# Dataset Information
# The goal of this dataset is to predict maximum water depth for flood modelling. 
# The dataset contains 559 hourly rainfall events time series which are used to predict the maximum water depth of a domain (Digital Elevation Model, DEM).
# The rainfall events and DEM are generated synthetically by researchers at Monash University because real DEM data with accurate rainfall events are rare. 
#
# Data Donor
# Jihane Elyahyioui, jihane.elyahyioui@monash.edu
@problemname FloodModeling2
@timestamps false
@missing false
@univariate true
@equallength true
@targetlabel true
@data
0.671341029,0.0,0.0,0.0,0.60718831,0.0,0.0,0.0069904884599999995,0.358388385,0.0,0.874302398,0.0,0.0,0.0,1.26978168,1.80474194,1.48864885,2.04104988,3.71496572,2.2856953,2.97224297,3.89309738,2.33071939,2.22749956,1.76592046,0.875312512,0.0,0.674345582,0.0,0.0,0.0,0.55831251,0.09614953550000001,0.0986125909,0.933688436,1.04095187,0.0,0.17587200100000003,0.0,0.504216304,0.0,0.0,0.295562189,0.18468229600000002,0.0,1.00236755,0.21857806800000001,0.0,0.5786338520000001,1.16519664,0.0,0.0,0.139741102,0.164077208,1.04915998,0.0,0.0,0.465402327,0.0,1.60338998,0.0,0.0,0.0,0.0,0.0,0.235987313,1.1182264,0.718067986,0.0,0.0,0.0,0.12173866900000001,0.0,0.0,0.0,1.16354714,0.0,0.0,0.07807408910000001,0.0,0.0,0.047602865700000004,0.0,0.0847562396,0.281838365,0.5182275789999999,0.0,0.0,0.357497789,0.615244432,0.012135188100000001,0.128900096,0.055314129100000005,0.0991402485,0.398558167,0.0,0.862756051,0.0,0.0,0.379542174,0.0,1.13488669,0.35610930799999996,0.0,0.0241927902,1.27822936,0.393341781,0.0,0.0,0.0,0.980527727,0.967602882,0.542515503,0.258555662,0.0,0.59414214,1.24511593,0.288820853,1.47711628,1.64055673,2.04251228,2.74170871,2.10562417,0.6952639690000001,1.63140021,0.0182627172,0.41446830799999995,0.8680266999999999,0.6678197889999999,0.0,0.0,0.590611288,0.74760965,0.0,0.0,0.0,0.0,0.958586635,0.0,0.28269960899999996,0.0,0.24075845,0.0,0.0,0.7967078670000001,0.0,1.10024241,0.641059521,0.0420440733,1.74268959,1.05258373,0.0,0.0,0.326234527,0.49186771,0.916714538,0.0426327598,0.0232394636,0.972951785,0.0,0.24746511899999998,0.0,0.0,0.0,0.7842028059999999,1.17423686,1.40206111,0.0,0.776250744,0.0,0.178146325,0.537765797,0.169479729,0.0,0.0,0.0,0.350948913,0.0,0.0,1.09990349,0.0904888287,0.0868820332,0.6805116659999999,0.0,1.41120807,0.502865474,0.9366365170000001,1.3274143,1.77483681,2.67071937,2.59300833,3.11335194,2.35611328,1.04959148,2.13559268,0.30023545,1.36749892,0.0,0.0,0.0,0.21993052100000002,0.597080134,0.772121772,0.0,0.349579955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.38924597200000005,0.0,0.0,1.58544804,0.832027961,0.0,0.118184535,0.0,0.0,0.0706955465,0.277536363,0.654465473,0.0,0.382839779,0.348047074,0.0,0.0,0.0,0.0,0.5291621320000001,0.0,0.0,0.0,0.0567583075,0.685302658,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
10.3589367,8.84056407,6.66955557,4.21508393,1.87404616,0.0,0.0,0.0,0.0,0.0,0.33247694,1.20392394,1.77508272,1.92492787,1.65146278,1.05936624,0.323476432,0.0,0.0,0.0,0.0,0.0,0.0716505439,0.5400936470000001,0.842470013,0.9064026740000001,0.729017063,0.37290253100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.123597829,0.42145242200000005,0.585536892,0.576804769,0.40606463200000004,0.128656377,0.0,0.0,0.0,0.0,0.0,0.0,0.21052148399999998,0.405408589,0.478869919,0.414035914,0.23354277899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0593289623,0.26505302399999997,0.39065582,0.402097716,0.29846402,0.111549525,0.0,0.0,0.0,0.0,0.0,0.0,0.143335271,0.303164765,0.374061845,0.33683284799999996,0.203384593,0.0129739527,0.0,0.0,0.0,0.0,0.0,0.0316358425,0.21259048,0.331403176,0.354263483,0.275027065,0.116852459,0.0,0.0,0.0,0.0,0.0,0.0,0.116576518,0.27419149800000003,0.352946824,0.329945861,0.211510298,0.0314533651,0.0,0.0,0.0,0.0,0.0,0.0128443132,0.201204522,0.332974822,0.36949918299999995,0.29923846,0.14136943400000002,0.0,0.0,0.0,0.0,0.0,0.0,0.10938201,0.292401344,0.393567225,0.38200724399999997,0.258934157,0.0579016715,0.0,0.0,0.0,0.0,0.0,0.0,0.226129274,0.400371994,0.462439504,0.39094541899999996,0.20271085100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.122294531,0.385075281,0.545597362,0.55232552,0.396345529,0.115847201,0.0,0.0,0.0,0.0,0.0,0.0,0.334521455,0.644418849,0.783248167,0.697943524,0.39732263799999995,0.0,0.0,0.0,0.0,0.0,0.0,0.201718657,0.80513536,1.23564356,1.34228381,1.04908439,0.386136748,0.0,0.0,0.0,0.0,0.0,0.0338142629,2.10037754,4.55423316,7.03355253,9.14235736,10.5290639,10.9581455,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.24
0.40516624799999995,2.02091077,0.12941389,0.0,0.0904124815,0.0,0.0892025316,0.0,0.23063275100000002,0.279401827,0.42675887,0.0,1.13450756,2.68301278,2.37141419,0.49302628,0.0,0.0191017679,0.010179411,0.0,0.056575504699999994,0.0,0.269188724,0.505676629,0.0,0.0545752089,0.00212584623,0.230010595,0.0,0.33990954,1.37040585,1.73624061,0.0,0.0538541212,0.0,0.0,0.0448738666,0.0,0.33888651,0.9344954990000001,6.43664095,1.63173246,0.0,0.418276845,0.0,0.337404494,0.0,0.360766271,0.0,2.35171849,3.16961569,1.24163458,0.0,0.7078097609999999,0.706047268,0.045155489800000004,0.0,0.040952923599999996,0.0,0.0574033799,0.0,0.0636566232,0.0,0.065408113,0.0,0.0633626037,0.0,0.28497732800000003,0.350236017,0.43710677,4.81554159,2.86015421,0.034429328700000005,0.0183860143,0.0,0.167019425,0.554634903,0.20515250000000002,0.0,0.128867009,0.0,0.144653324,0.0,0.249624441,0.611634357,3.70286966,2.69635543,0.8438990409999999,1.07261259,0.0,0.215811146,0.0,0.15388901800000002,0.0,0.127196245,0.0,0.11996939999999999,0.0,0.173849865,0.560405363,0.45823063,1.06340064,2.1015634,1.7599591,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.57170581,0.494502225,0.133301328,0.89225542,0.0,0.0280563581,0.258618212,0.0,0.220480762,0.18359628600000003,0.0,0.0,0.0,0.45500738700000004,0.400319593,0.7899076009999999,0.77675212,0.326396371,0.0229102832,0.0,0.0,0.513459001,0.0,0.0,0.0,0.0,0.266051596,0.0,0.40278515600000003,0.315063211,0.255162877,0.0,0.211545504,0.0,0.184859193,0.0,0.0206259349,0.268307564,0.350078166,0.168360769,0.0,0.574735352,0.0,0.628479737,0.57902484,0.0,0.393034063,0.493735721,0.613913876,0.403970402,0.834935573,0.457640682,0.35962573200000003,0.029452367599999998,0.410688664,0.0,0.128027939,0.0,0.0,0.0,0.192278946,0.0,0.0,0.554224107,0.44653986700000003,0.0,0.397514531,0.0,0.361782823,0.666794111,0.0,0.868117135,0.231220733,0.0,0.0729622909,0.47742375299999995,0.568481631,0.626101725,2.17860631,1.33765268,1.98927428,1.28966395,1.90130446,1.28462933,2.6330452,1.96591641,1.14872772,1.96889544,1.35117351,1.23224219,0.460175925,0.286506419,0.0055444686,0.0,0.0,0.0,0.639416839,0.0,0.966514057,0.174413515,0.253816997,0.0,0.0,1.50945703,3.64545119,5.72710832,7.16303872,7.33925343,5.84726241,2.67322263,1.4230325000000001,0.0,0.0,0.330597103,1.12057956,0.592258504,0.0826502234,0.0913712326,0.0,0.0,0.145354424,0.474979342,0.137401683,0.368583476,0.627433205,1.03728223,1.16840009,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
14.94688449,1.76838412,6.95473885,0.0,2.92303001,2.8863703999999997,8.87823223,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
14.671122899999999,0.0,0.872578373,0.0,0.0,1.52444414,0.34390391200000003,0.898712561,0.5075592999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.46961223,0.0360859314,1.0186723,0.522845398,0.0,1.06215314,0.0,0.0,1.36214835,0.0,0.0,0.0593144002,0.0,0.0,0.0,1.47229815,0.00297386618,0.555721366,1.07650326,0.311766017,0.28231405800000003,0.0,1.00350912,0.0,1.4411739,0.0,0.19089215399999998,1.24044673,0.0,0.0,0.0,0.0,0.748766321,0.0,0.0,0.0,0.708539859,1.45343474,0.9102203529999999,1.37365162,0.0,1.0357766,0.0,0.280423256,0.0,1.32576467,0.36286886399999996,0.0,0.0,1.51881934,0.44632525700000003,0.92669172,0.0972920748,0.0,0.0560852605,1.09239832,0.34770511600000004,0.0,0.0,0.463087904,1.06389848,0.0,0.709845099,1.415677,0.0239519258,0.322676337,0.0,0.0382287968,1.59708622,1.25473609,0.0,0.67657823,0.0,0.0,0.0,0.0,0.0,1.59762848,0.954356957,0.0,0.0,0.231636027,0.0,0.0425305241,1.14598844,0.5319280160000001,0.118720054,0.8966508790000001,0.570152902,0.0,0.0,0.939380995,0.0,0.0,0.315445043,0.244970728,0.0,0.0,1.13035831,0.895185825,1.1679104999999999,0.0,0.0,1.0218305,0.0,0.0,1.02241107,1.47006855,0.072383803,0.0,0.96549086,0.0,0.0,1.14769153,1.36385186,0.8611570470000001,0.40054009399999996,1.50474716,0.0,1.10921787,0.0,1.53780715,0.53212396,0.0,0.0,0.0,0.0745627343,0.354641562,0.16344719300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.15859599,0.0,0.0,0.0,0.11231264,0.0,0.0,0.0,0.51594452,0.51854728,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45116451,0.53806668,0.0,0.0,0.0,0.30417375,0.46095675,0.5919678,0.19415369,0.0,0.0,0.21694770000000002,0.48463448,0.0,0.0,0.41903308,0.19307945,0.03638196,0.0,0.15682719,0.32133969,0.0,0.6628708000000001,0.29636334,0.23325869999999999,0.11028517,0.02552097,0.56619062,0.0,0.0,0.12225193,0.0,0.0,0.65816061,0.55804006,0.33755151,0.63993407,0.89067709,1.31896383,2.82013285,5.17792192,5.42622292,4.61927385,3.12629068,1.13166481,0.0,0.0,0.35901082,0.12874026,0.79037842,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.346714897,0.0,0.348724021,0.151528734,0.0,1.09178599,1.49716525,0.389041315,0.0,0.972086225,0.0,0.31309756699999997,0.27379669100000004,0.0,0.0,0.30393427300000003,0.1611785,0.0,0.5375830220000001,0.37616289700000005,1.4217658000000002,0.0,0.00184944648,0.0,0.14633401599999998,0.0,0.0,0.0,0.0,0.41982715600000003,2.33307259,0.0,0.0,0.32420303,8.62835699,12.5398301,10.051291,3.50264111,0.0,0.0,0.22145883,2.36751105,0.135155093,0.0,2.22116927,1.80159531,1.05873355,0.0,0.0,0.0,1.3654256,0.0168257133,0.0,0.0,1.21692644,0.433490655,0.08219660200000001,0.0,0.0,1.22925967,0.0,0.0,0.0,0.0,1.3839603,0.0,0.596864649,0.0,0.0,2.00739273,1.78980467,0.529656395,0.47757786799999996,1.64867165,0.0590240444,0.0,0.0,0.0,3.17580894,3.82839908,4.68690844,1.65236394,1.14449264,0.0,0.0,1.4381388000000002,1.41755218,0.297456535,0.0,0.204262036,0.7698188029999999,0.37117137299999997,1.02224856,0.0,1.02227524,0.0,0.0,0.13423927,0.988362517,0.553814021,1.20536759,0.0488446776,0.0,0.423576999,0.0,1.03698723,0.199619285,0.0,0.0767989514,1.37708438,0.8210349790000001,0.8376287609999999,0.603854436,1.18577736,0.0,0.0,0.149632299,0.0,0.0,0.365731436,0.0,0.7499560759999999,2.73270067,1.32567743,1.39552676,0.0,0.875584609,0.40154150200000005,0.0,0.339229438,0.0,0.568955762,0.0583723337,0.259956727,0.0,0.0,0.8618147429999999,0.189906094,0.0,0.0,0.0,0.0,1.18862102,0.458811378,0.422114571,0.0,0.727513455,1.02789787,0.0,1.089445,0.0,0.0,1.06387559,0.0,0.0,0.961296319,0.873843611,1.03030461,0.304480886,0.8755330729999999,0.0,1.21814627,0.678647353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23600000000000002
0.0115493581,0.0,0.25861247,0.0,0.8551783609999999,0.0,0.519422332,0.0592758255,0.0,0.0,0.0,0.460083546,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12391147699999999,0.31175526600000003,0.0,0.292024346,0.215439223,0.0,0.0,0.502942095,0.0,0.0877396266,0.0,1.18517975,0.166866268,0.00442161734,0.17786968600000003,0.0,0.371814937,0.851790176,0.37166119,0.10834549,1.41414072,0.615874515,0.0,0.0,0.0,0.207185124,0.0,0.0,0.233435065,0.805472472,0.0,0.7556248459999999,0.25740753899999996,0.945558899,1.14964943,0.0,0.0,0.055390531900000005,1.51266442,0.268583849,0.202098406,0.0,0.0,0.0,0.647185844,0.103416849,0.0,0.7303746459999999,0.5672473889999999,0.8302976870000001,0.0,0.06945623299999999,0.0,0.13464888,0.0714437166,0.120952869,0.0,0.0,0.250842625,0.0,0.10138473,0.152950425,0.06842954309999999,0.0,0.0,0.0,0.0,0.432671573,0.594234464,0.0,0.08479624039999999,0.0,0.374509107,0.0,0.0,0.0,0.0,0.0,0.0,0.0851753208,0.21669823100000002,0.0,0.0,0.491569895,0.36070357,0.25178695100000004,0.0,0.0,0.0324228706,0.0,0.903990179,2.29276445,1.13215886,1.42798167,2.4868106,2.28177702,1.78215379,3.6338364999999997,1.76072675,1.80083174,2.26634471,1.85083998,0.78770693,0.0,0.0,0.6845496090000001,0.0,0.0,0.0612757212,0.0,0.0,0.508910996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.88748686,10.0203153,0.0,0.0,1.05615655,0.0,0.821063093,1.09442661,0.0,1.31383664,0.0,1.20020952,0.41512657399999997,0.026749952999999996,1.15282103,0.7936737890000001,0.197561598,0.875157764,0.0,0.0,1.00532583,0.8391883609999999,0.536503219,0.0,1.70794773,0.0824022903,0.0,0.0,0.126407827,0.962317077,0.10234023099999999,0.0180537369,0.818017815,0.0,0.813213876,0.896490455,0.0,1.00347902,0.47834204799999996,0.0,0.0,0.0,0.5032277789999999,2.41419277,0.0,0.0,0.683514837,0.50976227,0.736999631,0.66964046,0.622702505,0.512044333,4.52430422,5.9941758,0.364636177,1.23032533,2.88785654,0.0,0.314558976,3.31657622,1.3085346000000002,0.364273389,0.0,0.295129278,0.0,0.9008616509999999,1.06773137,0.042332010999999996,0.0,0.0,0.0,0.0,0.17845578899999998,0.0,0.0,0.505788689,0.0,0.0,0.135714236,0.60473054,0.00693162343,0.6337343000000001,0.0,0.268271181,0.799314408,0.600515472,0.7654440640000001,0.0,0.637487545,0.0,0.0,0.381587804,0.0,1.19962065,2.42169959,2.87968603,2.26753107,0.519863314,2.59762395,0.46370377799999996,0.0,0.263754424,0.537362759,0.0,1.39196323,0.0,0.323986252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.831871818,1.71628214,2.68595334,3.68582597,4.655879799999999,5.53557618,6.26844091,6.8064038,7.11352739,7.16880804,6.96781046,6.52299735,5.86272807,5.02901513,4.07423371,3.05706777,2.03803911,1.07499682,0.218941904,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0252360033,0.350006059,0.60442974,0.7711336529999999,0.84279617,0.821904486,0.719639235,0.554044535,0.347699795,0.12514462199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.101310001,0.20921483899999999,0.285232304,0.324393063,0.32610544399999997,0.29384565100000004,0.234429212,0.156972967,0.071684153,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0167048496,0.0421570151,0.0557832639,0.0578614788,0.0504438742,0.0369067162,0.021331349700000002,0.00780726233,0.0,0.0,0.007255898890000001,0.022291936800000002,0.0417939717,0.061893024000000005,0.0781229121,0.08612289949999999,0.0823618624,0.06478246019999999,0.033271184,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0546288833,0.152864203,0.24479515699999999,0.318875218,0.364483209,0.373274919,0.340383403,0.26531713,0.152429908,0.0108769186,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.142876266,0.42413842799999996,0.703045615,0.952191508,1.14491644,1.25809524,1.27478078,1.18643189,0.9944807370000001,0.711046697,0.35867681100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0788859052,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.904164035,0.916358184,0.170402733,0.0,0.0,0.0,0.600152305,0.0,0.488147809,0.0,0.262941782,0.177468065,0.601251859,0.643412639,0.0,0.0,0.315818368,0.0,1.02166415,0.999239859,0.0,0.0,0.0,0.0,0.7002425959999999,0.404510625,0.5544767270000001,0.805831155,0.7110280590000001,0.144773151,0.667279149,0.0353769873,0.703806464,0.798267952,0.0,0.0,0.37912550799999994,0.902988219,0.737198441,0.417356891,0.0,1.20489644,0.00308448037,0.0,0.34618559,0.496873546,0.380070316,0.31329344800000003,0.0,0.31291772,0.0,0.0,0.0,0.701961385,0.494670692,0.0,0.809275535,0.485220828,0.0,0.0,0.0,0.0,0.0,0.475880043,0.0,0.0,0.649877128,0.362884004,0.67331606,0.23746441100000001,0.0,0.0,0.0,0.29656566100000004,0.0,0.38060913,0.0,0.0,0.7796496,0.126108707,0.544843623,0.0,0.36674618,0.0,0.0,0.0717847957,1.21495556,0.256820678,0.121265329,0.0,0.0,0.0,0.0,0.0,0.764994353,2.19494399,2.03146133,1.8987777,0.0,0.0,0.0,0.0778440175,1.7929275000000002,3.83005995,6.59266657,8.39227819,9.90487709,7.76405396,4.5798879,1.00530109,0.0,0.0,0.0,0.0,0.5769859279999999,1.68876929,1.21003003,0.511015715,0.437214786,0.0,0.0723217057,0.0,0.0,1.03176975,0.0,0.241173164,0.0,0.0,0.592491491,0.529678645,1.08011477,0.7657777929999999,1.22880805,0.0,0.0,0.110301069,0.0,0.0,0.0,0.158604015,1.2549808999999998,0.548313829,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23199999999999998
0.48183696,0.0,0.68801668,0.65750398,0.043963,0.0,0.54894608,0.0,0.74894734,1.07010987,0.0,0.0,0.14962093,0.20999151,0.0,0.0,0.0,0.0,0.0,0.46703902,0.0,0.45232509,0.0,0.74217181,0.55824083,0.09714819,0.0,0.63983309,0.11259263,0.93211707,0.0,0.0,0.89656344,0.0,1.02110553,0.0,0.90081089,0.40397423,2.0419702,1.18921656,1.99076368,2.3981988,3.44355156,0.47401364,0.92947182,0.25004391,0.0,0.0,1.07386343,2.11249894,0.51880871,0.11969980000000001,0.0,0.62708523,1.34235004,0.0,0.0,0.0,0.0,0.07911041,0.0,0.0,0.0,0.0,0.0,0.0,1.09771759,2.2138521,2.71287783,4.25253977,3.96333909,1.76000614,0.55646554,0.0,0.0,0.0,0.07685511,0.0,0.37824132,0.0,0.0,0.46006236,0.49146478,0.59329065,0.14087879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.629729168,0.434660045,0.00148511697,1.50010009,0.08505870199999999,0.0,0.0,0.0,0.8025334540000001,0.0,0.0,1.88957968,0.960874089,0.055971178499999996,0.9936131309999999,0.0,0.5822273570000001,0.0,0.0,0.0,1.54303395,0.0,2.24019336,2.11435327,2.67941539,5.04456116,4.60139088,5.04917343,4.24246067,4.35797858,2.60576124,1.45777837,1.02465099,1.42772192,0.0,0.0,0.0,0.0,0.645138358,0.917032732,0.0,0.0,0.47456442299999996,0.0,0.0,0.62474636,0.136898761,0.901499527,0.302089872,0.0,0.0,1.23179599,0.0,0.0,0.0,0.0,0.685193954,1.13437469,0.0,0.0,0.268942382,0.0,0.35651540600000003,0.7337289909999999,0.521229721,0.0,0.395443025,0.0,0.550500707,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.24041745399999997,0.15933404199999998,0.0421844385,0.736353108,0.565838826,0.570921832,0.349404221,0.5653991070000001,0.27637929699999997,0.634576841,0.19208974,0.06685110650000001,0.508355942,0.0,0.0,0.0,0.0,0.10655522699999999,0.76740791,0.45425599299999997,1.07004298,1.61535457,1.523252,1.59571531,1.08410004,1.01098525,0.573797609,0.204693426,0.0,0.35240472799999994,0.672205243,0.152759946,0.7585420709999999,0.11938374300000001,0.23140428600000001,0.0,0.0,0.0,0.0,0.128274231,0.948352552,1.96739197,2.79007157,3.56773868,3.70984347,2.80239433,2.21340787,1.44853297,0.795420976,0.0,0.0,0.0,0.0,0.17732293899999998,0.892721222,0.638967202,0.861843857,0.668041303,0.820085005,0.40530069700000004,1.07432858,0.82200257,1.63910372,1.67928386,1.56961524,0.997040195,0.9615039609999999,0.12386813099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.391509885,0.172220612,0.0,0.0537642179,0.0,0.0,0.0139722492,0.140510956,0.14817471599999998,0.0,0.0,0.0,0.0,0.0,0.268356624,1.07698349,2.01743455,2.58351539,3.63398867,3.20025265,3.03326259,2.49531609,1.56341682,1.24204823,0.118101272,0.0,0.0,0.338231825,0.219484161,0.48626729999999996,0.598804837,0.57372855,0.0,0.0,0.0,0.0,0.0,0.0,0.345686785,0.0,0.0,0.31737072,0.0,0.287463537,0.15695048,0.166219432,0.0,0.0,0.0,0.0,0.0,0.0,0.145437636,0.280672992,0.488606104,1.3362782,1.14202943,1.79624527,1.88840405,1.23533124,0.7408171709999999,0.7288645229999999,0.39797059100000004,0.0,0.0,0.0,0.36171670100000003,0.389258781,0.0,0.586473123,0.571250809,0.277624529,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.07807928,1.71110639,0.0,0.0,1.95789073,2.43907414,0.7902420609999999,0.0,0.0,0.436249558,0.644666607,0.0,0.0,0.0,0.35891756799999996,0.324449805,0.0,0.0,0.0,0.253309949,0.137697563,0.0,0.0,0.0327423222,0.13854776900000002,0.0346030089,0.0,0.0,0.024013211200000002,0.027223721,0.0,0.0138176922,0.0172418711,0.0,0.0,0.0301977979,0.12343118,0.0295913369,0.0,0.0,0.12746438300000001,0.235528314,0.0,0.0,0.0,0.30437727800000003,0.33698850700000005,0.0,0.0,0.0,0.608776079,0.416050627,0.0,0.0,0.218497699,1.27567558,0.461441185,0.0,0.0,1.89838611,7.42730237,9.92108838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.71469994,1.22497938,0.0,0.67047264,0.0,0.13422223,0.48038897,1.02862287,1.01530317,1.11633649,0.11759685,0.0,0.0,0.91891315,0.0,1.10014817,0.40689749999999997,0.29040891,0.57130539,0.0,0.0,0.40275473,0.5947951,0.0,0.0,0.17759823,0.25455003,0.0,0.5992814999999999,0.0,0.08217462,0.67052694,0.0,0.0,0.0,0.0,0.0,0.11874439,0.0,0.54832329,0.69970221,0.59294335,0.21057665,0.0,0.60528257,0.0,0.21482059,0.0,0.16755050000000002,0.25707359,0.45940495,0.20517184,0.36314894,1.060024,0.43427392,0.20049294,0.34218137,0.0,0.0,0.35349607,0.51411109,0.12908005,0.0,0.0,0.0,0.0,0.34634240000000005,0.98650539,0.0,0.0,0.0,0.59117367,1.99118397,3.54109251,1.47194891,0.0,0.36274565,0.0,0.29397126,1.22763976,0.0,0.0,1.44210402,0.0,1.53622113,6.86116353,5.33710219,0.0,0.18241793,0.48327879999999995,0.0,0.3606426,0.0,0.0,0.45493533,0.18093799,0.42865576,0.0,0.35304245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.00617622,5.05779311,3.96400213,1.63441782,0.0,0.0,0.0,0.0,0.184531618,0.0,0.0,0.0,0.820429959,0.778555902,0.8978564109999999,0.5427678779999999,0.35252412899999996,0.7010888129999999,1.70150042,1.39048742,0.620648525,1.64843974,0.160349605,0.011941864299999999,0.0772512135,0.0,0.0,0.0,0.0,0.38797195799999995,0.40173185299999997,0.0,0.0,0.436605203,0.0,0.138458305,0.18889081300000002,0.0,0.87453057,0.873703514,0.0,0.0,0.0,0.588557412,0.0,0.0,0.0,0.0,1.52661414,0.288658372,0.0,0.0,0.0,0.7948105240000001,0.0412886387,0.76204507,0.388430634,0.0,0.39814442899999997,0.353639263,0.0,0.243770583,0.628141019,0.0,0.0,0.413738799,0.0,0.0,0.0,0.0,0.341666856,0.0,0.390019444,0.0,0.307362782,0.597253502,0.0,0.171973132,0.0,0.07088272,1.71580837,0.209405502,1.25028742,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.1083466,2.30864298,3.37263806,1.8296679,2.65624658,1.82668583,2.01812882,0.902759515,0.65401724,1.40325582,0.471017165,0.7638313590000001,0.0,0.0,0.827445069,0.312114275,0.1401672,0.028187074399999998,0.0,0.0,0.09210345310000001,0.0,0.0,0.788592271,0.32204600699999997,0.0,0.0,0.198300255,0.10696917,0.0,0.660906317,0.136995917,0.00659823079,0.7901869979999999,0.0,0.679823425,0.0,0.750930271,0.573180652,1.6631926,0.32694095300000003,0.778213067,0.8913856920000001,0.0,0.267485898,0.127394123,0.6688393979999999,0.0,0.0,0.0,0.410896599,0.0,0.030893286699999998,0.259220827,0.0,0.07972250339999999,0.0,0.0,0.29460271,0.704677955,0.119454874,0.674865026,0.0,0.159640339,0.0,0.0,0.0706252595,0.0,0.420000599,0.0,0.0,0.316668801,0.0,0.32418268100000003,0.0,0.0,0.0,0.0,0.36838240299999997,0.507421794,0.762223623,0.183894041,0.47872337600000003,0.0,0.0,0.723644306,0.17592668600000003,0.0,0.0,0.0,0.0,0.0799741332,0.0,0.0,0.0,0.0,0.0,0.0,0.490059304,0.15146663,0.7350832190000001,0.297490618,0.133086218,0.16232434099999998,0.8687461329999999,0.0,0.8104910609999999,0.0,0.0,0.316515261,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.627113437,1.15003321,1.35708671,0.7460431959999999,1.26289755,2.13490441,2.19625529,2.740741,2.40630653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
21.58816504,0.0,5.82822582,0.0,1.81398353,0.0,1.35036869,0.0,2.87797242,3.73833578,0.0,2.75145429,0.0,10.76023286,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.34898775,1.70133992,0.698754645,0.620393635,0.536407643,0.0,0.0,0.0,0.46896170600000003,0.447635881,1.07265015,1.20805901,0.10094318599999999,0.0,0.0,0.0647794191,0.0,0.30540066,0.835625788,0.17932181600000002,0.805660825,0.570371799,0.0,0.296495362,0.0,0.0399948537,1.76557713,0.721471802,0.0,0.21352412,0.0,0.0417108616,0.04942579230000001,0.0,0.125324705,0.0,0.0770739949,0.0,0.0,0.0,1.17200108,2.01817001,0.0,1.13394778,2.92252256,0.607065759,2.66173805,2.21046263,0.0,0.60626977,0.487836301,0.189193538,0.13617144,0.0,0.0381120641,0.0,0.0,0.0,0.0562120407,0.0,0.143282247,0.0,0.08228339280000001,0.122575389,0.00977271749,0.780800553,0.0,3.35813662,6.9980497,0.444046283,0.0,0.658113331,0.0,1.01317856,0.0,0.100682392,0.18006658899999997,0.0,0.38659247399999996,0.0,0.24013183,0.0,0.0,0.236939898,0.0,0.343582099,0.0,0.14003076,0.057966902300000005,0.0,1.10034114,0.852289648,2.01980527,2.32708797,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.51250507,1.00985544,0.700075778,0.745245838,0.539151256,0.7478162079999999,1.11516548,0.668099429,0.0322322237,0.0506865066,0.213162155,0.0,0.0,0.0,0.0,0.234793538,0.0,0.522632095,0.12506868699999998,0.12350841800000001,0.022643526,0.0,0.0,0.0,0.0,0.105928632,0.36226411299999994,0.337188805,0.47799102600000004,0.00330510073,0.358612314,0.13287865699999998,0.0162381595,0.0,0.0781950919,0.0,0.339334102,0.0,0.0,0.0,0.0,0.0,0.0603828466,0.0,0.0,0.0767622796,0.0,0.0215841058,0.312313781,0.0,0.0,0.0,0.0,0.22810291,0.0,0.17022019800000002,0.0,0.0,0.527009184,0.32146695,0.26397281899999997,0.0715439475,0.0,0.0,0.168017043,0.134589291,0.091525915,0.0,0.0261986619,0.16762247,0.011946775500000001,0.0,0.54800296,0.36463809799999997,0.556986765,0.354450545,0.237293493,0.0,0.0102237716,0.140100835,0.121179465,0.52385824,0.0,0.0,0.0,0.0,0.0248037127,0.0,0.0,0.245135949,0.0,0.0,0.514252944,0.0,0.302121625,0.10384643699999999,0.24913014,0.0,0.07592235559999999,0.0,0.0,0.0843753335,0.212827548,0.0,0.0,0.32353615199999997,0.0,0.0,0.086411251,0.0,0.0,0.0,0.301928576,0.15204699800000002,0.128863115,0.0,0.0,0.0,0.0,0.198058963,0.159962243,0.184847082,0.333133633,0.392288883,0.44170635700000005,0.18022201399999999,0.0,0.0,0.0,0.20155589,0.113989021,0.413473827,0.37941052200000003,0.108090365,0.347327405,0.369531069,0.286040747,0.0,0.0,0.0,0.0770007262,0.363132114,0.22182884600000002,0.0941501094,0.38766496200000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.103635744,0.13862977099999998,0.5084850999999999,0.435179931,0.0,0.0,0.0,0.0,0.0,0.0,0.376552272,0.6837815840000001,0.8607072090000001,0.399380535,0.0726063564,0.41500043,0.0,0.0,0.0,0.0,0.0,0.343336555,1.61639867,2.48168172,3.83359875,4.1441239,4.20669014,4.10320141,2.94887476,2.23467825,0.911802188,0.0,0.0,0.0,0.0,0.0,0.0,0.420940799,0.65493152,0.401796806,0.43995193299999996,0.0,0.0,0.039111488300000004,0.0,0.0,0.0568672585,0.0,0.0,0.328856225,0.268754285,0.363880489,0.16179302199999998,0.270019246,0.0,0.0,0.0,0.0,0.0,0.0,0.255458849,0.0,0.249833613,0.0,0.0383671097,0.357466751,0.37099801299999996,0.137643517,0.0,0.0,0.0,0.0,0.0,0.652410709,0.6233173089999999,1.3091244,2.22067781,2.70004573,3.10011244,2.85050242,3.0806141,2.35567735,1.60199544,1.30306369,1.48387853,0.88852173,1.41278991,1.46327773,1.75682859,1.68077485,2.20614474,2.41076467,1.90911177,2.18822205,1.7385751,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0913051526,0.0135961003,0.0,0.0,0.0,0.0949957835,0.37349898600000003,0.7587175890000001,1.21461087,1.69079391,2.12989765,2.47408772,2.67088119,2.67961678,2.47965552,2.07955073,1.5239725,0.8936507770000001,0.294366339,0.0,0.0,0.0,0.0,0.135640086,0.41873826700000005,0.5435195079999999,0.443493883,0.139858091,0.0,0.0,0.0,0.0,0.22258998800000002,1.08232559,1.9789404,2.68115954,3.0012412,2.85459698,2.28608919,1.45399264,0.5776248070000001,0.0,0.0,0.0,0.0,0.0,0.18935185,0.34228603799999996,0.323453777,0.17074056199999998,0.0,0.0,0.0,0.0,0.0,0.0854697784,0.174780402,0.180879916,0.11121254300000001,0.00468703041,0.0,0.0,0.0,0.0,0.0441733382,0.0980830816,0.103749378,0.06293882049999999,0.0,0.0,0.0,0.0,0.0,0.025796479100000002,0.0623287118,0.0678444732,0.042839796500000006,0.0013441972400000002,0.0,0.0,0.0,0.0,0.014007568,0.0370141987,0.041034278199999996,0.026561590099999997,0.0023361405800000003,0.0,0.0,0.0,0.0,0.005965034,0.0168954223,0.018200998899999998,0.011347473899999998,0.0014419385,0.0,0.0,0.0,0.0,0.000200338999,0.0,0.0,0.0,0.0,0.0063011640100000006,0.0141863468,0.016777641,0.0103780907,0.0,0.0,0.0,0.0,0.0,0.0198281257,0.0422412867,0.047136272400000005,0.0286250084,0.0,0.0,0.0,0.0,0.05730789730000001,0.17807344600000002,0.309809968,0.41671015100000003,0.467751951,0.44810696,0.364704235,0.24357443899999998,0.12000202800000001,0.0255293723,0.0,0.0,0.0,0.0237447198,0.038613995299999995,0.035993607000000004,0.0243205026,0.01899858,0.0327206158,0.06714761059999999,0.110168437,0.140375744,0.137042962,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.75295403,1.51284619,1.68360372,0.0,1.25991393,0.4872062,0.0,0.31349646,1.46596685,0.9373881,0.0,0.0,0.0,0.0,0.0,0.67563152,0.0,1.11880851,0.0,0.0,0.0,0.10727947,0.0,2.92418244,2.38961085,5.5397163,5.60850818,8.13346533,3.61069569,3.82607732,1.41939048,0.0,0.73387176,0.0,0.36054971,0.0,1.05736308,0.22838133,1.79940334,0.0,0.0,0.0,0.76105467,0.08327543,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.7344093,1.13484483,2.2753327999999997,2.23140645,3.24263074,0.42422551,1.35563292,0.0,0.0,0.75461795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.037099556400000004,0.37880249299999996,0.757093207,1.16672336,1.60154149,2.05461475,2.51837297,2.9847716,3.44546945,3.8920169000000002,4.31604969,4.70948333,5.06470314,5.374744799999999,5.63346085,5.83566856,5.97727531,6.05537817,6.06833494,6.01580479,5.89875736,5.71945012,5.48137456,5.18917256,4.84852534,4.46601771,4.04898143,3.60532165,3.14333115,2.67149708,2.19830544,1.73204814,1.28063777,0.851434623,0.45109038799999995,0.0854122068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.051344576399999994,0.196680918,0.32619359800000003,0.436900664,0.526565276,0.593719185,0.637663385,0.658446765,0.656824156,0.634195761,0.59253045,0.534275771,0.462257882,0.37957476799999995,0.289486218,0.19530402800000002,0.10028574800000001,0.00753510073,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0257751266,0.0738977434,0.116341888,0.152025042,0.180167419,0.20030326399999998,0.212280363,0.21624829399999998,0.212636262,0.20212176399999998,0.185591593,0.164096892,0.138804191,0.110944372,0.0817615891,0.0524640464,0.0241784688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00100091608,0.0004899793310000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0180439098,0.0409061555,0.0660527878,0.09263053630000001,0.11964442900000001,0.145992405,0.170506137,0.19199664600000002,0.20930305100000002,0.221342636,0.227160296,0.225975399,0.217224118,0.200595411,0.176058987,0.143883867,0.10464640800000001,0.0592270658,0.008795506750000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0378733929,0.131381597,0.22620572100000003,0.319231538,0.407228308,0.486949614,0.555239707,0.609142167,0.6460075470000001,0.663596552,0.660175347,0.634599702,0.5863849320000001,0.515758921,0.42369595200000004,0.31192958600000004,0.18294339399999998,0.039939014700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.49708844399999996,0.0,0.112379899,0.336441562,0.0,0.0,0.44455110200000003,0.0107083135,0.286065619,0.35747502700000006,0.458419275,0.0,0.14326692,0.23999157399999999,0.0,0.0,0.0,0.176046285,0.190201105,0.0,0.09585160000000001,0.00337342049,0.005967084029999999,0.242825288,0.41983205,0.032269631800000004,0.13822787,0.37077568200000005,0.31206904,0.120678922,0.16834111300000001,0.47398662,0.0,0.0,0.241925786,0.0,0.21973525300000002,0.0029090140899999998,0.142927775,0.0,0.0,0.0,0.0,0.0,0.125642632,0.356362488,0.0,0.25276761600000003,0.28988308,0.216292333,0.40218817700000004,0.0,0.155866933,0.0,0.193150181,0.0,0.0,0.0102060918,0.382202324,0.0,0.0,0.05439199980000001,0.34728298700000004,0.266452538,0.0424788342,0.0193018431,0.42686046,0.715967674,0.258402032,0.0520745134,0.0,0.0,0.0,0.19304096399999998,0.40391334,0.0,0.0,0.28847295300000003,0.28332559399999996,0.21215906199999998,0.00379777114,0.0,0.0,0.0,0.43173787799999996,0.0,0.4944007,0.520441658,0.160152484,0.460817705,0.054706547599999995,0.0,0.0,0.21321429600000003,0.306647465,0.0463499801,0.0387485359,0.0,0.09810400710000002,0.0,0.11961206199999999,0.0,0.0,0.059115995899999996,0.0,0.0,0.49409607299999997,0.0121511146,0.557705894,0.278732556,0.132543768,0.549496406,0.37896803799999995,0.29342674399999996,0.0,0.0307852005,0.0201693544,0.0,0.0,0.0,0.0,0.0,0.0,0.29297051399999996,0.161353564,0.931570577,0.79031108,1.34407329,2.22866531,2.34795866,3.14151575,2.87740972,3.51474941,3.42755627,4.27463428,3.68060459,3.86132235,3.87585667,3.88085766,3.48216736,2.66546157,2.16938909,1.95549207,1.02305926,1.3050167,0.528951149,0.345795367,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.390114891,0.311351728,0.465624449,0.665464834,0.6077528,0.8935885140000001,0.652759659,0.0680276281,0.695788008,0.21929575899999998,0.0,0.0,0.0,0.223442251,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.600375029,0.18524524899999997,0.359723791,0.619765941,0.597309159,1.12501165,0.58249482,0.7449242340000001,0.9366539759999999,0.695332043,1.13198909,0.560150751,0.284767205,0.696672172,0.833442833,0.82473306,0.456783612,0.513293563,0.353156641,1.00845083,0.643368556,0.871697466,0.655447911,1.21993848,0.981530183,1.07693519,1.02387457,1.3447577,0.8858857040000001,1.16180564,0.8640399990000001,1.06807188,1.11179415,0.701120278,0.98381054,0.874260307,0.359776595,0.868257133,0.362477273,0.7871180529999999,0.388369225,0.707330927,0.0034826046,0.583663785,0.509384488,0.417672356,0.507027105,0.0,0.0380860246,0.38472807,0.0,0.201601682,0.0553157346,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.324854478,0.0,0.0,0.27761453399999997,0.0,0.97116709,0.0,0.0,0.0,0.47859092,0.0,0.0,0.0,0.5448485710000001,0.0,1.21057047,0.320305475,0.0,1.1630963,0.0,0.0,2.34988492,0.0,0.603894575,0.577314088,1.30852259,0.0,0.0,2.59875772,0.286141119,0.0,0.0,3.83055793,1.49461606,0.0,0.0,0.0036194021100000003,0.145087512,0.0,0.433473118,0.0,0.0,0.0,0.0,0.0,0.506626401,0.644964408,2.00401844,0.421062069,0.0,0.0,0.0,0.0,0.0,0.0,0.47141976,0.0,0.0,0.0,0.905077402,0.0107784212,0.0,0.0,0.985223567,0.7645263370000001,0.0,0.724260253,0.0,1.19940723,0.0,0.0,0.737800705,0.0,0.0389977636,0.0,0.38520032600000004,0.0,2.05109843,0.9272167859999999,2.56798339,0.201722543,0.0,0.0,0.250988228,0.0,0.0,0.0,0.7007821609999999,0.0,0.0350653352,1.2693816,0.884475255,1.53776631,0.0,0.86644899,0.0,0.557270469,0.0,0.0,0.0,0.0,0.0,0.330533295,0.0,0.0691422094,0.0,0.0,0.0,0.466837465,0.0,0.0,0.449702165,0.0,0.0,0.476695828,1.00000529,0.0921819747,0.462800197,0.899645175,0.0,0.0,0.0,0.0574496372,0.0,2.72216123,2.4939105,3.71232155,5.56933776,6.70939279,7.04100963,5.50856103,5.46932175,2.52026765,0.0,0.059466625700000005,0.0,1.49565494,0.0,0.571783255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.33388092399999997,0.595382298,0.0,0.0,0.0,0.810717305,0.0,0.0,0.0,0.0,0.0,0.584651864,0.0,0.162430532,0.768898848,0.296568838,0.15737836300000002,0.927516455,0.0,0.0,0.149655863,0.0,0.0,0.565804071,0.0,1.34914455,0.23507594,0.0,0.281873514,0.184688055,0.0912370091,0.0,0.0,1.21641578,0.24847343300000002,2.67610082,2.15677499,1.82203361,0.557892624,0.26021973,0.8726736979999999,1.82782645,0.390683794,0.0376744274,0.59720159,0.561889909,0.7258667459999999,0.0,0.0,0.518522678,0.568034581,0.188291552,1.14440237,0.0,0.0,0.0,0.335436935,0.723222765,1.1979953,1.67462368,0.199608232,0.792542238,0.0,0.0,0.7249899129999999,0.0,0.0,0.0,0.103373515,0.854586775,0.0,0.0,0.0,0.9205615779999999,0.398317986,0.49065363,0.7954161129999999,0.317668716,0.239914655,0.662053251,2.40615013,3.85311568,2.41758457,2.5618517000000005,0.0,0.0,0.0,0.323931978,0.0614680619,0.410859591,0.0,0.0,0.0,0.9617836890000001,0.0,0.578609368,0.7981740909999999,0.0,0.8125715059999999,0.0,0.0,1.0371801,0.0950375624,0.0,0.755380361,1.2725156000000002,0.0,0.0,0.791997827,0.0,0.485194377,0.0,0.0,0.48683962299999994,2.05131301,5.91243508,9.85385997,11.552222800000001,11.0639489,7.30407826,3.39129209,0.27169152399999996,0.0,0.0,1.21080071,1.18129308,0.0,0.175425836,0.0,0.282963745,0.706455615,1.49783537,1.15477478,0.602930678,0.0,0.0820406524,0.9239501390000001,0.664412808,0.0,1.28897558,1.24769822,0.22584320000000002,0.0,0.0,0.0,0.41530908899999996,0.0,0.0,0.0,0.255774582,0.652359629,0.0,0.0,0.63593693,0.826637416,1.57092758,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.245
0.48816315,0.0,0.0,0.0,0.0,0.0,1.00980939,1.93175984,0.17527765,0.69145943,0.23108488,1.10382622,0.60585368,0.0,0.13405735,1.04248852,0.0,0.40481154,1.13907659,1.47018289,0.0,6.84952118,3.65848638,0.0,0.96906094,0.0,0.17455505,0.0,7.32885011,6.3332371,0.24683766,0.0,0.65652197,0.0,0.07211492,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.10140393,0.0,0.19295693,0.47656741,0.0,0.0,0.43182659999999995,0.63104484,0.18615189,0.0,0.07889925,0.0,0.0,0.07910492,0.34608762,0.32572215,0.07502719999999999,0.0,0.16590415,0.38247278,0.41913622,0.60252488,0.97501849,0.97280645,0.90627329,2.05592158,3.96898341,4.22170076,2.42157912,1.1172687,1.28727728,1.10602487,0.35530559,1.00639083,2.51488294,2.16983444,0.60001079,0.95498145,2.68785791,2.35501118,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
20.420839,7.25934357,0.0,0.224187295,1.60258433,1.09531015,3.24091385,0.0,0.9340072759999999,0.0,1.89152971,0.41993537799999997,0.0,0.170264003,1.78861421,1.4849253999999998,1.30437273,1.02403668,0.33973764700000003,1.67125345,0.0,8.89497753,1.4748436000000003,3.20513477,0.0,4.88004787,6.99265887,1.78875594,0.0,0.610651484,0.8345911909999999,0.131046167,3.1086603,3.874535,0.0204685966,0.0,0.0,1.69550528,0.0,0.0,0.0,1.55914875,1.41311859,1.78464119,0.0,1.5028153999999998,0.0,3.88353712,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0885145806,0.341711983,0.29045392600000003,0.21525142100000003,0.35721069899999996,0.455268282,0.739755122,0.546537507,0.434740323,0.819041735,0.756272178,0.121499491,0.0,0.0,0.25099320399999997,0.165571294,0.0369488147,0.0,0.160407904,0.0,0.0,0.39417964299999997,0.0,0.0,0.355250268,0.0,0.0,0.0,0.127469215,0.363426398,0.440013992,0.279340423,0.37944735,0.0,0.06118970519999999,0.318545148,0.066110058,0.442699054,0.0,0.423853417,0.0,0.19725588800000002,0.0,0.0,0.111187179,0.668430409,0.496474666,0.232332011,0.905589214,1.05389177,1.52040228,3.149944,4.29430525,3.99675798,3.93011087,2.96513974,2.31810319,0.945274064,1.14691985,0.581031566,0.501148426,1.08879745,0.87538802,1.26111175,1.13116621,0.37674780700000005,0.426793814,1.23412941,1.32428499,1.71577412,2.17860675,2.21504109,1.67469177,1.37040307,1.5555212999999999,1.66504004,0.682790916,0.8624158279999999,0.37168017700000006,0.20509403,0.13247114699999998,0.47607901,0.248932817,0.21533350199999998,0.82115028,0.48206634,0.547448216,0.644345759,0.9090606659999999,0.693139595,0.278234276,0.462061735,0.786448365,1.0006508,0.653652484,0.158582615,0.486685188,0.567787746,0.0,0.26536820899999997,0.0,0.32585585300000003,0.253498939,0.498199026,0.23656811,0.0,0.256141537,0.0,0.37887303,0.9078344340000001,1.43949098,1.67967773,1.56930577,1.81491962,1.68951773,1.15864823,0.338808839,0.16988810699999998,0.133739573,0.0,0.20974871399999998,0.0,0.0,0.0,0.0,0.8105845970000001,0.67622344,0.597692363,0.862363393,1.15481908,0.195647899,0.35487109200000005,0.47913228799999996,0.147352524,0.0,0.110416751,0.198834596,0.23367010300000002,0.0,0.0,0.0,0.310388414,0.0,0.0,0.21435872,0.0,0.22665000300000002,0.296913528,0.054172467099999996,0.24566645399999998,0.0,0.39286646299999994,0.0,0.324283323,0.299537347,0.266179718,0.164480371,0.340219585,0.0,0.339450395,0.0,0.517686694,0.015327785900000002,0.0,0.5513836360000001,0.0,0.180091497,0.201805763,0.37887343100000004,0.36642574299999997,0.37467423899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.054047110999999995,0.281499813,0.0,0.0,0.37334798399999997,0.261688028,0.0,0.139747321,0.0,0.0,0.0,0.0,0.0,0.20313831100000002,0.43298021,0.0,0.0,0.0151143327,0.23555990699999999,0.0,0.478650759,0.0,0.0569685398,0.117261724,0.19721344899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.26165570000000005,0.22567644,0.19295495,0.16611664,0.14776055,0.14037139,0.14623396,0.16735254,0.20537752,0.26154165,0.33660788,0.43083019,0.54392895,0.67508143,0.82292794,0.98559359,1.16072506,1.34554157,1.53689856,1.73136258,1.92529507,2.11494298,2.29653357,2.46637081,2.62093073,2.75695293,2.8715259,2.9621635,3.02687068,3.06419647,3.07327273,3.05383766,3.00624334,2.93144711,2.83098695,2.70694169,2.56187706,2.39877908,2.22097671,2.03205593,1.83576757,1.63593155,1.43634015,1.24066301,1.05235649,0.87457988,0.71012082,0.56133182,0.43007977,0.31770958,0.22502302,0.15227317,0.09917455,0.06492842,0.04826255,0.04748411,0.06054395,0.08511056,0.11865115,0.15851775,0.20203546,0.24659042,0.28971485,0.32916655,0.36300065,0.38963135,0.40788203,0.41702199,0.41678896,0.40739669,0.38952724,0.36430846,0.33327706,0.29832859999999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.14551172,0.106526521,0.035936921499999996,0.0,0.0435924778,0.235525304,0.590455642,1.09189189,1.68585396,2.28954841,2.80694806,3.14791602,3.24671393,3.07586925,2.65240523,2.03511884,1.3135401000000002,0.590982779,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.189863941,0.365829788,0.43129763200000004,0.388312172,0.26277459,0.0955140733,0.0,0.0,0.0,0.0,0.0,0.0,0.0117141596,0.09030275460000001,0.132660656,0.135060892,0.104856083,0.0568421909,0.0080157037,0.0,0.0,0.0,0.0,0.0,0.0014516105300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0106874032,0.0731766016,0.131512239,0.166056384,0.160607441,0.10801864900000001,0.013882163500000001,0.0,0.0,0.0,0.0,0.0,0.0,0.112581938,0.31357244100000004,0.473427789,0.54710099,0.505488126,0.345083552,0.09259028009999999,0.0,0.0,0.0,0.0,0.0,0.22139484399999998,0.8942659890000001,1.66677443,2.43274661,3.07940876,3.50819554,3.65338241,3.49462573,3.0607207,2.42372726,1.68466689,0.953804368,0.329689603,0.0,0.0,0.0,0.0,0.0,0.0014739605599999998,0.113236956,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0853352889,0.529156584,0.788097486,1.16743511,1.51285676,0.0176145644,1.95303596,0.0,0.44346604799999995,0.0,0.0,0.110119304,0.0,0.0,0.963118508,0.0,1.15359912,0.0,1.03503604,0.14883195,0.0,0.26218097,0.8874484770000001,0.0,0.0,0.0,0.0,0.0135452882,0.0910058259,0.230733642,1.10773272,0.281346392,1.56530598,0.0,0.900130489,0.0,0.0,0.0,0.0,1.56019181,0.0866138848,0.039561535099999996,0.494509841,0.200579433,0.0,0.0,0.0,0.0,0.440257365,0.0,0.907903603,0.475774665,0.07868964269999999,1.23490596,0.0,0.0,0.0,0.32539905,0.710656321,0.35660901799999994,0.829225401,0.245238614,0.840376144,0.575858925,0.13772980699999998,0.0,0.583384085,0.45365227,0.0,0.0,0.179247297,0.0,0.0,0.0,0.140304843,0.0,0.16885878399999998,0.0,0.637864517,0.488375645,0.395829592,0.271459132,0.0,1.00684567,0.994185616,0.39080020600000004,0.11975413300000001,0.0,0.347888085,0.98041483,1.06602677,0.0610621386,0.0,1.48793381,1.23488673,0.0,0.0,0.0,0.06466065309999999,0.0,0.0,0.643055746,0.0,0.77648462,0.27529488,0.0,0.0,0.0,0.0,1.36039118,0.9622923729999999,0.0,1.00666085,1.53761995,1.88812121,1.67295954,3.51439296,3.57367954,5.8490117,3.52311743,4.57516919,2.94743714,2.43644026,2.14317218,0.0,0.480770431,0.324575363,0.311122825,0.0,0.0631349031,0.0,1.33379493,0.239064755,0.0,0.449139446,0.0,0.10190321199999999,0.0,0.7387851409999999,0.0935680323,0.7478779990000001,0.0,0.0,0.123473631,1.19081596,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.27465634,0.08618554,0.0,0.0,0.0,0.02695825,0.0665541,0.09943908,0.12490874,0.14647314,0.16793158,0.19011515,0.20932742,0.21794096,0.20692177,0.16944419,0.10439101,0.01851157,0.0,0.0,0.0,0.0,0.0,0.0,0.09422946,0.21368245,0.29154187,0.29925571,0.22218166,0.06567929,0.0,0.0,0.0,0.0,0.0,0.0,0.29583839,0.88613936,1.53385279,2.1497972,2.64206753,2.93258395,2.97181393,2.74866138,2.29340723,1.6729456000000003,0.97910895,0.31229043,0.0,0.0,0.0,0.0,0.0,0.0,0.11961688,0.36524916,0.49684687,0.4937487,0.36777805,0.15837503,0.0,0.0,0.0,0.0,0.0,0.0,0.05581833,0.24440374,0.36530012,0.38822051,0.3088592,0.15109515,0.0,0.0,0.0,0.0,0.07658077,0.49235958,1.03514241,1.64198852,2.23517949,2.73599657,3.07852429,3.22075548,3.15091532,2.88797815,2.47657843,1.97764628,1.45688845,0.97353355,0.57152484,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16241958,0.05777052,0.24576486,0.07002783,1.27413764,1.55412561,0.19313873,0.0,0.07232167,0.0,0.09005703,0.0,0.0,0.11298552,2.37159751,1.2133169,0.0,5.49235206,4.72586702,0.0,0.35003755,0.0,0.0,0.18790787,0.0,0.16259032,0.0,0.05793539,0.14865317,0.51653546,0.14078482,0.0,0.07903432,0.0,0.0,0.05706993,0.59223252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.29598960399999996,0.000988750526,0.192257669,0.0,0.0,0.0,0.0,0.0165551112,0.0686601158,0.0,0.18328634600000002,0.0,0.0,0.130092591,0.306298673,0.0,0.326390574,0.0,0.324506909,0.00438472889,0.12496748,0.0111938895,0.0,0.0,0.0,0.0561893785,0.0,0.32195035,0.23998151899999998,0.0,0.30871332,0.148372366,0.0,0.014475234699999999,0.19746877899999998,0.0,0.0584433308,0.0,0.0,0.123692075,0.405164301,0.274904407,0.0,0.106136174,0.0,0.0,0.0,0.613249561,0.6897793170000001,0.307073163,0.7934776040000001,0.126973988,0.298058366,0.260836785,0.0,0.23214180399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.193267997,0.26462836300000003,0.8970293770000001,2.46426139,3.02366414,4.08737299,3.78004809,3.04797675,2.30819396,1.04953762,0.502515619,0.524278127,0.0796180892,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.347943189,0.486438126,0.656035165,0.8168789809999999,0.9303552540000001,0.968262453,0.919255602,0.7909787429999999,0.607476193,0.40272403799999995,0.21210865,0.0641368722,0.0,0.0,0.0,7.04869904e-16,0.043195751,0.0706539038,0.0729886509,0.050928572199999994,0.013562658600000001,0.0,0.0,0.0,0.0,0.0,0.0109421659,0.0383677073,0.0515354656,0.0470587464,0.0274596813,1.3426093400000002e-16,0.0,0.0,0.0,0.0,0.0,0.015736671,0.0334231907,0.0393266704,0.0320161129,0.014439062800000001,0.0,0.0,0.0,0.0,0.0,1.3426093400000002e-16,0.0185684341,0.0304352675,0.031868729900000003,0.022678105499999997,0.00618000912,0.0,0.0,0.0,0.0,0.0,0.00582191038,0.0209431718,0.0288509033,0.0270103019,0.016154081,0.0,0.0,0.0,0.0,0.0,0.0,0.010916126200000001,0.0237145216,0.028533742400000003,0.0237480867,0.0109459511,0.0,0.0,0.0,0.0,0.0,1.3426093400000002e-16,0.0161085695,0.0267766929,0.0283584879,0.020338185800000002,0.00555877907,0.0,0.0,0.0,0.0,0.0,0.0038524926399999995,0.010791167800000001,0.00847418233,0.0,0.0,0.0,0.046152796399999994,0.14794142400000002,0.317595698,0.555638692,0.8476811590000001,1.16436062,1.46489509,1.70384138,1.83979469,1.84416592,1.70799885,1.44511196,1.09061619,0.694899736,0.314236117,0.0,0.0,0.0,0.0,0.0,0.0,0.0875046156,0.180571533,0.20895740699999998,0.169277398,0.0768606109,0.0,0.0,0.0,0.0,0.0,0.0,0.16301991300000002,0.326889145,0.460083928,0.53901259,0.553331985,0.508158097,0.42289766,0.327208225,0.255173711,0.23904065800000002,0.30377329399999997,0.463322936,0.719003318,1.05987179,1.46466295,1.9046710999999998,2.34702169,2.75794132,3.1058306,3.36407548,3.5135517,3.54469302,3.4588662000000006,3.26871029,2.99713016,2.67481658,2.33647207,2.01626816,1.74333339,1.53816428,1.41070605,1.36047936,1.3786235,1.45122929,1.56299781,1.70019985,1.8521578,2.01096661,2.16976723,2.32039821,2.45150818,2.54811377,2.59314321,2.57083708,2.47118477,2.29408451,2.05180044,1.76862317,1.4773551999999999,1.21315009,1.0060726,0.874257163,0.819545788,0.826947565,0.8683013820000001,0.909394363,0.91880557,0.8761953729999999,0.7778203690000001,0.6377288320000001,0.484214269,0.35237423799999995,0.274688626,0.272095872,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.24561924100000002,0.107265803,0.745903433,1.10668427,0.0,2.19803572,0.0,10.5977418,14.113741699999999,0.0,1.89986219,0.0,0.44075542100000004,0.0,0.0,0.5402030720000001,0.0,0.945795652,0.0,1.29674739,0.0,2.51676106,0.48730319,1.97791993,6.48658725,0.0,0.042909636200000004,0.103552321,0.0,0.157990514,0.0,0.124745316,0.0,0.0808696105,0.0,0.0500445328,0.0,0.0423615547,0.110392095,2.5103669600000003e-05,0.00459399501,0.0,0.0445669747,0.0,0.145011423,0.0,0.385127503,0.0,2.24503449,5.08016255,0.0,0.37970367,0.0,0.0,0.21824222899999998,0.0,0.563078929,1.22631374,2.26898033,0.0,3.91117534,4.89626155,0.0,0.28299280600000004,0.0,0.015893416100000002,0.00605470831,0.0026741001500000003,0.0,0.06771760019999999,0.0,0.156357056,0.0,0.240960035,0.0,0.312520019,0.0,0.44806306,3.17919166,0.246346896,0.0,0.1343805,0.0,0.0936746432,0.0,0.0404047079,0.0,0.0,0.0148766704,0.0,0.0192462863,0.0,0.0,0.0271587436,0.0,0.083137386,0.0,0.143908396,0.0,0.192971046,0.0,0.21218905300000002,0.0,0.175689581,0.0,0.0,3.14169344,0.786941179,0.579234052,0.8996863009999999,0.0,0.222183514,0.0,0.08781457449999999,0.0,0.026300021,0.0,0.00181028767,0.0,0.000126103061,0.008873669629999999,0.0,0.731228115,1.03535945,0.11628700300000001,1.08657425,0.219156459,0.15648038,0.0,0.15530534699999998,0.0181391771,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.32509554399999996,0.0,0.0,0.18067936199999998,0.0,0.0,0.136849997,0.0,0.400598539,0.695258935,3.36235781,1.27379025,0.43425690100000003,0.0,0.69974587,0.796699642,0.0,0.0343649084,0.0,0.0,0.299603884,2.45785503,0.40314800700000003,0.672603216,0.154365743,0.374589923,0.0,0.250069938,0.151902793,0.0,0.0,0.303195791,1.80550112,0.932999318,0.356319634,0.0,0.118427975,0.0,0.589223201,1.01463922,0.331936816,0.0,0.0,0.070318559,0.0,0.0,0.0,0.126065664,0.0,0.630382088,1.66253513,1.40601895,0.17377943899999998,0.0916485266,0.311312155,0.0704699183,0.223637413,0.0,0.196139085,1.00047876,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.377659711,0.47642986,0.271551716,0.679135635,0.0566659549,0.0,2.25217776,5.62472791,3.96845248,0.761226057,1.11278035,2.1562086,1.09984138,0.142711255,0.0829588328,0.0,0.0,0.122081983,0.0,0.0,0.10181964800000001,0.0,0.0,0.0634987286,0.0,0.21564828,0.281232992,0.0,0.0,0.159299534,0.0,0.0,0.153322435,0.0,0.0,0.16431838199999999,0.0,0.0,0.192382081,0.0,0.0,0.25633185199999997,0.0,0.0,0.506795791,0.0858200302,0.0,1.52591512,2.70024298,0.7832342529999999,0.0,0.109191259,0.226085063,0.0,0.047775304000000005,0.142855987,0.0,0.028882835200000002,0.123559713,0.0,0.0225548422,0.149128816,0.0,0.47679360299999995,1.89817446,1.65644689,0.0,0.0,0.361086653,0.14928561099999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.11382557,1.19156367,0.205549857,0.0,0.0,0.0,0.6141129,0.49848593799999996,0.015993963400000002,0.18345411399999997,0.807228543,1.93124846,0.379227328,0.830946658,0.0,0.0,0.0,0.0,2.02776507,0.44030578200000003,0.0,0.0,0.629132708,0.0,0.0,1.5011317,0.128892421,0.200185776,0.401924751,0.8779775790000001,0.427899737,2.61298086,3.16841951,2.10426827,1.19401294,0.972754982,0.15281656,0.0,0.0,0.481640487,0.0,0.0,0.682759095,0.472816874,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.43402516,0.421607012,1.89469815,0.893019443,0.8113664079999999,1.15300697,0.0,0.0,0.374672998,0.840929026,0.0,0.0,0.398401876,0.524299515,1.17709885,1.48988142,0.0,0.0490884742,0.0,1.81466639,0.937526368,0.8614977070000001,0.0,0.0,0.534058976,0.19855314,0.87968633,0.31550034600000004,0.0,0.353979239,1.87616169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.84655969,0.032316177200000004,0.0,0.15751229,0.0,0.9885553690000001,1.16807214,2.69986379,2.00579647,2.55304734,1.92190728,2.85772862,2.60186719,4.92921239,1.91178628,1.03621015,1.30623991,0.383845645,0.126620351,0.0,0.0,0.0,0.0,0.68071653,1.10246299,0.0,0.0,0.0,0.0,0.24780844300000002,0.0,0.014228984299999999,0.044431035199999996,0.0,0.0,0.0,0.646534121,0.0,0.179184412,0.0,0.0,0.7261860590000001,0.0,0.9002665670000001,0.5432359,0.0,0.0,1.15054593,0.507792565,0.81151182,0.0,0.0,0.0,0.679798366,0.0,0.0,0.287833033,0.247823958,0.0,0.0,0.0,0.344920965,0.0,0.0,0.0,1.50786783,0.114919635,0.613614167,0.0,0.252635603,0.36751146,0.7832485509999999,0.740877362,0.0,0.796752421,1.21846225,1.70717121,1.27653138,1.43090247,1.40309106,0.187710231,1.13336459,0.215287549,0.0,0.23774488,0.210212282,0.24310205399999998,0.8225525890000001,0.726419762,0.0413349281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.598053664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.09777899720000001,0.552351813,0.251291838,0.796175339,0.784612223,0.169396508,0.0,0.0,0.0,0.377611869,0.917866051,1.20234166,1.53756688,0.993140083,0.484818834,0.124430603,0.771862832,0.991232418,1.21312089,1.16105259,0.650628598,0.594368527,0.08605716960000001,0.68966863,1.18667107,1.27300212,0.9026879790000001,0.25934566800000003,0.0,0.0,0.124150716,0.0,0.34410483,0.0,0.199761838,0.0,0.0,0.0,0.6755216059999999,1.18107324,1.85884939,1.99513502,2.50478415,2.84753954,3.23400175,2.68288787,1.75505668,0.820437121,0.398891635,0.111482574,0.237439574,0.0292335058,0.09769558019999999,0.0,0.118321306,0.130118021,0.185678798,0.024064048199999997,0.0,0.0,0.07825497690000001,0.0,0.0,0.0203635237,0.19085286699999998,0.286550339,0.0,0.0,0.0,0.463728281,0.37317679299999995,0.610149884,0.39937668200000004,0.246772534,0.0228079881,0.0,0.0,0.0,0.0334298222,0.6059046810000001,0.84329566,1.20065473,1.52297509,1.30400475,1.23522214,0.732273361,0.506207902,0.206558517,0.0,0.0,0.0,0.0,0.030694361899999998,0.0747555979,0.0,0.0,0.0,0.160889425,0.306857167,0.0435151738,0.0,0.0,0.0,0.0,0.9406499709999999,1.35775358,1.8002435,2.0492557000000002,1.34848815,0.8332823659999999,0.0737874908,0.351481294,0.410302447,0.5416902170000001,0.32367383,0.467895204,0.145660279,0.037050831400000005,0.324662296,0.08931178210000001,0.172630057,0.7677234620000001,0.243487846,0.247029059,0.332290274,0.0917850902,0.462650268,0.363260798,1.05420554,0.9757688720000001,1.45810835,1.47679585,1.13595953,0.6906229709999999,0.799512054,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.68174924,0.924375425,0.35716228,0.0,0.0,0.0,0.0,0.0936522131,0.303507877,0.49450667200000004,0.63106322,0.690031953,0.6623079000000001,0.552614756,0.37761741200000004,0.162690206,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.163120616,0.311742625,0.412073374,0.45230971799999997,0.42918386299999994,0.34809337,0.222074112,0.06979100719999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.02796052,0.160281889,0.267333289,0.335050928,0.355063866,0.325699931,0.25206407399999997,0.145198592,0.0204574837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0565797886,0.165328933,0.24970209399999999,0.298393476,0.30514891899999996,0.269557406,0.19703545600000003,0.09801622119999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0816286347,0.177467693,0.24813416100000002,0.283965126,0.280155442,0.237397117,0.16176143699999998,0.0638430148,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00428379666,0.108670654,0.198118481,0.260153848,0.286071348,0.272146929,0.22016865800000002,0.13720992199999998,0.0346735081,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.035889476600000005,0.143120664,0.23143684399999997,0.28830736,0.305435505,0.279955097,0.214891272,0.11881385400000001,0.004721421270000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0759433415,0.19416442899999997,0.287566412,0.342510993,0.35041904700000004,0.309081029,0.223126534,0.10357299699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0669220077,0.263343286,0.45645286399999996,0.626410445,0.756977335,0.8378467070000001,0.866202059,0.847267159,0.793741282,0.72416206,0.660385541,0.6244992420000001,0.635571853,0.706679698,0.842629046,1.03871551,1.28073597,1.5463093,1.80739026,2.03369712,2.19664123,2.27326252,2.24965277,2.12339219,1.90463233,1.61561665,1.28862198,0.962505044,0.678224316,0.47385312700000004,0.37968702299999996,0.414062515,0.58044239,0.866189267,1.24325853,1.67081586,2.09954978,2.47723469,2.75493135,2.89311149,2.86697552,2.67030123,2.31731105,1.84226038,1.296705,0.744673464,0.256217915,0.0,0.0,0.0,0.138122957,0.7256472690000001,1.54309661,2.53986734,3.64611717,4.77910715,5.85094373,6.7769114,7.48352036,7.9154254,8.04049713,7.85253148,7.37134282,6.64027216,5.72141994,4.68915379,3.62261631,2.59804932,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
0.500526912,0.6276690739999999,1.4778706,0.752760874,1.48096905,1.0711837,0.49649827700000004,0.583831395,0.6603045989999999,0.0,0.0,0.0,0.263870186,0.0,1.34908124,0.678077789,0.0,0.0,0.11414400599999999,0.351566119,0.205871014,0.0,1.09135483,0.096266474,0.0,0.585479154,1.02048783,0.0436222051,0.604019985,0.0,0.0,0.10473137699999999,0.103896121,0.0,0.63925045,0.981308058,0.21670647199999998,0.0,0.373802486,0.45811069,0.0,0.320430987,0.0,0.0,0.0,0.0,0.0,0.471434833,0.0,0.0,0.0,0.0,0.0,0.00993455926,1.59226116,2.22908686,3.32725901,3.97575271,2.16186131,1.84424673,0.631570528,0.747031765,1.01395974,0.22781600100000002,0.919306755,1.08557298,0.35541757399999996,1.45053085,0.0,0.167312298,0.10570155199999999,1.12841087,0.0985415531,0.211611622,0.08646342439999999,0.0,0.938162445,0.0,0.0,0.47695490700000004,0.14942401,0.172209253,0.48186087200000005,1.39831021,0.6385573760000001,0.35234303899999997,0.00264174955,0.5669408539999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.65756475,2.66593074,1.53547611,2.18016289,1.75010318,1.15878215,2.93582717,4.45350724,2.47523879,0.0,0.0,0.18105019,0.04626333,0.34403509,1.0321993,0.61511192,0.0,0.17126455,0.0,0.0,1.97117672,5.72295535,4.88045848,0.4188001,0.0,0.50175985,0.79112607,0.0,0.0,0.82372201,0.17927452,0.0,0.2405183,0.62711683,0.33646049,1.58676329,3.68705268,3.62726485,1.74585092,0.63812866,0.55008291,0.55873768,0.87693481,1.1299402,0.41957302,0.0,0.27920007,0.66968149,0.0,0.0,0.34068704,0.22562181,0.0,0.0,0.44737062,0.0,0.0,0.30889504,0.32149971,0.0,0.0,0.59734661,0.0,0.0,0.40222140000000006,0.63708074,0.0,0.0,3.30127161,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8182331409999999,0.37295698899999996,0.601436968,0.430510926,0.44605949100000003,0.12136792699999999,0.0,0.0,0.0,0.0,0.23817526100000003,0.0,0.106108575,0.156661078,0.152146845,0.19839612899999998,0.0,0.0,0.0,0.0386058678,0.0,0.0,0.11452598300000001,0.0,0.0,0.19745802199999998,0.0,0.240225789,0.0,0.252823197,0.0,0.0,0.0,0.0301957942,0.409886418,0.0,0.085172649,0.31448023199999997,0.251241237,0.290081056,0.218107114,0.224105952,0.0,0.306551939,0.0,0.433835775,0.53068727,0.46993264700000004,0.245566347,0.450594989,0.0940089073,0.125480624,0.21486725,0.0,0.0,0.389192217,0.22753919600000003,0.0163193928,0.0,0.0,0.0,0.300446247,0.0852410634,0.0,0.145172676,0.0,0.028012300299999997,0.12006595800000001,0.04454121690000001,0.0,0.0,0.0,0.198049717,0.234766745,0.0,0.0,0.0,0.270702707,0.0,0.08842965720000001,0.209675755,0.0,0.289614645,0.0634859077,0.230094849,0.0,0.011858146699999999,0.0,0.25796124800000003,0.18357004300000002,0.0,0.087246529,0.150737857,0.12360395800000001,0.275486656,0.0,0.0950153757,0.0,0.0,0.046961492,0.0,0.0425199627,0.00255234627,0.223831805,0.0611883643,0.0418860386,0.0,0.0,0.0,0.0,0.214462089,0.262766363,0.277457335,0.0,0.0,0.0,0.0,0.0428390131,0.0,0.280931495,0.0,0.10449671099999999,0.090290411,0.0,0.0,0.0,0.0,0.0,0.26336575,0.0,0.282084995,0.234743178,0.0,0.0778848157,0.17527933899999998,0.0,0.17322750399999998,0.45656142200000005,0.826922955,0.476009433,0.723652348,0.86434774,0.899100531,0.8259117090000001,0.79097144,0.386391253,0.0,0.0,0.0,0.0,0.28511138199999997,0.161183173,0.42325183200000005,0.0,0.0,0.0,0.0,0.10951248699999999,0.156837434,0.254241942,0.08394261859999999,0.33736529200000004,0.21322208399999998,0.264068119,0.192776988,0.0,0.0,0.0,0.2549982,0.0,0.0571313415,0.0,0.0,0.0,0.0,0.34018148299999995,0.68478317,0.56877366,0.36524194299999996,0.149394586,0.0,0.0,0.0,0.0760940303,0.999153084,2.0226917,2.78949022,3.30690452,2.8339693,2.17928479,0.6879854609999999,0.0,0.0,0.0,0.0,0.218392182,0.829256856,1.41099339,1.13406526,0.884422768,0.854012812,0.771486138,0.36512315799999995,0.20104719399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.857571713,0.883651153,0.865916328,1.31230571,1.70700452,1.83895667,2.05764814,2.22392694,2.90363713,2.94681617,2.99273313,3.45614008,3.35060625,3.85959427,3.89759986,3.32092293,3.29163549,3.54531562,2.92630151,3.27536247,2.6134058999999996,2.69036638,1.8966113000000002,2.22885168,1.27815984,1.2374771,0.723232056,0.636421771,0.564121999,0.318369255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0620827547,0.0,0.23610827899999998,0.49026396299999997,0.573579046,0.295899947,0.524643895,0.24798394,0.533202714,0.5655369,0.328828993,0.14637033,0.128079345,0.330289495,0.0191397889,0.0301276905,0.0,0.01752944,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0136868593,0.0,0.09663761130000001,0.0,0.00619108065,0.0,0.21316379,0.0948732883,0.407801565,0.410097967,0.22609907399999998,0.6816901329999999,0.486124881,0.620378487,0.0958725616,0.490571166,0.0,0.181417895,0.11314351199999999,0.319095222,0.0,0.0399863309,0.0,0.0,0.022789570699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.151719333,0.0,0.203560162,0.0,0.300920598,0.17511682399999998,0.0595735711,0.575778652,0.47935833299999997,0.7522801159999999,0.731991692,0.523600683,0.136093818,0.256591728,0.441174154,0.308340342,0.0,0.23298009100000003,0.18196070399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0116379451,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.4867487999999995,1.03102453,0.451434719,1.96068843,2.44420747,1.89952683,1.61708517,0.0,1.4218237,0.37576085200000003,0.0,1.6764641,0.0,0.0,0.0,0.0,0.0,0.8085278109999999,0.0,0.0,0.258680239,0.451424728,0.0,0.622110411,0.0,0.625339295,0.760898443,0.0,0.407648332,0.0,0.0,0.0,0.45891792600000003,0.0,0.869438888,0.9132102740000001,0.0,0.0,1.00156958,0.358813014,0.286841162,0.0,0.40063381299999995,0.877213948,0.6424431620000001,0.0,0.138370036,0.0134905356,0.0,0.977018395,0.82406133,0.40539500100000003,0.0,0.509500226,0.0,0.864691103,0.0,0.688541106,0.0,0.503295559,0.15328762,0.0,0.0,0.963321655,0.0,0.0,0.0,0.140155494,0.0163501598,0.0,0.0,0.29377416,0.0,0.0,0.0,0.822055035,0.0,0.642734527,0.0715438379,0.0,0.998450611,5.12921753,7.99908279,9.95386319,10.7344382,7.86436116,6.02851999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.239
0.46186458,0.0,0.0,0.0,0.266713472,0.00136596385,0.08958102009999999,0.0,0.418484966,0.521835611,0.284208912,0.439664059,0.391077248,0.61280098,0.667863353,0.464890322,0.824791541,0.654687124,0.570749007,0.289597073,0.494337215,0.0,0.23984304899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.214640866,0.0,0.266148412,0.0,0.0,0.22136685399999997,0.0700991176,0.0916636839,0.0,0.158212333,0.0,0.042064332,0.0,0.253650928,0.0276705196,0.0,0.293629976,0.0038745794299999995,0.0,0.0,0.122526725,0.38072658600000003,0.138387654,0.0,0.05671134269999999,0.133017357,0.360276227,0.0,0.09349199050000001,0.0,0.06587043940000001,0.23309806600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0893920526,0.176869749,0.0,0.257268534,0.298622834,0.278330471,0.0,0.0,0.0,0.0251631698,0.0,0.308873384,0.0,0.347197728,0.0,0.0,0.252665619,0.210137608,0.469102629,0.0,0.388932919,0.602476649,0.692293135,0.200688647,0.795322482,0.193387115,0.128861997,0.0,0.0,0.286064852,0.0,0.0186571307,0.0,0.0,0.033388656600000004,0.0,0.09776421119999999,0.41289148299999995,0.0,0.0638690746,0.0440216833,0.0273654647,0.390214978,0.24055004600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17322665399999998,0.368247582,0.651011745,0.487418041,0.66366112,0.0,0.0,0.013387258999999999,0.0,0.0,0.0,0.267717494,0.150065306,1.17113286,1.61136094,2.03041251,2.57113411,2.92381407,3.69521533,3.84402802,3.22042072,3.3924870000000005,2.78999057,1.82383101,1.66094859,0.761299415,0.618628327,0.14312002599999998,0.146702894,0.0,0.525524734,0.585822367,1.18911366,1.93639404,1.9084487,2.11759743,2.23746223,1.68589796,1.31538729,1.00897244,0.617073601,0.16759744099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.110635201,0.53736556,0.626369918,0.621110515,0.354870325,0.14786359699999999,0.0195713525,0.0,0.0,0.0,0.0,0.00691155473,0.0,0.0745117783,0.24282681399999997,0.309165945,0.0,0.241054346,0.145609945,0.0,0.245812583,0.29416632600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5162612910000001,0.260789841,0.66981309,1.12092888,1.30800726,1.5260733,1.40171963,1.44223315,1.45980687,0.7707581179999999,0.6400795979999999,0.61514201,0.765956236,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.242090248,0.66033265,0.712780462,0.44263062200000003,0.205414768,0.133671744,0.0980330753,0.0202212952,0.0,0.0913944491,0.203115197,0.19156062699999998,0.0806177892,0.0016591108800000003,0.0,0.00324790406,0.0,0.0,0.022270749700000002,0.0249136792,0.0,0.0,0.0162068556,0.048115391699999996,0.0,0.0,0.0131653056,0.09389352640000001,0.0372434075,0.0,0.0,0.0920824714,0.11757844,0.0,0.0,0.0940431043,0.624781344,0.8493223670000001,0.580523453,0.170045074,0.0,0.0,0.0,0.0,0.0618110504,0.201043368,0.20548243100000002,0.0782642125,0.0,0.007512027409999999,0.00102857788,0.0,0.0,0.0708385582,0.0769962984,0.09785250919999999,0.498452237,1.30463303,1.86284935,1.53652969,0.603336038,0.0,0.0,0.125875965,0.0,0.0131769221,0.791819162,1.80028301,1.87210436,0.770119887,0.0,0.0,0.177334463,0.469875396,0.15739310199999998,0.0,0.45098772600000003,0.9762903559999999,0.947146685,0.8085904340000001,1.5998603999999998,3.41691247,4.94641476,4.80257879,3.03973668,1.05035931,0.0989941475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0760303822,0.0739806101,0.0,0.42771943799999995,0.0,0.0307513255,0.0,0.047058337900000004,0.00415600532,0.0,0.0,0.0,0.0,0.0,0.0,0.31328697899999997,0.102615015,0.533786182,0.541596458,0.09923513949999999,0.0,0.0153542825,0.0,0.115253445,0.0,0.0,0.547947854,0.24371915800000002,0.559175941,0.0,0.0,0.46038102399999997,0.0,0.0,0.0,0.0,0.392389868,0.0,0.0,0.0,0.0,0.0,0.0,0.0898029524,0.661345767,0.091000284,0.841409332,0.694571515,0.490025325,0.858344005,0.0,0.355971703,0.0,0.158511362,0.294569564,0.53822853,0.537271255,0.886030335,0.771209246,0.874920633,0.0,0.2921684,0.246133656,0.0,0.0,0.73428356,0.711243007,1.2106336000000002,1.81632121,2.86536195,2.52421817,3.36456119,2.91586442,2.16500046,1.56860721,1.50745678,0.524366594,0.0,0.0,0.0,0.0,0.0909874222,0.0,0.381364635,0.38993198799999995,0.137335766,0.0,0.287781797,0.0,0.337207759,0.0,0.0,0.0,0.0,0.166687399,0.0,0.303958397,0.219423368,0.0,0.0,0.0,0.693621912,0.0,0.372556084,0.42083896,0.373315254,0.0,0.0,0.0,0.406953196,0.422165292,0.43145242899999997,0.524543259,1.28730931,0.587355469,1.14993985,0.253836825,0.14815478699999998,0.156343953,0.260912423,0.0,0.00595304428,0.0,0.292676647,0.0,0.058558030899999995,0.426948031,0.354053491,0.268334827,0.0,0.0,0.0,0.0,0.160875789,0.401474085,0.18785653600000002,0.0,0.573467387,0.0,0.0,0.256808628,0.11108999300000001,0.314547975,0.0,0.0,0.519336472,0.110290921,0.7181561759999999,0.35186239,0.27520600300000003,0.0,0.0,0.243055734,0.351390453,1.03268418,1.42864638,2.45681571,3.22094952,4.70542148,4.67786607,4.88180962,4.58400304,4.28079925,3.3877147000000005,2.91976615,1.25630906,1.21792303,0.342240353,0.250353625,0.7795002390000001,1.99658211,2.21870586,3.0123492,3.01537425,3.05427106,3.56774109,2.78543722,2.64102568,1.6699098,1.55141902,0.5586277479999999,0.31264749999999997,0.47120869600000004,0.228619493,0.19015101,0.183029157,0.5012465220000001,0.20347628399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.48165083,0.34470189,0.25075001,0.4629277,0.0,0.0,0.14648461,0.20565671,0.30193577,0.26177153,0.17036095,0.43358064,0.05898872,0.24726368,0.42858496,0.8157856,0.63720982,0.97124718,1.09962061,1.08946511,1.44618981,1.09038995,1.37962913,1.08554087,0.95228374,1.24399847,1.16466586,0.92414153,1.25187602,1.44502928,1.69851573,1.76607292,1.97234767,2.29626188,3.20110753,3.32582562,3.19965395,3.11700534,3.29353548,2.61079469,2.69085003,2.31182558,1.8722172,1.42385774,0.96284011,1.27502679,0.72597992,0.87503235,1.1232313999999999,1.05946831,0.76230256,0.75433098,0.6526453000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.54528427,0.645009,0.82912506,0.91660059,1.55906903,13.85997657,5.67518715,10.62644309,1.55035507,3.35643911,1.86203081,0.0,0.56916466,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.82133408,2.24005628,3.46087696,2.0486579,3.26974899,4.52489906,3.80041693,0.0,0.14428092,2.29420286,0.37461642,0.0,0.05882821,0.0,0.26578083,0.25485444,0.66393372,0.52814232,0.41652585,1.11415767,9.65666387,0.05502046,2.13914946,2.45440611,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.24597605,0.0,0.0,0.937183568,0.0,2.84273909,0.0,1.02402597,0.0,0.0,2.65923285,0.0,1.11390871,2.46323623,1.34854747,0.30180555,0.0,0.43364310799999994,0.171943896,1.0632066999999998,0.0,0.0,0.797230324,0.744702915,0.0,0.0,0.37434995,0.0,2.68740136,0.0,0.0,0.641478213,0.0,0.0,0.47533092,1.43704152,0.0,0.0,0.0,0.0,1.23525103,1.1587825,1.84458809,0.0,0.0,0.0,0.0,0.0,0.0689251619,2.42587666,0.0,0.774466145,2.38736529,0.0,0.0,2.67491029,0.0,1.87034151,0.0,1.12773367,0.29172738600000003,0.0,0.0,0.0,0.0,0.0,2.11540513,2.7792559,0.0,2.03730376,0.0,0.733867222,1.72645352,1.12156504,2.53738484,0.0,0.0,29.7500603,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.24600000000000002
0.31119509,0.5228934000000001,0.55537391,0.43961133,0.25781636,0.11066779,0.08148514,0.20841198,0.47275134,0.80633437,1.11484065,1.30912797,1.33431893,1.18729329,0.91703451,0.60778725,0.35049759,0.21182427,0.21093619,0.31203179999999997,0.43568556,0.48619027,0.38682157,0.11203023,0.0,0.0,0.0,0.0,0.0,0.2518037,1.47242738,2.89676831,4.292566099999999,5.41194504,6.04775328,6.08188648,5.51306505,4.45681401,3.11766423,1.74085953,0.55612204,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
138.591361,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.06892901e-14,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.06892901e-14,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.325
1.2530456,1.57929153,0.0,0.601486073,0.732078937,0.414241165,1.74099437,1.61263746,0.24893080199999998,0.0,1.24964734,1.38064318,1.73061735,1.65214429,0.340193499,1.15481171,2.97219136,3.15974153,0.09746821130000001,0.051211676,0.146572491,0.750108131,0.00136324099,0.0,1.0347763,0.213260615,0.334883523,0.283712327,0.909370727,0.396562966,0.0,0.191318727,0.873362078,0.73866272,0.387178436,0.0,1.05104712,2.24633378,1.09169334,0.0,0.32464751399999997,0.0,0.0,0.0,0.0,1.02944602,0.0,0.14498231,0.661674071,0.0,0.778013968,1.50294562,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.317615699,0.0,0.0,0.0,0.0,0.0,0.0,0.221529897,0.564705253,0.051028384100000004,1.1054961,0.756524137,0.6920664000000001,0.41465130299999997,1.13361386,0.42820655399999996,0.274294877,0.0998496199,0.0,0.0,0.193485773,0.0,0.0,0.0,0.0681697424,0.647268822,0.740371643,0.657289735,0.00105524269,0.24587526199999998,0.635693693,0.126524847,0.22284171,0.146306089,0.178987268,0.0,0.010655976599999999,0.16197889099999999,0.0,0.14321139300000002,0.44058849,0.0263901845,0.427597522,0.551393374,0.590497084,0.317209371,0.285753495,0.0,0.0,0.0,0.0237664941,0.0316965294,0.0,0.189706934,0.294160198,0.0,0.0186044842,0.477504527,0.519541715,0.6010425429999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.191761878,1.10526272,1.89205273,1.91873275,3.07983304,3.4959492999999995,3.8636356,4.49471126,4.36894044,4.34285048,3.82584739,3.60424625,2.75010802,2.49876554,1.01176339,0.40298297299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0265865295,0.0,0.0,0.0654194318,0.49198435799999995,0.0,0.471313783,3.07309459,4.49112189,4.04173581,0.8088030070000001,0.956466967,0.6819515309999999,0.523760617,0.0,0.0,0.0,0.01562274,0.5947012629999999,0.0,0.470652203,1.2359142,0.11570598,0.0,0.0,0.528282799,1.82790932,2.53595787,0.7707379120000001,0.329509197,0.667442569,0.0,0.611776708,0.0,0.0,4.61166501,7.84282498,2.72005838,0.0,0.774981151,1.41605706,0.708280096,0.93743725,0.865621883,0.0173637574,0.575217509,0.120594311,0.0,0.0,0.022480518999999997,0.0,0.11216369699999999,0.0,0.0,0.537143468,0.818294915,0.0,0.0,1.74267573,4.06248167,1.96538025,0.0,0.6027023420000001,2.45774209,1.58020578,1.07942552,1.619846,3.16620352,3.81270257,1.37861667,1.54357627,2.20194222,0.0,0.0,0.8770240490000001,0.0,0.379789861,2.78807573,1.33824352,0.479031033,0.07353992179999999,0.319647492,0.0,0.7392619090000001,1.48571212,0.350725778,0.39575361,0.043666253700000005,0.284831451,0.0966311725,0.0,2.13454254,2.1145655,0.878749294,0.0,0.17789047,0.328128704,0.20406621,0.0,0.675183822,0.23615175600000002,0.0,0.683384677,0.0,0.0,0.0,0.41366991399999997,0.387018012,0.669454847,0.598033142,0.0,0.0,0.6579199920000001,0.58868588,0.0,0.0,0.0,0.775995765,0.0564775508,0.251541458,0.401037889,0.538808442,0.0,1.0066746,1.21880911,1.49123081,1.1484252000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.443084155,0.528872351,0.591214805,0.624650333,0.627032702,0.599688774,0.547125131,0.476335413,0.395812926,0.314409868,0.240201054,0.179504517,0.136185144,0.111324735,0.10328877,0.108164459,0.120494036,0.134188686,0.143487019,0.143820235,0.132463725,0.108889001,0.0747752275,0.0336895838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0352467057,0.0659837015,0.08659568029999999,0.09441283880000001,0.08865673630000001,0.070510096,0.042900964699999995,0.0100378907,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0125505728,0.0379214622,0.056545134500000004,0.0660678521,0.0656198088,0.055887179800000006,0.038937473199999996,0.0178310575,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0067821413,0.00936968435,0.00707239455,0.0012235709599999998,0.0,0.0,0.0,0.0,0.0107153919,0.0322012121,0.057150251799999996,0.08047498410000001,0.0958732578,0.09682523800000001,0.0778410658,0.0357937311,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.038771225,0.35519976299999995,0.761327917,1.24126299,1.76930438,2.3114427,2.82796845,3.2769876000000004,3.61851373,3.81871112,3.85381236,3.7132382000000006,3.40150914,2.93865279,2.35896855,1.70819373,1.03930311,0.40734397299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143905631,0.521241927,0.8390211040000001,1.04952246,1.11828675,1.02858935,0.7840208240000001,0.408828851,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.9147660320000001,1.96721535,3.0673597000000004,4.13065178,5.0731078,5.8193567999999996,6.30985556,6.50651869,6.3961871,5.99159409,5.32975911,4.46801508,3.4781246,2.4391356,1.42974798,0.520996101,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0249667969,0.329881584,0.553965887,0.677695046,0.696122153,0.618008749,0.463439496,0.260301765,0.0401220328,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0838981237,0.215756103,0.309301125,0.35414622799999995,0.34713671399999996,0.292340702,0.200082095,0.0851950443,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0035992651700000006,0.09591051449999999,0.170599533,0.218055584,0.23287360399999998,0.214421907,0.166728694,0.0977293832,0.018002528,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0337901588,0.09148852060000001,0.132852276,0.152664654,0.14920557,0.124471871,0.0838655574,0.0354019614,0.0,0.0,0.0,0.0,0.0,0.04766095309999999,0.134277741,0.235612205,0.342025488,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.250340393,0.36461169200000004,0.0453813375,0.38103952700000004,0.30637423399999997,0.38859867299999995,0.0858440488,0.00124865873,0.0,0.17584279100000003,0.335733623,0.138625323,0.165429874,0.024681261099999997,0.0,0.0279964865,0.0,0.0,0.0,0.0313985737,0.0,0.138103592,0.174959699,0.66957346,0.9715468829999999,1.47954867,1.66275507,2.49456865,2.82138971,2.97315565,3.09679247,2.62053562,2.56543854,2.44021304,1.90635447,1.6623346,1.24176414,1.03380748,0.728907825,0.0,0.0,0.0991740599,0.0,0.0,0.0,0.0,0.11415963300000001,0.118590498,0.0809114792,0.284845077,0.0,0.0,0.129557143,0.264407507,0.104193619,0.00380014568,0.205854832,0.0396923867,0.21123325199999998,0.22457797399999999,0.41368821899999997,0.508875975,0.35061423399999997,0.7127219509999999,0.739433528,1.07585655,1.25299189,1.07607342,1.08979707,1.1755436000000001,1.23208571,1.3276696000000001,1.17879686,1.14970382,0.994248177,1.09990296,0.776642277,0.9119447490000001,0.665866721,0.5064993729999999,0.307629706,0.678187724,0.132331071,0.1000624,0.547922539,0.19723258,0.44312655100000004,0.212328729,0.250671952,0.661145416,0.426467489,0.644283439,0.584604296,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.655106789,1.16468841,0.468396689,2.03525861,1.63025399,0.883455278,0.742849882,0.207132433,0.31302668899999997,0.0,0.0,0.203029391,0.382214039,0.360007001,0.369467745,0.436709763,0.433193568,0.364670239,0.20614722600000002,0.528331963,1.17794995,0.0,0.38400843100000004,0.00794275235,2.3131276,2.09847113,0.312894163,0.00867763007,0.0,0.7083187259999999,0.344330651,0.282155358,0.0,0.0,0.335930936,0.5192503070000001,0.0,0.0,0.28389759600000003,1.70125428,0.588460455,0.751998567,0.0,0.832912915,1.90859637,0.538847176,0.484501925,0.0,0.0,0.0,0.8139107320000001,0.269027401,0.305772648,0.207386816,0.0,0.322643505,0.0,0.0,0.0,0.0,0.37238884299999997,0.0,0.158764259,0.0,1.78708101,0.280176906,0.0,0.0,0.0,0.7173785779999999,0.0917202004,0.0,0.30177208899999997,1.20065968,0.6938039559999999,0.0,0.0,0.571071612,0.0,0.0,0.374719181,0.0183033492,0.29669872199999997,0.523010824,0.0,0.0,0.517711216,0.0,0.247451513,0.0,0.09871010470000001,0.0,0.0,0.0,1.05592614,0.0,0.27869568,0.0,0.5479043929999999,0.9637765009999999,2.48510754,3.26920718,0.0,0.0234321447,0.0,0.179758707,0.0,2.93250487,6.54061039,1.1827309,1.34223015,1.04321145,0.216690805,0.11058583699999999,0.0,0.0,0.0,0.170471681,0.8507898509999999,0.0768744997,0.5480430239999999,0.0,0.887457664,0.0,0.0,0.293705031,0.0,0.0,0.106962098,0.0,0.0,0.0,0.0,0.0,0.174612978,0.670889421,0.311061111,0.666101516,0.139427178,2.51806506,2.02015461,0.8586259829999999,1.01456376,3.36775046,2.55750111,0.0,1.08382005,0.18679339,0.308714902,0.0,0.618099514,0.193565961,0.14475744699999998,0.0,0.0,0.0,0.0,0.0,1.87468875,1.49630768,0.365759795,2.10823718,1.38927145,3.30387072,1.19788093,1.52247999,2.73565958,2.58860907,1.34278354,0.32196976,0.549346091,0.126777563,0.636680763,0.51066553,0.0,0.45536191600000003,0.189568805,0.0,0.0,0.43873882299999994,0.608789101,0.0,1.67573618,0.9572830290000001,0.0984715103,0.0,1.98769499,1.47162353,0.244436388,0.9344020340000001,2.44682743,4.90192196,3.79537798,3.39044173,1.14886903,0.332457204,0.0,0.5113643170000001,0.259555952,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.459833282,0.0,1.61586775,2.75400862,1.4704044,1.98254231,0.0,0.42707973899999996,0.0,0.331091472,0.0,0.36984864799999995,0.0,1.83007753,0.817949273,0.127319079,0.18897275,0.13781013,0.0,0.781525782,1.51935955,2.54978352,5.41131009,10.2660319,2.52995038,0.0,0.032478496,0.0450775768,0.0,0.130565758,0.0,0.204312948,0.0,0.39209338299999996,0.0,0.393907415,0.0,1.77317081,0.717573462,0.0669608512,0.0,3.23226404,6.15755995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.04039176,0.12154269999999999,0.0,0.0,0.017074000000000002,0.63766832,1.21381257,0.76071136,2.07366559,1.48795746,2.57748042,1.74446858,2.70814369,2.3323374,1.73740071,0.8580751,0.86192168,1.78166653,1.54599627,2.43832656,2.13541398,2.02100673,2.7389049,3.2167789,2.94604703,2.08484389,2.06736104,2.79406309,1.83701144,2.22089883,1.8062741999999998,2.19489546,2.51041231,0.8202658000000002,1.82372604,0.67083965,0.0,0.78282256,0.0,0.36806989,0.0,0.0,0.0,0.75888995,1.13516101,0.8184486,0.5250571999999999,0.0,0.12034553,0.42177899,0.0,0.99305626,0.02638987,0.36795199,0.67481573,0.85005546,0.56316299,1.86775451,0.98238381,1.06483211,0.0,1.14630881,0.67034134,1.00082778,0.4446343,0.73791634,1.07599054,1.31368715,0.96146226,0.71896663,0.59931729,0.66949891,0.71446611,0.0,0.20138372,0.43707815,0.43702362,0.37348004,0.45314354,1.25245809,1.26734035,0.97640967,0.67370848,0.0,0.8892027,0.38195968,0.82856831,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.17443981,1.77861434,0.0,0.530404812,0.718210955,3.03446161,1.65087717,0.00830760359,0.0884932806,0.0,0.0540208857,0.0,0.0579217743,0.0,0.18633284,0.158506442,0.317418082,0.0,0.07212686759999999,0.0,0.18773229,0.0,0.59838714,0.13541940800000002,0.39559105200000005,0.00793983227,1.24464159,1.72186659,0.0458045907,0.34230619799999995,0.612566547,0.250088256,0.365125449,0.918445277,0.0,0.0105084752,0.0,0.12500572199999999,0.856329036,0.0,0.240997732,0.00644140432,0.18126850100000003,0.0,0.324520899,0.0,0.35838711799999995,0.0,0.57490978,0.0,4.74831077,2.59259392,0.0,1.62078921,1.11508242,0.523902541,0.0,0.08752067029999999,0.0,0.00866824315,0.0255992452,0.0,1.24695272,0.229565684,0.468871,3.07868327,1.94997565,0.141321491,0.744391028,0.0,1.69372478,0.66031762,0.0154637023,0.40068392700000005,0.931541886,0.586283444,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.21673931300000002,0.384597299,0.392735968,0.566290583,0.21000069899999999,0.48268420700000003,0.0,0.0,0.240038416,0.20594052300000001,0.0,0.146391892,0.559888043,0.25619312899999996,1.06146874,0.882689787,1.36317326,1.28899093,0.9215093679999999,0.821732811,1.10341724,0.7793436140000001,0.749809053,0.28881314,0.24819148300000002,0.123760076,0.6755316140000001,1.25053017,1.75510543,1.81273538,2.79466074,2.66322032,2.59214253,3.01217948,2.73298426,2.18057074,1.27835312,1.19479332,0.20766949399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.30836622,0.428839545,0.709990162,0.7174982409999999,0.30712238399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.135543222,0.0720969945,0.36860638,0.364722218,0.7131572540000001,0.797286426,0.326966339,0.260430344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.153603625,0.820591898,0.643191015,1.20980068,0.9263918990000001,0.8000339329999999,0.967988783,1.08001894,0.773586935,0.849794637,0.330225922,0.549170976,1.61641748,1.93230018,2.20281844,3.1524556,3.64078383,4.18916157,3.68356311,3.8170374,3.51139134,3.44000419,2.71549042,2.52429027,1.29730907,1.31610587,0.802823869,0.0014172707399999999,0.45154020899999997,0.0,0.138750021,0.270040352,0.317177775,0.133934331,0.180630863,0.10712069999999999,0.0,0.33534599,0.107618777,0.0,0.0443858092,0.0,0.0,0.0,0.0,0.0,0.101262869,0.0,0.382293459,0.0,0.15082195,0.0,0.0,0.0,0.283227992,0.026033691299999998,0.0,0.0,0.0,0.0,0.134099284,0.0,0.342036852,0.0,0.0,0.0,0.31983932600000003,0.40746832899999996,0.42243125299999995,0.37950940200000005,0.198988835,0.0372188448,0.0,0.0,0.307768203,0.0,0.21722423800000001,0.0,0.0,0.160354874,0.231772079,0.118740365,0.47761826799999996,0.558039015,0.500793983,0.0,0.0,0.0,0.229144202,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8659394029999999,1.28032111,0.967448546,0.6983356820000001,0.798832089,0.0,0.639301176,0.21338452800000002,0.0,0.8842804940000001,0.480593845,0.0,0.425935891,1.30813308,0.574153785,0.97975453,1.0990596000000001,0.45946637700000004,0.0,0.7871491429999999,0.0,0.698391055,0.25343391,0.0,0.0914526287,1.39727849,1.93605063,0.914433072,0.975936433,1.28662977,1.44007072,2.35624639,2.69146567,1.08066158,1.06211053,0.0,0.887944238,0.41534287,0.227404188,1.12667587,0.6795361670000001,1.89602163,2.22635181,3.2803737999999996,3.28408003,0.737591627,0.0,0.12756461800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.5650279810000001,0.0,0.0,0.0,0.255758611,0.0,0.602594702,0.0,0.0,0.0119657974,0.0,0.0806131337,0.42077808899999997,0.0,1.04002485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.54085402,5.94624509,14.63439537,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.737641743,0.7500845840000001,0.0,0.0,0.0,0.0,0.0,0.39215894799999995,0.0,0.6913486059999999,0.0,1.0190127,0.825839643,0.0,1.17839561,0.690287593,0.396945545,0.291067225,0.0,0.43485611,0.589326595,1.79498284,3.42048891,4.73722325,7.05717111,8.33817857,8.88446971,9.11012192,9.22487459,7.79833061,5.59917438,4.79553591,3.26342523,0.623408555,0.99541179,0.954463438,1.09623781,0.351890966,0.6902436120000001,0.0,0.0,0.6696888910000001,0.459574882,0.0,0.0,0.0,0.912350951,0.0,0.158783176,0.10123631699999999,0.468306878,0.638514893,0.0,0.0,0.0,0.0,0.42382972700000004,0.116625149,0.10542102699999999,0.73113511,0.96446941,0.0,0.0,0.0,0.0,0.19863487100000002,0.0,0.4638626,0.0,1.18070327,0.0,0.0,0.0,0.31930576,0.0,0.0,0.0,0.28970608600000003,0.5777439289999999,1.90918237,1.90639935,3.36045254,2.17155689,1.76781559,2.13569932,1.20347594,0.8964665,0.0,0.0,0.438546056,0.0,0.0,0.0,0.0,0.270667055,0.0,0.0274636108,0.434222279,0.45572274700000004,0.0,0.35731282799999997,0.0,0.0,0.131165917,0.118293563,0.0166595184,0.545987593,0.6045327079999999,0.0,0.0,0.0,0.46373765299999997,0.404589586,0.0,0.0,0.0,0.8449224940000001,0.643915255,0.716083375,0.0,1.25668651,1.24973389,1.30313659,0.617332519,0.0982945524,0.203422889,0.013168271499999998,0.357989702,0.856964885,0.0,1.23437224,0.501759661,1.61764654,1.02769286,2.10635182,1.55651303,0.8862160090000001,1.63422382,1.69123086,1.34014273,1.32632762,1.34149876,0.41636344,0.0,1.14130963,0.672760172,0.505546531,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23800000000000002
0.175309038,1.282129,2.44357154,3.23567445,3.44373139,3.17126196,2.75575937,2.55013445,2.71077674,3.12178917,3.4915361000000003,3.5471392,3.19780716,2.57039714,1.91180041,1.43722125,1.22604009,1.21974704,1.30007723,1.3764946000000002,1.42133227,1.44338466,1.44116047,1.38613947,1.25102454,1.0514038,0.85290795,0.7252703779999999,0.675847168,0.6236849520000001,0.45229962100000004,0.117149985,0.0,0.0,0.0,0.57061798,1.67107967,2.67721989,3.16446695,2.93835304,2.15361213,1.23182855,0.620917609,0.542753611,0.885329397,1.30360189,1.45840477,1.23494475,0.7999869890000001,0.46740102899999997,0.47011707,0.796199312,1.19875199,1.36841698,1.14692064,0.635161151,0.124587999,0.0,0.06428869549999999,0.46142675200000005,0.80900191,0.879204445,0.643889385,0.274995732,0.011234551499999999,0.0,0.162266129,0.34251821600000004,0.35319184299999995,0.15466422,0.0,0.0,0.0,0.0,0.258001275,0.35171990200000003,0.209370945,0.0,0.0,0.0,0.0913060394,0.577856842,1.01674391,1.23678557,1.19026595,0.95677972,0.674651355,0.453948801,0.327878946,0.2643745,0.215753904,0.162845311,0.122654662,0.121556549,0.162324906,0.21435822399999999,0.234396579,0.199291854,0.123405,0.046797601900000006,0.00442720722,0.00148339866,0.0143722358,0.0158001083,0.002928527,0.004946014310000001,0.062463244800000005,0.193276294,0.370256426,0.52902322,0.601896905,0.556124527,0.41171716799999997,0.22855688899999999,0.072725558,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0206595043,0.149314761,0.385644805,0.717095081,1.08617479,1.39806755,1.55271992,1.4924110000000002,1.24037217,0.903317191,0.627257097,0.524455165,0.611597553,0.798097794,0.9360648690000001,0.905387061,0.683460139,0.35659666,0.065959173,0.0,0.0,0.0519416794,0.134211398,0.115160297,0.00411908345,0.0,0.0,0.0,0.09186838929999999,0.276313541,0.39790538299999995,0.42837905200000004,0.390790808,0.329947918,0.275542255,0.22639664,0.164268973,0.08125366099999999,0.0,0.0,0.0,0.0,0.0271876921,0.047898561799999996,0.0305539329,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0172672135,0.19550305199999998,0.44730740799999996,0.661743489,0.714556346,0.5519494229999999,0.24229717399999998,0.0,0.0,0.026871856099999997,0.380958023,0.728205696,0.8805162470000001,0.7650439520000001,0.46247946,0.147607004,0.0,0.0,0.0819462657,0.146293655,0.0944522409,0.0,0.0,0.0,0.0,0.126968833,0.19329180899999998,0.11182848599999999,0.0,0.0,0.0,0.0,0.167031921,0.259456529,0.184448163,0.00542954813,0.0,0.0,0.076870799,0.278500384,0.331097721,0.163618646,0.0,0.0,0.0,0.0,0.33272091800000003,0.47958999999999996,0.278413062,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.11686259199999999,0.122728224,0.0133070072,0.0,0.0,0.0148359908,0.101163099,0.0801011398,0.0,0.0,0.0,0.024250158100000002,0.08693655310000001,0.0586430559,0.0,0.0,0.0,0.0336201343,0.0878532619,0.0522024734,0.0,0.0,0.0,0.0844635266,0.257505166,0.352331897,0.31997312,0.190371601,0.0433360109,0.0,0.0,0.0,0.0276827773,0.0358221302,0.0089696331,0.0,0.0,0.0,0.023641875,0.0294165056,0.00432840745,0.0,0.0,0.0,0.0340174314,0.0383587087,0.0,0.0,0.0,0.0051521805799999995,0.0966072407,0.164055789,0.17189183,0.133177181,0.08979697460000001,0.0683718655,0.0581758707,0.0326585612,0.0,0.0,0.0,0.016557081499999998,0.0531178877,0.0356524302,0.0,0.0,0.0,0.0337538697,0.0799425557,0.0436013004,0.0,0.0,0.0,0.0647182607,0.125661941,0.0663017497,0.0,0.0,0.060274720700000006,0.25679255,0.294399431,0.0766039422,0.0,0.0,0.930391733,2.62180231,4.45727265,5.61784536,5.56037719,4.35846288,2.63262914,1.13341627,0.29500517,0.0707566618,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18827706100000002,0.17395757,0.23735612,0.391617954,0.589865609,0.734292272,0.724404838,0.5216111139999999,0.19311471100000002,0.0,0.0,0.17820477,0.869812125,1.75656119,2.55642049,2.98917909,2.89479338,2.30290133,1.41999442,0.539937674,0.0,0.0,0.0,0.0350751895,0.26040013100000003,0.324169382,0.214328603,0.0181378041,0.0,0.0,0.0,0.004283809570000001,0.0880955559,0.0897402365,0.0341641071,0.0,0.0642020578,0.251688986,0.504260137,0.7058054490000001,0.7413985059999999,0.562237544,0.21981921899999998,0.0,0.0,0.0,0.0,0.219325401,0.585457914,0.799198587,0.796186304,0.608487141,0.33978320100000003,0.110805579,0.0040493058500000005,0.0339940237,0.153432036,0.287399162,0.373820285,0.38988674100000004,0.353800062,0.30576764300000003,0.28194396899999996,0.295876688,0.335062806,0.37077668,0.373226787,0.32409039,0.222983441,0.0891623638,0.0,0.0,0.0,0.175888447,0.589598228,1.13735686,1.69532545,2.09073709,2.15795752,1.8109473999999999,1.10144738,0.23087946899999998,0.0,0.0,0.0,0.39752401,1.61129409,2.77412204,3.50900094,3.58254767,2.99056389,1.95220568,0.816119113,0.0,0.0,0.0,0.0,0.0734641538,0.270490095,0.26097405,0.10769487,0.0,0.0,0.0691382241,0.33370961600000004,0.5869252229999999,0.700790602,0.618109688,0.383865186,0.123212832,0.0,0.0389712805,0.295454492,0.6460505529999999,0.943916313,1.06546553,0.96496846,0.691020174,0.35975467200000005,0.100314291,0.0,0.0726748755,0.26613870100000003,0.49436917,0.682458245,0.797786205,0.85538161,0.897828807,0.962762234,1.05594855,1.14372651,1.16801207,1.07577705,0.8482776329999999,0.516046755,0.152800341,0.0,0.0,0.0,0.0,0.218970936,0.57919274,0.915838356,1.18082343,1.35499594,1.44268176,1.4589913,1.41727679,1.32288993,1.17539224,0.976669482,0.739297787,0.489487506,0.261959574,0.08862589380000001,0.0,0.0,0.0,0.0,0.0035961563200000005,0.00445502056,0.0,0.0,0.006904735290000001,0.0264425363,0.0359435108,0.0176584777,0.0,0.0,0.0,0.0,0.142569185,0.44514507200000003,0.8320575440000001,1.24928246,1.64589456,1.99267598,2.28577078,2.53339195,2.73412919,2.86160759,2.86788257,2.70752508,2.37124875,1.90974124,1.43060216,1.06396425,0.909425374,0.989130403,1.23182188,1.49920536,1.6451964,1.58117442,1.31581893,0.949587483,0.62607293,0.46405155,0.503659059,0.69258232,0.917316902,1.06146985,1.06007008,0.922682673,0.716346626,0.5216033379999999,0.388681616,0.318708947,0.27830171600000003,0.235001612,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.50217534,0.977836185,1.37800825,0.0,0.0,0.0,0.0,0.19470813399999998,1.01930039,0.8156501859999999,0.423966509,0.0,0.0,0.0,0.0,0.7542035970000001,0.9215129759999999,0.40444857100000003,0.673103973,0.0,0.19309607899999998,0.36207361200000004,0.320955377,0.0,0.0,0.09361345039999999,0.0,0.168128688,0.32069633,0.0715725073,0.0,0.253400165,0.20798032100000002,1.2410549,0.7514934059999999,0.0,0.0,0.156003717,0.0,0.732717719,1.10742716,2.23387527,2.8582652000000004,3.13467701,3.61235232,2.52736581,2.62586212,0.8043503470000001,0.0,0.0,0.6643052389999999,0.00885429907,0.0,0.335640262,0.0,0.0,0.0,0.585653974,0.0,0.694235143,0.9095034340000001,0.598833911,0.161868292,0.0,0.155087318,0.0,0.7714223440000001,0.192336791,0.161772729,0.0,0.23258461800000002,0.23963267600000002,0.0,0.181601176,0.754037275,0.0,0.9196558440000001,0.0,0.0,0.09259329599999999,0.318125125,0.563327373,0.25779657,1.5423996000000002,0.0,0.0,0.0,0.0,0.0,1.13731903,4.87681091,6.34731036,7.72870958,6.61806844,4.57498549,1.93160201,0.902581915,0.0,0.0,0.0,0.0792261919,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0175931047,0.49979026299999996,0.0,0.296698962,0.0,0.48570317799999996,0.0,0.47059033200000006,0.6865081409999999,0.348369524,0.108200601,0.898814826,0.22133347399999997,0.0,0.668403344,0.711244324,0.737438609,0.13718191300000002,0.0,0.752872877,0.0,0.39315578700000003,1.04214164,0.972922682,0.48653264399999996,0.0,0.792507649,0.0,0.0,0.547003589,0.17514055399999998,0.0,0.38739257,0.30343942100000004,0.0,0.0,0.467603142,0.0,0.41216350700000004,0.508291731,0.517405015,0.0,0.0,0.31074872600000003,0.0,0.035736225499999996,0.0,0.0153095567,0.0,0.409112354,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24068101100000003,0.0,0.0,0.393298221,0.0,0.0,0.0,0.5844215770000001,0.0,0.0,0.0,0.0,0.18283189,0.0,0.0,0.151150392,0.0,0.0,0.6422723539999999,0.10437378900000001,0.448526214,0.0,0.8967570290000001,1.33222938,0.6785995840000001,1.14709852,0.314086459,0.33629213700000005,0.842293453,1.06090909,0.634744096,1.74993381,1.29350003,1.79349865,1.14008691,1.13214851,1.49071974,1.76098593,0.581922638,1.4551403,1.39435325,1.97068374,1.3498146999999998,2.03976778,1.95144697,1.85677922,2.53578265,1.92920884,2.18168051,2.80608788,1.83720047,3.05440139,1.97198917,1.73019925,2.83151525,2.17035711,2.13181815,2.38693897,3.15720108,2.62626658,2.14142358,2.52325987,2.07552016,1.84558801,2.60943807,2.0351151,3.06244907,1.88558199,1.94884381,2.12920867,1.41347682,2.08280616,1.542584,2.11118436,1.38155637,1.59166691,1.5527843000000001,1.73117058,1.58719784,1.71135373,0.7462342909999999,1.2398101000000001,1.25057585,0.7924395559999999,1.53765025,0.0294781339,1.83136424,0.220587292,0.410047072,1.12091369,0.23864834,1.16059132,0.0,0.0,0.0,0.165047942,0.0,0.0585943191,0.201641906,0.0,0.31744970100000003,0.630069122,0.0,0.0,0.0,0.787233152,0.0,0.0,1.15774677,0.152591135,0.28530643899999997,0.0,0.158856637,0.0,0.0,0.365548087,0.0,0.0,0.0,0.0,0.135714465,0.0,0.167450874,0.000763332583,0.49449768899999996,0.40434542700000004,0.0,0.0,0.0,0.0,0.0,0.37409261299999996,0.384816106,0.0,0.0556616471,0.0,0.20144212,0.0,0.237441055,0.321186233,0.0941213786,0.0,0.0976616932,0.40306630299999996,0.636495382,0.0,1.08310993,0.0,0.8457321259999999,0.043281319400000004,0.0756810502,0.0,0.17290841399999998,0.64518879,1.04726994,0.715022523,0.240679725,0.0,0.0,0.0,0.0,0.257064319,0.0658290432,0.0,0.026911217299999998,0.873710494,0.139053179,1.1767208999999998,0.0,0.509148175,0.40997354799999997,0.630627423,1.15127916,0.36424466,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.169690409,0.503522504,0.618887689,1.02180872,1.74585932,2.26546025,2.38976521,2.73498878,3.2924468,3.14590307,3.24338652,2.90087354,2.16236147,1.86999074,1.44507675,1.05957305,0.965475961,0.30463043100000003,0.12495789199999999,0.079412904,0.168106913,0.0,0.0,0.0,0.0,0.012646476100000002,0.326610512,0.34206341,0.613591165,0.357205616,0.38425165,0.0644663647,0.220120211,0.15336570300000002,0.013206225700000001,0.516981669,0.0541944862,0.289117364,0.435542805,0.448594315,0.45357665700000005,0.0,0.0,0.0543156516,0.0,0.435210445,0.53656507,1.45133886,1.43065908,1.98722033,2.55532608,2.51761046,2.30963604,1.70656852,1.42335647,0.605180018,0.5407657779999999,0.0,0.0,0.0,0.208133669,0.424801781,0.571570613,0.43255742700000005,0.549521329,0.24553065,0.0689719386,0.522577242,0.0,0.298782229,0.290456102,0.423023549,0.052544445099999997,0.0,0.0,0.248742441,0.0,0.0,0.029559231499999998,0.0,0.336727965,0.468914833,0.0242661162,0.12719260699999999,0.38670736299999997,0.359837523,0.356356155,0.0,0.0,0.09887239449999999,0.333857948,0.526947411,0.43598157200000004,0.0558554795,0.489672648,0.20696094899999998,0.0,0.0,0.056379827,0.0,0.269550701,0.193267942,0.563700211,0.554892443,0.455257316,0.372964801,0.380473501,0.00745880193,0.18065592,0.29796932,0.265516488,0.49094550299999995,0.5358144189999999,0.300975228,0.7205995070000001,0.357476694,0.5785291920000001,0.498603512,0.44718654799999996,0.687808078,0.610266246,0.636322161,1.04995501,0.55519633,0.953134335,1.08614011,1.01343231,1.4353619,1.07210232,1.11979195,0.952996507,1.17201833,0.766340318,0.718191947,0.404771001,0.317492599,0.0134511635,0.383901045,0.0,0.284300973,0.327372047,0.0,0.0768340359,0.0,0.149038296,0.0,0.0,0.0,0.494379561,0.42382887799999996,0.7011076970000001,0.534652235,0.390836309,0.62300765,0.691557889,0.6247018910000001,0.464311532,0.140136291,0.560922511,0.117015298,0.164643997,0.111326874,0.0218798038,0.334309139,0.308269815,0.628746445,0.690502608,1.31679735,1.1505424,1.16929826,1.09500144,1.51184769,1.2118817,1.11114418,0.846572159,0.6283746139999999,0.608919325,0.798149058,1.13468979,0.896283576,0.796595672,1.14702436,1.34311263,1.17691896,1.02437011,1.12268048,0.6587076239999999,0.621705427,0.768928363,1.03186953,0.813002454,0.909444198,0.933797384,1.0731926999999999,1.24632113,0.977987022,1.00361818,0.7412481870000001,0.201834515,0.0,0.054191354000000004,0.0,0.0,0.274305627,0.0,0.0,0.0,0.296851441,0.138150947,0.0,0.178405736,0.17121683,0.312418943,0.00046068606500000004,0.0,0.0990409776,0.0492923266,0.198647375,0.221506512,0.0,0.0,0.0,0.00370663258,0.0791444115,0.355116075,0.04927744059999999,0.0,0.19137819600000003,0.221189506,0.0,0.19089156699999998,0.0871679833,0.204596045,0.384107531,0.132406065,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0546821295,0.11354028,0.150663286,0.15663331,0.13166078,0.08512287689999999,0.032550048399999996,0.0,0.0,0.0,0.0301618821,0.08973102359999999,0.150850105,0.197245985,0.21686033899999999,0.205302994,0.167136973,0.114630495,0.0643123361,0.0322759006,0.0295285672,0.0586807787,0.112913642,0.177549758,0.233844582,0.264005504,0.256098229,0.20751040199999998,0.126010748,0.028072426400000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0676313412,0.127224334,0.151102202,0.132931312,0.0776073655,3.02758363e-16,0.0,0.0,0.0,0.0,0.0,0.013294697900000001,0.10480076599999999,0.17754473699999998,0.213425792,0.203613176,0.150940796,0.0693641624,0.0,0.0,0.0,0.0,0.0,0.0643274314,0.19069784399999998,0.31262476,0.40714844200000005,0.45770259399999996,0.457473975,0.41029152799999996,0.328956103,0.23157070100000002,0.13690978199999998,0.0600553001,0.00938735087,0.0,0.0,0.0,0.00124132099,0.00529489159,0.0011592228100000001,0.0,0.0,0.0,0.0,0.019075468300000002,0.0546821295,0.091589652,0.11935579800000001,0.128718158,0.11462468099999999,0.0782038659,0.027013522400000003,0.0,0.0,0.0,0.0,0.0,0.0171564084,0.0769552899,0.123884292,0.144481965,0.132095704,0.0890612184,0.026473954100000002,0.0,0.0,0.0,0.0,0.0,0.0673131049,0.165570215,0.258921374,0.338219041,0.405753711,0.477285807,0.5802431929999999,0.7480516970000001,1.01159681,1.38967663,1.88076735,2.4583402999999997,3.0713277000000003,3.65025572,4.11828264,4.40519061,4.461566599999999,4.2701772,3.85196898,3.2651380000000003,2.59709818,1.95064018,1.42679124,1.10759435,1.04206867,1.237986,1.66093944,2.24074491,2.88381015,3.48902036,3.96413685,4.239772,4.27864248,4.07884509,3.67110443,3.11105028,2.46837931,1.81511025,1.21503091,0.715938451,0.34554199,0.111111642,0.0022873683399999996,0.0,0.0624613208,0.17068169600000002,0.293415422,0.410308995,0.509533011,0.587844724,0.6493523379999999,0.703304385,0.761254285,0.833967723,0.928469435,1.0456603,1.17894494,1.3142527,1.43167757,1.50869817,1.52460048,1.46538143,1.32815472,1.12400103,0.878363848,0.628495445,0.41804704600000003,0.289554404,0.276143586,0.39412005899999997,0.638097756,0.9799378670000001,1.37205433,1.75474367,2.06630632,2.25405301,2.28400151,2.14725388,1.86168111,1.46850305,1.02442709,0.590957764,0.22309142199999998,0.0,0.0,0.0,0.0,0.0,0.0856767985,0.18029332,0.226004558,0.216680683,0.161707086,0.08162319,0.0015026167,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.36853569,0.38536496,0.25718275,0.0,0.0,0.60168511,0.0,0.19637415,0.0,2.22134494,14.18740279,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.665913768,0.23563706199999998,1.16871235,0.488423129,0.0,0.327976567,0.0,0.0,0.278517279,0.89691025,0.33745912,0.0,0.0,0.0898424169,0.0,0.0,0.0,0.0,2.20320754,0.34264231799999995,0.0,0.0,0.0,1.50005555,0.0,0.0,0.0,0.0,0.0,0.467856825,0.0,0.0198239695,0.199422879,3.77654859,3.71024011,1.35204246,0.917313246,0.8604285690000001,0.0,0.605534884,0.0,0.0,0.4001361,0.9527119270000001,0.0,0.0,0.0,0.0,0.44162822,1.36718164,0.18490456800000002,0.991169069,0.731391043,0.152510525,0.524074209,0.0,0.0407254796,0.0,0.0709124412,0.23731544100000002,0.248935127,0.397494577,0.0,0.657718638,0.37532033,0.0,0.452836762,0.0,0.233508424,0.0,0.312342247,0.0,0.0,0.976450038,0.0,0.949288219,2.7813293999999997,0.6594873520000001,0.0,0.0,0.0,0.92094198,0.676407347,0.324798439,0.88257217,0.255316694,0.0,0.649323264,0.0,0.0,0.0,1.0353690999999998,0.0,0.0295161877,0.536395238,0.0,0.327615229,0.0,0.0,0.720647789,0.6916287409999999,0.0,0.274173268,0.0792048167,0.0,0.0,0.704745622,0.0,0.0,0.688978359,0.0,0.801790914,0.0,0.0,0.66761605,0.0,1.18095354,0.719709422,0.518537252,0.0220338508,0.875943076,0.465790924,0.787026028,0.431618678,0.0,0.0,0.16822322,0.0,0.28186477600000004,0.0,0.347107815,0.0,0.7670121670000001,0.0,0.166494311,0.121449184,0.0,0.101218307,0.0,1.09390949,0.546914482,0.0,0.0,0.0,0.647864789,0.0,0.0,0.5832891570000001,0.0,0.0,0.0,0.328235049,0.924912415,1.29896304,0.0,0.6945434109999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0792845657,0.0612328967,0.04518777190000001,0.00867364413,0.37889316799999995,0.0,0.0,0.145946514,0.0,0.356866491,0.0,0.0,0.0,0.0,0.0,0.031272332,0.0,0.18761069100000002,0.16861977600000003,0.0,0.0,0.0,0.0,0.0311039326,0.0,0.0,0.0,0.0754826883,0.217757809,0.0324769323,0.0,0.198532106,0.275110509,0.0,0.103999494,0.026448691,0.0,0.0,0.0,0.184651753,0.07073152070000001,0.210884321,0.109507614,0.326993355,0.178746675,0.0330059871,0.08020473339999999,0.36104624399999996,0.34447913700000005,0.314475472,0.37341522,0.0972518084,0.0,0.0,0.0784454609,0.0,0.0829397369,0.212250672,0.11430598300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.242531771,0.290811809,0.123043616,0.46439942100000003,0.025291514900000003,0.344643374,0.5892413670000001,0.371849475,0.0922944849,0.264997201,0.529007975,0.289013833,0.0,0.409870254,0.30627089399999996,0.121911017,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0805900675,0.0,0.321747568,0.337862813,0.6225314439999999,1.33339682,1.2158459,1.72675015,2.17522836,2.36392397,2.24982792,3.01357976,2.80097386,3.07422879,3.14521071,2.88318564,3.27916284,2.9536751,3.02678583,2.79580843,2.86766385,2.67278598,2.44264784,1.9417244999999999,1.45690049,1.40495131,1.30679293,0.8998619259999999,0.70475361,0.46582283700000005,0.0,0.0,0.0339551072,0.0,0.0,0.0,0.0,0.0,0.0,0.025663852999999997,0.29589831699999997,0.050992853899999996,0.5799195079999999,0.619391987,0.264665695,0.7225778429999999,0.49992611299999995,0.50946166,1.07653844,0.5645361879999999,0.619308226,0.602360617,0.8948355290000001,0.435204817,0.673294025,0.600249193,0.570279674,0.257832482,0.368017508,0.315374955,0.0393181468,2.62295038e-05,0.0,0.0,0.0,0.0,0.0,0.0,0.0380525205,0.0,0.0,0.030193005800000002,0.0,0.0,0.13486514300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.6631271479999999,0.0,0.399328275,0.252444664,0.696113355,0.474727445,0.524376608,0.0,0.244485443,0.0,0.15528802,0.0,0.0776906526,0.0,0.0452050024,0.560166952,0.40034809299999996,1.78619668,0.73488284,0.0,0.256880748,0.0,0.16188044699999998,0.0,0.112301363,0.0,0.0777946022,0.0,0.049901779,0.0,0.0246125858,0.0,0.0,0.017312478899999997,0.0,0.06586156559999999,0.0,0.37108061299999995,2.08039573,0.0,0.140643701,0.0,0.09008490150000001,0.0,0.0944028984,0.0,0.147101073,0.0,0.333584907,0.0,2.20122707,3.25369742,0.0,2.41142698,0.0,0.632401201,0.0,0.7340390609999999,0.0,3.63247071,1.06354544,0.0,0.0,0.163201168,0.0,0.265738741,0.0,0.40272736,0.0,0.390209053,0.0,0.48519858200000004,0.0,0.62629313,0.0,0.929198321,0.0,3.06952892,2.59307969,0.996341521,0.40905927700000005,0.022714626800000002,0.0,0.37966857299999995,0.0,0.7424406570000001,0.0,1.4992173,0.0,8.43812053,6.72919299,0.0,1.28368293,0.0,1.20688641,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.21330035100000003,0.35586126799999995,0.448506852,0.463679444,0.400178209,0.282333817,0.15002923199999998,0.0434274549,0.0,0.0,0.0233526459,0.0641168117,0.0813652589,0.060749013,0.008083668549999999,0.0,0.0,0.0,0.0,0.0118637384,0.0787388354,0.113265108,0.0989594652,0.041226322200000005,0.0,0.0,0.0,0.0,0.0745882182,0.197380015,0.29151916699999997,0.324851711,0.29035480199999997,0.210427127,0.128489741,0.0907585299,0.125519504,0.228840452,0.36351445,0.472811004,0.504313979,0.43434652799999995,0.282359906,0.10795785699999999,0.0,0.0,0.143071807,0.39916102200000003,0.672129084,0.849117097,0.839180066,0.61595926,0.24150228199999998,0.0,0.0,0.0,0.38613511799999994,1.37451064,2.60459187,3.81889696,4.73353464,5.11925346,4.86999753,4.03681431,2.81573836,1.49300279,0.364623401,0.0,0.0,0.0,0.316207927,0.975409218,1.50428773,1.76369035,1.71634759,1.42174972,1.0013369,0.589042438,0.285560837,0.13137358400000002,0.10528005,0.145325505,0.18128922600000003,0.16493021,0.0866613425,0.0,0.0,0.0,0.0,0.0,0.056421614800000006,0.140085357,0.162450084,0.11544648800000001,0.0205670602,0.0,0.0,0.0,0.0,0.009848622270000001,0.101408071,0.148925948,0.132716678,0.0599527262,0.0,0.0,0.0,0.0,0.0,0.07341968780000001,0.162451073,0.20126136600000002,0.179105058,0.109369541,0.0231493106,0.0,0.0,0.0,0.0165341108,0.0766935648,0.10814531599999999,0.0931033398,0.0347632721,0.0,0.0,0.0,0.0,0.0792263528,0.26759065600000004,0.47933001700000005,0.6819302279999999,0.8506148440000001,0.972883662,1.04717814,1.07732751,1.06624666,1.0124691,0.9114914740000001,0.7613394379999999,0.569434061,0.35684384799999996,0.156866809,0.007289526390000001,0.0,0.0,0.0661159224,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18693408,0.0,0.02638216,0.16045003,0.25058026,0.32606149,0.39418378,0.37484006,0.18409788,0.0,0.0,0.0,0.08950148,0.48665569,0.51086038,0.0,0.0,0.0,0.0,1.54208479,3.77568255,5.31334453,5.30420816,3.69696738,1.30687696,0.0,0.0,0.0,0.21015727,0.9021046999999999,0.75069028,0.0,0.0,0.0,0.0,0.5226688,0.70804758,0.26538249999999997,0.0,0.0,0.67542671,2.61142351,4.64719514,5.85212486,5.71209701,4.39837835,2.59702192,1.05724923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.26054770899999996,0.292468115,0.30480775,0.2988514,0.279136908,0.252637242,0.227691182,0.21281003199999998,0.215497489,0.24121475,0.292603851,0.36905143700000004,0.466636285,0.5784611620000001,0.695327716,0.8066765140000001,0.9016868570000001,0.9704153990000001,1.00485027,0.999768372,0.95330627,0.867187035,0.746582793,0.599631582,0.43666314700000003,0.269217768,0.10896209400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.16727099e-16,0.0699729396,0.12582697,0.162869848,0.17877838100000001,0.173649868,0.149801106,0.111351235,0.0636459351,0.012594490500000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0188872369,0.0546595344,0.08575170789999999,0.110606123,0.128702333,0.140495116,0.147229656,0.15066600900000002,0.152754728,0.155309563,0.159721244,0.166748912,0.17641403600000002,0.188007115,0.200202165,0.211259841,0.219288838,0.22252825199999998,0.219611718,0.209777433,0.192996102,0.170000309,0.14221219300000001,0.11157995,0.08034566580000001,0.050775901500000005,0.0248910746,0.00422951578,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000249218315,0.000852296167,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0038306350299999996,0.02018521,0.0365677873,0.050634831,0.0600962127,0.0630482193,0.0582784171,0.045498847800000006,0.0254712139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.031726420299999995,0.073396448,0.109652864,0.135644055,0.147384042,0.142303333,0.11966765800000001,0.0808052378,0.0291024156,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.021720018900000002,0.11004060199999999,0.19295858100000002,0.260127884,0.302119834,0.31158637699999997,0.284291213,0.21988953100000003,0.122356979,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14921654199999998,0.48609938,0.873965056,1.29298424,1.7198768,2.12967355,2.49766714,2.80137814,3.02235844,3.14766789,3.17088949,3.09259098,2.92019302,2.66725935,2.35227888,1.99705662,1.62486611,1.25853611,0.918648083,0.622006839,0.38051708,0.20055657899999998,0.0828861805,0.0230834964,0.0124362416,0.0391877233,0.08999546230000001,0.151447185,0.21147795100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0158474727,0.0,0.238695822,0.194413826,0.0,0.0,0.328612238,0.0,0.30265288100000004,0.0207125014,0.0,3.28002483,0.292416685,0.569884174,0.32531345899999997,0.29411718600000003,0.030916734700000004,0.943833004,5.87328166,0.0,0.142683437,0.0,0.17110048100000003,0.0,0.585224921,0.0,0.46121251700000004,0.0,0.0,0.415905882,0.994143418,0.126384457,1.07457289,0.0,1.08820731,0.0,0.0,0.051488209199999996,0.46547822200000005,0.0,0.0,0.0746958025,0.574447236,0.0,0.288334977,0.716634584,0.249771417,0.0,0.249282885,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.78571082,0.0,2.4366887999999998,0.0,10.13214927,31.20451584,0.0,3.13732772,0.0,2.07109354,0.0,2.42970384,4.7707318,1.80698746,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.263
1.59054747,2.14884299,2.55288006,2.55543416,2.10994353,1.04397422,2.24932196,1.39316416,1.29950406,1.46989079,1.37731121,0.0,0.0,0.13052286,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.26627803,0.45652565,1.16141243,0.95315574,0.86424388,1.86184318,1.23381865,3.07400871,1.45737316,2.21416268,2.50399173,2.25543623,1.7703578999999998,2.42858811,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.250202816,0.0,0.385875364,0.0,0.198858693,2.85752811,2.63057564,0.776989578,0.7082273929999999,0.445709836,0.0,0.0943560165,0.0,0.0,0.0688119522,0.0,0.0815265203,0.0,0.0,0.12452822699999999,0.0,0.072312168,0.0687254746,0.0,0.423826638,0.0,0.0,6.56675332,10.208131,4.47094458,0.0,0.0,0.0,0.924743416,1.45136094,0.126756372,0.215952277,0.634959095,0.0,0.0,0.124038651,0.0,0.10045182400000001,0.0,0.0,0.139546789,0.0,0.0629705367,0.0979475199,0.0,0.87925269,1.62688688,0.09017821279999999,0.0781751883,0.887606468,0.0,0.042453181799999996,1.65625242,0.8743782790000001,0.0,0.055352751,0.0555388993,0.0,0.07238153,0.0,0.039566332200000005,0.166907972,0.048430962699999996,0.0,0.0,0.0,0.0448566966,0.154095875,0.0783726184,0.0,0.0242887717,0.207860015,2.55813689,5.19852071,2.85566196,0.0,0.308756667,0.0103127664,0.0,1.02913603,0.7386611999999999,0.0,0.0613739339,0.0,0.543439941,1.0406860999999998,0.09279972269999999,0.0,0.0660703967,0.0,0.0,0.0,0.0342421892,0.0,0.0100196398,0.0386659418,0.0,0.0880583397,0.0,0.0,0.127062875,0.0,0.113694647,0.0238547561,0.0,0.349419957,0.0,0.0922711724,1.55065502,0.193471158,0.860533399,2.82869422,0.5467611920000001,0.0,0.448941506,0.0,0.0,0.204324893,0.0,0.15318403,0.0,0.0,0.16139858199999998,0.0,0.044700413700000004,0.0559013079,0.0,0.121277193,0.0,0.0,0.0922964706,0.0,0.0785798432,0.0,0.0,0.11197528300000001,0.0,0.0318580315,0.0553275809,0.0,0.142963036,0.0,0.0,0.859787196,1.4442038000000001,1.30462002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.81944272,1.93164335,0.536496601,0.210607732,0.0,0.0,0.09192741460000001,0.544459104,0.0047733386299999995,0.299557068,0.0,0.0,0.0,0.0,0.412826126,0.0,0.0,0.0,0.0,0.0,0.0697850697,0.310558467,0.233422945,0.07255074519999999,0.141976558,0.0753071822,0.21861777100000002,0.0,0.0,0.0,0.0,0.12272049,0.0879957915,0.0,0.0,0.0737705874,0.0,0.0,0.0543068983,0.0,0.0832120408,0.360965088,0.0,0.240823254,0.0379722381,0.304699971,0.0,0.0,0.218822199,0.0,0.00446734639,0.0322344113,0.0,0.0,0.208337656,0.36866586799999995,0.17206946899999997,0.803942231,0.7083947209999999,1.48925515,0.941144353,1.02755683,0.9072040859999999,0.479828806,0.362054361,0.0,0.0,0.0,0.0,0.0,0.0,0.236911663,0.0,0.011811975800000001,0.0,0.208243075,0.0,0.062543111,0.09996802880000001,0.0,0.0,0.00413518292,0.29110697,0.0,0.13083377,0.227812543,0.237686665,0.25288062,0.130818288,0.0873756669,0.0,0.0,0.197036872,0.0,0.235550585,0.0,0.0,0.12823474199999998,0.0,0.220409402,0.0,0.0,0.0,0.329271954,0.292374448,0.463341125,0.236172023,0.530282634,0.460911801,0.154969894,0.0,0.0,0.0,0.0,0.0646944981,0.626941101,0.54977428,0.705198641,0.23811047600000002,0.137927831,0.47232692200000004,0.493233252,0.523657013,0.460793215,0.0,0.028290327,0.0,0.0,0.0,0.43457973200000005,0.258756559,0.07327465059999999,0.0,0.0,0.851987458,1.88311436,2.44776203,3.77761686,3.59439666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.118178801,0.0,0.18507315100000002,0.0,0.696333766,0.0,0.0,0.0,0.0,0.0,0.8955040890000001,0.0,0.704971213,0.0,0.00296227213,0.0,0.0,0.0,0.0,0.0,0.596051669,0.0,0.564593097,0.334975512,0.0,0.0,0.444046227,0.0,0.427079483,0.0444988639,0.0,0.6804540029999999,0.514145351,0.8947009570000001,0.0,0.0,0.0,0.0,0.199268693,0.0,0.0,0.62328588,0.0,0.0,0.0,0.0,0.0740026822,1.01105946,0.562967501,0.449100979,0.0,0.114879681,0.568858442,0.0,0.29650320399999996,0.058572461,0.335751485,0.0,0.0,0.524034185,0.0,0.0,0.9147649729999999,0.0,0.541171857,0.0,0.0,0.612000337,0.643833404,0.0155112908,0.63763685,0.326986385,0.0,0.20698952399999998,0.0,0.0,0.0,0.0,0.0,0.858933113,0.0,0.640326553,0.126388787,0.00340931805,0.0,0.0,0.0,0.0,0.104812318,0.323536997,0.0,0.0,0.0,0.0,0.15361756,0.735684844,0.0,0.0371173655,0.283553154,0.0,0.7458759859999999,0.0,0.496587768,0.7076752959999999,0.0,0.0,0.0,0.0,1.294991,0.5196361079999999,0.8658663940000001,0.622071111,0.648005918,0.0,0.0,0.0,0.8383487279999999,0.0,0.300041966,0.0,0.0,0.0,0.0,0.158073353,0.0,0.0,0.67061848,0.88715156,0.0,0.086269521,0.06732877030000001,0.0,0.0,0.47162861799999994,0.222457035,0.0,0.6413843779999999,0.0,0.572454138,0.042437928300000004,1.95205522,0.307401965,0.21210390199999998,0.898068344,0.0,1.31174029,0.916316672,0.0,0.0,0.810914516,0.22360017699999998,0.0,0.60911764,0.0,0.18743660899999998,0.0,0.12121183699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.774363778,0.767036265,0.23832670399999997,0.0,0.5571742679999999,0.503065169,0.0,0.0,0.21471126399999999,0.0,0.0,0.0,0.461997476,0.41353260799999997,0.30851666,0.783063265,0.0873917582,0.0,0.0,1.49412559,0.000756016519,0.0,0.0,0.0,0.0,1.20360226,0.0,0.27615990100000004,0.8953603840000001,0.185212192,0.030623117000000002,0.0,0.0,0.0,0.012083543899999999,0.0,0.381997207,1.0180787,0.154409441,0.875017415,0.956616063,1.88962725,2.03233092,1.61850299,3.03036681,2.81042819,2.5379976,3.71205645,3.53535012,3.1202217999999995,4.11239909,3.6837271,2.94121155,2.72295817,4.68863552,3.33147753,2.47697249,1.84842222,2.79162926,0.948442958,1.56021585,0.0,1.0496657,0.144225358,0.0525755629,0.308892098,0.414922876,0.0,0.0,0.476399446,0.0,0.0,0.0,0.233676434,0.784638851,0.541187007,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.26214104899999996,0.061427887699999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.584941864,0.37625640299999996,0.710528585,0.911739637,1.37002137,1.82474712,1.40773771,1.62562538,1.96804188,2.41842065,2.91318553,2.67683694,2.93198048,3.6114818,3.66725262,3.64712241,3.33461494,3.6088658,3.8684267999999995,3.28886981,3.79496413,3.29629284,3.6040793,3.10846895,3.33482015,2.56062099,2.69509084,2.60026253,2.24922508,1.80481121,1.37331589,1.05150651,0.858466849,0.43215032299999995,0.180894138,0.386211611,0.0,0.0,0.000576383962,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.050703455,0.0,0.114596049,0.430921988,0.09458175070000001,0.0630102214,0.33538639,0.108648306,0.5394885420000001,0.22549158600000002,0.000683785589,0.542097264,0.22473867100000003,0.37556745,0.0,0.0,0.0,0.029821355,0.0839332909,0.0,0.0,0.0,0.0,0.0034642345299999997,0.104040108,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.345200756,0.184530802,0.358930184,0.19435165100000001,0.0,0.20799330600000002,0.21572281,0.43098045100000004,0.0,0.0,0.528084373,0.306935935,0.52284324,0.0,0.360603295,0.39291072,0.0,0.0804785971,0.398892026,0.0,0.520491579,0.0,0.0,0.172116674,0.183372965,0.0,0.09466874800000001,0.0,0.163707927,0.0039058148,0.117273924,0.0,0.0888307043,0.28779368,0.0545608666,0.0836624299,0.163046729,0.0,0.0830320412,0.0,0.0,0.10730340599999999,0.0,0.0,0.0443170607,0.0,0.0,0.0,0.0,0.160964423,0.0,0.0,0.0,0.179834408,0.0,0.0382037349,0.34410661200000003,0.0,0.392322669,0.0832294277,0.480898285,0.631758147,0.202737561,0.43729539700000003,0.566918163,0.533169527,0.251349088,0.09777055289999999,0.175214612,0.021875855099999997,0.137275442,0.0,0.012119366999999999,0.23994909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.83083682,0.0,30.75420908,6.38865398,10.63123853,19.60550435,0.0,2.12272772,0.8426962,3.26109344,0.0,0.0,0.68780646,0.0,4.35568729,0.54901397,8.73162534,0.69982039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.265
0.688343684,1.55519215,1.95128972,0.951307845,0.0,0.0,0.0,1.65479877,0.0,0.168919583,0.261451259,0.110030238,0.7790658,0.0373982143,0.0,0.0,0.022714036400000002,0.307371705,0.0,0.449683271,0.8611791959999999,0.0,0.946370188,0.0,2.03965353,2.56336206,1.46187405,0.44567736700000005,0.0,1.04398123,0.07413978610000001,0.100492926,0.0,0.0,0.0,1.19408933,0.198960743,0.559566851,0.0,1.31098462,1.683266,0.0012164310899999999,1.79953575,0.0,0.0,0.917055286,0.0,0.0,2.07841761,1.27477564,0.0,0.0,1.18599769,0.0,0.0,0.7581481179999999,1.17912005,0.45792853899999997,0.131461079,0.909785152,0.0,0.0,0.929893412,0.0,0.0,3.28794323,0.25054179600000004,0.37100499299999995,1.24848314,1.08956863,0.99209386,0.0,0.298588482,0.0,0.0,0.47713431700000003,0.0,0.0,0.598526628,0.0,0.0,0.0,3.15826426,1.27851792,1.26340429,1.51135775,0.7986490740000001,1.48868984,0.8914714640000001,1.23652035,0.0,0.0,0.385057858,0.34237532,0.770662339,0.0,0.0,1.00088246,0.0,0.0,0.8530346209999999,1.71244696,1.89671872,1.61171492,0.641403826,0.0,0.871291423,0.9468308320000001,0.141743772,0.0,0.344517216,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.69858361,0.820650665,0.9714297479999999,1.13740087,1.29096947,1.39865874,1.43182521,1.37589117,1.23490852,1.0301573,0.793672032,0.559265187,0.35421674299999995,0.194202223,0.0825702115,0.013383693600000001,0.0,0.0,0.0,0.0,0.0,0.013862941200000001,0.033292851,0.0427462733,0.0367766076,0.014718410800000001,0.0,0.0,0.0,0.0,0.0,0.0220685094,0.0705038967,0.09852516210000001,0.0913385634,0.046037361799999996,0.0,0.0,0.0,0.0,0.0,0.028193356200000002,0.150009008,0.247737403,0.287570478,0.253695451,0.155736459,0.027354731299999997,0.0,0.0,0.0,0.0064187396999999995,0.150937229,0.270285952,0.304058919,0.21591423899999998,0.011867983300000001,0.0,0.0,0.0,0.0,0.0,0.54375702,1.29910356,2.04552846,2.62573699,2.91052356,2.83343522,2.40919289,1.73033038,0.942902224,0.20826992800000002,0.0,0.0,0.0,0.0,0.0,0.157142203,0.343164432,0.38311159,0.286232799,0.10461244800000001,0.0,0.0,0.0,0.0,0.0,0.0525789904,0.160328996,0.199896837,0.16469577900000001,0.0755593003,0.0,0.0,0.0,0.0,0.0,0.10150847199999999,0.185819402,0.22333778399999998,0.204129657,0.137817841,0.0489166287,0.0,0.0,0.0,0.0,8.69001242e-18,0.053150338899999997,0.0844067093,0.0833979825,0.052469357599999995,0.00475865621,0.0,0.0,0.0,0.0,0.0,0.031120777599999996,0.0562630191,0.0595855877,0.0414724436,0.0098517772,0.0,0.0,0.0,0.0,0.0,0.018279888799999998,0.0420088747,0.053257291799999995,0.0508209323,0.039174775,0.0272710361,0.026292015800000002,0.0470937205,0.0979485753,0.18290790199999998,0.300832697,0.445017305,0.6033827420000001,0.759359899,0.8936695290000001,0.9871067029999999,1.02411927,0.9965297940000001,0.906386118,0.766853624,0.600411857,0.434356804,0.294523973,0.198907433,0.153131439,0.149350078,0.169157301,0.18977932600000003,0.191644435,0.164829509,0.112139421,0.0476592052,0.0,0.0,0.0,0.0,0.0453610569,0.0843432709,0.0950544841,0.0682945081,0.00990490162,0.0,0.0,0.0,0.0,0.0,0.0719222619,0.1486527,0.176172487,0.137877222,0.0407291054,0.0,0.0,0.0,0.0,0.0,0.102704362,0.26550213,0.35044958600000004,0.30984942600000004,0.134429038,0.0,0.0,0.0,0.0,0.0,0.243012652,1.02054982,1.90183069,2.73837228,3.38401715,3.72950614,3.72732855,3.40031592,2.83225136,2.14394255,1.46216009,0.89040703,0.489290806,0.2708251,0.206499194,0.24488291199999998,0.33213698199999997,0.428704065,0.517508638,0.602346662,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.37721046399999997,0.9114792140000001,0.172269273,0.0,0.33690683200000004,0.477086357,0.503854198,0.242703148,0.259963315,0.442228202,0.0,0.0,0.0,0.0,0.277312307,0.0,0.0,0.411912031,0.619802756,0.0,0.335656932,0.0423584956,0.0880014191,0.14622760699999998,0.0,0.0,0.439372224,0.21566372600000003,0.5621884979999999,0.281458517,0.0,0.0,0.443508445,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.482036908,0.0,0.0,0.538442445,0.0,0.200836055,0.09265523349999999,0.18120330899999998,0.09912510029999999,0.0,0.0,0.494017241,0.596544693,0.0,0.16779631899999997,0.043230994,0.0,0.294140731,0.09421439300000001,0.0,0.0,0.0,0.0,1.19521642,0.96127377,0.8280354109999999,0.590402502,0.718301133,0.11349888400000001,0.499851874,0.0,0.0061188161100000004,0.024673512400000003,0.9274492590000001,1.6525421000000002,1.83329097,2.37328763,2.66154214,4.20213513,5.03799193,5.09128486,4.4047537000000005,3.77068556,2.62612927,3.27977508,4.00349995,3.13383618,1.93771613,1.53397223,0.239709725,0.39989602799999996,0.0457580591,0.41331229700000005,0.55578207,0.276834672,0.0,0.318353112,0.890911789,0.21569809199999998,0.0,0.0974757138,0.10590628699999999,0.0,0.0164215529,0.199475793,0.443584276,0.285450987,0.0,0.0,0.0785480829,0.42956753,0.23124556100000002,0.251420977,0.0,0.554998116,0.0,0.7238014359999999,0.0,0.625631508,0.653184754,0.111591096,0.0,0.603924899,0.0,0.729121428,0.27562133,0.0,0.349161196,0.0,0.338306547,0.26456965,0.0,0.0,0.153974236,0.0,0.0,0.0,0.0,0.0,0.0,0.0440327749,0.0,0.5130897179999999,0.207606421,0.0,0.0,0.355349597,0.0,0.0706912534,0.539409909,0.245572917,0.367262194,0.0410980855,0.23552854199999998,0.0,0.0,0.109967828,0.609527994,0.0,0.0,0.0,0.34630920299999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.394383484,0.537329455,0.5455337029999999,0.41865016,0.25434044699999997,0.17837614,0.251690211,0.426251896,0.582915424,0.619767817,0.521737301,0.360766026,0.233104068,0.18798968300000002,0.202611409,0.21541396399999999,0.18245931699999998,0.108764821,0.0346798442,0.0,0.00629271647,0.0453848755,0.0985958711,0.161313603,0.231097405,0.29014472399999996,0.304684291,0.249143428,0.1351598,0.015422253899999998,0.0,0.0,0.0452570679,0.110352108,0.119716553,0.0749983949,0.0186900324,0.0,0.006219084770000001,0.0275673479,0.024830733100000002,0.0,0.0,0.0,0.0,0.031075160299999998,0.0312032204,0.00410851902,0.0,0.014462256599999999,0.07956146559999999,0.132240184,0.120964419,0.0421931068,0.0,0.0,0.0,0.031546439700000005,0.0683858825,0.038114212,0.0,0.008709546720000001,0.13794507,0.3206909,0.433961004,0.385663052,0.197191742,0.0,0.0,0.0,0.103886159,0.140765278,0.0428435196,0.0,0.0,0.0652208056,0.39041709,0.668209895,0.74410477,0.61970445,0.442984785,0.36885676,0.412726166,0.43406908,0.27687032,0.0,0.0,0.0,0.295787613,1.12372538,1.84637183,2.16064785,2.0982228,2.02425122,2.36183791,3.24149861,4.35122083,5.12098929,5.11922783,4.36807247,3.33772933,2.62011791,2.52317894,2.88278399,3.2188041000000003,3.10191678,2.45031329,1.54797071,0.800475954,0.438352278,0.394383484,0.42245865200000005,0.33068815,0.127799827,0.0,0.016675409199999998,0.226812092,0.436381026,0.47255373799999995,0.303804213,0.058540834900000005,0.0,0.0,0.0553527972,0.13453289300000001,0.0889739711,0.0,0.0,0.0,0.0184336271,0.116446681,0.106689851,0.0,0.0,0.0,0.0,0.10523678300000001,0.159990415,0.11994250699999999,0.0496346362,0.042883996699999996,0.136870715,0.277899666,0.367742743,0.34806088399999996,0.24859415199999998,0.158899146,0.151120486,0.222274353,0.304276641,0.32883695,0.287472589,0.23443669399999997,0.23307834300000002,0.295787613,0.37098149399999997,0.386971658,0.312521404,0.18146661600000003,0.0626922508,0.00470865447,0.00337131574,0.0170580665,0.0102778614,0.0,0.0,0.0,0.0156857696,0.038792301,0.0263719471,0.0,0.0,0.0,0.00602412233,0.038605711699999996,0.0356857013,0.0,0.0,0.0,0.0,0.0303223164,0.0374815656,0.0106176374,0.0,0.0,0.0,0.013920376399999998,0.0191097346,0.0046679059899999995,0.00413590202,0.050489428200000006,0.13749482300000002,0.21437460100000003,0.225529958,0.164232316,0.09081014289999999,0.0919875268,0.209071072,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.39134549,0.0,0.35139314,0.22861452,2.02131913,1.33085204,0.0,0.15892942,0.52086783,0.0,0.0,0.0,1.55870988,0.0,0.51388082,1.55279765,0.14223533,0.0,1.08627832,0.31266266,0.0,0.94756052,1.35044639,1.92056532,0.47666855,0.0,0.86957612,0.83168315,0.0,1.65276113,0.40402297,0.0,0.0,0.0,0.0,0.0,0.0,1.44262768,0.0,0.64882765,0.0,0.0,0.0,0.0,0.67352004,0.19498626,0.37918287,0.0,0.47322061,0.0,0.0,0.0,0.0,1.25646336,0.0,0.64565207,0.44693824,0.0,1.37485316,1.17392108,0.42285961,0.0,0.0,0.9507207000000001,0.0,1.13663811,0.0,0.0,0.0,0.0,0.0,0.0,0.04938961,1.20104794,0.0,0.29811989,0.91218557,1.55614643,1.05750088,1.01557295,0.0800679,1.4266801000000002,0.02758019,1.83656075,0.21380941,0.0,0.0,0.21148368,0.0,0.0,1.68866599,0.0,1.14116866,0.0,1.75255864,0.33656382,0.12434977,0.69180469,0.47669768,1.3912639,1.39701536,0.31859612,0.0,0.0,0.0,0.74394893,0.0,0.0,0.58973712,1.98965137,0.67298776,1.7723291,1.80122059,1.31045679,1.9919046000000002,3.81092713,4.918101200000001,3.40814706,3.98903491,3.99717047,3.64752055,3.978054,5.23870719,2.93756943,2.93435467,2.65140633,0.0,0.0,0.97326727,0.0,0.0,0.15648896,0.0,0.0,0.0,0.0,0.82635571,0.0,1.47462039,0.50288017,1.60409046,2.14225737,2.68418623,1.32835988,3.31897466,3.47039659,0.48270137,1.523317,0.83676395,0.0,0.67237162,1.04761889,0.79079674,0.0,0.0,0.0,0.28351341,0.0,0.98492243,1.09749572,0.51441404,0.0,0.23915817,0.19408467,0.08753569,1.53600587,0.0,0.0,0.28953707,0.12028699999999999,0.0,0.71278127,0.59502158,0.0,0.06930124,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.04949715,3.07048401,2.66853191,2.03192526,2.26804901,2.04801758,1.8809846000000001,2.14169904,1.44801654,0.9908428779999999,0.672021097,0.300155746,0.166823892,1.35137477,0.0,0.63450507,0.0,0.0,0.0,0.0841994579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.03166106,0.0,0.399285073,0.14719314,0.0,0.0604504527,1.3035181,0.0,1.08672549,0.13583346300000002,0.136261107,0.824083978,0.386189788,0.355384624,0.856852488,0.313430152,0.0,0.0,0.39544741899999997,0.138942481,0.0,0.114908779,0.0,0.0,0.7668248320000001,0.361039527,0.0,0.185900316,0.0,0.0,0.28028880899999997,0.0,0.145867687,0.277829012,0.17515312,0.0,0.593509785,0.945957818,0.0,0.3526901,0.0,0.11129423699999999,0.11704310300000001,0.024834831,0.482507365,0.0,0.0,0.7764587829999999,0.0,0.648439826,0.887739547,0.487843156,0.024320056,0.0,0.00991853838,0.336549449,0.0,0.0,0.431504467,0.0,0.0,0.0,0.354636124,0.0,0.0,0.0,0.203695861,0.421602961,0.011344531299999999,0.0,0.0,0.38468767299999995,0.300328041,0.45634144,0.267705549,0.0,0.0,0.0,0.351167642,0.0,0.528596191,0.0,0.403977507,0.225404475,0.674619697,0.0,0.0,0.490955724,0.197129895,0.191132715,0.713420081,0.12175880900000001,0.0,0.130085414,0.663564348,0.0495281387,0.0,0.0397490363,0.0,0.00974085351,0.0,0.0,0.153213374,0.0,0.0,0.5089760320000001,0.0,0.0,0.0,0.0,0.0,0.0,0.30570693600000004,0.5253209560000001,0.481630193,0.07769318110000001,0.7734034909999999,1.45988964,0.0,0.45381425200000003,0.0,0.0,0.0,0.7387072020000001,1.33480907,0.0,0.0,0.0,0.9841141240000001,0.0,0.0,0.366127004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.19600789600000001,0.0945943502,0.251405745,0.0,0.151198113,0.627257341,0.0,0.170151208,0.9808377159999999,0.462395988,1.06039255,1.16482889,0.8290398170000001,1.70645724,2.21599528,1.81304902,1.98151767,2.03874188,2.89402705,1.61808952,3.07611499,2.91051741,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.289460645,0.538846388,0.477376898,0.0318398715,0.0,0.0,0.157959865,0.42752818600000003,0.5697788970000001,0.0,0.0,0.0,0.0,0.0,0.15921243599999998,0.885801038,0.393244731,0.0,0.0,0.0,0.119759306,1.02150537,0.0410917673,0.0,0.0,0.058734572199999995,0.0,0.0,0.0,0.0,0.0,0.0,0.327370123,0.118971775,1.3466198,0.26480539,0.0917731851,0.0,0.291208356,0.215446052,0.0,1.53143189,0.0,0.0,0.30168238,0.0,0.157858465,0.0,0.0,0.0,0.72076335,0.36574207200000003,0.144177275,0.0,0.0,0.0067101856599999996,0.21025253800000002,0.0,0.772176145,0.0,0.0,0.0,1.53813658,0.538452245,0.0,0.0,0.72442366,0.0,0.36224984299999996,0.0,0.0,0.0,0.0,0.6858864309999999,0.0,0.0,0.0,0.45485149,0.0,1.27444394,0.0,0.79886626,0.394680663,0.995476313,1.03319309,0.8930677440000001,0.0,0.0888422675,0.0,0.0,0.006091679670000001,1.14677224,0.12511592300000002,0.0,0.0,0.48483724200000006,0.7549477109999999,0.0,0.724158515,0.966134425,0.52764232,0.0,0.0,0.0,0.0,0.392897239,0.0,0.0,0.0,0.26074179999999997,0.654188369,0.0,0.0,0.0,0.0,0.740516262,0.356516554,0.293142933,0.5318557110000001,0.0,0.748631279,0.176517019,0.0,0.0164838043,0.33943590100000004,0.249290318,0.0,0.0,1.64534694,0.922161146,2.77828773,1.40034959,2.07163516,1.05059681,2.34197919,1.17704338,1.71079225,1.50383351,2.03598894,2.77533561,3.59650355,4.63458099,4.01410046,2.16543515,2.85617832,3.98002951,2.61449167,3.07708639,3.53052043,2.56361999,0.90805593,0.81097319,1.30780191,0.0,0.0,0.857232454,1.58676253,2.48813878,0.630367156,0.211743605,0.0,0.12166174699999999,0.0,0.0,0.153190931,0.381881171,0.0,0.032257999100000004,0.8999363920000001,2.02240141,1.6708557000000002,2.74934763,1.6351131,1.1925848999999997,0.0,0.0,0.0,0.0,0.961556895,0.139135057,0.599221969,0.0,0.0,0.117116676,1.18583563,0.10083494900000001,0.0,0.417877031,0.865454772,0.9603084390000001,0.755876048,0.0,0.760696617,0.7830624970000001,0.0,0.69563695,0.0,1.11595691,0.0,0.5248050639999999,0.0,0.817680071,0.0,1.08609338,0.881978727,0.7354366529999999,0.0,0.0,0.050119988399999996,0.0,1.1287575,0.200507281,1.46620348,0.0,0.0,0.0,0.0,0.0,0.0,0.688907734,1.31555767,0.779609647,0.0,1.56422252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.321440223,0.7260695970000001,0.036585616,1.02276614,0.66797351,0.62286193,0.703233208,0.70571405,0.0,0.7010252640000001,0.404831814,1.03321738,1.05109249,0.948037517,0.766623614,1.41723344,1.75607136,2.18228616,1.79449742,1.66079227,1.80614209,1.34763103,1.62826992,0.8868092740000001,0.47624262,0.36314238200000004,0.666156345,0.38700716399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.38878903200000003,0.446641842,0.644489321,0.5388418620000001,0.449624102,0.234413436,0.18512309600000001,0.403625277,0.616545447,0.569128579,0.0,0.448252284,0.0,0.0,0.0,0.0701613636,0.296156354,0.22917509600000002,0.0222959953,0.0,0.0,0.0,0.262981967,0.0,0.67606248,0.268582532,0.786110415,0.100900743,0.6569804229999999,0.569838846,0.77368478,0.0,0.5537771570000001,0.20379080800000002,0.10887464300000001,0.266106293,0.5910215560000001,0.55823446,0.760678242,0.577797158,0.552982559,0.834310923,0.241618692,0.0,0.516005225,0.0,0.0,0.0,0.06933161639999999,0.315081893,0.284194987,0.0,0.0,0.0,0.43521319799999997,0.275312326,0.0,0.15145661800000002,0.46369838,0.455549438,0.0,0.0,0.439192005,0.0,0.23555784300000002,0.0,0.08700272519999999,0.0,0.0,0.0340901674,0.0,0.352540497,0.20521065600000002,0.0,0.238647255,0.0,0.0,0.570186076,0.14943963,0.0,0.0,0.0,0.0269836444,0.0700647059,0.0,0.0,0.320634102,0.0,0.0,0.0,0.0,0.632118037,0.6941243159999999,0.0,0.35223953399999997,0.587514916,0.0,0.0,0.517175546,0.0,0.0,0.0,0.0,0.0,0.193819713,0.17364565199999998,0.0,0.463919374,0.0,0.242937364,0.7734557459999999,0.756581655,0.523572378,0.798650313,1.00567051,0.128551479,0.10347194,0.268124201,0.37090597799999997,0.146100821,0.0,0.0,0.0,0.0,0.0,0.0,0.203774628,0.501695587,0.648421365,1.21771725,2.01520972,3.05658977,4.16038556,3.85792039,5.0915985,5.15408666,5.7975651,6.00600701,5.43087496,5.05571338,4.47766831,4.06212764,3.37799459,3.02820465,1.96434817,1.86846914,0.896787045,0.416664555,0.8286682470000001,0.0,0.409340033,0.0795124825,0.271933242,0.33908528,0.0,0.00647036415,0.701840267,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.485012995,0.6569526729999999,0.0,2.12311768,0.48414791100000004,0.9065890040000001,0.32077695300000003,0.0,1.56301557,0.12276872400000001,0.0127374457,0.0441515545,0.0,0.0,0.219529893,1.74616296,1.45078439,0.867040257,0.0,0.487343731,0.09591629269999999,0.0,0.0,0.0,1.01979838,1.39591066,0.0,0.0,0.551913831,0.0,0.0,0.0,0.0,1.36734842,0.0,0.461746162,0.0,0.0,0.0,0.687148127,0.0,1.69048233,0.0,0.9892035159999999,0.22370406,0.49701229799999996,0.0,0.795232616,0.477551296,0.456632621,2.29221198,1.46440937,0.0,0.0,0.0,0.0,0.0,0.0278153693,0.499631703,0.0,0.145745058,0.0,0.0,0.0,0.0,0.353445222,0.128216647,0.0,0.0,0.0,0.223867221,0.0,0.413259945,1.05397964,0.100238547,0.12417398199999999,0.0,0.33054299,1.91724434,0.0,0.0,0.0,0.0,0.0,0.014490286399999998,0.0,0.0434175715,0.0,0.0,0.0,2.11790099,0.0748421688,0.0,0.0,0.39074325200000004,0.252676985,1.93665563,0.0,0.0,0.6861202559999999,1.07330933,2.0265885,2.4091157,0.45300273,0.00803468983,0.0,0.0,0.705085014,2.40007664,0.8876484370000001,0.424016571,0.0,0.0,0.8624651109999999,1.5453246999999999,0.8885686740000001,0.652991133,1.48910426,0.0,0.20784729300000002,0.194395173,0.44170613799999997,0.9770993259999999,0.192974852,0.0,0.600494509,2.88742557,4.71358848,3.90859024,4.28772619,0.0,0.0,2.45594508,0.307818046,0.0,0.0,0.109665426,0.7166270459999999,0.835415763,0.009523350600000001,0.0,0.0,1.14664874,0.0,0.119092775,0.888813073,0.40477542899999996,1.45631126,0.2697437,1.96361618,0.0,0.0,0.0,0.8904643440000001,0.875353629,0.68524315,0.0,1.18270878,0.0,0.599263532,1.09173997,2.67027097,2.82540037,2.36200043,2.3710052000000004,2.73980802,2.11300128,1.89763311,1.48427886,1.19652437,0.0,0.0,0.874988498,0.9839756209999999,0.0,1.1811228999999999,2.11952841,0.19754133899999998,0.0,0.418857484,0.813463444,2.09459257,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.67422505,0.0,0.0,0.32073532,0.0,1.04472804,0.96989562,0.0,0.0,0.0,0.62164497,1.09344983,0.0,0.0,0.09687328,0.0,0.87545899,0.0,0.0,0.0,0.0,0.72015927,0.89059552,0.27815875,0.08642362,1.99133616,1.52230465,0.08108275,0.48330534,0.28488586,0.0,0.28471862,0.0,1.46277574,0.0,0.0,0.31156965,1.07496912,0.40919904,0.0,0.58911439,0.0,2.60451263,0.0,0.2069737,0.0,0.27696176,0.0,1.22484323,0.0,0.0,0.13248654,0.0,0.91067902,0.75957046,0.30876811,1.13652208,0.22594695,0.0,0.29938007,1.6272528,2.90945737,4.96094888,4.50235101,2.58237625,0.0,0.0,0.0,0.29476937,0.0,0.0,1.53354957,0.80773739,0.0,0.88934254,0.41894159,0.74448338,1.99436449,0.0,0.51984168,0.0,0.0,0.0,0.0,0.0,0.53580736,0.0,0.2984903,0.0,0.0,0.77863209,0.0,1.24680871,1.56808543,0.0,0.0,0.0,0.0,0.0,2.00064518,0.0,0.0,0.0,2.08029191,0.10923030000000002,0.0,1.33761179,0.51646283,1.74806677,1.91410643,0.0,1.14768275,0.38142451,0.52378408,0.10753075,0.60465785,0.0,0.57942068,0.0,0.68015839,0.0,0.0,0.72072276,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.731362738,0.0249734298,0.634037337,0.13301506800000001,0.118659907,0.537880685,1.20682442,0.63902358,1.32368574,1.05699776,1.17628649,1.82282432,1.96342801,2.15657862,2.38424149,2.87373805,3.32802601,4.38712752,4.81252715,4.28127705,4.05129115,3.54422054,3.13716243,2.4492107999999995,1.62225079,0.433347466,0.187402367,0.0,0.0593474372,0.0,0.226914127,0.44905237299999995,0.7449005679999999,0.712793006,0.0645057192,0.546520187,0.35590123700000004,0.562577167,0.0,0.34380455,0.317303296,0.24821561,0.427209314,0.0,0.0,0.0,0.0152289203,0.0295604984,0.0,0.0,0.217816129,0.0,0.458033907,0.223527173,0.0,0.0,0.060709119900000004,0.371517159,0.046272056500000006,0.0,0.0,0.0,0.142804767,0.388328721,0.0,0.215743639,0.49219650000000004,0.49233489700000005,0.0406209315,0.428203638,0.399084076,0.0,0.0,0.354021308,0.0,0.36741733200000004,0.26589124,0.418065167,0.350130756,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.30230161699999997,0.35474202899999996,0.0807977321,0.13016355400000001,0.0,0.0,0.00636813301,0.0,0.0,0.0,0.223433415,0.266372465,0.29339494899999996,0.265291771,0.0676535583,0.0,0.12471839900000001,0.222422714,0.0,0.0,0.0,0.0,0.160843159,0.441808229,0.0,0.139457738,0.29383181399999997,0.0968165363,0.0,0.060523632699999996,0.298463769,0.500786234,0.6095452060000001,0.607776022,0.296272715,0.0,0.42823193299999995,0.28498667,0.21917727899999997,0.0,0.0,0.0,0.0,0.144104405,0.39496901700000003,0.0,0.0,0.140280021,0.0,0.0,0.0,0.0,0.619740787,0.380651674,0.0128261622,0.0,0.0,0.0,0.0,0.0,0.0,0.37113380100000004,0.8832593679999999,2.08319708,2.51231963,3.23613666,3.62329713,3.4174622,3.71478284,2.65697182,2.06819009,0.804555005,0.556025762,0.0,0.0,0.0,0.0,0.230804973,0.498686797,0.217218765,0.257913279,0.551554377,0.0170412091,0.0,0.0,0.0,0.0,0.0,0.0357005746,0.0,0.0,0.0,0.128273412,0.0172975119,0.0,0.0,0.14165560300000002,0.0,0.08787151609999999,0.282082078,0.0104505973,0.466590845,0.366689485,0.0,0.0,0.0,0.0,0.0,0.0,0.124484124,0.744555684,0.49886449899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.49939780200000006,0.113144195,0.159528792,0.508995349,0.40148196700000005,1.0377449,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.156338701,0.269160119,0.258335114,0.125770781,0.0,0.0,0.0471044475,0.153664667,0.194663406,0.158649773,0.0863752423,0.0140904687,0.0,0.0,0.0359031835,0.18334802100000003,0.316556907,0.33953089,0.23678270899999998,0.0924824566,0.00630135627,0.0,0.0184472813,0.0110749448,0.0,0.0,0.00262039182,0.0168859521,0.00646561328,0.0,0.0,0.004485467470000001,0.0367032234,0.11741597,0.272088464,0.439847535,0.479331202,0.307635332,0.0279516964,0.0,0.0,0.060559644,0.08923083710000002,0.0,0.0414170169,0.41412595,0.966831737,1.28984551,1.15869086,0.822588971,0.7574635959999999,1.12286301,1.55173384,1.55589432,1.11382624,0.7635394529999999,1.06397227,1.99912519,2.96017182,3.29953283,2.86193781,2.00205431,1.19162875,0.678315934,0.451141804,0.37725015,0.30214082800000003,0.11552883900000001,0.0,0.0,0.13931366,0.835728438,1.36550077,1.23108843,0.515939467,0.0,0.0916803667,0.9302238270000001,1.64268696,1.5577524,0.804571739,0.111231897,0.0,0.21324395100000001,0.26035871899999996,0.0,0.0,0.0,0.7127897940000001,1.32228457,1.40835175,1.07499007,0.769054075,0.80646717,1.13843645,1.49392068,1.61823481,1.38046396,0.807110089,0.127846967,0.0,0.0,0.216380463,0.49735508,0.375276606,0.0881284817,0.0745947805,0.36550191600000004,0.466857836,0.0,0.0,0.0,0.920901504,2.89552998,4.18950532,4.30552899,4.08830249,4.83667966,6.83796818,8.9063359,9.43533206,7.86195605,5.07692079,2.5120021,0.9691144429999999,0.307529176,0.0228132358,0.0,0.0,0.21095626,0.499172279,0.5487274910000001,0.34165718100000003,0.07947951639999999,0.0,0.0,0.00394717513,0.015739951999999998,0.00332608113,0.0,0.00107548345,0.0,0.0,0.0,0.00673243286,0.0063864820400000005,0.0,0.0,0.0,0.00683551928,0.00439702119,0.0,0.0,1.3537997699999999e-16,0.0010398747500000001,0.0,0.00245123372,0.0063062011,0.0,0.0,0.0,0.0218562937,0.0316539585,0.0,0.0,0.13097186,0.560814605,1.06727201,1.29474575,1.05907359,0.599944371,0.424757393,0.832585756,1.58309053,2.07246243,1.86910302,1.08836144,0.254842033,0.0,0.0,0.0181517087,0.0950680709,0.031181371800000003,0.0,0.0,0.0116825624,0.0352237501,0.008541804609999998,0.0,0.0,0.00858607651,0.018362420900000002,0.00239116511,0.0,0.0,0.00710736647,0.011817260900000001,0.0,0.0,0.0,0.006679217289999999,0.00896563613,0.0,0.0,0.0,0.00587736324,0.00506146745,0.0,0.012964155500000001,0.0564766799,0.108870013,0.13942093,0.147754332,0.16553140800000002,0.209044819,0.241831605,0.206954463,0.103947902,0.0156714291,0.0342954682,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23399999999999999
0.186589185,0.343513643,0.463232469,0.40788668100000003,0.163323086,0.0,0.0,0.0,0.274450623,0.6725994000000001,0.889132943,0.83410609,0.579904793,0.296908141,0.12812828699999998,0.09722787849999999,0.119502144,0.100243519,0.027814323399999997,0.0,0.004948648129999999,0.0979848115,0.155508344,0.10688323599999999,0.0,0.0,0.00102850456,0.164363484,0.286618135,0.272675359,0.150427374,0.031834712,0.0,0.02398628,0.0371629588,5.61530042e-16,0.0,0.0,0.017448080300000002,0.096613611,0.17287105,0.280536894,0.45211642799999996,0.633529744,0.6914924809999999,0.537726698,0.24620443600000003,0.0176055641,0.0,0.135278838,0.224461888,0.127399028,0.0,0.0,0.0,0.120892346,0.185287502,0.0341719487,0.0,0.0,0.0190376165,0.214283279,0.16901170199999999,0.0,0.0,0.0,0.172336766,0.315742172,0.0881614595,0.0,0.0,0.335467187,1.16594787,1.56454363,1.19766863,0.431309878,0.0154547181,0.36311470799999995,1.14757482,1.65190847,1.53980051,1.25591056,1.60854649,2.91743174,4.58320321,5.54794118,5.23471056,4.06274398,3.03739572,2.81499897,3.14449909,3.19837282,2.42886107,1.09904975,0.00236115508,0.0,0.0349141187,0.38225154,0.285815335,0.0,0.0,0.0,0.28490190000000004,0.679517755,0.710389127,0.48244648700000003,0.27453473,0.22364479199999998,0.22920440600000003,0.138152305,0.0,0.0,0.0,0.07450928700000001,0.146228368,0.0495301259,0.0,0.0,0.0,0.119885675,0.112373636,0.0,0.0,0.0,0.056610418899999994,0.13370621300000002,0.0565294863,0.0,0.0,0.0,0.113292455,0.121907015,0.0,0.0,0.0,0.20978494399999997,0.52203216,0.6786015059999999,0.601912345,0.355446586,0.0619753427,0.0,0.0,0.0,0.48880591799999995,1.06131882,1.37246121,1.15612242,0.496002347,0.0,0.0,0.465295549,1.54281987,2.37140296,2.48385518,1.90233816,1.04595209,0.365237088,0.0436909892,0.0,0.0110372573,0.0235110456,0.0111011083,0.0,0.0,0.0,0.34629661799999994,1.24374513,2.56841376,3.8556269999999997,4.49742075,4.14755629,2.97834697,1.56674613,0.49983936,0.021194753700000003,0.0,0.07112152570000001,0.107485589,0.11182239599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.05770598,0.7998938059999999,0.47064976799999997,1.02309802,1.23121508,0.0,0.217394749,0.162967204,0.0,0.0,0.0,0.0,0.0,0.216043233,0.418069808,0.0,0.0,0.0,0.0,0.0,0.40047187,0.139135645,0.464352586,0.312750529,0.0,0.0,0.0,0.313482418,0.0,0.0,0.0,0.0,0.505218883,0.0,0.53103614,0.0,0.0,0.38087203700000005,0.319222897,0.0,0.442788302,0.186583109,0.0547252219,0.0,0.0,0.0,0.0,0.203420094,0.0,0.552964033,0.0,0.484121906,0.372016515,0.0,0.163770906,0.0,0.0,0.169472889,0.205684915,0.0,0.039221751299999996,0.0,0.0,0.0,0.9681728559999999,1.3507038999999998,0.590580338,1.49518083,0.794200529,0.6015407629999999,1.44127654,1.06470992,0.883984511,1.87038043,1.43069891,0.668810261,0.31252396,0.056088970599999996,0.0,0.0,0.0,0.436153124,0.0,0.150980314,0.0,0.034292678300000004,0.479022062,0.0375065286,0.904979229,1.34602486,1.67199469,1.58352356,1.29789118,0.081938186,0.0,0.0,1.26616055,3.50901133,4.96699495,5.90855616,5.99286532,5.01241804,2.63779308,0.631642724,0.0,0.0,0.0,0.376410119,1.51840507,0.854995312,0.963960232,0.46843664,0.0,0.133392349,0.7868039440000001,0.609589786,1.34539736,0.844577413,1.00772255,0.145336525,0.0,0.0,0.0,0.40264946700000004,0.267365138,0.7069631009999999,0.0,0.242812045,0.525206517,0.14932637099999999,0.00422943806,0.00596874373,0.0,0.0,0.0,0.351344237,0.0,0.752586897,0.10692790099999999,0.68892084,0.20364674800000002,0.576073297,0.0,0.511139789,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.71546001,1.26453946,0.58231264,0.33682159899999997,0.0,0.600682989,0.0,0.0,0.0,0.0,0.0,0.0,0.9983270959999999,1.50501099,0.0,1.30413813,0.0,0.227998442,1.41311173,0.8448800329999999,0.0,0.285512262,0.432478949,0.848934387,0.877801724,0.207232959,0.0,1.3134793,0.0,0.0,0.770856263,0.6444710229999999,0.680308021,1.11171878,0.0,0.0,0.9084181370000001,0.0,1.22433578,0.157751058,0.0,0.0,0.0,1.84618223,0.0,0.09680946539999999,0.0,0.641437232,0.899247136,0.7610973529999999,1.21105288,0.494379712,1.30237048,0.8373137890000001,0.849322721,0.0,0.819833247,1.09062945,3.98921108,6.07340767,1.64679905,0.0,1.2080507,0.220899435,0.314944945,0.0,0.794446615,0.0,0.8062648240000001,0.46906963399999996,0.3960701,0.0748325909,0.0,0.0,0.0,0.0,0.0,0.7242697770000001,0.138211108,0.0,1.68581762,1.46195683,0.025892984900000002,0.0,0.0,0.0,0.0,0.19813401,1.00990165,0.0,0.0,0.368913134,1.07759459,0.21752397699999998,0.0,0.0,0.00469522649,0.165267973,0.23676324899999998,0.0,1.25795353,1.83592564,0.5322821839999999,0.803307903,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.60122497,7.52916898,2.59333568,0.0,0.22301133,0.60801764,0.0,0.17368996,0.33291386,0.0,0.16874521,0.23067957,0.0,0.18439884,0.18410159,0.0,0.23329091,0.17783943,0.0,0.53501732,1.60539313,1.0298695,0.4779795,0.05248396,0.0,0.49424636,1.46059111,3.0055941,4.0735939,0.97807916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.157464696,0.0,0.0,0.0,0.0,0.131713293,0.0,0.0,0.513531657,0.0,0.0,0.9713187740000001,0.90235335,0.0,0.9497714540000001,0.703471115,0.128153343,0.0,0.0,0.0,0.8450643090000001,0.25177257,0.229946928,1.51297018,0.15227554199999999,0.681511712,0.0,0.62219281,1.21258058,0.0,0.152520706,0.48661006700000003,0.915353353,0.6729206759999999,1.6840374,1.06971826,0.9904286370000001,0.9112573490000001,0.43215114299999996,1.17040544,0.255066582,0.0,0.0,0.0,0.775362103,0.543298949,0.589962346,1.18821714,0.331692852,0.988757068,0.763915028,0.0,0.0,1.35755662,0.358702016,1.25191229,0.961097911,0.804792719,1.25476638,1.27949935,1.46892367,0.611253471,1.34716186,0.43172315,0.273405077,0.00159619589,0.938829337,1.06485389,0.651069904,0.0,0.0,0.5124037770000001,0.552288116,0.893254133,0.295154022,0.0,0.0,0.0550741538,0.0,0.259314457,0.329636798,0.354900411,0.0,0.34152701,0.0,0.0,0.0,0.0,0.119411586,0.23889919699999998,0.0,0.0,0.0,0.5459546120000001,1.0894339,1.33040008,0.0,0.203197125,0.0,0.0,0.0,0.439840471,0.0,0.0,0.131504498,0.0,0.0,0.0,0.0,0.0,0.136224681,0.364552401,0.323162746,0.0526768107,0.241638573,0.0214035923,0.0,0.279262775,0.14841563300000002,0.0,0.0,0.367353534,1.06354382,0.0,0.852274069,0.416773571,0.0,0.0,0.0,0.0943413126,0.050358836500000004,0.162685142,0.0,0.0,0.0,0.406083319,0.0,0.729227113,0.0,0.0,0.802332445,0.161441214,0.46964069700000005,0.0,0.26571084100000003,0.350825877,0.0,1.00706337,1.39588915,0.0,0.0,0.0691283639,0.08744561449999999,0.20778548600000002,0.0,0.219424343,0.0,0.0,0.0513133852,0.0,1.1392524,0.0,0.0,0.0,0.637796342,0.918921398,0.507859039,0.0,0.107329601,0.0,0.0,0.795979021,0.327106132,0.0,0.0,0.834026875,0.195474612,0.0,0.384648217,1.01839897,1.50879893,0.18515309,0.292314797,0.0,0.9014823129999999,1.10333231,0.9399721329999999,2.56308289,2.2816023,3.59540579,3.01466882,1.17942662,1.09824347,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.27481923,0.25964095,0.15389498,0.0,0.18516733,0.11949209,0.0,0.12616801,0.0,0.16246389,0.08173103,0.10683016,0.0,0.0,0.88392144,1.33272886,1.71603982,2.82720004,3.44653384,3.15861639,3.41423658,2.53106199,1.88336945,1.04944105,0.49825714,0.0,0.0,0.0,0.0,0.0,0.2799489,0.5681605,0.52812755,0.18254198,0.18509632,0.39794052,0.27812123,0.0,0.278925,0.42763946,0.4984813,1.04008751,0.85796601,1.13334346,1.06260752,1.24514518,1.53852383,1.29774017,1.32141331,1.37058531,0.97942511,0.46755233,0.28199793,0.48338955,0.3249135,0.54803056,0.2506535,0.30777586,0.8613036000000001,0.91050213,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.22609359,0.661191595,0.107841752,0.0,0.0587274338,2.02324631,3.9853498999999997,3.74951878,2.80142234,0.59101125,0.0,0.0,0.0,0.7616688420000001,0.23149950800000002,0.135548943,0.022471533300000002,0.0376063563,0.0329282519,0.244909851,0.192553788,0.0,0.0,0.34128245100000004,0.0,0.0,0.0,0.170447583,0.0,0.0,0.143636744,0.00913635137,0.207595124,0.209501055,0.08322546019999999,0.0,0.38347597299999997,0.056162171600000005,0.0,0.0,0.218000196,1.11050345,1.96683365,1.86852559,1.21534153,0.403300789,0.27451772399999996,0.20426526899999997,0.818497012,0.192439164,0.34162868799999996,0.0,0.897778408,1.27924181,1.0739826000000001,0.165306452,0.0,0.0527389215,0.192319525,0.356612531,0.34183582799999995,0.0,0.0,0.08908451449999999,0.52061061,0.288676535,0.205623117,0.0,0.0,0.0,0.35348714200000003,0.362941743,0.0,0.0,0.332118276,0.33167136399999997,0.291276375,0.39258886200000004,0.43519841,0.0,0.0,0.421202251,0.440977175,1.00221021,0.745600334,0.565990507,0.965245954,1.57292543,1.43191638,1.04251365,1.10652715,1.19431769,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0733601247,0.141716695,0.0,0.0,0.0,0.130339347,0.131053824,0.0,0.124264005,0.0349246597,0.0,0.149332414,0.295973351,0.0512152908,0.109195936,0.163691138,0.0,0.058199596500000006,0.305365485,0.014525084099999998,0.0,0.17352287100000002,0.240668347,0.0937510818,0.230365228,0.0,0.0,0.333271961,0.08124522440000001,0.0,0.0,0.323549274,0.019052736299999998,0.176658678,0.269472467,0.60124792,0.5221795779999999,0.0,0.16654818400000002,0.0,0.261008564,0.110076622,0.153219344,0.0,0.24449003600000002,0.0,0.051057774199999996,0.493659774,0.768344239,0.46370743299999995,0.0,0.0,1.64671431,3.77607835,3.72654003,1.60781859,0.394392391,0.773366082,1.64150235,1.31750846,0.176727439,0.0,0.0,0.0,0.0,0.0,0.0,0.337887039,0.300322493,0.0,0.0,0.0,0.0,0.319402984,0.920505171,0.653926634,0.28486299800000003,0.269664837,0.032546852599999995,0.23938096,0.0,0.0,0.26779345600000004,0.0,0.0,0.0442690503,0.0,0.124493887,0.0411205813,0.282057668,0.18073746699999998,0.0,0.0809005358,0.27097434800000003,0.7165973720000001,0.0,0.00252474828,0.0,0.162090803,0.036552135699999995,0.812216915,0.737656697,0.266397376,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16216824300000002,0.0,0.297911335,0.128694046,0.18040186,0.118115786,0.119788591,0.569461859,0.390141588,0.048172397400000004,0.0,0.382773099,0.3344253,0.0,0.0,0.0245576854,0.12215965699999999,0.24289166899999998,0.247488789,0.145199545,0.0,0.18890937,0.368073004,0.16859641600000003,0.193855445,0.39348812,0.0,0.0,0.0,0.126028473,0.0,0.23895528100000002,0.0,0.24634649600000003,0.0,0.0,0.0,0.0916230355,0.0,0.0,0.0,0.022719825899999997,0.249821349,0.0,0.0,0.021689435299999997,0.0813182697,0.0116463942,0.0,0.0,0.135829031,0.089833286,0.10160808199999999,0.0,0.170689285,0.0,0.104308284,0.0,0.0,0.12368876599999999,0.19561303,0.0,0.13063396900000002,0.807762245,0.536282844,0.9795251629999999,1.50022417,1.99089069,2.58767761,3.28676256,3.24022238,3.68530597,3.42421445,2.67272606,2.51608947,2.29196606,1.58967215,1.05975312,1.06863056,0.742149411,0.704989538,0.456010515,0.789104233,0.551887816,0.83758932,0.44826684,0.79903737,0.932059341,0.429956402,0.563828665,0.08183438400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33766339,0.610798564,0.632682901,0.19619388399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0544544196,0.07364355,0.0674987507,0.532728369,0.155854624,0.510039386,0.19863551899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.171537319,0.427000472,1.28207952,1.27152214,1.92988192,2.1101487999999997,2.52739082,2.13786693,2.32164833,1.58152411,1.66001219,0.847862805,0.8312007140000001,0.297030525,0.182210277,0.34542348799999995,0.333829959,0.218245918,0.7933768290000001,0.942064432,0.805873765,0.740227605,1.16769014,1.02872611,0.37828805,0.22367300199999998,0.6066605979999999,0.0,0.0,0.0373030238,0.0,0.104014915,0.116551711,0.0,0.0,0.340247432,0.506373087,0.0,0.20563346,0.12131687699999999,0.158148643,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.612376775,0.494703725,0.154893476,0.716070387,0.7190779209999999,0.0723497939,0.019480726,0.35475679200000004,0.0,0.581409298,0.0,0.0,0.0,0.554158656,0.419886769,0.0,0.43262938799999995,0.0,0.596227293,0.41836742600000004,0.49553325200000004,0.457839251,0.0,0.8320895779999999,2.93825247,4.50107197,5.98041036,6.86877554,5.14388649,2.56026771,0.162412967,0.270333767,1.03987201,2.47939462,4.11602912,5.28746085,3.18087819,2.08518649,0.0,0.0,0.0,0.322928534,0.923706362,0.364074959,0.0,0.0,0.241771102,0.163354789,0.249696282,0.0367457766,0.382722968,0.0,0.0340774443,0.0,0.506118133,0.640585603,0.173404005,0.0,0.0,0.0,0.0,0.21350343800000002,0.124214533,0.487347145,0.057670157699999995,0.0,0.0,0.0,0.0,0.0159861515,0.261260973,0.44337049100000003,0.0,0.514604249,0.0,0.32765156,0.0,0.0,0.0,0.09662845769999999,0.289570407,0.0,0.10984136,0.0,0.0,0.0,0.0,0.0,0.473839488,0.46962592299999995,0.169830428,0.55766574,0.23249911,0.265644945,0.0,0.0114989303,0.424799391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.371600961,0.0,0.0,0.0,0.0,0.24317076399999998,0.232246741,0.0,0.0,0.473948992,0.47476638,0.0,0.0,0.0,0.0,0.202728465,0.7006160140000001,0.0,0.12301935,0.132126245,0.654887849,0.0,0.0,0.0,0.0,0.229078965,0.502211737,0.0,0.622793926,0.0,0.53229113,0.0,0.15514666400000002,0.0,0.10972556,0.11929945300000001,0.0,0.369873888,0.7818164240000001,0.299714827,0.7118025290000001,0.521104569,0.24831123600000002,0.295572006,1.54788159,1.73964213,2.2037818,0.780164209,2.15228426,2.58405988,3.32780493,2.48631607,3.09247163,2.05755169,2.64694828,2.91161242,3.22406848,3.15060006,2.66726337,2.12522693,2.69508801,2.56816967,2.56867627,1.17509302,1.38358678,1.71075202,0.735374952,0.42100581600000003,0.450174742,0.0,0.975356195,0.0,0.666508565,0.0,0.0,0.0,0.0,0.513833051,0.488130464,0.0,1.09801279,1.14868916,0.60930807,1.07427074,0.0,0.884242897,0.0,0.0,0.8121515709999999,0.611067137,0.0,0.18249067600000002,0.521871424,0.974139062,0.0,0.503737102,0.0,0.0,0.713464827,1.01009102,0.0,0.706665888,0.0,0.0,0.0,0.0,0.564226172,1.30803434,0.008691529520000001,0.0,0.0,0.0,0.0,0.0,0.28291695899999997,0.25769555899999996,0.0,0.873700316,0.0,0.0,1.27879344,0.0,0.0,0.0,0.151696455,0.0,0.676602204,0.575377928,0.736314183,0.238669118,0.96119252,2.50951444,1.2894107,2.31691242,2.16461578,1.66019936,1.60918388,1.74946161,3.11228658,2.33155422,2.32207271,2.30871328,1.48232009,2.87618494,2.5211832000000003,1.33809793,2.23564549,0.924049261,1.69990582,0.682208192,0.477328167,0.815272507,0.439255701,0.0,0.0017682607300000001,0.0,0.8273899240000001,0.0,0.50113108,0.0,0.038167776699999996,1.25913842,0.474266509,0.0,0.776150527,0.630312905,0.994116097,0.0,0.220578235,0.22413245699999998,0.179236402,0.0,0.749094837,0.0,0.933687811,0.595210838,0.141196718,0.152836779,0.0,0.013361968200000001,0.0,0.00874382186,0.8751258940000001,0.0,0.0,0.790653664,0.5394457979999999,0.0,0.35362290399999996,0.316513208,0.674539042,0.085916436,0.47464183200000004,0.0,0.0,0.7782292279999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45146106799999997,0.0,1.16632142,0.0,1.69920527,0.0,1.04143174,0.45666028200000003,0.0,0.7457216259999999,0.00462386292,0.0,0.0,0.0,0.015036223100000001,0.0,0.7797775370000001,0.710173963,0.0,0.539120506,0.0,0.0643018764,0.614888279,0.28651990899999996,0.297463356,0.0,0.371104052,0.392727217,0.279529957,0.490621685,0.158630899,0.055213425499999996,0.19484110100000002,0.0,0.0,0.0780757138,0.0,0.201261832,0.0169804566,0.0,0.41119848700000006,0.319171245,0.39451296700000005,0.20435150100000002,0.0,0.49370922899999997,0.19943065899999998,0.560493571,0.0,0.744518928,0.0,0.0,0.0171790708,0.556496508,1.23156697,1.93023944,0.958845589,1.1676753999999998,0.929296063,1.04605687,0.242170023,0.879281175,0.316754477,0.0659626785,0.0,0.7509278420000001,0.0,0.435311705,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.871446915,0.0,0.42976308399999996,0.0,0.0,0.19069981800000002,0.710624885,0.0,0.0775192701,0.0,0.759924739,0.0,0.8744044440000001,3.41865694,7.04937921,9.28516261,7.26541116,3.46188544,0.512293315,0.916290605,2.19315245,2.93029083,2.38679246,0.5173916000000001,0.0,0.329304896,0.457451269,0.0,0.743590282,0.584132475,0.740348571,0.0693383024,0.0,0.30839606199999997,0.0,0.9357808190000001,0.41366153299999997,0.34935628,0.0,0.0,0.0,0.0,0.0,0.5655590970000001,0.091273374,0.016593885,0.816546949,0.29244704899999996,0.0,0.0,0.0,0.0,0.0,0.531465502,0.0,0.52247493,0.48420615,0.225409882,0.0,0.845974808,0.767592212,0.0,0.0,0.0,0.020305728500000002,0.770729386,0.0322671535,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23087371899999998,0.85340476,0.956976918,1.17305465,0.985831363,0.0,0.0735267589,0.0,0.0,0.0,0.0,0.0,0.0,0.21719845,0.183787741,0.0,0.48224262799999995,0.0,0.284880893,0.0,0.852276521,0.830324913,0.0,0.84931767,0.422215082,0.642147911,0.0,0.0,0.13609938900000002,0.0,0.0,0.0,0.22360952399999998,0.0,0.0,0.367775994,0.544657387,0.0,0.705464977,0.0,0.0,0.0441527043,0.0,0.6748798909999999,0.0,0.7714338000000001,0.0,0.18179268,0.0,0.0505114958,0.60060491,0.0,1.16022226,2.6147156000000003,3.54856359,2.32426673,1.66135308,1.91874934,0.0,0.0,0.0,0.48157000899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.14026913900000001,0.264572246,0.309215445,0.26898683,0.180651452,0.103749583,0.09137398,0.1649319,0.304658277,0.459912957,0.573829641,0.610209297,0.569784393,0.488368245,0.41824575,0.40215234299999997,0.452511476,0.545761691,0.6341086539999999,0.668611449,0.6222530629999999,0.502019422,0.34468340000000003,0.19904054,0.103756427,0.07165677620000001,0.0875496826,0.119567706,0.137249808,0.12658863199999998,0.0944787709,0.061124093899999996,0.0456660066,0.053953412199999995,0.075979977,0.094765978,0.10146121699999999,0.10710418,0.142437858,0.24334031899999997,0.427794401,0.676445617,0.929029087,1.10243413,1.12555665,0.976428629,0.703513238,0.418063959,0.256556545,0.32624752100000004,0.656307357,1.176811,1.7374005000000001,2.16073434,2.31017256,2.14375103,1.73118766,1.22588778,0.803229636,0.5912503179999999,0.62340171,0.833429497,1.09372331,1.2790110000000001,1.32587164,1.26054299,1.18217717,1.20949125,1.41617069,1.78629019,2.21243446,2.5397582,2.63762179,2.4665705,2.10887633,1.7458542000000001,1.58833829,1.78788617,2.36599049,3.19228924,4.02294621,4.58544578,4.67669095,4.23576427,3.36325605,2.28101342,1.25006907,0.48032229,0.0669680398,0.0,0.0779283003,0.2159533,0.269962994,0.198240367,0.038280205,0.0,0.0,0.0,0.0,0.0663800346,0.166488086,0.177611057,0.101105221,0.0,0.0,0.0,0.0,0.0,0.0820170612,0.134332436,0.117375353,0.0436125948,0.0,0.0,0.0,0.0,0.0176602501,0.08515367730000001,0.10713958900000001,0.0750151988,0.00728292385,0.0,0.0,0.0,0.0,0.037814917,0.0815500812,0.08293834509999999,0.04305410690000001,0.0,0.0,0.0,0.0,0.0,0.0488942241,0.0737811934,0.0610162724,0.018286036000000002,0.0,0.0,0.0,0.0,0.015942016599999997,0.05395916940000001,0.06395047870000001,0.041695505,0.0,0.0,0.0,0.0,0.0,0.0301089933,0.058235012999999995,0.0572825811,0.0271391504,0.0,0.0,0.0,0.0,0.005190601610000001,0.0784140121,0.151078888,0.205620677,0.23056417399999998,0.221914384,0.182147717,0.11853516900000001,0.042171199900000005,0.0,0.0,0.0,0.0,0.0145146309,0.138752202,0.273067706,0.381027313,0.43016896200000004,0.40427679200000005,0.310715705,0.178971018,0.05018308230000001,0.0,0.0,0.0,0.0160993032,0.0740799312,0.112120422,0.129599872,0.1461674,0.19120988100000003,0.28766118399999996,0.438210812,0.62107007,0.79791669,0.930578857,0.9984143670000001,1.00758012,0.987048301,0.97269562,0.986967444,1.0243792999999999,1.05088083,1.01868844,0.8905278759999999,0.662027347,0.37097195899999996,0.08759483970000001,0.0,0.0,0.0,0.07683528190000001,0.26165242,0.377708836,0.375954085,0.25933215600000004,0.0798456307,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.028456732599999996,0.09348236160000001,0.143285458,0.17422651100000003,0.185009582,0.17664026800000002,0.15214957099999998,0.116124356,0.0741033203,0.0319088752,0.0,0.0,0.0,0.0,0.0,0.0,0.0292359583,0.0695866943,0.110659996,0.14831535,0.179077055,0.20051277899999997,0.21147248300000002,0.21216476899999998,0.20406697399999998,0.189684675,0.17219326699999998,0.155007295,0.14133068599999998,0.13374229699999998,0.133866182,0.142165285,0.15788229199999998,0.179133719,0.20314514399999997,0.226598816,0.246051601,0.258372927,0.26114989,0.253010411,0.233824731,0.20475966399999998,0.16817714600000003,0.127386943,0.0862806492,0.0488884384,0.0189097268,0.0,0.0,0.0,0.0134975205,0.0393515265,0.0709575018,0.10414627900000001,0.134518001,0.157962708,0.17116031899999998,0.172000685,0.159871979,0.135779423,0.102274849,0.06319886599999999,0.0232591514,0.0,0.0,0.0,0.0,0.0,0.0,0.040316154900000005,0.0903450613,0.140927904,0.18543932600000002,0.21744613100000001,0.231477292,0.223731878,0.19264120399999998,0.139213298,0.0671079742,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.043279138200000004,0.16711326599999998,0.280730401,0.37108347799999997,0.42683753799999996,0.439830609,0.406345351,0.32804981899999996,0.21248869,0.0730420997,0.0,0.0,0.0,0.0,0.0,0.0,0.268822248,0.708114162,1.27316306,1.95050762,2.7172568,3.54208119,4.38692528,5.20933135,5.96521087,6.61185648,7.11096188,7.43141018,7.551605499999999,7.46115541,7.16176197,6.66724197,6.00266687,5.20268427,4.30914975,3.36825334,2.42736594,1.53185227,0.722097862,0.030977296,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.026485932799999997,0.268397044,0.45791734,0.585454641,0.648727295,0.652239728,0.6061828260000001,0.524890588,0.42501911200000003,0.32363221600000003,0.236378559,0.175928626,0.150808206,0.164721679,0.216407695,0.300016929,0.40595136200000004,0.52206187,0.635069556,0.732058867,0.8018885640000001,0.836379558,0.831165103,0.786125658,0.7053743,0.596804199,0.47125311299999995,0.34137671399999997,0.220349507,0.120526706,0.0522014941,0.0225799382,0.0350718426,0.0889626933,0.179493027,0.298330973,0.434385425,0.57487497,0.7065444470000001,0.8169088290000001,0.895404022,0.93433587,0.929540716,0.880700852,0.791293061,0.668184479,0.5209238310000001,0.360804225,0.199793665,0.0494394118,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.15646429999999997,0.0,0.47607682,0.16800471,0.06342321,0.13628546,0.0,0.03915071,0.56920403,0.75433633,0.37051847,0.80169309,1.14334527,1.10756771,0.80642195,0.74792628,1.11921443,1.33795653,0.86585639,0.86041428,0.97236747,0.57420047,0.46693463,0.65829168,0.59223445,0.95372865,0.55302141,0.91026173,0.9190594999999999,0.77625817,0.5361156,1.24728429,1.00239397,0.980187,0.44929847,0.19995929999999998,0.57369469,0.0,0.10144512,0.0,0.0,0.0,0.18270155,0.58930563,0.57550425,0.48935723,0.15660711,0.61564257,0.67420201,0.02776253,0.0,0.0,0.0,0.0,0.0,0.0,0.46742132,0.67406148,1.67165989,2.70862174,3.50244915,3.6311120000000003,3.92667823,4.2702748,4.32683313,3.74476167,3.29880579,2.21026255,1.66747424,0.77013879,0.51969818,0.0,0.0,0.0,0.0,0.21140356,0.0,0.05630332,0.02511319,0.26321789,0.36342176,0.6186096999999999,0.43031734,0.0,0.0,0.0,0.0,0.0,0.0,0.259371,0.0,0.4857232,0.55087567,0.42164401,0.0,0.07983293,0.0,0.0,0.02597508,0.0,0.31498404,0.0,0.37947072,0.0,0.58342535,0.50390324,0.26045039,0.05675546,0.15695676,0.40812115,0.07074794,0.40801016,0.0,0.23398553,0.0,0.2096654,0.19651712,0.35713391,0.0,0.37696726,0.0,0.0,0.4191202,0.0,0.16000704,0.0323743,0.0,0.4145741,0.25535084,0.20134383,0.0,0.46239529999999995,0.0,0.32049361,0.43402809,0.50534216,0.0,0.0,0.2257155,0.0,0.0,0.0,0.29689372,0.0,0.0,0.34131774,0.0,0.09305766,0.19016339,0.0,0.0,0.3729908,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.97704628,0.0,0.0,0.38369441,1.60901988,1.99102249,0.84379518,0.0,0.0,0.0,0.0,0.0,0.0,1.43993572,0.0,1.11704934,0.0,1.21102717,1.8235963,0.0,1.99764599,0.67213023,0.78449577,0.9222358,0.0,0.27476876,0.0,1.31997935,0.54643896,0.7251996999999999,0.0,0.22460224,0.0,0.0,0.51320382,0.60181042,0.44459582,0.0,2.31375183,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.2104008,0.70442241,0.3026002,0.7359271190000001,1.41213426,1.14138018,0.0,0.0,0.0,0.516057491,6.20222232e-16,0.0,6.891358129999999e-17,0.620562934,0.0,0.0,0.0,1.05520646,2.2052346e-15,0.0,0.0,5.11210082,7.96847192,5.03299476,0.0,0.0,0.0,1.01177348,0.10086673300000001,0.0,1.32658644e-15,0.44990704200000003,1.07677471e-16,0.0,0.0,0.21679866600000003,0.0,0.0727253512,0.605200399,0.816858075,0.5043336660000001,0.401264154,0.706067132,0.6860752459999999,0.10086673300000001,0.0,7.580493940000001e-16,0.31335403100000003,0.10086673300000001,0.0,0.20173346600000003,0.9654607159999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.30340449,3.91698393,3.23803238,0.919437353,0.42308655,1.73761316,1.23690741,0.0,0.0,4.00758069,6.78599431,4.21859641,1.52388674e-15,0.0,0.181200825,0.532026508,0.0,0.0,0.236480971,0.354555781,0.0614818167,0.0,0.07447390400000001,0.116753969,0.10879675,0.0,0.0,0.04206772809999999,0.231599565,0.0,0.0,0.699274889,2.51837351,2.50106913,0.5411033679999999,0.0,0.0,0.575560006,0.945065516,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.846551807,0.44778701,0.618662266,0.35909465799999996,0.78640044,0.288759047,0.322287228,0.296396418,0.216469761,0.246875173,0.250411535,0.0,0.0,0.099530324,0.0,0.0,0.0,0.151089387,0.0,0.151431628,0.0530987768,0.0,0.455333854,0.135053656,0.107007955,0.2760836,0.07282813839999999,0.0533535597,0.215910005,0.10101975,0.0,0.0249205706,0.0877156372,0.04381773,0.0,0.0,0.0,0.0,0.122923664,0.049188778499999995,0.246039856,0.486968584,0.549460143,0.545354763,0.26876198100000004,0.265477556,0.772518897,0.7181919,0.27419955,0.517347937,0.22621963899999997,0.282794041,0.328635522,0.0,0.249393313,0.446751488,0.333728975,0.51653518,0.624669261,0.581959973,1.02175902,1.34643826,1.52056117,1.87747717,2.10907958,2.11673691,2.48561998,2.84416065,3.14504242,3.21672922,3.07066157,2.79116915,2.85409393,2.70852623,2.2692104,2.22989376,2.05896627,1.33434935,1.42595345,0.857903634,0.824984301,0.423321381,0.313744368,0.47115379,0.0058561478,0.0,0.0885593033,0.0,0.06551648269999999,0.0,0.26221255600000004,0.283403489,0.46653759100000003,0.446118732,0.0460113334,0.296246358,0.42597451,0.48381309200000006,0.0374595475,0.025055635299999997,0.269103943,0.178855641,0.373627851,0.30209609,0.375433256,0.281757055,0.36067125200000005,0.08607154199999999,0.336470715,0.0,0.375621903,0.017157201299999997,0.0,0.0,0.0051284513399999995,0.0,0.0220403065,0.166860114,0.0267707725,0.0,0.0,0.209011709,0.15923847900000002,0.0,0.0,0.245640655,0.051312020800000004,0.0820272454,0.262167166,0.056115888200000005,0.11820210699999999,0.32622112,0.0370462359,0.190269865,0.15594402400000001,0.0,0.0,0.0772814877,0.0,0.0535224893,0.148408997,0.152965993,0.0,0.09806677400000001,0.0,0.0,0.0,0.0,0.0,0.0694687509,0.0008889537619999999,0.215099405,0.0990726765,0.132961791,0.0,0.0,0.21060647899999999,0.254583098,0.0901438862,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18855244899999998,0.038730716899999997,0.289745934,0.359204853,0.19787805600000002,0.5739524020000001,0.230840065,0.378292653,0.57524964,0.6795880879999999,0.81674609,0.432141141,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0622000866,0.0985174636,0.129594932,0.154653789,0.173183575,0.18494507,0.189963281,0.188511079,0.18108449100000001,0.16837088600000003,0.15121156300000002,0.13056035900000001,0.107440035,0.0828981782,0.0579643545,0.0336101242,0.0107133637,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0020809430899999997,0.00484670167,0.00572353203,0.00478960459,0.00224351286,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00913105593,0.0229465143,0.0382139489,0.0543756901,0.0707931378,0.08677382859999999,0.101602024,0.114571564,0.12501959199999998,0.132359705,0.136113041,0.135935896,0.131642539,0.123222077,0.11084841699999999,0.0948826546,0.0758674739,0.054513495499999995,0.0316778044,0.00833523379,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027514914100000003,0.0661803948,0.108335339,0.15255497199999998,0.1972309,0.240621293,0.280908805,0.31626447399999996,0.344915569,0.36521514200000005,0.37571087700000005,0.375210796,0.362843359,0.338109647,0.300925462,0.25165148,0.191109919,0.120586587,0.0418176412,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08309311700000001,0.278792212,0.493593316,0.7240173440000001,0.9660658440000001,1.21531123,1.46700113,1.71617405,1.95778323,2.18682525,2.39846966,2.58818599,2.75186447,2.88592681,2.9874238999999996,3.05411737,3.0845427000000005,3.0780517999999994,3.03483375,2.95591311,2.84312554,2.69907155,2.52704954,2.33097002,2.11525348,1.88471474,1.64443728,1.39964083,1.15554638,0.917242149,0.689554498,0.476927386,0.28331369300000003,0.11208144800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.060433983899999995,0.170331392,0.282019552,0.391665885,0.49566837399999997,0.590751686,0.6740508279999999,0.743180101,0.796285644,0.8320804159999999,0.849861015,0.849506313,0.83145847,0.7966874079999999,0.746640339,0.683178353,0.608502446,0.5250716320000001,0.43551596299999995,0.34254738700000004,0.248871323,0.15710178,0.0696826016,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0216764211,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.273491907,1.84866223,0.698244073,0.0,0.0495008671,0.7210736090000001,0.0,0.0,0.316442257,0.782795648,1.07039868,0.909083263,1.80700097,0.0,0.537998327,1.26463477,0.127090497,0.15056704199999998,1.47464472,0.044710066500000006,2.45153391,0.0,0.0,0.0,0.85965708,3.12427259,1.41897937,1.49263454,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.37322531,4.01899524,3.49750683,2.85406606,2.14416666,1.42716116,0.75963131,0.18929461,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09968363,0.19937506,0.24162533,0.23272216,0.18832079999999998,0.12986593,0.08028229,0.05962616,0.08138261,0.14998517,0.25994192,0.39670306,0.53913641,0.66322839,0.7464349,0.77199813,0.73253769,0.63231938,0.48778995,0.32621474,0.18253284,0.09481073,0.09889229,0.22297939,0.48291091,0.8788345999999999,1.39379306,1.99449547,2.63425502,3.25777742,3.80722971,4.22883596,4.47916434,4.53029863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.597056116,0.95554369,1.74641769,2.46129862,1.87451143,0.7829714329999999,0.0,0.0,0.0,0.26793205,0.39055772200000005,0.0368468579,0.0,0.0,0.0,0.37573580100000004,0.663707496,0.76088624,0.27039869,0.253151445,0.0,0.152115114,0.501922239,0.0,0.0123933736,0.123107856,0.278598245,0.0,0.0,0.182646644,0.629467085,0.0,0.0,0.0,0.404836045,0.454481009,0.305241203,0.0,0.0,0.0,0.307831152,0.310318787,0.453886691,0.0,0.47117042299999995,0.0,0.0,0.0,0.0,0.0409996273,0.0,0.0,0.009189553670000001,0.446980879,0.0,0.23176195800000002,0.0666145247,0.386822858,0.0463996051,0.0,0.0,0.212067376,0.0,0.0,0.268434945,0.121736278,0.0,0.0,0.0,0.35048614200000006,0.0,0.39472910200000005,0.0,0.40315708899999997,0.0,0.0,0.0449183175,0.0,0.0,0.29025177399999996,0.0127016776,0.439770299,0.295726124,0.0,0.19766961100000002,0.0,0.0,0.00801367527,0.13944700599999998,0.0,0.129417316,0.0,0.481201936,0.0,0.0,0.20276511,0.0,0.294693495,1.26745846,1.59298556,1.03114298,0.8565980959999999,0.686414567,0.0,0.0,0.0,0.0742503435,0.236102338,0.7465180370000001,0.270207042,0.0,0.0,0.894629132,0.5718927460000001,0.978640078,0.717807049,1.34506006,0.875840906,0.406616611,0.113456795,0.470304079,1.07921552,0.914782688,1.2644768,0.6412524279999999,1.24582337,0.314393219,0.34646495299999996,0.173756248,0.42275439200000003,0.0183677998,0.8967593229999999,0.823379346,0.9823909129999999,0.801779615,0.0937727532,0.46609965600000003,0.0,0.222909992,0.22456092800000002,0.0167260122,0.33650420600000003,0.0,0.0,0.5287145120000001,0.507786949,0.520808618,0.0,0.0,0.115492842,0.0326603059,0.0,0.0,0.495651723,0.0,0.0,0.19749398899999998,0.47952112,0.0,0.623553551,0.0,0.0,0.860875884,2.02370297,2.99722527,5.16585851,5.74212115,5.079406,4.48678467,2.96630229,2.09483475,0.92231102,0.926848621,0.222282767,0.29108835899999996,0.0873999658,0.0863368665,1.26444994,2.41817981,3.15498963,3.85968852,3.03566767,2.89650468,2.35823294,1.31896732,1.33491247,1.8615281000000004,1.28223373,0.8595532459999999,0.5253461070000001,0.0,0.135826636,0.237527419,0.5607655429999999,1.25122197,1.39464035,0.366541236,0.394602761,0.0,0.774797462,1.67599346,1.91271821,1.29132252,0.56216862,0.268605673,0.0,0.0,0.0,0.0,0.458531345,0.0,0.191909876,0.09076976560000001,0.0,0.0,0.644253842,0.334836998,0.0,0.258048042,0.0,0.177342986,0.275463309,0.0,0.0,0.0,0.0,0.379656006,0.544852879,0.987164003,1.19933582,0.285520966,0.366751055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.132650754,0.30080790399999996,0.461249856,0.605518398,0.764817497,1.00503712,1.40183757,2.00344045,2.7954239,3.6831388999999994,4.50227836,5.05815263,5.18298966,4.79248217,3.92127223,2.72312252,1.43328461,0.303856856,0.0,0.0,0.0,0.0,0.0819314583,0.40073682200000005,0.500025342,0.368329753,0.0848890991,0.0,0.0,0.0,0.0,0.0934552701,0.444675206,0.7219496790000001,0.860934602,0.8538336059999999,0.7443506670000001,0.603513557,0.49784041100000004,0.463296515,0.49491668,0.554692499,0.5925743760000001,0.570437058,0.47848999999999997,0.33771939799999995,0.188493773,0.07149637610000001,0.0100909835,0.0019722764499999997,0.0232678258,0.0423878457,0.0365425964,0.00289112607,0.0,0.0,0.0,0.00719315982,0.0921048694,0.16766481,0.198969024,0.168327353,0.08551534820000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.58195388,0.0,0.0,0.0,0.0,0.0157046061,0.0,0.0,0.0,0.0,0.0,0.46380157200000005,0.0,0.0,0.0,0.0,0.0,0.5460994220000001,0.0,0.0,0.550038887,0.640322883,0.12737599300000002,0.0,0.0,0.119619503,0.0,0.0,0.0,0.233035462,0.0,0.0,0.210776365,0.507765522,0.0,0.800043907,0.0,0.37184183600000004,0.636546107,0.357463033,0.0,0.0,0.18028602800000001,0.24339124899999998,0.0,0.0,0.0,0.0,0.0594449842,0.04881662639999999,0.38159895899999996,0.0,0.348568251,0.0,0.0,0.449371828,0.0,0.401469023,0.720433213,0.96639963,0.832512797,0.193625015,0.0,0.0,0.0,0.6463247010000001,0.636213821,0.0,0.5136589570000001,0.0,0.590432755,0.119031444,0.11381744699999999,0.339496598,0.0,0.0,0.209768177,0.361070788,0.0,0.0212585147,1.01490212,0.781438493,1.11170386,0.8126556840000001,0.6798752379999999,0.0,0.0,0.0,0.12083459699999999,2.83453591,5.69947977,7.01587685,8.04363221,6.59660926,3.02680096,2.00841632,0.290699495,1.0092287,1.01480932,3.09672497,2.52687218,2.62955504,0.594018914,0.0,0.0,0.0,0.0,0.18567647699999998,0.172848316,0.0,0.21614832399999998,0.0,0.540291098,0.243484305,0.355432335,0.0,0.554145172,0.661299713,0.329248194,0.06262240000000001,0.0,0.0,0.0,0.0,0.0,0.0,1.75289423,0.941320293,2.48225024,1.31954441,1.81550942,0.0724637891,0.8094276109999999,0.0,0.512782611,0.0175105267,0.0,0.0,0.37310099399999996,0.025191531099999998,0.656001768,0.0,0.0,0.0,0.34911280200000006,0.0444508451,0.0101714083,0.0,0.0,0.335676816,0.637038586,0.0,0.0,0.278950173,0.0,0.499710926,0.0635250128,1.20697586,0.8508790279999999,0.622913325,0.791267165,0.969040054,0.0,0.0,0.455911636,0.0,0.0,0.0,0.8407119270000001,0.30000311,1.05637462,0.527212048,1.62273622,0.970489255,0.748633632,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8849810140000001,2.66923004,3.68966481,4.1176264,3.30258841,1.23669237,0.319131245,0.0,0.0,0.0,0.0,0.56605507,0.140795172,0.0,0.0,0.0,0.0,0.33634048,0.0,0.268534425,0.486092714,0.46943947799999997,0.030751353399999997,0.0,0.588905595,0.598213165,0.0,0.0,0.274124011,0.0,0.16343755,0.0,0.487746774,0.0,0.359438241,0.027423535099999997,0.0,0.0,0.0,0.0,0.352026471,0.595005482,0.51908861,0.0479237618,0.332593491,0.290623601,0.0,0.158798886,0.287730052,0.407382814,0.0,0.0,0.0,0.568043932,0.38225775100000003,0.364834805,0.44036954700000003,0.544780951,0.0,0.758403736,0.0,0.677827636,0.13346132,0.0,0.0,0.136402172,0.0,0.0,0.12051293199999999,0.0710451842,0.0,0.378077513,0.0,0.0,0.267256445,0.0,0.0,0.159707488,0.0,0.264637721,0.311019942,0.127535289,0.0,0.0,0.0,0.40504352,0.784985912,0.0,0.883754554,0.7827218659999999,0.6862721909999999,0.716835001,2.15395684,4.21240981,6.07296835,6.98196588,6.28066422,5.02758483,2.67020462,0.0,0.0,0.0,0.0,0.20222504,1.14263507,1.14524033,0.28399729,0.0,0.0351160058,0.27852993600000003,0.806083355,0.8972659709999999,0.682014329,0.937906114,0.687299248,0.0,0.045665410499999996,0.20130308800000002,0.8879391459999999,0.610932314,0.6426215989999999,0.0,0.0,0.589921875,0.0,0.743010429,0.0,0.0,0.0,0.261719016,0.0,0.0,0.651478374,0.6473723229999999,0.0,0.0,0.436626426,0.0,0.0519984992,0.0,0.0,0.40507854600000004,0.000368695398,0.381967345,0.0,0.262426378,0.099152325,0.0,0.0,0.0,0.0,0.49921560600000003,1.1134351,0.879830077,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.11158750099999999,0.0440369251,0.024227678500000002,0.441836015,0.341611999,0.40508810799999995,0.383038426,0.759036113,0.621395732,0.682964589,0.7216216609999999,0.79734003,0.308818827,0.32292246399999996,0.218484641,0.6086418570000001,0.7315825640000001,0.390471667,0.374777484,0.438864484,0.13054428099999998,0.0,0.41194082,0.306205244,0.0650959988,0.0,0.0,0.0867524157,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.318172609,0.0,0.296062365,0.0759687385,0.475387081,0.525082523,1.04470758,0.819654922,0.921595633,1.27544767,1.77375224,1.7871505,2.11992533,1.9323653000000003,2.0383351999999997,2.0700228,2.30627161,2.44844685,2.63387923,2.75403471,2.92465723,3.01834106,2.77096122,3.19564087,2.92150271,2.84174841,3.19313069,2.99854613,2.70429764,2.9816052,2.91524603,2.51084637,2.12796802,2.25241646,2.22872137,1.85252412,1.54048094,1.30237976,1.53942418,1.44619937,0.739121803,1.05447647,0.934512716,0.29793036300000003,0.611411394,0.0,0.19164854399999998,0.0,0.115243753,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.136107906,0.14572289900000002,0.37125726700000006,0.0,0.285319655,0.49101719299999996,0.137667033,0.39016933299999995,0.17554779899999998,0.36269049200000003,0.457215126,0.35518864299999997,0.09751106130000001,0.137907909,0.321131577,0.0,0.0,0.20797364,0.198553261,0.185064742,0.0,0.0432555941,0.20930011899999998,0.11150239699999999,0.09210208800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.017657627,0.22392887399999997,0.06832747230000001,0.0,0.10399016,0.0,0.28130820300000003,0.263124746,0.276946185,0.0053060203,0.165258001,0.167339515,0.270051862,0.10533690300000001,0.0889185387,0.0,0.326031632,0.0,0.0,0.0178007646,0.0,0.0963019001,0.140255301,0.186530904,0.0,0.10004180900000001,0.293960348,0.123889839,0.09053954619999999,0.0,0.19694645800000002,0.24028452100000003,0.0748751721,0.0,0.10345436599999999,0.244062136,0.185801994,0.135507097,0.171356326,0.0,0.0,0.142902866,0.135513751,0.0369261839,0.0,0.008285141269999999,0.0,0.0,0.0,0.283440704,0.053247505199999996,0.0,0.0,0.15459344,0.0,0.146346528,0.0,0.101575712,0.0,0.0899539603,0.23410935600000002,0.175861386,0.0154492511,0.0,0.0,0.0,0.0727547521,0.10825212599999999,0.137088794,0.0,0.13400784400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.308374069,0.0,0.45831233200000004,0.0,0.0,2.91035077,3.78081806,1.4747655000000002,0.750224233,0.834948288,0.100230659,0.0245787152,0.0686369741,0.0,0.09372524480000001,0.0,0.0,0.127884734,0.0,0.0,0.136664869,0.0,0.101785384,0.0961821475,0.0,0.45673827,0.0,0.0,5.7451105,12.6349424,8.46635867,1.07211692,0.0,0.0,0.31393882,1.79074018,1.18983993,0.0,0.600848264,0.5791517279999999,0.0,0.072941853,0.098328736,0.0,0.136290575,0.0,0.0,0.17491011899999998,0.0,0.0,0.231591502,0.0,0.42532289799999995,2.08122406,0.923557471,0.0,0.861455715,0.599304042,0.0,0.9475663040000001,2.08225822,0.468248912,0.0,0.155013619,0.00609594761,0.0,0.0914929736,0.0,0.0455186111,0.206931103,0.07599617759999999,0.0,0.0018590445899999998,0.0,0.025874612400000004,0.154236697,0.166524339,0.0,0.0321535281,0.0,1.1406041,4.92152361,6.10156554,1.85960064,0.0,0.564760054,0.0,0.0,1.37513553,0.82804539,0.0,0.0826624976,0.0,0.490024766,1.34932354,0.35884147899999996,0.0,0.064506465,0.00758681125,0.0,0.0,0.0153680454,0.0177226634,0.0,0.0721554672,0.0,0.0,0.122692039,0.0,0.0127550058,0.125167671,0.0,0.158290589,0.0336611733,0.0,0.410451688,0.0,0.0,1.77764037,0.817963725,0.206855028,3.1061366,2.21591941,0.0,0.078200416,0.335728432,0.0,0.24629440800000002,0.0249867827,0.0,0.25016684699999997,0.0,0.0,0.18069057100000002,0.0,0.0627928966,0.07838554589999999,0.0,0.131791192,0.0,0.0,0.143993822,0.0,0.0,0.106308598,0.0,0.07805965940000001,0.0332803396,0.0,0.141027236,0.0,0.0,0.186737278,0.0,0.0785346087,1.20364891,1.80410552,1.57215266,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.183665293,0.28260918,0.35115702,0.316708382,0.183769015,0.0329032092,0.0,0.0393936474,0.21040367100000001,0.36623706,0.38984240000000003,0.241415963,0.0,0.0,0.0,0.0,0.315168055,0.5586113779999999,0.5795903139999999,0.36733058700000004,0.0689725397,0.0,0.0286524329,0.39992566,0.785304569,0.8766326320000001,0.48873884799999995,0.0,0.0,0.0,0.0,1.09244986,3.26264833,5.20738185,6.19479932,5.83361164,4.25786897,2.0691604999999997,0.0629709578,0.0,0.0,0.0,0.217950074,0.7990329759999999,0.8205220520000001,0.366005839,0.0,0.0,0.0,0.0,0.260762923,0.505261229,0.41701981299999996,0.0787100734,0.0,0.0,0.0,2.1306455500000002e-16,0.31895113,0.463055695,0.397928712,0.252875953,0.244606027,0.545950273,1.17662843,1.97811877,2.68513778,3.05219882,2.96595479,2.48630962,1.80174181,1.13081888,0.6263372220000001,0.32959648199999997,0.18867537899999998,0.117971775,0.0577233779,0.0,0.0,0.00397313407,0.087582151,0.183401195,0.23992570300000002,0.22723957399999997,0.155196643,0.0654812807,0.00397964844,0.0,0.0180932677,0.045849010700000005,0.0448585871,0.00955940433,0.0,0.0,0.0,4.877180830000001e-16,0.050576965599999996,0.0695289845,0.043372666500000004,0.0,0.0,0.0,0.0,0.0238579913,0.06770959559999999,0.0681280621,0.0243053204,0.0,0.0,0.0,0.0,0.0471477564,0.07630000519999999,0.055581114699999996,0.0,0.0,0.0,0.0300179175,0.151710697,0.265898875,0.314081645,0.267198568,0.144402552,0.00660818344,0.0,0.0,0.093175353,0.286838184,0.458782142,0.539043646,0.497044011,0.35277743899999997,0.164421369,1.46481882e-16,0.0,0.0,0.0,0.0120787872,0.0537080233,0.0551960152,0.0243606741,0.0,0.0,0.0,0.0,0.0165213085,0.0318579704,0.0262105963,0.0049380347799999995,0.0,0.0,0.0,2.19722823e-16,0.0191912229,0.0255894677,0.0155766048,0.0,0.0,0.0,0.0,0.00805786279,0.0227723931,0.02285565,0.00814502353,0.0,0.0,0.0,0.0,0.0160523388,0.026315329300000002,0.0196362193,0.0,0.0,0.0,0.0,0.0046434958,0.0238716191,0.027927626,0.0138456376,0.0,0.0,0.0,0.0,0.014331941899999999,0.0292639284,0.025278879100000002,0.004957931279999999,0.0,0.0,0.0,2.6633069399999997e-17,0.0203901259,0.0264697557,0.0153766149,0.0,0.0,0.0,0.0,0.00188565103,0.0,0.0,0.0,0.0332866294,0.132001018,0.264901298,0.38246715600000003,0.426579389,0.362733945,0.20478940199999998,0.0157427394,0.0,0.0,0.0,0.146829254,0.301209861,0.354191862,0.281787352,0.128034799,0.0,0.0,0.0,0.133886149,0.296091906,0.394815865,0.397896087,0.329635761,0.24926767600000002,0.20924996199999998,0.220398352,0.24615910600000002,0.22964818,0.136089772,0.0,0.0,0.0,0.0,0.101870979,0.386777418,0.638062712,0.784611009,0.809440115,0.747214802,0.653357831,0.566631918,0.489681291,0.398647915,0.27269936899999997,0.120694336,0.0,0.0,0.0,0.019529889499999998,0.106856627,0.133066229,0.0779532186,0.0,0.0,0.0,0.191706756,0.45257026,0.668541807,0.742772,0.648885972,0.447284245,0.24983936899999998,0.153517967:0.23
1.22111555,0.0,0.0,0.0,0.0,0.0,0.0,1.87995441,0.0,0.68419276,0.0,1.2482672,2.76427905,18.37161589,13.26202091,0.87700699,0.4786829000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.24600000000000002
0.19402401600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33095347,0.276849754,0.67817469,1.08479644,1.94901283,1.71344754,2.76589657,3.15777579,3.47280604,3.47254795,4.14540948,4.10805057,3.79937458,3.84497197,4.1308277,3.56607924,3.61317929,3.29623337,2.78524962,2.32056493,2.14985387,1.95512472,1.70018693,0.840177354,1.21667919,0.594397592,0.241849704,0.621305758,0.25212956,0.39357789,1.05805815,1.19578573,1.3802218000000002,0.93118215,1.09124732,1.69909589,1.67699041,1.20227783,1.75223784,1.17054091,1.7075328999999997,1.4609946000000003,0.8551971009999999,0.74339983,0.67968303,0.6673034999999999,0.330085098,0.506294008,0.0804072353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.36997261,0.43688462200000006,0.327170109,0.541814759,0.409728305,0.315923837,0.637847038,0.0,0.09833191029999999,0.00969058376,0.0,0.0,0.0,0.183828066,0.0,0.149415681,0.101109417,0.0,0.0,0.186991346,0.0,0.0,0.36117172,0.11854688199999999,0.0,0.0,0.446358669,0.19853114,0.373024454,0.24965732399999999,0.0,0.103059966,0.117503267,0.0,0.243172036,0.0,0.0,0.0,0.0,0.0,0.008507999890000001,0.0,0.167586803,0.0,0.0505370889,0.0,0.0,0.26545115199999997,0.42936594299999997,0.0,0.550029941,0.0633409778,0.532731062,0.216048591,0.40949413,0.0,0.0,0.0,0.0,0.162643188,0.0,0.139679357,0.0,0.0,0.0454916308,0.0,0.353920622,0.13487107,0.0,0.210586574,0.466614181,0.57312828,0.497904807,0.0,0.468965917,0.38848519200000003,0.227860404,0.33153896,0.21433364300000002,0.0,0.15830348800000002,0.0,0.165466859,0.0,0.0182603435,0.0654458539,0.143382607,0.219183127,0.0830969032,0.043984008600000006,0.6077888770000001,0.7885936990000001,0.551289015,0.33997588700000003,0.37568691299999996,0.573785057,0.697772725,0.7515293559999999,0.39260830399999996,0.118060347,0.143535562,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.61015827,5.05219938,4.56282581,1.70255394,0.0,0.0,0.9253957709999999,1.1363653999999999,0.264006745,0.0,0.104665944,0.40576602799999995,0.021398558300000002,0.0,0.0,0.389295183,0.212040504,0.0,0.0,0.616986319,1.61556067,1.52106937,0.626019544,0.12098310699999999,0.519838453,1.1203186,1.06162836,0.414835584,0.0,0.0,0.140438673,0.077366597,0.0,0.0,0.0908617015,0.11621971800000001,0.0,0.0,0.0401051922,0.154122539,0.0,0.0,0.0,0.19406253899999998,0.0814328827,0.0,0.0,0.236325263,0.259255318,0.0,0.0,1.18458527,3.43576419,4.6935387,4.09035267,2.63911146,1.86580428,2.08443746,2.44132921,2.2155836,1.48423243,0.6853610090000001,0.12094507800000001,0.0,0.20906950600000002,0.642641792,0.825519365,0.610892515,0.270586675,0.08915524279999999,0.0464791363,0.011905323,0.0,0.0311196994,0.0241696118,0.0,0.0,0.0821224009,0.12247458,0.0,0.0,0.13924356400000001,0.899514934,1.27524891,0.9038355090000001,0.27818661100000003,0.0407664245,0.178233643,0.23926969899999997,0.0717003323,0.0,0.0,0.0255976492,0.016898844399999998,0.0,0.012423903899999998,0.0,0.0,0.00376885278,0.10189945,0.061120712599999995,0.0,0.0,0.272595898,0.647847811,0.820851542,0.930524494,1.21506978,1.66990216,2.25582703,3.05440087,3.74713145,3.37916176,1.53189803,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.80492492,2.4072812999999997,1.74162867,0.958521099,0.232829846,0.0,0.0,0.0,0.0,0.326664816,0.698488434,0.904417143,0.884707641,0.652314075,0.28398409199999997,0.0,0.0,0.0,0.0,0.0,0.0136299182,0.269859113,0.41730968700000004,0.414748481,0.27249748100000004,0.046131819500000004,0.0,0.0,0.0,0.0,0.0,0.119586841,0.283289959,0.344867747,0.286319304,0.1308533,0.0,0.0,0.0,0.0,0.0,0.0182244625,0.19395164,0.300831367,0.302539323,0.199149529,0.026886875600000002,0.0,0.0,0.0,0.0,0.0,0.11525602,0.263541364,0.321139633,0.266889825,0.118203636,0.0,0.0,0.0,0.0,0.0,0.029741787599999996,0.22306094,0.343074702,0.345308501,0.225281697,0.021411347,0.0,0.0,0.0,0.0,0.0,0.159596658,0.346225602,0.408587729,0.322190154,0.125633978,0.0,0.0,0.00964682548,0.532249277,1.41202186,2.56441166,3.82135452,4.96619003,5.78418933,6.11522322,5.89403497,5.1667646,4.07893714,2.8381779,1.66208125,0.725806035,0.123859249,0.0,0.0,0.0,0.0613138534,0.0827204354,0.0,0.0,0.0,0.0,0.08707782,0.5918611579999999,1.2603231000000001,1.96247226,2.53954757,2.84870985,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.26465292,0.87262099,1.24387154,3.43367283,4.68052938,3.65227638,5.127019799999999,6.38957285,4.1587328999999995,5.23819117,4.12493184,3.80857633,5.21262751,3.84533527,1.52796,0.0,0.79047634,0.62422687,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15296568,0.30561544,1.39736573,0.39274576,0.25624888,0.0,1.51187746,0.13526562,0.0,0.0,0.0,0.0,0.0,0.29210336,0.0,0.15624958,0.35897459,0.0,0.94620361,0.0,0.0,0.0,0.0,0.19012011,2.24945457,0.0,2.12127777,1.78288948,0.12279254,0.79146049,0.0,0.0,0.27768607,1.43269936,1.05964763,0.0,1.15487178,2.56045586,0.67524993,0.4268914000000001,1.21774991,1.50995632,0.81056106,1.29273441,0.0,3.30465358,2.25964804,2.38019787,0.0,1.15677264,0.0,1.53431473,2.22221421,1.31199043,0.0,0.27197839,0.0,0.0,1.06611697,0.0,0.0,1.40751211,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45275562799999997,0.86185967,0.347808227,0.00857468745,1.22549653,1.25401462,0.7702106009999999,1.41400591,1.87616759,1.98134497,1.718848,1.71021748,2.17563213,2.0771593,2.42439044,2.22963782,2.962814,4.05568005,2.22249922,1.42236244,2.73834881,3.19734993,3.28721463,3.34483876,2.34089417,3.01630615,2.61255177,2.18069372,2.70646517,1.90509084,2.95780747,3.03441833,2.07352539,2.24915847,1.81049038,1.78299067,1.32576421,1.78193172,2.20888293,0.8878940559999999,0.31727604800000003,1.22448835,0.9449590729999999,1.91038439,1.69058843,0.163500242,0.6857721290000001,0.281803906,0.155545344,0.0,0.0,0.0,0.211007525,0.36126420200000003,0.0,0.16964018399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.23636233899999998,0.0,0.0,0.0,0.0,0.0,0.0771660597,0.0,0.0675799193,0.537955065,0.0147157695,0.996420425,0.0,0.0,0.850647629,0.0,0.0,0.8465889329999999,0.0361988683,0.20792389,0.0,0.0,0.0,0.434174383,0.35989747,0.0,0.933426003,0.320509424,0.540823446,0.0,0.363081924,0.467407571,0.9740205390000001,0.0,0.0,0.0442444699,0.0,0.198152933,0.0716149495,0.0237041411,0.0,0.0,0.0,0.0213360704,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.254534213,0.0,0.0,0.257351383,0.0,0.0,0.0,0.0,0.116401189,0.0,0.116896931,1.79000027,0.0,0.481420553,0.158257263,0.0,0.0,0.126863064,0.924225662,0.7492196870000001,0.11498881,0.0,0.0,0.237746232,0.0,0.046807807300000004,0.0,0.15775007300000002,1.02481361,0.411255534,0.0,0.262611307,0.0,0.0,0.0,0.0,0.0,0.0,0.236786692,0.0,0.0,0.0,0.0,0.0,0.0,0.839969458,0.0,0.0,0.0,0.0,0.0,0.0,0.531451156,0.0740509511,0.0,0.0,0.0,0.35250798299999997,0.0,1.48574429,0.528288864,0.549010064,1.09840938,0.930696418,0.9131736840000001,0.122271528,1.35373061,0.10317697699999999,1.06292364,0.0,0.0,0.456476823,1.57524151,0.126576962,0.0,0.0,0.0,0.710227157,0.0,0.292626891,0.8364864540000001,0.0,0.0,0.0,0.0,0.242513975,0.0,0.855289557,0.0,0.0,0.0,0.215041708,0.0,0.0,0.0,0.0,0.0,0.18305295100000002,0.0,0.0,0.0,0.324699367,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.64779689,2.71484158,3.52504617,2.92077851,2.28742286,1.8732952,2.25559691,1.70813312,1.96492791,2.05572136,1.4247658,1.78297737,1.38017545,1.07509936,0.5622903260000001,1.16355634,0.81172962,0.216438372,1.2497656000000001,0.0,0.0,0.14022116199999998,0.495459663,0.159641675,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.106412207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.15528909,0.0,0.290162213,0.32897329999999997,0.0,0.135682965,0.0,0.275267642,1.1972973999999998,0.592416125,0.7384060729999999,1.27564257,0.9668256690000001,0.0,0.0,0.44019219200000004,0.0,0.243809238,0.299346187,0.6522603020000001,0.0,0.0,0.34709108899999996,1.2999701000000001,0.0850132609,0.0,0.0,0.0,0.124981865,0.0,0.047307935499999995,0.0,0.0,0.0,0.0,0.0,0.166677939,1.05557016,0.00656502101,0.0,0.40050843,0.0,0.0,0.0,0.0,0.0,0.496145124,0.6941094040000001,0.0,0.0,0.389527712,0.477989472,0.0,0.307491236,0.0,0.0,0.0,0.420689839,0.734364639,1.56471333,0.0,0.0,0.0,0.0,0.366018621,0.0,0.0,0.10042927900000001,0.0,0.0,0.0,0.0,0.027126622000000003,0.120637036,0.94922463,0.632208587,0.0,0.0,0.275500322,1.06617119,0.0,0.219563645,0.0,0.22765164899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.586430679,0.0,0.012677733500000002,0.0,0.29678208100000003,0.231917559,0.0,0.0,0.0,0.0,0.466989789,0.0,0.9001008229999999,0.66986242,0.0,0.0,0.0,0.43684707899999997,0.0,0.0,0.0,0.21412665399999997,0.7730855090000001,0.0,0.382340613,0.193197095,0.09381098310000001,0.0,0.0,0.0,0.0,0.579215036,0.837604427,0.839694093,0.744246803,1.52220067,0.349638706,0.0619011268,0.0,0.21150557899999997,0.0,0.0,0.0,0.0708287883,0.60020099,1.510786,0.43610466,1.21014431,0.709335725,0.268115488,0.031059946,1.28544707,1.66826476,1.42517206,1.13093493,1.06840305,1.09012201,1.1864985000000001,2.01060773,1.91271364,2.04347469,1.76901788,2.75956232,1.86794427,3.06724515,2.77105496,3.41321892,2.93249998,2.90378442,2.99747409,2.10183873,2.83071739,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.231365811,0.0,0.17075735,0.271061286,0.0,0.153593211,0.654662164,0.679132255,1.62869588,1.79335023,2.1330736,2.91478974,2.6937355,3.30236915,2.54121709,2.61515368,1.44705983,1.11773061,0.581277106,0.895501641,0.724919995,0.7655587229999999,1.21056809,2.05834563,3.56994334,3.58109021,4.29005953,4.64062166,4.19802444,3.95762144,3.82791816,2.42537275,2.17902403,1.47351978,0.467964072,0.32514993,0.0,0.378688181,0.46960675700000004,0.32692374399999996,0.536990481,0.18022861199999998,0.467727775,0.180484323,0.250901213,0.0,0.0,0.0,0.0435949199,0.0,0.510704531,0.5313792479999999,0.40571365299999995,0.0484490642,0.21363548899999998,0.298561137,0.0,0.0,0.0,0.011583591,0.34154344600000003,0.0,0.403450184,0.550452694,0.312041044,0.319738151,0.0,0.0,0.0,0.0,0.07448617190000001,0.0,0.0,0.24842694399999998,0.752524933,0.40861717,0.7864201759999999,0.80368891,0.986501126,0.925098416,0.0938364395,0.614162612,0.257782415,0.25949088,0.0137850926,0.20890115,0.14698279,0.49589689600000003,0.431012655,0.281465421,0.597019008,0.22577988899999998,0.19527369100000003,0.0378728549,0.393610012,0.0,0.0,0.0,0.393601401,0.0,6.66217962e-05,0.0662502284,0.0,0.156876764,0.20576777899999998,0.207160436,0.187286271,0.0,0.198492,0.524238919,0.215263731,0.0346393519,0.0,0.0129703341,0.0,0.0,0.0,0.0,0.0260634044,1.01229603,1.46385545,1.74422701,2.24068774,2.90450871,2.64419615,2.69046493,2.2772047000000004,1.86842372,1.46466789,0.467507031,0.301686803,0.276317301,0.0,0.00302608348,0.240796258,0.0,0.42857758,0.785813348,0.0,0.367470699,0.44245856200000006,0.0,0.0,0.278932739,0.07745778,0.0,0.46094765200000004,0.804023035,0.10866953,0.7981737740000001,0.907882579,0.804196317,0.854521148,0.0796182873,0.14323929300000002,0.0527911298,0.290511566,0.437656479,0.0,0.272627388,0.328985317,0.326920706,0.0,0.081576147,0.0,0.0,0.119498631,0.0,0.41643602,0.199222476,0.422152087,0.0,0.0,0.0,0.0,0.0,0.385094795,0.0699592307,0.0,0.0,0.0,0.200350957,0.0,0.35713333,0.0,0.0,0.0,0.336658908,0.0,0.215313463,0.29067684899999996,0.0,0.24262531399999998,0.0,0.177368387,0.376619957,0.0826056796,0.42983824299999995,0.00448201031,0.299407468,0.086525945,0.224591565,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.68175759,0.0298880601,1.77908471,1.32811173,0.0,1.02408674,0.0,0.6796054109999999,0.265905945,0.8913976509999999,0.91257082,1.40209215,0.350636424,0.999674745,0.243936995,1.89822618,0.0,0.0,0.0,0.0,0.145669291,0.0,0.956599255,1.04152171,1.86110328,0.0,0.0,0.0,0.0,0.36284208100000004,0.0,0.0,1.22357496,1.46143333,1.48997865,0.0473289805,0.0,0.135521312,0.703672147,1.09810751,0.7980994090000001,1.22724287,0.462755057,0.0,0.0,0.0,0.451836351,1.74751038,1.69925636,3.30018427,3.61747706,3.8518123999999996,3.70896397,1.40076475,2.4214306,1.31636387,0.0,0.0,0.13316502,0.0,0.0,0.77131545,0.0,0.0,0.0,0.0,0.0,0.0,1.80643985,0.6854477440000001,2.64856273,0.0,0.8395727829999999,1.94379223,0.0,0.0,0.7253809590000001,0.0,0.652320562,0.502751709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0805069161,0.0,0.0,0.0,0.7954294890000001,0.0,0.0,0.363512799,0.057215301600000004,0.0,0.0,0.43568396200000004,0.0,0.0,1.32075009,0.0,0.0,0.733977202,0.384696969,0.453212438,0.55014274,0.709289561,0.352692845,1.47338472,0.992251887,1.5006137,0.644580258,0.40898016,0.83146884,2.47642862,3.16446175,2.50863674,2.05396431,0.46230184399999996,0.49173599100000004,0.618119506,0.344418625,0.0,0.0,0.0,0.0,1.04770224,0.157029281,0.0,0.746747321,0.0,0.0,0.6865118259999999,0.131840182,1.41182902,0.0,0.0,0.0,0.0,0.0,0.736287375,0.0,0.0,0.0,0.0,0.757817953,0.0,0.26682135100000004,0.30317978,0.0,0.362185211,1.14971502,1.24686906,1.30667101,0.0,0.28100807,0.0,0.0,0.9272753440000001,0.6477596520000001,1.51501995,0.45667178,0.0,0.0,0.0,0.0428650279,0.061563012300000004,0.0,0.814457962,0.0,0.908184185,0.38334842700000005,0.0,0.180468623,0.0,0.0,0.0,0.945154842,0.0,1.02804769,0.6529184060000001,0.41357822,0.783236011,0.140594783,0.0,1.10998701,0.0,0.127974933,0.0,0.621874028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0751627843,1.16987707,2.85430045,4.84805385,3.06265799,0.815039168,0.322357355,0.899916011,3.55142291,4.73883265,2.69759531,0.162382148,0.0,0.321537676,0.526728078,0.8121447190000001,0.0,0.0,0.19475073199999998,0.0,0.191167797,0.0,0.0,0.126450424,0.0,0.278876242,0.0,0.166540184,0.5708688679999999,0.0800129233,1.21219224,0.795624482,0.266259282,0.42334765799999996,0.0022756722699999996,1.25718138,1.05516253,0.0,0.82072426,1.44798088,0.178711968,0.22324527600000002,1.18709596,0.0,0.877331968,2.89539055,0.559207239,0.0,0.248887257,0.0,0.428445189,0.38049913,0.030236347599999998,0.0,0.181541945,0.388786618,0.0,0.113407652,0.106784442,0.0,0.059559252400000005,0.0,0.00433938159,0.0999012425,0.0383743902,0.0,0.0853999402,0.0,0.0,0.061865793499999995,0.0,0.17646610399999998,0.0,0.892574237,3.19940087,1.94238847,0.0862226778,0.0787691703,0.0,0.0123325665,0.0149158395,0.0,0.0132382771,0.00112565763,0.0,0.0019435985600000003,0.0232772984,0.0,0.09728677289999998,0.0,0.0837135494,0.022441943399999997,0.0,1.71965872,1.78395915,0.0,0.062369168600000004,0.0299443454,0.0,0.0310365263,0.0277822753,0.0,0.066547247,1.38030929,0.595691746,0.0,0.42734307299999996,0.0,0.0073359462099999995,0.0854832851,0.0,0.16437639199999998,0.0,0.0877414476,0.24198466100000002,0.0,0.0509739638,0.0,0.0530680912,0.0,0.0,0.056202980599999994,0.0,0.09605989390000001,0.0,0.040535268,0.799964166,0.423494449,0.0,0.564365809,0.0525431329,0.380952399,3.41897802,3.3668546000000004,1.72649564,1.29564223,0.33840062,1.78550726,2.19792891,0.267848539,0.061820985599999996,0.00671588151,1.09833712,1.14112631,0.0,0.39487005799999997,0.0,0.650145112,1.94906693,1.31996098,3.94779509,2.67502864,0.0,0.308578507,0.148603765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0697254591,0.0161453643,0.0,0.599542954,0.459314701,0.04967831,0.0,0.0,0.5399847179999999,1.55418846,1.89051113,1.59686602,0.7553327790000001,0.0,0.0,0.0,0.040704175,0.11343506099999999,0.289212872,0.0486590712,0.0,0.112808591,0.0,0.165556654,0.0,0.0,0.219959645,0.143252351,0.0,0.0,0.08784654720000001,0.166626122,0.139256732,0.0,0.062160499800000005,0.0,0.223458237,0.0,0.226771837,0.09434385320000001,0.0,0.23291055300000002,0.0,0.20342521600000002,0.005763260629999999,0.0,0.17867516,0.13011642,0.34178828299999997,0.272192714,0.132206913,0.0,0.0,0.14220370699999998,0.253720541,0.0,0.20328891600000001,0.0,0.06704454879999999,0.0,0.0,0.0,0.17261851399999997,0.287435596,0.138127527,0.0054438681599999995,0.0,0.0,0.0,0.148017284,0.0,0.0,0.0,0.0,0.0,0.194535652,0.0,0.0603612049,0.0,0.0,0.059390998099999995,0.12652312,0.428483997,0.0,0.0,0.0,0.20070748,1.59777229,2.99927586,3.12233187,1.78404586,0.7005850440000001,0.0,0.0,0.0,0.49270157700000006,0.504259107,0.296394906,0.42445568100000003,1.09684702,1.37795566,1.04685924,0.733611954,0.254128449,0.009203785459999999,0.213015323,0.35581164,0.265217878,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0574661334,0.510782744,0.956926955,1.35182305,1.66213777,1.8675800999999999,1.96133092,1.9487888,1.84502877,1.67149718,1.45249935,1.21198147,0.970985322,0.745991348,0.548194865,0.383611253,0.253800221,0.156948596,0.0890551123,0.0450093725,0.0194332874,0.00723700387,0.00391396761,0.0056479865,0.00932271486,0.012512491200000002,0.013501104299999999,0.011334093799999998,0.00587372123,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000960307761,0.0168555547,0.0315233808,0.0416942052,0.0446266775,0.0387670425,0.024228631,0.0029662355699999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0242385373,0.0577286847,0.0829636877,0.0940743764,0.0874825953,0.0628344561,0.0233653919,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0208734054,0.08698093949999999,0.142008824,0.17404614899999998,0.17459203399999998,0.140525951,0.0752125751,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12884627199999998,0.257527453,0.351272796,0.386883706,0.349084713,0.234344351,0.0531093028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33526607199999997,0.959377105,1.6622103,2.38119385,3.04699118,3.59183068,3.95791912,4.10478539,4.01454025,3.69432524,3.1756179,2.51049916,1.76540859,1.01324943,0.324911943,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.54490767,0.88137815,0.46136573,0.46731582,0.54999924,0.0,0.65503842,0.0,0.1747366,0.07838896,0.0,0.0,0.60377967,0.73002063,0.44473635,0.11917538,0.21512526,0.35671825,1.11260121,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.98432694,1.1110381,1.05055469,0.35972794,0.80397089,0.0,0.37163744,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.63624272,0.19638991,0.69307983,0.56836355,0.0,0.43718034,0.27232509,0.13157267,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.2576729,1.07606422,1.32017249,1.14347854,0.0,0.33380125,0.0,0.0,0.0,0.0,0.0,0.34038386,1.22050803,1.1296708,3.04904747,4.06380158,5.17169837,5.40600103,6.27589897,7.0455912,5.76346323,5.1543425,5.01056266,3.74890844,2.36795528,0.90910313,0.5474299,0.0,0.0,0.0,0.0,0.0,0.26782669,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.538107695,0.0,1.55215699,0.0,0.23106020100000002,0.0,0.0,0.5469964079999999,0.0,0.0,0.0,0.824633925,0.0,0.174853444,0.0,0.0,1.0739272,0.0,0.11383197099999999,0.250533671,0.0,1.53088854,0.754224012,2.7972627999999995,3.65986726,3.75658063,1.40285158,1.67626561,0.94700666,0.218081893,0.484647359,0.0,1.37952709,0.0,0.0,0.790292057,0.0,0.368638105,1.14523373,2.01066113,0.0,0.0380832728,0.0,0.0,0.0,0.0,0.0,0.8410523209999999,1.8753518,4.34364402,5.21663086,4.56359438,1.84938885,1.5371107,0.587730005,0.0,0.0,0.0,1.2537257,1.15615974,0.40810566600000003,0.544039211,0.7699793779999999,0.0,1.8473240000000002,3.02996155,0.0,0.0,0.942380455,0.0,0.0,0.0,0.0,0.0,0.486601667,0.22172832899999997,0.738698918,0.0,0.0,1.07717187,1.04187139,0.0,0.0,0.84315509,0.86838058,1.95954008,0.0,0.429221045,0.8006897709999999,0.0,1.07771879,0.411674145,0.0,0.40109516100000003,0.6107922029999999,0.943953543,0.17010495,0.470799541,0.0,0.162169603,0.46655124600000003,0.305234435,0.0,0.989060785,0.0,1.41742827,1.36977121,1.63204621,1.40089454,0.0,0.0,0.0,0.0,0.16762847,0.749422002,1.26076802,0.0,0.329383851,0.13599112800000002,0.15678081,0.0,0.0,0.0,0.0,1.16891383,0.0,0.483345331,1.26718801,0.0,0.0,0.0,0.0,0.0,0.0,0.8573514309999999,0.0,0.5400295,1.29573519,2.46217286,0.660064329,0.0,2.81695103,0.17816152,0.9449810809999999,1.53480441,0.32010973600000003,0.0,0.0,0.268257197,0.0909608393,1.90023445,0.43184518899999996,2.02228932,1.05281241,0.0,0.0,0.0,0.0,0.8558602409999999,0.128003528,0.0,1.20756801,1.29787399,0.7715493729999999,1.08764984,0.0,0.0,0.7720955979999999,0.0707603611,0.391356136,0.784798415,0.755826971,0.30144664,0.0,0.0,0.0,1.04942482,0.8807529270000001,1.22755307,1.47719316,0.41253857200000005,0.8839236540000001,0.599832473,0.787441122,1.03455095,0.0,0.0,0.8306523790000001,0.0,0.207220137,0.0,0.0,2.15978798,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.67372419,0.555282381,0.0,0.0,1.55006364,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.61098379,0.0,0.5152340879999999,0.19818080100000002,0.303716973,0.37879305399999996,1.00060172,0.0,0.0,0.26294615600000004,1.22394426,0.0,1.10948474,0.339802581,1.43144619,0.546079378,0.0,0.271055778,0.43825862600000004,0.37959499399999996,0.0,0.0,0.180478978,0.0,1.68874441,0.385424931,2.86990075,2.70987691,0.669940455,1.28045616,1.10482792,0.8697759,1.54938512,0.060759016799999996,0.0,0.0,0.0,0.0,0.0,0.8526524,1.51835699,0.0,0.0,0.0,0.0,0.252991242,0.0,0.0,0.507371708,0.0119402372,1.27581474,0.8587195540000001,0.37888313,1.89491079,1.73340608,0.90595306,1.23840685,0.359150105,0.755406624,0.38385865399999997,0.0310622292,0.0,0.637174771,1.50002312,0.0412042715,1.2971106000000001,0.0,0.0,0.0,0.0,1.22446152,0.902333827,0.0,0.0,1.04068877,0.049640443,0.0,0.657141767,0.0712605659,0.594027997,0.0,1.19506732,0.43384060700000004,0.028267074,0.303272262,1.04048824,0.92607616,0.0,0.0806444069,2.48546632,1.74219769,1.63932285,2.37947961,2.045482,1.72256671,2.60692786,1.0300973,0.389773906,0.33698547,0.563241942,0.0,0.0026710984000000004,1.85878029,1.1493984,1.10013266,0.427880728,0.647185428,1.46024053,0.404778375,0.0,0.0,0.17302142899999998,0.908137175,0.867299508,1.97052846,2.5706993,2.4217681,3.26257353,4.00736954,4.63463104,3.92336713,3.51279837,2.61670755,0.925717145,2.07699592,1.31560916,0.492391764,0.0,0.0,0.0,1.18392137,0.0,1.06353541,0.10646034800000001,0.701324262,1.02072205,0.40091133,0.0,0.0,0.532709077,0.0,0.528022468,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8504236479999999,1.57373162,2.01942272,2.10400268,2.19137349,2.06718241,2.19220674,2.40519777,2.21742475,1.59759905,1.91982942,0.985374292,0.591110267,0.9895062840000001,0.748491186,0.744480244,0.89162362,1.55506181,1.79948073,2.16221471,3.33024123,3.74406698,3.99595475,4.73914344,4.18068665,4.58566305,3.88140528,2.9047457999999997,2.37460155,1.54269224,0.76932503,0.268855272,0.0,0.0,0.0,0.0,0.0,0.163120226,0.343629419,0.666139842,0.627655496,0.473106861,0.540078241,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.544126962,0.0,0.0,0.121564873,0.0,0.0,0.187181128,0.0,0.00909945337,0.0992696351,0.174588075,0.127461887,0.0,0.0389293119,0.560024055,0.10016795,0.0,0.0302164888,0.0,0.0,0.0,0.0,0.299053733,0.0,0.46544686700000004,0.0,0.200000142,0.15713422900000001,0.0,0.363860423,0.412634295,0.33851992799999997,0.0,0.251270805,0.0,0.0,0.133400712,0.41312425,0.0137880595,0.0823424821,0.0814026701,0.0350115561,0.0,0.0,0.0,0.0,0.43794731200000003,0.0,0.625728706,0.286243381,0.692213845,0.517507242,1.34367887,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.03240912,0.9982895409999999,0.841087809,1.21461213,1.75742445,0.48732869799999995,1.40765736,0.0,0.39422248600000004,0.0,0.486311964,0.0,0.16146944800000002,0.0,0.736773938,0.529872894,0.643003737,0.0,0.39425147,0.514131129,0.0,1.0953752,0.0,0.900285085,0.0,0.0,0.49176447100000004,0.0,0.0,0.0,0.0967278937,1.09111555,0.27176534399999996,0.0,0.7825820059999999,0.0,0.57838988,0.7865013909999999,1.39909229,0.928269728,0.0,0.0,0.831674169,0.0,0.148839,0.78115393,0.392235605,0.0,0.0,0.681297112,0.925572161,0.0,0.0,0.0,0.0,0.36972178299999997,1.6587243000000003,1.62499401,1.58642198,2.48009723,0.486362543,0.0,0.24528907600000002,1.05647804,0.0,0.0,1.05289093,0.0,0.0,0.0,0.790846493,0.595568075,0.0685054775,0.0,0.0,0.0,0.0,0.9271307259999999,0.297136827,0.0,0.0,0.277390904,0.386180149,0.0,0.0,0.624546892,0.37963634,0.0,0.562288162,0.0,0.847544376,0.0,0.0,1.76796223,6.38004897,10.947821800000002,12.312015800000001,7.58516093,3.48387239,0.312532887,1.19879926,4.10507291,3.61004918,2.69995393,0.467507502,0.0,0.0,0.45633574200000004,0.0,0.0,0.791460252,0.563598429,1.19939084,1.56099092,0.9132789379999999,0.22323838,0.634121646,0.16906823,0.06411471469999999,0.0,0.256831574,0.0,1.09774196,0.598503375,0.0,0.0,0.0,0.0,0.446021399,0.0,0.0,0.0,0.0,0.0,0.630589255,0.0,1.08600389,0.996745386,0.750990823,0.918156249,0.754721778,0.0,0.0,1.03023784,0.0,0.0,0.0,0.0,0.973805365,0.0,0.060106947,0.0,1.0625625,0.0,0.512394934,0.6362871520000001,0.17048683399999998,0.140106429,0.0,0.0,0.0,1.59608522,0.0,0.486688756,0.49206244600000004,0.518873108,0.0,0.0,0.22600573699999998,0.551056701,0.12666756199999998,0.357093715,0.954102517,1.05958186,0.0,0.0,0.517805009,0.0279577667,0.966974626,0.28193245899999997,0.43516500399999997,0.0,1.15780637,0.146951747,0.007392527640000001,0.0,1.08183597,0.123383326,0.0,0.0,0.8475305559999999,0.25515179600000004,0.247488901,0.0,0.668940069,0.17232709100000002,0.21069437800000002,0.0,0.47272171700000004,0.0,0.0521830454,0.546334823,0.004298819979999999,0.0,0.09979472800000001,0.0,0.0,0.0,0.813146568,0.500647196,0.7005452740000001,0.0,1.25633085,2.80980448,4.48556027,4.17966763,3.62255782,0.994205553,0.0,0.290401287,0.0,0.19892963600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.24
0.181763221,0.0,0.0,0.0,0.0,0.0,0.0,0.964970518,1.04563682,0.587756464,0.09093673619999999,0.0,0.46748508899999996,0.0,0.0,0.0,0.27005926399999997,0.39924111100000004,0.0,0.010061515600000001,0.275271541,0.0,0.114389142,0.0,0.0,0.0,0.0,0.22399099100000003,0.08970292630000001,0.650856918,0.0,0.0,0.405554656,0.651913356,0.0,0.0,0.0,0.0,0.660730912,0.6321214620000001,0.212746855,0.573502683,0.0,0.11451589999999999,0.85907459,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.28660256100000003,0.474449127,0.0,0.353192887,0.51403693,0.9360225040000001,0.591055612,0.0,0.0,0.0,0.0273545406,1.25842395,0.0,0.0,0.0,0.0,0.0,0.0,0.164531479,0.0,0.0,0.0,0.0,0.0,0.960946228,0.0,0.0,0.5417392670000001,0.5372755260000001,0.0,0.614102183,1.23832639,0.0,0.0,0.0,0.0,0.179420689,0.24497648,0.0,0.0,0.0,0.0,0.0368290559,0.579443435,0.528672636,0.0,0.0,1.05345992,0.255075487,0.35855352100000004,0.0,0.0,0.0,0.0,0.9516561240000001,0.426893911,0.0,0.0,0.552588235,0.0538909886,0.631837613,0.0,0.0,0.0,0.342281154,0.0,0.0,0.161038395,0.0,0.0,0.0,0.0,0.27977217600000004,0.214498422,0.949471507,0.36599113,0.611982616,1.40321152,0.7188769220000001,0.8363286520000001,0.27589046300000003,0.597897433,0.65863206,0.0,1.24995312,0.167306159,0.0,0.0,0.0,0.0,0.0,0.421538161,0.0621768505,0.956339033,0.6729592759999999,0.0,0.0,0.31551362,0.0,0.463821802,1.90359843,0.0,0.0,0.0,0.7696411809999999,0.158123416,0.6422853470000001,1.02685281,0.0,1.62111489,0.87619011,0.883701617,0.875869171,0.993469499,0.0,0.525123526,0.24673384199999998,1.56369738,0.51468361,0.5320540579999999,0.13582977400000001,0.0,0.0,0.0,0.35414819799999997,0.0,0.043927401500000005,0.698224911,1.29042245,1.12227807,1.48310029,1.86232275,2.18117476,1.21018338,2.8430815,2.47762976,3.08200835,4.15987603,3.0620175,2.94186044,3.20615129,2.71520642,1.89542623,1.11537305,0.425735721,1.61860456,1.10990135,0.113307915,0.544969529,0.0,0.0,0.5524942270000001,0.34230824200000004,0.40643580700000004,0.179378686,0.0,1.34526835,0.730527357,1.90942969,0.0,0.0666712947,0.11952293300000001,0.315274773,0.0,0.868101298,0.0,0.666707968,0.0,1.12882691,0.0,0.582975051,0.0,0.0,0.0,0.0,0.62481419,0.889969068,0.704550483,0.533040863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.07325209,0.0,1.77764126,1.37524247,4.03952823,5.34874939,3.94621747,5.41039866,1.5736021999999998,0.0,0.0,1.12566533,1.1738536,0.0,0.0,1.32987998,5.09591074,4.41165686,4.79494181,2.07007332,0.0,0.0,1.26626519,1.06190473,0.45887054,0.0,0.63193021,0.0,0.0,0.0,0.0,0.64698717,0.0,0.0,0.0,1.04196846,0.0,0.0,0.0,0.65834828,0.0,0.0,0.34100499,0.0,0.0,0.87003379,0.69047222,0.68442833,0.0,1.61798475,0.0,1.85762981,0.0,0.0,0.0,0.64512435,2.8105648999999997,0.0,0.18425727,0.51566983,0.51906892,2.53073111,0.90057744,0.09301845,0.0,0.0,0.0,0.0,0.0,0.0,0.11174779,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.47355144,0.27356367,0.69389269,1.35372319,1.71807656,1.11991136,0.79103495,0.69781909,0.60181367,0.71029038,1.27925384,1.87844072,2.7850777,3.94762262,4.148172,4.07462651,3.35789415,2.92471483,2.03644049,1.72382109,1.57541869,0.83898596,0.69591164,0.15524782,0.0,0.15678559,0.44123928,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.581914531,0.0,0.0,0.0,0.0,1.25033409,0.58750659,0.0,0.0,0.0,0.0,1.1069646,0.0,0.0,0.0,0.667659416,2.08396797,2.20391745,3.21894215,5.85947283,6.41072252,5.59697533,7.91924499,3.46638442,3.00072181,0.583968948,1.22201039,0.0,0.0,0.07944150650000001,0.9653172040000001,1.48710896,0.520063972,0.0,0.0,2.24330013,0.938872719,0.6799268559999999,0.0,0.0,1.35381752,1.39948845,0.89529987,0.469792469,0.155098319,0.0,1.98042395,1.74106777,0.0,0.0,0.0,0.0,1.69651831,0.0,0.0,0.0,0.340148646,0.0,0.0,0.539854304,2.09161718,0.0,0.0,0.0,0.0,0.0,0.378026288,0.0,0.0,1.69302162,2.11230083,0.362482995,0.257006307,0.444470109,0.0,0.0,0.0,0.576971035,0.6956008640000001,0.198326998,0.0,0.0,0.0,0.0,0.107609065,0.0,0.0,0.0,0.522236481,0.0,0.0,0.0,0.187280538,0.0,3.32685471,1.15164392,0.416973095,0.0,0.0,0.892483815,0.0,1.71276606,0.32666565399999997,0.22275719,0.0,0.0,0.39005319200000005,0.716495433,0.0,0.0,1.74366896,1.02691911,0.0,1.50687157,1.37159375,0.0,0.35229485200000005,0.007914806529999999,0.132076353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.57180564,0.59446056,0.60456891,0.60216366,0.58813387,0.56416881,0.53264809,0.4964861,0.45894198,0.42340889,0.39319694,0.37132469,0.36033301,0.36213327,0.37789914,0.40800807,0.45203505,0.50879718,0.57644464,0.65259012,0.73446664,0.81910178,0.90349592,0.98479202,1.0604256,1.1282456,1.18659909,1.234376,1.27101291,1.29645829,1.31110443,1.31569344,1.31120669,1.29874793,1.27943033,1.25427707,1.22414365,1.1896679,1.15125112,1.10907092,1.06312356,1.01329074,0.95942383,0.90143659,0.83939672,0.77360661,0.70466399,0.63349525,0.56135612,0.48979708,0.42059416,0.35564868,0.29686239,0.24599725,0.20453046,0.17351706,0.15347202,0.14428321,0.14516509,0.15465994,0.17069068,0.19066544,0.21162995,0.2304605,0.24408609,0.24972621,0.24512806,0.22878674,0.20013137,0.15966217,0.10902552,0.05101772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01725374,0.15783717,0.33575487,0.54862232,0.79219145,1.06045393,1.34584522,1.63954136,1.93183444,2.21256779,2.47160814,2.6993292,2.88708006,3.02761235,3.11544202,3.14712513,3.12143187,3.03940873,2.90432501,2.72150667,2.49806687,2.24254833,1.96449795,1.67399746,1.38117657,1.09573566,0.8265040000000001,0.58105742,0.36541506,0.18383032,0.03868485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03820602,0.07745715,0.10733709,0.12668932,0.13552536,0.13491947,0.12683594,0.11390377,0.0991562,0.08575463,0.07671651,0.07466626,0.08162565,0.09885734,0.12677077,0.16489529,0.21192054,0.26579941,0.32390468,0.38322688,0.44059841,0.49292738,0.53742427,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.36258711e-16,0.0,0.0256660386,0.0968209315,0.0409962409,1.36362238,4.42257756,6.59390884,5.26533257,1.65074121,0.0,0.0,0.36335031799999995,0.222992705,0.0,0.0,0.200934339,0.0684618636,0.0,0.0,0.150254571,0.0102290838,0.0,0.009440303,0.12774132300000002,0.0,0.0,0.0441058862,0.115844318,0.0,0.0,0.0823224035,0.10833439199999999,0.0,0.0,0.13931300800000002,0.10338023699999999,0.0,0.0,0.286932684,0.156656557,0.0,0.0,1.57287363,3.21964181,3.3063805,2.00562511,0.613417753,0.0,0.0,0.035806132000000004,0.0655722812,0.0,0.0,0.051721690199999996,0.0597115458,0.0,0.0,0.0794805813,0.0388128054,0.0,0.353508781,0.727550274,0.355494804,0.0,0.0325865512,0.873139763,0.774728442,0.18939269600000003,1.2745207,3.86736256,4.74575995,2.40218308,0.0,0.0,0.421819048,0.502856635,0.0,0.0,0.4934844,0.703917583,0.21694184800000002,0.0,0.0933634088,0.0286409719,0.0,0.202468712,0.337223659,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.71546395,0.0,0.321419605,0.24419163600000002,0.254710555,0.382366456,1.43313401,3.59362041,1.06525462,0.11782029,0.0,0.0661745057,0.0,0.676322538,0.0,0.303336934,1.44027679,0.717943055,0.0449102496,0.0781517684,0.7504725720000001,3.15647776,2.61327068,0.0,0.447632135,0.0,0.35217875,0.0,0.435522497,0.684474138,3.51436411,2.49282527,0.0,0.614351541,0.0,1.20571492,0.7144769259999999,0.0,1.30654228,6.93645355,2.97264541,0.0,0.213924162,0.0,0.123228831,0.0,0.09662388570000001,0.247505363,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.144899167,0.0796096673,0.17049024,0.0,0.22811272,0.280035908,0.182649988,0.0,0.132576939,0.143915616,0.203910607,0.143536295,0.0533366733,0.0,0.0808883377,0.451570518,0.0790114479,0.20570835,0.5327774710000001,0.183011724,0.10883867,0.7536797390000001,0.431442304,0.5341894229999999,0.467558039,0.204509772,0.63827955,1.02304453,0.92103496,0.744698347,0.9460913040000001,1.00954412,1.17415104,1.20387591,1.96444576,1.73404761,1.70117136,2.25104169,2.65770447,2.59228155,3.24235331,3.15611792,2.96743188,3.68498832,3.35090214,3.33476217,3.77067061,3.81482144,3.87410565,3.1589513,3.68959843,3.13286525,2.86653576,2.89033004,2.07006921,1.87152679,1.41961249,1.70755168,1.36553637,1.01832935,0.36045025299999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.348106051,0.0481129613,0.0062738190899999996,0.587900798,0.0,0.237119259,0.25921428,0.276180937,0.58625029,0.0,0.014341948500000002,0.284868136,0.0,0.0,0.0,0.0,0.0600820226,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0195800242,0.0620951412,0.146541711,0.600971644,0.37146587799999997,0.448597497,0.307642501,0.598362316,0.60499821,0.252571612,0.698410366,0.31860266600000003,0.21953236399999998,0.82398397,0.767500497,0.694870885,0.736085187,0.585502698,0.0142599996,0.12234812699999999,0.33020820300000003,0.312721655,0.459606625,0.216346507,0.26069149,0.281798489,0.10252870900000001,0.528198108,0.363870089,0.302289299,0.714818506,0.629416027,0.19298141,0.633994098,0.185183105,0.135300306,0.0613173683,0.122433389,0.5926420929999999,0.0,0.0,0.0,0.0,0.0,0.21230357600000002,0.209417055,0.33014143100000004,0.0,0.154639782,0.312817625,0.0,0.0,0.289034548,0.0,0.0,0.29288163899999997,0.20701343600000002,0.0803411717,0.0,0.0365207425,0.0,0.0,0.0830123751,0.319326044,0.0,0.060143132300000006,0.0,0.0,0.22529919,0.0,0.0,0.0568970462,0.0,0.0,0.257565456,0.0580256575,0.0,0.0,0.474192206,0.449168274,0.0,0.0,0.36815440200000005,0.0,0.050728443,0.0,0.399419659,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.78989991,0.96394195,2.07570326,3.63061212,1.64656839,0.32672649,8.69908465,14.46463155,8.64482857,0.0,1.46283501,3.68709573,0.42887992,0.0,0.0,0.36497959999999996,0.0,3.34858197,5.44033914,2.77311726,0.0,1.3505983,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.01821166,2.25557862,0.0,0.54715269,2.16345144,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.237
0.11797591,0.19094277,0.24643636,0.27697817,0.27867617,0.25177168,0.20056344,0.13272995,0.05815939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04593080000000001,0.09995986,0.14086839,0.16158633,0.15822412,0.1306628,0.08257619999999999,0.02088249,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04128605,0.10750882,0.15879144,0.18721057,0.1881195,0.16089355,0.10909127,0.03999838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03074122,0.11039766,0.17510901,0.21480180000000001,0.22295284,0.19768913,0.14223269,0.06460346,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.02090189,0.14491838,0.26685309,0.36876554,0.43441008,0.45168284,0.41461278,0.32459281,0.19063992,0.02859771,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21829075,0.44626276,0.64178831,0.77696832,0.83048686,0.79104644,0.65973691,0.45097075,0.19178109,0.0,0.0,0.0,0.0,0.0,0.0,0.2815955,0.8796905999999999,1.59865062,2.38891493,3.18988249,3.93563741,4.56147071,5.01049711,5.23964115,5.22432457,4.96132309,4.46945885,3.78803263,2.97315007,2.09232899,1.21796389,0.42034702,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.54134626,1.11517791,1.65094454,2.10061048,2.42829603,2.61293219,2.6491646,2.54651592,2.32701358,2.02165461,1.66619152,1.29677228,0.94595038,0.63950259,0.39436486,0.21783926,0.10805754,0.05553192,0.0454989,0.06068302,0.08408066,0.10139145,0.10279852,0.08390864,0.04579075,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03750421,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.94651762,7.67396318,11.24633114,8.59425327,0.0,0.66484852,3.71217601,0.0,0.0,1.20886385,0.0,0.0,0.0,0.27520805,1.82033987,1.63641909,0.0,0.07320675,2.89600868,3.64758591,0.0,2.17250385,4.05570435,3.1161539,0.0,2.00014158,0.0,0.07757803,0.0,0.0,0.0,0.0,0.0,0.0,0.7225634,0.0,0.0,0.0,0.0,0.0,2.24223943,1.20747669,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.09459434970000001,0.0,0.311353607,0.0,0.43317617,0.0,0.0324319808,0.0,0.23204682899999998,0.353130679,0.0,0.21838457600000002,0.0,0.208275977,0.0,0.0,0.087390621,0.0,0.355139463,0.0,0.0,0.22047328800000002,0.0,0.21539942,0.0,0.0,0.0,0.298316827,0.426753095,0.129697753,0.0,0.0,0.0,0.0,0.166695672,0.11977488,0.12031715800000001,0.331967996,0.0,0.0697735792,0.00571089803,0.0,0.102342426,0.19653665899999997,0.0890135021,0.0,0.0,0.36160086399999997,0.0,0.0,0.0170974676,0.0,0.0528101787,0.184090836,0.543178999,0.7771092070000001,1.44888775,1.89804609,2.42661688,2.77087578,3.27777953,3.32746174,3.69252663,4.34599323,3.76562765,3.89807802,3.69196826,3.91337374,3.44286055,3.51560467,3.58727019,2.8343837000000005,2.87041134,2.46233024,1.59391917,1.68226555,1.81373008,1.51030896,0.499489974,0.798426698,0.699214213,0.111914905,0.21276782800000002,0.506109189,0.34148089,0.0,0.34255971799999996,0.171981506,0.33602980600000004,0.0,0.255303684,0.403108055,0.201945047,0.40240411,0.30746563600000004,0.0,0.0,0.0,0.0,0.187153729,0.0,0.168701829,0.31180263199999997,0.871599005,0.525452155,0.7165213220000001,1.09391313,0.733442678,0.637286571,0.376026735,0.011190540700000001,0.0,0.0,0.0,0.0,0.0638302815,0.0,0.0,0.0,0.0,0.416385386,0.594432046,0.57486241,0.44106772,0.0793531526,0.27218665,0.331034884,0.508911559,0.547863798,0.526002025,0.258297503,0.770232515,0.528903235,0.9841253790000001,1.07463187,1.6488903999999998,1.97175211,1.64605258,1.62338938,2.25230774,1.83603334,1.57690847,1.04150602,0.7406392970000001,0.407544192,0.863136205,0.31626084,0.347158745,0.0,0.0,0.0,0.390219298,0.238570605,0.29831835100000004,0.0,0.162501779,0.0,0.321593684,0.167783775,0.0,0.0345120692,0.39339494,0.0,0.531001845,0.913052677,0.886624544,0.9459408690000001,0.8342907009999999,0.809845523,1.00404636,0.9234542020000001,0.8485017,1.22810785,0.995200477,0.986057035,0.151406326,0.114960787,0.102495585,0.510057094,0.0,0.0,0.0151020934,0.450620904,0.17445362,0.0,0.183746616,0.32304321199999997,0.5471413620000001,0.011045891499999998,0.0918522588,0.0,0.0,0.0,0.0608980879,0.60781739,0.793990538,0.8493823309999999,1.11867526,1.35691925,1.72312398,1.29703466,1.63166533,2.03587586,1.78310544,1.21864386,1.18981592,1.03246114,1.0993275,1.12207711,0.587014067,0.40187669299999995,0.507752038,0.17587005100000003,0.37635613799999995,0.0607066047,0.0,0.0,0.0,0.06483036730000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.278899007,0.0435509802,0.026883955,0.0,0.0,0.07855770940000001,0.0330062283,0.0,0.0,0.014276880700000001,0.0,0.18800165,0.191648218,0.0361293233,0.026183433399999997,0.0,0.07404206990000001,0.0,3.82015301e-17,0.0774069384,0.0,0.168200186,0.0,4.07482987e-16,0.16391519,0.0,0.382464091,0.0,0.0,0.804503566,0.0,2.67113163,5.12343338,5.0935373399999996e-17,0.0,0.6338451279999999,0.0,0.22360450699999998,0.0,0.047423579,0.371359285,0.0,0.150121501,0.043871321100000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.920473916,0.825200479,1.56295581,1.5691027,1.42524403,1.16026168,1.41071839,1.30953415,1.75138496,1.46544719,1.10174544,1.12718941,1.1633095,0.7602705590000001,0.535370514,0.826081491,0.336425301,0.279959523,0.0375937871,0.0,0.0,0.0,0.0,0.013749771599999999,0.0,0.052825524299999996,0.0617134731,0.0,0.00820860983,0.186949665,0.288212364,0.20091831,0.282024198,0.0,0.0,0.0,0.0,0.228097126,0.0,0.180242387,0.0119030314,0.0,0.101493683,0.0638552332,0.18686522,0.0,0.398128972,0.0,0.0,0.0,0.242659618,0.0,0.0502417953,0.0,0.261117802,0.0,0.0,0.0,0.178179788,0.0,0.0,0.20460110399999998,0.0,0.0,0.0,0.0,0.382617537,0.0314880695,0.115469054,0.0,0.285079965,0.42258724799999997,0.0,0.0,0.133727251,0.24526791899999997,0.0,0.0630666791,0.0841318366,0.285204874,0.0,0.0818958788,0.0,0.07884556690000001,0.0,0.0,0.0,0.0,0.31491394699999997,0.026501627599999997,0.0,0.0470094892,0.0441433442,0.228411673,0.0,0.0,0.0,0.35716979200000004,0.31830979600000003,0.0,0.09739746519999999,0.0,0.0,0.0,0.0037053300299999996,0.0719547666,0.20125781,0.027307022200000003,0.0,0.165268768,0.140508961,0.308807213,0.24432890699999998,0.20358359,0.36179187,0.0,0.0,0.0,0.0,0.375279721,0.0,0.20328478,0.256250155,0.0,0.0,0.0,0.167882002,0.0,0.0,0.0,0.380336045,0.429081902,0.455942771,0.19750750399999997,0.0,0.0662984735,0.0278096038,0.0,0.014744294199999999,0.143735163,0.0,0.0,0.314654553,0.183115732,0.0,0.0,0.0,0.226195027,0.0410021202,0.11499744199999999,0.164491479,0.292251661,0.772629228,1.12074316,1.09311434,0.796159284,0.986511586,1.3312124,0.850738243,1.12033388,0.44571981200000005,0.761712033,0.371127073,0.304533661,0.0027730068100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0908034181,0.0,0.51335954,0.768408711,1.00285336,1.32767435,2.44728059,2.17461214,3.14138861,3.43305092,3.46696421,3.86208957,3.59981434,4.26815798,3.49083685,3.5048646,3.37535064,3.1770516,3.12023488,2.75359677,2.28097921,2.32535867,1.60991067,1.15792046,1.50296127,1.33985303,0.47257740600000003,0.950399601,0.683341196,0.562349711,0.45351395,1.05507993,0.865889413,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.370035926,0.186841582,0.09896096019999999,0.0814086352,0.0633362019,0.0143140845,0.0,0.0,0.0602570508,0.13586958300000002,0.139898851,0.05812360019999999,0.0,0.0,0.0,0.0313997401,0.0858267439,0.0600905789,0.0,0.0,0.0,0.007351074890000001,0.0698379354,0.06743994980000001,0.00290794232,0.0,0.0,0.0,0.0625370294,0.08445091560000001,0.0268499434,0.0,0.0,0.0124575107,0.226882468,0.455871181,0.575375793,0.516743335,0.31566718,0.093924181,0.0,0.0322535382,0.18128660600000002,0.294907847,0.269244923,0.12100451699999999,0.0,0.085243231,0.477687497,1.08305225,1.65476577,1.92756923,1.77454954,1.27913527,0.6749652070000001,0.19967238399999998,0.0,0.0,0.0,0.011109226699999999,0.00474784646,0.0,0.007929204229999999,0.0289676746,0.0248388195,0.0,0.0,0.0,0.009288931690000002,0.0621205081,0.0608824054,0.0,0.0,0.0,0.0,0.07546856980000001,0.0963347879,0.025472328399999997,0.0,0.0,0.0,0.0746515719,0.131362648,0.0659495562,0.0,0.0,0.0,0.0584097882,0.16412157800000002,0.120207305,0.0,0.0,0.0,0.022762458,0.19131445600000002,0.189404054,0.00429874321,0.0,0.0,0.0,0.204283372,0.267842602,0.0784301281,0.0,0.0,0.0212064548,0.422453772,0.597060633,0.348245209,0.0,0.0,0.0429110738,0.842441751,1.38364565,1.00322786,0.0,0.0,0.0,0.22519444100000002,4.10009026,8.35229461,11.125668,11.252486900000001,8.89767497,5.36127377,2.22134287,0.433982097,0.0,0.154294047,0.282018243,0.119052311,0.0,0.0,0.0989517982,0.39312273600000003,0.458476263,0.23365075,0.0,0.0,0.0,0.0333363048,0.156807232,0.114479125,0.0,0.0,0.011503449099999999,0.0906962192,0.0777941025,0.0155085295,0.118116617,0.604970632,1.47857976,2.44821447,3.08825469,3.12185392,2.60798549,1.88329501,1.30829486,1.0224829,0.896312752,0.699002262,0.32626489399999997,0.0,0.0,0.0,0.0511689745,0.424293801,0.616897221,0.565061325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.243
3.93819612,0.0,2.00012958,0.0,1.97390887,0.0,4.15333722,5.26475587,19.85868379,14.25858999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.258
7.76657878,5.57012156,4.10860111,0.927047554,0.0,1.4278173,0.0,1.7435703999999999,0.0,0.0,0.0,1.94676532,0.0,0.9373252040000001,0.739857822,0.0,0.0735913186,1.56570421,0.28858703,1.08484068,2.25000958,2.81875885,0.0,0.0,0.624476003,0.0,1.16671483,0.0,0.200800547,1.1460347,0.0,0.37711355,0.0,1.30650565,0.0198297036,1.73762097,0.0,2.61057327,0.791151258,0.0,0.288830606,1.59828645,0.679236683,0.670787986,0.0,0.0,0.875251641,0.0,0.0,0.8218320920000001,0.0,0.57608185,0.77152015,1.87345364,2.66335212,0.0,2.65730002,1.17762113,0.0,0.0,0.0,0.0,0.0,0.10831975199999999,0.0,0.0,0.0,1.17597611,0.0,1.34206242,0.0,0.555363077,0.0,0.550023429,2.83691,1.52144836,0.941855222,0.24411300100000002,0.0,1.1097727,0.0,0.0,0.0,0.0,0.0,0.0,0.259466839,1.0490662,0.014376773999999998,0.0,1.1550486,1.12727691,0.0,0.0,1.24360095,3.65911981,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.694739743,0.28985071100000004,0.37434903700000005,0.451444876,0.658964997,1.64156271,1.09572734,0.683791423,2.41828894,1.86405157,3.38187486,2.39840089,1.63351664,1.59711678,1.44877858,0.434472188,1.38306332,0.328059074,0.332567082,0.517889144,0.0,0.0,0.67797236,0.0,0.18245598100000002,0.589772557,0.184419632,0.8891989570000001,1.48950145,0.294552418,0.08185252330000001,0.6931274609999999,0.5145835870000001,0.0,0.0,0.0219910583,0.153030961,0.025138814199999998,0.0,0.0,0.0,0.0218827276,0.7554013070000001,0.147803188,0.0,0.00540582809,0.8435626890000001,0.0,0.17945385,0.183884689,1.32257448,0.8205460170000001,0.6304616510000001,0.439911449,0.49290361,0.761040005,0.0899428434,0.127322826,0.259497257,0.141259935,0.134844112,0.841634627,0.0,0.464868788,0.0,0.0,0.809029434,0.30893539,0.172943435,0.9395401320000001,0.122101631,0.0,0.666540676,0.0520871516,0.0,0.0,0.0,0.2556447,0.0,0.0,0.24655455699999998,0.44800070799999997,0.0,0.521255119,0.766050185,0.0,0.09192042369999999,0.588216037,0.0,0.167472667,0.439531035,0.169800037,0.0,0.0,0.8548121590000001,0.0,0.0,0.209725827,0.0,0.0,0.0,0.524880675,0.0,0.0,0.9800729579999999,0.194675945,0.0,0.0,0.0,0.0,0.152514794,0.46003183,0.19641873199999998,0.340762258,0.332123657,0.0,0.669462453,0.46328960700000005,0.428444414,0.0,0.0,0.0,0.0,0.0,0.305360079,0.0,0.0,0.0,0.228534844,0.392137178,0.488676365,0.0,0.31214453,0.112689304,0.9826446759999999,0.687951058,0.76637184,0.278473878,0.244854794,0.0811102038,0.0,0.0892156804,1.02389586,0.710790818,0.0,0.0,0.817479873,0.0,0.0,0.0,0.0,0.491670151,1.20502817,0.557290584,0.825835955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.699513789,1.02505004,1.6405374,2.55879211,3.74589986,5.11966648,6.55649673,7.9061612000000006,9.01237798,9.73592401,9.97635518,9.68850119,8.89071823,7.66328956,6.13710062,4.47445143,2.84527023,1.40278761,0.262768884,0.0,0.0,0.0,0.0,0.0,0.0,0.225966377,0.434463195,0.50673575,0.450969908,0.301885791,0.109203545,0.0,0.0,0.0,0.0,0.0,0.0,0.0696801722,0.15996482,0.20176191300000001,0.189116745,0.13003937699999998,0.043264414,0.0,0.0,0.0,0.0,0.0,0.0,0.0330435598,0.09191028789999998,0.123652005,0.12199266199999999,0.089413809,0.036000655299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0167925886,0.0608213446,0.087278897,0.0902045773,0.0698713102,0.0324475715,0.0,0.0,0.0,0.0,0.0,0.0,0.007966595440000002,0.0441620829,0.0678675266,0.07336672179999999,0.0597684091,0.031094282400000003,0.0,0.0,0.0,0.0,0.0,0.0,0.00229345767,0.0345787969,0.0573803504,0.0649479095,0.0555336515,0.0317828016,1.0683610699999999e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.029373735699999997,0.053326938399999996,0.063420432,0.0569490713,0.0354729788,0.0044454277700000005,0.0,0.0,0.0,0.0,0.0,0.0,0.027947676499999997,0.0566512092,0.0712960353,0.0675284572,0.0456124875,0.0105339228,0.0,0.0,0.0,0.0,0.0,0.0,0.0324325194,0.0760778978,0.103109727,0.104680162,0.07758729219999999,0.0256004011,0.0,0.0,0.0,0.0,0.0,0.0,0.06864822200000001,0.21495618600000002,0.36613680200000004,0.49927940299999995,0.5937086460000001,0.634949352,0.617501612,0.545830182,0.433346794,0.299593997,0.166230659,0.0526848757,0.0,0.0,0.0,0.0,0.0,0.0,0.000947923681,0.0,0.0,0.0,0.0,0.0,0.021083246,0.12844720099999998,0.274407252,0.443633486,0.614581498,0.764099345,0.8727381340000001,0.929495367,0.9347753059999999,0.9007059609999999,0.8485428890000001,0.803590822,0.788725679,0.818042319,0.892265512,0.997289593,1.10658783,1.18737193,1.20946458,1.15508061,1.02728294,0.854916023,0.6923534720000001,0.613352721,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.243
0.539293781,0.0,0.0,0.405036171,0.8344943429999999,0.0,0.0,0.0,0.0,0.0,1.38747751,0.6097540779999999,0.0,0.0,0.0,0.68800752,0.0,0.0,0.0,0.736077568,1.67594399,2.02992826,0.0,0.0738202151,0.0,0.430062436,0.621601353,0.0,0.0,0.519416956,0.910230833,0.8644837209999999,0.15381704699999998,0.145778626,0.0,0.794408387,0.0,0.0226881709,0.0,0.0,0.0,0.898203202,0.425505102,0.0,0.9574919620000001,0.0,0.0,0.0,0.345476716,0.427717401,0.912162438,0.0,0.0,0.0,0.7844077559999999,1.32603094,0.895248728,0.415178245,0.0,0.161313185,0.0,0.0,0.0,0.0,0.0932931928,0.0,0.0,0.0,1.48865855,0.0,0.0,1.72672981,1.38729929,1.28266942,1.77577862,0.52119046,0.463494216,0.7845875859999999,0.0,0.0,1.03037806,0.43536835100000004,0.291522725,0.0,1.25894681,1.01395862,0.0,0.0190297679,0.0,0.0,0.0,0.06618988599999999,0.0670407976,1.54365898,0.956858248,0.0,0.7915135590000001,0.878407243,1.84037102,2.03311556,0.0,0.0,0.0,0.345785475,1.65134801,1.02208083,0.0261816015,0.0,0.45219897200000003,0.465327686,2.30184902,0.0,0.0,0.0,4.45713382,12.5886,15.7703459,13.060075,7.49865625,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.26
0.31013889,0.0,0.0,0.0,0.0,0.0207960906,0.621595486,1.3269798000000002,1.97960201,2.42607542,2.55961282,2.34983818,1.85075437,1.18457446,0.506555235,0.0,0.0,0.0,0.0,0.00262185765,0.26968160399999996,0.444008991,0.475429991,0.367851086,0.17092138199999998,0.0,0.0,0.0,0.0,0.0,0.0335077061,0.14135979699999998,0.184191186,0.154382228,0.07134619860000001,0.0,0.0,0.0,0.0,0.0,0.024107880499999998,0.0807659224,0.10064453400000001,0.0806188735,0.0334380156,0.0,0.0,0.0,0.0,0.0334549776,0.09152884970000001,0.133995466,0.148715019,0.133997595,0.0979954801,0.0545347454,0.0173662715,0.0,0.0,0.0,0.00453074815,0.0102082478,0.00947460005,0.00432649967,5.7006528900000005e-05,0.00227977752,0.0140610699,0.034518779900000005,0.059494856900000004,0.08390838269999999,0.10460599,0.122296461,0.141586859,0.16903514,0.21009824,0.26645067699999997,0.335095884,0.409985825,0.485780948,0.562368333,0.648242148,0.761074151,0.924705937,1.16304901,1.49251244,1.91516787,2.4146989,2.95634972,3.49091573,3.96174379,4.31308965,4.49815861,4.4856158,4.26399406,3.84391734,3.25819833,2.55969222,1.81654191,1.10446705,0.496264054,0.0496786766,0.0,0.0,0.0,0.0,0.177017449,0.296709622,0.309533619,0.210406097,0.0347897579,0.0,0.0,0.0,0.0,0.0756754382,0.34694238899999996,0.564845464,0.649115942,0.5586354170000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.168901306,0.294824872,0.0679917613,0.0,0.0,0.0681969637,0.290707885,0.141405685,0.0,0.0,0.0,0.40353935399999996,0.425015329,0.0607853017,0.0,0.0104655313,0.42160033700000005,0.42171302899999996,0.0,0.0,0.0,0.528408412,0.8715119509999999,0.0,0.0,0.0,1.28752234,5.20167443,7.94295285,7.63858458,4.72882133,1.44663472,0.0,0.0,0.416082931,0.457295784,0.0262017837,0.0,0.371541395,0.991539707,1.08816408,0.621606852,0.148101419,0.11432644300000001,0.376379924,0.472777646,0.22671496300000002,0.0,0.0,0.07860535099999999,0.20581909399999998,0.103191289,0.0,0.0204498851,0.268038053,0.404745446,0.24321046699999999,0.0,0.0,0.022995336,0.260455909,0.264764435,0.0349357115,0.0,0.0,0.15845979400000001,0.265969147,0.096925847,0.0,0.0127354674,0.7237284340000001,1.74207371,2.4670005,2.40837366,1.5853274,0.532769601,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.186001522,0.17963598100000003,0.137212775,0.0761495955,0.0192209861,0.0,0.0184219131,0.120235745,0.311631068,0.59838864,0.97635943,1.43122468,1.93931633,2.46942672,2.98543534,3.44949651,3.82547516,4.08229209,4.19684969,4.15625093,3.95909555,3.61572924,3.14742509,2.58458126,1.9641137999999998,1.32629917,0.711370884,0.15619298199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0588916381,0.270144984,0.429872111,0.527065726,0.558175355,0.5267774789999999,0.44256270200000003,0.319786546,0.175377664,0.026921841800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.029959325800000002,0.0992922716,0.148655187,0.1748593,0.177876637,0.16052777,0.127839346,0.0861744589,0.042261386,0.00225229921,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0017980900399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0030214206899999998,0.0552481866,0.11031850300000001,0.160853587,0.199096014,0.217959791,0.21208356399999997,0.17874711399999998,0.118520454,0.035541096200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0316194556,0.207190003,0.381015771,0.533803293,0.646919885,0.704573061,0.6958542240000001,0.616413521,0.46955927700000005,0.266625662,0.026521911699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0010534026600000001,0.5030728329999999,1.09974024,1.75806594,2.43811119,3.0961227000000004,3.68810578,4.17351007,4.51868435,4.69977323,4.70477754,4.53457764,4.20281705,3.73465327,3.16449214,2.53292113,1.88313494,1.2571956,0.692484964,0.21868645,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.059931041500000004,0.146435964,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45354017,0.0,6.37995462,0.0,2.69302939,0.0,15.079492000000002,7.179701799999999,0.0,0.0,2.06635678,3.08963324,0.91481695,1.28454122,0.73819129,2.19241621,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.29913827,1.33784636,1.33980125,1.2359852,1.04555603,2.64853198,0.7293387,0.80110268,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.28923671,0.0,0.0,0.0,0.0,0.97400538,0.74261349,1.10237012,0.0,0.0,0.57163281,0.40002366,0.0,0.0,0.17624604,1.74977688,0.21084513,0.0,0.0,0.0,0.0,0.0,0.0,1.12549988,0.0,0.31212742,0.55508661,1.14095756,0.76546642,0.42393055,0.0,0.12129863,1.56862649,0.0,2.04353118,2.10963415,0.0,1.8463961,0.48761627,0.0,0.0,0.27629749,0.75241706,0.13041067,0.0,0.0,0.0,0.0,0.0,0.0,0.8954174000000001,1.00497654,0.9083306000000001,0.88832102,0.0,0.88748218,0.0,0.0,0.0,1.1480091000000001,0.59116946,0.0,1.61728967,0.0,1.87890727,0.33528439,0.0,0.0,0.44584666,0.48742433,0.0,0.0,1.8590602999999999,0.0,2.0732730999999998,1.28752296,0.0,0.0,0.0,0.19707839,2.54754904,3.02852073,3.77012791,3.58279409,6.20463403,5.75371193,6.23744646,3.68498793,3.24223512,2.41472018,3.47050065,1.17868509,0.42618222,0.0,1.29145811,0.0,0.08722103,0.0,0.0,0.0,2.33501737,1.75774311,0.0,0.0,0.87002916,0.0,1.03164119,0.31990213,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.407903539,0.66526012,0.728765578,0.60248402,0.37739680299999995,0.171533094,0.064797908,0.0655516775,0.12276869800000001,0.169094735,0.164148992,0.112187215,0.048218578,0.007418214100000001,0.000933050223,0.0132160118,0.0191027848,0.00535713096,0.0,0.0,0.0,0.00447522058,0.0347726899,0.0419591139,0.0191811892,0.0,0.0,0.0,0.0,0.030480509300000003,0.0452013041,0.0278465475,0.0,0.0,0.0,0.030657900699999997,0.0817544823,0.101925155,0.07255881110000001,0.00694673421,0.0,0.0,0.0,0.0172394725,0.0692881331,0.0733969896,0.0260712585,0.0,0.0,0.0,0.0,0.0635795324,0.08688308880000001,0.0493138017,0.0,0.0,0.0,0.0,0.0561867795,0.10434782,0.0805321908,0.0,0.0,0.0,0.0,0.043700322199999996,0.13071492699999998,0.131424324,0.0349330314,0.0,0.0,0.0,0.019500844099999998,0.229715907,0.382635159,0.41543713299999996,0.353017585,0.297864181,0.36520357200000003,0.6025277139999999,0.9469105240000001,1.25346797,1.3842155,1.30527866,1.12901848,1.06606146,1.30571828,1.89017001,2.65840007,3.30105126,3.50538389,3.11592334,2.22333488,1.13069492,0.212720852,0.0,0.0,0.14239233199999998,0.5757323879999999,0.838919619,0.847062396,0.677855051,0.492620899,0.42092431799999996,0.480603997,0.577885592,0.580572764,0.413395148,0.114176666,0.0,0.0,0.0,0.0553831233,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.34911808,6.09179792,3.07670209,0.0,0.0,0.0,0.33615177,1.77648558,2.2209355,1.66395126,0.7453870859999999,0.122947297,1.86601718e-16,0.12761187400000001,0.162132129,1.6586819299999999e-16,0.0,0.0,1.6586819299999999e-16,0.201524898,0.205697463,4.201191379999999e-17,0.0,0.0,0.0,0.270764273,0.303802243,6.22005726e-16,0.0,0.0,0.0,1.17549335,2.52066334,3.35731581,3.20868846,2.13017727,0.710120615,0.0,0.0,0.0,0.501208874,0.501784046,2.22735809e-16,0.0,0.0,0.39497833,1.20299362,1.26521416,0.34035366799999994,0.0,0.0,0.306738491,3.23381192,6.14319592,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.234164557,0.6134191729999999,0.814297112,0.8381672170000001,1.04843461,1.49856198,1.68427161,1.28574168,0.789827543,0.856328002,1.26579929,1.17644731,0.5080153270000001,0.33838356299999994,1.45501974,3.03011636,3.45353127,2.31390255,0.823747273,0.20458516,0.38286816799999995,0.6399199870000001,0.88367505,1.53791754,2.46084263,2.83753089,2.30762863,1.5282597,1.24191111,1.27165136,0.9533453479999999,0.260772367,0.0,0.0990880591,0.487946528,0.527152804,0.459282514,0.848639749,1.6452402,2.15642002,1.93432189,1.29131299,0.8168948770000001,0.689052917,0.667544575,0.565738559,0.460437473,0.478017419,0.586637954,0.649590126,0.577164244,0.393191012,0.214395919,0.161768809,0.22778755399999998,0.255854188,0.142512621,0.0309620309,0.15868985800000002,0.490165466,0.6713466579999999,0.457168973,0.0513412667,0.0,0.0,0.108705251,0.053897764199999997,0.0,0.0,0.0475034908,0.0743246216,0.0,0.0,0.0,0.0857430408,0.0828281195,0.10596471800000001,0.329871255,0.689936978,0.891862782,0.740969937,0.365756497,0.0678056694,0.00860448694,0.0969825894,0.149468444,0.09536521519999999,0.0164213818,0.0304853502,0.168122787,0.352529269,0.475327957,0.486924455,0.42885757399999996,0.391045417,0.43113326,0.524878704,0.604835754,0.661217323,0.776455723,1.00185291,1.20157055,1.1174366000000002,0.669777808,0.133248478,0.0,0.0,0.133013924,0.069919902,0.0,0.0,0.0556810138,0.10036436900000001,0.0,0.0,0.0,0.107768305,0.0409804705,0.0,0.0,0.082407035,0.103863115,0.0,0.0,0.0198185844,0.14605759,0.0242964633,0.0,0.0,0.145384633,0.129923005,0.0,0.0,0.0786375851,0.238810603,0.014326944,0.0,0.364375706,1.0981528,1.09688054,0.299552652,0.0,1.10835928,2.90175727,3.52473949,2.35004359,0.674219589,0.0547500787,0.550472796,1.04037839,0.832711937,0.302781437,0.049032169699999996,0.083134465,0.0824429888,0.0,0.0,0.09566986220000001,0.129083518,0.0334732021,0.0,0.0,0.0176106046,0.0137113952,0.0,0.00289928977,0.0,0.00164880669,0.08399648369999999,0.222710778,0.27639694800000003,0.20686521300000002,0.162371992,0.224747138,0.245081424,0.111946638,0.024523225699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.97188306,0.73077679,0.84753308,0.80481525,1.02547383,1.23275712,0.69459972,2.05895945,2.49678834,3.15945789,4.20092867,4.99136866,4.49533042,4.27060724,3.2291789,2.64439014,1.21671879,0.24771886,0.0,0.0,0.0,0.0,0.0,0.63716532,0.04339044,0.52577993,0.0,0.0,0.0,0.08322083,0.21975989,0.0,0.2927421,0.0,0.03665919,0.0,0.23519101,0.0,0.31949775,0.0,0.0,0.64729026,0.0,0.0,0.0,0.07343336,0.0,0.0,0.0,0.42137459,0.63608477,0.26039231,0.0,0.0,0.0,0.0,0.0,0.30621464,0.28950388,0.27227629,0.32089109,0.0,0.0,0.27712441,0.30794693,0.0,0.08721072,0.45614472,0.75963434,0.41358792,0.31968703,0.3291078,0.0,0.15205316,0.0,0.42283174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.26246985100000003,0.7475596590000001,0.770696229,0.0,0.0,0.0,1.34197655,0.34808503,0.0,0.0619000463,0.0,0.337768367,0.84207624,0.452178566,0.0,0.32379034100000004,1.15493318,0.18969757,0.144177406,0.34322395899999997,0.383710249,0.301763447,0.0,0.848879741,0.353059045,0.857201035,0.069215019,1.20195332,1.20254624,1.1937233,0.44919481899999997,0.7584854759999999,1.03840728,0.0,0.8053308809999999,1.58862429,1.22408762,1.08074484,0.602466878,0.44619132799999994,0.216402896,0.7052945009999999,0.3735908,1.02771234,0.376311495,0.253762069,0.163079405,0.0,0.891977355,0.00197238327,0.0,0.0,0.0,0.0,0.0,0.694062748,0.5672234829999999,0.22133284600000003,0.288710416,0.0,0.054945254400000004,0.344355012,0.879183708,0.996080608,0.818616036,1.63157289,2.42285204,0.669082657,1.93975727,2.65263129,2.85517871,3.42555762,3.64839492,3.17213211,2.73217259,2.17736803,3.49229448,3.57867798,2.15684892,2.31318165,2.64587734,2.37910359,2.66159862,1.96253706,2.81343215,1.65296784,2.03623587,2.10350853,0.058033475099999995,1.15731548,0.543909666,0.590740274,0.705305686,1.27246297,0.0,0.0,1.55877366,0.895363468,0.0,0.271636321,0.0,0.0,0.0525282556,0.671888789,0.0,0.0,0.5075747420000001,0.125954285,0.0,0.0,0.200182809,0.0,1.14859601,0.0698035709,0.0,1.94968815,0.0,0.0,0.0,0.311529383,0.0,0.13555984,0.0,0.903361277,0.0577999129,0.0,0.00089053959,0.786493497,0.0,0.316069628,0.284322707,0.0,0.0,0.0,1.54737136,0.0,0.0,0.09607510470000001,0.253917015,0.22238369600000002,0.0,0.814394526,0.0,0.0,0.397296101,0.917736518,0.0,0.6050725229999999,0.0,0.0,0.342806303,0.0,0.83414625,0.25394828199999997,0.0670621658,0.256613588,0.0,0.0,0.317281907,0.0,0.0,0.0,0.0,0.186529484,0.0,0.166886665,0.0,0.0,0.642236296,0.33234408,0.0,0.183106104,0.0,0.0,0.0,0.976868567,0.0,0.30333683899999997,0.0,0.0,0.115457374,0.0,0.0,0.0,1.09580493,0.0,0.33655333,0.0671577404,0.083253189,0.9162896759999999,0.061921071900000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.27262504,0.0,0.67058851,0.71461626,0.3656551,0.30575631,0.35825552,0.43937813,0.73475181,0.75573744,0.69522753,0.39823797,0.88518788,0.30653058,0.30736343,0.62572033,0.15555512,0.28126688,0.0,0.05577234,0.04642887,0.0,0.0,0.0,0.16096667,0.0,0.45778131,0.185089,0.57885957,0.53467307,1.01231549,1.29610609,1.16889483,1.56414692,1.27040879,1.46530019,1.65107234,2.0170985,1.43885384,1.97133139,1.77110051,1.55054004,1.73998295,1.41701645,0.88667726,0.91226266,0.91434018,0.79322174,0.55848666,0.39476341,0.04704994,0.45453833,0.23796289999999998,0.24302087,0.0,0.19434210000000002,0.0,0.14837153,0.0,0.22811626,0.0,0.0,0.0,0.0,0.21780337,0.28581452,0.23089810000000002,0.16022750000000002,0.02018837,0.0,0.0,0.20016688,0.0,0.0,0.0,0.0,0.08612768,0.0,0.24870062,0.34101829,0.30033463,0.64259649,0.93928472,1.08600991,1.59209211,1.37359826,1.75849546,2.02524692,2.6247535,2.61365123,3.04132191,2.87061523,2.83841293,2.98045401,3.51118764,3.27352924,3.45306103,2.92111285,2.90762079,2.70510891,2.67950489,2.53761873,1.89338632,1.53882738,1.52757453,1.1064583000000001,1.12818721,0.46317055,0.12986701,0.19816992,0.36539784,0.09154738,0.0,0.0,0.12872106,0.0,0.0,0.0,0.30089276,0.0,0.23319754,0.082014,0.50259583,0.43156863,0.34228986,0.22639895,0.51678377,0.50687387,0.61859776,0.27827689,0.42929565,0.42401053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31007548,0.27036318,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0294636932,0.0,0.0,0.0,0.0,0.0,0.11302213,0.292563019,0.528047267,0.803938169,1.09613507,1.37467278,1.60774309,1.76645255,1.82952893,1.78712121,1.64293249,1.41418011,1.12925498,0.8233863020000001,0.533022627,0.289929327,0.11610659699999999,0.020516916399999998,0.0,0.032566308599999996,0.0987061067,0.16989876199999998,0.22313811600000003,0.244231915,0.230791178,0.19252870600000002,0.148769481,0.123683219,0.140261925,0.214366781,0.350185486,0.53816124,0.755931603,0.972159762,1.15249529,1.26641147,1.29344503,1.22746834,1.07803614,0.868483483,0.631168679,0.400894136,0.207952942,0.0723412935,0.000420623021,0.0,0.007173704300000001,0.0441978936,0.0737442937,0.0812986857,0.0641850382,0.032815038399999996,0.0085445315,0.0185510985,0.08886173689999999,0.237128555,0.466860576,0.764538624,1.10042445,1.43305897,1.71660975,1.90956434,1.98292597,1.92613432,1.74939648,1.48187399,1.16606315,0.849531591,0.575748598,0.375942489,0.263690738,0.23334755399999998,0.262573363,0.318337743,0.365019896,0.37279316,0.324446833,0.21917282100000002,0.0725388948,0.0,0.0,0.0,0.0,0.0,0.0,0.109731588,0.331658291,0.534336783,0.684474813,0.759473372,0.751516264,0.668442809,0.531338227,0.369494864,0.213945384,0.09102995779999999,0.0173853946,0.0,0.0233094544,0.0784416844,0.141578381,0.192506265,0.21678182699999998,0.208926428,0.17341697600000003,0.12341382199999999,0.0776878162,0.0565866979,0.0780356131,0.154473158,0.29131941699999997,0.487142178,0.7352449329999999,1.02605699,1.34954459,1.69691662,2.06114829,2.43622017,2.81536906,3.18896376,3.54277138,3.85732463,4.10884923,4.2718228,4.32280715,4.24483053,4.03138771,3.68912855,3.23852605,2.71220735,2.15110912,1.59907657,1.09686009,0.6766009959999999,0.35780751200000005,0.14552542699999998,0.030969247000000002,0.0,0.00957884377,0.0489536113,0.0884386043,0.11104588900000001,0.10870966800000001,0.08215296799999999,0.0390247577,0.0,0.0,0.0,0.0,0.0,0.0,0.00597056061,0.0393061097,0.060819628,0.0657493572,0.0535958468,0.028011203399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.00357483777,0.0411165514,0.0747210926,0.09827494960000001,0.108065479,0.103488248,0.08706102560000001,0.063762378,0.0398487493,0.0214044816,0.0129285634,0.016253944399999998,0.0300338035,0.049925873600000004,0.0694779512,0.08158512230000001,0.0802726172,0.0624765738,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.37566963,1.45657098,2.16016301,2.33655573,3.16916044,3.34661652,3.66980904,4.24968335,4.22632121,4.62854537,3.80719204,3.79258691,3.33668137,3.09914185,2.4277515,1.56508324,1.13680999,0.99567082,0.29408615,0.22105321,0.0,0.0,0.0,0.0,0.0,0.0,0.15402431,0.46746928,0.15297001,0.48179982,0.81158237,0.85847192,0.7066173000000001,0.14089416,0.10605872,0.0,0.26093577,0.0,0.0,0.0,0.0,0.01872222,0.0,0.0,0.14493725,0.0,0.21988342,0.52511172,0.04826479,0.16899865,0.22905367,0.02475638,0.0762029,0.38208984,0.0,0.18428542,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.56219808,0.37788658,0.37539255,0.74291146,0.94415541,0.11994434,0.0386491,0.54305999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01517695,0.53805895,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.2512585,0.0,0.0,0.6473995060000001,0.9384793140000001,1.3330266000000002,1.48433864,2.10989054,1.29848309,0.966125927,0.246761308,0.44525015,0.23539262600000002,0.249487653,0.222413833,0.09701350689999999,0.0873972464,0.0,0.0482320464,0.181521177,0.642396274,1.25123366,1.08750794,0.77437339,0.169593312,0.0,0.0,0.0,0.09511136519999999,0.396115135,0.0442585696,0.336939221,0.193300515,0.102804626,0.085885836,0.25021425199999997,0.0200364777,0.113901571,0.0,0.0861013548,0.0,0.0,0.0,0.0,0.194301124,0.0,0.0,0.014683370800000001,0.189280205,0.0779044658,0.21868309600000002,0.0,0.32386506600000003,0.129279224,0.0,0.0,0.022828989900000003,0.532134319,0.38708361399999996,0.98122264,1.0301835,1.1815651000000003,0.8770714190000001,1.42010074,1.84344773,2.40362897,3.31398124,3.28479251,2.84082116,1.72579154,0.651290946,0.0,0.0,0.048145702900000004,0.475622981,1.24088079,2.10235996,2.52958716,2.40028601,2.04441598,1.53432362,0.778566522,0.764500306,0.539795216,1.14048389,1.46199345,2.27542463,2.39869233,2.64142668,2.85577316,2.64104612,2.33811134,1.60040142,0.9548451490000001,0.754762525,0.575786518,0.0,0.0,0.0,0.0,0.22224333899999998,0.24099887600000003,0.0,0.382110505,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.59838624,0.26582968,6.28327807,25.24294064,0.0,5.67207754,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.235
0.484652775,1.15757189,2.12355692,3.20960113,4.14284468,4.64118483,4.51946556,3.76761027,2.56680832,1.23391312,0.112951736,0.0,0.0,0.0,0.0725940198,0.409939669,0.45838169700000003,0.210156641,0.0,0.0,0.0,0.0,0.472548985,1.12181943,1.56702796,1.6511422999999998,1.36612174,0.8453462709999999,0.29371545,0.0,0.0,0.0,0.0,0.0817989337,0.137355131,0.09750834609999999,0.00834016395,0.0,0.0,0.0,0.0150592018,0.0851107991,0.130407109,0.142890936,0.127387853,0.0935768273,0.0508794309,0.00830437068,0.0,0.0,0.0,0.00226534872,0.029999355499999998,0.0390687051,0.021447866200000002,0.0,0.0,0.0,0.0,0.0290064631,0.0574105195,0.0479454858,0.00300176949,0.0,0.0,0.0,0.0160312303,0.0736444255,0.0850526933,0.0368853393,0.0,0.0,0.0,0.0,0.0790957655,0.130545102,0.0943004813,0.0,0.0,0.0,0.0,0.055470032,0.152026047,0.133734242,0.0281550263,0.0,0.28562287399999997,1.09515437,2.45365415,4.1469083,5.76796835,6.87173214,7.16466184,6.63430442,5.55004924,4.33257359,3.3588428999999995,2.80329285,2.59442642,2.50138189,2.29383315,1.8812718999999998,1.35477972,0.914553313,0.733630222,0.84317169,1.10798241,1.30433171,1.25051994,0.9108002629999999,0.41184906,0.0,0.0,0.0,0.004339736320000001,0.20893219899999999,0.26489072,0.143909945,0.0,0.0,0.0,0.0,0.133494254,0.307384541,0.358876989,0.28850454600000003,0.159831779,0.0493930454,0.0,0.0036386090899999998,0.0358917114,0.08747767890000001,0.187434863,0.38170026,0.68534663,1.04348797,1.3351833,1.42757866,1.25220715,0.8558852790000001,0.389679915,0.0358772091,0.0,0.010610679199999999,0.205703792,0.333612892,0.289894728,0.0898428965,0.0,0.0,0.0,0.0,0.191505503,0.270467262,0.167342265,0.0,0.0,0.0,0.0,0.122383554,0.287454441,0.26269818300000003,0.053831616900000004,0.0,0.0,0.0,0.0294681637,0.325248964,0.42880252399999996,0.23745164,0.0,0.0,0.0,0.0,0.544530791,1.39901158,1.98982323,2.07592377,1.65873511,0.98618573,0.428255971,0.289928901,0.660108502,1.37367294,2.10169,2.51731395,2.44879778,1.94404227,1.22292203,0.5535408510000001,0.12374629999999999,0.0,0.010163125799999999,0.092363948,0.11401284800000001,0.0539417192,0.0,0.0,0.0,0.0,0.029326940099999997,0.0330923101,0.0325555062,0.137914661,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.054080750700000006,0.514389843,0.0,1.08048184,0.701283083,1.50529605,1.44320158,1.99489901,0.959496075,1.04601359,1.69419917,0.478672329,0.819969097,0.824358335,1.16000679,0.0,0.0,0.0,0.216748205,1.60865591,0.0,0.529112075,0.0,0.167731185,0.0,0.581848825,1.26440043,0.0,0.0,0.35712829700000004,0.508259771,0.986876946,0.0,0.214054721,0.278654868,0.0,0.620737091,1.09823433,0.595491924,0.8836242590000001,0.0,0.315303586,0.0,0.0,0.0,0.0,1.93651165,2.4656563,2.70452771,5.51350419,3.73535441,2.62315931,1.52877006,0.88411286,1.09059104,1.22668489,1.45278576,4.00512791e-05,0.381514439,0.0,1.01943732,0.765544879,0.26226606399999997,1.22036609,0.146340941,3.0605782,2.10016949,0.971618428,1.09830993,0.8806210940000001,1.37390105,0.433297728,1.27360073,0.150955399,0.570607575,0.46180565799999995,0.0,0.0,0.0,0.992530547,1.26677381,0.308501922,0.7446017509999999,1.3789582,0.0,0.909512152,0.0,0.0,0.177462895,0.0,0.0,0.019886194399999998,1.12230072,0.0,0.0,0.16877022100000003,0.154430365,1.54858426,0.0,1.28844384,0.0,0.0,0.7492912340000001,0.133577249,0.17030261300000002,0.0,0.0,0.16143703199999998,0.0,0.400546306,0.23438986,0.283617443,0.0,0.0,0.36402691200000004,0.460200038,0.0,0.0,0.0767659887,0.455079246,0.17234095600000002,0.19585379,0.15127753300000002,1.52825539,0.0657465501,0.0,0.593932386,1.46661502,0.106157838,0.46151978200000005,0.0,0.0981427693,0.91289099,0.0,0.734110195,1.46704031,0.0,1.7471643,0.8326808459999999,0.0,1.96228423,0.529195424,1.21008035,0.030242767400000002,0.216874874,0.604999549,1.6918442,0.0,0.517264438,1.10233194,0.0,0.0,0.0,1.42541908,0.0,1.66840877,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.27126986,3.36999994,2.03798576,0.22048885199999999,0.0,0.0,0.645905524,0.0,1.71319407,0.589130921,0.158371598,1.96986577,0.0319240669,1.38007287,0.0,0.698442138,0.0,2.11914267,0.524589296,0.7272269440000001,4.16473287,2.68734044,0.8931888729999999,1.81104808,1.19001394,0.55480066,0.0,1.40271983,0.0,0.0538039675,0.0,0.0,1.1417823999999999,0.0,0.684704455,0.641932318,0.44295657,0.30117351800000003,0.842178407,0.0,0.0,0.0,2.31062659,0.0,1.87825706,0.0,0.605531233,0.0,0.353806587,0.0,0.0,0.295439966,0.0,0.221054809,0.39311501600000004,0.354093262,0.430271123,1.3250305,0.0,0.748750652,0.256898364,0.0,1.41015298,0.513109923,0.112827692,1.68985098,0.09062193449999999,0.0,1.60847712,0.631998896,0.0,0.0877900568,1.68029358,0.0,0.148644868,1.1484425,0.829899805,0.420243094,0.0,0.939983377,0.0,0.0,0.0,0.0,0.0,0.640375899,0.0,0.0,2.91755492,3.7479192,3.73955496,2.34797792,0.350145931,0.0,0.349823053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0886066933,0.0852719472,0.0623274755,0.0,0.0,0.25131588899999996,0.928850015,1.94210945,2.95352917,3.53207726,3.41243407,2.66130587,1.62697112,0.7146543390000001,0.159561247,0.0,0.0,0.0,0.00976269821,0.0186298638,0.009794518790000002,0.0,0.0172538222,0.212118588,0.66268029,1.29726774,1.8490358,1.9943415,1.58831755,0.8100864320000001,0.0785736241,0.0,0.0168149108,0.54787239,0.988896045,1.07338488,0.797893958,0.36325061399999997,0.0,0.0,0.0,0.0151360386,0.23250928699999998,0.434829464,0.537913441,0.479735325,0.276556775,0.0381638091,0.0,0.0,0.0366195453,0.109383345,0.067035473,0.0,0.0,0.0,0.0504414088,0.105947161,0.0505104436,0.0,0.0,0.0,0.06661864519999999,0.107874836,0.0358392435,0.0,0.0,0.0,0.0848945186,0.110597476,0.0195384683,0.0,0.0,0.0,0.121871318,0.18259005399999997,0.177213387,0.21231739800000002,0.36068372,0.542593679,0.568899124,0.329306873,0.0,0.0,0.0,0.0784455391,0.31157262399999996,0.21805665800000001,0.0,0.0,0.178844397,1.09985317,2.06337692,2.55789053,2.47735423,2.23057061,2.38016576,3.11442121,4.02806862,4.42886884,3.91782191,2.73713176,1.5785565000000001,1.021017,1.09033328,1.31442259,1.19831774,0.676163345,0.139885389,0.0438024175,0.466317069,1.02959596,1.2348411,0.8933809979999999,0.26582008,0.0,0.0,0.0224699572,0.235812115,0.19110634899999998,0.0,0.0,0.0,0.0476088817,0.17946387600000002,0.120124046,0.0,0.0,0.0,0.062274539299999994,0.150945317,0.0813737665,0.0,0.0,0.0,0.0851940565,0.17616174399999998,0.130875579,0.0211069726,0.0,0.11375224699999999,0.333969177,0.510975029,0.545113211,0.44672712,0.303060165,0.190220919,0.12035891900000001,0.0636779949,0.0042638413299999995,0.0,0.0,7.264481799999999e-16,0.0288444344,0.0216300323,0.0,0.013184581899999999,0.0904146399,0.191089277,0.23669174899999998,0.181168918,0.058922204299999996,0.0,0.0,0.0274780823,0.105978449,0.11836793599999999,0.0615513684,0.0,0.0,0.025327053199999998,0.0794317338,0.0951500321,0.0784817202,0.0913941453,0.197311935,0.396884521,0.608677382,0.713091542,0.629788597,0.375611518,0.0639277069,0.0,0.0,0.0,0.19026629899999997,0.346602124,0.359200156,0.258289182,0.142679483,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.364787305,0.310423538,0.32757254399999997,0.016509466100000002,0.333072113,0.0,0.146662778,0.0,0.0,0.0,0.043130454500000005,0.237862071,0.0,0.274735756,0.31999511199999997,0.31190725399999997,0.25945993100000003,0.269943508,0.186280773,0.211204415,0.0150146958,0.0,0.149308568,0.432377585,0.517546327,1.20024388,1.56821951,1.04515805,0.9069414000000001,0.43114084700000005,0.0,0.0,0.556386418,0.799026288,0.668954191,0.7531805909999999,0.78143287,0.195313337,0.020240013,0.0,0.0,0.276045869,0.0,0.0,0.09835954470000001,0.11947144400000001,1.02331096,2.43628441,2.88795324,2.75266617,2.27668116,1.26804007,0.738059914,0.35193461299999995,0.495444675,0.902874877,0.749911585,0.395048091,0.0,0.0,0.0,0.270401161,0.24664142600000002,0.19525901,0.283005246,0.0,0.0,0.09524955130000001,0.493028701,0.539239138,0.124244414,0.0,0.0843473684,0.0,0.570028058,1.50353309,1.70256402,1.87215079,1.48255987,1.13883935,1.00850361,1.35306357,1.47067618,1.52859978,1.51520137,1.06868363,0.632744753,1.17411956,1.9754415,2.51130566,3.24824801,2.98310569,2.26006303,1.1849919,0.709099488,0.8435727679999999,1.22810202,1.27996095,1.0308225,1.11175604,0.46521640299999995,0.5248620279999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.43445698,1.72038186,0.932683259,0.24493961600000003,0.0,0.0,0.0,0.0,0.082577843,0.204169262,0.2050638,0.11034191800000001,0.0,0.0,0.0,0.0,0.0,0.06855275129999999,0.116820755,0.12363047699999999,0.100820044,0.0687735577,0.0429238421,0.026492101400000002,0.012731091299999999,0.0,0.0,0.0,0.0,1.93354045e-16,0.0700203191,0.14905701300000002,0.20785846,0.22281294699999998,0.188448793,0.12112607199999999,0.0512427485,0.00759231488,0.00213428423,0.0236866589,0.0445512513,0.0370884906,0.0,0.0,0.0,0.0,0.0,0.148716605,0.35642120299999996,0.55738306,0.7230390440000001,0.861171736,1.01637861,1.24865015,1.59823224,2.05313639,2.53637885,2.92232086,3.07851318,2.91714384,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.629834839,0.0,0.33425651100000003,0.558446795,0.0,0.7151381059999999,0.402942976,0.0,0.0,0.35135371,0.875466097,0.997438443,0.9535775870000001,1.00109685,1.47773422,1.80557638,2.55320655,2.68448192,2.30309915,3.32778948,3.47585953,2.13768647,2.90722701,2.39680959,1.76159936,0.325529687,1.50644531,0.0831915604,1.04710156,1.12085582,0.523357555,0.880518288,0.48984715,0.0,0.0,0.0,0.492062623,0.563509979,0.0,0.0,0.167560444,0.392598615,0.0367949163,0.0,0.0,0.0,0.0,0.6731772229999999,0.278776743,0.23528034399999997,0.0,0.19705501399999997,0.0,0.09270484080000001,0.587555057,0.200254054,0.0,0.0,0.0,0.0,0.356045244,0.27100515399999997,0.39153205799999996,0.35332802799999996,0.0,0.44843746100000004,0.6740937359999999,0.757685715,0.561883175,0.0,0.0,0.34963862799999995,0.0875361802,0.0,0.0,0.0,0.0717561942,0.213292061,0.333259383,0.0,0.0,0.0987751626,0.08046876139999999,0.0,0.40734053600000003,0.0,1.0463069999999999,0.0,0.0843646282,0.0769032627,0.748535837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.55627987,0.0,0.5549560570000001,0.222634533,0.0,0.588429854,0.749322887,0.0153965019,0.7404474740000001,0.0,0.0424203744,0.0,0.268684501,0.21154168899999998,0.0,0.7955846540000001,0.0,0.0,0.281595109,0.0,0.48219482,1.21947661,0.501619733,0.416999897,0.0,0.07392092730000001,0.602844601,0.0,0.0,0.25855793899999996,0.0,0.400212474,0.0,0.0,0.0,0.0,0.0,0.0,0.00867467716,1.30139843,0.0,0.180523342,0.526581724,0.0,0.0,0.0,0.223176588,0.0627846306,0.20676783899999998,0.0,0.0,0.35994770299999995,0.300237858,0.0,0.0531270183,0.194788034,0.31055488800000003,0.179824612,0.194773134,0.5727417579999999,0.88791835,0.9135225159999999,0.0,0.0,0.949287653,0.0,0.0,0.0,0.0,0.0,0.0,0.255354368,0.0,0.23669995800000002,0.0,0.0,0.0,0.0,0.886655674,0.152695782,0.16929117300000002,0.0,0.0,0.0,0.406465504,0.694812902,0.47500636,0.00933781979,0.0,0.0,0.0,0.282618983,0.0,0.401293535,0.0,0.8396319659999999,0.747595145,0.0,0.0,0.373936628,0.0,0.0513680625,0.604969189,0.9321859809999999,0.388505431,0.824357833,0.251491428,0.286220613,0.0,0.47369295,0.0,0.36215332299999997,0.194296147,1.00983283,0.543402846,0.304393181,0.30214757600000003,1.31491243,0.163918019,0.0,0.0,0.0,0.413851158,1.00182618,0.43580879200000006,0.0,0.0233515761,0.0,0.16232186,0.0,0.142394696,0.0,0.0,0.0,0.21680851,0.272794997,0.0,0.254925252,0.7341701070000001,0.905318815,0.168185494,0.431493888,1.30747232,0.613571024,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.40100319,3.06024203,3.61341847,3.97618742,4.08232284,3.89642084,3.42282065,2.70895295,1.84213117,0.9398224340000001,0.134507082,0.0,0.0,0.0,0.0273110323,0.9681699009999999,2.18925175,3.55480637,4.90444822,6.07445813,6.91991253,7.3343776,7.26424986,6.71562964,5.75275048,4.48827506,3.06699979,1.6454891,0.370732144,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.29193929,0.6882924579999999,0.909917183,0.9390667770000001,0.79289803,0.516945926,0.174547435,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10048538,0.308401076,0.442382557,0.483361883,0.43086044,0.301691718,0.125602564,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0355547747,0.163165204,0.251240126,0.285964515,0.264511017,0.19482800399999997,0.0934086344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00703846173,0.08452027599999999,0.139979906,0.164645431,0.15632385699999998,0.11931857400000001,0.06308819480000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.035363053,0.06267577790000001,0.0745170358,0.07059727240000001,0.053895274699999995,0.0296572642,0.00400331037,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00304020913,0.0026495438800000003,0.0,0.0,0.0,0.0,0.0,0.00854882294,0.0234974912,0.037425994500000004,0.04593283150000001,0.0453036537,0.0336252704,0.011547688300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0240112678,0.0710772505,0.108467977,0.127222789,0.121500081,0.09013118519999999,0.0372905994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0289595458,0.11311304300000001,0.17977270199999998,0.214192137,0.207407635,0.15852744400000002,0.07548282889999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.102609962,0.230238114,0.325641255,0.368408911,0.349798373,0.27653940899999996,0.171849444,0.0731296874,0.0264144902,0.07828770809999999,0.266541427,0.611221099,1.1077926000000002,1.72394276,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.463409425,1.37527521,0.0,0.335407313,0.305889986,0.0,0.0,1.06396857,0.0,0.39099929200000005,0.28379744100000004,0.47155449899999996,0.577894505,0.0,0.860101958,0.0,0.976454246,0.0,0.021833260499999996,0.15635494,0.0,0.479199764,0.149080889,2.34948652,1.48509772,0.909493529,0.523558606,0.0,0.0,0.0,0.289795077,0.0,0.07572749849999999,0.375729534,2.1135236,0.6746393070000001,0.0,0.457463147,0.6806086920000001,0.648764256,0.158245253,0.580429327,0.884523032,1.51495581,3.94253521,0.6350465270000001,0.135038598,0.0,0.0,2.40023745,0.0,0.9561654740000001,6.23312878,0.8229359540000001,1.31216725,0.0,0.878721746,0.0,9.50056004,4.98731705,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.80479528,1.29200156,2.01580774,0.0,0.82772123,0.0,0.62486796,0.0,0.53185137,0.0,0.56021463,0.0,8.51813711,4.85948542,1.62660255,0.0,0.0,0.27656188,0.0,2.38369056,5.68927811,1.49330096,0.0,7.6460314,8.42178095,0.0,3.66393485,0.04470654,0.7616712,0.06712330000000001,4.15706509,1.12115358,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.100025848,0.147277725,0.195009923,0.23551407600000002,0.261661878,0.268020101,0.25180789800000003,0.21355004800000002,0.15731251,0.09045707550000001,0.0229142585,0.0,0.0,0.0,0.0,0.0403657718,0.15592695199999998,0.303034778,0.469908761,0.64146188,0.800974235,0.932096653,1.02094744,1.0580398000000002,1.03978397,0.9693483,0.856732625,0.717998847,0.573706368,0.446701265,0.35949539399999997,0.33153305,0.376669945,0.501177235,0.702532506,0.9691747959999999,1.28129148,1.61258386,1.93283991,2.21104214,2.41866742,2.53280474,2.53872973,2.43163111,2.21727822,1.91153922,1.53879226,1.12940191,0.716542757,0.33273024100000004,0.0064537005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.144030546,0.280979761,0.372105265,0.406474485,0.38150374600000003,0.302874142,0.18341818899999998,0.0411402736,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0773321452,0.20460117,0.302771658,0.357728473,0.361252379,0.312161759,0.216526418,0.0869265765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.046385588600000006,0.246887697,0.443237859,0.6152971420000001,0.7464546459999999,0.8258871790000001,0.850117007,0.8236628579999999,0.758690671,0.673693697,0.591351054,0.5358151529999999,0.52974902,0.591466091,0.732513805,0.9559900859999999,1.25579513,1.61691075,2.01667923,2.42693804,2.81676928,3.15555494,3.41599866,3.57678374,3.62458518,3.55523196,3.37391663,3.09445829,2.73773011,2.32945142,1.89760616,1.46977978,1.07070102,0.7202374090000001,0.432028731,0.21286019899999997,0.0627876675,0.0,0.0,0.0,0.0,0.0186920784,0.0590958207,0.08977981089999999,0.105428186,0.104296241,0.08779603119999999,0.0597438474,0.0254047165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0026536120799999998,0.0226682719,0.0372739227,0.044978933799999996,0.0454516666,0.039437238900000005,0.0285243198,0.014813897900000001,0.000551711829,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00824649185,0.0184740662,0.0283191698,0.0376669502,0.04650586,0.0547942178,0.062338354400000004,0.0687162341,0.0732713832,0.0751876257,0.07363807730000001,0.0679851575,0.057995152,0.044023682300000005,0.0271289529,0.00907821749,0.0,0.0,0.0,0.0,0.0,0.0123566082,0.046012776500000005,0.0871732555,0.132288243,0.17695053,0.21640934399999998,0.24618174899999998,0.262680467,0.263767845,0.24914944600000002,0.220537667,0.181544344,0.137297853,0.09382008039999999,0.057235943600000005,0.0329174816,0.024680958399999998,0.0341558449,0.0604278621,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.169742117,0.0,0.0,0.0729553613,0.539026132,0.0682142989,0.145479843,0.7089289879999999,0.37240252,0.0207217484,0.5205822720000001,0.229571883,0.309822503,0.20778021,0.272775908,0.15454785699999998,0.296321489,0.339245047,0.022519294500000002,0.051235685999999996,0.026328808199999998,0.0,0.0,0.18920181,0.18666919199999998,0.081454951,0.120435761,0.293730379,0.0,0.492620069,0.09260673109999999,0.0,0.176695241,0.289376162,0.0,0.29033533,0.20597706100000002,0.205580722,0.45348924,0.0,0.23798987600000002,0.07983087009999999,0.10363765,0.125921049,0.0337450028,0.38457017600000004,0.221528285,0.34743238200000004,0.00269299534,0.553656099,0.349667684,0.0,0.0,0.0,0.235541093,0.0,0.294599006,0.218309232,0.571976075,0.761743776,0.8308778040000001,0.9022938140000001,0.413756723,0.442023438,0.84527072,0.280512613,0.27015426600000003,0.627077215,0.704193607,0.8150937079999999,0.452531342,1.02983532,0.42216013700000005,0.765453878,0.627655257,0.467573839,0.872422169,0.359493816,0.759189625,0.22992858800000002,0.0814672961,0.365259929,0.165363865,0.183990155,0.0,0.0,0.160862538,0.21688205600000002,0.268489092,0.0,0.0,0.0,0.0,0.0,0.15131077699999998,0.0484895782,0.242753005,0.16211463,0.104365131,0.376380493,0.0,0.153760215,0.0,0.0361106942,0.0,0.18974675100000002,0.0855068978,0.21248057899999997,0.378505042,0.559967041,0.575633262,0.746137044,0.28750428899999997,0.30033293699999997,0.0,0.26000148,0.173960151,0.569716808,0.694415508,0.8439605790000001,0.7143080629999999,0.368226169,0.57105872,0.365829676,0.0,0.0519235075,0.23547591699999998,0.59148012,1.15652497,1.39315503,2.0317573,2.08361531,1.7755589,1.72157341,1.31205726,0.833843219,0.689701027,0.26752521,0.698275953,0.338274036,0.8242322390000001,0.925568414,0.79643069,0.871498746,0.85016442,0.14346568199999998,0.0,0.0,0.0,0.0,0.0,0.316535444,0.45729431299999995,1.0631635,0.9877135,0.620513819,0.591914531,0.187515923,0.0,0.0705253653,0.537290127,1.1917105,1.9636713,2.76840309,2.75346673,3.5212607000000005,3.74480151,3.56070812,3.66895377,3.40726114,3.1480311000000003,2.57459195,1.93264706,1.93765105,1.17643507,1.38043692,0.434856717,0.323556457,0.486446198,0.0,0.10144566599999999,0.45369617700000003,0.46756325299999996,0.710211822,0.523657809,0.399201707,0.311272314,0.260162469,0.47416162799999995,0.0360330904,0.020043639499999998,0.35005432299999995,0.204747878,0.0,0.144597765,0.281850947,0.057831705899999995,0.0,0.354476921,0.0,0.0,0.356087019,0.0,0.0,0.139891511,0.205034501,0.0,0.29414913,0.385320359,0.392864437,0.327982376,0.0,0.0,0.09311458480000001,0.0596328095,0.0,0.0,0.0,0.00929415522,0.415051635,0.0,0.22968460100000002,0.0889524243,0.0,0.0810286095,0.24839461899999998,0.0,0.0,0.267275597,0.251074082,0.125325896,0.0685489572,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.161546375,1.39125109,1.93695715,3.09302148,2.86445931,2.70794728,2.48536236,1.27112988,0.8549362979999999,0.221025592,0.26629412,0.269542022,0.654359369,0.695205225,0.432616575,0.406568417,0.876150995,0.5887938079999999,0.0229514044,0.10967478,0.194416941,0.0,0.0,0.0,0.0,0.19982124899999998,0.282597822,0.048326924900000005,0.20530114600000002,0.0,0.0,0.0,0.0,0.296257608,0.750302558,1.42303314,1.54954531,1.49857016,1.77298121,0.795940109,0.42885512299999995,0.331435197,0.10851355900000001,0.0,0.0,0.0,0.0,0.0,0.315600163,0.0,0.0822281989,0.0,0.0,0.0,0.0,0.197544661,0.0,0.14190202,0.300029027,0.032148204900000005,0.0523661114,0.39896507200000003,0.519783545,0.25243349600000003,0.0,0.18027577,0.11489745,0.0,0.0,0.0733624965,0.0234794775,0.0,0.0,0.0,0.0,0.0,0.0180639199,0.206848809,0.0,0.380162979,0.249771317,0.0418959316,0.630135756,0.496958808,0.275998568,0.7150066890000001,0.27646445199999997,0.44815929299999996,0.0931284278,0.0,0.17127772100000002,0.0361154112,0.16262681,0.0,0.0,0.367097685,0.129783719,0.16693846099999998,0.0,0.0,0.0,0.191268021,0.141407876,0.0211837425,0.0,0.0,0.183427775,0.0,0.0,0.0,0.159068464,0.38846897399999997,0.0,0.0683922274,0.0,0.0,0.338257486,0.6828696120000001,1.60313511,2.02888203,2.37795613,2.39251628,2.06874365,1.31180639,0.790817786,0.0,0.0,0.0,0.0,0.34449131299999997,0.589201319,0.49424409,0.602231239,0.12186612599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.55145706,0.28573748,0.25802206,0.69312369,1.27509405,1.70439847,0.0,1.5752092,0.0,0.50793632,0.29941333,1.9005026999999999,0.41583336,0.0,0.855915,0.88108834,1.21238694,0.67743368,1.02936307,0.15329389,0.42642975,1.09757032,1.71557718,0.34246569,0.0,0.0,0.68336516,0.52605478,0.0,0.0,0.39991701,1.11197402,0.66753942,0.0,0.0,1.38268076,0.15951562,0.0,0.0,0.0,0.0,0.53956132,0.55793419,0.0,0.62690461,0.32200457,0.46597438,0.0,0.0,0.44117596,0.30311753,0.0,0.65943688,0.20040976,0.69883502,0.9576728999999999,0.0,0.23780521,0.0,0.0,0.05763816,0.05394136,0.17881056,0.0,0.4156693,0.0,0.0,0.0,1.44511948,0.0,0.36757290000000004,1.00798535,0.0,0.33092661,0.6866547,0.65955447,0.0,1.09527063,0.0,0.0,0.08141083,0.0,0.0,0.41370056,0.0,0.0,0.0,0.1117365,0.0,0.0,0.33651917,0.0,0.26082691,2.15060419,0.0,1.18856157,0.0,1.64331756,0.59428933,0.0,0.33892061,1.75169322,0.0,0.41180646,0.0,1.70037933,2.70413939,1.59993411,2.2697977000000003,0.0,0.0,0.86439215,0.65980028,0.0,0.0,0.0,2.95004821,2.08980007,2.6672714,2.44633464,5.97864079,5.49038323,3.1629292999999996,4.82974577,3.55453889,3.62168532,2.25725794,0.88702438,1.28540106,1.08872804,0.0,0.70286174,1.78967911,0.70037626,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.19086267,0.387835088,0.2503771,0.08256664009999999,0.360973316,0.0,0.0,0.118060389,0.493890393,0.0,0.923103727,0.575724084,0.0,0.0,0.47962614299999995,0.520278504,0.23532057,0.0,0.47994198200000004,0.791393585,0.505839287,0.280577282,0.37463511899999996,0.524530261,0.04317782,0.608818713,0.0,0.361660081,0.0,0.308519278,0.0907650679,0.0,0.157580561,0.0,0.240706013,0.306377507,0.040372318500000004,0.32180215100000004,0.184566117,0.429981589,0.222990472,1.07604689,0.985532504,1.28116477,1.48271857,2.09231296,2.46952736,1.48202112,1.39138297,1.74470891,1.44441375,1.81421478,1.84116866,2.27795887,1.82932512,1.29117663,0.313529088,0.441803075,0.825978845,1.17322214,0.9453963559999999,0.46518568899999996,0.0,0.18851393,0.0,0.022449764700000003,0.0,0.114770705,0.0,0.27565842,0.0,0.0,0.5942919010000001,0.49763170100000004,0.037879276600000004,0.38605901200000003,1.67543999,2.06629761,1.31143503,0.38667095,0.0,0.0,0.17018502300000002,0.0,0.5486041110000001,0.647309651,1.06982373,0.7516576509999999,0.572710689,0.0235874737,0.0,0.353643967,0.234424685,0.0,0.0,0.0,0.441998679,0.0,0.238916085,0.208143212,0.21285244600000003,0.457750101,0.405941141,0.059757326,0.221982178,0.0,0.106091578,0.0240507418,0.0,0.143476279,0.665635955,1.18397478,2.1895278,2.487373,4.87993147,5.46481234,4.64214977,3.11602255,0.476139364,0.300223177,0.0,0.52527653,1.49355399,1.07225983,0.497058348,0.0,0.0826121321,0.13194475,0.25321258399999996,0.839598025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.13128015199999998,0.336378144,0.503455448,0.621487068,0.684209603,0.6902252409999999,0.642745685,0.549013221,0.419458495,0.266671596,0.104273584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07576674950000001,0.173308625,0.251995905,0.30675056100000003,0.334808414,0.335809401,0.311683008,0.266349104,0.205268758,0.134890412,0.0620433482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0346560051,0.08550804070000001,0.13036894400000001,0.16536767,0.187693319,0.19578845,0.189421958,0.169641108,0.138612986,0.099375006,0.0555212264,0.0108557298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0026458708600000003,0.0271602455,0.046877073899999996,0.0604848412,0.0673609151,0.0675765104,0.061833619299999996,0.0513440009,0.037665562,0.0225149807,0.00757693615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00176665457,0.014616559599999999,0.0283998456,0.0416212232,0.052668245499999995,0.0599888474,0.062274826299999995,0.0586314292,0.0487137685,0.0328133887,0.011882734399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03354007,0.0727142161,0.108106801,0.136168325,0.153792165,0.15863539,0.149387054,0.125955741,0.08955419999999999,0.0426674335,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0420911801,0.118380822,0.188534223,0.245880632,0.284511887,0.29985817800000003,0.289177627,0.251911648,0.18986730100000002,0.10720101,0.0101939474,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10458175300000001,0.26218868,0.41253744600000003,0.541777846,0.636724735,0.6860104909999999,0.6811705859999999,0.617572446,0.495105797,0.31856733,0.0976931931,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.520817223,1.14409731,1.81966891,2.51824411,3.20792433,3.85605112,4.43114559,4.90480785,5.25344889,5.45973798,5.5136673,5.4131612,5.16418902,4.78037398,4.28212564,3.69535574,3.04986576,2.37751597,1.71030004,1.07845397,0.5087240820000001,0.0229057537,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.00545591963,0.337091773,0.661391349,0.512831979,0.0563941029,0.0,0.0618195688,0.204093329,0.0068508395799999995,0.0,0.0,0.18390531,0.148814741,0.0,0.0,0.06460128379999999,0.22549267899999997,0.0148451324,0.0,0.0,0.196559889,0.16932172899999998,0.0,0.0,0.0647794909,0.255996658,0.0252918993,0.0,0.0,0.21736097699999998,0.205644301,0.0,0.0,0.42819810700000005,0.598527284,0.16524897800000002,0.0,0.7858451909999999,2.09848395,2.45120013,1.6094093999999999,0.988550959,1.60807958,2.49918073,2.08955472,0.624014115,0.0,0.46230297600000003,0.739000971,0.0,0.0,0.406557228,4.95512715,8.10898956,6.56223915,1.7648157,0.0,0.0,1.08043838,2.26226544,1.48918579,0.426949798,0.295243071,0.52844659,0.243811007,0.0,0.0,0.148608566,0.30280637899999996,0.0,0.0,0.0,0.21689813800000002,0.21319417699999998,0.193487283,0.508859423,0.849501807,0.633984291,0.0,0.0,0.0,0.29149599600000003,0.205289626,0.0,0.0,0.140047957,0.26290788800000003,0.0,0.0,0.0,0.19585824899999998,0.135950947,0.0,0.0,0.0669277529,0.18156199399999998,0.0351415345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.408756326,0.156456134,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0019748660100000004,0.137958629,0.279810081,0.42049070299999997,0.5535286939999999,0.6732239959999999,0.774815184,0.854603232,0.9100290390000001,0.939703525,0.943391034,0.921948634,0.877225549,0.811928469,0.729459599,0.633735216,0.5289929760000001,0.419596366,0.30984450399999997,0.203794907,0.105106036,0.0169052894,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00317681939,0.046337995300000004,0.0855850693,0.11908740699999999,0.14543404199999999,0.16367341900000001,0.173329056,0.174391615,0.167288943,0.152836626,0.132172447,0.10667872800000001,0.07789699809999999,0.047439557800000004,0.016902513799999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00976205852,0.0199388341,0.027290791000000002,0.031690070699999996,0.0332196133,0.0321567567,0.0289453863,0.0241585808,0.0184542047,0.012526261,0.007055019940000001,0.00265896847,0.0,0.0,0.000323868188,0.00383021532,0.00935938563,0.0165694766,0.0249619632,0.0339130714,0.042713976699999996,0.0506174899,0.0568884849,0.060855066299999996,0.061957386100000005,0.059791097300000005,0.0541426852,0.0450143249,0.0326364586,0.0174669467,0.00017637599600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0267450052,0.059260409900000005,0.0916358216,0.122141653,0.149028939,0.17061934199999998,0.18539634,0.192092985,0.189771645,0.17789132,0.15635858800000002,0.125558907,0.08636579970000001,0.0401264805,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0525006064,0.148611044,0.24709266600000002,0.344239825,0.436291985,0.5196095479999999,0.590853119,0.647158357,0.686298449,0.706826482,0.708190558,0.690815438,0.656145689,0.60664679,0.545762336,0.477827237,0.407938728,0.341788779,0.285463289,0.24521496,0.227218107,0.237314634,0.280761067,0.361986816,0.48437363899999997,0.6500657670000001,0.8598191409999999,1.11289692,1.40701675,1.73835333,2.10159789,2.49007381,2.89590549,3.3102355,3.72348311,4.12563541,4.50656097,4.85633504,5.16556452,5.42570085,5.62932941,5.77042451,5.84456057,5.84907128,5.78315086,5.64789328,5.44626772,5.18303106,4.86458039,4.4987507,4.09456514,3.66194681,3.2114025,2.75368982,2.29947968,1.85902611,1.44185513,1.05648351,0.710177053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.940793304,1.56691154,1.50576623,1.75350191,1.75229251,1.88174271,1.69640718,1.25262321,0.967906698,1.08456429,0.7465969179999999,1.22885368,1.37892978,1.56254516,1.8433363999999999,2.30346473,2.6177444,3.19223192,3.17067727,3.02496682,2.8141418,2.95741464,2.31412387,2.01157711,1.71807328,2.21251509,1.95627245,1.85862324,1.94382618,2.56103842,2.35337317,2.36302675,2.34200889,2.07067881,1.55228401,1.16414156,0.6301429789999999,0.577036641,0.597737098,0.75711117,0.8171993590000001,0.895991557,0.630147577,0.670847416,1.09828861,0.894291196,0.531047095,0.748439175,0.47283773,0.518604538,0.331694301,0.374196938,0.27768738,0.0,0.0791529917,0.15568795,0.231887654,0.0,0.0,0.325697177,0.0,0.40117655399999996,0.153996823,0.7673349559999999,0.456238107,0.492269045,0.11205445,0.156871578,0.0674612684,0.053895846399999996,0.111708062,0.0,0.11945794300000001,0.0,0.0,0.0,0.0,0.265825555,0.016517110800000002,0.0,0.0,0.0,0.19345197,0.0,0.0,0.268049221,0.0,0.0,0.182687921,0.0,0.3441862,0.0,0.0,0.0523660699,0.0,0.0651557889,0.047357567,0.006550154420000001,0.0,0.170733508,0.307879048,0.0,0.0,0.123011275,0.0645611648,0.0,0.09527169939999999,0.0,0.0,0.0183246629,0.316641666,0.0,0.203833624,0.110022786,0.0,0.0,0.10154572,0.0,0.142748424,0.0,0.280277854,0.31656338100000003,0.0939234099,0.24787065100000003,0.0,0.210432528,0.38594331,0.755044245,0.646881839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.24645462,3.3462377,2.45355838,2.95826766,2.7217957999999998,2.54423563,1.16991586,1.92545237,2.67777671,1.32144041,1.53600503,0.647896307,1.07233313,0.0,0.0744886874,0.19687867899999997,0.19886300699999998,0.0075612432200000005,0.135174716,0.0,0.0,0.0,0.0,0.0,0.0,0.138058068,0.0,0.279562711,0.0,0.0,0.0,1.04805564,0.0,1.5868798000000002,0.368004107,0.270346295,0.19662173,0.97434336,1.19402409,0.28055179399999997,0.0,0.0,0.7782683779999999,0.0,1.34499505,0.0,0.0,0.18565957100000002,0.214404206,0.0,0.0,0.0,0.0,0.498959749,0.0,1.31534445,0.0459844837,0.116229405,1.1560236000000002,0.0,0.0,0.167300835,0.558825565,0.598805272,0.639987749,0.6117669729999999,0.0,0.597483895,0.44928862399999997,0.0,0.213955759,0.0483196782,0.0769530168,0.0,0.0,0.0,0.0,0.0291514775,0.277228314,0.0,0.0,0.0,0.349796615,0.0,0.390957093,0.40666167299999995,0.0784159849,0.10215240800000001,0.563956817,1.45410926,0.0502886247,0.913134019,0.0,1.90627431,0.0,0.0,1.39366075,0.425909847,0.0,0.5707503039999999,0.443352047,0.0,0.0,0.276190859,0.0,0.0,0.112370157,0.0,0.158086354,0.0,0.0,0.0,0.617599256,0.0,0.406505484,0.0,0.502634131,0.304633019,0.0,0.428801211,0.0,0.19165443199999999,0.46332916,0.295324656,0.0,0.065203323,0.08902879710000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0967783975,0.298791568,0.0,0.0,0.0,0.0,0.0,1.01158114,0.585554224,0.208200052,0.326550565,1.2900332,2.55231494,2.64423434,2.4670806,3.12096277,2.45875552,2.37143277,2.91755889,3.15610612,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.59786495,1.04786518,2.38179688,0.8170254779999999,0.800150715,0.369341377,1.33860383,0.411011489,0.0,0.919470745,1.03006908,0.0,0.501789821,0.0,0.0034128567299999994,0.5761256379999999,0.0,0.0,0.5456908420000001,1.68251374,0.0,0.466351616,0.0,0.16663308400000001,0.0,0.0,0.0,0.275171479,0.282394685,0.510171753,0.0,1.42402735,0.6599565,0.177010003,0.521733714,0.0,1.20201754,0.946750347,0.0,0.685133483,1.3381484,0.0,0.46029665700000005,0.0,0.0,0.0,0.0,0.153087719,0.342224837,3.54252845,2.9830813999999997,2.7457431,3.03348926,1.35399105,0.0,0.100673619,0.6839633159999999,0.5511566379999999,0.0,0.0,0.8488131740000001,0.0,1.02038601,0.0,1.78839671,0.0,0.251073906,0.50038331,0.582147353,0.0,0.5426293729999999,0.0,3.3679803999999995,2.09508771,0.0,1.92424382,0.0,0.0,0.515327478,0.0,1.49766971,0.0,1.10575356,0.0,0.0,0.272096173,0.0,0.0,0.6108615239999999,0.0,0.712505323,0.0,1.00228127,0.0,0.0,1.19864858,1.23364017,0.98172198,1.37365924,0.5724369779999999,4.1601042,3.11663115,2.28078609,0.0,0.008390905390000002,0.136087855,0.018810261,0.33902218100000003,0.104665364,0.0,0.0,0.0,0.0,0.220741993,0.0,1.21817016,4.5518042,1.61265175,0.7682165459999999,0.400115234,0.0,0.0,0.0,0.105886665,0.0,0.0,1.22316718,0.0,0.0,0.19492931600000002,1.6692121,1.10379486,1.08289823,0.0,0.0,0.499179042,0.472063195,0.0,0.31783294100000004,0.329545902,1.07363426,0.0,0.7136880529999999,0.887964612,0.160605516,0.344914612,0.35050605100000004,0.0,0.0,0.0,0.38788323399999997,0.868443518,1.23863436,1.77879398,0.0,1.45413131,0.0,0.589576455,0.556529026,1.11765109,0.0,0.438287945,0.0,0.574591418,0.0,0.0,0.0,0.0,0.214223142,0.18524776199999998,0.11076346699999999,0.0,0.0,1.62463568,0.0,0.0,0.0,1.15789356,1.52778835,0.0,0.0,0.665312441,0.613958705,0.40733174899999997,1.8891063000000001,0.0,1.91185566,0.551968755,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0753081973,0.0,0.0,0.61298319,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.49488669,0.0,0.0,1.71134043,0.0,0.0,1.18573032,0.0,1.48608066,2.69288187,0.0,11.39528617,17.57172208,0.0,0.0,3.77384811,0.0,0.0,1.6117188999999998,0.56822233,2.72404733,0.0,0.0,0.0,0.0,0.0,1.27523243,0.0,0.0,1.6234984,0.21018420000000002,0.8828013000000001,0.7041213000000001,1.90472391,0.82104967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.66563431,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.237
0.300263118,0.08044409150000001,0.0102402587,0.137720393,0.0,0.0,0.0,0.0,0.0345200497,0.224036615,0.417152026,0.0980393234,0.20941032199999998,0.44169423399999996,0.0,0.0,0.0,0.0,0.429818274,1.85577236,3.01470613,2.67095224,2.92321148,4.34622263,4.33907152,1.20078966,0.0,0.0,0.0,0.0,0.0,0.213183163,0.262099275,0.437271109,0.380425966,0.853035295,0.782073398,1.88561517,1.85513092,1.40426834,2.38343705,2.16063269,2.65683589,2.52522105,2.76881771,2.31454577,0.94257715,0.375756604,0.475047286,0.0,0.0,0.0,0.032295731800000005,0.373615604,0.0,0.0,0.0,0.0,0.129590184,0.313891271,0.366784925,0.0563111989,0.0,0.0,0.417405642,0.261826617,0.0985327412,0.498439994,0.06731253570000001,0.0,0.69363179,0.652816119,0.33802752,0.309680487,0.0,1.07864238,1.00052159,0.349752285,0.0,0.0747957478,0.190957083,1.54678027,1.49365375,0.7823178479999999,0.7257726520000001,0.50026842,0.0,0.349019966,0.0751997653,0.336849401,0.0,0.0,0.0,0.0,0.41618979799999994,0.0,0.0165521164,0.198805123,0.0,0.8283913190000001,1.95773758,0.33867867100000004,0.33613731700000005,0.47584735799999994,0.0,0.0,0.38546353,0.673319934,0.0741784145,0.196454407,0.506096277,0.0,0.128170035,0.0,0.0,0.0,0.0198596961,0.402927826,0.119419071,0.251830753,0.261919113,0.37459740799999997,0.0223300022,0.0,0.24236058600000002,0.0,0.0,0.48498069200000005,0.718804508,0.27791520000000003,0.463625457,0.257657756,0.13169782300000002,0.5322843110000001,0.472298358,0.09208628769999999,0.470003561,0.128697959,0.0,0.6973062179999999,0.207898657,0.401577711,0.250463983,0.558214461,0.773245353,0.17545840199999999,0.48489206700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.97049853,1.86446391,3.24554646,1.29694436,0.14724747800000001,0.0297232448,0.0,0.554875483,0.218128543,0.0,0.92170666,0.038892346200000004,1.53344106,0.8316848720000001,0.439118036,1.01829479,0.17109872899999998,0.0,0.0,0.0,0.0,1.86951302,1.28328727,0.0,0.128335117,0.0384136797,0.0,0.0,0.0,0.005835074920000001,0.355298199,0.0,0.0999566875,0.0,0.0,1.0507524,1.77537813,0.615543369,0.321760779,0.0,1.50595253,0.0,0.257171457,0.951372302,2.66614437,0.00216154075,1.27313642,0.254192132,0.0,0.0,0.0,0.0,0.0,0.0,0.0696907489,1.0300748,0.0,0.0,0.0,0.155207023,0.0,0.783022291,0.805893283,1.01261152,0.0,0.0,0.0,0.527002582,0.8882456390000001,0.0,0.5157189289999999,0.962326802,0.0,0.0,0.8453383959999999,0.880503177,0.0,0.0,0.429928408,0.0,0.0,0.32899400300000003,0.0,0.0,0.854648106,1.36011335,0.225185837,0.0,1.13127067,0.239331185,0.927723297,0.36821772399999997,0.6421491810000001,0.222324374,0.0272656096,0.0994326052,0.0,0.0,0.069437397,1.51588824,0.33591320700000005,1.10083664,1.68014199,0.0,0.43534190899999997,0.154710602,1.38658255,0.177499278,1.61686944,1.82379472,2.34753636,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.268625753,1.06233605,1.18724319,2.51110669,2.9962281,1.70780793,3.41706226,3.77255059,3.98372016,2.40152058,2.72170675,2.5251402,1.91872034,0.911716933,0.315264579,0.0,0.0,0.589490277,0.6900244940000001,0.0,0.0,0.11021237199999999,0.0,0.0,0.0,0.0,0.660109918,0.39370909,0.293807375,0.0,0.722805633,0.059905910300000004,0.0,0.142752806,0.32829211199999997,0.0,0.0,0.202620374,1.2371871,0.0,0.349676231,0.9164729620000001,0.139193039,0.535732426,0.699360709,0.0,0.6220687970000001,0.0,0.0,0.0,0.0,0.0,0.0,0.00827845912,0.0,0.0,0.6837502540000001,0.0,0.33993413899999997,0.0,0.82475718,0.0,0.146786573,0.921222068,0.714441256,0.275376242,0.0,0.0,0.0,0.0,0.054515929299999995,1.13878875,0.8003601770000001,1.38221655,0.0,0.055774887999999995,1.02221186,1.06362039,0.0,0.0,0.0,0.0,0.9338938920000001,0.16511979300000001,0.77910519,0.0,0.0,1.48281632,0.495716665,0.986153264,0.79356199,0.0,0.6828263000000001,0.147913789,0.0,0.0,0.0,0.0,0.655198937,0.27953272,0.0,1.32322878,0.0,0.885864401,0.16856102899999997,0.0,0.683310335,0.0,1.15716878,1.16032843,0.0,0.33741647,0.0,0.0,0.0,0.23794559699999998,0.0,0.0,0.0,0.0,0.37625033799999996,0.0,0.36932725,0.0,0.0,0.532232194,0.193993821,0.0170375933,0.0,0.0013372460999999999,0.45610762,0.0,0.471640701,0.7145584770000001,0.0,0.0,0.20463488800000001,0.0,0.0,0.0,0.256561985,0.0,0.0,0.0725490253,0.0,0.0,1.20921902,0.71196791,0.0,0.250119543,0.127281064,0.392345924,0.0,0.0,1.10562029,0.163370879,0.44005257799999997,0.7583897140000001,1.05374159,0.0,1.03940258,0.0,0.0332743877,0.44068402,1.12096047,1.10696049,0.0,1.13276991,0.675203633,1.62472101,1.43108422,1.00525107,0.74808652,0.769607204,1.55673911,0.27395922699999997,2.28565777,1.17490118,1.08157028,1.29224104,3.46569446,1.68091478,1.3919643,0.8798541,2.54403476,2.29878094,0.6959118409999999,2.91625297,0.8919229190000001,0.439898326,1.70865408,1.49537592,0.304825784,0.484406249,0.0,0.0,0.0,0.0,0.0843649947,0.407706988,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.70046357,0.0,6.61056205,0.0,15.98284436,6.30264425,6.01103472,1.16349932,4.83629356,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0573266871,0.259646704,0.451138275,0.794024246,0.769899682,0.0,0.0,1.31517007,0.9532542709999999,0.285043592,0.325899812,0.8864901740000001,0.648624796,0.0,0.36567099799999997,0.0,0.12248029199999999,0.0,0.0,0.0,0.0,0.178996982,0.0,0.0,0.0,0.34141797399999996,0.0,0.603274886,0.0,0.0,0.5184766679999999,0.0,0.693323758,0.72760319,0.387590689,0.35941291200000003,0.707339123,0.9256320020000001,0.0,0.0,0.0,0.0,0.15278576,0.0,0.0,0.0,0.0,0.36411326899999996,0.0,0.0,0.89716681,0.450200682,0.0,0.62674971,0.0,0.47718441,0.099095201,0.0,0.0,0.0,0.0,0.0,0.256830231,0.0,1.41764813,1.54527329,0.08470585929999999,0.458138693,0.0,0.911644708,0.622491717,0.390563234,1.21718865,1.08098513,0.0,0.7166067420000001,0.0,0.765296557,0.605627631,0.0229836592,0.0,0.0,0.0,0.302537268,0.0,0.0,0.0,0.0,0.00673702022,0.0,0.0,0.00837833441,0.8990721690000001,0.164405252,0.255733572,0.604662218,0.144137385,0.0,0.585659515,0.36698240200000004,0.995916943,0.495364995,0.705851819,1.33332966,1.29144821,1.80710309,1.67328864,0.546961093,1.83433657,0.0,0.555748034,0.341249079,1.03097469,0.157109795,0.467207462,0.588025492,0.0,0.0,0.436723201,0.0,0.570176791,0.0,0.0,0.883924638,2.29074864,0.786960639,0.665740499,1.6090456,1.64387509,1.76687769,1.95998505,1.83942265,1.46742256,3.57445055,2.49730607,2.33367527,2.09211127,2.46644604,2.81264811,1.78594797,1.28191441,2.74489139,1.05665957,1.86308582,0.641395636,0.80326968,0.65516549,0.0,0.0,0.0,0.0074586014599999995,0.0,0.32347992600000003,0.0,0.38389971700000003,0.506735355,0.0613807708,0.36868077,0.7897071309999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0676805037,0.0,0.0,0.041256200699999995,0.244480153,0.49899763399999997,0.753632643,0.9683821309999999,1.12276056,1.21388778,1.2474048999999998,1.22747685,1.15192652,1.01520201,0.8171998079999999,0.572389834,0.313080024,0.083398003,0.0,0.0,0.0,0.0,0.0670119854,0.121292491,0.114709442,0.0555356507,0.0,0.0,0.0,0.00285627022,0.106480362,0.19827192899999999,0.23341262699999998,0.19021709,0.08142642309999999,0.0,0.0,0.0,0.0,0.0,0.106983903,0.170981966,0.15370862300000002,0.0627580524,0.0,0.0,0.0,0.0,0.0042002807000000005,0.124293487,0.18720867600000002,0.161129905,0.056456787300000005,0.0,0.0,0.0,0.0,0.018388575,0.145840435,0.20927556100000003,0.19234152100000002,0.136197672,0.127705571,0.26078984899999996,0.585984986,1.07098345,1.5931083000000001,1.97290644,2.04075637,1.71261273,1.04381689,0.235202551,0.0,0.0,0.0,0.905136478,2.42925681,4.03231856,5.30241101,5.90474963,5.6867519,4.72376286,3.28996427,1.76577638,0.515371604,0.0,0.0,0.0,0.354307949,0.7878680859999999,0.999264247,0.9341993740000001,0.660117023,0.31895863,0.05826207940000001,0.0,0.060947103499999995,0.260969191,0.463751621,0.576649015,0.559075703,0.43377808,0.269082333,0.142834761,0.10572657699999999,0.160389219,0.26427123199999997,0.35305685600000003,0.372419257,0.303028143,0.167822875,0.0193399496,0.0,0.0,0.0,0.024099429900000004,0.10352822,0.132368256,0.09735779300000001,0.0174228908,0.0,0.0,0.0,0.0,0.0266226763,0.082245144,0.0915856016,0.0560056283,0.00428629217,0.0,0.0163610114,0.12531109,0.281821952,0.435511376,0.5298294929999999,0.525912707,0.419987835,0.24680866,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.83941294,0.05270355,0.95431017,0.72906,0.30799040000000005,0.0,0.13871777,1.33558493,0.0,0.31472115,0.0,0.0,0.0,0.58784294,0.33483325,0.0,0.0,0.93909975,0.61681028,0.12671435,0.21519366,0.65030496,0.0,0.0,0.0,0.0,0.86794198,0.0,0.0,2.79888177,5.08927903,3.84855185,3.50136841,1.84748374,0.0,0.0,0.5898448000000001,2.45382742,2.35595942,0.0,0.0,0.8873951999999999,0.1191615,0.25193977,0.0,1.08756486,0.0,0.0,0.62449492,0.0,1.44602759,0.0,0.0,0.0,0.0,0.0,0.68243174,0.0,0.0,0.56229165,0.0,0.0,0.09690614,0.1013237,0.0,0.0,0.0,1.27076426,2.11323555,0.64359959,0.0,0.45186957,0.0,0.85196366,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.30880165,0.0,0.308291493,0.46813519600000003,0.0304727256,0.0,0.0,0.346965381,0.21088892199999998,0.0,0.394218933,1.96934107,0.7559396290000001,1.14207477,3.11005205,2.74314256,2.23168591,3.5038574000000002,4.37200963,3.00771204,3.16077572,2.19102906,2.88202305,1.69509047,1.11660432,2.3204776000000003,0.208665438,0.0007056010700000001,1.30491763,0.986229193,1.37789858,0.0,0.758896965,0.0,0.994630621,0.0,0.640935842,0.0,0.0,0.923464243,0.0,0.0619651526,0.0,0.0,0.0,0.0,0.71977546,0.0,0.0,0.483163464,0.0,0.397102687,0.66082616,0.285556925,0.0,0.45912753799999995,0.0,0.6414758420000001,0.0,0.0527827538,0.0,0.666545446,1.49713052,0.0,0.0,0.0,0.45893107299999997,1.02650219,0.0,0.386460309,0.0,1.38377033,0.0,0.645128619,0.157753107,0.549494436,0.5455699070000001,1.05461626,0.0,0.476872141,0.0,0.0,0.0,0.253320818,0.846797548,0.0,0.0,0.167068472,1.48305985,0.0,0.177434465,0.0,0.601791689,0.763819105,0.0,0.567814753,0.318840941,0.0628638231,0.502306858,0.0,0.0,0.507531175,0.641013364,0.800978964,0.180018105,0.0,0.388167215,0.0,0.0,0.027102633900000003,0.256835752,0.08261053759999999,0.0,0.0,0.0,0.45518516299999995,0.39401176600000004,0.0,0.364578075,0.45530802200000003,1.1664976999999999,0.127588265,0.69507844,0.5325879,0.0,0.0,0.492008977,0.0,0.39098470799999996,0.0,0.0648466436,0.0,0.30590616,0.329835578,0.539801601,1.35410136,0.0725308436,0.0,0.220188584,0.0,0.0,0.312769839,0.609162186,0.0,0.0,0.44970029,0.0,1.02208089,0.0,0.036626505499999996,1.49398757,0.0,0.0,0.0,0.504355766,0.0,0.0,0.262203538,0.09393427619999999,0.0,0.0,0.840756435,0.224317035,0.0,0.0,1.04338996,0.0,0.272923604,0.32506569399999996,2.02876253,0.45243202299999996,0.183736497,0.448502258,0.514995005,0.105547374,0.250247105,0.403639876,0.766157082,0.0,0.0597447865,0.132496649,0.0,0.30768039399999997,0.0,0.7842947790000001,0.0,0.313136988,0.0,0.0420987457,0.116849405,0.198286617,0.641710738,0.275662853,0.928860853,0.0,0.0,0.0,1.36452123,0.583159538,0.7937757879999999,0.23860884,0.0,0.0,0.549900651,0.752898815,0.82311147,0.190468987,0.27209769899999997,0.7276263740000001,0.7698598990000001,0.483639883,1.15579214,0.458148661,0.287293255,0.33063332,0.358592385,0.422894651,0.791268234,0.0,0.247893223,0.117674855,0.0,0.838945067,1.27798498,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.35554223,0.17451791100000003,0.014892768300000001,0.127863806,0.0,0.0497229178,0.146052204,0.0,0.0907646702,0.158377496,0.0,0.162632924,0.186861269,0.0,0.444659249,0.314218993,0.0,3.33711789,10.423631599999998,8.78575506,2.14451901,1.87394881,5.15390536,4.92606749,2.88732338,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.493265656,0.381431321,0.287337301,0.236419682,0.243735375,0.311235592,0.428194655,0.574662267,0.727106148,0.864898245,0.9760885440000001,1.06105481,1.13308444,1.21563353,1.3367666999999999,1.52194011,1.78670393,2.13097357,2.53623376,2.96645195,3.37271326,3.70080932,3.90038284,3.93388334,3.78359776,3.4553818999999995,2.97835731,2.4006198,1.78177004,1.18366819,0.661117861,0.254146587,0.0,0.0,0.0,0.0,0.00878292827,0.131569687,0.23433938199999998,0.298680142,0.31883557,0.300397536,0.25691975100000003,0.205386787,0.161616118,0.136576458,0.134312269,0.151749789,0.18022265,0.20819141,0.224414339,0.220792547,0.19425400399999998,0.147313085,0.0872741509,0.0243603327,0.0,0.0,0.0,0.0,0.0,0.0,0.0108804517,0.039846479,0.0564661204,0.0581633221,0.0460042166,0.024164939700000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0340182469,0.07287332219999999,0.11186716,0.147079268,0.17572563300000002,0.19631801699999998,0.20851583899999998,0.212781102,0.20997834199999998,0.20104935399999999,0.18684480899999997,0.16812927100000002,0.145713356,0.120625395,0.09422593060000001,0.0681925567,0.0443509428,0.0243844009,0.00950110462,0.000160284216,0.0,0.0,0.0,0.0,0.0011449116199999999,0.00053744182,0.0,0.0,0.0,0.0,0.0,0.0,0.00288742904,0.009509945340000001,0.0146208213,0.016498108,0.0141415901,0.0076451512,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0121489771,0.023578759100000003,0.0298334888,0.0288782792,0.020416619599999998,0.00609388544,0.0,0.0,0.0,0.0,0.0,0.0,0.007687868309999999,0.0278817544,0.0434798789,0.051583750899999996,0.0518446132,0.0468998983,0.0420187178,0.0439650773,0.0592934756,0.0924604474,0.144221309,0.210755327,0.283822235,0.35202437200000003,0.402981748,0.42598520700000003,0.414537315,0.36816662299999997,0.29302443699999997,0.201025163,0.107620072,0.028626048199999997,0.0,0.0,0.0,0.0132939061,0.062698121,0.10519045,0.12546903199999998,0.11376889400000001,0.06868091700000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09255139960000001,0.20750233899999998,0.285360205,0.299605418,0.235419107,0.0950884236,0.0,0.0,0.0,0.0,0.0,0.0,0.09974361289999999,0.63696645,1.26769724,1.91927268,2.50951836,2.95999068,3.20911847,3.22279557,3.00040096,2.57505699,2.00802012,1.37821683,0.7688660820000001,0.253680518,0.0,0.0,0.0,0.0,0.0,0.122360539,0.284804707,0.374728128,0.374504571,0.289332026,0.143949576,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.118015867,0.21951200699999998,0.264416669,0.244095318,0.16558088599999998,0.049425190599999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0404907988,0.147334409,0.21729405300000001,0.23373552399999997,0.19297446199999999,0.105073471,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0963847335,0.19559490899999998,0.24920768100000001,0.242769977,0.17571681,0.06186201,0.0,0.0,0.0,0.0,0.0,0.0,0.05019660769999999,0.245505427,0.428236276,0.568054825,0.64416821,0.649583724,0.592308865,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.82554032,6.96016027,3.95597117,0.0,0.0,0.0,0.0,0.0,1.67940036,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.21406895,4.04202794,2.45354516,0.0,0.0,2.5703899,0.8138750109999999,0.0,1.07125236,0.0,4.32146314,0.0,1.01454991,0.783713326,5.67721028,0.0242479146,1.1691701,0.235013468,7.91474034,12.329192599999999,8.0834224,1.46424833,2.26503285,0.0,0.43792871,1.84402451,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.74662653,3.01477064,3.07833683,2.79668803,2.67144407,2.31542211,2.02471394,1.88547643,1.52694922,0.9807431329999999,0.9385614940000001,0.371869922,0.436897374,0.184938048,0.111144384,0.0030503585999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0251196775,0.0626689597,0.051024504000000005,0.442441646,0.337937043,0.21300074100000002,0.059666255700000004,0.46333310200000005,0.083153326,0.09030460859999999,0.24056266699999998,0.39023943299999997,0.38291086700000004,0.09152118210000001,0.092264877,0.0711621241,0.0,0.166224609,0.0,0.159561091,0.0608815614,0.0,0.20369307899999997,0.0,0.0,0.040732806499999996,0.180017244,0.0,0.10293031300000001,0.309156988,0.0239287326,0.195990135,0.271591052,0.0,0.259237741,0.0029751488800000003,0.0,0.0,0.0,0.0,0.0,0.22167819800000002,0.0,0.0,0.0,0.154549343,0.0,0.20036001399999998,0.0,0.0,0.0,0.0,0.0328261979,0.0,0.25848515899999996,0.117577427,0.12867241,0.0,0.242085595,0.0,0.0,0.308602428,0.113237235,0.127909554,0.299120615,0.21333355699999998,0.27582351,0.0,0.0,0.0207200294,0.0163694189,0.0,0.0,0.0,0.0,0.0,0.157096277,0.0,0.0,0.107675727,0.0,0.43363337,0.22545032,0.348638923,0.510177949,0.09473747699999999,0.24082564899999997,0.0,0.300946958,0.024766622000000002,0.0222071246,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.472746629,0.770536865,0.8237132420000001,1.22743233,1.8106629,1.7793128,2.3898482000000003,2.68844819,2.69495117,2.61266313,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.27462477,1.2382218,0.162719279,0.00998093856,0.26453145,0.203681075,0.00430960225,0.109754831,0.361854059,0.37931322799999995,0.24977186699999998,0.27614628,0.402106791,0.378931388,0.229808123,0.131874335,0.0741269338,0.0,0.0181465385,0.183736055,0.236127897,0.0380140744,0.0,0.147007743,0.382448002,0.172709836,0.0,0.0,0.177299414,0.217912671,0.0,0.0,0.105795998,0.286360817,0.0,0.0,0.00976710155,0.356833423,0.054524032199999996,0.0,0.0,0.447324536,0.258230062,0.0,0.0,0.8435758090000001,1.9984369999999998,1.64303321,0.461022882,0.0,0.312658047,0.520960625,0.227280703,0.0,0.049168335300000005,0.00483932281,0.0,0.057620285599999994,0.447059088,0.276654554,0.0,0.0,0.589206583,0.866375362,0.0,0.0,0.994173115,4.03169095,4.94775587,2.60351499,0.0,0.0,0.0478453724,0.672386085,0.064882896,0.0,0.0,0.349491129,0.149755951,0.0,0.0,0.191057174,0.169393359,0.0,0.0,0.0917684321,0.163192698,0.0,0.0,0.0232671242,0.129731865,0.00127806339,0.0777413417,0.801839055,1.89307512,2.59874033,2.61101479,2.46539697,2.94455122,4.18022181,5.42513076,5.73013557,4.81999942,3.26181502,1.82997533,0.87484561,0.337041981,0.0995701351,0.0734388483,0.0881786576,0.00683372371,0.0,0.0,0.085299872,0.0389934366,0.0,0.0414939723,0.379508544,0.644811227,0.785043865,1.07610911,1.51374153,1.64004396,1.27328415,0.889572135,0.842170015,0.7243564920000001,0.136703007,0.0,0.0,0.6958543709999999,0.871687841,0.375815956,0.24135250600000002,0.775986695,0.9257585290000001,0.148841075,0.0,0.719792715,2.31872531,2.49706052,1.09417801,0.0,0.0,0.00902899994,0.0,0.0,0.363364285,0.129525219,0.0,0.0,2.26906006,5.38915935,5.25584849,1.81357364,0.0,0.0,0.55189911,0.770499307,0.0,0.0,0.30478957100000004,0.686420548,0.0,0.0,0.0,0.469612535,0.135446122,0.0,0.0,0.334022074,0.22903881,0.0,0.0,0.20987304699999998,0.277033523,0.0,0.0,0.0944738243,0.287229798,0.0,0.0,0.0,0.264723109,0.0520671816,0.0,0.0,0.214529685,0.120931224,0.0,0.0,0.1422997,0.151086323,0.0,0.0,0.053690789800000006,0.0839421406,0.0,0.242038001,0.7128689579999999,0.8316784690000001,0.712802652,1.21036921,2.37029769,2.91638375,2.03353851,0.721449008,0.356020054,0.666358766,0.423763454,0.0,0.0,0.299028799,0.625293434,0.0,0.0,0.250419112,1.85011785,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.202301265,0.0,0.34601964700000004,0.410733719,0.697501028,0.0,0.6841176290000001,0.0,1.30626528,2.17844991,1.50334669,0.0,0.511708782,0.0,0.0,0.0,0.0,0.113164112,0.143007501,0.463734917,0.0,0.711001585,0.136835338,0.10584343800000001,0.40382086,0.0,0.503525074,0.0,0.45140423,0.261385415,0.220399178,0.0,0.0,0.0276090573,2.50796949,2.08753841,3.09627189,1.88699973,0.529885905,0.302194659,0.0,0.898867834,0.0,0.49231583100000004,0.0,0.0,0.471225276,0.77982077,0.0,0.0,0.0,0.88487637,0.0,8.6541596,6.99922285,0.0,1.07055427,0.5524163879999999,0.604652389,0.0,0.398804605,0.594083254,0.0,0.0,2.41039122,2.66516047,0.14315719400000002,1.12681597,1.90017078,1.82896743,1.53074327,0.0,0.73966655,0.0,0.6664395879999999,0.0,0.0,1.17750441,2.71401729,0.0,0.278481732,0.0,0.0,0.0,0.0,0.028954710800000002,0.0,0.0,0.150420441,0.0,0.0,0.0,2.90427467,3.13404182,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.777379038,0.46065699299999996,0.0,0.0,0.549910395,0.316966337,0.5310939960000001,0.0,0.449429585,0.0,0.378405473,0.57640945,0.0,2.66523101,2.52213584,0.271129205,0.0,0.0,0.592573486,5.07096724,0.5012207000000001,0.391414398,1.33438302,0.0188502097,0.0470825447,0.0,0.11432027300000001,0.5301511520000001,0.195065975,0.226040475,0.376787969,0.0,1.43118223,1.44824148,2.20272204,0.197559916,0.776670904,1.68539251,0.0,0.11820577800000001,0.459256065,0.38605213299999996,0.7587645359999999,0.0260680574,0.044835107199999995,0.0,0.498239155,0.31222639,0.0,0.302042886,0.53198951,0.0,0.0428798554,0.493446924,0.7553813970000001,0.0,4.9532850999999996,6.59962746,0.0,0.359231112,0.0,0.0,0.0,0.339707721,0.0,0.577976519,0.331457952,1.77626935,0.439475082,0.0,0.148968457,0.0,0.9294830890000001,0.473804341,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.75303014,2.07918775,3.26578862,0.0,28.10716917,1.8588493000000001,2.04410185,2.08327463,1.85625939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.24100000000000002
0.387702599,1.77550732,0.0,0.552056557,0.0415971833,1.4298875,0.0,1.66475068,1.94370938,5.56053379,6.07084574,3.6109339,0.0,0.0,0.0,0.193927,0.0230915647,1.08490445,1.28003664,0.0,0.843542186,0.595978427,0.658788037,0.0,0.857586599,1.53123981,0.0,0.0,1.21665831,3.59857461,12.2407221,17.6206332,13.8955157,3.11215684,0.0,0.0,0.0,3.31782295,0.41014574200000004,0.766073335,0.669631772,1.18797452,0.0,0.0,0.14190003699999998,0.0,0.0,0.0,0.0,0.25748052899999996,0.0,0.39312088700000003,0.0371109249,0.0,0.24932559699999998,0.665772279,1.28783362,0.0,1.1722034,0.0,1.32668538,0.0,0.0517304908,1.2312181999999998,0.426450182,0.0,0.0,0.779558668,0.0,0.0,0.189297283,0.0,0.5651043370000001,1.11187721,0.616680256,0.0,0.479265869,3.14704968,1.12435313,2.61022345,0.149857482,1.36146119,1.54491651,0.7560622909999999,0.0,0.0,0.829834622,0.444849723,1.43825652,0.418405087,0.0,0.0,0.0,0.0,0.27353263,0.127446785,0.598061973,0.0,0.0,0.0,0.0,0.0,1.23810203,0.0,0.833049976,0.0,0.0,0.413006659,0.53640481,0.5411417279999999,0.0,0.0,1.64850051,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.264
0.39416899299999997,0.295705699,0.128790278,0.31489622100000003,0.267204701,0.335010617,0.196253525,0.513718334,0.42193630000000004,0.57683392,0.412794781,0.413636254,0.113310583,0.41068271,0.508082213,0.608556969,0.14368483,0.26025581600000003,0.210165952,0.316985308,0.269230309,0.581099673,0.585151236,0.742840121,0.723370223,0.347404266,0.538427322,0.5259440710000001,0.40032804899999996,0.48055654,0.7976160109999999,0.47827442299999995,0.764434869,0.534730284,0.6469566139999999,0.60442801,0.873451913,0.524194255,0.714902822,0.506559741,0.46801384,0.5916106489999999,0.596652665,0.636284506,0.626051549,0.190654392,0.22602784399999998,0.325976581,0.0246189079,0.0,0.00426614781,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.007661017459999999,0.0,0.0,0.0,0.0877456013,0.399184097,0.661924311,0.5749307920000001,0.552286549,0.7587004829999999,0.902149575,0.70097421,0.70332443,0.8126125609999999,1.11705582,0.662947517,0.91933962,1.0707775,0.639694484,0.910526095,0.402747864,0.656174241,0.48859455,0.179352916,0.043179477300000005,0.37769135299999995,0.0,0.229689328,0.204754765,0.32312723600000004,0.308089528,0.0761847258,0.583241779,0.754772855,0.998968428,1.0438203000000001,1.60688931,1.60612568,2.08407683,1.8699276999999999,2.23128524,2.76595985,2.45442325,2.70774431,2.75134536,3.31260699,3.28566945,2.78528088,2.81016701,2.7379944,2.86434658,2.78775691,2.35915782,2.7477476000000003,2.60762635,2.27104192,1.84712363,1.91517138,1.55039922,1.69999915,1.25793152,1.65085955,1.50440144,1.3125189,0.9806785440000001,1.18738566,1.07507904,1.17656284,1.11951275,1.31906085,1.13052519,1.54944275,1.20404483,1.12956776,1.0170353,1.15437447,0.92808105,1.04169207,1.19978657,0.763444035,0.990219133,0.820865898,0.687521583,0.394145154,0.582139458,0.221015148,0.127896223,0.277249829,0.0891953714,0.0714380111,0.0,0.0,0.0,0.0,0.110339256,0.0,0.0,0.06637150900000001,0.14542316800000002,0.30607289,0.257960915,0.0140209257,0.0,0.032939903799999996,0.215003036,0.0661785159,0.10275492800000001,0.0,0.356638712,0.0242450014,0.213250067,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0858673487,0.0,0.0,0.17782815899999999,0.0,0.262190977,0.0,0.0,0.291413648,0.0,0.36275644,0.17804568,0.0,0.0,0.286620317,0.240037776,0.301934545,0.14303267,0.0,0.0,0.0234271028,0.0226582414,0.0,0.119046315,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23087759100000002,0.0,0.0942847045,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.615139532,0.18620536399999998,0.0,0.0,0.0,0.113306721,0.0,0.578176063,0.490182976,0.256919917,0.0,0.0,0.0,1.23302198,0.24889779,1.64826828,1.68972723,1.39495131,0.0,0.0,0.0,0.0688285012,1.40157458,0.826837811,0.421308643,1.80420465,1.5464738,0.441090459,0.914220266,0.374854629,0.0,0.722542125,2.82619546,2.80578581,2.28113001,3.8559687000000005,2.28643432,1.53800047,1.78936688,1.94436094,2.2669694,2.60536623,1.59451342,0.254807619,0.516562031,0.6155277720000001,2.14096939,0.0,1.75937446,3.41715409,1.82341584,1.47873383,0.0,0.35608686799999995,0.283401942,1.16093485,0.0,0.522929918,0.33962907,1.28334459,0.251223336,0.142853081,0.0,0.889141498,0.18819135,0.45933357700000005,0.125265769,0.241735394,0.915975315,0.9367465159999999,1.75050704,1.52254866,1.32406842,0.0,1.44334401,1.85375211,1.12289315,0.0,0.6513541070000001,0.0,1.20075983,0.866909403,0.997180033,2.31529704,1.26630625,2.36299533,1.00055445,0.0,0.666557475,0.47515683299999995,0.0723593592,0.0,0.0,0.755828319,0.697487637,0.17609101800000002,0.0,0.0,0.7063399370000001,0.481052505,0.0,0.0,0.188854482,0.227858867,0.0,1.07866365,0.0,0.30976021600000003,0.295434631,0.0,0.12155446199999999,0.8044961629999999,0.0303157998,0.0,0.0,0.0,0.0,0.0,0.159843076,0.0,0.550067437,0.7436085370000001,0.0,0.0,0.0,0.204084729,0.0,0.0,0.0799517253,0.0,0.33632804299999997,0.0,0.0,0.125174501,0.7467829890000001,0.354502944,0.0,0.0,0.06641156320000001,0.0,0.0,0.872626232,0.0,0.0,0.0474867521,0.134332601,0.258391963,0.0,0.66947279,1.26903905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.90667392,0.305864949,1.44972844,0.0,0.874792493,0.772530365,0.6723826,0.215828327,0.0,0.0,0.0,0.234714808,0.5268502039999999,0.734204445,0.0,0.0,0.0,0.359245485,0.0,0.865285086,0.0,0.243730682,0.701744046,0.0,0.0,0.0,0.0,0.655751451,0.01862354,0.42521862899999996,0.152661126,0.693517155,0.7394893440000001,0.0,0.661813708,0.0,0.0,0.0,0.0,0.13861367,0.0,0.0,0.7226368940000001,1.20361632,0.039198977,0.419138265,0.0,0.469029789,0.0,0.0,0.0570646411,0.0,0.0,0.169111696,0.017017682,1.6147256,1.28850876,0.773656945,3.1736062,2.9692272999999996,4.38033407,3.75676336,4.40867117,2.88014153,1.7499703000000002,1.725702,0.0,0.0,0.7058690609999999,0.7545680779999999,8.862028589999999e-05,0.0,0.653851545,1.11949185,0.531569592,0.0,0.39726859,0.0,1.09777713,0.0477775942,0.24589784,1.40637881,0.547372973,0.6854675929999999,0.0,0.703284138,0.8451045159999999,0.899580927,1.83394551,0.0,0.20968061899999998,1.05454824,0.605549212,0.7646298,0.0,0.0,0.7305854209999999,0.428442617,0.0,0.0,0.0,0.0933609038,0.907252645,1.02310858,0.334899114,0.0,0.0,0.50839294,0.0,1.13543611,0.0,0.484574429,0.0,0.522659794,0.22183255,0.508973185,0.0,0.0,0.7889160470000001,0.0,0.0,0.0,0.841299845,0.6745727659999999,0.0,0.0,0.0,0.0,0.0,0.0,0.181557523,0.212293402,0.0,0.0,0.0,0.0,1.6005842,0.0,0.47499445799999995,0.784335386,0.0,0.55887855,0.0,0.0,0.0,0.0,0.0,0.736459871,0.0,0.952764443,0.0,1.58238889,0.0,0.352694964,0.0,0.286244644,0.0,0.0,0.0,1.04569186,0.363506137,1.66769386,0.40219879299999994,0.29331266899999997,0.8053211029999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.404923,0.88896885,1.44628549,0.06244236,0.0,0.0,0.78385426,0.98226299,1.11455166,0.89497892,1.45362303,0.41979402,0.0,0.0,0.12951184,0.32774025,0.0,0.7745107,0.96236962,0.0,0.58324988,0.82418392,0.22701412,0.0,2.2118302000000005,3.05525023,3.65815598,3.11612595,2.49612952,1.14304869,0.94662175,2.90076583,1.7233053,0.77986563,0.28207669,0.72513128,0.0,1.23908844,0.62303249,0.70009996,0.0,0.26070875,0.51130919,1.43459931,2.62121507,1.62538602,2.00319515,0.0,1.43612856,0.93416137,0.0,0.36288879,0.27134699,0.0,0.0,0.0,0.0,0.8556563,0.0,0.22630043,0.25537258,0.0,0.26373614,0.54705871,0.0,0.12842478,0.0,0.0,1.17538776,0.6984635,0.7291135999999999,0.66522508,0.0,0.89863986,0.10299075,0.77039631,0.27914258,0.0,0.0,0.19553027,0.0,0.0,0.0,0.96479629,0.09729215,0.41524253,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.196889743,0.939722112,1.65326977,1.57336119,1.38471132,2.18391438,1.34196009,1.40093689,1.28142504,0.46641422299999996,0.0,0.15372556099999998,0.008187469749999999,0.0,0.0318209256,0.0887103249,0.41006702799999994,0.256929735,0.598021865,0.0935192246,0.0,0.0,0.224202168,0.0,0.0,0.0,0.342874171,0.0,0.0118937906,0.0,0.0,0.216030256,0.049738410999999996,0.0,0.0383103033,0.354645297,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0469779598,0.334298575,0.372805835,0.176320038,0.0,0.171967554,0.212582102,0.0,0.0510364415,0.0,0.16986969,0.0,0.0,0.0,0.419829038,0.46886704,0.451438413,0.544420573,0.590533263,0.7698452720000001,1.71560086,1.23676819,1.6845361,2.3722705000000004,1.9313921000000003,2.64716013,2.32497296,2.62726714,2.40230513,2.59640549,2.19001131,2.21855461,2.42566232,1.71098325,1.06297705,1.30182275,0.738701395,0.23851033800000002,0.0,0.120852062,0.0,0.290764133,0.24366195,0.09920347730000001,0.625695536,0.706991473,0.590387494,0.707605901,0.0,0.0,0.0,0.233382277,0.182976928,0.315025524,0.447447455,0.362597045,0.499034131,0.22782402,0.0,0.134925441,0.01955846,0.0142470975,0.0,0.023636654,0.0,0.0,0.0,0.0,0.277102019,0.0,0.14861747,0.0,0.0,0.0,0.0641224996,0.00346166812,0.0759587541,0.0588101064,0.17719059,0.288090299,0.0,0.49273333,0.342962219,0.0,0.0,0.0,0.0,0.0,0.0,0.0347421564,0.6894479090000001,0.0872876259,0.74002524,0.494030956,0.16306965199999998,0.0,0.0,0.0,0.0,0.776789045,1.57042534,2.75708682,3.46193192,4.5627027,4.10392659,4.58222644,4.43906022,3.56011473,2.30185355,1.65857852,0.7689442209999999,0.026405886,0.0,0.0,0.0,0.0,0.26661869,0.251460585,0.0730098478,0.5036178720000001,0.8432663440000001,0.426111295,0.10591351199999999,0.0,0.010945206,0.0,0.09740224800000001,0.0,0.22559084100000001,0.24627961199999998,0.0,0.453636737,0.0,0.0,0.207447885,0.0,0.0270221298,0.0,0.0,0.0,0.161066693,0.0894696964,0.059422778499999995,0.26196295199999997,0.0,0.015446071100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.357737221,0.0,0.36023099299999994,0.0,0.0,0.0,0.154502454,0.0,0.0,0.0,0.21868842300000002,0.0,0.0128699069,0.0,0.0,0.152025641,0.0,0.306270094,0.200538815,0.0,0.0,0.0,0.5252808379999999,0.481153557,0.152068656,0.366786075,0.07094747259999999,0.288016389,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.24710387,0.8745042,0.87597737,0.0,0.70289217,0.0,0.0,0.0,1.1973236,0.51126088,0.62657634,1.04987996,0.1325346,0.0,2.20298196,9.15349927,9.45162281,3.80538197,0.0,1.35645252,0.80419463,0.0,0.0,0.0,0.34434433,0.0,0.04042491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5340152579999999,0.251745871,0.395585885,0.0,0.416061068,0.0,0.0,0.108983569,0.024796214,0.0265103659,0.0,0.0,0.0,0.026398537200000002,0.0,0.14916629,0.0,0.297035002,0.0,0.0,0.7822936109999999,0.7134681390000001,0.16752543,0.0,0.326178776,0.458427285,1.44511762,1.89032693,1.28002101,0.0,0.344179845,0.5778988629999999,0.0,0.748313462,3.67288066,4.17276822,2.5949851,1.53925582,0.0,0.0,0.36053818,0.0,0.0,0.0737728311,0.0,0.0613794759,0.251901017,1.13450897,0.580435401,0.794161731,0.445401403,0.890827591,0.0,0.0,0.0,0.595675934,0.546884296,0.583801954,0.458813032,0.9897974420000001,0.52532105,0.363156607,0.0,0.717567062,0.0958891735,0.0,0.0,0.0,0.406648402,0.423175067,0.0,0.430951562,0.311093875,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.821801573,1.08931301,0.362297143,0.93757686,0.8441164059999999,0.40457470100000004,0.7045313759999999,0.194093011,0.26814826399999997,1.37439845,1.06967674,1.40904442,1.40319038,1.33486717,1.36000474,0.8415520129999999,0.228378713,0.0,0.0,0.19607070000000001,0.144186841,0.757376162,2.22892782,3.38160151,3.76175888,4.6816176,5.49499046,5.08278089,4.11314275,3.886392,2.80136607,2.8463004,1.82074979,1.49016634,1.50627146,1.69085866,1.67615143,1.45774808,2.33948594,1.67660185,1.43984355,1.62331479,0.648456907,1.13567521,0.19072749100000003,0.168491177,0.18621193100000002,0.5331974279999999,0.701203446,0.472724749,1.06154244,0.5348431029999999,0.567630567,0.0,0.0,0.089247945,0.0,0.127955848,0.0,0.00800994939,0.436601501,0.546908113,0.6243041,0.237559283,0.0,0.0,0.0,0.122274706,0.0308483913,0.0,0.0,0.512897346,0.545212602,0.36907303399999997,0.163183112,0.19949350100000002,0.0,0.19986298,0.157308815,0.0387059473,0.0,0.0,0.211460464,0.0,0.489984849,0.0,0.20848582,0.0,0.0,0.283493968,0.0,0.0,0.0,0.32512014699999997,0.0,0.0,0.0,0.052051272999999995,0.0,0.0,0.0,0.355324556,0.328330607,0.0,0.0,0.0,0.36600684299999997,0.188287345,0.0,0.0,0.0037764680799999995,0.0,0.0,0.00442222924,0.0,0.358740079,0.0,0.18396296899999998,0.41689123100000003,0.233976264,0.0,0.0,0.0,0.26728675,0.0826433714,0.0,0.0,0.36124321,0.0,0.279768041,0.0108418209,0.438456519,0.0,0.0,0.0,0.0,0.19295543199999998,0.197329743,0.0,0.428545546,0.0,0.254752437,0.0,0.0,0.0,0.0724565159,0.59821312,0.346783254,0.0264706059,0.0,0.536304875,0.430357779,0.0,0.5128511379999999,0.0,0.6542099029999999,0.258388048,0.921175084,1.5241278999999999,1.16348361,1.09804192,0.30141099600000004,0.177257403,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.34262961700000005,0.424976374,0.475499998,0.491101071,0.471882998,0.420973771,0.344103495,0.248982615,0.144540962,0.040097297999999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0512007689,0.120888389,0.178920546,0.21973361,0.239475141,0.23631979399999997,0.21061443600000002,0.16484827900000001,0.10345812300000001,0.032491479,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.13199614,0.30976527800000003,0.520940049,0.760638046,1.02280439,1.30052392,1.58634612,1.87260384,2.15171093,2.41642801,2.66009006,2.87679337,3.06154206,3.2103568,3.3203489,3.38976305,3.41799121,3.40555906,3.35408515,3.26621228,3.14550984,2.99634692,2.82373637,2.63315264,2.43032774,2.22103282,2.01085473,1.80497894,1.60799121,1.42371017,1.25506206,1.10400626,0.971517018,0.8576228109999999,0.761500225,0.6816150009999999,0.615899101,0.561949688,0.517234282,0.479286029,0.445874263,0.41513803200000005,0.385673951,0.35657416399999997,0.32741489100000004,0.298200652,0.269273168,0.241196915,0.214634922,0.190228635,0.168494438,0.149746932,0.134055588,0.121237355,0.110883602,0.102415942,0.0951623584,0.0884430586,0.08165472139999999,0.07434241280000001,0.06625030030000001,0.0573451528,0.0478101448,0.0380102527,0.0284340975,0.019620023400000002,0.012076168600000001,0.00620503729,0.0022425377,0.000219666649,0.0,0.0010602720199999998,0.00301578793,0.00521226764,0.007048360870000001,0.00801453663,0.00777155432,0.006209988279999999,0.00348204165,9.5530151e-17,0.0,0.0,0.0,0.0,0.0,0.0040211723,0.014543259,0.028036205699999997,0.043741965099999995,0.0605581463,0.077126872,0.0919599732,0.10358863900000001,0.110722186,0.1123987,0.10811028,0.0978874624,0.0823311469,0.0625854693,0.0402512642,0.0172462179,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015353861399999998,0.035870284599999996,0.054177536299999995,0.0679628271,0.0753186393,0.0749664181,0.0664233419,0.0500918359,0.0272587402,1.38952947e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00966712439,0.048555484100000004,0.08472593070000001,0.114165344,0.133318027,0.139483932,0.131151623,0.10822849699999999,0.07213934450000001,0.0257761544,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0614193625,0.145458089,0.224925128,0.29213178300000003,0.34006411200000003,0.36310255799999996,0.357655839,0.322645956,0.259791968,0.173656292,0.0714373104,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0606200167,0.27192901399999997,0.5156116620000001,0.7788780359999999,1.04685353,1.30361837,1.53335635,1.7215218999999997,1.8559321,1.92769481,1.93189703,1.86799631,1.73988228,1.55560197,1.32677032,1.06771265,0.79440794,0.523317326,0.27019144100000003,0.048950836799999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.110058373,0.234670665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.890724132,0.455997186,0.0,0.471575859,0.376695379,2.71404801,0.0,1.54019109,0.01266454,2.22974124,0.644357697,0.264739819,0.0,0.266483475,0.0,0.0175629178,1.33222714,0.0,1.14502794,2.2330889,0.0,0.529514123,0.0,1.08794163,0.0,0.513146016,0.0,0.0,0.0,0.225831421,0.325250773,0.0,1.67540071,0.563323262,0.506412454,0.0,2.0264983,1.10863206,1.81677997,1.34189927,1.37070627,2.0485796,3.23911737,0.600662614,0.0,2.9817772000000002,0.0,0.0,5.15153612,5.28678681,2.73079178,0.0,0.0,2.58938519,2.36429206,1.00313477,0.572435959,0.0,0.0,0.0,0.0,0.8520173240000001,0.8875589290000001,1.5743988000000002,1.51580903,0.0260346463,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.238137906,0.149601871,0.0713141983,0.0034206298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0047516502000000006,0.0352982077,0.0645211166,0.09177112009999999,0.116477298,0.138153331,0.15640214,0.17091886,0.181492147,0.18800384,0.190427027,0.18882258899999999,0.18333433100000002,0.174182819,0.16165807,0.146111246,0.127945543,0.10760644400000001,0.0855715317,0.062340052400000005,0.0384224329,0.014329926100000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012654041100000001,0.0336490948,0.0541971704,0.07393514030000001,0.09252335,0.109651819,0.125045812,0.138470699,0.149736036,0.15869881,0.16526580800000001,0.169395102,0.171096618,0.170431818,0.167512516,0.162498842,0.155596435,0.14705289400000002,0.137153578,0.12621681699999998,0.114588625,0.10263700699999999,0.0907459477,0.0793091699,0.06872377730000001,0.059383856500000005,0.0516741411,0.0459638234,0.042600598600000004,0.0419050219,0.0441652487,0.0496322271,0.0585154003,0.0709789691,0.0871387607,0.107059736,0.130754166,0.158180494,0.189242895,0.22379154399999998,0.261623575,0.302484734,0.34607171,0.39203510399999997,0.439983023,0.489485265,0.54007804,0.591269194,0.642543879,0.693370626,0.743207739,0.791509974,0.83773542,0.881352505,0.921847085,0.958729498,0.991541543,1.01986328,1.04331956,1.0615863,1.07439619,1.08154409,1.08289172,1.07837172,1.06799105,1.05183353,1.0300616,1.00291706,0.97072101,0.933872658,0.8928472120000001,0.848192686,0.800525699,0.750526235,0.69893141,0.646528279,0.594145732,0.542645547,0.49291269600000004,0.445844976,0.40234210200000003,0.363294361,0.329570983,0.302008354,0.281398241,0.268476175,0.263910159,0.268289878,0.282116551,0.305793618,0.33961839200000005,0.38377483799999995,0.438327615,0.5032174939999999,0.578258278,0.6631352939999999,0.757405537,0.86049951,0.971724777,1.09027124,1.2152181,1.34554246,1.48012944,1.61778385,1.75724305,1.89719106,2.03627369,2.17311437,2.3063307,2.43455126,2.55643266,2.67067643,2.77604557,2.87138055,2.95561449,3.02778726,3.08705835,3.13271828,3.16419836,3.18107861,3.18309388,3.17013774,3.14226447,3.09968873,3.04278316,2.97207384,2.88823361,2.79207349,2.68453211,2.56666352,2.43962342,2.304654,2.16306769,2.01623006,1.86554201,1.71242166,1.5582861000000001,1.40453335,1.25252471,1.10356789,0.9589009629999999,0.8196776490000001,0.686953864,0.561675924,0.44467046299999996,0.336636237,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.026812177599999997,0.0,0.0,0.0,0.0,0.605332595,0.816404735,0.0,0.629345721,0.0,0.511842885,0.0,0.733693885,0.360034523,0.0,0.0,0.0,0.0,0.643341563,0.43538221299999996,0.10979927099999999,0.26472816,0.0,0.10959127,0.8462749509999999,0.947760692,0.527356681,0.0781870201,0.0,0.9786957940000001,0.535893622,0.0,0.0,0.0121395203,0.0,0.0,0.0,0.0,0.0,0.0,0.25014810000000004,0.133046243,0.398284095,0.17165244600000001,0.9634502159999999,0.0,0.0,1.19232601,1.36107327,0.0,0.0,0.5648434960000001,0.0,0.582526141,0.0,0.0,0.0,0.0909307804,0.0,0.030934795299999998,0.6014823539999999,0.163262445,0.479680482,0.0,0.0,0.0,0.258356822,0.0699084628,1.74306098,2.35910505,2.81340135,4.04415076,3.55590893,2.4262012000000004,1.49457156,1.40668419,0.0276518705,0.0,0.0,0.0,0.223422034,1.47099125,1.61198922,1.9610512999999998,0.770326738,0.59660992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.765641034,0.0,0.0,0.843486609,0.641366514,0.118471699,0.0,0.445242621,0.0,0.0,0.0,0.62508736,1.24563484,0.904476292,0.0,0.0,0.0751353988,0.0,0.301659263,0.14139542,1.24804593,0.16340302199999998,0.358076364,0.51119137,0.234689719,1.78024014,0.6037966610000001,0.75982103,0.9816095690000001,0.0,0.373378298,1.26125031,0.0,0.506982279,0.0,1.40413539,0.0963050139,0.0,0.0,0.294758081,0.67189413,0.13338809,0.0,0.0,0.0486366992,0.697492152,0.601702152,0.46122655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.22174122,0.0,0.37886085,1.00439502,0.259347817,1.14187314,1.1395576,1.90776232,3.33869996,3.32257279,4.72508691,5.47719391,5.20463894,5.77683012,6.51663222,6.36328196,5.98997096,5.36558207,4.78441227,3.49555233,3.27852704,1.62671429,1.62872139,1.23237526,0.7025359259999999,0.0,0.316745226,0.0,0.10115605400000001,0.0,0.0,0.0,0.795796108,0.134006934,0.0,0.0363951975,0.58173134,0.5739763170000001,0.0,0.0,0.0,0.0,0.022868281299999998,0.48501002200000004,0.591863873,0.0,0.52780137,0.0,0.684694185,0.610587349,0.0,0.20073677199999998,0.19901156,0.0,0.284804784,0.0119069056,0.396137474,0.0,0.524379964,0.441510245,0.498516377,0.0,0.0,0.009730876020000001,0.34494062200000003,0.056313094400000006,0.357006039,0.375652473,0.316794882,0.45487262100000003,0.34002089700000004,0.159823503,0.397776189,0.388142383,0.132803643,0.0,0.438372528,0.29680534399999997,0.520078186,0.0,0.0,0.0,0.0,0.0,0.0,0.196849365,0.0,0.438813846,0.41917146,0.0,0.0,0.0,0.300354664,0.0937577125,0.19459405600000002,0.0,0.383329694,0.499335951,0.5955180929999999,0.590793175,0.0,0.0,0.41020650700000005,0.483516895,0.567958183,0.553823957,0.273545637,0.0,0.0146383539,0.34576010100000004,0.419061935,0.0,0.18310396899999998,0.0,0.0,0.0,0.190979654,0.287371047,0.0,0.0,0.177650429,0.0,0.0,0.50564682,0.48750030200000005,0.085305989,0.32375706600000004,0.29613671199999997,0.0,0.0467404654,0.0,0.0,0.482123784,0.203833763,0.0,0.047892208,0.152864581,0.59353369,0.0,0.626731348,0.022987672200000003,0.550484738,0.0784319941,0.0,0.19893613899999998,0.0,0.0,0.0,0.0,0.39019883,0.0,0.0,0.0176568488,0.22225719600000002,0.0,0.0,0.384650182,0.0,0.0,0.0,0.0,0.270343712,0.058474933099999994,0.0,0.183536938,0.0,0.0211575498,0.117678706,0.398337901,0.102363176,0.0,0.680439164,0.315495415,0.273902729,0.33816928,0.0,0.0,0.310779125,0.32056041399999996,0.390017458,0.0,0.19361962100000002,0.0604933209,0.0,0.0,0.0,0.0,0.09063261210000001,0.32127970699999997,0.621536985,0.07189164690000001,0.540127664,0.293662352,0.32508473,0.0,0.091288915,0.0,0.168446125,0.0415553328,0.00840125599,0.340207233,0.0,0.0,0.112484319,0.0,0.104735574,0.0,0.5206850439999999,0.0,0.0,0.0,0.506511752,0.0,0.0134481928,0.354683883,0.0,0.0,0.186111775,0.500059166,0.318834121,0.62758441,0.430930814,0.0,0.0,0.137776691,0.0,0.161897525,0.0,0.260297231,0.0,0.0,0.4071062,0.0,0.22147324,0.695146987,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.507851439,0.029199886,0.43726199299999996,0.635848952,0.0,0.437760376,0.198036774,0.0,0.351273648,0.0,0.0846903592,0.0,0.0,0.0,0.0,0.0,0.935006943,0.830827348,0.328631522,0.0,0.645627453,0.0,0.83739776,0.0,0.0,0.88303805,0.10125645400000001,0.0,0.0,0.0,0.0,0.0,1.45723086,0.393897226,1.3801732,0.0,0.986697583,0.0,1.04862228,0.0,0.0,0.0,0.0785290347,0.0,0.279746315,2.67412963,0.05817974730000001,0.665602481,0.9298222420000001,0.0,0.0,1.38832705,0.0,0.0,0.0,0.9431369390000001,0.346459729,0.7327407570000001,0.38428507100000003,0.058472901900000006,0.07543068559999999,1.88302708,1.46237903,0.0,0.0,1.91583674,3.23530348,4.27163692,6.08765582,3.83050506,1.4129868,1.62159549,0.574353895,0.0,1.8202017,0.037380207799999995,3.65191722,3.25434242,0.78732893,1.21100003,0.526789462,0.0,0.493575397,0.454761541,0.331594235,0.556338262,0.763417627,0.647945891,0.0,0.0,0.0,0.0,0.0,1.08669659,2.31816758,0.0,0.0,0.36823265299999997,0.906648103,3.06429626,2.41035409,0.544078123,1.56490958,0.765956723,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.7337633729999999,0.7226472890000001,0.0,0.0,0.367141638,0.910032671,1.01069974,1.18166446,1.25582849,0.616729891,0.0,0.0,0.6792118629999999,1.15015134,1.5722313,2.80044709,4.13090804,3.9398901,2.23245133,0.639434326,0.0641471729,0.0018834227999999999,0.0,0.00327559467,0.0770213175,0.0,0.0,0.0363866274,0.110406652,0.0,0.0,0.0912942001,0.137806329,0.0,0.0,0.325143503,0.8256779809999999,0.9929410879999999,1.38982954,2.32554631,2.96418719,2.50834031,1.56975423,1.34909643,1.89503455,2.17929173,1.68361991,0.943736692,0.514408334,0.292657105,0.0666476584,0.0,0.030703865299999997,0.07801428219999999,0.12806398800000002,0.444855785,0.851347711,0.823471087,0.46583327799999996,0.451856529,0.7938254840000001,0.808179263,0.475424981,0.440924218,0.538980358,0.0554545445,0.0,0.009818850550000001,0.668893139,0.0,0.0,1.54507871,6.4942991999999995,8.48814359,5.11555648,0.624969958,0.0,0.44737259100000004,0.408442122,0.0,0.0,0.591951561,0.21671189600000001,0.0,0.30197754,0.749812499,0.22305205600000003,0.150551162,1.24406805,1.54565618,0.0396819144,0.0,0.247026632,1.8657386000000002,1.64492215,0.426392286,0.0,0.0678483054,0.0,0.0,0.15814609400000001,0.16302571800000001,0.0,0.0,0.249113377,0.12621042300000002,0.0,0.0,0.313745492,0.0523579008,0.0,0.0,0.359033476,0.0,0.0,0.10298769599999999,0.38397973,0.0,0.0,0.23487933100000002,0.38152472200000004,0.0,0.0,0.375001959,0.31019280899999996,0.0,0.22671893699999998,1.26539959,0.42500417100000004,0.0,0.21300401100000002,2.19371076,0.624253975,0.0,1.95635713,10.949243699999998,14.2909833,7.37747149,0.0,0.0,0.810208873,1.2510444,0.0,0.0,0.59160058,0.529908956,0.0,0.0,0.476898327,0.233789953,0.0,0.0,0.386056726,0.071761119,0.0,0.0,0.304235104,0.0,0.0,0.0576570705,0.22856027199999998,0.0,0.0,0.09941397199999999,0.161334338,0.0,0.0,0.12663270699999998,0.11944928699999999,0.0,0.0,0.520734949,1.75663127,3.009963,3.28094381,2.08192488,0.5307443510000001,0.167897292,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.239
0.29629488,0.0,0.0,0.3210985,0.0,0.0,0.0,0.0,0.38355090000000003,0.0,0.0,0.41049873,0.23620974,0.0,0.03088053,0.11709985,0.0,0.10324047,0.0,0.16921094,0.61580817,0.0,0.02354597,0.0,0.0,0.58341871,0.31720729999999997,0.0,0.0,0.39790557,0.0,0.11664977,0.45507201,0.0,0.0,0.20993439,0.0,0.01756183,0.0,0.0,0.39749619,0.16062847,0.0,0.33477968,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.3272656,0.05133465,0.36448691,0.06016868,0.0,0.10288127,0.0,0.0,0.0,0.06388521,0.0,0.3836467,0.0,0.08695275,0.0,0.0,0.0,0.0,0.46259128,0.0,0.16675248,0.0,0.0,0.0,0.34574509999999997,0.0,0.0,0.09397421,0.0,0.37742607,0.0,0.0,0.0,0.05364472,0.0,0.0,0.0,6.28722398,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.65809673,1.72451916,0.0,0.0,0.530475173,0.0,0.0,0.0,0.50578266,0.43512122200000003,0.42803144600000004,0.0,0.899407757,0.0,0.0,0.767227488,0.0,0.19457123199999998,0.516572139,0.535481801,0.583371887,0.0308251083,0.0,0.0301126131,0.0,0.267849483,0.043399556500000006,0.7559897259999999,0.0,0.0,0.010424232299999999,0.507072371,0.0,0.440890822,0.885365397,0.0,0.0,0.0,0.297443859,0.0,0.223298418,0.0,0.0,0.480280765,0.0,0.0843543139,0.0,0.0,0.0377627908,0.0,0.0,0.0,0.231943502,0.0,0.0,0.0,0.85653508,0.0,0.0,0.409382032,1.21722997,2.49038728,1.94981757,0.288327645,0.0,0.792463715,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.32988869,0.7547320279999999,0.34896792600000004,0.0,0.0524945468,0.0,0.0,0.0,0.236680568,0.681343508,0.828687587,1.64983907,0.89396029,2.24169269,0.565382865,1.09027775,3.49751338,2.54212787,3.71188802,1.2994456,1.98320313,1.14145817,0.88715192,0.0,0.410014955,0.0,0.0,0.0,0.16406019800000002,0.0,0.196227018,0.7327616,0.5206250889999999,0.0,0.00038608208100000005,0.201866367,1.18614662,1.70639175,0.338954259,1.48970732,0.0,0.0,0.0,0.0,0.0,0.27250288100000003,0.0,0.31820341399999996,0.0,1.07247441,0.293631997,0.81086247,1.41444542,0.887943838,0.7339168290000001,0.00247847768,0.724720885,0.535878875,1.2504746,0.9534326809999999,0.0,0.0,0.0,1.76416276,2.66557284,2.27092853,0.453153491,0.88042451,0.12985182,0.0,0.0,0.581543508,0.0,0.048412864800000004,0.0,0.0,0.0,0.283204859,0.0,0.0,0.0,1.99226249,1.26219334,1.57981591,0.570270356,0.007741107099999999,0.462142149,0.47559742299999996,0.133017813,0.0,0.0,0.0,0.6900983620000001,0.0,1.04352635,0.0,0.0,0.297656963,0.0,0.0,0.0,0.33031785399999997,0.325185248,0.0,0.0,0.436097395,0.379269901,0.0,0.773986752,0.822743841,2.18865855,0.93125056,0.546206705,0.8975092240000001,1.66278559,0.47414544299999994,0.0,0.0,0.26912371,0.0,0.0,0.0,1.40602808,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.124435564,0.009925769880000001,0.11121676900000001,0.332513507,0.558057967,0.694902921,0.7020267170000001,0.596192909,0.434856884,0.285519629,0.195546324,0.17496184899999997,0.198113846,0.221476952,0.20806735699999998,0.14677029800000002,0.058014310300000003,0.0,0.0,0.0366250771,0.182726553,0.37220559200000003,0.5552762,0.68577903,0.7364985909999999,0.704785601,0.607500089,0.469575435,0.313230355,0.153720419,0.00319954895,0.0,0.0,0.0,0.0,0.271337783,0.669793953,1.11206351,1.50581189,1.76348952,1.83640742,1.73819406,1.54551349,1.37246915,1.32640437,1.46196032,1.75288123,2.09533811,2.34424627,2.37004072,2.11365533,1.61658477,1.01188597,0.477552985,0.169561674,0.161231013,0.41404721200000005,0.7928783340000001,1.1203372,1.24846846,1.11810583,0.780832568,0.373922425,0.0586290957,0.0,0.057279230800000004,0.294882375,0.506212009,0.54499119,0.34544718,0.0,0.0,0.0,0.0,0.0,0.5696929279999999,1.29335954,1.77959796,1.85027254,1.48627377,0.848061285,0.223628185,0.0,0.145389446,0.9111089059999999,2.02251855,3.13664357,3.88421691,4.00430094,3.44095846,2.36472106,1.11057574,0.0564426188,0.0,0.0,0.0,0.696026822,1.29089044,1.54780973,1.39067018,0.917044502,0.34421614899999997,0.0,0.0,0.0,0.390191684,0.821582232,1.0865732,1.08473179,0.839707395,0.48165515,0.18412742,0.0843812868,0.222176108,0.523194307,0.833430711,0.988914197,0.890278984,0.550067693,0.0925944151,0.0,0.0,0.0,0.300219109,1.00320299,1.68591937,2.16395442,2.33375742,2.2053757000000003,1.89029712,1.55137409,1.33638032,1.32199871,1.48934771,1.73842978,1.93311909,1.95694218,1.75718984,1.36128577,0.861561592,0.37726641299999997,0.010640243999999998,0.0,0.0,0.0,0.0,0.0637019897,0.0984491268,0.0797257936,0.0325922741,0.0,0.0,0.0,0.0,0.0,0.00456681872,0.00040352220800000005,0.0,0.0,0.00604989635,0.021470907799999998,0.030330142400000003,0.0232364079,0.0,0.0,0.0,0.0,0.0,0.0285224458,0.0688407878,0.0796296264,0.050061561799999994,0.0,0.0,0.0,0.0,0.0,0.0680666066,0.138768389,0.14637383699999998,0.07837017190000001,0.0,0.0,0.0,0.133382846,0.568712995,1.1682153999999998,1.81633816,2.36151553,2.66310011,2.63826063,2.29149085,1.71526845,1.06096654,0.490246325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.21273431899999998,0.042469615700000005,0.0,0.0,0.0695680588,0.018581213,0.0,0.0,0.062240132999999996,0.274600061,0.705456465,1.04581584,0.82042752,0.197347613,0.007827938100000001,0.589859845,1.12053437,0.69045449,0.0,0.0,0.632591051,1.88463682,2.1914857999999997,1.886349,2.11609149,3.04240022,3.50028166,2.60547311,1.00412703,0.018167937,0.0,0.14423712,0.021676063,0.0300518596,0.45991042299999996,0.718863768,0.301016585,0.0,0.82552918,2.62302282,3.57514662,2.66232046,0.928972107,0.0466272451,0.29680614,0.7422223509999999,0.8436488390000001,0.9033855470000001,1.09900286,1.11826116,0.92205867,0.9892168840000001,1.4359741000000001,1.6051745000000002,1.01687219,0.173269151,0.0,0.0799747192,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.620998799,0.9658604479999999,1.22454362,0.699400865,0.765473682,0.400910176,0.271081836,0.0778870606,0.452253178,0.48904632600000003,0.493953012,0.41991248299999995,0.373714039,0.272702227,0.0,0.0914487052,0.19493732,0.0,0.14503547,0.0660258801,0.0,0.0,0.21211909699999998,0.0,0.149656575,0.0,0.0,0.208567504,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.284959555,0.0,0.17373260699999998,0.0,0.0,0.278297289,0.186651657,0.036872065,0.0,0.0610896818,0.16731018,0.0,0.17981107300000002,0.234536823,0.0,0.0928850542,0.12642336099999998,0.0,0.0174531424,0.075498782,0.169996268,0.302782117,0.0,0.0,0.23336683,0.0770277101,0.151845598,0.10975135300000001,0.0,0.38681547,0.526449463,0.34055011,0.525314713,0.0909774399,0.0202136757,0.0,0.0,0.0,0.213769286,0.0,0.18435527399999999,0.362316886,0.0,0.0,0.0650786318,0.0,0.058998280599999994,0.41042375,1.26355511,1.46681807,1.54356151,0.905799682,0.5243684470000001,0.13691074,0.0,0.0,0.0,0.0,0.101086361,0.175690541,0.38993982299999996,0.472061091,0.758888201,1.10197523,1.3327076999999998,1.02900161,1.18198054,1.02506836,0.200358471,0.253716938,0.47021216299999996,0.892132397,0.9934764770000001,1.47582932,1.81660806,1.76802021,1.16432552,0.904387836,0.218950494,0.0,0.0,0.0,0.6843734570000001,0.8132316509999999,1.05906428,1.27303475,1.73349061,1.26219613,0.977398428,0.41565570399999996,0.0,0.0,0.0,0.0,0.211387092,0.032465323399999996,0.383360873,0.0,0.0,0.0,0.0,0.14382752699999998,0.44954010899999997,0.72187767,0.9562123840000001,0.9141398040000001,0.85261199,0.20227319800000002,0.0551956821,0.615393803,0.671031197,0.9258577920000001,0.880957655,0.845744559,0.244691838,0.35182847,0.641540012,0.8728895990000001,1.24375782,0.510203528,0.225643156,0.0,0.0,0.340414964,1.18764943,2.13699319,2.97080597,2.83014047,2.67010528,2.0151757,1.97028068,1.88704126,2.42704493,2.82790612,3.31283729,2.56597108,1.81054308,1.31858272,0.6172880239999999,0.46921271,0.57357437,0.5351640000000001,1.24513542,0.617194184,0.754255943,0.12679490699999998,0.0980028165,0.120408877,0.0,0.21730851899999998,0.42160282200000004,0.272385988,0.5236073920000001,0.0,0.0877022534,0.238697625,0.13701560599999998,0.124971634,0.172644402,0.15338705800000002,0.10390612099999999,0.0,0.19543426600000002,0.44711287,0.477391225,0.6231722279999999,0.277462072,0.482317768,0.18360909600000003,0.22277492699999998,0.288990922,0.0,0.0,0.0,0.0,0.0,0.0,0.132301434,0.0,0.0991069908,0.36571937200000004,0.0,0.0,0.0,0.0777550562,0.0,0.0,0.0749510197,0.358593373,0.17623011600000002,0.130887565,0.0,0.0,0.0141104422,0.21261871300000001,0.8411305990000001,0.8918021290000001,1.47017474,1.19907565,1.77034915,1.04390108,0.934245338,0.415667305,0.40030478700000005,0.0119397631,0.0,0.0,0.39233939799999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.57475912,0.93944344,0.0,0.0,0.48369155,1.89561334,0.0,0.42704036,0.50830812,0.0,1.12326807,0.82164623,1.06385553,0.48518108,0.80788547,0.0,1.28872434,0.47479494,0.8318535,0.83978993,0.14917252,0.0,0.61675256,0.34659246,0.48451622,1.18530077,0.33622149,1.34790118,0.35879636,1.54936373,3.35441501,1.83087497,1.8542691000000002,2.42498488,3.74332622,3.55855399,2.02316758,3.14058637,2.58369254,1.69780489,1.61752513,3.02906596,2.59159114,2.87694825,3.317997,1.5251845,0.73151533,0.63209016,0.0,0.82655665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.543973365,0.0,0.0198762101,0.49414856,0.20698149899999999,0.0,0.38933104700000004,0.12830888699999998,1.25388261,0.819197471,1.26760383,1.49632936,0.8809909340000001,0.0,0.0,0.0,0.0,0.161242796,0.620903077,1.43701006,1.65033499,1.99322034,1.40024819,1.2950955,0.34406812,0.0,0.0,0.0894928707,0.08772981769999999,0.08814318189999999,0.0,0.0,0.818126554,0.9991146479999999,1.11724101,1.64606507,0.883071449,0.786110511,0.100138114,0.0,0.0,0.246943758,0.46172397299999995,0.7999403359999999,0.355888336,0.0,0.0,0.0,0.0,2.09210142,3.74233953,5.64119421,5.63700028,4.16763249,2.76873542,0.868665425,0.0,0.0,0.0785810258,0.180685077,0.588809623,0.8515729390000001,0.0,0.0,0.0372185323,0.0,0.316967169,0.78521701,0.0,0.48955294,0.0,0.263602908,0.0,0.36286805899999997,0.0,0.0,0.0,0.285720584,0.0,0.0,0.0487217518,0.509504371,0.252514993,0.322487109,0.0945893383,0.0,0.0574943639,0.0,0.706225078,0.5878275829999999,0.43920216700000003,0.40644419,0.0834916799,0.5187009260000001,0.696592755,0.326160122,0.0,0.10050629900000001,0.0,0.0,0.25664719,0.322628545,0.29836397,0.6768705859999999,0.565994977,0.8896766209999999,0.6826123409999999,0.807438471,1.02925045,0.26895601,0.0,0.0,0.0,0.8462900309999999,1.1736052,0.614663253,0.599521693,0.827268197,0.059807162000000004,0.0,0.0,0.0,0.425697379,0.9644487840000001,1.20157864,0.7222723590000001,0.0,0.20294260100000003,0.468122407,0.190072662,0.672356705,0.814544811,0.0,0.702859405,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.84020408,0.44464436,3.28756945,0.0,0.73603669,1.80124672,2.8013470000000003,4.64011206,3.76102217,1.64790292,0.0,0.0,0.85740857,0.0,2.42288458,0.0,0.0,0.98978541,1.07989736,1.22656552,0.9277209999999999,0.55993323,0.0,2.43293383,4.45414377,7.20306353,2.52030847,4.32046369,0.0,0.0,0.0,0.0,1.50003984,0.0,0.0,0.0,0.21537818,2.82492934,3.07500139,0.36995143,0.0,3.00540239,0.0,0.0,0.0,0.0,3.59542262,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.29168668600000003,0.45787627200000003,0.149829619,0.229095121,0.0192893675,0.0,0.0358209778,0.0,0.123196605,0.34304342,0.45673176299999996,0.49181793799999995,0.0,0.0203698954,0.27481455,0.105810788,0.282736155,0.6907283670000001,0.9959253259999999,1.15139476,1.29417596,1.32154937,0.9738907929999999,0.570904387,0.535551498,1.02952655,2.08140045,2.72633851,3.01091468,2.53549229,2.19456794,1.31003919,0.6572233470000001,0.0813715269,0.0440901841,0.0,0.044128695499999995,0.0,0.21322719,0.31778869,0.37913130100000003,0.487908952,0.273539769,0.497456258,0.781686937,0.595892642,1.12512376,1.82333959,1.97282172,1.70925863,1.52414457,1.95456087,1.64251281,2.13079682,2.53569597,2.00426684,1.73047981,1.02520017,0.0498656142,0.0,0.0,0.40239485,0.610685965,0.6321900739999999,0.0,0.0,0.0,0.28060670600000004,0.545941141,0.304526124,0.263282938,0.0,0.0,0.07780401320000001,0.802222298,1.33165582,1.25755532,0.472301205,0.43995463,0.435874596,1.11025787,2.17613508,2.05103045,2.15822689,1.19806217,0.30688581,0.20201340199999998,0.117050834,0.18556082399999999,0.07636997599999999,0.20224361300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.234383586,0.0772519069,0.0,0.0,0.0500561072,0.5175643639999999,0.856445438,1.31646341,1.73077097,1.43870565,1.11303421,0.483908002,0.0,0.0,0.0,0.264068333,0.0,0.191422073,0.0,0.277944138,0.43504161,0.6405041429999999,1.01899267,0.564251793,0.13121913699999999,0.0,0.0,0.19517553899999998,0.115677158,0.0,0.0,0.0,0.0,0.0,0.536817915,0.804572354,0.594607784,0.396697849,0.446634012,0.344658136,0.08955321640000001,0.270416751,0.222525738,0.022360161200000003,0.0,0.249801212,0.0,0.327366043,0.15703086800000002,0.34213467299999994,0.454899114,0.468167107,0.172966268,0.30237496,0.0,0.0,0.19859748600000002,0.24612431,0.0421225969,0.00420733428,0.0,0.047511192599999995,0.157324065,0.0,0.0,0.102893355,0.0,0.0,0.0,0.0614861501,0.0,0.039683116000000004,0.06453242990000001,0.0,0.164303864,0.0,0.401129446,0.155573301,0.37391545299999995,0.352994455,0.483647124,0.021095781400000003,0.11164658,0.0,0.18029788,0.38072489,0.610169379,0.68009172,0.481984011,0.0,0.0,0.0,0.0,0.0,0.302985212,0.0968013011,0.043184323399999995,0.0,0.0107402581,0.405044288,0.0,0.0109023315,0.150224054,0.165705466,0.23657489,0.425455109,0.07995481389999999,0.132362502,0.0,0.0,0.0,0.134445171,0.158229711,0.0,0.0,0.0,0.0,0.12079608300000001,0.334647825,0.046543018,0.10559075300000001,0.0,0.209877206,0.0,0.0702084816,0.145680468,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0835819141,0.0,0.167503375,0.11665607800000001,0.0,0.0,0.0,0.0647353742,0.253025726,0.265058089,0.414308864,0.8156794079999999,0.639231268,0.282322201,0.285361488,0.0,0.32172758100000004,0.28592820399999996,0.851538902,0.7125725270000001,0.611114413,0.584345851,0.0437344347,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.298632437,0.0,0.0,1.23377035,0.0,0.0,0.0,0.0,4.88818005,2.20388659,1.45721042,0.0,0.31076045199999996,1.65115966,0.0,0.9390647059999999,0.76990989,0.0,0.0,1.61037765,0.0,0.0,0.0,0.54823788,0.287103296,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.32872284,2.78919399,0.0,2.21322129,0.0,0.0,0.0,0.0,0.0,14.905907999999998,8.99310443,0.0,0.0,1.55034557,0.11722020400000001,0.0,3.54208428,0.0,0.0,1.80486931,0.820927808,0.0,4.26705771,1.73035395,0.43677372600000003,2.08148009,0.173573223,0.0,2.10310395,0.0,0.0,0.0,2.00040377,0.207013155,1.93370662,0.0,0.0,0.0,0.6671267479999999,1.54117309,0.0,1.03386694,0.0,1.24817033,0.0,0.417376268,0.0,0.0,0.5867336360000001,0.673018722,0.26184135399999997,1.78765118,0.0,0.875272464,0.8436554270000001,0.0,0.244841518,0.0,1.41999678,0.00013509169599999998,0.0,1.66692677,0.596400346,0.871474709,0.0,0.0,0.0,0.0,0.0,0.0,2.53969308,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.549119646,0.88390309,1.36808028,1.7067697,1.63629231,1.14374189,0.491383146,0.023768353500000002,0.0,0.0687372945,0.219919207,0.177515098,0.0,0.0,0.0,0.0,0.193767957,0.232383055,0.0668682893,0.0,0.0,0.0,0.110537675,0.23259205100000002,0.149408758,0.0,0.0,0.0,0.0159422686,0.197561252,0.20489871,0.0317462579,0.0,0.0,0.0,0.136468342,0.23414036,0.125561043,0.0,0.0,0.0,0.05301326940000001,0.242951935,0.22427292399999998,5.53529459e-16,0.0,0.0,0.0,0.24390397100000002,0.37577331700000005,0.171504954,0.0,0.0,0.0,0.301153584,1.27205613,2.04524422,2.22972055,1.74923456,0.875285396,0.04691597559999999,0.0,0.0,0.0,0.17838433899999998,0.24060890399999998,0.10068594800000001,0.0,0.0,0.0,0.220204598,0.476594119,0.609909962,0.5739035610000001,0.406591949,0.19353387,0.0185292171,0.0,0.0,0.0,0.0333108618,0.0529862817,0.027236040299999997,0.0,0.0,0.0,0.011780291799999999,0.0556404708,0.0531002134,0.0,0.0,0.0,0.0,0.0664049917,0.10311196199999999,0.0467930775,0.0,0.0,0.0,0.059351345,0.188471202,0.162374312,0.0,0.0,0.0,0.0,0.34516084799999996,0.49478233,0.173409253,0.0,0.0,0.0,0.91636584,3.29277818,5.53871475,6.59137149,5.924087999999999,3.88813568,1.50838843,0.0,0.0,0.0,0.548263147,0.761101859,0.48388107,0.143365914,0.19814623899999997,0.701846883,1.24184392,1.29612565,0.699659041,0.0,0.0,0.0,0.140403308,0.756753641,0.76996194,0.166464361,0.0,0.0,0.0,0.414625079,0.78813005,0.468876505,0.0,0.0,0.0,0.119918612,0.795455767,0.789699068,0.0657534264,0.0,0.0,0.0,0.7200328770000001,1.17857621,0.593057565,0.0,0.0,0.0,0.5811551079999999,2.3922898999999997,3.16360711,2.43427743,0.886824583,0.0,0.0,0.946300592,1.52045552,0.649586627,0.0,0.0,0.0,3.20888617,9.67730968,14.931773800000002,16.1780775,12.6651411,6.19562426,0.0,0.0,0.0,0.0,1.58850882,1.97676521,0.727347889,0.0,0.0,0.0,0.42492397600000004,1.11938733,0.79998858,0.0,0.0,0.0,0.0,0.63378051,0.7276321609999999,0.201038437,0.0,0.0,0.0,0.28793788,0.586309701,0.36471535299999996,0.0,0.0,0.0,0.034328616,0.412235521,0.414148936,0.062122326900000004,0.0,0.0,0.0,0.232620982,0.384579245,0.198571306,0.0,0.0,0.0,0.0754155719,0.369427203,0.474948838,0.461325156,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.268
0.055850426200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.181361002,0.35903779799999996,0.520313485,0.658789999,0.769420578,0.848641489,0.8944380059999999,0.906344357,0.885380093,0.8339279479999999,0.7555605590000001,0.654825351,0.53699833,0.40781854100000003,0.273215305,0.13904029099999998,0.010815781000000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.065051444,0.127856097,0.180659653,0.22154909600000003,0.249305273,0.263421083,0.264084367,0.252127996,0.228951128,0.196416857,0.156732431,0.112318785,0.0656764274,0.0192545745,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00465124614,0.0243544194,0.0402025861,0.0516912987,0.058633600300000005,0.0611510552,0.0596462408,0.0547589993,0.0473096319,0.0382329023,0.028507170699999997,0.0190831737,0.0108169038,0.004410718,0.000366253109,0.0,0.000187189168,0.0038436257200000004,0.00946403154,0.0163969172,0.0238450125,0.0309244411,0.0367308644,0.0404083997,0.0412169029,0.0385932517,0.0322025648,0.021975832999999997,0.0081311971,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.005492124540000001,0.045320478899999996,0.0861536496,0.125865297,0.162235134,0.193065104,0.216300994,0.230153163,0.233209823,0.224536462,0.20375539399999998,0.171100256,0.127441319,0.07427883610000001,0.013703163999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0442156137,0.149998403,0.255385576,0.355132204,0.443924772,0.516630183,0.568550299,0.5956706429999999,0.594891697,0.5642315489999999,0.50298951,0.41186164700000005,0.293000996,0.150017362,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.265209155,0.6745520690000001,1.12018053,1.59169859,2.07746469,2.56496176,3.0412072,3.49318789,3.90830379,4.27480344,4.58219453,4.82161379,4.98614185,5.07105062,5.07397361,4.99499238,4.83663559,4.60379062,4.30353118,3.94486735,3.53842789,3.09608699,2.63054987,2.1549131,1.68221652,1.22500368,0.7949073259999999,0.40227530100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.28498439,0.0,0.54248185,0.0,0.60610234,0.51597925,0.75511312,0.0,0.19625075,1.02746533,0.0,0.0,0.0,0.66311045,0.68470255,0.7463666,0.0,0.43291024,0.29173183,0.81519241,0.74609935,1.11962695,0.81591674,1.21842444,0.36325247,0.49504255,0.0,0.12004145,0.61809344,0.44071583,0.0,0.0,0.7188971,0.61995081,0.78574033,0.60016738,0.0,0.02895129,0.0,0.11618098,0.90476889,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11700186,0.33691963,0.507363,0.77784375,0.20695697,2.66149279,2.77018474,2.21936477,2.53663795,3.14441768,1.68869313,2.78700397,2.66198006,2.74625655,0.87523026,1.20391001,1.49216569,0.0,0.09264992,0.0,0.0,0.0,0.36052066,0.0,0.0,0.35629502,0.0,1.04685942,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.57450135,2.36383141,0.0,0.0,1.03324075,0.9856029479999999,0.0,0.0,1.36053096,1.79148119,0.298935656,0.0,0.0,0.677693364,0.644663902,0.0,0.0,0.13622244,0.666244335,0.0834743767,0.0,0.0,0.47080443899999996,0.399324935,0.0,0.0,0.155490338,0.526226195,0.0172958627,0.0,0.0,0.47240676200000004,0.358103172,0.0,0.0,0.300762326,1.16273547,1.05372273,0.34769124700000004,0.0,0.119727871,0.10927624300000001,0.0,0.0,0.164488534,0.524395439,0.5286778320000001,0.495886547,0.6947388179999999,0.7390814309999999,0.241454759,0.0,0.0,0.230292489,0.378153532,0.0,0.0,0.0,0.45277518,0.187211656,0.0,0.0,0.7444694759999999,1.54113709,1.2859856,0.567427886,0.363270825,0.681477278,0.892879607,0.907797885,1.11619935,1.36048507,0.9819911929999999,0.052268248600000004,0.0,0.0661053315,0.553686503,0.11725865099999999,0.0,0.0,0.669068212,0.981933643,0.130691261,0.0,0.156509708,0.8103914320000001,0.08960042050000001,0.0,0.0200254158,2.40361518,2.84497937,0.0780216868,0.0,1.2976127,8.53936496,12.7769455,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.415466175,0.34066817200000005,0.547127192,0.584025236,0.949475173,0.684372341,0.385805643,0.381701171,0.696922996,0.0,0.260686796,0.0,0.369691404,0.012319873600000001,0.109712751,0.0,0.0,0.536746275,0.127220605,0.0,0.0,0.467223382,0.5108520999999999,0.0,0.224681546,0.5265922710000001,0.0,0.360315215,0.0,0.0,0.0019347110999999998,0.37595385299999995,0.0,0.0,0.0,0.230114982,0.0,0.0,0.0,0.0,0.30315248699999997,0.39554160200000005,0.142789092,0.396025185,0.70434831,1.40604494,1.43163251,1.61195852,1.35131832,2.05336178,1.58405087,2.06859721,1.85537199,0.974752583,1.35168693,0.5958469510000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.76453332,0.7910801390000001,1.01874812,1.00807954,0.773203669,0.6096085139999999,0.238738609,0.0,0.0,0.0,0.0,0.0,0.45589418600000003,0.943253098,1.92397118,3.10802573,4.04625516,5.07598638,4.85422607,4.48432687,4.27056218,3.46048346,2.61629432,2.09393846,0.756842676,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.278888283,0.343521901,1.06061447,0.374905831,0.013169546599999998,0.0,0.0,0.190775136,0.0,0.0,0.0,0.0,0.390784956,0.0,0.32173027,0.263469247,0.21325996600000002,0.0,0.0,0.336495204,0.0,0.19384315100000002,0.0,0.0,0.0,0.0,0.239367334,0.6014155529999999,0.254419335,0.28397798,0.348963539,0.0,0.0,0.0,0.0672215703,0.0,0.35878504200000005,0.0,0.0,0.0,0.6050745160000001,0.33845264799999997,0.0,0.5485725889999999,0.0,0.139474475,0.0,0.0,0.0,0.0,0.0,0.23722636100000002,0.5791664910000001,0.472165073,0.665796603,1.06455754,0.9632010440000001,0.94775021,0.680858025,0.966804958,0.7753103179999999,0.04677005730000001,0.271485518,0.0,0.0,0.26744914399999997,0.0,0.216465393,0.33905471200000004,0.0,0.0,0.311387602,0.480736116,0.49613495399999996,0.0,0.142359233,0.102301255,0.178621597,0.23668863899999998,0.0,0.5489000079999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.975217557,0.346502501,0.8903619,0.247141172,0.617795566,1.19339117,0.364804501,0.428430025,0.9254715,3.80126909,1.24937967,0.8347389340000001,0.710936048,0.18445510199999998,0.581670472,0.299757205,0.34065895700000004,0.8665371959999999,0.0,1.99097066,0.0,0.0500768537,0.0,0.0,0.894347675,0.0,0.302472733,0.0,0.0,0.36308074100000004,0.617567223,0.0,0.0,0.7520651909999999,1.28171563,0.0,1.24639819,0.0,0.6198376489999999,0.0246833293,0.531440654,0.0,0.0,0.0,0.8979198890000001,0.026407183100000002,0.153917327,0.0445933312,0.0,0.0,1.08432097,0.404500222,0.0,0.0,0.0,0.0,0.0,2.62969937,3.31777954,1.16570702,1.9238646000000001,1.88076769,5.22490154,4.37787078,2.97362611,1.19633855,1.57467796,2.37375975,2.31358979,0.16258235,0.41151132,0.8799077340000001,0.15364607,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.25001376,0.267289102,0.28037822,0.288830959,0.292372162,0.290906387,0.284515933,0.273452437,0.258122538,0.23906829300000002,0.216943243,0.192485121,0.166486321,0.13976329699999998,0.113126072,0.0873489774,0.0631437182,0.0411356845,0.021844327900000002,0.00566822141,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0024729024899999997,0.012303458500000001,0.0223487338,0.0320896084,0.041055846,0.0488434311,0.055128469900000004,0.0596771721,0.062351602,0.0631110726,0.062009235499999996,0.0591871035,0.054862407300000006,0.049315835700000005,0.042874834199999996,0.0358957304,0.0287450148,0.0217806332,0.0153341351,0.0096944786,0.0050942098,0.00169862897,0.0,0.0,0.0,0.0008095926690000001,0.00326180894,0.006353721850000001,0.00978607589,0.013235717099999999,0.016373346299999997,0.0188818847,0.020474590600000002,0.0209120701,0.020017354299999998,0.0176882937,0.013906621999999999,0.00874317671,0.00235892639,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0112079282,0.0307017783,0.0518079956,0.0738798074,0.0961912656,0.11796433699999999,0.138400094,0.156713005,0.172167137,0.18411298,0.192023511,0.195528057,0.194442577,0.188795013,0.17884449600000002,0.16509336,0.14829112,0.12942983800000002,0.10973056099999999,0.0906208103,0.0737034451,0.0607174898,0.0534918463,0.053893073799999996,0.0637686743,0.0848875206,0.11887922599999999,0.167174355,0.230947409,0.311064512,0.40803762299999996,0.521986959,0.6526131070000001,0.799180034,0.960509919,1.13499035,1.32059411,1.51491134,1.71519356,1.91840849,2.12130452,2.32048308,2.51247709,2.69383337,2.86119671,3.01139328,3.14151095,3.24897425,3.33161184,3.38771426,3.41608054,3.41605202,3.38753236,3.33099321,3.24746511,3.13851397,3.00620355,2.85304524,2.68193623,2.49608796,2.29894696,2.09411002,1.88523644,1.67595955,1.46980013,1.27008406,1.07986656,0.901864957,0.738401845,0.591360047,0.46215051,0.351693782,0.26041537800000003,0.18825487600000002,0.134688209,0.09876219480000001,0.079140023,0.0741561024,0.0818784012,0.100176242,0.126791374,0.159410099,0.19573423,0.23354876800000002,0.270784313,0.305572446,0.336292597,0.36160918200000003,0.380498182,0.392262645,0.396537015,0.393280489,0.382760028,0.36552390100000004,0.342366966,0.314289125,0.282448559,0.24811149300000002,0.21260029999999996,0.17724176600000002,0.143317255,0.11201643800000001,0.0843960401,0.0613448788,0.0435561948,0.0315080005,0.0254518792,0.0254103546,0.0311826515,0.0423583784,0.058338399699999995,0.07836192809999999,0.10153868,0.126884783,0.153361038,0.179912073,0.205504963,0.229165915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.584556318,1.73942572,2.64247441,2.70679995,1.91140822,0.794076892,0.013973391000000002,0.0,0.106347314,0.291822103,0.173862535,0.0,0.0,0.0383315619,0.29050028899999997,0.285772963,0.0252305479,0.0,0.0,0.266851215,0.444087852,0.294092113,0.0224376719,0.0,0.113221775,0.22582529399999998,0.0862460142,0.0,0.0,0.248752301,0.518732975,0.412965121,0.125439298,0.16249729699999999,0.682028802,1.19393671,1.08792018,0.407656274,0.0,0.028748671400000002,0.501746232,0.45652737299999996,0.0,0.0,1.58725173,5.18847619,8.38107667,8.71503041,5.70729194,1.41267316,0.0,0.0,0.0,0.956225386,0.579771209,0.0,0.0,0.0,0.462704732,0.46258108600000003,0.0114828106,0.0,0.0666938055,0.466328025,0.442764525,0.0,0.0,0.0,0.155150719,0.318965516,0.0748259021,0.0,0.0,0.0746007534,0.323482686,0.185318992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.633402757,0.801532235,0.938317064,1.02594997,1.05263201,1.01457877,0.916718743,0.771935278,0.59897332,0.419384779,0.254069029,0.12004006199999999,0.0280022321,0.0,0.0,0.000731966365,0.043885600999999996,0.09092003369999999,0.129994515,0.153297412,0.15796347,0.145850492,0.122324918,0.0944140172,0.0688014008,0.0501478741,0.0401136989,0.037268979,0.0378531765,0.0371374626,0.0310042863,0.0173197187,0.0,0.0,0.0,0.0,0.0,0.0,0.0033985975700000005,0.0660890327,0.147242534,0.244326018,0.35557932,0.480820408,0.621477284,0.779680693,0.9565234890000001,1.14987138,1.35232161,1.54998596,1.72268538,1.84588491,1.89431395,1.84678511,1.69134443,1.42965399,1.07949755,0.674541561,0.26095274399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.258766592,0.601892171,0.877219014,1.02679759,1.01502083,0.837379918,0.524080652,0.137443545,0.0,0.0,0.0,0.0,0.0899712504,0.835836163,1.78804365,2.84481484,3.87993872,4.76143717,5.37182523,5.62655649,5.48750028,4.9691235,4.13630074,3.0941249,1.97147402,0.901155028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.251773166,0.545269631,0.69621675,0.6911398040000001,0.5484992989999999,0.311766311,0.038498168799999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0546238771,0.222243863,0.329249776,0.35734465,0.306174056,0.19215163600000001,0.043895825199999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0180251526,0.133981508,0.215336599,0.246035593,0.22160104600000002,0.14956608400000002,0.047362454400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0987490025,0.175432605,0.21353793,0.20463707399999997,0.150002158,0.0602980232,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143091871,0.32316365,0.496469259,0.642302456,0.74400545,0.791026991,0.7799660620000001,0.714556772,0.604708922,0.464833837,0.311746713,0.162447709,0.0320555041,0.0,0.0,0.0,0.0,0.0,0.0,0.00807153261,0.0580769066,0.0905048485,0.100067537,0.08659214890000001,0.055273913499999994,0.0160405506,0.0,0.0,0.0,0.0435643777,0.145483089,0.286411028,0.45481373799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.75160921,5.89006369,5.62751073,3.09948001,0.0,0.0,0.0209008421,0.968374483,1.12325614,0.0199117836,0.0,0.0528402375,0.128803911,0.051158735700000006,0.0,0.0,0.0339876527,0.15046074199999998,0.0,0.0,0.333377608,0.12486129300000001,0.36827747899999996,0.0,0.0,0.0,0.530744447,0.0,0.455293486,0.164299624,0.0,0.15894493199999998,0.694580028,0.0,0.29272692,0.0,0.0,0.63507995,0.0,0.10495016300000001,0.44071270700000004,0.0,0.66140923,0.0,0.0,0.0,0.0,0.0,0.303598155,1.63291768,3.17892381,3.97218462,3.99881648,2.20271017,1.28871675,0.221132439,0.181130033,1.14984783,1.61569237,0.47331566700000005,0.30642205899999997,0.0,0.0,0.22039763399999998,1.02466121,0.409965788,1.11967873,0.318280648,0.79909389,0.0,0.311243907,0.0,0.0,1.04579508,2.09578422,2.51482903,1.41733837,0.0,0.0,0.0,0.7118983409999999,0.818272132,0.375831961,0.0,0.0,0.8055967470000001,0.48884355,0.0,0.0,0.0371641189,1.00355937,0.8039721670000001,0.325056788,0.491974577,0.0,0.0,0.9354954129999999,0.588942279,0.0,0.38813389,0.16291965,0.0,0.142254929,0.0,0.0,0.43204167,0.0569387732,0.0,0.0,0.0,0.345368171,0.0,0.0,0.0,0.42567862100000003,2.16589004,1.09910516,0.258406258,0.0,1.78814312,3.318772,4.67591194,3.64841052,1.05549525,0.0,0.0,0.724566556,0.86035579,0.0928880511,0.0,1.96026378,2.34833792,3.03878062,1.07678749,0.09863501699999999,0.0,0.615050161,2.3815475,2.10256889,1.8699006999999999,0.0,0.0,0.0,0.274875358,0.41680583200000004,0.0,0.0,0.0,0.0,0.195140516,0.0,0.0,0.0,0.0,0.0,0.266774632,0.0,0.0,0.0,0.0,0.060033034699999994,0.0,0.0,0.0,0.420846622,0.0,0.0,0.0,0.809723216,1.12435864,0.237747691,0.0,0.07127218610000001,0.0,0.0417741109,0.462597645,0.0,0.441336275,0.41051118700000006,0.634413565,0.0,0.0,0.005591863020000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.560006641,0.0259030102,0.0,0.0,0.0,0.417341749,0.385238574,0.0,0.0,0.27594174,0.441613109,0.0,0.504973428,0.0,0.147204639,0.0,0.387110095,0.172061391,0.605938293,0.14483600900000002,0.29737478300000003,1.28535648,0.280888953,0.998746892,3.26838556,2.57436314,0.270993514,1.45396187,2.98599762,2.20646892,3.34971783,0.46135667700000005,0.514811803,0.23092557100000002,0.0,0.0,0.9024616409999999,0.591957877,3.60988439,1.76030619,0.17773421399999997,2.4234430000000002,4.45428698,3.1597942999999997,6.37146076,2.80200603,0.746661809,2.98585775,2.36203528,0.7222802209999999,0.619672209,1.40638923,1.70180386,0.0,0.0,0.0,0.679656912,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
20.647835999999998,0.535934197,0.0,1.14641475,1.46468963,0.0,0.0,1.02757097,0.0,0.0,0.0,2.05483435,1.82296432,0.0,0.637299818,0.0,0.795438172,0.472272355,0.0,0.391265377,0.0,1.90271315,1.27829264,0.0,0.0,1.2302171,1.23949169,0.15673984400000002,0.551488483,0.0,0.9810298390000001,0.0,0.0,0.0,0.0,0.0,0.0,0.859579436,0.0,0.0,1.51545349,0.0,0.298860572,1.67337604,0.0,0.7307226840000001,1.86079766,0.0,0.45356078,1.74662187,1.66628309,0.0,1.0730206,0.076306998,1.48517962,0.0,1.51656779,0.661103814,0.0,1.95510229,0.0,0.0,0.0,0.408131339,0.0,0.0907930985,0.0,1.50702296,0.0,0.0,0.0,1.88869244,0.235125045,1.7860526,0.0,0.0,0.0420417331,0.443862185,1.05755808,0.0,0.0,0.0,0.104377976,0.0,1.20057427,0.0,0.0,0.0566509343,0.0133749145,1.83266665,0.0,0.0,0.0,1.75725548,0.0,0.0,1.80580906,0.0,0.0,0.455696363,0.0,0.0,0.0,1.80545555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.498307565,0.0,0.0,0.0323954265,0.684010765,0.604991762,1.21229718,0.0,0.0,1.76078229,0.30026538199999997,0.0,0.626774807,0.528602634,0.0,0.736617705,0.8602942729999999,1.00899574,1.13332968,1.50713069,0.5371755429999999,0.532404064,0.241229523,0.0,0.325542819,0.0,0.6263026999999999,0.0,0.0,0.0,0.941908655,1.33398193,0.623565053,0.5079483029999999,1.31373204,0.0,0.30020262600000003,1.0195188,0.0,0.538588683,0.0,0.0,0.0,1.12688946,0.146242816,0.772958487,0.0829600559,0.0,0.0,0.0,0.0,0.99638458,0.0,0.20874817699999998,1.32706849,1.1741476,1.09283304,0.0,0.519847931,1.25111905,0.28271467,0.0427710341,0.0,0.127739293,0.759232667,0.48274315100000004,0.0,0.153109879,0.202545416,0.38089364,0.21977634100000001,0.0,0.5295094539999999,0.344410912,0.008493302809999999,0.0,0.0,0.0,0.729082578,0.16504490300000002,0.670824364,0.0,0.521189937,0.0,0.43355468799999997,0.0,1.09598126,0.441124998,0.274133594,0.0,0.0,1.07662678,0.0,0.756904172,0.0,0.0,0.230126936,0.0,0.0,0.0,0.0,0.20838937100000002,0.035315107799999995,0.0,0.123050149,0.0,0.0,0.0328468876,0.00102200157,0.0657850368,1.18530582,0.273501292,0.0,0.649209396,0.0,0.281341334,0.34037911200000004,0.102800197,0.352351884,0.0,0.0,0.330377136,0.760497555,0.0,0.547198696,0.400580186,0.0,0.45000513200000003,0.807705077,0.0,0.606520607,0.510675099,0.101216725,0.6881113959999999,0.55876969,0.259993923,0.958877951,1.46976373,0.0207974582,0.460663441,0.190606713,1.20856977,0.17036654399999998,0.633962385,0.0,0.0,0.0,0.770560633,0.400475935,1.75904417,0.921035602,0.409335206,1.30183993,1.889502,1.13587144,0.00820736523,0.334032735,0.385256799,0.469585229,1.71751603,0.0,1.2914917,0.0528105658,0.0,0.0,0.0,0.0,0.18830603899999998,0.254873145,0.054514644,0.549634754,0.0,0.192095822,0.102825785,0.229043391,0.119489386,0.0,0.0,0.35918910600000004,0.0,0.0,0.592076345,0.0,0.026895481000000002,0.0,0.0,0.510031269,0.34353938100000003,0.0170516834,0.0,1.09019485,0.652274456,1.37501743,0.553715686,0.475936824,0.0,1.03237877,1.32792648,0.102979414,0.68032319,1.00635991,0.540160081,0.0,1.32131798,1.3228521999999998,0.841029955,1.97302968,3.15611429,3.50448599,2.46749865,1.61802608,2.19958023,0.8856159109999999,1.39817975,0.0,1.00903252,0.0,0.9460909129999999,0.172374853,0.491623793,0.67053179,0.0,0.07855247480000001,0.0,0.398506514,0.483968258,1.47526732,0.8473621720000001,0.37090142299999995,0.43010371399999997,0.310671175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.31211073,0.859827089,0.433367811,0.0,0.0,0.0,2.92606047,6.01105753,6.86165802,4.83593046,1.43021379,0.0,0.0,0.0,0.777002381,0.66263807,0.0,0.0,0.0,0.22356595,0.348052533,0.0645932467,0.0,0.392847094,1.04227419,1.18141305,0.552889822,0.0,0.0,0.0,0.534856028,0.589222814,1.0954184399999998e-15,0.0,0.0,0.25134211,0.89190602,0.883376583,0.416139046,0.26111761899999997,0.964795018,2.24442798,3.18921958,3.0599827,1.91715221,0.52194845,0.0,0.0,0.0,0.207706272,0.168555555,0.0,0.0,0.0,0.054832532999999996,0.0938847137,0.0226267309,0.0,0.0,0.005922273489999999,0.0590441739,0.038773253,0.0,0.0,0.0,0.037810124300000005,0.047585771500000006,6.84636526e-16,0.0,0.0,0.0184182349,0.0531095138,0.0234717477,0.0,0.0,0.0,0.052346965599999996,0.0477985115,0.0,0.0,0.0,0.040645597900000004,0.0696608365,0.0131902501,0.0,0.0,0.014612709599999999,0.0826095003,0.0515800104,0.0,0.0,0.0,0.0790218316,0.0921973079,0.0,0.0,0.0,0.0519583375,0.123140945,0.044375131,0.0,0.0,0.0,0.10447072199999999,0.06107159,0.0,0.248114657,0.9953261590000001,1.96999242,2.57711869,2.38352261,1.50516908,0.506173187,0.0,0.0,0.0,0.023262506000000002,0.0,0.0,0.0503189875,0.0692821743,0.0,0.0,0.0,0.08083998070000001,0.173494559,0.051302237699999996,0.0,0.0,0.0225073303,0.259976508,0.195951244,0.0,0.0,0.0,0.31957360100000004,0.481259227,0.10020818599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.23000303,0.22348009600000002,1.02293346,0.0,0.0,0.0,0.0,0.0,1.15944084,0.0,0.70690725,0.101617317,1.3110825000000002,0.0,1.03509291,0.0,0.0,0.503005138,0.0,0.37341276100000004,0.319208525,0.0,0.831127438,0.0,0.0,0.873267067,1.22738831,0.9055615840000001,0.0,0.771510835,1.53973594,4.22013943,5.87074063,3.89778125,3.32913971,0.873109391,0.0,0.22681529600000003,0.0,0.344696713,0.308239115,1.15449327,1.07548661,0.0,1.6859297999999998,1.30694065,0.0,1.1692337,0.0,0.211741144,1.1024796000000001,1.93439071,2.79235224,0.638395452,1.22489007,1.47805323,1.36787262,0.18644930699999998,3.82531081,0.432697619,0.12047136900000001,1.02070754,0.0,0.358972621,0.0,0.0,0.12140420099999999,0.0,0.16882361,0.0,0.0,0.0,0.37949535100000004,0.0,1.69820106,1.91056062,1.9353836,0.0,0.9729380879999999,0.0,0.00291147696,0.0228489596,1.16313547,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0916436146,1.36179092,0.0,0.0,0.37570573399999996,0.93401782,0.0,0.0,0.765882946,0.0,1.4646753000000001,0.0,0.867043552,0.439898099,0.0663121616,0.793889245,0.0,1.5264739,0.0,0.0,0.092384841,0.8010316829999999,0.0,0.508293103,0.321893871,0.316285726,0.0,0.0,0.127493314,0.0,0.0,0.681725177,0.0,0.621691094,1.80843136,0.0,0.163614893,1.78087393,1.04464861,0.466358527,1.13689951,0.573377562,0.5647925189999999,0.889453245,0.0,0.727468476,0.6753373770000001,0.294684945,0.052784653499999994,0.151282245,0.0,0.0,1.84537209,0.0,0.9075016029999999,0.7812345820000001,0.0,0.0,0.25640986,1.52187377,2.6516037,1.00041887,0.544597526,0.48746649799999997,0.0,0.0,0.141327048,0.0,1.03492997,1.29523832,0.0,0.98705325,2.28252801,0.0,0.20902903899999997,0.948799708,0.613517346,0.292765395,0.0,0.484929125,0.0,0.0,0.0,0.0,0.9143587940000001,0.0,0.0158435038,0.0,0.0,0.0,0.0,1.1067106000000002,0.179650662,1.10738194,0.0,0.0,0.0,0.0,0.0,0.401066889,0.0,0.0,0.823854193,0.0,0.51115812,0.959860495,1.18637765,0.0,2.48616575,0.0,1.39456129,0.832149536,0.0,0.0,0.08530678970000001,0.0,0.0,1.41400267,0.447222413,1.93322697,0.0,1.48485931,0.0707283679,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.290047785,0.545623884,0.599572322,0.561347087,0.251767352,0.243418443,0.3401854,0.0,0.0,0.0,0.0,0.0,0.308885426,0.0,0.0,0.0,0.0,0.295779045,0.0,0.0,0.10671289099999999,0.0,0.0,0.0,0.0,0.0897007058,0.00619863341,0.0,0.0,0.11234975,0.0,0.341275038,0.19033708800000002,0.165167526,0.213217607,0.0,0.060901043499999995,0.345486942,0.272296921,0.44216398100000004,0.0,0.463717965,0.5636272520000001,1.12933825,1.82193277,2.25779699,2.82915401,2.4873106,2.17622279,1.12020804,0.755501742,0.32566597199999997,0.270365375,0.430515989,0.455117704,0.676548037,0.245111055,0.201957327,0.0,0.0,0.0,0.015391503300000001,0.47236634899999996,0.124405208,0.398017384,0.335013701,0.160430731,0.0,0.7478728370000001,2.0283946,2.70376959,3.44969324,3.24023515,2.91879033,1.92352116,1.24608063,0.0147878098,0.263661672,0.0597258088,0.16556854099999999,0.0,0.0,0.0391029013,0.132233668,0.116703766,0.337730808,0.511646419,0.48514453,0.0,0.15898625,0.0,0.0431297125,1.07899313,1.53033803,2.03779996,2.20299774,1.88886807,0.8370427509999999,0.24856695199999998,0.0907029065,0.0,0.26110560899999996,0.151856283,0.750805955,0.289724934,0.46505763,0.126515218,0.363048207,0.33589519,0.13610845400000002,0.0827391822,0.38010954,0.566326146,0.409887546,0.22811308100000002,0.560304172,0.718046387,0.799032045,0.8256340670000001,0.36509752100000004,0.0116342898,0.08687900259999999,0.33484506199999997,0.108046965,0.543465414,0.455629168,0.31454650300000003,0.484825842,0.0866086414,0.784925622,0.455355716,0.740788155,0.377508971,0.312663678,0.286014571,0.48342131299999996,0.34325472100000004,0.159333414,0.153756324,0.23260533100000003,0.0841642524,0.23679697,0.0,0.141685675,0.07731143780000001,0.0,0.32079638899999996,0.0,0.0,0.169504513,0.0,0.0,0.0,0.0,0.0,0.0452554139,0.0,0.0,0.141358146,0.0,0.186667279,0.033405973900000004,0.144342368,0.0,0.0448467471,0.156351655,0.0,0.0,0.0,0.0,0.0,0.304200602,0.0,0.14570118599999998,0.0792515933,0.036459786800000005,0.15382126,0.0,0.0,0.305885435,0.23670444899999998,0.0,0.0,0.13106495,0.0827673362,0.0,0.0,0.012885573899999999,0.0,0.0366000777,0.0,0.0,0.0,0.233793307,0.0,0.0,0.0,0.203888887,0.18734656600000002,0.0,0.290486116,0.00561033819,0.0,0.0,0.279495678,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.90255728,7.13444749,4.74456527,2.21274059,0.0241171346,0.0,0.0,0.0,0.0,0.0241171346,0.890076868,1.33756311,1.26567031,0.749428907,0.0,0.0,0.0,0.0,0.0,0.06431235889999999,0.959647281,1.76951652,2.32308886,2.53565275,2.4197525,2.0658714,1.60273269,1.1526684999999999,0.7972131140000001,0.56273314,0.427796709,0.346158357,0.27440314899999996,0.192902324,0.11254662800000001,0.06601509900000001,0.0885979426,0.19748402199999998,0.37861840799999996,0.586850275,0.759577035,0.838638523,0.791915455,0.62615302,0.385874153,0.138543377,0.0,0.0,0.0,0.0,0.125518034,0.211514486,0.21746342600000002,0.137140515,0.0,0.0,0.0,0.0,0.0,0.0,0.147460048,0.240462528,0.24236141600000002,0.15099684800000002,5.71208493e-17,0.0,0.0,0.0,0.0,2.85604246e-17,0.161430422,0.264254598,0.267515833,0.167487387,0.0,0.0,0.0,0.0,0.0,3.85565733e-16,0.18743359399999998,0.30924739100000004,0.315579249,0.19913155899999999,0.0,0.0,0.0,0.0,0.0,0.0803904486,0.375006423,0.605730034,0.697534946,0.622338143,0.40999128799999995,0.13824622,0.0,0.0,0.0,0.0,0.21744441899999997,0.382773559,0.411679022,0.271892295,0.0,0.0,0.0,0.0,0.0,0.0,0.418874984,0.722992823,0.7714805140000001,0.5080135960000001,2.57043822e-16,0.0,0.0,0.0,0.09089101039999999,1.63996515,3.72893355,6.011248,8.0388836,9.37219194,9.6950881,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
0.035717828199999996,0.198562645,0.374074765,0.546991306,0.701608115,0.8235274570000001,0.901320771,0.927905393,0.90146205,0.82576979,0.709901427,0.567297864,0.414314835,0.268401547,0.14611903099999998,0.061230436500000006,0.0230923768,0.0355454265,0.09644606130000001,0.197907871,0.32723535600000003,0.468449072,0.604226625,0.71802929,0.796156086,0.829469945,0.814574776,0.75428435,0.657307181,0.537166574,0.410470419,0.294729617,0.205986787,0.15654975599999998,0.153122484,0.19558866,0.2766335,0.38229460600000004,0.493423569,0.587928669,0.643568766,0.640991259,0.566662724,0.415335757,0.19173148,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.245152197,1.05092906,1.9828063999999999,2.9923157000000002,4.02198594,5.00982792,5.89434341,6.6195906,7.13982743,7.4232928,7.45476943,7.23669159,6.78870407,6.14573061,5.35475424,4.47063409,3.55137095,2.65327803,1.82651083,1.11136116,0.53563249,0.11329527800000001,0.0,0.0,0.0,0.0,0.0,0.0795085296,0.229402683,0.347938861,0.418993492,0.43497686,0.396636117,0.31196907,0.19443825399999998,0.060738960599999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05528253019999999,0.13527381300000002,0.193165702,0.22417662800000002,0.227364806,0.20545935899999998,0.164232016,0.11151805699999999,0.0560336233,0.00615437872,0.0,0.0,0.0,0.0,0.0,0.0373705136,0.0810830572,0.12103466800000001,0.151546357,0.16856511300000002,0.170179306,0.156816085,0.131105508,0.0974417652,0.0613119642,0.028492307,0.0042265459899999995,0.0,0.0,0.013398353,0.04426565230000001,0.0844914312,0.129266718,0.17328890800000002,0.211507707,0.239818187,0.255604467,0.258059964,0.24824254,0.22886075,0.203825384,0.177633481,0.154675346,0.138565673,0.131596186,0.134389831,0.145807779,0.163124407,0.18244683399999997,0.19932007300000001,0.20943115899999998,0.209309849,0.196921962,0.172064558,0.136498385,0.09378902119999999,0.0488690418,0.00737387584,0.0,0.0,0.0,0.0,0.0,0.0394850671,0.0859105043,0.130070345,0.164337003,0.181882701,0.17771046399999998,0.14950993,0.0982129666,0.0281573546,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.6792021890000001,0.0,0.0864160618,0.0,0.0,0.653657979,0.662120783,1.75278406,2.41264427,3.06319766,3.25696292,4.15058289,3.86753742,3.85026305,3.73268402,3.07999749,2.70589713,1.68687828,0.9369284720000001,0.0,0.0,0.0,0.0,0.0,0.0,0.28164923199999997,0.151860796,0.197339476,0.7268595729999999,0.0,0.546588344,0.37339683700000004,0.23683989100000002,0.0,0.0,0.0,0.0,0.0346218474,0.0,0.149493173,0.227457241,0.0,0.527742362,0.273984089,0.36377762700000005,0.0,0.0,0.166464741,0.0,0.377647981,0.0,0.23763014100000002,0.0,0.0,0.0,0.0,0.0,0.298230702,0.311785319,0.308659347,0.0,0.0,0.38598516,0.0,0.0,0.36353914200000004,0.0,0.0,0.228404513,0.26371673100000004,0.228903598,0.0151378507,0.20623200600000002,0.515939105,0.325935663,0.4119807,0.0,0.49525958,0.329909944,0.27597649399999996,0.49598057100000004,0.0,0.354369728,0.0986383502,0.396826914,0.416511705,0.0,0.312118697,0.0,0.038413894,0.0793085992,0.0,0.0,0.230086032,0.08474378119999999,0.06663372719999999,0.417698835,0.0,0.45651283299999995,0.091848921,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0822026832,0.420768341,0.947871059,1.08004765,1.13031269,1.2657633,1.1561350000000001,0.775168883,0.6888328359999999,0.131305704,0.48609435,0.128494322,0.456186549,0.5130603460000001,0.525180386,0.820845024,0.14366484,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5112688360000001,0.0,0.497437409,0.0,0.0,0.0,0.18071357899999999,0.221942642,0.58600861,1.05417723,1.26443512,0.917657257,1.67578238,0.972976642,0.9886600259999999,0.0,0.0,0.33574361700000005,0.253235823,0.0,0.574627849,0.0,0.0,0.0,0.288490079,0.113913059,0.0,0.0,0.100100699,0.0490528268,0.0,0.0,0.203860481,0.0,0.0,0.0,0.644260135,0.35391283100000004,0.0,0.747714777,0.16997277,0.137315057,0.0271252194,0.0,0.0,0.0,0.28841855899999996,0.0,0.664113257,0.716230948,0.0,0.0,0.588584789,0.631393697,0.448916353,0.0,0.0,0.0,0.0,0.47007613200000004,0.45516133200000003,0.0976960868,0.0,0.036800576200000004,0.0,0.0,0.0,0.33794896,0.7991353640000001,0.45468907799999997,1.0145301,0.739172066,0.6753449159999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.801462702,0.5279674010000001,0.406579875,0.0,0.277654566,0.255147513,0.0,0.0,0.0,0.0,0.19845013,0.605382443,0.99208461,0.654955663,0.35645271100000003,0.0,0.0,0.07132500650000001,0.58597256,0.928045804,3.24633773,4.21170641,6.10293542,5.9089594000000005,6.09367158,5.72610774,4.72285554,4.04841452,2.34495621,0.7816295459999999,0.0,0.0,0.547004595,1.37235411,2.45914586,3.39992288,4.31860444,3.85572439,2.77119446,1.01262406,0.0329410959,0.0,0.0,0.0,0.0,0.319329365,0.796969345,0.273105667,1.40967787,1.28503699,0.31388364,0.050387700300000005,0.0,0.0,0.0,0.0961352318,0.0,0.0,0.0,0.21294521100000002,0.0,0.44538862799999995,0.0,0.0,0.0,0.0639680898,0.261094279,0.9023803109999999,1.52623993,1.17329685,2.24816188,2.31761888,1.89152439,2.73582362,2.33899755,1.48300055,0.626350019,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.462254934,0.0,0.0,0.468675685,1.02910877,1.39437596,0.228693885,1.88224144,1.37721858,2.3757777,0.454007111,0.0,1.21937644,0.0,0.937826623,0.0,0.301273199,1.10373306,3.42945772,1.57435167,0.7417122009999999,0.398312684,1.29235514,0.0,0.774252525,3.12814248,0.09976090230000001,1.61459965,0.333588475,2.3735139,1.94921409,1.85744278,1.48640359,0.235679875,0.409982996,0.0,0.8566792940000001,0.359711651,1.23470271,0.0,0.0,0.0,0.0,2.03683391,5.30131298,7.15610517,4.14350686,2.77877426,0.0,0.0,0.0,0.0,1.76465303,3.41649519,0.14716761,1.0584803,0.0,0.0,0.444020189,0.0402069812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.1879568,0.670913355,1.98610491,2.52011825,1.83269415,0.683401348,2.24885274,1.01631915,0.0,0.61608009,0.0,0.0,0.0199419841,0.0,0.612051796,0.563453915,0.156065564,0.0,0.0,0.355983208,1.02175593,1.77887264,1.17167579,0.24945062199999998,0.13624893300000002,0.938949565,1.33401349,0.0,2.0818497,0.0,0.0,2.04557619,0.9731883159999999,0.669579594,0.0,0.7133061070000001,0.922832048,0.0,0.0,0.0,0.469850472,0.847882659,0.8370858320000001,0.469890452,0.0,0.0,0.0,1.62769673,1.52174568,0.155581611,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.7755386000000004,4.78003793,5.43613188,3.39254901,0.579955849,0.0,0.0,0.07586941309999999,0.7626886629999999,0.6818968990000001,0.0,0.0,0.439653065,0.23611870899999998,0.784990572,0.0,0.0,0.011961499799999999,0.544266504,0.0,0.485511299,0.0,0.0,0.14684240099999998,0.315136064,0.0,0.450218522,0.0,0.5906214470000001,0.712977925,1.08580234,0.932799708,1.65231746,1.26104585,0.499194135,0.5775390220000001,0.47466294600000003,0.7874669870000001,1.66095612,1.9084515,1.21002545,0.328658983,0.0,0.0,0.0,0.0,0.07954374139999999,0.0,0.0,0.0143338153,0.0,0.33566438,0.0,0.0,0.426892985,0.505156535,0.0,0.184523837,0.0309052836,0.0,0.346794208,0.0605014235,0.0,0.0,0.0,0.584530024,0.7518347540000001,0.74669294,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.178467295,0.28290423,0.292738312,0.204864485,0.050003365999999994,0.0,0.0,0.0,0.0,0.0,0.101754506,0.23854788,0.29296346,0.243872527,0.10637652,0.0,0.0,0.0,0.0,0.0,0.039726929,0.22283263,0.333040018,0.327762806,0.203759575,1.3782991899999998e-16,0.0,0.0,0.0,0.0,0.0,0.20419612,0.403551813,0.470442305,0.36984478600000004,0.12365728599999999,0.0,0.0,0.0,0.0,0.0,0.284524084,0.8235824159999999,1.28760078,1.56610521,1.60489051,1.42385973,1.11091182,0.79300735,0.593192905,0.587444752,0.775913465,1.07908615,1.36165189,1.47782214,1.32440254,0.884521722,0.246871233,0.0,0.0,0.0,0.0,0.741802231,2.23176192,3.86707592,5.32706896,6.31035134,6.61015111,6.16634662,5.07988319,3.58578882,1.99257144,0.60498998,0.0,0.0,0.0,0.0,0.33364279,0.83841524,1.11788361,1.11070821,0.852156293,0.45013959600000003,0.042687792599999996,0.0,0.0,0.0,0.0,0.167743765,0.343208925,0.394960139,0.310888387,0.128326768,0.0,0.0,0.0,0.0,0.0,0.08343266690000001,0.23964392899999998,0.313444364,0.283121843,0.16373133199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.100136953,0.181224978,0.191330127,0.133964946,0.038818548,0.0,0.0,0.0,0.050432263399999996,0.197727583,0.34033273799999997,0.43043691100000003,0.435385377,0.34903684700000004,0.19417949699999998,0.0152242001,0.0,0.0,0.0,0.0,0.0,0.125081499,0.203246245,0.208511285,0.140829531,0.0253430503,0.0,0.0,0.0,0.0,0.0,0.0719220612,0.166601931,0.202289209,0.16655735900000002,0.0718845281,0.0,0.0,0.0,0.0,0.0,0.0252893576,0.140417295,0.207605662,0.201866007,0.123709471,0.0,0.0,0.0,0.0,0.0,0.057304387199999994,0.233757694,0.368479075,0.413817815,0.35215827200000005,0.20742590800000002,0.044468386799999995,0.0,0.034960240499999996,0.353608418,0.93197291,1.72817407,2.64010612,3.52401562,4.22529707,4.61401629,4.61608462,4.23185957,3.53706661,2.66550779,1.7778151999999998,1.02420577,0.510773489,0.277865894,0.295796379,0.478447579,0.710524446,0.8806480520000001,0.911126641,0.776455089,0.506003509,0.17096133100000002,0.0,0.0,0.0,0.0,0.0,0.08760361529999999,0.266812371,0.347636829,0.309866611,0.17339444699999998,0.0,0.0,0.0,0.0,0.0,0.0155182693,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.204618363,0.0,0.0,1.52042776,0.0,2.09739671,1.55135966,3.36248964,2.36263132,5.292088099999999,4.15415831,4.13292057,2.03175215,2.92500854,1.13447733,0.644692531,0.14128202199999998,0.0,0.26398863300000003,0.0,0.0,0.0,0.0,0.317708389,0.0,0.0,0.0,0.0,0.21912094899999998,0.0,0.0,0.0,0.0,0.0,1.11519899,0.0,0.0,0.234977325,1.56855082,0.0,0.0,0.0,0.282803831,0.929620639,0.491238506,0.307515771,1.14965766,1.63384231,0.0,0.743250097,0.62881238,0.394310692,0.0,0.866568061,0.0,0.0,0.7053256640000001,0.3171489,0.0,0.656033266,0.259509145,0.7093758370000001,0.0,0.247246584,0.0,0.0071973067099999994,0.764813558,0.0,0.98333834,0.0,0.0,0.0,0.0,0.24805658600000002,0.0,0.0,0.0,1.57902836,1.52886777,1.93741838,1.01354489,0.0,0.0,0.0,0.0,0.137479253,0.013666319299999998,0.0931323188,0.444338016,0.0,0.90327196,0.21492846699999998,0.0,0.69289309,0.0978346258,0.0,0.0,0.0,0.0,2.22341225,0.0,0.630198138,0.0,0.0,1.1330386000000001,0.0,0.0,0.0,0.8805611870000001,0.781576255,1.41325528,2.00976521,0.0,0.0,0.687421664,0.0,0.730008415,0.42705515,0.42433977799999995,0.0,0.49300616700000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.426263025,0.601915289,0.513731795,0.28096514699999997,0.198783505,0.379652562,0.6202729020000001,0.656021648,0.467761452,0.264094888,0.203096213,0.230512612,0.206648212,0.103466281,0.0118734201,0.0015944553400000002,0.055367998200000004,0.135096663,0.231625876,0.317143936,0.314819575,0.184257599,0.0123842476,0.0,0.021057111,0.119272295,0.11864772400000001,0.0400845507,0.0,0.0140753967,0.0322981239,0.0,0.0,0.0,0.0309266345,0.0292943129,0.0,0.00727467073,0.09775141300000001,0.147584617,0.06630817,0.0,0.0,0.0156494404,0.073793573,0.0172741239,0.0,0.156647827,0.40644867799999995,0.45401228200000004,0.213131513,0.0,0.0,0.107945119,0.135641123,0.0,0.0,0.14765503800000002,0.610006493,0.8077141529999999,0.629653686,0.417564373,0.43489542600000003,0.45763096799999997,0.14202841800000002,0.0,0.0,0.6985100809999999,1.84073402,2.34147993,2.20873402,2.38877716,3.5504125,5.07692602,5.63443985,4.72116065,3.29705042,2.68815198,3.0969092999999996,3.50522687,2.9864952000000002,1.75028163,0.730807007,0.420323833,0.45747636799999997,0.318933922,0.0334779182,0.0,0.287248545,0.52056149,0.37768025200000005,0.0354240227,0.0,0.0267003369,0.14668399,0.0452489101,0.0,0.0,0.0671456158,0.133122471,0.0,0.0,0.0,0.109287118,0.169659676,0.0810119339,0.0428158508,0.18374844699999998,0.36757442100000004,0.38480842,0.245126101,0.154353716,0.224801282,0.33850607899999996,0.340358383,0.262100984,0.256943562,0.35867541700000005,0.42292698100000004,0.327804505,0.139164716,0.0151945252,0.00426661845,0.019244597,0.0,0.0,0.0,0.0366747494,0.0297680608,0.0,0.0,0.00287173425,0.0450664324,0.019489552900000002,0.0,0.0,0.0161294768,0.0420909113,0.00507052574,0.0,0.0,0.0172826846,0.0147999631,0.000872988296,0.0609555531,0.18708650300000002,0.24938123,0.173956759,0.0851840216,0.173013374,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.71378482,1.48214357,0.0,0.0,0.0,1.92615304,4.34919072,4.75655947,3.98941072,3.37300387,0.0,0.0,0.0,0.0,0.0,1.5262128000000001,0.822113488,0.005558985210000001,0.655477795,0.0,0.1218711,0.0,0.0,0.0,0.7448114659999999,0.0,1.43338345,0.0134583699,2.24071076,0.0,0.769625827,0.0,1.05403423,0.0,0.39377782200000006,0.9818328959999999,0.0,3.58425336,0.219633595,1.17447711,1.7599803,0.0,0.0,0.0,0.19011088399999998,0.0,0.968314384,0.8445802929999999,0.0,0.0,2.25482661,0.643396184,0.36361128600000003,0.690731792,0.0,0.0,0.0,0.608330716,0.0,0.0,0.19034707399999998,0.848593553,0.45553120399999997,0.0,0.297448449,0.0,1.57039968,0.0,0.0,0.0,0.0,0.0,0.0,0.0773290548,0.776603699,0.0,0.0,0.0,1.14384983,2.40747219,3.99438551,4.66469761,3.88799117,1.23391535,0.0,0.0,0.0,1.63211019,0.0,0.798233298,1.30921413,0.17351018,1.10489509,0.0,0.35796056299999995,0.0,0.0,0.7226167259999999,0.0,0.0,0.0,0.5256754570000001,0.6911695090000001,1.23819577,0.7857035990000001,0.0,0.54787182,1.85490139,0.0,0.0,0.926301567,0.0,1.68054408,4.91771956,2.33146649,1.62851011,1.48667124,1.37263716,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.412170972,0.27358395399999996,0.368248459,0.547167909,0.772012301,1.00314117,0.848721035,0.182389303,0.0,0.0,0.391055837,0.0911946515,0.0,0.0911946515,0.8925802709999999,0.8207518629999999,0.0935315632,0.0,0.46146945799999994,0.182389303,0.0,0.182389303,2.68684741,4.19495397,2.7065181000000003,0.0,0.0,0.0,0.585031335,2.1149248400000001e-16,0.0,0.455973257,1.56925127,1.82389303,1.28100555,0.63836256,0.218715212,2.87989765e-16,0.0,7.199744129999999e-17,0.0100599811,8.63969295e-16,0.021676280200000002,2.15992324e-16,0.0,0.0,0.118891328,0.0,0.0,0.0911946515,0.8252730420000001,1.09433582,0.7056423140000001,0.8207518629999999,2.03562005,2.91822885,1.93849186,1.79993603e-16,0.0,0.0,0.494608025,3.95985927e-16,0.0,0.0,0.339259776,8.09971214e-17,0.0,0.0,0.285934535,2.15992324e-16,0.0,8.99968016e-17,0.268265775,0.0,0.0,0.0,0.276130598,0.0,0.0,3.14988806e-16,0.328756887,0.0,0.0,0.0,0.8161603829999999,0.911946515,0.304425535,1.4399488300000002e-16,0.300185724,0.547167909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.20215967,0.250134027,0.280564932,0.285088498,0.26065907,0.209791373,0.13984833300000002,0.061537137699999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0568270624,0.109519054,0.147212701,0.16471397599999998,0.16100435800000001,0.139357639,0.106690416,0.07226655629999999,0.0459853353,0.0365521376,0.049848566600000005,0.08778298080000001,0.147819547,0.22326816100000002,0.30428874,0.379443055,0.437535548,0.46943652700000005,0.469584483,0.436918201,0.375084452,0.291887448,0.198071623,0.105638945,0.0259777119,0.0,0.0,0.0,0.0,0.0,0.0406175331,0.0834984587,0.113962348,0.125291822,0.11449497900000001,0.0827524494,0.0351496308,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.054051447999999995,0.113310909,0.15855234,0.18315399,0.18397436600000003,0.161833108,0.12130760800000001,0.0698830722,0.016605933,0.0,0.0,0.0,0.0,0.0,0.0,0.030225673999999998,0.0627145803,0.08297095139999999,0.0869421537,0.0744078323,0.0492861981,0.0191691829,0.0,0.0,0.0013700433199999998,0.0496156125,0.131448824,0.243064812,0.37521674200000005,0.514201975,0.643654586,0.746890872,0.809451321,0.821434525,0.7792354340000001,0.686381613,0.553295661,0.39597932,0.23378881699999998,0.0866234971,0.0,0.0,0.0,0.0,0.0,0.0646748188,0.155192111,0.228962743,0.269658296,0.26684784699999997,0.217912981,0.128711543,0.012837465900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11118256,0.269577693,0.396001504,0.464280335,0.455613695,0.36240552,0.19065547600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.402762014,1.04055238,1.73803727,2.43515992,3.06896338,3.58104099,3.92458604,4.07010674,4.0090407,3.75477915,3.34095626,2.8172251,2.2430789,1.68053506,1.18664628,0.806816365,0.569777228,0.484847267,0.5417724079999999,0.713096622,0.958668003,1.23160736,1.48488669,1.67760787,1.78014335,1.77748624,1.67042926,1.47450819,1.21696038,0.9322173509999999,0.656635172,0.423244031,0.257260959,0.172966703,0.172323841,0.24544386899999998,0.37273740000000005,0.528344092,0.684271128,0.814593164,0.899090084,0.92581433,0.892265698,0.8050775090000001,0.678348024,0.530949786,0.383288267,0.254041002,0.157383472,0.101105819,0.0858640995,0.105618756,0.149122488,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0724804451,0.0,0.0,0.228046949,0.6957902109999999,0.758512535,0.585378806,0.605712779,0.929838935,1.14201483,0.777539798,0.0,0.0,0.41255250299999996,2.24103345,4.01034526,4.58262767,3.75425604,2.37076694,1.49109367,1.45796959,1.7622465,1.72346728,1.19918711,0.6129938229999999,0.389543414,0.49006644299999996,0.5335230870000001,0.284510327,0.0,0.0,0.0,0.139242104,0.16849396100000003,0.0,0.0,0.0,0.0696663859,0.136316275,0.030390234300000003,0.0,0.0,0.027248511800000003,0.113575143,0.0538834444,0.0,0.0,0.0,0.0948264706,0.0717216334,0.0,0.0,0.0,0.09063030400000001,0.131372249,0.0597038998,0.0,0.0,0.032932292200000005,0.0577225108,0.007043040770000001,0.0,0.0,0.020000344,0.056395034299999994,0.0202562868,0.0,0.0,0.00287663919,0.0252522333,0.00571076433,0.011250938500000002,0.09882582849999999,0.207155941,0.212079833,0.109811011,0.0864082276,0.325871487,0.738999315,0.9591458740000001,0.691625582,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.185368742,0.0,0.0304160988,2.1477112000000003,0.0,0.0,1.30407963,0.0,0.569956,0.0,0.0,0.099847715,0.0,0.132531906,0.0,0.036069076,0.0,0.760845078,0.308118173,0.0,0.198215872,0.12739794599999998,0.0,0.223676805,0.424250809,0.0,0.0,0.586089387,0.0,0.33413044,0.651737221,1.60782998,1.16374776,0.72479846,0.0,1.19887619,3.4614997000000005,3.71841069,2.69867602,0.6866731979999999,0.330758278,0.486696411,0.9630637409999999,1.33272584,0.477903696,0.013211216299999998,0.820602088,0.525585376,0.550673647,0.266083209,0.777685924,0.335213431,0.0,0.508784156,0.0,0.154045299,0.755850096,0.7757586890000001,0.0,0.505278638,0.36164251,0.0,0.0,0.943567884,0.0,0.42708418299999995,0.14491162900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.14569279300000001,0.11817422699999999,0.0927964113,0.07094143809999999,0.0534725969,0.0407226348,0.0325317358,0.028327647400000003,0.0272369839,0.0282145515,0.0301766844,0.032125097000000005,0.0332495192,0.0330001856,0.0311247774,0.027668315899999997,0.0229383795,0.017441501499999998,0.011799367199999999,0.00665522707,0.0025816170699999997,3.72253887e-16,0.0,0.0,0.00210465509,0.00520453724,0.00857121032,0.0114853092,0.0132420523,0.013244302900000001,0.0110869208,0.00662245391,5.211554419999999e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,5.211554419999999e-16,0.018195801,0.0367348404,0.0539179822,0.06802002830000001,0.0774534381,0.08093035400000001,0.077607364,0.0671982292,0.0500420241,0.0271176271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.19121244e-15,0.042187151500000006,0.08346590870000001,0.12025366400000001,0.149135779,0.167169306,0.17216305699999998,0.162908616,0.139339825,0.102603297,0.055029257000000005,3.72253887e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0814764679,0.162476852,0.23708903899999997,0.299941776,0.34677608299999996,0.374971265,0.38397950000000003,0.375627289,0.35424979700000003,0.326634898,0.301766844,0.290374048,0.304300432,0.355734079,0.45633935299999995,0.616348393,0.843673874,1.14310682,1.51566055,1.95811481,2.46280269,3.01766844,3.606607,4.21007731,4.80596311,5.37063704,5.88016922,6.3116097,6.64426747,6.8609065000000005,6.94878281,6.90045479,6.71431228,6.394786799999999,5.95222477,5.40242706,4.76587886,4.0667138,3.33147331,2.58773481,1.86269116,1.18176621,0.567348993,0.0377208555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,7.07282386e-16,0.20064312199999998,0.366480058,0.48849280700000003,0.561574635,0.584557455,0.55998024,0.493626739,0.39387519600000004,0.270913691,0.135881597,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08885132119999999,0.165736529,0.225318579,0.263888662,0.27956017,0.272314018,0.243899753,0.19760755100000002,0.137935282,0.0701815922,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0580082179,0.112183395,0.159359817,0.197116658,0.223901806,0.239077892,0.24289218,0.236378155,0.22120181100000003,0.199469449,0.173515935,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.515876479,0.681608793,0.890026173,1.1191178,1.33012512,1.47714337,1.52071922,1.44103974,1.24616834,0.9722278129999999,0.67500435,0.41528829899999997,0.242407995,0.181105395,0.225885495,0.34456616700000003,0.489758572,0.614427188,0.686384667,0.69700924,0.6614849079999999,0.6107730570000001,0.578338507,0.586414536,0.636700692,0.708809226,0.767053657,0.773242028,0.701006811,0.546609857,0.332315538,0.100940495,0.0,0.0,0.0,0.0,0.0,0.0914966942,0.191273899,0.220672411,0.172254235,0.065386084,0.0,0.0,0.0,0.0,0.0,0.0358848776,0.140790218,0.194753911,0.179417178,0.100849651,0.0,0.0,0.0,0.0,0.0,0.0,0.102868444,0.179118795,0.19206509100000002,0.136741853,0.0321956135,0.0,0.0,0.0,0.0,0.0,0.06841456,0.17618466800000002,0.22989717199999998,0.211824425,0.12883181300000002,0.0100227274,0.0,0.0,0.0,0.0,0.021427453500000002,0.154479072,0.26260358300000003,0.320203335,0.3223913,0.285871355,0.241642611,0.222186032,0.247873415,0.317735361,0.408253001,0.480980973,0.49655991899999996,0.430198855,0.282925052,0.08415870550000001,0.0,0.0,0.0,0.0,0.0,0.0744510727,0.23063960000000003,0.30569751100000003,0.27251414399999996,0.141817883,0.0,0.0,0.0,0.0,0.0,0.00490679847,0.167542941,0.251791416,0.226614956,0.117179945,0.009016770799999999,0.0306936054,0.317902794,0.968395737,2.00124678,3.33397868,4.78683285,6.11596373,7.06871423,7.44699237,7.16139029,6.26028541,4.92448676,3.42734085,2.06992415,1.10817461,0.69138051,0.828524182,1.39135445,2.15291366,2.85049876,3.25549795,3.23106193,2.76249322,1.9533276999999998,0.989906403,0.0859051017,0.0,0.0,0.0,0.0,0.0,0.27099259800000003,0.520350683,0.562467818,0.412208375,0.143213061,0.0,0.0,0.0,0.0,0.0,0.06953239929999999,0.24444181899999998,0.320844974,0.281417531,0.149198238,0.0,0.0,0.0,0.0,0.0,0.0,0.12327512300000001,0.20263562899999998,0.206744802,0.139447454,0.028866942200000002,0.0,0.0,0.0,0.0,0.0,0.0528037429,0.122190873,0.143838591,0.114125992,0.047922674900000004,0.0,0.0,0.0,0.0,0.0,0.06952742519999999,0.153784017,0.231482285,0.306864231,0.39526584600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
6.14002434,5.67930029,5.1283804,4.51198717,3.85726926,3.19216137,2.54372449,1.936582,1.39155855,0.924612289,0.546127489,0.26060727300000003,0.06677514799999999,0.0,0.0,0.0,0.0167373824,0.110850688,0.214087864,0.31140223100000003,0.39042643200000005,0.442168634,0.461396975,0.44669958299999996,0.400233888,0.327203276,0.23511940399999998,0.132923269,0.030046261600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.017419264,0.0798121254,0.130792855,0.165651105,0.181480222,0.17738624100000003,0.154500345,0.115799931,0.0657606813,0.00987671701,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0217144239,0.0752826147,0.1216222,0.155732776,0.173743211,0.17330062699999998,0.153824244,0.116601643,0.0647189323,0.00283073752,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0589533759,0.183466403,0.317227489,0.452530665,0.5813815379999999,0.696070376,0.789721364,0.8567761759999999,0.893375872,0.8976136090000001,0.869641242,0.811624439,0.727552768,0.6229221460000001,0.504316443,0.37892207299999997,0.25401363,0.136449854,0.032217282400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.009657547640000002,0.0503031785,0.08229044740000001,0.10319471699999999,0.111797801,0.108114155,0.0933131157,0.0695474428,0.0397057242,0.0071119910400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.010037983,0.0376043366,0.0610304882,0.0778638684,0.0863188503,0.0854551808,0.0752768272,0.0567413325,0.0316777202,0.0026192321300000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0176456837,0.0542375337,0.08714415560000001,0.112545245,0.127133332,0.128476752,0.115322867,0.08781078169999999,0.047569432300000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0696499449,0.19980576,0.343798214,0.493790854,0.641049183,0.776564475,0.8917234390000001,0.9789699940000001,1.03240422,1.04826704,1.02526708,0.9647184540000001,0.8704729859999999,0.748647697,0.607165793,0.455145876,0.30218816800000003,0.157616771,0.0297424087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0126433731,0.0465833367,0.06761455429999999,0.0765465588,0.077303816,0.0768598679,0.0848759156,0.113058529,0.174275808,0.281493541,0.44661082,0.679286484,0.985852574,1.36840801,1.82417507,2.34518349,2.91832348,3.52578158,4.14584349,4.75401964,5.32442238,5.83130316,6.25064296,6.56168312,6.74828575,6.80002336,6.71291636,6.4897615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.17347050600000002,0.48724027299999995,0.830091143,1.19350666,1.56803664,1.94362681,2.30997657,2.65691067,2.97474998,3.2546663,3.489007,3.67157604,3.79786017,3.86519085,3.87283545,3.82201392,3.71584053,3.55919289,3.35851399,3.1215554,2.85707227,2.57448278,2.28350606,1.99379325,1.71456689,1.45428298,1.22032932,1.0187716999999998,0.854157897,0.7293864259999999,0.645644429,0.602416156,0.597560355,0.627452103,0.687181933,0.7708027559999999,0.871613249,0.982464964,1.09607967,1.20536322,1.30370257,1.38523377,1.44506998,1.47948065,1.48601538,1.46356841,1.41238243,1.33399312,1.23111837,1.10749861,0.9676965209999999,0.8168662259999999,0.660503078,0.5041857989999999,0.35332283600000003,0.212914267,0.0873396963,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012799400800000001,0.0760896383,0.13538734300000002,0.187214191,0.22866835800000002,0.257546338,0.27242679,0.272713306,0.258635037,0.231206188,0.192147382,0.143773685,0.0888556241,0.0304607327,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0141484701,0.0660321235,0.11397759699999999,0.155435877,0.18822801100000003,0.210656266,0.221589133,0.22051605600000002,0.207569311,0.18351217,0.149694233,0.107976454,0.0606299529,0.0102140118,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0168813492,0.0665706075,0.11276465,0.152976984,0.18503351699999998,0.20718838,0.218217622,0.217485857,0.20498226100000003,0.18132393300000002,0.14772628699999998,0.105941845,0.0581704412,0.00694534703,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.022130924,0.0765890462,0.12743079699999998,0.171839183,0.207311675,0.23180230300000002,0.243842442,0.242633569,0.228106605,0.20094401399999998,0.162562703,0.115057666,0.0611083468,0.0038516004299999993,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00021120320100000001,0.0858826393,0.1786095,0.274024337,0.367364787,0.453693333,0.528135063,0.586122732,0.623637778,0.63743583,0.625245619,0.5859311429999999,0.519608355,0.427709465,0.312990182,0.179477668,0.0323596159,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.283539414,0.0895206975,0.222632688,0.674533061,0.378251441,0.505168966,0.48706972299999995,0.6858718570000001,0.457632582,0.24164335399999998,0.19857109899999997,0.344749645,0.387028827,0.507070848,0.125924699,0.53245989,0.58432082,0.420140933,0.486864489,0.246325833,0.183266277,0.326204985,0.391783365,0.23698442399999997,0.0,0.0,0.08813921109999999,0.0,0.0,0.233672977,0.203055785,0.0,0.0,0.219285187,0.0,0.256657855,0.0,0.061950457699999996,0.0,0.171331176,0.0,0.0844372194,0.110836895,0.0,0.0778892184,0.0,0.0,0.410793705,0.23997715600000002,0.388465846,0.33419045399999997,0.704713239,0.6172893110000001,0.599750465,0.485476616,0.35183791299999995,0.598961804,0.413936734,0.0,0.0,0.142311775,0.0,0.143861955,0.0,0.191454912,0.119560174,0.065483807,0.23618251,0.317816899,0.09109528759999999,0.0,0.0,0.232832805,0.09097698789999999,0.00836101753,0.0,0.0,0.0,0.0,0.0,0.047383502,0.0,0.178489593,0.270757872,0.67968289,0.383580945,0.7596354190000001,0.8524932590000001,0.724919421,0.610883325,0.436358184,0.511021185,0.0143174575,0.0390814606,0.0185430218,0.0,0.0,0.0,0.0,0.0,0.0663419188,0.202886705,0.9737393320000001,1.29060621,1.66373144,1.65506921,2.07393733,2.43855177,2.03840475,2.19596403,2.10514465,1.96336663,1.73312924,1.52613997,1.10612668,0.826803104,0.6709285070000001,0.187218783,0.310229072,0.0,0.138718658,0.23595297699999998,0.24991767899999998,0.38936680100000004,0.29722196,0.788442911,0.841153998,0.437012096,0.505320873,0.6444768470000001,0.42485948100000004,0.37620241,0.40174378299999997,0.449658415,0.38926014,0.21124672100000003,0.266224266,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.308941958,0.0,0.179668388,0.0,0.11009019699999999,0.0400082724,0.0,0.0,0.0,0.0,0.0,0.358982742,0.479606745,0.676065668,1.12738104,1.4227077,1.71858605,2.19551163,2.59435494,2.43266845,3.11082742,2.99302577,3.12565978,2.99827064,2.34656972,2.37354036,2.12655855,2.29047735,1.6667351000000001,1.87044718,1.78902352,1.46412387,1.82725606,1.8391438000000002,2.24621124,2.13159906,2.07329856,2.35854624,2.10314484,2.05937034,2.3442041000000002,2.33446931,1.78890031,1.73217625,1.12980778,0.917113765,0.7088938709999999,0.719779374,0.332955323,0.0639359642,0.0,0.165254231,0.0,0.156504225,0.0,0.0,0.051465053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0200806879,0.679170462,1.11402633,1.07378069,0.518009471,0.0,0.0,0.0,0.0,0.110861437,1.7436452,3.39847246,4.59971975,5.01386261,4.55841178,3.4157129999999998,1.95238115,0.581270312,0.0,0.0,0.0,0.0,0.057485973899999994,0.326987773,0.37824146,0.245167971,0.0322047445,0.0,0.0,0.0,0.0,0.059882406799999996,0.12572997800000002,0.119741309,0.0592568396,0.0,0.0,0.0,0.0,0.0,0.0358109852,0.050864765,0.0393421474,0.0116309432,0.0,0.0,0.0,0.0,0.0066603244499999995,0.024335783700000002,0.0305811993,0.0219660541,0.0,0.0,0.0,0.0,0.0,0.058145656,0.17274532,0.302350164,0.411949356,0.464429255,0.434983279,0.32340248899999996,0.158021889,0.0,0.0,0.0,0.0,0.0,0.0792150886,0.138745289,0.126961044,0.0528841374,0.0,0.0,0.0,0.0,0.0145583601,0.0959511314,0.127199675,0.0935500108,0.013808758300000001,0.0,0.0,0.0,0.0,0.0374544085,0.0775844519,0.0665655279,0.023514092900000002,0.0,0.0499537105,0.203261658,0.433936851,0.664690514,0.795034675,0.747293935,0.508459899,0.14617950300000002,0.0,0.0,0.0,0.0,0.09985051539999999,0.368141645,0.454141788,0.309990899,1.22515397e-15,0.0,0.0,0.0,0.0,0.272920697,0.556979375,0.572272955,0.28319845899999996,0.0,0.0,0.0,0.0,0.050928624900000004,0.6982688159999999,1.08037192,0.9356298009999999,0.224168847,0.0,0.0,0.0,0.0,1.05493874,3.82081645,6.65129587,8.76016419,9.53023025,8.73215501,6.6073057,3.78185183,1.04551935,0.0,0.0,0.0,0.0,0.609252689,1.49534583,1.91117225,1.92190785,1.78261323,1.77787368,2.06530876,2.59491384,3.13743639,3.40305073,3.19032698,2.49321138,1.51515058,0.5839138620000001,0.00720377517,0.0,0.301469608,0.847027485,1.25225469,1.27945603,0.882660935,0.22651212199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23399999999999999
0.157180326,0.107966986,0.0841621761,0.24575053800000002,0.6479098529999999,1.14343359,1.44017358,1.29475575,0.7071770890000001,0.0,0.0,0.0,0.0,0.643493466,1.04832048,1.03579405,0.731823772,0.443693335,0.41626001799999995,0.655028993,0.9458163359999999,1.04403008,0.875178652,0.584981634,0.40345798899999996,0.44072269700000005,0.58888223,0.617407271,0.387612433,0.00665860079,0.0,0.0,0.657902715,1.48117393,2.04494869,2.11299519,1.8148325,1.55960262,1.7293961,2.37529888,3.14830717,3.5281854,3.19003102,2.24015759,1.14554903,0.40841164399999996,0.228661508,0.406200943,0.552058892,0.439923736,0.21848924,0.307984458,1.04686923,2.35452852,3.67924552,4.29958932,3.78706819,2.31040051,0.563001789,0.0,0.0,0.0,0.671851005,1.2395999,1.19164973,0.6907884870000001,0.144312395,0.0,0.0,0.158672226,0.241709783,0.11556110000000001,0.0,0.0,0.0,0.0382877389,0.18960734399999998,0.17524783300000002,0.0202948553,0.0,0.0,0.0,0.0801734545,0.135672551,0.0738732378,0.0,0.0,0.0146788634,0.12023506,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5128844370000001,0.0,1.23009169,0.696902294,0.859567162,1.8634838,0.542194339,0.0,0.0,0.0,0.22733717399999998,0.280019209,0.0,0.14977731,0.0627879046,0.0,0.0292176671,0.0,0.0954117956,0.0,0.896551843,0.0161099341,0.0,0.0,0.0,0.0,0.0,0.9002117279999999,0.408051345,0.617467118,0.21426189399999998,0.0,0.37350522799999997,1.41632627,1.02616725,0.206469,0.0,0.593201228,0.49499300700000004,0.454655937,0.283883924,0.0,0.640348906,0.0,0.0,0.0,0.0,1.91148437,1.41555559,1.58963868,3.65647167,1.95629434,2.61282207,2.26011011,2.57239741,3.43533185,3.0923655,0.0,0.0,0.0,0.49269190799999996,0.10870567,0.0490403436,0.0,1.27642243,0.0,0.0,0.71756379,0.8133179009999999,0.9411802490000001,0.703831746,0.0,1.14699714,0.9246284290000001,0.0,0.0,0.0,0.0,0.0,0.28041015399999997,0.9725109390000001,0.341271968,0.10399577,0.571527094,0.0,0.0,0.0,1.63324494,2.58057023,0.593079049,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.30373718,4.03240477,0.0,0.0,0.6548793039999999,0.0,0.0353246544,0.26133446899999996,0.0,0.13322715400000001,0.0648226621,0.0,0.11182595199999999,0.0,0.0,0.0344681642,0.0,0.0053435952399999995,0.0,0.0675662001,0.0,0.0,0.09673049880000001,0.0276494204,1.03448436,1.40331953,0.0,0.212369627,0.7380057440000001,0.533095969,7.15314295,13.325472099999999,8.35722762,2.07112532,0.7707985709999999,0.0778506404,0.13398133199999998,0.0,0.16630208900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
1.21767689,0.677867925,0.261726356,0.0654549932,0.151022897,0.531280874,1.16408397,1.95717434,2.78332354,3.50300007,3.99012513,4.15570934,3.9645193999999995,3.44134456,2.66561249,1.75555847,0.845334308,0.0598683093,0.0,0.0,0.0,0.0,0.0,0.0,0.25299297800000003,0.43574851200000003,0.483352632,0.40422346600000003,0.23531055399999998,0.029875284300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.108594564,0.205505585,0.249049308,0.238841329,0.188968722,0.122664205,0.0651632501,0.0367947241,0.0481026649,0.0980879909,0.17571704300000002,0.26393987,0.344839,0.404341481,0.43519707399999996,0.437548791,0.41719944600000003,0.382376027,0.34021117100000003,0.294184851,0.24340420699999998,0.183963829,0.11191891400000001,0.026835797400000003,0.0,0.0,0.0,0.0,0.0,0.0,0.135895527,0.376310463,0.635282804,0.874546994,1.05608783,1.15001599,1.14105416,1.03203184,0.8434767009999999,0.609326901,0.369734674,0.162643597,0.0161151594,0.0,0.0,0.0,0.0656656194,0.139630707,0.18928067899999998,0.202323561,0.178586622,0.128497168,0.0688071721,0.0168967376,0.0,0.0,0.0,0.00960609585,0.0209522716,0.0124580728,0.0,0.0,0.0,0.0,0.0,0.0,0.0809550609,0.286179246,0.5282916679999999,0.7732038170000001,0.982637819,1.12203756,1.16790159,1.11279695,0.966873196,0.7555471509999999,0.513953426,0.27951798,0.08442252369999999,0.0,0.0,0.0,0.0,0.0,0.0213045177,0.0594157376,0.07346647860000001,0.06488874730000001,0.0416098489,0.014399839099999999,0.0,0.0,0.0,0.0,0.00132608018,0.00357339062,0.0,0.0,0.0,0.0,0.0,0.0,0.012827426299999998,0.0552733641,0.09151503400000001,0.107898044,0.09438828199999999,0.0484604198,0.0,0.0,0.0,0.0,0.0,0.0,0.0398109504,0.205639885,0.371463964,0.503667132,0.574232276,0.568391353,0.489653916,0.36077340700000005,0.22014031899999997,0.11419091699999999,0.08741723539999999,0.17220523,0.380844051,0.701600771,1.09984302,1.52403561,1.9153174,2.21855421,2.39245712,2.41662223,2.29411171,2.04926077,1.72149102,1.35676885,0.998766162,0.681676128,0.426062738,0.238252517,0.112852466,0.037246844,0.0,0.0,0.0,0.0,0.0,0.0,0.000855492031,0.00795258064,0.008086458959999999,0.00106899219,0.0,0.0,0.0364768653,0.134616695,0.314692824,0.589295125,0.953866518,1.38237674,1.82757713,2.22672825,2.51237005,2.626316,2.53396036,2.23551067,1.77107865,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.284615988,0.23371477,0.0,0.0229885922,0.0,0.08942908140000001,0.0,0.327310615,0.0,0.263724988,0.345450961,0.0,0.0500998363,0.0,0.0,0.331827366,0.0,0.395089983,0.480555487,0.44723557399999997,0.159557966,0.425356665,0.497587039,0.36089839100000004,0.527426406,0.8464789629999999,0.891670455,0.787117912,0.7828535740000001,1.17065472,1.54390572,1.39270524,1.58060194,2.11875293,2.30106807,3.13528693,3.21315023,3.84168288,3.64662913,4.15248436,3.77933246,3.61105929,3.44952168,3.55145969,2.63296107,2.4635482000000004,2.08317277,1.6831658,1.19976764,0.486059305,0.795445431,0.36371268,0.00093402987,0.0453893104,0.0,0.0,0.0,0.370170327,0.120662424,0.628150681,0.0845443785,0.0473922642,0.0,0.0,0.0,0.395690135,0.26833218,0.20397425600000002,0.29663665100000003,0.0783759251,0.309708769,0.35025895,0.10386341,0.779050755,0.22442437,0.0,0.234335102,0.0,0.307712069,0.243108651,0.0,0.0,0.10384286699999999,0.0,0.0922180008,0.37116959899999996,0.0,0.347673886,0.537421218,0.0,0.0,0.142327166,0.0630903767,0.0,0.128981559,0.322473286,0.0683804253,0.621906988,0.12201311599999999,0.568981556,0.304733201,0.162264968,0.258987841,0.35497290200000003,0.24343827699999998,0.06816033120000001,0.0694036551,0.0,0.0,0.0818899313,0.0,0.134367452,0.0643925778,0.0663761561,0.0,0.23402230899999998,0.0,0.34669965799999997,0.0,0.0,0.0,0.267496277,0.187754659,0.228902042,0.0,0.0,0.0,0.0,0.0736835506,0.0,0.0,0.35710041600000003,0.161760878,0.623216497,0.0,0.172317597,0.189081915,0.060519879699999994,0.28171109699999997,0.10875337300000001,0.0486315509,0.0,0.130219342,0.34813292100000004,0.190212028,0.18867186100000002,0.0,0.0,0.0,0.0,0.309502447,0.0,0.15280308,0.0925398925,0.0071072183999999995,0.240792443,0.0,0.0,0.0,0.0,0.298428535,0.0,0.0,0.333637754,0.161465966,0.0,0.17095896600000002,0.0,0.0,0.32140741,0.0,0.0,0.0932518655,0.215130655,0.10219024,0.0571919385,0.048833904000000004,0.38812472299999995,0.366262277,0.0,0.294405121,0.0,0.0,0.0,0.101163487,0.0,0.0,0.0,0.12230371599999999,0.112245724,0.0,0.0,0.0,0.132663319,0.061340724299999996,0.106349995,0.59983682,0.24888237600000002,0.576136369,0.155108892,0.6694040960000001,0.0783284998,0.0,0.485696484,0.287740873,0.0,0.205007551,0.127336543,0.0,0.32936894,0.48182463799999997,0.0,0.285243536,0.0,0.0,0.21589785,0.0,0.18160766399999997,0.0,0.0,0.277817731,0.27264076800000003,0.171251189,0.169220112,0.0,0.213306656,0.312830868,0.348344505,0.148567157,0.43204747,0.381146592,0.40752758899999997,0.263220519,0.0,0.12772244,0.12432293900000001,0.158625219,0.0,0.0,0.0,0.062487929500000004,0.519721961,0.0777935077,0.295965959,0.05323926650000001,0.384817045,0.278441817,0.0,0.170395078,0.0,0.308897592,0.141053619,0.212493569,0.0,0.0,0.159919397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.25200379100000003,0.0,0.7926623759999999,0.0,0.0,0.0979982604,0.0,0.0,0.0,0.0,0.380627647,0.0,0.266904004,0.884482422,0.0,0.34674931600000003,0.0,0.0,0.0,0.698469793,0.671373563,0.0,0.0,0.0,0.0,0.309505982,0.0,0.5949200179999999,0.0,0.664833613,0.00257841335,0.146525495,0.0,0.0,0.021427059,0.0,0.60701681,0.0,0.0,0.0806849419,0.0956239606,0.36076029600000004,0.0,1.01663922,0.0,0.127516858,0.0,0.0,0.0,0.688735475,0.0,1.26290437,1.70175862,1.00436333,0.698658028,0.111164394,0.0,0.0,0.41772173700000004,0.746879395,0.653423686,0.8490871240000001,0.0,0.0,0.340861645,0.0,0.964035037,0.178663787,0.0,0.7886481809999999,0.0,1.09383417,0.935804503,0.0,0.31731559800000003,0.400891139,0.0,0.115436532,0.693214364,1.3345972,0.868045486,1.35886668,1.68725793,1.23373021,0.324715686,0.283107937,0.0,0.023651336600000003,2.21984728,2.78804146,3.11684014,3.59026309,2.53393375,0.588823813,1.09594333,0.0,0.0,0.0,0.0,0.295715964,0.672172048,0.0,0.0,0.0,0.0,0.115790961,0.0743234728,0.0,0.0,1.4968788999999998,0.126690009,1.02990158,0.0,0.989953566,0.0,0.230410084,0.0,0.283429796,0.0,0.0,0.0,0.0,0.0,0.0,1.14030251,0.362664747,0.049216176699999996,0.281903809,0.0,0.0,0.49871194700000004,0.0,0.46324758200000005,0.0,0.0,0.0,0.0101673709,0.665382124,0.0,0.686633553,0.0,0.08674933580000001,0.178989693,0.0,0.49950952600000004,0.44936979200000005,0.0,1.05961889,0.045568141799999996,0.179360183,0.15575888300000001,1.19883493,0.0,0.32380437,0.0,0.129829673,0.200903891,0.11191751800000001,0.0,0.0,0.9276462999999999,0.394897503,0.0,0.99729354,0.0,0.255095974,0.0,0.0,0.0,0.642413572,0.25607830600000003,0.558846032,0.675908375,0.0,0.0,1.12132428,0.406292974,0.0,0.0,0.700039889,1.44254318,0.110787296,0.0,0.0,0.0,0.060863099000000004,0.0,0.0,0.0,0.5690493320000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.39697784799999997,0.214897557,0.9359924390000001,0.062451842699999996,0.0,1.11383303,0.130192264,0.391355533,0.110577105,0.018732329,0.611340843,0.0,0.0,0.22209940600000003,1.13047276,2.08093325,2.2927595000000003,2.60012004,3.33448908,2.16835042,2.40336754,2.05128042,2.37566849,2.02715585,1.05145932,1.04826481,0.0,0.0,0.0,0.142754815,0.0,0.0,0.394413963,0.45168404,0.173842837,0.23909519199999998,0.0,0.690686757,0.0,0.0,0.0,0.0,0.0,0.771287287,0.0,0.0,0.0808741326,0.0,0.0,0.048659685300000005,0.0,0.48399692899999996,0.347652694,0.0,0.0,0.852052715,0.0,0.0,0.199439447,0.315085309,0.23755272100000002,0.309285576,0.0,0.196179795,0.122635378,0.0,0.726287237,0.0,0.0,0.0,0.0834563738,0.0106062691,0.0,0.0,0.09074248300000001,0.0,0.0,0.0,1.3546291000000001,0.545735659,0.25576952399999997,0.774693865,0.0,0.0,0.0,0.0,0.7925587359999999,0.0,0.10458603699999999,0.0,0.333466993,0.242904818,0.29667018,0.0,0.0,0.0,0.0,0.0,0.0,0.142397263,0.0,0.0,0.7954090970000001,0.0,0.0,0.6448529000000001,0.538380016,0.48077312200000005,0.69624533,0.11199401,0.0,0.0,0.0,0.0137532994,0.0,0.0,0.0,0.27063934,0.0010605963099999999,0.379494035,0.5088354979999999,0.33735689,1.49042305,1.21438951,2.08716987,1.06311219,1.53508128,1.57178535,1.05713911,0.0,0.825385375,0.12314932699999999,0.0945626016,0.0,0.63185303,0.528592951,0.6795914040000001,0.6346187879999999,0.557382869,0.0,0.0,0.0,0.0,0.0,0.25795355600000003,0.661585599,0.687468574,0.23320949800000002,0.0185318085,0.5886500339999999,0.0,0.0,0.35266331700000003,0.252498954,0.12280538,0.0889542764,0.0,0.0,0.0,0.445377006,0.0,0.0,0.635159887,0.0,0.0,0.0,0.277452495,0.11056975,0.12672676900000002,0.312008616,0.0,0.356839866,0.0,1.19881214,1.13349617,0.379226949,0.393041199,0.43566073899999996,0.390787726,0.24572876100000002,0.0,0.633302845,0.0,0.0,1.03745431,0.324903226,0.0,0.0,0.764556025,0.0,0.307509801,0.167863056,0.22171221300000002,1.05818668,0.909442944,1.37296106,2.30020282,2.1307982999999995,2.88093508,1.42215857,2.98037669,1.40392122,0.790706893,0.9011287029999999,0.0,0.366115261,0.0,0.0,0.0,0.858362431,0.0,0.0,0.0,0.812838872,0.309499833,0.0,0.0,0.515862782,0.0230019142,0.0,0.372070034,1.5992246,0.37729392,0.599476957,0.0,0.0,0.14907762300000002,0.0,0.0,0.22102187399999998,0.0230025621,0.0,1.08148763,0.0,0.0,0.36676163,0.305506338,0.0,0.888858202,0.0,0.0,0.0,0.0,0.20933561399999998,0.0,0.5775179570000001,0.293901775,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.15013826,0.0,0.0,0.0,0.7691297009999999,1.785518,0.0,1.38323666,0.49202808200000003,0.849314825,0.0,0.857107031,0.0,0.0895239511,0.0,1.78812188,0.307164008,1.54918874,0.0,0.0,0.0,0.0,0.0,0.7242880909999999,1.12148399,0.184867483,0.0,1.54115123,0.0,0.0,0.0,0.0,0.497663725,0.0,0.0,0.198799693,0.774203237,1.52097593,1.35924052,0.747255335,0.0,1.61481454,0.563660889,0.0,0.0,1.10886162,1.84485974,0.0,0.0,0.0,0.0,0.606259277,0.199919903,1.4584398,0.0018205460699999999,0.0,0.802910076,0.74623324,0.195949235,0.0,0.40112709999999996,0.0,0.0,1.42942565,1.67920954,0.0177216733,0.0,1.69762775,0.0,0.992540238,0.220770495,1.05484459,0.0,0.0,0.0,1.91806849,0.0,0.0,0.223110855,0.8803347429999999,0.7455272620000001,0.0,0.729276782,0.451022162,1.58959038,0.0,1.98774498,0.0928654934,0.33982997200000004,0.0,0.164204694,0.0,1.7392391,0.0,0.125805748,1.24839747,1.47189053,0.0,0.143654079,0.0,0.8740854140000001,0.611072542,0.0,1.5459139,1.16509082,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.87076625,0.24835324600000003,0.0,0.0,0.651363349,0.0,1.97156537,0.0,0.0,0.46080168299999996,0.7149950759999999,0.665030535,1.33159339,3.83548251,4.78513221,3.78773106,4.03536974,4.88471715,3.77303091,2.13602785,1.12421302,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.104017721,0.6503728329999999,0.0,0.0,0.0,0.11370756300000001,0.0,0.0,1.30804645,0.721166655,0.0,0.0,0.24691452,0.142843683,2.29439506,1.538011,0.7787832790000001,0.665913735,0.0,0.0,0.467182345,0.0,0.0,0.0,1.21624626,0.664067297,0.0,0.0,1.23764447,0.805243932,0.0,0.591550609,1.78988078,0.0,0.731158273,0.0,0.0,0.0,1.52860282,0.0,0.0,1.74621212,3.40535526,4.02716019,0.63806639,0.0,0.0525859512,0.0,0.0,0.9319026359999999,0.0,0.315617317,0.0,0.425945123,0.0,0.297112213,0.0,0.30047636,0.0,0.955977965,0.577007786,0.31685875399999996,0.0,0.0,0.329902384,0.792579356,0.88609219,0.13536510599999999,0.00522893165,0.434837701,0.993956972,0.0,0.0,0.730076807,1.36513691,2.23680852,0.961147298,0.055232225700000005,0.0,0.84279662,0.0881635556,0.0,0.0,1.3488666999999999,1.11306634,1.83233282,0.0,0.0,0.0,0.214168317,0.0,0.0,1.2194014,1.89051418,0.849454888,0.343360437,0.0,0.0,0.575265899,1.34643472,1.52257622,1.80180556,0.52935075,0.471180748,0.522968274,1.41105863,0.211473603,0.0,0.0,1.44053122,0.716930387,1.15645777,0.0,0.783683007,0.0,0.0,1.53709428,1.35147568,0.42383376,0.0,0.0,0.24895071,0.0,0.7142362659999999,0.0,0.0,0.0,0.0,0.724707876,0.0,0.151307801,0.075273215,0.0,1.79190771,0.0,0.6077519060000001,0.0,0.321689316,2.18618927,1.01775099,1.58671176,0.0539860299,1.65223972,0.0,0.0,1.75515128,0.0,0.501007015,1.74956242,0.0,0.840259474,0.718475778,2.67936154,2.11299904,0.783772974,1.20780272,0.528942289,0.0,0.736790446,0.289925731,0.0,0.0,0.0,0.979287867,0.0,1.66113992,0.311672401,0.737486552,0.46527340899999997,0.8808442540000001,0.0,0.0,0.0,0.7959305190000001,0.0,0.312267446,0.0,0.0,0.0,0.0,1.13621214,0.000211987801,0.540080028,0.034447605299999996,0.848490987,0.0,0.38531102899999997,0.0,0.0,1.48501883,1.30047345,0.0,1.37117914,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.13320527,0.0,0.0,2.9418024,0.0,0.0,1.66468872,0.6282436,0.0,0.60684634,1.41518234,0.0,0.0,2.62821466,0.0,0.0,9.18747151,18.59627131,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23399999999999999
1.32543148,0.85113388,1.78967752,0.0,0.91942708,0.65877583,1.53661182,3.44077571,3.47544233,2.7016868,2.88214655,3.36373362,0.73796089,0.84821635,0.49109715,1.29602191,0.26839505,0.36953956,0.12431672,1.38571357,0.0,0.36745829,0.69927866,0.96419385,0.0,0.0,0.0,0.9611379999999999,0.0,0.61298908,0.0,0.0,0.94147172,0.0,0.34182958,0.0,0.0,0.4691619000000001,0.0,0.0,1.5935635000000001,0.20099443,1.54388887,1.05542515,2.51106997,0.54777398,0.76427794,0.0,0.49860496,0.0,0.88860564,0.0,0.74945858,0.0,0.0,0.18648307,0.0,0.23389883,0.0,0.82159509,0.48867868,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.414872235,0.472503539,0.2388275,0.0,0.0,0.238091866,0.0,0.12967398,0.172492841,0.0800436023,0.0,0.013707575,0.219280208,0.210259465,0.335690879,0.17073370699999998,0.0,0.016338421000000002,0.385508643,0.223323834,0.180646433,0.605375432,1.34656532,1.07930473,0.633731629,0.25938924,0.30622165,0.10849117900000001,0.112776263,0.428519692,0.252033662,0.0,0.0,0.286295355,0.0505622582,0.39238323399999997,0.0180455096,0.233275321,0.0,0.311592468,0.0,0.348272965,0.410844786,0.06836405429999999,0.447333708,2.15423757,3.00420376,3.35657977,3.13450008,1.20036601,0.0,0.0,0.0211969152,0.140922805,0.373614847,0.0,0.0,0.56351077,0.811854435,0.0,0.0,0.544251875,3.02160018,4.76473346,3.68824292,1.63212717,0.724969945,0.9536478429999999,1.9704956999999999,1.56426737,0.350604982,0.253098185,0.740951261,0.9986616359999999,0.558599482,0.147898232,0.0,0.0,0.0,0.0,0.0,0.30091715399999996,0.0,0.053927265,0.0,0.0,0.0,0.391720677,0.0918170249,0.0,0.306966686,0.7286368559999999,0.18767294899999998,0.0,0.0,0.333570202,0.901669895,0.56170397,0.566648443,0.312865107,0.144651378,0.0,0.153515392,0.0,0.0,0.0,0.0,0.0,0.0,0.40218583700000005,0.0,0.0,0.363863655,0.240369,0.24670336,0.214780639,0.0,0.0,0.0,0.182794,0.0,0.28745631,0.012877893100000001,0.376735291,0.124824376,0.0,0.084685499,0.29127567,0.0,0.0,0.48048429200000004,0.248888859,0.45552803799999997,0.29947562899999997,0.7979016040000001,0.7544711909999999,1.92947288,1.47954694,1.21049906,0.196932789,0.29522441,0.386338676,0.0464997175,0.11921703,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.00980732233,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.011410654199999998,0.0755335691,0.136814984,0.194319162,0.24721553,0.294787148,0.336437175,0.371693293,0.40021007299999994,0.421769293,0.436278257,0.44376620200000005,0.44437888700000006,0.438371516,0.42610014,0.408011722,0.38463307,0.356558838,0.324438828,0.28896482,0.25085714800000003,0.21085127899999997,0.169684592,0.128083594,0.08675176539999999,0.0463582253,0.0075273933700000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.011205027900000001,0.025840868,0.0386871405,0.04959532690000001,0.0584690078,0.0652638285,0.0699863549,0.0726918702,0.0734811784,0.0724965025,0.0699165812,0.0659510824,0.0608344637,0.0548194204,0.04817006769999999,0.0411550075,0.0340404308,0.027083404300000002,0.020525486000000003,0.014586803999999998,0.009460724509999999,0.00530922063,0.00225903827,0.00039873927900000003,0.0,0.000399981492,0.00223446679,0.00520563963,0.009200608,0.0140709557,0.0196364848,0.025689751,0.032001294900000005,0.0383254566,0.0444066488,0.049985953,0.0548078953,0.05862725480000001,0.0612157531,0.0623684775,0.0619098916,0.059699296299999996,0.055635613,0.0496613715,0.041765803399999996,0.0319869562,0.0204127617,0.00718101556,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0136024135,0.048692201399999996,0.0848681084,0.121511601,0.157964334,0.19353856600000002,0.227528502,0.259222409,0.287915293,0.312921947,0.333590151,0.34931379700000004,0.359545713,0.363809961,0.36171337200000003,0.352956119,0.33734110100000003,0.31478195800000003,0.285309551,0.24907673,0.20636128899999998,0.157566998,0.103222635,0.0439789901,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0290301933,0.181596232,0.345745112,0.5202866970000001,0.7038752709999999,0.8950234429999999,1.09211818,1.2934388,1.4971766000000002,1.701456,1.90435678,2.10393725,2.29825785,2.48540512,2.66351538,2.83079815,2.98555862,3.12621916,3.25133939,3.35963455,3.44999198,3.52148537,3.57338669,3.60517551,3.61654571,3.60740934,3.57789769,3.52835952,3.45935643,3.37165548,3.26621919,3.14419302,3.0068905,2.85577625,2.69244715,2.51861189,2.33606917,2.14668497,1.95236905,1.75505113,1.55665704,1.3590852,1.16418365,0.973728102,0.789401213,0.612773323,0.445285008,0.28823161,0.14274993800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8377416329999999,1.29332248,1.24829084,1.02059238,0.943028918,0.853455518,0.0706124023,0.331814632,0.7657625229999999,0.7749904390000001,0.450902514,0.468665922,0.142079252,0.330265701,0.0,0.0,0.309687832,0.0,0.146298976,0.292807658,0.0288014449,0.0,0.0,0.184290308,0.136187075,0.0,0.0,0.0,0.12470542,0.0,0.0,0.0,0.0,0.0,0.307623126,0.0,0.214532392,0.0684364207,0.0,0.0,0.0,0.175003115,0.0,0.29891001100000003,0.0,0.0241886134,0.0615000474,0.0736578486,0.0,0.302040843,0.40223989200000004,0.403841702,0.0,0.12051054,0.0,0.0,0.0,0.0,0.0,0.36460620200000005,0.0,0.164240705,0.312557569,0.7871568729999999,0.440314455,0.0,0.0164654889,0.130895713,0.0,0.0,0.0,0.0,0.0,0.16183213400000002,0.0,0.275986187,0.0,0.85220463,1.51584765,2.05938948,2.08079982,1.64643088,0.7843536,0.0,0.0,0.0,0.0,0.364688859,0.08434936109999999,0.878572968,1.05474017,1.3590246000000001,0.9509524159999999,1.53607419,1.73038839,1.18449317,0.735311794,0.0,0.11704469,0.448131679,1.65184956,1.91666005,2.5168932999999996,2.46059254,1.44251975,0.842903453,0.35581361799999994,0.0,0.530340461,0.283907809,1.12112262,1.33029826,2.13542356,2.25891574,1.48474739,1.2193361999999999,0.679845522,0.0,0.0,0.0,0.242367818,0.0971296086,0.7281738659999999,0.17735646100000002,0.0,0.0,0.0,0.644905899,1.22641047,1.77352532,1.48141789,1.31412318,0.54237668,0.5435630920000001,0.20038547899999998,0.9418204720000001,1.24972893,1.06213476,0.514823731,0.458046612,1.21170756,1.4516803,1.22486551,0.894468961,0.429153567,0.45500081600000003,0.0,1.27578517,2.35478659,3.11634415,4.47671981,3.68082415,3.3783758,3.05965431,2.32715313,3.2039216,3.39858843,4.30983613,3.9567265,2.39532132,1.21022891,0.526236169,0.18565869699999998,1.16596609,1.2129828999999999,1.07374762,0.6881728290000001,0.0,0.0,0.0,0.0825097632,1.00181119,0.8798103890000001,0.750000185,0.0933789148,0.321902709,0.0,0.0,0.169406522,0.534835642,0.197681253,0.424208225,0.0,0.0,0.32499078600000003,0.16071244,0.904711168,0.53284903,0.38966225600000004,0.0887385764,0.0,0.0974349895,0.5245615370000001,0.0,0.275535063,0.12409394800000001,0.234678012,0.0,0.0,0.386801203,0.213229125,0.0,0.0,0.0,0.33834262,0.0,0.770171523,0.567494884,0.418778559,0.19346125399999997,0.0,0.269736353,0.913796559,0.766202976,1.61830205,1.64984642,2.08446994,2.30989766,1.81879567,0.961938506,0.514720681,0.0,0.0119020794,0.0,0.5183016570000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.809300096,0.702357195,0.667289324,0.642459864,0.56899492,0.41349306700000005,0.182184332,0.0,0.0,0.0,0.0,0.0430615811,0.53796,1.13295912,1.7170218999999998,2.17359211,2.40869301,2.3736037999999997,2.0761562,1.57787797,0.978076458,0.389401438,0.0,0.0,0.0,0.0,0.0,0.0,0.134530074,0.24055348699999998,0.254686631,0.189990893,0.0799163047,0.0,0.0,0.0,0.0,0.0,0.0,0.0504915854,0.0828484392,0.0834849704,0.05848609019999999,0.0211612241,0.0,0.0,0.0,0.0,0.0,0.0,0.00496939382,0.0017418896399999998,0.0,0.0,0.0,0.00842248764,0.0275603361,0.0433679203,0.046318868799999996,0.030363094700000003,0.0,0.0,0.0,0.0,0.0,0.055273048600000006,0.19953220100000002,0.37558335,0.556922791,0.7139510259999999,0.821166356,0.863259023,0.838338855,0.7574283559999999,0.640521162,0.510560088,0.38728501299999996,0.282847758,0.20041572100000002,0.13592447800000002,0.0820574565,0.032799389500000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0448852646,0.088439806,0.106718367,0.0902122939,0.0404184405,0.0,0.0,0.0,0.0,0.0,0.0,0.091643806,0.166339832,0.192041297,0.154579079,0.059905077699999996,0.0,0.0,0.0,0.0,0.0,0.0109753721,0.182015973,0.311679626,0.350322972,0.272679995,0.0892874401,0.0,0.0,0.0,0.0,0.0,0.0668504377,0.483121885,0.857374557,1.07994226,1.0741493,0.823702365,0.385511655,0.0,0.0,0.0,0.0,0.219226533,1.21946168,2.41470946,3.58679524,4.50360406,4.97309073,4.88950729,4.25988414,3.20368563,1.92542024,0.666986125,0.0,0.0,0.0,0.0,0.0,0.189823241,0.674547377,0.9323613829999999,0.9112834759999999,0.6431906510000001,0.22705820399999999,0.0,0.0,0.0,0.0,0.0,0.0143029818,0.31787694,0.501635567,0.516891079,0.369425272,0.114536698,0.0,0.0,0.0,0.0,0.0,0.0368875772,0.259356287,0.39124118799999996,0.394272678,0.271995888,0.0672343728,0.0,0.0,0.0,0.0,0.0,0.05323052599999999,0.23765914800000001,0.342177085,0.335133515,0.22095695,0.038056451,0.0,0.0,0.0,0.0,0.0,0.0686306642,0.233133345,0.32108446399999996,0.304965716,0.190794235,0.0159319192,0.0,0.0,0.0,0.0,0.0,0.08587200210000001,0.241266957,0.318827275,0.293419276,0.172973801,0.0,0.0,0.0,0.0,0.0,0.0,0.10813703,0.263708423,0.33558984,0.299319866,0.165009352,0.0,0.0,0.0,0.0,0.0,0.0,0.141866364,0.310353422,0.38242985799999996,0.331419413,0.169592105,0.0,0.0,0.0,0.0,0.0,0.0,0.20809627,0.42135092799999996,0.5099058160000001,0.434863461,0.206691158,0.0,0.0,0.0,0.0,0.0,0.052484074699999994,0.672683452,1.33928784,1.9293406000000002,2.33827219,2.50508449,2.42529614,2.14837591,1.76085534,1.36037019,1.0283549,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.81911169,5.27716255,4.74542392,4.16575315,3.23945499,2.52607576,1.69000795,1.2709998,0.643311741,0.0,0.0,0.0,0.0,0.10456834599999999,0.30951309,0.17038973,0.12372659,0.0813475491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.575728909,0.221448087,0.22876132600000001,0.694588613,0.920479585,1.08653114,0.299960977,0.300922217,0.31488537,0.634847828,0.829525918,0.542526564,0.720466712,0.7387842090000001,0.697118089,0.11918773099999999,0.254436781,0.332632396,0.38928006200000004,0.0,0.20765784199999998,0.0,0.363027269,0.0,0.0,0.468732272,0.0,0.232044455,0.0,0.6181821129999999,0.363156259,0.339240128,0.0735765976,0.267121764,0.625001459,0.19882267,0.0,0.0,0.145176833,0.410164088,0.0200936546,0.308900836,0.496288757,0.483965835,0.300119637,0.355801415,0.0,0.0,0.0,0.135596263,0.0,0.0,0.360698177,0.0414465035,0.471704291,0.39455871200000003,0.0,0.0,0.413964884,0.13731458,0.141156779,0.024649798900000002,0.0,0.0,0.0,0.06466466950000001,0.312430766,0.0,0.34727947600000003,0.0,0.349026579,0.0,0.0,0.09089437730000001,0.0,0.08340245219999999,0.0,0.446953471,0.0,0.0,0.407257328,0.0,0.0,0.0,0.0,0.410030935,0.0,0.0,0.434125866,0.384116346,0.256107855,0.257306209,0.0,0.0,0.13772953300000002,0.49521697299999995,0.38768754899999996,0.0,0.0,0.0,0.163168976,0.0,0.0,0.0,0.18355524899999998,0.014448198600000002,0.482420873,0.922940938,1.21173147,1.54409834,1.41772549,1.69003257,1.21642744,1.17142881,1.03285884,0.91153123,0.837367898,0.641960788,0.618390435,0.5990561320000001,0.24246221199999998,0.0,0.0,0.0,0.114937678,0.25608822,0.148986051,0.430995358,0.22875934899999997,0.187918155,0.042847065,0.20493431199999998,0.22747567300000002,0.0,0.0,0.0823544569,0.239299277,0.0,0.0,0.345016978,0.46004397799999996,0.46193574200000004,0.0,0.0,0.397658079,0.0,0.133744767,0.0,0.0,0.0,0.176755518,0.0,0.415010958,0.451150292,0.23437819,0.39645489799999994,0.0,0.209344118,0.20811944699999999,0.0,0.0,0.0,0.0,0.130327175,0.5074289470000001,0.0,0.41489031299999996,0.37572524399999996,0.0,0.0,0.227719375,0.47373473,0.0,0.0,0.0,0.0,0.0687515679,0.30455036399999996,0.0,0.264115068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.218289487,0.38322330600000004,0.0734947706,0.201919829,0.0,0.358367441,0.32167451199999997,0.26642420699999997,0.0,0.0,0.0,0.359693282,0.198790859,0.556181469,0.260902446,0.417094179,0.30515506,0.0,0.0,0.0,0.0,0.0576236819,0.0720824841,0.46018475,1.04982379,1.72222028,2.9861816,3.91666652,4.97681862,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.919346262,0.32827324399999996,0.0,1.19279417,0.868422822,1.07748467,0.18083516600000002,0.0,0.434763931,0.0,1.35460454,0.43120685200000003,0.23826296100000002,0.149444419,0.6983271740000001,1.46085718,1.05358991,0.863467312,0.34612808899999997,0.0,0.0,0.0,0.7529042659999999,0.389742308,0.0,0.0,0.0,0.53908712,0.537303057,0.164437735,0.0,0.0,0.0,0.697856105,0.0,0.6752835209999999,0.372298714,0.264140139,0.0,0.931755291,1.03601633,0.542563912,0.0,0.272328257,1.5580294,0.652784561,0.543622069,0.48682475,0.447244745,0.0,0.0,0.16329381,0.0,0.7183218720000001,0.865568467,0.235711781,0.0,0.339469887,0.0,0.190972582,1.29364348,0.07533840559999999,0.0,0.258715137,0.231823453,0.0,0.263287192,0.403576638,0.285086159,1.05279681,0.35136595200000004,0.508782466,1.36530893,1.43973136,1.05098972,0.6283606629999999,1.01059557,1.39055787,0.560211204,0.7534588390000001,1.83815296,0.7860568640000001,1.4943222,1.12997021,2.07565855,1.65984485,0.97725902,1.92588558,2.46184836,1.95643611,1.53355584,0.7480641309999999,0.0734062437,0.184636932,0.29813865300000003,0.165093645,0.0,0.474678765,0.047734513,1.02141549,0.0,0.00319471968,0.445256724,0.0,0.0,0.0,0.16858197,0.0,0.0633439679,1.146525,1.12712754,1.57402046,1.41800426,1.29092613,3.46598715,2.05898711,2.94796636,2.64677944,2.29694539,1.91268746,0.266876493,0.46080774799999996,0.531446468,0.0,0.0,0.0,0.0,0.0,0.0,0.256264461,0.0,0.33458208100000003,1.36179231,1.11018772,0.0,0.836370767,0.9818509879999999,0.916260662,1.15580292,0.220655199,0.0,0.0,0.0575769201,0.0,0.35936179799999995,0.0761161831,0.197495315,0.35052696200000005,0.0,0.0,0.121634473,0.269537739,0.0264046569,0.9501893770000001,0.579692064,0.0,0.0,0.0,0.52900861,0.0,0.410437765,0.048638225199999996,0.0,0.0,0.0,0.123907369,0.324375364,0.0,0.0,0.475553874,0.0,0.0,0.0,0.519906599,0.697356015,0.0,0.0,0.360013549,0.683684108,1.02956709,0.0,0.0,0.0,0.209157258,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.88390654,5.02360311,5.11735043,3.58818878,2.08588285,0.9826502859999999,0.0,0.0,0.0,0.0,0.432341485,0.55003012,0.842252317,0.9091127240000001,0.108351314,0.0432996224,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.278719852,0.202540284,0.0,0.0,0.0,0.0,0.41060640200000004,0.207614777,0.0,0.0,0.235553647,0.597196996,0.106913625,0.355568347,0.329993731,0.0,0.22303139100000002,0.0,0.382522304,0.465900194,0.534668557,0.280086839,0.46234401399999997,0.40328527399999997,0.30501264699999997,0.0,0.0,0.054592923,0.0,0.0,0.0,0.517159072,0.0,0.0112802798,0.0,0.0,0.0,0.42950852799999995,0.38314239899999997,0.133078223,0.0,0.0,0.401237623,0.0,0.0,0.313074573,0.0,0.31591182,0.0,0.45789493600000003,0.023710934,0.0,0.0,0.0,0.0,0.32506639,0.0,0.45921665799999994,0.185501705,0.199919547,0.8860122690000001,0.93209883,0.426916456,1.0880413,0.499597842,1.08341677,0.6469581839999999,1.10474825,1.44641306,0.41516387299999996,0.305518756,0.611726002,0.5052022310000001,0.123590202,0.0,0.0,0.253957303,0.345669446,0.0,0.6331859999999999,0.692813427,0.283557808,0.42148017,0.120655861,0.110912579,0.0,0.0,0.0,0.0,0.0,0.49631981299999994,0.36810775700000004,0.0123438531,0.0402039238,0.192379517,0.0,0.0,0.0,0.1938798,0.9551199309999999,0.0,0.673891967,0.0,0.11937830099999999,0.0,0.0,0.0,0.169065811,0.13995370199999999,0.421347377,0.441002712,0.884551842,0.0,0.0,0.0,0.0,0.0,0.467310706,1.97951003,3.3773915999999997,4.8014864,4.86813836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.163319782,0.795196551,1.40317596,1.7219148000000002,1.63546005,1.22864742,0.7154445209999999,0.301591758,0.07733460589999999,0.00577610319,0.0,0.012104366100000001,0.0807863076,0.275340687,0.6144316679999999,1.01101352,1.29929267,1.3292006,1.06314864,0.606438215,0.14911548,0.0,0.0,0.0,0.0207891337,0.09119978960000001,0.0747085151,0.0136520772,0.0,0.0,0.0,0.005327610450000001,0.005938863050000001,0.0,0.0,0.0159740817,0.0282871604,0.014874651599999998,0.0,0.0,0.0,0.0106322443,0.07130102599999999,0.07946171519999999,0.0193020786,0.0,0.0359136011,0.37692717600000003,1.00123633,1.76834339,2.4186137999999997,2.69387981,2.47223585,1.83673689,1.03499544,0.352355142,0.0,0.0,0.0197213528,0.134278746,0.138533297,0.0350121631,0.0,0.0,0.0,0.0403982223,0.126388345,0.114083715,0.00915775567,0.0,0.0,0.0,0.09128601789999999,0.220872554,0.190384532,0.0,0.0,0.0,0.0,0.6726461020000001,1.94007546,3.19064466,3.88812398,3.66877963,2.59886801,1.24690184,0.484122499,1.07063727,3.22237676,6.39863574,9.45906229,11.148895300000001,10.6844927,8.13896418,4.42095336,0.8526871229999999,0.0,0.0,0.0,0.462880205,1.72996095,2.22630644,1.94095996,1.2292011999999999,0.525503895,0.0973255416,0.0,0.0,0.0195188902,0.0,0.0,0.0,0.0,0.0343462678,0.053119096799999994,0.028438861,0.0,0.0,0.0,0.0,0.0,0.0,0.0794387646,0.316516281,0.688860389,1.06891418,1.27057399,1.16030654,0.7533536759999999,0.22322586600000002,0.0,0.0,0.0,0.0661279537,0.23493387100000002,0.20848475800000002,0.0293541796,0.0,0.0,0.0,0.079078177,0.182986818,0.140260874,0.0,0.0,0.0,0.0,0.0933494627,0.162968589,0.10331204599999999,0.0,0.0,0.0,0.0,0.10799502400000001,0.15184673,0.0755093968,0.0,0.0,0.0,0.00489847736,0.123591174,0.144469157,0.0506906598,0.0,0.0,0.0,0.0324106382,0.141605486,0.139463484,0.0256866461,0.0,0.0,0.0,0.0637069037,0.165328015,0.137280265,0.0,0.0,0.0,0.0,0.106328415,0.20423962199999998,0.14175114,0.0,0.0,0.0,0.0,0.194822597,0.323781822,0.229123295,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.244
0.96902276,0.0,0.0,0.0,0.78284192,0.0,0.0,0.94376306,0.696684,1.85016367,0.71643595,1.78279313,0.0,1.05136864,0.0,1.80386103,1.29051102,0.0,0.0,1.7133991999999998,0.0,1.67791842,0.0,0.0,0.0,0.0,2.85730152,0.0,1.21075719,2.34773396,0.0,0.86421205,0.0,0.0,0.0,1.388862,1.76014096,1.72143356,0.74048651,0.51606835,0.0,1.9745884999999999,3.44144968,6.21116888,5.60096864,1.61173969,0.0990572,1.88546363,0.78747374,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.566678192,0.730685549,0.7455111,0.603419378,0.369053065,0.143248279,0.007556881359999999,0.0,0.034138394700000005,0.0930823949,0.114298296,0.09277661820000001,0.0554990706,0.031406756800000005,0.026979561099999997,0.0258092869,0.00922205723,0.0,0.0,0.0,0.0392612651,0.156489764,0.312197114,0.506816536,0.747955898,1.02240874,1.2660076,1.36676284,1.21890788,0.804523581,0.245481586,0.0,0.0,0.0,0.286461775,0.674978614,0.7173872459999999,0.3564125,0.0,0.0,0.0,1.05116297,2.48444771,3.66890835,4.05696728,3.4499246,2.10879186,0.613134516,0.0,0.0,0.0,0.08582172960000001,0.46583820000000004,0.46484221299999995,0.160679399,0.0,0.0,0.0,0.0281769204,0.22733849899999997,0.23697558,0.0749840471,0.0,0.0,0.0,0.0305835211,0.159095286,0.160280723,0.043123159,0.0,0.0,0.0,0.034848357999999996,0.140515115,0.140130877,0.031245761099999998,0.0,0.0,0.0,0.0721930881,0.315952202,0.508132592,0.572393196,0.491789043,0.309626353,0.103606856,0.0,0.0,0.0,0.0,0.0581974182,0.0691245528,0.0283989247,0.0,0.0,0.114265349,0.328193905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.359872149,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.230431406,1.21583906,2.34517273,3.52253182,4.641038,5.59474884,6.29074823,6.65989793,6.66489142,6.30458961,5.61409259,4.66054896,3.53524958,2.34302348,1.19028627,0.17324234600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0342301619,0.43882716200000005,0.7364579790000001,0.897516654,0.914998062,0.8031766770000001,0.5935123370000001,0.328532788,0.0546789161,0.0,0.0,0.0,0.0,0.0,0.0,0.0099971039,0.194671747,0.346809744,0.44311754799999997,0.470593359,0.427906324,0.324891787,0.180351287,0.0185935929,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0191443585,0.13438486300000002,0.22161464,0.268620989,0.27024745,0.228822658,0.153381771,0.057864926500000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05220630440000001,0.115262492,0.155587975,0.168180158,0.152944875,0.114432063,0.0607994938,0.00220948562,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.006189069209999999,0.0247861819,0.027564063,0.014850773999999999,0.0,0.0,0.0,0.0,0.0369650549,0.15453217800000002,0.33667466,0.585602147,0.8964867959999999,1.25732848,1.64965893,2.05000984,2.43197828,2.76865601,3.03515388,3.21095047,3.28182376,3.24117907,3.09065742,2.83998628,2.50611005,2.11170327,1.68321993,1.24866465,0.83528608,0.46738961700000003,0.164449748,0.0,0.0,0.0,0.0,0.0,0.0,0.09411656289999999,0.232619347,0.350580915,0.43225010700000005,0.467277595,0.45168968600000003,0.388151065,0.285467001,0.15736163,0.0206579325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013082769099999999,0.121754487,0.21033643,0.26501850600000004,0.277117735,0.244454161,0.17178175899999998,0.0701799973,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08382585990000001,0.20229925199999998,0.291652998,0.336118189,0.326620902,0.262521981,0.152073609,0.0114639644,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0349867336,0.214738543,0.369101555,0.47089045399999996,0.49991983100000004,0.446719935,0.314756281,0.120714818,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.295683155,0.631585556,0.913585732,1.09357332,1.13504256,1.01968375,0.7518144459999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.44321138600000004,0.11133728,1.1448728000000001,0.137198665,1.05190474,1.33928085,0.0,1.34239665,0.5240609279999999,0.0282387365,0.0,0.0,0.0,0.0,2.91235092,0.7442300820000001,0.0,0.494365355,0.0,0.0,0.18830886,0.0,0.0,0.984530742,0.0,0.0,0.0,0.346182375,0.0,0.0,0.0,0.0,0.0,0.575592766,0.058966130199999994,0.0,0.0,0.0629656292,0.40880193,1.63288599,0.33558151399999997,0.151651231,0.253521885,0.13354567,1.1202347,0.0,0.8785922709999999,0.0,0.0,0.776290295,0.42050830100000003,0.0,0.016020386,0.0,0.23514431600000002,0.726216489,0.0,1.37697937,0.297490771,1.99706662,0.0,0.0186029781,0.9086006520000001,0.0,0.0,0.17764819699999998,0.658883311,0.47836616,0.0,0.464178469,0.0,0.40753017399999997,0.0,0.0,0.0,2.16640651,0.488694302,0.0,0.7388712940000001,0.803086075,1.60226646,0.0,0.000339528412,0.0,0.48187487700000003,3.26625956,3.17340644,0.0,0.0,0.0,0.0,0.6873773,0.708210628,0.0,0.39963117,2.10506939,0.879340694,0.0,0.0,0.818581676,0.466672126,0.724150827,1.09386289,2.01581103,1.70724112,2.36127075,1.29541179,0.0,1.3550698,0.0,0.662573341,0.0,0.0,0.0,0.22758146699999998,0.8868132809999999,1.32553107,0.0,0.0,0.0,0.0,0.0,0.0,1.28440867,1.45516031,0.21556641899999998,0.0,0.0,0.0,0.0,0.961923438,0.8425656220000001,0.0,0.0,0.169811233,0.0,0.24318632399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0617413807,0.944730492,0.0,1.48210974,0.0,1.06291129,0.244619951,0.447372886,0.0,0.0,0.0,0.0262190402,0.0,0.0,0.749247219,1.04119775,0.0,0.595893937,0.0,0.499272525,1.25313813,0.0,0.0,1.05364971,0.540162791,0.944075317,0.0,0.0,0.0,0.676668175,0.0,0.55706664,0.9419121420000001,0.0600229716,0.343784328,0.0,0.159906383,1.5519676000000002,0.0,1.03223233,1.27112996,0.0,0.17627329100000003,0.46774128600000003,0.5952704289999999,0.0,0.0,0.0,1.01290933,0.0,0.05140467730000001,0.8890459909999999,0.0,0.547644429,0.177992703,1.12551987,1.14724324,0.506050029,0.0,0.221658579,0.44822523200000003,0.58308597,0.0,0.0713195631,0.0,0.181065173,0.181689615,0.0,0.453576748,0.0,0.0,0.311447385,0.0,1.38814858,1.39330426,0.689014028,0.0,0.19572730300000002,0.0,0.0,0.0,0.0,1.18198585,0.0,0.22642937600000002,1.02085811,0.0,0.0,0.0,2.04291727,2.76334587,0.0,0.0,0.159618598,0.0,0.0,0.00314384206,0.0,0.298867449,0.0500721475,0.0,0.0,1.32820747,0.0018061735199999998,0.173459191,2.38219804,4.35533863,2.93790286,0.345802482,0.0,0.322252895,1.43264072,1.32606551,0.9436356340000001,0.0,0.0,0.0,0.39009312,0.39640803,0.0,0.0,1.35416436,0.0,0.566458734,0.0762465948,0.405174231,0.603406719,0.426819004,0.0,0.0,0.07465443690000001,0.525284918,1.03048929,1.27977447,0.38200463,1.60313627,2.08324595,1.67207909,0.840743708,0.986532686,0.0,0.0,0.0,0.0,0.0,0.0,0.952094909,0.0,1.32889592,0.0,0.0,0.39775508600000004,0.22826525600000003,0.14837060400000002,0.0,1.75752718,2.21240465,1.90376276,1.80260344,2.92716335,2.08982937,1.92830495,2.30311227,0.0,0.0,0.500928307,0.0,0.395534006,0.741885285,0.0,0.0945968928,0.0,0.900593037,1.12275458,0.929384798,0.0,0.418530192,0.6435506,0.313936439,0.0,1.68409151,0.0,0.0,0.7983836059999999,0.0,0.0,0.36767787799999996,0.29778874,0.427473396,0.0,0.44403833600000003,0.0,0.0,0.0,0.789006348,0.6806414909999999,0.0,0.0,0.0,1.73792137,1.04527611,0.8515840170000001,0.118249466,0.710327617,1.02163855,0.0,1.53965747,0.0,0.19640906600000002,0.0,0.346642181,1.84403328,0.753749143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.77035587,0.8997222359999999,0.827446404,0.604687826,1.28923226,0.0,0.490009113,0.290821518,0.650602302,0.7865414909999999,0.0,0.0,0.339257651,0.0,0.0,0.0,0.0,0.0,0.800355039,0.0,0.0,0.332630014,0.417697236,0.0063429916,0.0,0.948129773,0.0,2.38152627,0.102643333,1.04433779,0.307740945,0.133801967,0.0777012571,0.560668382,0.476473291,0.232067335,1.63511901,0.927055576,1.64568673,0.949250465,1.47276844,0.738178302,1.18449637,2.11185789,2.09160878,2.08869614,2.24734498,1.92894262,1.50240708,0.601946491,0.516030173,1.81674859,0.922303678,0.504510212,0.443643106,0.9435852929999999,0.0712340223,0.0454369658,0.0,0.429032057,0.49778655200000005,1.71441321,2.69870492,1.85384654,3.83527398,3.16524924,3.96268565,3.12717575,2.46574556,2.18383596,1.15796075,0.569788172,1.96202559,1.37928795,2.33024804,1.33251248,2.3149916,2.90437524,3.17181485,2.02278422,2.7499267999999994,2.46145879,3.07195061,1.78826616,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.55516548,7.66633597,6.77636397,5.18672904,3.36375402,1.75991325,0.661362154,0.121926365,0.0,0.06612627780000001,0.12444935,0.0868305474,0.0,0.0,0.0,0.0,0.023624186000000002,0.0853559514,0.0762371346,0.023710585699999998,0.00107643694,0.0792081667,0.275847205,0.53438602,0.746799158,0.809328075,0.679899813,0.40444366200000004,0.09634427970000001,0.0,0.0,0.0,0.0798374752,0.19146760899999998,0.186361793,0.06934857629999999,0.0,0.0,0.0,0.0,0.0936142856,0.18772671,0.16845916800000002,0.0479298138,0.0,0.0,0.0,0.0,0.10977551,0.19191116,0.15781054,0.02872718,0.0,0.0,0.0,0.052414798,0.22132807699999998,0.291312063,0.21043645600000002,0.0139021869,0.0,0.0,0.0,1.2581878e-16,0.222825408,0.322605055,0.22841648,0.0,0.0,0.0,0.0,0.0433400669,0.36330098899999996,0.494504789,0.323939672,0.0,0.0,0.0,0.0,0.8196309009999999,2.12788733,3.33942634,4.03549038,3.97779258,3.21770064,2.07537788,0.9965768859999999,0.354366311,0.290021758,0.6678832029999999,1.16281731,1.43417233,1.2990594,0.820451148,0.269734757,0.0,0.204506057,0.9375355959999999,1.96499107,2.93282894,3.5088072,3.51939219,3.00651165,2.18566456,1.33508269,0.674937839,0.2932136,0.145060599,0.11298888,0.0871289283,0.021110546600000002,0.0,0.0,0.0,0.050999121900000007,0.17505174899999998,0.240764495,0.208193243,0.09293152560000001,0.0,0.0,0.0,0.06344979690000001,0.280385779,0.50741051,0.697026302,0.831068203,0.915571185,0.960834966,0.962830141,0.900332212,0.750855967,0.514969036,0.23162391300000001,0.0,0.0,0.0,0.0,0.0283238225,0.14709929300000002,0.171924772,0.0955445432,0.0,0.0,0.0,0.0,0.0391115586,0.136817627,0.151960032,0.0756106746,0.0,0.0,0.0,0.0,0.056124193600000004,0.151518676,0.15702529199999998,0.06660930940000001,0.0,0.0,0.0,0.0,0.083026481,0.18650613800000002,0.180405288,0.061710863,0.0,0.0,0.0,0.0,0.133271624,0.261661775,0.23759045199999998,0.0592866118,0.0,0.0,0.0,0.0,0.256557315,0.45933640200000003,0.39592413600000004,0.0551558727,0.0,0.0,0.0,0.814934522,2.55312517,4.59889953,6.43320545,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.37888621,1.99211528,1.69641543,1.42236185,0.96348941,0.0,0.0,0.49606087,0.0,0.63109136,0.0,0.17081777,0.65330267,0.0,0.0,0.9348261,0.0,0.2734474,0.0,0.0,1.13492972,0.0,0.0,0.0,0.0,0.0,0.77735323,0.0,1.17454777,0.0,0.78303135,0.0,0.15351625,0.87918808,0.0,0.01773925,1.70094229,1.13033779,1.37235214,0.58418023,1.01762775,1.50503154,1.54365164,1.93175458,2.43734137,0.0,0.39550802,0.0,0.0,0.80844145,1.59713476,2.85544856,2.46471485,4.37790196,3.24320786,3.39530181,3.49133917,1.75043836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.38319613,2.02382446,1.83793809,0.85726816,0.72828375,0.31175305,0.0,0.37034241,0.0,1.05957883,0.22909603,1.41039233,0.6080749,1.040224,0.0,0.62340772,0.0,1.3114042,0.0,0.0,1.15948559,1.07127506,1.37085824,0.0,1.40444848,0.06520699,0.11865773,0.35485749,0.09015935,0.65880641,1.43040309,1.2937873,0.23629211,0.0,0.0,0.0,0.0,0.24601262,0.45229256,0.86432274,1.25870141,2.26931285,0.06113149,0.0,0.0,0.0,0.0,1.2400946000000002,5.66395232,11.07434235,13.03217402,13.56407974,11.49413125,7.74638897,5.56566435,1.87151647,0.0,0.0,0.0,0.51577332,1.04099714,0.93703439,0.24201893,1.52896925,0.46868177,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.259
0.11219866,0.0,0.0,0.20910445,1.64078656,3.18493619,4.05378505,3.76590311,2.45683484,0.79746304,0.0,0.0,0.0,0.22296006,0.53958983,0.39002748,0.0,0.0,0.0,0.0239547,0.26627022,0.25829944,0.021920500000000002,0.0,0.0,0.0,0.18803735,0.26615972,0.10188894,0.0,0.0,0.0,0.13084794,0.30336808,0.20250874,0.0,0.0,0.0,0.09405705,0.46698793,0.50419772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
10.619337699999999,0.882125651,0.0,0.248963355,0.0,0.137011095,0.013478926,0.258406974,0.0,0.6937519240000001,5.85164444,1.45129028,1.74273807,2.03276102,0.0,0.723880533,0.0,0.15527470599999998,0.0,0.292690313,0.23770241399999997,2.62923615,4.51180456,3.74862961,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.53862908,0.586210966,0.428404502,0.183906018,0.0,0.0,0.0156321252,0.0512056255,0.0,0.029706039700000002,0.26753727,0.374227485,0.144896611,0.0,0.161178435,0.32577940000000005,0.0058844086,0.0,0.8050086890000001,2.60257707,3.57377808,2.81172309,1.22416843,0.214926498,0.0921227208,0.234406213,0.188067417,0.0280473575,0.0,0.0,0.035480257200000004,0.007042324670000001,0.0,0.0385760569,0.292096808,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.98405855,0.0,0.0,0.5190539000000001,0.17930066,0.09838652,1.89195275,1.80196125,3.13232823,3.62391838,2.99483469,2.94820306,2.20621331,1.53657682,0.96002702,1.56939814,1.37990509,0.0,0.0,0.77834068,0.0,0.0,0.74316671,0.37001049,0.05532101,0.0,0.0,0.49326379,0.27478135,0.41431556,0.0,0.18816252,0.16864182,0.0,0.0,0.0,0.38757952,0.0,0.0,0.46976366,0.0,0.0,0.0,0.0,0.74304721,0.15154091,0.0,0.0,0.01486056,0.61489987,1.08623073,0.43550783,0.24935509,0.09850289,0.7975821,0.82446144,0.29686236,0.72183208,0.0,0.0,0.0,0.33395125,0.61840324,0.62337957,0.0,0.0,0.54057294,0.1869438,0.0,0.38538242,0.35755329999999996,0.0,0.51450593,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.35322624,0.435902875,0.285554422,0.240643087,0.0,0.0,0.0,0.0,0.0,0.46362304299999996,0.31735220199999997,0.621728168,0.0296162466,0.385698053,0.44012384600000004,0.95602626,1.08727251,0.946221845,1.14813644,0.22816101,0.300027569,0.81373178,0.815153835,0.0,0.0,0.093502401,0.11149779,0.130816491,0.644701188,0.41805578299999996,0.533521229,0.0,0.0,0.256712315,0.13561763599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.42395964399999997,0.0675200162,0.0,0.0,0.0,0.0982108108,0.566795543,2.01311809,4.499477099999999,6.39695821,6.70124529,3.89496481,1.82219252,0.129494515,0.0,0.221389287,0.0,0.124838621,0.0,0.440932131,0.6900804420000001,0.7990220159999999,0.0,0.0,0.321803326,0.0,0.26211372899999996,0.0,0.311927544,0.42556183700000005,0.259428748,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7206579409999999,0.0,0.0,0.0,0.307823546,0.137803844,0.40940707,0.0,0.356459546,0.0,0.537911667,0.0,0.0,0.0,0.847299825,0.209356575,0.0,0.0,0.0,0.784298643,0.0,0.66864064,0.0,0.0,0.0,0.655762069,0.0,0.235007539,0.0,1.47721151,2.20369443,2.0053696,0.157626374,0.0,0.0,0.6898431079999999,1.02157255,0.0,0.529245339,2.30557499,3.24699007,2.16188742,0.20812564100000003,0.624909886,1.19831447,1.92449339,0.616684582,0.47276413799999994,0.0,0.0,0.0,0.34897168,0.972979707,0.0,0.0,0.29773412899999996,0.254449025,0.0,0.55648555,0.292979724,0.354821045,0.0,0.0,0.008783999609999999,0.39396302299999997,0.0,0.0,0.0,0.0,0.45169387,0.0,0.0,0.717055372,0.5628156329999999,0.20349013800000001,0.463317286,1.65331044,1.82060389,1.05210844,0.94223366,0.101989636,0.0,0.35163635299999996,0.584235003,1.69241374,3.83744067,4.28327346,4.04924362,1.96793348,0.48416120799999995,0.21776762100000002,0.33705546299999994,0.18007162100000002,0.0,0.654544861,0.0,0.485648866,0.0,0.0,0.0,0.780987605,1.20649629,2.88796312,2.77690112,1.63663208,1.81736096,0.6843894140000001,0.6302903,0.0,0.0,0.0,0.0294939764,0.0,0.495729291,0.0,0.17481950899999998,0.0,0.133938264,0.0,0.232021194,0.16895580899999998,0.181362742,0.38802620200000004,0.0669673572,0.0,0.38129322200000004,0.0,0.0,0.33697168200000005,0.0,0.0881568195,0.515524373,0.0,0.0,0.231447707,0.669439624,0.031439745299999995,0.0,0.669876413,0.370963651,0.214781151,0.0,0.34736000899999997,0.0,0.440287737,0.0399489253,0.010815555400000001,0.0,0.895659847,0.0843831275,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0774526577,0.111118759,0.0700764042,0.0,0.0,0.0,0.0,0.0512225433,0.0783470146,0.0441932802,0.0,0.0,0.0,0.0,0.0579605655,0.0779297454,0.0357388991,0.0,0.0,0.04371022980000001,0.301292292,0.668689471,1.0265289,1.22830704,1.1710049,0.856473155,0.407113159,0.0179958377,0.0,0.0,0.324034243,0.64745019,0.775265952,0.636007096,0.318050342,0.012039653,0.0,0.0,0.24210270399999997,0.44426544,0.47925471700000005,0.34376925,0.14583327,0.0150461468,0.00581922284,0.0663988501,0.0939777733,0.028546941099999997,0.0,0.0,0.0,0.060710535,0.210788625,0.21669285600000002,0.051678332,0.0,0.0,0.0,0.16811931,0.47457036799999996,0.5989708420000001,0.514846612,0.378117476,0.40371441399999997,0.6704796439999999,1.00876848,1.08244388,0.638628767,0.0,0.0,0.0,0.0,1.66830002,3.87208205,5.38379002,5.5015617,4.17099614,2.01768059,0.0,0.0,0.0,0.0,0.430273401,0.742556584,0.467576685,0.0,0.0,0.0,0.0,0.305904723,0.461883596,0.256542223,0.0,0.0,0.0,0.659853154,1.84534889,3.14972767,4.26604188,4.960406099999999,5.10630984,4.68340739,3.77352159,2.55990126,1.30606533,0.290989798,0.0,0.0,0.0,0.11422930699999999,0.294531954,0.278253365,0.135807245,0.00936604419,0.0042164961,0.120173755,0.264364934,0.327659308,0.26471304100000004,0.12075355800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0842156374,0.696126195,0.588660469,0.668259214,0.586169872,0.415275424,1.24960723,0.903832373,0.7512196999999999,0.9045036359999999,0.0,0.0,0.187513225,0.190410318,0.904359826,0.102539992,0.606867742,0.0,0.0,0.435272418,0.0,0.106842914,0.24479758399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0213115726,0.0560087291,0.6010626929999999,0.17922365899999998,0.0,0.0,0.382873156,0.0669345477,0.414169395,0.0,0.0,0.0,0.376673135,0.0,0.428239818,0.0741999154,0.211256962,0.379540159,0.342403299,0.0,0.400448907,0.0367620183,0.0,0.0,0.35789626399999996,0.377629369,0.43645091399999997,0.464559217,0.5726716079999999,0.347341154,0.875593773,0.103591265,1.3563696,1.71770787,2.48109597,1.47292499,1.48965282,0.19677391100000002,0.291224627,0.380182468,0.522364642,0.0,0.0,0.0,0.594787568,0.0,0.0,0.390545816,0.0,0.41658049799999997,0.22991352899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.572657799,0.031796063,0.495823975,0.0,0.0,0.0,0.0569908867,0.6767965709999999,0.0,0.0,0.0,0.394190295,1.44688975,1.70144894,1.38355394,1.28806966,0.7873539740000001,1.84233,1.1103792,0.0,0.891191086,1.52101233,3.98898453,5.21580533,4.89385256,3.1667665,0.58030221,0.0880470144,0.172028769,0.023192303100000002,0.149305632,0.298962514,0.0,0.326311787,0.0540247421,0.36500434299999995,0.474114195,0.23305549899999997,0.024788315,0.276826737,0.21678816899999998,0.24526081100000002,0.0,0.0,0.419175103,0.19026624399999997,0.042821448399999996,0.120259406,0.314916727,0.109627548,0.0,0.670326106,0.489522836,0.25330966899999996,0.3097793,0.0,0.468124749,0.117198397,0.309729288,0.224963003,0.0,0.352579053,0.0,0.0,0.389328069,0.419929996,0.0,0.0,0.0,0.0294435964,0.0,0.598442904,1.03075527,0.6074861999999999,1.30301198,0.890119633,1.02637306,0.95447676,0.0,0.0,0.0,0.45197767299999997,0.0,0.0,0.0,0.198301211,0.364013564,0.017524568799999998,0.220945193,0.0,0.0,0.5457257560000001,0.0,0.0,0.0826105531,0.253165125,0.0,0.173064815,0.0,0.13601156,0.0,0.0558513592,0.65142778,0.7515898240000001,1.13429694,1.79598305,2.76673868,2.80957015,4.14217663,4.15428646,2.99482131,2.56741766,2.86813071,2.79878697,3.49534578,2.56730849,2.15028707,1.82404776,1.85792249,1.44329529,1.61378251,1.03307116,0.70406455,0.0,0.319893822,0.302519887,0.430803875,0.250082747,0.0,0.0,0.0,0.479198058,0.49120355299999996,0.0,0.0,0.204348908,0.04079724,0.0,0.0855438875,0.0372713316,0.314470703,0.35200924,0.0,0.490094989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.209801055,0.0,0.745984885,1.89509842,0.554990306,0.0,0.163643184,0.0,0.0,0.0710243359,0.0,0.0303531946,0.004199930510000001,0.0,0.020894276,0.0,0.000381472325,0.0,0.0136485278,0.0,0.0101786668,0.015656259,0.0181270295,0.35935592,0.253807891,0.307683307,1.28342015,1.0046992000000001,0.0,0.0,0.06645361450000001,0.0,0.036649531299999996,0.0,0.0,0.0,0.0541665633,0.0,0.0,0.799927614,0.9097937290000001,0.37650132799999997,0.660515195,0.30187734,0.0,0.661099614,0.978528941,1.25219022,0.857183899,0.0,0.054987474800000005,0.067134315,0.0,0.138646489,0.0,0.0,0.111057781,0.0,0.0964096998,2.84622354e-15,0.0,0.192019461,0.0,0.771703372,3.45890527,4.00596519,1.70177226,0.0,0.0,0.1489367,0.0,0.042328658,0.0073978093000000005,0.0,0.0685424528,0.0,0.00718163115,0.0408893586,0.0,0.0632206389,0.0,0.0,0.0789553441,0.0,0.061884290999999994,0.129624462,0.0,0.167394347,0.189912583,0.157377106,0.668938871,1.35125596,1.53091091,0.805080754,0.543320184,1.18947536,0.9045308129999999,0.0927300172,0.0,0.0213757711,0.0,0.000606053577,0.0,0.00863373671,0.0,0.0145707775,0.0,0.0,0.0272157288,0.0,0.00993329278,0.013885715,0.0,0.0361229961,0.0,0.0,0.035437103399999996,0.0,0.0321342229,2.27900461e-16,0.0,0.055179800300000005,0.0,0.0128413182,0.0327644766,0.0,0.06856682110000001,0.0,0.0,0.0869197425,0.0,0.0898547094,0.14821204699999999,0.0687308012,0.70617541,0.765813381,0.36782345299999997,0.432986372,0.204120391,0.026290255099999996,0.0984435868,0.00969829304,0.006801379329999999,0.0,0.020588580800000002,0.0114655144,0.0,0.0819604781,0.0,0.11803283,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.44759548,0.0,0.594998435,0.32083755199999997,1.13889783,0.0,0.108292864,0.0,0.0,0.0,1.15493571,0.342620518,0.41891902,0.323895539,0.0,0.9980784309999999,0.526668496,0.0,0.19122615,0.0747268916,0.0,0.515992495,0.0,0.0,0.0,0.0,0.836962335,0.374940854,0.0,0.00140756332,0.0,0.0607051708,0.0,0.263566777,1.4486697,0.26688832100000004,0.629534125,0.622663045,0.0,0.634863755,0.626243575,0.38769593799999996,0.292888113,0.325041343,0.0318425844,1.27148163,1.41214285,0.0,1.14031807,0.0,0.0,0.0,0.335298602,0.566340596,1.56851011,0.331260718,0.596133936,0.0,0.0,0.939220116,0.0,2.19530726,0.0,0.0,0.0,0.0,0.0,0.0,0.384229036,0.0,1.4224312,0.35449123899999996,0.428322156,0.228318623,0.321139296,0.0,0.0,1.33336891,2.18469373,0.0,0.0,0.0,0.886804652,0.682740398,2.49730371,0.0,0.0,0.455732584,0.799915121,0.0,1.27410236,0.7428596190000001,0.162217069,0.0,0.77967758,0.0,0.0,0.0,0.283358532,1.42150489,0.275172635,0.214222826,0.7064276820000001,0.0,1.37223393,0.0,0.0,0.0,0.0,0.364538363,0.0,0.7785983,0.0,0.0,0.19919245800000002,0.651380549,0.0,0.0,0.0,1.19454244,1.61051404,3.44324915,3.65961473,4.28422189,2.41636518,2.12512425,0.0,0.0,0.7680910609999999,0.0,0.071140833,0.0,0.0,0.16885995,0.0,0.0,0.17797353,0.7041291829999999,1.47076575,0.011521570200000001,1.07777259,0.68140132,0.0,0.140270038,0.0,0.0,1.33655006,0.0516330312,0.0,0.425943919,0.515364422,0.399955325,0.336171761,2.86196905,0.0,0.16962964100000003,0.0,0.0,0.0,0.0,0.0,1.31165143,0.0072581207299999995,1.49833973,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.23745236100000003,0.0,2.39089563,0.006595847629999999,1.256831,0.0,0.359561552,1.42908589,0.0,0.522784343,0.668812011,0.0,0.141970478,0.262418895,1.01728935,0.0,1.24065092,0.168658363,0.0,0.0,0.0,0.0,0.0362736033,0.93556534,1.47303963,1.0120308,0.523195737,0.29298691600000004,0.984565892,0.0,0.0,0.0,0.9062584659999999,2.00992952,1.3591418,0.863095464,2.33684374,1.21006211,0.914840268,0.37628347100000004,0.0,0.0,0.587253059,0.61959065,1.62107592,3.24758303,4.46583028,4.01614242,3.93244236,3.38616498,2.03618651,0.643454467,0.0,0.0,0.499282514,0.0,0.0,1.69211578,1.27537942,1.32546904,0.0,0.189351605,0.0,0.734808386,0.288070636,0.7042732490000001,0.0,0.0,1.6546071,2.4573846,0.0785720468,1.77100497,2.62395364,1.41200196,1.11626841,1.47816485,0.130438735,1.13719093,0.0,0.0,0.634557781,0.0,0.0,1.15264355,0.44245028799999997,1.31176811,0.40821137799999996,0.9906484170000001,0.34449113,0.43300130600000003,0.0,0.874724591,0.40335211600000004,0.272602091,1.04536983,0.235206921,1.88859752,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18571479100000002,0.149499171,0.207371145,0.298368051,0.308208624,0.208456528,0.109773215,0.163253475,0.40152133100000004,0.681222221,0.7968800840000001,0.669010973,0.42983301399999996,0.318581808,0.47440052,0.8122927590000001,1.09426362,1.13162757,0.9385152290000001,0.705178291,0.623579032,0.7250025309999999,0.8687367,0.8802843109999999,0.7098370279999999,0.47675333799999997,0.37447753100000003,0.525622138,0.9011009179999999,1.34725105,1.6791808999999998,1.77049354,1.60120904,1.26390404,0.933651583,0.7967493790000001,0.94804021,1.31063993,1.6536836,1.73226345,1.46923784,1.03405063,0.730241438,0.757455296,1.03726386,1.26162709,1.14326827,0.665896348,0.11550503,0.0,0.00801839391,0.371723006,0.56551979,0.37026464299999995,0.0,0.0,0.0,0.30392131899999997,0.9708483109999999,1.32887657,1.19980642,0.730322639,0.238614238,0.0,0.0,0.00439287797,0.0449371004,0.024130765699999997,0.0,0.010907290900000002,0.046854239900000004,0.054238891799999994,0.0169833479,0.0,0.0,0.023080109100000003,0.0569244097,0.032990043399999995,0.0,0.0,0.0,0.039069675,0.0823804605,0.0423227142,0.0,0.0,0.0,0.0515272473,0.10061495,0.047788231699999996,0.0,0.0,0.0,0.0651808642,0.11961158599999999,0.0527087165,0.0,0.0,0.0,0.0828139967,0.14400063,0.0587666221,0.0,0.0,0.0,0.108833021,0.18076033100000002,0.0681509748,0.0,0.0,0.0,0.154232666,0.24785830399999997,0.086538775,0.0,0.0,0.0,0.262630812,0.424624555,0.142362748,0.0,0.0,0.0,1.01148182,2.60536338,3.80826629,4.15424077,3.69800796,2.88627731,2.17743321,1.74238403,1.46507491,1.17260166,0.836076009,0.557291376,0.398655783,0.275198504,0.04929726190000001,0.0,0.0,0.0,0.7451741820000001,1.74425526,2.32151442,2.08920294,1.16328128,0.0972047518,0.0,0.0,0.0,0.313532142,0.30645301199999997,0.0232342268,0.0,0.0,0.0,0.17616847300000002,0.17042212399999998,0.00666298826,0.0,0.0,0.07087878780000001,0.22319788899999998,0.25034632100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.116462435,0.23912767199999999,0.408786473,0.438247035,0.178431883,0.0,0.0,0.286698006,1.04648455,1.70214004,2.15622213,2.49215961,2.65963282,2.49132952,1.99399513,1.39137844,0.847436451,0.354084639,0.0,0.0,0.0,0.15666121800000002,0.068192395,0.0,0.0,0.10672193199999999,0.16248528,0.0,0.0,1.0301316e-15,0.22095273899999998,0.07467371889999999,0.0,0.0,0.308522902,0.36864328700000004,0.0017798872699999998,0.117006175,1.31155995,2.64339045,2.6006744,1.28279997,0.661491267,2.16782296,4.69927028,5.8348865,4.73245648,2.89871345,2.014023,1.95672275,1.55724419,0.603921451,0.105043573,0.6601571270000001,1.51393548,1.60311028,0.9221741179999999,0.30056988,0.174693652,0.208997629,0.0534289161,0.0,0.0,0.10844289999999998,0.269191809,0.501332852,0.959883693,1.38840493,1.31604047,0.718789017,0.126731324,0.0,0.0797002836,0.0857263656,0.0,0.0,0.127738173,0.36255593,0.43786717799999997,0.379185771,0.272797745,0.131060692,0.006642331360000001,0.0468634936,0.276904931,0.45704878200000004,0.337124342,0.0,0.0,0.009721333490000001,0.584218795,1.26651437,1.67296089,1.44150708,0.618230264,0.0,0.306386716,1.68394609,2.79998405,2.41802667,0.8330253120000001,0.0,0.0,0.510724006,0.607016305,0.0,0.0,0.0,0.907807217,1.2717013000000001,0.800185158,0.17645291,0.0,0.0,0.0,0.0,0.0,0.0870469451,0.0308759479,0.0,0.0,0.0777063092,0.0967999991,0.0,0.0,0.0138213304,0.131463931,0.0291968078,0.0,0.0,0.115913059,0.12162731800000001,0.0,0.0,0.0418119478,0.212486343,0.0254021224,0.0,0.014381046399999998,0.859723144,1.59103397,1.49653204,0.665931321,0.0,0.0,0.0,0.377305218,0.43998140799999996,0.23360683100000001,0.0314719024,0.0182659154,0.134981405,0.22479734699999998,0.330996629,0.748250174,1.63085081,2.59685822,2.98289191,2.62724333,2.18557452,2.39444486,3.10055147,3.3532995999999997,2.55448184,1.23333521,0.454921488,0.626427458,1.17035261,1.32229268,0.936163984,0.409618725,0.0892270891,0.0,0.0,4.54678775e-16,0.018228498899999997,0.00702974832,0.0,0.0,0.022930297599999996,0.0304356827,0.0,0.0,0.00494464079,0.0481949074,0.010858463600000002,0.0,0.0,0.040700288700000004,0.0383521421,0.0,0.0157842608,0.170626158,0.247635985,0.104586376,0.0,0.0,0.19799682899999999,0.418734339,0.39568343799999994,0.223382539,0.0970585283,0.0724880356,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.7692130140000001,1.60106458,2.50899437,3.43000892,4.29661134,5.04286249,5.61042842,5.95400171,6.04554338,5.87691078,5.46060298,4.82855026,4.0290771,3.12235638,2.17482539,1.25313595,0.418250093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.200617197,0.458511072,0.631294437,0.708339609,0.6911037040000001,0.591773872,0.43084437700000006,0.23397105899999998,0.028509490099999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00891306358,0.123605194,0.211202955,0.26349875300000003,0.27758227,0.255722677,0.204587678,0.133952777,0.0551106039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015335683000000001,0.037831484500000005,0.0482773591,0.047388569900000004,0.0379301138,0.024039465,0.0103452206,0.00103479136,0.0,0.00540298782,0.0191481483,0.0373216684,0.0555581514,0.0688658471,0.0725783151,0.0633047971,0.0397176027,0.00303499708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012400376299999998,0.10265642400000001,0.19018824399999998,0.262154734,0.30647956600000004,0.313669166,0.278436539,0.200887034,0.0870650671,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20011502,0.462084436,0.709524533,0.9120062959999999,1.04184322,1.07774799,1.00802204,0.832866518,0.565483139,0.231756856,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0664600814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.0998843999999997,3.58430452,5.09229516,6.242464900000001,6.71118987,6.341153599999999,5.19801708,3.55343654,1.79962836,0.325915744,0.0,0.0,0.0,0.0,0.280011784,0.548055402,0.529954911,0.28267765100000003,0.0,0.0,0.0,0.0,0.0,0.151759833,0.282481157,0.270980662,0.138868673,0.0,0.0,0.0,0.0,0.0,0.09934302589999999,0.17308274,0.16085993,0.0769023778,0.0,0.0,0.0,0.0,0.0,0.0664759417,0.107804614,0.0957851532,0.0417396031,0.0,0.0,0.0,0.0,0.0,0.0399927121,0.0595575026,0.049459564500000004,0.0189018677,0.0,0.0,0.0,0.0,1.99901775e-16,0.0148758007,0.0182145083,0.011965545900000001,0.00303085214,0.0,0.0,0.00377266526,0.005031945889999999,0.0,0.0,0.0,0.0,0.0,0.014892774099999999,0.036419883199999996,0.043211605099999995,0.0278507724,0.0,0.0,0.0,0.0,0.0,0.0375408389,0.0795424438,0.0864661389,0.0500157658,0.0,0.0,0.0,0.0,0.0,0.06991558,0.1353687,0.139669803,0.074069128,0.0,0.0,0.0,0.0,0.0,0.11785658,0.21072455399999998,0.20557227,0.0975469498,0.0,0.0,0.0,0.0,0.277339299,0.60416598,0.82861053,0.8513526790000001,0.663582738,0.373466546,0.184003156,0.32443552600000003,0.9577861790000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.08274383,0.0,0.169415961,0.594724232,0.0,0.8069186770000001,3.18606977,1.5037883,0.0,0.0,0.000379142039,0.055832968399999995,0.0174047803,0.0,0.16496863,0.0,0.0,0.245043278,0.0,0.0,0.313003539,0.0,0.0,0.303368722,0.0,1.09442901,1.61728611,0.0,0.0,1.55175477,0.0,0.666367618,11.5097595,9.53017889,0.0,0.0,1.75681507,0.0,0.0,1.06290909,0.0,0.16980651800000002,2.60872152,2.36194238,2.08359363,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.63567308,3.28381812,4.60302248,4.33429164,3.35709885,1.74032036,0.205955052,0.0,0.0,0.0,0.06947246280000001,1.11299066,0.549353901,0.0,0.0,0.0,0.148198788,0.38818548,0.801939271,0.593189162,0.0,0.31783454899999997,0.480144005,0.0,0.0,0.507674396,0.556922869,0.825453922,0.0,0.0,0.0,0.0,0.0,0.0,0.840076348,0.0,0.533340719,0.206127909,0.0,0.0,0.0,0.82065519,0.34627202100000004,0.0,0.0,0.33595402700000004,0.382644717,0.0,0.0,0.184928211,0.578939196,0.0,0.09452027460000001,0.40852466,0.0,0.314836217,0.378772596,0.21715821100000002,0.0,0.0481233724,0.0,0.436752917,0.15999263,0.0,0.462275448,0.621296902,0.0,0.0,0.0,0.147108672,0.0,0.771597139,0.0,0.0,0.0,0.0,0.511110265,0.47059845899999997,0.6468236820000001,0.20052355,0.0,0.389345627,0.0,0.0,0.396022128,0.44213247,0.431753039,0.369947517,0.468065836,0.0,0.0,0.55924501,0.0,0.47516783799999995,1.02143364,0.0,0.0,0.9478612009999999,1.9641998999999999,3.8868226000000003,5.72306435,6.79751626,6.57275278,6.57161682,4.01831725,2.22241766,0.0,0.0,0.0,0.0,0.9332623090000001,0.518620554,0.976923168,0.0,0.0544346475,0.0,0.0,0.0,1.0138075,0.832447187,0.56512805,0.0374973346,0.139646879,0.0,0.0,0.297326755,0.786655983,0.0497717115,0.0,0.5493588420000001,0.0,0.085007641,0.0,0.19348796699999998,0.369503326,0.36690976799999997,0.0,0.0,0.0,0.0,0.106826594,0.0,0.0,0.0,0.0,0.0,0.0,0.574056065,0.0,0.84495315,0.174498816,0.0,0.0,0.175343367,0.622333496,0.7078404709999999,0.0,0.287502032,0.0,0.34909898,0.0,0.0,0.862793557,1.1012567,0.373067207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.653222089,0.8533728840000001,0.5836945379999999,0.0,1.00481215,0.5036066060000001,0.68002673,1.27142353,0.496777861,0.60083323,0.203350972,1.18722134,0.26334763,0.42018902399999997,0.0,1.16662399,0.94685716,0.88077054,0.0,0.0,0.0945434578,0.0,0.30658052,0.0,0.695369773,0.820710277,0.43106292700000004,0.0,0.0,1.09608248,0.981254451,0.0,0.317719209,0.8493659509999999,0.5767512539999999,0.127245842,0.0,0.655684345,0.46239294200000003,0.638860458,0.0,1.24847199,2.4020368,0.8116852990000001,1.32812893,0.9212588820000001,0.825190952,1.73202545,1.3843681,0.7485086040000001,1.69141805,1.18222975,0.0,1.58638733,1.49344543,0.0,0.862633689,0.0,0.869733158,0.0,0.0,0.0,0.0,0.0,0.0,0.865463822,0.302411903,0.0,0.0,0.785209833,0.613671838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.377534122,0.7885460740000001,0.176028692,0.261191154,0.5081161670000001,0.752862204,1.90736321,1.12057777,2.49824852,3.72434581,3.22566776,4.22966324,4.15968026,2.34217067,2.86870073,2.28837922,1.65620616,2.25560162,0.0283491537,1.32718234,0.559867638,0.475218216,1.40127017,0.306137351,0.449006036,0.024286448399999997,0.5942928239999999,0.922474185,0.241968297,1.24057666,0.295275765,1.05535839,0.927427927,0.677513708,1.60017479,0.0,0.0045844199,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.484594189,0.0,0.613485603,0.08469605710000001,0.46707556100000003,0.0833228111,0.500711831,0.692748302,1.04920004,0.308168771,1.65435821,0.6076620779999999,0.0,0.402238352,0.0071803770900000004,0.0,0.0,0.295229827,0.0,0.0,0.292493061,0.5739400889999999,0.0,1.00434655,0.132683525,0.8712142740000001,0.0,0.0,0.0,0.0,0.0,0.8329248640000001,0.0,0.7235831429999999,1.39666245,0.0,0.7228252559999999,0.0,0.0,1.88160534,0.5220156189999999,1.0507619,0.935640632,0.914431683,0.311825307,1.43847064,0.0,0.0,0.0,0.0,0.43456213899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.02053004,0.0,0.2755446,0.27205684,0.23468784,0.0,0.40211911,0.25653331,0.57335326,0.31774443,0.55587697,0.79522087,0.33600667,0.86207737,0.79229411,0.73874887,1.1618233999999998,1.28335219,0.9031761,1.17542914,1.22171952,1.26947318,1.18256895,1.64533857,1.82047517,1.70737057,1.80466001,2.42272137,2.48529192,2.71097501,2.65392132,2.9842174,2.90277816,3.14548332,3.1404172999999997,3.43592337,3.56238497,3.3211644999999996,3.36471295,3.58253759,3.47811721,3.25296979,3.57928471,3.04732498,3.21406437,3.10002472,2.90385345,3.04519034,3.0777625,2.52428056,2.46926265,2.23431108,2.26076284,2.46187879,2.07474848,1.65706222,1.93723948,1.81974738,1.44934992,1.37318908,1.29723687,1.30047147,0.87417437,0.80666996,0.75234958,0.76371488,0.7473261,0.56024284,0.37084993,0.84439299,0.68153281,0.23689851,0.71743077,0.24051619,0.54609121,0.08079564,0.05187019,0.54755782,0.28917798,0.57701234,0.07960251,0.28860091,0.07710994,0.05262853,0.19157788,0.23322247,0.19507094,0.0,0.12092076,0.0,0.0,0.21464779,0.0,0.09216695,0.0,0.0,0.0,0.0,0.03601581,0.3136639,0.0,0.19016832,0.0,0.08117535,0.38950669,0.08866363,0.14961075,0.41635445,0.32982824,0.20878629,0.0,0.0,0.0,0.46468009,0.38967614,0.28229934,0.0,0.1756014,0.38792591,0.08219058,0.0,0.0,0.10775567,0.29335,0.0,0.0,0.0,0.25183331,0.0,0.20641701,0.0,0.0,0.24021042,0.0,0.23162782,0.06600159,0.0,0.0,0.0,0.0,0.0396899,0.0,0.0,0.35087776,0.22805266,0.42741938,0.40828649,0.0,0.36409568,0.14143270000000002,0.26342551,0.0,0.19615636,0.5955284000000001,0.0,0.56502096,0.07871477,0.19192756,0.36382542,0.0,0.12858559,0.02172629,0.32518958,0.19672853,0.20811555,0.18567376,0.0,0.0,0.23129684,0.03153498,0.0,0.0,0.0,0.0,0.23414646,0.1258594,0.0,0.18149824,0.18593851,0.05981357,0.46766422,0.17673171,0.43463677,0.66336907,0.27869140000000003,0.31856268,0.84458429,0.54988158,0.48788667,0.6739738000000001,1.03905021,1.1032735,0.76577204,0.42879151,0.73164675,0.73299178,0.86549507,0.42298986,0.66603501,0.36909303,0.54464175,0.13157712,0.59858761,0.08132083,0.24736568,0.0,0.19141064,0.16490425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.87467541,0.0,0.13187446,0.0,0.16697291,0.0,0.20103103,0.0,0.23650907,0.0,0.28450433,0.0,0.4721822,0.31296909,0.23142797,0.0,0.26854883,0.0,0.31248964,0.0,0.35487482,0.0,0.40382231,0.0,0.46793948,0.0,0.56393034,0.0,0.73800285,0.0,1.19683442,0.0,8.11076836,2.73988541,0.0,0.51723209,0.0,0.15626081,0.0,0.0,0.09272588,0.46208051,6.32816991,2.81235487,4.12719441,3.37542412,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.42438429,0.0,0.145470303,0.5572992170000001,1.97981633,0.0,1.81720944,0.0,0.0,1.51572199,0.43921734700000004,0.0,0.0,0.0,0.0,7.02160191,5.4843886,0.0,0.0,0.0,0.43101887,0.0,0.25282984399999997,0.0,0.668864372,2.1032425,0.081377542,0.0,3.68448848,0.0,0.0,0.0,0.0,0.39126233299999996,0.0,2.02150637,0.53001118,0.307603499,0.377894461,0.482312697,1.08947128,0.0,1.03854863,0.0,0.9324478759999999,3.51890216,0.0,0.031145487000000003,0.0,1.10603883,0.0,0.0,0.0,0.0,0.739725082,0.0,0.0,0.0,2.56560293,4.28810223,3.90999842,1.08780444,1.62849594,1.98150317,1.74859028,0.720946145,1.71684183,0.0,2.98549821,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.22444036,2.11741442,0.0,0.037966908,2.09467725,0.0,0.072012301,1.6967279,0.94889673,1.73086117,0.0,1.39750394,0.763317595,0.133111322,1.1101375,0.457613372,1.95920762,1.26154246,1.76743327,0.0,0.0,0.0,0.0,0.0,0.797534905,0.300138105,0.0,0.0,0.0,0.0,2.06123559,0.0,1.35326536,0.0,0.196572923,0.0,1.37087697,0.40984214700000005,0.0,1.72556534,1.68861145,0.668559554,0.0,0.82573447,1.08689948,0.0776124794,1.06736783,0.0,0.208110105,1.98389294,2.11659232,1.71632004,0.0,1.3474129,0.0,0.0,0.0,0.0,1.43955573,0.0,0.0,0.0,2.16152598,0.465212357,0.09899793289999999,0.0,1.72129761,0.0,0.0,0.0,0.826843575,1.35387404,0.736687103,1.77058373,0.0,0.0,1.25191307,1.79027269,1.18967787,1.32461022,0.0,0.8149894,0.0,0.0,0.0,1.31655633,1.98201101,0.0540352471,1.25199088,0.0,1.37906852,0.0,1.56515475,1.32646893,1.75114909,0.0,0.132881325,1.36666685,1.117836,1.21132778,0.0,1.79846977,0.629655246,1.68069643,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.442400836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.766354049,0.876519135,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14399416,0.0,0.0,0.0,0.0,1.69529645,0.0,0.0,0.0,1.77809256,0.0,0.0,0.931860738,1.71601255,0.0,0.0,0.0,0.0,0.0,1.65650695,2.15367941,0.0,1.63870541,0.0,1.24822302,2.17874315,0.0,0.0100284833,0.0,0.358314165,0.0,0.0,0.0,0.361049255,0.0,0.750616409,0.0,1.91073846,1.34515837,0.0,0.47516522200000005,0.0,2.1111009999999997,2.00054991,1.05581348,0.0,0.567519669,2.22606359,0.0,0.9949841999999999,0.72840323,1.22934197,0.0,0.0,1.49294299,0.0,0.0,0.580810164,0.0,0.379100273,22.307197600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.79721214,2.74534724,0.61367065,0.0,0.0,0.0,1.11319755,1.75389771,1.83923247,0.14236722,1.88326599,0.74135158,0.94459656,0.0,2.5777912,0.0,0.0,4.38422491,8.16101796,4.4941721,0.0,1.96510564,0.74592133,2.64951292,0.0,0.0,1.40098087,2.43796711,0.27818614,1.39182976,0.0,0.0,0.07759131,0.0,0.0,0.0,0.27060505,0.0,0.0,1.35522876,0.0,0.0,0.0,0.0,0.80281967,0.0,3.05692348,1.59958757,0.91624859,0.46917428,3.15269255,4.05350129,2.78097728,0.24363591,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0966188101,0.783125779,1.00763641,0.561002253,0.11310805300000001,0.000724782271,0.00876953647,0.152368925,0.548474311,0.800922905,0.507938797,0.0184775525,0.0,0.0135618286,0.047818711900000005,0.0,0.0,0.00463509645,0.0,0.010589563,0.00958770234,0.0,0.0,0.0500281151,0.0,0.046077418099999996,0.60888717,1.39567808,1.5256708,0.811643342,0.0874717866,0.0,0.0839207639,0.0229330706,0.0,0.0,0.0792248622,0.0,0.0,0.0597420655,0.11961833,0.0,0.0,0.715504735,2.05662977,2.10600234,0.744487004,0.512495437,3.16578828,6.26965421,5.87233143,2.09657973,0.0,0.0,0.8860613409999999,1.25665638,0.519285077,0.016997383,0.0,0.0,0.0,0.0123168201,0.0257860881,0.0,0.0,0.0,0.0419064647,0.35759871600000004,0.727122972,0.586872882,0.0362320538,0.0,0.043173652300000004,0.131511439,0.0,0.0,0.0816725845,0.0631486718,0.0,0.0,0.09435194289999999,0.008475983509999998,0.0,0.016333237900000002,0.0860724702,0.0,0.0,0.058898402300000006,0.0590839688,0.0,0.0,0.0880447815,0.0168255724,0.0,0.00886889304,0.09960895880000001,0.0,0.0,0.0690115142,0.0907094647,0.0,0.0,0.164224415,0.0943586472,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0245246126,0.250577753,0.466856421,0.498560599,0.0607017388,0.0,0.34988753200000006,0.223899535,0.485324405,0.146922597,0.83919369,0.7543017959999999,0.902842319,0.7980016390000001,0.889255075,0.64215212,0.545276704,0.37743818100000004,0.0,0.27768105600000004,0.326936252,0.0434128253,0.407463444,0.0874595801,0.0,0.056936491799999996,0.142214537,0.866577424,1.44570944,0.631577915,0.798649217,0.198788868,0.171139417,1.46558678,1.73545981,2.28872383,1.74605386,1.26242976,0.139732439,0.942166982,1.60860692,1.16543539,1.16443051,1.48286601,1.98778653,3.05484475,2.51502832,1.61691008,1.26359064,1.91359108,3.14742333,4.44883382,4.52617586,3.15002334,1.16649213,0.350401343,0.17838196,0.213024878,0.0,0.0,0.0,0.0,0.21021747899999998,0.0,0.187311166,0.0,0.0,0.18573071300000002,0.274768529,0.16330641199999998,0.0,0.0,0.0,0.373662906,0.502571866,0.0,0.0,0.33927851600000003,0.369222506,0.379413564,0.0,0.0,0.0,0.513380154,0.0,0.003828868,0.20274480600000003,0.0,0.0,0.155278961,0.0,0.0,0.0,0.0,0.0,0.359949694,0.0,0.0,0.243917815,0.0,0.0,0.17643003,0.340142635,0.24396921300000002,0.189516603,0.290341697,0.0,0.0687943722,0.595987264,0.245240058,0.48519541,0.0,0.0,0.0,0.437155313,0.0,0.0,0.0,0.597407535,0.539715497,0.9261233940000001,1.47187952,1.22963832,0.591029009,1.53239201,1.07341428,0.594959647,0.0579643649,0.0,0.19955620699999999,0.644791601,0.0115848345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.92412398,4.8550153400000004e-17,2.15152045,8.18627294,1.25942661,2.32644082,0.332348688,0.0,0.0,0.0,1.5536049100000001e-15,9.71003067e-16,0.0,0.38482479700000005,1.94200613e-16,0.0,0.0,4.8550153400000004e-17,0.0,0.0,1.34688679,0.0,0.0,0.0,0.0,1.25942661,18.0342893,0.262380543,0.7346655209999999,0.0,3.4284391000000003,4.32053294,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0679381775,0.289050553,0.517866343,0.6843069890000001,0.746573881,0.7088026059999999,0.616022736,0.528480755,0.48804628200000005,0.494087524,0.502204795,0.448141095,0.28628848,0.023905789700000003,0.0,0.0,0.0,0.0,0.398906356,1.16745378,2.00984108,2.80907263,3.50007792,4.08536272,4.61376921,5.13246038,5.63656922,6.04394671,6.21193181,5.99333855,5.30891508,4.2030085999999995,2.85374746,1.52754984,0.49237873,0.0,0.0,0.11621915699999999,0.511693573,0.80078999,0.851055221,0.67740424,0.427320583,0.30694082100000003,0.480478157,0.9873444840000001,1.71387931,2.4329582999999997,2.89524912,2.93339623,2.53470646,1.85132662,1.14344979,0.679156187,0.63206418,1.0178411,1.69342582,2.41645662,2.9383722999999997,3.09290439,2.84637323,2.29424811,1.6112554,0.979944653,0.528121686,0.297837725,0.252430351,0.311413393,0.39315079299999994,0.44569004100000004,0.455272158,0.43445870799999997,0.40121201100000004,0.36251566799999996,0.311070635,0.23474278899999998,0.13084700300000002,0.014986609599999999,0.0,0.0,0.0,0.0,0.0528468257,0.114982335,0.11813141099999999,0.0601518347,0.0,0.0,0.0,0.0,0.0054532737199999995,0.0996515773,0.151675729,0.139392917,0.0772456193,0.0116757609,0.0,0.0819943769,0.259018003,0.488863235,0.701348313,0.8265592559999999,0.8234399059999999,0.695830391,0.489102364,0.269602042,0.0968780817,0.00148187648,0.0,0.0,0.011378017800000001,0.006428727360000001,0.0,0.0,0.0,0.0,0.026463663,0.0851253801,0.116227717,0.102816688,0.051448935300000005,0.0,0.0,0.0,0.0508710007,0.155103082,0.24787243,0.291469107,0.26934633,0.19358179399999997,0.09840244470000001,0.0231664955,0.0,0.010070249,0.0506178846,0.0836494563,0.0865516883,0.0583127346,0.0200861081,0.00324124565,0.031254490499999996,0.10521528699999999,0.20100441800000002,0.280150104,0.309081954,0.27680292,0.20144837,0.121731707,0.077149258,0.0869724636,0.13918413400000001,0.19581153,0.212779045,0.164634439,0.061369504400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.240889401,0.301267263,0.151559189,0.0,0.0,0.0517275004,0.0883395169,0.0170221453,0.0,0.184435006,0.512032024,0.6553268329999999,0.38504779299999997,0.0,0.0,0.0,0.36336482600000003,0.57617822,0.127975224,0.0,0.0,0.382489109,2.29928048,3.91072865,4.19328133,3.06603404,1.41874323,0.33428833,0.2279823,0.654512827,0.86994943,0.549254154,0.0,0.0,0.0,0.399716604,0.6401384379999999,0.513715694,0.20575707699999998,0.0,0.0,0.0673661915,0.0677308073,0.0,0.0,0.0,0.036031365600000004,0.0716679693,0.023487264900000002,0.0,0.0,0.0,0.0586945085,0.056166603899999994,0.0,0.0,0.0,0.15996924699999998,0.752265277,1.63723547,2.54806464,3.06071188,2.83898522,1.90782594,0.70784689,0.0,0.0,0.0,0.21280799,0.27398206399999997,0.058445709699999994,0.0,0.0,0.008696909590000001,0.151079717,0.10911468099999999,0.0,0.0,0.0,0.0767871141,0.12012856599999999,0.0237642469,0.0,0.0,0.011292006299999999,0.106362336,0.07580285440000001,0.0,0.0,0.0,0.0725515502,0.110145207,0.0173664416,0.0,0.0,0.0188901169,0.126849565,0.08860441919999999,0.0,0.0,0.0,0.12067772800000001,0.183118528,0.0211742958,0.0,0.0,0.061220717599999995,0.354523765,0.265629034,0.0,0.0,0.0,1.21446227,3.49635773,5.36128161,5.8054761,4.66661266,2.70143669,0.9791678890000001,0.121303105,0.007332864000000001,0.107258115,0.045551011399999994,0.0,0.0,2.60407457e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.258173347,0.0,2.4707559,3.49519558,3.11497152,1.37009577,0.208855357,0.0,0.00575625066,0.822573518,0.0,0.0,0.0,1.75669657,2.71885406,1.06188173,0.0,0.9679514290000001,2.08648455,2.49583283,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.043736137599999995,1.89033843,1.1474046,0.61909632,0.36610708700000005,0.0,0.0,0.0,0.350768332,0.469389706,1.41332129,2.96385136,0.368047865,0.0,0.0,0.15496021,0.546170621,0.0,0.0,0.0,0.206805481,0.47255925600000004,0.0,0.609064893,0.0,0.0,0.0,0.0,0.7587125579999999,0.0,0.0,0.624111909,0.981028305,0.0,1.06463236,2.49030981,4.5049225,0.8388108409999999,0.562879783,1.72830317,2.02543676,0.0124565888,0.0,0.0,0.0,0.0,0.95751408,0.473490643,1.64308375,0.298199562,1.71918814,2.63195041,1.60097944,8.22718797,6.38033236,0.0,0.235769726,0.5023967429999999,0.0535640668,0.973842069,0.0,1.81212017,0.0,0.0,0.0,0.154906037,1.07871623,0.0,0.682535485,0.620995859,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.31446205,1.23206321,0.0,0.0,0.0,1.1961431,0.0,1.03850788,0.0,0.0,0.754174982,0.0,0.0,1.37638952,1.08381344,0.0,1.4005785,0.0,0.0,2.4468812,0.0,0.381707951,0.42272886200000004,0.0,0.0,0.0,1.14032055,0.349032144,0.7831883190000001,0.0,0.0,0.0,2.26821393,2.12661521,2.02976489,1.8656120999999999,0.19971325399999998,0.0,1.42310052,0.982585708,0.853288078,0.21728688,0.0,0.0,0.0426323916,0.0,1.86582057,0.0,2.68999476,0.0,1.23953255,0.0,0.0,2.35197318,0.0,0.0,0.0,0.5059849989999999,0.500860829,0.0,0.8634340509999999,0.94639665,0.0,0.0,0.205049037,0.0,2.19888264,0.0,0.499119129,0.0,1.26738074,0.0,0.0,0.0,0.763188988,0.614931996,3.44016872,3.97208667,1.96801119,0.0,0.0,0.0458777247,0.15054227,0.9450100509999999,2.72505165,2.25819436,0.0,0.0,0.822937932,0.0,0.0,0.0,0.805538706,0.0,0.0,0.0,1.75730247,1.44505528,1.60114051,0.0,0.560924768,0.0,0.013511953,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08977522210000001,3.28345689,0.0,0.8031468970000001,2.87058738,0.14501898,0.6922670559999999,0.0,0.260602159,0.5186320010000001,3.49664257,5.38652067,5.30310215,3.46999624,0.0,0.0,0.0,0.19487084699999999,0.817367915,0.0,0.0,0.0,0.37225026299999997,0.755891538,0.7372955440000001,0.0,0.0,0.0,0.0,0.0,0.152787791,0.320610603,0.0,0.0,0.0,0.588350666,0.0,1.03986754,0.6871405909999999,2.48164754,0.0,0.674495682,0.894321768,0.54920419,0.49363999399999997,0.0,0.0,0.533270083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.217311568,0.257553046,0.217404138,0.10966214,0.0,0.0,0.0,0.0,0.06472054599999999,0.134120107,0.14591443099999998,0.10544178,0.051662005899999995,0.0341763729,0.0841415816,0.195030333,0.323762889,0.411766852,0.414894961,0.326446995,0.181201799,0.0383575041,0.0,0.0,0.00292519471,0.0750009779,0.11209630300000001,0.08730273919999999,0.01088928,0.0,0.0,0.0,0.0,0.0742017656,0.150369482,0.16442105099999998,0.11380745,0.0293156408,0.0,0.0,0.0,0.0246154148,0.0709727622,0.0737348115,0.0349875975,0.0,0.000160750573,0.098527974,0.285274085,0.508444638,0.6848683309999999,0.737838682,0.635744416,0.411536591,0.151436514,0.0,0.0,0.0,0.11210144400000001,0.226939499,0.231850306,0.108261676,0.0,0.0,0.0,0.0,0.116916681,0.348551103,0.418737029,0.250358409,0.0,0.0,0.0,0.0,0.14695793599999998,1.17208792,2.30295385,3.21660519,3.64521328,3.47948125,2.81101113,1.89528878,1.0506502,0.535656904,0.45577036299999996,0.736520695,1.17092796,1.51709904,1.60179509,1.38579815,0.966225865,0.520049102,0.21846503,0.152305718,0.300486352,0.551525446,0.763341142,0.8304245309999999,0.7269132159999999,0.508153019,0.274352322,0.117457859,0.0783542933,0.133946574,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.6790287209999999,1.2794881,0.201460707,0.0,0.20087739300000002,0.047924343200000004,0.0,0.33294466100000003,0.013069312900000001,0.313293954,0.0,0.318525889,0.0,0.200939767,0.053268599900000005,0.253870848,0.370138267,0.0,0.0,0.20416782,0.183250303,0.0,0.0,0.081267639,0.0,0.0,0.0,0.247655472,0.0,0.0408476968,0.0,0.0,0.253291922,0.0,0.18026515,0.148681749,0.17503673600000003,0.0,0.0,0.16510956,0.0,0.0,0.316326727,0.0,0.0,0.0,0.0,0.0,0.41873558299999997,0.0,0.0,0.0,0.30963875399999996,0.278271622,0.14791232,0.0,0.230106996,0.0524902384,0.0,0.0,0.0,0.0164787299,0.0,0.0,0.162210461,0.36641213100000003,0.0,0.0,0.44911250799999997,0.18902310600000002,0.43777110700000005,0.18499126300000002,0.20783054,0.39111417600000004,0.0,0.378388015,0.0,0.0,0.0,0.0,0.0,0.29955825399999997,0.541290729,0.585685648,0.12424734400000001,0.44142902100000003,0.23337106,0.334068066,0.165561023,0.24577983899999997,1.05249182,1.13160321,0.8213490390000001,0.963011136,0.507122533,0.05717650480000001,0.238104607,0.68882898,1.03483762,0.8087752490000001,0.923200723,0.26431890399999997,0.0251170756,0.496793941,0.37617758700000004,0.161140389,0.186824354,0.160796569,0.567106239,0.8500565609999999,0.75981023,0.766448315,0.233382851,0.719527276,0.930722481,1.31401142,1.73953738,2.64053671,2.62935754,2.59025766,2.20489839,2.24556274,2.35802959,2.88962056,1.77976895,2.10339817,2.09190919,2.78460658,3.72757577,4.18303723,4.16690625,2.5427874,1.62750717,0.755231841,0.0640801801,0.0,0.619176838,0.41136896700000003,0.0,0.0,0.0,0.0,0.447182937,0.0,0.0,0.0553442672,0.0,0.0,0.35078043299999995,0.00471016968,0.0,0.135987487,0.511330694,0.803285868,1.00823086,0.645653569,0.485294871,0.0,0.295720783,0.0,0.13769730300000002,0.24044883600000003,0.34925248600000003,0.0,0.0281352567,0.0,0.0,0.128274134,0.0336703002,0.0,0.0,0.0,0.20502405399999998,0.0981908447,0.0,0.0,0.0,0.158361063,0.181380748,0.303441164,0.0,0.0,0.0,0.0,0.43764105600000003,0.321758312,0.43668405899999996,0.0945509334,0.33170876,0.0,0.0,0.180556715,0.174872418,0.31430519100000004,0.0,0.10333783,0.0374248756,0.478995182,0.150557849,0.33879528799999997,0.0,0.0,0.0,0.0,0.0782487761,0.248204802,0.0,0.0,0.0656763446,0.9744981970000001,0.84593313,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.37423618,5.98486904,6.04623566,5.18133583,4.06009882,4.06975056,3.04634965,2.69098227,1.59627858,2.00409236,2.13466415,1.3993531000000001,1.18257096,0.6335540679999999,0.366075136,0.756270482,0.0,0.0602048253,0.0,0.0,0.0,0.0,0.211629662,0.415809475,0.0281211894,0.0,0.0,0.0,0.373212813,0.0,0.488203216,0.911677651,0.39905793100000003,0.804710424,0.0,0.0914888608,0.07396871370000001,0.006481748620000001,0.0,0.0,0.160149058,0.0,0.0,0.0037807780600000005,0.576141647,0.218333442,0.317100167,0.263249451,0.33750197600000004,0.408122173,0.44545504,0.396293602,0.0,0.557002681,0.0,0.0,0.0,0.32910402699999997,0.053487134000000006,0.0,0.0,0.706369765,0.6400300179999999,0.62471836,0.268650014,0.0,0.0,0.0,0.0,0.47908238799999997,1.1139257,2.58307538,3.69499653,4.47636632,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.31138824,0.0,0.0,1.01025556,0.21063483,0.60240735,0.12668156,0.0,1.09441782,0.0,0.2120447,1.03955047,0.02585103,0.0,0.90061601,0.0,0.75156251,0.0,0.0,0.65045457,0.11508309,0.0,0.81449949,0.0,0.0,0.0,0.35274108,0.0,0.0,0.0,0.26948171,0.83335755,2.30955312,1.80619332,1.13702692,2.30637065,2.77061241,2.59867044,2.364442,5.35430078,2.88979736,5.05396176,3.10677839,4.16904375,4.76813696,3.64973308,1.57212446,4.18905963,1.96800932,2.36455014,0.09319974,1.2432303999999998,0.0,0.0,0.24982122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.56167933,0.0,1.22947548,0.0,0.0,0.0,0.90250975,0.45065475,0.04334776,0.63805808,0.0,0.0,0.0,1.40092074,0.38971038,1.48542524,0.0,0.45702040000000005,0.0,0.90740981,0.11651727,0.21429360000000003,0.0,0.0,1.18469874,0.52485856,0.36662259999999997,0.02711307,0.79717233,2.24532864,0.08355365,0.0,0.0,0.88132205,0.0,0.0,0.0,0.51919708,0.0,0.0,0.97470833,0.0,0.0,0.36763829,0.0,0.12528150000000002,0.81334589,0.29544565,0.09727481,0.0,1.34471353,0.0,0.0,0.10289768,0.40192551,0.63115497,1.75356409,0.20407719,0.0,0.93108841,0.0,0.56634454,0.0,0.85407591,0.0,1.44994547,0.01958454,2.22803229,0.29170802,0.80883201,0.0,1.66507133,0.0,0.0,0.0,0.5151437,0.0,0.35146788,0.37554109,0.99557023,0.72558129,0.0,0.0,0.56930067,0.07945362,0.0,1.37986591,0.24837589,0.0,0.0,1.13695982,0.01947099,0.69124241,0.0,0.4141089,0.0,0.78224322,1.25230331,0.0,0.0,0.12807218,1.70318601,0.0,1.48531348,0.67199249,1.71775614,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0741728413,0.5850544670000001,1.00955266,1.27481664,1.34400166,1.22027351,0.942911403,0.576761436,0.197529051,0.0,0.0,0.0,0.0,0.0,0.006698562,0.210492297,0.36256172200000003,0.429967155,0.40126250799999996,0.287299492,0.11723658099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.105786319,0.22325393600000001,0.285803522,0.283494915,0.22094555100000002,0.11542331800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.038179217599999996,0.118448934,0.167135815,0.176328546,0.147314916,0.08957984990000001,0.0180625384,0.0,0.0,0.0,0.0,0.0,0.0,0.004530043389999999,0.04707056900000001,0.07378231219999999,0.08089981980000001,0.06966575,0.0454475781,0.0159351916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0023696828100000004,0.0,0.0,0.0,0.0,0.0,0.00200552279,0.020680538300000002,0.040210675,0.054333349100000004,0.0572093019,0.045290450700000005,0.018729347,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.050067262300000005,0.10679328,0.14483428,0.153014082,0.126205223,0.0671672111,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0570512836,0.16504559300000002,0.243961235,0.273305996,0.24239650899999998,0.153570767,0.0226387885,0.0,0.0,0.0,0.0,0.0,0.0,0.0354797768,0.222102057,0.37366340299999995,0.45285089100000003,0.43545112,0.316721559,0.11397838699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.36168585200000003,0.791108493,1.17551159,1.45808264,1.60113483,1.59343909,1.45212661,1.21865843,0.9496265859999999,0.704291716,0.531523079,0.45900830299999995,0.487179993,0.5893335829999999,0.718079076,0.816857125,0.8340639990000001,0.7366397579999999,0.519951623,0.21148362699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.37951318700000003,0.9088221329999999,1.36291445,1.63327507,1.63821306,1.34340611,0.774751132,0.0202906656,0.0,0.0,0.0,0.0,0.0,0.0,1.46765001,3.30630417,5.21473178,6.95265473,8.29281949,9.05712337,9.14513404,8.54995308,7.35861978,5.73702737,3.90210872,2.08631723,0.5007541529999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.377425303,0.571329152,0.564722518,0.40992728700000003,0.19769875,0.0338725541,0.013778906,0.199736821,0.606157937,1.19512805,1.88314747,2.55744648,3.09840176,3.4034305000000002,3.4075401,3.09647826,2.50998306,1.73464441,0.8879457159999999,0.0967467059,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.237
0.12566806,0.34356555,0.0,0.0,0.0,0.25083543,0.03466631,0.0,0.0,0.0,0.0,0.92015299,0.93780245,0.35739567,0.0,0.0,0.0,0.0,0.0,0.59967648,0.041923,0.4576219,0.63451435,0.19432041,0.08285665,0.34824447,0.63574956,0.37068598,0.33186899,0.0,0.0,0.0,0.59621776,0.46152661,0.05734781,0.71526008,3.40552798,1.98568494,2.54331656,3.89347998,3.77847694,3.07993774,4.03198937,2.19600438,1.51460975,1.34607107,0.71023619,1.10480325,0.0,0.0,0.13737276,1.13989251,0.22180262,0.19051311,0.73057563,1.57404651,0.69964626,0.15086714,1.32286497,1.57160446,2.03005268,0.58906929,1.44240124,0.50443896,0.70576035,1.22233139,0.99765373,0.43188533,0.32953457,2.19879911,0.0,0.10885335,0.80540104,1.75798615,0.61689815,1.28536909,0.0,1.53956839,2.03303845,1.22370564,1.18906784,1.94123156,0.84814891,3.23829648,3.27442528,2.42702752,2.45873949,1.34712079,1.07229797,0.0,0.42205476,0.0,0.0,0.57145743,0.0,0.0,0.0,0.94653466,0.0,0.16543508,0.0,0.0,0.75976509,0.0,0.34743166,0.0,0.0,0.19780944,0.62242538,0.0,0.0,0.24142983,0.06061799,0.91509155,0.81505896,0.37276815,0.31485705,0.0,0.0,0.0,0.0,0.0,0.29441544,0.0,0.61705896,0.0,0.60103345,0.80125586,0.48430328,0.28704697,0.0,0.14108967,0.16899397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.08377078,0.16904005,0.0,0.0,0.03101446,0.03673449,0.40048521,0.57140465,0.4562902,0.75764035,0.67865141,0.0,0.0,0.4849464,0.0,0.0,2.16980738,4.95811332,4.0819605,1.73412153,0.7039055000000001,0.26582746,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.253179996,1.52145852,2.81097303,3.65175012,3.72460927,3.00522971,1.77322621,0.482769149,0.0,0.0,0.0,0.0,0.313583588,0.463225204,0.31446889,0.00689693656,0.0,0.0,0.0,0.0409436802,0.222043447,0.248163971,0.12012901699999999,0.0,0.0,0.0,0.0,0.0874627427,0.180309844,0.154801369,0.034460720099999995,0.0,0.0,0.0,0.0,0.109343515,0.150500871,0.0951272984,0.0,0.0,0.0,0.0,0.0385659653,0.12059302400000001,0.12401223900000001,0.048428215,0.0,0.0,0.0,0.0,0.0727966578,0.12536608,0.0971953961,0.00677735645,0.0,0.0,0.0,0.013565579099999999,0.101724219,0.124824752,0.067459938,0.0,0.0,0.0,0.0,0.05550559150000001,0.127799184,0.11859177900000001,0.0318694821,0.0,0.0,0.0,0.0,0.102436543,0.152659052,0.104693946,0.0,0.0,0.0,0.0,0.0440137145,0.160551061,0.17784384600000003,0.0780207055,0.0,0.0,0.0,0.0,0.128176609,0.243152676,0.205112712,0.0243731067,0.0,0.0,0.0,0.024605349,0.289536109,0.41065383899999996,0.321660614,0.13540716,0.126261601,0.6045632089999999,1.73712094,3.40726182,5.19893281,6.53218839,6.89959288,6.09559495,4.32615739,2.13933044,0.203510949,0.0,0.0,0.0,0.047678263,0.60767041,0.7083443509999999,0.37714842600000004,0.0,0.0,0.0,0.0,0.205670331,0.559113667,0.663187425,0.51674853,0.25501512600000004,0.0546323607,0.0260813374,0.156665832,0.33241102100000003,0.418701469,0.34646385700000004,0.151420257,0.0,0.0,0.0,0.0388564535,0.177275447,0.210173902,0.11376766099999999,0.0,0.0,0.0,0.0,0.10267239,0.204363845,0.17539453800000002,0.0308997939,0.0,0.0,0.0,0.004156233499999999,0.17673103399999998,0.240968159,0.149607453,0.0,0.0,0.0,0.0,0.0988045095,0.28556737600000004,0.30304854800000003,0.12645589,0.0,0.0,0.0,0.0,0.305546403,0.522612193,0.430403108,0.0230089085,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.88640047,1.51189528,1.76768289,2.22052361,0.0,0.18465547,0.0,0.0,0.0,0.0,0.5429861999999999,0.42747945,0.36678909,0.0,0.85027723,0.11254078,4.08328969,3.88442219,3.47241949,4.69327297,4.15291918,3.80883943,3.8770171,1.96423324,2.57289258,2.28400714,1.07715702,1.39744192,0.41459385,2.82917632,0.0,0.91236383,0.0,0.16379604,0.0,0.0,0.0,2.58036221,0.19691605,0.0,0.0,0.51730961,0.0,0.0,0.0,0.35138568,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.56204357,1.56073395,0.0,0.27645858,0.0,0.0,0.0,0.95945867,0.87924545,2.39009578,3.07242444,2.3222597,3.92752721,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.50680451,0.0,0.0,0.301797867,0.0879381672,0.0522714582,0.270409775,0.0293234885,0.0,0.0,0.0,0.0,0.0193595466,0.468892583,0.046519829900000004,0.0,0.278603451,0.0400808775,0.195138636,0.21429573100000002,0.0,0.189916974,0.0,0.0,0.0,0.0,0.0,0.39142621899999996,0.529029403,0.5003449870000001,0.319351455,0.555117937,0.47061369200000003,0.0,0.646290287,0.224431133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.194697006,0.7165954859999999,0.0,0.0712438148,0.363751204,0.535354242,0.0,0.0,0.0,0.0,0.215119416,0.09427311630000001,0.0,0.0,0.0,0.0,0.0,0.014840623899999999,0.0,0.0,0.679761677,0.158070187,0.0,0.344876949,0.673523584,0.893026037,0.0,0.00664403468,0.0,0.261162963,0.0,0.616840352,0.457499321,1.46684526,1.56874458,1.9486902,1.48608564,1.46198425,0.307353494,0.0,0.498588332,0.214178948,0.578495319,0.161502072,0.562796392,1.09501846,2.26237815,2.19827205,1.9214459,2.31233251,1.38674461,0.571247202,0.92146838,0.0,0.0,0.0,0.0,0.22367348399999998,0.0,0.0056666710899999995,0.0,0.6548144920000001,1.4042569,0.24198888,0.0,0.0,0.0,0.0,0.0,0.430879195,0.308928595,0.485773424,0.189583523,0.6931055309999999,1.32281652,1.56268906,2.42313731,1.84154753,3.18932055,2.60674113,2.13371063,2.95789628,3.21548667,2.42400134,2.29316612,1.32704521,2.0362888999999997,2.26359843,2.21993209,1.38730577,3.05765839,1.71223625,2.32373713,1.6345873,0.669951581,0.435640945,0.36188665700000006,0.551690656,1.54313965,0.0,0.572939867,0.28068842899999996,1.0697378999999998,0.53383808,0.21756140000000002,1.34089621,0.556222653,0.7136427059999999,1.4191031,2.16131819,1.55150186,0.776553498,0.554172126,0.0,1.11208442,0.0,0.660768048,0.029744018599999998,0.0,0.0,0.62598286,0.0,0.0,0.22588088,0.42142855100000004,0.0,0.15439836,0.0,0.0,0.0344680573,0.9033278509999999,0.0,0.20481939100000002,1.03164978,0.641946441,1.03472639,0.410587384,1.33048988,0.797490154,0.954600861,1.27925141,1.47548381,0.680913595,0.640514339,0.502257618,0.994241907,0.9031350690000001,2.14486757,2.02240219,0.648553151,1.47736027,0.547759255,1.43345085,0.468066243,0.18349015,0.0,0.0890543216,0.116520901,0.0,0.248994,0.574320001,0.731357045,0.270087779,0.557479423,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.011396340800000002,0.301881811,0.0,0.854267711,0.0,0.133532073,0.0037347902899999997,1.30113139,1.15678157,2.14144075,2.39606124,2.21604675,1.99684675,1.85269262,1.00893798,0.0,0.265144803,0.0,0.0285499465,0.48343990600000003,0.0,0.0,0.39324778,0.0,0.22017709600000002,0.0,0.0,0.0,0.258224679,0.0,0.0581295786,0.872505925,0.12549979,0.0,1.05931743,2.26021389,2.4429325,0.535858773,0.9323403709999999,4.2321088,5.97583678,4.86379629,2.23536431,1.60497722,1.79451647,0.8978489140000001,0.245043832,0.926026615,0.914354751,1.36472216,0.480189935,0.770890638,0.48292257,0.0,0.0,0.270420893,0.35798272600000003,0.39624152100000004,0.8495346309999999,0.5200100670000001,1.17468059,0.9720121509999999,0.0,0.25109495600000004,0.0,0.0,0.0,0.0,0.216703554,0.243478143,0.881771478,0.574700402,0.19900845,0.0,0.35484159299999996,0.0829627186,0.056552839900000006,0.0,0.410201331,0.0,0.0,1.16030092,1.38623908,0.859695767,0.8144745309999999,0.0,0.644306351,2.53083168,2.24441934,1.59535177,0.0,0.0,0.9760689020000001,0.6788367759999999,0.0539864843,0.0,0.95154282,1.60657937,0.666940454,0.397012015,0.41595899399999997,0.45187681,0.139707531,0.0,0.043070523099999994,0.178028639,0.116950115,0.0,0.0,0.327205542,0.0,0.00361605826,0.639292891,0.6027459270000001,0.0,0.272047095,0.455077325,0.0,0.296884988,0.22604364600000001,0.0,0.350537155,0.0,0.0132918257,1.24792928,1.20138689,1.26532166,0.194303655,0.0,0.0,0.725087665,0.0,0.143053718,0.37046967299999994,0.209765825,0.419640801,0.0076052119,0.248294775,0.857710723,2.05906691,2.57895426,2.33774104,1.92901763,2.06124451,2.83542602,3.35086719,1.52267175,0.8686390429999999,0.610583707,1.43754522,1.37364683,0.578699689,0.0,0.0,0.0,0.08461676060000001,0.0,0.3318939,0.0,0.0,0.19495820600000002,0.0313877015,0.0,0.20304454800000002,0.42745717,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6077701179999999,0.0,0.0,0.0195852021,0.6868487529999999,0.238473552,0.653650622,0.0,0.0252163755,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.449228632,1.28076621,1.89054236,2.81876858,1.63354156,1.51044446,0.946350137,0.730926282,0.872998098,0.571368793,0.047688106900000006,0.722316857,0.43613474700000004,1.55851331,1.31042472,0.702059971,0.584315341,0.698576977,0.0,0.0,0.36870322,0.288002898,0.44510426,0.9782706870000001,0.808950918,0.252478228,0.0,0.0,0.0,0.0,1.11682908,0.0360135476,0.11523767800000001,0.0,0.0,0.534146099,0.5141720999999999,0.36009785200000005,0.0,0.648534745,0.0,0.0,0.9545538,0.410491426,0.8259356390000001,0.0,0.813298693,0.0054990358100000004,0.0,1.0544364,1.06763179,0.237751646,0.0,0.600337181,0.480729321,1.17037592,0.0,0.46263095299999996,0.0,0.0,0.0,0.654955564,0.9386676629999999,0.0,0.00561053427,0.195571789,0.0,0.0,0.261362473,0.0,1.47463017,3.01144772,5.8178884,7.81485524,10.239686099999998,8.64480427,5.14555653,2.28011897,0.811695253,1.24551471,2.69562936,4.26860063,4.19039062,1.95723402,0.7945940159999999,0.0,0.0,0.0,0.40517403799999996,0.060400422999999995,1.07215751,0.6747864720000001,0.0,0.0,0.0,1.35998673,1.22364157,0.0,0.0,0.0,0.0,0.0,0.623656148,0.717114294,0.0,0.0,0.0,0.09730179779999999,0.0,0.965743089,0.0,0.0,0.0,0.747962192,0.198575059,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.233
0.8260849,0.0,1.15204696,0.71798405,0.23964441,0.09578061,0.71574198,1.38162956,1.50211039,0.0,0.0,0.0,0.0,0.0,0.0,1.91183467,0.0,1.24062438,10.5895621,3.26050541,0.0,2.28727106,0.0,0.0,1.74517849,0.22902133,0.86826941,0.68583098,0.6382585999999999,0.90135088,0.23605019,0.0,2.20138761,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.5441002500000005e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.5441002500000005e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,92.46527640000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.71040724,0.152987313,0.0,0.265534214,0.0,0.148537284,0.0,0.330586817,0.0,0.0,0.427061942,0.0,0.224994754,0.200168298,0.105401245,0.0,0.0,0.0,0.548863099,0.0,0.0,0.0,0.38559905,0.0,0.0,0.0,0.299912583,0.0,0.0,0.0,0.32310706899999997,0.0,0.25603554300000003,0.37031091,0.0,0.213658867,0.0,0.36181455799999995,0.0,0.30969707399999996,0.0,0.46426732299999995,0.0,0.47961715899999996,0.0,0.0158861267,0.22073473100000002,0.45348275600000004,0.187595823,0.121587555,0.118196261,0.0,0.0,0.0,0.0,0.570797846,0.0,0.28383101899999996,0.31742037100000003,0.0504494292,0.28046499399999997,0.0,0.0,0.0,0.062930409,0.006487015160000001,0.0,0.0,0.0,0.0,0.774999173,0.715407274,0.388880479,0.0102175748,0.0,0.351507154,0.0,0.0843759631,0.0,0.0,0.0,0.0,0.344427246,1.14403028,1.21420146,2.85511724,3.22715182,3.92071717,4.29199899,4.52401751,5.58946982,5.4498948,4.74570151,4.08421056,3.92929956,3.30955522,2.12045842,1.69071173,1.37182896,1.13234802,0.504644919,1.20861927,0.30228644,0.940217335,0.546533791,0.54686955,0.814040358,0.743327057,1.01915939,0.267218974,0.285717421,0.21288244,0.137274914,0.0425957428,0.35502558100000003,0.469466965,0.556610021,1.10614685,0.8285368409999999,1.7612173999999998,0.9980817059999999,0.874207648,1.46422283,1.09328668,0.445585866,0.283473007,1.04483298,1.07492803,0.262176035,0.409933392,1.04714308,1.39470924,0.9783693109999999,1.25975769,1.35986251,1.34984621,2.01619679,1.40953362,1.06621316,0.704536803,0.61426904,0.725705541,1.04918608,0.824971192,0.013966456399999999,0.244633557,0.447925817,0.29460684600000003,0.0,0.575127953,0.0,0.472756835,0.0,0.0608246139,0.426786764,0.0,0.0,0.42946137100000004,0.0,0.0509354516,0.126625995,0.0,0.460025358,0.439569744,0.0,0.0,0.0,0.247873873,0.0,0.0,0.0,0.01078256,0.425147585,0.0,0.0,0.263998524,0.0,0.19758765,0.163285768,0.0,0.0,0.10359097699999999,0.0,0.0,0.0,0.077064812,0.0,0.0,0.28707508800000003,0.18687137899999998,0.448736746,0.0,0.140950787,0.0,0.0,0.147913121,0.0,0.44058301899999996,0.000429782056,0.299013197,0.0,0.141560816,0.0,0.0,0.0,0.467760656,0.199982192,0.0,0.0,0.126492526,0.0282567658,0.0,0.219159202,0.460249078,0.0896896098,0.14611834199999998,0.00153332177,0.0884354461,0.0,0.0,0.0,0.0,0.0,0.39054692,0.599943804,0.0,0.20297142699999998,0.581526134,0.7882933670000001,0.0,0.26730095,0.294386957,0.862684778,0.572627085,0.246844101,0.747831375,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
6.05397474,5.62953728,5.79618121,4.66109392,4.72623067,3.16312053,2.74099892,2.34898813,0.896762423,0.9267193109999999,0.191982338,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10977401,0.370023691,0.0,0.15176795199999998,0.8381858640000001,0.44081568200000004,0.20797592899999998,0.593842228,0.0407913598,0.735638888,0.0,0.314343212,0.18762556600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.318889468,0.564492056,0.0,0.0,0.435100389,1.02103228,0.6775072459999999,0.650466175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.049893924400000005,0.0,0.281682186,0.0124158001,0.0,0.0,0.384593303,0.37181365899999996,0.44976119,0.0293589081,0.0,0.0195610693,0.0,0.0,0.0,0.15932758800000002,0.0,0.0,0.0,0.0,0.23567026100000002,0.331824258,0.0,0.21214295600000002,0.7821042659999999,0.184230363,0.0650504255,0.208440247,0.398336736,0.433258829,0.0,0.0,0.372171474,0.0,0.0,0.0,0.0,0.111340316,0.0,0.0,0.0020903657500000003,0.16693522800000002,0.33560212,0.427951449,0.128077757,0.0265592588,0.700303875,0.569171524,0.122949955,0.275734305,0.252484074,0.310744519,0.0,0.409207227,0.0,0.0,0.0,0.0,0.031045750499999997,0.0,0.0,0.0,0.0,0.524504921,0.186162225,0.017736616,0.131950923,0.0848777008,0.0,0.0,0.650751661,0.0,0.0,0.0,0.29342334,0.15228335199999998,0.0,0.0,0.0,0.0,0.205249054,0.0,0.0,0.0,0.448853245,0.528984773,0.151052791,0.7456711559999999,0.08911206890000001,0.0,0.0,0.0,0.0,0.225734195,0.0,0.0,0.0,0.0184405646,0.0,0.17337667199999998,0.0,0.0,0.197240649,0.840484103,1.20324093,1.47532871,1.43838607,1.51343672,1.41087604,0.871008517,0.616601128,1.26372146,0.7962199059999999,0.313982895,0.7377350709999999,0.33571299,0.782931305,0.791368935,0.0,0.51669565,0.649469351,0.7130043009999999,1.35269183,1.37726738,1.05354872,0.879415655,1.39276046,1.44042697,0.576555555,1.01277921,0.6024785420000001,0.19270025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.130581232,0.997095139,0.982460876,2.20759356,2.92802712,4.10762809,4.31687562,5.38271654,5.188863099999999,5.80505457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.119010451,0.430406216,0.579429738,0.562419145,0.46485217700000003,0.41548392700000003,0.528659591,0.8557726040000001,1.36234725,1.93742388,2.43042885,2.70152111,2.66752271,2.32798833,1.76354651,1.10846044,0.507912182,0.07495725219999999,0.0,0.0,0.0,0.12500836199999998,0.234840973,0.250950568,0.172268113,0.0363819222,0.0,0.0,0.0,0.0,0.0,0.0694138597,0.133503701,0.14134475400000002,0.09781343029999999,0.0260988615,0.0,0.0,0.0,0.0,0.0,0.022886003199999998,0.045298912000000004,0.0454674632,0.029306848700000002,0.00816080448,0.0,0.0,0.0,0.0,0.000642284243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0511936326,0.272626843,0.641586566,1.14007409,1.70233885,2.22260415,2.57919651,2.6696065,2.44584987,1.93757154,1.25284026,0.553169095,0.008028627359999999,0.0,0.0,0.0904916256,0.48158570799999995,0.7710019859999999,0.792281527,0.47080017,0.0,0.0,0.0,0.0,0.0,0.31612128899999997,2.11010142,4.1576219,6.06756459,7.45510041,8.04139369,7.72534123,6.60654645,4.95345404,3.12708237,1.48384584,0.286468288,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.27003056,7.02697587,5.88805386,4.4399561,3.62613644,2.91173272,0.986104051,0.555655482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.482897653,0.452978664,0.479546569,1.33783652,0.955257954,1.5046645,0.709123287,1.05821908,0.47767434799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.00475493,0.8583317490000001,0.565010552,0.0,0.593345355,0.833024007,0.703427136,0.929388337,0.0,0.328121552,0.1070605,0.0,0.0,0.35585996799999997,0.0,0.208268387,0.0,0.470419143,0.149013654,1.01850096,0.0157400834,1.25856001,0.666042568,0.658085227,0.798126604,0.45315531299999995,1.08147259,0.15829519,0.968696563,1.11954718,0.292477879,0.205920082,0.213690916,0.48124692799999996,0.0,0.5351635060000001,0.0,0.619599359,0.0411024616,0.0,0.0,0.18062231899999998,0.55271861,0.6927776170000001,0.433153147,0.291421907,0.236997915,0.6312600420000001,0.625380129,0.7272274000000001,0.45290647700000003,0.598775585,0.371700077,0.0,0.0,0.0,0.41178188,0.0,0.62670315,0.384570003,0.326818043,0.145486816,0.0535251987,0.643313657,0.7417660209999999,0.0,0.314448026,0.651121088,0.685524224,0.0,0.0,0.0,0.0,0.572438931,0.780318252,0.0724626963,0.0,0.0546491133,0.14089760699999998,0.0,0.0,0.565815727,0.0168468409,0.471800655,0.0,0.0,0.0,0.0,0.0,0.408126483,0.08953080599999999,0.142861497,0.803464898,0.134491824,0.689068315,0.0,0.731006095,0.0,0.0,0.0,0.749625691,0.275147619,0.0,0.5233822579999999,0.0,0.0,0.0,0.45021711,0.052588583,0.294218229,0.906112246,0.07559669940000001,0.9408839809999999,0.486531627,0.0,0.0,0.0,0.563059847,0.0,0.17627910800000002,0.0,0.311263578,0.0,0.0,0.191303643,0.45386531399999996,0.0,0.0,0.580836821,0.136203865,0.725083743,1.14800803,0.0,0.0,0.452252098,0.0,0.0,0.09598075029999999,0.000120686751,0.0,0.9523060809999999,0.638609188,1.30419103,3.22099033,3.34023174,5.07299651,5.95752581,7.11020142,7.50152918,7.95971038,8.47948366,8.00755043,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
0.968186999,0.0,0.291850867,0.0,0.0,0.243378245,0.0,0.0601539537,0.0999525017,0.0,0.197115485,0.0,0.0,0.203170632,0.0,0.129813861,0.0539041943,0.0,0.306684723,0.0,0.0,0.450233922,0.0,1.70565858,2.52754003,0.396009629,0.0,0.0,0.0399664093,0.159189962,0.0,0.96406116,0.616061641,0.8967138170000001,7.67848348,9.74825896,5.22760043,5.31375508,6.35526779,5.57033618,5.41021543,3.1568058,1.30878376,1.41889482,1.18977803,1.0680291000000002,0.36198190700000005,0.704641053,1.98440297,0.7565845409999999,0.598266258,2.30231187,1.43551873,0.165572088,0.38340817899999996,0.346568618,0.11870712900000001,0.0,0.0,0.0152444929,0.045546366100000006,0.238851586,0.0287070338,0.0,0.0933697589,0.0,0.0,0.056546727000000005,0.0,0.052434176799999996,0.0,0.0,0.066213574,0.0,0.013343965400000001,0.0341047087,0.0,0.059865115,0.0,0.0,0.0699616139,0.0,0.041110260600000004,0.0268908937,0.0,0.131438721,0.0,0.0,0.22697947699999999,0.0,0.669647662,2.56326983,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.85011706,1.36095836,0.63958392,0.7978225999999999,0.89385041,0.0,1.42447749,0.0,1.0682607,3.57887897,1.97642682,1.1377968,2.16920432,0.0,1.3139054,3.12383877,0.0,0.0,12.16680738,5.10670713,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.126770404,0.35519770700000003,0.073962417,0.403835614,0.495648476,0.226254275,0.126638704,0.317092396,0.42853370700000004,0.6492658029999999,0.286353982,0.6038303110000001,0.624340729,0.30788461699999997,0.44711200799999995,0.46121409700000005,0.582600742,0.4796647,0.63559848,0.7322903909999999,0.675771405,0.826656217,0.724973208,0.6568277260000001,0.8260689840000001,0.598584955,0.833246231,0.559434281,0.646968239,0.5612473920000001,0.435029344,0.7909794370000001,0.27161764899999996,0.313612487,0.781013375,0.598834996,0.48324080700000005,0.576839098,0.594655687,0.615918752,0.355835556,0.155265138,0.552826489,0.170699248,0.6406131939999999,0.231808044,0.806770555,0.449960043,0.660401982,0.569190656,0.701214015,0.901271519,1.03504326,1.59274151,1.53513282,1.94671558,2.09964887,2.48410597,2.65762957,2.52486478,2.47022516,2.58249881,2.72909816,2.93346229,2.94973562,3.41233722,2.8947121,3.41555984,2.91994171,3.26326256,2.67507152,2.96230405,2.44398302,2.43599353,1.76177247,1.93438321,1.22676322,0.931272953,1.0982413999999998,0.8049159109999999,0.735459138,0.149134,0.23076909199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0333577342,0.0257229216,0.0,0.284937289,0.0,0.46834204399999996,0.182931631,0.0171445596,0.00109254341,0.0,0.0731007986,0.057873812000000004,0.18348694100000001,0.317156582,0.0201023441,0.0,0.0,0.0,0.0,0.0,0.11376641,0.0,0.156734109,0.0,0.0,0.0740328126,0.202412532,0.0,0.0567849909,0.13987670900000002,0.08716854539999999,0.0,0.211566365,0.0,0.264680278,0.233551232,0.0,0.0,0.323251018,0.11675823800000001,0.0,0.0,0.0,0.112696277,0.218166885,0.124624433,0.214194136,0.18620974,0.0,0.137106421,0.27916575600000004,0.182618526,0.0162097387,0.0,0.139044116,0.21367867,0.0,0.0,0.105101623,0.0932511928,0.0,0.271141907,0.0,0.11938768599999999,0.0738218567,0.201376794,0.0,0.102518355,0.015274117299999999,0.0,0.0,0.24401790899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.745093344,0.0,0.0,0.0,0.147755629,0.349978665,0.0,0.967187095,0.0,0.0,0.28344826300000003,0.521367983,0.0,0.568925518,0.0,1.25251996,0.0,0.0,0.144436548,0.0,1.79273066,0.8877037640000001,0.474639427,0.326537783,0.275376487,0.611195638,0.68851672,0.0,0.919513543,2.64101583,3.66482824,1.0401201999999998,0.0,2.23058371,0.22505825100000001,0.0,0.694390335,0.0,0.0,0.0,0.19147096,0.39661858200000005,0.0,1.19088711,0.362740475,0.282281916,1.92093588,0.0,0.587799306,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.19249128,0.0,0.6662929120000001,0.0,0.0,0.892490303,0.484670589,0.901838322,1.27112741,0.0,0.324304834,0.6742556679999999,0.624186212,0.0,2.38380467,1.50525165,0.07812979469999999,1.09104875,0.579632526,0.0,0.0,0.0607923423,0.0,0.272238978,1.23106761,0.324545242,0.685221702,0.482629772,0.0,0.247273102,0.0,0.0810450936,0.0,0.39707289,0.0,1.93018964,0.475898758,0.913158343,0.258293992,0.0,0.53562991,2.22843128,1.30578465,0.35307309299999995,0.758709165,0.0,0.0,0.0251796371,0.0,0.64155015,0.9416037820000001,0.0848059227,0.5406511479999999,0.666692965,0.0,0.79047035,0.0250025888,0.249377837,0.0,1.03268615,0.134434234,0.443754976,0.00387594698,0.696991116,0.508524455,0.0,0.633627499,0.344245562,1.63708468,1.01728713,0.08412615119999999,0.0,0.0848874691,0.0,0.0,1.58379714,0.0,0.117722765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.011238676299999998,0.0310844639,0.174601349,0.23404606100000003,0.136548724,0.0,0.0,0.0,0.0202907625,0.064487752,0.036491932000000005,0.0,0.0,0.0,0.0063873900300000005,0.0063575116899999996,0.0,0.00567229922,0.0207196023,0.0138822983,0.0,0.0,0.0,0.055966888799999996,0.125077494,0.11375702,0.0306117295,0.0,0.0,0.07094938740000001,0.107440976,0.0177331462,0.0,0.0,0.0,0.264130696,0.40343468899999996,0.252159339,0.0,0.0,0.203683379,1.0256546999999998,1.85381676,2.17190397,1.76384261,0.8684776679999999,0.0,0.0,0.0,0.33642138,1.24199646,2.31659958,3.4132227999999993,4.23845679,4.39870994,3.65555703,2.18784236,0.591574365,0.0,0.0,0.0,0.496232994,0.7020921809999999,0.446890169,0.0663556342,0.0,0.369959601,1.02422481,1.54756141,1.62569445,1.22250079,0.575562217,0.0388342836,0.0,0.203371177,0.8220336840000001,1.43948523,1.74637512,1.58790676,1.04630946,0.39039971,0.0,0.0,0.0,0.054864906100000006,0.14918678800000001,0.116735066,0.029999277999999997,0.0,0.0,0.014347136299999999,0.025215616899999998,0.00944384528,0.0,0.0,0.0,0.00150157507,0.0,0.0,0.00722561573,0.0136903725,0.0038033205100000004,0.0,0.0,0.00833139558,0.0438788945,0.0465991667,0.00235647458,0.0,0.0,0.00300605484,0.0684337027,0.0672415433,0.0,0.0,0.0,0.025344340899999998,0.126114058,0.102311872,0.0,0.0,0.0,0.107260365,0.405263296,0.533430891,0.411447665,0.167214583,0.0103917112,0.028039547,0.106621779,0.0653882113,0.0,0.0,0.0,0.380590505,1.0158916,1.40780106,1.36101747,1.01910405,0.735397867,0.762209648,1.03785736,1.25846591,1.15926174,0.7453287820000001,0.271839985,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.791505702,1.66722722,0.303195202,0.0,0.0,0.445251002,0.242404869,0.0,0.39605099,0.0,0.45152396,0.607850071,1.91599055,0.00502962067,0.480456283,0.397598666,0.411980269,2.2088702000000002,2.28284281,3.42736354,3.32689559,2.59314663,2.95803243,1.93846307,1.71343489,0.89744619,0.0,0.0,0.0,0.0,0.175475938,0.895200222,1.64459543,0.186590598,1.33977022,0.0,0.0,0.0,0.0,0.8439126229999999,0.72253671,0.166395941,0.8450619309999999,0.71607425,0.35588534299999997,0.0,0.553310052,0.0,1.09758216,0.0,0.626221644,0.0,0.0,0.0271398819,0.0,0.173660163,0.0,0.0,0.0,0.180599924,0.0,0.866083402,0.7006380640000001,0.0,0.0921157943,0.0,0.1752716,0.0,0.0,0.0,1.83370003,1.15816197,0.45210919200000005,1.41012996,0.8896094659999999,0.0,1.73112956,0.77929334,0.858051074,0.843712716,2.05335015,0.959178008,1.78285107,0.321536108,0.0,0.0,0.0,1.55712818,0.910038778,0.0,0.166874394,0.710258266,0.0980901833,0.635606993,0.0,0.678526362,1.15708936,0.93869754,0.0,1.01216587,0.0,0.0,0.625301549,0.615899259,0.68513096,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.03458342,4.88553435,4.46304265,3.80814998,2.98501157,2.07338547,1.15939194,0.325726947,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.282448645,0.730135493,1.10465538,1.36978722,1.50682758,1.51498106,1.40939826,1.21732325,0.973038165,0.712406568,0.467809728,0.264149184,0.11637997,0.028777729300000002,0.0,0.0047341901,0.0381434842,0.0780426395,0.108727235,0.11928169400000001,0.10494456699999999,0.067278667,0.013223188700000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0220191421,0.08435189929999999,0.13266368,0.158291441,0.156434834,0.126986706,0.0745762678,0.00782851416,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0370479213,0.117790238,0.183515782,0.221690592,0.22325852899999998,0.184287906,0.106997106,3.26685065e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.149470624,0.468455385,0.8333125090000001,1.21670751,1.58713395,1.91207769,2.16147626,2.31108627,2.34535925,2.25946154,2.0601551,1.76537826,1.40251581,1.00551019,0.6111187539999999,0.25474686399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0368753927,0.195082945,0.319554525,0.387940385,0.38811890600000004,0.31999959999999994,0.19555385600000003,0.0370150748,0.0,0.0,0.0,0.0,0.0,0.0,0.10377056400000001,0.35591367399999996,0.601736385,0.8009008000000001,0.917077768,0.92406807,0.8108324240000001,0.584614006,0.271575285,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.517517997,1.30873001,2.18241771,3.05924545,3.85477876,4.48926319,4.89706867,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.598715224,0.0,0.317696325,1.15843464,0.0,1.50859633,0.0,0.72641552,0.257375407,0.7359004229999999,0.0,0.661355922,0.654051744,0.0,0.12236133199999999,1.14120734,0.42917286600000004,0.0,0.196904095,0.04326127900000001,0.0,0.0,0.0,0.0,0.0,0.026744266000000003,0.139287946,0.0,0.42165820600000004,0.276259422,0.728199782,0.616034341,1.24085361,2.19516558,2.07066605,2.13831404,1.33826575,3.18799511,2.92819291,3.11334046,2.84705712,3.41895528,3.78152451,3.0139011000000004,2.21725557,1.52602358,0.976655067,2.33231766,2.23061378,2.52202222,0.698037164,0.231120403,0.669631875,0.347513763,0.0808658383,0.0,0.23884468,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.299380662,0.0,0.0,1.17859712,1.20065994,0.0,0.991417997,0.11488226900000001,0.0885255246,0.567652955,1.64858327,0.370651776,1.4830614,1.50361214,1.29895529,0.8584633079999999,0.8672450829999999,0.730196787,0.310835666,1.54142608,0.7540013040000001,2.00783378,1.98934655,1.09906734,1.5154596000000002,1.909648,1.00448163,1.69542088,1.75938531,0.67828117,0.901183402,1.50301464,0.7796890890000001,1.26889905,0.495448809,1.75000241,0.6914115809999999,0.0,0.0,0.0,0.131631589,0.422480016,0.112172996,0.0,0.0,0.155585479,0.0,0.260586583,0.0,0.0,0.0,0.46673863,0.076705748,0.8939470890000001,0.0,0.0,0.491452609,0.0,0.0,0.0,0.0,0.0,0.562418608,0.0,0.0,0.00831105759,0.194379944,0.0286067923,0.0221470352,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0132087956,0.23349121899999997,0.9523406259999999,0.223523138,0.655080795,0.0194795621,1.4079792,0.0,1.19353678,0.292659551,0.0,0.0,0.672824256,0.91089544,0.0,0.0,0.564430297,0.443307909,0.15555824599999998,0.9285091440000001,0.35744837700000004,0.0,0.285463081,0.0,0.0655564791,0.0,0.0,0.30135275,0.0,0.0,0.0402500604,0.26716961100000003,0.0,0.701692566,1.06388757,0.0,0.0,0.0,0.0,0.817386299,0.0,0.57041438,0.425399694,0.38819745899999997,0.572500723,0.0,0.30448046300000003,0.0,0.546233416,0.960066898,0.0,0.525871688,0.0,0.0,0.0376262538,0.0683619014,1.06665285,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33297545100000003,0.0,0.24859692600000002,0.893911285,0.0710003132,0.0,0.201965767,0.0,0.44376559,0.0,0.0,0.0,1.30563712,1.54537842,1.66461746,2.29187887,2.04869117,2.41626851,3.52621566,2.7205207000000002,2.86666914,2.68140381,1.51634507,2.39601573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.451967171,0.998165073,0.730230512,0.0,0.18083682,0.274517215,0.233805729,0.0,0.0,0.0,0.0,0.161868376,0.0,0.415701141,0.29651843899999997,0.0,0.9921279340000001,0.39282243299999997,1.83410795,0.0,0.0826213446,0.368817665,1.12493662,0.203240476,0.155549027,0.428769843,0.328695592,1.87996265,1.72343432,1.13365647,0.0,1.27525141,0.199187218,0.0,1.12402141,0.00951738148,0.6984703459999999,0.31161747100000003,1.00861293,0.0,0.0595331595,0.6122820520000001,0.0,0.755896606,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.9661625429999999,0.837499271,0.676337787,0.511359375,0.357242118,0.221202638,0.110422665,0.0345357557,0.00143805244,0.00945877215,0.0418239371,0.068815572,0.059238287699999996,0.0,0.0,0.0,0.0,0.0,0.37047289899999997,0.947766647,1.64420907,2.32999084,2.8573771,3.10412225,3.01160442,2.6040064,1.98131793,1.28829279,0.670184121,0.23073562,0.00672901681,0.0,0.0336077037,0.11792298300000001,0.153330019,0.11621049900000001,0.0262996536,0.0,0.0,0.0,0.0,0.00610135336,0.0595845315,0.0676331057,0.0365709328,0.0021209846,0.0135025966,0.109314251,0.296045585,0.539321375,0.77273935,0.9216188120000001,0.932348952,0.7951935859999999,0.550677677,0.276206159,0.057682260199999995,0.0,0.0,0.118929028,0.27161870899999996,0.36917785299999994,0.358876278,0.235115112,0.041009084700000004,0.0,0.0,0.0,0.0,0.0257786684,0.184753205,0.261060199,0.22323867,0.0887145811,0.0,0.0,0.0,0.0,0.0,0.140296793,0.25090896,0.25180811399999997,0.14142871099999998,0.0,0.0,0.0,0.0,0.142682145,0.49108828,0.832843945,1.07191049,1.14594939,1.04699846,0.821065355,0.5475857510000001,0.307712523,0.154564994,0.09723117740000001,0.104146694,0.12314885800000001,0.10856880199999999,0.043091003899999994,0.0,0.0,0.0,0.0,0.0,0.117707416,0.210041313,0.214392019,0.120070383,0.0,0.0,0.0,0.0,0.0,0.121515947,0.297997071,0.357517798,0.258221808,0.0239220687,0.0,0.0,0.0,0.0,0.121174836,0.637139359,1.11266169,1.41546877,1.47385386,1.30308382,0.9980392690000001,0.694170884,0.511750811,0.505726272,0.642084429,0.811747188,0.878267549,0.741684232,0.39335358299999995,0.0,0.0,0.0,0.0,1.00894319,2.48267647,4.1642117999999995,5.71905674,6.81780597,7.22761487,6.87528889,5.86277015,4.43192213,2.8920397,1.53466744,0.562509895,0.0522806121,0.0,0.150234184,0.466539992,0.766107825,0.960339983,1.02087132,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.166380744,0.394228329,0.022641463599999998,0.0664992674,0.762688763,3.36746819,3.24625631,3.74756043,3.27533776,1.2180038,1.64462538,0.0,2.43341493,3.6192076,1.97345333,0.716400865,0.536081708,0.745730947,0.517456942,0.700788585,0.64267052,2.23156985,6.05060804,0.0,2.00710495,0.0,5.32448953,8.86061682,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.474945956,0.509192816,1.90093069,0.9527184459999999,1.61082216,3.65664146,3.60498402,6.34970107,7.39040391,8.46450646,7.72597884,6.303334400000001,5.73981612,2.75755846,2.52092976,0.553765566,1.01716919,2.85658942,3.17001514,2.59666482,2.5148037999999997,1.4152557,0.6367679479999999,0.0,0.0,0.0,0.0239425064,0.062958044,0.29252666899999996,0.566088835,0.0,0.0,0.0,0.444818941,0.5777606470000001,0.5653318279999999,0.0976494522,0.53328279,0.42816559600000004,0.337101979,0.0,0.0,0.695876632,0.0,0.0,0.671502279,0.0,0.0,0.0,0.0,0.444837208,0.0,0.642425084,0.21079144,0.0,0.810732125,1.32860295,2.00314942,2.15542186,1.08450461,0.965011827,0.251025249,0.0,0.0,0.0,0.268986375,0.0,0.518229186,1.18113744,0.0,0.34867517200000003,0.0,0.00431638001,0.0,0.0,1.36086019,0.782617989,0.645623605,0.9055169,1.13525042,0.0,0.0,0.0660724849,0.0,0.0,0.584354366,0.0,0.320974325,0.254587328,0.769643491,0.352183872,0.0,0.766729023,0.0,0.0,0.0,0.0,0.0,0.703421029,0.82601016,0.541766827,0.358175144,0.0,0.61385278,0.45821433899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0874368534,0.0,0.0,0.0,0.733250482,0.22652732399999997,0.0,0.0,0.158591768,0.0,0.525681397,1.00188354,0.0,0.0,0.16239251400000002,0.44805423899999997,0.0,0.36376375200000005,0.0,0.798188845,0.22702750100000002,0.5526818729999999,0.636580951,0.704942315,0.105259961,0.0,0.345657393,0.531823522,0.0,0.562455215,0.721581211,0.0,0.0,0.8073625740000001,0.8667962379999999,0.0,0.0,0.11887149699999999,0.19992412899999998,0.0,0.683453753,0.0,0.497389133,0.6419994370000001,0.0,0.46510374600000004,0.0591124837,0.380140927,0.0,0.810160427,0.0,0.7899836990000001,0.0,0.0,0.0,0.0,0.380482325,0.551789626,0.892811351,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.57352426,16.127632300000002,0.0,2.84960826,2.79424444,9.83849772,16.7124381,0.0614236481,0.0,0.0,0.0183164442,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.237
0.27337803899999996,0.544176818,0.0,0.0,0.14200759699999999,0.0,0.307350756,0.5650367270000001,0.5972826139999999,0.0,0.820255758,0.7702928000000001,0.145534661,0.0,0.0,0.7053808559999999,0.7993220790000001,0.30624076,0.251886124,0.414863886,0.637731898,0.038108282400000006,0.0,0.0,0.39138646,0.0,0.35349271200000004,0.9999307759999999,0.70074976,0.0,0.485840924,0.403046415,0.254753445,0.0,0.0,0.288278386,0.0,0.353791996,0.701205703,0.595289738,0.0,0.0,0.0,0.31586044399999996,0.0,0.0,0.7053280559999999,0.0,0.0,0.0,0.583017009,0.0,0.0,0.25197902699999997,0.380846646,0.598796074,0.35578949200000004,0.0,0.48848420600000003,0.0,0.0111919399,0.5758020939999999,0.0,1.14980661,0.0,0.630912981,0.261962216,0.0,0.0,0.0,1.46620973,0.22698265899999998,0.0,0.216625962,0.134116015,0.147742224,0.0,0.0,0.0,0.0,1.28910455,0.452587081,0.61118858,0.874177146,0.0,0.117635368,0.0,0.0,0.970886565,0.549049666,0.0,0.0,0.0,0.42513511299999995,0.0,1.37741997,0.496151236,2.97516772,3.52021885,3.43787759,2.77003518,1.53560993,1.27624976,1.10666446,0.796838638,1.7126186,1.15605951,1.0371666,1.12171961,0.0,0.240751902,0.80088626,0.0,0.0,0.28373563399999996,0.26085320300000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.60820158,0.0,0.31053342100000003,0.0,0.924155925,0.40405619,1.53480353,0.0,0.0,1.00522907,0.0,0.0,0.0,0.0,0.0,0.0,0.0407098924,0.23579225899999998,0.10612117800000001,0.648837363,0.165174669,0.0,1.24973784,1.23354275,1.18051313,0.9616899859999999,0.0,0.0,2.46761674,0.0,1.326586,1.6484727,2.10885408,0.9818184679999999,0.297448723,0.0,0.7901225340000001,0.0,0.0,0.865080829,0.121395368,0.9190757279999999,0.0,0.0,0.0,0.0,1.38946889,0.0,0.905934138,3.47511118,0.0416179541,0.0845568108,0.0,0.0,0.0,0.579518239,1.95968906,0.270103153,0.94084869,0.16023162800000001,0.646267533,1.71140274,0.0,0.872014614,0.0,0.619505705,0.055918815999999996,2.2969294999999996,3.4883733,4.30112891,0.0,0.0,1.70964169,7.63424136,6.88312131,2.60966832,0.0,0.0,1.45627248,2.28806057,1.67184569,0.384935252,2.25498811,0.26766893399999997,0.534197134,0.0,0.0,0.0,0.0,0.21776026699999998,0.0,0.5145259520000001,0.735402267,0.23095226800000002,0.0,1.60583335,0.7216664629999999,0.7054608990000001,0.0,0.439078759,0.492088889,0.0,0.412012471,0.73589705,0.206222262,0.0,0.0,1.62167315,0.0,0.0,0.0,0.718085614,1.29810782,0.811558784,0.0,3.47053483,0.36647368700000005,0.0,0.0,0.0,3.45587654,0.0,0.0,0.38507757299999995,0.0,1.11812898,0.043558380099999995,1.43021776,0.6734739670000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.09259366,0.929126536,0.785976212,0.701639806,0.692933458,0.7534106709999999,0.8578401940000001,0.9708255859999999,1.05685718,1.08908416,1.0547862,0.9566438159999999,0.810107178,0.638116009,0.46491023600000003,0.31062649999999997,0.18788844300000002,0.10086713900000001,0.0465502581,0.0174201433,0.0045206545299999994,4.4146648e-16,0.0,0.0,0.0,0.0,0.0,0.00141906909,0.00428824795,0.006158823620000001,0.00607088628,0.00380065093,5.808769480000001e-18,0.0,0.0,0.0,0.0,0.0,0.0020550633,0.00535687025,0.00676745547,0.005953793520000001,0.0033609711600000006,2.3235077899999997e-17,0.0,0.0,0.0,0.0,0.0,0.000881455189,0.00196607776,0.00203675685,0.00136310116,0.000500099523,3.2529109100000003e-16,0.00014128167,0.00079373706,0.00147982824,0.0016083323499999998,0.000780781922,0.0,0.0,0.0,0.0,0.0,0.0,0.004071292670000001,0.007499560749999999,0.008875733640000001,0.0073290163,0.00294034712,0.0,0.0,0.0,0.0,0.0,3.39813015e-16,0.00856959879,0.015155173700000002,0.0173026326,0.0138381283,0.00539540968,0.0,0.0,0.0,0.0,0.0,0.0,0.0137096552,0.023920402,0.026972614300000003,0.021325996899999998,0.00822729879,0.0,0.0,0.0,0.0,0.0,0.0,0.0197863083,0.034326917799999995,0.038504205,0.0302965415,0.011636161499999999,0.0,0.0,0.0,0.0,0.0,5.227892530000001e-16,0.027387961000000002,0.047427015700000005,0.0531151383,0.0417391605,0.0160147829,0.0,0.0,0.0,0.0,0.0,0.0,0.0377222531,0.0654069317,0.0733699644,0.0577690396,0.022216848799999998,0.0,0.0,0.0,0.0,0.0,2.38885645e-16,0.053897691399999996,0.0940940359,0.10637555300000001,0.0845090035,0.0328382277,0.0,0.0,0.0,0.0,0.0,0.0,0.09463917,0.17701879899999998,0.22391411,0.22171582199999998,0.171055813,0.0872451653,0.0,0.0,0.0,0.0,2.03306932e-16,0.091580156,0.169559519,0.201728877,0.167973222,0.06829740620000001,0.0,0.0,0.0,0.0,0.0,6.041120259999999e-16,0.29771092600000004,0.619069933,0.9007015309999999,1.08911873,1.15769659,1.11766569,1.01950412,0.943483766,0.9809908970000001,1.21083373,1.67635664,2.36932809,3.22516072,4.13137498,4.94798452,5.5354846,5.78413777,5.63779455,5.10669103,4.26623312,3.24206606,2.18491427,1.24097671,0.524527836,0.0986308689,0.0,0.0831386996,0.358859011,0.694070028,0.996006882,1.19844656,1.27192975,1.22430541,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.972488882,0.028244607999999997,0.0,0.394164959,0.0,0.0,0.0,0.8938877120000001,1.2427853000000002,0.30893861300000003,0.746004146,0.14080994300000002,0.15808517800000002,0.7104564090000001,0.5360967170000001,0.384488576,2.23836527,0.704257061,1.45004069,1.65657846,0.33023742,0.845662754,0.0,0.251940121,0.0,3.60979687,1.29111503,0.0,2.44606913,0.0,0.679787252,0.0,0.341769828,2.69538681,2.84791033,0.0,0.0,0.552996013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.03656628,3.00335634,2.94916836,2.87470065,2.78090513,2.66897325,2.54031822,2.39655412,2.23947204,2.07101375,1.89324316,1.70831625,1.51844977,1.32588921,1.13287663,0.9416188670000001,0.75425646,0.5728339339999999,0.399271828,0.23534090600000002,0.0826389345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00151991411,0.0775434094,0.150034002,0.217705206,0.27940661899999997,0.334139796,0.381071206,0.419542087,0.44907508,0.46937758700000004,0.480341841,0.48204174299999997,0.47472656799999996,0.458811717,0.434866696,0.403600615,0.365845464,0.322537536,0.274697321,0.22340828899999998,0.16979492699999998,0.11500046,0.060164653600000007,0.006402094279999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.018571148,0.06288385070000001,0.10620670199999999,0.14763183300000002,0.18629874600000002,0.22141096,0.252251263,0.278195285,0.298723142,0.313428947,0.322028025,0.324361701,0.320399579,0.310239311,0.29410384300000003,0.272336227,0.245392108,0.21383003399999997,0.178299806,0.139529079,0.09830850279999999,0.055475679699999995,0.011898263899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0115749341,0.0537940265,0.0949983909,0.134326477,0.170951935,0.204100333,0.23306491399999998,0.25722109600000004,0.276039418,0.289096674,0.29608501800000003,0.296818845,0.29123929600000004,0.27941631100000003,0.261548142,0.23795834100000002,0.209090263,0.17549916399999999,0.137842032,0.0968653389,0.0533909192,0.008300247059999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0199458152,0.0751987149,0.130145352,0.183634496,0.234517108,0.28166869699999997,0.324011669,0.36053723299999996,0.390326478,0.412570216,0.426587214,0.431840464,0.42795115899999997,0.41471009299999995,0.392086241,0.360232316,0.319487155,0.270374845,0.213600545,0.150043028,0.08074401769999999,0.0068944537400000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.067239277,0.224049348,0.39186395399999996,0.569041585,0.753772132,0.944100768,1.13795431,1.33316969,1.52752404,1.71876603,1.90464783,2.08295738,2.25155027,2.40838085,2.55153211,2.67924369,2.78993775,2.88224223,2.95501108,3.00734121,3.03858582,3.04836398,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.437359579,0.35153956799999997,0.280239704,0.211189388,0.137310736,0.059085460599999994,0.0,0.0,0.0,0.0,0.0,0.0,0.06657201830000001,0.124745076,0.152882685,0.140528246,0.0880492459,0.007213447709999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0959656314,0.18414822100000003,0.227362462,0.210848676,0.135297324,0.017622306,0.0,0.0,0.0,0.0,0.0,0.0,0.133931795,0.268584712,0.339335014,0.321839415,0.213896819,0.037748923399999995,0.0,0.0,0.0,0.0,0.0,0.0,0.21172986800000002,0.45175379,0.593644623,0.585911335,0.41068467799999997,0.0923867977,0.0,0.0,0.0,0.0,0.0,0.0,0.572354657,1.45355348,2.31802395,3.02018536,3.43915348,3.50601638,3.22158489,2.66031036,1.95889828,1.29139853,0.83551087,0.73684882,1.07849706,1.86222565,3.00538109,4.35425689,5.71134586,6.8710265,7.65654634,7.95099027,7.71628099,6.99683645,5.90772907,4.61034952,3.28099666,2.07900165,1.12073413,0.464247996,0.10680385699999999,0.0,0.041883746,0.153549028,0.24754392600000003,0.270706018,0.206086147,0.0707091024,0.0,0.0,0.0,0.0,0.0,0.0,0.0922540576,0.237809265,0.31932522,0.315871107,0.229041388,0.0820593159,0.0,0.0,0.0,0.0,0.0,0.0,0.0928396337,0.277457784,0.425277605,0.512661424,0.532278512,0.49351823200000006,0.41858453100000004,0.335513552,0.270104975,0.23896007600000002,0.24544071,0.27952032600000004,0.32142489399999996,0.347946044,0.33961648,0.286743665,0.192642688,0.07319170280000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0987634449,0.192400015,0.243147804,0.237555845,0.176594105,0.0753995405,0.0,0.0,0.0,0.0,0.0,0.0,0.0354973513,0.133740585,0.19589918899999997,0.20591337899999998,0.161446949,0.0744407328,0.0,0.0,0.0,0.0,0.0,0.0,0.029337367799999996,0.128843869,0.19474591600000002,0.20934188,0.168327929,0.0820330002,0.0,0.0,0.0,0.0,0.0,0.0,0.0255400782,0.136264122,0.21346834399999998,0.235657306,0.195186529,0.100674289,0.0,0.0,0.0,0.0,0.0,0.0,0.10882309800000001,0.321408747,0.525675122,0.690220003,0.794172868,0.8314347409999999,0.811130956,0.754252795,0.687433982,0.635528555,0.614945017,0.629475978,0.6696999339999999,0.7160935979999999,0.7450207179999999,0.736006327,0.678358155,0.575348902,0.44478587,0.315712361,0.22197455600000002,0.194196725,0.25213107,0.399278862,0.6211347079999999,0.887523795,1.15850543,1.39245525,1.55442742,1.62286031,1.59312867,1.47724326,1.29995012,1.09234265,0.884656283,0.700033352,0.550707322,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.94464548,7.4982701,6.66709479,4.77974986,3.00564199,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.29071603,1.23587526,0.88981747,0.0,0.37725751,0.0,0.03666486,0.0,0.0,0.0,1.0116383,0.3475218,0.0,0.0,0.12001946,0.0,0.0,0.0,0.0,0.0,0.20303154,0.0,0.0,0.35403212,0.0,0.12380122,0.0,0.0,0.14778550000000001,0.03200417,0.0,0.0,0.31149394,0.39035707,0.86013352,0.39053529,1.56611902,1.80183163,0.89052221,0.67545122,0.06777321,0.0,0.0,0.0,0.0,0.0,1.3478991000000002,4.46381666,6.51111294,7.16619737,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.76397828,0.0,0.24446315100000002,0.0,1.32213207,2.14544624,1.07112995,0.0,3.38622129,2.947478,0.410309902,0.8674505570000001,0.0,0.624990288,0.143705386,0.0,1.00607842,1.22506294,0.0,0.6000540529999999,0.0,0.401990721,0.577811716,1.09572035,0.0,0.0,0.570151145,0.0,0.685529687,0.16797366600000002,0.0,0.0,0.046267080499999995,0.09309466890000001,0.0,0.46492531299999995,1.13362787,0.0,0.568905973,0.0,0.207444412,0.00322743464,0.466325434,0.206704516,0.0,3.38745269,1.3460875,0.0,0.0,0.644350027,1.05709896,0.0,0.625802681,0.0,0.0,0.37579724700000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.00917456,0.65100392,0.98823015,0.81129849,2.25698416,0.11727705,0.7636232,0.26939452,1.69987266,2.58805829,2.64428169,0.83028792,1.97863833,2.61756153,2.856922,1.63253137,2.83768002,3.30056935,2.87510075,3.44818094,2.5202431,3.63598175,1.58720248,2.02465649,2.52889854,3.2576869,1.2006401000000002,2.85898652,1.69226743,2.24259891,0.21166571,0.13987847,0.14329364,1.11694964,0.0,0.0,0.81058247,0.53921767,0.0,0.21865901,0.0,0.0,0.0,0.0,0.0,1.62426131,0.0,1.43825968,0.0,0.0,0.0,1.1419608,0.0,0.0,0.60099429,0.92023499,0.0,0.01868998,0.73461056,0.0,0.15698311,0.0,0.0,0.70345372,0.25819754,0.17373143,1.25129953,1.93149466,0.55128543,0.0,0.0,0.69915371,0.43911036,0.0,0.97683328,0.0,0.60672055,0.55296149,0.0,0.0,0.0,0.40106683,0.27318113,0.0,0.0,0.28951552,0.0,1.17751661,1.0620789,0.0813834,1.18219621,0.13145035,0.51126279,0.05142859999999999,0.02428982,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.257332445,0.7732014559999999,0.0,0.46218627700000003,0.0,0.0,1.17370757,1.53303573,0.9158754259999999,0.0,0.0309350512,0.0,0.0,0.253420553,0.0,0.237299605,0.280984691,0.0599975363,0.900593018,0.773803549,0.0,1.90821601,2.72547348,0.33676788799999996,1.86156505,0.0,0.0,0.48623287600000004,0.9973741979999999,0.42816198899999997,0.787615967,0.491568338,0.0,0.8966883,0.0,0.0,0.0,1.77687897,2.1953044999999998,0.0,0.757210009,0.7100951059999999,1.80643588,0.179716862,0.0,0.0,1.2883931,0.41280329200000004,2.20520162,0.330740322,0.0,0.0,0.0,0.562164187,0.0,0.34093960100000004,0.0,0.0,1.47553629,0.284905127,0.78761269,0.0,0.600177372,1.62887955,0.5747576289999999,0.0,0.652198495,0.511700084,0.0,0.644242772,0.544808875,1.54285881,0.0,0.49369926399999997,0.0,2.19035378,0.0,0.46760446200000005,0.0,0.0,0.0,1.83997464,0.32526801,0.0,0.0,0.81442565,0.0,0.0,0.244093599,0.8941803070000001,0.077317682,0.0,0.0,2.61073655,3.84518842,4.09549584,4.63422213,2.63804427,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.76686699,8.81338901,6.09166328,2.5852119,0.0,0.0,0.0,0.0,1.04169068,2.55342106,3.16862933,2.83400558,1.90808035,0.907699217,0.231554487,0.000578695479,0.0739616245,0.198808748,0.187018744,0.0153500471,0.0,0.0,0.0,0.0283515017,0.23576929600000002,0.290948369,0.159526949,0.0,0.0,0.0,0.0,0.11012216,0.26272464100000004,0.24617882800000002,0.073155697,0.0,0.0,0.0,0.0,0.188449437,0.308777133,0.264477966,0.09354120769999999,0.0,0.0,0.0,0.0389991862,0.178383438,0.205597437,0.0992984122,0.0,0.0,0.0,0.0,0.106120588,0.216449635,0.188538297,0.0387728525,0.0,0.0,0.0,0.0,0.169678406,0.237658709,0.153262283,0.0,0.0,0.0,0.0,0.0737848629,0.238023261,0.253654297,0.10389536099999999,0.0,0.0,0.0,0.0,0.181496414,0.333694506,0.276503817,0.028361817200000004,0.0,0.0,0.0,0.0366420398,0.408424831,0.567777772,0.359606009,0.0,0.0,0.0,0.0,0.655945056,2.47183068,4.47692555,6.16933992,7.1441355,7.22621065,6.5025995000000005,5.25380171,3.82792561,2.51881877,1.49546357,0.796797182,0.373748921,0.144692064,0.035743825099999994,0.0,0.0,0.0,0.0023513936,0.0,0.0,0.0,0.0,0.0130253049,0.0310223369,0.030515161000000002,0.00752042618,0.0,0.0,0.0,0.0,0.0387219294,0.05712120230000001,0.0385847058,0.0,0.0,0.0,0.0,0.0167488576,0.054893551,0.0558274446,0.021638843300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0752709753,0.42239738299999996,1.00219519,1.67932361,2.19664659,2.28057242,1.78937571,0.825168613,0.0,0.0,0.0,0.0,0.436858354,1.20091041,1.25985779,0.461176601,0.0,0.0,0.0,0.0,2.4140446,5.82335375,8.61894577,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.147053088,0.37232664600000004,0.455993462,0.327216065,0.10044774599999999,0.0,0.0,0.0774550761,0.133210901,0.0627922443,0.0,0.0,0.0,0.0573009768,0.151647809,0.10774924300000001,0.0,0.0,0.0,0.0120745205,0.13897878,0.139380577,0.0121805256,0.0,0.0,0.0,0.11179160000000002,0.158862411,0.060733944299999995,0.0,0.0,0.0,0.0734278459,0.165246475,0.106410487,0.0,0.0,0.0,0.026143344199999998,0.15727450199999998,0.145606916,0.0,0.0,0.0,0.0,0.133783047,0.173847342,0.054708843300000004,0.0,0.0,0.0,0.09411150369999999,0.18416066399999997,0.105879784,0.0,0.0,0.0,0.0400881752,0.160748508,0.130014444,0.0,0.0,0.0,0.0,0.0327306175,0.0,0.0,0.271635786,0.979401207,1.81493586,2.24871339,1.89023544,0.8787019159999999,0.0,0.0,0.667970589,2.00968725,2.63973879,1.75580325,0.0,0.0,0.0,0.0,4.20694349,8.13318664,9.73772558,8.25412396,4.65257492,0.9809513529999999,0.0,0.0,1.09754138,2.62691392,2.90369951,1.91507456,0.504581464,0.0,0.0,0.133292078,0.537405426,0.43492016,0.0,0.0,0.0,0.23847360199999998,0.9673123459999999,1.48660981,1.63195584,1.48503324,1.22649092,0.973021398,0.742574225,0.538823206,0.42763914399999997,0.502773203,0.769016238,1.07220625,1.17372422,0.9301457740000001,0.426884947,0.0,0.0,0.0,0.147053088,0.323878994,0.254822569,0.0333577574,0.0,0.0,0.21098240000000001,0.438206227,0.460790628,0.268392355,0.0160649876,0.0,0.0,0.0471697712,0.11264361199999999,0.0688496525,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5675097020000001,1.65895469,2.95808866,3.96110528,4.22733968,3.6404071000000005,2.47264663,1.2137722,0.289831589,0.0,0.0,0.0,0.0179348699,0.028000153,0.00627173377,0.000898630376,0.014452508999999999,0.0190515302,3.4159376000000006e-16,0.0,0.0,0.0,0.022849765499999997,0.0276103746,0.007727552359999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0243788809,0.127044553,0.243297321,0.297867037,0.24651102800000002,0.117598707,0.0,0.0,0.0,0.0,0.0357264405,0.12326049800000001,0.358853717,0.78153639,1.27611037,1.59489119,1.51121126,1.00232605,0.31210531399999997,0.0,0.0,0.20534547,0.7433783270000001,1.04051668,0.923801038,0.518809725,0.130112702,0.00170478749,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0692283485,0.0499638009,0.0632179188,0.108093679,0.171045539,0.23172068899999998,0.272348036,0.287042849,0.287210919,0.300552392,0.363515779,0.509555613,0.7572407729999999,1.1024737,1.51769841,1.95849158,2.37527008,2.72601364,2.98559429,3.14864972,3.2254292999999996,3.23273069,3.18389701,3.08213826,2.92004708,2.68562109,2.37236414,1.9891880000000002,1.56562573,1.14943397,0.796460735,0.555658729,0.454196479,0.487945775,0.621021754,0.795051802,0.945507867,1.01995382,0.9923383370000001,0.8687774420000001,0.6831597620000001,0.484347112,0.319515455,0.21932086899999997,0.189713482,0.212714994,0.255260248,0.282448486,0.270223096,0.213019233,0.124018534,0.0284930429,0.0,0.0,0.0,0.0,0.0,0.0339257418,0.0451928025,0.0341140598,0.0122347255,0.0,0.0008835902779999999,0.0305759167,0.078718151,0.129495904,0.164764367,0.171932278,0.1496797,0.10903327,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.79626013,2.80327726,0.0,0.0,0.49449950299999995,1.44878307,0.0369238315,0.385216605,0.446160166,0.037577064900000005,0.36821474600000004,0.0,0.0,2.19981697,0.255795868,1.90214092,1.41261622,2.40101297,0.567895645,0.0,0.44292932799999996,0.633021521,0.0,1.57537224,0.0,0.0,0.0,0.0,0.0,0.0,0.34364992,0.073606598,0.0,0.704572112,0.0211295835,0.0,0.0,0.0,0.807324303,0.45676712799999997,1.03364271,1.12369447,1.33374826,0.0,0.0,0.0,0.0,2.31503947,0.0,0.903784686,0.004454881710000001,0.0,1.02264519,0.26457371399999996,0.209494911,0.303995223,2.1248627,0.292785881,0.843210307,0.0,0.582802564,0.0,0.0,0.0,0.0,1.40792717,0.0,0.994398316,0.719611675,0.23652378100000002,0.6544060070000001,0.0,0.340531827,1.20224559,0.8184418179999999,0.0,0.8598339309999999,0.34969609,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.551725292,0.0,0.7418556009999999,0.0,0.0,0.736311589,1.97497754,0.303298397,0.0,0.0,0.34322293200000004,0.149201199,0.0,0.0,2.60422131,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.716312495,1.35333343,1.67878874,1.57145725,1.15527987,0.746824376,0.68638365,1.14396924,2.01018327,2.93684395,3.50851607,3.45224774,2.77175934,1.73588011,0.7331260740000001,0.0769863477,0.0,0.0,0.182932122,0.257316938,0.14465749,0.0,0.0,0.0,0.0,0.198110674,0.315957668,0.25848069100000004,0.06897280509999999,0.0,0.0,0.0,0.169658616,0.34337776,0.317839624,0.0557711342,0.0,0.0,0.0,0.34117597200000005,1.70013862,3.45458133,5.2308404,6.59823911,7.20289578,6.88169747,5.71760633,4.01560243,2.20477791,0.698983582,0.0,0.0,0.0,0.0,0.24010759899999998,0.311515731,0.18062964,0.0,0.0,0.0,0.0,0.0771929763,0.156757284,0.122966245,0.009726368649999999,0.0,0.0,0.0,0.033325849399999996,0.11151051099999999,0.10909105300000001,0.031210367200000002,0.0,0.0,0.0,0.007875249150000001,0.0997596578,0.138777168,0.11369820900000001,0.062281179400000004,0.0433529115,0.0940003602,0.201566057,0.309755768,0.354749121,0.30683972800000003,0.18961477699999998,0.064175328,0.0,0.0,0.0282788678,0.0631694653,0.053211494299999995,0.0,0.0,0.0,0.0,0.0272710969,0.0791624708,0.0757959908,0.017524861699999998,0.0,0.0,0.0,0.0125613406,0.0808482676,0.0932809057,0.0388437593,0.0,0.0,0.0,0.0,0.0793601459,0.112457918,0.0655551791,0.0,0.0,0.0,0.0,0.0754946112,0.137117532,0.102512145,0.0,0.0,0.0,0.0,0.068124268,0.17483830399999997,0.16236443,0.0271108854,0.0,0.0,0.0,0.0526756604,0.251350274,0.292242434,0.11333152199999999,0.0,0.0,0.0,0.04886843019999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.7538208559999999,1.81192678,2.98914981,4.11899229,5.02927084,5.57525741,5.66822502,5.29314781,4.5116528,3.44958203,2.27193311,1.15070284,0.23262234699999998,0.0,0.0,0.0,0.0,0.0,0.20841532699999998,0.43440473700000004,0.516143101,0.449643432,0.270322689,0.0388442908,0.0,0.0,0.0,0.0,0.0,2.2165954499999997e-16,0.153156716,0.250525298,0.27100041,0.216032465,0.107237208,0.0,0.0,0.0,0.0,0.0,0.0,0.032237884,0.113615251,0.157051831,0.15391481099999998,0.109053645,0.0383432331,0.0,0.0,0.0,0.0,0.0,0.0,0.0359608182,0.0758325333,0.0909350673,0.0796774932,0.0479865545,0.006877583409999999,0.0,0.0,0.0,0.0,0.0,1.9395210199999998e-16,0.0227948335,0.0352783686,0.0356864012,0.026221910600000002,0.011779411799999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.007296709759999999,0.022913288599999998,0.035104200499999995,0.0383753086,0.0294331972,0.00877925932,0.0,0.0,0.0,0.0,0.0,0.0,0.0355725873,0.0726141622,0.09204112240000001,0.0857472105,0.052693936100000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0129676221,0.0890170282,0.145721046,0.164272287,0.13554187199999998,0.063695702,0.0,0.0,0.0,0.0,0.0,0.0,0.0661065749,0.188169731,0.266094917,0.272362751,0.19788221,0.056459942699999995,0.0,0.0,0.0,0.0,0.0,0.0,0.204099702,0.420205586,0.5417303520000001,0.520588009,0.344240307,0.044921962999999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.48173277299999995,0.23310961100000002,0.0134158949,0.0,0.12491921,0.0,0.047379037,0.0,0.0462882377,0.0,0.0486416055,0.0,0.0526871854,0.0,0.0585473528,0.0,0.0671880184,0.0,0.0810696338,0.0,0.107183259,0.0,0.171555517,0.0,1.69806385,2.21881411,0.7095825020000001,1.03867856,0.247777243,0.0,0.060860917300000004,0.0182278923,0.744065761,0.0,0.0289496521,0.0,0.030327572999999997,0.0,0.0344110637,0.0,0.0326837504,0.0234427587,0.14492115,0.0,0.734472318,0.124353046,0.0,0.00608448839,0.0104080795,0.0,0.433081557,3.21497614,2.45727909,0.0,0.308223598,0.0,0.237431456,0.0,0.506151209,0.0,0.616853207,0.0,0.15741450699999998,0.41161685200000003,0.36265536,0.0,1.01611346,2.02221091,3.91725323,3.8291137,0.0,1.32796565,2.53623535,0.9387569809999999,0.794522625,3.80842847,3.9622219,0.794031642,0.0,0.239304025,0.0,0.17219635100000003,0.0,0.144519835,0.0,0.21823459399999998,0.013676991699999998,0.056991725300000004,0.0,0.0558280466,0.0,0.0,0.89549729,2.32457106,3.09863294,4.16446663,4.19711442,2.67980043,1.22618659,0.316442322,0.0,0.045246525700000005,0.0790127026,0.565049686,1.18932366,1.5432184,1.55974406,2.0655537,2.93357252,3.15832864,1.62513367,0.412148497,0.45030590200000004,0.0,0.0031379107899999997,0.24780284100000002,0.08782151949999999,0.0071731083400000005,0.0,0.043746531799999995,0.0,0.0320706022,0.0,0.0298303886,0.0,0.0277135877,0.0,0.025722017200000002,0.0,0.287543754,1.27985131,1.89710351,0.70703644,0.0,0.13101063599999999,0.0,0.933586933,0.19793344300000001,1.31488654,1.97560382,0.628808433,0.9148849809999999,0.48991103700000005,1.24611329,0.0,0.441489578,1.02383376,0.0,0.121720127,0.0,0.10524731,0.0,2.15748519,2.70957181,0.7080807090000001,0.385448568,0.0,1.80432918,0.316335405,1.16304366,0.6779511290000001,0.134659014,0.0473749007,0.990149775,0.659947272,0.0,0.039404626,0.0,0.0,0.0216002642,0.0,0.0412976294,0.0,0.52815246,0.410093516,0.300449792,0.294101138,0.24524300100000002,0.367564641,0.138604239,0.40813511799999996,0.14448989,0.08000913259999999,0.402093799,0.416190998,0.31924620800000003,0.435784795,0.175949033,0.532454705,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.34105106,3.87556092,2.55535631,0.930430695,0.0,0.0,0.0,0.0,0.361818421,0.567599648,0.37645656200000005,0.0,0.0,0.0,0.0,0.10609737300000001,0.28102051899999997,0.24936661899999998,0.060016682599999996,0.0,0.0,0.0,0.0131567655,0.148861099,0.170289833,0.07761464309999999,0.0,0.0,0.0,0.0,0.07081133190000001,0.106861456,0.0682564811,0.0,0.0,0.0,0.0,0.0242685009,0.053354342,0.042350575,0.0070951475,0.0,0.0,0.0,0.00240063752,0.0101400721,0.00581269311,5.797958050000001e-07,0.0025203521,0.0116336238,0.015233963500000001,0.0032083324600000003,0.0,0.0,0.0,0.00815212391,0.0479362864,0.0596927814,0.0269017332,0.0,0.0,0.0,0.0,0.0736936421,0.115035204,0.07604079650000001,0.0,0.0,0.0,0.0,0.0827612753,0.181462328,0.158549124,0.0140076693,0.0,0.0,0.0,0.063734319,0.264197675,0.296352038,0.110810282,0.0,0.0,0.0,0.191710887,0.75048487,1.10546056,1.00376729,0.447302766,0.0,0.0,0.0,0.8399549590000001,2.3947581000000002,3.75883596,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.16097667,2.54582951,2.89302432,1.52074003,0.819685922,2.19837404,1.2810478,0.8721744220000001,0.181428673,0.7310951509999999,0.563050563,0.460543453,0.0,0.692600524,0.0,0.0,0.18008700800000002,0.147732304,0.0,0.0,0.545983616,0.0,0.315818687,0.0,0.59625847,0.011615764099999999,0.0,0.256808755,0.146108644,0.0,0.716502792,0.0,0.923747682,0.6969979690000001,0.6985993540000001,0.499620072,0.909163827,0.906132189,1.7431625,1.02113864,0.646129623,2.39788285,1.5169774999999999,2.16625486,2.78543176,3.56030542,1.85990155,2.45808818,3.36266807,2.32134796,2.65784525,2.43310557,3.03115472,2.91694551,1.54796039,2.41920247,2.3507754000000003,1.95324836,1.33789021,1.40070392,2.41616315,1.11642426,0.867631417,0.0,0.12071428699999999,1.55069644,1.3719559,1.47473765,0.46074176200000005,0.705267933,0.574329829,1.35667078,0.48054341100000003,0.45622025200000005,0.155172032,0.8093953140000001,1.02002976,0.0,0.27924795199999997,0.8404511179999999,0.0,0.69545243,1.31375617,1.16883735,0.0,0.54104338,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6419009729999999,0.22026323399999997,0.0,0.0,0.0,0.0,0.226746959,0.0,0.0,0.0,0.509460555,0.0,0.12349537699999999,0.40677044100000004,0.0,0.0,0.0,0.0,0.927066864,0.0,0.585932735,0.0,0.0,0.0418907479,0.0,0.0,0.0113281035,0.149691947,0.198595687,0.0352480173,0.19351707899999998,0.0,0.0,0.0,0.0,0.355095996,0.290114463,0.86806599,0.12371278,1.32980726,1.2308283000000002,0.686417583,0.8123942820000001,0.431196929,0.6076545289999999,0.475879111,0.137462177,0.0,0.190933203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11217691199999999,1.12682502,0.970924175,0.0,1.97841433,1.2245264999999999,1.94192375,0.394592427,2.82653765,2.62858509,2.84937524,3.27158492,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0765989009,0.0690689957,0.053797724299999995,0.0256478202,0.00134835003,0.00181716871,0.035618272,0.0918895352,0.145331184,0.169425661,0.150198234,0.0932170234,0.0205965931,0.0,0.0,0.0,0.0,0.0279269171,0.0650869095,0.0829823019,0.0820609977,0.0691616422,0.0515275764,0.0326705942,0.0125868402,0.0,0.0,0.0,0.0193485559,0.109334439,0.252243012,0.434252814,0.627095926,0.796413186,0.913370977,0.96472281,0.957144186,0.914184358,0.867298072,0.8446887479999999,0.8621946009999999,0.919186811,1.00022991,1.08117369,1.13720567,1.1503721000000002,1.11479327,1.03867421,0.942865636,0.856161628,0.8079896540000001,0.819850515,0.897668583,1.02764225,1.17770578,1.30513576,1.36857285,1.34071835,1.21723134,1.01844516,0.78314715,0.556734182,0.37818863399999997,0.270528859,0.23760719600000002,0.267257015,0.338241158,0.427417992,0.514372384,0.5828137170000001,0.620065081,0.616803256,0.568456241,0.47788978,0.35740852100000003,0.227770495,0.11321901699999999,0.0338249762,0.0,0.0015144105999999999,0.026881384900000003,0.0556904915,0.0765989009,0.0922856747,0.11916104699999999,0.179912244,0.29209259,0.458018506,0.660770391,0.868299878,1.04390737,1.15851332,1.19955748,1.1732013000000001,1.09973365,1.00501023,0.911987766,0.8355370990000001,0.7814677409999999,0.748467552,0.7306825370000001,0.7193072709999999,0.70317555,0.66970644,0.607652528,0.511758455,0.387507064,0.252954607,0.135257361,0.0618761329,0.0494798745,0.09554072400000001,0.17718265,0.25888115300000003,0.3063925,0.30093501,0.24701247699999998,0.169927402,0.10384820800000001,0.0759309742,0.094072128,0.144214429,0.198453994,0.22979670300000002,0.226030662,0.19559569100000002,0.162404481,0.152273606,0.178041592,0.231277034,0.285215378,0.307814805,0.278507359,0.200089913,0.09941479060000001,0.0160597296,0.0,0.0167220821,0.0988827692,0.195800075,0.269241542,0.29606477800000003,0.278875224,0.243446627,0.223969287,0.24339846899999998,0.298971307,0.36087893,0.385975329,0.34106502200000005,0.225168509,0.079701954,0.0,0.0103763894,0.229227016,0.641618342,1.18727617,1.75247409,2.20220019,2.42201064,2.35487358,2.01983032,1.50576107,0.942495467,0.45959340600000004,0.147338956,0.033316763799999996,0.08188356320000001,0.21524112,0.34694116399999997,0.414490719,0.398817115,0.324177906,0.240264974,0.19541273,0.21304412399999997,0.28148065699999997,0.360931813,0.403662725,0.37749522700000004,0.281548843,0.147030581,0.0231179194,0.0,0.0,0.049589334699999994,0.18043038,0.332508354,0.498815246,0.699403485,0.9725704959999999,1.35182566,1.83907401,2.38752425,2.90446607,3.27553383,3.40220179,3.23765013,2.80600641,2.19654618,1.53484334,0.942417064,0.5008509529999999,0.233784679,0.11196598199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.46452279,1.3908425,1.72465499,2.46021766,3.32084958,3.84734126,3.61097839,2.45878189,0.6654077070000001,0.0,0.0,0.0,0.58515755,3.73159606,6.94978161,9.15445925,9.58717431,8.12086377,5.30310735,2.11926504,0.0,0.0,0.0,0.0,0.615504211,1.30583747,1.25183018,0.6016645310000001,0.0,0.0,0.0,0.0,0.17341745600000003,0.54908469,0.557903057,0.253204861,0.0,0.0,0.0,0.248826885,0.699831793,0.923225106,0.775614617,0.314331195,0.0,0.0,0.0,0.0,0.23171798300000002,0.580413972,0.593276523,0.247879245,0.0,0.0,0.0,0.0,0.559729015,1.62138849,2.57484886,3.17685432,3.3182767999999996,3.03897044,2.48300414,1.82506044,1.2055191,0.699477365,0.32311913600000003,0.0621196404,0.0,0.0,0.0,0.0,0.117265105,0.28175152600000003,0.40422612799999996,0.451670866,0.41820572,0.32459032600000004,0.206809364,0.10028713800000001,0.0274162177,0.0,0.0,0.0,0.00878742335,0.012903963300000001,0.00925033041,0.0010577701800000001,0.0,0.0,0.0,0.0,0.00739905334,0.0116921376,0.00915903816,0.000424180859,0.0,0.0,0.0,4.0023309000000003e-16,0.013932301000000001,0.0210610852,0.0156368041,0.0,0.0,0.0,0.0,0.0020148927899999998,0.0255530571,0.035816809,0.0245067152,0.0,0.0,0.0,0.0,0.00638083295,0.042303994299999995,0.055468687999999995,0.0350105952,0.0,0.0,0.0,0.0,0.0145195626,0.0674187621,0.0837638102,0.0489824609,0.0,0.0,0.0,0.0,0.0323777932,0.124748342,0.164370393,0.125939513,0.029094936499999998,0.0,0.0,0.0,0.152003207,0.35524184,0.507236035,0.54816558,0.473377728,0.337687965,0.228589498,0.222051062,0.344001799,0.557499776,0.781712046,0.931934288,0.959260318,0.869797335,0.715343132,0.56307493,0.46220247299999995,0.425254294,0.431619672,0.44763991299999994,0.44891213,0.43122736899999997,0.405470855,0.38273109899999996,0.361762609,0.328314496,0.266794278,0.175538265,0.0738836394,0.0,0.0,0.0,0.0374334339,0.07525372400000001,0.0691218384,0.0166962145,0.0,0.0,0.0,0.0,0.06243912150000001,0.105759899,0.08552189880000001,0.0135360232,0.0,0.0,0.0,0.0,0.041990987199999996,0.038618766,0.0,0.0,0.133597678,0.47235490799999996,0.974298228,1.49834352,1.85946146,1.93136304,1.73655561,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.233
0.92466389,0.45946905,0.0,0.47432558,0.0,0.0,0.50845064,0.0,0.0,0.0,0.0,1.10663092,0.14617129,0.52930812,1.15605757,0.50443971,0.0574423,1.07576239,0.0,0.20202014,0.0,0.73166155,0.0,0.92324784,0.0,0.0,0.04094452,0.0,0.44694516,0.16927376,0.67746018,0.0,1.11158871,0.0,0.02438275,0.0,0.11111773,0.03864479,0.0852876,1.2328146,0.74446223,0.41792451,1.19640004,0.30281337,1.88650668,2.36748767,2.24544481,2.4320119,3.8175611000000003,4.89887061,2.54185696,2.58162327,1.12954021,0.46714784,0.36548317,0.76976795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0344766931,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.102791046,0.315521958,0.468421741,0.543664202,0.535589266,0.450863675,0.307044656,0.12976400300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0028839082399999996,0.21911060000000002,0.443959216,0.647525088,0.8026582809999999,0.8889035120000001,0.895598943,0.823709137,0.686127765,0.506381114,0.315869408,0.149973251,0.0435029683,0.0260599062,0.117898975,0.326827765,0.6465557510000001,1.05673218,1.52470479,2.00881885,2.46288433,2.84129066,3.10416463,3.22195533,3.17889488,2.97491586,2.62579007,2.16146658,1.62280272,1.05707456,0.512798573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.23795093,0.0,0.0,0.577619003,0.0,0.0,0.24333163300000002,0.0,0.0,0.0,2.10924404,0.0,1.56778622,0.26977091,0.0,1.08211001,2.17748484,0.0,0.276863718,0.0,0.0,0.0,1.12985668,0.584289111,0.0,0.0,0.0,0.37543700399999996,0.9240293559999999,0.0,0.0,0.0,1.18579568,1.27002489,0.0,1.94648563,1.11163674,0.017434148899999998,0.0,0.0,0.0,0.46949317700000004,0.0357967154,0.0,1.60868403,0.0,0.09153504009999999,1.13374003,0.0,0.0,0.0,0.0,0.524315138,0.0,0.0,0.0,0.8992892020000001,0.0,0.07836265440000001,0.045858543099999996,0.35315372700000003,0.17644419,0.688794017,0.0,0.0,1.14848211,0.0,0.195605065,0.0,0.0,0.0,0.0,0.0,1.39559122,0.514751539,0.563617713,0.0,0.5658629860000001,0.242527534,1.39639617,0.150570809,1.2658798999999998,0.125459961,0.0,0.0,0.0,1.31876709,0.030018328599999998,0.0,0.592352419,0.30740058600000003,0.0,0.0,0.620355793,0.0,0.440921414,0.980449232,0.0,0.0,0.0,0.0,0.7077460990000001,0.0,0.0,0.0,0.0,0.38493323799999996,1.54273869,0.0,0.0,0.0,2.37016212,0.0,0.223624934,0.0,0.62095861,0.0,0.123594484,0.0,0.825879397,0.566998894,0.325973974,0.0644573642,0.061762699000000004,0.0,0.0,0.509529134,0.0,0.56384741,1.41737634,1.34141821,0.0,1.0496885,0.0,1.48010602,0.0,0.909526004,1.17761915,0.35053122600000003,0.343063861,0.23729036,0.0,1.55372285,1.08689805,0.0,1.19662483,0.46838829200000004,1.01527191,0.703017538,0.0,0.951649014,0.0,0.881669417,0.0,0.0,1.19866482,1.74843089,0.34058771299999996,1.33914392,1.75700889,1.56364555,0.0,2.46022516,0.301050394,2.13595835,0.208062315,0.6883893879999999,1.09873341,0.0871105859,0.0,0.0,0.0,0.0,0.0,0.0,1.69743938,1.23323747,2.11596426,3.39050148,2.4366115,3.65707627,5.48951054,4.22736674,4.44856268,4.21154895,4.52391513,1.92456462,2.89430091,1.35250963,2.07348754,1.71258338,2.1551459,0.6911541,0.0,1.33628517,0.0,0.254879588,0.643951206,0.983065917,0.0,0.453890674,0.543153455,0.509934903,0.0,0.0,1.01853429,0.0,0.0,0.0,0.349266036,0.0,0.0,0.0,0.15716227,0.0,0.0,0.0,0.09713012039999999,0.959559212,0.0,0.0,1.9689458999999998,0.0,0.212266887,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.42401243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08209555,0.8231483,2.33440997,2.80806003,4.16069945,5.3681232,5.70504432,7.29767691,8.10045581,8.34203781,8.35584818,7.40311148,7.31959118,5.62414101,5.39642075,3.57100534,2.7690414,1.43917136,0.15145198,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.78321715,0.81100667,0.90060595,0.50528318,0.81639053,0.24668273,0.18385741,0.42246009,0.40320959,0.0,0.30276054,0.0,0.0,0.0,0.30034137,0.0,0.12413732,0.30567783,0.58059751,0.0,0.08119419,0.0,0.24964114,0.5629571,0.03134965,0.48692024,0.96531125,0.67839683,0.69424902,0.0,1.03697898,0.86069723,0.87044909,0.67811444,0.83586787,0.0,0.45803948,0.45326182,0.0,0.0,0.0,0.0,0.35441559,0.0,0.2885139,0.0,0.76455333,0.0,0.57684021,0.62339183,0.09030752,0.10566638,0.66369503,0.73897883,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23199999999999998
0.02839714,0.39402054,0.0,0.92382131,1.05659918,1.29232563,0.26524255,0.57132943,0.96207589,0.78841405,0.67834899,0.45194343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04384465,0.68560119,0.90611226,0.26055131,0.55317257,0.0,0.22386286,0.0790026,0.0,0.0,0.03230897,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07598052,0.37713154,0.61674602,1.06123818,1.29201877,1.03748583,0.64320671,0.55750694,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.58024501,1.47306621,1.97670616,2.76354271,3.93298778,4.71832393,4.9954946,6.07901519,5.43269004,5.82850362,5.4083651,5.98435002,4.54509629,4.50132793,3.64468389,2.32565829,1.65603971,1.71990964,0.90279384,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0828697878,0.0164648043,0.571956518,0.0019143740300000003,0.0,0.6516726270000001,1.11993379,0.0,0.5289155529999999,0.311667092,0.717108937,0.214541398,0.162014557,0.689580436,0.0,0.538646172,0.35457157100000003,0.017972372900000002,0.0,0.479874191,0.0403535448,0.0,0.044213169299999994,0.943963033,0.0,0.0,0.0,0.38736306200000004,1.01990509,0.49795258,0.337426258,0.0,0.0,0.0732777437,0.102723329,0.467324199,0.7597307590000001,0.20551171399999998,0.26251711,0.8233591990000001,0.25569077,0.740894657,0.053366847099999996,0.0,0.0,0.690999837,0.668418411,0.0,0.0477130579,0.468588875,0.0,0.0,0.0,0.0,0.694573137,0.0419175783,0.0,0.0343381181,0.0,0.401783861,1.27310572,0.210688679,0.0,0.0,0.0,0.0,0.376738818,0.0,0.0607438561,0.0,0.0,0.468010181,0.81143931,0.0,0.047549580099999995,0.0,0.013670657,0.0,0.0,0.21120312800000002,0.49460138200000003,0.0,0.0,0.21337068899999997,0.192783768,0.9110185120000001,0.0299114548,0.571105485,0.588659983,0.358940916,0.0,0.736716265,0.21019395300000002,0.0,0.96798986,0.0,0.0,0.0,0.658588201,0.777729522,0.0,0.0,0.13387365099999998,0.290004146,0.0,0.0,0.44051448200000004,0.0,0.0,0.0,0.0,0.030029812700000002,0.0,0.0,0.8823317209999999,0.0,0.0,0.241570641,0.0,0.0,0.475941585,0.0,0.0,0.7945658109999999,0.0,0.0,0.552990182,0.204197395,0.0,0.0,0.5254740720000001,0.0,0.784715475,0.69514822,1.56713547,2.17192322,2.43993733,1.66324769,1.81954984,2.76702835,2.67411795,1.38356167,3.37361034,3.32771805,3.42870485,1.71665318,2.06665773,2.39386107,2.39701284,1.25659635,1.27683784,1.41836776,0.893721511,0.9937593809999999,0.0,1.24539453,0.715021692,0.0,0.053133039900000005,0.0,0.0,0.122767192,0.10547197900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18611098399999998,0.2457026,0.0,0.22880257199999998,0.0,0.0,0.0,0.532113697,0.666023719,0.0,0.0,0.0,0.0,1.32940529,0.0,0.0,0.0,0.618966126,0.0,0.64595746,0.0,0.0,0.365959855,0.0,0.0,0.0,0.9734541090000001,0.227448288,0.35147870700000006,0.0,0.37821596799999996,0.0,0.0,1.17937949,0.577239219,0.0,0.0,0.0,0.5050126620000001,0.0,1.03687595,0.0,0.0,0.9665943229999999,0.850885808,0.0,0.0,0.0736511638,0.0,0.284273813,0.0,0.0578970248,0.0,0.48017644600000003,0.181129189,0.0,0.72373058,0.0,1.02788514,0.0,0.0,1.4967502000000001,0.0,0.0,1.28412265,3.71346047,2.98024816,0.29667098399999997,0.535442105,0.0,0.548984646,0.0,0.660097552,0.52305494,0.311783996,0.0,0.667738583,0.39869158200000004,0.278998009,0.691721495,0.884848778,0.0,0.0287723297,1.15404235,0.896771235,0.267079694,0.0,1.23454939,0.0,0.0,1.26060557,0.166724302,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.33739673299999995,0.104293121,0.0,0.0835507768,0.26379595,0.0,0.0414288535,0.0,0.234130387,0.27670602,0.0781640484,0.241032174,0.270920891,0.04761274099999999,0.355159655,0.14061444,0.0,0.148396922,0.239616816,0.0760980824,0.0,0.0,0.0,0.0,0.0020583775,0.197245382,0.0446653602,0.275921677,0.231574733,0.21358497699999998,0.09624757310000001,0.153344951,0.0157928674,0.0167910843,0.10738390199999999,0.0,0.0008929154670000001,0.0,0.0,0.109621627,0.0,0.0,0.190331482,0.118442274,0.27011351699999997,0.0313725455,0.158954184,0.29538937,0.31960148,0.15256244,0.0,0.26655185800000003,0.128293398,0.0578999275,0.0,0.0,0.503574023,0.141461291,0.337516146,0.738878942,0.906304343,1.28772922,1.28783984,1.01492198,0.620459593,0.393564643,0.545201023,0.384027185,0.0,0.0,0.0,0.0,0.0,0.0,0.08555613390000001,0.306609659,0.473950311,1.26458275,2.02838572,2.5728282000000005,2.75296365,2.919274,3.02374204,3.1138248,3.15398897,3.04580841,2.74488927,2.1598528,1.55412394,1.68718247,1.13442846,0.601303589,0.381478515,0.246206116,0.44035340100000003,0.465695795,0.259985974,0.227603148,0.11874733900000001,0.199953031,0.40472109,0.35351274200000005,0.584062165,0.301680391,0.509786298,0.312745487,0.11375886699999999,0.27215249399999997,0.17895323800000001,0.388691594,0.44635282299999995,0.726933745,1.33604521,1.69768971,2.32403321,2.32482313,2.73357233,2.95411558,2.7713148,2.44682257,2.63610437,2.73938841,2.51226979,1.61686966,1.37271897,1.79310573,1.57801357,1.40276997,1.33684533,1.40152857,1.24994041,1.48808807,1.52677144,1.31491991,1.44382189,1.51816961,1.33583722,1.75463704,1.20575259,1.22872922,0.534948684,0.41517409899999996,0.40445590299999995,0.0,0.0,0.0,0.0,0.0,0.205681883,0.0,0.333600055,0.560249435,0.417171226,0.590857441,0.18222704399999998,0.510290076,0.34898812100000004,0.311691758,0.11399437400000001,0.411722094,0.309043367,0.618240847,0.321271756,0.5711778279999999,0.609036536,0.519609644,0.506658481,0.571732554,0.623468525,0.679140588,0.660881199,0.590769285,0.97524078,0.245086313,0.29404356,0.309698588,0.395121836,0.372909771,0.470564087,0.159450233,0.180555107,0.589566975,0.755509812,0.868018645,0.6932444659999999,0.8141910929999999,1.1638349,0.8710518309999999,0.54188001,0.784821068,0.231141508,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.54779009,0.7107425359999999,0.576004564,0.8163491540000001,1.12634387,0.972012889,1.1711709,1.31468568,1.06577426,1.12563059,0.537990843,0.8855095129999999,0.649538411,0.253040753,0.507862348,0.137840607,0.0,0.0744399673,0.0,0.0,0.103247591,0.0684631148,0.0,0.232373212,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.46931257,0.7548520040000001,0.467250336,0.0,0.0334278357,0.24124685399999998,0.975382635,0.0,1.24127236,0.42162438799999996,0.0,0.94073888,0.783944018,0.477116734,0.0,0.0,0.0,0.468657736,0.0,0.0,0.0,0.592288356,0.20303706300000002,0.202159952,0.0,0.0,0.7049629159999999,0.0,0.322487597,0.449087865,0.8625312890000001,0.0789079401,0.0970120333,0.567685062,1.66386368,0.669848455,0.0,0.0,0.0,0.0,0.0,0.138122137,0.36916744100000004,0.124894017,0.179097726,0.0,0.607278338,0.15173441199999999,0.0,1.19036301,0.616411818,0.24278840399999999,0.533532472,0.552816579,0.0,0.36529937700000004,0.0,0.0,2.40956919,0.00534800446,0.0,0.0,0.0,0.240031902,0.312433417,0.0,0.744049637,0.0,0.232035532,0.0,0.138775889,0.257346465,0.0,0.0,1.5710287,0.0,0.0,0.717660858,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45505959,0.00212542141,0.892452452,0.32799168100000003,0.06965553740000001,0.0,0.6781805870000001,0.22222951800000001,1.93222203,0.187782141,0.0,0.0,0.09922721289999999,0.844806987,0.98702238,0.0,0.0,1.38366125,0.172530713,1.18686784,0.439759991,0.0,1.4898223,1.86285074,0.149004876,0.0,0.0,0.30895632,1.39856311,0.0,1.19257813,0.22918662,0.0,0.30837927,0.7647104090000001,0.920852951,0.0,0.0,1.44131015,0.0,1.06570163,0.0,0.0,0.0,0.0,0.228548392,0.0,0.39375788899999997,0.570588743,0.657250352,0.0,0.356157719,0.0,0.462524545,0.0,0.8460559320000001,0.0,0.0,0.929398953,0.556622105,0.956583376,0.641656585,0.0,1.28779669,0.0,0.441029985,0.0,0.8374080359999999,0.723011362,0.297998848,0.274475016,0.0,0.0,0.0,0.410360984,0.0,1.15661806,1.40777432,0.0,0.0,0.0,0.0,0.0,1.18843673,0.0,1.09123155,0.0,0.0,0.0,0.480796299,0.0,0.10485729099999999,0.0331043115,0.0,0.301411836,0.0,0.0,0.565606566,0.0,0.0,0.8475824129999999,1.80645617,0.142690313,0.509159286,0.0,0.359635456,0.9211216,0.07891816780000001,0.5831349929999999,0.161537096,0.0,0.0,1.25401757,0.0,1.24407825,0.24127185399999998,1.5356542,0.0,0.43883807,1.31950083,1.23295643,0.0,0.359773127,0.0,0.0,0.0,0.0,0.253381171,0.0,1.12524219,0.245410243,0.0,0.0,0.810450544,0.0,0.0,0.228645347,0.770413978,0.0,0.0,0.791956298,0.0,0.801900885,0.0,0.0,0.150943306,0.0,0.0,0.0,1.22524096,0.0,0.0,0.0,0.0,0.257328878,0.0,3.07314783,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.43238321,1.80798643,2.11873695,2.70512223,2.90736356,2.95245509,3.44613657,3.2592517000000005,3.76383249,3.49004244,3.55675106,3.33760789,3.40411853,3.22287501,2.44648534,2.06241766,2.11989775,1.48183073,1.10476228,0.634546235,0.614082464,0.03359035,0.0037638316299999993,0.0287548785,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0370293642,0.0,0.40906398299999996,0.0929338307,0.592425002,0.556970042,0.371196597,0.41032251399999997,0.27483271800000003,0.300460853,0.12965398,0.35815895299999995,0.0,0.15456910599999998,0.105846913,0.0,0.0444189834,0.0,0.0,0.0,0.0959126039,0.0,0.122714484,0.0,0.0120386998,0.17565905699999998,0.377675124,0.0,0.10281032,0.127700106,0.0238980206,0.0658737887,0.32025535899999996,0.14355841800000002,0.0,0.0,0.13080952,0.0,0.0,0.0,0.0,0.0,0.0666283332,0.15734157,0.0,0.0,0.0,0.0,0.23519817199999998,0.323003589,0.0,0.00600257525,0.31336389,0.254788593,0.0,0.0,0.07991973320000001,0.21404465600000003,0.174130647,0.0,0.0,0.277347073,0.0,0.18592660100000002,0.0206642685,0.042024089800000004,0.113955242,0.268371445,0.136988306,0.0,0.0,0.0,0.0,0.187825839,0.0,0.00897373941,0.0,0.0,0.108917778,0.0,0.0,0.306246646,0.0,0.0335185579,0.0,0.0040767189899999995,0.0,0.0991804459,0.0,0.0812283145,0.0,0.0,0.0,0.32067121,0.352887186,0.0,0.0509022203,0.021829154700000002,0.0,0.0,0.0,0.196219024,0.0,0.0,0.0,0.0,0.0,0.18216464899999998,0.240437807,0.0056556607,0.29223756300000003,0.0,0.0,0.0423223856,0.107675251,0.0,0.0,0.0,0.309582967,0.143904299,0.0,0.30480656,0.0798367712,0.0,0.136738162,0.0,0.10296607599999999,0.0,0.33891881799999996,0.283218332,0.0,0.0,0.14520011800000002,0.35178033200000003,0.0,0.0,0.30944623600000004,0.289875683,0.0,0.0,0.11535573,0.289490679,0.0344322637,0.19660760800000002,0.30556680399999997,0.0,0.0,0.243091031,0.242605595,0.323425064,0.0,0.0,0.30539845600000004,0.0385683507,0.09906574800000001,0.0,0.0,0.0,0.0750364878,0.30396746399999997,0.253876958,0.102802115,0.0,0.0,0.017387528,0.141897296,0.0,0.0,0.0,0.311767144,0.0,0.055617369900000005,0.0,0.0,0.09615406480000001,0.183714717,0.0,0.267953705,0.0536394934,0.352222682,0.214011477,0.18033565699999998,0.0,0.256991982,0.12888509199999998,0.235094379,0.259680748,0.22533245699999999,0.236396208,0.488235194,0.564465022,0.550169583,1.17769313,1.39575434,1.2891446000000002,1.36202352,1.24573294,1.38495358,1.84558399,2.08509898,1.83842956,2.06213677,1.58086075,1.52030517,1.75249779,1.31254123,1.01894061,1.09596815,1.02755514,0.398095728,0.366197348,0.863460048,0.341398265,0.78266622,0.459621475,0.773866765,1.19207319,0.955531311,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.9271125309999999,0.0,0.63124123,0.0,0.0,0.259666367,0.0,0.5092576870000001,0.94392222,0.177700529,2.35222598,1.7815796000000002,3.15006637,2.85180611,2.85245374,4.95850464,3.83782466,4.93686398,4.00857133,3.52885552,4.251109099999999,2.35844772,2.6367512000000004,4.16463723,2.93777208,0.310763088,0.960580687,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.345166591,0.0,0.0,0.0,1.02428502,1.40182918,0.17358878,1.53800091,0.42953570700000004,0.0,0.0,0.0937125569,0.175714757,0.0,0.509556342,0.0,0.0,0.0,0.05585057400000001,0.0,0.209726209,0.0,1.52883378,1.1093051,0.0,0.0,1.28051651,0.0,0.0,0.0,0.0,0.0,1.23227988,0.0,0.0,0.342641536,0.179732792,0.0,0.0,0.897894416,1.42464706,0.0,0.450670271,0.0,0.0,0.48420696799999996,0.0,0.0,0.0,1.22159117,1.07969878,0.0,0.815876624,0.138633314,0.02783006,0.0,0.0198604353,1.28624155,0.0,0.6831656359999999,0.0,0.0,0.0,0.0,0.0,0.36737025700000003,0.0,0.0,2.15910192,0.163177651,0.40440865600000003,0.407394655,0.0,0.0,1.74401618,1.47406333,0.0,1.44482955,1.83148709,1.21684892,0.0,0.393330419,0.772830308,0.0,0.684455818,1.31258714,0.8394489190000001,0.225629418,1.48328846,0.539214364,0.627142495,0.909427641,2.10490577,0.0,0.0,0.100685218,0.024292177400000003,0.0752123741,0.0,0.511784275,0.0,0.0,0.0,0.0845399539,0.0,0.0,0.22575514800000002,0.40593541899999996,1.03096024,0.0,0.18750609199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.04711412,0.803765185,0.208942777,0.563275964,0.0,1.65881158,1.00118747,1.80217126,2.03016327,0.0,2.95510789,0.0,0.907618762,1.51846078,1.2578486,0.0,0.0,0.5389554910000001,0.0,0.0,1.27001001,0.0,0.576165164,1.08611717,0.7915316179999999,0.07670068099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.356052196,2.04949074,0.0,1.71375841,0.0,0.8776740479999999,0.0,0.46906027899999997,0.0,0.700465887,1.73943775,0.903580487,0.0,0.0,0.21376001100000003,2.20486998,0.267321868,0.0,0.0,4.53292887,1.98519819,0.566285361,0.640002007,0.0939253849,1.64733411,0.049483323499999995,0.0,0.22862764800000002,0.24639410399999997,0.0,0.0,2.72059408,0.0,0.0,0.37744010200000006,1.69579235,0.0,0.0,1.49173617,0.0,1.0826528,1.19108645,0.0,0.408313486,2.48902464,0.0,1.01566072,0.0,0.0,0.0,0.0,0.0,1.2735016000000001,0.0,1.30846084,1.33684337,0.133702223,0.0400298072,0.0,0.0462382009,0.913683683,0.0285265271,1.7004107,1.4714121,0.0,0.560090454,0.0,0.0,0.499086396,0.0,0.0,2.14627731,0.33800031700000005,0.721029096,1.09647825,0.7238264109999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.07127023,1.6622324,1.78211456,2.65929401,3.22987456,2.9844287,3.23810428,3.86893259,3.76897152,3.88255338,3.59877913,3.5377012000000003,3.10247038,2.72871839,2.5860155,2.1982232999999995,1.29033135,1.14851004,0.52461481,0.45133163200000004,0.0,0.152294725,0.0,0.0,0.0,0.448706221,0.11224737900000001,0.347948515,0.585079242,1.27071492,1.34095467,1.08299672,1.66016001,1.00881428,1.37530067,1.14620112,0.817794118,1.0543813999999998,0.42980177799999997,0.417912794,0.7017359259999999,0.29807072100000004,0.5343890370000001,0.535869625,0.0610676592,0.384762695,0.242043079,0.44684925299999995,0.5672881679999999,0.707367302,0.7794573890000001,1.12676634,1.32744311,1.29954708,1.08484773,1.35558798,1.10037262,0.605761741,1.05944256,0.924011855,0.505811363,0.774303957,0.39959856200000005,0.253165002,0.394065579,0.565398065,0.31896082600000003,0.227950056,0.249513525,0.598092533,0.134556638,0.047263342,0.41991523799999997,0.229971578,0.09257272960000001,0.604903837,0.47566693299999996,0.0469574843,0.21883488,0.0,0.148005088,0.050441063099999996,0.00133669698,0.0,0.0,0.16694626099999998,0.0,0.0,0.0153616707,0.0,0.381056832,0.47242227700000006,0.017543173500000002,0.377087381,0.111032644,0.400569096,0.0905674335,0.220531034,0.0,0.0,0.0,0.0,0.0,0.109569037,0.1118009,0.042193384400000006,0.26304580699999996,0.0,0.265396859,0.151048023,0.30274514399999997,0.41632215899999997,0.26591864600000004,0.410747856,0.0,0.0,0.0,0.379126213,0.0,0.045312125700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11015974099999999,0.0189583124,0.289694863,0.0,0.23900643100000002,0.0316147942,0.14066182800000002,0.28698573,0.419020296,0.0,0.382399195,0.101718029,0.0,0.0,0.08611438490000001,0.0,0.108919965,0.18090827199999998,0.196661631,0.16292896699999998,0.0,0.166793664,0.25782708,0.431349763,0.112794929,0.33218776899999997,0.0,0.0,0.0,0.121088985,0.0,0.0,0.0,0.0,0.0,0.16580499,0.061525232199999995,0.051653221299999996,0.0,0.30164562899999997,0.19785091800000001,0.23367135,0.051069665199999996,0.0,0.0,0.0,0.0,0.0823472678,0.0,0.144555195,0.0987396507,0.165487775,0.0,0.0,0.154141132,0.0,0.0,0.138330155,0.125720448,0.0,0.0722497001,0.28013796,0.233577447,0.39242648700000005,0.0510278636,0.43960373799999997,0.0,0.439941184,0.17734423300000002,0.0,0.0551995666,0.21191959800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.058429899199999996,0.0,0.0,0.0,0.0,0.243450597,0.0,0.011621648799999999,0.372226499,0.391373112,0.0,0.233623923,0.0,0.0,0.109693755,0.10354165800000001,0.0962204482,0.0,0.0,0.0,0.0,0.375794254,0.0186281992,0.380421432,0.253287098,0.0,0.0196570776,0.395400901,0.0727132249,0.0,0.17548165,0.0,0.0,0.0,0.0,0.341024651,0.225200808,0.190864128,0.308280581,0.556525298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.107932277,0.14956197400000001,0.25180762100000004,0.0,0.339144874,0.320883596,0.586228204,0.0,0.0,0.0,0.0,0.265219262,0.0,0.0,0.210955107,0.0,0.0,0.0,0.0,0.590886991,0.0334018653,0.0,0.704419955,0.787664402,0.17297300000000002,0.661313479,0.0,0.86674367,0.262394031,0.0,0.48796965600000003,0.536412012,0.590260644,0.294933182,0.0,0.872031785,1.37780267,0.771129918,0.509209414,0.0,0.607064715,0.0,0.0,0.0,0.299619812,1.20517047,0.156972831,0.0,0.547567206,0.0,0.27530254,0.0,0.0,0.0,0.43755213200000004,0.174574693,0.0,0.56607875,0.0,0.72008613,0.178765902,0.0,0.0,0.0,0.0,0.113207573,0.103439895,1.28330569,0.974545969,0.0,0.49993540700000005,0.0,0.531683657,0.0,0.0,0.0,0.915961848,0.500602389,0.48680535,0.117427067,0.0,0.0,0.5415559320000001,0.676663206,0.8708488529999999,0.0,0.803311874,0.0,0.26590026,0.263051727,1.13780895,1.15939989,0.9277311229999999,1.23784051,1.0220555,0.221163992,0.24043192,0.0,0.0,0.251191788,0.76436224,0.0,1.63080882,0.0,0.0,0.41666281,0.378085495,0.0,0.6562301770000001,1.13740867,0.20619923399999998,0.9277043640000001,0.304870853,0.311868058,0.0,0.0,0.38191164299999997,0.0,0.0,0.0245644363,0.06740624349999999,0.692777144,0.0,0.462322326,0.0,0.0702998891,0.141213529,0.691546178,0.0,0.0,0.8606680720000001,1.5210238,1.23756225,1.17216863,0.759105358,0.610483197,0.593098311,0.0,0.0856747126,0.47393701200000005,0.051963927800000004,0.0,0.231832025,0.0,0.0,0.0,0.698408238,0.0,0.260545762,0.365209095,0.166246839,0.803817535,0.0,0.869356967,1.96599249,0.12753535,1.45282861,0.778019283,0.0,0.0321674206,0.628815487,0.480790967,0.46596999899999997,0.28760536600000003,0.0,0.0,0.519222382,0.48467161,1.30301849,0.43869485399999997,0.89357692,0.715360792,0.0,0.302164295,1.84975905,2.69966734,4.11938123,2.82063551,1.94011265,0.535926104,0.947920146,0.0,0.0683994112,0.0,0.806134094,0.96115639,0.7124422490000001,0.847706333,0.848456251,1.9342901999999997,1.70733261,1.5247752,0.572957733,1.21167359,2.05689017,0.250489323,0.977439933,1.74258482,1.53249501,1.9587017,3.29404139,2.57889682,3.82337567,2.81885397,2.40735282,1.66739319,2.86442401,2.1711370999999997,3.65433229,2.71653201,2.82549863,1.65578319,0.570087691,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8272194409999999,0.0,0.0,0.7460983440000001,6.79942906,9.71583489,6.95878704,3.02725131,0.655524303,0.0,0.0,0.0,1.03565733,0.0,0.0,0.0,0.0,0.43812654,1.01862945,0.0,0.206513709,0.0103808709,0.9574147740000001,0.0,0.0,0.0,0.0,0.0,0.87660751,0.326424963,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.57433106,3.31885702,5.34299249,6.7234313,6.82377715,5.64009197,3.76379313,2.00523473,0.9303802879999999,0.600751312,0.6560226889999999,0.647188761,0.373303812,0.0,0.0,0.25109968,1.06830514,1.95376346,2.46990701,2.37905704,1.76768372,0.9577742309999999,0.28926344600000004,0.0,0.0,0.0,0.00254638556,0.0888816118,0.200727447,0.327902768,0.396910969,0.326652779,0.116458561,0.0,0.0,0.0,0.06622344179999999,0.230144656,0.199611615,0.0,0.0,0.0,0.0,0.234568115,0.362158052,0.171246061,0.0,0.0,0.0,0.253830304,1.21538867,2.01500217,2.25061164,1.81839358,0.965101601,0.122529231,0.0,0.0,0.0,0.134491641,0.215364494,0.11177551699999999,0.0,0.0,0.0,0.007902007420000001,0.08374534389999999,0.0879181742,0.0397131623,0.0,0.0,0.0,0.0129979691,0.0288888571,0.0409750169,0.0548516051,0.0616473171,0.0428854931,0.0,0.0,0.0,0.0,0.0650530173,0.09815242769999999,0.0428537356,0.0,0.0,0.0,0.0642385185,0.214337547,0.19800600399999999,0.0,0.0,0.0,0.0,0.7027100270000001,1.65468331,2.33611189,2.41255062,1.85311189,0.949756002,0.13673194800000002,0.0,0.0,0.0343508431,0.23570918,0.216572085,0.026798551099999998,0.0,0.0,0.0,0.0976990787,0.160502499,0.0850622225,0.0,0.0,0.0,0.016528647900000002,0.105352868,0.0991369609,0.0112373272,0.0,0.0,0.0,0.05328217019999999,0.0872033398,0.0458338335,0.0,0.0,0.0,0.0103184975,0.0594216651,0.054578268099999994,0.00527815282,0.0,0.0,0.0,0.0263853886,0.0400078833,0.0191330596,0.0,0.0,0.0,0.0025870078,0.00946297452,0.00450628543,5.71957881e-05,0.0011865025300000001,0.0,0.0,0.0444589149,0.265103614,0.7706117140000001,1.56081886,2.44087376,3.05901816,3.0774772,2.38723642,1.22030249,0.059568917400000004,0.0,0.0,0.0,0.330356983,0.493525175,0.23922106699999998,0.0,0.0,0.0,0.0825845211,0.39549210799999995,0.370574192,0.0199545427,0.0,0.0,0.0,0.34250518399999996,0.584232554,0.321474942,0.0,0.0,0.0,0.270740983,1.74292954,3.01816657,3.45306862,2.85148333,1.57203604,0.284297793,0.0,0.0,0.0,0.10700786400000001,0.116527841,0.0,0.0909709013,0.664356322,1.58512903,2.36864067,2.47505884,1.69736088,0.35837337799999996,0.0,0.0,0.0,0.652431553,1.79112099,2.19467251,1.77522246,1.04529312,0.794451665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.75647098,2.53881092,0.0,0.0,1.60066429,2.59616592,1.04013977,3.66555999,6.86746215,3.12909067,1.7818665,0.43732881,0.64944631,0.0,0.0,0.0,0.0,0.76823201,0.40495763,0.42607789,0.29625159,0.34470813,0.42444421,0.83908484,2.62172036,8.22285899,0.21935433,1.19247903,2.92376802,0.0,1.11449723,0.0,0.0,0.96335135,0.0,0.24863403,0.06837209,0.0,0.77570599,0.0,0.25932029,0.75443901,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.22546337,3.11535476,2.68119715,2.02631653,1.29334748,0.62606516,0.13362966,0.0,0.0,0.0,0.09035177,0.25420601,0.36090363,0.4010395,0.39967161,0.39937459999999997,0.43836584,0.53204993,0.66468988,0.79400088,0.86669551,0.83906295,0.69489724,0.45407867,0.16847373,0.0,0.0,0.0,0.0,0.0,0.08017415,0.21462162,0.26022911,0.20473073,0.07284258,0.0,0.0,0.0,0.0,0.0,0.09538089999999999,0.21632647,0.25489436,0.19343077,0.05210455,0.0,0.0,0.0,0.0,0.0,0.15803386,0.32081338,0.37159797,0.27589918,0.05222843,0.0,0.0,0.0,0.0,0.15196978,0.84725703,1.6529716,2.41438064,2.97676009,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.665602987,0.0,0.0,0.689771591,0.0,0.0,0.228588698,0.0,0.0,0.0,0.778902613,0.0512166175,0.0,0.19039955100000003,0.0,0.651842204,0.452758363,0.533245031,0.339044471,0.0,0.0,0.0,0.0,0.45054082100000004,0.394594029,0.0,0.0,0.0,0.755363322,0.0,0.0,0.0,0.012293121,0.0,0.18511729600000001,0.0,0.0,0.0297311652,0.0,0.0,0.5589042320000001,0.6881554240000001,0.50089509,0.0,0.9576266640000001,0.691653284,0.7051404929999999,0.879149472,0.0,0.0,0.35176614,0.0,0.680097905,0.39009818799999996,0.698536301,0.0,0.0,0.0537949299,0.118210557,0.80534668,0.0,0.0,0.0,0.900623452,1.15913058,2.7022275000000002,2.36111614,1.85740832,2.31232362,1.23094825,0.0476841666,0.0,0.039661701800000004,0.0157440712,0.459433352,0.0922460545,0.560516719,0.0,0.647467069,0.293660689,0.0,0.0,0.0,0.0,0.0,0.0,0.460386988,0.0159287636,0.0,0.0,0.5435985839999999,0.11720510099999999,0.0,0.0,0.33583616299999997,0.0,0.0,0.0,0.0,0.617034614,0.274724201,0.30978303100000004,0.0,0.41710160700000004,0.0,0.102105226,0.0,0.25106416600000003,0.380085326,0.0,0.0,0.0197900001,1.25254555,0.333320939,0.14685332199999998,0.0,0.0,1.40552305,2.7211344,5.35623802,5.99807306,6.35986505,3.25594038,1.43149924,0.0,0.0,0.36006036700000005,0.703403572,0.622974083,0.583879509,0.0,0.0,0.604495395,0.0,0.43095515700000003,0.57065636,0.0,0.0,0.378636049,0.808135026,1.14876711,1.94338818,1.20460569,1.29321961,1.32390424,0.557044408,0.8851601659999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.171532226,0.421699679,0.48419964200000004,0.293160914,0.0,0.0,0.0,0.0,0.267287854,1.07969469,1.84868909,2.32694497,2.36947897,1.98623091,1.33008891,0.628594839,0.09097537689999999,0.0,0.0,0.0,0.152808952,0.20720724100000001,0.129241763,0.0,0.0,0.0,0.0,0.0507989665,0.16415170199999998,0.173272483,0.07067638030000001,0.0,0.0,0.0,0.0,0.12222639,0.224956138,0.186612186,0.0177344551,0.0,0.0,0.0,0.0294742884,0.291348523,0.401772093,0.249742667,0.0,0.0,0.0,0.0,0.45128326,1.55066986,2.56550223,3.11653955,2.98985985,2.2382735,1.15946356,0.16006897,0.0,0.0,0.0,0.321029103,0.613315584,0.587636497,0.289309459,0.0,0.0,0.0,0.0,0.11674965400000001,0.28434116600000003,0.261648355,0.0813263054,0.0,0.0,0.0,0.0,0.144915774,0.222093205,0.156405411,0.0,0.0,0.0,0.0,0.0339040713,0.160721066,0.18201700699999998,0.0875433603,0.0,0.0,0.0,0.0,0.083611633,0.170704954,0.148040169,0.030679623399999998,0.0,0.0,0.0,0.0,0.130796877,0.18360453699999998,0.118782519,0.0,0.0,0.0,0.0,0.0734834527,0.265385105,0.37236125200000003,0.35400217700000003,0.23783564,0.0974358488,0.00564754769,0.0,0.0339222786,0.0735629662,0.0654528248,0.00491179299,0.0,0.0,0.0,0.011973629,0.09423668699999999,0.11881632,0.0660175933,0.0,0.0,0.0,0.0,0.0568446064,0.136369396,0.135364583,0.0561481234,0.0,0.0,0.0,0.0,0.06938099639999999,0.0989636458,0.0927996242,0.13984190400000002,0.359936574,0.8205683509999999,1.46357136,2.09420933,2.45553064,2.36198638,1.8252308999999998,1.09752024,0.5928672660000001,0.7080925370000001,1.62309386,3.17993265,4.90956924,6.20606174,6.5748703,5.84240462,4.22949061,2.25519207,0.517605907,0.0,0.0,0.0,0.140692502,0.622902857,0.7976286779999999,0.68567465,0.45765677,0.305401725,0.32544472,0.475273139,0.617098768,0.61468424,0.42261016100000004,0.116462828,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.271140795,0.5839280020000001,0.23493048,0.110328909,0.487852925,0.0,0.703207639,0.686026039,1.29624827,1.65631178,1.28453995,1.47887069,0.682184872,0.710045693,0.8401973709999999,0.330109622,0.155956184,0.0,0.049704975,0.347365235,0.0,0.0,0.342098445,0.13947911400000002,1.01569377,1.74264536,2.00128315,1.50601725,1.56650143,1.35500426,1.49914325,1.44181448,1.01268792,1.35973282,0.723917088,0.951644484,1.1354952,1.05043358,1.31774869,1.18764842,1.50467228,1.51962844,1.77398509,2.177084,1.72368403,2.01866135,1.82256371,1.1586086000000002,0.796567881,1.24252414,0.49082787899999997,0.0,0.3271007,0.0,0.0,0.0990372018,0.11909064300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.42743143899999997,0.0,0.447332668,0.0,0.118787478,0.207668861,0.251335956,0.409147689,0.340358536,0.0,0.0,0.33101639,0.21955433300000002,0.356212652,0.0,0.0896448574,0.610019003,0.34938708700000004,0.861818712,0.8808106059999999,0.334395944,0.584219756,0.535605727,0.369277355,0.0,0.0,0.642254731,0.665431955,0.243947391,0.0,0.0105008427,0.151341657,0.0578026384,0.55734214,0.0,0.000635446179,0.0,0.0,1.08276713,1.56066082,3.67305364,3.85119458,3.84804416,2.15428822,1.58970351,0.754023447,0.0,0.118920601,0.0,0.44954758,0.0,0.129422397,0.0,0.0,0.140132485,0.335434942,0.13434759,0.0,0.0557387906,0.316155996,0.0,0.419068565,0.0965694031,0.723639626,0.58119429,2.03688651,3.20725273,4.24788058,5.00178257,3.37422393,1.8421383999999998,0.147577334,0.0,0.0,0.0,0.37625209200000004,0.0,0.0,0.0,0.0,0.37381475700000005,0.0,0.0,0.0,0.0,0.239977527,0.0194074099,0.09811048439999999,0.118077377,0.0,0.0,0.603025186,0.046533961,0.185360031,0.0,0.0,0.381333983,0.989101949,1.46816209,1.19892105,1.13069201,0.0198557927,0.0,0.0,0.219780568,0.150316729,0.18499710100000002,0.199922669,0.0,0.0,0.0,0.42952825299999997,0.0,0.130732115,0.0,0.0,0.68461207,0.9136939940000001,0.8942319999999999,0.0519381941,0.333644424,0.0693147631,0.0,0.031354975099999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.110854442,1.73372091,3.6032319999999998,5.2440477,6.2181326,6.27305291,5.42607441,3.95274974,2.28559643,0.8627817659999999,0.0,0.0,0.0,0.403977388,0.769996204,0.869094283,0.666527566,0.27143694,0.0,0.0,0.0,0.0,0.106216693,0.334519876,0.40496197,0.300812932,0.0873807364,0.0,0.0,0.0,0.0,0.112205712,0.248045305,0.280901718,0.20965121399999997,0.0830669105,0.0,0.0,0.0,0.0837195479,0.18665917,0.232682272,0.19593782199999998,0.0917879991,0.0,0.0,0.0,0.0,0.010239485500000001,0.0949587489,0.12901155,0.0985530656,0.0219131769,0.0,0.0,0.0,0.0,0.0299436421,0.08740774300000001,0.09936412830000001,0.0624315225,0.0,0.0,0.0,0.0,0.0,0.0396001506,0.0759758504,0.0735205184,0.0354808324,0.0,0.0,0.0,0.0,0.0,0.042180608099999996,0.06253111459999999,0.0514099687,0.0159516429,0.0,0.0,0.0,0.0,0.0100104029,0.0397070129,0.0484150846,0.0331483669,0.00274100243,0.0,0.0,0.0,0.0,0.0153314744,0.0339283232,0.0349217682,0.018977296799999998,0.0,0.0,0.0,0.0,0.0,0.0164439295,0.026714938100000002,0.0234016302,0.009031091750000001,0.0,0.0,0.0,0.0,0.0022694944600000003,0.0153878112,0.0202166576,0.0149097921,0.0027804587100000006,0.0,0.0,0.0,0.0104957669,0.0335250469,0.0528669709,0.059633476500000004,0.048509353899999996,0.0205196627,0.0,0.0,0.0,0.0,0.0651465358,0.193433881,0.352377813,0.5178525860000001,0.663244288,0.7677650429999999,0.8235327809999999,0.838573582,0.8342192620000001,0.8375367509999999,0.871550983,0.9471106220000001,1.05967721,1.19221943,1.32266127,1.43225948,1.51093954,1.55727221,1.57368272,1.5601914,1.51100921,1.41693662,1.27324533,1.0891464,0.893016154,0.728581405,0.641175527,0.658354349,0.77310832,0.938412373,1.07814004,1.11264299,0.990377683,0.71306786,0.343142557,0.0,0.0,0.0,0.033321420299999994,0.502543408,1.07709431,1.62481029,2.02536873,2.20248428,2.13863856,1.87009346,1.46782607,1.01436239,0.585653606,0.24215731,0.027210407000000002,0.0,0.06758272280000001,0.307089958,0.630230662,0.950595126,1.16761899,1.19648527,1.0014816,0.618112419,0.15081999,0.0,0.0,0.0,0.0,0.14705717699999998,0.43405214299999995,0.525593774,0.37467490000000003,0.046992769000000004,0.0,0.0,0.0,0.0,0.34333730100000004,0.690881425,0.73778461,0.40124630299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.546912309,0.36589318299999996,0.0,0.0,0.145801755,0.337691165,0.0,0.0977250033,0.0,0.14592580300000002,0.41368608799999995,0.0,0.26154498,0.21365409300000002,0.0,0.0,0.0,0.0,0.198378238,0.300409296,0.35233928700000006,0.0,0.167316006,0.0,0.0,0.312151526,0.24107802600000003,0.64887124,0.0,0.0,0.0,0.0,1.24457848,2.87662393,4.68323318,4.77608067,3.89969114,2.28364522,0.535136311,0.0,0.0,0.0,0.42465070899999996,0.943069843,0.36082929999999996,0.5896969329999999,0.0,0.0,0.0,1.07889395,1.98764714,2.36196885,2.864682,1.87649655,1.22887795,0.291292983,0.135490828,0.0,0.166914748,0.0,0.0664032415,0.018792853,0.0,0.05317497,0.0,0.0,0.0,1.7987260899999998e-05,0.0218772469,0.0,0.0,0.418265069,0.318443149,0.469955595,0.0,0.0,0.351147999,0.0,0.0,0.356737498,0.188354379,0.20771437,0.0,0.0,0.0,0.295871421,0.036907595,0.0429820267,0.40819551,0.43255934700000004,0.364635069,0.549918563,0.880872552,0.61294556,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.247159335,0.162224145,0.0,0.355557826,0.755855733,0.0,0.0950155909,0.281896567,0.333898065,0.0,0.79016342,0.296134287,1.50284053,0.281746483,0.292692661,0.0,1.01577573,0.8843676559999999,0.267485711,1.36083617,0.0766499679,0.17883023899999997,1.07099106,0.85616912,0.40768376700000003,1.50283104,0.0,0.131364481,0.0643441616,0.0,4.70819829,5.33918092,0.0,2.0924613,7.7378266,2.37434193,0.0,0.751242972,0.0,2.35274496,0.0673749626,1.57559311,0.851250085,0.708017201,0.0,1.9934391,4.33778656,0.0,2.40724398,0.0,1.99674696,2.3006545,1.46102937,1.47757815,0.0,0.180804735,0.0,0.0504365029,0.171184557,0.40058881399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.07579357,0.0,0.0,0.0,0.0,0.0,0.08317423,0.17872071,0.23147577,0.23415656,0.19037779999999999,0.11261743,0.01890863,0.0,0.0,0.0,0.0,0.0,0.0,0.01669286,0.09720708,0.16293289,0.20366412,0.21465887,0.1974116,0.15935781,0.11261716,0.07201801,0.05273048,0.06786366,0.1263583,0.23144406,0.37984389,0.56181374,0.76201442,0.96113052,1.13808146,1.27261122,1.34799649,1.35357947,1.28681652,1.15454551,0.97322103,0.76795335,0.57031433,0.41503211,0.33586822,0.36113051,0.50939234,0.78603532,1.18119,1.66950824,2.21197519,2.7596838,3.2591937,3.65882792,3.91507403,3.998189,3.89617879,3.61653194,3.18540252,2.64431444,2.04483565,1.44198349,0.88731859,0.42272949,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.415714797,1.89638211,4.14785471,3.92409014,6.20574036,4.7025765,4.52557282,0.117512359,2.38449818,0.164350425,0.0,2.09638198,0.16453509,0.0,1.7973240000000001,0.875126718,0.0,0.0,0.0,1.56895467,0.391620034,1.25026407,0.21579732399999998,0.41585412899999996,0.0,0.0,2.19976057,0.0,0.36224062100000004,0.520565244,0.0,0.438629826,0.5710472520000001,0.567878788,1.06729917,0.0,0.0,0.164123611,0.0351757034,0.0,0.403163965,0.0,0.6069524829999999,0.0,2.76263311,2.09354904,0.0,0.0,0.0,0.494135165,0.0,0.0,0.025386041,0.750740333,0.102242375,0.0,0.302506273,0.0,1.43292927,0.498102435,0.0,0.0,0.0,0.532137958,1.09309191,0.118745979,0.112128022,0.0,1.0635092,0.6858296209999999,1.0397094999999998,0.0,0.0,0.924227225,0.0,0.0,0.0,0.0,1.23359547,0.95487628,1.54334758,1.14789168,0.0,1.04197631,0.5052301889999999,0.0,0.0,0.0,1.65760154,0.473336835,2.01645587,1.63410201,0.0,0.65091513,1.21217769,0.0,0.8755679040000001,0.0,0.0,0.309534443,0.0,0.0,0.0,1.23634683,0.0,0.0,0.0,0.0,0.0,0.0,0.835447527,0.273328128,0.761882029,3.59180681,2.10607966,0.905884887,0.618999304,1.13903724,1.16997705,0.389054381,3.1042068,1.46671481,0.584456341,1.36086519,0.440298022,1.11209627,0.24760296699999998,0.0,1.40173638,0.685744881,0.358105357,2.5426376,0.272360431,1.36398431,0.26399529,0.0,0.0,0.0,0.0,0.337215782,1.77148325,0.0,0.16269234,2.07346923,1.67874124,2.61136373,0.8880307609999999,0.62506327,0.150653369,0.0,0.66829157,0.148964225,1.74752958,1.042414,2.48937537,1.98925709,0.233157035,0.0,0.0,0.7584291040000001,0.327938872,0.0,0.09064855220000001,1.14128496,1.08020795,0.0,0.0,0.025141457000000002,0.0,1.1133711000000002,0.796103362,0.0,0.33887957399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5856208820000001,0.655544579,0.668625984,0.619580103,0.514457175,0.368618461,0.203446032,0.042380458600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08530956599999999,0.14913513,0.181030415,0.17685268899999998,0.139073082,0.0759847785,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08838823779999999,0.173403002,0.24405990800000002,0.292127476,0.313198131,0.307066318,0.277399365,0.230806769,0.17550851899999997,0.119857979,0.0709823076,0.0337648289,0.0103181963,0.0,0.0,0.00581795451,0.013080273500000001,0.017754343500000002,0.0173047846,0.0110199605,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0178202822,0.0329354933,0.0420446448,0.0429774052,0.035187220299999995,0.0199173243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0233351115,0.042764393600000006,0.0542333241,0.0551543769,0.0449794775,0.0253823467,1.14064875e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0287288033,0.051985850099999995,0.0647593353,0.0642049497,0.0504718421,0.026973577999999998,3.42194625e-16,0.0,0.0,0.0,0.014201055700000001,0.07232299639999999,0.14809598,0.23116613800000002,0.30774026,0.362669115,0.382065971,0.35605384100000004,0.281172543,0.161990401,0.011558306899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0269693827,0.356191473,0.737446842,1.13357271,1.50257758,1.80304807,1.99979725,2.06893693,2.00160139,1.80571536,1.5054637,1.13844748,0.750854102,0.391274765,0.10402476199999999,0.0,0.0,0.0,0.110771317,0.360189882,0.638784942,0.8976951679999999,1.09096358,1.18255277,1.15205352,0.998229723,0.739842352,0.41358130200000004,0.06934984129999999,0.0,0.0,0.0,0.0,0.0,0.29054421199999997,0.863020247,1.51525537,2.18439005,2.80421512,3.3133462,3.66270217,3.82129226,3.77956635,3.54993372,3.16445465,2.6700991000000003,2.12229032,1.5776652,1.08705817,0.6896456440000001,0.40898727700000004,0.251402682,0.20677335300000002,0.251512967,0.353154794,0.47580402299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8914751209999999,2.25286803,1.62447764,2.19208377,0.415221112,0.554790911,0.0,0.382642355,0.36077722799999995,0.0,0.390423132,0.0,0.192769854,0.0,0.247390495,0.0,0.509846039,0.0,0.40233324,0.0,0.0,0.0,0.472945605,0.0,0.0,0.0,0.458892827,0.638241254,0.0,0.09854775880000001,0.0,0.657557017,0.0,0.460354041,0.23996795699999998,0.237519051,0.183214596,0.09510173359999999,0.0,0.0,0.282434774,1.0943223999999998,2.95322077,5.38181216,5.78194005,6.17949106,4.69986433,1.91732721,0.546669324,0.0,0.0,0.0,0.0,0.621486455,0.0,0.0,0.0,0.37314286,0.17607453899999997,0.526215079,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00534112103,0.0,0.0,0.0,0.0,0.31888764,0.0,0.0,0.622243481,0.16267917699999998,0.0621856814,0.0,0.0,0.0,0.232588696,0.448770577,0.0,0.0,0.0726922039,0.851281198,1.33094652,0.768701828,0.556259402,0.0,0.0,0.0,0.0950503141,0.0,0.0,0.0,0.25134859,0.0,0.0,0.0845464975,0.405604132,0.389090231,0.0,0.559087698,0.0,0.0,0.0,0.0,0.0,0.0,0.350435548,0.6614150360000001,0.21716834699999998,1.3613427,1.65517486,1.66795674,1.42000766,0.768728086,1.48347695,0.6429136129999999,0.784327662,0.08192405559999999,0.0,0.052074956799999995,0.10788736,0.8054263559999999,1.14205829,2.05811341,2.70223167,3.13336028,3.19130672,1.94886766,0.481299965,0.0,0.0,0.0,0.6899178890000001,0.0,0.48357269,0.0625432526,0.293977095,0.0203214694,1.13252128,0.0888818379,0.0,0.0414380867,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.48147367700000004,0.0615024942,0.290868962,0.0549209438,0.16410418699999998,0.0,0.0,0.0,0.0211550205,0.272180859,0.7145240909999999,0.8910027709999999,0.861961731,0.33784406200000006,0.0,0.104247102,0.38263042799999997,0.0213310856,0.0,0.019035743,0.633310609,0.255971736,0.0,0.43397707,0.347687386,0.0,0.0,0.0,0.0,0.523737721,0.0,0.536825814,0.126862287,0.841507085,0.0,0.6401372710000001,0.0689672867,0.030576815499999997,0.0,0.0,0.0,0.976423843,0.9311479570000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04303910389999999,0.438670116,2.61977075,2.75276791,2.88951827,3.84407822,3.55013645,2.16422864,1.61505398,0.160964023,0.7379822340000001,0.4913911,2.26794064,3.42545688,5.389578500000001,6.46566823,8.38162706,7.805008099999999,7.73718531,5.74806194,5.27250374,3.19670811,2.54406619,0.424693923,0.642509628,0.0,0.146948039,0.546951321,0.987412982,0.238791885,0.7723573029999999,0.173676142,0.0,0.0,0.0843211557,0.596027131,0.0,0.0,0.260183338,0.351021874,0.892098678,0.7767070620000001,0.0,0.172579075,0.0,0.50254946,0.0,0.007539194190000001,0.20808052300000002,0.471745105,0.38205304700000003,0.753599398,0.76840047,0.0,0.377357328,0.0,0.8211446440000001,0.439766704,0.9327763840000001,0.0,0.46715416,0.0,0.0483768562,0.235877055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.141455696,0.0525937393,0.0,0.0,0.0,0.550154964,0.263274584,0.341366299,0.5603807,0.0,0.0,0.47300422200000003,0.0,0.0,0.0,0.658209485,0.48844447799999996,0.0,0.0,0.19810213699999998,0.0,0.389930486,0.0,0.0,0.0,0.0,0.25653477399999997,0.0,0.411782992,0.0408616241,0.0393947058,0.0,0.0,0.0,0.0,0.638599704,0.581501001,0.18218153899999998,1.3003353000000002,0.356612782,1.52675618,0.394329459,0.321959671,1.31760873,0.18180384,0.7265804570000001,0.566613638,1.0489788999999998,0.984295998,0.5193199629999999,0.356036973,0.0,0.0,0.47659459299999996,0.6021234910000001,1.13276765,0.0,1.03706606,1.55150845,0.81026092,1.69364667,2.32589551,2.06048403,0.525912104,1.2191975,0.0,0.357554773,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.143361463,0.20424298300000002,0.325906559,0.0,0.235697543,0.31814270899999997,0.0,0.0,0.0,0.18623673100000002,0.0,0.026104243399999998,1.06918971,0.0,0.0,0.63493251,0.0,0.0,0.9540301240000001,0.0,0.0,0.0,0.347323667,0.494611542,0.0,0.0,0.0,0.45252132,0.159261295,0.0,0.0,0.72247027,0.0,1.37465014,0.942927629,0.6715314290000001,0.41083807899999997,0.721487337,0.34792030399999996,1.73400031,1.0394984,1.16494505,0.0,0.8382713940000001,0.70891108,0.0,0.0,0.0,0.628474815,0.41881866100000004,0.220702475,0.18237343600000003,1.11781622,0.473270865,0.808793185,0.0,0.783230887,0.5135062220000001,0.0,0.0,1.25859635,0.626741648,0.0,0.0,0.18678260300000002,0.0,0.426478536,0.0,0.0,0.22489547899999998,0.39633708799999995,0.456566442,1.5374774,1.03797734,1.10006106,2.86259488,1.65319037,1.02392801,1.81383336,1.73658253,1.58841217,1.63911391,1.27333502,1.15899444,1.57042267,1.67397834,1.33968437,2.36947615,2.18484371,2.35962475,2.60443581,4.21209229,2.4037611,2.72160023,1.45789389,1.92013651,2.13816,1.22985288,0.12056459,0.0,0.7653317709999999,0.140098208,0.90069514,0.0,0.147603361,0.0,0.35217489799999996,0.249731913,0.0,0.0,0.977139784,0.0,0.217520961,0.0,0.0,0.927453495,0.0,0.0,0.356481272,0.0,1.2922381,0.0,0.506629099,0.30779883199999997,0.658444537,0.171489732,0.152771764,0.0,0.0,0.0821045687,0.0,0.51615577,1.8191602999999998,1.23988384,1.44103274,1.83836164,0.862875873,3.16278384,3.4629593,3.2991339,2.63421818,1.40288598,1.87674773,0.948639325,0.8237110209999999,1.0417538,0.0,0.8620169040000001,0.0437000985,0.310996788,0.8270623890000001,0.49971497200000004,0.0,0.596931219,1.18544296,0.439333834,0.83209594,0.307254482,1.27100797,0.6336778829999999,1.05348524,0.938510079,0.966925076,1.37111636,0.6029942070000001,0.0,0.604512119,1.13094861,1.09346679,0.182733029,0.8350348059999999,0.416448494,0.0781718403,0.0,1.40034657,1.00408246,0.45045725799999997,0.671062255,1.63535783,1.43327969,0.983342776,0.687877072,2.21835512,0.7789231209999999,1.11964318,1.00149668,0.749539057,0.5502984989999999,1.27132817,0.0,0.0,0.0,0.864839977,0.0,0.442658179,0.41258867200000005,0.48579180200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0456225758,0.0,0.0,0.0,0.172581777,0.0,0.0,0.0,0.0,0.0,0.697049268,0.0,0.289366268,0.0,0.519717122,2.03702927,4.54816284,5.75421812,3.35464735,0.0,0.0,0.958274615,0.404457798,0.765932229,0.641805904,0.33630194700000005,0.559419039,0.0,0.0,0.0,0.531157468,0.0,0.88240406,0.053891960499999995,0.0,0.0,0.0,0.0,0.156097129,0.18525595399999997,0.0,1.35806427,1.20619251,0.0,0.0,0.700441495,0.0,0.0,0.595485381,0.00604559374,0.621582441,0.353755537,0.0,0.0,0.311041423,0.501265537,0.40738434,0.0,0.329443081,0.0,0.0,0.0,0.0,0.0,0.0,0.842707793,0.8932903090000001,0.0796465212,0.108048315,0.0,0.0,0.0879545735,0.0,0.0,0.954142323,1.37629583,0.327282809,0.695650515,0.807678014,0.7616430059999999,0.8844584440000001,0.558287035,0.0,0.0,1.01851552,1.00215238,0.93859864,1.09337005,0.747885569,0.167991136,0.997103829,0.255097931,0.0,0.0,0.0,0.0,0.0,0.664329273,0.12023674699999999,0.0,0.387734065,0.0,0.91887812,0.0,0.0,1.30906755,1.83662373,0.0,0.0,2.00456871,7.64585298,9.26450447,5.880910299999999,2.46966653,0.0579032383,0.468703287,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.0438712000000003,0.20401449,0.0,0.0,0.0,0.75243849,0.0,2.19263852,1.77760066,1.20458298,0.0,0.88794035,0.0,0.57035257,4.2286922,0.26347805,0.60367289,2.14326338,0.92197438,1.53771126,3.52489703,0.2417681,0.0,0.66982974,1.04022986,2.25927701,3.59222994,0.0,1.3229756000000001,1.64781469,6.98533368,3.70630853,0.0,0.0,16.43650956,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.687945994,0.406629453,0.38250712,0.99668926,0.9209133159999999,1.36851149,1.19948435,1.57670674,2.07045696,1.94515115,2.25392916,2.17581728,1.45605871,0.7710675459999999,2.23393141,0.603226202,1.27467876,0.262405889,0.23494079999999998,0.7746760859999999,0.0,0.6143972870000001,1.25754427,0.0,1.08598713,0.8536568720000001,1.25013464,0.617809209,0.022672541600000002,0.0,0.37495314700000004,0.2844006,0.8159566629999999,0.364616855,0.39100422,0.121598716,0.272735186,0.690413432,0.0,0.0,0.0,0.0,0.0,0.0,0.17810053,0.34641779899999997,0.451907226,0.0,1.17238343,1.80838357,3.04038616,2.92423845,2.75348079,3.26116138,3.39788562,2.78810409,3.0254195,2.61661346,2.80250653,1.79340946,1.38627602,0.994932873,0.43707280299999995,0.0,0.0,0.0,0.562644031,0.0,0.0,0.0,0.06504971150000001,0.023085807000000003,0.289550667,0.0,0.0,0.50541997,0.7970442870000001,0.0,1.07616275,0.0257612696,0.65885154,0.765475173,0.36768082700000004,0.0,0.0,0.334746892,1.09977945,0.0,0.0,0.0,0.0,0.446219586,0.581055477,1.32323397,0.402327283,0.0,0.37412736700000004,0.399026748,0.612020523,0.608842539,0.849165174,0.0,1.78420909,0.0,0.582140704,0.599003152,1.41950447,0.543881236,0.453726895,0.536241094,0.0,0.0,0.731049576,0.0,0.0,0.0189760428,0.14542847,0.0,0.0,0.733526095,0.0,0.0,0.0,0.0,0.0710934845,0.700385575,0.8062163259999999,0.0921901429,0.0,0.147172048,0.7228777209999999,0.506305537,0.0,1.0777424,0.0,0.229237243,0.013934335800000001,0.171945402,0.0,0.24861624899999998,0.0,0.0383063072,0.0,1.04799391,0.0,0.531412604,0.0,0.703264771,0.0,0.0,0.0,0.0,0.0,0.00733009177,0.0,0.0,0.0,0.0,0.629479359,1.55343838,0.0,0.246117456,1.53345875,0.7337389790000001,2.61374957,1.57301658,1.77439058,1.66786781,0.371561711,1.78608914,1.78585567,0.594203065,0.7666179759999999,2.00964234,0.0974657357,0.565353483,0.336182914,0.0,0.141459472,0.6595277429999999,0.143456809,0.0,0.227867655,0.159746462,0.0,0.138727546,0.0,0.0,0.0,0.673115047,1.69138437,0.0,0.0,0.23274535300000002,0.7145466970000001,0.738571711,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.676688838,1.39140909,0.0165604796,0.073856956,0.261232366,0.0,0.389830616,1.75297282,0.0,0.100068246,0.636974054,0.0335422144,0.9670555009999999,1.25337275,2.06209157,2.18475805,0.0,0.06913937860000001,0.42553915299999995,1.44697624,0.10953260199999999,0.153608416,0.0,0.462330075,0.0,0.111457918,0.0,0.083491063,0.0,1.05304714,0.99787624,1.83481344,0.434720457,0.47695787,0.0,2.3740215,4.35220524,0.0,0.619173957,0.0,0.0,0.0,0.0,0.0558700625,0.501291606,0.0,0.0,0.0,0.0,0.208148334,0.0,0.0,0.0,0.0,1.20687118,0.0235942925,0.25504610699999997,0.0,0.0,0.0,0.0,0.854653575,0.601935145,0.271799115,0.531812221,0.35032900899999997,0.608651869,0.24378535199999998,0.28381991,1.2141307,1.77753667,0.47590630899999997,0.0085577947,0.0,0.6688415289999999,0.0166698685,0.689906026,0.44776865299999996,0.0,0.343336816,0.0,0.0183750391,0.0,0.125648224,0.433288309,0.0,0.0960534876,0.522741978,0.0,0.0,0.15131957699999998,0.265211093,0.0313760104,0.0,0.0,0.406476785,0.0,0.133143705,0.0,0.627373959,1.52724314,2.28145118,0.598919797,1.21940255,0.041773015,0.0,0.597010909,0.352312576,2.05285273,0.50090372,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.529278652,0.794103992,1.32842384,1.46088763,0.898830245,0.0,0.0,0.0,0.092541514,1.09960088,1.68763919,1.56415205,0.938450731,0.297523307,0.0011595048800000002,0.0330858182,0.0981114183,0.0,0.0,0.0,0.163205299,1.11748107,2.03476673,2.34139856,1.80949372,0.745408847,0.0,0.0,0.0,0.143455675,0.39514383700000005,0.237256258,0.0,0.0,0.0,0.114583916,0.292580655,0.173139233,0.0,0.0,0.0,0.13956338199999999,0.33577673799999996,0.196698238,0.0,0.0,0.0,0.39292049799999995,1.3039486,1.98395887,2.12558844,1.73950455,1.09493193,0.507425603,0.151020635,0.015828156399999998,0.0,0.00047643665999999997,0.00020892871999999999,0.0013475509299999998,0.0059150596100000005,0.00365068341,0.0,0.0,0.0,0.0162301625,0.027339337999999998,0.00941814725,0.0,0.0,0.0,0.0295114985,0.0428870293,0.0113706932,0.0,0.0,0.0,0.0430257409,0.056886740899999996,0.0112331153,0.0,0.0,0.0,0.060188908,0.073710252,0.00956730768,0.0,0.0,0.0,0.0872806808,0.100387634,0.00586280789,0.0,0.0,0.0,0.142963511,0.156823096,0.0,0.0,0.0,0.299762778,0.971323956,1.53429697,1.65187651,1.24510185,0.550815481,0.0,0.0,0.0,0.0294179283,0.15589814300000002,0.108521892,0.0,0.0,0.0,0.0165657418,0.065906826,0.043968087999999995,0.0,0.0,0.0,0.0104564594,0.0379237982,0.0406155773,0.030978119199999998,0.021676547799999998,0.0108836604,0.0,0.0,0.0,0.0353974031,0.064037782,0.0412144723,0.0,0.0,0.0,0.051242156799999994,0.143019334,0.0959122765,0.0,0.0,0.0,0.257437372,0.922169538,1.44046947,1.48530232,1.00941118,0.293947495,0.0,0.0,0.0,0.154357995,0.24235056600000002,0.0908838507,0.0,0.0,0.0,0.10631533300000001,0.163565202,0.0565763145,0.0,0.0,0.0,0.12797461699999998,0.253543504,0.256149374,0.17392491399999999,0.0830983501,0.0151087501,0.0,0.0,0.0,0.24633744899999999,0.774950123,1.36156325,1.69335819,1.54648744,0.9781283540000001,0.317469619,0.0,0.0,0.246966966,0.445676222,0.435793261,0.427481162,0.822878999,1.84734773,3.26257508,4.42413275,4.6842016,3.85631946,2.38496927,1.06975229,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.57656664,4.43569362,2.8149142999999994,0.0,1.23568918,1.36391191,0.0,0.0,4.59319344,7.05117704,3.7971006000000003,0.0,0.0,0.0,0.0,0.0,0.95148346,0.0,0.10812868,0.62344178,0.0,0.17101984,0.37238906,0.26421528,0.404381,0.80342109,0.26110398,0.0,1.50420181,2.93241993,2.24945511,0.0,0.30328921,0.0,0.66251766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.62602767,0.27896905,0.0,1.63287498,1.01359317,0.0,0.46654377,0.38148118,0.57049121,0.0,0.52892195,0.0,0.0,0.0,0.99935078,0.51073955,0.0,1.75931262,7.45932942,11.87110469,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.368611105,0.0,0.0760770237,0.0238899337,0.163673656,0.6008342729999999,0.0,0.0,0.7769599779999999,0.570138413,0.0,0.0186767231,0.0,0.05082573519999999,0.0250022194,0.0,0.115685571,0.0,0.0,0.15217164800000002,0.0,0.011290633100000001,0.14764497699999998,0.0,0.170250562,0.07724508320000001,0.0,1.02711403,1.92617975,0.325065117,0.0,0.17783591699999998,0.0,0.0,0.0869036105,0.0,0.0,0.0373761774,0.0,0.0112258313,0.0107826929,0.0,0.0158091452,0.0,0.0,0.021189154900000003,0.0,0.0,0.036238505899999995,0.0,0.0347053775,0.050770314000000004,0.0,0.561015511,1.02663029,0.197657365,1.4565063999999999,3.25790311,0.884409908,0.0,1.47817105,1.91635947,0.587667806,0.240433427,0.0,0.055827224,0.22690088600000002,0.0,0.364473451,0.0581848262,0.0,4.24114962,5.99124333,1.5421334999999998,0.26084223300000003,1.29556196,0.0,0.0,0.38282526899999997,0.0,0.0,0.17184275,0.0,0.07494701200000001,0.0402927765,0.0,0.05528348190000001,0.0,0.0115948344,0.0,0.872285627,2.67641442,2.97150268,2.78249388,2.82747372,1.29716196,0.274965373,0.67449792,0.272340597,0.188885565,0.7967050590000001,0.7466973809999999,0.7026532240000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
29.29663204,8.70115528,4.91709301,6.77372462,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16914487,1.57945473,1.96290648,2.62528912,3.02830816,3.88972745,4.66408716,4.75073108,4.95214684,5.87704711,6.05117986,6.02336107,5.80532005,5.33759795,5.24702504,4.812751400000001,3.48026824,2.8682887000000004,2.40563014,2.23993626,1.1195563,0.2159996,0.45791457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.25554343,0.36238408,0.6759808,0.73222297,0.96455672,0.5638632,1.23876548,0.41741199,0.90264244,0.55896645,0.41157169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04153753,0.0,0.12460908,0.20487908,0.69054917,0.68110851,0.32192088,0.88852266,0.95345787,0.43944251,0.32004707,0.25735305,0.0,0.4473545,0.08421653,0.01001661,0.0,0.0,0.0,0.0,0.0,0.0,0.20579539999999996,0.09366671,0.0,0.25093196,0.52315221,0.84180489,0.82172096,1.09476438,0.3294917,0.61983601,0.90812946,0.23676674,0.42300988,0.04723823,0.2272834,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0331045392,0.0901817499,0.227922278,0.48801789,0.23545462,0.0306661579,0.330429104,0.0,0.308371899,0.0,0.0,0.400465023,0.0,0.0,0.380284874,0.0,0.392387586,0.0286895065,0.0331203453,0.375973836,0.0,0.0,0.134598518,0.0,0.332815286,0.0,0.0,0.062194738,0.00182244217,0.0,0.0446680496,0.0,0.247940865,0.0,0.0,0.0,0.333502837,0.247168152,0.0413727593,0.0,0.5620940289999999,0.863182905,1.23615942,2.33798055,2.78252703,2.748334,1.34322158,0.412933451,0.183303519,0.0,0.0,0.45268708,0.307435532,0.632679057,0.0337747682,0.0,0.0,0.0,0.0,1.435977,2.49391743,4.02823737,4.27402259,4.27693438,2.9264989,1.32796468,0.0,0.0,0.0,0.0,0.0,0.68000714,0.231056681,0.0,0.0,0.0,0.017385023200000002,0.0,0.0820706828,0.14964361,0.0,0.0,0.0,0.134311452,0.0,0.0,0.214917053,0.23811629899999998,0.0,0.0,0.12418963699999999,0.341135354,0.4878698,0.05216356269999999,0.0,0.232733511,0.0290955367,0.0,0.0,0.57072989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.143478661,0.594049685,0.865033497,0.882777431,0.745656503,0.657193041,0.798827968,1.21367475,1.76808216,2.21596551,2.3338291,2.05340331,1.51701822,1.02034306,0.867375135,1.21118043,1.96419941,2.82761781,3.42806333,3.49405111,2.98374437,2.10066225,1.19149237,0.579699808,0.41918166100000004,0.638744629,0.999153134,1.22672128,1.15122472,0.7789190509999999,0.269819984,0.0,0.0,0.0,0.0,0.157286106,0.249889959,0.18104080600000003,0.015356671200000001,0.0,0.0,0.0,0.011732578300000001,0.12057830300000001,0.144617734,0.07874583660000001,0.0,0.0,0.0,0.0,0.0368196742,0.0922040517,0.08589965880000001,0.028171631699999998,0.0,0.0,0.0,0.0,0.0380205624,0.0576480842,0.0394945845,0.00164876475,0.0,0.0,0.0,0.0017196354199999998,0.00497281715,0.0,0.0,0.008455084040000001,0.046772451500000006,0.0729876489,0.0444058118,0.0,0.0,0.0,0.0,0.296867977,0.940023961,1.65857354,2.21250472,2.38263537,2.07628624,1.38410052,0.553231669,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.160604892,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.536763291,0.351667988,0.435162042,0.7380445640000001,0.9324814370000001,0.735172904,0.470164669,0.991069531,0.423349575,0.859065572,0.9393512490000001,0.684923298,1.01471227,0.55321518,0.437129205,0.579779754,0.7352678859999999,0.32126130399999997,0.0,0.11125607800000001,0.332778191,0.315453845,0.134814709,0.00600013399,0.0,0.0,0.0,0.0,0.0772450568,0.253442262,0.285918196,0.0,0.0,0.418697466,0.419244238,0.31394364199999997,0.41744848799999995,0.448434305,0.37545509899999996,0.0,0.520374169,0.182972968,0.5690192820000001,0.60979496,0.679721295,0.158610765,0.0410940785,0.0,0.574642765,0.494306368,0.0,0.320983685,0.257116014,0.0,0.31671294,0.154973859,0.0,0.0,0.0529369165,0.0,0.176907108,0.0,0.0,0.0,0.25849579,0.0,0.0,0.0,0.0,0.0,0.37366685299999997,0.140173825,0.055859513799999996,0.318404422,0.149208266,0.047581204,0.418829795,0.282702081,0.05600217019999999,0.632499402,0.0,0.135284566,0.0595635125,0.0,0.281955373,0.193273547,0.0,0.0,0.156952661,0.0,0.011072195,0.0,0.0,0.0,0.0149220668,0.0,0.0,0.0,0.022792325699999998,0.0,0.10890979699999999,0.0,0.0,0.39129286,0.388379784,0.0252973687,0.16355688300000001,0.0247589525,0.670476733,0.48152731200000004,0.62892945,0.046624339400000006,0.192261923,0.188690805,0.312331987,0.0834962875,0.0,0.318696574,0.21092949,0.0,0.06116473309999999,0.09889639509999999,0.0,0.0,0.0195166347,0.0,0.0,0.0,0.0,0.0,0.0768309631,0.0,0.312293305,0.303345869,0.480135398,0.291159758,0.654536305,1.05622662,1.14765783,1.59535043,1.71823774,2.26679607,2.34091607,2.81903673,2.99854337,2.87945147,2.9436584999999997,3.59740136,3.28317076,3.78826639,3.94292342,3.68727658,3.9046089,3.79641089,3.42615878,3.7998661,3.15163914,3.44333439,2.9065012,2.87383279,2.25032025,2.26006259,1.90322954,1.85071377,1.02773961,0.743354871,0.758629239,0.7260909520000001,0.552627489,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.64116675,1.96960374,3.20805456,3.2764311,2.93623417,3.09236927,2.75356706,4.31172607,3.62549666,2.95320526,1.65308407,1.54765545,1.50018447,0.0,0.0,0.29200427,0.0,0.0,0.0,0.15061085,0.0,0.0,0.67433907,0.93491727,0.0,0.0,0.0,0.84704501,0.31201302,1.23683233,0.21051139,0.0,0.0,0.61329282,1.27159484,0.0,1.17849903,1.36938978,0.0,0.90167577,0.18930625,0.1192752,0.10727527,0.76740542,0.0,2.87837628,0.88780683,0.42344512,0.07308669999999999,0.68928985,0.60667896,0.82937222,0.0,1.35997484,0.42561486,0.76058706,1.18355075,0.0,0.72242383,0.68740346,1.54425466,0.8493833000000001,0.592145,0.57822305,0.05243682,0.0,0.65365041,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.910133042,0.0,0.164578726,0.742881687,0.08794877279999999,0.426852991,0.0,0.342551135,0.0,0.46517137799999997,0.0,0.0,0.0,0.642835744,0.33329594,0.0,0.590011695,0.653685573,0.0,0.0,0.382333616,0.67991261,1.14576746,0.0,0.19938551300000001,0.0,0.28768428,0.0,0.0,0.0,0.53820809,0.0,0.0,0.227660878,0.605349205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.576082682,0.31728864100000004,0.0,0.542221055,0.69820948,0.0,0.948791088,0.0,0.063860875,0.8997762509999999,0.770697464,0.26299129,0.0,0.438173353,0.0,0.6409270779999999,0.0,1.01246007,0.0,0.0,0.0,0.06507037019999999,0.349510165,0.0,0.0,1.04057178,0.0,0.130660936,0.05654471,0.780798249,0.950276844,0.0864860636,1.84325059,0.725734997,0.538587359,1.16625528,0.43654941799999997,1.25204974,0.0505435866,0.379180881,0.432264747,0.0779061022,0.44420160799999997,0.0,0.0,0.171225325,0.0,0.0,0.595662809,0.0,0.510332707,0.643655906,0.0192009383,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.837056826,0.0,0.0,0.895257265,0.959518517,1.19524524,0.573470435,1.64917232,0.0,0.0,0.0,0.674946444,0.0,0.051035701399999994,0.0,0.921271451,1.35463696,1.28163793,2.41630399,2.54533269,3.4341729,3.41250512,2.74249929,3.16700708,3.46629362,2.19937933,2.74154789,2.59969783,0.878893817,0.7630368340000001,0.0,0.7076444959999999,0.515145625,0.61715383,0.0,0.234277058,0.0,0.16444149,0.577414326,0.897575473,1.81763012,0.0694256789,0.721356412,0.621764601,1.49138259,0.8037460270000001,0.48570789200000003,0.41920784,1.27293414,0.0,0.0,0.33980590200000005,0.0,0.202299655,0.225818863,0.9532995809999999,0.230429188,0.0,1.00747946,0.5184608239999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0360534734,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.180443894,0.127092108,0.137000335,0.200558803,0.0,0.0,0.0986846967,0.236336417,0.0,0.0,0.10973623099999999,0.140576347,0.102008911,0.463469614,0.08604654029999999,0.0,0.179751881,0.29819771899999997,0.54439406,0.18764006,0.49087890000000006,0.794932455,0.8383550909999999,0.7599165659999999,0.7386634809999999,0.7464806540000001,1.3435716999999998,1.3446361999999998,0.595662578,0.331997605,0.163887551,0.677681029,0.0,0.0626518525,0.0472311091,0.251779603,0.229272301,0.0,0.0,0.287626505,0.0755308533,0.0,0.569463159,0.0,0.0,0.0,0.0,0.0751537626,0.0,0.212585971,0.0,0.44891071200000005,1.18207038,1.77352779,2.0863723999999997,2.5087311000000003,3.1875632,3.32997029,4.12577551,4.33644402,4.28844894,4.13232046,4.0783316,3.81761815,3.03066697,2.47549488,1.86972687,2.15752953,1.87334849,1.34127348,1.31418055,1.10571065,0.735065906,0.869122396,0.549249995,0.33727038600000003,0.248148945,0.7181134379999999,0.551950215,0.297105901,0.026338172599999998,0.0,0.0,0.0,0.0,0.171818157,0.0,0.265815746,0.233424637,0.0,0.158312091,0.0,0.0,0.33005412300000003,0.0,0.0,0.0,0.0,0.0,0.29882438,0.0,0.28496947,0.185929232,0.0,0.38285350700000004,0.322245389,0.0,0.0,0.348393199,0.0,0.0,0.228400926,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.406611726,0.13653870099999998,0.0008559706359999999,0.41597029,0.29345795399999997,0.031516642000000004,0.0,0.0,0.134163796,0.0,0.298187802,0.120106575,0.0,0.0,0.363676359,0.0689329742,0.11508290199999999,0.0,0.303143196,0.0,0.0,0.0418670252,0.09823126609999999,0.117464384,0.0758873697,0.0,0.06777688429999999,0.306289403,0.39507379200000003,0.0,0.065661737,0.0056387226,0.445202645,0.34067649899999997,0.152076131,0.185105955,0.0,0.593327366,0.0486102721,0.0,0.0,0.392024545,0.0,0.0,0.0,0.264177343,0.142008615,0.0,0.0,0.0,0.0,0.0,0.215719365,0.0,0.332044409,0.32013633399999997,0.0,0.108330375,0.0,0.0838747375,0.200100324,0.180669761,0.0,0.207589923,0.232853492,0.14543767400000002,0.24380593399999997,0.0,0.0346819014,0.16671950300000002,0.214228106,0.23838435300000002,0.0,0.0,0.229493416,0.0,0.0,0.0308232506,0.0663068074,0.0456011162,0.0997092527,0.0,0.326566528,0.0,0.052560845599999996,0.38744244299999997,0.0031836189899999996,0.0,0.0,0.17314929699999998,0.0,0.0,0.0,0.0,0.31913619,0.0,0.27059922399999997,0.39606148700000005,0.0,0.23611992199999998,0.38026743,0.0,0.0442016497,0.023509175299999997,0.35785772200000004,0.282046475,0.0,0.23244148399999998,0.422078313,0.0,0.593128656,0.0,0.0,0.30308397800000003,0.21836000600000002,0.0,0.45773500799999994,0.242576997,0.0,0.35967923700000004,0.0695984964,0.0,0.0,0.0,0.25091262,0.0,0.0650939668,0.0,0.33288967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0804616842,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07089024349999999,0.294161767,0.503176429,0.67593635,0.796938015,0.8592381590000001,0.8652476809999999,0.826117271,0.759784905,0.68795696,0.632461442,0.61151804,0.636497926,0.7096901659999999,0.823456875,0.960963673,1.09844227,1.20871109,1.2654811000000001,1.24783818,1.14424064,0.955413043,0.695649772,0.392249202,0.0830533471,0.0,0.0,0.0,0.0,0.0,0.353821083,0.936026934,1.62970699,2.38391407,3.13944304,3.83521063,4.41495487,4.83342402,5.06128602,5.08815233,4.92335269,4.5943865,4.14327442,3.62129893,3.08282112,2.57896599,2.15196741,1.83085897,1.62900297,1.54369581,1.55780907,1.6431595,1.76508515,1.88756548,1.97817855,2.01224118,1.97561818,1.86589212,1.69182496,1.47128293,1.22800202,0.987716391,0.774236978,0.606046375,0.493875403,0.439563145,0.43630216200000005,0.470164026,0.522617447,0.5736178710000001,0.60478115,0.6021619570000001,0.55823623,0.472821826,0.35284097200000003,0.211005466,0.0636644323,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0794503195,0.15308596900000002,0.19804792,0.20886284100000002,0.185628488,0.133738936,0.06281191400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0339670739,0.09262655970000001,0.134347308,0.15294222300000002,0.146130125,0.11578105,0.06749406179999999,0.00959333651,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.008689085309999999,0.0596309758,0.09977293039999999,0.122812865,0.125346786,0.10735985699999999,0.07216281179999999,0.025794720099999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0374824603,0.0775645588,0.10458284699999999,0.11424983400000001,0.105119918,0.07879181769999999,0.0396228716,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.022394593900000002,0.0702754897,0.110404418,0.13743604,0.148165524,0.141955898,0.12074756699999999,0.08865908689999999,0.0512538626,0.0145995965,0.0,0.0,0.0,0.0,0.0,0.0023694454500000003,0.0269486344,0.048247743899999994,0.0620330593,0.0655438535,0.057935239900000005,0.0403828703,0.0158385725,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0194287446,0.042050318499999996,0.0572365975,0.0626129064,0.057531703,0.0431524457,0.022202729100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00639590494,0.0198488546,0.0271477973,0.0274665817,0.0217487373,0.0125981054,0.0038269036600000004,0.0,0.004212839810000001,0.0199212839,0.0475576575,0.0855105442,0.12990495900000001,0.175096292,0.214556976,0.24202965899999998,0.25276295,0.244615893,0.21882211399999998,0.18024537899999998,0.137030598,0.0996480525,0.0794296609,0.0867883317,0.129379262,0.210492916,0.327956068,0.473759145,0.634531606,0.792865156,0.929354844,1.02511011,1.06440068,1.0370606,0.94028708,0.77953839,0.568351705,0.327049303,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.91910071e-15,0.0,3.5029208500000004e-15,0.0,0.0,0.0,1.7514604300000002e-15,0.0,1.16764028e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,8.75730213e-16,0.0,0.0,0.0,0.0,0.0,3.5029208500000004e-15,0.0,8.75730213e-16,0.0,8.75730213e-16,0.0,2.4812356e-15,0.0,0.0,0.0,0.0,0.0,6.567976600000001e-16,0.0,8.027526950000001e-16,0.0,2.55421312e-16,0.0,2.55421312e-16,0.0,8.027526950000001e-16,0.0,6.567976600000001e-16,0.0,0.0,0.0,0.0,0.0,2.4812356e-15,0.0,8.75730213e-16,0.0,8.75730213e-16,0.0,3.5029208500000004e-15,0.0,0.0,0.0,0.0,0.0,8.75730213e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.16764028e-15,0.0,1.7514604300000002e-15,0.0,0.0,0.0,3.5029208500000004e-15,0.0,2.91910071e-15,0.0,0.0,0.0,69.81428050000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.324
0.09276244789999999,0.106042391,0.115993606,0.121533534,0.121845171,0.116453649,0.105279921,0.08866697539999999,0.0673758363,0.0425506712,0.0156544513,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0273781466,0.0590805358,0.0880018927,0.11148895800000001,0.127068693,0.13264141599999998,0.12666717800000002,0.108333772,0.07769517940000001,0.0357702042,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.117353779,0.317517447,0.558287828,0.836592233,1.14753232,1.484477,1.83924392,2.20236482,2.56342526,2.91146489,3.23542072,3.52459288,3.76911035,3.96037334,4.09144968,4.15740396,4.15554165,4.08555389,3.94955412,3.75200304,3.49952419,3.20061858,2.8652919999999997,2.50461368,2.13022856,1.75384829,1.38674694,1.03928727,0.7205017090000001,0.43774881600000004,0.196461749,4.70797739e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0264090994,0.0801322937,0.12061345,0.14627628199999998,0.156813806,0.15307488800000002,0.136886846,0.11082944300000001,0.0779779472,0.041634066000000004,0.00506339296,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00663351755,0.028250098300000002,0.0461462382,0.0590526018,0.0661833378,0.0672716815,0.0625626108,0.0527653083,0.0389711416,0.022545272400000003,0.00500169039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0019944213199999997,0.0154344627,0.027229145,0.036520020099999995,0.0427188058,0.045552471799999994,0.045080444299999994,0.0416830065,0.0360222925,0.0289794442,0.021573347200000002,0.0148677623,0.00987451725,0.0074606659799999996,0.00826715965,0.0126456325,0.0206184753,0.0318655583,0.045738913799999996,0.061304552000000005,0.0774085177,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.142207779,0.392209866,0.0,1.91923479,4.51725091,0.9989943490000001,0.965710112,0.0,0.106853351,0.0,0.066248572,0.0,0.034956706000000004,0.0,0.0194897324,0.0,0.0609615254,0.0,1.00702792,15.128377800000003,6.8726268,0.0,0.293945707,1.82603096,0.837781445,0.38050284799999995,0.438608754,0.0,0.175187934,0.0,0.103642571,0.0,0.061098630599999995,0.0,0.0710311998,2.4132826,0.0,1.09945271,0.0,1.66862614,1.3536791000000001,0.0,0.275901278,0.0,0.128597662,0.040444618700000004,0.21911854,0.0,0.00792623693,0.12585214,0.12934463,0.128678391,0.0,3.96749604,7.2867429999999995,0.23557675100000003,0.395759966,0.0,1.50138572,0.43678095,0.0,0.26317900899999996,1.47581383,0.0,0.0981052791,0.0,0.0453385519,0.0,0.016619585,0.0,0.0,0.023019434900000003,0.0,0.0568761738,0.0,0.10980273300000001,0.0,0.225894135,1.60939887,0.896460138,3.70112015,0.0,0.318498701,0.0,0.168957842,0.0,0.10848763300000001,0.0,0.0729959009,0.0,0.0475830743,0.0,0.026912965299999998,0.0,0.00859190917,3.79909187e-05,0.0,0.015976,0.0,0.0247938877,0.0,0.0,1.19074189,2.56418303,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.901621427,0.711834448,0.548662663,0.259039978,0.0028288196899999996,0.317150775,0.0185652426,0.20144391,0.771433723,0.884883592,0.46873228299999997,0.49028869999999997,0.12132679699999999,0.257478428,0.0,0.18786707600000002,0.0,0.0,0.0,0.0,0.0,0.603175861,0.982139212,1.07429671,2.43289195,1.90474667,2.29527762,2.72194121,3.19819993,2.50479957,1.76732019,1.69761735,1.92712942,1.5006007,0.904234725,0.195259533,0.46382090600000003,0.0152475589,0.558970627,0.0,0.5184448629999999,0.229183406,0.287686068,0.280813553,0.282893882,1.16232146,1.20726976,0.7661041559999999,0.734712432,0.6834624640000001,0.48712303700000004,0.0,0.299518862,0.0,0.0,0.0,0.0,0.267349232,0.0,0.23367448100000002,0.0,0.134056286,0.0,0.0758565368,0.0,0.421282328,0.0,0.451659582,0.0,0.0,0.0,0.39168852600000004,0.142641709,0.0,0.172736098,0.48047879,0.194618978,0.0,0.0,0.0,0.37895022100000003,0.012764983700000001,0.0,0.252743885,0.0,0.0,0.0,0.13649297400000002,0.0,0.0,0.562121749,0.232616693,0.35126605299999997,0.0,0.589116199,0.307598715,0.0,0.501406108,0.27849558399999996,0.0,0.209957896,0.0,0.537795538,0.479972005,0.17353355199999998,0.734597307,0.0875491157,0.0,0.6781355990000001,0.222156756,0.439802905,0.0,0.0,0.193809791,0.0,0.0,0.0,0.0,0.390462342,0.0,0.237463748,0.73823083,0.0,0.583141264,0.0,0.0,0.0,0.0,0.0,0.0,0.137105739,0.0,0.0,0.0,0.222607041,0.494933179,0.266011398,0.7379683220000001,0.0,0.148059845,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.171328433,0.795839179,0.617901936,0.999351696,0.36702696100000004,1.11191847,0.6794512420000001,0.0902067849,0.0,0.353825685,0.0,0.0,0.0,0.0,0.478143925,0.47231693799999996,0.529805721,0.571658275,0.024349866600000002,0.808714552,0.341265861,0.0,0.0,0.0,0.17382873899999998,0.0,0.0,0.0,0.0,0.0268548946,0.41866389,0.8232452259999999,0.663027283,0.831884515,0.135137287,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.08925374,1.45551176,1.90373997,3.26202744,4.55583314,4.83261408,5.43105599,5.61691024,5.52817773,5.2482052,4.02200392,3.6652237000000003,2.62613684,1.8008883999999998,0.935145573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.146415669,0.370690455,1.06408141,1.10268913,0.759367921,0.446752336,0.0,0.0,0.26500504399999997,0.0,0.0,0.0,0.242557104,0.0,0.826949497,0.73964243,1.98368092,1.67665334,2.22103046,2.21441666,1.76921309,2.11593875,1.53466871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.9097615,1.17249509,1.35025428,1.40740648,1.33368493,1.14607502,0.884106678,0.599872811,0.345383008,0.160464831,0.06420549240000001,0.0519566029,0.0984668336,0.166141922,0.21615772800000002,0.219486006,0.164988476,0.0625498508,0.0,0.0,0.0,0.0,0.0,0.227093292,0.52225004,0.829544506,1.09863877,1.28537596,1.36079998,1.31653012,1.16542813,0.937665992,0.6733838940000001,0.413854944,0.193286403,0.0330656047,0.0,0.0,0.0,0.0,0.0,0.0025271877899999996,0.012891773300000001,0.0108894372,0.00281161967,0.0,0.0,0.00290133793,0.0152276552,0.0270119292,0.0323370353,0.027298745899999997,0.0116662877,0.0,0.0,0.0,0.0,0.0,0.0,0.0195350226,0.0471446224,0.0626671321,0.0607027489,0.0408316971,0.00798196808,0.0,0.0,0.0,0.0,0.0,0.0,0.0385379057,0.069638869,0.0817176895,0.0706616598,0.038926694,0.0,0.0,0.0,0.0,0.0,0.0,0.0134766995,0.059490639500000005,0.0896359932,0.0948464623,0.0730024626,0.0297249486,0.0,0.0,0.0,0.0,0.0,0.0,0.032731337,0.0785323663,0.101339775,0.0944713123,0.0606755754,0.0120455442,0.0,0.0,0.0,0.0303991606,0.136569261,0.266109317,0.39308784700000005,0.489144797,0.530560454,0.50459006,0.413382304,0.274362647,0.116836328,0.0,0.0,0.0,0.0,0.0340943533,0.19443886800000001,0.360405828,0.496282006,0.573458296,0.576851618,0.508158911,0.385327055,0.238571845,0.104099493,0.0171616976,0.006094371899999999,0.0885646051,0.270518822,0.547510568,0.90743267,1.33337945,1.80550678,2.30129344,2.79436597,3.25278403,3.63814428,3.90686737,4.01453359,3.9232311,3.61080923,3.08000006,2.36488264,1.5323208000000001,0.676850683,0.0,0.0,0.0,0.0,0.0,0.16527307900000002,1.02331334,1.93492017,2.75995014,3.37390307,3.68977911,3.67270229,3.34429079,2.77594782,2.07265285,1.35089452,0.7156200779999999,0.241189546,0.0,0.0,0.0,0.0224782424,0.153755166,0.252277194,0.29984024800000003,0.30891444,0.31683575399999997,0.373244654,0.524276878,0.7977522420000001,1.19325875,1.67969822,2.2008984000000003,2.68781161,3.07414401,3.31141229,3.37961301,3.29085148,3.08510454,2.81930861,2.5526526,2.33188552,2.18038965,2.09374856,2.04282653,1.98341996,1.86984869,1.66885826,1.37015548,0.990802671,0.572310929,0.17117706800000002,0.0,0.0,0.0,0.0,0.0,0.0293667768,0.23114584600000002,0.37121886299999995,0.42168222200000005,0.38205615,0.27853510800000003,0.156428534,0.067770432,0.057284715199999996,0.150281112,0.34553394200000004,0.614906274,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.44190861,8.23928459,7.36137743,5.28728496,3.47004862,1.78617979,0.416766879,0.0,0.0,0.0,0.20420477199999998,0.979921996,1.25458286,0.0,0.0565894706,0.419831546,0.19567584300000002,0.0,0.24594152600000002,0.0,0.0,0.103431871,0.0,0.17421575,0.631670343,0.0015206064000000002,0.17140651399999998,0.42285197399999996,0.0,1.24000847,0.0,0.8618644609999999,0.0,0.0,0.251742758,0.0,0.0,0.25069924899999996,0.0,0.6775376590000001,0.0,0.981518215,0.0,0.0,0.0,0.522707823,0.596674088,0.0,0.870791433,0.45026629799999995,0.8361952009999999,0.737887726,0.765617798,0.0,0.0,0.41677979299999995,0.5158044079999999,0.0,0.586363694,0.0,0.285889628,0.0,0.701772877,0.39673843200000003,0.329214353,0.0,0.0,0.0,0.262906994,0.0,0.0,0.864548248,0.0,0.0,0.0,0.22416809,0.44450743299999995,0.0,0.555667267,0.24690140100000002,0.333242004,0.9193497540000001,0.498809302,0.055542278,0.794861577,0.247049975,0.0078009301,0.8645313170000001,0.139311155,0.850822016,0.0,1.20287422,1.52962971,1.5449933999999999,1.36151609,2.75059787,1.46735643,1.50522717,1.75454546,0.228206226,0.0,0.0,0.0,0.0,0.0,0.0285832907,1.34543482,1.14855299,0.275943961,0.0,0.0,0.0,0.0,0.0,0.44898016399999996,1.14342486,3.09716594,5.223018,7.99571776,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.098338955,0.200791825,0.294369024,0.370261164,0.421414636,0.443327949,0.434603123,0.397188011,0.336275403,0.259859048,0.17798181100000002,0.101743711,0.0421640706,0.009009774190000002,0.00970855999,0.0484615059,0.125652498,0.237625874,0.37686897,0.532597126,0.69169866,0.8399601740000001,0.96346214,1.05001412,1.0904904,1.07993169,1.01829603,0.91077205,0.76760603,0.60343901,0.43619611,0.28561373100000004,0.17152682600000002,0.11206458400000001,0.12191580099999999,0.210823662,0.382453251,0.633745201,0.954828019,1.32951326,1.73634621,2.1501349999999997,2.5438369,2.89064738,3.16611695,3.35011601,3.42847892,3.39418473,3.24797083,2.99832416,2.66084814,2.25705725,1.81270047,1.35575519,0.9142612040000001,0.514177026,0.177437841,0.0,0.0,0.0,0.0,0.0,0.0,0.10654594199999999,0.309592727,0.50813057,0.6821981429999999,0.815355533,0.895911797,0.91768334,0.880232342,0.788582844,0.652459645,0.485137314,0.302019769,0.119091943,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0647251628,0.130770986,0.173075493,0.189439073,0.181222758,0.15311392699999998,0.112541449,0.0688060221,0.0320189129,0.011960130900000001,0.0169735946,0.0530116218,0.122924811,0.22606780899999998,0.358259245,0.51209851,0.6776066070000001,0.8431265440000001,0.996393657,1.12567031,1.22083405,1.27431395,1.28178543,1.24255887,1.15962705,1.03937075,0.8909543740000001,0.725473556,0.5549394120000001,0.39119899,0.244895804,0.12456879900000001,0.0359728682,0.0,0.0,0.0,0.00301032103,0.0513949284,0.10639399,0.159086283,0.20148589,0.227316319,0.232583531,0.21589587600000001,0.17850554899999999,0.124074887,0.0581986258,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0421813295,0.10175406199999999,0.149640283,0.180860713,0.192277785,0.18291395,0.154038271,0.109013968,0.0529246851,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.005379424549999999,0.0681851437,0.125715945,0.171761595,0.201300405,0.21103629100000001,0.19975454899999998,0.168458551,0.12027254300000001,0.0601202024,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0374479478,0.100006795,0.152149488,0.188220972,0.20423904899999998,0.198329156,0.17094025699999998,0.12481731800000001,0.0647311262,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.038842185099999996,0.11032398,0.171507816,0.21570731899999998,0.23794110100000002,0.23549470399999997,0.208253988,0.158771086,0.0920513476,0.015078506100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.13744695699999998,3.47174482,1.98223663,3.86018704,0.0,0.111815985,0.11144820400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.85208864,0.0,0.0,0.0,0.0,0.39681055299999995,0.0,0.89281923,0.0,0.0,0.0,1.67270842,1.25855867,0.889921719,1.78496105,0.047832805199999995,0.0260040237,0.0,0.0,0.8036621620000001,0.0,1.20995993,0.0,1.53355765,3.49337301,0.0,0.0,0.0,0.0,0.2909449,0.41130959100000003,2.31115517,1.56106753,0.0,0.0,0.0,2.66486363,0.803947741,0.23773760000000002,0.0,0.0,2.47464466,0.0,2.69669487,0.0,0.0,0.0048001034,0.0,1.03536241,0.43422699,0.324333577,0.43535813,1.58498699,1.1420893,3.12066199,0.876759855,1.72257412,1.36460406,2.17828953,1.71741475,1.77621897,0.0,0.0,0.0,0.9142754340000001,0.0,2.49218486,0.0,0.0,0.0,2.9118246,3.08879921,0.868989311,1.14084275,0.0,0.0,1.36387007,0.49209611600000003,0.0,0.0,1.80935615,0.687897935,0.0,0.0,2.17016021,0.0,1.33533046,2.43002278,0.0,0.0,1.08442405,4.82672327,0.99431201,0.761377222,1.49595982,0.0,0.0,0.0,1.17063546,0.0,1.31005746,0.0,0.0,0.44402068200000006,1.7094869,0.0,0.0,7.12897883,2.18010484,0.0,0.0,0.0,2.77434079,0.261105459,1.29991742,0.316209146,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.79896776,0.7193812340000001,0.0,0.0,0.0,0.23900170199999998,0.108019626,0.872078858,0.277922845,0.0077367932,0.0,0.172520416,0.0028222529600000004,0.0,0.0,0.0,0.0,1.0771551000000001,0.0,1.10137413,0.650327004,0.33394738,0.0,0.0,0.737686161,0.578609181,0.32145103,0.470084269,0.0,0.514892035,0.0,1.05561085,0.5761385760000001,0.0,0.0,1.12115412,0.44705844100000003,0.819399795,0.0,0.6596394520000001,0.0,1.21312808,1.33914098,1.40069763,0.0,1.07117537,0.0844096899,0.6845930729999999,0.533149238,0.0,0.472103676,0.673916562,0.0195230951,0.0,0.0,0.0,0.0,0.153013836,0.0166446539,0.0,0.8803506409999999,0.353401686,0.0,0.0,0.0,1.56255529,0.303052862,0.7850065390000001,0.0,0.23040190600000002,1.94215515,0.0,0.0,0.60392803,0.0,0.0,0.0,0.025397160699999997,0.0,0.117421941,0.8651511009999999,0.0423077484,0.0,0.60611315,0.9843377040000001,0.0,0.0506066483,0.0,0.0,0.7861120070000001,0.34838147,0.374009958,1.14879611,0.0,0.0,0.720751825,0.649932605,0.32350075,0.0,0.0953742373,0.9548320290000001,1.61299039,1.52295276,0.0,0.0,0.0,0.0,0.0,0.47270466200000005,1.48990289,0.0,0.0,0.0,0.0,1.82092479,0.0,0.805658276,0.6919130259999999,1.35843398,3.16264452,3.40925537,3.66337882,3.66908265,2.66034891,2.4623717999999997,2.58535725,0.0,0.8376747590000001,0.223965821,1.91375132,1.28838582,0.0,0.0,0.855666148,0.24180760899999998,0.0,0.47150576200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
13.640059299999999,10.550858999999999,6.45738763,2.42170012,0.0,0.0,0.0,0.0,0.8895024090000001,2.16758385,2.6218996,2.16059851,1.06011651,0.0,0.0,0.0,0.0,0.0,0.706253507,1.19107729,1.15479872,0.652119378,0.0,0.0,0.0,0.0,0.0,0.30081253399999996,0.723687745,0.803320417,0.526179341,0.0339137109,0.0,0.0,0.0,0.0,0.16318622900000002,0.5309865460000001,0.648659716,0.47439080200000006,0.0963806215,0.0,0.0,0.0,0.0,0.0762159127,0.41458820700000004,0.558996243,0.450360799,0.143390289,0.0,0.0,0.0,0.0,0.0114872643,0.33482905399999996,0.5028627210000001,0.44285844399999996,0.184999002,0.0,0.0,0.0,0.0,0.0,0.274994097,0.46736110700000005,0.448050502,0.22686972600000002,0.0,0.0,0.0,0.0,0.0,0.226290775,0.446524541,0.465368766,0.273584893,0.0,0.0,0.0,0.0,0.0,0.18306635100000002,0.437822879,0.49667327899999997,0.330388629,0.0113237746,0.0,0.0,0.0,0.0,0.1406076,0.441119077,0.546884198,0.40511494,0.0743813112,0.0,0.0,0.0,0.0,0.0934013677,0.458990072,0.626543576,0.511970163,0.15704561,0.0,0.0,0.0,0.0,0.0322612429,0.499075736,0.759485759,0.6817475390000001,0.282237935,0.0,0.0,0.0,0.0,0.0,0.582990804,1.01006013,0.998480855,0.513328605,0.0,0.0,0.0,0.0,0.0,0.790650368,1.62485211,1.80183552,1.12217415,0.0,0.0,0.0,0.0,0.0,2.72022113,6.93586691,11.0185294,13.924691099999999,14.8822375,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.257
0.40994976200000005,0.0,0.0,0.0,0.0,0.11947937,0.20962820100000001,0.0,0.34951772,0.0,0.0,0.0,0.103930244,0.0,0.27090764100000003,0.22574752399999998,0.0,0.358566034,0.0,0.0,0.302942404,0.0948658091,0.0,0.0522240966,0.0,0.0,0.177419153,0.0,0.0509179446,0.273753339,0.216198489,0.0,0.0,0.0,0.0507345415,0.0892697975,0.0,0.11644855400000001,0.049380342,0.0,0.0,0.419967862,0.688053316,0.461943858,0.35559570100000004,0.0,0.027574696800000003,0.0,0.0,0.0,0.0,0.43245399799999995,0.329113357,0.0,0.0,0.733958468,0.679332959,0.427849111,0.19216053100000002,0.427401116,0.587366614,0.017879035300000002,0.0,0.89107092,2.27100757,2.96921717,1.87874996,0.893751923,1.05195091,1.43654921,0.7836283159999999,0.45579834700000005,0.565474872,1.59780754,2.08487243,1.46816933,1.01540974,1.16274131,2.24750884,2.19146986,0.967680935,0.6845897940000001,0.130189376,0.254428759,0.509310849,0.189176373,0.65873155,0.091357268,0.0,0.117226314,0.0,0.0,0.0,0.0418326693,0.306227911,0.36449912799999995,0.356235444,0.0,1.13642318,2.18217096,2.36561758,1.27127502,1.16954656,0.9582972409999999,1.039932,0.41018443,0.12146242900000001,1.48438022,2.54793035,2.9396117999999998,2.17695314,2.39205139,2.50591362,2.71323902,3.15278731,3.33189846,3.52167138,2.61487993,1.30322211,0.0,0.29658465300000003,0.980988737,1.8649958999999998,2.05071591,2.10627016,1.44632145,1.12461505,0.5522155129999999,0.329635096,0.040865381400000005,0.430965,0.14989133300000002,1.04421704,1.19066491,1.35770446,0.89732598,0.0877662601,0.0,0.0,0.141826375,0.0,0.0,0.11771095300000001,0.0,0.0,0.0,0.0,0.0963561645,0.141377208,0.180236118,0.387475091,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.25665376,0.0,0.0,0.445202276,0.394119622,0.032136032200000005,0.8621189640000001,0.364309999,0.800704692,0.0,0.007059798000000001,0.0,0.0,0.0,0.317729559,0.540347293,0.345773592,0.0,0.532449712,0.0,0.0,0.25092129,0.0232077676,0.0,0.376884961,0.0,0.0113189923,0.0,0.23871335100000002,0.0,0.421812814,0.119209535,0.294558185,0.420059715,0.35674211200000006,0.16552170900000002,0.0,0.5105431779999999,0.441810731,0.0,0.0,0.0,0.0,0.0,0.0,0.455507104,0.0,0.542928661,0.249450065,0.268302174,0.22145998600000003,0.0,0.0,0.0,0.0,0.0213980275,0.34225050100000004,0.235386015,0.0,0.0,0.021615322000000003,0.228605277,0.0,0.374293066,0.0,0.0,0.0,0.01330621,0.0,0.0,0.0,0.0,0.308227615,0.0,0.494664812,0.0,0.399426953,0.00389896979,0.0,0.0,0.35783957200000005,0.257741157,0.059415274000000004,0.7030748520000001,0.73446082,1.41543976,1.41764665,1.4144385,1.5308524,1.62884813,0.7796489440000001,0.561375294,0.409920204,0.9416149090000001,0.6398188779999999,1.17460561,0.9757625109999999,1.89547968,1.98059021,1.67746327,0.858980559,0.815238459,0.0,0.0357895286,0.0287112754,0.0626514388,0.664066731,0.150370115,0.332822188,0.44414818799999994,0.0,0.0,0.0,0.0,0.0,0.649125184,2.91780768,3.91065873,4.47506476,5.10844432,4.6737004,3.68245644,3.22202574,0.9691077020000001,0.44813712299999997,0.0,0.0,0.0,0.0,0.25035736,0.724475396,1.55466951,1.53531996,1.43223543,1.14661312,0.27771654100000004,0.542264205,0.333147678,0.0,0.0383786503,0.029847984700000003,0.403884433,0.679240379,0.0,0.0,0.0,0.0,0.110129706,0.0,0.372774476,0.0,0.45798145700000004,0.352676025,0.0,0.0794788149,0.25170724,0.0,0.0,0.0,0.0,0.0,0.544177962,0.515712069,0.417950073,0.592456713,0.285027613,0.40870258200000004,0.55743397,0.341971861,0.723568269,0.8791200640000001,0.353088123,0.0,0.631382349,0.33943740299999997,0.00966306531,0.0,0.0,0.334782878,0.0,0.308213499,0.435158609,0.196934843,0.152927704,0.157307741,0.237810178,0.114242903,0.0,0.0,0.139930941,0.18297693899999998,0.266660446,0.605005417,0.0459299491,0.0,0.17990853899999998,0.25533398399999996,0.0,0.0,0.0,0.0,0.343375339,0.303850257,0.15152537800000002,0.0,0.430098666,0.0,0.0698510671,0.0,0.0,0.0116794898,0.286814575,0.499068735,0.40127419200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.39166776600000003,0.0,1.40588224,2.19872671,0.108545899,1.34291886,2.06477849,1.10128504,0.0,0.0,0.0,0.0752059679,0.0,0.674962101,0.0,0.0,0.0,0.0,0.576041616,0.0,0.128650113,0.0,0.0,0.42499994799999996,0.0,0.0,0.0,0.47151148600000004,0.0,0.849151076,1.43657695,0.0393953894,0.0,1.71085817,0.20034275899999998,0.0,0.723418942,0.0,0.275162862,1.72364466,0.234782087,0.93812945,0.0,1.16583813,0.0,1.08860251,0.0,1.13979177,0.0,0.273646308,0.0,0.0,0.632977494,0.4908143,0.22372451899999998,0.0,0.0,0.505372415,0.0,0.048984340300000005,0.0817632637,0.0,0.0,0.0,0.0,0.350575397,0.0,0.0,0.0,0.0,0.0,0.0,0.32740333,0.82755178,0.0,0.669409316,0.0,0.41945099799999996,0.273270453,0.0,0.0,0.9017456540000001,0.267891962,0.19999776600000002,0.488310996,0.0,0.354608629,0.235350123,0.0,0.0,0.27064594,0.7885329940000001,0.524397543,0.538520095,0.0878349489,0.8380770740000001,1.61860796,0.024756435,0.0,0.561356132,0.154755143,0.0,0.297996215,0.0,0.0,0.0,0.297589851,0.0,0.918444857,0.0,0.0,0.0,0.44269393799999995,0.0,0.8598151740000001,0.101867395,0.9269270390000001,1.64346544,0.0,0.0,0.02089964,0.0,0.491542374,0.9919832590000001,0.0,0.244003327,0.0,0.0,0.6897520629999999,0.443487201,0.48137861200000004,0.0,0.0,0.0,0.494376518,0.0,0.0,2.01105628,0.593483212,0.212969623,0.0,0.5221077479999999,0.479953452,0.0,0.0,0.47504744299999996,0.34462632200000004,0.08623172650000001,0.670656414,1.09260734,0.0,0.0,0.769631669,0.0,0.0,0.0,0.983025672,2.36762694,0.816098456,1.73591556,0.29930062,0.099073618,1.59591767,0.8845512329999999,1.5375536,1.5787143999999997,3.12325922,4.6060233,2.80025891,5.65588497,2.9721646,1.46992412,1.33546393,2.55403112,1.2389301000000001,1.92217182,1.20525672,1.11529861,0.0,0.245982385,0.0,0.0,0.510242519,0.377199467,0.599389207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.64250738,4.98898164,1.54907899,3.60548157,7.95979832,4.4132411,0.13337951,2.0761135,3.02779714,2.22874353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.61070763,28.67425011,16.03779097,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.257
0.17514944699999999,0.577621995,0.306558361,0.177254943,0.0,0.120243554,0.369348219,0.563338906,1.35543034,1.18759214,1.65590769,2.46062944,3.3899951,2.51537717,2.11092971,3.59244677,3.51507994,1.6663807000000002,2.29458525,1.8195284,0.585770005,0.0,0.39714124,0.0,1.13155021,1.21318205,0.0,0.0,1.1184804,1.08730143,0.696494747,0.9896588759999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.00841974,0.0,0.0614518663,0.018732204,0.0,0.0,0.0,0.164583061,1.73901092,0.359291984,0.0,0.0,0.764707685,0.016009761799999998,0.058035112400000005,0.0,0.324370736,0.275710295,0.0,0.7500210079999999,0.0,0.103894805,0.0776538586,0.6737482,0.058071019800000005,0.0862231771,0.0,0.570198934,0.118674285,0.0,0.0,0.0120571339,0.0,0.0,0.229574122,0.0,0.0,1.21439616,0.907482789,0.0,0.0,0.772619308,0.0,0.265218319,0.0273701468,0.47688583,0.148112728,0.8409755170000001,0.0,0.07636769040000001,0.0,1.34415339,0.834372608,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.6590884889999999,0.0,1.07931273,2.34156398,0.771927528,0.250486895,0.144307572,0.0041702283,0.022080648900000003,0.0,0.0758461855,0.0,0.0861895286,0.0,0.046457852699999996,0.0,0.0,0.0380319017,0.036691476699999996,0.20031928100000002,0.0,0.40560541899999997,1.11490875,1.43766165,0.198900343,0.0,0.729667927,0.0611634791,0.121807866,0.0,0.143746054,0.0,0.0,0.15393427099999998,0.0,0.918057914,0.296099447,2.17682271,2.09036722,2.4948332000000004,6.68641946,1.44124706,0.0,0.755030917,0.0,0.697002033,0.0,1.50056662,5.63509996,3.3558812000000007,0.452415082,0.0,0.0411330305,0.0,0.0203508825,0.0,0.0818086645,0.006522900010000001,0.000781301375,0.0,0.572535161,1.44084919,0.56181254,0.0,0.0,0.0,0.0101780395,0.0,0.0112368311,0.024657362599999996,0.142402096,0.10419972400000001,0.0,0.230513312,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.61005347,0.76152754,1.12118052,1.49605099,1.63078971,2.37447987,2.3479794999999997,2.2199965,2.51103015,3.62295184,3.87432474,3.38924957,4.33999491,3.96631367,4.55685908,4.4905739,4.51035561,4.18878935,4.33941816,4.5143364,3.94160041,3.8477751000000002,4.22391919,3.81403388,3.65157965,3.27831742,3.46253548,2.9641474,3.03257576,1.94169359,2.17403832,1.84306434,0.96109088,0.88676781,0.67697537,0.34209335,0.65334793,0.0,0.06361468,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10760036,0.40924287,0.0,0.42954013,0.44754014,0.66000584,0.50008672,0.60983144,0.63252541,0.83931723,0.13471967,0.76570505,0.18060199,0.62144023,0.08266478,0.47483859,0.31881769,0.56171254,0.08046702,0.08105172,0.08490393,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01034609,0.0,0.0,0.06384382,0.0,0.22172317,0.0,0.36486709,0.0,0.16728056,0.0,0.13607784,0.36503697,0.43717984,0.54067609,0.72120631,0.73970616,0.10141119999999999,0.36210183,0.82955364,0.52569106,0.4330568,0.09278523,0.11021007,0.50704716,0.21442099,0.01058299,0.0,0.0,0.01379043,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06781083,0.0,0.0,0.25027978,0.0,0.0,0.0,0.29062658,0.0,0.56335893,0.84686546,0.31073152,0.28642665,0.54589023,0.64484392,0.79869054,0.21604675,0.63183798,0.11740108,0.09347059,0.347351,0.78553193,0.06903646,0.0,0.04725589,0.19851056,0.0,0.06121189,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14198671,0.0,0.0,0.30357061,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.128035753,0.145018272,0.1597519,0.171050315,0.17780544899999998,0.179071092,0.174142221,0.16262416300000002,0.14448609699999998,0.12009411699999999,0.0902202307,0.0560250712,0.0190137916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0455837783,0.090170813,0.130903934,0.165034771,0.19009985100000001,0.204087806,0.205586823,0.19390217699999998,0.169135058,0.132215939,0.0848881558,0.0296403259,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.09873036e-16,0.08810716869999999,0.176487781,0.259525367,0.331548498,0.3871671,0.421612705,0.431063721,0.412936817,0.366126665,0.291178399,0.190380258,0.0677677143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027833859300000003,0.36821119,0.758164939,1.18891097,1.64974493,2.12843359,2.61168076,3.08564671,3.53649738,3.95095774,4.31684376,4.62354826,4.86245815,5.02728406,5.11428761,5.12239665,5.0532044,4.9108538,4.70181447,4.43456403,4.11919084,3.76693801,3.38971139,2.99957553,2.60826141,2.22670874,1.86466323,1.530346,1.23020807,0.968778305,0.74860825,0.570312105,0.432695586,0.33296294,0.266987887,0.22963155600000001,0.215088736,0.217243136,0.23001274300000002,0.24766775,0.265105849,0.278072712,0.283319029,0.278689419,0.26314249,0.236705198,0.200368182,0.15593173,0.10581434599999999,0.0528373937,5.4936518099999997e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0183569225,0.052571056,0.0818382887,0.10458330099999999,0.11971317199999999,0.126663172,0.125407262,0.116434195,0.10069223199999999,0.0795073686,0.0544814294,0.0273774192,3.29619109e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00909494145,0.025823346400000002,0.0398276963,0.0503889515,0.0570587753,0.059673348499999994,0.05834719730000001,0.0534484558,0.0455581891,0.0354173871,0.023865930499999997,0.0117781969,1.09873036e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0023299635999999998,0.006123889820000001,0.00863505959,0.00982849832,0.00979863457,0.00875243858,0.0069835096,0.00483960719,0.0026866081199999996,0.0008721124390000001,0.0,0.0,0.0,0.00161358595,0.00410341593,0.007273981800000001,0.0108552554,0.0145320192,0.0179785149,0.0208953502,0.0230453322,0.0242848877,0.0245879994,0.024060112,0.022940207,0.021590165499999998,0.020471561,0.0201110743,0.021056724,0.023827974,0.0288634513,0.036470413300000004,0.0467802166,0.059713826100000006,0.0749608749,0.09197496449999999,0.10998683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.307458161,0.368554941,0.516835434,0.532505761,0.19344482699999999,0.609729692,0.0,0.0,0.0,0.43070384700000003,0.0,0.322452728,0.0,0.861248646,0.317010625,0.7179046729999999,0.188455653,0.0,0.06751454679999999,1.05439913,1.10610521,0.525396909,0.0,0.142815304,1.04915388,0.0,0.202729327,0.0,0.625000071,0.21075022100000002,0.0812249178,0.806834745,1.00614698,1.08274148,0.938527909,1.92530106,1.4339031999999998,0.44285338799999996,1.31263639,1.65764935,1.81777056,1.70159196,1.44197302,2.16455484,1.75784744,0.106777334,0.696575732,0.804029324,0.843481697,0.380333825,0.148464382,0.776056291,0.129926525,0.900507818,1.11459005,0.578535966,0.297193704,0.0,0.0,1.1609409,0.226600263,0.338672056,0.0,0.33632048600000003,0.0,0.0,0.0,0.07747606929999999,0.5356693810000001,1.27314927,0.503709092,1.12558823,0.0,0.0106774913,0.0,1.90517485,0.135650623,1.39771203,2.53401868,2.96928216,2.56304396,2.83765828,0.49666035700000005,0.630016153,0.0,0.0,1.09163882,0.128666748,0.554360579,0.525181349,0.690825007,1.24310684,0.0,0.305739432,0.263658472,0.0,0.937944225,0.668332962,0.0,0.0690880613,0.0,0.125615755,0.117248522,0.215230805,0.5075841529999999,0.97258359,1.60290875,0.70593909,0.0,0.5072923970000001,0.0,0.0,0.691053925,0.75053855,1.75353599,1.86753394,1.15181892,2.23066215,1.28430824,1.40225786,1.43663505,0.824892235,1.58155976,1.79599982,1.04321341,1.57374381,2.12909682,0.0,0.44233611100000003,0.493828369,0.5502745379999999,0.76090704,0.702571822,0.44247109100000004,0.0,0.26445907,0.0,0.45664197,0.14124141199999998,0.149671601,0.0254276487,0.0,0.255126737,0.0,0.0,1.13299629,0.0,0.244155092,0.0,0.0744967604,0.222172703,0.279344274,0.0,0.0,0.109027111,0.668339462,0.0,1.1705005,0.0,0.562947006,0.0295086164,0.0,1.30022703,0.0,0.8603882909999999,0.5208173779999999,1.36726108,0.0,0.0,0.8016580190000001,0.7652460059999999,1.43042655,1.60083498,1.86563971,3.03543568,0.660077295,1.18875174,0.435178064,0.0011295496499999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.00239456,4.99610512,2.06644477,0.234086354,0.0,0.0,0.675212355,0.7092684920000001,0.37253970299999994,0.0,0.516846481,0.014782588300000002,0.629174673,0.5992350989999999,0.0,0.150513943,0.24305047300000002,0.0,0.0,0.828033847,1.57288188,1.63240306,0.532924402,0.22194865800000002,0.551913248,0.369273213,0.440199305,0.692800313,0.147574018,0.0,0.0,0.0,0.143350176,0.181554825,0.0,0.6968226479999999,0.0,0.403001606,0.22492836300000002,0.0,0.0359435667,1.40085584,1.06096171,0.31790547199999997,0.0,0.0,0.26467857699999997,0.0,0.236783601,0.43478882700000004,3.77712324,6.20560788,7.07344481,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.142219584,0.376968119,0.10921169300000001,0.8185745090000001,1.14738611,1.35076431,0.687247561,1.02486643,0.738167523,0.8772396170000001,0.734392224,1.88859975,0.930567845,0.834604175,1.07894217,0.9615062529999999,0.928568643,0.0,0.260756539,0.0,0.0,0.0,0.0116723099,0.67302031,0.0725867536,0.0,0.565339012,0.305279309,0.301803654,0.45022988,0.731510922,0.0,0.38392844299999995,0.0,0.436951837,0.0,0.0,0.0,0.346248335,0.0,0.0,0.08859973980000001,0.032961245099999995,0.278923194,0.402183389,0.438362026,0.165544356,0.256380049,0.576737801,0.432228751,0.005062302879999999,0.0,0.402324908,0.0,0.0,0.0,0.0,0.37727684899999997,0.0407182048,0.712274616,0.7757279709999999,1.06456219,1.4274428,0.7677299940000001,0.594145539,0.15531415699999998,0.12499238800000001,0.165471441,0.393176745,0.360594927,0.905241616,1.17256053,0.743605356,0.191512748,0.870154634,1.9334272000000001,2.34353505,3.52447259,2.34775433,2.20365188,0.593713361,0.0,0.0,0.120203732,0.724499369,0.378423303,0.0,0.41044052200000003,0.837859377,2.28641617,4.37807223,5.28719415,5.73709293,4.28154948,2.16013306,0.0,0.0,0.0,0.0,0.376680046,0.638435207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0499935441,0.34072498,0.0,0.0,0.364851174,0.251468029,0.0,0.0,0.0194560961,0.108132293,0.0,0.689593165,0.0,0.0,0.987849469,0.0867533565,1.41017175,1.65424746,1.41051908,1.59499342,1.59937323,1.42263832,0.0,0.20273315,0.23051070899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.833333068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.22921059,0.0,0.19794860600000003,0.0,1.6538087,1.83862398,0.18840669399999999,0.0,1.42968677,0.651065246,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.72696702,0.0,1.10062928,0.0,1.05570781,1.29645651,0.0,1.3925393999999998,1.84898822,0.0,0.15507726900000002,0.0,0.0,0.0446289821,0.0,0.0,0.0,0.615803148,0.027640106499999997,0.0,1.24774169,1.59450816,0.70965079,0.7501929890000001,1.09068922,0.0,0.13323805800000002,0.5618714,0.0,0.14462940800000001,1.2560361999999998,0.0,0.0,0.471601881,0.15173687800000002,0.0,0.0,1.87594364,2.00847885,0.0,0.015314469499999999,1.15683057,0.0,0.7874374040000001,0.17107325899999998,1.16050511,0.326691132,0.0,0.0,0.0,1.00876415,0.0,1.13506109,0.0,0.0,0.0,0.0,0.0,0.0,1.97251216,0.0,0.620355827,1.36935752,1.03626078,0.0,1.0356559,0.0,0.0,0.73641286,0.0,0.0,0.0,0.44959437700000005,0.0,0.0,0.0,0.0,19.0267521,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
