# Dataset Information
# The goal of this dataset is to predict maximum water depth for flood modelling. 
# The dataset contains 613 hourly rainfall events time series which are used to predict the maximum water depth of a domain (Digital Elevation Model, DEM).
# The rainfall events and DEM are generated synthetically by researchers at Monash University because real DEM data with accurate rainfall events are rare. 
#
# Data Donor
# Jihane Elyahyioui, jihane.elyahyioui@monash.edu
@problemname FloodModeling3
@timestamps false
@missing false
@univariate true
@equallength true
@targetlabel true
@data
0.226813485,2.36131237,1.38860439,3.25996531,2.23633074,3.23430714,3.76879645,3.253097,2.89597538,3.14854422,2.39944179,1.74653439,1.32300321,1.74227246,1.24464684,0.70051679,0.8794289279999999,0.8549156990000001,1.37984806,0.192012745,1.11523869,1.05080873,0.0,0.0,0.7048520359999999,0.042798313899999996,1.03869467,0.447711043,0.66312375,0.0,0.26012682800000003,0.0,0.34484532,0.0,0.0,0.0,0.0,0.586906812,0.0,0.0,0.0023166999,0.0,0.8898062809999999,0.17188238,0.0,0.0,0.0,0.14741387,0.0,0.0,0.0,1.2994864,0.0,0.0,0.0,0.0,0.40460496,0.780123493,0.0,1.6322473,0.0,2.12172458,1.09878393,1.48205327,0.5250499120000001,0.5085983510000001,2.18892338,1.07858232,1.11970694,0.0,1.24407846,0.0,0.0598349898,0.0,0.8958773000000001,0.060162749800000005,0.0,0.0,0.0,0.0,1.22145631,0.0,0.0,0.916393624,0.0,0.791196242,0.701382726,0.0,0.5223959429999999,0.685128788,0.21306009899999998,0.0,0.598268686,0.449350143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.034957927,0.0,0.115596967,0.09915547400000001,0.306191076,0.360927548,0.426646694,0.8698859809999999,0.7733329109999999,0.7143635690000001,1.08951521,0.62856109,0.169879573,0.507352327,0.356917063,0.127197241,0.398485925,0.217602505,0.0182250132,0.218699731,0.0420315774,0.0,0.100609335,5.49823852e-16,0.0,0.356966192,0.6849224359999999,0.244462583,1.07194477,3.79201049,4.85170542,3.2000522,1.70622376,0.76841749,0.08405269800000001,0.381318185,0.261774179,0.0691743389,1.39059329,1.69027261,0.41594998,0.180951864,0.0250911144,0.09907838880000001,1.89359459,2.04416353,6.46851591e-17,0.0,0.433837046,0.0,0.0,0.17114231,0.0,0.0,0.0167780647,0.008502084009999999,0.00583085694,0.0,0.105379368,0.0,0.0,0.598565627,0.540444819,0.146931335,1.68773544,2.233518,0.22604370699999998,0.0,0.309170404,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.9313541,1.87025363,0.32377794,0.87628108,0.60433787,0.0,0.64756687,0.0,1.71950266,0.0,0.0,0.0,0.0,0.0,0.37455846,0.0,0.0,0.0,0.15332407,0.0,0.0,0.0,0.0,0.04358792,0.0,0.50285941,0.10295679,0.81660356,0.0,0.0,0.33781179,0.0,0.0,0.0,0.41916074,1.60187435,0.0,0.0,0.0,0.80755927,0.0,0.62742465,0.46367248,1.76765976,0.31718048,0.0,0.0,0.0,0.19123831,0.0,0.0,0.69087689,1.01375828,0.65870322,0.0,0.0,0.0,0.37218851,0.0,0.59779138,0.0,0.0,0.0,0.65071474,0.0,0.0,0.0,0.0,1.62029601,0.0,0.04764012,0.37032189,0.0,0.0,0.23891626,0.0,1.11195585,0.0,0.0,0.6895062,0.0,1.19653821,0.13703797,0.22381806,0.83067499,0.34243522,0.12925478,0.0,0.0,0.11488129,0.52380865,0.0,0.99703534,0.0,0.0,0.0,0.53539164,0.0,0.0,0.0,0.0,0.0,0.0,0.69095208,2.0350901,0.0,1.11085382,0.0,0.79345626,0.0,0.17552758,0.67993883,1.40502371,0.81356053,0.0,1.70924593,0.46430092,0.0,0.0,0.0,1.51959266,0.0,0.22787129999999997,0.40459788,0.0,0.0,0.45785177,0.0,0.0,0.0,0.46777527,1.16367344,0.23832575,0.0,0.43618648,0.56616528,0.21668264,0.09645149,0.48495814,0.97368836,0.93362332,1.29351306,2.25602475,2.43536919,3.85216364,3.11195603,2.80468371,2.83660633,2.09566559,3.36015345,3.75302984,3.92939938,2.59697239,3.47794434,3.64709006,3.57038635,3.9927817,2.47732221,3.43166087,3.74457539,2.51583977,2.19189249,1.38043821,2.66093416,2.82966643,0.0,0.39547246,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.07679589,0.0,0.0,0.07864055,0.0,0.0,0.72757417,0.77684664,0.0,0.84712261,1.14233631,0.0,0.6834647,2.28543896,1.61568884,0.32905657,2.44077938,0.83161291,0.0,2.59101129,9.41055472,6.26499547,0.53930397,0.0,0.78398954,0.44697364,0.0,0.49979897,0.0,0.0,0.0,0.0,0.07497323,0.0,0.83953411,0.0,0.40643071,0.04468791,0.0,0.0,0.0,0.90892547,0.0,0.0,0.0,0.05600724,0.20315208,0.05104464,0.15342054,0.68568807,0.88543081,0.0,0.18898604,3.2522539,5.52528988,5.49302626,1.14195371,0.0,1.49036037,0.24314197,0.0,0.30678068,1.05089042,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
1.04428419,1.59182453,2.14127104,2.86823209,4.21211539,3.35438271,2.57606967,2.74464184,2.30784333,0.793270065,0.44514604399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.024477349300000003,0.0,0.0,0.275441579,0.5769805570000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0229842671,0.501824468,1.26722496,0.768303972,0.49766465600000004,0.953573296,0.0,0.0,0.0,0.0,0.0,0.0,0.42901311700000005,0.58924679,0.0,1.04597329,0.0,0.263778766,0.347347085,0.0,0.693342336,0.0,0.0,0.0,0.0,0.543131801,0.592281701,0.530878422,0.0,0.46355481600000004,0.0,0.0,0.0686086107,0.0,0.0,0.639501297,0.795383079,0.0,0.141770565,0.14617449999999999,1.22669216,0.868628407,1.71814212,0.0,1.1425031,1.51127437,1.23114235,0.0,0.40158586399999996,0.277859316,1.08391308,0.0,0.41663474100000003,0.0,0.708969425,0.889529344,0.292587356,1.12109358,0.0,0.21145900899999998,0.291916183,0.888059687,0.0,0.7575414090000001,0.505434655,0.163359249,0.52492878,0.105714611,0.0,0.254206506,0.0,0.0,0.562336463,0.0,0.720288488,0.0,0.0,1.03582636,0.536082994,0.0,0.0,0.611093401,0.915832865,0.109057993,0.0,0.0307948349,0.0,1.00032978,0.0413062685,0.027246579,0.64175797,0.0,0.0,0.0,1.06038498,0.20652837899999998,0.606890725,0.0,0.6798534740000001,1.07976538,1.3182770000000001,0.0,1.74338565,0.0,0.0,0.910831132,0.0,0.0,0.0,0.0,0.0,0.0,1.17888071,0.8600428370000001,0.0,0.0,0.0,0.326563032,0.0,0.006975552370000001,0.468493944,0.11197123699999999,0.342573395,0.0,0.0,0.812486583,0.766115795,0.0,0.0,0.0,0.43876999200000005,0.0,0.0,0.7124601279999999,1.01955532,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.09352013,0.14944734,0.0,0.36365663,0.42131702,0.17210974,0.0,0.0,0.17758459,0.32268323,0.62761264,0.38102414,0.0,0.0,0.0,0.25005966,0.07599501,0.0,0.0,0.0,0.74848635,2.56445685,3.138887,3.28576784,2.28444563,1.48846833,0.38173117,0.12092388,0.04083399,0.41033489,0.0,0.25178444,0.0,0.0,0.0,0.35649541,0.0,0.0,0.26882727,0.0,0.27656998,0.28426292,0.22093153,0.0,0.30940781,0.41673504,0.27307479,0.05675442,0.32165471,0.0,0.17129395,0.0,0.0,0.0,0.0,0.09190273,0.0,0.29008618,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.78070112,0.70869036,0.0,0.50741199,2.16125305,0.11886702,0.63843665,0.08571828,0.0,0.0,0.0,0.58403951,1.01120688,0.49191704,0.31504944,0.15888343,0.09082965,0.0,0.47208028,0.0,0.0,0.0,0.0,0.45795409,0.47953552,0.55452056,0.20699651,0.0,0.0,0.53004504,0.0,0.24457025,0.0,0.0,0.76993017,0.0,0.0,0.0,2.54294548,5.0372105000000005,5.34768206,2.88558507,0.0,0.44234694,1.34460455,0.67340439,0.54135184,0.0,0.33041393,1.66620827,0.0,0.0,1.58151468,0.56257883,0.0,0.14814803,0.54385765,0.0,0.0,0.81947739,0.38967028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.23795093,0.0,0.0,0.577619003,0.0,0.0,0.24333163300000002,0.0,0.0,0.0,2.10924404,0.0,1.56778622,0.26977091,0.0,1.08211001,2.17748484,0.0,0.276863718,0.0,0.0,0.0,1.12985668,0.584289111,0.0,0.0,0.0,0.37543700399999996,0.9240293559999999,0.0,0.0,0.0,1.18579568,1.27002489,0.0,1.94648563,1.11163674,0.017434148899999998,0.0,0.0,0.0,0.46949317700000004,0.0357967154,0.0,1.60868403,0.0,0.09153504009999999,1.13374003,0.0,0.0,0.0,0.0,0.524315138,0.0,0.0,0.0,0.8992892020000001,0.0,0.07836265440000001,0.045858543099999996,0.35315372700000003,0.17644419,0.688794017,0.0,0.0,1.14848211,0.0,0.195605065,0.0,0.0,0.0,0.0,0.0,1.39559122,0.514751539,0.563617713,0.0,0.5658629860000001,0.242527534,1.39639617,0.150570809,1.2658798999999998,0.125459961,0.0,0.0,0.0,1.31876709,0.030018328599999998,0.0,0.592352419,0.30740058600000003,0.0,0.0,0.620355793,0.0,0.440921414,0.980449232,0.0,0.0,0.0,0.0,0.7077460990000001,0.0,0.0,0.0,0.0,0.38493323799999996,1.54273869,0.0,0.0,0.0,2.37016212,0.0,0.223624934,0.0,0.62095861,0.0,0.123594484,0.0,0.825879397,0.566998894,0.325973974,0.0644573642,0.061762699000000004,0.0,0.0,0.509529134,0.0,0.56384741,1.41737634,1.34141821,0.0,1.0496885,0.0,1.48010602,0.0,0.909526004,1.17761915,0.35053122600000003,0.343063861,0.23729036,0.0,1.55372285,1.08689805,0.0,1.19662483,0.46838829200000004,1.01527191,0.703017538,0.0,0.951649014,0.0,0.881669417,0.0,0.0,1.19866482,1.74843089,0.34058771299999996,1.33914392,1.75700889,1.56364555,0.0,2.46022516,0.301050394,2.13595835,0.208062315,0.6883893879999999,1.09873341,0.0871105859,0.0,0.0,0.0,0.0,0.0,0.0,1.69743938,1.23323747,2.11596426,3.39050148,2.4366115,3.65707627,5.48951054,4.22736674,4.44856268,4.21154895,4.52391513,1.92456462,2.89430091,1.35250963,2.07348754,1.71258338,2.1551459,0.6911541,0.0,1.33628517,0.0,0.254879588,0.643951206,0.983065917,0.0,0.453890674,0.543153455,0.509934903,0.0,0.0,1.01853429,0.0,0.0,0.0,0.349266036,0.0,0.0,0.0,0.15716227,0.0,0.0,0.0,0.09713012039999999,0.959559212,0.0,0.0,1.9689458999999998,0.0,0.212266887,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.0550974859,0.23693053,0.0,0.0,1.81531142,0.173428508,0.0,0.0,1.32394394,1.04230322,0.307760527,0.0,0.0,0.0642681006,0.06578051139999999,0.6769588809999999,0.0,0.448460133,0.0,0.0,0.0,0.0,0.980215631,0.0,0.0,0.557475787,0.350575301,0.249055606,0.0,0.0,0.264342863,0.0118358692,0.0,0.26975545100000003,1.60442858,0.0,1.57592163,0.220122811,0.0,0.0,0.0447924467,1.16661115,0.0,0.08158663969999999,1.29383363,0.0,1.30396248,0.0,0.0,0.0,0.412099105,0.93495697,0.0306107712,1.14939193,0.0,0.0,1.37272846,1.08577438,0.222639825,0.313118666,0.41513895700000003,1.59239709,2.40480474,1.72838317,1.16288085,2.20118066,3.15889698,3.61290157,2.28279071,3.87729503,2.98862954,4.79035189,3.60307137,4.58872873,3.55521547,2.85037812,3.57765429,2.65485699,2.78475398,3.84752273,1.74069125,3.52424753,2.48236763,0.7027321870000001,0.608585609,1.53964873,0.714476588,0.9305305079999999,1.08964584,1.97648252,0.012819077,0.7382225570000001,0.0,0.232593152,0.0,0.0,0.0,0.524553529,0.0,0.0,0.0,0.0,0.0,0.47457737299999997,0.530360075,0.0,0.0,0.428554195,0.0,0.0,0.0710851984,0.7064063559999999,0.7130572829999999,0.0,0.635334754,0.131420192,0.0,0.0,0.253004681,0.0,0.0,0.0,0.0,0.290377642,0.562014447,0.0,0.38201667899999997,0.0,0.00371682497,0.0,0.0,0.0,0.7250729709999999,0.0,0.0,0.12510223,0.0,0.133510565,0.25242543100000003,0.802775242,0.0,0.9990662229999999,0.0,0.402623971,0.990769349,0.0,0.9433498779999999,0.0,0.269552154,0.0,0.0,0.0,0.0,0.0,0.765796345,0.0,0.013985911100000002,0.0,0.17187999699999998,0.0140922998,0.166267999,0.0,0.0,0.0,0.0,0.0,0.0,0.30152097699999997,0.11122269,0.0,1.36130175,0.0,0.0,0.577868146,0.0,0.364412876,0.0,0.0,0.0,0.0,0.36338884299999996,0.75999011,0.0,0.40500157700000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
1.88911348,0.00645308527,0.1233766,0.0,0.0,0.0,0.0,0.10310989,0.0,0.47721498,1.64492031,0.9331217209999999,0.0,0.47284249100000003,0.0,0.0,0.0,0.0,0.38468920700000003,0.0,0.102970859,1.0633865,0.0,0.206140887,1.83353082,0.74878533,0.0,0.707337322,0.0,0.702479161,0.0,0.88320825,0.0,0.12569597400000002,0.0,0.518413934,0.0,0.512230216,0.0,0.009409677909999999,0.0,0.172789494,0.0,0.0,0.0,0.064661112,0.934335377,0.0,0.0,0.0,0.35978835,0.549625701,0.963988506,0.030171611299999998,0.5712316270000001,0.35110319,0.0,0.0,0.129217854,0.0,2.30868442,0.0,0.0,0.514709059,0.692970984,0.710577901,0.0,1.41589645,0.379013421,0.0,0.118985634,0.0,0.0,0.0,0.0,0.0,0.5628352670000001,1.39652835,0.0,0.311335949,0.0,0.0,0.212071221,0.0,0.0,0.0,0.0,0.104216995,1.24326499,0.0,0.0,1.15041846,2.12177973,0.0,0.0,0.0,0.0414004288,0.018190158600000002,0.547248785,0.0,0.7100860240000001,0.34522637,0.0,0.45046020299999995,0.0,0.639727823,0.0,0.36714812799999996,0.0,1.11038349,0.959804179,1.16482495,1.33654075,1.2463761,0.0,1.13166252,0.0,0.274251144,1.7443591,0.0,0.18158236,0.337975132,0.41237335799999997,0.9808609909999999,0.0,0.0,0.0,0.004105607589999999,0.0,0.0,0.0,0.0864636729,0.0,0.0,0.0,1.20622143,0.466595857,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32209509,1.15880871,0.8480429979999999,0.306160605,0.22457502699999998,0.0,0.0,0.0,2.76488033,1.94493752,0.231999471,0.0,0.0,0.829204465,0.0,0.0,1.09877258,1.12108488,0.0,0.0,0.760490208,0.296373887,0.8504231059999999,0.0,0.21902587199999998,0.0,0.792943098,0.5370013579999999,1.78019287,2.05778503,2.78105494,3.54861413,4.08571378,3.72544665,4.9480179,3.90165076,2.90033257,3.66763967,1.72318834,0.7798734940000001,0.836352986,0.0,0.0,0.0,0.556173218,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
2.05201306,1.77190859,0.59860357,0.0,0.57964068,0.0,1.00619698,0.37659619,1.03299447,0.0,0.0,0.77513741,0.23938367,0.0,0.0,0.32761105,0.0,0.35264328,0.0,0.0,0.0,0.0,0.10050519,1.27283771,0.0,0.0,0.0,2.2802694,0.32595694,0.0,0.3945256,0.0,0.0,2.59798092,0.20091022,0.44247147,1.20635931,0.0,0.0,0.0,0.92416432,0.0,0.83824621,0.27868276,0.23430298,0.74548811,0.0,1.60958122,0.0,0.40111617,0.16650656,0.0,0.0,0.10232409,0.56279754,0.0,0.0,0.0,0.0,1.1119508999999999,0.55888466,1.3078862,0.0,0.09221554,0.09909678,0.0,0.90446103,3.13187572,1.70313765,3.8434112000000002,3.11816162,3.78363479,3.30365647,1.66545466,0.99001778,1.13021938,0.32694932,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
2.65223348,0.0,10.72393934,3.41431858,0.0,3.02405775,2.22183658,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
1.52039903,2.81598062,2.86912774,1.61607988,0.19201280199999998,0.0,0.0574079504,0.346832798,0.0794162507,0.0,0.0,0.199970686,0.257415983,0.0,0.0,0.0,0.291771465,0.144699174,0.0,0.0,0.164069399,0.360611004,0.0,0.0,0.0,0.762607328,1.07882303,0.544933833,0.105812288,0.7161933290000001,1.90143375,2.24808861,1.32747809,0.447671349,1.0588004,2.80005325,3.78126976,2.83635737,0.930693405,0.0,0.7212648629999999,1.94881002,2.2268272999999996,1.38585657,0.386505605,0.0,0.0329711798,0.0227783995,0.0,0.0,0.16869567600000002,0.415915207,0.35685258,0.10629431199999999,0.0,0.159334655,0.39633972100000003,0.43975495200000003,0.21607878600000002,0.0,0.0,0.0288739012,0.680297472,1.30820345,1.44658874,1.08773214,0.8162646590000001,1.166685,1.82345725,1.77778421,0.563799591,0.0,0.0,1.43064595,3.88314681,4.42150143,2.53267586,3.70474755e-16,0.0,0.0,0.59898929,0.469822904,0.0,0.0,0.09254391619999999,0.59086892,0.150625264,0.0,0.0,0.96121453,2.5671373,3.14584486,2.7375043999999997,2.41040684,2.93871496,4.07339475,5.08557343,5.61456932,5.75268573,5.558181299999999,4.88719906,3.75511504,2.5749921000000002,1.82899582,1.58028241,1.45868309,1.11257218,0.566265562,0.129256735,0.050697398399999996,0.29455860899999997,0.583932102,0.6285674139999999,0.365688952,0.020271899399999998,0.0,0.0,0.12377741800000001,0.0503734341,0.0,0.0,0.0786405641,0.147584413,0.0,0.0,0.0,0.216473425,0.16788424899999999,0.0,0.0,0.193770295,1.11326398,1.51175177,1.07600105,0.45327312299999994,0.41547085200000006,0.880694925,1.08340384,0.624179378,0.0,0.0,0.09427416300000001,0.328145598,0.166852381,0.0,0.0,0.0340076909,0.11944823,0.015352186200000001,0.0,0.0476772369,0.17011032,0.11623592199999999,0.0,0.0,2.54701394e-16,0.0766936845,0.027521215,0.0,0.0,0.0261572492,0.039294699,0.0,0.0,0.0,0.00846508764,0.0,0.0103667771,0.029090601299999998,0.0,0.0,0.0,0.323411206,0.6770509859999999,0.681275795,0.291763192,0.0,0.0,0.013062633,0.13951487,0.0396143445,0.0,0.0,0.0601403732,0.08857273189999999,0.0,0.0,0.0,0.243276623,0.55222195,0.6870168959999999,0.44586501799999995,0.0,0.0,0.110796834,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.177590568,0.6817954390000001,0.713343043,0.646748863,0.441028163,0.0,0.304368876,0.137756723,0.945925598,1.3862483,1.85101165,2.45250826,2.10453361,2.56018187,1.9171985,1.20468832,1.4043903,0.506147265,0.0,0.0684032363,0.0,0.19508401,0.317501491,0.0701065271,0.0,0.0,0.0,0.305769008,0.222650034,0.0,0.26946309,0.0,0.63011122,0.0331805019,0.0,0.053123247400000004,0.0,0.297837896,0.0,0.418949109,0.280189061,1.58271603,1.98177418,2.12009334,1.33154612,0.865101021,0.806763019,2.55526943,4.10408738,4.49692181,3.51775682,2.71769454,2.01380571,1.24919147,1.53034604,0.531869642,0.607070359,0.00407609606,0.8114427390000001,1.2542586000000002,0.963004139,0.18337905300000001,0.264063857,0.0,0.0,0.547496554,0.269920037,0.10879046,0.0,0.251645079,0.527528595,0.280046095,1.12610618,0.8010822959999999,1.02684108,0.607751013,0.0,0.0,0.45467871,0.0,0.0928342167,0.21965870899999998,0.371817128,0.0,0.559585851,0.7661607859999999,0.767282307,0.643316323,0.29256996,0.0,0.206193858,0.46048489,0.26523097100000004,0.158663421,0.46718285600000004,0.368135945,0.26545788600000003,0.0,0.304885015,0.404942869,1.69898777,1.74265284,0.809246263,0.0498510831,0.0,0.185196859,1.81123202,2.25626226,2.32773353,1.53221065,0.0,0.0,0.0,0.752737008,0.599954065,0.0,0.0,0.0,0.248275048,0.96989062,0.915067525,0.11573536699999999,0.0,0.108035905,0.0,0.0,0.0,0.0,0.198831767,0.0,0.38151334299999995,0.341195697,0.00547998818,0.0,0.298093567,0.0,0.0,0.0,0.182798047,0.08932744179999999,0.225322348,0.18895753,0.0,0.0,0.255747709,0.10619848300000001,0.338935253,0.0,0.265456292,0.0,0.0,0.0613472577,0.265416981,0.835434372,1.13444495,1.4960831,0.152763154,0.0,0.0,0.19594841699999999,0.250877657,0.0,0.551414841,0.205268334,0.0,0.386126794,0.0,0.0686636209,0.465415245,0.665153549,1.64699075,2.44548229,2.57405219,2.20907029,1.49699871,1.38515034,2.52778077,2.43779749,2.35958333,2.27068611,0.670041966,0.368653668,0.0756509393,0.43384532600000003,1.48748422,1.13056826,0.480780241,0.672754196,0.449511334,0.0,0.176461867,0.0,0.0,0.20444089699999998,0.272057567,0.0,0.0,0.31668388,0.0,0.25607109699999997,0.0,0.0,0.314184244,0.0,0.0,0.19284775,0.46116417299999996,0.0,0.0,0.0,0.23077315199999998,0.44458425,0.0,0.0,0.227458572,0.0,0.220864885,0.5157554879999999,0.8017972529999999,0.529043088,0.569736458,0.21717627899999997,0.185359313,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
0.51247004,0.25367039999999996,0.11576372,0.19485388,0.90005031,0.35399681,0.0,0.81894748,0.0,0.6096108,0.0,0.72052522,0.70925754,0.0,0.0,1.79687074,1.45018518,0.0,0.25663723,0.0,0.08466152,0.0,0.12787123,1.80066317,0.0,1.48117264,0.0,0.0,0.0,0.0,0.89339841,0.11710394,0.0,0.24010854,0.0,0.68305957,0.29087334,1.28483969,0.66733108,1.74376899,3.48450295,2.07852238,3.55503079,3.84058087,1.56252616,3.47138749,0.56849164,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
8.75214178,7.559017599999999,5.83759199,3.86031155,1.92615891,0.305562318,0.0,0.0,0.0,0.0,0.0,0.703719277,1.29902993,1.60021565,1.56021269,1.21643116,0.6737611309999999,0.07407571339999999,0.0,0.0,0.0,0.0,0.0,0.101854106,0.47433991600000003,0.7124109009999999,0.7636493740000001,0.626071631,0.345261637,0.0,0.0,0.0,0.0,0.0,0.0,7.129726190000001e-17,0.266623369,0.45023690899999996,0.507387977,0.429256139,0.24232087300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20796895399999998,0.354417286,0.402886819,0.34367436100000004,0.195545055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.176982423,0.303334478,0.34673316200000004,0.29737181,0.17009010800000002,0.0,0.0,0.0,0.0,0.0,0.0,3.15034413e-16,0.159892162,0.275231389,0.315950279,0.272107385,0.156281867,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.151547058,0.261832255,0.301671888,0.260756135,0.150303535,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.149913085,0.259908814,0.300494455,0.26063859899999997,0.150756372,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.154618346,0.269018806,0.312138349,0.271711682,0.157730276,2.68608289e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.16671855900000002,0.291222462,0.339259326,0.296524147,0.172846322,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.189339035,0.332351443,0.38910678299999996,0.341831558,0.200300142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.230048422,0.406554267,0.47932926600000003,0.424161424,0.250421629,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.30937230600000004,0.552885882,0.659578467,0.590969109,0.35352491700000005,4.77525847e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.503628991,0.922364396,1.13003529,1.04225986,0.643497605,0.0,0.0,0.0,0.0,0.0,0.0,0.37963803100000004,2.13972993,4.15376935,6.14153439,7.80643429,8.89032844,9.22242631,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.06031379,0.314750007,0.0596932709,0.5948030879999999,0.7767997459999999,0.177755704,1.39872627,2.63741587,3.47642575,4.87365129,5.23428441,4.9950472,3.78896069,2.5139466,1.00310341,0.0,0.0,0.0,0.16970807100000002,0.0,0.19191681800000002,0.472962957,0.35452854100000003,0.0,0.0,0.0,0.0,0.41986360899999997,0.570646004,0.305694537,0.381929729,0.0,0.0,0.293882037,0.0613983034,0.059000018700000004,0.00299439347,0.38666977799999996,0.48127638100000003,0.191783371,0.0,0.113587945,0.0,0.567293305,0.54405066,0.12015077699999999,0.154312442,0.0,0.57323974,0.322843179,0.868066608,1.23271717,1.77325505,1.32338123,0.92727026,1.50073658,1.08524353,0.915614189,0.316499631,0.149062261,0.0,0.196418445,0.315926294,0.0,0.08830009189999999,0.0,0.129092467,0.0,0.0,0.0,0.0,0.0,0.288941175,0.0,0.0,0.0,0.280928146,0.0,0.0,0.37294446299999995,0.298557767,0.0,0.323249491,0.17872072,0.19149615,0.0,0.437385174,0.664446746,0.0,0.569460738,0.239083483,0.0,0.103041539,0.171912037,0.0,0.24532761399999997,0.0,0.0,0.155302735,0.0,0.0,0.370184952,0.0,0.273021263,0.0,0.12504041300000002,0.0,0.0,0.0,0.35755257100000004,1.07278812,2.54851474,3.17098613,4.0717872999999996,3.4301331,1.86283093,1.12186268,0.09235536400000001,0.0,0.0,0.0,0.358235686,0.0683644628,0.8492439159999999,0.435496127,0.031853251,0.0,0.0,0.203884652,0.551854736,0.513238894,0.26898167100000003,0.392607446,0.07704882490000001,0.0,0.0,0.0,0.0,0.313173913,0.461574563,0.0,0.0,0.0,0.0,0.0,0.0,0.20194960399999998,0.28406058100000003,0.134055456,0.192038005,0.061074417199999995,0.0,0.0,0.37695812700000003,0.748397842,0.46699652,1.31049965,1.41045331,1.27913317,1.79932113,2.29899867,1.5075661,1.59436952,1.24565401,0.86090344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
6.81381065,4.0323803,1.03681994,0.0,0.0,0.029877882400000003,1.39288695,2.07519137,1.72341265,0.693892913,0.0,0.0,0.0,0.17642246399999997,0.549483994,0.467537495,0.053733591799999994,0.0,0.0,0.0,0.156666516,0.34592257299999996,0.255719925,0.0,0.0,0.0,0.0,0.123471458,0.212779915,0.133206944,0.0,0.0,0.0,0.0,0.0805031593,0.11055883,0.055143366,0.0,0.0,0.0,0.0,0.0266350765,0.0230772737,0.00511853628,0.000168022507,0.012084226399999998,0.018198017099999998,0.0,0.0,0.0,0.0,0.048382441,0.0983627724,0.0723989853,0.0,0.0,0.0,0.0,0.123369939,0.197684727,0.115008698,0.0,0.0,0.0,0.0,0.239893993,0.324713201,0.147127819,0.0,0.0,0.0,0.0505878453,0.441183173,0.521018999,0.169053437,0.0,0.0,0.0,0.21584539999999997,0.906507873,0.972464745,0.179981998,0.0,0.0,0.0,1.15189312,4.32472697,7.04056134,8.02460477,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41
0.977268899,0.0,0.0,0.247760404,0.34472654399999997,0.0,0.0,0.275122669,0.112237336,0.0,0.0,0.254323512,0.0,0.0,0.120479571,0.42698461299999996,0.0615948354,0.0,0.6099025779999999,2.20419591,2.99952151,2.18040917,0.724864043,0.0,0.0076676441700000006,0.0,0.0,0.0686116858,0.129000366,0.0,0.0,0.20909145899999998,0.104571834,0.0,0.0,0.42608630000000003,0.020048428700000002,0.0,0.378734269,0.763022187,0.0,0.0,2.20900157,5.87334054,4.75541806,0.527967934,0.0,0.328840655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
1.54658102,0.0,2.06524658,0.866111745,0.23184223,0.0,0.420282548,0.0,0.8979882370000001,0.437092855,0.284376035,0.0,0.0,0.0,0.250686404,0.157269257,0.0,0.0,0.0,1.0127017,0.0,1.14532948,0.0,1.17937583,3.28276344,1.46329454,1.72960136,1.42267779,1.38432855,0.47884291100000004,0.374549275,0.0,0.0,0.0,1.12688827,1.08130821,0.014605523,0.46493045200000005,0.897800576,0.0,1.67339811,0.0,0.0,2.08317927,0.0,0.80823885,1.02437148,0.0,0.0,0.0,0.504179132,0.816971662,0.0,0.0,1.08487744,0.0,2.40376908,0.0,0.0,0.313125284,1.76328005,0.536825326,0.0,0.0,0.550404386,1.06778865,1.01416402,0.9801583159999999,1.83981897,2.83336687,2.15859028,0.0,1.90803892,0.485629718,0.0,0.0,0.0,0.0,2.53219699,4.13776188,1.94053328,4.70495871,4.51529498,4.1187601,4.47409953,3.70695462,1.99067282,3.49270238,1.08767069,0.0,0.0,0.0,1.11842794,0.720450609,0.0,1.88415976,1.06802992,0.0,0.0,0.966744574,0.864038434,0.0,1.11814854,0.0,0.0,0.44873828200000004,0.0,0.648700513,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.179708724,0.162051749,0.0,1.23115212,0.0,1.22893975,0.528223057,0.0,0.0,0.0,0.0,0.1171339,1.64234323,0.603875608,0.8710316709999999,0.0,0.907419619,0.0,0.9266999570000001,0.64687258,0.0,0.6991094309999999,0.0,0.433389743,0.836781153,0.0,0.0,0.392551054,0.0,0.0,2.03758551,0.447090117,0.10161439800000001,0.0,0.0,0.0,0.0,0.0,0.0,1.10646252,0.746442583,0.28309375,0.0,0.0311295069,0.0828718401,0.0,0.22630186800000002,0.0,0.0,0.30402808,0.188652087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.110601319,0.0,0.058886507000000005,0.0,0.0,1.49905372,0.344845324,0.0,0.9798026459999999,0.637982032,0.331943235,0.862270685,0.107971507,0.477892864,1.61564988,0.0,1.10542806,1.12755236,0.0,0.0,0.0678518977,0.026076443300000002,0.14193379,0.0212298489,0.0,0.8866064709999999,0.0,0.0,0.0,0.703460953,0.0,0.251312742,0.55252517,0.15873875699999998,0.0,0.0,0.9871491370000001,0.159276606,0.177962032,1.6215936000000002,0.1809511,0.18125059100000002,1.06102307,2.03028072,3.32540846,2.6843719,2.30206242,0.6869452690000001,0.7510272840000001,1.41526035,0.752469782,0.0,0.773947295,0.0,1.32113643,0.0,0.547261537,0.39363647700000004,0.820009311,0.0,0.0,0.353060836,0.0,0.655850403,0.0,0.736152893,0.7550587740000001,0.181386275,1.10526442,0.0,0.0,0.0818513727,0.0,0.0,0.0,0.882559729,0.0400237135,0.354719426,0.0,0.0,0.0,0.23250693100000003,0.540834205,1.12875715,0.238354767,0.733787613,0.576070519,0.23015387899999998,0.693859188,0.0,0.0,0.355958289,0.628131618,0.0,0.537972307,1.39753309,0.90551551,1.48217973,0.601257726,0.0,0.194733436,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.25225056,0.99616703,0.7130463,0.95058684,1.28203835,0.66672465,0.34945356,0.32391025,0.0,0.11370537,0.46943881,0.02690037,0.0,0.23007505,0.37829886,0.04571217,0.0,0.41105161,0.84966899,0.46604063,0.0,0.26223070000000004,0.4173791,0.0,0.21299499,0.0,0.0,0.0,0.10095178,1.63559438,0.38795664,0.21474358,0.0,0.0,0.27091435,0.50604152,0.0,0.0,0.36190974,0.49640005,0.0,0.0,0.21080078,0.65596934,0.0,0.0,0.36005513,0.42651828,0.98173797,0.45755694,0.91022572,0.18428827,0.0,0.0,0.48319457,0.0,0.87192376,3.6277277999999997,2.39072419,3.5467072999999996,2.39884568,0.50527949,0.0,0.0,0.64967919,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.0239079341,0.0864612582,0.130845094,0.152987058,0.15244803,0.13216818800000002,0.0977606458,0.0564789017,0.016023670900000002,0.0,0.0,0.0,0.0,0.0,0.03510584,0.0753546142,0.11408724099999999,0.146251018,0.16821674399999997,0.178279637,0.176827078,0.166159404,0.150004499,0.132813743,0.11895905,0.111963634,0.113891158,0.124990642,0.143652294,0.16667910800000002,0.18982838,0.20853415,0.218692613,0.21738225100000003,0.203400337,0.177526135,0.142464055,0.102470751,0.062720678,0.028507189,0.00440413187,0.0,0.0,0.0136695783,0.0404097648,0.0723772789,0.103860504,0.129156996,0.143500225,0.143865037,0.129519171,0.10222363,0.0660364359,0.026734976299999998,0.0,0.0,0.0,0.0,0.0,0.0250222823,0.0733498745,0.122724859,0.164369804,0.189934546,0.192867588,0.16960821399999998,0.12040376900000001,0.0496008814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.115518386,0.229072812,0.317221759,0.364988565,0.362490086,0.307131958,0.205042052,0.0714801365,0.0,0.0,0.0,0.0,0.0,0.198366875,0.6277828120000001,1.19964273,1.89400223,2.67662518,3.50120637,4.31302339,5.05368275,5.66648771,6.10186869,6.32229357,6.30611847,6.04994587,5.56921477,4.89693955,4.08071672,3.17831043,2.25228309,1.36424127,0.569304784,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17173966300000001,0.368492957,0.495594739,0.549639953,0.537635114,0.474909043,0.382163797,0.282087107,0.195980677,0.14083363699999998,0.127192514,0.15805983199999998,0.228909516,0.32875776,0.442092359,0.551358648,0.63963866,0.693148456,0.7032168000000001,0.667489656,0.590217619,0.48161137200000004,0.356376375,0.231645588,0.12460442699999999,0.0501362035,0.0188056751,0.0354456316,0.0985247756,0.200366937,0.328176851,0.46572175200000004,0.595434735,0.7006557290000001,0.767714749,0.78759032,0.7569387890000001,0.67837832,0.560012307,0.414276926,0.25628331,0.101885335,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.0383302267,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0152131122,0.0702720329,0.122864814,0.16917487399999998,0.205630972,0.22914290399999998,0.23732033,0.2286618,0.20270228399999998,0.16010949900000002,0.102721832,0.0335236477,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.157871323,0.375525049,0.626585792,0.90585683,1.2067961,1.52175034,1.84224372,2.15930807,2.46383951,2.74696512,3.00040272,3.21679684,3.39001565,3.51539495,3.5899183,3.61232532,3.58314363,3.50464382,3.38072024,3.21670408,3.01911827,2.79538655,2.55351064,2.30173125,2.04818859,1.80059805,1.56595566,1.35028574,1.15844136,0.9939648590000001,0.8590128890000001,0.7543470520000001,0.679387941,0.63232747,0.610291635,0.609543711,0.625716243,0.654059292,0.6896920529999999,0.727845393,0.764083862,0.79449728,0.815854028,0.8257105159999999,0.8224738070000001,0.805416968,0.774649204,0.731045073,0.676139022,0.611992975,0.541045718,0.46595330100000004,0.389429652,0.314096036,0.242347006,0.176239124,0.11740707800000001,0.0670099857,0.025708827200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00183855012,0.00403055636,0.0044171322,0.0033551457,0.0013208478,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00325626501,0.00802884475,0.013031320700000001,0.0177452928,0.0216400633,0.024222050800000002,0.0250820808,0.0239367894,0.0206607983,0.0153069695,0.008112894809999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00523794719,0.0214917139,0.0376644469,0.0525381367,0.0648758378,0.0735061815,0.0774100195,0.0758038689,0.0682147694,0.0545414317,0.035097138199999996,0.0106307334,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06783035400000001,0.157244841,0.258772978,0.369977155,0.48787665,0.60906028,0.7298241879999999,0.846328497,0.95476537,1.05153024,1.13338759,1.19762266,1.24217117,1.26571995,1.26777283,1.24867782,1.20961369,1.1525359,1.08008431,0.9954568020000001,0.902255155,0.804310739,0.705499016,0.609552406,0.519881313,0.43941275700000004,0.370455225,0.31459700399999996,0.272643503,0.24459702100000003,0.229680107,0.22640127399999999,0.23265950800000001,0.245881796,0.263186061,0.281560384,0.298048393,0.30993031,0.314889245,0.311153105,0.29760375899999997,0.273846898,0.2402382,0.197863885,0.14847634699999998,0.09438815980000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.26767713,1.23232723,0.12249687,0.25773971,1.36352881,2.25277641,0.0,0.0,0.56257638,0.0,0.0,0.0,0.0,0.0,1.40790068,0.75795658,0.0,1.40412738,0.84068993,1.89034061,0.0,0.11974208,0.0,0.0,0.9887921000000001,0.0,1.55076649,0.0,0.80039275,0.0,0.63198249,0.0,0.0,0.0,1.28106907,0.0,1.94535808,0.0,2.48087593,0.0,0.0,0.40108218,0.13415317,0.0,1.03280808,0.0,0.30219434,0.0,0.94651227,1.50096125,0.0,2.15276981,0.93769797,0.0,0.24889456,0.1656786,0.0,1.95839989,0.0,1.45688533,0.35306533,1.20648169,0.0,0.0,2.28297213,1.19278729,1.46101924,1.63941517,0.91972593,0.0,0.0,0.33353922,0.0,0.89532848,1.27977625,2.84495272,2.00084651,0.0,0.20249724,0.0,0.0,0.0,0.0,0.0,0.0,0.36685902,0.34349153,0.0,0.0,0.62445918,0.0,1.14626987,0.35019066,0.0,1.84840526,0.24715049,1.57168199,1.1601713,5.19059849,6.46479077,6.01639054,5.17358795,3.7827053999999998,6.55748215,3.28943804,2.21477666,4.71538684,3.20092156,5.33869001,6.19644244,7.14769141,5.07647626,5.59612247,7.8549882,4.73339232,2.79849039,0.93854134,0.0,0.0,0.24136479,1.20981761,1.2262132,0.0,1.09459577,0.0,0.0,0.58187933,0.0,0.0,2.13348639,0.0,0.0,0.0,0.0,1.26406138,0.55999355,2.49749493,0.21687420000000002,0.0,0.64222068,0.0,0.0,0.0,0.0,0.71524484,0.0,0.16718934,0.0,0.96701622,0.0,0.20171154,1.22097342,2.73180127,0.0,1.50207899,0.0,0.90764755,0.0,0.0,0.85300008,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.375503295,0.0415563806,0.41410859200000005,0.233752008,0.28371659899999996,0.0201875057,0.352936152,0.168362525,0.470291798,0.29361056,0.38156184600000004,0.39722754600000004,0.75128076,0.0,0.239169539,0.0,0.22005814199999998,0.31722396,0.0,0.502099969,0.0768848442,0.0,0.41381059,0.0,0.0,0.162295463,0.386281893,0.24454626100000001,0.42690677,0.0,0.102598441,0.39136382700000005,0.0,0.0,0.0315852074,0.0,0.24748420000000002,0.717277395,0.0,0.866571063,0.0,0.257024446,0.5778988389999999,0.208856454,0.480586821,0.290780588,0.871009877,0.080172158,0.0,0.608325219,0.520608851,1.93833335,3.42398103,3.82375988,3.04035732,2.5934662,2.24311635,1.27596716,0.10122116800000001,0.31112064100000003,0.364946844,0.0,0.0,0.403651495,0.0,0.0,0.018523158600000002,0.12010622,0.15875635300000002,0.292578261,0.177977983,0.370247116,0.16866244600000002,0.0,0.59490272,0.0,0.9571524459999999,3.26263676,1.33240195,0.34934048700000003,0.427076519,0.0,0.325697601,0.0,0.0,0.155617783,0.22114156399999998,0.0,0.45402236799999995,0.0,0.0,0.328474002,0.0,0.0,0.0,0.0,0.099778331,0.23881206800000002,0.0,0.255401504,0.135148399,0.845507969,1.63056695,1.22357136,1.1472102,0.7745630459999999,1.78849354,4.35731513,3.58028469,1.13504076,0.110352861,0.0,0.385766334,0.15635635,0.0,0.0,0.0,0.408229141,0.0,0.0,0.0,0.6367094010000001,0.0,1.07999575,3.66795037,1.95413282,0.0,0.691830098,0.0,0.19102088899999997,0.17666041100000002,0.0229901788,0.0,0.0,0.0,0.0663322531,0.00303752935,0.370424388,0.0421914216,0.0,0.0,0.0,0.41214580100000003,0.0,0.17536317399999998,0.36142669200000005,0.135228031,0.0,0.197842063,0.0,0.0,0.0,0.16911390699999998,0.0,0.0,0.0,0.0,0.0,0.04983890269999999,0.0,0.0,0.0,0.119282235,0.171472505,0.0,0.0,0.334694864,0.0,0.471401599,0.0,0.0,1.38183293,1.33855693,0.19704835199999998,0.0,0.0690936924,0.7127037420000001,0.0545864343,0.0,0.0,0.0,0.37615705299999996,0.145208368,0.129595945,0.0,0.296783171,0.00641351236,0.469177697,0.0,0.040046871,0.332855179,0.847696265,0.651774108,0.000476237353,0.5697928729999999,1.15544337,0.6284579,1.07363387,0.9917442879999999,0.785333043,0.491781411,0.0,0.054972845599999993,0.44261727100000003,0.39590180700000005,0.139843225,0.0,0.0,0.08712609630000001,0.025346286099999997,0.292549428,0.0,0.0999999664,0.0,0.0567885611,0.407623012,0.300341474,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
14.11978869,4.3988768,0.29262906,4.87053234,0.0,2.4549141,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.376
0.190829634,0.0,0.146063554,0.0,0.924963713,0.156644253,0.50832085,0.669800993,0.47838531799999995,0.735066105,0.31039868800000003,0.0471248988,0.527269816,0.413986759,0.288001467,0.0,0.0,0.0,0.0659251575,0.0,0.0,0.44877063799999994,0.0,0.161158281,0.238850859,0.0,0.11886235699999999,0.0,0.0493042624,0.0,0.0,0.343712061,0.324137036,0.318564988,0.0421970096,0.146728079,0.0,0.0,0.0,0.146900614,0.119591611,0.0,0.0,0.144551137,0.193701522,0.32950787800000003,0.254092975,0.0,0.0,0.377441707,0.0,0.0,0.24752858100000003,0.0,0.312117171,0.148109307,0.551955396,0.45328822399999996,0.476859739,0.152392664,0.36156137299999996,0.0,0.111757309,0.361440407,0.24789834600000002,0.0,0.23598025600000003,0.45484043399999996,0.0,0.12253703099999999,0.0,0.21487486600000003,0.41050518700000005,0.013570735700000001,0.0,0.0790163408,0.0,0.0,0.06428042469999999,0.0324664357,0.0678665716,0.17950147,0.356240958,0.309099926,0.0,0.0,0.468486962,0.0,0.0,0.099809144,0.0,0.325274251,0.258857965,0.0407165578,0.0,0.0,0.0,0.132660224,0.426875124,0.111873697,0.690744971,1.29973018,1.00201774,1.40422151,1.89351834,2.19562958,2.89903759,3.20243422,2.73016788,3.46461244,3.35779057,3.13554293,2.55701609,1.76152773,1.53380153,0.962897728,0.515993774,0.243541554,0.0,0.011026891200000001,0.0,0.0,0.0,0.0,0.0,0.0,0.09214409380000001,1.03283903,1.05917086,1.17535577,0.37118593299999997,1.22680412,0.540398313,0.407299061,0.210994822,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.369475341,1.35946858,2.07995597,2.95974739,3.32060869,4.83621871,5.01629954,4.73902388,5.49280044,4.68119752,4.90142101,3.55098502,3.85679476,3.08873573,2.10996319,1.56015214,0.729091442,0.265233027,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.46634488799999996,0.0,0.05412047440000001,0.0502621919,0.819541576,0.936049765,0.0,0.286787012,0.0,0.326608973,0.0,0.0,0.0,0.0,0.0,0.0726558864,0.0,0.24125284100000002,0.0,0.0224567946,0.523684143,0.0,0.58102799,0.0,0.349833622,0.0,0.283024475,0.0,0.000224107778,0.0,0.0,0.165887037,0.199455665,0.0,0.155767817,0.0,0.0,0.128339693,0.42152937799999995,0.360008671,0.015432963999999999,0.490242545,0.0,0.498689551,0.0,0.0,0.0461367016,0.303806431,0.0,0.0,0.0,0.14559443,0.0,0.0,0.14662797,0.45636003399999997,0.550508264,0.0,0.584350246,0.0,0.508949998,0.0,0.039972686800000004,0.0,0.0,0.275251957,0.0,0.011601733400000001,0.351348208,0.0,0.341472778,0.370049935,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.718480091,1.13292794,1.26127353,1.44672138,1.40006859,1.37115242,1.31129957,0.716096175,0.642262579,0.0,0.035407452,0.0,0.025854078,0.0,0.0,0.0,0.218471295,0.0,0.33973569600000003,0.0,0.0,0.0,0.0,0.0,0.23837088399999998,0.344807365,0.0,0.0,0.137402749,0.0,0.0,0.0051195508600000005,0.172019869,0.0,0.0,0.0394531515,0.0,0.0,0.0,0.0336335342,0.0,0.279157812,0.297570915,0.0,0.33780873100000003,0.0,0.0,0.0,0.0,0.0601675558,0.33212091899999996,0.189872441,0.0950851494,0.0,0.291393198,0.0,0.0,0.0682119576,0.0,0.0,0.0,0.0,0.149011809,0.0,0.0397813054,0.134688501,0.0,0.250430179,0.0,0.0,0.0,0.251464099,0.0,0.08303308849999999,0.37638866299999996,0.151610838,0.095377887,0.0,0.19134560399999997,0.0,0.116891408,0.0,0.0,0.352738724,0.603606151,1.00718745,1.31963314,1.398224,1.43203277,1.10163041,0.329319223,0.154150881,0.0,0.0,0.0,0.0,0.0,0.150398347,0.0,0.500255097,0.0011034433,0.144787917,0.0,0.0,0.0,0.0830797196,0.0165003012,0.00634175417,0.00712413844,0.644009189,0.22968147,0.932362402,1.18878013,1.0397988,1.1595737,2.01764775,2.14503918,2.33928,2.4050875,2.69977716,2.56099348,2.10062217,1.50995401,0.8101590679999999,0.42480822799999995,0.444918506,0.17817508,0.17899373100000002,0.175042693,0.448627075,0.0,0.17128613,0.200214631,0.21254025,0.0,0.0,0.0,0.0,0.200954267,0.393424007,0.736092733,0.678858527,0.764527428,1.12418882,0.59569358,0.102930513,0.0,0.11783307400000001,0.0551310987,0.783888293,1.3108813999999998,2.44703598,2.94978563,3.29096283,3.66496644,3.37622302,2.56524279,1.98257448,0.9725481140000001,0.369587615,0.0,0.0,0.0,0.014951883300000001,0.0703332855,0.620053098,0.284304973,0.453894832,0.33473722,0.292812047,0.7407210590000001,0.807322002,0.558908476,0.877516093,1.51793144,1.53493562,1.18537112,1.55230851,0.947700262,0.868524698,0.140250453,0.0,0.0,0.0,0.0,0.0,0.45480511,0.0874749808,0.45542082,0.412393072,0.131420591,0.0852167667,0.0,0.0,0.0,0.0,0.0,0.28723562399999997,0.060615599400000005,0.360651874,0.0,0.094539305,0.0,0.0,0.0,0.18309845800000002,0.0,0.18681009,0.0,0.39425640700000003,0.0,0.0,0.0466131107,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
3.97049853,1.86446391,3.24554646,1.29694436,0.14724747800000001,0.0297232448,0.0,0.554875483,0.218128543,0.0,0.92170666,0.038892346200000004,1.53344106,0.8316848720000001,0.439118036,1.01829479,0.17109872899999998,0.0,0.0,0.0,0.0,1.86951302,1.28328727,0.0,0.128335117,0.0384136797,0.0,0.0,0.0,0.005835074920000001,0.355298199,0.0,0.0999566875,0.0,0.0,1.0507524,1.77537813,0.615543369,0.321760779,0.0,1.50595253,0.0,0.257171457,0.951372302,2.66614437,0.00216154075,1.27313642,0.254192132,0.0,0.0,0.0,0.0,0.0,0.0,0.0696907489,1.0300748,0.0,0.0,0.0,0.155207023,0.0,0.783022291,0.805893283,1.01261152,0.0,0.0,0.0,0.527002582,0.8882456390000001,0.0,0.5157189289999999,0.962326802,0.0,0.0,0.8453383959999999,0.880503177,0.0,0.0,0.429928408,0.0,0.0,0.32899400300000003,0.0,0.0,0.854648106,1.36011335,0.225185837,0.0,1.13127067,0.239331185,0.927723297,0.36821772399999997,0.6421491810000001,0.222324374,0.0272656096,0.0994326052,0.0,0.0,0.069437397,1.51588824,0.33591320700000005,1.10083664,1.68014199,0.0,0.43534190899999997,0.154710602,1.38658255,0.177499278,1.61686944,1.82379472,2.34753636,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.379
0.8816455870000001,0.644419588,0.45610879600000004,0.292292688,0.136605333,0.0,0.0,0.0,0.0,0.0,0.036436265499999995,0.27119391600000003,0.52798607,0.7583609029999999,0.918251127,0.9790830070000001,0.934697412,0.802079705,0.61576943,0.417714411,0.245668635,0.12360598199999999,0.0569269802,0.033695748399999996,0.0312412477,0.0257831645,0.0018194449800000001,0.0,0.0,0.0,0.0,0.0,0.0703256773,0.22280755300000002,0.371613409,0.475195529,0.499867694,0.431940961,0.28520286100000003,0.10106487300000001,0.0,0.0,0.0,0.198422305,0.617299271,1.15999998,1.75402054,2.31332067,2.75642872,3.02295525,3.08444051,2.94714691,2.64672018,2.23689702,1.77596749,1.31506476,0.891463867,0.52821959,0.239249669,0.0370803421,0.0,0.0,0.16288625,0.534426587,1.08844182,1.79465477,2.58430701,3.35336223,3.97643673,4.32966942,4.31790884,3.8997834000000005,3.10402071,2.03195874,0.844229322,0.0,0.0,0.0,0.0,0.0,0.0,1.05034726,2.17621007,3.1207745,3.73238131,3.92774599,3.70332394,3.12986971,2.33241236,1.46096421,0.658962901,0.0364004331,0.0,0.0,0.0,0.0,0.00984672422,0.225437119,0.366815765,0.4142987,0.37595838200000004,0.279582221,0.161423869,0.0550844371,0.0,0.0,0.0,0.0,0.0275891225,0.0520661088,0.057772914,0.044394438200000004,0.0182361651,0.0,0.0,0.0,0.0,0.0,0.0,0.018443308000000002,0.029578216600000002,0.030277367700000002,0.021459729700000003,0.00687120395,0.0,0.0,0.0,0.0,0.0,0.00183203046,0.012249971,0.0180391565,0.0177462628,0.0118701826,0.00257066019,0.0,0.0,0.0,0.0,0.0,0.00308383008,0.0112399368,0.0158202701,0.015315475700000001,0.00975949076,0.000760573161,0.0,0.0,0.0,0.0,0.0,0.006214103760000001,0.0171327896,0.023321925499999997,0.0221422319,0.0131103437,0.0,0.0,0.0,0.0,0.0,0.0,0.0167774914,0.0386242523,0.0503812914,0.046052532599999994,0.0242099236,0.0,0.0,0.0,0.0,0.0,0.0,0.058096016900000005,0.11903758699999999,0.151060415,0.134310801,0.0606652369,0.0,0.0,0.0,0.0,0.0,0.0171795783,0.43103890200000006,0.96236459,1.53815595,2.06229338,2.43381358,2.568647,2.41993334,1.99193389,1.34372037,0.581026343,0.0,0.0,0.0,0.0,0.0,0.0,0.644484388,1.45677897,2.17789012,2.7054897,2.98114213,2.9969744,2.79074458,2.43143556,1.99969685,1.56842978,1.18834952,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
1.40955564,0.0,1.48657274,0.0,8.64752951,6.58979498,0.0,1.32339169,0.0,0.6288909429999999,0.0,0.296023721,0.0,0.0,0.880616107,0.9795027540000001,3.95235869,0.824156401,0.0,0.38253483200000005,0.0,0.25106558100000004,0.0,0.172536635,0.0,0.10923368300000001,0.0,0.09485127300000001,0.0,0.0450491666,0.0,0.0186357407,0.0,0.22567547,3.82599498,0.0373627991,0.250052638,0.0,0.344588094,0.0,2.13065361,0.0,2.57577859,2.86580514,0.0,0.5319831270000001,0.0,0.273004178,0.0,0.16043112699999998,0.0,0.0873805148,0.0,0.0115535952,0.0773830197,2.17912863,0.0,0.061268461399999995,0.0,0.0169442804,0.0,0.0,0.024204383399999998,0.0,0.0455911644,0.0,0.0641713149,0.0,0.0798701453,0.0,0.0905082088,0.0,0.0859217847,0.0,0.0,1.79502366,0.938324277,0.336026063,0.43598345899999996,0.0,0.300859533,0.0,0.33770502700000005,0.0,0.39502238100000003,0.0,0.560832958,0.358886104,0.867446678,0.1160873,0.600411445,0.0,0.832982605,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
0.473811459,0.0,0.0,0.0,0.260928084,0.0,0.0940421041,0.08823013910000001,0.0,0.0473820784,1.2143715,0.425202983,0.0,0.0,0.621037776,0.202635624,0.317483766,0.0,0.307189588,0.46202255700000006,0.42222391,0.14382831,0.0,0.0,0.258751978,0.0,0.0,0.260006182,0.554133191,0.0,0.0,0.0,0.0,0.0,0.767904534,0.0,0.622413541,4.37723122,5.44265549,1.74895382,0.0,0.602765875,0.506749554,0.0,0.0,0.0,0.0,0.44163889700000003,0.07622755860000001,0.0,0.480990879,0.0,0.0,0.0,0.0,0.0,0.0192015839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.35785787799999996,1.08384802,1.42901074,0.0,1.49020403,2.04896516,0.966808592,0.24799073600000002,0.0,0.0806402858,0.170969965,0.0,0.0,0.134157829,0.12313651699999999,0.38153037700000003,0.16940713699999999,0.0,0.0,0.549071066,0.229863934,0.0,0.7714513909999999,0.409333803,2.14376264,1.96882279,0.0,0.361957099,0.19779046399999997,0.0,0.249520493,0.0,1.24153678,4.34802427,2.9254332,0.623415806,1.9414866000000002,2.3282552000000005,0.875371267,0.5906177220000001,0.38825921,0.0,0.0266058736,0.0,0.134967724,0.6386401829999999,0.0,0.941325065,4.00555152,3.10545455,4.50767841,3.63092675,0.453089825,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.132222405,0.0,0.0,0.0320016907,0.0,0.136723011,0.30292363,0.503982995,0.0,0.75696125,0.613774803,0.146426207,0.533679617,1.03039635,0.90448705,0.352412186,0.47740939,0.449211996,0.0115800074,0.0,0.39701649899999997,0.0,0.350930707,0.47959431399999997,0.0693447554,0.0,0.20464999399999997,0.449302043,0.393332181,0.200288717,0.0,0.8714491120000001,0.21944032300000002,0.684253125,0.302755805,0.9690123829999999,0.6830663109999999,0.558002545,0.392886145,0.163367627,0.18398120199999998,0.0,0.0,0.0,0.489802659,0.0,0.505536413,0.359414034,0.295107697,0.812053735,0.10002446400000001,0.545650017,0.331022009,0.446445882,0.663914126,0.545120301,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.046404386299999996,0.0,0.329275294,1.08564899,1.78455554,2.6682167999999997,2.95174257,3.41642996,3.7289775,4.09323024,4.43153837,4.51314694,4.56703932,4.94455583,4.26668647,3.67224428,3.28426183,3.43801058,2.86270708,2.52842985,2.06092228,0.8199156120000001,1.20881387,0.20804755,0.41787796,0.0,0.12363321099999999,0.0,0.204984748,0.23642443800000001,0.31740663,0.23616486399999997,0.5414707329999999,0.0,0.0,0.0,0.5812951120000001,0.0,0.0,0.0,0.39058372700000005,0.032715201299999996,0.0,0.0,0.247596292,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.028353021200000002,0.0,0.0,0.0034041401700000006,0.5385443120000001,0.0,0.225896732,0.0,0.0,0.418715425,0.0,0.0,0.24171441300000002,0.267479426,0.22629609899999997,0.40186813600000004,0.0,0.449329682,0.13354870000000002,0.47985646,0.329936645,0.0575073642,0.217549713,0.240132887,0.35273988,0.0,0.48591702,0.42923856899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.40691434299999996,0.0,0.132125021,0.44085784899999997,0.0,0.49252515399999997,0.0,0.559455144,0.31688457600000003,0.392221507,0.0,0.2680958,0.471192092,0.0054131115100000005,0.054880461500000005,0.025327771699999998,0.106132142,0.0110576242,0.560089954,0.0,0.154002818,0.5605075389999999,0.14755629999999997,0.239187183,0.00131209997,0.0466745012,0.0782794785,0.0,0.0,0.0138384368,0.371223569,0.0,0.07248786019999999,0.0,0.0,0.0,0.0,0.14625886,0.0,0.260230042,0.46252196100000004,0.292441318,0.494653038,0.0,0.223739697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
0.398281841,0.0,0.853621788,0.766859283,3.77536041,2.71638311,0.0203137958,0.23783339399999998,0.148397873,1.5383584,0.0,0.31644768100000004,0.0,0.0,0.0,0.0,0.0,0.10707657400000001,0.0,0.0,0.0,0.25755045,1.6890636000000003,1.44200479,1.45368153,0.257417253,0.0,0.125108692,0.0,0.364635728,0.0,0.31987139800000003,0.152430916,0.0,1.29600395,0.41497771,1.68899303,0.0,0.0331054254,0.0,0.581314961,1.3182277,0.621902229,0.0,0.0,0.0,0.384829451,0.82199079,4.46908154,3.33885761,4.24240327,2.17745171,1.06435895,0.38471422299999997,0.20017956399999998,0.0,0.0,1.38441753,0.26858801,0.130358778,0.0,0.0831439038,1.72602988,0.6581733000000001,1.36329487,0.0,0.0,0.0,0.0,0.180121084,2.32771611,1.69265767,1.61890749,0.0,0.307118774,2.1479605999999998,0.0,1.74037855,0.823784623,0.55992841,0.611520003,0.0,3.07263447,2.87031161,3.74895893,5.4350455,5.12079343,5.30600084,3.06133543,5.23193637,1.55010315,1.21450402,0.0,0.0,0.36878976399999996,0.6644603689999999,0.390539829,0.291225526,0.0,0.128635002,0.0,0.0,0.310193896,0.396076935,0.0,0.5257950579999999,2.02316462,0.0,0.0,0.0,0.755250533,0.0,0.0,0.8180970740000001,0.46547371,0.562075949,0.0,0.0636132153,0.0,0.0,0.551626373,0.105312062,0.0853692942,0.200948577,0.755091959,1.61854714,1.23847062,0.345029497,0.0,0.0,0.0,0.217243515,0.479605334,1.16857541,0.42700819700000003,2.44573886,0.0,0.0,0.0,1.14488294,0.8306860079999999,0.700794114,0.0,1.16005718,0.0,0.0,0.0,0.0164871269,0.313528341,0.3663134,0.0,0.268312992,0.0,0.0,0.0,3.15351709,2.10109077,2.97692542,5.38247094,2.70723621,0.48600752799999997,0.32375718,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
2.15013826,0.0,0.0,0.0,0.7691297009999999,1.785518,0.0,1.38323666,0.49202808200000003,0.849314825,0.0,0.857107031,0.0,0.0895239511,0.0,1.78812188,0.307164008,1.54918874,0.0,0.0,0.0,0.0,0.0,0.7242880909999999,1.12148399,0.184867483,0.0,1.54115123,0.0,0.0,0.0,0.0,0.497663725,0.0,0.0,0.198799693,0.774203237,1.52097593,1.35924052,0.747255335,0.0,1.61481454,0.563660889,0.0,0.0,1.10886162,1.84485974,0.0,0.0,0.0,0.0,0.606259277,0.199919903,1.4584398,0.0018205460699999999,0.0,0.802910076,0.74623324,0.195949235,0.0,0.40112709999999996,0.0,0.0,1.42942565,1.67920954,0.0177216733,0.0,1.69762775,0.0,0.992540238,0.220770495,1.05484459,0.0,0.0,0.0,1.91806849,0.0,0.0,0.223110855,0.8803347429999999,0.7455272620000001,0.0,0.729276782,0.451022162,1.58959038,0.0,1.98774498,0.0928654934,0.33982997200000004,0.0,0.164204694,0.0,1.7392391,0.0,0.125805748,1.24839747,1.47189053,0.0,0.143654079,0.0,0.8740854140000001,0.611072542,0.0,1.5459139,1.16509082,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.87076625,0.24835324600000003,0.0,0.0,0.651363349,0.0,1.97156537,0.0,0.0,0.46080168299999996,0.7149950759999999,0.665030535,1.33159339,3.83548251,4.78513221,3.78773106,4.03536974,4.88471715,3.77303091,2.13602785,1.12421302,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.404718257,0.0,0.0,0.334995414,0.37878423899999997,0.7264100179999999,0.501675258,0.0,0.839421985,0.628807466,0.0,0.0,0.607990733,0.8094195909999999,1.23443617,0.523170691,1.47991514,1.74637028,0.951560744,1.00498686,2.19055925,1.89811139,1.66206932,1.81766256,1.17797185,1.13674118,0.486245854,0.550643872,0.566375279,0.0,0.0,0.0,0.0,0.415822271,0.424613295,0.352792011,0.0,0.663557673,0.19401832300000002,0.0,0.650301559,0.0,0.204618647,0.0,0.318373171,0.057740402999999996,0.0,0.310884431,0.0,0.0,0.153295192,0.0,0.12294773,0.0,0.0,0.0380261602,0.35253074700000003,0.0,0.0,0.0,0.0,0.164185134,0.0,0.0,0.382406101,0.0,0.0,0.0,0.0,0.28947411100000003,0.0295865891,0.24302815,0.0,0.0,0.0,0.15157893,0.0,0.00281798724,0.0,0.0321387228,0.0541470442,0.0,0.322731247,0.334520765,0.0,0.0,0.0,0.0,0.18803313300000002,0.0,0.354199136,0.457408435,0.0,0.0,0.0,0.463357688,0.19408073,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.799855535,0.963641892,0.8194235679999999,0.0,0.6911854270000001,0.833532145,0.176098317,0.0,0.0,0.0,0.0,0.0,0.0,0.158583704,0.0,0.0117447681,1.21187507,0.366253612,0.154818166,0.47866356,0.631223347,0.207953899,0.0,0.0,0.0,0.0,0.0,0.0,0.8344120279999999,1.08161201,2.53851173,3.37595229,5.30834888,6.0237309,6.49871609,6.92514197,6.92182393,6.17828098,5.30258209,4.06680795,2.37650314,1.19157262,0.84207271,0.0,0.0,0.0,0.0,0.0,0.0,0.060163187300000004,0.5145032620000001,1.01803798,0.72920087,0.677596593,1.05461418,0.0,0.7009730590000001,0.0,0.0,0.0,0.0,0.0,0.0,0.153715151,0.23886418,0.0,0.0,0.544780546,0.740366313,0.258961702,0.0,0.0,0.368380686,0.0,0.0,0.007099547640000001,0.0,0.0,0.5524463039999999,0.0,0.0,0.17319567800000002,0.481321706,0.0,0.033556063399999995,0.0435665391,0.0,0.0,0.341503522,0.0,0.0,0.0,0.122957629,0.0,0.173423735,0.11666551,0.757715432,0.0927802315,0.0,0.0,0.0,0.0,0.38250108200000005,0.0,0.475973992,0.0,0.0669946342,0.014450323700000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
1.35322624,0.435902875,0.285554422,0.240643087,0.0,0.0,0.0,0.0,0.0,0.46362304299999996,0.31735220199999997,0.621728168,0.0296162466,0.385698053,0.44012384600000004,0.95602626,1.08727251,0.946221845,1.14813644,0.22816101,0.300027569,0.81373178,0.815153835,0.0,0.0,0.093502401,0.11149779,0.130816491,0.644701188,0.41805578299999996,0.533521229,0.0,0.0,0.256712315,0.13561763599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.42395964399999997,0.0675200162,0.0,0.0,0.0,0.0982108108,0.566795543,2.01311809,4.499477099999999,6.39695821,6.70124529,3.89496481,1.82219252,0.129494515,0.0,0.221389287,0.0,0.124838621,0.0,0.440932131,0.6900804420000001,0.7990220159999999,0.0,0.0,0.321803326,0.0,0.26211372899999996,0.0,0.311927544,0.42556183700000005,0.259428748,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7206579409999999,0.0,0.0,0.0,0.307823546,0.137803844,0.40940707,0.0,0.356459546,0.0,0.537911667,0.0,0.0,0.0,0.847299825,0.209356575,0.0,0.0,0.0,0.784298643,0.0,0.66864064,0.0,0.0,0.0,0.655762069,0.0,0.235007539,0.0,1.47721151,2.20369443,2.0053696,0.157626374,0.0,0.0,0.6898431079999999,1.02157255,0.0,0.529245339,2.30557499,3.24699007,2.16188742,0.20812564100000003,0.624909886,1.19831447,1.92449339,0.616684582,0.47276413799999994,0.0,0.0,0.0,0.34897168,0.972979707,0.0,0.0,0.29773412899999996,0.254449025,0.0,0.55648555,0.292979724,0.354821045,0.0,0.0,0.008783999609999999,0.39396302299999997,0.0,0.0,0.0,0.0,0.45169387,0.0,0.0,0.717055372,0.5628156329999999,0.20349013800000001,0.463317286,1.65331044,1.82060389,1.05210844,0.94223366,0.101989636,0.0,0.35163635299999996,0.584235003,1.69241374,3.83744067,4.28327346,4.04924362,1.96793348,0.48416120799999995,0.21776762100000002,0.33705546299999994,0.18007162100000002,0.0,0.654544861,0.0,0.485648866,0.0,0.0,0.0,0.780987605,1.20649629,2.88796312,2.77690112,1.63663208,1.81736096,0.6843894140000001,0.6302903,0.0,0.0,0.0,0.0294939764,0.0,0.495729291,0.0,0.17481950899999998,0.0,0.133938264,0.0,0.232021194,0.16895580899999998,0.181362742,0.38802620200000004,0.0669673572,0.0,0.38129322200000004,0.0,0.0,0.33697168200000005,0.0,0.0881568195,0.515524373,0.0,0.0,0.231447707,0.669439624,0.031439745299999995,0.0,0.669876413,0.370963651,0.214781151,0.0,0.34736000899999997,0.0,0.440287737,0.0399489253,0.010815555400000001,0.0,0.895659847,0.0843831275,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
0.20965550600000002,0.358058459,0.2921163,0.8183584709999999,0.712908557,0.437943171,0.500213962,0.980094192,0.7158469009999999,0.47378142799999995,0.601062431,0.356529628,0.39153911,0.19679877699999998,0.0,0.0,0.18616766399999998,0.18193380899999997,0.130846202,0.0,0.0,0.0,0.417663191,0.158782091,0.44735380700000005,0.168389648,0.0,0.0,0.0,0.265642399,0.0,0.14634660900000002,0.121802257,0.0,0.161715706,0.266648066,0.0,0.263938949,0.254999659,0.148631008,0.0,0.0,0.33283466,0.218225358,0.42985647899999996,0.0,0.17205510699999998,0.180484208,0.0,0.0,0.0,0.0,0.0,0.0,0.0373551017,0.0,0.0,0.27740542,0.0,0.123673407,0.0,0.0,0.0,0.0,0.365469032,0.32209163,0.279301097,0.316685578,0.0,0.0,0.434875712,0.432337284,0.654080354,0.511285666,1.11263523,1.06482596,1.24689859,1.58935626,1.08325673,0.602159867,0.661998917,0.17501924300000002,0.0,0.0,0.0,0.0,0.657583348,1.86602712,3.06794134,3.49290941,3.75894012,3.8207608,3.51065972,2.45924427,2.3026478999999997,0.80719061,0.5054961179999999,0.0,0.0,0.0,0.0,0.387045591,0.49784626,0.521926378,0.978886919,0.33256366,0.7613439390000001,0.0,0.0,0.229418137,0.319127227,0.246876103,0.450077254,0.0584897976,0.00435658759,0.44636325600000004,0.355849718,0.0,0.340647511,0.0,0.220337151,0.125422464,0.0,0.21222947399999997,0.0,0.5742638000000001,0.485358654,0.0,0.0,0.0,0.0,0.0260676348,0.00476260468,0.0,0.27091453600000004,0.0,0.159490718,0.346303454,0.183997448,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.395044025,0.0,0.120390289,0.0,0.231491513,0.023171469500000003,0.38296763,0.22500905,0.508163015,0.464552888,0.42242517,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.928189363,0.966852809,0.7569894659999999,0.38507950399999996,0.0108384499,0.0,0.0,0.0,0.16228711099999998,0.290539757,0.255862511,0.0806333591,0.0,0.0,0.0,0.0,0.10590983400000001,0.267340036,0.332434789,0.33076474,0.35657615299999995,0.510782527,0.8333265959999999,1.26486771,1.66186302,1.86039478,1.75706163,1.36470082,0.812681201,0.28992523600000003,0.0,0.0,0.00431762524,0.18506672,0.280558313,0.216489266,0.0221986649,0.0,0.0,0.0,0.0,0.17585145,0.308181355,0.27035323699999997,0.08188259469999999,0.0,0.0,0.0,0.0,0.129586059,0.301865779,0.308219442,0.143138362,0.0,0.0,0.0,0.0,0.0762397382,0.289820183,0.34563571,0.20952653300000001,0.0,0.0,0.0,0.0,0.0139827872,0.273384081,0.38681472299999997,0.286542908,0.022233238500000002,0.0,0.0,0.0,0.0,0.251377219,0.437361464,0.384360328,0.111570925,0.0,0.0,0.0,0.0,0.22094644300000002,0.5103636539999999,0.527580623,0.244116837,0.0,0.0,0.0,0.0,0.17497560199999998,0.651084323,0.803281219,0.502864853,0.0,0.0,0.0,0.0,0.317387871,1.72972159,3.05465858,3.83710424,3.82994673,3.09344571,1.95271597,0.836841453,0.0813462218,0.0,0.0,0.0,0.013275221100000002,0.0,0.0331646995,0.562452119,1.7673884999999998,3.59657641,5.67098848,7.3913592,8.16857377,7.67487873,5.99828782,3.62431387,1.24870466,0.0,0.0,0.0,0.0,0.125411873,0.459279327,0.393619626,0.130195079,0.00215329867,0.26995254399999996,0.964525383,1.85660673,2.56502335,2.74630708,2.26842253,1.2814794,0.151537079,0.0,0.0,0.0,0.0,0.420544895,0.71904809,0.608594451,0.193224688,0.0,0.0,0.0,0.0,0.18965004800000002,0.454426436,0.457163041,0.215930223,0.0,0.0,0.0,0.0,0.0720497785,0.30872958,0.376677639,0.27024892100000003,0.09133253820000001,0.0,0.0668344416,0.33085232,0.6722055509999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.52047864,0.94932,0.42723751,1.80294258,2.09683664,0.37299186,0.85547612,0.52294649,0.0,0.0,0.41427892,0.38559182,0.7525276999999999,0.86275045,0.56560619,0.0,0.69755698,0.0,2.60970267,0.0,1.07997019,0.89917987,0.0,1.00274793,0.0,1.24609884,0.20167916,0.35265378,0.91654691,0.0,0.0,0.0,0.47494829,0.0,1.06831635,0.0,0.75572259,0.02286824,0.14964633,0.31345476,0.0,1.08554162,0.0,0.0,0.0,0.0,0.15592336,0.0,1.0760008,2.12538722,0.98397015,1.51313132,0.09042057,0.0,1.33551276,0.0,0.0,0.0,0.0,0.86608051,0.60654156,0.83546387,0.0,0.0,0.0,0.0,0.5750196,0.78542761,0.3563163,0.0,0.53210749,0.53460749,0.18910029,0.0,0.5165869000000001,0.60511336,1.05449169,0.75589101,0.15366377,0.14312525,0.0,0.0,0.12263510000000001,0.0,0.41334239,0.0,0.0,0.05736508,0.0,1.34589391,0.0,0.0,0.0,0.0,0.0,0.74660845,0.0,0.19970861,0.0,0.0,0.90966101,0.0,0.0,0.0,0.0,0.1196848,0.63841544,0.0,0.0,0.0,0.0,0.16510941,0.93267166,0.43026926,0.0,0.0,0.0,0.0,0.0,1.09541152,0.0,0.22417084,0.0,0.24401046,0.45222661,0.13910043,1.30393462,1.8190346000000002,1.18211429,0.89923798,0.0,1.71416915,0.77551815,0.67250902,0.0,0.0,0.85526648,0.0,0.0,0.0,0.0,0.0,0.0,0.42838228,0.0,0.0,0.0,0.0806034,0.0,0.58600885,1.69032526,2.50674637,2.65101158,3.10059836,3.02104672,2.58117898,3.11065488,5.41947806,4.27282804,5.54462989,3.40577195,4.89442901,4.88078695,4.4561517,3.24335503,3.27066736,1.37975844,1.04585392,0.84973532,1.36689603,1.51999106,1.25886014,0.79014565,1.91349619,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.82980203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.26782310600000003,0.541061911,0.30708607,0.0,0.0,0.0,0.174397616,0.46179609899999996,0.155732605,0.384041367,0.180851469,0.0,0.473315501,0.15468627199999999,0.0601424599,0.206663984,0.31653584100000004,0.22359704,0.41319006700000005,0.0,0.0,0.0,0.17312308,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.354450025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18108100800000002,0.11895885,0.0,0.237446055,0.45809454,0.394024927,0.0434407398,0.0,0.321096779,0.0,0.0,0.16004263900000001,0.17748608100000002,0.150822355,0.0653206696,0.0,0.056685743600000005,0.194905545,0.263645974,0.362398096,0.137896766,0.0484978159,0.0812280288,0.278926729,0.014795368400000002,0.342859607,0.0,0.0,0.0,0.0,0.08579815380000001,0.10496548,0.0,0.116511354,0.26490232,0.0,0.0,0.0,0.028533177000000003,0.452329556,0.0,0.12766547,0.060414206100000006,0.319858558,0.0,0.0,0.0536869288,0.102360782,0.0,0.0,0.0345998297,0.0,0.0,0.17383432899999998,0.0,0.227751234,0.0,0.39494864700000004,0.43793097200000003,0.5994768779999999,0.26513137,0.0,0.0,0.0,0.139554192,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.202783482,1.01422594,1.23719656,1.69309779,2.23999586,2.40406781,2.64308602,3.37815494,3.71361419,3.25786837,3.6846154,3.18439445,3.51938944,2.85366073,2.59295235,2.37840285,2.24855158,1.81800121,1.43799383,1.33449434,0.56941954,1.01625654,0.323149227,0.594445731,0.726161508,0.7730570609999999,0.567253046,0.582401885,0.834773855,0.768666325,0.8168375109999999,0.71121749,0.294706236,0.6207902120000001,0.253421444,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.44504286,0.64190234,3.43867006,2.67002659,7.68788074,4.24029696,0.0,0.0,0.79147184,0.0,0.32887286,0.0,0.8942036,0.0,0.0,0.12308363,0.0,0.26340166,0.0,0.32811542,0.0,0.0,0.0,0.44603862,0.0,0.0,0.0,0.22760992,0.0,0.06695408,0.0,0.0,0.0,2.18222459,1.1821631000000001,0.35604952,2.17995087,0.56224807,0.0,1.9495276000000001,0.0,0.0,0.44802916,0.0,1.32255256,0.84413316,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.8495078000000001,0.35714688,0.0,0.0,0.62931215,0.06834004,0.66462768,0.82507993,0.8172353,2.02277762,0.0,0.0,2.40621224,0.55407351,0.0,0.37478553,0.13790693,0.37546887,0.84685434,0.0,0.35700741,0.8771781999999999,0.0,0.0,0.20693797,0.0,0.53815212,0.0,0.0,0.0,2.39781739,0.0,1.43312053,2.75495072,1.51545867,1.77053814,0.27510359,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.86598511,0.0,0.08332837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
6.38159583,0.0,0.47488087,0.0,2.30821725,0.00958011,0.0,0.0,0.0,1.58176316,0.0,2.39590942,0.0,1.80972418,0.0,1.84552016,0.69784661,3.19850741,0.0,0.0,2.57057053,0.9801155999999999,0.07328074,0.84629773,0.0,0.00652016,0.0,0.0,1.14286637,2.5654941000000004,0.0,0.0,0.0,0.0,1.17370511,0.0,0.36439876,0.0,0.0,0.0,0.0,0.0,0.0,0.91458693,0.0,0.0,2.82669875,1.92187147,0.0,0.24707283,0.0,0.86841315,0.0,0.16034424,0.0,0.0,0.0,1.05553836,1.50178953,1.02022372,2.79020379,0.0,0.0,0.53892201,2.4817086,0.0,2.61290392,0.62338552,1.27496871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.37200000000000005
0.395846142,0.0,0.279040274,0.742008807,0.9363526659999999,0.0465041363,0.0,0.196942544,0.327844609,0.0,0.324853455,0.22464947300000002,0.0419913384,0.0,0.0,0.0,0.536003522,0.889442024,0.511340682,0.864199495,0.00936964496,0.0,0.0,0.466706942,0.442147689,1.22780214,1.0788521999999998,0.187869685,0.613552064,1.15616223,3.25536425,5.14582397,6.42367074,5.12411781,3.5860461000000003,1.39701168,0.0,0.0,0.0,0.0,1.27639758,0.17060442,0.0713157567,0.0,0.0,0.365895129,0.222408838,0.630243574,1.0802286,0.986760251,0.856562777,0.0,0.0,0.017526482700000002,0.297902383,0.615896189,0.0,0.415369754,0.0,0.273233844,0.449132818,0.0,0.0,0.128085113,0.0,0.0506476783,0.0,0.49148762799999995,0.0,0.188233508,0.0627637246,0.0,0.0,0.5872049779999999,0.851681391,0.0632587559,0.526021053,0.304126454,0.916417003,1.26552132,0.48376863,1.42325406,1.19618705,1.32763088,0.27936607399999996,0.190937935,0.868861068,0.63964746,0.763129683,0.5610066999999999,0.853111043,0.608353141,0.0,1.20849947,1.13086184,0.670320075,0.0,0.8095100120000001,1.04210067,0.0588249155,0.849684876,0.929169922,0.5980869360000001,0.0795670754,0.0457955674,0.0,0.386016801,0.648291035,0.0,0.206012488,0.20935954699999998,0.638421411,0.0776815043,0.530282654,0.0,0.0,0.0,0.0,0.49009029299999995,0.5206522729999999,0.73787629,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.24735853300000002,0.0,0.170216256,0.0,0.44741075799999996,0.660383949,0.0,0.133627296,0.0,0.0,0.0200852948,0.0,0.044294833,0.0,0.06307481549999999,0.0,0.0826112958,0.0,0.109152038,0.0,0.18567838600000003,0.0,0.157483072,0.0,0.31509689,0.0,3.95619139,1.01089614,0.0488458825,0.5148607070000001,0.0,0.0416590528,0.015856627800000002,0.0,0.46003532700000005,0.7971115,0.0,0.171397895,0.0,0.106224599,0.0,0.0763159157,0.0,0.050774735099999996,0.0,0.383688056,0.0,0.10637948900000001,0.0,0.116079801,0.103107492,0.303051198,0.0302886745,0.19382798,0.17313742199999999,0.011081435300000001,0.0,0.0206586588,0.12196436,0.07958621469999999,0.0,0.16844873600000002,0.158879776,0.0356572389,0.0994945773,0.0,0.0605677558,0.0,0.158348865,0.184597111,0.0257188112,0.00519876804,0.0,0.058725264000000006,0.3146766,0.113427407,0.23016639100000003,0.0,0.052129023200000006,0.0,0.037305016499999996,0.0,0.0313685144,0.0,0.029098801,0.0,0.042789500700000004,0.277224293,0.0,0.032242633799999997,0.0,0.127601674,0.191689475,0.5268891689999999,1.35163116,0.949444967,0.224294608,0.0,0.0796794409,0.0,0.0566675297,0.0,0.022466046899999998,0.0588770167,0.45123265799999995,0.0,0.14218772699999999,0.0,0.287253865,0.20986836899999997,0.129924426,0.0,0.195687335,0.00649964382,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
2.28162174,1.9437727999999999,1.46737794,0.935982188,0.43636519,0.0413339042,0.0,0.0,0.0,0.0,0.10963511599999999,0.276717626,0.381103335,0.402329985,0.343441044,0.22695976399999998,0.086685391,0.0,0.0,0.0,0.0,0.0,0.0,0.0279119185,0.0700040788,0.0839138168,0.0720275908,0.0438145791,0.011681644,0.0,0.0,0.0,0.0,0.0,4.509668229999999e-05,0.0,0.0,0.0,0.0,0.0,0.0,0.015632761499999998,0.029258310299999996,0.029874684500000002,0.016249406,0.0,0.0,0.05205806,0.19790345399999998,0.47173839,0.894051613,1.46071572,2.13742188,2.8602382,3.54306706,4.09113588,4.41808663,4.46314096,4.20451861,3.66589802,2.91412401,2.04827542,1.1821587,0.42381837,0.0,0.0,0.0,0.0,0.0,0.015448489099999999,0.249514543,0.396431229,0.432051942,0.364207845,0.226712435,0.0678626221,0.0,0.0,0.0,0.0,0.11548773300000001,0.270892984,0.40547587799999996,0.49319219700000005,0.523972123,0.5052087160000001,0.458253507,0.411143486,0.389747381,0.40985585,0.472385581,0.562942472,0.655762041,0.7208548140000001,0.7323474320000001,0.6757383920000001,0.552134256,0.378384751,0.18314949100000003,3.36878998e-16,0.0,0.0,0.0,0.0,0.0,0.011363858400000001,0.09516664429999999,0.143752167,0.148762106,0.113900092,0.0527506054,0.0,0.0,0.0,0.0,0.0,0.0,0.0166954282,0.055536771,0.0751804876,0.0724985466,0.050792059400000006,0.018190460500000002,0.0,0.0,0.0,0.0,0.0,0.0,0.011332806,0.0246711609,0.0286411568,0.0239648979,0.0139110198,0.0028489522999999998,0.0,0.0,0.0,0.0,0.0,0.000280757211,0.0,0.0,0.0,0.0,0.0,0.0,0.013255295600000001,0.026741483599999998,0.03464316,0.0329176898,0.0201717833,0.0,0.0,0.0,0.0,0.0,0.0,0.00642343681,0.0424281151,0.0698854995,0.07951581099999999,0.06651119400000001,0.032475794100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.024974816,0.0801052131,0.113963186,0.115249895,0.0828713219,0.027855792799999998,0.0,0.0,0.0,0.0518593027,0.206551815,0.407851345,0.619341822,0.794811299,0.8888347259999999,0.8685762309999999,0.7238939409999999,0.47299680200000005,0.161792385,0.0,0.0,0.0,0.0,0.0,0.413576,0.969956012,1.53413461,2.01240152,2.32416152,2.4179867,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.10276332,0.5853459329999999,0.277566934,0.0,0.0,0.286657028,1.01179862,0.635905397,0.0,0.0,0.48746271799999996,0.745668619,0.0,0.0,0.0,1.37102467,1.18816885,0.0,0.0,0.637335263,7.72597997,12.564291,10.616398599999998,3.82488463,0.0,0.0,0.938329472,2.23394539,0.7366301120000001,0.0,0.0,0.423922842,0.9404983720000001,0.0632905512,0.0,0.0,0.453212238,0.51093292,0.0,0.0,0.0,0.39391168,0.24711571,0.0,0.0,0.0582178236,0.291742937,0.0783048799,0.0,0.0,0.10700271,0.17343468899999998,0.0,0.0,0.0,0.0804121095,0.0875739294,0.10701868699999999,0.302393443,0.539850602,0.538559366,0.271417739,0.00613029848,0.0,0.0192952516,0.0480546363,0.0054934830099999995,0.0,0.0,0.0213123422,0.0863427176,0.168765264,0.172344702,0.0350988662,0.0,0.0,0.0703088975,0.109416206,0.0,0.0159779508,0.35895298600000003,0.652777768,0.41141968799999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
2.12469956,0.0,0.0,0.0,0.0,0.0,0.0,0.1066473,1.42277795,0.0,0.187633837,2.00201968,0.515119477,0.0,0.0,0.276638295,0.663092236,3.26654078,0.0,0.532150126,1.70170407,3.88770918,1.56770315,0.589999147,0.0,0.0,0.0,0.580180955,1.98979902,0.0,8.43387547,5.67020129,0.0,1.30110341,1.1135531,0.547278473,0.0,0.0,0.26639383,0.487221694,0.0,0.0,0.48019424200000005,0.0,1.03825816,2.4083028,1.45585395,0.0,0.0,0.935709021,0.046720112599999995,0.724105309,0.0,0.36148854700000005,0.26157555,1.7431234,0.7495312190000001,0.0,0.0,0.0,1.32904683,0.984753585,0.0,1.0563178,2.03479677,0.0,0.420538646,0.0,0.42579921,2.41832886,1.43750276,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.25280119100000004,0.29144503899999996,0.0,0.0,0.022914559900000003,0.303205529,0.0,0.152469534,0.22901388399999997,0.24716745899999998,0.255355027,0.49523552600000004,0.636466035,0.466779912,0.8463380890000001,1.01433511,0.867905587,0.8774020440000001,0.937256497,0.7387267270000001,1.10986251,0.969662919,1.15756819,0.732453655,1.11096138,1.26495623,0.818818845,1.40912025,1.16592849,1.49813837,1.39036229,1.86419049,1.91829966,1.89138693,2.33357863,2.24323394,2.30794128,2.6107823,2.64188781,3.13088478,2.90167947,2.7695326000000002,2.94384595,2.72913607,2.65752084,2.3549736,2.37847601,1.72324186,1.91433186,1.52971646,1.38279366,0.669413676,0.484099774,0.534602933,0.41385329600000004,0.20233040100000002,0.412721385,0.120116233,0.11799241199999999,0.0,0.20614327300000002,0.180461746,0.0,0.0,0.264982215,0.356086963,0.352208681,0.0,0.211994028,0.0,0.0,0.255510271,0.15481973599999999,0.138913364,0.0,0.0,0.122886775,0.0,0.0,0.0,0.0667323425,0.0,0.231314062,0.0782469078,0.0,0.11832893900000001,0.10575567400000001,0.18212654600000003,0.0,0.0,0.0,0.18515768300000002,0.0,0.0,0.19168628399999998,0.0,0.023545466600000002,0.0,0.0,0.0,0.0,0.0,0.092703027,0.13478535,0.0,0.275771628,0.0,0.0,0.0648024594,0.337603455,0.021760905,0.247749638,0.158201154,0.0665177263,0.25871804600000003,0.00874653661,0.0,0.112872896,0.172495595,0.0322446251,0.0,0.0926977097,0.0,0.0,0.0,0.0560284838,0.18208067600000002,0.28482710899999997,0.0581661505,0.0,0.297057244,0.25964913100000003,0.0,0.0,0.320176709,0.0,0.0,0.0,0.0,0.0243891668,0.0,0.0,0.0,0.0109903291,0.0,0.0,0.0,0.0,0.06762184519999999,0.267841536,0.244819676,0.41481596200000004,0.500682938,0.44894440700000005,0.306400787,0.293112697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.000843048074,0.0910832622,0.264513489,0.115881654,0.0,0.0,0.178053975,0.0,0.0,0.0,0.0,0.0,0.36085282399999996,0.0,0.0414554789,0.0,0.0,0.0,0.0,0.14215996,0.0,0.0,0.0,0.0506717724,0.011306335700000001,0.40756544,0.357028396,0.0,0.0,0.0,0.011979228799999998,0.109444203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.353940064,0.13230579,0.559748895,0.592554931,0.10295370400000001,0.39150550700000003,0.0,0.21044648800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.230196226,0.339837732,0.9066586670000001,1.40440171,2.0269523,2.04792288,2.5298474,3.08882046,3.3718601,3.63911596,3.58805815,3.90938423,3.90451478,3.36041288,3.24675778,2.74265678,2.43689131,1.5534545,0.902858388,0.827820332,0.114175229,0.0,0.0,0.0,0.0,0.0,0.0,0.0883080242,0.0,0.0,0.518451808,0.278146997,0.696237201,0.18210222399999998,0.119018254,0.0770393515,0.17942568,0.337916314,0.5008791229999999,0.123669365,0.622887833,0.601692633,0.232370756,0.240073917,0.35281481200000003,0.597311302,0.169289222,0.568206813,0.222034548,0.258262832,0.0,0.538103749,0.0790585699,0.502231513,0.152107973,0.227019621,0.5520706879999999,0.496325746,0.580377178,0.813782241,0.458232863,0.971691443,0.7423305370000001,0.840952963,0.614092486,1.03787506,0.760639066,0.59101858,0.390111766,0.267346631,0.56731635,0.210499506,0.397145376,0.20683963800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
4.47235898,0.0,8.3668835,0.0,5.81317982,6.11255417,0.85075206,2.64400083,15.12449397,3.50390678,0.90307763,0.0,0.11304104,1.72451596,0.0,6.27835656,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.819034429,0.0,0.136821133,0.0715056003,0.7111742,0.008131444009999999,0.90677928,0.0174618704,1.53383803,0.0,0.0,0.0,0.0,0.412486849,0.0,0.0,0.0,0.8762734670000001,8.64775964,7.33562458,0.0,0.402863298,2.07816427,1.98953272,0.0,0.7871564120000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.45571264,2.16878073,3.13020275,4.35324786,4.23393951,4.49240017,3.4500451,2.1924262999999997,1.32251052,0.0,0.0,0.0,0.0,0.10278985,0.0,0.80713196,0.04921294,0.26590139,0.0,0.0,0.0,0.16079143,0.18098392,0.46411937,0.04582513,0.4591066,0.0,0.0,0.3688833,0.0,0.24433567,0.0,0.0,0.0,0.0,0.22642454,0.0,0.19736862,0.56556635,0.19378043,0.26593923,0.0,0.20124212,0.06323743,0.0,0.0,0.30038777,0.15303068,0.87590848,0.22126705,0.0,0.42006582,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.586852853,0.965428321,0.9717931320000001,1.31378625,1.026357,0.5681953129999999,0.143021334,0.0,0.0,0.156850146,0.0,0.413150625,0.296287685,0.05118040980000001,0.0,0.0,0.0,0.0347413269,0.0,0.0,0.218295773,0.0,0.0,0.0,0.290155805,0.377782666,0.0,0.13455397800000002,0.0,0.20508409,0.0,0.0,0.303997698,0.0830773922,0.0,0.0,0.161582853,0.30418314399999996,0.0,0.304123202,0.0,0.130541297,0.0,0.08837536970000001,0.06046811480000001,0.0766611897,0.122638426,0.0540279516,0.12205999199999999,0.277246765,0.0532419918,0.059640492,0.0522482988,0.0,0.0533358658,0.0,0.0,0.0475753854,0.297986748,0.647850612,0.36445909600000004,0.316610265,0.0,0.0,0.0,0.546053032,1.43457067,2.41998213,3.30535062,3.09765564,2.1441275,1.05607501,0.0,0.0,0.0,0.0,0.59896129,0.21576019,0.0,0.156047,0.0,0.0,0.0,0.391530651,0.496096769,0.0,0.270860225,0.0163310127,0.0,0.155428374,0.642937611,0.137207389,0.0284744846,0.0,0.0,0.0,0.0,0.491534462,0.0,0.26971043699999997,0.0,0.0187358074,0.0,0.188701357,0.15419860800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.237754274,0.436796202,0.523427121,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.240743281,0.0,0.187356601,0.0,0.171025917,0.0,0.135247067,0.0,0.99381791,2.39014119,0.998431893,0.34154730299999997,0.9219810959999999,2.01895793,2.74877705,2.52155671,0.18736126,1.30844996,4.90002322,5.09277566,4.40047448,3.15943777,4.07665107,2.42701801,0.32849213,1.39092917,1.88317523,3.31010934,1.2250914,0.278155499,0.9205158290000001,0.0,0.0874490876,0.0,0.45457956200000005,0.757124969,0.6628399660000001,0.620726449,3.24253762,2.43370787,1.42227608,3.43325146,0.6643710070000001,1.21425713,1.33020788,2.6058012,3.98701813,0.13372546800000001,0.86176762,0.476878429,0.6879070079999999,0.6890823629999999,0.0,0.47219777,0.0,0.22657406300000002,0.0,0.189515359,0.6254857739999999,0.0591555829,0.26108198899999996,0.0,0.281787947,0.0,0.0750050618,0.0186168579,0.0,0.231178844,0.0,0.33539286100000004,0.0,0.106055525,0.0,0.0,0.07389050259999999,0.0,0.16916391,0.0,0.16562439,0.0,0.261150122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
1.13788899,0.653053619,0.048326575499999996,0.0660285382,0.0,1.17930438,0.0,0.0,0.0,0.0,0.350078541,1.02801346,0.0877000028,0.989635156,0.868112287,1.09394633,2.12054686,0.68309797,2.03046692,1.59272928,3.29331044,4.38331677,4.06949892,4.56825542,5.86060482,1.90823145,2.68559987,3.0915803,0.43526369200000004,0.39779676700000005,0.0,0.0,1.79480072,0.0,1.57913942,0.562407992,0.333525028,0.0,0.312107168,0.92558459,0.00738810806,0.0,0.0,0.726000943,0.6568450060000001,1.2580577,1.06271197,0.0,0.0,0.38829758600000003,0.0,0.0,2.72841693,0.114781804,0.0,0.0,1.00468327,0.336368337,0.349716664,0.0,0.0,0.159106198,0.0,1.23126282,0.0,1.05505087,0.0,0.0,0.003956802410000001,0.0,0.0,0.14182121,0.0,2.41659147,0.33996186899999997,0.0,0.0,0.0256228433,0.0,0.757273205,0.0,1.97031954,0.0,0.0,0.68439298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.122021815,0.0,0.639207807,0.0,0.0,1.10302013,1.22460985,0.0,1.52833455,0.11910726,1.91304301,0.6033269529999999,0.0,0.508263127,0.0,0.0996538923,0.0,0.83139587,0.8663653640000001,0.0,0.0,0.0,0.363205569,2.00761229,0.361251959,1.43185748,2.2474175,2.25640679,0.20643380600000003,0.0,1.84279056,0.487387,1.01971527,0.549529429,0.0,0.0,0.449303719,0.0,0.729967472,0.0790706483,1.05698486,0.0,0.0,1.23675767,0.0,0.0,0.0,0.0,0.8791670970000001,0.0,0.398190379,0.659893992,1.15857961,0.0,0.326631267,0.0,0.16724796,0.799368744,0.0,1.37321333,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.408657537,0.114712782,0.0,0.0,1.16231101,0.0,0.0,0.0,1.69945791,0.0,1.34147295,0.0,0.6897002390000001,0.304504197,0.0984465519,1.51090146,0.0,0.909490998,0.583233048,0.0,0.0,0.405996669,0.573639748,1.0937861,0.0,1.06103699,0.0,0.0,0.0,0.0,0.0,1.23408686,0.0,0.16845732,0.0,0.0,0.5163519,1.83431342,0.0,0.790186653,0.952360555,0.0,0.0,0.914664021,0.36914980399999997,0.0,0.0,0.8888514040000001,0.0,0.0,1.36134612,0.0,0.580782521,0.0,0.448889805,1.30786541,0.173676155,2.5486952,1.67183331,0.0,0.650839439,0.0,0.0,0.438603399,1.25420389,0.864817583,0.0,0.745383795,0.311625505,0.860774961,1.21880467,0.9189098090000001,0.49940406299999995,0.493099794,0.11579328,0.0,0.0349086538,1.27179629,1.63170589,0.0,0.028243918,0.7404285279999999,1.29464438,2.27029409,0.0,0.3897761,0.0,0.0,0.0,0.575410965,0.0,0.0,0.164765503,0.325469988,0.0,0.0,1.05716616,0.388987122,0.6583981760000001,0.0,0.242572528,0.23410369600000003,0.0,0.0,0.0920763934,0.554242404,0.0,0.699235133,0.0,0.0,0.207659593,0.337183024,0.0,0.0,0.0,0.76514681,0.8989382229999999,2.11646311,0.889475366,1.63733915,1.61360421,2.70770759,2.52630672,0.43677256,0.022890112599999998,0.549401943,1.2319605,1.3026065,0.0,0.8982081270000001,0.352875706,0.8146179259999999,0.0514542345,0.72451456,0.0,0.0,0.0,0.266806035,0.7429512559999999,1.80646545,2.07217816,3.12140467,2.55612419,4.17702476,4.23638852,4.06019565,3.34888803,3.38198792,3.85666355,1.65116358,0.0,0.542949844,0.329117133,0.0,0.0,0.0,0.992229565,0.5131228870000001,0.0,0.0,0.693937803,0.212649723,1.18984202,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.22898394800000002,0.360395918,0.473460438,0.5593304029999999,0.6127881629999999,0.632300111,0.61978257,0.580114624,0.520450992,0.44940069899999996,0.37614424700000004,0.309563009,0.257449788,0.225859494,0.21864478699999998,0.237204429,0.28045368,0.345007679,0.425551959,0.51536032,0.606910143,0.6925396620000001,0.765090833,0.8184852570000001,0.848188493,0.851529346,0.8278541490000001,0.7785105920000001,0.706669952,0.617009541,0.515287756,0.40785152399999997,0.301119725,0.201086132,0.112881765,0.0404297136,0.0,0.0,0.0,0.0,0.0,0.0,0.00282535243,0.0340600225,0.0629544762,0.0862739047,0.101648961,0.107712425,0.104138656,0.09158835259999999,0.0715693651,0.046231147800000004,0.0181153691,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.011471476999999999,0.027080936099999998,0.038749763199999995,0.0457947899,0.048041883099999995,0.0458038447,0.0398101936,0.0310986179,0.020881341100000003,0.0104016381,0.0007961146330000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0005563501389999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00557055905,0.018743866100000003,0.0321161499,0.04425186019999999,0.0536898366,0.0591022897,0.0594509134,0.0541233622,0.0430345417,0.026680016600000002,0.00613311125,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0355207377,0.0703107454,0.101154089,0.124989055,0.139200666,0.141888643,0.132084641,0.10989594300000001,0.0765584686,0.0343894745,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0360579032,0.101818134,0.162202185,0.21158638100000002,0.245014549,0.25866968,0.25026964100000004,0.219348559,0.16739366,0.09781851789999998,0.0157669558,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0107681889,0.13095346900000002,0.247141345,0.34893134299999995,0.426509198,0.471515817,0.477845798,0.442306376,0.36507588700000004,0.249914203,0.104095484,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.303027765,0.6465781070000001,1.00090543,1.34499257,1.65753365,1.91845186,2.11039308,2.22008551,2.23946203,2.16645615,2.00540372,1.76700918,1.46786554,1.1295488999999999,0.777339553,0.438649116,0.141255957,0.0,0.0,0.0,0.0,0.0486153263,0.38756260600000003,0.8389008440000001,1.38504653,2.00223087,2.66186414,3.33221657,3.98030512,4.57386173,5.08325336,5.48322815,5.75437447,5.88420032,5.86776717,5.70784331,5.41457486,5.00470555,4.50040603,3.9277991,3.31528584,2.69178852,2.08502902,1.51995535,1.01741561,0.593158179,0.257211701,0.013670343799999998,0.0,0.0,0.0,0.0,0.0,0.0913433666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
1.07644284,2.25686224,4.65896631,0.261055627,0.0,0.5151952479999999,2.13860166,1.23662156,0.0583719704,0.0,0.0,1.85544138,0.0,0.0,0.0,0.072907238,0.905063884,1.51354278,0.8337413379999999,0.0,0.294967849,0.51581198,0.9334686809999999,0.297362631,0.0,0.0,2.08370956,0.725339869,0.0,0.0,0.0,3.85500159,1.01807438,0.0,1.15916096,1.11125397,0.0,1.0295450000000002,0.0323774389,0.0,0.0,0.0,0.0,0.8420189240000001,1.50882122,2.41501284,0.0,0.0,1.49998694,2.00608717,6.531757700000001,5.01460754,3.24002923,1.77782124,0.0,0.113008378,2.97302354,0.8325644590000001,0.0,0.7396211159999999,0.0,2.05893934,0.0,0.957065072,0.0,0.0,2.0496467000000003,0.0,3.32171556,1.80128092,0.0,0.431810518,0.0,0.0,0.952177158,0.102354875,0.0,2.64248784,1.20507952,0.0521624922,3.22637226,0.0,0.4704969,0.0,0.0,0.0,0.0583737725,2.66578868,2.61351287,0.0,0.38900253700000004,0.0,0.428096993,0.0,0.0,0.654326938,0.0,1.55062611,0.0,0.0,0.756708877,4.06114598,2.26358319,5.08444475,0.417680186,0.0,0.0,0.0,1.95678671,2.64538995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.074384027,0.14450560699999998,0.214247651,0.275793275,0.323681734,0.355188981,0.370188464,0.370592349,0.359539144,0.34052146200000005,0.316635333,0.290085906,0.262015417,0.232643374,0.201641884,0.168623773,0.133605687,0.097324044,0.061323500700000005,0.0277954671,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00509105848,0.016288988100000002,0.0225226783,0.0229990166,0.0183404216,0.0104379504,0.00203700352,0.0,0.0,0.00122366658,0.014032381399999998,0.032508485,0.054143060800000004,0.07565986849999999,0.0936830712,0.105445211,0.10938742,0.10552356199999999,0.0954871842,0.08224541490000001,0.0695338742,0.061126651399999996,0.060092393200000004,0.0681932584,0.0855558835,0.11068764800000001,0.140838599,0.17263450800000002,0.20284569800000002,0.229122911,0.250533701,0.26777122600000003,0.282975007,0.299186652,0.319545403,0.34639110799999995,0.38047155899999996,0.420439455,0.46277229,0.5021655429999999,0.532351805,0.547205934,0.5419286,0.5140728529999999,0.464198141,0.396001211,0.315871956,0.231935417,0.152745981,0.0858746218,0.0366583406,0.0073556306099999995,0.0,0.00114295222,0.0140143395,0.0285896119,0.0386296244,0.0398077502,0.030533468199999997,0.012178495400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0246869685,0.0511581396,0.06745326459999999,0.0692924949,0.0555325654,0.0286576076,0.0,0.0,0.0,0.0,0.0,0.0,0.0414322839,0.108750124,0.17614843300000002,0.232581465,0.268810132,0.279489239,0.264580279,0.229756337,0.185656999,0.14608239999999997,0.12544111900000002,0.135939492,0.185081955,0.274021193,0.397153474,0.543121327,0.6971050870000001,0.844010687,0.9719491729999999,1.07529968,1.1566793,1.22731211,1.30557028,1.41380514,1.5739311000000002,1.80250489,2.10619899,2.47856481,2.89880999,3.33299852,3.73767261,4.06546259,4.271873,4.32218057,4.19730265,3.8976144999999995,3.44399523,2.87581813,2.24609979,1.61449772,1.03921547,0.569072141,0.236982446,0.0558737557,0.0176732853,0.0954981656,0.248658307,0.429625959,0.591814101,0.6968905940000001,0.720454525,0.6551962370000001,0.511100644,0.312757663,0.0943269692,0.0,0.0,0.0,0.0,0.0,0.0,0.11538122199999999,0.307174433,0.467816785,0.57126245,0.60243435,0.559615188,0.454472549,0.30977446,0.155246269,0.022324836400000003,0.0,0.0,0.0,0.118228233,0.305956781,0.522938323,0.739080757,0.924615787,1.05478289,1.11354631,1.09577578,1.00759957,0.8649528609999999,0.690640037,0.510458404,0.34905716,0.226213754,0.154104536,0.135951643,0.16618095,0.231970822,0.31585156600000003,0.39886541299999995,0.463737436,0.497543254,0.49347762100000003,0.451503782,0.377863425,0.28361587,0.182521851,0.0886701198,0.0142548017,0.0,0.0,0.0,0.013149441599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.21205641,0.29971317,0.27000630000000003,0.0,0.0,0.47883234,0.21786056,0.45398913,0.19520312,0.74697991,0.52646887,0.13902587,0.0,0.40239481,0.5244159,0.12366327,0.47226294,0.67211916,0.27054367,0.36685275,0.59124971,0.69230441,0.30787476,0.79036969,0.20564756,0.81557432,1.11525891,0.68883764,0.86209699,0.86955094,0.19813199,0.61944016,0.05922262,0.08828953,0.0,0.0,0.0,0.0,0.0,0.17430465,0.40036515,0.48755949,0.0,0.16787157,0.14242372,0.30918416,0.29739644,0.0,0.32223114,0.62946775,0.30041757,0.0,0.0,0.39938236,0.92452549,0.0,0.0,0.30675027,2.59976632,4.43775067,3.52222923,2.04665662,0.37788556,0.0,1.03585184,0.86205971,0.0,0.58935445,0.77445859,0.85063775,0.07016741,0.0,0.13066355,0.6768625,0.62178448,0.0,0.0,0.58790847,0.0,0.0,0.06858178,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.132190724,0.0,0.0,0.030327228799999998,0.598980561,0.17661612,0.580721874,0.0,0.0,0.390951383,0.52174692,0.7930454920000001,0.0,1.66935244,0.0,0.151485634,0.9723322209999999,0.41558535700000004,0.5865328670000001,0.0,0.374527792,0.326073553,0.0802337258,1.19428967,0.5735059029999999,0.0,0.0,0.0,0.0,0.41972413299999994,1.40479483,0.0,0.0,0.0,0.26169858,0.0,0.590438992,0.0,0.773311485,0.0,0.0,0.851021778,0.013123369499999999,0.0,0.0654809625,0.842235295,0.052559675800000004,0.0294581048,0.29980233100000003,0.0,1.08782489,0.0,0.0,0.31284005800000003,0.0,0.0,0.0449735056,0.24858954800000002,0.0,0.0,0.0,0.0,0.0,0.6285958629999999,0.0580824423,0.172116097,0.0,0.025390023799999998,0.0,0.0,0.0,0.0,0.77486868,0.0,0.0,0.0,0.0,0.0,1.17673553,0.529692313,0.369703502,0.36501455299999996,0.13499677300000001,0.0,0.933241386,0.18644853,0.142950158,0.890355054,0.69158354,0.565805646,0.325007842,0.166103806,0.44592257799999996,0.225804956,0.475096932,0.247868913,0.65854608,0.308607697,0.829201289,0.988416593,0.47096641,0.0,0.0036197229100000004,0.0022639195100000002,0.51497653,0.271020146,0.0,0.631407234,0.8170360879999999,0.0,0.0,0.0,0.420312571,0.286943148,0.556005874,0.0,0.9688739940000001,0.0,1.00966937,0.0,0.257682998,0.441240034,1.25937952,0.33660646899999996,1.99887856,0.8234062390000001,1.03882888,1.79052849,1.94213116,1.75923643,1.35464886,2.89449807,2.65138633,3.48391169,3.20850398,2.90770712,2.40183921,3.2896919999999996,2.40241121,2.76248308,2.48350748,1.86624443,1.50420322,2.50371606,2.61973527,2.04800778,2.30836857,2.01063435,1.24538189,1.71495281,2.26869829,1.006153,0.895189096,0.444622248,0.69234994,0.25459172,1.11756856,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
1.80248757,1.44073019,1.42860148,1.3874027,1.00225346,0.307358099,0.0,0.0,0.0,0.170619773,0.452836048,0.328785753,0.0,0.0,0.0,0.0,0.29863285300000003,0.34869546,0.09607976160000001,0.0,0.0,0.0,0.16045315,0.329084661,0.20697329399999997,0.0,0.0,0.0,0.026224652200000004,0.274075358,0.279366035,0.0389324525,0.0,0.0,0.0,0.191963441,0.323603476,0.170381167,0.0,0.0,0.0,0.09507892230000001,0.469258674,0.621618164,0.49164348799999996,0.229029927,0.0499998855,0.0538568504,0.15717763,0.19304316300000002,0.0769166112,0.0,0.0,0.0,0.0808765365,0.220062617,0.166408109,0.0,0.0,0.0,0.0,0.19941922899999998,0.236557178,0.06297358110000001,0.0,0.0,0.0,0.13453859699999998,0.274348779,0.172737246,0.0,0.0,0.0,0.0312143376,0.270700798,0.276348969,0.033211117400000004,0.0,0.0,0.0,0.2174739,0.36072527200000004,0.184894047,0.0,0.0,0.0,0.10447468300000001,0.41297181,0.367097193,0.0,0.0,0.0,0.0,0.417724414,0.5955092479999999,0.237449317,0.0,0.0,0.0,0.34228965299999997,0.965496895,0.786570216,0.0,0.0,0.0,0.0,2.72528485,5.54589282,6.97438711,6.27619348,3.87028587,1.03569136,0.0,0.0,0.0,0.293662642,0.7314408609999999,0.486386266,0.0,0.0,0.0,0.0,0.240835178,0.250817171,0.0631047516,0.0,0.0,0.0,0.027848258900000002,0.019346200900000003,0.0,0.0188289039,0.11526293300000001,0.140815385,0.0,0.0,0.0,0.488080558,1.88303841,3.55073244,4.75469726,4.91265297,4.01272,2.66378325,1.71279608,1.68783369,2.46588437,3.40189485,3.81169946,3.44241015,2.58931165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
1.05261674,1.90871863,1.91231855,1.87447427,2.3904259999999997,1.40412539,1.10850144,0.71411413,0.91960614,0.46762991,0.54229986,0.71418209,0.56211478,0.11558322,0.0,0.0,0.0,0.15705235,0.68037395,1.82553706,2.30641636,1.89750427,1.76783851,1.60485578,0.06878184,0.53119056,0.0465368,1.29235616,2.26798746,3.51787024,4.7674367,4.48428449,4.05989794,3.62724625,2.09808262,0.96159052,0.0,0.10374781,0.0,0.60087042,1.10710836,0.70633713,0.98676037,0.94470811,0.97416368,0.54022059,0.81445354,0.2620572,1.10111643,0.42176001,0.41379748,0.76996418,0.64893274,0.28631325,0.94838549,0.73501215,1.11314449,1.09681756,0.65165194,0.36148143,0.24452510000000002,0.0,0.19171655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.27179559999999997,0.22499148100000002,0.198055962,0.0,0.12860717300000002,0.34575776700000005,0.0,0.0746508265,0.0,1.12636124,0.22092994,0.88502183,0.285608814,1.19349423,0.467586279,0.589303293,0.0,1.07484207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.596882771,0.0,0.0,0.0,0.0182072378,0.148797564,0.0,1.0528816,0.8232337209999999,0.264798254,0.0,0.0,0.495062501,0.0,0.0,0.0,0.0,0.145467958,0.0,0.0,0.265183271,0.40374336200000005,0.282249791,0.721827819,0.0,0.552489746,0.0,0.000600441589,0.25672986,0.0601772354,0.30030187,0.509068062,0.0,0.34503561899999996,0.7727641409999999,0.0,0.0,0.307015303,0.0,0.27197082100000003,0.305510487,0.0,0.0,0.0,0.46018679,0.0,0.0,0.170368042,0.0996449038,0.0,0.322159897,0.0,0.038690009,1.69560914,0.0,0.359276483,0.0,0.158701862,0.46760722899999996,0.008924607729999999,0.495785222,0.0,0.0,0.0,0.0,0.0576275595,0.0,0.193916975,0.0,0.466553977,0.86882324,0.0,0.0741157776,0.0,0.8203734690000001,0.0,0.243896223,0.331349415,0.46415672799999996,0.5380283370000001,0.0,0.0939454366,0.0,0.66598331,0.40002143799999995,1.16904711,0.36691680200000004,0.0,0.132025115,0.39001097799999995,1.00217506,1.45907161,1.56953649,2.66132937,2.22589643,2.34192688,2.57580604,2.51373879,2.62956764,3.0033008999999997,2.6098543999999997,2.4436183,1.90760758,1.04373307,1.24878701,2.16626961,1.35230448,0.0,1.3396297,0.137452309,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.1345319,0.59186894,0.6353291999999999,1.17056446,0.0,0.25311909,0.0,0.46681718,0.0,1.95946287,1.8448651999999999,2.17934313,2.21403683,0.0,3.48279398,0.32754779,0.0,0.41015573,0.0,0.74915899,1.37461144,1.77140671,0.0,0.92064228,0.0,0.0,3.4326562999999997,0.0,0.67354217,0.0,0.0,0.0,1.18999197,0.0,0.0,0.04123229,0.0,0.58340971,0.0,0.0,0.0,0.0,0.93084515,0.0,0.0,0.0,4.33626616,0.42321799,1.11993317,0.46598287,0.0,1.01411218,0.02003767,0.23185324,2.7530447000000002,0.0,0.0,1.21933898,0.0,0.67167254,0.0,2.06317882,0.20066825,0.0,10.47026637,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
7.59708584,3.32177046,1.23251288,0.0,1.03406755,0.33643496,12.93368361,1.3079083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
1.48558542,1.21068875,2.18247927,2.31034352,3.4787646,2.76662937,0.637337767,0.0,0.736443414,0.552947648,0.0,0.748922949,0.0,0.360907921,0.258798501,1.00636122,1.26646916,1.30735804,0.171480032,0.0,0.0,3.09683156,9.35206353,13.0483476,10.4041554,5.57070536,1.86609716,0.0,0.0,0.112171141,0.833336705,0.37343476,0.048700451500000005,0.618682968,0.0,0.0,0.0,0.779682749,0.12363323699999999,0.0,0.43511178899999997,0.0,0.0,0.9601473070000001,0.060736039400000004,0.598883911,0.849346328,0.0,0.0,0.22231775899999998,0.0,0.219941864,0.0,0.93132254,0.0,0.304843728,0.0,1.26003296,0.251620401,0.0,0.348335881,0.555149412,1.00182613,0.0,0.0,0.0,0.0,0.0,1.47078111,0.658579609,3.54865238,5.18794449,4.27853823,2.75656382,1.98483102,0.0,0.630217082,0.0,0.007956682540000001,1.29788663,0.0,0.0,0.0,1.36830878,0.906947741,0.0,0.0,0.0,0.0,1.781391,0.0,0.79938351,1.86425422,0.501877941,0.0,1.17965539,0.546672995,0.0,0.0,0.0,0.0,0.030600344100000003,0.0,0.0,1.1571,0.0,0.252288229,0.0,0.0,0.639448675,0.239393551,0.730477785,0.0,0.0,0.0,0.0,1.02664023,0.0,0.105917499,0.0,0.0,0.533245917,0.348117222,0.0,0.0,0.0,0.690837605,1.03754418,0.20133831300000002,0.0,0.765493035,0.524558083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.162902627,0.0,0.783385911,2.16582968,4.97992824,9.41115371,4.30074742,0.181130745,0.608404455,0.389941308,0.855531073,0.0465570192,0.433629879,0.34167257799999995,0.8642520770000001,0.18902421,0.31652858899999997,0.0,0.55545104,0.404637807,0.042156316799999996,0.0,0.05509181269999999,0.0,0.0719459638,0.0,0.106334317,0.0,0.66276396,0.520163238,0.199130002,0.0193430742,0.08121929230000001,0.17604173,0.23451304399999998,0.484751651,0.19790694,0.160053039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.698740355,0.587607765,0.812571908,0.790948433,0.7159172970000001,0.7294515359999999,0.405922596,0.736830144,0.6550448520000001,0.264073913,0.0,0.0,0.17831997600000002,0.120727794,0.0,0.17982889,0.42879431799999995,0.10780050199999999,0.26217789,0.0,0.32149935399999996,0.35598795299999997,0.0,0.0,0.0,0.47409099200000004,0.0770579802,0.453251908,0.213275178,0.106232094,0.0,0.659783472,0.601795869,0.0,0.262398621,1.55738384,3.23154132,4.78076933,4.97831258,3.74099627,1.94537379,1.11027217,0.619674783,0.9938017920000001,0.8631742370000001,0.813287042,0.38439489299999996,1.22454976,1.47326568,1.77583858,2.14609205,1.89064085,1.52918894,1.20911275,1.19318735,1.01301973,0.765446643,0.296556156,0.831129997,0.501884536,0.1927219,0.569819717,0.268179086,0.8225438970000001,0.746326667,0.81637427,0.823113365,0.819280068,0.0348017017,0.0,0.0,0.19670982899999997,0.572165867,0.6807286220000001,0.12419342900000001,0.103973786,0.0,1.25605129,2.10602812,1.75762396,2.00699502,0.770853452,0.0,0.0,0.0,0.262498927,0.7714550990000001,0.398297831,0.601578231,0.37475157,0.69687486,0.562923097,0.34431008,0.0504337005,0.24140520699999998,0.451771087,0.0,0.397799771,0.0,0.0911546077,0.0,0.0858288665,0.0,0.0,0.05163114480000001,0.165487802,0.0,0.0,0.337121556,0.0,0.46592079299999994,0.0,0.0,0.0,0.407681454,0.0,0.111898855,0.490782614,0.24099921800000002,0.28986911600000004,0.0,0.127952612,0.0,0.0,0.0285548971,0.0125406653,0.0,0.0,0.44532123700000004,0.0,0.0,0.0,0.0,0.447652129,0.306853883,0.0,0.415394986,0.0130604853,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
1.72821567,1.49446536,1.27693506,1.0784288,0.900997217,0.7459277670000001,0.61376069,0.504328886,0.41681910299999997,0.349851134,0.301571204,0.26975537899999996,0.251918646,0.24542531,0.24759652,0.255811069,0.267596067,0.280704674,0.293178741,0.303394924,0.310093592,0.31239058,0.309772531,0.30207722800000003,0.289460815,0.272354293,0.25141194,0.22745451600000002,0.201410135,0.174255627,0.146960994,0.12043926,0.0955036248,0.0728333845,0.0529495492,0.036200614900000004,0.022758408900000002,0.012623464499999999,0.00563895438,0.00151185719,0.0,0.00014150584300000001,0.0018898613100000003,0.00454428968,0.007582144599999999,0.0105266824,0.0129705957,0.0145940645,0.0151766639,0.0146028322,0.012860958,0.0100364866,0.006299748929999999,0.00188946763,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.005325018220000001,0.0103291471,0.0147363841,0.0183078185,0.0208549923,0.0222500886,0.022432413199999997,0.0214108585,0.0192622738,0.0161259055,0.0121942947,0.00770121772,0.00290741962,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00272850368,0.005762117099999999,0.00822856479,0.010012174399999999,0.0110490798,0.011330402199999999,0.010901645500000001,0.00985830811,0.00833795248,0.00650921253,0.0045584275,0.0026747695399999996,0.0010348614,0.0,0.0,0.0,0.0,0.00010121760399999999,0.0013511396300000002,0.0028093192699999996,0.00426637204,0.00549080801,0.0062497275500000005,0.00633241481,0.00557558866,0.00388887266,0.00127891462,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00255182633,0.0195959949,0.043564981100000004,0.0753057358,0.11548916599999999,0.164555421,0.222663538,0.289648153,0.36498586200000005,0.44777359,0.536720933,0.630157996,0.72605965,0.8220865079999999,0.915642211,1.00394591,1.08411813,1.15327747,1.20864516,1.24765376,1.26805615,1.26803049,1.24627705,1.20210264,1.13548873,1.04713991,0.938509768,0.81180206,0.669945911,0.516544695,0.35579920299999995,0.192406689,0.031438366,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20661878600000003,0.465464664,0.7511458459999999,1.05824254,1.3806737,1.71186076,2.04490787,2.37279283,2.68856242,2.98552598,3.25744075,3.49868311,3.70440008,3.87063643,3.99443332,4.07389569,4.10822647,4.09772692,4.04376381,3.94870483,3.81582512,3.6491885,3.45350797,3.23399047,2.99617147,2.74574524,2.48839644,2.22963866,1.97466505,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.768315263,0.254915054,0.580191899,0.0,1.01964585,0.0,0.0,1.23079019,0.203116706,0.0,1.75810105,0.0,0.0,0.0,0.0,1.11237534,0.934666077,0.0,0.0,0.0,0.8292506159999999,0.0,0.0,0.958971108,1.15244857,1.31475847,0.0,1.6717045,0.0,0.0161735155,0.277652883,0.45160563600000003,0.0,0.0,0.872593562,1.04066855,0.0,0.0,0.221129267,0.459775881,0.442409583,0.0,1.74891637,0.0,0.616349441,0.0,0.0,0.820284114,1.35393339,0.638459277,2.04461707,0.0,0.0,0.329174895,0.80649678,1.13724041,3.07656302,3.1453432999999995,2.06583614,0.0,0.0,0.707804801,0.50228256,1.35103298,1.09550219,1.44997299,0.0,0.22210987100000001,1.93606648,0.24267465100000002,0.0,0.6663172079999999,0.0,0.0,1.5054846000000002,0.144317143,0.971931832,2.57034541,1.76504766,0.0,0.230077755,0.0,0.0,0.0,0.7521207520000001,0.609697354,0.0,1.66192614,1.69474721,0.0589529158,0.0,0.477740196,0.146263496,1.76706157,0.64077615,0.0,0.584476239,0.318997572,0.40673978,1.39841678,0.118757032,0.0,0.0,0.942868684,0.208950055,0.0,0.0,2.80873478,0.650177246,1.71644303,1.2226021999999999,3.37971821,2.26157158,2.04484491,5.33800483,4.15631415,3.73997098,2.73325381,0.54021388,0.7181155909999999,0.129314621,1.79118836,1.1225265,1.3826592,0.0,0.225884372,0.606718375,0.842796723,0.156586136,0.0,0.0197275558,0.0,0.0,0.0,0.979203258,0.0,0.0,0.0,0.0,0.0,0.0,0.140381979,0.426128953,0.0,0.275798192,1.17762505,2.19736818,0.0,0.0,0.0,0.0,0.0478178246,0.637687519,0.0,0.97995517,2.19667314,1.37158324,0.0,0.0,0.393303391,1.96414815,0.973515114,1.42195911,0.0,0.960887907,0.27691882,0.564797819,0.0,1.99887395,1.96023336,0.0,0.615234395,0.186863148,1.65870332,0.0,0.0,0.0,0.516209259,1.21741829,1.12273635,1.41870352,0.89338014,1.61780558,0.0,0.0,0.9518388409999999,0.37172665200000005,0.45373261600000003,0.0,0.8736690970000001,0.0,0.84122535,0.0,0.103610051,0.354514476,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.27504354,1.59704331,0.0,0.823562695,1.8329811000000003,0.0,0.0,1.53629039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.685712083,1.72558886,0.0494424931,0.0,0.00111678091,0.00241520674,0.6627468089999999,1.3866803,0.0,1.25572826,3.24566402,5.8619796,1.44957089,0.0236346619,0.719083282,0.0,0.12094767,0.0,0.0620916925,0.0,0.00489860213,0.024562607599999998,0.0,0.49895074100000003,0.404724773,1.98593887,2.45918511,1.49641338,1.13301136,0.0,0.168643337,0.0,0.0865407014,0.0,0.0334920388,0.006490471120000001,0.268697334,0.570334288,0.16803297899999997,0.08907887130000001,0.0,0.441735789,2.16272885,0.0,0.153508038,0.0,0.0569674076,0.0,0.19672395399999998,0.0,0.004722435850000001,0.00382651458,0.0,0.009960167459999999,0.0,0.0,0.796043382,0.173174936,0.0,0.10711059199999999,0.0,0.0946290275,0.0,0.0437837015,0.397494368,0.7831596140000001,0.33382439199999997,1.48685533,1.43111563,1.6715295,0.520175718,0.03498692,0.0,0.0644770042,0.0,0.07828240269999999,0.0,0.0811615743,0.0,0.0760119607,0.0,0.0568042862,0.0,0.0,0.331231767,1.91053957,0.839941357,0.15049546,0.0,0.0929438217,0.0,0.0830371478,0.0,0.0591087448,0.0,0.605643248,0.0497297775,0.07091855150000001,0.0,0.78393181,1.68616101,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
1.60276531,1.60276385,0.07264832,0.77618712,0.0,0.6391351,0.0,0.84448098,0.38610353,0.57621966,0.0,1.14900286,0.02129497,0.0,0.0,0.0,0.64958635,0.13864465,0.0,0.0,0.1903695,1.00437582,0.0,0.47180091,3.97774826,6.732224799999999,11.27156995,10.98465852,8.89782475,4.67181234,4.1148248,3.95500521,2.45022875,1.76080237,0.73688045,0.09244930000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
2.32188455,0.0,1.07624341,2.61445805,1.07547475,0.929977295,1.29894522,1.07314209,0.0,1.61892477,0.0,6.76862882,5.44688807,9.87083533,4.84337274,3.72060296,0.0,0.0,0.0,0.7744568620000001,1.5117763000000002,0.0,0.0,0.0,0.0,1.4890809999999999,0.571374634,0.863721748,1.58670141,0.0,1.53507315,0.90498048,0.0,1.20198439,0.242531408,0.0,0.0,0.854390825,0.30691033,0.0,0.21633723600000002,0.9039317640000001,0.0,0.0,0.267485054,1.29486292,1.89176416,0.0,1.72752106,4.99807873,0.0,2.40034703,1.00211321,0.20320647100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.9071017920000001,0.9030384709999999,3.71448363,2.66263974,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.37418437,0.7874063809999999,1.85127965,0.42457838299999995,0.592402324,0.301159169,0.0,1.08561485,0.0,0.031514623900000004,0.537526908,0.0,1.49804559,0.538702795,0.0,0.521224052,0.21685864800000001,1.61010839,0.163546351,0.0,0.0,0.0,0.44488053299999997,0.0,0.855192208,0.0,0.0,0.0,0.0,0.0,0.944905873,0.9828960940000001,3.60158421,0.336599054,2.94988324,0.595993994,0.778865129,0.0,0.0,0.792431942,2.2527822,1.59223234,0.0,0.656996727,1.94662741,0.0,0.276132917,0.8154274140000001,1.71714648,0.0,0.0922143118,0.37924309,1.42957278,0.0,1.10082336,0.0,1.55176308,1.25310149,0.8751912829999999,1.59025929,0.0,2.30952703,1.28649538,0.0,0.0,0.0,0.11555542199999999,0.0511683916,0.925210237,0.0,0.0,0.0,0.153358432,0.0,0.0,1.35030669,0.0,2.5812287,1.63220335,0.0,4.380602400000001,2.77539933,0.0,0.0114394852,0.0,2.30417348,1.965602,2.8405411,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
1.16549873,6.79116832,4.87467459,0.0,0.536333962,0.0,0.242743018,0.355910085,0.0,0.825821017,0.0,0.756987724,0.37288780299999996,0.0,0.220389361,0.0,0.0,0.0,0.0,0.0,0.0565315174,0.0,0.7341928059999999,4.40767981,2.20473861,0.874863497,0.0,0.0,0.0,0.0,0.222300379,0.0,0.00208261571,0.744286862,1.20710257,0.0,1.55796566,0.431182165,3.30080683,6.12548516,0.496697767,0.0,0.22079967600000003,0.0,0.986989218,0.602612944,0.678099583,0.627110379,0.44878268200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
3.21983901,1.68882374,2.6031977000000004,2.97874506,1.94000646,1.75783973,2.35149792,1.44772913,2.12312781,1.80909271,1.73915119,0.9995664000000001,1.02473152,1.28182303,1.22756639,0.59562414,0.43537373,0.91290142,0.72823874,1.29768045,0.1991164,0.20739693,0.0,0.0,0.0,0.35433374,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03471847,0.0,0.0,0.0,0.23291695,0.80678859,0.02999544,1.3427815,0.0,0.04562814,0.0,1.21350495,0.23149055,0.4674932,1.81846345,1.21343031,1.65855318,2.06544515,1.5440983,1.8249644,1.63053026,0.99022187,2.24221956,3.09223164,1.77344203,2.46797306,2.07704446,1.81192903,2.36668271,2.90281063,2.39431765,2.29822111,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.203618653,0.0,0.163292145,0.0,1.20225047,0.034565906699999996,0.027410571,0.0,0.5373524000000001,3.39098275,1.42517201,0.746441659,3.55377332,0.789655648,1.83704488,4.09179467,4.1669321,0.00203908421,0.651239084,0.194409904,1.87340422,2.72158055,1.58956205,1.99474457,1.33277507,0.751315838,0.011525366200000001,0.0325494882,0.0761041875,0.0268740538,0.0,0.0112243399,0.0,0.00307988413,0.0,0.0,0.0370607109,0.151288481,0.0,1.10696982,0.118343514,0.8479706109999999,5.10897167,2.63885506,0.39435266,0.0,0.0709833134,0.0,0.0884833542,0.0,0.104335694,0.0,0.119394506,0.0,1.71746089,1.14480528,0.7298829579999999,0.28037751,0.0,0.0246387431,0.0,0.0,0.0228504288,0.0,0.0451927003,0.0,0.25201806,0.63435304,2.61974174,2.02802339,1.50977418,0.0,0.0,0.021831142799999998,0.00819632767,0.574593001,3.74298295,3.63973153,3.13762746,2.87553601,2.14670081,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.417433934,0.050960444699999996,0.40923020200000004,0.0,0.236618423,0.0,0.523287273,0.600188984,0.16758694400000002,0.0771962804,0.644293364,0.212049068,0.14300012199999998,0.6297107,0.09114562179999999,0.18564287399999999,0.294246112,0.774353407,0.762767255,0.763460756,0.336876114,0.508839034,0.38089865700000003,0.0992844318,0.0,0.318632925,0.0,0.0862346382,0.0,0.297931287,0.0410770209,0.17154467899999998,0.264462601,0.109873094,0.0813701871,0.0,0.0,0.482134406,0.0,0.221423075,0.0,0.0,0.44732541200000003,0.503756581,0.197646858,0.0,0.0,0.08073212889999999,0.0,0.242933502,0.0516996759,0.0,0.0,0.0,0.23985958300000002,0.342250416,0.40234532100000003,0.0,0.22198083899999999,0.0,0.31988910600000003,0.587850646,0.41544570299999994,0.0,0.0,0.217168945,0.160981878,0.44259110700000004,0.35982068,0.0,0.0,0.25288757100000003,0.0,0.24270503300000001,0.212248315,0.0,0.246933822,0.0,0.0,0.17225262600000002,0.253919361,0.0717030319,0.0,0.485467224,0.519456758,0.0,0.471931363,0.0,0.12391365,0.0,0.5351633960000001,0.0,0.0288969106,0.0,0.0,0.0387282108,0.0272292161,0.155097144,0.0,0.0,0.171657998,0.33352853,0.18310267600000002,0.0,0.24623310699999998,0.251493158,0.548310428,0.293495981,0.0723493937,0.392857044,0.476569426,0.641695572,0.16514327199999998,0.00722686262,0.0,0.0,0.0,0.0,0.0,0.0867891273,0.0,0.0,0.0,0.0,0.0,0.271007138,0.30824509899999997,0.0,0.0,0.38095059,0.75750463,0.73432561,0.418541357,0.0864963898,0.471589794,0.0,0.13400656800000002,0.0,0.147569321,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.386091135,0.9857286259999999,1.38195894,1.72662528,2.11979845,2.69964682,2.79451294,3.73981812,4.17952667,4.15694712,4.58148654,4.87045003,5.15703857,4.9435616,4.49490969,4.87608504,4.59213546,4.162518,3.71818375,3.19635199,3.45754969,3.0613312,2.71831507,2.20858254,1.35180261,1.59034374,1.46164072,1.06731619,0.975658797,1.05985718,0.357882335,0.7460465999999999,0.26591588,0.8411939540000001,0.81043216,1.18805588,0.5052423739999999,0.583651823,0.7192785709999999,0.60022616,0.7698660009999999,0.9077533590000001,0.92292959,0.468718732,0.767307464,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.21348203,0.5431473720000001,0.533953634,0.522636193,0.724741266,1.0561321000000001,0.6070183170000001,0.607640142,0.434017961,0.373451605,0.658708485,0.143561508,0.29027629,0.22700333,0.336018109,0.284060606,0.0,0.0,0.331673103,0.0838707503,0.314124847,0.150266619,0.23997629199999998,0.172734169,0.10816742900000001,0.34530200899999997,0.412514571,0.0,0.3563717,0.0894955399,0.0,0.0,0.0217681706,0.0,0.0,0.0,0.0,0.30952767,0.0,0.145049829,0.37073521600000003,0.198576328,0.0,0.0,0.062938198,0.234560795,0.14610257199999999,0.23667020600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012309373200000001,0.311898571,0.19224033699999998,0.0,0.22275029300000002,0.057472068499999994,0.332893717,0.202449696,0.0,0.273043086,0.010187801,0.42769739799999995,0.195610178,0.510929524,0.21645106100000003,0.7528722170000001,0.979082824,0.653203459,1.09531468,1.04327092,1.5422569,1.20680139,1.1587305,1.59554665,1.30591236,1.06356275,1.41620647,1.36190094,1.29681425,0.639479334,0.8384661720000001,0.43299420899999996,0.392707962,0.326511341,0.11324064800000001,0.285129571,0.277182541,0.7420422729999999,0.892946467,0.650719803,0.871318775,1.20979755,1.4199371,1.26155741,0.984813115,1.32958281,0.9401759059999999,1.22580232,1.09210313,0.7739821990000001,0.460622656,0.21832938100000002,0.0,0.0,0.0650002849,0.0,0.0,0.0,0.0,0.200072133,0.46225470799999996,0.0,0.10481773900000001,0.516515779,0.420103799,0.417594742,0.32776418399999996,0.323687925,0.372597061,0.18148650100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.39938889200000005,1.0300124,0.986708747,1.86377425,2.00252293,2.72962925,2.90368147,3.39841481,3.68182901,3.28187255,3.69018803,3.4427332,3.03962123,2.32462387,1.78590662,1.64013735,1.07608019,0.968163003,0.590339364,0.19034378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
9.57450135,2.36383141,0.0,0.0,1.03324075,0.9856029479999999,0.0,0.0,1.36053096,1.79148119,0.298935656,0.0,0.0,0.677693364,0.644663902,0.0,0.0,0.13622244,0.666244335,0.0834743767,0.0,0.0,0.47080443899999996,0.399324935,0.0,0.0,0.155490338,0.526226195,0.0172958627,0.0,0.0,0.47240676200000004,0.358103172,0.0,0.0,0.300762326,1.16273547,1.05372273,0.34769124700000004,0.0,0.119727871,0.10927624300000001,0.0,0.0,0.164488534,0.524395439,0.5286778320000001,0.495886547,0.6947388179999999,0.7390814309999999,0.241454759,0.0,0.0,0.230292489,0.378153532,0.0,0.0,0.0,0.45277518,0.187211656,0.0,0.0,0.7444694759999999,1.54113709,1.2859856,0.567427886,0.363270825,0.681477278,0.892879607,0.907797885,1.11619935,1.36048507,0.9819911929999999,0.052268248600000004,0.0,0.0661053315,0.553686503,0.11725865099999999,0.0,0.0,0.669068212,0.981933643,0.130691261,0.0,0.156509708,0.8103914320000001,0.08960042050000001,0.0,0.0200254158,2.40361518,2.84497937,0.0780216868,0.0,1.2976127,8.53936496,12.7769455,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.0219040069,0.320850764,0.602664132,0.812611636,0.9059295629999999,0.857985659,0.671720435,0.380786016,0.0474628257,0.0,0.0,0.0,0.0159921976,0.695558858,1.69332043,2.95751164,4.39522623,5.88245488,7.27916399,8.44726475,9.26881809,9.66174146,9.59064497,9.07117038,8.16721504,6.98152675,5.64117417,4.28016196,3.02185001,1.96379221,1.16714818,0.65202741,0.399138238,0.35710329700000004,0.45393704100000004,0.610598278,0.754318136,0.829581847,0.805164384,0.676381013,0.462573458,0.20065817100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.053818194400000005,0.21735863600000002,0.327190865,0.366077572,0.331398135,0.23468814100000002,0.0985558025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.044447597199999994,0.149564578,0.22030071199999998,0.244613838,0.21997962199999999,0.153406858,0.059644393,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.041682799300000004,0.12332915,0.17986891800000002,0.200728685,0.18203861600000001,0.127167391,0.0459985959,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0768856459,0.233324974,0.39551749799999997,0.5478540679999999,0.6760794170000001,0.768732118,0.818156895,0.8210490340000001,0.778546623,0.6959208179999999,0.581928996,0.44789784200000005,0.306602625,0.171013445,0.052993273,0.0,0.0,0.0,0.0,0.0,0.0,0.0381710211,0.0884414776,0.12152964699999999,0.130727734,0.113871968,0.0737802206,0.0178269882,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0526623195,0.115323563,0.157391963,0.16924143,0.146895259,0.0931362058,0.0173083084,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0847786722,0.175049996,0.234655015,0.249387825,0.213374658,0.130795364,0.015663048500000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.148451538,0.293122076,0.39007625700000004,0.41622069,0.361178261,0.230332879,0.044945715,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
7.85329799,3.85229913,0.0780789323,0.0,0.00130617413,0.927057786,0.332175796,0.0,0.24084014199999998,0.175919274,0.151333701,0.680518924,0.0,0.022617519500000002,0.0,0.0,1.32670785,0.0,0.47986231700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0651044829,0.0,0.0,0.0,0.340528015,0.9051535709999999,0.14366921300000002,0.0,0.0,0.0,0.0,0.451421045,0.0,0.224188539,0.0,0.6725467140000001,3.13262526,2.8210014,3.69662293,2.4075224,1.64991417,0.38730139799999996,0.0,0.0,0.9156217090000001,0.0435075272,0.11668463300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.77608865,0.6448295070000001,0.426225509,0.0,0.237414049,0.000599763846,0.0768831021,0.262581556,0.34134085,0.0,0.21292927399999997,0.0,0.0,0.0,0.5272127329999999,0.0,0.0,0.65120167,1.88661506,1.29322753,0.0,0.760002762,0.714765221,1.86255153,1.16612864,1.0888862,1.14725268,2.68095597,1.39564354,0.46670321299999995,0.0,0.0,0.0,1.06324077,0.279023488,0.007404284329999999,0.402297594,2.52789714,6.52815298,10.834895800000002,11.3942683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
2.08855327,2.14773889,4.02188032,4.12394876,4.41521788,2.90847468,3.99839386,3.72447456,1.4650665,1.11081474,2.07425139,0.0,0.919701254,0.0,0.398671644,1.77471089,0.0,0.0,0.0,1.42063187,1.45054453,0.148694997,0.0,0.0,0.550993152,0.389744635,0.646806248,0.0,0.0,0.0,1.12344988,0.0,0.9390983709999999,1.24341631,0.0,0.0,0.0,0.0,0.0,0.19977638,0.0,0.848814227,0.120061499,0.0,2.32593724,0.263569615,0.67814183,0.0,0.574812213,0.0,0.0,0.0,1.04543913,0.0,0.0,0.0,1.23409995,0.0,1.30751702,0.0,0.0,0.0,1.76193664,2.26641211,1.56360598,0.014223551899999999,0.0,0.0,0.0,0.16535456199999998,0.123132307,1.19035914,0.15687431699999999,0.0,0.0,0.0,1.54483163,0.5682307670000001,0.0,0.0,0.0,1.61872527,0.29358902600000003,0.0195182613,0.0,0.210952107,0.477012145,0.0,0.0,0.8470703190000001,0.289653082,0.0,0.777596365,0.0,1.43648184,0.0,0.155396489,0.40176449299999994,1.40541763,1.06899784,0.0,0.0,0.429786822,0.623670735,0.0,0.0,0.0,0.0,0.0,0.302942668,0.234003641,1.74514699,0.0,0.0,0.308582801,0.118488755,0.8939402870000001,0.643241954,0.0,1.14165525,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.147607069,0.0,0.0,0.0,0.11748674199999999,0.0,0.0,0.588322106,0.231436545,0.379049535,0.516623055,0.382161649,0.0,0.0,0.0,0.0,0.0,0.0,0.123712141,1.01292091,1.43416785,2.03134499,1.64067192,1.7124788,2.13930902,1.40299831,1.71851564,0.992573928,0.377787511,0.0714186222,0.0,0.0,0.0,0.0,0.10755542400000001,0.219553582,0.513174019,0.0,0.462458062,0.24894375600000002,0.0406955274,0.0,0.0,0.0,0.159597162,0.135628901,0.0,0.45368742700000003,0.0,0.39790905299999996,0.5617809260000001,0.17122877399999997,0.438023936,0.0219349075,0.058161834800000006,0.0,0.0,0.0,0.182219768,0.0,0.036703585899999995,0.241318505,0.23925526800000002,0.020720055,0.0,0.119154471,0.10540031,0.0,0.259313759,0.0,0.39969021600000004,0.480581656,0.0,0.0,0.0541026393,0.125857967,0.0,0.0,0.07831048480000001,0.0,0.0,0.0,0.0,0.495269251,0.219022677,0.396921684,0.0,0.00784996155,0.0,0.0,0.0,0.0,0.0,0.219231765,1.00466546,1.83385744,2.40682166,3.23433158,3.97620682,4.03241468,4.71589382,4.40077116,4.62074717,3.86285939,3.43178754,2.814496,1.88164523,1.44804503,0.999555338,0.7466185340000001,0.0,0.0,0.0,0.033258966099999995,0.273823725,0.0,0.326697616,0.010199382,0.0,0.28674532399999997,0.152173112,0.186072617,0.0,0.0,0.0,0.0,0.0,0.0,0.375855916,0.0,0.653914847,0.9490757870000001,0.9157715909999999,1.14537379,1.06369721,1.02548902,1.14032017,0.31945392899999997,0.35893432399999997,0.49157143200000003,0.0388428774,0.6685009679999999,0.5459341870000001,0.0,0.0279236207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.338506105,0.193000802,1.35871125,1.42997339,1.27792688,1.45055857,1.24967075,1.08929238,0.9192485570000001,0.352255087,0.10687225199999999,0.0954266539,0.0,0.426822597,0.307968285,0.218475339,0.784885938,0.7684042670000001,0.511490841,0.5043910189999999,0.462012614,0.0,0.152099531,0.117932173,0.6976026209999999,0.5464139729999999,0.956822098,1.84207349,1.72443423,1.95256218,1.75582474,1.38842062,0.8832178340000001,0.75626442,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6498007060000001,0.200095805,0.22978652100000002,0.366487899,0.478437102,0.0374715977,0.0,0.0,0.0,0.181414346,0.0,0.206286215,0.220220529,0.311522255,0.427655732,0.633061326,0.0,0.0,0.0,0.22243862399999997,0.23355241100000002,0.0,0.259065412,0.33921215600000004,0.554677136,0.212839295,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.516220815,0.22758313300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.571047439,0.332380137,0.778528063,2.00532437,1.36068116,1.83592412,1.83609882,1.9867352999999999,3.24519679,3.91533642,2.17158548,3.08854886,2.86459062,1.76092758,2.72591197,0.753116783,1.59560703,1.94874343,1.1180165000000002,0.9629318290000001,0.0,1.03844805,0.00938270271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6847128029999999,1.02801557,0.0,0.0,0.0,0.531053639,0.38891829200000005,0.0,0.0,0.414751806,0.0,0.109165353,0.33162452600000003,0.0,0.0,0.9041443640000001,0.0,0.0,0.19300468699999998,0.299133143,0.8093741390000001,0.0,0.0,0.0,0.0355140298,0.264431637,0.0,0.0,0.0,0.44980465,0.0,0.510042898,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.687251933,0.256204065,0.58563173,0.3253348,0.159261051,0.0,0.0,0.304906898,0.928524242,0.0,0.0,0.0,0.159227429,0.0,0.0,0.571217774,0.184273634,0.0,0.563500452,0.006656426280000001,0.0,0.5804980279999999,0.0,0.0,0.0,0.930223473,0.629939265,0.0,0.0594259426,0.0,0.404904816,0.79992458,0.0,0.0,0.131051445,0.0,0.0,0.0,0.0,0.847621126,0.0,0.630100761,0.536627324,0.0,0.811041344,0.019500441599999998,0.573580267,0.17494671399999998,0.0,1.30944976,0.0,0.0,0.025419371800000003,0.363468247,0.9833396109999999,0.279518972,0.158248427,0.0,0.0,1.05308838,0.426988241,0.071600328,0.0,1.48100931,0.162218329,0.478014479,0.309824366,0.9841271340000001,0.601072127,0.556350593,1.41043961,1.42904852,1.35383189,1.22374845,1.49472955,0.691117106,1.08765975,1.33465405,0.7698494109999999,0.614831569,1.00786613,0.665164796,0.609773537,0.354859607,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.22559293800000002,0.0,0.35479446299999995,0.0,0.031034714900000003,0.039277351099999996,0.533930358,0.604165659,0.47666888700000004,0.455015957,0.309342169,0.0,0.419296425,0.319231909,0.692123259,0.8679326409999999,0.0,0.641880975,0.30549133100000003,0.39856268899999997,0.14501751400000001,0.0,0.078135654,0.0,0.0,0.0,0.0,0.0,0.0,0.20184191199999998,0.555260006,0.0,0.0,0.0,0.210274483,0.0,0.0,0.0,0.0,0.7438716540000001,2.16438435,3.04716807,4.0748807000000005,5.24176652,5.18372998,4.43686879,3.55258719,2.36566407,1.437984,0.297432164,0.047413483,0.00637659372,0.374664646,0.389065509,1.49683619,2.22675947,2.21681844,2.42611966,2.50795689,2.13261843,1.12478239,0.929974557,0.706970691,0.0,0.0,0.0,0.214006408,0.45308024399999997,0.0,0.0,0.0,0.229242417,0.0,0.366938069,0.465982981,0.0,0.056092946,0.0,0.478155175,0.0,0.0,0.0,0.0,0.440395087,0.0,0.0,0.0,0.026746144700000002,0.05437882,0.152793875,0.266458311,0.0,0.45302169299999995,0.0882976642,0.0,0.0,0.214676615,0.0,0.236638116,0.015145483000000001,0.085699951,0.419531909,0.019300380500000002,0.315616651,0.31677514100000004,0.0,0.0995360283,0.28529063,0.0,0.0,0.11177404199999999,0.469076215,0.18197986,0.122897097,0.0,0.00377916138,0.0,0.0,0.0,0.306039747,0.44204661799999995,0.49553295,0.723399903,0.472786528,0.22116755899999999,0.948816313,0.5793012120000001,1.41564589,1.53537576,2.30760212,2.99323152,2.66182465,2.32916988,2.57048524,1.4278163000000001,1.01113996,0.7135708000000001,0.0,0.0,0.0,0.19175272399999999,0.0,0.0,0.239570161,0.539442577,0.366450237,0.49403863600000003,0.42509332200000005,0.00802488329,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.531923647,0.256158223,0.173022875,0.0,0.0,0.0,0.0,0.07642358610000001,0.638253745,0.730921145,1.40520482,1.61798046,1.71379275,1.55880553,1.32185183,0.616591142,0.762015797,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
9.01701858,7.85916015,6.21478232,4.30691273,2.38893466,0.70128064,0.0,0.0,0.0,0.0,0.0,0.0,0.54329846,0.96103124,1.10258982,0.96108333,0.59613277,0.11444693,0.0,0.0,0.0,0.0,0.0,0.0,0.27486020000000005,0.59143072,0.74663332,0.70647027,0.48614388,0.14510343,0.0,0.0,0.0,0.0,0.0,0.0,0.20374904,0.53599078,0.7369485,0.7511041,0.56770239,0.22454075,0.0,0.0,0.0,0.0,0.0,0.0,0.24580373,0.92983924,1.5905528,2.12601056,2.46332346,2.57279335,2.47180306,2.21771373,1.89163415,1.57709774,1.3389107,1.20742076,1.17218849,1.18680021,1.18385569,1.09662116,0.88206098,0.53938767,0.11906688,0.0,0.0,0.0,0.0,0.80375633,2.09995448,3.71511503,5.47264042,7.14890401,8.50956605,9.35029442,9.53398316,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
3.03656628,3.00335634,2.94916836,2.87470065,2.78090513,2.66897325,2.54031822,2.39655412,2.23947204,2.07101375,1.89324316,1.70831625,1.51844977,1.32588921,1.13287663,0.9416188670000001,0.75425646,0.5728339339999999,0.399271828,0.23534090600000002,0.0826389345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00151991411,0.0775434094,0.150034002,0.217705206,0.27940661899999997,0.334139796,0.381071206,0.419542087,0.44907508,0.46937758700000004,0.480341841,0.48204174299999997,0.47472656799999996,0.458811717,0.434866696,0.403600615,0.365845464,0.322537536,0.274697321,0.22340828899999998,0.16979492699999998,0.11500046,0.060164653600000007,0.006402094279999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.018571148,0.06288385070000001,0.10620670199999999,0.14763183300000002,0.18629874600000002,0.22141096,0.252251263,0.278195285,0.298723142,0.313428947,0.322028025,0.324361701,0.320399579,0.310239311,0.29410384300000003,0.272336227,0.245392108,0.21383003399999997,0.178299806,0.139529079,0.09830850279999999,0.055475679699999995,0.011898263899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0115749341,0.0537940265,0.0949983909,0.134326477,0.170951935,0.204100333,0.23306491399999998,0.25722109600000004,0.276039418,0.289096674,0.29608501800000003,0.296818845,0.29123929600000004,0.27941631100000003,0.261548142,0.23795834100000002,0.209090263,0.17549916399999999,0.137842032,0.0968653389,0.0533909192,0.008300247059999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0199458152,0.0751987149,0.130145352,0.183634496,0.234517108,0.28166869699999997,0.324011669,0.36053723299999996,0.390326478,0.412570216,0.426587214,0.431840464,0.42795115899999997,0.41471009299999995,0.392086241,0.360232316,0.319487155,0.270374845,0.213600545,0.150043028,0.08074401769999999,0.0068944537400000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.067239277,0.224049348,0.39186395399999996,0.569041585,0.753772132,0.944100768,1.13795431,1.33316969,1.52752404,1.71876603,1.90464783,2.08295738,2.25155027,2.40838085,2.55153211,2.67924369,2.78993775,2.88224223,2.95501108,3.00734121,3.03858582,3.04836398,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.024576317200000003,0.157377996,0.306355249,0.457392991,0.59546919,0.7064816890000001,0.7789974409999999,0.805698267,0.7843381779999999,0.71809312,0.615265391,0.488390127,0.352868315,0.22530888699999999,0.121793899,0.0562817676,0.0393347781,0.07730362959999999,0.172032346,0.321072119,0.51832395,0.754977331,1.02058303,1.30409576,1.59474648,1.88264886,2.15910274,2.41661759,2.64873235,2.84974348,3.01446628,3.13814204,3.21656769,3.24647211,3.22610202,3.15592323,3.03929836,2.88298116,2.69727394,2.49573038,2.29434673,2.11026241,1.96007406,1.8579433,1.81373325,1.83143415,1.90812579,2.03367467,2.19128064,2.35888114,2.51130594,2.62296644,2.67077729,2.63695888,2.51136382,2.29301392,1.99062114,1.6219871000000001,1.21231531,0.791610587,0.391461251,0.041585972400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.157237865,0.34250789200000004,0.488233232,0.579153919,0.608299302,0.577330406,0.49574878299999997,0.37911223200000005,0.246528887,0.117793244,0.0105684522,0.0,0.0,0.0,0.0,0.0352445599,0.11543026699999999,0.18979953800000002,0.24473021600000003,0.27044154800000003,0.262466767,0.22226224100000003,0.156870439,0.0776968579,0.0,0.0,0.0,0.0,0.0,0.0,0.061475232000000005,0.151492806,0.233032254,0.29043508,0.31104348600000004,0.287449932,0.219061753,0.112723428,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0413662517,0.317922204,0.636872659,0.970920184,1.2896413999999998,1.56294402,1.76453702,1.87497469,1.88389015,1.79114017,1.60672506,1.34950639,1.04489948,0.721846381,0.409461663,0.133776304,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0325634666,0.123408589,0.18502233899999998,0.210785764,0.20019119100000002,0.158311801,0.0945378259,0.0208036544,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.006994210600000001,0.0589951349,0.098468264,0.11970785099999999,0.120222292,0.10096492,0.06601500589999999,0.0217833664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0361927341,0.0677463656,0.08716469519999999,0.09158719609999999,0.0806820112,0.056633793200000004,0.023726173399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.025039028199999997,0.054021050599999995,0.0736606013,0.0807835709,0.0743141504,0.055433152400000005,0.0273666756,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0184837526,0.0484283779,0.0704076557,0.0806777618,0.07741368559999999,0.061026814000000006,0.034118403900000004,0.00107339688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013935506200000001,0.0492673777,0.07723826219999999,0.092904786,0.093223895,0.0776119967,0.0481203516,0.009187935040000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.009849808270000001,0.0623621399,0.10861507599999999,0.140646209,0.152296236,0.140299943,0.104995931,0.0505323245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
10.619724099999999,10.6633291,5.36627622,0.570277432,0.840268826,0.924522473,0.0,0.363003574,0.0,0.0,0.0,0.0,0.0,0.0,0.0870075938,0.9288788490000001,0.3056795,0.18980381699999999,0.0829372654,0.275929734,0.0,0.710910134,0.115990626,0.286044362,0.0201256914,0.0,0.0,0.031449832999999996,0.34658858,0.0,0.0,0.0,0.8972464920000001,0.0,1.50586526,0.613242863,0.0,0.7034109140000001,2.54391041,0.23695914199999998,4.82288642,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.9170609270000001,1.60743278,1.96150225,2.14908377,1.63537417,1.76822147,2.10019907,1.61152293,0.0,0.0,0.936754785,0.0,0.0,0.0,1.20400523,0.0,0.7359617009999999,0.0,0.0,0.0,1.12128648,0.39843591899999997,0.40715452799999996,0.0,0.0,0.0,0.0,0.642652832,1.01865826,0.441500622,0.0,0.19302557399999998,0.0,0.628300141,0.0,0.0,0.0,0.0,0.6801766020000001,1.13218061,0.750592797,0.0,0.575144063,0.0,0.7641928109999999,0.369250697,0.0,0.0,0.455225565,0.0,0.25104724,0.0,0.632464127,0.20282791600000002,0.0,0.0,0.0,0.0,0.506633497,0.0,0.930045433,0.7669989140000001,0.0,0.379635641,0.0,0.42043423399999996,0.27983267100000003,0.0,0.908201844,0.647773699,0.0,0.0,0.0,0.94588534,0.17569141600000002,0.234745802,1.09566598,1.51311431,2.19559688,3.75796998,4.35863984,2.82951649,3.30614914,2.03948991,2.43764993,0.881021816,1.47610504,1.2924197,1.63896889,1.13029412,0.39056546200000003,0.0405734665,0.9848686209999999,0.0,0.6809346559999999,1.2758201999999998,0.237995336,1.33344641,0.0,0.8220195840000001,0.236167911,0.25094612,1.00766392,0.282829514,0.83447195,0.129328465,0.081167288,1.39282956,0.0,0.0,1.37680442,0.7402376709999999,0.0,0.563155471,0.0,0.0,0.18678975899999997,0.8984576240000001,0.0,0.61974341,0.90596615,0.0,0.0,0.136856144,0.0,1.17725955,0.75851483,0.0,0.0,0.0,0.0,0.0,0.0,0.160072146,1.11955321,0.0,0.330334515,0.0,0.0,0.0,0.7776238540000001,0.0,0.969069533,0.0,0.0,0.0,0.0,0.841013412,0.958562018,0.44251642799999996,0.61458799,0.0,0.422174506,0.0,0.9386307190000001,0.691504853,1.77287533,0.0,1.42941788,0.0578173598,0.257202792,1.02305123,1.51736606,2.60783909,1.61482248,1.00831726,0.343220842,0.796862185,1.28454963,0.0,0.0,0.0,0.0564272394,0.327576856,0.272540377,0.612302139,0.256998699,0.537437716,0.0288725107,0.809281997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.108878694,0.23778446399999997,0.79172921,0.463276421,0.0194706215,0.0,0.0,0.0,0.342777638,0.0,0.0,0.0,0.0,0.431717753,0.0,0.0,0.0,0.0,0.310408134,0.0,0.0,0.0,0.0,0.0,0.528512209,1.34876374,1.4588169,0.6364354329999999,0.414124727,0.0,0.010927605200000001,0.91657575,1.2309997,0.6121341539999999,0.0723673151,0.0,0.0,0.273218118,1.01614449,1.45566802,1.29044943,1.2083877,1.82175394,2.55198328,2.93530538,2.50556528,1.47203378,0.0,0.0,0.20061360399999997,0.550965126,0.65471798,1.09625214,1.60693052,2.47623847,3.70689621,3.96751095,3.75885732,2.52212108,1.21731103,0.0,0.104054947,0.0,0.0829605021,0.26952176699999997,0.269118118,0.164968298,0.0,0.20601669399999997,0.0,0.0,0.37190567399999996,0.0652260831,0.0,0.0,0.0,0.390597934,0.0,0.0,0.300117813,0.410848946,0.0,0.0,0.428448768,0.324350988,0.359340569,0.166874385,0.355013391,0.176511735,0.0,0.605841162,0.565008644,0.342131533,0.595703267,0.42871157,0.716309635,0.731228653,0.770241976,0.726574877,0.397902849,0.938039228,0.5507643879999999,0.635270508,0.616546287,0.0,0.0,0.351166605,0.0,0.0,0.10688459300000001,0.0,0.0,0.649364736,0.506727354,1.11969082,1.33034751,0.65786889,0.0,0.0,0.208831667,0.0,0.421615477,0.0,0.0,0.0,0.24336112699999998,0.0,0.31917291,0.0,0.0,0.32120717,0.0,0.243567268,0.0,0.22462849,0.0,0.0,0.39933529,0.0,0.239560461,0.0,0.0,0.42545120399999997,0.34619746799999995,0.0,0.223970429,0.0,0.0,0.0,0.0299967629,0.0,0.446338089,0.402936566,0.6107067589999999,0.42182502,0.0,0.0,0.0,0.12300814199999999,0.115145477,0.38812106799999996,0.0,0.0,0.438533612,0.0,0.0,0.0243309502,0.0,0.22518806,0.0781107712,0.0,0.0,0.309288959,0.0,0.42478932,0.0,0.0,0.23526319199999998,0.0,0.133060409,0.124515155,0.0,0.0,0.0,0.292952504,0.0449659085,0.0877513977,0.158021202,0.21274116,0.0,0.100117595,0.0,0.0,0.0,0.0,0.216026715,1.45646173,1.24194126,1.07569876,0.787772723,0.263222949,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.250202816,0.0,0.385875364,0.0,0.198858693,2.85752811,2.63057564,0.776989578,0.7082273929999999,0.445709836,0.0,0.0943560165,0.0,0.0,0.0688119522,0.0,0.0815265203,0.0,0.0,0.12452822699999999,0.0,0.072312168,0.0687254746,0.0,0.423826638,0.0,0.0,6.56675332,10.208131,4.47094458,0.0,0.0,0.0,0.924743416,1.45136094,0.126756372,0.215952277,0.634959095,0.0,0.0,0.124038651,0.0,0.10045182400000001,0.0,0.0,0.139546789,0.0,0.0629705367,0.0979475199,0.0,0.87925269,1.62688688,0.09017821279999999,0.0781751883,0.887606468,0.0,0.042453181799999996,1.65625242,0.8743782790000001,0.0,0.055352751,0.0555388993,0.0,0.07238153,0.0,0.039566332200000005,0.166907972,0.048430962699999996,0.0,0.0,0.0,0.0448566966,0.154095875,0.0783726184,0.0,0.0242887717,0.207860015,2.55813689,5.19852071,2.85566196,0.0,0.308756667,0.0103127664,0.0,1.02913603,0.7386611999999999,0.0,0.0613739339,0.0,0.543439941,1.0406860999999998,0.09279972269999999,0.0,0.0660703967,0.0,0.0,0.0,0.0342421892,0.0,0.0100196398,0.0386659418,0.0,0.0880583397,0.0,0.0,0.127062875,0.0,0.113694647,0.0238547561,0.0,0.349419957,0.0,0.0922711724,1.55065502,0.193471158,0.860533399,2.82869422,0.5467611920000001,0.0,0.448941506,0.0,0.0,0.204324893,0.0,0.15318403,0.0,0.0,0.16139858199999998,0.0,0.044700413700000004,0.0559013079,0.0,0.121277193,0.0,0.0,0.0922964706,0.0,0.0785798432,0.0,0.0,0.11197528300000001,0.0,0.0318580315,0.0553275809,0.0,0.142963036,0.0,0.0,0.859787196,1.4442038000000001,1.30462002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.170361873,0.550736199,0.317204514,0.5848012429999999,0.0,0.289258699,0.0,0.168749891,0.149384169,0.0,0.0,0.0,0.616067695,0.043874123499999994,0.642281755,0.291900062,0.45518856,2.77107463,6.65574145,5.92801961,2.44037535,0.0,0.9800104590000001,0.0,0.317686548,0.0,0.0218591077,0.478951339,0.5441453470000001,0.174681208,0.0,0.33641052899999996,0.290525556,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.48373666600000004,0.0,0.0,0.0,0.5726129010000001,2.99403732,5.73955049,6.13943478,6.05026232,2.8682499,1.00922171,0.0373544046,0.0,0.0,0.0,0.895126375,0.890355053,0.0,0.406086958,0.0,0.169653855,0.110553265,0.0,0.0686595481,0.0365554535,0.5348597589999999,0.0,0.0,0.0,0.6174978,0.646891281,0.44926005700000005,0.0,0.0,0.0,0.104133108,0.0,0.0,0.282676111,0.505929885,0.0334373423,0.0,0.167469463,0.212608383,0.618834068,0.0,0.17021479399999997,0.0,0.470839712,0.117759024,0.0,0.287789097,0.0,0.0901831018,0.0,0.12953814800000002,0.0,0.0,0.0,0.520720185,0.0761545506,0.37789930899999996,0.6158628979999999,0.0,0.0,0.580086936,0.0,0.0,0.187027175,0.0,0.0,0.0,0.33558592600000003,0.53849468,0.26723600399999997,0.962012667,0.9047875190000001,0.049308453099999996,0.23022093600000001,0.565913515,0.0,0.0,0.35448351100000003,0.0,0.0,0.0,0.300696381,0.0,0.0,0.0,0.0,0.0,0.0100087751,0.49869259899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.272489531,0.0,0.859815687,0.8701184000000001,0.55065406,1.19396841,0.278641902,0.175349797,0.0,0.38257887399999996,0.0711416901,0.94065145,1.65663722,2.13829482,3.0210505000000003,2.05149343,1.06636801,0.0,0.0,0.0718990856,0.0,0.6795454470000001,0.18177619399999997,0.0,0.481081281,0.0,0.511665081,0.0,0.0,0.0,0.9151880179999999,1.05083948,0.131603422,0.645327526,0.791384564,0.0,0.437590782,0.0,0.0,0.0,0.061821108799999996,0.296833592,0.5970175679999999,0.29807242899999997,1.56611428,2.5885931,2.397158,2.66683043,2.10696518,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.95906486,0.0,0.106647869,0.40112756200000005,0.0,0.055290364,0.528223022,0.28425808,1.40378724,2.29188091,1.22888503,0.559170422,0.6564922329999999,0.209168722,0.010556731399999998,0.0648619898,0.0,0.0537580305,0.0992723936,0.0,0.0762098996,0.106822584,0.0,0.0972311896,0.10840568699999999,0.0,0.120559173,0.10818828400000001,0.0,0.149087848,0.107746591,0.0,0.18725055300000001,0.108272745,0.0,0.244846058,0.11218931800000001,0.0,0.364940335,0.244531093,0.0,0.5046344,0.140557809,0.0,1.79389309,4.60937602,1.87894806,0.0,0.0,0.225115442,0.0,0.0,0.0,0.785329596,2.09831184,0.8494567890000001,0.0,0.567884211,0.5812542079999999,0.160441216,0.664869306,0.355131364,0.0,0.214047185,0.662490734,0.706867004,1.16875655,1.2216694,0.7530290959999999,0.5387472010000001,0.252939117,0.0,0.031976053500000004,0.0379654653,0.0,0.030774805899999997,0.0649428534,0.09214889710000002,0.46950453299999995,1.42788646,3.09077676,4.45287846,4.05965935,2.5749686,1.93778625,2.10541075,1.52104182,0.35045872,0.0,0.102374626,0.0,0.0,0.13670668,0.0,0.0,0.18101413,0.0,0.0,0.266378744,0.0,0.0,0.48962117899999996,0.0,0.05438007,3.41117591,3.10785422,0.0,0.0,0.7364884890000001,0.0,0.0,0.370921955,0.0432433908,0.0,0.045470203099999995,0.0184768025,0.369718339,0.199273437,0.0797524759,1.276967,1.31815584,0.0,0.0,0.395656516,0.0,0.0,0.282024557,0.0,0.0,0.23292116899999998,0.0,0.0,0.21053493899999998,0.0,0.0,0.298026931,0.0634056406,0.0,0.18925398899999998,0.0773107833,0.0,0.0751964101,0.155026327,0.312703742,0.260069132,0.198321606,0.320982518,0.11223494199999999,0.0348204446,0.22730903100000002,0.0,0.547247854,1.79021837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
1.56463123,0.857864601,0.693388406,0.811624593,1.83721584,0.260947179,1.00852825,0.742203361,1.76596978,0.0,0.0,0.0,0.631570775,1.0369871,0.44496152899999997,0.0,1.05770687,0.0,0.0543112359,0.21302838699999999,0.28011383100000004,0.0,0.0,0.0900903066,0.0,0.118941086,0.0,0.0,0.0,0.0,0.0,1.07517208,0.551577757,1.82383778,1.32527794,0.0,1.16380016,0.0,2.26844937,0.0,1.11455026,0.0996937705,0.358511796,0.10521247199999999,0.475422791,0.09479741900000001,3.21451578,0.0,0.138090236,0.0,0.0,1.25558932,0.07452064509999999,0.348325744,1.01051493,0.9609165359999999,0.0,0.211439237,0.292064445,1.82053472,0.314922375,0.0,0.7669545809999999,0.18752663100000003,1.49209789,0.201447763,0.171624177,0.0,0.0,0.621305779,0.0,0.0,0.0,0.140965985,0.8512438920000001,0.0,0.44377731,0.0,0.0,0.171943916,1.78074834,0.0,0.0,0.0,0.0,0.0,1.51622917,3.9209437000000005,3.31273696,5.178988400000001,5.65936164,1.85877098,2.33689408,2.2040074,3.16568922,1.61147595,0.0,0.07307768469999999,2.5224855,0.0,0.0,0.0,0.440487001,1.22493574,0.0,0.0,0.0,0.0,0.0,2.26114216,0.0,0.9863413190000001,1.81063851,0.23505335,1.14011959,0.0,1.06917325,0.677881521,1.17233543,0.510379567,0.0,0.0,0.0,0.0,0.0,1.92899597,1.27442294,0.0,0.0,0.0,1.11760508,0.584594275,2.50378871,0.0,0.801368913,0.41838128799999996,0.0,0.0,0.564784466,1.96907269,1.5550061000000002,0.00856473534,2.59768361,1.97685869,2.49897338,1.46949545,0.0,0.387833153,0.0,1.18867835,0.0,0.47423340799999997,0.0,1.70346603,0.0,1.73101909,0.0,0.0,0.0,1.09751937,1.79174488,0.0,0.118626279,0.0,1.07899166,1.03863188,0.16266578199999998,0.0,0.0,1.09930494,0.0,0.0,0.7824075840000001,0.018668121,0.0,0.0,0.0,0.0,0.0,0.42492973700000003,1.4949077,0.052558475199999996,0.408526942,1.4984745000000002,0.0,0.521407395,0.602394344,0.0,0.0517170075,0.0,0.40323119799999996,0.0,0.648653012,0.0,1.02778563,0.6095315410000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
1.68175759,0.0298880601,1.77908471,1.32811173,0.0,1.02408674,0.0,0.6796054109999999,0.265905945,0.8913976509999999,0.91257082,1.40209215,0.350636424,0.999674745,0.243936995,1.89822618,0.0,0.0,0.0,0.0,0.145669291,0.0,0.956599255,1.04152171,1.86110328,0.0,0.0,0.0,0.0,0.36284208100000004,0.0,0.0,1.22357496,1.46143333,1.48997865,0.0473289805,0.0,0.135521312,0.703672147,1.09810751,0.7980994090000001,1.22724287,0.462755057,0.0,0.0,0.0,0.451836351,1.74751038,1.69925636,3.30018427,3.61747706,3.8518123999999996,3.70896397,1.40076475,2.4214306,1.31636387,0.0,0.0,0.13316502,0.0,0.0,0.77131545,0.0,0.0,0.0,0.0,0.0,0.0,1.80643985,0.6854477440000001,2.64856273,0.0,0.8395727829999999,1.94379223,0.0,0.0,0.7253809590000001,0.0,0.652320562,0.502751709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0805069161,0.0,0.0,0.0,0.7954294890000001,0.0,0.0,0.363512799,0.057215301600000004,0.0,0.0,0.43568396200000004,0.0,0.0,1.32075009,0.0,0.0,0.733977202,0.384696969,0.453212438,0.55014274,0.709289561,0.352692845,1.47338472,0.992251887,1.5006137,0.644580258,0.40898016,0.83146884,2.47642862,3.16446175,2.50863674,2.05396431,0.46230184399999996,0.49173599100000004,0.618119506,0.344418625,0.0,0.0,0.0,0.0,1.04770224,0.157029281,0.0,0.746747321,0.0,0.0,0.6865118259999999,0.131840182,1.41182902,0.0,0.0,0.0,0.0,0.0,0.736287375,0.0,0.0,0.0,0.0,0.757817953,0.0,0.26682135100000004,0.30317978,0.0,0.362185211,1.14971502,1.24686906,1.30667101,0.0,0.28100807,0.0,0.0,0.9272753440000001,0.6477596520000001,1.51501995,0.45667178,0.0,0.0,0.0,0.0428650279,0.061563012300000004,0.0,0.814457962,0.0,0.908184185,0.38334842700000005,0.0,0.180468623,0.0,0.0,0.0,0.945154842,0.0,1.02804769,0.6529184060000001,0.41357822,0.783236011,0.140594783,0.0,1.10998701,0.0,0.127974933,0.0,0.621874028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.0416654723,0.0,0.0,0.0,0.0,0.0,0.0486139451,0.166012431,0.24335144399999997,0.251916588,0.179910646,0.038028336499999996,0.0,0.0,0.0,0.0,0.0,0.288595405,0.861209601,1.54800124,2.27294344,2.94800331,3.48823915,3.82661158,3.92556076,3.78307568,3.43213429,2.9337657000000004,2.3652775000000004,1.80612287,1.32426237,0.965640972,0.7486260379999999,0.664127809,0.6809126259999999,0.7545869609999999,0.8380930190000001,0.8914281190000001,0.8886741109999999,0.82118103,0.696693155,0.535109419,0.36223316,0.203158216,0.0768253904,0.0,0.0,0.0,0.0,0.0,0.0,0.00355643145,0.0042221159,0.0,0.0,0.0,0.0,0.009156174920000001,0.0200797148,0.0267643006,0.0250491125,0.013455758,0.0,0.0,0.0,0.0,0.0,0.0,0.0244213153,0.0593078066,0.0814126296,0.0804338904,0.051224056100000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0773045853,0.29632178600000003,0.558853089,0.8328856020000001,1.08122406,1.26843184,1.36780243,1.36682259,1.26985845,1.09737384,0.8817539259999999,0.660583833,0.468838766,0.331727989,0.259821272,0.247585306,0.275675952,0.316447927,0.34136579899999997,0.32852001399999997,0.268394719,0.166427705,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.894539298,0.0,0.50766225,0.8597896070000001,0.528494489,0.6857562909999999,0.0,0.0,1.05845858,0.555218671,0.475509158,0.0,0.0,0.38403856700000005,0.0,0.0,0.31811446,0.722991679,0.6592680670000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.435927389,0.0,0.0,0.0,0.220714648,0.680572588,1.18473561,0.0,0.0,0.633423059,0.362462382,0.635054425,0.055856810599999994,0.047272373,0.0,0.7989751740000001,0.7892997490000001,0.22292594699999999,0.0,0.0198743469,0.0,0.0436828176,0.0,0.0,0.0,0.580406526,0.0,0.0,0.233751135,1.19717016,0.0,0.157853095,0.272426932,0.0,0.157088607,0.0,0.551306752,0.658702688,0.14519860699999998,0.0015677118400000002,0.0,0.0,0.45368803,0.553885359,0.0,0.15414903300000002,0.0,0.0,0.0,0.0,0.58890687,1.08690076,0.0,0.0,0.0,0.0,0.0,0.0490505484,0.0,0.0,0.5665123879999999,0.82962644,0.63089936,0.5806011,0.0,0.0,0.309647975,1.4631774,0.0,0.105277676,0.14689315,0.15877781300000002,0.507875163,0.0,0.562057623,0.0,0.0,0.9599635559999999,1.23560151,0.0,0.244217973,0.0,0.0,0.549403458,1.11061822,0.0,0.0,0.0,0.538962634,0.24510429399999997,0.0,0.0,0.35893196899999996,1.19431985,0.0,0.660402402,0.44923390799999996,0.0,0.0,0.0,2.2720526000000003,0.0,0.41557278799999997,0.0,0.0,0.265247875,0.252178649,0.177890981,0.42735547,0.0,0.211886733,0.292420626,0.785832792,0.0,0.7988695840000001,0.476363062,0.0,0.494798962,1.17591082,0.0,0.0,0.0682971526,0.0,0.40239470899999996,0.541421975,0.6928624859999999,1.4605732,0.0,0.0,0.0,0.0,0.0672720661,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.03065168,0.40353581200000005,0.805325397,0.21923879,0.8572586740000001,0.7148006459999999,1.52797703,2.4762258,1.56888777,1.48309179,2.2896812,3.18763059,2.07974831,3.31886523,2.1339085,3.74650923,2.85089557,2.77066105,2.29346559,3.1693186,2.76680995,1.94835836,2.0509789,1.37275534,1.29251188,0.930910694,1.42413993,0.469307176,0.292416652,0.0,0.0,0.0,0.5873618389999999,0.0,0.169516521,0.0,0.0,0.0,0.0,0.0,0.386693269,0.38991839100000003,0.84713129,1.06124828,0.0,1.68466342,0.809950955,1.32311705,0.584150214,0.93479044,0.543296835,1.2070677,1.75915258,0.0,1.28478869,0.720449331,0.574126729,0.75595381,0.11346495599999999,1.01684138,1.13875297,0.76420325,0.22849845300000002,0.0,0.0,0.24652204600000002,0.57226196,0.0,0.0,0.0538208437,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.33160961699999997,0.621631403,0.11571336800000001,0.209361286,0.0711283838,0.281761857,0.0,0.0,0.210877275,0.0,0.0,0.0,0.0753096295,0.0,0.0156653743,0.36341697799999995,0.406725857,0.10259737699999999,0.0,0.394796435,0.32995592,0.0,0.0656266025,0.40777025899999997,0.527220089,0.343775061,0.5528505920000001,0.216909315,0.06365873179999999,0.30918115,0.326230256,0.282876545,0.23405129800000002,0.211554712,0.316681575,0.13675520800000002,0.0,0.297840396,0.0,0.21380976699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.164157652,0.214770262,0.236105347,0.10906206199999999,0.47399460200000004,0.0,0.0,0.32216500800000003,0.6031969110000001,0.133148543,0.243422298,0.0,0.199788985,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.117152125,0.46618867799999997,0.257717615,1.16549393,1.2282187,1.79634296,1.99473467,2.07124726,2.37809605,2.3465011000000002,2.63322494,3.22305006,3.52944329,3.34233235,3.49924704,3.47983358,2.83836325,2.65249714,2.50859548,2.42955693,1.90377163,1.98937202,1.48167971,1.05037735,0.9372943229999999,0.273591743,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.319583253,0.0294254513,0.0,0.41187817,0.241549388,0.67235815,0.56535196,0.34783636700000004,0.8540425140000001,0.150101625,0.08277052230000001,0.384089489,0.19719356,0.0024894914699999998,0.0270096691,0.00987409181,0.0303662304,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0492309053,0.0174257393,0.429443908,0.49577780200000005,0.411900549,0.681229875,0.276901813,0.7081880859999999,0.48215375299999996,0.564133126,0.497832761,0.0,0.36645155799999996,0.155181479,0.0,0.0120875927,0.0,0.0,0.0,0.0104516368,0.11308665400000001,0.0,0.43291349100000004,0.08128840309999999,0.41070116700000003,0.645635065,0.94071322,1.04814959,1.75101288,1.80742225,2.18856516,2.80898334,3.15426177,3.17614615,3.24802578,3.32995099,3.40567926,3.32127707,3.77195792,3.48016439,3.55017477,3.14544831,3.28837775,3.00096178,2.43329651,2.10329049,1.9417596000000001,1.81812342,1.5353473,1.4612708,1.25697838,0.833296404,0.41612986700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.0665589436,0.0882124333,0.592415524,0.242942806,0.08444333710000002,0.0512727519,0.445056846,0.877466362,0.485481302,0.272597229,0.14054589999999997,0.005425475450000001,0.163742834,0.0,0.0,0.051308981,0.599257656,0.525317758,0.0345133788,0.024375826899999998,0.9543456029999999,2.21663968,3.10855225,2.39495076,1.33023191,0.783781123,0.56088303,0.464227606,0.28879459399999996,0.19889574699999998,0.45169849,0.329772571,0.19835422800000002,0.0,0.0691889626,0.12086081800000001,0.0,0.0,0.19248853,0.32761093199999997,0.0,0.0,0.213336323,0.538463376,0.523800074,0.179468719,0.23885629100000003,0.249275785,0.10852699699999999,0.0,0.0963586421,0.214988435,0.0,0.0,0.13607545,0.239770155,0.025695046699999998,0.141688428,0.0,0.0,0.36718125700000004,0.364179061,0.25731657399999996,0.0,0.0,0.26659057199999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.0665905972,0.0,0.14841398,0.278581275,0.276088134,0.123396533,0.0,1.11763472,0.622586414,0.5103064829999999,0.782651757,0.084031436,0.557499025,0.0,0.143695063,0.0,0.7084545999999999,0.354362795,0.0,0.0,0.665527921,0.0,0.0,0.0,0.0,0.0,0.0,0.310142547,0.0,0.577745546,0.552496577,0.0802731456,0.0,0.20036916100000002,0.0,0.634745134,0.0,0.5899231739999999,0.761957977,0.0,0.0,0.0,1.0521675,0.0,0.146549572,0.43621389200000005,0.0,1.09823844,0.384725537,0.0,0.0,0.0,0.309316806,1.10235013,0.996043819,2.58223822,3.08362548,3.04439164,1.85290999,1.73362573,1.76184694,0.0,0.738477945,0.0,0.0,0.593879276,0.132195739,0.0,0.0,0.0,0.55686541,0.39374625399999996,0.965356311,0.41907887200000005,1.61194898,1.8656253,0.810186538,1.00132517,1.21309761,1.0522434999999999,0.756749472,1.32484519,0.728558279,0.627274175,0.876380264,0.362189186,0.137511691,0.43676123,0.24524374,0.8599087459999999,0.0,0.0,0.0,0.314066052,0.32654435600000004,0.0208947043,0.200934668,0.36519652700000005,0.033089955899999995,0.42179388,0.24289529199999998,0.0,0.0,0.102384534,0.5971827,0.0,0.659053598,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0920332422,0.0693266886,0.19524127600000002,0.633624906,0.390967744,0.111918924,0.906660302,0.18207752800000002,0.0,0.590058896,0.307172235,0.0545889565,0.0,0.659053158,0.0,0.34083352299999997,0.0345051746,0.08390612970000001,0.118097638,0.0,0.300694472,0.353206178,0.0,0.0,0.0631683807,0.347134147,0.0,0.584368753,0.0,0.9646552840000001,0.0,0.18410867399999997,0.0,0.815881037,0.18946369300000002,0.0,0.0746452784,0.323282307,0.667745139,0.358864412,0.0,0.754861311,0.881393619,0.12345959,0.363664506,0.160657619,0.7832659590000001,0.45053386700000003,0.20966116899999998,0.0156255054,0.568066514,0.576572891,0.477390872,0.0,0.235756149,0.0,0.41265524200000003,0.944018998,1.13097015,0.322183271,0.8701234109999999,0.0,0.0,0.0933668181,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.11745702300000001,0.842103499,1.65527836,2.52098371,3.39842829,4.2444315,5.01604872,5.67323891,6.18138954,6.5135218,6.65201984,6.58976095,6.33056537,5.88893356,5.28908892,4.56339439,3.75025545,2.89165831,2.03051702,1.20801509,0.46112520100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.264542878,0.49391201799999995,0.658709491,0.7509046070000001,0.769069832,0.7179740059999999,0.607725751,0.452557649,0.26936577100000003,0.0761329843,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.032642813199999995,0.15454411699999998,0.255259781,0.327132376,0.36550087200000003,0.36893704299999996,0.339186434,0.28083457,0.20074197,0.107309548,0.009647776319999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.038108893399999996,0.10084333599999999,0.15079936900000002,0.18422053300000002,0.199071201,0.195124677,0.17388035899999998,0.13832659,0.0925792459,0.041436213300000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027750825299999997,0.0553264174,0.0754236152,0.0868056461,0.0891835668,0.0831729111,0.0701618409,0.0521095439,0.0312998067,0.0100780399,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000847120755,0.00490634195,0.00612564966,0.00476877856,0.00151621675,0.0,0.0,0.0,0.0,0.0,0.0,0.006754255129999999,0.016806028799999997,0.0275006996,0.0373720033,0.044872851,0.048574234400000006,0.0473625163,0.0406111895,0.0283051872,0.01110037,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0035296114700000005,0.0396423363,0.0747815028,0.10536094900000001,0.127996476,0.139866795,0.139039115,0.12472365699999999,0.09742676300000001,0.0589810234,0.012442291999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.026102555299999997,0.0904407127,0.148379437,0.19394019199999998,0.222164883,0.22970917300000002,0.215315545,0.180111143,0.127688759,0.0639474263,0.0,0.0,0.0,0.0,0.0,0.0,0.00971814837,0.13501756,0.293619115,0.476527524,0.67134223,0.863020485,1.03494333,1.17021525,1.25310362,1.27050637,1.21332643,1.07763236,0.8654945390000001,0.585406742,0.252231365,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
1.27836904,2.94261903,4.8228922999999995,6.73586121,8.47948938,9.86034196,10.7205135,10.9599897,10.5509305,9.54161823,8.04945414,6.24412005,4.3235768,2.48666814,0.9065708570000001,0.0,0.0,0.0,0.0,0.0,0.0,0.17677183600000002,0.631502456,0.915846933,0.992909775,0.869536161,0.589825,0.22290595100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.13330071699999999,0.35776838899999996,0.49454484299999996,0.523863387,0.448291812,0.290555393,0.08764436029999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10270041199999999,0.227798112,0.299002228,0.306181412,0.252574278,0.153202212,0.031053869300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0727411016,0.139180743,0.17242029,0.168754383,0.13223423,0.07318700709999999,0.0055608754,0.0,0.0,0.0,0.0,0.0,0.0,1.5217426500000003e-15,0.038160507999999996,0.0629547423,0.0711890256,0.06375566719999999,0.044931880599999995,0.0209591344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00572022271,0.0308728358,0.0549260781,0.0710788184,0.07344911059999999,0.0587825008,0.027668768399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.028858200299999998,0.09687619900000001,0.15103716,0.17799906699999998,0.169146938,0.12295134699999999,0.045948932000000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0741025,0.193736868,0.281742431,0.316878332,0.287514521,0.194843273,0.053600896399999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.160972098,0.35768416700000005,0.49471369600000004,0.538187996,0.471071255,0.298087086,0.046537236600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.36517103799999995,0.7307926379999999,0.984900752,1.06242212,0.9277875959999999,0.585882948,0.08656824800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.462
0.0523600333,0.0,0.0,1.09969453,1.10044139,0.918500909,0.0,0.0,0.0,0.0,0.0,0.9458948909999999,1.0805233,0.0,0.0,0.0,0.66029501,0.280882492,0.95646105,0.824070472,0.0,0.656036642,1.69248835,0.012413441499999999,0.0,1.56069947,1.45477365,0.0,0.0,0.54505204,0.0,1.64175332,0.0,0.0,1.54302122,0.0,0.0,1.27138605,0.0,0.41332923,0.0,0.0,0.570289266,1.35134917,0.0,0.617357705,0.0,0.0,0.0395917669,0.11504195699999999,0.0,0.0,0.0,0.0,0.18497021,0.780862055,0.0,1.32407394,0.0,0.616029918,0.0,0.600051099,0.0,0.662189681,0.132832576,0.0123582473,0.0,1.77173235,0.0,0.0,0.00182236885,0.0,0.0,0.0,0.0247474048,1.8187999,1.75586426,1.6567096000000001,1.82440161,1.66634018,0.0111658376,0.0,0.0,0.0,0.0,0.0,0.624353436,1.47791456,1.58509212,1.03832506,0.0,0.804678316,0.0,0.277863395,0.0,0.0,0.0490800053,0.535968396,0.0,0.0,0.0,0.485203,0.0,1.11341911,1.2564228000000002,0.0,0.0,1.72650353,0.988856132,0.0,0.0,0.24224047399999998,0.173102345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12666095300000002,1.61509948,0.174919219,0.0,0.0,1.38217425,0.0,0.0,0.28158374199999997,0.10091326099999999,0.0,1.68694935,0.0,1.5153062,0.0,0.920883488,0.11968149,1.83355365,0.0,0.62022777,0.0,1.18747186,0.0,0.570534339,0.0,1.60306758,0.0,0.0,1.57361997,0.0,0.114284859,0.0,1.82597658,0.0,0.0,20.542380800000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.47432023,0.414374156,0.9173079759999999,0.495552705,0.732363942,0.0,0.0,1.76573845,0.0,0.368166936,0.0,0.557786407,0.0,1.342285,1.17141212,0.0,0.0,1.19641749,0.194027743,0.0,0.188103522,0.0,0.0,0.0,0.43373866,0.9628044109999999,0.13842026,0.198000727,1.12425112,0.0,1.65478847,2.29428395,0.232648513,0.0,0.0,1.23238699,0.0754781154,0.703266053,0.0,0.725433874,1.19079552,0.0,0.88462359,0.0,0.729997305,0.32533369100000004,0.0,0.0,0.0,0.0,0.239626422,0.0,0.0,0.30211285600000004,0.0,0.0,0.0,0.43426227700000003,1.45165343,0.0,0.0,0.0,0.0,0.98231013,1.15575599,0.8250622459999999,0.0,0.457481355,0.0,0.7059235709999999,0.0,0.0,0.116227192,0.0,0.801373523,0.156039395,0.23253975600000001,1.74769705,2.86046237,2.78505116,0.581281755,0.923147355,1.22555981,0.0,0.0,1.00148685,0.0,0.0,1.26100136,0.04310927690000001,0.363532077,4.10073947,3.69701417,1.60713436,0.0,0.7224426409999999,0.0,0.0,1.28397144,0.0,0.0,1.24615512,0.401495347,0.0,0.275016453,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.5448923170000001,0.883535829,0.354586296,0.0687745815,0.47256992299999995,1.69209714,0.0,0.693484436,0.110443259,1.55784655,2.91321258,0.8627921909999999,0.0,1.29220436,0.035090028599999996,0.04283728059999999,0.0,0.0389612928,0.0,0.00380078261,0.134343422,1.03286574,1.40493162,0.11121071099999999,0.330406475,5.35177985,0.31260276800000003,0.12559506,0.0,0.102910001,0.0,0.097244974,0.0180584666,0.0494529913,0.0160872814,0.24763301,0.0,0.360157858,0.613481443,0.0,0.0737615553,0.0,0.36514887,0.8612420270000001,0.0337588608,0.52341427,0.441274335,0.19629438,0.361683135,2.01367384,0.35719172,0.304818756,0.10681749199999999,0.427177295,0.280375541,0.0145292756,0.0784649473,0.0698999049,0.0,0.140547073,0.21486780600000002,0.21554778,0.0695490697,0.0,0.0,0.00276282142,0.0031401855499999997,0.0,0.051960850700000005,0.0729234102,1.7440179,2.74349811,0.559191304,0.499521461,0.0,1.71555196,1.05694371,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.393065571,0.0,0.0,0.0,0.20511454,0.0,0.0160676664,0.0,0.0,0.0,0.821076598,0.0,0.7958887840000001,0.0,0.0,0.28932601199999997,0.0,1.20214928,0.0,0.0,0.0,1.15486999,0.110775976,0.694013075,0.0,0.544215102,0.23094784699999998,0.30253887399999996,1.14983424,0.132101129,0.0,0.0,0.0927461384,0.0,1.31425901,0.0,0.342434646,0.058605930199999996,0.0,1.08025764,0.0,1.8958993999999998,3.20704534,0.80477691,0.602330395,1.39662468,1.00848455,1.58702282,2.64378263,2.42072921,5.62754741,3.73617096,4.4609312,4.096588,2.34040996,0.0903318229,0.757365217,0.0,0.0,0.0,0.433793672,0.7645901540000001,1.9962286,1.61869929,2.15024707,3.78370424,5.39972404,2.04644191,3.31607263,3.89212266,0.0,1.35865521,0.0,0.0,0.0,0.0,1.64490921,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.915027655,1.2188226999999998,0.0,0.0,0.976557883,0.0,0.0,0.0,0.0,0.9182074179999999,0.0,0.0,1.18787158,0.711824655,2.14490009,2.43100104,0.210422907,0.0,0.932806235,1.79972644,1.22389477,0.379270771,0.0,0.620505226,0.0,1.64343788,1.95097826,0.0,1.12841972,0.28392015800000003,0.0,0.0269663043,2.01741219,0.732514355,0.501548843,0.0,0.462698231,0.0,0.0,0.0,0.0,0.7540616859999999,0.0,0.394121655,0.0,0.0,0.381522776,0.0,0.63397649,0.0,0.0,0.0,0.325810704,0.13706505900000002,0.39478393799999995,0.0488156337,0.331558172,1.16463236,0.0,0.8250489240000001,0.303161394,0.0,0.0,1.06184534,0.0,0.0,0.0,2.5707505,0.0,0.0,0.0,0.0,0.021605280299999998,0.112848811,0.394678921,1.46178471,2.12412927,1.89432404,0.0,0.716699357,0.0,0.590788147,1.64260828,0.0,0.517757394,0.0,3.01079369,0.0,0.0,2.24217241,0.387334316,1.09427985,0.0,0.0,0.0,0.95003611,0.104856008,0.0,0.764606233,1.79906494,0.323455568,0.256898269,2.7687037999999995,0.304012817,1.04106845,0.0,3.01158958,0.56444475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.420766652,1.27225046,2.37724773,3.1921302000000003,4.44468986,4.99719379,5.15452194,4.85428059,5.25602788,4.91360188,3.80285105,3.58938537,3.05056596,2.08661718,2.54882627,2.28486073,1.51045157,1.73949566,2.36580529,2.07222756,1.75631531,1.40296465,1.88187383,0.944764077,0.9811406709999999,0.54695148,0.546708635,0.119760437,0.0,0.0,0.37305739299999996,0.0,0.0,0.623693069,0.614261419,0.22973607,0.0733739733,0.0599181499,0.0,0.125870341,0.246253597,0.0,0.0806975787,0.0,0.251950348,0.0,0.35045810299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.384756659,0.28338067,0.0,0.0598956368,0.286172067,0.513761235,0.0798865495,0.0,0.0,0.579368338,0.345971178,0.0,0.019110516299999998,0.0,0.0,0.158838591,0.0,0.491554913,0.9961577420000001,1.34737024,1.47372128,1.95433993,2.59150915,1.88501051,2.01589744,2.32904967,2.18944339,1.36750036,1.64427198,1.17097331,0.665743026,0.577110947,0.0,0.0,0.106923499,0.0,0.41178651299999997,0.237715714,0.0,0.383151015,0.0,0.325856747,0.040962010699999996,0.167511238,0.669280985,0.373513264,0.0,0.0,0.173361044,0.0,0.0939568435,0.11336297,0.0,0.0,0.36819796200000005,0.109785315,0.17485972600000002,0.062916658,0.0172565374,0.133207361,0.0836981629,0.0298797173,0.0,0.0,0.307911187,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.17278637800000002,0.43662329200000005,0.673958927,0.598543608,1.11460245,0.47079524,0.0,0.0,0.19636780899999998,0.0,0.0,0.0,0.0,0.0,0.40593754200000004,0.0,0.0,0.15664256,0.301622967,0.37742956,0.22499074800000002,0.106538138,0.0183963188,0.207395644,0.286401589,0.0,0.0,0.177652253,0.0,0.254981479,0.0,0.0,0.715921873,0.403082571,0.051314055,0.146618321,0.580824259,0.200043903,0.376300287,0.06202986519999999,0.0,0.0,0.0628059336,0.0677446336,0.0,0.26176108800000003,0.0654196639,0.16065363300000002,0.0,0.36358615899999996,0.0,0.310501701,0.0,0.0,0.0,0.26642462,0.165459631,0.0,0.0,0.0,0.0,0.6461925860000001,0.0,0.0,0.11550760800000001,0.0,0.0,0.0,0.0,0.302254895,0.0,0.0,0.0,0.42410870000000006,0.0,0.046162027,0.0,0.297747663,0.422192268,0.46417778200000004,0.0,0.3642867,0.0,0.0,0.0,0.0,0.0,0.0,0.168364763,0.47329447700000005,0.6752439990000001,0.559042309,0.329035355,0.150426255,0.0,0.483765936,0.309087571,0.241022585,0.0,0.0,0.0,0.0,0.0477259536,0.040857295099999996,0.0,0.0,0.0,0.26140876,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.535104172,0.7517807120000001,0.114274142,0.257876292,1.12572386,0.33000304399999997,0.7408240540000001,0.33126413899999996,0.0,0.0614051059,0.0,0.0,0.0,0.0,0.0,0.0,0.807238647,0.8582844079999999,1.93910812,3.30399009,4.49871003,5.11136306,5.16996407,5.53230961,4.89984251,4.83331016,4.52126071,3.96415867,2.48337156,2.00984613,0.530836758,0.0,0.0,0.0,0.0,0.0,0.0,0.06307126589999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
1.55236201,1.75384119,1.94265065,2.09885892,2.18928963,2.17416341,2.01860547,1.70601814,1.24920482,0.695188501,0.121009505,0.0,0.0,0.0,0.0,0.0,0.0775585972,0.517504364,0.823572031,0.8971548109999999,0.696067908,0.251193674,0.0,0.0,0.0,0.0,0.0,0.0,1.17565478,2.55995151,3.8932559,4.94640546,5.53499944,5.55823485,5.019545,4.02437305,2.75587508,1.43457006,0.271631033,0.0,0.0,0.0,0.0,0.0,0.0475703241,0.40764820799999996,0.602155003,0.615832454,0.485742027,0.28256915,0.08542180810000001,0.0,0.0,0.0,0.12114267,0.251143916,0.339801796,0.360438624,0.315544625,0.235367153,0.167242671,0.159235722,0.24329047199999998,0.42314998,0.670788798,0.932518697,1.14304577,1.24342496,1.19773968,1.00372768,0.694335233,0.329776799,0.0,0.0,0.0,0.0,0.0,0.0,0.08448096880000001,0.23430080399999997,0.300735802,0.273430773,0.169141218,0.0247821092,0.0,0.0,0.0,0.0,0.0,0.0259769024,0.127628703,0.18458375600000002,0.183139235,0.127634171,0.0379988911,0.0,0.0,0.0,0.0,0.0,1.11250998e-15,0.0745084015,0.12233858800000001,0.130933375,0.100136791,0.041493174,0.0,0.0,0.0,0.0,0.0,0.0,0.0417064738,0.0802667713,0.0925430772,0.0765676494,0.0389187262,0.0,0.0,0.0,0.0,0.0,0.0,0.0205849625,0.049501742,0.0616076038,0.05457205,0.031958706600000004,0.0017103462300000001,0.0,0.0,0.0,0.0,0.0,0.0077552644200000005,0.027014757799999997,0.0365179577,0.0344036888,0.0224240318,0.0050387539899999995,0.0,0.0,0.0,0.0,0.0,0.0018472023899999998,0.0193740024,0.0381444757,0.0589932998,0.0841849576,0.11652949300000001,0.158238378,0.20990277100000002,0.269905059,0.334408695,0.397879186,0.453941818,0.49632687200000003,0.519697611,0.520266463,0.49622144799999995,0.448049441,0.37882241,0.294415961,0.203504906,0.117098521,0.04740179480000001,0.0059447613,0.0011823928999999999,0.0360524921,0.106179224,0.199424328,0.29726393,0.37802987299999996,0.421504883,0.413861727,0.351658853,0.243673444,0.10979776699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.08556014449999999,0.164942249,0.19633410199999998,0.168607586,0.0872441914,0.0,0.0,0.0,0.0,0.0,0.0,0.153600609,0.39229067100000004,0.645374558,0.893315289,1.12631807,1.34427281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
0.300837824,0.0,0.0,0.229773714,0.0,0.340351584,0.39061617200000004,0.138108956,0.48335591200000005,0.031068672599999996,0.134251378,0.649219571,1.26233991,0.0,0.209953692,0.35998939,0.106813335,0.138311942,0.169787949,0.0540554928,0.251197646,0.0,0.254893586,0.0267208341,0.0,0.301576742,0.143235698,0.0,0.0,0.389659546,0.0,0.274172999,0.0,0.16432798099999998,0.0,0.131099559,0.0,0.0,0.0,0.332630126,0.270903326,0.345595084,0.0,0.139908815,0.0,0.103154699,0.0,0.0,0.399120704,0.0,0.0,0.0706455198,0.0,0.9500095590000001,4.22812899,3.29547502,1.55719749,0.605496164,0.347369683,0.217354186,0.322424854,0.0,0.0,0.0,0.0635768969,0.286340842,0.0202625617,0.0472750533,0.37407672,0.24991870800000002,0.10638197,0.0,0.0,0.0,0.225883857,0.0,0.0,0.0952285041,0.0748065299,0.34286038,0.0,0.0,0.0,0.35906308299999995,0.0347524854,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.285198975,0.7360871640000001,1.01149265,0.0,0.00459828104,2.07493357,6.53350397,1.34258218,0.06913065339999999,0.0,0.0450425597,0.0,0.0,0.0739826075,0.8453916020000001,0.0488213474,1.70063007,0.0,1.05226678,0.6066072379999999,0.0804283486,0.0,0.10161550800000001,0.0,0.231560965,0.0,0.12263632699999999,0.0,0.119452264,0.0,0.2980927,0.0907671007,0.0899113933,0.0,0.11900808800000001,0.0,0.141140353,0.0,0.557490559,2.69952685,4.93287397,3.63669936,1.97142872,0.0,4.01736409,4.17741821,0.0,0.457982324,0.0,0.461621271,0.76346348,0.418348448,0.0,0.0527587444,0.0,0.0150169354,0.0,0.0,0.0146343043,0.0,0.029602072599999998,0.0,0.043979625099999996,0.0,0.060907999500000004,0.0,0.123371231,0.0778807588,0.147470491,0.0,0.129798998,0.0,1.02499203,2.13098889,2.60766591,1.35665573,0.714762826,0.0,0.787886132,0.0,2.12972818,1.500086,0.0,0.413323899,0.073323935,0.474761734,0.0,0.21216983600000003,0.0,0.146802403,0.0,0.11107876900000001,0.0,0.08714494980000001,0.0,0.0691708424,0.0,0.0548019386,0.0,0.045868717,0.0,0.271357702,0.545963276,0.112924914,0.0,0.00108720659,0.031485380699999996,0.0,0.681039976,0.187114924,0.000387485847,0.692908431,1.7387313000000002,0.739242803,0.43350255600000004,0.28250166,1.00197556,0.27358471300000003,0.0,0.102157515,0.510096979,1.58315976,0.910959772,0.12854845,0.0,0.07865899309999999,0.0,0.06324070059999999,0.055927148200000006,0.0758947888,0.0,0.547020363,0.0980169946,0.0382936256,0.0,0.027311262000000003,1.0918727,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
1.90347242,1.29319556,0.59539872,0.0,0.0,0.45866599999999996,1.05173325,0.54447745,0.0,0.49729359999999995,0.0,3.33768926,1.88231899,0.42645019,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.02983368,0.0,0.24245497,0.06526587,0.0,0.0,0.0,0.0,2.18774755,1.12236477,1.06888084,0.0,0.68491179,0.0,1.21738128,0.0,1.25243025,0.43145600000000006,0.0,0.0,2.596098,0.0,0.96892104,0.0,0.40296572,0.57389817,0.0,0.96077478,0.0,1.00847275,0.0,0.68302541,0.0,0.0,0.0,0.78034903,0.0,0.0,0.0,0.0,0.0,0.83458801,0.66431697,0.0,0.0,0.0,0.30343876,0.63387348,0.0,0.0,0.7942166,0.0,0.0,0.0,0.62675454,0.0,0.41881695,0.83191913,0.0,0.0,0.0,0.80086589,0.0,0.0,0.0,0.64507469,0.28817683,0.0,2.09455818,0.60800644,0.07029143,0.0,0.96385477,0.30563226,0.0,1.03887987,0.16211857,0.0,0.28160718,0.0,0.66146533,0.35606434,0.0,0.0,0.0,0.0632738,0.0,0.15181308,0.52422557,0.3901153,1.51372628,0.0,0.0,1.93697829,0.40688776,2.45268848,0.17301660000000002,0.0,0.86790078,0.0,0.19796022,0.0,0.0,0.0,0.0,0.6918799,0.3326159,2.22179648,1.12231475,0.84463689,0.0,0.0,0.0,0.0,0.68422274,0.0,0.0,1.60551214,0.0,1.09824418,0.67633583,0.0,0.0,0.0,0.0,1.05955068,1.00624252,0.0,0.0,1.84652113,0.63872379,0.7336304,0.0,0.0,0.92170746,0.27745297,0.35319555,2.02780607,0.0,0.0,0.0,0.0,0.27834056,0.02668314,0.0,0.0,1.49372283,0.79891446,1.37568279,0.0,0.0,0.55764004,0.0,0.0,1.31824051,0.0,0.0,1.80339579,0.0,0.0,0.0,0.0,0.0,0.0,2.62811418,2.11036804,1.11214068,3.25595359,5.17792261,4.38692852,3.27965486,3.61447061,4.1045304,5.01088471,3.6584468,3.98609678,5.27097643,3.23432026,2.60860037,2.14027856,1.68334665,1.66925293,0.79083817,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
0.637125178,0.582642261,0.508914997,0.42701771299999997,0.344544339,0.265835463,0.193232601,0.12857827800000002,0.0742324918,0.0331620477,0.00807443857,0.0,0.006791542270000001,0.0227615366,0.0390605865,0.0457844649,0.0349201323,0.0035542895299999996,0.0,0.0,0.0,0.0,0.0,0.109095996,0.343673635,0.6483304,0.99594307,1.34767175,1.65905395,1.88774174,2.00130609,1.98344621,1.83723785,1.58467431,1.26255634,0.915587183,0.588138608,0.316429911,0.12273970699999999,0.0127816189,0.0,0.0,0.0344383526,0.0757259558,0.09775454789999999,0.09174641,0.0595981804,0.011665874599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.023880284100000003,0.0428680991,0.04332738269999999,0.0286104119,0.00900510257,0.0,0.0130720344,0.0612499716,0.145487221,0.25808745,0.38259515299999997,0.497084937,0.579100013,0.611040007,0.584641784,0.5033864920000001,0.382158826,0.24415965899999997,0.115761595,0.020523976,0.0,0.0,0.0285274617,0.102702349,0.17788352699999999,0.23068675,0.244085723,0.21154543,0.138522439,0.0409713979,0.0,0.0,0.0,0.0,0.0,0.0,0.0505821031,0.124964369,0.16556227,0.16221685800000002,0.11618118300000001,0.0397432471,0.0,0.0,0.0,0.0,0.0,0.0,0.0451369146,0.12145754199999999,0.165973488,0.16643823,0.12233329,0.0454758655,0.0,0.0,0.0,0.0,0.0,0.105879479,0.27938867,0.456742728,0.6077321370000001,0.7072072070000001,0.740375718,0.705625508,0.614263396,0.48732098700000004,0.350287461,0.227113032,0.134966636,0.0809973724,0.061806197800000004,0.065624709,0.0765051735,0.0793275671,0.0642511699,0.0294225244,0.0,0.0,0.0,0.0,0.0,0.0,0.0232615038,0.087675356,0.132822067,0.144560661,0.117097384,0.0551545585,0.0,0.0,0.0,0.0,0.0,0.0,0.0303818297,0.132598418,0.207155538,0.23117380399999998,0.19326385,0.0974634731,0.0,0.0,0.0,0.0,0.0,0.0,0.0531671332,0.30705599100000003,0.563016617,0.777411905,0.915087077,0.957290251,0.90584301,0.7824758390000001,0.623390816,0.470279139,0.359920686,0.314900899,0.337783916,0.41031038799999997,0.49801307,0.559333956,0.557192978,0.47027535200000004,0.30124754600000003,0.0797115161,0.0,0.0,0.0,0.0,0.253349809,0.8507080770000001,1.608033,2.44602366,3.26528215,3.96254198,4.44796621,4.66017185,4.57612387,4.21411384,3.62945326,2.90395961,2.1314846000000003,1.40239262,0.7899254509999999,0.34081427799999997,0.0714789602,0.0,0.0023799773000000002,0.12262390699999999,0.282138142,0.43869613399999996,0.5621223710000001,0.636515043,0.659169362,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.637842128,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0309086411,0.0,0.0371123321,0.051278162,0.034035504700000004,0.9197414540000001,0.41135135100000003,1.05866116,0.8888652090000001,0.0,0.5856508539999999,0.28932364899999996,0.0,0.0,0.0,0.246722379,0.0,0.0,0.0,0.129758114,0.0,0.0,0.0,0.0,0.012446828600000001,0.0,0.132014407,0.295679454,0.45137694,0.0,0.520063762,0.668086628,0.0828628214,0.47631204200000005,0.130591114,0.518525392,0.0,0.683004968,0.108983292,0.6919535240000001,0.0,0.0,0.37597604799999995,0.0,0.0,0.26105750699999997,0.0308327514,0.304072372,0.0,0.0,0.0,0.0,0.154572584,0.0,0.0,0.0,0.0,0.0132452808,0.0,0.0,0.0256493577,0.0,0.0,0.11143239099999999,0.0,0.347824695,0.80273344,0.0,0.146518748,0.314150146,0.5079171029999999,0.607183116,0.41597821,0.0,0.0,0.0490278193,0.335729744,0.0,0.0,0.00635965483,0.0,0.0,0.0,0.0,0.11810073300000001,0.0,0.0,0.0,0.0,0.224800535,0.0570480233,0.170186655,0.00407495593,0.9427944490000001,0.313914433,0.8841161259999999,0.9734816270000001,0.966081703,0.485834518,1.16966726,0.285897213,0.381672536,0.49106869,0.9857195790000001,0.420431934,0.341657059,0.332681892,0.58247471,0.937604551,0.43959033399999997,1.15009782,0.207699556,0.9594647740000001,0.756857633,1.06281798,1.26708373,1.35967967,1.77158758,1.74071679,1.22191264,1.13158718,1.64895067,1.92508146,1.59396987,1.48688572,1.3287440000000001,1.79575654,1.66776825,1.38913439,1.21599118,0.846068915,1.49299818,0.961677902,0.292928891,0.17748326600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.121044358,0.561110621,0.0,1.06484823,0.7308494870000001,1.83415056,1.60438724,2.74333407,3.28364898,3.66837919,3.33285929,4.3794664,4.80108289,5.32076362,5.0698137,4.92990717,5.31617875,5.73351437,5.69879935,5.155546,5.69605291,4.64577017,4.50226034,4.67027258,3.72662596,3.72327984,2.77286264,2.21298229,2.16610967,1.58825257,1.05393034,0.6429439889999999,0.900585527,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.415
1.6585216,0.79890457,4.01325389,0.27219324,0.38750024,0.73111968,0.0,0.0,0.18778869,1.05101879,0.0,0.0,4.62582784,3.11818542,4.32607409,3.49150085,0.0,1.87016706,3.90895827,6.74597234,0.63250068,0.0,1.91210067,1.06050232,0.0,0.0,0.0,2.00995936,0.0,0.11461919,0.70135467,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
1.21844478,0.584154524,0.18338995600000002,0.0281443519,0.0584259588,0.174943237,0.278603284,0.30319526,0.231575223,0.0923535998,0.0,0.0,0.0,0.0,0.0,0.0851308016,0.16281965,0.17636771199999998,0.125367428,0.0334632781,0.0,0.0,0.0,0.0,0.0,0.042185220700000005,0.0932824436,0.105318362,0.078666444,0.027805111,0.0,0.0,0.0,0.0,0.0,0.0130662604,0.0344067181,0.0382320338,0.0273629997,0.010216795899999999,0.0,0.0,0.0,0.0,0.0028444932899999997,0.0,0.0,0.0,0.0,0.0,0.004650352020000001,0.0342472025,0.0570331021,0.060584511900000006,0.0388018399,0.0,0.0,0.0,0.0,0.0,4.17214796e-16,0.0718818787,0.124777982,0.134783249,0.09239278769999999,0.00811424978,0.0,0.0,0.0,0.0,0.0,0.106807264,0.206624692,0.236054858,0.176099998,0.0408280325,0.0,0.0,0.0,0.0,0.0,0.144462429,0.32627015,0.400717645,0.326341316,0.114613034,0.0,0.0,0.0,0.0,0.0,0.202073317,0.573537659,0.77723083,0.7033268159999999,0.328217172,0.0,0.0,0.0,0.0,0.0,0.43499718,1.97354353,3.62564252,5.04714152,5.92481283,6.06101918,5.42943848,4.18516076,2.62563475,1.11328293,0.0,0.0,0.0,0.26209713,1.25452957,2.26654344,3.03089073,3.37312189,3.24694198,2.73064805,1.98949595,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
6.73257612,2.34784363,0.0,0.0,0.0,0.910515972,1.26534476,0.0,0.00848840278,0.613104302,0.0,1.23314966,5.54346925,4.32949247,0.346232516,0.942996802,1.71485039,0.41244015700000003,0.0,0.0,0.289635695,0.346113571,0.0,0.0,0.0569572316,0.0808890677,0.811150741,0.97926591,0.216870657,0.0,0.0590566087,2.30095992e-16,0.25703061899999996,0.560958135,0.00504681347,0.0,0.145475665,0.0,0.178882722,0.0,0.0,0.349463773,0.0,2.8761999e-16,0.363589867,0.0,0.50331521,4.0266798499999996e-16,0.0,1.47603111,0.0,0.0,12.119919900000001,9.36550948,0.0,0.8341894790000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.10403396599999999,0.711630421,1.35351898,1.86388003,2.13097599,2.13262703,1.93019547,1.62733136,1.31645075,1.04064568,0.789190752,0.526014891,0.232278105,0.0,0.0,0.0,0.0,0.0,0.25537726,0.392677372,0.318160867,0.07684488639999999,0.0,0.0,0.6447809870000001,2.02323928,3.96522037,6.08734498,7.85381132,8.74906805,8.46184804,7.00804768,4.7406322,2.23820254,0.11225829699999999,0.0,0.0,0.0,0.0,0.49396602,0.878806585,0.7830260840000001,0.335332014,0.0,0.0,0.0,0.0,0.0644537154,0.38877044299999997,0.488155471,0.33570542700000006,0.0313996516,0.0,0.0,0.0,0.0,0.262190402,0.427385539,0.39134584200000005,0.175729568,0.0,0.0,0.0,0.0,0.0343353565,0.265833445,0.36057040100000004,0.274265111,0.0536119745,0.0,0.0,0.0,0.0,0.167079025,0.38967289899999996,0.47177585299999997,0.38894333600000003,0.194721901,0.0,0.0,0.0,0.0145454111,0.161788168,0.23941441100000002,0.191974798,0.031888607,0.0,0.0,0.0,0.0,0.223131633,0.5572136010000001,0.81384153,0.929600636,0.901039875,0.777116925,0.6283441470000001,0.509864884,0.437528984,0.38808678700000004,0.321332318,0.210452503,0.06296216240000001,0.0,0.0,0.0,0.0,0.0733263264,0.17352746300000002,0.186093335,0.100075271,0.0,0.0,0.0,0.0,0.00542909578,0.162086426,0.24154381800000002,0.19656594,0.0429023843,0.0,0.0,0.0,0.0,0.118931694,0.30470789800000003,0.347994281,0.209570013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.511213913,0.8453995390000001,0.13403539,0.11094226800000001,0.71367788,0.0241219912,0.665737088,0.326838538,0.25856864,0.36039645600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00463563053,0.0246519344,0.0,0.109220728,0.148577574,0.8160302559999999,0.660373726,1.19686664,1.63787088,1.58117485,1.97446708,2.03037398,1.55566371,1.6752985,1.54018516,1.59852163,1.3263766000000001,0.622623324,0.68759253,0.13378256300000002,0.245787366,0.0,0.026723317599999998,0.0,0.0,0.0,0.114109813,0.029793523,0.0,0.0035263001200000004,0.0,0.187857761,0.0,0.0,0.0,0.498712447,0.310037806,0.0,0.07614982990000001,0.218709247,0.384423539,0.0955404075,0.0,0.0,0.0,0.17529342399999998,0.0,0.0,0.184718386,0.059783112199999995,0.0,0.0,0.32411547,0.130276824,0.269755519,0.0,0.0,0.0,0.0,0.0,0.0,0.321702394,0.20670332600000002,0.0,0.315219347,0.0,0.30471435399999997,0.38809309999999997,0.228749053,0.0,0.206068114,0.231703942,0.0,0.30847314,0.143765692,0.0,0.0,0.0,0.46135847,0.496710505,0.280361166,0.33703899600000004,0.0,0.16840600600000002,0.203278915,0.419510603,0.43570092200000005,0.0267092641,0.0,0.0,0.0,0.0,0.15656161400000002,0.0,0.0,0.276712043,0.0,0.36276613799999996,0.060515760300000006,0.630713164,0.259348932,0.211563155,0.704044291,0.0,0.0,0.111053316,0.0,0.0986366376,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0469864669,1.23462553,1.47596147,1.85020216,2.15589666,2.6384531000000004,3.18604401,3.69582689,3.59407354,4.18837327,3.78821699,3.91912278,3.3605236000000005,2.62705605,2.11626731,2.01064255,0.970818245,0.520953853,0.379755688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.408799526,0.42157083100000003,0.902170528,0.679214845,0.657964985,1.30155609,1.39353531,0.947479673,1.27550677,0.46821776200000004,0.752452042,0.77133059,0.428889732,0.21019374300000002,0.0,0.0343080791,0.0114273816,0.00824328405,1.00990188,0.806437665,1.40214095,1.56889621,2.03624807,2.18605065,2.17400055,2.48203026,2.61383891,2.6104976000000004,2.40204225,1.95360508,1.70758185,1.68428847,1.7502783,1.39449967,0.9718683140000001,1.02488577,0.797100085,0.414750606,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
1.8296119,1.4227386,0.977349703,0.511149913,0.085825395,0.0,0.0,0.0,0.0,0.145786967,0.260525777,0.231185062,0.0802836743,0.0,0.0,0.0,0.0,0.15827317800000001,0.39688611799999995,0.549459304,0.570206595,0.467641061,0.29501911399999997,0.12426853,0.0169925559,0.00485700676,0.0850493697,0.22876712300000002,0.395809646,0.548001053,0.6573117270000001,0.708516888,0.6986006459999999,0.635057425,0.53370518,0.41534976700000004,0.300814724,0.205297041,0.134413157,0.0842567762,0.0459156101,0.012207737199999999,0.0,0.0,0.0,0.0,0.0158110915,0.04337750889999999,0.0492874367,0.0268098823,0.0,0.0,0.0,0.0,0.0111049287,0.0629198921,0.0840280025,0.058492101399999996,0.0,0.0,0.0,0.0,0.0,0.0765396911,0.124147058,0.104623139,0.022944382599999997,0.0,0.0,0.0,0.0,0.0790969264,0.167709498,0.16781587,0.0714652015,0.0,0.0,0.0,0.0,0.0650233382,0.215993852,0.257079636,0.15389014,0.0,0.0,0.0,0.0,0.0228271769,0.28150315800000003,0.41052331799999997,0.316832533,0.0201264993,0.0,0.0,0.0,0.0,0.523029665,1.17216312,1.60463684,1.67874165,1.40597098,0.939665988,0.49516729299999995,0.24251108300000002,0.22721287199999998,0.36011625700000005,0.480598504,0.457641355,0.271771038,0.0300091953,0.0,0.0107439608,0.338150749,0.706757862,0.856794242,0.590207601,0.0,0.0,0.0,0.0,0.0,2.02252522,4.46019883,6.54520739,7.59955981,7.25285556,5.59541089,3.15133059,0.680248885,0.0,0.0,0.0,0.0,0.557520871,1.17097027,1.11530551,0.49177657399999997,0.0,0.0,0.0,0.0,0.282103127,1.34161502,2.24898719,2.81247058,2.99164172,2.86828196,2.57284726,2.21147259,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.0661556757,0.24397561899999998,0.408116569,0.509506244,0.524791866,0.460238569,0.347119357,0.23032179,0.153725035,0.14667605,0.215419026,0.341770344,0.48915299799999995,0.6139508,0.678638036,0.662712316,0.568214942,0.41832338,0.24962720100000002,0.10061187699999999,1.98108447e-16,0.0,0.0,0.000996741071,0.0294367377,0.027631169,0.0,0.0,0.0,0.0,0.0,0.0,0.0849206884,0.262309839,0.399085959,0.43529198,0.33029854399999997,0.08082904519999999,0.0,0.0,0.0,0.0,0.0,0.16059620300000002,1.23960671,2.57539898,3.99785415,5.29993953,6.27648568,6.76495657,6.67925508,6.02894516,4.91942287,3.53278639,2.09343599,0.825765544,0.0,0.0,0.0,0.0,0.711061059,1.57703951,2.38922595,3.00559648,3.33665626,3.35500993,3.0914769,2.62027522,2.03787716,1.44092756,0.90806757,0.488907491,0.20125674600000001,0.0356357756,0.0,0.0,0.0,0.0,0.00554910332,0.008889487120000001,0.00524453271,5.38911049e-05,0.0,0.0,0.0034040948600000003,0.007789286340000001,0.009789580090000001,0.00842037291,0.00448684216,0.0,0.0,0.0,0.0,0.0010073707,0.00160584799,0.0,0.0,0.0,0.0,0.0,0.0,0.007682896230000001,0.023772463900000002,0.0359331959,0.0386269534,0.028655451600000003,0.006800036329999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0443371531,0.0807897982,0.09660584480000001,0.0840395272,0.043471598099999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0434054146,0.124156505,0.17571261800000001,0.178776674,0.126726817,0.0289846716,0.0,0.0,0.0,0.0,0.0,0.0,0.19195283300000002,0.378993253,0.522227763,0.596742972,0.600938306,0.559953495,0.52165443,0.545605917,0.687438305,0.982457983,1.4328323,2.00201706,2.61841498,3.18796497,3.61305353,3.81342333,3.74410148,3.40597796,2.84639796,2.14955547,1.41896426,0.7561934490000001,0.24089430399999998,0.0,0.0,0.0,0.0,0.10417425,0.23976292899999999,0.31175295199999997,0.308519688,0.242623635,0.142637613,0.0418109457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0694430585,0.136197991,0.17317247,0.158606781,0.0855806125,0.0,0.0,0.0,0.0,0.0,0.17152716899999998,0.577751489,1.05901433,1.53993292,1.93676572,2.17618179,2.21250071,2.03893672,1.68982005,1.23305775,0.754624507,0.338956436,0.0501863133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.193733839,0.117155021,0.083442944,0.043007364299999996,0.0899567688,0.143529826,0.567709851,0.0,0.571348859,0.506126936,0.0,0.0059017817799999995,0.0,0.0413381072,0.436378418,0.588580591,0.046944081,0.168125628,0.7222268079999999,0.496689465,0.594164285,1.15749666,1.0541675,1.28877797,1.28387425,1.34776099,1.55394759,1.49899561,1.08768595,1.26527418,0.7752717379999999,0.987909265,0.9331829540000001,0.5596108470000001,0.324813901,0.46835594399999997,0.378212349,0.13694545800000002,0.0,0.0,0.270884483,0.25485115399999997,0.0,0.061535545700000006,0.0,0.0142813504,0.0812176226,0.0,0.198297525,0.07537162730000001,0.17601719300000002,0.46001961700000005,0.184342995,0.013499271399999999,0.21229242199999998,0.0112469083,0.0183623544,0.0,0.0835259127,0.014527670800000001,0.291142406,0.0,0.0,0.0,0.0,0.0,0.20118685,0.0,0.0,0.216372443,0.0,0.0,0.0,0.0,0.0,0.351162168,0.0,0.40134084299999995,0.0607278555,0.0,0.0,0.0,0.20937708,0.0,0.0668933585,0.295769206,0.0221567786,0.0,0.0,0.24596685899999998,0.0,0.21062504399999998,0.32413369399999997,0.14908268800000002,0.342196954,0.0,0.0,0.0,0.0179326969,0.35744449899999997,0.0,0.0,0.318499363,0.367751714,0.0,0.316932902,0.0,0.33202328,0.021257355099999996,0.0628794186,0.0,0.0,0.0,0.0,0.0,0.0885376298,0.23474151199999999,0.32129138100000004,0.144065149,0.0,0.0,0.2893022,0.034154665099999995,0.0,0.057510926799999994,0.0,0.0,0.0,0.0,0.12804809,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22080191,0.249230927,0.0,0.0,0.0127090129,0.33500284,0.0817536996,0.195425491,0.991567731,1.08898022,1.05553414,1.41206524,1.47640378,1.35135496,1.23427731,0.988051502,1.24623097,1.20680832,0.8412357559999999,1.32987588,1.20253338,1.16268831,0.631489634,0.487171236,0.180111692,0.34783654,0.0,0.0,0.0,0.0,0.23052741899999998,0.0,0.0,0.0,0.0,0.16568034,0.115113794,0.334614574,0.042610941500000006,0.09509352800000001,0.591055864,0.147140453,0.07294181200000001,0.198573687,0.550515864,0.379219587,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.52208763,0.333360832,1.31730066,1.0448964,1.65804217,2.39021589,2.62322584,2.90825559,3.42273186,3.39272865,3.98139399,4.32716089,3.55780612,4.01685806,4.10067736,3.20831669,3.01419294,2.95525911,2.50667307,2.07276678,1.71209669,0.963071572,1.17212775,0.24166960699999998,0.569872736,0.0,0.273657992,0.0,0.13797133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.294164039,0.0,0.0248399958,0.0,0.538026033,0.717528035,0.0,0.0,1.70600078,0.147787515,0.612193814,1.32332774,0.57602296,0.26934285199999997,0.09966444210000001,0.317275684,0.0,0.0,0.14806836,0.340859755,0.539349258,0.9307362509999999,0.0,0.42278490399999996,0.5257280529999999,0.0,0.0,0.32423699300000003,1.96628595,0.8462912920000001,2.94207692,1.53895864,1.88528414,0.921984473,2.03123661,1.37971002,0.46107006799999994,1.39529905,0.521595488,0.0,0.0,1.34295712,0.296031483,0.945844007,0.6834606870000001,0.081830179,0.99475862,2.82690795,2.34236936,2.43253791,2.35855179,3.23510537,4.73915858,3.55706525,2.86080799,2.73352437,2.54657072,2.05956711,1.53620188,0.512271622,0.587975689,0.13089557,0.0,0.117979789,0.0,0.0,0.08591969140000001,0.0,0.0,0.36502303700000005,0.0,0.268113455,0.0,0.0,1.66793925,1.53193433,1.08883279,0.0,0.0,1.17696152,0.0,0.788029111,0.0,0.0,0.0,0.0,0.0,0.6768725290000001,0.88691363,1.0578848,0.8488833370000001,0.0,0.0,0.0,0.480576212,1.04799717,0.0,1.14112864,0.0,0.0,0.0,0.238545578,0.0,0.814296514,0.49633407,0.219049388,0.906560818,1.33697207,0.8314424220000001,2.03232336,2.84655196,0.42094644,0.0,2.10714031,0.5114888879999999,0.0,0.372448922,0.15526251800000002,0.061523830599999996,0.0,0.0,0.0,0.421722476,0.37005666600000003,0.46490736,0.0,0.0139722715,0.0,0.0,0.558628658,0.275942445,0.498911605,0.0,0.0578891825,0.0,0.0,0.686589605,0.9016552090000001,0.0672843548,0.9690633679999999,0.0710235828,0.0,0.0,0.0,0.0,0.207499985,1.27276964,0.725793805,0.0,0.287895296,0.0,0.499524953,0.0,0.419513849,0.0,0.0,0.0,0.33659395799999997,0.0,0.216366413,0.576697302,0.592482733,0.548413371,0.0,0.238326316,0.7005055290000001,0.0,0.0,0.0254013594,0.24758455,1.2905138,0.815382478,0.0,0.411514735,0.584351019,0.337660016,0.315680883,0.0,0.0,0.91035059,1.3032968999999999,0.0398425367,0.0,0.0,0.0,0.0,1.02465481,0.0,0.0,0.5724311529999999,0.0,0.905202362,0.9422151809999999,0.356050473,0.11765650000000001,0.0,0.7590193479999999,0.0,0.0,0.8757731440000001,0.64161711,0.0,0.469200685,0.0,0.0,0.216085623,0.0,0.554666088,0.0,0.742654736,0.0,0.755825722,0.118583058,0.517138457,0.182277154,0.5830401820000001,0.7341773779999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
2.7242835,1.37635323,0.021237053500000002,0.0,0.0,2.20139717e-17,0.420225122,0.38081344,2.08872035e-16,0.0,0.0,0.0,0.304329022,0.303890124,0.0,0.0,0.0,2.10290023e-16,0.373281414,0.40916811,1.80108697e-17,0.0,0.0,0.12211305800000001,1.47763005,2.78800264,3.30767108,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.379
0.273185244,0.367029019,0.38686029200000005,0.11670696400000001,0.392418311,0.0,0.299856306,0.0,0.0,0.0,0.07281176519999999,0.0,0.0,0.263777522,0.0187524607,0.0,0.0,0.0,0.0,0.20262424699999998,0.224245317,0.0,0.0,0.0,0.144015624,0.0,0.26392595,0.22253289999999998,0.0,0.303738552,0.0916045523,0.230645517,0.0,0.30501303,0.27709436600000004,0.259143154,0.31373170699999997,0.0,0.25485346,0.26147296600000003,0.0,0.260641255,0.0,0.08120720299999999,0.0171409282,0.081290939,0.0,0.272005641,0.0,0.118936551,0.00826343653,0.0865351882,0.0,0.0,0.0,0.184101988,0.0,0.155910978,0.0509175121,0.02213929,0.0,0.0,0.0,0.36442014799999994,0.0,0.299871309,0.292952822,0.238789723,0.047914445300000004,0.20556180300000002,0.0,0.000639936657,0.15300397,0.0,0.0,0.0,0.0,0.0,0.152508538,0.105343627,0.0,0.221551208,0.0,0.286737982,0.190870942,0.165506547,0.2294795,0.21620525,0.0,0.0320336299,0.0,0.0,0.0,0.0427588688,0.0,0.177581337,0.0817865598,0.126809661,0.0,0.0,0.0756936585,0.0,0.059270981900000005,0.163747438,0.19300399899999998,0.0,0.0403478869,0.125488745,0.0657548565,0.0,0.316610452,0.36047642,0.271679249,0.0,0.208445997,0.186422808,0.500908461,0.358782052,1.08148516,0.9445474620000001,1.34442023,2.1243569,2.31656998,2.35633277,2.83511376,3.20591623,2.93115834,3.41099131,3.27898277,2.87822361,2.42974043,2.61076553,2.30912688,1.93047851,1.64953072,1.02278919,1.08268961,0.5715518310000001,0.304201312,0.26317666100000003,0.366943015,0.20470712800000002,0.321078347,0.242854751,0.0565970783,0.0,0.0,0.0,0.0,0.0,0.0,0.256761156,0.0,0.0,0.0,0.220004458,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.02839714,0.39402054,0.0,0.92382131,1.05659918,1.29232563,0.26524255,0.57132943,0.96207589,0.78841405,0.67834899,0.45194343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04384465,0.68560119,0.90611226,0.26055131,0.55317257,0.0,0.22386286,0.0790026,0.0,0.0,0.03230897,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07598052,0.37713154,0.61674602,1.06123818,1.29201877,1.03748583,0.64320671,0.55750694,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.58024501,1.47306621,1.97670616,2.76354271,3.93298778,4.71832393,4.9954946,6.07901519,5.43269004,5.82850362,5.4083651,5.98435002,4.54509629,4.50132793,3.64468389,2.32565829,1.65603971,1.71990964,0.90279384,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
4.7314379,5.03856671,3.60704065,3.42918594,1.79258379,1.9664816000000003,0.86387305,0.010434435,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.688455464,0.085262042,0.45401802700000005,0.0,0.7673674309999999,0.249026308,0.059007707300000004,0.0,0.0,0.0,0.175795475,0.0298956915,0.00262635808,0.365815512,0.0,0.0,0.34213101100000004,0.0,0.0,0.331907766,0.48462810799999995,0.0636334864,0.0,0.0,0.0,0.0,0.0,0.29433892300000003,0.019299540900000002,0.200901255,0.0,0.46137634299999997,0.381248628,0.0,0.0,0.0,0.0976442839,0.28528112899999997,0.0,0.0,0.134807424,0.450166378,0.0,0.734700114,0.127804243,0.908931721,0.7632605370000001,0.0,0.0,0.40655267,0.0,0.0,0.0,0.630905129,0.539911751,1.25204321,1.38609668,2.55981246,2.47083524,4.041732700000001,4.07220161,4.34866126,5.33660955,5.26472057,5.09110194,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.311741515,0.524817967,0.630762326,0.46429454,0.20307492,0.527651371,0.452610956,0.227450391,0.204249063,0.0,0.297129594,0.183956801,0.0,0.0,0.07777593669999999,0.0,0.0,0.11031650400000001,0.117259807,0.0,0.0,0.0762287496,0.0,0.22136050899999998,0.0,0.11277690900000001,0.0,0.362391719,0.0,0.349385894,0.24678639800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.027671439199999998,0.0,0.0,0.0,0.0,0.0,0.470480268,0.270297617,0.0,0.280619322,0.0,0.37846420299999994,0.37637916299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23430039800000002,0.0,0.0,0.36269832799999996,0.309995418,0.08235306839999999,0.0828482238,0.359412513,0.0,0.238571258,0.206185103,0.0,0.0,0.0,0.0,0.00956446745,0.0,0.111267184,0.26581869199999997,0.0,0.10911477800000001,0.48995644899999996,0.460053947,0.222100783,0.185140256,0.539905376,0.265638027,0.425015197,0.333071481,0.148955531,0.0,0.0,0.0,0.0,0.0204401011,0.0,0.335236223,0.0514867763,0.056303501900000004,0.5794739879999999,0.515990204,0.647356632,1.35738361,1.28860865,1.17787822,1.60562264,1.2975278000000001,1.26589747,1.11219992,1.36453603,1.09927585,0.867676619,0.598464876,0.829929667,0.3728578,0.27987423,0.599721246,0.861423775,0.8110723009999999,1.00080863,1.80558881,1.78036861,2.20702285,2.8548213,2.78179721,2.9424101,3.04436217,3.07157553,3.47739046,3.52005793,3.39926403,3.11326127,2.72419196,1.88715521,1.74319237,1.12408907,0.7541526959999999,0.212995766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.131570978,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
2.6158407,0.0,0.58389711,0.0,0.0,0.26331203,0.0,0.58048679,0.11278088,0.87792784,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.15046587,0.91360956,0.0,0.0,0.0,0.0,0.0,0.2653942,0.3275956,0.0,0.0,0.0,3.16249326,5.53190209,0.26267416,0.73431898,0.65352161,0.31698784,0.37845807,0.0,0.0,0.0,0.2572993,0.72200343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.38030956200000005,0.0,0.0,0.160345757,0.0,0.0,0.0,0.299954682,0.158433519,0.56742076,0.0,0.150948706,0.6848436840000001,0.713963818,0.549464003,0.771526195,0.807239513,0.8755692629999999,1.07775051,1.90227627,2.55012576,2.45172182,3.04157665,3.68417868,3.7115172,3.81229536,4.35378777,4.04576075,4.43273405,4.27046188,3.98249638,2.61696898,2.53285831,1.95537598,1.39593512,0.0948191502,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15018827099999998,0.0,0.7153959670000001,0.40779171700000005,0.0,0.11715201900000001,0.357807225,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07266456730000001,0.335049542,0.294079787,0.35898623,0.7282226709999999,1.11807626,0.35713881,0.503762002,0.585240538,0.625051138,0.495360966,0.284441435,0.0910869634,0.514455031,0.609932703,0.0,0.39530829700000003,0.28752959699999997,0.0765302878,0.535640796,0.057133322199999996,0.39503077600000003,0.494797407,0.6899547840000001,0.0,0.0,0.26980295,0.0,0.0,0.0,0.0,0.42244486700000006,0.21896287,0.361260476,0.0,0.248051412,0.269908339,0.0409985589,0.189518157,0.19294644,0.0,0.332111426,0.0,0.0,0.0,0.0,0.286549922,0.0,0.0022233977600000002,0.0,0.262011498,0.47529152,0.42359654700000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.401
0.253733301,0.0,0.769195893,0.49035327100000003,0.392487884,0.0,0.327733255,0.0,0.0,0.0477615672,0.6815253290000001,1.10337918,0.0,0.0202728477,0.575501886,0.0,1.34858976,0.0,0.127628259,0.0,0.0,0.0,0.42904543700000003,0.967281937,0.201035663,0.0,0.084600903,0.8208431690000001,0.394983662,0.0,0.0,0.16804237600000002,0.40034976,0.15267001,0.0,0.0,0.0,0.0,0.11500737,0.05925725230000001,0.0,0.6894512909999999,0.794450553,0.5587618320000001,0.559578934,0.0,1.211342,0.763117575,0.755624341,1.06940054,0.902837965,1.22261045,0.0641765499,0.731533575,0.9753359109999999,0.5984571329999999,1.70575684,0.0,1.21096942,0.8513252040000001,0.0,1.27276434,0.43868401100000004,1.0155878,1.3131204,0.472738671,1.24852438,0.709977689,1.51844473,1.01566479,0.7839393720000001,1.384239,1.19080998,1.10152428,0.718912065,1.29946276,0.16020057599999998,0.30746509,1.08543075,0.947824142,0.7026267159999999,0.291220594,0.777181459,0.12352759,0.330344052,1.05442199,0.302210128,0.629650135,0.0,1.21047656,1.0658238000000002,1.1931935,1.22336908,0.5505909999999999,0.767768234,1.11698219,0.24099426399999999,0.8584964209999999,1.45178195,0.0,0.0,0.146481572,0.332601222,0.53176287,0.0,0.0,0.8461907390000001,0.256857952,0.38124026899999996,0.568030689,0.036166946299999995,0.012727919099999999,0.315373593,0.0,0.0,0.397954684,0.0,0.945596135,0.0,0.0,0.0,0.7657559970000001,0.0,0.0,0.60928542,0.19317446,0.0,0.0,0.623646226,0.366377965,0.269468435,0.0,0.355856758,0.0,0.0,0.0325014806,0.0,0.854251698,0.0,0.18089300100000003,0.0,0.0,0.501321545,0.050700440199999995,0.0,0.0,0.37030968799999997,0.202179268,0.532963685,0.32350283399999996,0.865446319,0.241214095,0.821253888,0.326632553,0.197585555,0.997900876,0.6170637729999999,0.6350293029999999,0.0,0.856006954,0.583330328,0.842501033,2.04345952,1.5615003,0.9942332009999999,2.27878522,1.35809484,1.11722778,2.00612183,1.88888275,2.49230292,2.7662283,1.5356435,2.20147917,1.10564061,1.91695525,1.25715186,2.1925707,1.20331486,1.05586251,1.51592515,1.1564495000000001,0.716221854,1.01929984,1.0921370000000001,0.5982135000000001,2.07530128,1.70035306,1.98114314,1.61193647,2.26479126,1.22721935,2.27161839,2.64165634,2.08747485,3.51383058,2.95141146,1.37247976,2.55843,1.41139914,2.06106039,2.33148329,2.40023416,1.75827565,0.769842111,1.06442363,1.22541599,1.51054195,1.61925571,0.601558419,0.060983069400000006,0.64631612,0.317695997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.625749025,0.322899851,0.0326043669,0.0,0.56750513,0.0,0.322994203,0.428138225,0.0,0.0,0.0,0.0,0.0,0.28363218,0.0,0.348307384,0.0,0.0359747746,0.31851567199999997,0.0,0.0472833816,0.614840315,0.23941230600000002,0.0,0.0,0.199915696,0.0,0.0,0.0,0.0518122484,0.0,0.061645797,0.0,0.0,0.36649883200000005,0.0,0.0,0.189323968,0.0,0.48860381399999997,0.0,0.07429017730000001,0.0,0.0,0.0734136258,0.106220165,0.0250021071,0.36558151299999997,0.311715829,0.0,0.273398803,0.483106689,0.5274381539999999,0.0,0.261628566,0.08770516880000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.505919394,0.0646169853,0.0,0.046521877,0.6285089739999999,0.06368194690000001,0.18426298600000002,0.0612660777,0.0,0.149408155,0.0,0.0,0.0,0.0,0.0,0.0,0.301111223,0.463839203,0.125100841,0.42822023600000003,0.852126933,0.974771945,0.864672584,0.868163615,0.158311689,0.327140967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7161954,1.26458573,2.26325142,2.10510368,3.6328324999999997,3.97328981,4.46366459,4.9278492,4.74206693,4.89261248,5.08590678,5.11387243,4.16570227,3.76070263,2.56960377,2.54701051,1.18512239,0.386301137,0.340046192,0.009142532890000001,0.0,0.0,0.0,0.0,0.0332216361,0.0,0.0,0.575732495,0.0,0.158578719,0.604286411,0.9083455340000001,0.6162514579999999,0.205846643,0.0,0.224832957,0.0,0.0,0.0,0.257864673,0.0,0.33988473,0.0,0.404728239,0.155912683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
0.17966704,2.00315129,0.35898420200000003,0.0,0.270519187,1.30871422,0.0,0.0,0.0,0.0,0.603210519,0.0,0.0,1.00045221,0.438620939,0.543775445,1.05017523,0.110835007,0.225528948,2.36163375,1.89165974,2.07734542,4.2146457,3.85417847,4.56665577,1.7392535,0.05191325980000001,0.0,1.45180675,1.3089248,0.51501864,0.0863758519,1.02078594,1.5651286,0.0,0.7686036070000001,0.0,0.0,0.08662155,0.7059168490000001,0.0,0.055223073,0.0,1.93140162,0.660751356,0.843250385,0.0,0.325788791,0.0,1.02943082,1.07108379,0.48790657200000004,0.09287384109999999,2.87148819,0.686073523,2.02022554,3.39556091,3.0933148999999998,1.74854003,0.8337474340000001,0.8316246629999999,1.47425813,0.0,0.0,1.19585263,0.154723798,0.0,0.0,1.14623585,0.0,0.0,0.0,0.0,0.0,0.0,0.2763394,0.345488607,0.25623151899999996,0.375231782,0.0,0.0,0.73489188,1.17763716,0.0,0.042938143,0.0,0.630786952,0.49073350299999996,0.0,0.0,0.204302907,0.19901913899999998,0.34008757100000003,2.30720593,0.0844423207,0.834464943,0.0,0.0,1.01796971,0.0,0.0,0.0,0.0,0.0,0.177707786,0.0,1.41992479,0.365601402,0.0,0.22705796,1.80626403,0.43832819100000003,0.0,0.06534133019999999,0.400731082,0.0,0.0772636346,0.0,0.0,2.06053125,0.0,0.0,0.945168375,0.0,0.7587959879999999,0.28579331199999997,0.0,0.0,0.0,0.8192235929999999,1.54312927,1.1412466,0.41043274799999996,0.28237829600000003,0.267165291,0.0,0.0,0.8938329490000001,0.0,0.0,0.0,0.0,0.8718866809999999,0.0,0.39524661200000005,1.05102318,0.0,1.5373375,0.44956428299999995,0.7449205990000001,3.24787645,1.06206789,1.29210406,0.891271576,2.30180897,0.56322624,0.0,0.0,0.202395615,0.47356404,0.0,0.7688717559999999,0.0,0.301247367,0.0,0.0,0.0,0.568248269,0.0,0.0,0.0,0.227863801,0.0,0.274753128,0.09831854039999999,1.42978795,1.52804953,0.0,0.0,0.62974711,0.520660664,0.0,0.926114715,1.17253535,0.0,0.650459833,0.0,1.67377791,0.47959638299999996,3.55688983,1.60289416,0.0,1.00266749,1.81997788,0.0,0.784365205,0.173291688,0.0,0.0,0.428886439,0.0,0.0,0.0,0.0,0.0,0.658505772,0.050843235,0.0,0.120403303,0.0,0.707503034,2.63301306,0.0,0.0,0.114460591,0.0,0.0,0.0,0.0,0.0,0.6253235429999999,1.04944249,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.45265388700000003,0.36694614799999997,0.189827314,0.542678992,0.0,0.0,0.192057888,0.0951207142,0.18758356899999998,0.0,0.0,0.0,0.0,0.0,0.496784533,0.0,0.330953925,0.160997478,0.37535107,0.0,0.0,0.365593555,0.0,0.407629267,0.0,0.0,0.365852301,0.328079441,0.0,0.0,0.0495267703,0.16741636,0.0,0.0,0.0,0.298915423,0.0,0.0894398592,0.242638226,0.069070406,0.0,0.013704256699999999,0.183445085,0.0,0.00976426807,0.23584941199999998,0.06773530629999999,0.124134465,0.15463759,0.23893818600000002,0.0,0.180517327,0.0,0.295849882,0.0393029935,0.0,0.39125749200000004,0.0,0.0491282847,0.0,0.0,0.0,0.0030202708799999998,0.0,0.403673193,0.0,0.0,0.132585203,0.490261644,0.457823596,0.0,0.236149019,0.24961966,0.254179957,0.264082322,0.162517768,0.0,0.37714104200000004,0.144017233,0.0730005701,0.0,0.18335527899999998,0.542206698,0.0,0.14433275199999998,0.25712615899999997,0.252740197,0.024642497200000002,0.23014577100000003,0.770884702,1.19984944,0.6991926629999999,0.793562544,1.13333139,1.22913847,0.519458154,1.00166628,0.49841064,0.0431510838,0.286795171,0.281950953,0.885081186,0.743420913,0.752828747,0.37037659999999994,0.505443259,0.628634249,0.47384866299999995,0.47865784299999997,0.19463371100000001,0.0,0.176599101,1.24274015,1.33188107,2.26421389,2.93717321,3.42412226,4.30024719,3.94644192,4.58369652,3.8916157,2.83733645,2.45533466,1.52000153,1.25050834,1.04848351,1.00129471,1.02601488,0.8670514109999999,1.36262258,1.66868026,1.48601727,1.9030456999999998,1.8387021000000001,1.72693451,1.59062244,1.53710039,1.30459449,0.879304185,0.6984722170000001,1.0776068,0.541919532,0.542874461,0.35255804,0.5887036520000001,0.663577541,0.434900634,0.0,0.0,0.0,0.0,0.174727861,0.007700377690000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.617894662,0.842614003,0.75018414,0.816075068,0.006394328889999999,0.25804534100000004,0.42871093899999996,0.0,0.043512812000000005,1.6654327000000002,2.31225292,3.34648172,0.0,0.46182707,0.0731560002,0.40464531600000003,0.12150631199999999,0.0688384767,0.0,0.0,0.0,0.120198594,0.00268620445,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
2.42782657,0.920356982,0.0,0.43207247600000004,0.44098384399999996,0.0,0.7773848329999999,0.17781033300000001,0.027030368399999997,0.07586876440000001,0.784087538,0.0,0.0,0.105434359,0.0,0.0,0.0,0.405097376,0.224055907,0.122980021,0.0,0.0419139789,0.0,0.0,0.35603904399999997,0.00806815782,0.0,0.0,0.6929316790000001,0.0726741759,0.0,0.243164771,0.151603945,0.0,1.0389084000000002,2.2589523999999996,0.5386455410000001,0.230961903,0.152219733,0.0697139697,0.0,0.0551323746,0.0,0.611199578,0.104310023,0.042700474,0.0,0.654251571,0.0,0.0,2.1561199,4.16789488,1.98379603,0.0,0.0,0.969723824,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18045337399999997,0.0,0.0,0.0,0.0,0.0,0.302661611,1.14083848,2.02741395,2.6514275,2.03855025,3.35768375,4.26986889,5.1620492,4.19635246,2.02292264,1.0891879999999998,0.0596639025,0.174518786,0.59175193,0.438098119,0.165390601,0.0,0.21447640699999998,0.0,0.5438564379999999,0.8651487309999999,0.648079064,0.9510039570000001,1.75583404,0.906514615,0.636414276,0.940991679,0.0939578459,0.0,0.752528545,0.0396969227,0.0,0.5065151170000001,0.00691118569,0.0,0.721673008,1.90029519,1.57363143,0.154526721,0.265013496,0.0,0.0,0.0,0.0,0.0,3.29760795,5.22736084,1.13355027,0.0,0.809928083,0.303434859,0.0,0.64639961,0.906872717,0.13128520800000001,0.0,0.205146205,0.0,0.0,0.0,0.0,0.09624733099999999,0.41080832,0.38245043799999995,0.0,0.55969624,0.0,0.0,0.0,0.66773317,0.0,0.415367559,0.355066262,0.265606708,0.0,0.18616229899999998,0.0,0.0,0.590968681,0.0855737797,0.0258875825,0.273862487,1.14043356,1.47726544,2.73243436,2.16079851,0.39779593799999996,0.57404539,0.886682162,0.0,0.08912413820000001,0.229897328,0.0,0.0,1.02378154,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.33388092399999997,0.595382298,0.0,0.0,0.0,0.810717305,0.0,0.0,0.0,0.0,0.0,0.584651864,0.0,0.162430532,0.768898848,0.296568838,0.15737836300000002,0.927516455,0.0,0.0,0.149655863,0.0,0.0,0.565804071,0.0,1.34914455,0.23507594,0.0,0.281873514,0.184688055,0.0912370091,0.0,0.0,1.21641578,0.24847343300000002,2.67610082,2.15677499,1.82203361,0.557892624,0.26021973,0.8726736979999999,1.82782645,0.390683794,0.0376744274,0.59720159,0.561889909,0.7258667459999999,0.0,0.0,0.518522678,0.568034581,0.188291552,1.14440237,0.0,0.0,0.0,0.335436935,0.723222765,1.1979953,1.67462368,0.199608232,0.792542238,0.0,0.0,0.7249899129999999,0.0,0.0,0.0,0.103373515,0.854586775,0.0,0.0,0.0,0.9205615779999999,0.398317986,0.49065363,0.7954161129999999,0.317668716,0.239914655,0.662053251,2.40615013,3.85311568,2.41758457,2.5618517000000005,0.0,0.0,0.0,0.323931978,0.0614680619,0.410859591,0.0,0.0,0.0,0.9617836890000001,0.0,0.578609368,0.7981740909999999,0.0,0.8125715059999999,0.0,0.0,1.0371801,0.0950375624,0.0,0.755380361,1.2725156000000002,0.0,0.0,0.791997827,0.0,0.485194377,0.0,0.0,0.48683962299999994,2.05131301,5.91243508,9.85385997,11.552222800000001,11.0639489,7.30407826,3.39129209,0.27169152399999996,0.0,0.0,1.21080071,1.18129308,0.0,0.175425836,0.0,0.282963745,0.706455615,1.49783537,1.15477478,0.602930678,0.0,0.0820406524,0.9239501390000001,0.664412808,0.0,1.28897558,1.24769822,0.22584320000000002,0.0,0.0,0.0,0.41530908899999996,0.0,0.0,0.0,0.255774582,0.652359629,0.0,0.0,0.63593693,0.826637416,1.57092758,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.529340815,0.625767063,0.725697613,0.44281557899999996,0.910274987,0.9315209729999999,1.14953551,1.0302052,1.31262911,1.56157316,1.62700647,2.08902018,1.84125945,1.88086029,2.39195802,2.52794085,2.70942542,2.84060728,2.95179561,2.75317006,3.12926194,3.14821543,3.22644227,3.03047386,2.78474821,3.24620465,2.79840706,2.94222374,2.54588958,2.62721573,2.64956664,2.6145152,2.65920558,2.52686684,2.11466767,2.17435694,1.88840806,1.68856712,1.96311453,1.72069041,1.33698777,1.54096421,1.22776729,1.00739802,0.802396762,1.1927783,1.09892022,0.7758777259999999,1.1069711000000002,0.565447192,0.54570898,1.04040333,0.709184719,0.67000627,0.6052750029999999,0.827467623,1.03377686,0.47176641799999997,0.73779294,0.502278674,0.5022021170000001,0.5980759,0.244336427,0.461334425,0.439926159,0.035767921800000005,0.485238551,0.0,0.111280394,0.11265535900000001,0.0,0.0,0.161891819,0.126064956,0.0,0.07138215490000001,0.147459325,0.0,0.0877539726,0.116657465,0.0,0.271199255,0.215223759,0.0,0.285884951,0.304170042,0.0,0.00507769976,0.127091202,0.0,0.0,0.24004936300000002,0.214076718,0.0683207312,0.0719919437,0.21803698100000002,0.0,0.0851324326,0.0,0.23430056300000002,0.09760137960000001,0.259848229,0.0930187743,0.0,0.0,0.0,0.0,0.271815714,0.0,0.0964451168,0.140420873,0.0,0.144762961,0.163500381,0.013105254399999999,0.00162288334,0.187341058,0.0,0.235836844,0.0,0.0,0.216169465,0.137035026,0.0,0.0,0.27023822,0.0,0.146423575,0.0,0.0,0.21310327699999998,0.00789043816,0.0,0.149118159,0.0,0.0,0.0,0.0,0.0,0.052245247300000006,0.132533116,0.101823701,0.254481134,0.0,0.00902686662,0.0098087933,0.0,0.0,0.319055521,0.0,0.015294863300000001,0.0,0.0,0.23042858300000002,0.23161469699999998,0.17694823699999998,0.279833473,0.269394838,0.0,0.0,0.0,0.0,0.277638822,0.29186233,0.0,0.254413761,0.0,0.198702845,0.0,0.0,0.07038704900000001,0.0148728527,0.0,0.0,0.09270276849999999,0.0,0.0661232242,0.0314222074,0.18554732100000002,0.0,0.0,0.0,0.0,0.0,0.0406699376,0.0,0.154684266,0.0,0.12008341,0.0,0.0,0.0,0.0,0.0,0.118470492,0.31738248,0.0,0.17760136399999998,0.0373945227,0.361419916,0.0,0.0,0.204601612,0.189421395,0.10699886,0.40604905,0.248741026,0.0,0.11474104800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.364787305,0.310423538,0.32757254399999997,0.016509466100000002,0.333072113,0.0,0.146662778,0.0,0.0,0.0,0.043130454500000005,0.237862071,0.0,0.274735756,0.31999511199999997,0.31190725399999997,0.25945993100000003,0.269943508,0.186280773,0.211204415,0.0150146958,0.0,0.149308568,0.432377585,0.517546327,1.20024388,1.56821951,1.04515805,0.9069414000000001,0.43114084700000005,0.0,0.0,0.556386418,0.799026288,0.668954191,0.7531805909999999,0.78143287,0.195313337,0.020240013,0.0,0.0,0.276045869,0.0,0.0,0.09835954470000001,0.11947144400000001,1.02331096,2.43628441,2.88795324,2.75266617,2.27668116,1.26804007,0.738059914,0.35193461299999995,0.495444675,0.902874877,0.749911585,0.395048091,0.0,0.0,0.0,0.270401161,0.24664142600000002,0.19525901,0.283005246,0.0,0.0,0.09524955130000001,0.493028701,0.539239138,0.124244414,0.0,0.0843473684,0.0,0.570028058,1.50353309,1.70256402,1.87215079,1.48255987,1.13883935,1.00850361,1.35306357,1.47067618,1.52859978,1.51520137,1.06868363,0.632744753,1.17411956,1.9754415,2.51130566,3.24824801,2.98310569,2.26006303,1.1849919,0.709099488,0.8435727679999999,1.22810202,1.27996095,1.0308225,1.11175604,0.46521640299999995,0.5248620279999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.27262504,0.0,0.67058851,0.71461626,0.3656551,0.30575631,0.35825552,0.43937813,0.73475181,0.75573744,0.69522753,0.39823797,0.88518788,0.30653058,0.30736343,0.62572033,0.15555512,0.28126688,0.0,0.05577234,0.04642887,0.0,0.0,0.0,0.16096667,0.0,0.45778131,0.185089,0.57885957,0.53467307,1.01231549,1.29610609,1.16889483,1.56414692,1.27040879,1.46530019,1.65107234,2.0170985,1.43885384,1.97133139,1.77110051,1.55054004,1.73998295,1.41701645,0.88667726,0.91226266,0.91434018,0.79322174,0.55848666,0.39476341,0.04704994,0.45453833,0.23796289999999998,0.24302087,0.0,0.19434210000000002,0.0,0.14837153,0.0,0.22811626,0.0,0.0,0.0,0.0,0.21780337,0.28581452,0.23089810000000002,0.16022750000000002,0.02018837,0.0,0.0,0.20016688,0.0,0.0,0.0,0.0,0.08612768,0.0,0.24870062,0.34101829,0.30033463,0.64259649,0.93928472,1.08600991,1.59209211,1.37359826,1.75849546,2.02524692,2.6247535,2.61365123,3.04132191,2.87061523,2.83841293,2.98045401,3.51118764,3.27352924,3.45306103,2.92111285,2.90762079,2.70510891,2.67950489,2.53761873,1.89338632,1.53882738,1.52757453,1.1064583000000001,1.12818721,0.46317055,0.12986701,0.19816992,0.36539784,0.09154738,0.0,0.0,0.12872106,0.0,0.0,0.0,0.30089276,0.0,0.23319754,0.082014,0.50259583,0.43156863,0.34228986,0.22639895,0.51678377,0.50687387,0.61859776,0.27827689,0.42929565,0.42401053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31007548,0.27036318,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.32997115,0.0,0.33059592,0.11666009,0.0,0.0,0.14999446,0.0,0.0,0.0,0.06813675,0.12854745,0.0,0.0,0.0,0.30817906,0.0,0.23267952,0.18269354,0.51029085,0.0,0.0,0.0,0.33549062,0.08380815,0.0,0.0,0.26555700000000004,2.47474921,3.58157393,3.61418095,2.44911342,0.80651686,0.25951448,0.40759174,0.68711474,0.04441328,0.25971196,0.89887098,0.59382006,0.91229941,0.51358995,0.71283563,0.8332601999999999,1.02333857,1.46548735,1.12757115,0.22572752,0.34789485,0.0,0.0,0.0,0.18476475,0.1335039,0.08284571,0.0,0.0,0.31096357,0.0,0.18701799,0.18195792,0.0,0.15597199,0.0,0.0,0.0,0.26907441,0.14587937,0.10875278,0.28201211,0.0,0.26633931,0.12636191,0.0,0.0,0.30904958,0.18091987,0.0,0.03518157,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.22333454,2.34454501,6.49131891,9.661480099999999,9.1029176,5.51612268,2.30634412,1.55876128,1.99265493,1.49448717,0.282527083,0.0400882486,0.766784088,0.6791192979999999,0.0,0.0,1.01542434,3.45023051,3.59891873,1.61136269,0.0167288066,0.0,0.2419325,0.0,0.0796275218,1.64153443,3.35877203,3.39157205,1.87229506,0.494265765,0.123900074,0.16982538100000003,0.0388335579,0.0,0.0,0.023585094700000003,0.0,0.110041599,0.37652213,0.40227262,0.126713124,0.0,0.0,0.0,0.0,0.47917542799999996,1.33002916,1.62072629,0.855140204,0.0,0.0,0.0595414416,0.264086979,0.0,0.0,0.0,0.18425045399999998,0.067098582,0.0,0.0,0.0913652142,0.0328987776,0.0,0.0,0.0548620869,0.0312946483,0.0,0.0,0.009581974870000001,0.0,0.04781861019999999,0.26521673,0.418986526,0.287519537,0.0388118233,0.0,0.151298165,0.24795182600000001,0.35034176,0.773928101,1.34826786,1.30591665,0.469381989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.337784084,0.0,0.641940199,0.620782684,1.88809277,3.39868272,3.77846662,5.50221381,0.0,0.22437991100000002,0.174852545,1.19228626,1.87727041,0.891807589,0.0245819586,0.961206349,0.0,0.902144926,0.0,0.9299987909999999,0.0,0.503435602,0.0,0.567932203,0.0,1.43800234,1.44058015,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
1.83956705,3.36594091,6.02515577,6.81230262,5.97563402,4.38260274,1.72492252,1.49336417,0.0,0.0,0.0,0.0,0.42506484,2.2471326,0.63330155,0.0,0.0,0.65360078,0.91516573,1.42431052,0.0,0.49854915,0.27423378,2.01810612,1.86306221,0.0,0.0,0.0,0.28483375,0.35458499,0.25898435,0.0,0.32811401,1.03520328,2.20003841,0.29246883,0.0,0.0,1.85628023,0.0,0.0,0.0,0.68261179,1.03328081,0.28687996,0.52536334,0.0,0.0,0.0,0.0,0.0,0.55235494,3.03792447,0.46972852,0.0,0.83264988,0.74259012,0.77424241,1.6889392,0.21783223,0.0,0.0,1.79051063,0.0,0.39663935,2.61922271,0.0,0.0,0.60426344,0.0,1.23451848,0.0,0.60335027,0.0,0.0,0.0,0.0,1.62731849,1.61357066,0.54028622,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
1.86911255,1.60772656,1.35700531,1.12179483,0.906250039,0.713739428,0.546779042,0.40699712299999996,0.295129612,0.211045583,0.153800595,0.12171499599999999,0.112473364,0.123240629,0.15078996,0.19163722100000002,0.242176781,0.298813606,0.35808692200000003,0.416781261,0.47202138899999996,0.521348383,0.562775024,0.594819549,0.616517741,0.627414195,0.627534394,0.617339949,0.597669903,0.569671421,0.534723464,0.49435712600000004,0.450176242,0.403781664,0.356702225,0.310334955,0.265896536,0.224387345,0.186568801,0.152954062,0.123811489,0.09917973890000001,0.07889285759999999,0.062613372,0.0498710957,0.0401052412,0.0327073991,0.0270630549,0.0225895248,0.0187685043,0.015171808,0.011479323,0.00748866838,0.0031165324600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00506846469,0.0127107303,0.0200118853,0.026538737599999997,0.0318867727,0.035705089700000005,0.0377187019,0.037746848300000004,0.035716189100000004,0.031668042599999995,0.0257591532,0.0182558466,0.00952179795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0038707555700000004,0.0154136347,0.026364933599999998,0.0361171323,0.044115292199999996,0.0498891783,0.0530816752,0.0534718841,0.0509915296,0.0457336238,0.03795272,0.0280565105,0.016588970800000002,0.00420570071,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0178161082,0.0392632034,0.061905744699999994,0.08476224460000001,0.106800997,0.126991115,0.144355478,0.158022966,0.167277325,0.171600072,0.170705043,0.164562538,0.153411434,0.137758197,0.118362287,0.09620814609999999,0.072464587,0.0484330496,0.025486808,0.00500370999,0.0,0.0,0.0,0.0,0.0,0.0,0.0156622523,0.0431775309,0.0755679575,0.111396181,0.14893484,0.18623263899999998,0.22119503399999998,0.251676615,0.27558164399999996,0.29096868800000003,0.296154935,0.289815621,0.27107399,0.239577464,0.195556084,0.139859875,0.0739725729,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0595705958,0.258365226,0.48531713299999996,0.737118912,1.00959191,1.29778641,1.59611007,1.89848085,2.19849917,2.48963375,2.76541476,3.01962773,3.24650135,3.44088285,3.59839468,3.71556715,3.78994233,3.82014575,3.80592341,3.74814302,3.64875952,3.51074638,3.33799525,3.13518774,2.90764399,2.66115357,2.4017947,2.13574819,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
4.90544038,4.47128513,3.21258318,1.54473085,2.0414665699999997e-16,0.0,0.0,0.0,0.17427222399999998,1.00895559,1.511312,1.56143441,1.23926915,0.750464459,0.312585977,0.0588184958,0.0,0.0522777471,0.10497459,0.0873669899,4.2662485e-16,0.0,0.0,0.0,2.59974518e-16,0.105317428,0.148482962,0.104414522,3.76629751e-16,0.0,0.0,0.0,0.0,0.0995303784,0.139810165,0.0983174358,0.0,0.0,0.0,0.0,0.0,0.10323661699999999,0.15593269199999998,0.13283491,0.0516362145,0.0,0.0,0.0,5.66611129e-16,0.0741434916,0.10662607,0.0762597583,1.17988435e-15,0.0,0.0,0.0,0.0,0.0790382621,0.11236223099999999,0.0798954163,0.0,0.0,0.0,0.0,0.0,0.08361482419999999,0.11946824199999999,0.0854276299,0.0,0.0,0.0,0.0,0.0,0.0935672225,0.134996113,0.09754830869999999,0.0,0.0,0.0,0.0,0.0,0.11623879999999999,0.17093096,0.126147061,1.5298500500000002e-15,0.0,0.0,0.0,0.0,0.18281270100000002,0.28308364199999997,0.22203471,2.47309093e-15,0.0,0.0,0.0,0.0,0.7477476190000001,1.68975637,2.61667782,3.31762678,3.64833989,3.57056522,3.15072404,2.52371998,1.84086559,1.22400706,0.741121411,0.406635189,0.198893918,0.082336288,0.0239650543,0.0,0.0,0.0,0.000975247811,0.0,0.0,0.0,0.0,0.0,0.0105617822,0.0167796974,0.0131164052,0.0,0.0,0.0,0.0,0.0,0.0194482137,0.0286572867,0.020987465099999998,0.0,0.0,0.0,0.0,2.86638571e-16,0.0221890943,0.0304073498,0.020373941899999998,0.0,0.0,0.0,0.0,5.29948056e-16,0.0,0.0,0.0,0.0516362145,0.229035315,0.511118732,0.835877187,1.09081503,1.15497038,0.958086694,0.528329809,0.0,0.0,0.0,0.0,3.19968638e-16,0.44685509700000003,0.6711566379999999,0.51301144,0.0,0.0,0.0,0.0,6.491030440000001e-16,1.44724908,3.07767144,4.37720593,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.76682805,1.10503917,1.46030581,1.77423993,1.9939398999999998,2.08334566,2.03096309,1.85206841,1.58480335,1.2810416999999998,0.9941906999999999,0.76686702,0.62145503,0.55588499,0.5457083,0.55199589,0.53311675,0.45743346,0.31363964,0.11595848,0.0,0.0,0.0,0.0,0.0,0.28773875,0.7446977,1.22169021,1.63209543,1.89626126,1.95996601,1.80850612,1.47296076,1.02679756,0.5730695,0.2245527,0.08081153,0.20697512,0.61877234,1.27713635,2.09371462,2.94633262,3.70135868,4.23846232,4.47276666,4.36996876,3.95150931,3.28897763,2.48917529,1.67314668,0.9536157,0.41542121,0.1027134,0.01507346,0.11272669,0.32908726,0.58742498,0.81777974,0.97047862,1.02363806,0.98358423,0.87881602,0.74956916,0.63589647,0.56728923,0.55624221,0.59700128,0.66933787,0.74592458,0.8010498,0.81819675,0.79445121,0.74065571,0.6774332,0.62833988,0.6121797,0.63672518,0.69569266,0.76992211,0.83255242,0.85686664,0.82470395,0.73310432,0.5972374,0.44857975,0.32851734,0.27875793,0.33082825,0.49726927,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.410376356,0.543057545,0.0,2.1003083,1.24796521,2.29650162,1.87154318,1.73732101,2.10906461,0.0,0.575010619,1.06343702,0.42181778799999997,0.216563774,1.13778239,0.2338732,0.13681384300000002,0.458381015,0.449911117,0.0,0.13763492900000002,0.0,0.0,0.0,0.0,0.0,0.0996241324,1.01952251,1.30685812,2.45893674,1.36611492,0.415644977,2.21883367,0.672141622,0.48737193799999995,0.0,0.7556302979999999,0.637550955,0.0,0.0,0.0,0.363352944,0.0,0.23716608399999997,0.0721973055,0.08636585640000001,0.0,0.0405663531,0.571065798,0.0,1.50390111,0.587564334,0.23825051600000002,0.477618366,1.87171481,0.8537245990000001,0.0,1.01696266,1.01356209,1.31488931,1.08378881,0.9911287209999999,0.65412322,0.0,0.666540271,1.63232817,0.0,0.20495414899999997,0.0,0.0,0.0,0.0,0.0,0.602604453,0.0,0.117105559,0.9727529140000001,1.97658455,3.12447282,1.98356074,2.62437317,1.59744044,2.38708402,1.87812138,2.16041069,1.62598392,2.11377373,0.477748323,0.23783320000000002,0.9994643990000001,0.9387467859999999,0.874851335,1.49576863,0.832748438,1.69466528,3.36422587,2.13806915,3.00180534,2.98942316,2.50355359,0.181709172,1.3729081,0.725928749,0.0,0.0,0.0,0.0,0.0,0.906224824,0.454030008,0.0,1.75215762,0.134792924,0.917984006,0.652168396,0.0,0.0,0.0,0.0,0.0,0.471175323,0.127863209,0.0,0.0,0.669528683,0.26585234399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.4150179,0.0,0.840302894,0.128406398,0.0,0.0,0.34869122399999997,0.5041263189999999,0.0,0.44913707,0.0817285918,0.0,0.0,0.9284221340000001,0.0,0.14276303099999998,0.965011891,0.14612209199999998,0.0,0.0,0.0,0.0,0.0,0.0139570324,0.0,0.0,0.40213878700000005,0.0,0.0,0.224844226,0.0,0.239661407,0.0,0.0,0.0,0.0,0.389076542,1.54717808,0.7270520140000001,0.11000986300000001,0.0332298925,0.187824138,0.0,0.297226742,0.577590526,0.0,0.0,0.0,0.0,0.6293973660000001,0.0,0.047155116600000005,0.0935005575,1.12060469,0.0,0.0,0.0,0.105547271,0.139553617,1.09839412,0.512612254,1.44794564,0.0,0.222825,0.108505498,0.117681165,0.11939775,0.0,0.11531424,0.536048203,0.403221406,0.0,0.892692362,0.245019282,0.296071776,1.02464989,0.37977911299999995,0.0190627627,0.0,0.0,0.0,0.0,0.0,0.526417435,0.958855529,1.57391101,0.59505141,0.929969339,0.388280216,1.48351919,0.0,0.470153789,0.0570285821,0.9926467609999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.543666402,0.0,0.38343384,0.0,0.0,0.0,0.765574737,0.0,0.0,0.254938437,0.0,0.0,1.65788706,0.813988942,1.40932707,0.44524536600000003,0.42637071600000004,0.77774342,0.383492041,0.0,0.521841158,0.137010981,0.0,0.142823953,0.0,0.332274866,0.0,0.9475253640000001,8.77288094,6.82439539,4.09153672,0.38481256799999997,0.0,0.0,0.0,0.77081403,0.49344432,0.515855297,0.0,0.444157266,1.42054534,1.38695001,0.728896758,0.0,0.0,1.06306285,2.0250415,2.23979544,0.24289530199999998,1.33784458,0.171117678,0.0,0.08670112640000001,0.0,0.305941925,0.619462055,0.317763123,0.515260656,0.0,0.619734494,0.0,0.400205584,0.111481325,0.9723306190000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.239959455,0.0,0.118097511,0.0,0.0,0.0,0.5136704529999999,1.74679614,0.0,0.0,0.405236914,1.16424769,1.65109357,3.4470077000000003,1.72191791,0.0,0.215595343,0.0,0.392255529,0.19869563899999998,0.0,0.381877569,0.21436636,0.0822953888,0.0,0.175578843,0.0108593234,0.0,0.274631699,0.18698411199999998,0.0,0.021739477599999998,0.14374002800000002,0.160672813,0.0,0.20425169899999998,0.0,0.0771384814,1.23505919,0.0,0.106948599,0.134772801,0.0,1.15342451,0.559663247,1.06673244,1.13486896,0.644391886,1.0992108,1.47505346,0.351402881,0.46584463200000004,0.84133742,0.46721571,1.17752144,0.131292032,0.843573528,0.011733635800000001,0.24796991399999999,0.531357726,0.21663750899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.419428645,0.0,0.0,0.875873391,1.08799089,1.66127512,0.0,0.0,1.07222645,0.0,2.52859363,0.424104679,0.384181355,6.75424023,9.19921224,0.971216868,0.664076701,2.27995759,0.793395575,0.0,0.9151330679999999,0.548385263,0.136882266,2.90894547,4.28252862,0.6820589890000001,3.45893897,2.61997716,0.0,0.0,0.0,0.0,1.93490975,0.0,3.06142643,2.97155993,0.0,1.11307578,0.0,0.0,1.43168641,1.44926474,1.61214077,2.34109078,0.15742792,1.09652174,0.0,0.0,1.33278162,0.0,0.708138286,0.0,1.17910009,0.056684871100000006,0.0,0.34597389100000003,0.413708662,1.88211254,0.0,0.0,2.92035592,0.0,0.0,0.0,0.0,1.39805556,0.385369192,0.111350154,2.57777376,1.45649185,1.240825,0.10096181900000001,0.0,0.350669602,0.0,0.16805576,0.0,3.03986842,0.0,1.23515423,0.0,0.0,2.27114281,1.23433755,0.0,0.041862034900000004,0.361454147,0.0,0.0,0.0,0.0,0.0872937274,0.033294939700000005,1.68938613,0.0,0.865891373,0.872559385,0.594651348,1.58349759,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.48505402799999997,0.0,0.964144683,0.274017341,1.02620538,0.0,0.0,0.271926347,0.0,0.254602014,1.10680079,0.786869582,0.0,0.0,0.287904055,0.16950126,0.0,0.0,0.961617052,0.795967825,1.10274532,0.0,0.41162126,0.459487435,0.507067696,0.30757749,0.458559029,0.6347873620000001,0.8447867109999999,0.13306610800000002,1.41063553,0.0,1.42538799,1.13946058,1.23897649,2.59017904,2.4817191000000003,3.71649063,3.37865577,3.38536764,1.90906516,3.10893424,4.35881747,1.79896813,3.93419243,1.9796945,1.91249773,0.145809205,0.491037209,1.50946308,1.18840828,0.273259247,0.85962207,0.0515338498,0.11988774699999999,0.6846778,0.8709853259999999,0.0,0.0,1.01519268,0.0,0.0,0.13557577099999998,0.45111995,0.278042032,0.0,0.275102047,0.695665172,1.04263302,0.0,0.0398394751,0.0,0.25065929,0.334260505,0.0,1.05096212,1.06068972,0.329328749,1.29256429,0.744873549,0.0140728275,0.0,0.132131453,0.073732155,0.0,0.462137784,0.446213916,0.0,0.699094585,1.48703675,0.0,0.0,0.343589325,0.681416865,1.15783055,0.28985499600000003,1.17919938,0.30282481,0.0,0.18659124,1.29756775,0.271542296,0.0,0.46970721200000004,0.938399083,0.668869626,0.0,0.38670281,0.0,0.0,0.0,0.0,0.0,0.364056926,0.0,0.0,1.67944217,0.103846878,0.0571770403,0.0,0.20496921,0.0,0.0,0.0,0.0,0.0792309271,0.619130255,0.0,0.138838676,0.0506086064,0.0,0.194193335,0.0,1.30560148,0.843676827,0.0,0.058037122999999996,0.0,0.713758817,0.11918683199999999,0.034295038199999996,0.7452569109999999,0.0,0.00740405179,0.0,0.0,0.706352159,0.0,0.018840676299999998,0.0,0.0,0.0,0.6916210309999999,0.0,1.29133782,0.0,1.01989111,0.0,1.39763784,0.09852291519999999,0.0,0.0,0.022480735099999996,0.0,0.0,0.0,0.7214886490000001,0.0,0.0,0.104208008,0.0,0.0,0.0,0.0,0.0,0.53086656,0.0,0.0,0.0,0.0,0.593061815,1.10289517,0.27626453300000003,0.477176516,0.408002474,0.0,0.0,0.575412339,0.980505904,0.0,0.0,0.45810867299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.65765659,0.108007471,0.0,0.0,0.0,0.0,0.82419626,0.446155641,0.0,0.7344064440000001,0.259454931,0.0,1.38319301,0.0,1.47029701,0.324470792,0.646778239,1.10754032,1.80731724,2.40315532,0.8976741559999999,1.33868265,1.89947632,0.538972307,0.30149899,0.1304274,0.469862255,0.988542357,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.072725296,0.507131957,0.16951656899999998,0.0,0.0,0.21554234,0.19651200800000002,0.0,0.0,0.078631986,0.152590385,0.0,0.0441339446,0.42038188299999996,0.516932307,0.0775558462,0.0,0.0,0.243244989,0.158940674,0.0,0.0,0.149464919,0.21786530699999998,0.0,0.0,0.0506905224,0.235633617,3.62706284e-16,0.0,0.21723073,0.628608924,0.411913145,0.0,0.0,0.238012112,0.259023719,0.0,0.0,0.177639818,0.453156355,0.0,0.0,1.06678319e-16,0.814258877,0.373403486,0.0,0.301598877,3.90420721,7.06894609,6.3335125,2.29099311,0.0,0.0,0.44299527899999996,0.905648832,0.0,0.0,8.53426551e-17,1.66041546,2.47906908,1.97818877,0.901510543,0.187488417,0.190367626,0.527520177,0.482708944,0.0,0.0,0.387620191,2.10920715,3.0032967999999998,2.08388912,0.378343694,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.134534534,0.271773385,0.550078238,0.41397416299999995,0.0,0.422337057,0.0,0.34683309700000003,0.012898283899999998,0.0,0.0,0.0,0.0,0.0,0.169036728,0.00326228798,0.0,0.0657701319,0.268660903,0.0163737234,0.243942484,0.167831145,0.795788698,0.7857826290000001,0.545420922,0.23405145800000002,0.74514451,0.234493906,0.146281525,0.513082012,0.0566373073,0.0,0.251242604,0.0,0.0,0.017314701499999998,0.17045483,0.139850564,0.581029361,0.427545744,0.5649352470000001,0.316168393,0.38402165299999996,0.6487925929999999,0.0297267262,0.22374474600000002,0.299189317,0.365802494,0.0,0.44552451,0.106824871,0.281712864,0.0,0.0,0.130934172,0.0859453375,0.0,0.36647693200000003,0.0,0.112366508,0.457446265,0.0,0.264241532,0.403690971,0.0,0.223442282,0.0644085019,0.062094650599999995,0.0,0.0,0.20771802,0.25101309899999996,0.0,0.0,0.189910038,0.173645269,0.307339846,0.550759453,0.6860404920000001,0.0,0.671472704,0.301938503,0.491245146,0.34327101299999996,0.23170723,0.0290755132,0.328820131,0.39910815,0.594215897,0.6394443470000001,0.33475434600000004,0.44556427,0.730022335,0.9298150709999999,0.44964381299999995,0.770748845,0.814605283,1.10091524,1.51884963,1.2445442,1.86783302,2.004085,1.92939186,1.72343712,1.53315956,1.27965389,1.42046101,1.18314334,1.76298647,1.41616355,1.15332847,1.62046091,1.63799622,1.65388299,1.99666113,2.19996069,1.83963164,2.26099693,2.74900554,2.56432592,3.01901943,3.33752919,3.61137801,3.88453372,3.7112037000000004,3.49693537,3.74181917,3.5695617999999993,3.42793555,3.33730894,3.02569882,2.62516384,2.71996032,1.87084763,1.96817472,1.45427441,1.27126426,1.24251015,0.98368975,0.43306324399999996,0.25568942699999997,0.35542676100000004,0.020501559699999998,0.461860874,0.488048406,0.448492685,0.29930475,0.0,0.188963883,0.0,0.0471260999,0.0,0.0,0.0,0.201217449,0.0,0.327710187,0.23544596399999998,0.11977360000000001,0.0967637776,0.43694469700000005,0.0,0.429366598,0.0,0.0,0.11674353800000001,0.0147045282,0.316226666,0.0,0.102412121,0.0,0.0,0.0,0.0,0.31156682399999996,0.48570088,0.0,0.6911892079999999,0.421722715,0.490909644,0.42653015200000005,0.556963407,0.25385820000000003,0.597973863,0.224005727,0.61337113,0.015522907800000001,0.10626286199999999,0.0,0.0,0.0,0.0,0.0,0.0879363837,0.0,0.159064654,0.0,0.19745938300000002,0.10892733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.8646579520000001,0.0,2.67410827,0.157885037,1.46155905,0.0,0.0,1.60151868,0.830227543,0.0,0.20402981899999997,1.25335579,1.01923992,0.0,1.15432194,0.07895692879999999,0.0,2.29542973,0.0,0.0,0.67780945,4.25993723,3.96925749,4.60312516,6.921811099999999,7.642778599999999,5.65076911,4.17791936,4.55563108,0.0,1.58175582,0.439302176,0.902003813,2.04541086,0.0,1.10191359,0.0,1.33371439,0.0,2.25440452,0.0,0.0,0.50135043,0.0,0.9902100770000001,0.6695183729999999,0.712439127,0.21421748399999999,0.395884116,0.612943996,1.60653419,1.21001462,0.0,0.0,0.0,1.32430257,1.45602999,0.265312623,0.0,0.9090438679999999,0.0091164727,0.401340541,0.177045775,0.0,0.0620426382,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
1.10764035,1.83595193,2.70428366,4.61497114,0.0,0.35792305799999996,0.0,0.0,0.32319395100000003,0.95528887,0.0,0.292972673,0.0,0.0,2.24270523,1.81641316,0.0,0.0,0.0,0.107200953,0.09599806220000001,0.0,0.0553616558,0.0,0.772106362,0.67915844,1.10923831,2.02946547,0.0,0.0,1.03217683,0.0,0.0,0.0,0.0,0.445031946,0.459079455,0.885374142,0.719752018,0.0,0.0,1.42042828,1.35987355,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0288511372,0.0,0.0,1.13680512,0.177813845,0.0,0.30262053699999997,0.6404722070000001,4.64756517,5.1960457,3.20168352,2.37534568,1.88503107,2.19769117,1.7083354,4.46993334,5.93396095,5.92266113,3.52004508,2.09580731,1.54191848,0.570327469,0.0,0.0,0.380363878,1.82374192,1.54351109,1.53412368,2.48992307,1.15958699,0.0171372193,0.0,0.5639199460000001,0.0,0.0,0.0,0.454834289,0.232079652,0.0,1.49035534,1.04817473,0.615315254,4.23478378,0.645185324,0.0,0.0,1.17954535,1.69433066,1.91123585,0.46300752100000003,0.0,2.72908897,0.12955842,3.06169783,3.72651529,3.57601272,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.121747424,0.741756938,1.22421766,1.23735894,0.836968176,0.359969361,0.0785657883,0.0024126552800000003,0.00121746553,0.0383997246,0.20935846800000002,0.553874393,0.905584374,0.997066839,0.722732484,0.262094956,0.0,0.0,0.0,0.0608591053,0.0541887044,0.0,0.0,0.0,0.0054223956,0.0008058254589999999,0.0,0.014006221599999999,0.019411358899999998,0.0,0.0,0.0,0.0404080598,0.059946144400000005,0.0,0.0,0.235988997,0.8431946029999999,1.57317525,1.99373791,1.81433912,1.14305334,0.40289136200000003,0.0,0.0,0.0721463564,0.10751260900000001,0.00681246075,0.0,0.0,0.0387752566,0.100483838,0.0344932622,0.0,0.0,0.0175586679,0.159894958,0.116911995,0.0,0.0,0.0,0.8781275059999999,2.14657721,2.90357265,2.52898954,1.28672766,0.372311933,1.07560578,3.62557962,6.73047411,8.36566667,7.28749301,4.03214324,0.529189799,0.0,0.0,0.291570027,1.44524528,1.60001048,0.9974742879999999,0.323919867,0.00438450892,0.0,0.014644554099999998,0.0,0.0,0.0,0.032894961800000004,0.0319696626,0.0,0.0,0.0,0.0,0.0,0.113413927,0.421310785,0.7952147340000001,0.949077793,0.7042119659999999,0.20514917,0.0,0.0,0.013157128700000001,0.180393785,0.10918103800000001,0.0,0.0,0.0,0.11841049099999999,0.110989739,0.0,0.0,0.0,0.0809166591,0.113690965,0.00250990975,0.0,0.0,0.049291355,0.113875288,0.033029531699999996,0.0,0.0,0.018931298200000002,0.11063543,0.0610214038,0.0,0.0,0.0,0.103619272,0.0880325459,0.0,0.0,0.0,0.0925529873,0.116292801,0.0,0.0,0.0,0.0768847655,0.151862429,0.030669682099999998,0.0,0.0,0.0553647691,0.233934473,0.155983129,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.350057126,0.15991818800000002,0.08966133220000001,0.0776559173,0.039050307,0.0,0.0,0.051423084699999996,0.137603647,0.135507483,0.032791431600000004,0.0,0.0,0.0,0.0770029098,0.0726242385,0.0,0.0,0.0,0.0259188246,0.07853638,0.0431799188,0.0,0.0,0.0,0.0574670517,0.0849164798,0.015325160800000001,0.0,0.0,0.104081575,0.36983743399999996,0.561875215,0.547915668,0.33921346799999996,0.09003613279999999,0.0,0.0656167195,0.236151584,0.305676381,0.192186548,0.020415338600000003,0.0459506094,0.44108675399999997,1.115453,1.73572972,1.94928886,1.63824704,0.9964066659999999,0.37083659799999996,0.0101002184,0.0,0.0,0.0115484603,0.00251663405,0.0,0.0168877485,0.0319409495,0.0052311488,0.0,0.0,0.0052010718,0.0642119135,0.0548889417,0.0,0.0,0.0,0.045723682800000005,0.10128200300000001,0.0428670531,0.0,0.0,0.0,0.101903055,0.121392431,2.30850755e-16,0.0,0.0,0.0331212765,0.163521503,0.11395223300000001,0.0,0.0,0.0,0.122574096,0.217757128,0.0659377942,0.0,0.0,0.0,0.23639929399999998,0.238052392,0.0,0.0,0.0,0.327487095,0.603218843,0.368725632,0.0,0.0,0.262664341,1.15162799,1.33672325,0.245283526,0.0,0.0,0.125129611,4.49296313,9.14088603,11.582583300000001,10.6308296,7.15148263,3.26430274,0.7473096929999999,0.0,0.149484137,0.28168537899999996,0.0670967625,0.0,0.0,0.272968626,0.476452135,0.310961861,0.0,0.0,0.0,0.0712818635,0.161730561,0.0645858021,0.0,0.0,0.0785919683,0.08583649730000001,0.0160019906,0.148275174,0.7703678490000001,1.81969865,2.81834736,3.21950341,2.8572731,2.06902462,1.37539967,1.03422452,0.89157639,0.638782771,0.181955055,0.0,0.0,0.0,0.354177715,0.6143074510000001,0.57093159,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.8555213979999999,0.0,0.0,0.0,0.0,0.0,1.21523551,0.0,0.7124211770000001,0.0,0.0,0.49261958200000006,1.57195525,0.0,0.0,0.0,0.768085527,4.03341833,4.76520263,3.04558934,1.01675264,0.0,0.286965785,0.0,0.0,0.152396657,0.5568014139999999,2.61448502,0.687381962,0.593620781,0.0,0.0,0.376066057,0.0,0.0,0.37022558299999997,0.0,0.588481487,0.0,0.0,0.0,0.0,1.05201052,0.753188008,0.0,1.42335162,1.80871113,2.32455336,3.87440095,2.53277341,0.0,0.253031603,1.03062713,1.03119006,0.0,0.157883353,0.750746837,0.0,0.6700977370000001,0.0,0.0,0.648849801,0.0,1.01995264,0.165420479,0.0,0.0,0.874227118,0.0,0.0,0.504271633,0.598197149,0.643726745,0.0,0.0,0.512851033,0.247218939,0.0,0.369433479,0.582563457,0.0,1.90021368,0.11309967,1.00810747,0.0,0.0543885948,0.0,0.0237455392,0.0,2.25462737,4.76874537,6.07374009,2.48203256,1.39966855,1.17916663,0.0,0.0,0.0384627177,1.07443977,2.14925642,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.168901306,0.294824872,0.0679917613,0.0,0.0,0.0681969637,0.290707885,0.141405685,0.0,0.0,0.0,0.40353935399999996,0.425015329,0.0607853017,0.0,0.0104655313,0.42160033700000005,0.42171302899999996,0.0,0.0,0.0,0.528408412,0.8715119509999999,0.0,0.0,0.0,1.28752234,5.20167443,7.94295285,7.63858458,4.72882133,1.44663472,0.0,0.0,0.416082931,0.457295784,0.0262017837,0.0,0.371541395,0.991539707,1.08816408,0.621606852,0.148101419,0.11432644300000001,0.376379924,0.472777646,0.22671496300000002,0.0,0.0,0.07860535099999999,0.20581909399999998,0.103191289,0.0,0.0204498851,0.268038053,0.404745446,0.24321046699999999,0.0,0.0,0.022995336,0.260455909,0.264764435,0.0349357115,0.0,0.0,0.15845979400000001,0.265969147,0.096925847,0.0,0.0127354674,0.7237284340000001,1.74207371,2.4670005,2.40837366,1.5853274,0.532769601,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
0.0643515704,0.0568056866,0.0491309792,0.0415611394,0.0343163057,0.027596756899999998,0.0215773059,0.0164025503,0.0121831094,0.008992950809999999,0.0068678744499999994,0.00580519291,0.0057646079299999995,0.00667025073,0.00841381833,0.010858706499999999,0.013845009699999999,0.0171952329,0.0207205386,0.024227335200000002,0.0275240023,0.030427543900000003,0.0327699604,0.034404139,0.0352090745,0.0350942512,0.0340030437,0.031915018999999996,0.0288470585,0.0248532542,0.020023566899999998,0.014481278600000001,0.008379303559999999,0.0018954623899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.004761490300000001,0.013137173500000002,0.0213289664,0.029056668799999998,0.0360464373,0.0420398744,0.0468029039,0.0501341493,0.05187253730000001,0.051903865,0.0501660933,0.0466531625,0.0414171643,0.0345687496,0.026275702400000003,0.0167596634,0.00629104104,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00482192282,0.0221295608,0.0396954625,0.0569479858,0.0732911675,0.08812144029999999,0.100845453,0.110898551,0.117763462,0.12098866900000001,0.12020599900000001,0.11514691699999999,0.105657043,0.091708459,0.0734093852,0.051010885199999995,0.024910309,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08924526960000001,0.191879501,0.30751567,0.435529774,0.5750638770000001,0.725033798,0.884141382,1.05089114,1.22361103,1.40047692,1.57954038,1.75875924,1.93603027,2.10922346,2.27621713,2.43493325,2.58337225,2.71964662,2.84201269,2.94889997,3.03893738,3.11097606,3.16410817,3.19768136,3.21130879,3.20487432,3.17853303,3.13270693,3.06807606,2.98556522,2.88632658,2.77171856,2.6432815,2.50271044,2.35182586,2.1925426,2.0268379000000003,1.85671899,1.68419081,1.51122464,1.33972801,1.17151652,1.00828801,0.851599507,0.702847342,0.563250614,0.433838334,0.315440307,0.20868181800000002,0.113982131,0.0315566731,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.010584163600000002,0.0335176279,0.0536022894,0.070465678,0.0838495863,0.0936080629,0.09970316039999999,0.10219862199999999,0.10125172699999999,0.0971035368,0.090067824,0.0805189677,0.06887911570000001,0.055604923,0.0411741681,0.0260725446,0.0107809094,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00185694738,0.014882952,0.0277267234,0.0400789981,0.051653311900000005,0.0621929404,0.0714768638,0.0793246232,0.0855999622,0.0902131867,0.09312220380000001,0.09433223859999999,0.0938942618,0.0919021934,0.0884889806,0.0838216754,0.0780956635,0.0715282187,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.356667254,0.0,0.12408561300000001,0.0,0.44210552299999994,0.0,0.0,0.237409498,0.253458835,0.0,0.0,0.430477116,0.503348541,0.349184747,0.358230612,0.67309046,0.65621508,0.51976324,0.564661644,0.0,0.40830094,0.472201173,0.0,0.368556485,0.0,0.440244085,0.530314949,0.6322280579999999,0.75254954,0.177318568,0.213022094,0.98847713,0.98138162,0.637454223,0.569782343,0.447720261,1.15519664,1.25198467,0.76848727,0.668212605,1.11049161,0.894742025,0.520766359,0.566775968,0.139524865,0.0,0.82403302,0.854743348,0.416327414,0.869706865,0.7422118759999999,0.263975225,0.0,0.146575986,0.8579225420000001,0.31851350100000003,0.423990542,0.481828673,0.0412009947,0.35976690000000006,0.21949813199999998,0.0,0.0,0.21106971,0.0,0.0,0.0,0.209029238,0.185724497,0.344929855,0.0,0.0,0.052106166399999994,0.300303909,0.0,0.12185245900000001,0.620413828,0.0984831624,0.0909253434,0.0,0.216093822,0.0,0.0,0.0,0.12174076199999999,0.0,0.14337866400000002,0.6896123559999999,0.260045779,0.517180463,0.80766114,0.583858758,0.730385623,0.514835334,0.597364392,0.523594098,0.0,0.274761381,0.0,0.0,0.0,0.0,0.0,0.0,0.408399655,0.0,0.090626385,0.920464779,0.0690805259,0.585184201,0.0910312126,0.147902173,0.467507447,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.43697863600000003,0.347080066,1.80353286,2.66368209,3.20456409,3.41115507,4.4838644,5.17357022,4.95257364,4.66168713,4.60233196,4.2000767,3.65893609,2.95588508,2.60888813,2.13223742,1.04849925,0.412139373,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.601496434,0.809817557,0.566983215,0.310696295,0.6994114159999999,0.9359287270000001,0.653582,0.030252870499999997,0.37614528,0.04467562940000001,0.0,0.0,0.0654727371,0.0,0.0,0.0,0.0,0.0871556241,0.22547685899999997,0.0,0.0,0.0,0.30066755,0.675003894,0.141349337,0.20059888399999998,0.0,0.0,0.0,0.184027778,0.0,0.223431838,0.279490101,0.304950793,0.0,0.11317838699999999,0.37857145700000006,0.404356912,0.153456174,0.43756945700000005,0.0,0.279963,0.52187638,0.171384708,0.0,0.0,0.08385212110000001,0.34906968200000005,0.0,0.291135409,0.460477421,0.0562056036,0.12690821800000002,0.0,0.0,0.0,0.429785673,0.280824473,0.0,0.26536652899999996,0.0,0.286369431,0.0,0.642111046,0.5961761170000001,0.8741275609999999,0.192198845,1.21701381,0.575368776,0.62020578,1.40210449,1.46886758,0.951891547,1.03958072,0.513830947,0.596353237,0.521099202,0.611598494,0.195707199,0.361958909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.054939553499999995,0.00225936698,0.452233975,0.0,0.025477696600000002,0.318304049,0.340604344,0.103078782,0.127475425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.0825823121,0.267429245,0.0180479965,0.0,0.0,0.201342811,0.0512914691,0.0,0.0,0.175309648,0.04297844,0.0,0.0,0.18190637399999998,0.0606747639,0.0,0.0,0.19314938199999998,0.0826548716,0.0,0.0,0.209888362,0.111238696,0.0,0.0,0.23450599600000002,0.150990844,0.0,0.0,0.275082954,0.21443532699999998,0.0,0.0,0.36583299700000005,0.358824659,0.0,0.0,0.940995823,2.63624185,2.77439162,1.67743487,0.736723177,0.330058564,0.040090847400000004,0.0,0.107003865,0.21358971300000001,0.0,0.0,0.17965436,0.285403029,0.0,0.0,0.200192888,0.42945558799999994,0.0,0.0,0.24907320100000002,0.665638534,0.0,0.0,0.341056801,1.18825095,0.0,0.0,4.22102693,11.903219,14.4735122,9.44089337,3.13533332,1.32118399,2.02974166,1.23486314,0.39558143799999995,2.95170425,6.84755993,6.81165774,2.6820941,0.0,0.495715677,2.35749537,2.46147634,1.73591669,1.66013403,1.41054623,0.21235998,0.0,0.0173812385,0.74055486,0.259518149,0.0,0.0,0.46981343600000003,0.151335555,0.0,0.0,0.439421257,0.184564358,0.0,0.0,0.50745618,0.431499695,0.0,0.0,0.876791502,1.29405122,0.78386476,0.586926426,1.33231346,1.95682216,1.4900678,0.498009379,0.0,0.0,0.0,0.0,0.043119656900000004,0.042938311900000005,0.0034620678499999997,0.454354972,1.52791123,2.33194433,1.98358919,0.8551519679999999,0.0455467733,0.0,0.021728636200000002,0.0,0.0521027857,0.30487040000000004,0.403584505,0.18250210600000003,0.0,0.0,0.006026581709999999,0.0,0.0750887286,0.42609573799999995,0.655145336,0.40270959700000003,0.0,0.0,0.047865190499999995,0.162441074,0.0,0.0,0.0608185364,0.711817815,1.40784106,1.7924311999999998,1.65134516,1.12179283,0.722314201,0.801542347,1.00230071,0.72949609,0.100143124,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
0.38037212299999995,0.40875687299999997,0.18064161399999998,0.733714367,0.47697554,0.763074687,0.905875945,2.13665122,1.62643647,1.23336299,0.6743009040000001,0.0,0.746568033,0.0,0.218793068,0.0,0.0,0.176201462,0.0,0.0,0.0706537834,0.0,0.0,0.0,0.0,0.0,0.10325297300000001,0.852641715,0.510688118,1.77901212,2.32582975,2.3398508,3.0997022999999997,2.50278279,0.574912766,1.814688,1.12424263,1.3983434,0.279161796,0.0,1.0283974,1.6324334999999999,0.698523696,0.177260373,1.05307292,1.18462724,0.559461717,0.6188868120000001,0.0,0.0,0.14377546900000002,1.00589679,1.33879546,1.51996264,2.03035978,3.3154796,1.90866279,2.32644766,2.56577584,1.61373445,0.7057796709999999,0.0,1.49305682,0.16991216,1.60563242,2.14517699,3.08444312,2.20222639,3.29143981,1.77803279,1.79413942,0.174870131,0.595393529,0.0,0.0,0.9463959059999999,1.36558672,0.0,1.22466902,0.0,0.0,0.564497006,0.0,0.245855443,0.751327647,0.0,0.0,0.0,0.17510787,0.0,0.0,0.0,0.0,0.0,0.0,0.11185999999999999,0.0,0.67499942,0.0969182026,0.0,0.0,0.0,0.0,0.46232637200000004,1.28255288,1.15946113,0.7288359409999999,0.0,0.0,0.648664903,0.0,0.8903143929999999,0.292508998,0.741827153,0.0822776229,0.0,0.00039438849800000004,0.950729458,0.441145753,0.0,0.17911453600000002,0.356308465,0.10572398300000001,1.03334189,0.0,0.469755359,0.0,0.0,0.0,1.31566165,0.9209744459999999,1.000316,0.342224618,0.0,0.0,0.576748438,0.0,0.530112797,0.160424967,0.281711857,0.699600807,0.603320387,0.0,0.191973255,0.8098277690000001,0.0,0.563031312,0.0988968744,0.0,0.0,0.0,0.589563363,0.0,0.09310350939999999,0.6791075879999999,0.47520616299999996,0.0,0.3206992,0.237533727,0.224011063,0.0,0.029109048999999998,0.0,0.0,0.48829804299999996,0.0,0.479049802,0.0,0.0348478666,0.0,0.0,0.0,0.37969465,0.0,0.0,0.0,0.12220757,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.0599339474,0.0,0.0,0.196574886,0.361798881,0.335350574,0.192422519,0.0370524779,0.0,0.0,0.017542536799999998,0.0531161053,0.012384528700000001,0.0,0.0,0.0329462861,0.0748903255,0.005340149620000001,0.0,0.0,0.11649163900000001,0.336414948,0.391632242,0.248446172,0.050679079,0.0,0.0,0.0068006540599999995,0.014168383500000001,0.0016727485500000001,0.000590968992,0.00463779376,0.0,0.0,0.0,0.020818174,0.0165036457,0.0,0.0,0.00167997783,0.039772588,0.022377081400000002,0.0,0.0,0.014146645900000001,0.0868543574,0.07744683599999999,0.00340814217,0.0,0.0200052669,0.0655697725,0.014022190600000001,0.0,0.0,0.06831081139999999,0.176866406,0.0978645843,0.0,0.0,0.176858966,0.5056993679999999,0.577707699,0.365827691,0.186642484,0.32296163,0.66454615,0.815342215,0.550522437,0.0776431541,0.0,0.0,0.0719798151,0.130082723,0.00888167132,0.0,0.0,0.0535302615,0.0764944885,0.0,0.0,0.0,0.05046624809999999,0.058521485899999996,0.0,0.0,0.022150271000000003,0.20062127300000002,0.336894969,0.326239844,0.18738705100000003,0.0450770041,0.0365437419,0.211847918,0.49141218,0.7245233729999999,0.8283717759999999,0.890029938,1.10501813,1.58073142,2.20567352,2.74093915,3.03571372,3.11191673,3.03226018,2.76307671,2.25874327,1.6673650000000002,1.32085225,1.40488084,1.66689792,1.58875281,0.9338814870000001,0.06553055299999999,0.0,0.0,0.213360804,0.289424966,0.0,0.0,0.0,0.26929039899999996,0.327761193,0.0,0.0,0.0,1.01207389,2.19439964,2.37043419,1.38716911,0.0755836149,0.0,0.0,0.587918342,1.03620464,0.9167669390000001,0.574154555,0.443841916,0.602281164,0.782511292,0.72093012,0.41355630600000004,0.0661665933,0.0,0.0,0.054541030899999995,0.20358627399999998,0.244077047,0.15848822099999998,0.0353334239,0.0023764667899999997,0.0986285882,0.216638809,0.210380299,0.0679286806,0.0,0.0,0.00953262821,0.0220434889,0.0,0.129967916,0.5839682110000001,1.10089254,1.19886082,0.710983273,0.10729861,0.103843881,0.882827947,1.8004646,2.00093449,1.32049388,0.469011611,0.25799122399999996,0.7370914479999999,1.20981565,1.0728251,0.47795856299999995,0.0731133878,0.198647199,0.528026961,0.535875898,0.153911148,0.0,0.0,0.093166399,0.195714508,0.0199473556,0.0,0.0,0.09788970400000001,0.154690874,0.0,0.0,0.0,0.11392047400000001,0.141873525,0.0,0.0,0.0,0.150136362,0.149286414,0.0,0.0,0.292613173,1.06809264,1.60712082,1.46798002,0.773051466,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
1.14916715,0.11785610099999999,0.444763029,0.0,0.70797293,0.0,0.0,0.0,0.0,0.550565449,0.0,0.458340514,0.341496267,0.0,0.432997714,0.0,0.506937461,0.0118733249,1.03636086,0.464092073,0.0,0.6407316829999999,0.221196169,0.48238208299999996,0.0555175242,0.0,0.818954007,0.886358304,0.494920323,0.314331187,1.25838676,1.41735355,1.27944129,0.911658348,0.92619352,1.75360328,0.994084493,1.13035978,0.819120451,0.46861474700000005,0.0,0.25065985,0.277318216,1.29699179,0.351717269,0.274737707,0.0,0.0,0.613588476,0.0,0.253338601,0.0,0.375284725,0.0,0.0,0.0828442169,0.11162187,1.4062991000000002,0.81569434,0.024961565800000002,0.241182985,0.0,0.0,0.0,0.0,0.752444302,0.0,0.489177817,0.297937428,0.0,0.7854350720000001,0.0,0.474171116,0.321146315,0.36481315799999997,0.21762930100000002,1.12940919,0.194010396,0.0192507029,0.6405214,0.472135774,1.32726312,1.10680482,0.29078590600000004,0.0,0.0,0.0,0.0,0.0,0.7528607979999999,1.12658945,0.166785269,0.518991627,0.275601135,0.429836311,0.0,0.956961101,0.0,0.0,0.0,0.0,0.0,0.820072531,0.637860245,0.0,0.155747623,0.0,0.597612586,0.0,0.0,0.0553642936,0.0,0.0388663314,0.0,0.0,0.0,0.0,0.0,0.0,0.15397042,0.744696667,0.381057307,0.5013115920000001,0.011909711699999999,0.751764482,0.0,0.0338370356,0.0,0.204183742,0.2344833,0.0,0.0,0.0,0.462745264,0.0,0.502283171,0.0,0.0,0.193079212,0.239458791,0.45489697799999995,0.6152707829999999,0.41081350899999997,0.31322884,0.113746686,0.169383001,0.661487643,0.0,0.22936868100000002,0.5532308229999999,0.0,0.048017254,0.7132506759999999,0.0,0.80046859,0.0,0.0,0.0,0.0,0.0,0.680009841,0.33972275700000004,0.0169827689,0.89800708,0.0328787618,0.0540634383,0.38105432,0.0,1.34707602,0.11974840699999999,0.0,0.0,0.0,0.66897637,0.445781427,0.0,0.390573596,0.0,0.16458146099999998,1.08702024,0.0,0.0,0.266010232,0.0,0.0,0.675510658,0.0392206719,0.0,0.11840865699999999,0.620121162,0.5165578,1.61215189,0.0,0.732676832,0.232689605,1.14667829,0.868328179,0.0,0.49506724399999996,0.0,1.20699418,0.0,0.36765982799999997,0.278004431,0.222047123,0.7332126999999999,0.36885244899999997,0.0372644045,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.706300314,0.789979227,0.983123176,0.545729152,1.51916142,0.9975224140000001,2.20930918,2.79079025,2.14904421,2.55939204,3.70536435,3.15989534,2.77867425,2.39068001,2.19666636,0.9006906809999999,1.09369081,0.394800098,0.9836749859999999,0.296273025,0.0,0.0,0.0,0.0,0.93098634,0.48643124600000004,0.551875299,0.806922584,0.688393646,0.266046853,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
2.44394385,2.65842867,2.13695901,1.21398069,1.62216272,1.14999902,0.0,0.0,0.0,0.216414073,0.0,0.0,0.0,1.41114502,0.480553926,0.0406555064,1.1381796,0.719128386,0.682738133,0.0,0.0,0.99994068,0.0,0.0,0.0,0.0,0.0,0.443909857,1.10629236,0.0,0.973280719,0.14777086,0.0,0.0,0.721463132,0.0,0.729751423,0.0,0.0,0.299949048,0.8493279909999999,0.7917936409999999,0.424658528,0.0,0.0,0.58845183,0.6415813570000001,0.265042823,0.0,0.49885901200000005,0.0,0.15203085,0.0,0.0,1.48803329,0.0,0.0,1.28228049,0.0,0.0,0.0,0.0,0.27584817899999997,0.29057984,0.423882858,0.0,0.0,0.0,0.0,0.0,0.0,1.53880581,0.0840158909,0.331338894,0.9651476379999999,0.0971700474,0.0,0.0,0.0,0.298652111,0.6209995620000001,0.0,0.26035253399999997,2.42498935,0.109581531,0.710461074,0.0,0.0,0.37516099799999997,0.327186448,0.0,0.606310212,0.0,0.784432984,0.0,0.09712054349999999,0.156716752,0.0,0.0,0.19777871100000002,0.41115838,0.280716568,0.0298388575,0.0,0.401639329,0.721261422,2.16667973,1.08170183,2.75725179,1.67038077,2.61905705,1.5556229,2.91411511,1.39214512,1.86684047,1.6224321000000002,1.37209549,1.95941529,0.9054304190000001,0.0141566226,0.316091003,0.0721727565,1.3786633999999998,1.29938999,1.08809734,1.52884119,0.490803669,0.625286692,0.0,0.0,0.170042207,0.0,0.0,0.0,0.825277422,1.48085504,1.88797164,1.89387301,3.97928029,2.28360035,2.78116007,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.53368605,0.38992855,0.62970871,0.13586196,0.0,0.0,0.0,0.0,0.44033304,0.65832929,0.0,0.0,0.50253381,0.0,0.42443188,0.07409181,0.0,0.0,0.0,0.70879373,0.53222109,0.31687766,0.0,0.0,0.0,0.0,1.8804736000000002,3.84467285,5.12335735,4.8620294,3.81635072,2.04436698,0.29616711,0.0,0.0,0.0,0.02781584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
7.07807928,1.71110639,0.0,0.0,1.95789073,2.43907414,0.7902420609999999,0.0,0.0,0.436249558,0.644666607,0.0,0.0,0.0,0.35891756799999996,0.324449805,0.0,0.0,0.0,0.253309949,0.137697563,0.0,0.0,0.0327423222,0.13854776900000002,0.0346030089,0.0,0.0,0.024013211200000002,0.027223721,0.0,0.0138176922,0.0172418711,0.0,0.0,0.0301977979,0.12343118,0.0295913369,0.0,0.0,0.12746438300000001,0.235528314,0.0,0.0,0.0,0.30437727800000003,0.33698850700000005,0.0,0.0,0.0,0.608776079,0.416050627,0.0,0.0,0.218497699,1.27567558,0.461441185,0.0,0.0,1.89838611,7.42730237,9.92108838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
0.30901524199999997,2.07154729,0.126905089,0.0,0.0,0.0,0.0,0.0,0.0,0.46663796799999996,0.0,0.0,0.14537871800000002,1.51284543,0.166263252,0.0,0.111920752,1.38662752,0.0,0.0,0.980421842,0.0,0.798412005,0.0,0.174605058,0.0,1.33468752,0.0,0.0393617962,0.0,0.0188074958,0.0,0.0,0.0,0.0,0.0,0.8347185579999999,0.859551154,0.0,0.0,0.0,0.332340193,0.0,2.3896238,1.63846915,5.87968546,6.15663967,6.57225211,6.43244002,4.50146558,0.0,0.0,0.35020550799999994,0.0,0.9891672009999999,1.58002067,1.82539912,1.07148791,0.0,1.40510133,0.0,0.0,0.0,1.05276729,1.74141921,0.0,0.0,1.29076456,0.0,2.12512366,0.0,0.0,0.27792506899999997,0.0,0.652425346,1.72527151,0.27292065600000004,0.0,0.7538246590000001,0.0864900323,0.0,0.0,0.0,1.18519442,0.0,0.0,0.0,1.79619016,0.666629614,0.239167745,0.0,1.33591339,0.0,0.5460802920000001,0.0,0.717193675,0.0,0.275538263,0.132692135,0.0,0.0320028824,0.0,0.0,0.46992021100000003,0.0,1.02224729,2.35207378,2.03471655,0.0,0.0,0.0,3.18536043,0.0,1.88044623,0.0,0.025908982,1.12410431,0.0,3.02432426,1.81472241,1.14638461,0.179624687,0.0,0.33179730399999996,1.04768354,0.104121257,1.39611318,0.0,0.139472854,1.37685754,1.86119153,2.39746419,2.75879333,0.45407266700000004,1.07256695,1.66992478,2.91349392,1.26933538,0.0,0.0,3.15036227,1.33268661,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
0.41555492899999996,0.038497162599999996,0.0399291275,0.0569429443,0.0,0.111931849,0.0060103401600000005,0.0,0.155641186,0.0,0.0,0.169170285,0.0,0.0,0.640663093,1.90747469,2.87835653,0.71940913,0.0,1.31326293,0.485929806,0.0,6.24695011,9.46673824,3.69823094,0.327758023,1.16694476,1.24333077,1.2144778999999999,0.141814484,0.35072110100000004,3.71787278,2.93733694,0.0,0.0,0.924828916,0.0,0.110464053,0.290989779,0.0,0.303888803,0.215345512,0.0,0.662224543,0.7991892140000001,0.0,0.590116278,0.868099649,0.118085317,0.14424031199999998,0.282558125,0.0,0.259540852,0.670115075,0.353124602,0.0,0.1922896,0.233865369,0.0,0.0,0.0,0.0182620573,0.0259687451,0.0,0.248479703,0.501376768,0.07431422929999999,1.25887195,2.95830606,1.74169745,0.043567764,0.147145349,0.0,0.0,0.20219530600000002,0.0,0.0,0.19618217300000002,0.0,0.0639213304,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41
0.350327667,2.498382,0.0,0.0,0.489631844,0.0,0.40508565799999996,0.024477611,0.0,0.0,0.526345317,0.0,0.0,1.03052418,0.32271654,0.255774672,0.0,0.0272982597,0.745601583,3.91672333,2.1987243,1.25181975,2.35103222,1.14590322,0.0,0.69042868,0.82329847,0.0,0.0,0.047718414400000006,0.992083926,0.0,0.0,0.0,0.0,0.892960836,0.0,0.881848915,1.72925888,0.483957697,0.707176639,0.25162905,0.0,0.0,0.583619123,0.0,0.000855295453,0.0,0.998873285,3.35100338,3.00560328,5.86286487,6.66611648,7.37064197,5.84842741,2.46497861,4.62709124,0.869926144,0.38182225399999997,0.0,0.286103512,0.0,0.0,0.731570827,0.0,0.0,0.0,0.0,0.0,0.690476427,1.24877689,2.71850148,0.0,1.62058324,0.885974983,0.0383682242,0.0,0.0,0.0,0.571941975,0.493684034,1.2918611999999998,0.435714947,0.0,0.0,0.961968892,0.7489489429999999,0.0,0.34213812600000004,0.0,0.0,0.0,0.302526787,0.0,0.0,0.0,0.0,1.35762376,1.61787349,0.0,0.0,0.0,1.77161808,0.0,0.816057955,0.0,1.37022429,1.42728194,0.75852743,1.03032422,3.64503734,1.29370752,0.7979257259999999,1.1087053999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.9340139940000001,1.98610028,0.35085070100000004,0.318787127,0.0,0.0,0.6055671810000001,0.0,1.78527602,1.07819492,2.1761689,0.299068956,1.73729894,0.0,0.523992069,0.0315424697,0.17857825300000002,0.06009856,0.0,1.39999264,2.55862315,0.26850755,0.0,0.8916533170000001,0.0,0.318030363,0.863330136,1.59746225,2.21825933,0.9367377240000001,2.88280942,0.270052408,0.0,0.870376629,1.24156238,0.383744135,0.6641013929999999,0.0,0.0,0.31010305899999996,0.523053007,0.43148609200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.5174653929999999,0.7275136990000001,0.645144347,0.37569454700000005,0.234106187,0.39249776700000005,0.689203252,0.818646597,0.667132529,0.404395034,0.256823515,0.261780539,0.280889789,0.205199186,0.075309951,0.0,0.015245991100000002,0.08865284470000001,0.185687078,0.299743824,0.39166706799999995,0.376476162,0.21958570100000002,0.019398599,0.0,0.00996032088,0.131646257,0.155484762,0.0737871111,0.0,0.00323355636,0.0376357265,0.0213619715,0.0,0.0,0.00694813952,0.0467022262,0.0188830603,0.0,0.0324173538,0.142053622,0.17365114,0.0594354146,0.0,0.0,0.0181707423,0.08974664480000001,0.0301641285,0.0,0.136420935,0.43337176,0.574379769,0.37642884299999996,0.029187957999999996,0.0,0.036980953999999996,0.187755077,0.0775481326,0.0,0.0,0.364559921,0.8584102779999999,0.9613940559999999,0.702125415,0.492338932,0.539387991,0.54651038,0.16499530099999998,0.0,0.0,0.6747659109999999,2.0378515,2.80147984,2.74079959,2.72098517,3.70289819,5.49618544,6.77314492,6.444284400000001,4.86917231,3.50254189,3.35696871,4.00803756,4.20284494,3.28495212,1.80650295,0.7662831290000001,0.508923242,0.554639678,0.37664796100000003,0.044090797699999996,0.0,0.305766873,0.615755484,0.524985837,0.134633311,0.0,0.0,0.151322147,0.135252556,0.0,0.0,0.0,0.145060519,0.123809449,0.0,0.0,0.0,0.16304645199999998,0.19807895399999997,0.08677650699999999,0.0555226542,0.224633677,0.440321199,0.475123126,0.321554603,0.19238318199999999,0.241783418,0.383121363,0.42985723,0.350612023,0.295252089,0.373368139,0.495006381,0.48376692,0.302430624,0.0942270682,0.0018831940300000002,0.0132180512,0.0201198252,0.0,0.0,0.0,0.0467416924,0.0348506835,0.0,0.0,0.0,0.051502519000000004,0.035844241,0.0,0.0,0.0,0.048670411,0.0315911388,0.0,0.0,0.0,0.0268120352,0.00788937983,0.010876916799999999,0.11204908300000001,0.256909486,0.297561957,0.191976325,0.101916834,0.22093747600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
2.60820158,0.0,0.31053342100000003,0.0,0.924155925,0.40405619,1.53480353,0.0,0.0,1.00522907,0.0,0.0,0.0,0.0,0.0,0.0,0.0407098924,0.23579225899999998,0.10612117800000001,0.648837363,0.165174669,0.0,1.24973784,1.23354275,1.18051313,0.9616899859999999,0.0,0.0,2.46761674,0.0,1.326586,1.6484727,2.10885408,0.9818184679999999,0.297448723,0.0,0.7901225340000001,0.0,0.0,0.865080829,0.121395368,0.9190757279999999,0.0,0.0,0.0,0.0,1.38946889,0.0,0.905934138,3.47511118,0.0416179541,0.0845568108,0.0,0.0,0.0,0.579518239,1.95968906,0.270103153,0.94084869,0.16023162800000001,0.646267533,1.71140274,0.0,0.872014614,0.0,0.619505705,0.055918815999999996,2.2969294999999996,3.4883733,4.30112891,0.0,0.0,1.70964169,7.63424136,6.88312131,2.60966832,0.0,0.0,1.45627248,2.28806057,1.67184569,0.384935252,2.25498811,0.26766893399999997,0.534197134,0.0,0.0,0.0,0.0,0.21776026699999998,0.0,0.5145259520000001,0.735402267,0.23095226800000002,0.0,1.60583335,0.7216664629999999,0.7054608990000001,0.0,0.439078759,0.492088889,0.0,0.412012471,0.73589705,0.206222262,0.0,0.0,1.62167315,0.0,0.0,0.0,0.718085614,1.29810782,0.811558784,0.0,3.47053483,0.36647368700000005,0.0,0.0,0.0,3.45587654,0.0,0.0,0.38507757299999995,0.0,1.11812898,0.043558380099999995,1.43021776,0.6734739670000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
1.22487174,1.08639986,1.21323631,0.809647938,1.15231716,0.40757204399999997,0.8100500540000001,0.0,0.191238138,0.00515351908,0.0,0.0,0.0,0.0,0.376540337,0.38063388200000003,0.0,0.0,0.59795906,0.78400904,0.0,0.0,0.0,0.0,0.422493471,0.0,0.0,0.0727725767,0.0,0.21396617699999998,0.475608177,0.179553463,0.0,0.0,0.21350324,0.30858664199999997,0.0,0.564701739,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45105041,0.0,0.0,0.0,0.53281943,0.39724716200000004,0.0,0.39388996200000004,0.20393278199999998,0.10096998800000001,0.0412357537,0.0,0.47196538899999996,0.43686772100000004,0.47401413600000003,0.0,0.0,0.18705129399999998,0.0,0.237583547,0.0255161404,0.0070898924200000005,0.0,0.250532228,0.280765999,0.0,0.0,0.0,0.0,0.0,0.0913711509,0.31054050899999996,0.0,0.0,0.0545715934,0.463432079,0.0,0.0,0.583428004,0.419047906,0.0,0.577306189,0.0,0.157522911,0.0,0.350389733,0.0,0.0,0.0,0.569293747,0.245132632,0.0,0.482617456,0.0,0.0,0.0866519922,0.0,0.0,0.0,0.0,0.474201385,0.6675255729999999,0.0,0.0745543154,0.48689449,0.0,0.0,0.0,0.0,0.0,0.431673012,0.0,0.0,0.06885632929999999,0.0,0.378725141,0.5355406429999999,0.183594984,0.012879321,0.400460046,0.581344767,0.519073586,0.35284946799999994,0.0,0.221953741,0.613238799,0.0918536655,0.540907548,0.158900601,0.196334345,0.0,0.7175438940000001,0.0068560579,0.33671008700000005,0.190465986,0.530708441,0.0,0.0,0.0,0.0,0.00388793085,0.567337889,0.434113636,0.0,0.586667599,0.0,0.476771834,0.667400554,0.0412694612,0.0,0.0,0.0,0.0,0.435615845,0.225712455,0.211080133,0.360585554,0.0,0.0,0.158304711,0.0,0.0,0.0,0.417569071,0.0,0.251515764,0.0,0.552699897,0.0,0.474112789,0.326260915,0.0,0.604264926,0.624304664,0.0731189139,0.21152854899999998,0.0,0.0869922456,0.0,0.158049855,0.508864776,0.393946226,0.5321166070000001,0.305651652,1.07574646,2.29055817,1.92568711,3.34451717,4.68387902,4.63918976,5.86124883,5.98607521,6.68098012,7.23480345,6.43510827,6.24534815,6.98849824,6.2860059,5.42363564,5.21202471,3.39204482,3.15174213,1.96911649,2.36416537,1.14767705,0.841068612,1.04194584,0.571077152,1.59523634,1.38906939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.033635,0.0,0.0,0.0870438212,0.224569288,0.0,0.630700058,0.342099551,0.114967906,0.49340087200000005,0.0,0.331421613,0.0,0.575821224,0.315588477,0.27775205,0.0,0.0,0.00851226276,0.0,0.0,0.0,0.362054239,0.0,0.188006358,0.49557425200000005,0.023664200099999998,0.0,0.0,0.0,0.218997865,0.31149524,0.0,0.107767444,0.8636819929999999,0.6687265139999999,0.39437433,1.48844222,1.09042364,0.0,0.590689406,0.0,0.0,0.0,0.0,0.33749076299999997,0.0,0.0,0.479204158,0.0,0.194291842,0.374378249,0.100378059,0.658260343,0.32951324600000004,0.214308157,0.521159844,0.0,0.06240078860000001,0.0,0.0787289387,0.0,0.299354016,0.63666481,0.0,0.430249027,0.289927119,0.423862546,0.586013364,0.18231030899999998,1.94374816,2.29497693,1.71118653,1.59355424,0.329793991,0.452326775,0.056894133300000004,0.735150505,0.0,0.0,0.652650023,0.264130915,0.145679506,0.20426163100000003,0.0,0.0,0.15930298,0.601538517,0.0,0.00413728853,0.0,0.0,0.43788455200000004,0.0,0.40434519700000005,0.0,0.320784032,2.25156668,3.43758937,2.50978002,0.29482273,0.0,0.0,0.269675516,1.35515196,0.0,0.0,0.0359579575,0.965680158,0.479733491,0.0,0.0,0.590742246,1.71795736,0.085522826,0.0,0.0,3.92977944,6.05964232,6.32124726,3.83000683,0.581996145,0.0,0.194623427,0.638725914,1.92317998,3.83070331,4.05620036,3.50972339,1.24092289,0.0,0.37762652799999996,0.36206763,1.157831,0.348556775,0.0,0.435073485,0.0419989766,0.225877515,0.552154774,0.0,0.550284965,0.714607239,0.40540729,0.0,0.0,0.0,0.208856437,0.0,0.0,0.5852434470000001,0.0,0.0,1.00693959,2.15851683,3.10120094,2.34312826,1.81199344,1.23809255,1.85195764,1.01270885,0.37070132,0.0,0.0,0.0,0.268597834,0.0,0.145973418,0.0,0.0,0.0,0.107288202,0.0,0.377623971,0.0,0.0,0.0,0.48595552399999997,0.30603765899999996,0.293070016,0.103510835,0.294123085,0.5349611470000001,0.0,0.0,0.264068222,0.9821951590000001,1.79059417,2.52905758,1.02031201,0.9114845420000001,0.0,0.242936603,0.08266865129999999,0.714220583,0.536173615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.07742244,0.94979071,0.0,0.0,0.0,0.0,0.18710761,0.0,0.0,0.0,0.60902441,0.43164376,0.0,0.58791115,1.97004695,0.0,1.40999544,0.0,1.00363962,0.42874262,1.19197169,0.0,0.82340832,2.0926063000000004,1.81586411,1.09305654,0.0,0.73508829,0.50675035,0.96551573,0.99483203,0.25357474,1.45101021,0.43358335,0.32697043,0.0,0.84302116,0.49378014,0.21083819,0.62293032,0.0,0.86010708,0.04917822,1.01611071,0.44059365,0.0,1.05009465,0.0,0.42589940000000004,0.0,0.03115238,1.13344309,0.27350615,0.67441778,0.0,0.0,0.0,0.08570475,0.0,0.0,0.0,0.0,0.31444743,0.0,0.1374651,0.53376002,0.0,0.0,0.0,0.1430214,0.0,0.0,0.0,0.0,0.0,1.76748692,1.14398829,3.00393449,1.54828581,2.36119167,2.76584862,2.34993992,3.99828987,2.90866904,4.34508635,3.8963591,3.87862784,4.00498453,3.90632514,4.94263562,4.13023381,2.55633848,3.22036185,2.92151197,1.94499941,4.30345123,2.28302678,1.66417345,2.79836118,2.27489525,1.86219293,0.0,0.0,0.37842639,1.29635348,0.0,0.0,0.8051837,0.0,0.0,0.74669764,0.02138414,0.0,0.26404589,0.63620208,2.61568115,0.51344529,0.46027221,1.15387344,0.13814839,0.51966467,0.0,1.07129158,1.31701833,1.03060864,1.36100051,1.18424094,0.0,0.40922548,0.0,0.0,0.35259261,0.32260769,0.48645765,0.0,0.0,0.0,0.20123505,0.59099202,0.0994272,0.0,0.0,0.0,0.0,0.0,0.54747704,0.0,0.0,0.47604671,0.70402341,1.40305506,0.48937820000000004,3.38500962,0.51996331,0.0,0.0,0.55443884,0.67761137,1.46792836,0.59072378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.901621427,0.711834448,0.548662663,0.259039978,0.0028288196899999996,0.317150775,0.0185652426,0.20144391,0.771433723,0.884883592,0.46873228299999997,0.49028869999999997,0.12132679699999999,0.257478428,0.0,0.18786707600000002,0.0,0.0,0.0,0.0,0.0,0.603175861,0.982139212,1.07429671,2.43289195,1.90474667,2.29527762,2.72194121,3.19819993,2.50479957,1.76732019,1.69761735,1.92712942,1.5006007,0.904234725,0.195259533,0.46382090600000003,0.0152475589,0.558970627,0.0,0.5184448629999999,0.229183406,0.287686068,0.280813553,0.282893882,1.16232146,1.20726976,0.7661041559999999,0.734712432,0.6834624640000001,0.48712303700000004,0.0,0.299518862,0.0,0.0,0.0,0.0,0.267349232,0.0,0.23367448100000002,0.0,0.134056286,0.0,0.0758565368,0.0,0.421282328,0.0,0.451659582,0.0,0.0,0.0,0.39168852600000004,0.142641709,0.0,0.172736098,0.48047879,0.194618978,0.0,0.0,0.0,0.37895022100000003,0.012764983700000001,0.0,0.252743885,0.0,0.0,0.0,0.13649297400000002,0.0,0.0,0.562121749,0.232616693,0.35126605299999997,0.0,0.589116199,0.307598715,0.0,0.501406108,0.27849558399999996,0.0,0.209957896,0.0,0.537795538,0.479972005,0.17353355199999998,0.734597307,0.0875491157,0.0,0.6781355990000001,0.222156756,0.439802905,0.0,0.0,0.193809791,0.0,0.0,0.0,0.0,0.390462342,0.0,0.237463748,0.73823083,0.0,0.583141264,0.0,0.0,0.0,0.0,0.0,0.0,0.137105739,0.0,0.0,0.0,0.222607041,0.494933179,0.266011398,0.7379683220000001,0.0,0.148059845,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.171328433,0.795839179,0.617901936,0.999351696,0.36702696100000004,1.11191847,0.6794512420000001,0.0902067849,0.0,0.353825685,0.0,0.0,0.0,0.0,0.478143925,0.47231693799999996,0.529805721,0.571658275,0.024349866600000002,0.808714552,0.341265861,0.0,0.0,0.0,0.17382873899999998,0.0,0.0,0.0,0.0,0.0268548946,0.41866389,0.8232452259999999,0.663027283,0.831884515,0.135137287,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.08925374,1.45551176,1.90373997,3.26202744,4.55583314,4.83261408,5.43105599,5.61691024,5.52817773,5.2482052,4.02200392,3.6652237000000003,2.62613684,1.8008883999999998,0.935145573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.146415669,0.370690455,1.06408141,1.10268913,0.759367921,0.446752336,0.0,0.0,0.26500504399999997,0.0,0.0,0.0,0.242557104,0.0,0.826949497,0.73964243,1.98368092,1.67665334,2.22103046,2.21441666,1.76921309,2.11593875,1.53466871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.407742824,0.0,0.0,0.17337025,0.0,0.0,1.06154624,0.69843739,0.71396515,0.529237306,0.41525340000000005,0.0,0.0,0.0,0.712446985,0.0,1.79477276,0.0,0.500453341,0.0,1.79046001,0.309719494,0.0,1.95472904,2.07400939,0.0,1.6441383999999999,1.55992888,0.0,1.34626354,0.43582784799999996,1.63791838,0.0963405884,0.676593874,0.8531158870000001,0.0,2.57485974,0.0,1.68334596,0.0,0.0,0.0,0.0,0.0,0.23254596800000002,1.09643781,0.48068903,0.0,0.23366701199999998,0.0,0.0,0.580290468,0.0,0.773854013,1.22437761,0.05637855519999999,0.0,1.31636562,0.0,0.0,1.38458673,0.0,0.749244151,0.923498154,1.28852184,0.0,0.0,0.19183757399999998,0.0,0.0,0.0,0.0,0.0,0.895398823,0.0,1.03750338,0.016558850400000002,0.0,1.06431013,0.0,0.0,1.11658659,0.409240441,0.389780274,0.58176522,0.7285057420000001,0.000123635246,0.861048645,0.0,2.02928612,2.01451058,0.0,0.0,1.21597517,1.11213261,0.0,1.2461065,0.34237417600000003,0.0,0.343483794,0.0,0.0,0.0,1.8621282,0.0,0.0,0.0,0.0,0.773858522,0.0,0.0,0.0,0.0,0.0,1.48665287,0.60417302,0.0,0.0454779808,0.0,0.0,0.0,1.22232995,0.0,0.0,1.28013527,1.23506531,1.32702045,0.634618218,0.54757928,0.327057624,0.0,0.0,0.0,1.55505516,0.969287413,4.16226453,3.1542601,4.73418413,4.7628066,4.1908557,4.13198436,2.2146119,0.8231220090000001,0.0,0.0,0.0,0.00283361691,0.0,0.458425295,1.02310516,1.33376404,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.8748978940000001,0.0,1.9672988999999999,0.0,0.0,1.46595292,0.529418856,0.0,0.0373873251,0.902835596,1.03695778,0.0,0.0766365279,0.389501748,1.11020428,0.0,0.0,0.754802047,0.9716017579999999,0.11266926,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
1.11382557,1.19156367,0.205549857,0.0,0.0,0.0,0.6141129,0.49848593799999996,0.015993963400000002,0.18345411399999997,0.807228543,1.93124846,0.379227328,0.830946658,0.0,0.0,0.0,0.0,2.02776507,0.44030578200000003,0.0,0.0,0.629132708,0.0,0.0,1.5011317,0.128892421,0.200185776,0.401924751,0.8779775790000001,0.427899737,2.61298086,3.16841951,2.10426827,1.19401294,0.972754982,0.15281656,0.0,0.0,0.481640487,0.0,0.0,0.682759095,0.472816874,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.43402516,0.421607012,1.89469815,0.893019443,0.8113664079999999,1.15300697,0.0,0.0,0.374672998,0.840929026,0.0,0.0,0.398401876,0.524299515,1.17709885,1.48988142,0.0,0.0490884742,0.0,1.81466639,0.937526368,0.8614977070000001,0.0,0.0,0.534058976,0.19855314,0.87968633,0.31550034600000004,0.0,0.353979239,1.87616169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.84655969,0.032316177200000004,0.0,0.15751229,0.0,0.9885553690000001,1.16807214,2.69986379,2.00579647,2.55304734,1.92190728,2.85772862,2.60186719,4.92921239,1.91178628,1.03621015,1.30623991,0.383845645,0.126620351,0.0,0.0,0.0,0.0,0.68071653,1.10246299,0.0,0.0,0.0,0.0,0.24780844300000002,0.0,0.014228984299999999,0.044431035199999996,0.0,0.0,0.0,0.646534121,0.0,0.179184412,0.0,0.0,0.7261860590000001,0.0,0.9002665670000001,0.5432359,0.0,0.0,1.15054593,0.507792565,0.81151182,0.0,0.0,0.0,0.679798366,0.0,0.0,0.287833033,0.247823958,0.0,0.0,0.0,0.344920965,0.0,0.0,0.0,1.50786783,0.114919635,0.613614167,0.0,0.252635603,0.36751146,0.7832485509999999,0.740877362,0.0,0.796752421,1.21846225,1.70717121,1.27653138,1.43090247,1.40309106,0.187710231,1.13336459,0.215287549,0.0,0.23774488,0.210212282,0.24310205399999998,0.8225525890000001,0.726419762,0.0413349281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.598053664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.30317651,0.0,0.049140799299999996,0.13578536,0.265929211,0.0849380409,0.42635351,0.21932772600000003,0.0,0.15661472099999998,0.0951444256,0.34979155,0.48339694299999997,0.0,0.0,0.35240165,0.196546301,0.162952965,0.0,0.25862277300000003,0.0,0.20666204100000002,0.0,0.0106030274,0.608531436,0.0,0.5824205729999999,0.0298613423,0.0,0.297404614,0.0,0.0,0.0,0.118494684,0.6265744910000001,1.16622257,2.79795752,3.64558155,3.90482227,4.65567497,4.91248859,4.40549727,3.53438807,3.39769406,2.11494406,0.841943463,0.45837031799999994,0.0,0.0,0.0,0.0,0.063547017,0.352896827,0.5350662429999999,0.25873378199999997,0.25598677,0.788057518,0.473714543,0.20035416600000003,0.257166564,0.0,0.645172365,0.6779071109999999,0.0523487579,0.6713446279999999,0.72709144,0.11487602599999999,0.27538764,0.723388583,0.668654576,0.5989838829999999,0.8429512109999999,0.29531571100000004,1.27051987,0.701725796,1.21135651,0.969580243,1.23448849,0.45221313,0.404041605,0.26122271399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
3.04400845,2.37140633,2.77009452,0.58496852,0.0,0.0,0.0,0.0546324333,0.0,0.303227195,1.31200834,0.0,0.48985388799999996,0.0,0.0,0.0,0.0,0.0,0.39169805799999996,0.66300219,0.331932975,0.00115757007,0.200837076,0.0,0.0,0.0,1.77647599,2.88174896,2.5985287999999995,2.73557068,0.0,0.0,0.0238075273,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
10.9005173,10.615515,8.42269016,5.22973291,2.22052466,0.29139997100000004,0.0,0.0,0.522587224,0.674881825,0.305339288,0.0,0.0,0.0,1.20417964e-16,0.827534542,1.49520383,1.77721304,1.69523601,1.4515385,1.26201004,1.21116859,1.22071236,1.13733637,0.8661060770000001,0.45334681,0.0658892271,0.0,4.81671854e-16,0.33948483799999996,0.7279429759999999,0.9770700290000001,0.984030037,0.770666625,0.451970889,0.162694289,0.0,0.0,0.0,0.022262430899999998,0.0428660616,0.029343139700000003,1.6055728499999999e-16,0.0,0.0,0.0,0.00853417859,0.0176994336,0.013374226699999998,0.0,0.0,0.0,0.0,0.00745792816,0.0176311135,0.015051976100000001,0.0,0.0,0.0,0.0,0.0129232202,0.0323014437,0.0289948669,1.6055728499999999e-16,0.0,0.0,0.0,0.0320862861,0.08595601119999999,0.0838096929,4.81671854e-16,0.0,0.0,0.0,0.220679192,0.89067566,1.77928562,2.69349434,3.39149486,3.66504366,3.41719824,2.70405595,1.72142064,0.73815286,0.0,0.0,0.0,0.0,0.112563463,0.22460724399999998,0.163682264,2.70940418e-16,0.0,0.0,0.0,0.070426482,0.15493172800000002,0.122460358,3.21114569e-16,0.0,0.0,0.0,0.0681131306,0.154909778,0.12616682699999998,1.20417964e-16,0.0,0.0,0.0,0.08260235469999999,0.20534131,0.214540197,0.12654000199999998,0.0393921744,0.056159176799999995,0.197325268,0.37125370399999996,0.432582504,0.292475026,8.32890914e-16,0.0,0.0,0.0,0.162324878,0.378826506,0.315892485,0.0,0.0,0.0,0.0,0.5471058870000001,0.9370613959999999,0.764339325,0.0,0.0,0.0,0.0,2.45119237,5.89595133,9.10597209,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
0.7368810490000001,0.0,1.4872626,0.5087527629999999,0.717052405,0.0,0.0,1.03533836,0.0389385425,0.18956815,0.18377229899999997,0.115035278,0.0005807844189999999,0.0,0.110377283,0.0,0.255574658,0.0,0.0,0.0,0.0,0.526922277,0.38953160299999995,0.0,0.0581391829,0.0,0.721635666,0.121221105,0.25596255100000004,0.0,1.24831522,0.38125073200000004,0.768850803,0.0,0.0,0.731228545,0.0,0.48713358,0.582245679,0.7808108659999999,0.0952720415,0.505985849,1.03683088,0.0,0.134428975,1.13669256,1.06978697,1.16247592,0.588146265,2.95655896,2.03402282,2.42119828,2.47562065,3.00121265,2.35980038,2.63187854,2.77706868,3.09419848,1.92631341,1.85178676,2.31357742,1.56598285,2.60406345,2.66793545,0.85790604,1.5472792,0.999583005,0.793433643,1.03835067,0.0,0.031443812,0.314467208,0.0,0.0,0.0,0.0,0.094933642,0.0,0.959016001,0.367766725,0.0,0.09478006720000001,0.9731540879999999,0.534980393,0.16629148,0.557381655,0.0,0.0,0.0,0.625206216,0.0,0.05935448559999999,0.206969682,0.0,0.120064029,0.893046624,0.502221731,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.499663419,0.47120333200000003,0.528477677,0.738678389,1.09523608,1.50519298,1.8203148999999998,1.90245644,1.69555895,1.27016641,0.815591535,0.576701982,0.7574006670000001,1.42982322,2.48880199,3.67413024,4.65542523,5.14784009,5.01321203,4.30665492,3.25092659,2.15048934,1.28124167,0.8002107909999999,0.708930174,0.880014402,1.12963315,1.30094048,1.32221552,1.21806905,1.07502343,0.9831949590000001,0.98460242,1.0525768,1.10969313,1.07232445,0.897618412,0.608857485,0.287000823,0.0333981773,0.0,0.0,0.12034732699999999,0.286724694,0.38059517200000004,0.357357281,0.232247278,0.06864237570000001,0.0,0.0,0.0,0.119208946,0.245329093,0.306141449,0.276816196,0.17552991,0.0512289991,0.0,0.0,0.0,0.0491299121,0.130555551,0.186342587,0.21094750399999998,0.219730562,0.235787522,0.273306882,0.327191985,0.37478947,0.38861446200000005,0.352786483,0.273805191,0.17937331899999998,0.105519621,0.07875481320000001,0.102917093,0.158115496,0.212865682,0.243392291,0.249875299,0.260425545,0.319435562,0.464836042,0.704789971,1.00543463,1.29676673,1.4956921,1.53737599,1.40199095,1.12560414,0.790476498,0.498475126,0.337909466,0.35616931399999996,0.5475072320000001,0.858864077,1.20978147,1.51801431,1.72187809,1.79320555,1.7392181,1.5954839,1.41401813,1.2503401,1.1518712,1.14871459,1.2474091999999999,1.42861513,1.65005945,1.85555246,1.98915441,2.01121418,1.91124609,1.71266666,1.46672108,1.23680171,1.07821048,1.02048966,1.05869333,1.15660112,1.26029564,1.31669092,1.29010532,1.17131818,0.976958283,0.740921086,0.502140335,0.293519155,0.13531052300000002,0.0337609859,0.0,0.0,0.0,0.00689045502,0.0239467404,0.0286034246,0.0188422483,0.0,0.0,0.0,0.0,0.0,0.0203140177,0.0396221284,0.0400072885,0.0180556058,0.0,0.0,0.0,0.0,0.013371055,0.088914994,0.161639051,0.210010732,0.22228744600000003,0.200676808,0.158966718,0.115021285,0.0820944708,0.06341169969999999,0.0526315509,0.0395876514,0.0178416722,0.0,0.0,0.0,0.0,0.00291379315,0.037918459,0.0577847563,0.050812944699999994,0.0187858191,0.0,0.0,0.0,0.0,0.0249703689,0.0631926835,0.07071085519999999,0.040599782599999995,0.0,0.0,0.0,0.0,0.0,0.0612946996,0.0961716764,0.0814015763,0.0230875355,0.0,0.0,0.0,0.047689379000000004,0.187803448,0.313645616,0.37312116,0.34141910200000003,0.234480355,0.102833625,0.00784287666,0.0,0.055082722699999996,0.157349425,0.23523092399999998,0.236326758,0.147658999,0.00531149809,0.0,0.0,0.0,0.090760525,0.296547065,0.454688281,0.518048686,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
1.93486518,0.0,0.32625555,4.67510343,4.99951376,4.47845226,5.67070218,5.37747863,2.26991893,3.15748127,8.62367107,0.0,0.0,4.02397758,0.0,2.08162917,1.86472267,0.0,0.8515398999999999,0.0,1.34022317,0.0,0.0,1.56777321,0.0,0.0,0.84556059,3.8948968999999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.555701462,0.11737387699999999,1.17530909,0.0,0.683832483,0.647321347,0.503193012,0.5748112439999999,1.01723161,0.9775947559999999,0.836685357,0.281775138,0.594645455,0.0,0.642607222,0.363954548,0.0,0.276288156,0.105872928,1.42993114,0.0,0.548818688,0.0,0.08755413320000001,0.312019297,0.0,0.0,0.483360509,0.45212243799999996,0.783048447,0.5330260520000001,0.0,1.55718122,1.1715943000000002,0.0,1.37432853,1.11239795,0.790493353,1.51157064,0.91159502,1.36476769,1.65748471,0.0,0.812831257,0.7478283170000001,0.919812064,0.605884202,0.0,0.0,0.23442324,0.025405498199999998,0.33584928399999997,0.13923479800000002,0.0,0.0,0.0,0.542889741,0.0,0.14777927300000002,0.0,0.09563728789999999,0.501471895,0.40019011299999996,0.0,0.0,0.251949694,0.617726252,0.0,0.33994808600000004,0.0,0.153070018,0.487435401,0.6927951179999999,1.48364517,0.994079652,0.764231551,0.502597517,0.613116998,1.01351596,1.69607526,0.43727562700000006,0.11794687599999999,0.232340402,0.7474842509999999,0.8642240290000001,1.69924738,0.0,0.0,0.008996536650000001,0.721771252,0.0,0.872440929,0.258758005,0.0,0.0,0.231271563,0.0,0.045132922699999994,0.78541139,0.43353167200000003,0.536964176,0.0480521451,0.595644562,0.23262208899999998,0.701271262,1.18880321,1.81916579,1.54923031,0.46853147,0.0421279533,0.0,1.11170635,1.44650299,1.61257587,0.0,0.573324187,0.610694266,1.79810698,1.60605564,0.691935387,1.07291841,1.08470617,1.80435422,1.52631147,1.40535364,1.46541164,2.12018818,1.04778396,0.7325000840000001,0.0,1.20345743,0.478977761,0.51802711,0.924726033,0.7173143670000001,1.08358636,0.6204008089999999,0.0,0.0,0.7858147120000001,0.194957047,0.718330239,0.0,0.0,0.424139363,0.054390694100000005,0.9425572879999999,0.926648983,0.0,0.998566498,1.09498388,0.5513690520000001,1.8084752,0.680041479,1.87205379,3.01752972,1.7206639,2.52336636,3.56923461,3.1446713,2.51158351,2.46039193,1.51419958,1.03217805,0.43820852,0.670335945,0.47464221100000004,1.76615203,0.0,0.0,0.0,0.0,0.0,0.037105894900000005,0.746222052,0.0,0.566452621,0.0,1.09541871,0.0,0.0,0.857740933,0.303968864,0.0,0.0,0.0,1.03493191,0.319828729,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.831780495,0.0,0.0,0.0,0.203055955,0.577472274,0.336578503,0.595667962,0.443843965,0.931527963,0.888589792,0.7261821079999999,0.0,0.791868437,0.730891017,1.32576307,0.56569048,0.948073663,0.597508371,0.0,0.0,0.966780412,0.671617537,0.515929257,0.0,0.060529348499999996,0.8940789990000001,0.0,0.0,0.0495248879,0.99400243,0.0,1.83379651,0.0,0.434811946,0.9628998120000001,0.0908521925,0.44007113,0.088381534,0.769366015,0.423019965,0.0,0.0,4.29235443,0.7158265220000001,2.03309556,0.754491568,0.0,0.0400025446,0.0,2.64640429,2.42097165,0.0,0.155443636,0.0,0.0,0.0,0.0,0.0,0.6145676210000001,0.929030074,0.6685744060000001,0.932723545,0.594031943,0.920752591,0.343596358,3.30611171,0.589559611,0.256817069,0.0,0.8146767090000001,0.0,1.35940181,0.0,0.916212345,0.0,9.50616829,2.67778736,0.0,1.81034302,0.0,1.31833879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
1.33929521,0.728742945,0.0,0.0,0.113535278,0.0,0.0,0.0,2.77869754,0.0,1.61872962,1.16356078,0.0,0.0,0.0,0.0,0.0,0.7398059290000001,0.28394934899999996,0.5757874470000001,0.0249773194,0.823018866,0.160696167,0.144568634,0.0,0.616008176,0.0,0.0,0.711557287,0.0,0.824209948,0.0,0.146650825,0.0,0.0,0.0146536425,0.0,0.0,0.31011446600000003,0.0,0.197968024,0.0,0.206244695,0.0285375457,0.47001255299999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.15864248,1.36831099,0.33038942,2.36197171,4.08774,1.23552071,3.38130733,2.04649629,0.448820295,0.0,0.707785508,0.76333074,0.0,0.47117466,0.0,0.54707345,0.0,1.7918424,0.0,0.336732219,0.671901816,0.0,0.0,0.391702544,0.18379650100000003,0.8968743640000001,0.427966481,0.0,0.0,1.23237503,0.690271981,0.22145664399999998,0.310093485,1.31600571,1.8044663,0.0,0.289492798,1.32285729,0.578750883,2.16454952,0.0,0.0,1.53449383,0.0,0.0,1.21079229,0.703051465,1.50639414,0.590989909,0.0641813035,1.41213017,0.0,0.0,0.0,0.0,0.192645275,0.646095333,0.0,0.990573368,1.27306284,0.500877887,0.917519915,0.817967515,0.0,0.0,0.0,0.0739785352,0.0,0.0,1.15951458,0.665322579,0.840548575,0.0,0.34761842200000004,0.0,1.67860442,0.33892571299999996,0.793707561,0.0,0.93133871,0.0,0.5689033,0.8350922909999999,0.0,0.0,0.22107465199999998,0.48403662799999997,0.7859886290000001,0.866123627,0.563521863,1.70177365,0.0,0.0,0.0662620264,0.0,0.697464981,0.0,1.57952556,0.0,0.0,1.26085613,0.56731502,0.845433454,0.0,0.039440314500000004,0.0,0.575172815,0.0,0.0,0.0,0.348232185,1.26342344,0.28726952,1.95185825,1.06978544,0.6170162539999999,2.25271635,1.50668601,2.61134331,0.8262226559999999,1.10092207,1.18551659,0.626261996,0.8418045190000001,0.561631704,0.0,0.041353585,0.0,0.8892847620000001,0.0,0.361893963,0.93045391,0.316414139,0.11013445300000001,0.0,1.55492003,1.14172292,0.0,0.0,0.276859638,0.0,0.0950320695,0.9960018829999999,0.417842151,0.0,0.251893889,0.84481305,0.0,0.23789128,0.0,0.0,0.0,0.306457194,0.20065190300000002,0.0,1.55217032,1.22869517,0.0,0.0,0.5581241029999999,0.0,0.0,0.0,0.579485448,1.72494371,1.13316996,0.0,1.76114756,4.24465333,4.02457226,4.66026688,4.74469796,3.96363831,3.15183128,3.18181733,1.58277889,0.9971234240000001,2.05030665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
1.14703249,0.682199689,0.705545125,0.7598106259999999,1.01233781,0.8693136159999999,0.7590278570000001,0.195219289,0.261280699,0.0,0.208338835,0.335972316,0.67880493,0.23768973399999999,0.0,0.0,0.330215098,0.0,0.355220442,0.0,0.0,0.0,0.29139371,0.0,0.252776304,0.229221375,0.0,0.0,0.378657845,0.0,0.0,0.150579228,0.176066472,0.32555055899999996,0.0996832404,0.503999779,0.6001938920000001,1.05727206,0.7502318440000001,0.38671506,0.846872712,0.0,0.0,0.8084980429999999,0.09512452939999999,0.978467871,1.02528615,0.285940574,0.012353042,0.174932721,1.13744333,2.37892553,3.47898847,3.32375859,2.94502869,1.81092959,0.416985549,0.0,0.0953641597,0.0,0.0,0.0,0.0,0.0,0.20884037100000002,1.30650826,2.60347971,3.23791951,2.49639341,1.14370959,0.968720373,1.23766394,1.62065695,2.69941727,3.44870302,4.04386534,4.69795286,4.42142527,4.79222574,5.13929422,5.05890956,5.89014926,5.14931463,4.68521143,4.29674945,3.97575568,2.90881519,2.84813648,1.92598636,2.08592997,2.93198588,3.40519936,3.03815695,3.58408165,2.55568272,1.73484749,0.758994733,0.0,0.258586105,0.0,0.27420048399999997,1.07997715,1.13836689,0.508632625,0.7277449890000001,0.468176279,0.0,0.0,0.0,0.0929019873,0.0,0.0,0.0,0.535039505,0.0,0.0,0.555263625,0.0,0.172861457,0.0,0.0172796583,0.366331588,0.0,0.0,0.0,0.21862691199999998,0.0,0.0,0.23367490100000002,0.287962939,0.0,0.0276518141,0.0,0.0,0.0,0.0578756921,0.0,0.0,0.0,0.0,0.409676005,0.478562531,0.043756635700000004,0.0569139646,0.0,0.0994691016,0.38097485700000006,0.0,0.0,0.0,0.647614892,0.416354247,0.456613469,0.849281803,0.304463744,0.439065539,0.0,0.369569263,0.0,0.519705238,0.0,0.0,0.20077416899999997,0.0,0.0,0.0,0.481798245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0311988413,0.08769084949999999,0.278625375,0.0,0.258737683,0.476749962,0.244922223,0.123549255,0.241277845,0.269807894,0.44860825,0.0,0.22699107899999998,0.0,0.0,0.137980452,0.349606111,0.152889106,0.0,0.0,0.0,0.0,0.503433598,0.201157429,0.0,0.135480335,0.0,0.0,0.0,0.268738556,0.00308899797,0.04346892,0.24459934,0.0,0.348602851,0.0,0.774181942,1.14749419,1.1555823,0.87486071,0.385631613,0.41324571299999996,0.289601165,0.17407113600000002,0.046307644,0.34867213399999997,1.23464175,1.51950165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.18886178,0.24967081,0.30206176,0.53822957,0.07915388,0.12077865,0.20690698,0.16902060000000002,0.0,0.0,0.16320751,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31291301,0.19725284,0.75495322,1.51686269,1.68728058,2.22966184,2.82379912,2.77257399,3.2014216,3.45638053,3.8604807,3.80957594,3.55004531,3.17413442,2.7789764,2.18582301,2.30291191,1.29750502,1.1698955,0.46008074,0.28389790000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12407458,0.51354947,0.65034535,1.09079474,1.19451533,0.88498359,0.93068414,1.52362737,1.51737532,1.50912296,1.41257644,1.39718512,1.8584598,2.10489907,1.48654358,1.48661758,1.59432437,1.44326019,1.57304701,1.73417492,1.70582715,1.1017915,1.20675704,0.78663093,0.79824179,1.16515232,0.85578526,0.48434476,0.12184849,0.35708923,0.19103694,0.0,0.0,0.21631923,0.0,0.0,0.14323842,0.0,0.0,0.26045793,0.0,0.0,0.16451559,0.16680339,0.26161624,0.0,0.0,0.0,0.0,0.03502198,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
1.42876687,0.47576561700000003,0.0,0.0,0.42603466700000003,0.0,0.050588998899999994,0.0,1.09244335,0.170214597,0.0,0.21324579899999999,0.21925437399999997,1.19264169,1.3187102,0.0,0.0,0.759424788,0.8731491370000001,0.0,0.0,1.21407404,0.0,0.0,0.0962720701,0.618307284,1.08724687,0.0,0.32110326899999997,0.161143227,0.0,0.272283754,0.0,0.0,0.704524713,0.15733577099999999,0.0,0.0,1.04722439,0.0,0.0,1.24102585,0.0,0.705284985,1.33154035,2.641946,0.887500395,0.0,0.0,0.0,0.0,0.0,0.998931895,0.0,0.0,0.0,0.506471137,0.56636064,0.0,1.49195445,0.0,0.0,1.89277609,0.0,0.0,1.9549501,0.0,1.01126774,0.554853629,0.0,0.0,0.0,0.0,1.39528278,5.49241459,6.45526335,4.64421186,1.42219619,0.901648896,1.59501945,1.96505349,0.9353137340000001,1.12473735,0.0,0.0,1.64200296,0.0,1.87827238,1.23360149,0.40412532700000003,0.171467688,0.557370396,0.18850603300000002,0.0,1.37899966,0.323283653,0.0,0.013192846999999999,0.0,0.0,0.0585254996,2.00571065,0.0,0.271281076,0.970914962,0.412103923,0.0,0.410544821,2.13008984,0.076194496,0.0,0.0,0.8448533159999999,1.98531048,1.57803248,0.261055932,0.0,3.06405957,0.0,0.0,1.20710615,0.0,0.0,0.0,2.99822996,0.25534899899999997,1.91401354,0.43168627600000004,1.16112449,0.433648318,0.0,0.0,0.49485230399999997,0.0,0.0,0.0,0.8706344140000001,0.0,0.23113864399999998,0.0,0.646801569,0.0,1.01530483,0.507225265,0.0048691650700000005,0.0,0.0,1.49343325,0.95264925,0.0,0.0,0.33095251,0.0,0.0,0.7895447859999999,0.349106827,0.521048882,0.271233669,2.75240031,2.45407671,0.101191324,0.659300587,0.0,0.0,0.7606753270000001,0.0,0.33661757299999995,0.924798861,0.36667530600000003,1.82446614,2.80529126,1.93295055,2.00612105,1.68236772,0.0,0.182145538,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.401
0.143620517,0.31479658899999996,0.0,0.10887519699999999,1.02201326,0.6975808029999999,0.0,0.0,1.20760087,0.249813473,0.0,0.5437687170000001,7.94457143,10.266686,3.99068056,0.0,0.0,1.39910449,0.40364241,0.0,3.29443813e-16,0.90107632,0.0,0.0,0.441675714,0.510759385,0.0,0.0,0.652371801,0.10797390300000001,0.0,0.11420356400000001,0.7344652859999999,0.0,0.0,1.0122033000000001,1.78971818,0.188873834,0.0,2.28106529,4.00342192,2.21519459,0.0,0.0,0.275238792,0.24627625399999997,0.0,0.0,0.163011114,0.021895451200000002,0.0,0.0150452249,0.07676251,0.0,0.0,0.0355114447,0.0258026615,0.0,0.0,0.0334111868,3.6897707e-16,0.0,0.0139083748,0.0755186091,0.0553799422,0.00633830934,0.00505791361,0.00670788966,0.0,0.0,0.0380223192,0.0,0.0,0.0346127657,0.0778959084,0.0,0.0,0.186425392,0.08782478140000001,0.0,0.17952564699999998,2.12739664,3.16212093,1.70136988,0.0,0.0,0.44180209299999995,0.205959627,0.0,0.0,0.353029496,0.0,0.0,0.144829554,0.33501623399999997,0.27075351,0.99199109,1.59566997,0.36191761,0.0,4.48043585e-16,2.91010561,3.61312654,1.47637584,0.0,0.0,0.219258189,0.0837299707,0.0,0.0,0.0512850354,0.0,0.0,0.0,0.0,0.0296120835,0.032173841200000004,0.0,0.0,0.0902954845,7.64309645e-16,0.0,0.0414322491,0.135847038,0.0,0.0,0.196223392,0.136228897,0.0,0.0,1.20910063,1.85759745,0.968543127,0.0,0.0,0.135899725,0.0855419689,0.0,0.0,0.0684170445,5.2711009999999995e-17,0.0,0.009481681700000001,0.0190890682,0.0,0.0,0.0,0.0,0.011792208200000001,0.00277401446,0.0,0.004331498499999999,0.030841546299999998,0.0,0.0,0.0327228442,0.0299271867,0.0,0.0,0.0647118885,3.6897707e-16,0.0,0.0254349868,0.07906559469999999,0.0,0.0,0.0908040394,0.0554589547,0.0,0.0,0.163669231,0.0,0.0,0.111911507,0.241479098,0.0,0.0,0.8509495690000001,1.83340888,1.27398777,0.19747821100000001,0.137534825,0.64289971,0.5499779539999999,0.0806902357,0.0,0.136016189,0.048137205700000005,0.0,0.0,0.0528964552,0.0,0.0,0.0113282617,0.0146023953,0.0,0.0,0.00268084297,5.10665123e-05,0.0010565742800000002,3.0308830800000003e-16,0.0052391054,0.0,0.0,0.0800768369,0.477594865,0.7213015079999999,0.416603289,0.067564051,0.299617696,0.644208462,0.406940685,0.00798495564,0.044302696399999994,0.11136454900000001,0.0,0.0,0.183805379,0.109468291,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
3.21102419,3.41047028,3.07348027,3.45910916,3.19971268,3.32479132,2.86096793,3.14949307,3.23503758,2.99530239,2.84472858,2.63689064,2.51417099,2.41809245,2.17645291,1.76891558,1.42143353,1.41807181,1.63568796,1.2305482,0.951308858,0.982144785,1.01745478,0.461938791,0.75027818,0.225902391,0.0,0.264700094,0.268371834,0.190879293,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.041727392,0.129728776,0.0,0.061918332300000004,0.0,0.526509529,0.320536773,0.0621456757,0.429167357,0.35458145399999996,0.690884486,0.27834604,0.6791282740000001,0.284378473,0.547747371,0.801786267,0.767878982,0.7487448879999999,0.5483016820000001,0.443414245,0.20958898399999998,0.34069242299999997,0.0,0.264906843,0.209340726,0.0,0.0186784382,0.0175110752,0.0,0.0,0.21849970000000002,0.049533155,0.0,0.0,0.0,0.0,0.0871603019,0.0821763435,0.0031401167100000003,0.036641245499999996,0.0894865468,0.0,0.0,0.0,0.153857261,0.124835736,0.26329454399999996,0.33842586399999997,0.285781983,0.0687778663,0.08680876119999999,0.456236385,0.0,0.40250608,0.244613086,0.352981925,0.421019166,0.16719704900000001,0.539418605,0.237753785,0.279446792,0.571452945,0.0707277667,0.473719199,0.0821399447,0.402391326,0.40124761200000003,0.0,0.15515434,0.0,0.0281763053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.046413271900000004,0.0,0.0,0.0428590009,0.217386288,0.500642038,0.285020891,0.34361833299999994,1.02563215,1.12600103,0.921984935,1.18769816,1.76748715,1.52807013,1.79012906,2.01504025,2.21487008,2.217686,2.32983005,2.88972486,2.55802654,3.1394297000000004,2.64631732,2.84329957,3.36663502,2.99781125,2.99099328,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
1.37550006,2.87828458,3.82050696,3.80331625,3.01959206,2.07795874,1.53492897,1.50404104,1.63901859,1.48036213,0.864818695,0.0605941642,0.0,0.0,0.0,0.335858066,0.36304343899999997,0.0488565596,0.0,0.0,0.0,0.27206199999999997,0.330250989,0.0617297474,0.0,0.0,0.0,0.328722141,0.489519789,0.24535434600000003,0.0,0.0,0.12357418699999999,1.02023577,1.89140949,2.26591223,2.0594443,1.65304497,1.60986692,2.25099234,3.41142359,4.54420074,5.07310848,4.72969254,3.66007254,2.28064212,1.02875178,0.178203571,0.0,0.0,0.0,0.0991841932,0.143617104,0.0524324388,0.0,0.0,0.0,0.084270181,0.148695139,0.06580898240000001,0.0,0.0,0.0,0.109687281,0.21243672600000002,0.104930875,0.0,0.0,0.0,0.163870953,0.347829425,0.188298322,0.0,0.0,0.168109282,1.45738567,3.04140498,4.2110768,4.52616852,4.13721326,3.63883474,3.56146842,3.91896417,4.19373023,3.77902743,2.51305107,0.859662906,0.0,0.0,0.0,0.217299661,0.49594892100000004,0.278132859,0.0,0.0,0.0,0.107619053,0.29096952,0.182214192,0.0,0.0,0.0,0.0668924596,0.207952028,0.140081811,0.0,0.0,0.0,0.0430863637,0.151803481,0.10450019699999999,0.0,0.0,0.0,0.162512421,0.24212678699999998,0.14927981699999998,0.0,0.0,0.0,0.16220087800000002,0.278083878,0.190658288,0.0,0.0,0.0,0.0264039861,0.182007103,0.151199216,0.0,0.0,0.055861166600000005,0.437539694,0.768205492,0.776582412,0.43289621799999994,0.0,0.0,0.0137049668,0.35984399100000003,0.46915045899999996,0.14813441800000002,0.0,0.0,0.04319902900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
3.428485,3.27517244,1.34348743,1.72350169,4.60080802,1.86803302,1.22605549,1.1809436000000002,2.38048792,2.36326519,5.09790623,7.79775146,5.88872216,2.08784939,0.84859813,2.33526169,0.34483685,0.31790291,0.83613669,0.0,0.56983779,0.24898682,0.12155654,0.99092385,0.0,0.0,0.70859948,0.39242309,0.5831326,1.04328214,0.76982793,0.0,0.0,0.56771283,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.577846693,0.0,0.0,1.70317483,3.38865626,3.73494491,4.08687293,3.55207433,1.03509374,0.722047221,0.686535969,0.6239515179999999,0.584147551,0.124791761,0.0,0.575716565,0.0,0.0,0.78202877,0.0,0.374547675,0.543413703,0.0,0.680954735,0.0,0.0,0.32242154,0.0,0.390908546,0.0,0.0,0.0,0.459375094,0.0,0.280051646,0.0,0.8145710829999999,0.362507123,0.0,0.0448313979,0.282321879,0.76142467,0.0,0.0,0.23356375699999998,1.58072345,0.0896923402,0.252350064,0.0,0.0,0.0,0.0,0.0,0.0,1.69833936,1.37822039,0.44436540399999996,2.40152059,2.42133177,0.549415283,0.0,0.5574071079999999,1.57162367,0.0,0.45587982200000005,0.0,3.02092652,2.51592594,2.31219796,2.74251577,1.88550075,1.83246585,0.9712968890000001,1.02115019,0.061607456500000005,1.03943951,1.29823151,2.49387305,1.50315861,0.445429216,1.38473394,1.4696998,0.44907964100000003,0.194105157,0.0,0.506488478,0.344930841,0.121402725,0.015670909099999998,0.678119244,0.0,0.0,0.7806452629999999,0.0,0.0,0.0,0.331723223,0.0,0.0,0.116599294,0.48089351700000005,1.33689648,0.0,0.0,0.8621573929999999,0.0,0.0,0.303723472,0.293861518,1.68579667,0.434272551,0.0,0.19617528899999997,0.0,0.551764194,0.0,0.0,0.34746053299999996,0.645296729,0.0,0.0179685598,0.0,0.0,0.47149866799999995,0.285082557,0.128333074,0.693210696,0.12562253199999998,0.0,0.0,0.152943787,1.64051332,0.240915441,0.22240237399999999,0.0,0.35142842799999996,0.153301765,0.0,1.42947876,0.273478744,0.0,0.160681407,0.0,0.5080174829999999,0.013517436399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.703980772,0.00895020854,0.895415596,1.05545941,1.26543539,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.665074983,0.7133565709999999,1.41633252,0.919843843,0.0,0.591483619,1.35855765,0.26310825600000004,0.0,0.0,0.567750956,0.0,0.17761203399999997,0.0,1.36963971,1.08849337,0.553599529,0.0,0.0,0.368801155,0.515365513,0.0194798549,0.0,0.0,0.024504379399999998,0.0,0.0,0.432729755,0.07236434309999999,0.09190629060000001,1.39359658,0.0,0.0,0.36064670299999996,0.9536943920000001,0.0,0.482142561,0.0737269336,0.0835465381,0.246709053,0.8425095220000001,0.0,0.0,0.312194152,0.0,0.0,0.34601180200000003,0.311018356,0.00357027951,0.0,0.140600045,0.0,0.0,0.22533921399999998,0.0,0.0,0.0,0.0,0.0,0.0,2.3731665,0.0,1.2478535,0.0,0.0,0.36625145299999995,0.0,0.0,0.0,0.0,0.543609401,0.195225564,0.0,0.30467489600000003,0.0,0.0113236573,1.26191285,0.0,0.0,0.0,0.0,0.0,1.35754034,0.0,0.0,0.0,0.0,0.0,0.12456925099999999,0.7122537870000001,0.061464001500000004,0.275686859,0.159621132,1.08139303,0.0,0.9717362159999999,0.0,0.0,0.0,0.0,0.41343314200000003,0.0,0.0,0.0,0.422531449,1.40552423,0.587739069,0.0,0.33618986799999995,0.610206196,0.0,0.0,0.0,0.245453507,0.0,2.08824884,2.26376583,3.51942337,2.68945854,4.25486546,4.62681761,2.79995145,3.56614151,4.20542282,2.81649593,0.357876015,1.03387334,0.0,0.49264777200000004,0.0,0.0,0.0,1.41215823,0.0,0.338931078,1.52521012,0.47560807299999996,0.391010381,0.0,0.694124407,0.551230459,0.013200628700000001,0.0,0.0,0.0,1.51370368,0.23531402899999998,1.21502477,0.0,1.05224455,0.0,2.56524759,0.0,0.12724339099999998,0.433136058,0.765393742,0.0,0.00757251163,0.0,0.0,0.0,0.9360897420000001,0.0,0.0,0.0,0.0,0.0,0.537758595,0.0,0.258364589,1.02513845,0.0,0.0,0.0198311237,0.0,0.0,0.10073632699999999,0.131916163,0.0,1.49599367,0.79528317,0.0,0.8021393859999999,0.247553857,0.281707191,0.0,0.6893523029999999,0.0,1.06036209,0.0,1.99189424,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.570940575,0.0,0.0,1.38886349,0.598663054,1.77627222,0.713652372,1.12945875,1.51471647,1.01724495,1.25726215,1.81038496,1.23326562,0.0,0.933678308,0.593873801,2.30548497,1.20972814,1.08338215,1.01710063,0.0,0.552912844,0.568136461,0.0,0.0,0.8765364990000001,0.0,0.0,0.0,0.0130844181,0.0,0.0,0.0,0.632370902,0.0,0.0,0.0,0.0,0.48648873200000003,0.543373083,0.0,0.621367591,0.0,0.0,0.009199062740000001,0.929683705,0.5475625670000001,0.0,0.81815807,0.0,0.25561131,0.054891251399999993,1.05004105,0.2501551,0.7292027609999999,0.0,0.0,0.0,0.0,0.457394885,0.0,0.0,0.0,0.0,0.0,1.03789215,0.0,2.03035867,0.19593703399999998,2.22627399,1.35806085,1.2227315,1.58699547,2.41658778,3.07437781,3.23105802,1.38138033,3.23837627,2.85015853,2.50710797,2.63789578,3.51684885,3.86330709,3.73008768,4.04752877,4.02429228,2.42751046,1.7135241,1.07914136,1.21781075,1.15707291,0.535937943,1.63408769,0.42764008299999995,0.566218083,0.0,0.0,0.41339735299999997,0.0,0.0,0.0,0.0,0.0,0.008184557240000001,0.0,0.0,0.664094352,1.29892449,0.12239623,0.0,0.149736567,0.0,0.153171148,0.0,0.229595529,0.0,0.791526741,0.0,1.42006308,0.0,0.0,0.0,1.01512695,0.0,0.656884157,0.0,0.0,0.289568241,0.829417348,0.18725566600000002,0.0,0.0,0.326365312,0.901828098,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
6.04027947,6.21923431,6.79409895,6.70854457,5.75997811,6.30173114,5.99100048,5.11663205,4.46849975,3.65811273,3.80786826,2.5183584999999997,1.83005778,1.75103738,0.79496612,1.2093812,0.48387335,0.86626691,0.66585279,0.30251468,0.0,0.0,0.20434474,0.19467306,0.07209574,0.0,0.47497156,0.0,0.0,0.0,0.0,0.12889562,0.0,0.5602058000000001,0.36639072,0.0,0.0,0.60649952,0.0,0.0,0.0,0.22333667,0.56814463,0.09456953,0.21895576,0.0,0.48397192,0.46884472,0.94871231,0.69104992,0.8967700999999999,0.70537149,1.60498052,1.04108687,2.2464824,1.29822119,1.64838859,1.26883106,1.48299872,1.020226,1.81149932,1.30120271,0.8624366,0.71535945,0.65049926,0.0,0.13198557,0.0,0.0,0.0,0.05722914,0.42831333,0.23333456,0.54121868,0.0,0.34333782,0.87955346,0.96968572,0.33972203,0.83573533,0.35605583,0.77730212,0.7843101,0.59533147,0.0,0.44618517,0.13911089999999998,0.0,0.0,0.07742022,0.37376878,0.14432099,0.61652435,0.0,0.0,0.0,0.59549091,0.45224697,0.0,0.0,0.19136263,0.32288108,0.5327295,0.0,0.0,0.0,0.0,0.0,0.0,0.06133216,0.0,0.50980054,0.33704242,0.41401489,0.15342744,0.10701957,0.0,0.18996683,0.0,0.28409483,0.0,0.0,0.0,0.0,0.33951695,0.39274823,0.56991914,0.0,0.07995912,0.0,0.0,0.0,0.0,0.0,0.0,0.41296902,0.0,0.0,0.0,0.50991104,0.06489894,0.27144845,0.53196864,0.08122064,0.07271682,0.13165376,0.3077008,0.04181095,0.0,0.6030494000000001,0.0,0.1341505,0.20227143,0.19511132,0.55256874,0.25638404,0.0,0.35610178,0.14707779,0.44468279,0.0,0.0,0.0,0.0,0.71361638,0.0,0.0,0.34543355,0.02451832,0.0,0.04367842,0.0,0.2167357,0.0,0.11423705,0.0,0.0,0.0,0.59772636,0.19880413,0.40927784,0.13913431,0.0,0.55187907,0.62594784,0.0,0.13934905,0.0,0.0,0.0,0.0,0.28395495,0.3508216,0.0,0.46094808,0.53908492,0.0,0.0,0.31608026,0.80291913,0.127281,0.82489199,0.04095283,0.10395937,0.55747873,0.0,0.10478688,0.21836438,0.0,0.0,0.25795582,0.0,0.0,0.44902825,0.64718641,1.02216501,1.80357444,2.38200259,3.38861867,4.12820944,4.13843858,4.48581528,5.14869846,5.84103989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.10896969,0.011304713899999999,0.0,0.0,0.0,0.069370759,0.18930681300000002,0.32623948199999997,0.46021026600000003,0.571037395,0.641223675,0.658550175,0.6179648529999999,0.5224715289999999,0.38286687,0.216340855,0.044124849199999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.141829097,0.285677992,0.400510773,0.47028978200000005,0.486119993,0.44761076,0.362955908,0.247699439,0.122351356,0.009194677220000001,0.0,0.0,0.0,0.0,0.119244412,0.265254515,0.411753662,0.532826473,0.604819384,0.610195177,0.5406413179999999,0.398935425,0.199236985,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.111316309,0.45958109,0.79585141,1.07749542,1.26744535,1.33955852,1.28273183,1.10316315,0.8243848220000001,0.48498415899999997,0.134234199,0.0,0.0,0.0,0.0,0.0,0.322695252,0.884736394,1.53014338,2.19818863,2.82316487,3.34193736,3.70126392,3.86397586,3.81325514,3.55448477,3.11445643,2.5380537999999997,1.8828459,1.21228284,0.588352361,0.0646091919,0.0,0.0,0.0,0.0,0.0,0.0,0.23992332600000002,0.507450173,0.7125198359999999,0.8281349720000001,0.841848405,0.756469343,0.5887487570000001,0.36631608299999996,0.123358358,0.0,0.0,0.0,0.0,0.0,0.0,0.0333688914,0.291338883,0.561423653,0.8169154009999999,1.03542527,1.20145616,1.30780605,1.35567738,1.35356259,1.31515111,1.25663434,1.19385421,1.13974141,1.10242221,1.08425246,1.08188173,1.08728637,1.08956083,1.07714539,1.04011063,0.9721217679999999,0.871767885,0.7430498879999999,0.594960233,0.440233415,0.293477133,0.16898940199999998,0.0786126043,0.029965295899999998,0.0253288904,0.0613598467,0.12966587599999999,0.218147875,0.31288926699999997,0.400289816,0.469104785,0.51206782,0.526844223,0.516169286,0.48715704600000004,0.449897613,0.415575164,0.39441591600000003,0.393803577,0.416874395,0.461828642,0.522081825,0.587244612,0.644786373,0.6821244540000001,0.6888077690000001,0.658440989,0.590028833,0.488504269,0.36432754700000003,0.232186413,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
5.07207097,4.63036232,3.94556267,3.09162508,2.1578312000000004,1.23775151,0.417945306,0.0,0.0,0.0,0.0,0.0,0.0,0.0318517132,0.40087064,0.704564509,0.901415975,0.9702185190000001,0.9113040859999999,0.7445931159999999,0.504936297,0.235588171,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15383232,0.299603612,0.39027908,0.40912702700000003,0.352748059,0.231588823,0.0683081646,0.0,0.0,0.0,0.0,0.0,0.0,0.25903259300000003,0.636807446,1.05553975,1.4758841,1.85710673,2.16191004,2.36072413,2.43495223,2.37881507,2.19963171,1.91657519,1.55812407,1.15857485,0.754070725,0.378632865,0.0606519902,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05980411150000001,0.158352212,0.21885106399999998,0.235592644,0.21008411899999999,0.150232308,0.0686995083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0679706357,0.126190634,0.160444838,0.16505388,0.13966420599999999,0.0892800356,0.0233566242,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.024338350699999997,0.0791750837,0.11436867,0.123339945,0.105941564,0.06927356059999999,0.0271299477,0.0,0.00215017326,0.0573195037,0.17518877300000002,0.357795682,0.595485687,0.866607008,1.13925373,1.37499663,1.5342038999999998,1.58225481,1.49573931,1.26765759,0.910705822,0.457957534,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.212090295,1.07685766,2.04020652,3.01162818,3.89548503,4.6023459,5.05980827,5.22135868,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
0.00275595202,0.471853853,0.356938531,0.9573685890000001,0.926254823,0.99343424,1.40859443,1.40577496,1.49386749,1.51063116,1.27187123,0.809723247,0.22818727,0.0,0.0,0.026080617900000002,0.358563501,0.14935790699999998,0.6281131670000001,0.021751500299999997,0.0,0.0,0.0,0.0,0.0,0.757623807,1.34907372,2.19486045,2.25185333,2.43973936,2.24452758,1.65458016,1.21394874,1.04940287,0.76774609,0.65562278,0.36728468200000003,0.732839048,0.890055602,0.550769425,0.502866495,0.145335691,0.0,0.0,0.0,0.26083345199999997,0.120372591,0.62355617,0.7704945790000001,1.2484939,1.55344088,1.67371568,1.90537281,2.39041911,2.36998328,1.86391734,1.73432522,0.875295367,0.6057065770000001,0.848464252,0.85208001,1.72053203,2.36835787,2.9503917,3.43559497,3.20836355,2.61642991,1.51111565,0.645825351,0.411539197,0.00947100896,0.236505855,0.256750576,0.754723228,0.49991172100000003,0.678702296,0.443911063,0.369197305,0.0291723009,0.0,0.0,0.0261349627,0.0,0.472398665,0.0392089804,0.285299777,0.0,0.0,0.0542057229,0.034640255,0.0,0.262487032,0.134308233,0.0,0.150382605,0.21168307600000003,0.0212576402,0.0,0.0,0.0,0.0,0.124701539,0.368852193,0.0230166619,0.17342902600000001,0.0,0.0,0.0,0.0,0.243031522,0.0,0.0,0.0589780695,0.0,0.10804848,0.165687793,0.121900723,0.0950330509,0.33816572899999997,0.0,0.0,0.0470448431,0.0,0.0,0.0,0.0,0.297629353,0.34007644600000003,0.0,0.00257378405,0.200909901,0.128672691,0.0,0.282458745,0.0,0.135859061,0.255822485,0.0,0.286023965,0.0,0.0,0.14033477800000002,0.0,0.0538139712,0.14917365,0.156497116,0.0,0.0,0.16574129999999998,0.128439755,0.0,0.130603413,0.295198381,0.048597978099999994,0.175919092,0.0,0.0,0.19921360899999999,0.0,0.0,0.261963307,0.0,0.0,0.0,0.0384479493,0.0,0.0127384249,0.182629636,0.25895901,0.0,0.0,0.10009168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.0072503104,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.141362331,0.325327847,0.5344096420000001,0.760721,0.995037284,1.22720027,1.44658595,1.64261484,1.80528087,1.92567367,1.99646846,2.01235862,1.9704084,1.870306,1.71450206,1.50822315,1.25935608,0.978204253,0.677124012,0.370054094,0.0719571283,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.345979404,0.813283801,1.34047404,1.91234147,2.51152381,3.11915152,3.71556496,4.28107211,4.796715,5.24501206,5.61064475,5.88105908,6.04695633,6.10265203,6.04628807,5.87988933,5.60926273,5.24374399,4.79580343,4.28052875,3.71500761,3.11763738,2.50739199,1.90307782,1.32261033,0.782342078,0.296470044,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.061346189800000006,0.258452903,0.430437048,0.56928063,0.669195978,0.7267823859999999,0.741063575,0.713408165,0.647340823,0.548256809,0.42305688799999996,0.279722988,0.126857267,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00714507059,0.125458827,0.23348352,0.325513588,0.396869161,0.44412273799999996,0.465253515,0.459722853,0.428468635,0.373820556,0.299342506,0.209611927,0.10994915,0.00611211836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0759594987,0.162951223,0.239679378,0.301960391,0.346463095,0.37088327299999996,0.37406004200000004,0.356028324,0.318005176,0.26231133,0.192232793,0.111830579,0.0257093668,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0497106433,0.131341436,0.205398148,0.267706517,0.314755143,0.343890705,0.353465585,0.342929785,0.31286209600000003,0.264938754,0.201841274,0.127108456,0.044940618499999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.031242351800000002,0.118340139,0.19946660000000002,0.26996312100000003,0.325725654,0.363439367,0.380771765,0.37651321200000004,0.35065663700000005,0.304411389,0.240149791,0.16128859199999998,0.0721110995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0126816426,0.120561612,0.224392583,0.318381081,0.397215446,0.456382931,0.492450603,0.503293856,0.488258735,0.448247564,0.385721126,0.304615008,0.21017215,0.108698175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.0227477304,0.303733712,0.0,0.0,0.0,0.0,0.345479021,0.614733631,1.67914341,2.55947181,3.75899446,3.6947818,4.99218571,4.76276787,4.76426598,4.15064128,3.96829524,2.85186371,2.4769372000000005,1.05755016,0.678997867,0.395249925,0.431700388,0.00359693605,0.0,0.276126705,0.308072339,0.0,0.494739328,0.0,0.0,0.0,0.0,0.0,0.126881844,0.0,0.0,0.48503073700000005,0.570674156,0.0,0.534502798,0.176236437,0.0,0.043648958499999994,0.0,0.0,0.128568433,0.0,0.140529527,0.434192617,0.0,0.620544271,0.299216887,0.283882399,0.434247115,0.212878232,0.0,0.23113350100000002,0.0,0.183148002,0.254250702,0.172034338,0.0,0.39627942299999996,0.106749312,0.0666575435,0.410585396,0.0,0.0,0.0,0.0,0.0,0.0861781435,0.30734141800000003,0.0,0.0,0.48742960700000004,0.427243107,0.0,0.0,0.0,0.0195548833,0.0,0.0,0.0,0.0,0.241710813,0.509832341,0.8903731,0.32599373600000003,0.963357081,0.42233032600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.168390106,0.315290421,0.050860355999999995,0.0,0.0,0.641102986,0.781033372,0.278050161,0.342087651,1.67533451,3.03106823,2.68736415,0.88120837,0.0,0.0,0.300073,0.25569575699999997,0.0,0.0,0.149604189,0.197359106,0.0,0.0,0.0891641934,0.18476117600000003,0.0,0.0,0.0538290473,0.203331197,0.0,0.0,0.0229821327,0.289843903,0.0,0.0,0.0,1.1086802,1.8402213,1.30547786,0.16353210699999998,0.0,0.0,0.210807482,0.0824334473,0.0,0.0,0.107223994,0.06884259940000001,0.0,0.0,0.0684845021,0.0645573085,0.0,0.0,0.041399713399999996,0.0479547654,0.0,0.080051393,0.28048222899999997,0.267265987,0.0430379958,0.046574539500000005,0.458566391,0.831656455,0.731295143,0.360238306,0.157028623,0.124690366,0.0340701245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
2.95086938,2.4201632,2.50032189,2.05320282,1.48308491,1.63382127,1.99562865,2.27425479,2.23214988,2.90224171,3.26911725,3.53782423,4.38642482,4.10902387,3.64864601,2.61037612,1.80370395,1.49362794,0.8782410420000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.34764689299999996,0.427540284,0.47617043600000003,0.8631124509999999,0.565521199,0.0392382677,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.519108789,0.0944720852,0.614341495,0.30292732,0.303407501,0.0,0.0,0.042336600700000004,0.0,0.0,0.0,0.0,0.0,0.14736976599999999,0.0,0.22427502300000002,0.0,0.0,0.0,0.0,0.08546756949999999,0.0,0.0,0.0,0.0,0.0336609055,0.0,0.23448816,0.0,0.497686012,0.471389324,0.0,0.0,0.0,0.0,0.0,0.0,0.041591573199999995,0.19973869600000002,0.0,0.0,0.0,0.138327494,0.308262663,0.168238638,0.0,0.0,0.0,0.0,0.0,0.178596822,0.333190035,0.454333414,0.601592286,0.680241987,0.0386551111,0.429612328,0.291521984,0.0,0.0,0.0,0.0,0.21155202,0.284501816,0.6922858470000001,0.846966815,1.08019442,1.03526,1.77829282,1.20150278,1.39259484,1.73852782,1.64022702,1.15866153,0.76536656,0.69698723,0.96118227,0.7448542979999999,0.6265469229999999,0.323042189,0.568853501,0.352990268,0.332252865,0.291175941,0.818367238,0.599149806,0.8256886379999999,0.711754517,0.681126144,1.35007375,1.63721622,1.69765382,1.95353315,2.343322,2.07815841,2.38072656,1.36171191,1.45773458,1.06836144,0.488075498,0.019274195,0.0,0.6859055270000001,0.782274015,0.97911325,1.51402965,2.41199233,3.02005727,3.4280291,3.62682413,3.79957128,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
5.3428597,5.4168721,5.1805102,5.12397965,4.37957535,3.77576002,2.68389347,2.57192735,1.04335185,1.02036264,0.649190916,0.0,0.0,0.0,0.0,0.0,0.0,0.23859895899999997,0.12861105,0.025580898900000003,0.610347612,0.099378922,0.7548901259999999,0.295354245,0.113296942,0.5685815679999999,0.285113026,0.318686136,0.166454242,0.0,0.0,0.0,0.0,0.285560656,0.0,0.302877973,0.0,0.0,0.6851088129999999,0.0,0.576734548,0.33084515800000003,0.159029537,0.0,0.100436361,0.0,0.0,0.0,0.0,0.338917129,0.413512301,0.337946681,0.0,0.0470744537,0.52993692,0.44169337799999997,0.0,0.13417209900000002,0.10452189,0.012036048200000002,0.169841771,0.25471595,0.0,0.16898746399999998,0.0,0.36372601200000004,0.08471421800000001,0.0,0.28351239899999997,0.14267611300000002,0.0,0.0,0.0,0.0,0.637647978,0.0,0.452301778,0.20746567,0.0,0.0,0.0,0.0,0.457520541,0.0,0.0,0.0,0.0,0.0,0.0108497844,0.0,0.0,0.325930798,0.57265104,0.521834245,0.0,0.0,0.5737998320000001,0.504743342,0.153757859,0.0172027049,0.18551418100000003,0.0,0.0,0.0,0.0,0.343729161,0.0,0.141096308,0.430731366,0.0,0.205223077,0.037383980899999995,0.16552597300000002,0.643033316,0.0,0.51089815,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.043424906799999996,0.17544563300000002,0.0,0.0,0.10368423199999999,0.429750064,0.270593824,0.19336046699999998,0.251771605,0.226471957,0.0769625697,0.17346815,0.0,0.0,0.145794173,0.5119146210000001,0.365786224,0.0,0.0,0.0,0.504280838,0.141627634,0.623287409,0.8357852570000001,0.703065788,0.593459294,0.8684729440000001,0.0,0.13500308800000002,0.0,0.097268478,0.336292601,0.0947444898,0.00146898589,0.190053576,0.0,0.195815076,0.24601609300000002,0.370268928,0.227105219,0.0356558533,0.0,0.0,0.34040560700000005,0.0122017195,0.0,0.84271112,0.47817820899999997,0.588630543,0.708217505,0.9540486890000001,1.29436806,1.32847603,1.43095026,1.20745906,1.0764798,1.29592669,1.28126393,0.923972438,1.4491393,1.09080765,0.39504995200000004,0.437029155,0.44765973,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.267363372,0.0,0.21322638300000002,0.416919954,0.197252182,0.553361669,0.39826140200000004,0.7004554409999999,0.2192167,0.16539810900000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21579634,0.8076784990000001,0.966723992,1.84001825,2.60874287,3.87594817,4.89935636,4.73043485,5.49291773,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
1.7071642,1.47205441,0.493923312,0.0,0.0,0.0,2.09101241,5.00488348,6.76860582,6.37277869,4.04701045,1.09834537,0.0,0.0,0.0,0.421938804,0.8275909109999999,0.451338664,0.0,0.0,0.0,0.0999384113,0.380222492,0.28283229,0.0,0.0,0.0,0.0,0.174173603,0.162905914,0.0176085205,0.0,0.0,0.0,0.08088390919999999,0.11818054300000001,0.122429321,0.12932808699999998,0.12258099199999999,0.0533608761,0.0,0.0,0.0,0.131543875,0.311620618,0.228879878,0.0,0.0,0.0,0.234960335,1.45980081,2.62218627,3.15220421,2.86848572,2.08424016,1.33817025,0.9772175879999999,0.9377858590000001,0.8936427,0.617651761,0.22294941199999999,0.0656537745,0.399573854,1.09824512,1.7021351999999998,1.76255266,1.19365743,0.33753195700000005,0.0,0.0,0.0,0.125975637,0.22919392800000002,0.10845349300000001,0.0,0.0,0.15395568,0.325301142,0.335443422,0.176863335,0.0,0.0,0.0,4.07590512e-16,0.0373640103,0.0202905392,0.000243530935,0.0135189797,0.0340547951,0.012046518300000001,0.0,0.0,0.0,0.138056777,0.23671698100000002,0.184032707,0.017770928000000002,0.0,0.053511372800000005,0.42311892100000004,0.828416411,1.05094748,1.06446265,1.07764679,1.33986883,1.87466324,2.40145742,2.55313174,2.21579145,1.66998416,1.36257892,1.47859552,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
3.28852601,2.90654806,3.4617696000000002,2.50556131,3.57729875,3.37300965,3.40148217,3.47274979,3.24060786,2.08969763,2.3223138999999997,1.77564835,2.23202427,2.08602806,1.18435251,2.36646423,3.21236948,1.77897067,1.97143821,0.733966004,1.29450381,0.693623178,0.17418311600000003,1.0568205,1.6176328000000002,0.480844166,1.83809225,1.22449939,0.0,0.844986378,0.229213257,0.0,0.0,0.9672339459999999,0.0,0.0,0.987329383,0.0,0.378642365,0.0,0.195996804,0.569931329,0.0,0.0,0.0,0.0,0.0,0.303116451,0.565970501,0.5545816379999999,0.174693949,0.17002381,1.39204511,0.0,0.0,0.0035990836200000004,0.334706263,0.8186838740000001,0.0935455359,1.26733871,0.0,0.0,0.0,0.0,0.0015655873800000002,0.596029582,0.179651019,0.0,0.46954582799999994,0.274833271,0.0,0.06963570940000001,0.313568393,0.0,0.221117559,0.22015738399999998,0.33133097899999997,0.0,0.0,0.0,0.0,0.0,1.27808929,0.0,0.08288346519999999,0.0,0.0,0.0,0.0,0.627904782,0.0,0.829278078,0.0,0.0766802689,0.0,0.858560584,0.7146988129999999,0.0,0.19045984600000002,0.841526043,0.0152480136,0.0,0.0,0.0,0.248326325,0.394262929,0.0,0.09545881449999999,0.119284525,1.53705904,0.0,0.9221037259999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32871886699999997,0.0,0.0,0.322106853,0.0,0.0,1.01206784,0.0,1.34907791,0.12508350099999999,1.2592645,1.41205734,1.04317815,0.0,0.0,0.7856776240000001,0.0,1.01611899,0.0,0.8608291309999999,0.0,0.984878204,0.0,0.05079466059999999,0.0,0.0,0.0325937004,0.0,0.335700082,0.0190602925,0.36696101,0.0,0.0,1.43000768,0.024248117599999997,0.0,0.0,0.0,0.0,0.7169271340000001,0.0,0.0,0.38979764200000006,0.648253095,0.0,0.0,0.0,0.0,0.0,1.4343311,0.82112889,0.37853433,0.925250593,0.0,0.0,1.06256853,0.0,0.112633938,0.223887499,1.13463628,0.232172535,0.0,0.0,0.0,0.0339547509,0.0281739014,0.0,0.494460019,0.0,0.0,0.0,0.0,0.271266745,5.31013024e-05,0.0,0.936097033,0.0,0.0,0.228745032,0.0,0.22046278800000002,0.236371462,0.0,0.391171373,0.0,0.849770252,0.161145699,0.670849705,0.0,1.08540325,0.630819548,0.73891621,1.27195122,0.694623012,1.62731099,1.38041267,2.43742024,3.29496754,1.64868758,2.53886043,2.1120427000000004,2.71942559,3.03995243,3.35992391,2.90789201,0.315369981,4.3659587,2.43224595,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.6816300340000001,0.7884124690000001,0.330003552,0.0945881246,0.0,0.0731863681,0.0,0.0,0.16075673599999998,0.501368048,0.128283106,0.0,0.0,0.166670183,0.0,0.0,0.0,0.305370446,0.46790136200000004,0.25456782699999997,0.0702657052,0.0,0.11064715300000001,0.0,0.29622698199999997,0.20031358,0.253877949,0.481241318,0.372078773,0.0,0.33231494699999997,0.0658181056,0.0,0.289610585,0.0,0.0111366372,0.302913105,0.286672074,0.0,0.0,0.41205462600000003,0.48099416100000003,0.29286789,0.594057291,0.346751214,0.132332474,0.0,0.0,0.0,0.187943865,0.434260391,0.40912988200000006,0.329286391,0.0331896272,0.191328308,0.0,0.0,0.0,0.132495621,0.40918840799999995,0.607639787,0.43077236700000004,0.55845128,0.09946121210000002,0.0,0.0,0.0,0.0375608098,0.838440567,1.96242507,2.80055575,3.17811298,3.22283585,2.70086735,2.12241116,0.9733040079999999,0.23257703,0.0,0.0,0.0,0.249826012,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.045563239900000004,0.0,0.0431073224,0.0,0.0459448369,0.0,0.0,0.021412654,0.0,0.0343627694,0.0,0.0115839372,0.0,0.0,0.0,0.0481339368,0.0,0.174302453,1.26058297,0.32447783399999997,0.0,0.392137605,0.0,0.23460489399999998,0.0,0.267487713,6.90328688,8.753041699999999,2.68495393,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
0.73347133,1.44323028,3.73376277,1.96315522,2.68445284,0.68235056,2.21166052,0.0,6.58965113,11.12013677,0.0,0.472728,0.0,0.64068321,0.0,0.90603674,0.0,0.92600588,0.0,0.32280501,0.41287206,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
2.15869469,0.77141562,0.0,1.34144175,0.0,0.0,0.0,2.54953786,0.41259051,0.36718888,0.0,1.23821997,1.9871108,0.0,0.0,0.08476795,0.80705645,0.59219355,0.0,0.0,1.23441414,0.05656284,0.0,0.0,0.70590819,0.0,0.0,0.0,0.0,1.09988271,0.0,0.43078317,0.0,0.54759471,1.25963232,0.87921493,0.80336476,5.01560848,4.54489317,2.98451476,0.78424664,0.0,1.23522804,1.60456338,1.32682283,2.10049572,0.51981961,0.44622525,0.0,0.74714318,0.4728528,0.0,0.74114829,1.29788706,0.0,0.3136231,0.0,0.52318748,0.0,1.53232564,0.0,1.20702198,0.0,0.0,0.0,0.0,1.10467959,0.0,0.91644392,0.0,0.66084689,0.12606079,0.74934264,0.0,0.0,0.0,0.61381735,0.0,0.0,1.10736601,0.0,0.41716651,0.42284405,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.0791231686,1.72435496,0.0,1.07683158,0.221978387,0.9157793320000001,0.7800926659999999,0.40052607700000004,0.82725304,0.0,0.0,0.0,0.0,0.0,0.0,0.0521601308,0.10198536,0.0141467227,0.0,0.6294992979999999,0.0,0.5543436070000001,0.104364568,0.0710106075,0.733295878,0.0,0.541457104,0.0,0.0,0.0636186218,0.0,0.0634405378,0.0,0.620691262,0.672122164,0.0,0.33783055700000003,0.39399014,0.0,0.0,0.787233299,0.136893535,0.48967316899999996,0.0,0.0,0.0,0.321686009,0.9747157479999999,0.746018469,0.245751912,0.0,0.0,1.28363755,2.71555245,2.65695374,1.75907801,0.9294285459999999,0.0,0.00188694366,2.92059675,6.93691065,8.52891357,8.12233073,5.03940626,2.01992121,0.73143024,0.0,1.00291782,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.43726371,0.865805543,1.00789255,0.592403665,0.593526526,0.27835376100000003,0.725734928,0.150857927,0.0,0.0,0.0,0.057476209800000004,0.0,0.0,0.328725974,0.0326839391,0.0,0.0,0.0,0.17234527100000002,0.0,0.0,0.0967929634,0.40001450200000005,0.0,0.0,0.0769826738,0.0,0.0,0.00517459386,0.41039066,0.0,0.14786087,0.9529178420000001,0.971252439,0.715647845,0.993714742,1.19851059,0.962432415,0.336510856,0.238792246,0.0,0.39078310200000005,0.46547376,0.13793260699999998,0.317988809,1.22971601,2.15634976,2.03345592,3.25133359,3.42775191,4.40492148,4.60224409,5.5078239,4.89277199,5.54992667,5.36017436,4.73523005,4.52736554,4.19264842,3.51385475,2.77551826,1.27264322,1.2244568999999998,0.913564292,0.142493614,0.131037489,0.035852479300000004,0.0,0.302638631,0.5481433929999999,0.0,0.719774308,0.150021131,0.513591734,0.612429462,0.25241271,0.07466484849999999,0.462230362,0.656071551,0.367073173,0.0747438938,0.452628089,0.0,0.0,0.358889175,0.603630928,0.356426412,0.0145365827,0.0,0.0,0.0,0.0,0.0,0.0,0.234245494,0.0,0.30032316,0.216624542,0.06318877490000001,0.0,0.45754435299999996,0.0,0.0,0.0740881048,0.516435025,0.310226614,0.48755957,0.0,0.41443115,0.351080736,0.0,0.0,0.318265413,0.0472928712,0.143490162,0.0,0.0,0.18843575399999998,0.0,0.31335496399999996,0.24704033600000003,0.0,0.0,0.0,0.0,0.174070127,0.034646717599999995,0.10372626800000001,0.34534120100000004,0.0,0.37181344200000005,0.0,0.9704938240000001,1.06425609,0.7119355959999999,1.02002503,1.32698258,1.16848091,1.35724966,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
0.216817688,0.0610456162,0.0,0.302053939,0.791727678,0.13649646599999998,1.49034897,0.7994552070000001,0.119314546,0.0,0.39005455,0.0,0.39625901799999996,0.0,0.0,0.0,0.940598248,0.00977632864,0.214566197,0.0,0.615851951,0.47658614,1.22723812,1.22723036,0.3876368,0.309996335,0.666881518,0.0,1.39050709,0.330789173,0.0,0.0,0.067046749,0.0,0.0151297882,0.0,0.0,0.0,0.973432223,1.01868096,0.242362656,1.41440024,0.0,0.0,0.486806358,0.0,0.0,0.24744918100000002,0.19597478100000001,0.0,0.749268149,0.0,0.0,0.0,0.17903614399999998,0.0,0.0,0.0,0.0,0.0,0.0,1.79179266,0.37392954899999997,0.604488072,0.0,0.0,0.0,0.534062568,1.7486418000000001,0.8138865409999999,0.35617953399999996,0.30252086699999997,0.514391064,0.126389742,0.0,0.46475953299999995,0.0,0.0,0.0,0.0,0.228232462,0.0,0.0,0.0286498579,0.351957111,0.9834802640000001,1.66648703,0.0,1.19495904,1.09912841,0.8532464479999999,3.3543781000000004,2.61914616,2.42025226,1.79065768,4.03963375,1.94680506,3.44512787,2.88745838,4.09253846,3.02907876,2.81873833,3.5437396,1.59365994,1.92919945,2.13569002,0.747664879,0.0,0.0,0.212344758,0.0,0.0,0.0,0.0,0.0,0.752607448,0.0,0.170543107,0.0,0.269638121,0.0,1.38986385,0.558973315,0.0,0.661658913,1.39932549,0.6716599259999999,1.00697141,0.477027039,1.14406772,0.568184048,0.98450475,0.9262904909999999,0.0,0.0,0.535401072,0.0,0.0,0.0,0.0,0.0,0.12512400099999998,0.379901499,0.163309784,0.0,0.0,0.313054542,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.771130034,0.991891359,0.38339968399999996,0.26514131399999996,0.0,0.0814621463,0.40046491100000003,0.0,0.661727473,0.0,0.0,0.18790310100000002,0.5654790479999999,0.0,0.0,0.0,0.0,0.336380749,0.495531065,0.009025701629999999,0.0,0.84072719,0.348357542,0.0,0.359067937,0.0,0.0,0.0749954774,0.0,0.0450889805,0.119294347,0.36848825399999996,1.15408582,0.264800574,0.73682259,0.5662979020000001,0.2060149,0.0,0.0,0.0168373562,0.7069713120000001,0.610456098,0.732337872,0.0,0.0,0.0251489025,0.540172792,2.11200039,3.71385596,4.64218909,6.42977799,6.82955702,5.90897296,6.01157128,4.23455823,2.10227541,1.52661359,0.0,0.21878000600000003,0.469830211,0.0,0.593553565,0.23448356899999998,0.40392914,0.0,0.0,0.665711834,0.0,0.532018785,0.637872373,0.0612113755,0.472542499,0.0,0.0,0.244043659,0.0,0.692289519,0.689676692,0.0,0.35591295700000003,0.0,0.19877774899999998,0.34206700700000003,0.763778147,0.0,0.187449196,0.0,0.0,0.07217186490000001,0.267504829,0.905396495,0.050948194599999996,0.42511724700000003,0.132683679,0.0,0.0,0.0,0.48741023899999997,1.79308194,2.13179291,2.055891,1.16964215,1.68628352,0.270704417,0.0,0.0,0.44677489200000003,0.862315602,0.660993598,0.311303057,1.19282856,0.579219656,0.5379119920000001,0.0,0.0,0.0592637779,0.0,0.0,0.45995284299999994,0.614171539,0.0,0.416515835,0.0,0.5692697870000001,0.0,0.0,0.0,0.661206617,0.6714284620000001,0.0,0.400508034,1.02291103,1.05376634,0.678729438,0.0,0.329767465,0.4364089,0.583599243,0.0,0.45926093799999995,0.735049115,0.0,0.587441255,0.383143836,0.0,0.115858711,0.371901452,0.284052485,0.0,0.538384383,0.630200796,0.703416774,1.07925522,0.671673427,0.06708729,0.557797639,0.517819475,0.0,0.0,0.82133023,1.01043661,1.01798127,1.88712053,0.68825172,0.686621239,0.652279604,0.0,0.559396336,0.0,0.024356317000000002,0.0,0.607276884,0.08977678130000001,0.0,0.711556877,0.0,0.241466405,0.0,0.16481177800000002,0.7180289040000001,0.840404473,0.0,0.0,0.0,0.0,0.265739873,0.0,0.721874938,0.0,0.34956576799999994,0.489963983,0.40827974100000003,0.0,0.0,0.0,0.0158317469,0.0,0.0,0.0007784776299999999,0.314966339,0.0,0.0,0.75984971,0.11075709199999999,0.160243147,0.0,0.378412376,0.0,0.0,0.0,0.0,0.257433559,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.302935874,0.14992553,0.0,0.0,0.0,0.0,0.0,0.0,0.11356199800000001,0.31294227399999996,0.501798974,0.64387038,0.707140543,0.669703544,0.524616195,0.282914015,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32779019600000003,1.17533059,2.18204286,3.27376025,4.36090084,5.34791472,6.14383047,6.67259453,6.88189741,6.74935676,6.28525723,5.5314856,4.55678914,3.44895688,2.30491474,1.21998245,0.277629122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0455692108,0.371123408,0.60083786,0.712306388,0.702761456,0.5872910020000001,0.39479727700000006,0.162425987,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.074500623,0.201112455,0.28439838100000003,0.315629899,0.295012062,0.230838071,0.137443448,0.0323803332,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.049806758799999996,0.0912076642,0.11179403199999999,0.11121636,0.0929276718,0.0631093351,0.0291904916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000745741398,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0168662803,0.0586854181,0.09854098130000001,0.127787191,0.138563829,0.12551203,0.08718090810000001,0.0268253759,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00130931842,0.138946634,0.27998140000000005,0.40406906600000003,0.491996459,0.528951761,0.50730469,0.428392015,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.18693408,0.0,0.02638216,0.16045003,0.25058026,0.32606149,0.39418378,0.37484006,0.18409788,0.0,0.0,0.0,0.08950148,0.48665569,0.51086038,0.0,0.0,0.0,0.0,1.54208479,3.77568255,5.31334453,5.30420816,3.69696738,1.30687696,0.0,0.0,0.0,0.21015727,0.9021046999999999,0.75069028,0.0,0.0,0.0,0.0,0.5226688,0.70804758,0.26538249999999997,0.0,0.0,0.67542671,2.61142351,4.64719514,5.85212486,5.71209701,4.39837835,2.59702192,1.05724923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.19192865899999997,0.0896784823,0.0319058991,0.015767771,0.0245826341,0.037621508,0.0397339483,0.026654828199999998,0.00433934408,0.0,0.0,0.0,0.0,0.0026567198300000002,0.0105508073,0.0105967371,0.00558637943,0.000804995492,0.000252306335,0.003967363789999999,0.008069548559999999,0.0074789285,0.0,0.0,0.0,0.0,0.0,0.0106458042,0.0334841698,0.044189570899999996,0.034547794300000004,0.0056367844400000006,0.0,0.0,0.0,0.0,0.0127545107,0.060047536299999996,0.08424661619999999,0.0708126542,0.021883347200000004,0.0,0.0,0.0,0.0,0.00512327636,0.0833482297,0.129478126,0.11865757,0.050829926100000006,0.0,0.0,0.0,0.0,0.0,0.103260417,0.18296881199999998,0.183368275,0.097629345,0.0,0.0,0.0,0.0,0.0,0.11953426,0.25148031600000004,0.276602191,0.173771273,0.0,0.0,0.0,0.0,0.0,0.130797037,0.34925120600000004,0.42351090799999996,0.30435801100000004,0.029940134,0.0,0.0,0.0,0.0,0.297325267,0.726643728,0.927192241,0.768157753,0.26921597,0.0,0.0,0.0,0.0,1.52352575,3.55378485,5.61043445,7.15011757,7.72723165,7.15028803,5.56410023,3.42532699,1.37500212,0.047451780199999995,0.0,0.968595923,3.0646221000000002,5.63131891,8.01899749,9.65109204,10.1784198,9.55383055,8.01127779,5.96575022,3.8744771,2.10772844,0.868133395,0.17586441100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0665500912,0.108389424,0.10050970599999999,0.0462053263,0.0,0.0,0.0,0.0,0.0,0.0413557771,0.06667656429999999,0.054988540700000005,0.0216372456,0.0,0.015672226,0.0917805552,0.218293967,0.364220606,0.487172582,0.549955827,0.5348164870000001,0.44942992200000004,0.32257099699999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
1.43184032,0.0,1.33085465,0.16792361,0.71106973,1.77114211,1.56671337,0.73562299,1.62069074,4.12987451,1.42525646,1.1930956,0.0,0.99611145,0.0,0.98199984,0.85032331,0.0,0.0,0.0,0.0,0.53883063,1.41013221,0.84547394,0.71135208,0.0,1.05458086,0.0,0.0,0.08591664,1.11353117,1.0575895,0.43814851,1.05274077,0.92343845,1.54961703,2.44423416,2.94370877,0.98353214,0.5820403000000001,0.0,0.0,0.0,1.01228198,0.8802059000000001,1.2122175,0.0,0.0,0.0,1.59576665,0.0,0.0,1.73937735,0.48609275,0.0,0.11368869999999999,0.30545521,0.0,0.92850603,0.97310217,0.35544352,0.39846165,0.41906563,0.1977472,0.35458613,0.95039833,2.25413525,2.19319096,2.89680489,2.87702621,3.24024026,4.08959252,6.22491428,4.58365521,3.15174917,0.80943414,1.06526383,0.0,1.12277703,1.07875799,0.0,0.0,0.0,1.68381989,0.55102621,0.51526731,0.0,0.0,0.0,0.0667457,0.0,0.39043484,0.10300260000000001,1.36211329,0.42818038,0.0,0.61390013,1.07989236,0.0,0.93084247,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
0.940793304,1.56691154,1.50576623,1.75350191,1.75229251,1.88174271,1.69640718,1.25262321,0.967906698,1.08456429,0.7465969179999999,1.22885368,1.37892978,1.56254516,1.8433363999999999,2.30346473,2.6177444,3.19223192,3.17067727,3.02496682,2.8141418,2.95741464,2.31412387,2.01157711,1.71807328,2.21251509,1.95627245,1.85862324,1.94382618,2.56103842,2.35337317,2.36302675,2.34200889,2.07067881,1.55228401,1.16414156,0.6301429789999999,0.577036641,0.597737098,0.75711117,0.8171993590000001,0.895991557,0.630147577,0.670847416,1.09828861,0.894291196,0.531047095,0.748439175,0.47283773,0.518604538,0.331694301,0.374196938,0.27768738,0.0,0.0791529917,0.15568795,0.231887654,0.0,0.0,0.325697177,0.0,0.40117655399999996,0.153996823,0.7673349559999999,0.456238107,0.492269045,0.11205445,0.156871578,0.0674612684,0.053895846399999996,0.111708062,0.0,0.11945794300000001,0.0,0.0,0.0,0.0,0.265825555,0.016517110800000002,0.0,0.0,0.0,0.19345197,0.0,0.0,0.268049221,0.0,0.0,0.182687921,0.0,0.3441862,0.0,0.0,0.0523660699,0.0,0.0651557889,0.047357567,0.006550154420000001,0.0,0.170733508,0.307879048,0.0,0.0,0.123011275,0.0645611648,0.0,0.09527169939999999,0.0,0.0,0.0183246629,0.316641666,0.0,0.203833624,0.110022786,0.0,0.0,0.10154572,0.0,0.142748424,0.0,0.280277854,0.31656338100000003,0.0939234099,0.24787065100000003,0.0,0.210432528,0.38594331,0.755044245,0.646881839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.129823123,0.0,0.159511876,0.0,0.111167961,0.0,2.85883758,1.03864988,0.0,0.151284858,0.0,0.0139848852,0.563168471,1.21920729,0.261039756,1.5128551000000001,1.26023612,1.46093834,0.8773996340000001,5.06698869,2.56356641,1.6307878,1.20661631,0.7470967040000001,0.0,2.62629619,1.4362223,0.7053430629999999,0.926626427,0.0,0.29978802,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38299999999999995
0.11686259199999999,0.122728224,0.0133070072,0.0,0.0,0.0148359908,0.101163099,0.0801011398,0.0,0.0,0.0,0.024250158100000002,0.08693655310000001,0.0586430559,0.0,0.0,0.0,0.0336201343,0.0878532619,0.0522024734,0.0,0.0,0.0,0.0844635266,0.257505166,0.352331897,0.31997312,0.190371601,0.0433360109,0.0,0.0,0.0,0.0276827773,0.0358221302,0.0089696331,0.0,0.0,0.0,0.023641875,0.0294165056,0.00432840745,0.0,0.0,0.0,0.0340174314,0.0383587087,0.0,0.0,0.0,0.0051521805799999995,0.0966072407,0.164055789,0.17189183,0.133177181,0.08979697460000001,0.0683718655,0.0581758707,0.0326585612,0.0,0.0,0.0,0.016557081499999998,0.0531178877,0.0356524302,0.0,0.0,0.0,0.0337538697,0.0799425557,0.0436013004,0.0,0.0,0.0,0.0647182607,0.125661941,0.0663017497,0.0,0.0,0.060274720700000006,0.25679255,0.294399431,0.0766039422,0.0,0.0,0.930391733,2.62180231,4.45727265,5.61784536,5.56037719,4.35846288,2.63262914,1.13341627,0.29500517,0.0707566618,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.042845146900000006,0.0,0.0,0.011521676100000001,0.10624434599999999,0.0959012984,0.0,0.0,0.0,0.0614753339,0.19657731399999998,0.12644761,0.0,0.0,0.0,0.158292224,0.314925251,0.13293036800000002,0.0,0.0,0.0,0.339522204,0.492237692,0.09691813070000001,0.0,0.0,0.0,0.7578963240000001,0.8676858479999999,0.0,0.0,0.0,1.26450662,5.27069366,8.83460919,9.86171035,7.76997821,3.90874085,0.5181809629999999,0.0,0.0,0.549022896,0.886467022,0.34153893,0.0,0.0,0.0,0.34337924299999995,0.44844857200000005,0.0962207171,0.0,0.0,0.0,0.252028032,0.24909251899999998,2.6704656000000005e-16,0.0,0.0,0.0230040002,0.171949115,0.12695935,0.0,0.0,0.0,0.0359645981,0.0916019649,0.045949726100000005,0.0,0.0,0.0,0.010620613400000001,0.00409886216,0.0,0.0185073272,0.046625330199999995,0.019013553,0.0,0.0,0.0,0.13996809699999999,0.19861767100000002,0.0155100724,0.0,0.0,0.035826280099999996,0.9006978609999999,1.74516848,2.03852784,1.60277618,0.7549638740000001,0.0425482117,0.0,0.0,0.199726829,0.219208359,0.0703899712,0.0,0.079908946,0.30011059,0.427196124,0.340573689,0.114321666,0.0,0.0,0.0,0.08778593650000001,0.161815638,0.19373002600000003,0.19181608,0.142488858,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.19497165,0.27720076,0.34632768,0.39546913,0.41938152,0.41488695,0.38116207,0.31985788,0.23502971,0.13287124,0.02126225,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07606408,0.19355406,0.29607037,0.37339928,0.41732737,0.42251571,0.38715684,0.31334247,0.20709219,0.07802115,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22980376,0.48848635,0.7531277,1.00190354,1.2126382,1.36472559,1.44104499,1.42970885,1.32548578,1.13076152,0.85593252,0.51916909,0.14553397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.13639471,0.83507103,1.64384596,2.52534825,3.43569354,4.3272155,5.1515334,5.86273787,6.42046395,6.79262635,6.95761468,6.90578492,6.64013536,6.17611527,5.5405793,4.76996424,3.90782224,3.00189217,2.10092366,1.25148502,0.49498501,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.037832300000000006,0.42141852,0.7784079,1.07984844,1.30328273,1.43403982,1.46587299,1.40092275,1.24903782,1.02653536,0.75452253,0.45693097,0.15843168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17870242,0.34853062,0.48239461,0.56909047,0.60184366,0.57869756,0.50250437,0.38053895,0.22378520000000005,0.045967400000000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14217831,0.41226908,0.69318851,0.97145041,1.2340591,1.46920508,1.66684104,1.81911585,1.92065658,1.96869916,1.96307731,1.90608629,1.80224152,1.65795447,1.48114772,1.2808296000000001,1.06664677,0.84843063,0.6357514,0.43749282,0.26145963,0.11403046,0.0,0.0,0.0,0.0,0.0,0.0,0.0237434,0.10763984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.55315749,0.0,0.0,0.0,1.53212949,0.0,0.55703707,0.0,0.0,0.04317454,0.83695718,0.0,0.0,0.8820904,0.0,0.0,0.54999529,0.85550359,0.0,0.05256461,0.42644528,1.96185535,0.0,0.09800471,0.0,0.37616914,0.19021921,0.0,1.10495222,1.12118706,2.57368039,3.87820976,0.13606463,1.4997878,3.43285036,5.51145987,6.8451961,3.44361437,5.86076926,2.6936299999999997,0.49038273,0.0,1.14538784,0.57407233,0.14206801,0.0,0.15509694,1.00439976,0.0,0.12145843,0.58583941,0.0,0.06104812,0.0,1.48070721,0.0,0.0,0.0,0.39993119,3.15866844,4.30557784,5.38535552,5.79120534,2.3905621,0.0,0.0,0.0,1.58525097,1.62839887,0.63924449,0.30754223,0.0,0.78460633,1.06896743,0.68423881,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.992716348,1.83324997,0.32053062600000004,0.540433079,0.8571264000000001,0.245355378,0.0,0.8017299509999999,0.40059577399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.811877365,0.38413904299999996,0.0,0.32126910399999997,1.79325698,0.0,0.40078207899999996,0.0,0.326205993,1.11642646,0.35776315200000003,0.158926674,0.0,0.85723426,0.0,0.248208144,0.34854005,1.16771331,0.0,0.0,0.0,0.0,0.0,1.52728516,0.0,0.603036495,0.111369484,1.868369,0.0,1.33376377,0.0,0.0,1.49010981,0.0,0.0,0.11241369,0.219132054,1.01091365,0.0,0.0,0.0,0.751111017,0.0,0.431586322,1.02573613,0.525223648,0.56673063,0.0,0.8690257990000001,0.489979392,0.9061038240000001,0.0,0.41975378799999996,0.0,2.43058974,0.834943807,0.594634715,0.569021046,2.61827497,3.74745408,4.92971421,4.15561624,2.15536766,1.94621899,2.35098233,3.05947361,3.10951185,3.13833435,2.6332406,0.66484171,2.03093384,0.0,0.6971024020000001,0.463415156,0.0,0.0744872863,1.32764327,0.320881327,1.87654911,0.0,0.403122954,0.0,1.28812672,0.0,0.995651118,0.147258738,0.0,0.0,0.0,0.07121444440000001,0.141608335,0.351164889,0.0,0.0,0.0,0.0,1.96727334,0.0,0.0,1.19206708,1.37598751,0.0,0.0,0.527180977,0.0278615909,2.27777192,0.320049332,2.02273054,0.0,1.14383996,0.6952073440000001,1.05051006,0.0,0.0229593869,0.0,0.899842655,0.0,0.0,0.0,0.0,0.0,0.8115000440000001,0.0,0.175154485,0.45132541,0.0,0.18365837,0.642475615,0.0,0.0,0.0629925969,1.04343999,2.0788881,0.0,1.34066206,1.41182373,2.13789284,0.8597496590000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.257207262,0.0,0.0,0.000419597603,0.256453349,0.375888364,0.31119082,0.11654423300000001,0.0,0.0,0.0,0.0,0.0343412461,0.154635041,0.184936045,0.121058055,0.00451653909,0.0,0.0,0.0,0.0,0.0643998236,0.118370764,0.108975653,0.0458113859,0.0,0.0,0.0,0.0,0.0131835531,0.0720270929,0.0911052532,0.0630991966,0.00470963784,0.0,0.0,0.0,0.0,0.0360076538,0.07028572849999999,0.0673579949,0.030271846800000002,0.0,0.0,0.0,0.0,0.007094610240000001,0.0479002254,0.0628545156,0.045186362699999996,0.0049800714,0.0,0.0,0.0,0.0,0.0252139512,0.051715818,0.0509307277,0.024080826899999998,0.0,0.0,0.0,0.0,0.00404707187,0.0354414478,0.0475004267,0.0348058417,0.00494423789,0.0,0.0,0.0,0.0,0.0160746327,0.033165195099999996,0.0316969391,0.014626829899999999,0.0,0.0,0.0,0.0,0.000445648424,7.093087429999999e-06,0.0,0.0,0.0,0.0431435244,0.12870622199999998,0.231486384,0.321122603,0.373203112,0.387963221,0.399557189,0.46775709299999996,0.651765288,0.9755236159999999,1.40073096,1.82370827,2.10406633,2.11943727,1.82698396,1.3054016000000002,0.754889867,0.44692438700000003,0.635621129,1.46005664,2.87430701,4.63509887,6.35745603,7.62362554,8.10966929,7.68596456,6.45615847,4.72101797,2.88074252,1.31113957,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.0624393321,0.103501359,0.123511168,0.112596667,0.0736147017,0.0217824654,0.0,0.0,0.00952274279,0.0973515393,0.220516081,0.353172535,0.46459949100000003,0.528337276,0.530560147,0.47502667299999995,0.382903404,0.287320922,0.22420369399999998,0.222121834,0.294184579,0.434220967,0.617991716,0.8085805690000001,0.964086545,1.04564788,1.02454536,0.888084628,0.644433876,0.32617413300000003,0.0,0.0,0.0,0.0,0.08334632019999999,0.7227573190000001,1.53957356,2.39001908,3.09742995,3.49772129,3.48889332,3.06766775,2.33815354,1.48569986,0.721439045,0.21493459199999998,0.0388203593,0.14697681099999998,0.39657256700000004,0.607871855,0.640306194,0.45534169399999996,0.140022543,0.0,0.0,0.306298351,1.16130019,2.30908179,3.48592377,4.38842883,4.776195599999999,4.55549707,3.8122129,2.78128737,1.76418363,1.0255809,0.708030935,0.7955299640000001,1.13722358,1.51882171,1.7513129,1.74131898,1.51665667,1.20013799,0.9460267720000001,0.86802772,0.9895407270000001,1.23593722,1.46994185,1.55298659,1.40527212,1.03911644,0.5526532470000001,0.0882733216,0.0,0.0,0.0,0.0,0.206030419,0.317707058,0.29112097,0.152104756,0.0,0.0,0.0,0.0,0.0,0.0864528327,0.15324859,0.142042749,0.067033936,0.0,0.0,0.0,0.0,0.0,0.0573514242,0.08710501820000001,0.0725557546,0.0272719663,0.0,0.0,0.0,0.0,0.0011260186300000002,0.0120460719,0.0027095405699999998,0.0,0.0,0.034500152400000005,0.13041541,0.260629812,0.38804479700000005,0.46851012799999997,0.469228792,0.38351914299999995,0.235088071,0.0696050143,0.0,0.0,0.0,0.0,0.028848618599999997,0.0861481651,0.0970770143,0.062325900700000006,0.00321442349,0.0,0.0,0.0,0.0,0.0215790668,0.04662365809999999,0.0441619709,0.021337440899999997,0.0,0.0,0.0339722057,0.103947209,0.188636232,0.260170151,0.2937985,0.278482694,0.221569958,0.14561132699999998,0.07888106190000001,0.0438286861,0.04841334480000001,0.0838206491,0.129192012,0.16102223699999998,0.16307538900000002,0.132713344,0.081271328,0.0286975917,0.0,0.0,0.018724644,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
1.68831046,0.8047365329999999,0.491333752,1.03774575,2.07521441,2.86486653,2.85250265,2.06690408,1.07976957,0.5827455260000001,0.906496509,1.82093686,2.730845,3.09980841,2.79698466,2.14238211,1.64784009,1.65168233,2.09749026,2.59284661,2.69045168,2.19161027,1.26929937,0.339545562,0.0,0.0,0.0,0.17980468600000002,0.20386417699999998,0.0410891644,0.0,0.0,0.0,0.10723022800000001,0.136301653,0.0342547135,0.0,0.0,0.0,0.0836188165,0.115203291,0.0340745594,0.0,0.0,0.0,0.0733592287,0.108253549,0.0365311531,0.0,0.0,0.0,0.0682819711,0.107553861,0.0406099998,0.0,0.0,0.0,0.0656784994,0.11039648099999999,0.045988153399999995,0.0,0.0,0.0,0.0641116789,0.11494804900000001,0.052130273,0.0,0.0,0.0,0.060452050199999996,0.113016172,0.0527834021,0.0,0.0,0.0412503443,0.193706629,0.23810708100000003,0.110164552,0.0,0.0,0.0,0.0898469935,0.20231151,0.11584331699999999,0.0,0.0,0.0,0.0954084741,0.238479775,0.148016748,0.0,0.0,0.0,0.110448983,0.308091755,0.206456644,0.0,0.0,0.0,0.140739536,0.446738511,0.325658685,0.0,0.0,0.0,0.215117843,0.8122880379999999,0.6678821770000001,0.0,0.0,0.0,0.652656886,3.77880976,6.54046038,7.32276972,5.61985447,2.41677111,0.0,0.0,0.0,0.238485019,1.04126647,0.758001134,0.0,0.0,0.0,0.109676623,0.655885089,0.538138416,0.0,0.0,0.0,0.0669419672,0.577548698,0.5244352489999999,0.0,0.0,0.0,0.0515635179,0.859414688,1.18496983,0.819099756,0.17033656,0.0,0.46063416,1.50820224,2.3534435,2.4085965,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
3.18979359,6.07854849,7.29353916,7.55374592,9.13910028,4.80934279,4.23214473,0.0,2.35235725,0.0,2.83860116,3.92097419,4.56469455,3.9061282,3.77695616,2.70731737,0.27050057,0.0,0.0,0.03338906,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.04492582,0.21332559999999998,0.29931567,0.17792892,0.0,0.0,0.0,0.0,0.76069513,1.88562765,2.78844689,3.08176065,2.63132153,1.62664885,0.48126417,0.0,0.0,0.0,0.0,0.55510681,0.99057345,1.26588027,1.42141368,1.49520076,1.47605515,1.32341821,1.0265841999999998,0.6454799,0.29304281,0.06907245,0.0,0.01395801,0.02664802,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.448525057,0.273270203,1.02614025,1.48422379,1.21011525,1.93704661,2.11609095,2.4987105,2.7069365000000003,2.60129107,2.86848776,3.6096638999999997,3.64155406,3.41322939,3.7769864,3.67360467,3.24792065,3.49501986,3.4047973,2.97084382,3.1365678,2.60540702,2.58309261,1.74622508,1.4585059,1.23328179,0.7840631659999999,1.15463863,0.654042451,0.611891628,0.351590955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09701646609999999,0.137825466,0.0,0.380093134,0.44549419799999995,0.559569811,0.8031173770000001,0.494524608,0.9236686690000001,1.00783504,0.943043567,1.40708188,0.874961343,0.988855383,0.9391179909999999,1.01679262,0.8723817859999999,1.14482697,0.947006852,1.02880367,0.480496586,0.543758449,0.641597671,0.8813448490000001,0.271637769,0.648676083,0.704472051,0.265817676,0.099620936,0.412247087,0.0321019312,0.362826331,0.456856981,0.4564457,0.030166744199999998,0.6758887509999999,0.147582408,0.6580350620000001,0.5390300610000001,0.23033889100000002,0.405744007,0.053309572699999995,0.263922121,0.127089915,0.19922857300000002,0.46849539799999995,0.42625080600000004,0.277765512,0.0,0.31180268,0.0,0.153060797,0.0,0.0,0.039077659300000005,0.0,0.0,0.0,0.0,0.0890486886,0.00147552351,0.0,0.0,0.0,0.042584155199999994,0.0,0.0,0.42783723700000004,0.14296197300000002,0.279902086,0.393114003,0.47413741,0.0,0.309736632,0.0,0.101567152,0.222552544,0.253165508,0.24647966899999998,0.0,0.0,0.0,0.0,0.0,0.128320325,0.0,0.0,0.12063337800000001,0.0,0.186385279,0.265412068,0.0,0.0,0.0,0.0,0.19687939999999998,0.0,0.0,0.0863452559,0.0,0.225752382,0.0,0.0,0.305163755,0.0657172685,0.399007286,0.0,0.0,0.0,0.045251188899999996,0.0,0.0,0.0,0.044143092599999996,0.0199985298,0.0,0.0,0.008660462170000001,0.06227078900000001,0.0,0.0942889591,0.05629653230000001,0.09987501060000001,0.0,0.007907937700000001,0.188047217,0.598714344,0.595642543,0.655709835,0.206833972,0.291798133,0.00549170734,0.245779065,0.24607848699999998,0.384113174,0.0,0.0,0.0,0.028283573399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00253474263,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.02943689,4.68909959,5.65762585,5.98111042,4.00104502,1.4779496,1.07114511,0.0,0.0,0.66631223,0.2610318,1.84477377,1.510624,0.0,0.30666091,0.0,2.51396432,0.0,1.39968738,0.90832838,0.0,0.0,0.0,0.0,0.0,0.0,0.9126331,1.64395432,0.0,0.0,1.59771976,0.47007611,0.37031236,0.0,0.16020699,4.79230875,0.67629488,0.0,0.0,0.0,0.0,0.0,1.21912872,0.46403238,0.37062539,1.3241464,0.023716400000000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
1.16560837,1.53684451,1.94321652,2.37553104,2.82323371,3.27475638,3.7179108999999997,4.14031407,4.52982735,4.87499378,5.16545482,5.39233049,5.54854729,5.62910103,5.63124357,5.55458633,5.40111604,5.17512238,4.88304031,4.53321362,4.13558922,3.70135461,3.24253303,2.77155268,2.30080705,1.84222376,1.40685895,1.00453266,0.643519179,0.330303674,0.0694136445,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10379797699999999,0.210200255,0.302513076,0.375788209,0.42643765,0.45232217399999997,0.452771249,0.42853553299999997,0.381676126,0.315397521,0.23383357100000002,0.141797689,0.044509895599999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015478928500000001,0.0986809258,0.175441354,0.241743022,0.294167606,0.330065149,0.347682614,0.346245511,0.325988975,0.28813716899999997,0.23483249,0.16901845899999998,0.09428249609999999,0.0146666847,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0375783367,0.11878587800000001,0.194400779,0.260284511,0.31276334100000003,0.34882396600000004,0.366277663,0.363884441,0.341430585,0.299755237,0.2407241,0.167150946,0.0826701923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08891432369999999,0.21335723899999998,0.335085961,0.448363966,0.5477683170000001,0.628477827,0.686541648,0.7191151109999999,0.7246508490000001,0.7030350809999999,0.655661157,0.585435217,0.49671174700000004,0.39515996200000003,0.287565057,0.18157139100000003,0.0853774153,0.00739447315,0.0,0.0,0.0,0.0328410819,0.154162577,0.328690021,0.55685593,0.837052728,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.415
0.15624087,0.769535477,0.17741549199999998,0.0,0.0,0.35412481100000004,0.30389965399999996,0.0,0.0,0.0971469359,0.26038707699999997,0.0,0.0,0.0,0.115132264,0.036897803199999996,0.0,0.036775302,0.0,0.0,0.278088234,2.00046099,3.73267911,3.88732534,2.36207941,0.65727444,0.00120265242,0.118865786,0.12219726,0.0,0.0,0.08391007980000001,0.181921773,0.0,0.0,0.0,0.15708036,0.0583894368,0.0,0.0,0.09499478380000001,0.10515872400000001,0.0,0.0,0.025157535099999996,0.11006633199999999,0.005845960359999999,0.0,0.0,0.0846253773,0.0522392608,0.0,0.0,0.0440969149,0.0755419806,0.0,0.0,5.40401504e-16,0.0800730132,0.0223529344,0.0,0.0,0.0714048707,0.0727792506,0.0,0.0,0.04328973480000001,0.149778771,0.0,0.0,0.0,0.306435604,0.203335123,0.0,0.0,1.0193246,3.69827982,5.11784917,3.90476365,1.47399845,0.356882494,1.015182,1.50530773,0.480780328,0.0,0.0,0.643314036,0.926449216,0.0,0.0,0.19360797,1.69842925,1.63866768,0.40592819799999996,0.0,0.43081941799999995,0.409380677,0.0,0.0,0.5532852079999999,1.31656455,0.0,0.0,0.0,6.10693008,10.636496300000001,8.70033426,2.39798164,0.0,0.0,0.803405477,1.19058765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.58202058,0.8152913,0.91094306,1.1537895,0.7803467,0.75200471,0.93745981,0.31582467,1.55186131,0.09338546,1.86433681,0.62233839,0.41934799999999994,0.71599896,1.53993756,0.44684776,1.48063803,1.69803666,1.64200038,1.36017967,2.62523132,1.15790051,1.60144595,1.69036143,1.95845785,2.84812965,2.03784204,2.49453153,3.56827468,3.29157748,2.23233137,2.72929227,2.33642141,2.5012717,2.63758393,3.23374895,3.4965521,2.61064133,2.92790525,2.3311148,2.02494064,3.40624995,2.37622967,2.79871985,2.79458069,2.23839034,2.60640044,2.46442256,3.00605173,2.17804739,2.46040676,1.55473653,2.59525586,1.32910802,2.80098954,1.27655786,1.22014558,2.12149366,1.47998565,1.77117006,1.01731186,1.96191907,1.57449206,2.10132447,1.21384461,1.25227266,1.90050927,1.47224617,0.43154267,1.16680836,1.20519264,1.44680699,0.50991335,0.77723892,0.61066876,0.76488911,0.0,0.32869478,0.50226491,0.56010527,0.29933137,0.75436664,0.13760694,0.0,0.14474893,0.0,0.06438443,1.19896743,0.0,0.0,0.0,0.0,0.0,0.04087101,0.08068381,0.0,0.32089367,0.0,0.0,0.0,0.27044401,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.4848989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04864252,0.0,0.0,0.33635704,0.79484127,0.0,0.0,1.08072039,0.37652687,0.25520697,0.48095351,0.0,0.0,0.50869313,0.0,1.06000527,0.0,0.0,0.0,0.82482847,0.0,0.53227571,0.35528207,0.0,0.10403236,1.20176265,1.58676328,0.80754734,1.31085963,0.16941723,0.7026733000000001,1.70899236,0.22110947,1.35283142,0.17855809,0.10691527,1.35759288,1.40408846,0.25561452,0.06458729,0.0,0.0,0.35808742,0.0,0.0,1.93829502,0.0,0.0,0.28760191,0.01420142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22605915,0.0,0.0,0.0,0.09322164,0.08090708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.62249914,0.0,0.0,0.21046108,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.0466899703,0.69037996,1.37164988,1.74526393,1.78895003,1.51786837,0.91432928,0.198644147,0.0,0.0,0.157929936,0.118635585,0.0,0.0,0.23321283399999998,0.320225577,0.024622173799999997,0.0,0.0,0.204508255,0.183835429,0.0,0.0,0.0596880236,0.27437701800000003,0.0377495739,0.0,0.0,0.23149982800000002,0.270330921,0.191851463,0.88406523,2.3281327999999997,2.95683161,1.54468681,0.0,0.0,3.25038863,7.46994355,8.37747649,5.21120898,1.10386665,0.0,0.307231549,1.39486266,1.11509433,0.20014993600000003,0.009044639909999999,0.5553903729999999,0.845043056,0.505428585,0.16271422800000002,0.297747535,0.538937511,0.368487744,0.0,0.0,0.0759661789,0.186351287,0.0,0.0,0.0,0.126748162,0.07051628809999999,0.0,0.19913993,0.641849409,0.7595405209999999,0.35759861299999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
0.8565165920000001,0.476867718,0.0,0.319414128,0.31942077,0.047762088099999996,0.185590859,0.27588225,0.402790611,0.0710981009,0.0,0.09829940279999999,0.0,0.47132569700000004,0.833091567,0.046614858099999996,0.0,0.04961715480000001,0.115169607,0.31007672,0.0328130846,0.0,0.0512535708,0.0,0.00890281469,0.00672872184,0.0,0.0146419646,0.0,0.0161657119,0.437720275,0.921066155,0.8868246890000001,1.43212873,2.23455242,1.79342978,1.35664243,1.20510357,0.9936570459999999,1.76753614,2.36139527,1.66842019,0.588347992,0.20033658,0.6571613510000001,0.598462377,0.209107525,0.183986918,0.0,0.0,0.0662990291,0.0,0.143264908,0.0,0.0,0.143606821,0.0,0.84613278,2.27296524,0.9663021209999999,0.0,0.140771173,0.0,0.11284265,0.661821731,0.7032963590000001,0.728088471,0.40162926299999996,0.0,0.0,0.0239325873,0.0,0.013662044199999999,0.0,0.0,0.00919396718,0.0,0.00886943416,0.0,0.0,0.0174639823,0.0,0.07848558650000001,0.564639141,1.27078797,2.35750312,4.10094874,4.912429400000001,2.99081111,0.571762809,0.0,0.259937383,0.931288821,1.13347024,0.17127252399999998,0.0,0.11859233599999999,0.180365078,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.224157026,0.13526229,0.16474439800000001,0.351705455,0.66913782,1.02687431,1.30256063,1.39024691,1.24778307,0.9229672729999999,0.545377048,0.28374498600000003,0.282786248,0.602936169,1.18735313,1.87181713,2.43759789,2.69062793,2.53883619,2.03804059,1.38651348,0.866160162,0.747890811,1.19296377,2.18531941,3.52057451,4.85837899,5.82284524,6.11860381,5.62396457,4.42999008,2.81252188,1.14691225,0.0,0.0,0.0,0.0,0.0,0.304903938,0.652279422,0.6803876809999999,0.43133275299999996,0.0468120912,0.0,0.0,0.0,0.0,0.113481568,0.34068244200000003,0.410978543,0.310765805,0.104353965,0.0,0.0,0.0,0.208955187,0.59103318,0.9557852840000001,1.19013019,1.22660812,1.06532259,0.769411174,0.43743728299999995,0.164884678,0.0104145,0.0,0.0310891511,0.100594161,0.13162121400000001,0.0993802491,0.018475335500000002,0.0,0.0,0.0,0.0177877419,0.145919649,0.248883606,0.279258878,0.21871428399999998,0.08693558480000001,0.0,0.0,0.0,0.0,0.0,0.0967087467,0.17770053800000002,0.177380581,0.10113937199999999,0.0,0.0,0.0,0.021558391099999998,0.217951122,0.444553831,0.6286996770000001,0.710573573,0.6668247039999999,0.519472753,0.32637952800000003,0.157262449,0.0653078367,0.0663132113,0.134115496,0.214141395,0.24915211199999998,0.205953418,0.0913136651,0.0,0.0,0.0,0.0,0.08847112359999999,0.273078223,0.401548604,0.42674642100000004,0.34985945399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.677279355,0.0,1.04201449,0.782110944,0.0,0.0,0.232596675,1.58916585,0.0,0.0,0.0,0.0,0.81827109,0.0,0.0,0.886152033,0.6717512840000001,0.8568997340000001,0.0,0.6076498779999999,0.0,0.0,0.725790499,0.260063724,0.724249296,0.0,1.33592696,0.665633516,0.0,0.0,0.303000194,0.0,1.12051517,1.05426306,0.0,0.0,0.0,0.0,1.76228079,0.0,0.48897058,0.37638138299999996,0.144821662,0.0,0.0,2.16000236,0.0,0.0,1.07931145,1.37206593,0.0781542433,0.478697156,0.0,1.92360363,0.0,0.0,0.141489822,2.04817645,0.0,2.57225403,0.712583629,2.03388925,0.0,0.0,0.614478427,0.0,0.14910303800000002,0.0,0.0,3.41820361,4.68882623,3.26766585,3.64733435,3.07121801,4.88843514,2.74002161,2.07241459,0.580683483,0.729919139,0.945818061,0.0,0.0,2.04713418,0.0,0.0,0.496472573,0.0,2.08799831,0.0,0.014499194299999999,0.0,0.155073535,0.33908361600000003,2.40276955,0.0,0.717484757,0.0,0.205730131,0.7148095059999999,0.0,1.19071515,1.72594472,1.35356669,0.22318249899999998,0.0,0.0,0.373130526,0.0,0.0,0.690190339,0.024755997000000002,0.360820089,0.5146120679999999,1.45542777,0.420018195,0.609495583,0.0,0.0,0.23406532300000002,0.685827712,0.315895131,0.0,0.675679439,1.44088684,0.156373437,0.142938,0.0890498416,0.0,0.0,1.3696475000000001,0.0,0.0,0.428422728,1.08393332,0.07295245339999999,0.343615025,0.151104503,0.34019144799999995,0.885970755,0.137948315,1.75691672,0.0,0.022620024199999998,0.305038255,0.25363453,0.29795632699999997,0.0,0.0,0.0,0.0,0.0,0.0,0.305666561,0.0,1.66777851,0.0,0.50497397,0.0,1.05487685,0.29297577399999997,0.141688882,0.0,0.0,0.0,0.914876483,0.298049364,0.6483627120000001,0.7058207209999999,0.0,0.498940896,0.0,0.0653781867,0.0,0.0,0.0,0.890669575,0.981048081,2.30865435,3.96123373,1.422139,3.093829,1.21109827,0.457761553,0.9055975820000001,1.25350962,0.191330919,0.358489474,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.87482203,0.0,0.30936698,0.0,0.09916513,0.47079205,0.0,0.90867544,1.60860374,0.0,4.6627925999999995,1.36138504,3.18488744,1.28105552,2.11895916,2.43614423,0.0,1.77799272,0.0,0.24238066,1.03959379,0.90448527,1.41569899,1.83079761,0.57757308,2.30939491,1.35336433,0.0,1.37343453,0.0,0.0,0.0,0.41271937,0.3730932,0.70485249,0.0,0.0,0.28362488,0.0,1.65417912,0.33479172,0.0,0.0,0.0,1.08375742,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.12845539,0.214622075,0.282464805,0.322737796,0.329671392,0.301733646,0.241839677,0.15698342699999998,0.0573415058,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0804059786,0.15932080099999998,0.216258662,0.24399700600000002,0.23918879399999998,0.202766947,0.139791757,0.0587634962,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0670368446,0.144468621,0.202628862,0.233810783,0.23387456199999998,0.20279408399999999,0.14466347400000001,0.0671619572,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.059022035,0.140371416,0.203524713,0.239941459,0.244569564,0.216540328,0.159316576,0.0802701233,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0537503405,0.144459499,0.21710700300000002,0.261716134,0.271896237,0.245745288,0.18617245,0.10058924,2.3240821399999997e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.050301375,0.158426991,0.24775135399999998,0.305836983,0.324120776,0.299148488,0.233162895,0.133951982,0.0139582116,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0477625183,0.18688791899999999,0.305099633,0.38563691899999997,0.41628207700000003,0.39121788700000004,0.312114783,0.188270994,0.0357438816,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0695416117,0.311631085,0.551434734,0.7565519470000001,0.896201235,0.94536129,0.888534989,0.722661075,0.458773286,0.122131978,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.160905632,1.00157334,2.0060957,3.11743212,4.26533745,5.37214889,6.35947614,7.15514621,7.69971705,7.95190839,7.89240253,7.52562973,6.87935644,6.00211772,4.95875407,3.82450346,2.67824256,1.5955504999999999,0.642276949,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15167803900000001,0.45057572100000004,0.665209872,0.77610785,0.7782926720000001,0.68052484,0.503086409,0.27443724399999997,0.027182873,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0612935113,0.229852065,0.359912169,0.436720481,0.453022902,0.409618909,0.31488567100000003,0.183375404,0.033699278,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0282730467,0.14790198300000001,0.244095578,0.30509373,0.324093254,0.299969638,0.237245175,0.14532957800000001,0.0371514008,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0108316559,0.10371158,0.179971928,0.229971428,0.247859763,0.23229061199999998,0.18652500100000002,0.117920665,0.0368833639,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0354703856,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.940419888,0.0,0.524987713,0.584301702,0.358143169,0.943711159,0.0,0.143495501,0.55323959,0.484267839,0.0,0.0,0.0,1.05543359,1.47500034,0.940246345,0.0,0.0,0.0,0.247022345,1.61551803,0.0,0.0,1.04262427,0.008459558470000001,0.0,0.046758779199999996,0.18669470300000002,0.0,0.630562858,0.605233612,0.0,0.0,0.0,0.0,0.0,0.0,1.29470182,1.33986847,0.141778412,1.30865701,0.468602384,1.12917764,0.976080953,0.0,1.10099623,0.0,0.0,0.0,0.09861615650000001,0.0,0.0615341903,0.0,0.6057376489999999,0.0,0.549384442,0.0,0.0,0.0,1.07791011,0.0,0.0,0.43301917799999995,0.0,0.0,1.46115758,1.44508466,0.832261501,0.0,0.0,1.1462298999999998,0.0,0.915808402,0.266012126,1.7966182000000002,0.0,1.58853861,0.592627118,0.386607269,0.0,0.0,1.5577028999999998,0.83565097,0.0,0.152621388,0.0,0.09709874660000001,0.29464175600000003,0.000962135053,0.0,0.153687002,0.0308711586,0.40917808200000005,0.0,0.0,0.555707564,0.0,1.65856087,0.799447705,0.337356461,0.0,0.8180930040000001,0.0,0.0,0.67404975,0.0,0.9238499020000001,0.710613058,0.0,0.0,0.0,0.0,0.0,0.36334990100000003,1.79344427,0.12164013300000001,0.0,0.0,0.580514655,0.0937938508,0.10277965300000001,0.46265049,0.127865972,0.806597982,1.21683177,0.0,0.600332118,0.376158481,0.0,0.6139483020000001,0.17335474399999998,0.0,0.0,0.447186698,0.0,0.0,0.0,0.0,0.0,0.0895320278,0.908830406,0.400913367,2.01132244,4.18440183,3.98127451,3.73308372,3.80237164,3.79718564,3.46953606,6.00302568,3.52189705,3.10097245,1.61120352,1.20001781,0.747379648,0.7326944320000001,0.0,0.859748776,1.5695361,0.270632796,1.25948243,0.150138152,0.0,0.0,1.07722973,0.0,0.0,0.0,0.39509402,0.9524323029999999,0.0,0.278503555,0.389929841,0.605519202,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
1.07005647,0.592609808,0.218888265,0.0,0.0,0.0,0.0,0.181927664,0.402174304,0.618009315,0.797867876,0.919348257,0.971444093,0.9550273309999999,0.8816132109999999,0.770675138,0.645968046,0.531439153,0.447340415,0.40710529700000003,0.415423345,0.467759879,0.551352304,0.647500186,0.7347831909999999,0.792714122,0.805279929,0.7638476359999999,0.669009384,0.5310960610000001,0.36927930600000003,0.20937986100000003,0.0806786582,0.012161471100000001,0.0287009298,0.14768267599999998,0.37651669,0.71135115,1.13714294,1.6290593999999998,2.15501486,2.67900571,3.16481699,3.57964221,3.89718776,4.09991807,4.18022303,4.1404366,3.99178419,3.75246593,3.44517682,3.09441249,2.72390733,2.3545027000000003,2.0026583,1.67971211,1.39188214,1.14090163,0.925102777,0.740722034,0.583195339,0.44824261,0.33259988100000004,0.234332961,0.15274559699999998,0.0879648033,0.0403356193,0.00978040474,0.0,0.0,0.00404826958,0.019338704499999998,0.0355269957,0.0480115466,0.0531649578,0.0489080546,0.035048608700000004,0.0133130991,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.021494602999999998,0.053501855099999995,0.0782140166,0.0912568596,0.0900184159,0.07414464259999999,0.0456751584,0.008786862480000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.041312598799999996,0.0806649622,0.10823833599999999,0.119250652,0.111443371,0.08551640740000001,0.045099844800000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01263123,0.0678504959,0.113897977,0.143110145,0.150275717,0.133542887,0.09482008880000001,0.0395913873,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0383257339,0.10826760000000002,0.163516192,0.1946266,0.19563211600000002,0.16513085800000002,0.106693792,0.0285034358,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08518859289999998,0.181442524,0.25363454399999996,0.288764992,0.279001224,0.223209842,0.12752897,0.00483962031,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0195167275,0.19724521,0.358812048,0.476524586,0.5269652029999999,0.494967162,0.376720619,0.181504197,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33028692800000004,0.9654511509999999,1.66088628,2.35630704,2.98753916,3.4937661,3.82468151,3.94666126,3.84716596,3.53678524,3.04861501,2.43498353,1.76187085,1.10165611,0.5250417629999999,0.09311321310000001,0.0,0.0,0.00201346867,0.37126255,0.883371797,1.47852096,2.08884808,2.6463088,3.09038357,3.37471366,3.47189536,3.37590408,3.10192408,2.68368613,2.16872082,1.61218258,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.9295758829999999,0.9208241690000001,0.404963395,0.0,0.149430493,1.31848944,2.23427128,1.82215104,0.62427024,0.0,0.0910534996,0.108757914,0.0,0.0,0.155793189,0.07623497530000001,0.0,0.0,0.18496708399999998,0.0254631204,0.0,0.00381793725,0.20590739100000002,0.0,0.0,0.0688474553,0.193270391,0.0,0.135866714,1.04639562,1.47820715,1.05445541,1.15072085,2.32918234,2.95705442,1.8630843999999998,0.308480021,0.0,0.08505502029999999,0.114667829,0.00169214099,0.038812482999999995,0.0,0.0,0.380686542,0.828777595,0.643900519,0.267736971,0.39632304100000004,0.46842538899999997,0.0,0.0,0.7381506940000001,1.12109844,0.050797338,0.0,1.64140838,4.06300058,4.11362835,2.49099916,1.29908371,0.54244502,0.10508037199999999,1.87144489,5.81247132,7.45262803,3.91592927,0.0,0.0,0.628117671,0.912845006,0.0,0.0,0.616603305,0.517291148,0.0,0.0,0.8106160379999999,0.477292868,0.0,0.0,2.28785846,3.42323521,1.87012372,0.0,0.0,0.0587469577,0.15737563300000001,0.0,0.0,0.016181432,0.00837258141,0.0038573294200000005,0.0133505455,0.0,0.0,0.030778918199999998,0.0177344411,0.0,0.0310110814,0.089405075,0.128073468,0.54476218,1.52305485,2.35609851,2.20320984,1.25445739,0.40311641200000004,0.0615034468,0.0,0.0,0.0143629967,0.026633795,0.0,0.0,0.0330730484,0.0278290327,0.0,0.0,0.0469587326,0.0175243667,0.0,0.0,0.05435347559999999,0.00208913314,0.0,0.00636637999,0.0560460334,0.0,0.0,0.03517247,0.20834792300000002,0.47521526,0.8891740770000001,1.17295602,0.952269321,0.393150915,0.0349733707,0.0110759594,0.0173004066,0.0,0.0,0.0576298906,0.0104978317,0.0,0.0,0.0660767721,0.0,0.0,0.0192265239,0.064908955,0.0,0.0,0.0395562276,0.05697204,0.0,0.0,0.0587280201,0.0440608782,0.0,0.0,0.0828391564,0.029232857,0.0,0.033682215099999996,0.5009784420000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.482854709,0.837407255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.664755981,0.0,0.204501795,0.8261456359999999,0.0,0.6974459679999999,0.0,0.0,0.659026015,0.34863472100000004,0.0,0.45801146299999995,0.676264518,0.0,0.0,0.0,0.596827756,0.044357462300000004,0.107364857,0.35549179200000003,0.566175538,0.0,0.558002337,0.0,0.18477231600000002,0.144715858,0.0,0.0,0.0,0.17211402899999997,0.0,0.0,0.438536521,0.20151793699999998,0.0,0.0,0.194230848,0.0,0.334472169,0.0,0.06518204,0.131376192,0.0,0.33884490700000003,0.32227709,0.09645694980000001,0.011142011,0.49956126799999995,1.16103756,0.6890721879999999,0.9360274740000001,0.9710031240000001,0.5279964,1.885621,0.567392792,1.02280029,1.70438825,1.35643984,1.46463627,1.31527655,1.34147099,1.51510463,1.59286995,1.76641023,2.44464958,1.24858447,1.46755172,1.09731707,1.80813102,2.21795652,3.03233799,2.28754244,1.32692381,1.442408,0.513832261,0.331025489,0.0,0.0,0.676154597,0.783175524,0.33848965200000003,0.368088969,0.0,0.07109114650000001,0.0,0.0,0.0,0.550972906,1.38385467,1.84796763,1.2750944,1.47032504,0.817567402,1.67001703,1.41127713,0.985743872,0.780465594,1.0187369000000002,0.171163937,0.0,0.0,0.0,1.06319071,0.89293082,0.8597994170000001,1.0077249,0.688996547,0.661712485,0.0,0.0,0.0,0.5578466329999999,0.66441152,0.608892703,0.478807329,0.7996926109999999,0.0,0.0,0.0,0.030460847000000003,0.277045761,0.12798775699999998,0.317414725,0.5043526220000001,0.0,0.155576667,0.267371278,0.46911247,0.0,0.0,0.0,0.469989812,0.484479547,0.42465780700000005,0.0,0.0,0.0,0.0,0.0,0.270090027,0.329069098,0.0,0.0,0.5753615910000001,0.42875268299999997,0.0,0.0,0.29705410600000004,0.36275858200000005,0.651239286,0.168651766,0.0,0.395521946,0.326441844,0.0,0.0351536181,0.0803866601,0.27467840600000004,0.0,0.0,0.738164389,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
1.91594683,0.0,10.18552404,18.17015631,3.956176,1.46171987,0.0,0.32169649,0.07267414,0.35641456,0.0,0.5028803,0.0,3.30094699,6.66192915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.0168214245,0.0,0.0,0.0138575944,0.043075889000000006,0.0827765853,0.12890234,0.17695318399999999,0.22233433100000002,0.260711455,0.288348297,0.302403288,0.301165301,0.28421332,0.252490361,0.208287905,0.155142953,0.09765521640000001,0.0412365085,0.0,0.0,0.0,0.0,0.0,0.04931949730000001,0.151844205,0.28910268100000003,0.459873546,0.661243007,0.8886534340000001,1.13602929,1.39597734,1.66005542,1.91910172,2.1636139,2.38416494,2.5718403,2.7186786,2.81809645,2.86527633,2.85749642,2.79438145,2.6780555,2.51318087,2.30687155,2.06847573,1.80922878,1.54178553,1.27964925,1.03652171,0.8256062909999999,0.658901054,0.546522237,0.496099619,0.51228332,0.5963969889999999,0.7462649929999999,0.95623151,1.21737795,1.51793257,1.8438534,2.17955375,2.50872902,2.81523595,3.0839708,3.30169161,3.45773294,3.54456766,3.55818016,3.49822784,3.36798206,3.17405415,2.92592728,2.63532739,2.31547747,1.98028651,1.64352817,1.31806372,1.01515921,0.743939075,0.5110070329999999,0.320252537,0.172846762,0.0674183688,0.000386574493,0.0,0.0,0.0,0.0,0.0242279567,0.0530667375,0.07676492830000001,0.0921290932,0.0974628451,0.0925029469,0.07824298360000001,0.0566687471,0.0304351901,0.0025176453100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.019122161699999998,0.0351020258,0.046578092800000005,0.0527244327,0.053297278899999995,0.0486207769,0.0395171439,0.027191679399999998,0.0130869181,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0016742785699999999,0.0101295687,0.0167851232,0.0211283783,0.0229351371,0.0222705096,0.0194581658,0.0150232647,0.00961703991,0.003932635039999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000419636166,0.00101128413,0.0007993172359999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00131257339,0.004673738770000001,0.00834658029,0.0118256937,0.014556545300000001,0.016008178799999998,0.015749024099999998,0.013516386100000001,0.009270439220000001,0.0032248912800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00893236487,0.023382904500000003,0.037004603,0.048216031900000005,0.055517320999999994,0.057658266,0.0537972058,0.0436341119,0.0275027875,0.006410095940000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0203147067,0.08318490469999999,0.15554917199999999,0.23404361199999998,0.314650783,0.39296553700000003,0.464502354,0.525020587,0.5708419370000001,0.5991344820000001,0.608139775,0.597323728,0.567437879,0.520484692,0.45958820899999997,0.388778965,0.312709017,0.236318584,0.164479716,0.10164427300000001,0.0515231802,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
0.0339242014,0.30491083399999996,0.268628724,0.0,0.0,0.368457682,0.264169799,0.201881851,0.0,0.37347734899999996,0.0,0.40415338799999995,0.24951222,0.0532413791,0.44502749700000005,0.034070221,0.0,0.0,0.27686027399999996,0.0,0.0,0.18238369899999998,0.299609401,0.0,0.318161218,0.479744044,0.103593967,0.359868542,0.0,0.0,0.0614566914,0.0958492774,0.407271037,0.00509076128,0.25237804199999997,0.0,0.372838906,0.0348780042,0.183797457,0.0,0.0,0.125054799,0.296274104,0.013582620600000001,0.07272381929999999,0.0253879929,0.0,0.0,0.04248554,0.323411729,0.259728256,0.0,0.202241187,0.387675035,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.449496066,0.0,0.0,0.165740102,0.0,0.0,0.0,0.089423339,0.0,0.0,0.0,0.138183102,0.0,0.307113237,0.288668,0.0,0.0,0.0,0.0,0.0,0.200422908,0.43669852200000003,0.0,0.0,0.151113202,0.12870647300000002,0.375654647,0.0,0.49486323600000004,0.0,0.233247868,0.152773801,0.33844087799999995,0.456434767,0.00331997659,0.319864113,0.0,0.0,0.0,0.0709463342,0.0866197399,0.030993298199999998,0.0,0.0,0.0,0.023510789,0.0,0.0,0.0,0.0,0.49651699,0.296382268,0.289155326,0.458168625,1.10398349,0.916912452,0.8795334770000001,1.53609777,1.60890431,2.27923753,1.82029222,2.31284213,2.86497153,2.68890475,3.62775444,3.11782592,3.47924006,3.90779341,4.01153744,4.12722595,4.11937961,4.25303917,3.96993806,4.0455688,4.07892201,4.11097852,3.82120572,4.1018913999999995,3.91459881,3.52465117,3.70336273,3.53212698,3.60730122,2.79115354,2.64708551,2.80322112,2.65002957,2.0528654,1.85479741,1.39558665,1.07011828,1.36350991,0.41320086100000003,0.7166322620000001,0.0448710389,0.514695852,0.0,0.0,0.34693368700000005,0.27984227899999997,0.0,0.178646776,0.0,0.0,0.09940636859999999,0.0,0.0,0.0,0.0,0.114420906,0.0,0.0,0.00711362696,0.0,0.0,0.198709921,0.27619963,0.486744313,0.38710825299999996,0.112895404,0.40167831,0.28133528,0.375436292,0.0,0.176056971,0.273287398,0.0,0.13051218,0.0,0.005727131460000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.120074187,0.0,0.0,0.0,0.178375796,0.0,0.411354004,0.0,0.0171132935,0.23414265899999998,0.0,0.378638745,0.0801345124,0.0,0.057479841399999995,0.0,0.470788465,0.39109275600000004,0.345849652,0.295275877,0.292092929,0.0,0.269502846,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
3.82048823,2.87568807,1.73720054,0.19842257,0.0,0.0,0.0,0.0,0.14745104,0.96107148,0.73760967,0.21117456,0.28321192,1.1222618999999998,1.37626926,0.35678278,0.3283748,0.0984,0.07489676,0.0,0.0,1.47744541,0.88032005,0.06810391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.91767459,0.84399084,0.0,0.0,0.0,0.02539187,0.91529572,0.0,0.0,0.45892643,0.54668212,1.31160886,1.17726855,0.65833493,0.0,0.6393886,0.0,0.0,0.0,1.07331245,0.96217622,1.66748719,1.81469734,3.41723622,3.37870329,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.34833957,0.0,0.0,0.435240465,1.23645557,1.33354932,0.38486666399999997,0.47746345799999995,0.9402477359999999,0.7506522990000001,0.8133098009999999,1.62367006,1.61811243,1.52372756,1.96982416,1.39489503,1.86559886,2.37618376,1.86644935,2.55999583,1.47433087,2.77662165,2.42739353,2.16580288,2.01450002,1.9272895,2.36957471,2.35461183,1.84615382,2.45045222,1.91008437,1.64092743,1.13393907,1.4907711000000001,1.44018043,1.36468843,1.26471121,0.648670992,1.00136026,0.327977684,0.645121286,0.92125902,1.25969327,0.0,0.637567636,0.667320955,0.0,0.221691705,0.7724027590000001,0.0,0.937265417,1.4286332,0.10025244900000001,0.0,0.0,0.775137282,0.0,0.24444711600000002,0.153195955,0.558078328,0.0,0.0,0.0,0.0,0.0,0.0,0.0175285859,0.0881838759,0.49304288799999996,0.0,0.204161462,0.0,0.0,0.0,0.0430155718,0.0,0.0,0.0,0.0,0.347154225,0.133449507,0.0,0.0,0.008210637359999998,0.620325152,0.0,0.105448603,0.243562533,0.544471191,0.0,0.32477737100000004,0.0,1.00717766,0.0826922516,0.532870657,0.763508993,0.38559342,0.0,0.203394954,0.787499759,0.332642528,0.462776245,0.685453125,0.22372973100000002,1.27303873,0.0314928281,0.102728246,0.371037558,0.811383738,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.049285988499999996,0.0,0.0,0.369094849,0.658664977,1.16349226,0.7797162670000001,0.343648384,0.238041239,1.64183643,0.9959446359999999,1.42866564,1.95795625,1.58011799,1.51655921,1.36991548,3.02418963,1.93582851,0.7286959959999999,0.980839325,1.25425299,1.55113274,1.69405816,1.7555938000000002,0.799213046,0.888744251,1.39051085,0.788510203,0.081277074,0.0,0.507354871,0.0,1.23300206,0.11027007800000001,0.580503935,0.84694266,0.28621434100000004,0.41846480399999997,0.0,0.0,0.0,0.0,0.66763074,0.360986087,0.0,0.0,0.0,0.0,0.0,0.0,0.06319913440000001,0.300812943,0.0893999733,0.0417744548,0.661272825,0.51014932,0.18971107,0.487217281,0.0731528492,0.0,0.860140503,0.234447422,1.1393323,0.345142965,0.12633776,0.22456206,0.21073364100000003,0.0,0.70298312,0.312373026,0.0,0.990392624,0.286425976,0.0,0.0513751032,0.0,0.127358112,0.79153035,0.0,0.0,0.0,0.238694927,0.0,0.0,0.788955952,0.0,0.0,0.429837376,1.08831439,0.24613576,0.17804648899999997,0.606880992,0.0,0.0,0.97303535,0.0,0.0,0.0,0.0908825208,0.0,0.0,0.0,0.187471418,0.330106055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.044369628,0.0778772313,0.023975872599999996,0.13462505,0.805019203,0.7509057459999999,1.08918157,1.13527358,1.48672464,1.71384672,1.66114769,2.22633664,2.27281794,2.51032857,2.36887657,3.04442711,2.81733643,3.38198595,3.00763092,3.25317037,3.34617248,3.50583369,3.45397467,3.1962212,3.22280959,3.13028097,2.79272203,2.47840444,2.77455223,2.37126074,2.24857344,1.65057542,1.55440347,1.46111005,0.9898942270000001,1.3381744,0.778817072,0.9818692370000001,0.815163993,0.44326356899999997,0.459390475,0.125138279,0.36587696,0.0,0.422665099,0.17093692300000002,0.0,0.442587279,0.0,0.20263904300000002,0.0,0.16161066300000002,0.468092423,0.0,0.10871162300000001,0.136336139,0.266924406,0.4040005,0.22581459399999998,0.0,0.0,0.0,0.0171016357,0.0,0.0,0.0,0.0500331142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0588842061,0.18530355199999998,0.20641901899999998,0.329172927,0.387142445,0.008012770550000001,0.342164385,0.0,0.639706384,0.443301048,0.461925459,0.387715331,0.423527589,0.608888346,0.0880004594,0.422476575,0.305943627,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.34765623799999995,0.194749525,0.605615134,0.543866371,0.733457605,0.955931662,1.33962024,1.31515656,1.76654286,1.96855581,2.04048424,2.19300191,2.43425727,2.10371465,2.1265624,2.50057911,2.24463736,2.64187806,2.43931956,2.09591998,1.68864965,1.78894538,1.73478408,1.53520186,1.4412293,0.75218529,0.788758443,0.5159906360000001,0.660515168,0.569197176,0.0,0.005589811609999999,0.0863373925,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.084029649,0.0,0.24828901399999997,0.307045737,0.0,0.0,0.47998850299999996,0.0,0.519603021,0.207422317,0.0558395285,0.346149101,0.10115539900000001,0.310750371,0.0,0.263089148,0.39227755299999995,0.0,0.380933887,0.170257782,0.0,0.22015037399999998,0.0,0.14874568900000001,0.262083212,0.043059494299999994,0.339121884,0.0835488544,0.0,0.128946313,0.0,0.0,0.0894163945,0.209809012,0.0,0.212188147,0.0,0.0539954509,0.0,0.0,0.0146336093,0.297310393,0.0,0.0,0.0,0.0241593705,0.0,0.0,0.34370638600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.07325209,0.0,1.77764126,1.37524247,4.03952823,5.34874939,3.94621747,5.41039866,1.5736021999999998,0.0,0.0,1.12566533,1.1738536,0.0,0.0,1.32987998,5.09591074,4.41165686,4.79494181,2.07007332,0.0,0.0,1.26626519,1.06190473,0.45887054,0.0,0.63193021,0.0,0.0,0.0,0.0,0.64698717,0.0,0.0,0.0,1.04196846,0.0,0.0,0.0,0.65834828,0.0,0.0,0.34100499,0.0,0.0,0.87003379,0.69047222,0.68442833,0.0,1.61798475,0.0,1.85762981,0.0,0.0,0.0,0.64512435,2.8105648999999997,0.0,0.18425727,0.51566983,0.51906892,2.53073111,0.90057744,0.09301845,0.0,0.0,0.0,0.0,0.0,0.0,0.11174779,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.0513243364,0.0,0.0,0.261075296,0.0,0.7556335809999999,0.738948718,0.0,0.583915149,0.0,0.0,0.0,0.0,0.0,0.296105664,0.460913625,1.16509295,0.332019158,0.0,0.0,0.0,0.0,0.424081792,2.01795713,2.42611642,2.76864404,1.3150367,1.05408931,0.0,0.0,0.528023175,2.37193102,4.16078874,5.85141797,6.18498712,7.01745811,6.19578408,3.72336991,2.15334819,0.0,0.0,0.0,0.0,0.40314379,0.420879967,0.464280143,0.9832265440000001,0.0,0.301675079,0.0,0.0,0.0,0.11375889900000001,0.08144348950000001,0.833839531,0.034980746,0.107779574,0.0,0.0,0.0,0.333301697,0.0983304092,0.0,0.7408504090000001,0.632994886,0.0,0.0,0.0,0.0,0.34587094,0.0,0.492748095,0.469138296,0.261709848,0.100362516,0.0,0.30525480899999996,0.0,0.05668892019999999,0.7844293929999999,0.569017208,0.0,0.0,0.0,0.0,0.0,0.0,0.561666698,0.72910472,0.32643435600000004,0.275534126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45332861799999996,0.0,0.255325741,0.0,0.0357959236,0.311532042,0.0920742825,0.179811634,0.63220267,0.0,0.0,0.0,0.0,0.0,0.635244624,0.8845862659999999,0.256737628,0.372588525,0.0,0.0,0.0338307832,0.429281346,0.0,0.0,0.495320308,0.0,0.040842662599999996,0.012978264199999999,0.315931129,0.0184254901,0.0410405629,0.0,0.0,0.0,0.6165585889999999,0.488816521,0.0,0.250023538,0.0,1.13645071,1.0443076,1.04682739,0.503596021,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.57475912,0.93944344,0.0,0.0,0.48369155,1.89561334,0.0,0.42704036,0.50830812,0.0,1.12326807,0.82164623,1.06385553,0.48518108,0.80788547,0.0,1.28872434,0.47479494,0.8318535,0.83978993,0.14917252,0.0,0.61675256,0.34659246,0.48451622,1.18530077,0.33622149,1.34790118,0.35879636,1.54936373,3.35441501,1.83087497,1.8542691000000002,2.42498488,3.74332622,3.55855399,2.02316758,3.14058637,2.58369254,1.69780489,1.61752513,3.02906596,2.59159114,2.87694825,3.317997,1.5251845,0.73151533,0.63209016,0.0,0.82655665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.0496603721,0.0600355052,0.069580242,0.0773984997,0.0827304097,0.08502900960000001,0.08402932980000001,0.0798049735,0.0728077007,0.06388621559999999,0.0542813025,0.0455956044,0.0397376627,0.0388412446,0.0451624303,0.0609583292,0.0883525627,0.12919373,0.184913892,0.256394593,0.343848114,0.44672135,0.5636291520000001,0.692322889,0.829698678,0.971848061,1.11415204,1.25141735,1.37805171,1.48827288,1.57634428,1.63682837,1.66484763,1.65634192,1.60831071,1.51902855,1.38822271,1.21720303,1.0089356,0.768053874,0.500803067,0.21491663,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11965743699999999,0.632343089,1.19072772,1.7816698,2.39061436,3.00203749,3.59993375,4.16832937,4.69180263,5.15599245,5.54807616,5.85719892,6.07483826,6.19509027,6.21486635,6.13399304,5.95521116,5.68407413,5.32874943,4.89973058,4.40947078,3.87195189,3.30220521,2.715802,2.12833286,1.55489533,1.00960841,0.505171678,0.052484666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.131023369,0.303500066,0.448981733,0.562780478,0.641915766,0.685134235,0.692857649,0.667064089,0.611110085,0.529503645,0.42763983299999997,0.31151177,0.187410458,0.0616268566,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0255156592,0.10302679,0.171643574,0.22851835199999998,0.27150682600000003,0.29923685,0.311137253,0.307427053,0.28906726899999996,0.257679258,0.215434928,0.164925343,0.109014993,0.050689407400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0345335732,0.0675381099,0.0952116982,0.116495818,0.13071918400000002,0.137611338,0.137294547,0.13025544,0.11729879300000001,0.099486757,0.078067443,0.054397210599999996,0.029861164,0.00579627989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00522644209,0.012994122,0.0186329973,0.0221068633,0.0235666719,0.023331795899999997,0.021860401600000003,0.0197110644,0.017498269099999998,0.0158447816,0.0153340322,0.0164656207,0.0196168286,0.025012625400000002,0.0327061138,0.0425706876,0.05430443980000001,0.0674465826,0.08140487589999999,0.09549236470000001,0.10897111699999999,0.121100195,0.131184793,0.13862337,0.142949668,0.143866821,0.141271173,0.135264057,0.126150508,0.114424678,0.10074259,0.0858836365,0.0707030405,0.056078089500000004,0.042851460999999993,0.0317752496,0.0234593906,0.0183280396,0.0165871093,0.0182055996,0.022912609,0.0302110212,0.0394078733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.160604892,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.536763291,0.351667988,0.435162042,0.7380445640000001,0.9324814370000001,0.735172904,0.470164669,0.991069531,0.423349575,0.859065572,0.9393512490000001,0.684923298,1.01471227,0.55321518,0.437129205,0.579779754,0.7352678859999999,0.32126130399999997,0.0,0.11125607800000001,0.332778191,0.315453845,0.134814709,0.00600013399,0.0,0.0,0.0,0.0,0.0772450568,0.253442262,0.285918196,0.0,0.0,0.418697466,0.419244238,0.31394364199999997,0.41744848799999995,0.448434305,0.37545509899999996,0.0,0.520374169,0.182972968,0.5690192820000001,0.60979496,0.679721295,0.158610765,0.0410940785,0.0,0.574642765,0.494306368,0.0,0.320983685,0.257116014,0.0,0.31671294,0.154973859,0.0,0.0,0.0529369165,0.0,0.176907108,0.0,0.0,0.0,0.25849579,0.0,0.0,0.0,0.0,0.0,0.37366685299999997,0.140173825,0.055859513799999996,0.318404422,0.149208266,0.047581204,0.418829795,0.282702081,0.05600217019999999,0.632499402,0.0,0.135284566,0.0595635125,0.0,0.281955373,0.193273547,0.0,0.0,0.156952661,0.0,0.011072195,0.0,0.0,0.0,0.0149220668,0.0,0.0,0.0,0.022792325699999998,0.0,0.10890979699999999,0.0,0.0,0.39129286,0.388379784,0.0252973687,0.16355688300000001,0.0247589525,0.670476733,0.48152731200000004,0.62892945,0.046624339400000006,0.192261923,0.188690805,0.312331987,0.0834962875,0.0,0.318696574,0.21092949,0.0,0.06116473309999999,0.09889639509999999,0.0,0.0,0.0195166347,0.0,0.0,0.0,0.0,0.0,0.0768309631,0.0,0.312293305,0.303345869,0.480135398,0.291159758,0.654536305,1.05622662,1.14765783,1.59535043,1.71823774,2.26679607,2.34091607,2.81903673,2.99854337,2.87945147,2.9436584999999997,3.59740136,3.28317076,3.78826639,3.94292342,3.68727658,3.9046089,3.79641089,3.42615878,3.7998661,3.15163914,3.44333439,2.9065012,2.87383279,2.25032025,2.26006259,1.90322954,1.85071377,1.02773961,0.743354871,0.758629239,0.7260909520000001,0.552627489,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
2.16380966,6.49573762,9.06556666,2.17242168,0.0,1.53419524,3.7093708,0.0,1.42368449,0.0,1.54331348,0.0,0.48288517,0.0,0.0,0.68537998,0.0,0.0,0.89133563,1.87771348,1.80448322,0.0,0.0,0.0,0.37916098,0.0,4.41318106,2.12705697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.199325941,0.0,0.0,0.0,0.187280534,0.9642014720000001,2.0771306000000003,3.35616688,4.57414975,5.49075586,5.89088783,5.62707275,4.67362998,3.17822027,1.4721319,0.00019117856599999998,0.0,0.0,0.0,0.662585202,1.16726758,0.956090551,0.0817938506,0.0,0.0,0.0,0.8711113000000001,3.28711067,5.46684179,6.53828425,6.06963211,4.27382116,1.89526905,0.0,0.0,0.0,0.0,0.336105394,0.759142988,0.619624205,0.12024665300000001,0.0,0.0,0.0,0.0489056509,0.35152363600000003,0.394193203,0.18841219,0.0,0.0,0.0,0.0,0.159797526,0.234785545,0.146947929,0.0,0.0,0.0,0.0,0.0686363194,0.14886817,0.122010755,0.018285043799999998,0.0,0.0,0.0,0.0166271385,0.0818438727,0.0844053536,0.0318794769,0.0,0.0,0.0,0.0,0.0319693171,0.0400919449,0.0208173828,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.020196595,0.036356617599999995,0.026682033900000002,0.0,0.0,0.0,0.0,0.044297302000000004,0.09949006369999999,0.0891188031,0.006600370019999999,0.0,0.0,0.014349163100000001,0.301676681,0.657506358,0.938849687,1.02244813,0.872959492,0.562828644,0.230816175,0.00455226232,0.0,0.0,0.056058702,0.08624191689999999,0.0645883509,0.0410944319,0.0738050872,0.172975397,0.281578143,0.309237321,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
0.03707065,0.0159921758,0.0297494269,0.073305672,0.11836314199999999,0.13534522599999999,0.114402829,0.0706635691,0.0312805417,0.0148153355,0.0183764954,0.0218126365,0.005670413670000001,0.0,0.0,0.0,0.0,0.059556261900000004,0.12115425099999999,0.119015306,0.0375386998,0.0,0.0,0.0,0.0,0.119105449,0.266939616,0.275395204,0.111626931,0.0,0.0,0.0,0.0,0.20540402800000002,0.556925469,0.638120573,0.32615696899999996,0.0,0.0,0.0,0.0,0.559429736,2.37560159,4.22949827,5.52508072,5.81637614,4.98903115,3.30986958,1.32249715,0.0,0.0,0.0,0.0,0.227510672,1.06767229,1.51776472,1.51082784,1.16948522,0.70811112,0.319331915,0.09918032710000001,0.036473333,0.055783173600000006,0.0790837313,0.0693255165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
1.27097878,0.34151931,0.96192535,0.6141641999999999,0.38705764,0.0,0.58229586,0.0,0.0,0.0,0.0,0.93643502,0.06994343,0.65588654,1.02853596,0.18580361,1.08243868,0.0,0.0,0.0,0.56313941,0.42977070000000006,0.65130905,0.0,0.0,0.55513114,0.56794204,0.0,0.0,0.0,0.09911687,0.0,0.0,0.11179322,0.54551077,1.6328976,1.92603053,1.58569019,0.39084092,0.08635298,0.0,0.79216232,0.08439107,0.27277971,0.0,0.0,0.0,0.0,0.41707888,0.0,0.31594211,0.0,0.0,0.0,0.0,0.68022739,0.04393958,0.57756607,1.58791697,2.28055919,1.9139068,1.43611169,0.56929755,1.73426456,0.62127665,0.0,0.22332946,0.08446205,0.23174361,0.84021618,1.71747582,0.86943702,1.61712439,1.0264957000000001,0.47304322,0.17420088,0.0,0.0,0.0,0.73572004,0.0,0.14935206,0.0,0.35645576,2.24638823,3.32209221,5.81780415,8.04243923,7.89272636,9.02410219,7.75017748,7.79724278,5.28374462,3.68963895,2.5520978,1.86258569,0.53878662,0.63033175,0.85286437,0.29500819,0.22467537,0.0,0.0,0.0,0.93847919,0.0,0.41165298,0.0,0.0,0.14093098,0.8713339,0.31665935,0.0,0.0,0.0,0.0,0.0,0.49709699,0.0,0.0,0.0,0.37210978,0.0,0.0,0.0,0.10097598,0.0,0.0,0.80942671,0.0,0.0,0.0,0.08505899,0.37894,0.0,0.0,0.16427645,0.35147566,1.11463174,0.79596778,0.31908628,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.713888423,0.933852873,0.8307791959999999,0.871498647,0.915430815,1.25816875,1.5463676000000002,1.75639755,1.37634436,2.04070296,1.77454497,2.02425163,1.67814004,2.06126661,1.54604844,1.1731958999999998,1.09404032,0.7656233490000001,1.10955572,0.956584433,0.8457025490000001,0.749881008,0.909616876,0.807142824,0.662444979,0.655956998,0.415725645,0.14674351,0.748130405,0.37536911,0.51083371,0.392657685,0.0,0.48798569700000005,0.0,0.0,0.0732250897,0.0,0.0,0.0,0.36653081299999996,0.0,0.0,0.402420733,0.0,0.0,0.0,0.0,0.0,0.0,0.0884326208,0.0,0.404524237,0.495830341,0.0,0.314233253,0.00305207956,0.09413700800000001,0.14752941,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.393101345,0.631259418,0.9253953659999999,1.93906811,2.72471528,3.08239753,3.35773099,3.52477554,4.14419166,4.28818714,3.78895396,3.74903631,3.19087546,2.6279765,2.28825182,1.22607074,0.798722198,0.831809102,0.361199029,0.0,0.0,0.257089341,0.220810317,0.270796357,0.0,0.27829398,0.0,0.318296831,0.0,0.0,0.0,0.0,0.209539557,0.018423899,0.0346056138,0.0,0.283662317,0.381503905,0.0,0.216706603,0.0255513022,0.0,0.0,0.0,0.165240011,0.0,0.0,0.0,0.0,0.0,0.0,0.318314849,0.792782993,0.97802487,1.09572286,1.43223012,1.29800244,1.27471465,1.24943607,1.70832244,1.17481846,1.65813646,1.40313365,1.07695489,0.934485517,0.334197082,0.24238078300000002,0.172707312,0.166620328,0.0,0.0,0.0,0.0,0.0,0.0,0.397360027,0.0,0.412459148,0.0,0.0,0.38046699799999995,0.36187930799999996,0.12390674199999999,0.217141317,0.28649618600000004,0.0,0.0,0.0,0.0,0.0,0.0808533768,0.0,0.0,0.0,0.133724191,0.390940667,0.17285206,0.0,0.0898626328,0.0,0.0,0.22509707899999998,0.0,0.283917895,0.0,0.0,0.158968524,0.0,0.0,0.36611031,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
1.34424417,0.432670734,0.624996174,0.22648418399999998,0.0,0.0,0.0,0.37187094299999995,1.76893972,2.45915524,2.92868439,3.51371639,3.07301206,2.42554908,0.466241333,0.0,1.03050651,0.0,0.0,0.0,0.0,0.10943156300000001,0.554307774,0.607491679,0.0,0.0,0.98916707,0.161021449,0.0437739012,1.44224945,0.0,0.738806698,0.0,0.0,0.0,0.0646453074,0.0,0.266261097,0.0,0.495293673,0.18706301600000003,0.0,0.22937066399999997,0.745497339,0.0,1.10778333,0.0,0.477033029,0.0,0.0,0.49500886299999997,0.0,0.315451036,1.11061365,0.23289142899999998,0.608301701,0.12130709,1.01027459,0.205835094,0.316409762,0.0,0.0,0.0,0.026670395,0.0,0.0,0.0,0.0,0.782583027,0.0,0.0,0.44190397600000003,0.0,0.0,0.0,0.0409216597,0.0970732194,0.0609599366,0.0,0.0,0.483285139,0.0,0.0,0.0,1.28852387,0.401876511,0.0,0.0,0.2972037,0.6736594229999999,0.0963274495,0.503710445,0.0,0.00615560215,0.0,0.0,0.0,0.0,0.317052033,0.0279054352,0.0,0.458789538,0.831952107,0.0,1.05256111,1.28506945,0.482527485,0.0,0.49218939899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.255939304,0.0,0.0,0.0411368576,0.0,0.0,0.0,0.213090909,0.0,0.701288135,0.536993638,0.15765879900000002,0.498057552,0.29349863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.107107496,0.301513578,0.0,1.06772521,1.52441975,2.11143459,2.59222945,2.27739888,1.08520343,1.83014507,1.55512708,0.0,0.0803688399,0.0,0.0,0.150914045,0.0241653609,0.0,1.3862359,0.0,0.0,0.0,0.0,0.0191768109,0.597326884,1.16680479,0.294395085,0.773040693,0.11978032300000001,0.243015922,0.0,0.0291361708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.865025743,0.77690963,0.646751283,0.528758709,0.43494082700000003,0.343078769,0.22845090699999998,0.09360253730000001,0.0,0.0,0.0,0.00632354902,0.080139665,0.09939212369999999,0.048615369699999994,0.0,0.0,0.0,0.0,0.0717452595,0.116507753,0.0801752509,0.0,0.0,0.0,0.0,0.0637116278,0.161980554,0.177369202,0.106766253,0.007943682320000001,0.0,0.0208703435,0.168258383,0.33221877899999996,0.430548673,0.425615256,0.34858764299999995,0.276230815,0.275578147,0.35471909100000004,0.45494233700000003,0.49163669200000004,0.41704421799999997,0.2608699,0.117736094,0.0861545483,0.19854385800000002,0.39151429200000004,0.541708937,0.549021749,0.41436494799999996,0.257563843,0.255955661,0.5351460029999999,1.07759528,1.70878377,2.17608115,2.27871325,1.97393617,1.39662759,0.7807574429999999,0.330381302,0.117994686,0.07006230299999999,0.0442717283,0.0,0.0,0.0,0.0,0.4328059,1.09350547,1.68507542,1.9658865,1.83275141,1.3885040000000002,0.89733432,0.650822703,0.8194612040000001,1.37191472,2.10383341,2.75488141,3.14458907,3.2518591,3.20027168,3.16714395,3.27489125,3.52655393,3.8152445,3.99228355,3.94862118,3.66433694,3.20688446,2.69069747,2.22844821,1.89957808,1.7424905,1.75928102,1.91849621,2.15225527,2.35795845,2.41852218,2.24378489,1.81696,1.21839825,0.605377599,0.14982152,0.0,0.040618050600000004,0.276481419,0.510526209,0.613059508,0.542136486,0.350733877,0.14324225,0.010504237,0.0,0.0234282071,0.0669937431,0.0640167567,0.0119326695,0.0,0.0,0.0,0.011799323700000001,0.06422170370000001,0.0706697271,0.028278638199999998,0.0,0.0,0.0,0.0,0.0449958084,0.0622523986,0.0359653702,0.0,0.0,0.0,0.00421057599,0.054111804000000006,0.075614759,0.0532656533,0.00165097209,0.0,0.0,0.0,0.014571631000000002,0.0443249159,0.040047936,0.0101426729,0.0,0.0,0.0393780029,0.10215887,0.140299113,0.12379313800000001,0.0539146278,0.0,0.0,0.0,0.0,0.0801389632,0.176358302,0.236202369,0.255825432,0.252018446,0.244695026,0.24045914399999999,0.229070965,0.19455697100000002,0.131801929,0.0554865789,0.0,0.0,0.0,0.0331519173,0.0638795851,0.0599944687,0.0221370281,0.0,0.0,0.0,0.0,0.0363527626,0.050570903,0.0295724883,0.0,0.0,0.0,0.0,0.0248620548,0.0474787062,0.0369472646,0.000620922231,0.0,0.0,0.0,0.0154110173,0.0529454687,0.0643555692,0.046427830499999996,0.014415031399999998,0.0,0.0,0.0010859363099999999,0.0174121241,0.0211901715,0.00976014817,0.0,0.0,0.0,0.0204090769,0.0356026812,0.0332305287,0.015608074599999999,0.0,0.0,0.023824674900000002,0.0595718693,0.0836831884,0.07883207769999999,0.04619861,0.005260804889999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0601022601,0.230054471,0.437715599,0.5963758020000001,0.620109928,0.47460652,0.206109303,0.0,0.0,0.0,0.0370099442,0.364224204,0.6645092260000001,0.840808697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
0.308423032,0.260153426,0.18052565199999998,0.0945037544,0.0251076543,0.0,0.0,0.0,0.0,4.91429303e-05,0.0,0.0,0.0,0.0,0.00889798652,0.0311364713,0.0431932937,0.034829071,0.00486511535,0.0,0.0,0.0,0.0,0.0276422032,0.11868779800000001,0.20501848,0.26228028600000003,0.276447638,0.248814692,0.194448753,0.134909585,0.08865243769999999,0.0635649985,0.055029923099999996,0.0502293504,0.0363726591,0.008592830479999999,0.0,0.0,0.0,0.0,0.0110407424,0.05871356900000001,0.08408350380000001,0.07105118099999999,0.020667669399999998,0.0,0.0,0.0,0.0,0.0143675333,0.101980809,0.151338948,0.132524544,0.0448310596,0.0,0.0,0.0,0.0,0.0168027432,0.19486846300000002,0.309936525,0.290611346,0.11547457900000001,0.0,0.0,0.0,0.0,0.158584799,0.983589556,1.95362869,2.8467796,3.43691841,3.56354955,3.18393796,2.38940971,1.379788,0.40426133299999994,0.0,0.0,0.0,0.0,0.461478144,0.995127723,1.34421385,1.43827484,1.29157995,0.98327993,0.620585698,0.29996130600000004,0.0797503577,0.0,0.0,0.0,0.0,0.000779146158,0.0,0.0,0.0,0.0,0.00899243723,0.0353613806,0.0471533917,0.036771521200000004,0.00768625061,0.0,0.0,0.0,0.0,0.0101081182,0.0460930982,0.0625314902,0.050221631100000004,0.0129335675,0.0,0.0,0.0,0.0295983122,0.167173664,0.352293034,0.555312467,0.73858807,0.8655643940000001,0.909900478,0.86229263,0.73318377,0.55050609,0.35282868100000003,0.179536583,0.060633136399999996,0.00909459063,0.0181807852,0.0647309662,0.11758581,0.14848274,0.141754014,0.09939680710000001,0.0396218269,0.0,0.0,0.004300013839999999,0.0773652539,0.171603318,0.25758532300000003,0.308204812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.0584680792,0.0668885971,0.13709903699999998,0.261128596,0.345222708,0.281562302,0.0883249602,0.0,0.0,0.0793759696,0.190783996,0.16007263,0.0466183204,0.0,0.0045252691799999994,0.0403503604,0.0197730797,0.0,0.0,0.00662369618,0.0379520543,0.0157326745,0.0,0.0,0.00629237657,0.0279299044,0.0100373963,0.0,0.0,0.00433861767,0.014939341100000001,0.00461992516,0.0,0.0,0.0114385582,0.131805142,0.411652931,0.7935018340000001,1.04638951,0.9465056820000001,0.566846228,0.329308196,0.655233796,1.51456035,2.37347736,2.66477954,2.32604045,1.83913647,1.72562559,2.03308071,2.33592548,2.20266076,1.6084227,0.8970976420000001,0.41270390799999995,0.222373176,0.166927231,0.096948793,0.014683472099999999,0.0158558068,0.143474202,0.310394983,0.352752734,0.17344726,0.0,0.0,0.0,0.5856602320000001,1.17036626,1.28677173,0.841999917,0.196174497,0.0,0.0,0.104605272,0.15536333900000002,0.0,0.0,0.0,0.0784575082,0.113442625,0.0,0.0,0.0,0.06896116669999999,0.09480056880000001,0.0,0.0,0.0,0.0632353516,0.0812026557,0.0,0.0,0.0,0.0528603862,0.059867228099999996,0.0,0.0,0.0,0.00191346527,0.0,0.0294145497,0.369972377,0.838845216,0.995001837,0.568704532,0.0,0.0,0.0,0.398469581,0.512057266,0.0412775626,0.0,0.0,1.05905318,2.06799959,2.16773326,1.33860998,0.33414684699999997,0.0,0.26825758899999996,0.901890851,1.29745625,1.24419336,0.856485638,0.366919934,0.0,0.0,0.0,0.211254533,0.35879906,0.300063482,0.123528159,0.00458020245,0.023235035299999998,0.122574685,0.220680448,0.29585525,0.343107695,0.31426903100000003,0.17362550699999998,0.0,0.0,0.0,0.0824443589,0.049768375499999996,0.0,0.0810809777,0.476817844,0.9409719409999999,1.1328790000000002,0.943285967,0.583925203,0.317367593,0.18549308,0.0666458521,0.0,0.0,0.00895869979,0.146950049,0.155921543,0.146702966,0.39477029700000005,0.921575632,1.31496603,1.14110006,0.517430399,0.0907952848,0.340349165,1.02163279,1.48740548,1.54292391,1.74473761,2.66930779,3.9944464,4.5991291,3.72883281,1.9336991999999997,0.63364779,0.7109081009999999,1.66619367,2.24218569,1.76407204,0.7116229959999999,0.015385040400000001,0.0199044816,0.28464663,0.275637594,0.0,0.0,0.0,0.149673731,0.136267127,0.0,0.0,0.0,0.123453834,0.10620022400000001,0.0,0.0,0.0,0.111245266,0.09439052740000001,0.0,0.0,0.0,0.254726847,0.600928799,0.975578889,1.39526585,1.80254843,2.05843312,2.07805013,1.91407726,1.66365155,1.33473867,0.874813706,0.33163093899999996,0.0,0.0,0.0,0.24927721600000002,0.36101645200000004,0.29793656,0.175654468,0.0918463918,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
1.01631097,0.0,2.04403756,0.0,0.54269385,1.32795948,0.0,0.25528619,1.47088563,0.0,0.0,0.75508618,0.66899381,0.0,0.0,0.14082047,0.0,2.24084987,0.25777927,0.0,0.32513427,0.0,0.45861409,0.65886311,1.34943361,1.05900368,0.31489073,0.0,0.88818779,1.01817856,0.0,0.0,0.0,1.48158532,0.20536729999999997,0.26349386,1.18448237,0.0,0.0,0.21998982,0.0,1.16734958,1.3917453000000002,0.421021,0.0,0.0,0.0,0.0,1.48582036,0.0,0.0,0.0,0.46718389,0.0,0.44404904,2.78474902,1.34392203,2.52526327,3.37754748,2.15209578,0.85350977,0.0,0.0,1.09741569,1.82272992,0.0,1.47142126,2.5717239,4.25139169,7.44987017,4.66373925,3.60800572,1.79080491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
2.22936158,2.06790072,1.93830536,1.75745832,2.16736316,1.75768003,1.34594,1.36928818,1.43712744,1.29692806,1.08802572,1.22612904,0.751182577,0.572021774,0.614455078,0.544402408,0.5331093339999999,0.5129413970000001,0.202053258,0.0,0.0,0.0506835936,0.0194149998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.142020861,0.0877505423,0.0543852783,0.226901475,0.21152444,0.0301197488,0.21724046100000002,0.0,0.0773744474,0.20289313899999997,0.114657113,0.0,0.018634835500000002,0.0752254442,0.411989293,0.15608443,0.0019310017899999998,0.35405067100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.20516228,0.0,0.0173657756,0.0,0.217311248,0.0180614066,0.0,0.0,0.0,0.20131020300000002,0.0,0.0,0.0,0.0101989443,0.0,0.135154028,0.0,0.0549134182,0.0,0.0,0.0,0.09244527050000001,0.21259785399999998,0.0,0.233742728,0.0965303267,0.12475692,0.284695666,0.0630441376,0.199543949,0.0693314787,0.256477348,0.18812860399999998,0.0,0.0,0.255105243,0.0,0.0,0.130255293,0.0,0.0,0.0,0.0,0.194827635,0.0,0.0,0.0,0.0,0.18473730600000002,0.013863054199999999,0.0,0.0,0.0,0.034975270600000004,0.265734016,0.0,0.25325482,0.22830001,0.0301458998,0.219416947,0.132097456,0.0,0.15983583099999998,0.0,0.0254139556,0.164360413,0.18061164,0.0,0.0,0.0723785254,0.29476933899999996,0.309313664,0.21001297800000002,0.0,0.0909906573,0.0,0.245447539,0.294750672,0.0713038205,0.0,0.134825141,0.0430693937,0.529751785,0.24428073600000003,0.167557823,0.12608324699999998,0.57716314,0.609843376,0.431302268,0.589863955,0.67948274,0.8722583290000001,0.82397958,0.749116943,0.894411601,1.22382818,1.41243616,1.10408322,1.36525646,1.50424648,1.48576295,1.71734431,2.10277587,1.95247333,2.01804666,2.26058563,2.57230457,2.43281316,2.50584864,2.5056301,2.88301676,2.54476239,2.88209871,2.72597825,2.84218588,3.04992003,3.16872451,2.75116165,3.06203776,2.70605832,3.02010619,2.99338748,2.65915571,2.65724417,2.73911194,2.64032457,2.30395168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
1.40027026,0.0,2.0306409,3.31544539,0.0,0.610456842,0.0,0.298318106,2.50103675,1.64688365,0.0,0.0,0.840342032,0.0,0.42072982299999995,0.0,0.0,0.0,0.0,0.9136395690000001,1.04675812,0.0,0.13271557,0.0,2.42676157,1.69739935,0.0,0.0,1.49544145,1.0237653,0.0,0.867210403,0.8997393159999999,0.0,0.0,0.53533772,0.0,0.0,0.0,0.105620465,0.0,1.55432727,0.0,2.50477071,1.87204623,3.10556147,4.16014178,6.08642161,5.84996279,4.90966876,5.83478507,4.10036559,1.03983431,2.99863803,1.21831332,0.824944184,0.0,2.3031598,0.0,1.30470366,0.0,0.404824798,0.0,0.0,2.05645102,0.387366744,0.0,0.6361124779999999,0.892909389,0.0,0.0,0.0,1.13769101,0.0,0.571507187,2.09347656,0.261969645,0.0,0.394345359,0.0,0.0,3.3631946000000004,0.0,0.0,0.0319698765,0.0,1.23284334,0.0,1.02634016,0.0,1.07597292,0.0,0.0,0.0,0.0,1.22358014,0.119435715,0.573949898,0.972751688,0.655728299,2.36631295,0.53952461,0.7090646420000001,0.256306212,0.144684175,0.0,0.0834892524,3.30055352,0.0,0.0,1.07727628,0.0,2.18173853,0.0,0.0,1.25196754,0.0,0.0,0.826590235,0.10691059800000001,1.35909415,0.9799635879999999,0.21094554100000001,1.58596446,0.0,0.354192956,0.0,3.65263323,1.23787094,0.0,0.0,1.15410916,0.0,3.68048964,0.0,2.08950575,2.77122278,1.82773045,1.49369609,0.431882968,0.0,0.0,1.63623374,0.0,0.0,1.20919155,0.0,0.0442273015,0.0,1.48800062,0.0,0.0,3.11405405,0.0,1.32482864,0.0,1.30863668,0.0,0.0,1.76110718,0.0,0.0261187796,0.128074504,0.0,0.0,0.0,0.622180113,0.0,0.0,0.0,0.0,1.04382861,0.0,0.423679366,0.0392681273,0.0,0.641650052,1.22037661,0.117079197,0.0,0.0,0.0,0.25726001,0.0,0.0767505939,0.0,0.0988349097,0.465443984,0.0,0.20555369,0.0,0.0,1.10890107,0.7668731040000001,0.0,1.49159805,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
0.047152140700000005,0.0,0.14917651199999998,0.371469606,0.0,0.0,0.815055978,1.38450959,0.660909951,0.0,0.0,0.0,0.0,0.0620700825,0.048165123,0.0,0.0,0.120738032,0.0,0.0,0.0727883132,0.0898697772,0.0,0.0,0.118945403,0.0033721954799999995,0.0,0.0342920433,0.0761245746,0.0,0.0,0.00844909158,0.0444342044,0.504134194,0.956935911,0.539936073,0.113852891,0.9488242309999999,1.72716092,0.7456357240000001,0.0,0.376755028,1.45010092,0.847542518,0.0,0.14908617,0.247102705,0.0,0.0,0.412148329,0.0256491127,0.0,0.152434434,0.450172915,0.0,0.0,0.537660457,0.205622783,0.0,0.0449991009,0.8392213690000001,0.0,0.0,0.966944603,0.9819210420000001,0.0,0.0,6.23755172,9.66374181,4.88215048,0.0,0.0,0.639168849,0.242969059,0.029985403100000002,0.911624691,0.827494658,0.24139189100000003,0.7218923009999999,0.805972713,0.0,1.06272464,3.97178218,4.24320411,1.38556838,0.0,0.831160645,1.07670759,0.343118696,0.65937734,1.1293926,0.16984608699999998,0.0,0.07695491480000001,0.45969018,0.0,0.0,0.292360793,0.15420893,0.0,0.301575881,0.625127667,0.0,0.0,0.229400627,0.25453377,0.0,0.0,0.451741306,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
1.37588451,0.733058784,0.83450363,0.920063448,0.0,0.18806931899999998,0.0,1.17841101,0.0802500538,0.78931587,1.44444129,0.0,0.0,0.0,0.472711326,0.429002948,0.0,0.0805875336,0.0,0.008571393520000001,0.368764766,0.664969819,0.0,0.661067647,0.248504872,0.0,0.0,0.7416190859999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.339648946,0.0,0.156413476,0.0,0.0,0.682218447,0.0,0.215883367,0.152847831,0.0803587277,0.0,0.311861585,0.156791505,0.0,0.694553875,0.0,0.0,0.0,0.0,0.0789044638,0.5580256579999999,0.541743133,0.636770432,0.157433131,0.0390560258,0.730529322,0.0,0.241934979,0.0,0.0,0.0,0.29815342300000003,0.06938412299999999,0.190264691,0.32010073899999997,0.361844414,0.800304809,1.29031731,1.22201596,2.42184843,3.58282091,3.07994207,3.04541399,3.62937628,1.36771324,1.47896441,1.27446165,1.69252337,0.0,0.949925729,1.37780834,0.805531894,0.321063709,0.5685445579999999,0.0,0.0,0.327869239,0.999478083,2.03079672,2.09496518,2.19830304,0.211013929,0.532911186,0.059310634699999996,0.46046828,0.0,0.855964038,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.28637381,9.16908403,9.53546088,14.01224338,1.49005721,4.5007434,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.133153028,0.0,0.0,0.0,0.0,0.738246898,1.70624384,1.8877238999999997,0.464143101,0.0,0.0,0.0,0.118051658,0.04341592230000001,0.0,0.21451220899999998,0.39785012399999997,0.0,0.159521889,0.49129027299999994,1.71869956,4.54336022,4.72789372,0.119630131,0.0,0.19384104,0.0,0.08527210980000001,0.0,0.0,0.0,0.0,0.281124252,0.0,0.0291742273,0.00465613321,0.0,0.556412361,0.0,0.159781278,0.0,0.221151302,0.0,0.0,0.0,0.041833516099999996,0.0,0.0,0.07440269669999999,0.23944119600000002,0.0,0.46797927100000003,0.323828739,0.874945677,0.475542843,0.938062815,0.40101793700000005,0.0,0.205612548,0.0,0.0,0.7365537240000001,0.0,0.43591338700000004,0.142783732,0.460425784,0.0,0.0,0.0,0.116367946,0.180139931,0.0,0.0682162776,0.42494154700000003,0.182907102,0.0,0.401427834,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
1.03804596,2.61936463,0.931443633,1.94939509,0.0,0.421122991,0.0,0.0757611432,0.0,0.299804108,0.0,0.47236070399999996,1.36316567,0.44336958200000004,0.0939640622,0.644042484,0.0,0.23135338,0.978382882,0.272520887,0.43028394799999997,1.02277091,0.0,0.546537401,0.0,0.0,0.0,0.277533714,0.0,0.0,0.0,0.714391413,0.24445386300000002,0.0,0.9448373290000001,0.0,0.6532466570000001,0.0,0.0,0.8099261940000001,0.0,0.0,0.391493806,0.0,1.96800458,1.52547715,1.23791202,2.34661538,1.81919944,1.51628879,0.911808353,2.22562568,2.42556173,1.11581139,0.241323578,0.6966755790000001,0.23295465,0.0,0.0,0.0,0.9239080040000001,0.42453211399999996,1.38951771,0.124074263,0.500854853,0.323543202,0.0015612172,0.322179148,0.0,0.847034228,0.0,0.638105905,0.17998486800000002,0.0,0.0,1.05305374,0.301276174,0.21205831,0.0,0.0,0.590372004,0.0,0.08869798949999999,0.0,0.102180803,0.0,0.250897013,0.0,1.78659261,0.0,0.0,0.0,0.008098864,0.460083358,0.278525929,0.0,0.09248933470000001,0.0,0.0,0.729084148,0.0,0.0,3.12771361,3.12925514,3.925307,3.86291038,1.99592752,0.457092967,0.44837821,0.0184401577,0.0,0.0,0.0,0.30990422,0.0,0.0,0.0,0.0,1.2758976,0.11380692699999999,0.0,0.7225113040000001,0.674259605,0.8401152470000001,1.19498429,0.0,0.0,0.0,0.40330836700000006,0.0247075975,0.0,0.0,0.042528333700000004,0.0,0.0,0.0,0.0,0.0,0.763298721,0.0,0.0,0.670879715,0.380739977,0.0,0.0,0.228558757,0.0708895846,0.0,0.0,0.103215057,0.0,0.0,0.0,1.39686667,0.0,0.0,0.671581248,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.266184199,0.641664566,1.0153457000000001,1.22577797,1.19578776,0.985718784,0.7617189520000001,0.694246742,0.848828275,1.13910945,1.37447228,1.37448471,1.07924393,0.586830428,0.09548355630000001,0.0,0.0,0.0,0.029039380099999998,0.108868547,0.0785886006,0.011877941999999999,0.0132847254,0.134157157,0.33051686399999997,0.490278124,0.508854111,0.360192443,0.11537185300000001,0.0,0.0,0.0,0.0,0.106518841,0.128363697,0.0604079363,0.0,0.0,0.0,0.0,0.0556898088,0.0767712606,0.0425474667,0.0,0.0,0.0,0.0,0.030726134300000003,0.050352980199999994,0.03763629,0.0077415478,0.0,0.0,0.0,0.00832036494,0.0133593664,0.007779277309999999,0.0,0.0,0.0,0.0014341696900000002,0.0,0.0,0.0,0.0,0.0157472993,0.0250666669,0.015153089599999999,0.0,0.0,0.0,0.048985938099999994,0.11842678400000001,0.148161328,0.0954176909,0.0,0.0,0.0,0.0,0.26609531399999997,0.775313418,1.28891554,1.63824922,1.70233259,1.45791703,0.9893089540000001,0.457206017,0.0421835838,0.0,0.0380263141,0.451296552,0.979126789,1.42754221,1.62221389,1.48004462,1.05310378,0.5170766210000001,0.097735746,0.0,0.1282675,0.44623853,0.67326301,0.610194996,0.228256751,0.0,0.0,0.0,0.269111527,1.46643401,2.7783667999999997,3.81867617,4.31860857,4.2175135,3.64299903,2.81045583,1.91404949,1.07388522,0.35549336200000003,0.0,0.0,0.0,0.176654455,0.914772551,1.64432528,2.08118271,2.04769167,1.5665891,0.853453655,0.206603023,0.0,0.0,0.0774786295,0.313386449,0.393818419,0.279968045,0.0608086006,0.0,0.0,0.0,0.0189426378,0.0992927831,0.093437614,0.028140019199999998,0.0,0.0,0.023873101,0.0953803558,0.129134805,0.10259809199999999,0.035945336800000005,0.0,0.0,0.0,0.0,0.0194104063,0.018906290200000002,0.00623446495,0.0,0.0025359895300000003,0.00859896068,0.0029989023,0.0,0.0,0.0,0.010156671800000001,0.050851363,0.061439861500000005,0.0215956431,0.0,0.0,0.0,0.0149979348,0.14533870599999998,0.226037982,0.202166793,0.09381438539999999,0.0,0.0351047664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.153686128,0.0,0.0,0.161943538,0.497359693,0.0403410025,0.41823949200000005,0.035336843199999995,0.0,0.119300542,0.0,0.054560272300000004,0.17433972399999997,0.022133941600000002,0.0,0.116074568,0.0,0.0,0.0,0.095611832,0.0,0.36004388200000004,0.0,0.408688283,0.354692341,0.560555734,0.600505595,0.436916356,0.407957214,0.0,0.151487827,0.0,0.0727934151,0.16104042,0.173485962,0.0,0.0,0.18664122100000002,0.0,0.18760259399999998,0.0,0.0,0.0,0.0,0.10052731599999999,0.0,0.0,0.0,0.287884502,0.229565415,0.0,0.0206661631,0.212247778,0.0,0.0986414744,0.0809998743,0.0,0.24561189600000002,0.0,0.193129575,0.0,0.281709715,0.181405764,0.1666019,0.155653774,0.0923892427,0.0,0.0407728245,0.0351850182,0.0184567715,0.0,0.0,0.0,0.244427874,0.05587599769999999,0.00238851083,0.197001855,0.0,0.19272066100000002,0.0,0.165593465,0.0,0.0,0.0030386424300000003,0.114160006,0.0604272462,0.0,0.0,0.0,0.0,0.259744837,0.0,0.0,0.180697512,0.0,0.0,0.0,0.195571164,0.0,0.0766735082,0.135008224,0.25525037300000003,0.512951744,0.350876045,0.784894531,0.838804615,1.3523355,1.68972223,1.98309035,2.48520638,2.56678991,2.55274531,3.10829614,2.85948633,2.99128759,2.9564228,2.43696034,1.98897135,1.35312745,1.17142228,0.79880698,0.8259029840000001,0.374429995,0.268465721,0.12064301599999999,0.435723264,0.321121909,0.18967578100000002,0.208144663,0.33439472600000003,0.0,0.12055459,0.0,0.0,0.0,0.19333382600000001,0.0,0.0,0.0,0.0,0.19907901,0.0,0.0,0.212093239,0.08495706230000001,0.043620747300000005,0.0,0.0,0.356473059,0.290566825,0.39331555100000004,0.122489374,0.35465722299999997,0.145141126,0.30074338899999997,0.0,0.0,0.06662041980000001,0.164014102,0.162805222,0.054315636900000006,0.124344378,0.0942819199,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
4.34873935,4.32599647,4.24725585,4.11449651,3.93095638,3.70103866,3.43018651,3.12472958,2.79170736,2.43867438,2.07349332,1.70412212,1.33840134,0.98384816,0.647462844,0.335553293,0.053582624100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0864494092,0.207445452,0.314603256,0.404724112,0.47538809600000004,0.524997916,0.552794365,0.558843698,0.5439981220000001,0.509831473,0.458552936,0.39290231600000003,0.316030898,0.231372343,0.142508293,0.0530334067,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0528289892,0.118251766,0.17848674899999997,0.23123503399999998,0.27453739899999996,0.306841523,0.327052601,0.33456581,0.32927976600000003,0.311590808,0.28236868600000004,0.24291485300000001,0.194905219,0.14031975900000002,0.0813617953,0.0203701449,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.053946887199999995,0.10521481099999999,0.15181361599999998,0.19195358699999998,0.224112791,0.247093612,0.26006641399999997,0.262598772,0.25466925,0.236665312,0.20936553800000002,0.17390693100000001,0.13173863,0.0845638844,0.034272554,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.033593708300000004,0.0826865445,0.128495495,0.169200326,0.203180477,0.229078804,0.24585520000000002,0.252827972,0.24970138,0.236578199,0.213956788,0.182712715,0.144065584,0.099532281,0.050868392400000004,3.36450909e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0176466326,0.069894415,0.11944478800000001,0.164253453,0.202457179,0.232454248,0.25297606300000003,0.263146991,0.26252988,0.251155175,0.229532175,0.198641586,0.159909227,0.11516146099999999,0.06656360110000001,0.0165432199,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0372984593,0.123136177,0.220481134,0.32671589100000004,0.438740302,0.55306267,0.6659085060000001,0.7733436379999999,0.871407788,0.9562543059999999,1.02429142,1.07232016,1.09766415,1.09828658,1.07289,1.02099503,0.942994737,0.8401821690000001,0.714749216,0.569756143,0.40907187100000003,0.23728613399999998,0.059595585300000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21285068899999998,0.524633858,0.863155181,1.22181123,1.59330742,1.96984257,2.34331021,2.70551098,3.04836986,3.36415194,3.64567038,3.88648033,4.08105331,4.22492655,4.31482314,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.0210263832,0.0,0.0,0.0294369365,2.95626974,6.08579185,7.69565626,6.90364959,4.28546228,1.4045623999999999,0.0,0.0,0.0,0.46696462299999997,0.390625819,0.0,0.0,0.0,2.98802877e-16,0.0800719034,0.0267068501,0.0,0.0787456127,0.13209300699999998,0.0,0.0,0.0,0.117747746,0.647100989,0.7295279790000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.387119359,0.6827802759999999,1.09136629,0.7666030159999999,0.0,0.0,0.0857331068,0.23893359100000003,0.0,0.0,0.0,0.0,0.46418294600000004,0.0,0.023266618,0.251653258,0.26443468800000003,0.474313857,0.117432673,0.7083928429999999,0.29441333399999997,0.528243679,0.611020076,0.0,0.0,0.834783672,2.26721891,2.4782505,1.92624994,0.33887533700000005,0.0,0.388891937,0.8381647190000001,0.500703594,0.359784775,0.0,0.41897893799999997,1.06797044,1.81631237,2.36616236,1.81635082,1.20583769,0.616010237,0.29330842100000004,0.359077706,0.0,0.120193106,0.0,0.582425969,0.666858817,0.12001084599999999,0.0,0.547527781,0.8432332359999999,0.7212756240000001,0.5277585770000001,0.19291723,0.0,0.0992512383,0.32300260199999997,0.0,0.26951922899999997,0.0,0.106437117,0.291565681,0.208213371,0.0,0.0,0.0,0.0,0.0,0.47381454700000003,0.5752151560000001,0.332188908,0.331503871,0.23087170699999998,0.791482811,1.28104478,1.22714051,1.7876896,3.61046566,3.99101998,4.77886403,3.98610732,3.19473233,2.49791547,2.41077141,2.25824096,2.23085366,1.31064705,1.25768625,0.583087545,0.21976129600000002,0.08412405380000001,0.0,0.21207278100000002,0.0,0.509634399,0.0,0.0,0.0,0.289630572,0.0548861236,0.618775465,0.275620073,0.0,0.0877765562,0.189164387,0.0,0.08316332559999999,0.0762126555,0.183833495,0.0,0.0,0.35744808200000006,0.113143118,0.016358695700000002,0.0,0.38150391100000003,0.176368055,0.0,0.0,0.0,0.219149526,0.13519525599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.38070879399999996,0.0,0.0,0.0720901323,0.38864023,0.235974412,0.15279053199999998,0.0,0.0,1.75863719,3.23718364,2.9636961,1.11892528,0.0,1.10111332,2.72640289,3.42282793,1.18022174,0.237006386,0.29773050100000004,2.51631359,3.90968133,4.50156395,3.50263595,2.99624076,1.9912140999999999,1.02984508,0.27712750399999997,0.07284952459999999,0.143842079,0.685146665,0.0,0.177163452,0.0,0.0,0.013308163500000001,0.0,0.266681503,0.171908975,0.0,0.0,0.0,0.0,0.17549193899999999,0.299570763,0.0,0.18251427,0.281421965,0.215740442,0.0,0.39756772799999995,0.0,0.117779664,0.0,0.0,0.246940938,0.0,0.0,0.0990100292,0.180327065,0.0,0.26828527,0.19366728600000002,0.361704814,0.31312202100000003,0.0,0.5314468960000001,0.0,0.603959237,0.0397045544,0.0,0.0,0.489549375,0.843487243,1.44532362,2.2480011,2.12303908,1.00711156,0.17286480199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
0.47164172,0.50312029,0.54342167,0.58024338,0.59716508,0.57773255,0.50998882,0.39055327,0.22739954,0.0406867,0.0,0.0,0.0,0.0,0.0,0.33566952,0.84752837,1.47140445,2.15951962,2.85171228,3.48243996,3.98884767,4.31875667,4.43741786,4.33204287,4.01344858,3.51457718,2.88611713,2.18987763,1.49089379,0.8494109000000001,0.31388915,0.0,0.0,0.0,0.0,0.0,0.0,0.01762234,0.17560765,0.29989985,0.38278886,0.42725443,0.44420446,0.44845864,0.45432227,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.401
0.101567326,0.34460711299999996,0.319213455,0.0,0.0,0.37497086399999996,0.30104448300000003,0.0,0.0,0.333268407,0.151013319,0.0,0.0,0.201100477,0.5359250520000001,0.0,0.0407402877,0.206721825,0.37077759200000004,0.0,0.329738608,0.50961536,0.0,0.0,0.0,0.139959257,0.54835625,0.541967689,0.0,0.0,0.267206532,0.333329778,0.035496892,0.09873305310000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23330039100000002,0.16635449800000002,0.451096228,0.0,0.0,0.0,0.5830295670000001,0.367049977,0.0,0.0,0.0,0.0,0.041619685,0.30961924399999996,1.35633111,2.11281797,2.07891688,1.395529,1.47657255,0.728125513,1.81094355,1.95344654,3.26018082,4.99290843,5.09645319,4.41690279,2.91621939,1.89195537,0.11870691400000001,0.0702543375,0.0,0.282372372,0.0,0.0,0.277323382,0.287023801,0.136292332,0.0,1.2308587,1.86935028,3.30046053,3.65021125,3.95109899,4.10191024,3.52516469,2.99127604,2.17522575,1.4355441,0.0,0.164975669,0.208543115,0.14492501,0.860620822,0.283613096,0.431871767,0.556370413,0.0,0.0,0.160765658,0.0,0.43909880100000004,0.374034222,0.0,0.010873448300000001,0.0,0.524049336,0.0,0.300281376,0.36474192200000005,0.41561402399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.401
0.0395350324,0.236078118,0.41179669700000004,0.558571888,0.670387438,0.7435179340000001,0.776590517,0.770521287,0.728334186,0.6548762020000001,0.556447887,0.440372187,0.314527232,0.186869948,0.0649769997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0361166097,0.111237122,0.178916479,0.23450015899999999,0.27429439699999997,0.29576938199999997,0.297684696,0.280131422,0.24449046100000002,0.19331162699999999,0.130122755,0.059182056799999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.064412625,0.128833007,0.184484423,0.22783988100000002,0.256180402,0.26776249,0.261923185,0.239116517,0.200879476,0.149729952,0.0890033304,0.0226381729,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0273739149,0.0941453956,0.15509716199999998,0.20625223199999998,0.244241937,0.266524959,0.27155550100000003,0.258889685,0.229223022,0.184356025,0.127089495,0.061055344000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.007423413890000001,0.0863447016,0.161623018,0.228224733,0.281578461,0.31788789,0.334405102,0.329646591,0.30353723899999996,0.257471534,0.19428601199999998,0.118142125,0.0343240258,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0702319186,0.23374665,0.42002928700000003,0.6221412,0.832022239,1.04090226,1.23976735,1.41985621,1.57315971,1.69289587,1.77393311,1.81313679,1.80961755,1.76486508,1.68275649,1.56943528,1.43306363,1.28345797,1.13162375,0.989211818,0.86792284,0.778889962,0.732071523,0.735685789,0.7957181059999999,0.915527627,1.09557613,1.33329545,1.62310306,1.95656818,2.32272251,2.70850284,3.09930534,3.47962582,3.83375519,4.14649672,4.40386984,4.59376587,4.70652323,4.73539348,4.67687478,4.53089618,4.30084315,3.9934231,3.61837722,3.18805278,2.71685701,2.22061928,1.71589286,1.21923032,0.746467716,0.312051915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
3.5361987,4.96968034,5.99918974,6.265543599999999,5.65086253,4.3306635,2.70134576,1.21743577,0.21472337100000002,0.0,0.0,0.0905578684,0.284146163,0.28884137600000004,0.120944161,0.0,0.0,0.0,0.0,0.092372629,0.184149335,0.157354843,0.0417810231,0.0,0.0,0.0,0.0,0.0759986491,0.117008672,0.0847213839,0.006475894100000001,0.0,0.0,0.0,0.00250965041,0.056150262199999995,0.0701148902,0.0413475206,0.0,0.0,0.0,0.0,0.00925542824,0.0330617494,0.0333282376,0.0145497641,0.0,0.0,0.0,0.0,0.00431390015,0.00670134211,0.0030213236100000004,0.0,0.00201723433,0.00774629277,0.0101285521,0.00338640967,0.0,0.0,0.0,0.0,0.0224157702,0.0394747696,0.0326168343,0.0014963009900000003,0.0,0.0,0.0,0.00413126407,0.054598974800000005,0.0760135325,0.0496705042,0.0,0.0,0.0,0.0,0.0273186302,0.10209646300000001,0.11798946199999999,0.0579696096,0.0,0.0,0.0,0.0321211557,0.233884156,0.414983029,0.492486156,0.44328387,0.325356842,0.249725478,0.314781841,0.540047472,0.84172657,1.07213136,1.10857519,0.9448500259999999,0.729788855,0.720387028,1.16154874,2.14742114,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
5.89839354,0.21074824,0.0,0.80226949,0.0,1.55823375,0.0,10.34246372,9.90560247,1.71489528,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.23499206399999997,0.11843105,0.0,0.0,0.35287345200000003,0.0,0.0,0.536364544,0.36328916,0.0,0.0,0.0,0.0915229026,0.0,0.0,0.29170350300000003,0.015973421499999998,0.323687771,0.276948474,1.07849471,0.894588437,0.54962627,0.7399966379999999,0.0,0.0,0.405176814,1.96198983,2.03385136,3.34455124,3.31868491,3.28759358,3.41699425,2.63797354,2.92789512,1.78247855,0.73499401,0.313879936,0.0,0.0283440385,0.0,0.0,0.40296194700000004,0.138039846,0.41112023799999997,0.169168273,0.37558069,0.0,0.0,0.0,0.000758787362,0.0,0.617271906,0.555806433,0.521445574,0.0,0.0,0.0,0.0843401266,0.0,0.281530057,0.48059097799999995,0.183687553,0.0,0.0,0.452170022,0.0191350052,0.0,0.0,0.0,0.06706701030000001,0.272395,0.48778835600000003,0.40188193899999997,0.0,0.332544333,0.0,0.0,0.280139559,0.343588281,0.219430192,0.0851092648,0.684923554,0.616175379,0.20775378100000003,0.753206231,0.41952169899999997,0.0,0.0,0.0,0.0,0.0,0.27192499600000003,0.0643124098,0.283384391,0.0,0.0,0.32096748399999997,0.0,0.0,0.260032024,0.342100886,0.539877387,0.29734540000000004,0.0,0.38229303600000003,0.0191518498,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.1564194,0.0,0.404356025,0.138928721,0.0,0.290348945,0.545090045,0.9885773109999999,0.852030718,1.18947938,0.9238754309999999,0.6674029220000001,0.365015415,0.0,0.0,0.0,0.0140681744,0.940766377,2.88845985,4.02034574,4.71204187,5.09447631,4.69065531,4.05735987,2.48505682,1.37700595,0.561816628,0.00373677948,0.0,0.0,0.0,0.465091695,0.6819100309999999,0.922483446,0.776821282,1.20408444,0.171165575,0.32229388600000003,0.580869062,0.124002078,1.00305295,1.6061276000000002,1.42367869,0.798102105,0.47990035200000003,0.24092134,0.560051812,0.0,0.0,0.0,0.0,0.40084399200000004,0.0,0.613500622,0.36777171,0.23066682300000002,0.0,0.0,0.0,0.0784554692,0.0,0.426598705,0.363330135,0.0,0.577201307,0.0,0.0,0.0,0.0,0.153345551,0.0,0.115183399,0.123150106,0.580681004,0.42930725399999997,0.18403183399999998,0.365533582,0.0,0.0,0.0,0.285354321,0.0,0.391198747,0.11514031599999999,0.166002016,0.451680414,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
0.39770637200000003,0.0,0.0,0.0,3.94929271,3.55554526,3.87458791,0.787848117,0.0,0.0,1.45814488,0.0,0.285038627,0.0,0.312321848,0.0,0.0,0.147684697,0.0,0.0,0.0615993164,0.0,1.4783006,0.773493585,1.13329903,0.0,0.0,0.9729967409999999,0.0,1.4575583,0.0,0.0,0.354129165,0.0,0.0,1.22363579,0.129877019,0.0,0.252983941,0.0,0.0,0.0,0.657483759,1.11847422,0.176261397,0.301025816,0.0,0.604544483,0.0,0.0,0.0,1.39711398,0.0,0.0,0.207688385,0.0,1.20984656,0.0,0.0,0.0,0.0,0.343474499,0.0,0.847319736,0.0,0.0,0.0,0.0439608966,0.0,0.0111508021,0.0,0.75177221,0.0,1.01698831,0.0,0.00665486483,0.32062175800000003,0.0,0.19635109,0.0926839799,0.501718063,0.0,0.0,0.0,0.0,0.714908923,0.0,0.0,0.882471862,0.45981510700000006,0.0,0.0,1.48088888,0.6777773559999999,0.23661923399999998,0.48120331299999997,0.0,0.9751932459999999,0.0,0.11885823599999999,0.0059681590500000005,0.0992867706,1.38375745,3.21135884,1.47182243,0.34665592799999995,1.06302815,0.278580764,0.0,1.6203014999999998,2.32215715,0.0,0.536884525,0.421813932,0.0,0.95918441,0.0,0.923486143,0.23419762,0.754195981,0.5413774370000001,0.0,0.396402198,0.0,1.4301693000000002,0.0183245654,0.95746696,0.0,0.0,0.0,0.926524395,0.0,0.0,0.124906751,0.0805783986,0.6959083859999999,0.848750323,0.0,0.112338985,0.295950153,0.117048591,1.01831537,0.0,0.602339369,0.0,0.0,0.430971489,1.19162327,0.37328660700000005,0.20878460899999998,0.277775298,0.0,0.0,0.266586648,0.895622293,0.0,0.0,0.0355653229,0.0,0.0,0.0,0.0,0.0,0.189308111,0.0,0.0,0.0,0.0,0.0,0.277087447,0.0,0.0,0.22580564600000003,0.454571936,0.29652429,0.0724459779,0.5011268320000001,0.0,0.0338297313,0.8542005979999999,0.0,0.0,0.8849999909999999,1.25474704,1.11760803,1.87336323,1.34065832,0.0,0.0,0.718549632,0.668548559,0.0,0.6922777790000001,0.0,0.578685697,0.0,1.28172999,0.0,0.0,0.322997773,0.5574120370000001,1.8713573000000001,0.0,0.0,0.0,0.48990300700000006,1.1031482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.19934723399999998,0.051075733,0.0321513005,0.027538749300000002,0.858660814,0.755428945,0.0,0.0355948423,0.039211636800000005,0.0,0.0367068007,0.0,0.000407733222,0.0,0.037900905299999996,0.0,0.0,0.0762711615,0.0,0.0977141955,0.0,0.0,0.23620248100000002,0.0,0.08452613279999999,0.24829286899999997,0.0,0.622490926,0.0,0.0,5.05195138,5.23017193,0.0,0.0,0.9940782779999999,0.0,1.59907325,5.55729994,4.97108617,1.57532951,0.0,0.200248132,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.0435330781,0.300860631,0.0478808987,0.294701673,1.23631287,1.35244884,1.77409156,2.65089461,3.38684642,3.74624847,3.61745738,3.23938116,2.5936453999999998,2.51406596,1.95576671,0.942138391,1.03742137,0.99864707,0.8454616090000001,0.586941156,0.66784545,0.0962783398,0.22585745699999998,0.0,0.317423706,0.0285090845,0.531245639,0.33910088899999996,1.08932398,0.570965631,0.489228726,0.6019969510000001,0.162296569,0.0192756244,0.0,0.0,0.22903810100000002,0.0358343109,0.0,0.0,0.0,0.228994213,0.0225023665,0.113438289,0.382259698,0.2763645,0.361384262,0.0,0.0,0.24324769100000002,0.131041725,0.0,0.0,0.0,0.44702376200000005,0.47243066100000003,0.33382460199999997,1.21018119,1.11448426,1.57377524,1.10762388,1.47517094,0.9741922890000001,0.478477675,0.0,0.0,0.0,0.0,0.657782335,1.39445365,1.28598062,2.07179008,1.58481009,0.995524932,0.837689128,0.8514201570000001,1.15464453,1.37600331,1.70626367,2.48537402,3.38629764,3.48411661,3.60443558,2.89017808,2.89430158,2.23877073,1.65750405,1.04958258,0.764329334,0.76133986,0.47460961700000004,0.823492797,0.71939018,0.90610806,0.7958602370000001,0.306664667,0.35623488299999995,0.658553408,0.5820687370000001,0.132024203,0.0,0.11773810800000001,0.408576283,0.352719703,0.407562317,0.0,0.20851352199999998,0.0927217393,0.24746232,0.113410235,0.319203051,0.045353907699999994,0.0,0.0,0.23877195399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0435184653,0.0,0.0,0.0,0.20949114,0.0,0.166065717,0.326714753,0.0,0.0,0.049459051500000004,0.0,0.0,0.12103989,0.362150773,0.125511188,0.0,0.0,0.0,0.0,0.0,0.0,0.638488253,0.654253491,1.40791094,1.72515539,1.71846434,1.42682109,0.9941831320000001,0.45269014799999996,0.434261655,0.0,0.010056788,0.12264837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.0149314963,0.0,0.0,0.0,0.0,0.0,0.043611719900000005,0.0767907575,0.0925098484,0.09018915890000001,0.0731884447,0.0476283679,0.0208864286,2.8574798900000002e-05,0.0,0.0,0.0127818573,0.0410182501,0.0739356491,0.104780162,0.12691749,0.135098059,0.126479297,0.101228758,0.0626021247,0.0164770454,0.0,0.0,0.0,0.0,0.0,0.0,0.014356681699999999,0.0719168099,0.12542972,0.16510189,0.18274970899999998,0.173244268,0.135544685,0.0731354307,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10335017,0.212542237,0.29777840899999997,0.344299511,0.34206908,0.287608255,0.184986763,0.0457733278,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.123399935,0.36775418,0.594638005,0.774391259,0.882680007,0.9045793240000001,0.8377092629999999,0.69393215,0.49927823200000004,0.291977688,0.11871513199999999,0.029458164199999998,0.0714138278,0.282808638,0.687248566,1.28938404,2.07248215,2.99830579,4.00943986,5.03391843,5.99172783,6.80252437,7.3937407,7.70818454,7.71026763,7.39013969,6.76522692,5.8789622,4.796810099999999,3.59999782,2.37762511,1.21801196,0.200228348,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.250071789,0.602191238,0.835375326,0.9304585559999999,0.887681278,0.725124503,0.475094339,0.178991273,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.134224369,0.354016345,0.5209151710000001,0.613383029,0.620954217,0.5452553929999999,0.399351829,0.205563573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.153796173,0.308579759,0.415445776,0.460311068,0.438152673,0.35352204600000003,0.219715506,0.0567404122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0771900844,0.22531674399999999,0.33978760700000005,0.404387302,0.41012643200000004,0.356473805,0.25138838,0.110152915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0178408739,0.173842993,0.305961743,0.394879154,0.427272561,0.397764489,0.30977288,0.175133972,0.012539041899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.140294105,0.316189724,0.45300736700000005,0.529299004,0.531177438,0.45449503700000005,0.305800849,0.101929344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143285226,0.564870539,1.00905318,1.43840223,1.81676306,2.11308314,2.30458257,2.37891145,2.33506853,2.18301383,1.94206966,1.63834972,1.30156634,0.961627557,0.64544377,0.37431680100000003,0.162192256,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
1.77895206,1.18993454,0.9734315,4.69352868,2.63793689,2.15619058,4.55163432,0.74172398,0.44662421,3.6860964999999997,4.50002767,2.37458619,0.0,0.0,0.5565989,0.0,2.44900198,2.084382,0.82210898,0.08237647,1.46380208,0.0,1.15732109,0.69159092,1.92632032,0.66980734,0.0,0.43918729999999995,0.08319463,0.0,0.0,0.6837156,0.57684842,0.0,0.23110873,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.16616345300000002,1.15642628,0.335198082,1.51137791,0.839449245,0.306131615,0.43403700799999995,0.0,0.0,0.0,0.986762592,0.0,0.0,0.794481408,0.388298087,0.0,1.16697902,0.186330723,0.0,0.785431167,0.0,0.0,0.138998005,0.9470153570000001,0.23695523699999999,0.886759437,0.0,1.00669812,0.0,0.0,0.6906585709999999,0.389061999,0.0,0.0,0.0,0.0,0.0,0.0,0.713828385,0.8864399479999999,0.0,0.0,1.06728647,0.665775781,0.0,0.6515263570000001,0.58939205,0.0,0.538124226,1.68664295,0.0,0.0,0.522632085,0.118381037,0.0,0.0,0.0971877959,0.0,0.200545903,0.408991196,0.0,0.416602201,0.0,0.0,0.16124688199999998,0.128803154,0.571157786,1.10285087,0.0433012108,0.421344189,0.217681614,0.9992420059999999,0.0,0.476154523,0.0,0.0,0.7652727429999999,1.18014274,0.0,0.0,0.0,0.0,0.13148721,0.0,0.0,0.324416962,0.0,0.0,0.900937856,0.0,0.833351315,0.319985242,0.563140336,0.35242676799999995,0.0,0.20471231199999998,0.9289158679999999,0.0,0.404445315,0.5036935929999999,0.00187280549,1.47442036,0.0,0.0,0.0,0.353384948,0.0,0.719688201,0.0,0.0,0.907952641,0.319628601,0.0,0.0475539702,0.225296715,1.3359756,0.0,0.0,1.25706014,0.632157902,1.05187005,0.10010241199999999,0.0,0.0,0.988487571,0.0,0.0,0.0,0.0,0.0,0.0,0.33869818100000004,1.21862806,0.28045843,0.0,0.56892697,1.47035498,1.8510429,2.05758149,3.0469703999999997,2.19754811,3.0837561,2.34627204,3.4980198,1.88105944,1.99777752,3.4611991,2.5458244,1.61384545,1.2660025,1.59805271,0.317341001,0.0,0.0,0.0,0.7306925759999999,0.0,0.09168400939999999,0.0,0.0,0.0,0.0,0.0,0.0,0.09236337550000001,1.50600831,0.6525826020000001,1.09025178,1.17433217,0.0,0.0,0.270972885,0.602813653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.126893948,0.0,0.0,0.0,0.0,0.201230252,1.07347688,0.17150153199999998,0.412789805,0.547948459,0.8691608540000001,0.0,1.31649524,0.0,0.391560917,0.0,0.0,0.8236813829999999,0.0,0.0,1.31281754,0.0,0.0,0.59865892,1.06212279,0.32083196,0.0,0.0,0.0,0.0,0.0,0.433311987,0.0,0.752144647,0.0,0.0,0.438287936,0.0,0.0,0.0370709104,0.194107755,0.0,0.0,1.1170636999999999,0.995063107,0.061991286500000006,0.9957573940000001,1.14256769,0.646350226,0.0,0.0,0.12790844199999998,1.47111062,0.695964481,0.12300077699999999,0.935194847,0.0,0.669387773,0.8852007279999999,0.0273929838,0.0,0.0,0.0,0.0,0.0629202943,0.971664064,0.07609230730000001,0.0,1.18910182,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
2.20798115,1.31750243,0.0,0.29724586,2.19268358,3.15147802,2.57725028,1.27674256,1.75274761,1.85109614,0.62927027,1.45829377,4.28059914,4.73864682,3.37399098,0.8847269,1.99520694,5.18339205,5.91618751,1.48201734,0.0,0.0,1.8446929,0.94591598,0.0,0.11968303,0.73505669,0.82824688,0.0,0.04065194,0.13982812,0.26243128,0.98052214,1.09390132,2.64980585,1.12651779,0.0,0.0,1.22707107,2.72357421,2.88254078,1.5186986,0.0,0.28461275,0.0,0.0,0.0,0.39002513,0.23534838,0.28743416,0.22730003,0.0,0.49689298,0.38931788,2.15806351,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
1.61655432,3.78029389,3.646723,2.17481979,0.69760749,0.0,0.0,2.16599148,0.62614863,0.0,0.0,0.0,1.08570481,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.379
0.30321653,2.42156584,2.08318387,0.71781433,1.16324755,0.36500288200000003,2.8404879000000003,4.70335007,3.49775452,1.20437965,0.261286692,1.17214712,1.67843748,0.388721369,0.661591579,1.18879334,0.8978852490000001,0.7858697109999999,0.0,0.45245115700000005,0.0,0.923357874,0.193770837,1.93511796,0.24990141800000001,0.456167748,1.09457966,0.6765148129999999,0.0535787125,0.0,0.944850634,0.0,0.733389878,0.0,1.93853737,0.425298226,1.08175232,0.0,0.0,0.964215672,1.64374343,1.80270158,1.81386472,0.0,0.850865645,1.04672962,1.00595483,1.34760184,0.93633177,0.8919280479999999,0.371875216,1.55776963,0.570441485,0.7185660190000001,2.33760826,0.0,0.30889798,0.11778832,0.990401654,0.0,0.283792053,0.046995164299999996,0.0,0.935052,0.0,0.0,0.0,0.275318689,0.8267334120000001,0.295188458,0.0,1.75771249,0.424080685,0.174885528,0.0,0.517192522,0.0,0.31091077300000003,0.0,0.107420684,0.0,0.284071811,1.06608866,0.518781033,0.0,0.16533810699999998,0.304431789,0.0,1.27871235,0.0,0.0,0.0,1.1579135,1.3693514,0.245365085,0.0,0.136289031,0.322021309,0.0,0.0,0.0986874,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.11031991,0.0,1.043406,0.0,0.0,2.34136581,0.0,0.27620618,0.42695346,0.58947743,0.0,0.23521709,0.0,0.44573222,0.85822801,0.76754667,0.25833927,0.11542912,0.0,2.52436739,1.23327004,0.0,3.61257768,0.07572092,2.81858891,2.22460305,1.19312574,0.05195841,0.58060916,0.76273435,0.0,0.0,0.78190538,0.0,0.0,0.0,0.0,0.0,0.29709621,0.47885849,0.08410319,0.0,0.0,2.6481052000000003,0.93797281,2.05201815,1.72351088,2.39976484,6.10513765,6.99041385,4.93340385,5.80940194,5.08304689,8.10818438,3.19763057,4.55292121,3.11147702,4.39674138,3.86703741,1.21316483,3.00588764,0.0,0.47413665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.88999924,0.0,0.0,1.1240344,0.65854558,0.38306996,0.87129613,0.0,0.24826122,0.0,0.0,0.0,0.0,0.0,0.25596667,0.0,0.0,0.0,1.26359051,0.040059500000000005,1.40761467,0.37634969,0.20955016,0.0,0.0,1.33696345,0.0,0.0,0.0,0.22361335,0.0,0.0,0.49333681,1.65456302,0.0,0.0,0.0,0.10925571,0.0,2.03638975,0.95331161,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.77406988,0.23673468,0.0,1.0634792,0.29719321,0.0,0.0,0.28536688,0.0,0.32970727,0.0,0.0,0.06373274,0.0,0.0,1.1576524,1.82745793,1.04517159,0.0,0.1302365,0.0,1.00921369,0.08340192,0.0,0.0,0.32635787,0.03604251,0.18329471,0.0,0.0,0.0,0.0,0.0,0.07124839999999999,0.0,0.0,1.30515044,0.0,0.58577644,0.0,0.0,0.16774471,0.85127081,0.77607475,0.0,1.46290069,0.58462755,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.127532557,0.0,0.49584375700000005,0.0,0.0,0.313504577,0.0,0.0,0.0,0.021934358199999997,0.0338940864,0.039800928199999995,0.21390974100000001,0.0,0.23113523800000002,0.0,0.0,0.006587564549999999,0.0,0.0,0.0,0.142926108,0.0,0.0,0.162230865,0.431559852,0.0,0.0,0.0,0.018146555800000002,0.035555204900000005,0.045942960899999996,0.0,0.17678279800000002,0.346870555,0.431738825,0.49909198200000005,0.235185172,0.14057809,0.0,0.0,0.0,0.0,0.47434273,0.833343553,1.56709992,2.04095164,2.97695076,3.19109654,2.95654857,2.71004183,2.62361224,1.73875185,1.58393574,1.17133426,1.76744258,1.51110564,2.30851828,2.59466816,2.5489441000000004,2.7838667999999998,2.59544441,1.67051837,1.11995655,0.601528277,0.41324354799999996,0.0,0.0,0.0,0.0,0.0,0.494359657,0.333575384,0.19260206100000002,0.377200153,0.00462045602,0.18113699,0.0,0.0,0.0,0.0,0.16743132800000002,0.254902238,0.5358838029999999,0.37886960299999994,0.145147277,0.00583862654,0.177984532,0.0,0.263080469,0.25206855699999997,0.16822070600000003,0.40072996899999996,0.08408137660000001,0.122018871,0.214928426,0.0331781556,0.0631146226,0.0,0.0,0.357175731,0.225665055,0.028440532200000004,0.0963045258,0.48070863399999997,0.0,0.155437938,0.057120283499999994,0.259976767,0.128057904,0.0,0.0,0.0,0.0,0.0208921491,0.0,0.0,0.009913391,0.0371373786,0.0,0.266176996,0.205798793,0.0,0.161569969,0.0707045744,0.0,0.0589619168,0.0,0.0,0.0722009207,0.0,0.0,0.0,0.0,0.0,0.226445827,0.20547020300000002,0.0,0.10901966699999999,0.0305831255,0.0,0.26796142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.203491272,0.274683681,0.027631491299999998,0.0,0.0341173818,0.0,0.0,0.40221858,0.00717666191,0.36298945,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.99278716,0.39436789,0.59159618,0.70431003,0.40868652,0.66975225,0.0,0.11719451,0.0,0.09189144,0.0,0.09226288,0.0,0.14527674,0.0,0.38750486,0.91469945,7.82860406,0.58475337,0.0,0.14724395,1.29830421,0.71701343,0.0,2.71830145,0.38699057,0.44640362,2.13727148,0.0,0.47212277,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
2.52647199,3.64371572,4.59317117,5.04257987,4.90704301,4.40142695,3.86755889,3.51518047,3.28913601,2.96810783,2.40251683,1.68119522,1.08047503,0.8398906270000001,0.960035471,1.19880346,1.26987104,1.07265609,0.7578272890000001,0.576944001,0.651378379,0.8619842320000001,0.95198273,0.749504701,0.31597658300000003,0.0,0.0,0.0,0.042865287300000006,0.174096781,0.127872681,0.0,0.0,0.0,0.0020182804500000003,0.0615596431,0.046258279000000006,0.00211495121,0.0,0.0204170595,0.00924668748,0.0,0.0,0.0,0.33847561299999995,0.9644253279999999,1.49023368,1.57136009,1.0992004,0.315893777,0.0,0.0,0.0,0.19752403899999998,0.38524884200000004,0.209211996,0.0,0.0,0.0,0.10088536599999999,0.311891765,0.22731101899999998,0.0,0.0,0.0,0.045321510999999995,0.314792493,0.293606865,0.0,0.0,0.0,0.28318250300000003,1.05997196,1.61613155,1.6225758,1.11248711,0.44498898299999995,0.032564791,0.0505618354,0.347203352,0.602509165,0.590578133,0.33617980399999997,0.061118003600000005,0.0,0.176308209,0.491922972,0.7388914040000001,0.802090339,0.709728369,0.581358452,0.525177236,0.569241974,0.663968336,0.731440616,0.7136662570000001,0.593334264,0.392490173,0.163797055,0.0,0.0,0.0,0.00658591569,0.0820196312,0.0781847618,0.0020371301,0.0,0.0,0.0,0.0757556954,0.09327871060000001,0.0207354824,0.0,0.0,0.0,0.0796785263,0.12433763199999999,0.0496991806,0.0,0.0,0.0,0.0872096483,0.182387352,0.106546542,0.0,0.0,0.0,0.126784819,0.488631782,0.6760544470000001,0.580607937,0.30035727,0.054669168399999996,0.00866746032,0.162927285,0.402992723,0.655425234,0.99557631,1.59242466,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.55491289,1.52998054,1.54477134,1.43597575,2.84231924,2.16007865,1.34020782,0.0,0.0,0.0,0.0,1.75348284,0.12393657,0.0,0.0,0.0,0.23319511,0.0,0.55083851,1.42761587,0.69659229,0.75244759,0.0,0.0,0.0,0.0,1.35620329,0.69531274,0.22504404,0.0,0.0,1.28185446,0.28277071,1.13111362,0.28017594,0.0,0.0,0.0,0.0,0.0,0.28907875,0.0,1.4305643999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07057226,0.0,0.37812378,0.0,0.13415751,0.0,0.0,0.46599185,0.0,0.55646108,0.99465351,0.6148134,2.03007393,0.0,0.12810315,1.41244085,0.0,0.36942849,0.70811228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.51654715,0.73797404,0.52231667,0.0,1.26629222,0.0,0.32791295,0.0,0.61460332,0.31050261,0.0,0.7010746,0.29018087,0.09379275,0.0,0.14088579,0.14642235,0.0,0.0,0.28701835,0.61199157,0.0,2.72810147,2.59211677,4.87822734,6.05106924,5.04160639,2.86207598,2.12147517,0.33057561,0.42057902,0.0,0.0,0.04993773,0.0,1.20503212,0.0,0.29139072,0.0,1.2046301000000001,0.09234706,1.38522066,0.0,1.82086502,0.3305784,0.0,0.0,0.0,0.0,0.0,0.0,0.36804032,0.63754213,0.67691975,0.24415397,0.0,0.63386536,1.12342765,2.1342581000000003,0.0,0.36708792,0.0,0.0,0.0,0.0,0.16676282,0.58882427,1.13905342,1.63552176,0.0,0.0,1.44934438,0.0,0.0,0.0,0.9012601,0.27206414,0.0,1.11650402,0.0,0.0,0.51746001,0.0,0.95629329,0.0,0.36876908,0.9488683000000001,0.44960567,1.21523687,0.65595055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.259885641,0.273787209,1.53082781,0.49625043799999996,0.0110485321,0.22074686300000002,0.0,3.82938155,6.72992305,2.97692013,0.0,0.15968242,0.0,0.0,0.015974571599999998,0.0408734727,0.0,0.0,0.757365188,0.5757462879999999,0.0564298564,1.49951481,1.02024676,0.0,0.990790169,1.15570421,0.039955894900000004,0.124559145,0.0,0.0,0.133570667,0.0,0.192340928,0.07322532150000001,0.0,0.162538497,0.0,0.0,0.137509787,0.0,0.245915739,0.306086488,0.0,0.10515757099999999,0.0,0.0,0.11988431599999999,0.0,0.0956375874,0.0281563952,0.0,0.892224907,2.62013838,4.6114545,4.91286562,3.43175912,2.18539822,0.0432515968,0.447900085,5.11853979,4.82882238,5.5197239000000006e-15,0.0,0.53604739,0.0,0.147076433,0.7373882420000001,0.7592511,0.507649496,0.0,0.0,0.0655797733,0.0,0.0050724177500000005,0.0125777316,0.0,0.00319786855,0.000749773429,0.00569062272,0.0,0.0200634669,0.0,0.0,0.0402130451,0.0,0.0169334843,0.028791736499999998,0.0,0.100902175,0.11552790800000001,0.110018699,0.128738691,0.0,0.0518363164,0.0496393641,0.0,0.8538778440000001,1.84140153,2.52400423,2.62364489,1.57616305,0.968572766,0.35955412299999995,0.0,0.772091125,0.036002766299999996,0.0,2.54023746,2.09739848,0.0,0.329511045,0.311590136,0.0,0.653159689,0.0409635966,0.0,0.232940065,0.0,0.0,0.110281747,0.0,0.0831973204,0.0,0.0,0.08650888960000001,0.0,0.0035855231099999997,0.040987294300000005,0.0,0.0370626899,0.0,0.0,0.0326845185,0.0,0.0094359831,0.289713934,0.588232578,0.352475366,0.0,0.0,0.0,0.0549335824,0.0,0.0,0.589952478,0.615118607,0.0,0.053416652,0.498916554,1.4045411,1.75305176,0.673598296,0.398701395,0.458837551,0.307406748,1.09912768,0.649120954,0.0,0.12346796,0.054133753,0.21654352300000002,1.4143968,1.46172078,0.958143298,0.341931827,0.0,0.10427320400000001,0.0358657466,0.0,0.148220974,0.0,0.101522407,0.200732835,0.0,0.20439432100000002,0.528276595,0.197145856,0.0819574267,0.0,0.0,0.0,0.490213849,1.26330503,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
3.33270257,9.83305191,12.4300898,8.80123247,2.08299155,0.0,0.0,0.469110705,1.66323401,0.482345543,0.0,0.0,0.49302469299999996,1.21212972,0.508743399,0.0,0.0,0.312791311,0.65503518,0.0653814553,0.0,0.0,0.35899752799999995,0.610629526,0.0,0.0,0.0,0.702898205,1.51989784,1.41029419,0.7475989209999999,0.289596028,0.230816145,0.189208803,0.0,0.0,0.0,0.217175767,0.21497158,0.0,0.0,0.0,0.271610511,0.223166117,0.0,0.0,0.0,0.356055409,0.285990447,0.0,0.0,0.071735015,0.523615001,0.48501532,0.193154745,0.461878226,1.52676771,2.53974715,2.61537609,2.22622712,2.98091935,5.67058236,8.81335218,9.70764142,7.16850531,2.96355911,0.21142047100000003,0.373538141,2.05961851,2.80858019,1.71349923,0.0261646761,0.0,0.0,0.589150441,0.386959947,0.0,0.0,0.028001663,0.444822339,0.22375366800000002,0.0,0.0,0.0825563487,0.477184693,0.199796639,0.0,0.0,0.253792277,1.38726025,1.891803,1.42495068,0.497938748,0.0,0.0,0.015381396299999999,0.312253247,0.5298377129999999,0.674755963,0.742939026,0.732784817,0.694487156,0.6580117289999999,0.550349961,0.29293625100000004,0.0,0.0,0.0487708528,0.325159905,0.385135269,0.17819770699999998,0.0,0.0,0.09363512880000001,0.106681532,0.0,0.0,0.0,0.127911281,0.114285739,0.0,0.0,0.0,0.149630955,0.11002435,0.0,0.0,0.0,0.16086036199999998,0.0938043506,0.0,0.0,0.0131755938,0.09772461199999999,0.0170653378,0.07653818150000001,0.548493789,1.11606546,1.10355115,0.371989051,0.0,0.0,0.609605518,0.910566297,0.19718176399999998,0.0,0.0,0.39259974,0.92699918,0.121394639,0.0,0.0,0.8979496140000001,1.75764084,0.20120919,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.527413104,0.918233483,0.810017022,0.0,0.355937934,0.0,0.0,0.00953951319,0.0,0.0330235347,0.323969306,0.0,0.650826861,0.0,0.259235747,0.0,0.0,0.0,0.0,0.0,0.043741624699999995,0.570491078,0.470193431,0.353273516,0.0,0.35840367700000003,0.10900648199999999,0.0,0.0270694436,0.43299291799999995,0.0166501682,0.0,0.137790401,0.325562533,0.0,0.390920439,0.0,0.6370571999999999,0.19401236,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.301917928,0.0,0.00200872438,0.139516386,0.0,0.0,0.0,0.485714615,0.52576848,0.571438255,0.0,0.0,0.0,0.0,0.0,0.435785739,0.0,0.334217119,0.564318203,0.409602708,0.0,0.0,0.0,0.0,0.0,0.0,0.579916083,0.0,0.362699605,0.17278514600000003,0.325238768,0.0,0.0,0.0,0.5148504620000001,0.64005355,0.047381023,0.45750064700000004,0.0,0.0,0.167165163,0.476914257,0.0652836103,0.0,0.0,0.489797325,0.0,0.0,0.0,0.0,0.785224145,0.923771564,1.29894799,0.7486117409999999,1.34549594,0.949181831,1.61420508,1.44186113,0.639090404,0.939718249,1.18786453,1.22315516,1.70955401,0.92776782,0.582081144,0.417930824,0.97384261,0.7838030029999999,0.818448843,0.23917533100000002,0.790775448,0.0468576553,0.189907192,0.0,0.0,0.0,0.250967394,0.534914718,0.878521943,0.136143554,0.0,0.0,0.0,0.0,0.474531517,1.10458402,2.10330767,3.55113989,4.42307155,4.81042045,4.24603891,3.58953041,2.20757428,1.38164102,0.0,0.0,0.0,0.0,0.0,0.825718823,0.230879334,0.240253005,0.0,0.0,0.0,0.0,0.058381076799999994,0.0527785539,0.519415706,0.528761107,0.177895666,0.0220312694,0.834070827,0.276760707,0.816837598,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.07274929,0.0,0.20691106,0.52594358,0.33022845,1.16272489,1.5753556,0.0,2.41968746,1.18996266,0.34058337,0.0,0.0,0.28799315,0.69257693,1.01404593,0.10143052,0.44261192,1.37140082,0.78231769,0.0,0.22618539,0.66068846,1.93701965,1.66299884,0.0,0.46654385,0.95534543,2.48130341,2.20461534,1.78377057,0.6795485,0.0,0.92374477,1.25400293,2.67175059,1.85409937,3.98309089,1.57813849,0.0,0.0,0.86631566,0.0,0.0,0.0,0.0,0.42358229,0.0,0.0,0.0,0.37309159,0.0,0.0,0.68091431,0.0,0.49240576,0.0,1.02699288,0.37372209999999995,0.0,0.0,2.10713916,0.0,0.0,0.82922998,0.0,0.96561905,0.10078944,0.0,0.0,1.51269113,0.0,0.18413716,1.00901696,0.0,1.59615252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.823620475,0.0,0.0,0.0,0.0,0.587381723,1.97623618,1.28215117,5.90423709,4.01148219,5.69242369,5.08385479,4.46086272,3.19752992,2.63458163,3.47247147,4.13485271,1.88565214,1.88357053,2.33795001,0.649911344,0.0,0.0,0.0,0.7376639509999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.026671506499999997,0.278972596,0.533770281,0.7130569,0.8295453420000001,0.0,1.53408979,0.0,1.11543882,0.0,1.30461088,2.85461205,0.0,0.0,0.0,0.0,0.005586889770000001,2.2426641,0.0,0.18040515199999999,0.0,0.0,0.577589803,2.0611171,0.0,0.86762818,0.0,0.0,2.17830832,0.0,0.0,0.65942738,0.0,0.0,0.0,0.0,0.0,2.18135704,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.94410541,0.0,2.1972954,0.0,0.0,0.0,0.0,0.0,0.0,1.07754255,0.0,0.0,0.0,0.0,0.0,1.73989398,0.0,0.224160113,1.17504185,0.0,0.0,1.71497303,0.485719313,0.0,0.0,0.0,0.0,0.0,0.5151650560000001,0.24118778600000002,0.297521683,0.0,0.28535224800000003,0.091493774,0.0,0.147061901,0.7491076959999999,0.0,0.0,0.0,1.30142495,0.567863816,0.0,1.00428906,0.0,0.0,1.99865465,1.81926154,1.80345599,0.0,1.52726353,0.12468162699999999,1.09176331,0.0,0.13852909800000002,0.0,0.0,0.0,0.245236813,0.0,0.0,1.51484135,0.916638035,0.78679169,0.0,0.0,0.936846161,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.12611176,0.41254044,0.29598337,0.80148363,0.53939549,0.36320775,0.39628703,0.66803511,0.61992137,0.2167561,0.30743778,0.0,0.0,0.151296,0.0,0.0,0.0,0.0,0.0,0.0,0.04351386,0.55849583,0.69972101,0.64472339,0.47039106,0.55595086,0.0,0.09940863,0.31248293,0.2400862,0.17346603,0.0,0.09258797,0.0,0.0,0.0,0.25000289,0.27288193,1.00366958,0.80354068,0.57225553,0.0,0.0,0.08627354,0.20970785,1.22581896,1.86379289,2.19487733,2.21921068,1.68213583,1.0264495,0.49733420000000006,0.28208037,0.14163463,0.05193335,0.71804935,0.95255818,0.84830175,0.5309991,0.03471719,0.24788527,0.0,0.0,0.30939173,0.0,0.0,0.0,0.0,0.05449461,0.71627013,2.09608151,2.35576011,3.1763122999999998,2.83748816,2.97678319,2.49222915,2.1493047,2.01457318,2.16100287,2.5930744999999997,2.51812659,2.17236445,1.7345914,1.24170033,0.5828584,0.24971383,0.14463141,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.0205554102,0.00971196574,0.0,0.0,0.521929338,0.19541381,0.0,0.20537721899999997,0.0,0.0,0.388775666,0.0,0.0,0.0,0.0,0.348473222,0.47991196799999997,0.0,0.0,0.06995237650000001,0.143667996,0.0,0.0687462638,0.0,0.478696326,0.21414831899999998,0.0,0.41724893399999996,0.0,0.0,0.349751865,0.0,0.0,0.0,0.0,0.0,0.0,0.573938987,0.0,0.470859336,0.0,0.0,0.014058236000000002,0.0,0.0145795122,0.536444056,0.452150503,0.0456552383,0.0,0.507169042,0.33694405200000005,0.27533505399999997,0.46995478399999996,0.0198093599,0.0,0.0,0.0,0.0,0.43527036700000005,0.20729819300000002,0.105953559,0.0,0.0,0.0138403543,0.167755854,0.09685140939999999,0.7677985270000001,0.241449463,0.0,0.180172732,0.40909288200000005,0.211023248,0.004353524520000001,0.0,0.0,0.0,0.44505131600000003,0.0,0.232035975,0.544089819,0.0,0.194739745,0.0,0.426286173,0.0,0.0,0.227050114,1.22059483,1.40812416,1.20341337,0.5029985260000001,0.157482752,0.0,0.0,0.0,1.33204644,3.27421776,4.69989481,5.21023407,5.44916949,4.15479933,2.17432826,0.824203597,0.0,0.895482071,1.56826451,2.24351041,2.10659117,1.13858471,0.427311747,0.365682329,0.0,0.0,0.0,0.0,0.00737360468,0.50358566,0.0,0.35289941,0.0,0.0,0.487195041,0.14042669,0.35937871899999996,0.0,0.48012551600000003,0.504661586,0.274181827,0.487581611,0.0,0.0,0.0,0.364504865,0.01144905,0.372012357,0.730822979,1.80069004,0.98443394,1.25118074,0.296979597,0.964401919,0.0,0.0,0.0,0.0,0.0,0.0,0.312801857,0.11209373800000001,0.0,0.0,0.528338859,0.0,0.0,0.34026529299999997,0.0690021146,0.0,0.47266295700000005,0.0,0.475132623,0.0,0.0,0.0,0.466604316,0.0,0.0,0.0,0.267636985,0.0,0.9944217940000001,0.8960806240000001,0.22238095800000002,0.788749733,0.477347484,0.0,0.374371464,0.540748529,0.0,0.174948611,0.0,0.449968262,0.441049065,0.40674333,0.9356490270000001,0.235094062,0.029625009,0.590552318,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.556788055,0.531725253,1.16468256,3.51815229,2.99537633,2.73960874,0.333145362,0.0,0.0,0.45123379399999997,2.73008085,2.70651286,1.99751093,0.09571407300000001,0.0,0.0,0.0,0.276714508,0.9160057009999999,0.43125048,0.0,0.0,0.0,0.0,0.0,0.0,0.357227247,0.316820589,0.0,0.0,0.735639872,0.0,0.0,0.0,0.0,0.0144830735,1.09257689,0.43093626,0.0799998851,1.55016782,2.65652441,5.41912132,7.97388593,8.81842925,5.41831686,1.82014989,0.0,0.388998676,1.777194,3.86352711,2.53935912,0.659460833,0.8879289440000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
1.32714249,0.362436634,0.725526126,0.876011855,0.0,0.0,0.662438095,0.854471543,0.0,0.9698159909999999,1.22166322,0.0,0.104316928,0.0,0.0,0.23367513,0.0,0.316414494,0.00496168439,0.0,0.0,1.23445754,0.564892353,0.0,1.00345892,0.0,0.0,0.0,0.6886699620000001,2.78436348,2.76813369,3.88621108,2.39254452,0.792985119,0.142221505,0.0,0.0,0.0,0.0,0.616653483,1.83312205,1.01204234,0.0,0.0,1.43312783,1.01080403,0.0,0.0617144475,1.47580862,0.0,2.1789715,0.265767309,0.132104324,0.0,1.16046609,0.0,0.548438739,0.7326946459999999,0.0,0.232788031,0.461050329,0.0,0.376668757,0.0,0.0,0.0,1.460752,0.733007263,0.0,0.0,0.217283392,0.0,0.9669626509999999,0.165479155,0.0831349263,0.6897704709999999,1.44355159,0.0,0.0,0.487502502,0.0,0.0,1.21834657,0.0,0.0,0.0,0.184233591,0.100284265,0.0116999564,0.0,0.0,1.26527611,0.0,0.0,1.41290706,0.0,0.0,0.0,0.0,0.0,0.528785854,0.0,0.6498533870000001,0.0,0.0,0.0,0.0,0.0422335925,0.247829557,0.19824394899999997,0.380200362,0.7235099,0.0,0.0,0.0,0.312110736,0.127692076,0.431145336,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.26778472,0.826324805,1.25298747,1.50975166,1.58599182,1.49660954,1.27690536,0.97518659,0.644352561,0.33374767699999996,0.0824304783,0.0,0.0,0.0,0.0,0.0227058415,0.13515365099999999,0.22700551300000002,0.27894057899999997,0.281429897,0.235350167,0.150777739,0.044327125499999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0794484911,0.139444807,0.171505164,0.17258866,0.145192831,0.0964715805,0.0366035787,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.026079205699999997,0.04940034980000001,0.0600741376,0.0582942254,0.046722157800000004,0.029644751299999998,0.011865231,0.0,0.0,0.0,0.0,0.0,0.00556543218,0.0075820462,0.00347215019,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0353202248,0.070377987,0.09786740210000001,0.11100223599999999,0.10500239,0.0783189032,0.0333240555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0704163653,0.153662537,0.21717685,0.247694487,0.236755307,0.182649615,0.0912949271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09934275869999999,0.258809743,0.38595332600000004,0.455621258,0.45064349299999995,0.365482284,0.208159641,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.129659546,0.454338726,0.734718284,0.9165419709999999,0.956037592,0.828256386,0.533272458,0.09912186210000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.215163462,1.44092086,2.84553015,4.31145532,5.70631645,6.89781047,7.76908343,8.23257562,8.24053678,7.79083333,6.92728594,5.73449699,4.32785284,2.84001413,1.40565147,0.146383772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.582245015,0.0,0.460929318,0.0,0.27582131,0.383493264,0.0,0.121910282,0.273863987,0.043102108099999994,0.0,0.0,0.0,0.659389896,0.6793872,1.30402574,0.423813509,0.27844300899999996,0.0625692378,1.40300447,2.02389075,0.496562665,0.17615754399999997,0.0,0.0,0.0,0.0,0.675400447,0.339904059,0.9926434279999999,0.6926860990000001,0.315669475,0.0,0.0,0.35733192,0.0,0.37904765700000004,0.447734436,0.9969815540000001,0.0,0.31884354,0.164501899,0.28362231,0.39473095,0.366456096,0.08691040380000001,0.0,0.0,0.0,0.0,0.6530179389999999,1.41209354,0.958233485,0.923490057,0.0,0.25028454,0.0901903352,0.0,0.502571156,0.0,0.0,0.6779756579999999,0.41818926799999995,0.0,0.0,0.202216011,0.0,0.406165138,0.0,0.419354396,0.0,0.0,0.0,0.471348947,0.168920472,0.118115905,0.0,0.0,0.0878068191,0.0,0.0,0.546387066,0.812364199,0.399985482,0.00446791663,0.0,0.0,0.480354324,1.82296952,1.78328368,1.10565769,1.37924655,1.31200924,1.427211,0.622844003,0.132677506,1.7089816999999998,3.76146779,5.55747966,5.50340091,5.04768822,4.74936704,3.78498415,2.88712053,1.27150326,0.0,0.0,0.776934659,2.81601364,3.60156771,3.25303022,2.36033229,0.645073969,0.13495400400000002,0.5712595570000001,0.0328555341,0.536317061,0.123034525,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.258003823,0.9614117790000001,1.20537864,0.77630365,0.0,0.0,0.0,0.0,0.606164892,2.78146271,4.81981858,6.01163449,5.95849804,4.73342032,2.83018524,0.93313562,0.0,0.0,0.0,0.0,0.470697792,0.615944374,0.40084416100000003,0.0125263405,0.0,0.0,0.0,0.0334245239,0.231323043,0.261663662,0.133680147,0.0,0.0,0.0,0.0,0.0566603417,0.131947866,0.11612291400000001,0.0355749384,0.0,0.0,0.0,0.0,0.0250153073,0.0255440821,0.005898574889999999,0.0,0.0242995471,0.061512051500000005,0.0627249976,0.0,0.0,0.0,0.0,0.102425115,0.639811459,1.27841508,1.79159427,1.96254597,1.69207299,1.05825211,0.29183246,0.0,0.0,0.0,0.0,0.264882314,0.43302025299999997,0.326343158,0.0318204609,0.0,0.0,0.0,0.0199804506,0.291671945,0.385070188,0.236344191,0.0,0.0,0.0,0.0,0.201112139,0.7583758540000001,1.20754982,1.39669058,1.28351313,0.9378999170000001,0.495597036,0.09418674980000001,0.0,0.0,0.0,0.0,0.255856065,0.599178419,0.926775674,1.1424162,1.15089718,0.903734735,0.44042088100000004,0.0,0.0,0.0,0.0,0.256483857,1.07663735,1.85251459,2.37102906,2.51161338,2.27685825,1.77423734,1.16427995,0.602177828,0.196367388,0.0,0.0,0.125110586,0.339611269,0.546529258,0.667774602,0.650457327,0.487579983,0.22743181,0.0,0.0,0.0,0.0,0.058638387,0.19564324600000002,0.209179002,0.0913744349,0.0,0.0,0.0,0.0,0.130949215,0.26685448100000003,0.24080657600000002,0.0491211076,0.0,0.0,0.0,0.0,0.4231718,0.8113279999999999,0.9848798740000001,0.883559853,0.5853249220000001,0.260441274,0.07229927480000001,0.0816954932,0.211977781,0.299290565,0.202725796,0.0,0.0,0.0,0.0,0.687780905,1.86378476,2.97410219,3.60031966,3.47751438,2.62233593,1.33477411,0.0701271559,0.0,0.0,0.0,0.063819578,0.6263949560000001,0.86842921,0.7470305290000001,0.402811397,0.056174355599999996,0.0,0.0,0.07193372099999999,0.20699370600000003,0.211806703,0.0783557315,0.0,0.0,0.0,0.0,0.133097314,0.232469462,0.186132666,0.019247711,0.0,0.0,0.0,0.016901035800000002,0.29520035899999997,0.532204571,0.656510701,0.659644122,0.586389351,0.49696764200000004,0.427587004,0.3740564,0.30611276,0.19950367800000002,0.0619689666,0.0,0.0,0.0,0.0,0.0669156082,0.11657346699999999,0.0916914292,0.0117501961,0.0,0.0,0.0,0.00247752813,0.0652882082,0.0787670249,0.0419491512,0.0,0.0,0.014790262299999999,0.0957193695,0.18001915300000002,0.249576904,0.339954783,0.537018468,0.926277267,1.51804585,2.19511074,2.72639447,2.8573886,2.44171615,1.54501675,0.455112555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.211623224,0.8024900559999999,0.7117119009999999,0.5013771,0.47394637100000003,0.548000529,0.975102967,1.10809262,1.24489855,1.58667855,1.84631287,1.05704183,1.57231205,0.973501333,0.648120829,0.437875051,0.0,0.0,0.0,0.0,0.0,0.109956203,0.0,0.0,0.323420265,0.36868419799999996,0.0,0.0,0.0,0.150840687,0.0,0.21739997600000002,0.0,0.0,0.272068336,0.38983299,0.0189290548,0.0332891631,0.0,0.0,0.196358137,0.0,0.261596,0.0,0.0,0.0,0.0,0.334056736,0.136812568,0.65652796,0.8215365109999999,0.0758287876,0.13754818800000002,0.236607449,0.0,0.21842741699999998,0.0,0.0,0.0,0.0,0.0,0.258751496,0.283981796,0.498531926,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.163781154,0.356437018,0.849159178,0.052651257300000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.344728565,1.45184635,2.45290661,3.33031461,3.83698989,3.91146256,3.72830361,3.67469396,2.47136207,1.51707074,0.8468396579999999,0.395117591,0.0,0.0,0.0,0.0,0.0,0.28737987,1.17963498,1.30695142,1.16065235,0.5622896620000001,0.497253382,0.0,0.22672566,0.0,0.0,0.0,0.043666997699999995,0.0,0.228821212,0.6130649229999999,0.21432983,0.42266395700000003,0.344743315,0.0,0.194424263,0.0,0.0,0.0,0.0,0.0,0.0,0.148874029,0.0,0.221797417,0.0,0.155175746,0.0,0.0,0.0,0.0,0.360279525,0.0,0.449992055,0.615428315,0.6342798270000001,0.74744895,0.493946406,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.898640725,0.0,0.0,0.0422605937,0.0,0.602254408,0.418558366,0.11139281599999999,0.0279358259,0.0,0.939103383,1.59059232,0.42612578,1.1358581,0.0,0.0,0.240688199,0.44870537299999996,0.279638893,0.0,0.0509104731,0.772491595,1.21468221,0.323577493,1.00011212,3.29221129,2.05112522,2.67098258,2.14863712,2.65657036,1.40587695,3.47233712,2.0412377,2.46265437,0.206187598,2.24777265,2.12832784,0.0,2.37665709,1.1396848,0.867917006,1.27823818,1.03750395,0.08709856140000001,1.04991426,0.5074515829999999,0.5302305620000001,0.28002255600000003,0.308826415,0.0,0.188104568,0.0,0.445941398,0.14705912699999998,0.163179975,1.32864799,1.49272915,1.26144738,2.14406684,0.6432974260000001,1.00899705,1.59964357,1.56351774,0.297735613,0.601138446,0.0663548821,0.0,0.0666782205,0.0,0.0,0.0,0.0,0.0,0.0872622569,0.0,0.514047957,0.679243123,0.0,0.0985082307,0.0,0.0,0.0,0.0,0.0,0.67994034,0.0,0.0,0.0,1.18881099,0.8625937359999999,0.0,0.513226223,0.153646985,0.0,0.0,0.231091711,0.0,0.0,0.773787485,0.299861,0.0,1.26920477,0.0,0.240119428,0.0,0.0,0.0,0.33610518799999994,0.35412696,0.0,0.887029572,0.0,0.0,0.0,0.351878765,0.0,0.0,0.0,0.0,0.0785480271,0.16472847,0.143788217,0.161302836,0.0,0.295693844,0.0,0.683158807,0.151025554,0.0,0.0,0.821681707,0.0,0.19516872600000001,0.059788676,0.0,0.000666293547,0.0,0.0,0.23857945600000002,0.0839277175,0.0,0.027939946,0.471124272,0.443492059,0.22139176300000002,0.137233814,0.00659419838,0.0920095695,0.415302157,0.0,0.0,0.0,0.134317097,0.0,0.0,0.285661687,0.0,0.0,0.0,0.0,0.311080202,0.9228510190000001,0.149087997,0.0,0.9173354090000001,1.30254871,0.0,0.0,0.0,0.546105363,0.0,0.0,0.0462557391,0.0,0.0,0.0,0.6994288259999999,0.222412009,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.641389587,0.0,0.0378130085,0.0,0.0,0.0499893494,0.351884345,0.015140698000000001,0.0,0.106391954,0.0,2.49691191,0.429785779,3.44099864,3.12651986,0.0231428798,2.08471716,1.66644842,1.89692522,5.311362,4.7298365,2.6706142999999996,11.5256525,2.17650712,0.00463742857,0.0,0.106693466,0.0,0.569575856,1.70800643,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
1.06776811,0.8437427209999999,0.0,0.35507831700000003,0.0,1.69473448,0.493289075,2.58967874,3.23660699,5.14938245,4.25245093,2.07582742,3.4059807,2.4217405,1.74299432,0.0,0.0,0.0,0.0,0.0,0.0,1.9618678,1.62866914,0.0,0.135393766,0.277216052,0.0,1.26273894,0.0,0.0,1.76466358,0.0,1.7053112000000001,1.14429097,0.0,0.0,0.0,0.0,0.0,1.27017092,0.8194640459999999,0.647404364,0.0,2.18137794,0.0,0.0,0.841772482,0.41961126,0.0,0.0,0.0,0.343404621,0.0,1.07331495,0.0,0.0,0.37194889299999995,0.995342334,0.0937311411,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12231816599999999,0.0,0.326978934,0.139300795,0.0,1.80418505,0.8456990879999999,0.0,0.9877926220000001,2.2466291000000003,0.0,0.0,0.0,0.30670621600000003,0.0,0.0,0.42095954399999996,2.57396541,0.7471288229999999,0.0,1.21719626,0.6212684279999999,0.0,0.852984373,0.0290821404,0.0,0.0,0.0,0.17389985800000002,1.02811379,0.770331401,0.0,0.0368738971,0.42259142,0.0,0.0143055479,0.0,0.0,0.0,0.508938071,1.86583631,0.0,1.65332534,0.0,2.83128972,1.12228565,0.0,0.697430773,0.0,0.0,0.0,0.93234708,0.0,0.0,2.14469477,0.579678522,0.28980611100000003,0.0,0.0,0.0,0.0,1.11749473,0.0,0.202843461,0.275567515,0.0407206972,1.38687951,1.35037073,0.365229587,0.260973705,0.44434320899999996,0.0,0.0,0.234017383,0.0,0.352080104,0.0,1.58201491,0.141886772,0.171453618,0.0,1.51184763,0.938285411,1.3733806999999998,1.16426971,0.862997963,0.20869368300000002,0.0,1.2144986999999998,0.024968562000000003,1.31758101,0.0,1.52469068,3.14632954,1.62693529,1.84522448,2.2661336,3.08561546,0.6352367320000001,3.11831104,0.0,0.970386425,0.0,0.0,1.24955597,0.473086569,1.15591669,1.45304951,0.8618874809999999,0.611559924,0.0,0.453048551,1.0548333,0.0,0.970299073,0.194475695,0.0,1.41065326,0.0,0.0,0.500535209,1.00619704,0.572021719,0.7204183000000001,1.98281605,0.14635227,0.0,0.92923107,0.0,0.0,0.7394942040000001,0.0,0.0,0.5408385729999999,0.0,0.0,0.705926485,0.100328356,0.0,2.64035176,2.19898169,1.85536016,1.54911869,2.43290201,1.50464653,3.5047812000000005,1.49975379,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
0.89520176,2.12899701,3.05675036,5.03276982,2.99666496,4.54065495,1.90791828,2.23116743,0.0,0.72483318,0.0,1.14533574,2.07589348,1.67433661,1.70835954,0.0,1.87831785,0.0,0.0,0.0,0.0,1.4507866000000003,2.79598826,4.54992558,4.33663573,5.42844627,3.6007767,5.63116432,2.40015872,0.0,0.55793839,0.0,0.0,0.0,0.0,1.77383499,1.24517347,0.19978372,0.70353587,0.0,0.67010481,0.7469879,0.0,0.54029679,0.91603936,0.0,0.0,1.29765272,0.25073325,2.08310877,0.20909813,0.41448271,0.0,0.0,0.9258165999999999,0.62758473,0.77871142,0.07478886,0.35552659,0.25669699,0.16606924,0.0,0.0,0.0,0.0,0.0,0.25000326,0.0,0.0,0.0,0.70616217,0.0,0.0,0.62635817,0.0,0.7258252,2.29073275,2.1929691000000004,1.73860245,1.62172257,0.97442777,4.02933425,2.31768296,0.68954087,0.0,0.0,0.0,0.26694116,0.0,0.0,0.82839312,0.67817086,0.0,0.12135292,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.6139526670000001,0.0,1.17107758,1.54460798,0.00159563507,0.0,0.0,0.605613457,0.0,0.7760752470000001,0.505999295,0.0,0.0,0.298422445,0.618563486,0.786527628,0.0,0.639651289,0.0,0.0,0.0,0.0,0.0,1.07377212,1.59486192,0.928083972,0.0,0.0,0.30194442899999996,0.0,0.412445954,0.0,0.14988566,0.532425636,0.58784587,0.0,0.0,0.0,0.24389641199999998,0.0,1.00341104,1.95655436,1.48224535,1.03506483,1.38226853,0.0,1.72074479,2.15541344,2.98670633,1.4779988000000002,0.0,0.5869858170000001,1.11943837,0.8523108359999999,0.0,0.12400769,0.568661199,3.57994124,2.4688468999999995,3.27308601,0.812124693,0.0,0.7942996459999999,2.49498769,1.32896421,0.0,0.0,0.0,0.796343768,0.0,0.0,0.20440371300000001,0.986997764,0.421517299,0.44193824200000004,0.0,0.0,0.44369534,0.0,0.198060155,1.04607971,0.0,0.697948149,0.551988092,0.0,0.9810514840000001,0.167287451,0.7404520590000001,0.0,0.0,0.29748929399999996,0.0,0.16306443199999998,0.00566982046,0.181190198,0.029432269,0.167252777,0.0,0.39384808299999996,0.0,1.7388065,1.6263007,0.971939443,1.59190804,0.567372114,0.0,0.0,0.239323449,1.11323742,0.0,0.0,0.0,1.19249682,0.058684638899999995,0.11248280199999999,0.0,0.9315022140000001,0.0,0.06449430240000001,0.599809303,0.0,0.0,2.62803207,0.690993683,2.86734862,1.2541385,1.74552285,0.0,1.09837537,0.690219976,0.0,0.225306468,0.941763611,0.0,0.0,0.0,0.0,0.351918295,0.0,0.0,0.0,0.0,0.0,0.96107364,0.0,0.0,1.74832324,1.60080005,0.49159927299999995,0.0,0.0,0.5328996429999999,0.8877490840000001,0.0,0.416525332,2.38074962,0.50530793,0.0,0.0,0.0,0.0,0.530550549,0.144934557,0.0,2.09669014,0.0,0.466441406,0.0,0.207218003,1.90439503,3.72792125,4.66858672,2.69784749,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.78989991,0.96394195,2.07570326,3.63061212,1.64656839,0.32672649,8.69908465,14.46463155,8.64482857,0.0,1.46283501,3.68709573,0.42887992,0.0,0.0,0.36497959999999996,0.0,3.34858197,5.44033914,2.77311726,0.0,1.3505983,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.01821166,2.25557862,0.0,0.54715269,2.16345144,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.21273431899999998,0.042469615700000005,0.0,0.0,0.0695680588,0.018581213,0.0,0.0,0.062240132999999996,0.274600061,0.705456465,1.04581584,0.82042752,0.197347613,0.007827938100000001,0.589859845,1.12053437,0.69045449,0.0,0.0,0.632591051,1.88463682,2.1914857999999997,1.886349,2.11609149,3.04240022,3.50028166,2.60547311,1.00412703,0.018167937,0.0,0.14423712,0.021676063,0.0300518596,0.45991042299999996,0.718863768,0.301016585,0.0,0.82552918,2.62302282,3.57514662,2.66232046,0.928972107,0.0466272451,0.29680614,0.7422223509999999,0.8436488390000001,0.9033855470000001,1.09900286,1.11826116,0.92205867,0.9892168840000001,1.4359741000000001,1.6051745000000002,1.01687219,0.173269151,0.0,0.0799747192,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
5.16574961,2.17902168,0.0,0.0,0.0,0.590500593,0.487890006,0.0,0.0,0.33532028399999997,0.895671063,0.745789308,0.0177563676,0.0,0.0,0.198451533,0.42465193,0.110927135,0.0,0.0,0.0674323947,0.327376497,0.162684179,0.0,0.0,0.0,0.26070531199999997,0.197672547,0.0,0.0,0.0,0.20637539600000002,0.22591239999999999,0.0,0.0,0.0,0.161256685,0.264024952,0.0239813181,0.0,0.0,0.148882401,0.539148599,0.587702191,0.324153621,0.059336957999999995,0.0037187246399999997,0.0689997294,0.054093575,0.0,0.0,0.0,0.176341608,0.276172863,0.254652724,0.24547216600000002,0.327320842,0.38462377,0.253960265,0.0,0.0,0.0,0.11399864800000001,0.20013876100000003,0.0289895359,0.0,0.0,0.0736905662,0.23161601199999998,0.09267291279999999,0.0,0.0,0.12213058,0.590050831,0.779493918,0.586414157,0.28088633,0.172247116,0.285086939,0.416583114,0.44548409,0.463984112,0.576017515,0.6734629529999999,0.537387328,0.158786012,0.0,0.0,0.13101902099999999,0.273519464,0.0580450009,0.0,0.0,0.109282981,0.479101994,0.405599758,0.0,0.0,0.00928646943,0.364192125,0.27888320000000005,0.0,0.0,0.166286631,1.18982987,1.48808248,0.518793623,0.0,0.0,1.59232819,4.70400598,6.32480252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.162379622,0.0,0.0,2.44357028,6.29132822,6.0139977,0.37385804,0.0,0.0,0.224897572,2.14908985,0.704003921,1.07297442,0.5380615879999999,0.06209435,0.333664534,0.0,0.0,1.08930659,0.48479451799999995,0.0,0.0,0.0,0.0,0.0,1.24106057,0.0,0.0,0.820910383,1.82966767,0.0513471306,0.875409615,0.0,0.574949909,0.458264606,0.14784329,2.53802255,1.11008028,0.08257404980000001,0.0,1.09409354,0.0,0.0,0.0,1.43382562,0.171158187,0.0,0.264625432,0.0,0.216691457,0.0,0.282691696,0.093774118,1.20884417,0.490996316,0.0,1.43583096,1.70584544,0.263694102,0.0,1.35547752,0.0,1.01871067,0.0,0.0,0.0,0.0,0.861961801,0.0,1.13448044,0.0,0.288652924,1.25886352,1.77118914,2.42270993,0.0,1.75430263,0.0,0.0616523467,0.0,2.96460922e-05,0.0,0.5020305070000001,0.0,0.0,0.0,2.74029763,2.20686604,1.85018926,3.3236833,0.758661205,1.06073574,0.34219982600000004,1.79143182,1.08644114,0.0,0.0,0.0,1.5982027,1.75970479,1.94214034,0.328652434,0.240417797,0.0,0.0,0.0,0.0,3.0221767999999996,0.64836538,0.0,0.706901324,0.9847015379999999,0.0,0.0,0.586177849,0.0,0.879526591,0.0,0.8677726729999999,0.0,0.31669370199999997,0.0,1.24902225,0.0406554323,0.0,0.0,0.26965123,0.9352809590000001,0.0,0.0,1.52877658,2.09875258,1.76479427,0.26143399,0.0,0.0,0.0,0.496785904,0.0,1.73820749,0.0,2.95726874,0.14656757,2.7382927,0.0,0.6201350210000001,1.00416751,0.022484627799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.10040687599999999,2.56174021,0.626123337,3.07920006,0.23452019,1.47503122,1.81643814,0.0,0.0,0.0,1.18183482,1.23717723,0.0,0.0,0.37085133299999995,0.0,2.14140329,1.29104699,1.09303219,1.27331139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.0374912375,0.0,0.0,0.0,0.700011005,1.43015831,1.24438595,0.34184194,1.43935616,0.0,1.28368303,1.3277079,0.332619405,0.40452172299999994,1.02354371,0.967974605,0.0,0.0,0.0,0.618909626,0.303449485,0.0,0.00192340418,0.0647474553,0.0,0.0,0.0,0.992330018,1.07593441,0.282968779,0.961493802,1.52356614,0.84227219,1.38777195,3.6287351,2.49514385,3.99460793,4.29475611,3.88914966,3.74980197,3.50527395,2.22055969,3.78281181,2.3642289,1.79511592,1.8627957,0.562837235,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11319809800000001,0.0,0.0,0.0,0.0,0.642104025,0.5607254979999999,1.03613226,0.10440154300000001,0.608079461,0.0,0.0,0.366686744,0.0,0.0,0.0,0.0,0.0,0.0,0.389095156,1.40744072,1.01545466,0.28471992,0.0,1.6453875,0.0610298066,0.00276560922,0.053305134500000004,0.0,0.935048199,0.22447529999999996,0.894727717,0.9313110729999999,0.26464341399999997,0.0,0.940660844,0.0,0.0,0.0,0.24491122399999998,0.860470197,0.0,0.0,0.6179016620000001,0.0,0.63280239,0.135020943,0.826935028,0.0,0.185429094,0.0,0.0,1.14822369,0.0,0.0,1.05656186,0.0,0.0,0.0,0.278580612,0.0,0.5138444879999999,1.07975408,0.8290338079999999,1.06525111,1.55179429,0.0,0.0,1.10462084,0.2787848,0.47181317700000003,0.12324708300000001,1.25395671,0.550096236,0.0,0.289163374,0.360478135,0.0,0.689278779,0.0,0.725185854,0.0,0.0,0.156460892,0.0,0.0,0.0,0.0,0.0,0.53330861,0.579223472,0.40730499200000003,0.0,0.701244696,0.9202213509999999,0.0810767709,0.779789361,0.024660215,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.110429525,0.0,3.36917315,4.22979794,0.0,0.0,0.0154171746,0.0,0.0,1.04559103,0.0,0.18537803100000003,0.0,0.304977147,0.0,0.488463873,1.09964301,0.8106379709999999,0.0,0.24301241,0.655613317,0.0,0.0339915223,0.0,0.224164904,0.0,0.8258772320000001,0.0,0.0,0.48934232200000005,0.0,0.897205835,0.0,0.514044476,0.0,2.80232901,2.20139315,0.0,0.0,0.6423285479999999,0.0,0.0,0.604288553,0.148581869,0.0,0.623653947,0.143003985,0.0,0.0,0.0,0.348278121,1.29783803,1.22324169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.12226906900000001,0.0,1.19516964,0.0,0.0,0.44716363,0.0,0.929115033,0.48283340799999996,1.16503098,1.47875178,1.41951396,0.0,2.15163568,0.0,0.0,1.43395016,2.61281483,4.57303774,4.22130663,3.5244744,3.07666506,0.874671084,0.0,0.0,0.0,0.0,0.564690121,1.43880993,0.0,0.0,1.27229784,0.0,0.0,0.0,0.987405566,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.47860891899999997,0.0,0.0,0.0,1.32086138,1.34785497,3.08150739,5.34168599,1.86092107,1.93813054,0.256580824,0.385704373,0.0,0.196375627,0.0,0.0,1.44338953,0.00421740145,0.6286421289999999,0.0,0.70360359,1.03895567,0.0,0.79275343,0.0,0.0,0.6061348329999999,0.0,0.24408803,0.0,0.0,0.6874070440000001,0.0,0.629449995,0.395424995,0.663275564,1.33395989,0.727466444,0.34473401200000003,0.749431758,0.0,0.0,0.789456048,1.03168442,1.20174487,0.0,0.0,0.0,1.14917485,1.04752219,0.29532846100000004,0.94856094,2.26411727,1.35778437,1.0241204,0.795976042,0.589037453,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
0.027500124,0.865526322,1.78157384,2.37346161,2.40103078,1.90326329,1.14839272,0.463811242,0.0607603216,0.0,0.0232929729,0.103623005,0.112964138,0.061881455,0.008540387679999999,0.0,0.00625381503,0.0128718369,0.0,0.0,0.0,0.0,0.0472040152,0.07647111849999999,0.045543701299999996,0.0,0.0,0.0,0.0,0.0820011321,0.115038735,0.0579499016,0.0,0.0,0.0,3.00968088e-16,0.116766875,0.148857786,0.064005707,0.0,0.0,0.0,0.0152879618,0.16111461900000001,0.18937261100000002,0.0676984508,0.0,0.0,0.0,0.040840195499999996,0.22878544399999998,0.250226446,0.07060009540000001,0.0,0.0,0.0,0.08889185179999999,0.35408606299999995,0.3645669,0.0734841688,0.0,0.0,0.0,0.20754602800000002,0.675817295,0.677187882,0.0768386561,0.0,0.0,0.0,0.897272031,3.2734022,5.37261298,6.24349444,5.46510643,3.38716566,0.9445111709999999,0.0,0.0,0.0,0.08671366539999999,0.777929057,0.790447213,0.24721342899999998,0.0,0.0,0.0,0.09441534210000001,0.477754766,0.47344480000000005,0.121312616,0.0,0.0,0.0,0.10477520800000001,0.37893281700000003,0.35288313299999996,0.0638793501,0.0,0.0,0.0,0.22223992899999997,0.452243164,0.37539346,0.0362930578,0.0,0.0,0.0,0.188643217,0.48236891200000004,0.443917836,0.0931864842,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.5746948129999999,0.218495535,0.0,0.34968891700000004,0.500561053,0.17775411300000002,0.24195338100000002,0.326142638,0.26022481199999997,0.0,0.0,0.0233453822,0.0,0.00995916739,0.0,0.0,0.428955208,0.0678505552,0.0129875474,0.267689672,0.0,0.0,0.0,0.22026322199999998,0.0,0.0,0.206587143,0.0,0.0987981955,0.0921380973,0.0,0.0,0.0,0.0,0.253919507,0.189363375,0.0,0.480654605,0.377486274,0.0808692425,0.0,0.0,0.0,0.0,0.601817122,1.13097265,2.54023402,3.35265857,3.73782589,3.90159938,3.18217575,2.88111799,2.30792417,1.82154999,0.648990222,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.683174545,0.7090123420000001,0.18616406800000002,0.204970402,0.0759038841,0.126973997,0.8891517720000001,1.0911381000000002,0.69779991,0.115836729,0.6582957079999999,0.54921514,0.19660769399999997,0.0,0.0460421957,0.0,0.0,0.113340305,0.0,0.397016828,0.22541786600000002,0.193531603,0.0,0.0,0.0,0.0913022505,0.0,0.130059751,0.104088051,0.0392427817,0.196296998,0.356905985,0.0,0.0,0.0,0.0,0.248955122,0.262058697,0.0757250167,0.203452968,0.0854906373,0.0,0.0,0.379798377,0.0,0.250378182,0.284645653,0.227437532,0.0,0.349088636,0.25589536,0.0,0.0852444208,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.407815059,0.0,0.0634529822,0.0,0.495992179,0.332059082,0.0,0.128733513,0.0,0.688247851,0.0,0.0,0.145158604,0.46741320399999997,0.256702696,0.0,0.28354841399999997,0.0,0.0891833318,0.641046483,0.294230371,0.0,0.0,0.0,0.20356697199999998,0.46894934299999996,0.0,0.0,0.543625797,0.836788935,0.898799183,0.0,0.0,0.136148037,0.48824408799999996,0.0,0.352612145,0.0,0.0,1.48435829,2.2187597,1.98042584,2.31977537,2.22608348,2.21890297,3.09677104,2.78546776,2.27796521,0.583845533,0.778953138,1.91182574,3.90679113,4.67162457,4.27016234,2.78797994,1.63279999,2.25315121,2.92937102,3.79297398,4.74753734,3.74018348,3.73960702,2.28741659,1.08226577,0.685106753,0.231209747,0.0,0.315547539,0.258854342,0.260963492,0.0,1.28748005,1.63578983,0.941116697,0.451492791,0.160293362,0.39261952200000005,0.8949675890000001,0.511592357,0.23475061,0.0,0.145459426,0.260895626,0.948612827,0.28068982800000003,0.49106636200000003,0.207070787,0.20275283100000002,0.825035695,0.893496319,0.0887839729,0.0,0.0,0.0,0.983254035,0.7341386759999999,0.555458482,0.464226144,0.0,0.0,0.0,0.114593775,0.0101390913,0.21336179600000002,0.0,0.0,0.0021213943700000002,0.344263032,0.0,0.0,0.0,0.142389829,0.0369022729,0.0,0.0,0.0,0.300623364,0.267303517,0.42197183,0.224769418,0.0,0.405372997,0.0543832067,0.282846551,0.158969679,0.0,0.0,0.456391545,1.6674319,3.52820911,2.99532905,1.64064316,0.199573986,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
0.11247999199999999,0.0979824333,0.09945441320000001,0.14498571300000002,0.290409453,0.45299530200000004,0.47314362,1.0585206,0.452044206,0.7382532690000001,0.0,0.30366224399999997,0.0,0.0,0.0,0.0954729018,0.0,0.10928576699999999,0.36253140100000003,0.41232626,0.0,0.326742594,0.022476970699999998,0.23908945899999998,0.348165331,0.355871661,0.45728827200000005,0.0,0.29119641399999996,0.0,0.35721953799999995,0.20829841899999998,0.0183643261,0.0,0.185772283,0.45953059399999996,0.0,0.0,0.0,0.191655761,0.132920793,0.0,0.247148168,0.0,0.0,0.0632387202,0.34487297100000003,0.0,0.0,0.47334393700000005,0.11540295,0.0268685725,0.269220326,0.0405777565,0.0,0.0,0.0,0.364509123,0.0,0.48497886100000004,0.050497380700000004,0.28891194600000003,0.0,0.0,0.0,0.37189870399999997,0.0107308277,0.0,0.0,0.0,0.0,0.046688961200000004,0.0,0.0,0.181393368,0.14630448599999998,0.0,0.448649313,0.09482507859999999,0.0,0.166093748,0.0,0.34991089,0.0517855558,0.0,0.0,0.0,0.299468915,0.0,0.63142268,0.0747303389,0.732292963,0.8842130290000001,0.45866146399999996,0.25357024300000003,0.67260244,0.032090639,0.0,0.35759854,0.013523156599999999,0.0,0.420007743,0.0,0.310982443,0.000750670484,0.0891599123,0.20923181100000002,0.0,0.0,0.505628615,0.0646183228,0.5551957670000001,0.031494135,0.183163587,0.557873921,0.0268407109,0.0,0.0,0.0,0.435245647,0.0,0.0,0.37065552,0.0,0.33713043,0.0,0.0,0.248301448,0.0,0.439127641,0.0,0.0,0.149499971,0.512823421,0.458513765,0.0,0.0,0.265729997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18493533,0.239973642,0.0,0.0,0.0,0.322095261,0.390412648,0.256930173,0.253285192,0.127367777,0.0,0.0,0.14774399400000002,0.293241424,0.23463910899999998,0.0,0.21679864100000001,0.13969104699999998,0.00188454993,0.0,0.33912622200000003,0.396414785,0.0,0.153957341,0.301080809,0.0,0.0,0.0,0.0,0.0,0.0,0.00869735999,0.470539353,0.0,0.35983452,0.34104374200000004,0.43698344,0.0,0.127428385,0.0,0.0,0.0456592725,0.0,0.0,0.0,0.0,0.012854269599999999,0.0,0.0,0.262753198,0.748844398,0.874549008,0.859384148,0.560917322,0.0,0.0,0.0,0.250759795,0.0,0.0999242085,0.0,0.0121701753,0.43392507700000005,0.6535136220000001,1.2557622,2.47006166,2.82435177,3.70752696,4.36649793,4.24027208,4.92067238,5.13558045,4.56482808,4.89595797,4.12014128,3.6660122000000004,3.37296148,3.49046637,2.15954958,1.89977717,1.4837753,0.6035990729999999,0.77656844,0.90616998,0.7844674970000001,0.0,0.885136666,0.0611123249,0.353616974,0.164971364,0.0,0.5094653029999999,0.222621472,0.0,0.0,0.0,0.0,0.146140407,0.395928117,0.5267093070000001,0.40762221,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.044432199900000004,0.0864418991,0.700712832,0.943276606,0.24913143199999999,0.635922279,0.261614258,0.192088005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.659392555,2.20965823,2.53043694,3.81345035,3.89983357,4.28294339,4.96074038,4.3924518,4.86818902,4.31256926,3.48017078,3.4554646,1.95828884,1.93934715,1.09233492,0.958925205,0.583746,0.632246485,0.179361682,0.0,0.557700024,0.0,0.332324297,0.261654017,0.0,0.153231722,0.405216325,0.349741869,0.0,0.0,0.0,0.255710197,0.285557922,1.25463884,1.21236242,1.8030702,1.5397998,1.28139082,1.6676278000000002,0.883880667,1.04617755,0.41565267899999997,0.40294816,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.315269008,0.0,0.26755587,0.758324439,0.690752335,0.239479272,0.0,0.32169565,0.0405194895,0.13567041800000001,0.0279653414,0.015876437099999998,0.018214788500000002,0.0,0.0,0.0,0.0,0.596249885,0.354033109,0.0708799728,0.0774475246,0.46821228200000004,0.32176751,0.0,0.18909362100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.527092396,0.10900218199999999,0.0,0.057168187800000006,0.430590755,0.279285302,0.0,0.141622635,0.242996027,0.339648465,0.0,0.0,0.24471872100000003,0.25076374,0.0,0.5354443210000001,0.0,0.22234036,0.669282894,0.17786402899999998,0.0865256054,0.587562304,0.0,0.548636938,0.352290074,0.0,0.0,0.0,0.0329207064,0.0,0.106089271,0.457107471,0.229831373,0.37541037299999996,0.953315285,0.45361508,0.462347164,0.685002192,1.13184196,0.559115542,0.861496716,0.0,0.511041905,0.262602577,0.0,0.0,0.0,0.0,0.0,0.121798479,0.0,0.0,0.0,0.0,0.121466634,0.23754250600000001,0.0,0.0,0.0,0.0,0.0,0.167100403,0.0,0.0,0.0,0.11215738800000001,0.369534664,0.38462439200000004,0.0,0.170649573,0.389386719,0.305016758,0.0,0.130976795,0.0,0.25697497,0.0,0.136376525,0.0,0.0,0.10179179699999999,0.0,0.281634647,0.15376467800000002,0.0,0.570617357,0.290449552,0.0,0.19109656100000003,0.345878247,0.09029972039999999,0.0,0.166305163,0.368062538,0.315043738,0.0,0.46097612,0.515476281,0.679794775,0.331270661,0.608302675,0.0,0.0,0.0,0.0,0.0,0.0,0.078305682,0.0134644447,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40399999999999997
0.11853210300000001,0.058387689699999995,0.0047794573,0.0,0.0,0.0,0.0,0.0,0.046532958,0.12942148,0.229544597,0.341672769,0.459263353,0.574785903,0.680135435,0.767113301,0.8279497709999999,0.8558382990000001,0.8454489470000001,0.793387939,0.698571811,0.562488172,0.38932059399999996,0.185922215,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.107550979,0.5770348120000001,1.09848539,1.65504412,2.22757145,2.7954805,3.33766371,3.83346504,4.26364786,4.61130773,4.86268176,5.00781171,5.0410251,4.96120872,4.77185964,4.48091098,4.10034189,3.64559241,3.13481473,2.58800061,2.02603126,1.46969945,0.93875493,0.451021839,0.021632502400000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09885269869999999,0.280436103,0.43224145399999997,0.54651815,0.618248121,0.645255926,0.6281599170000001,0.57017513,0.47678635,0.355316184,0.21441759100000002,0.0635230238,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.113972944,0.291250791,0.47004675700000004,0.6437981939999999,0.806473463,0.952789944,1.07837604,1.17987533,1.25499466,1.30250106,1.32217488,1.31472781,1.28169539,1.22531349,1.14838708,1.05415878,0.9461822809999999,0.8282044,0.704057285,0.57756082,0.45243401299999997,0.33221339899999996,0.220176294,0.11926703300000001,0.0320251821,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00305877468,0.06428787,0.12804326,0.190441527,0.247663501,0.29616344899999997,0.33287952600000004,0.355432411,0.36229836,0.35294321799999995,0.327905224,0.28881677,0.238358524,0.180143368,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
1.67950342,0.52878185,0.0,3.34719024,6.48852906,1.77598815,0.0,0.0,0.0,0.14094061,4.56107548,11.70980952,9.09961951,2.5964343999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.15388321900000002,0.10308943400000001,0.0861463168,0.268249933,0.6917035570000001,1.18068486,1.4231122,1.19208462,0.542335185,0.0,0.0,0.0,0.19209606699999998,0.799201101,1.07040631,0.925501882,0.58859431,0.386770085,0.48765491200000005,0.784078196,1.00819158,0.968703306,0.708180285,0.450918999,0.39279010700000005,0.520356562,0.622125146,0.48879804,0.131092286,0.0,0.0,0.44164364899999997,1.26700037,1.92435547,2.09783485,1.84111097,1.54788074,1.64702031,2.25109115,3.03606219,3.45848916,3.15357709,2.2107791,1.11303055,0.385675317,0.228317701,0.416122489,0.542773011,0.40304951200000005,0.19717465,0.37748501799999995,1.2454783,2.61790247,3.84452459,4.19877914,3.37389735,1.7239052,0.0655461431,0.0,0.0,0.133160586,0.962823578,1.26946702,0.970634818,0.393003321,0.0,0.0,0.0708993168,0.22828429600000003,0.18268534,0.0,0.0,0.0,0.0,0.158576919,0.192155605,0.060817916900000005,0.0,0.0,0.0,0.0624408604,0.133235385,0.0813841861,0.0,0.0,0.0119906952,0.117983058,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.190118167,0.0650771564,0.0562053646,0.145187771,0.262227431,0.308137222,0.210597242,0.0,0.0,0.0,0.0,0.216109245,0.494289125,0.425490928,0.0,0.0,0.0,0.0,1.20458667,3.62254965,5.89102685,7.02511473,6.45145248,4.35511125,1.63004127,0.0,0.0,0.0,0.281538554,1.20203248,1.1870256000000001,0.286579737,0.0,0.0,0.0,0.35645694200000005,1.35702402,1.38732304,0.289421524,0.0,0.0,0.0,2.05381472,6.1928019999999995,9.86678933,11.5693416,10.613390800000001,7.45466805,3.43009953,0.0778217997,0.0,0.0,0.0,1.33538288,2.15691017,2.10417869,1.44220333,0.6610899060000001,0.146759271,0.0,0.0710099986,0.13616815599999998,0.0720897851,0.0,0.0,0.0,0.007783487990000001,0.204849917,0.30259992399999996,0.249512226,0.09946323859999999,0.0,0.0,0.00968407452,0.108063853,0.133294953,0.049829149100000004,0.0,0.0,0.0,0.324233944,0.72783265,1.02786909,1.07424046,0.8401508209999999,0.447424269,0.10676962300000001,0.0031518256899999994,0.190402906,0.556912341,0.8852587479999999,0.974266867,0.753888742,0.32527248,0.0,0.0,0.0,0.0,0.22068149199999998,0.292028763,0.158108939,0.0,0.0,0.0,0.0,0.17463361100000002,0.251893765,0.13715465699999999,0.0,0.0,0.0,0.0,0.22185059999999998,0.317502458,0.16851651,0.0,0.0,0.0,0.0,0.550986765,1.07952349,1.35683078,1.34582944,1.19034495,1.09392572,1.15574498,1.28512276,1.26466417,0.92642686,0.318619422,0.0,0.0,0.0603063181,1.11718077,2.31070503,3.08603618,3.06041719,2.23494536,0.99159629,0.0,0.0,0.0,0.0,0.27763158,0.435839765,0.262442344,0.0,0.0,0.0,0.0,0.154523377,0.238405819,0.140762134,0.0,0.0,0.0,0.0,0.10628095,0.15576552800000001,0.0869732074,0.0,0.0,0.0,0.0,0.0745165062,0.101497195,0.051775022999999996,0.0,0.0,0.0,0.0,0.0319169807,0.025958260299999997,0.0,0.0173023002,0.139155848,0.374424644,0.6679290520000001,0.9268693709999999,1.06805524,1.0544461,0.902489614,0.66479112,0.40661344200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45399999999999996
1.91532831,2.3638577,2.82848592,3.29320006,3.74106452,4.15506087,4.51895028,4.81810873,5.04028647,5.17624744,5.22025118,5.1703495,5.02848061,4.80035623,4.49514899,4.12499964,3.70437397,3.24930822,2.77658749,2.30290565,1.84405475,1.41418992,1.02520973,0.68628428,0.40355353200000005,0.180007205,0.0155464097,0.0,0.0,0.0,0.0,0.0,0.0,0.027351471000000002,0.09159608779999999,0.146830603,0.187937543,0.211671191,0.216685593,0.203432411,0.173943706,0.131521733,0.0803630579,0.025147383199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0279658419,0.0652234443,0.09552563189999999,0.11673200199999999,0.127524737,0.127477415,0.117050679,0.0975182007,0.07083160940000001,0.0394374495,0.00606241561,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0253228192,0.04895994730000001,0.0678436606,0.0805899735,0.08635413410000001,0.08488166679999999,0.0765106984,0.062126869,0.0430758405,0.0210416175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00456654111,0.0238975121,0.040852544500000004,0.0541009853,0.0626406105,0.065871165,0.0636341962,0.0562167664,0.044319528899999995,0.028992455099999998,0.0115439751,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00846069009,0.0245997782,0.0386171125,0.0493841295,0.0560400447,0.0580584097,0.055287002,0.0479582108,0.036669362000000004,0.0223347196,0.0061130258499999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.014002527800000001,0.0313877488,0.046624745599999996,0.0584175429,0.0657057411,0.067751663,0.0642056843,0.0551446608,0.0410801622,0.022935259399999998,0.0019907486199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00149174071,0.0357356391,0.07117834070000001,0.105431729,0.136044306,0.160671273,0.17724831,0.18415795699999998,0.180377347,0.165596637,0.14029872300000001,0.10579273800000001,0.0641962947,0.0183643415,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0267486606,0.125308755,0.244005904,0.379385021,0.526817576,0.680686557,0.834639927,0.9819009740000001,1.11561988,1.22924741,1.31690934,1.37375913,1.39628648,1.38256126,1.33239528,1.24740858,1.13099238,0.9881671390000001,0.825340163,0.649974292,0.470184848,0.29428743,0.130323057,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0671971953,0.154630375,0.230008073,0.287535765,0.323090167,0.33459258,0.322256628,0.288689575,0.23883528,0.179756694,0.12026616300000001,0.0704218496,0.0409178154,0.0424029546,0.08476958890000001,0.17645566899999998,0.323804922,0.530526852,0.797293338,1.12150095,1.49721851,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
0.615139532,0.18620536399999998,0.0,0.0,0.0,0.113306721,0.0,0.578176063,0.490182976,0.256919917,0.0,0.0,0.0,1.23302198,0.24889779,1.64826828,1.68972723,1.39495131,0.0,0.0,0.0,0.0688285012,1.40157458,0.826837811,0.421308643,1.80420465,1.5464738,0.441090459,0.914220266,0.374854629,0.0,0.722542125,2.82619546,2.80578581,2.28113001,3.8559687000000005,2.28643432,1.53800047,1.78936688,1.94436094,2.2669694,2.60536623,1.59451342,0.254807619,0.516562031,0.6155277720000001,2.14096939,0.0,1.75937446,3.41715409,1.82341584,1.47873383,0.0,0.35608686799999995,0.283401942,1.16093485,0.0,0.522929918,0.33962907,1.28334459,0.251223336,0.142853081,0.0,0.889141498,0.18819135,0.45933357700000005,0.125265769,0.241735394,0.915975315,0.9367465159999999,1.75050704,1.52254866,1.32406842,0.0,1.44334401,1.85375211,1.12289315,0.0,0.6513541070000001,0.0,1.20075983,0.866909403,0.997180033,2.31529704,1.26630625,2.36299533,1.00055445,0.0,0.666557475,0.47515683299999995,0.0723593592,0.0,0.0,0.755828319,0.697487637,0.17609101800000002,0.0,0.0,0.7063399370000001,0.481052505,0.0,0.0,0.188854482,0.227858867,0.0,1.07866365,0.0,0.30976021600000003,0.295434631,0.0,0.12155446199999999,0.8044961629999999,0.0303157998,0.0,0.0,0.0,0.0,0.0,0.159843076,0.0,0.550067437,0.7436085370000001,0.0,0.0,0.0,0.204084729,0.0,0.0,0.0799517253,0.0,0.33632804299999997,0.0,0.0,0.125174501,0.7467829890000001,0.354502944,0.0,0.0,0.06641156320000001,0.0,0.0,0.872626232,0.0,0.0,0.0474867521,0.134332601,0.258391963,0.0,0.66947279,1.26903905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.33739673299999995,0.104293121,0.0,0.0835507768,0.26379595,0.0,0.0414288535,0.0,0.234130387,0.27670602,0.0781640484,0.241032174,0.270920891,0.04761274099999999,0.355159655,0.14061444,0.0,0.148396922,0.239616816,0.0760980824,0.0,0.0,0.0,0.0,0.0020583775,0.197245382,0.0446653602,0.275921677,0.231574733,0.21358497699999998,0.09624757310000001,0.153344951,0.0157928674,0.0167910843,0.10738390199999999,0.0,0.0008929154670000001,0.0,0.0,0.109621627,0.0,0.0,0.190331482,0.118442274,0.27011351699999997,0.0313725455,0.158954184,0.29538937,0.31960148,0.15256244,0.0,0.26655185800000003,0.128293398,0.0578999275,0.0,0.0,0.503574023,0.141461291,0.337516146,0.738878942,0.906304343,1.28772922,1.28783984,1.01492198,0.620459593,0.393564643,0.545201023,0.384027185,0.0,0.0,0.0,0.0,0.0,0.0,0.08555613390000001,0.306609659,0.473950311,1.26458275,2.02838572,2.5728282000000005,2.75296365,2.919274,3.02374204,3.1138248,3.15398897,3.04580841,2.74488927,2.1598528,1.55412394,1.68718247,1.13442846,0.601303589,0.381478515,0.246206116,0.44035340100000003,0.465695795,0.259985974,0.227603148,0.11874733900000001,0.199953031,0.40472109,0.35351274200000005,0.584062165,0.301680391,0.509786298,0.312745487,0.11375886699999999,0.27215249399999997,0.17895323800000001,0.388691594,0.44635282299999995,0.726933745,1.33604521,1.69768971,2.32403321,2.32482313,2.73357233,2.95411558,2.7713148,2.44682257,2.63610437,2.73938841,2.51226979,1.61686966,1.37271897,1.79310573,1.57801357,1.40276997,1.33684533,1.40152857,1.24994041,1.48808807,1.52677144,1.31491991,1.44382189,1.51816961,1.33583722,1.75463704,1.20575259,1.22872922,0.534948684,0.41517409899999996,0.40445590299999995,0.0,0.0,0.0,0.0,0.0,0.205681883,0.0,0.333600055,0.560249435,0.417171226,0.590857441,0.18222704399999998,0.510290076,0.34898812100000004,0.311691758,0.11399437400000001,0.411722094,0.309043367,0.618240847,0.321271756,0.5711778279999999,0.609036536,0.519609644,0.506658481,0.571732554,0.623468525,0.679140588,0.660881199,0.590769285,0.97524078,0.245086313,0.29404356,0.309698588,0.395121836,0.372909771,0.470564087,0.159450233,0.180555107,0.589566975,0.755509812,0.868018645,0.6932444659999999,0.8141910929999999,1.1638349,0.8710518309999999,0.54188001,0.784821068,0.231141508,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.54779009,0.7107425359999999,0.576004564,0.8163491540000001,1.12634387,0.972012889,1.1711709,1.31468568,1.06577426,1.12563059,0.537990843,0.8855095129999999,0.649538411,0.253040753,0.507862348,0.137840607,0.0,0.0744399673,0.0,0.0,0.103247591,0.0684631148,0.0,0.232373212,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
1.17622334,0.0,0.0,0.86083335,1.36168769,0.5186637,1.13294524,2.20123203,0.0,0.0,0.0,0.0,0.73366775,0.0,1.75904452,2.85224179,0.0,0.18736354,0.0,0.20139684,0.0,1.88175913,2.13252478,4.52589488,3.02747712,1.50630343,1.48713013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
1.08262589,1.51719397,0.916507941,0.39327847299999996,0.0,0.0752791035,0.0,0.11356153599999999,1.3543376,1.7905513,0.7905538329999999,0.379275129,0.944609281,2.03843603,4.00539724,3.39464683,1.88233646,2.13715028,1.39484864,0.981379984,0.48953035799999994,0.037005625,0.21312613600000002,0.0,0.23672211399999998,0.0,0.024424837400000003,0.128403239,0.0,0.193391593,0.0,0.173358233,0.00891205845,0.0,0.0937032266,0.0,0.224683642,0.0,0.176506749,0.0,0.0,0.214733929,0.0,1.67049484,0.0851172526,2.8203326,6.83299644,0.919226925,0.0,0.42850372299999995,0.276035853,2.45946205,0.958144925,0.050571192599999995,0.407908504,0.0,0.135620666,0.0,0.0542802834,0.09555897039999998,0.576017046,0.297274586,0.0,0.19789569899999998,0.0,0.061583976299999996,0.0116108828,0.0,0.10959170900000001,0.0,0.10422571800000001,0.0,0.0203585069,0.0269319771,0.0,0.082553905,0.0,0.0712348405,0.237626255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.854148572,0.8207268590000001,0.858314398,0.625373379,0.854466952,1.56869792,1.031984,0.169657865,0.0,0.0,0.0,0.0,0.0,1.19074593,0.0,0.0,0.0,1.31552751,0.0,0.066120928,0.0,0.00912606281,0.0,0.565659412,0.155039281,0.170862283,0.0,0.641056148,0.0,0.49646696,1.12770753,0.263932887,0.0,0.605377947,0.530693248,0.0,0.0,0.123174635,0.922827271,1.17201147,0.0,0.530766144,0.535439883,0.0,0.29893773100000004,0.203431981,0.0,0.0,0.0,0.0,1.19390584,0.0,0.0,0.0,0.8271863709999999,0.053257118799999996,1.23352413,0.0,0.320455942,0.0,0.36994897600000004,0.0,0.135599546,0.5816256120000001,0.5371096710000001,1.3768904,0.887992225,0.652288299,0.9270418979999999,0.0,0.8591877179999999,0.0,1.81160685,1.23648005,0.0,0.0,0.41712438399999996,0.343838498,0.191871044,0.0,0.0,0.0,0.322492737,2.04297537,1.85216943,3.15853176,4.14462797,2.11148378,1.73998597,1.25245044,0.7968829070000001,0.137580217,0.0,0.0,0.316321363,2.25884495,1.75827221,1.14498783,1.00137303,0.044032330300000005,0.0,0.256305168,1.19833577,0.6960034559999999,0.733812989,0.0,0.0,0.5202709520000001,0.8821013190000001,1.16109321,0.0,0.306939775,0.33937314399999996,0.0,0.0306905381,0.0,0.0,0.599838934,0.9002160440000001,0.0,0.0,0.392518649,0.27013153100000004,0.491619873,0.299436771,0.536766976,0.997132908,0.0,0.539430179,0.0,0.737317342,0.0,0.0,0.667938711,0.0,0.298024181,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
7.4035013e-16,2.22105039e-15,0.0,5.55262597e-16,3.7017506500000003e-16,1.11052519e-15,9.25437662e-16,7.4035013e-16,7.4035013e-16,1.29561273e-15,1.29561273e-15,7.4035013e-16,1.8508753200000003e-15,1.29561273e-15,8.32893896e-16,7.4035013e-16,3.7017506500000003e-16,8.32893896e-16,1.5732440300000002e-15,1.2030689599999998e-15,1.01798143e-15,9.25437662e-16,9.25437662e-16,1.3881564900000001e-15,1.01798143e-15,0.0,1.01798143e-15,8.32893896e-16,7.4035013e-16,1.1567970800000001e-15,1.1567970800000001e-15,5.089907140000001e-16,1.29561273e-15,1.0642533099999999e-15,9.25437662e-16,8.56029837e-16,1.01798143e-15,1.19150099e-15,2.96429251e-15,2.96429251e-15,1.19150099e-15,1.01798143e-15,8.56029837e-16,9.25437662e-16,1.0642533099999999e-15,1.29561273e-15,5.089907140000001e-16,1.1567970800000001e-15,1.1567970800000001e-15,7.4035013e-16,8.32893896e-16,1.01798143e-15,0.0,1.01798143e-15,1.3881564900000001e-15,9.25437662e-16,9.25437662e-16,1.01798143e-15,1.2030689599999998e-15,1.5732440300000002e-15,8.32893896e-16,3.7017506500000003e-16,7.4035013e-16,8.32893896e-16,1.29561273e-15,1.8508753200000003e-15,7.4035013e-16,1.29561273e-15,1.29561273e-15,7.4035013e-16,7.4035013e-16,9.25437662e-16,1.11052519e-15,3.7017506500000003e-16,5.55262597e-16,0.0,2.22105039e-15,7.4035013e-16,0.0,0.0,42.7220412,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.465
0.783088585,0.359597334,0.84303705,0.0,0.0,0.343542156,0.0,0.6672767620000001,0.0,0.0,0.307110112,0.0,0.0215246883,0.0,0.53194905,0.0,0.7012520309999999,0.869366522,0.510489108,0.873323197,1.13927726,1.03725134,0.706080103,1.88501001,1.53189125,2.40471503,2.15270669,2.18577358,3.03296445,1.30749577,2.292106,2.2663907,2.80144259,2.41517427,2.50379297,2.66344829,2.66847747,1.71476743,2.45240653,2.47790137,2.18280515,1.26331006,1.92443832,0.0,1.22262861,0.9773900640000001,1.3462192,0.0,0.9342161940000001,0.593744476,0.36076785899999997,0.7986386679999999,1.01687256,0.159583595,0.0,0.0,0.14235277,0.669212512,0.214940018,0.166327786,0.0,0.710234055,0.0,0.0,0.0,0.14557759,0.165955864,0.0,0.0287892,0.36867190299999997,0.698497281,0.14276350699999998,0.344309116,0.0,0.0,0.206284272,0.0,0.0,0.0,0.732775919,1.27071871,0.0,0.0461740617,0.0,0.0,0.0,0.0,0.0,0.759111125,0.0,0.0,0.37091735299999995,0.0,0.0,0.523543523,0.0,0.0273212703,0.0,0.006905291440000001,0.0,0.364114613,0.08927637470000001,0.0,0.34917425,0.0,1.28794571,0.0,0.0,0.48040278799999997,0.06984606900000001,0.0,0.962163895,0.0,0.0,0.0,0.311650669,0.829652188,0.758136629,0.0,0.811036265,0.0,0.0,0.0,0.0258464596,0.428484066,0.751922805,0.39157126,0.43725627,0.0,0.46695787899999996,0.39326285899999996,1.40979826,0.0,0.0,0.0,0.0,0.060432104,0.0,0.594996569,0.211391109,0.0,0.0,0.0,0.0,0.793334456,0.259004345,0.0530814786,0.0,0.361980934,0.789308694,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.00989074056,0.261244525,0.436798998,0.0,0.245667467,0.0,0.0,0.0,0.0169369147,0.184359137,0.0,0.239048553,0.0,0.0,0.0896493516,0.0,0.38874553799999995,0.45611331,0.236997144,0.425040728,0.0,0.0,0.183330767,0.0,0.0519974517,0.0,0.0,0.275849862,0.0,0.0,0.0,0.245233289,0.335071693,0.0,0.0681490386,0.0,0.339108488,0.20449716399999998,0.205873415,0.0,0.20522211399999998,0.205239697,0.0,0.0,0.0572018646,0.0,0.35539577299999997,0.177816002,0.11050244099999999,0.18426389199999998,0.382318968,0.0,0.0,0.289351371,0.11446542400000001,0.0,0.0,0.351656278,0.24434683199999999,0.0,0.11548708099999999,0.468914504,0.17712910399999998,0.0,0.459177304,0.0,0.0,0.250391276,0.35180271399999996,0.372085999,0.0,0.0,0.050839897599999996,0.272478689,0.00933741183,0.370129654,0.0,0.0322057461,0.013566346200000001,0.0686010239,0.0,0.23371529100000002,0.0787636855,0.0,0.270130484,0.0465440579,0.0,0.218586036,0.0,0.0,0.113820625,0.0,0.314707993,0.0,0.414590114,0.0,0.11263049300000001,0.0,0.0,0.338300758,0.0674642961,0.24283565399999998,0.0,0.28409028399999997,0.331641416,0.0,0.0,0.0,0.0,0.316038659,0.20543066100000001,0.38152681200000005,0.29138412,0.518901249,0.669522659,0.518390074,0.6642308000000001,1.13308308,1.6416576,2.85595149,3.36398606,3.78669245,3.61938149,4.30440255,4.21037783,4.18643008,4.10025351,3.64214217,3.62727724,2.99896666,2.18701789,2.00830149,1.83385165,0.84799457,0.7214441009999999,0.649122388,0.714021427,0.251585153,0.207727981,0.140747175,0.427456355,0.0328974877,0.273166678,0.289749666,0.0,0.144673202,0.0,0.0,0.34389247,0.0,0.0215664625,0.0,0.0,0.152888034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.630233963,0.23197846600000002,0.0,0.6532155270000001,0.880660584,0.121349876,0.604588857,2.03039521,0.18874587899999998,0.014998149799999999,0.0,0.0360226196,0.297421706,0.0,1.2041167,2.0789561,0.0,0.301194162,0.0,0.135061618,0.0578704252,1.65570534,1.64587542,3.45345781,2.38346159,1.46737641,1.20621328,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.0700630195,0.0,0.0827880602,0.0,0.0,0.386003794,0.208249004,0.0,0.24993883100000003,0.0,0.39002192,0.7418861929999999,1.03941221,0.880571434,0.850143807,0.840909737,0.497585163,0.971934848,1.0447219,0.936324747,0.101064197,0.363508459,0.0,0.13679318599999998,0.0,0.0178385104,0.0507222592,0.132250546,0.0,0.0,0.0,0.0,0.0,0.0,0.483757192,0.0,0.0,0.45600811799999996,0.0,0.41221252399999997,0.0,0.00211423678,0.0,0.228316849,0.31454570000000004,0.300279652,0.136392768,0.0,0.299991528,0.45594140000000005,0.265801356,0.382754264,0.179638749,0.0,0.19306110399999998,0.0,0.0,0.413986175,0.313407365,0.155065126,0.19387500800000002,0.321113573,0.0,0.0,0.20035266300000001,0.36616354,0.00642518436,0.0,0.0,0.0,0.0,0.0,0.222390292,0.0,0.15417810199999998,0.38383228,0.438779439,0.42977762,0.143675687,0.0204311153,0.06364192839999999,0.0,0.021740425499999997,0.0,0.306662005,0.305792976,0.29944,0.0,0.0,0.0595921757,0.0,0.0,0.371398936,0.0,0.00912145607,0.433162166,0.157961185,0.513101997,0.19358182699999998,0.0,0.803600268,0.25074077699999997,0.238469656,0.910459858,0.179763927,0.219021054,0.0,0.0121248577,0.0562993003,0.171392847,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.104666784,0.38841385799999995,0.0,0.00664490659,0.0,0.0,0.266457283,0.176770674,0.167110932,0.0,0.010685238,0.0,0.0329882716,0.0,0.0,0.0,0.0483341405,0.753599887,0.289859166,0.384940989,0.724004584,0.300052638,0.000956112553,0.0,0.0,0.0106489007,0.0,0.0,0.527284027,0.7860306109999999,0.9859316029999999,1.63358048,2.43135289,3.04324612,3.84235727,3.74791552,3.87675051,4.23469602,4.06682864,3.61888167,3.38658159,1.96768748,1.98213621,0.812382397,0.272983476,0.0,0.0,0.0,0.0,0.858434308,1.30806578,1.29061204,2.27122823,1.76335541,2.02089411,2.68555129,1.97601589,1.91108229,1.28375581,0.640737875,0.765436529,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.154543562,0.450499896,0.0152839103,0.794690441,0.297084151,0.634597554,0.46418747,0.0,0.0,0.223763183,0.0,0.0,0.0,0.0,0.0918148119,0.023265433500000002,0.06254112839999999,0.223321445,0.6707663079999999,0.29033922,0.551802105,0.312098974,0.26676130800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.016432304499999998,0.0601736887,0.127357532,0.0,0.84261476,0.518412994,0.916769972,1.22733012,1.28464196,1.10085495,1.92035419,1.86002626,1.15942477,1.4586476000000002,1.47768105,0.76780809,0.6452323870000001,0.88228947,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39799999999999996
0.9152943259999999,0.0,0.07086381309999999,0.581817306,0.806030852,0.031686469700000004,0.0,0.0,0.23019846100000002,0.0,0.805828698,0.15183896300000002,0.8474532159999999,0.49952121299999996,0.556902577,0.7448338409999999,1.02911352,0.37406690000000004,0.141961177,0.44492954100000004,0.151954504,0.0,1.22075399,0.329801701,1.41427639,1.281255,1.40869638,1.4548534,0.0,0.0694396068,1.39925398,2.11817002,1.4617737,1.31167404,0.0,0.0,0.919638002,0.0860908425,0.874177702,0.0,1.07628683,0.0,0.37134543600000003,0.0,0.0446023672,0.8997176159999999,0.0,0.10463442,0.682812062,1.65742181,1.05212439,1.32356375,0.34320252,0.0,0.550263953,3.02397673,3.0997409,2.18957029,1.31703509,0.0,0.112388686,0.0,2.4820995,1.43424047,0.48374935,0.0,0.19424011,0.0,0.5195838629999999,1.27105213,0.0438221106,0.506967597,0.0,0.448930473,0.0,0.235699167,0.0,0.792339373,0.0438758287,0.0,1.33638061,2.00974533,0.20129943600000003,2.16492093,0.48912617,0.850595277,0.525233862,1.59818976,0.984862672,0.0,0.0,0.601783582,0.0,0.0,0.0,0.41673415,1.14710865,0.0,0.0,0.6161440229999999,0.6324209820000001,0.0,0.131172578,0.433927434,0.0,0.0,0.121869456,0.07268661629999999,0.0,0.0,0.36356203,0.63233251,0.32290102800000003,0.0,0.0,0.0,0.0,0.0,0.562540786,0.35259017,1.84109688,1.41938806,2.14093618,0.0,1.32326237,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
1.86374839,0.931979021,0.0348330402,0.685092175,0.0,0.159042156,0.0,0.0,0.0,0.0,0.0,0.0,0.254132372,0.0,0.0,0.0,0.0,0.171255463,0.46511573,0.0,0.0,0.653095776,0.27079157800000003,0.230016081,0.0,0.0545909197,1.77082994,2.0392128,0.096551179,0.44609993700000006,0.877573595,1.94381549,1.06584456,0.729479978,2.463898,1.95505145,0.48914464399999996,1.25616293,2.67800568,0.543425473,0.0,0.64117049,0.0,0.690204873,0.9456515640000001,0.169599479,0.727988635,1.18522636,1.44132368,0.0,2.33333774,4.66817903,2.62101555,5.06376461,1.59312025,1.01279799,1.09909859,0.0,0.35336876799999994,0.175841017,0.494447651,0.0,0.0790816442,0.229230183,0.456051675,0.0363454857,0.0825686896,0.0306136698,0.219423327,0.0,0.6092329000000001,0.0,0.580121601,1.95783097,1.44197192,0.164982446,0.554414758,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.0258942894,0.243431764,0.30102329899999997,0.13774666900000002,0.0,0.0,0.0,0.0,0.273420275,0.35724259399999997,0.170331044,0.0,0.0,0.0,0.0,0.34542583600000004,0.46618795799999996,0.23246752699999998,0.0,0.0,0.0,0.0,0.524622706,0.752983648,0.406870839,0.0,0.0,0.0,0.0,1.68452128,3.58873936,4.80622251,4.81765049,3.66058566,1.88960517,0.26221958,0.0,0.0,0.0,0.180083406,0.382907428,0.256020535,0.018085503899999997,0.0,0.191064961,0.655357255,1.1126945,1.35214079,1.3139638,1.10552935,0.9058573529999999,0.8368047259999999,0.891336205,0.9595625329999999,0.922014039,0.737751762,0.46747402600000004,0.22376812,0.0917058451,0.077978968,0.11964494099999999,0.13827165,0.0956920325,0.012518176399999999,0.0,0.0,0.0,0.0179853703,0.0490912355,0.039996006,0.00590308176,0.0,0.0,0.0,0.0054294535100000004,0.0127734873,0.00773480372,0.0006584219990000001,0.000410185778,0.005247142739999999,0.00569624172,0.0,0.0,0.0,0.0,0.021447071,0.0370873398,0.0246307537,0.0,0.0,0.0,0.0,0.0426523003,0.0709419024,0.04589112,0.0,0.0,0.0,0.0,0.0670140567,0.111775575,0.07276493690000001,0.0,0.0,0.0,0.0,0.09891269130000001,0.167600545,0.111015584,0.0,0.0,0.0,0.0,0.147136732,0.255481383,0.173576586,0.0,0.0,0.0,0.0,0.235084335,0.423299405,0.298682043,0.0,0.0,0.0,0.0,0.45453989100000003,0.874062265,0.662295606,0.0,0.0,0.0,0.0,3.02040166,7.28344295,11.4312623,14.1118914,14.5100446,12.706149400000001,9.58196827,6.34135131,3.92589853,2.64534526,2.19430095,1.98977454,1.58688432,0.916422373,0.231835305,0.0,0.0,0.19639449,0.45371870700000005,0.43233533700000004,0.13604117400000001,0.0,0.0,0.0,0.07853643639999999,0.338667172,0.35185433299999996,0.118460257,0.0,0.0,0.0,0.032623740299999995,0.260723645,0.28710883600000003,0.10202181,0.0,0.0,0.0,0.0237093356,0.220825026,0.256524906,0.13051200400000001,0.0,0.0,0.114727521,0.374444775,0.546006575,0.490940744,0.22134589899999998,0.0,0.0,0.0,0.0172159421,0.23791962100000003,0.27839817899999997,0.111075204,0.0,0.0,0.0,0.012468422,0.22835425899999998,0.27302269100000004,0.11312858099999999,0.0,0.0,0.0,0.00844395882,0.231391328,0.283377146,0.12214941900000001,0.0,0.0,0.0,0.00475368926,0.270235712,0.37240861700000005,0.24793483100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.485
0.36752417,0.0,0.0,0.78168782,0.0,0.50859978,0.0,0.0,0.48682902,0.85488672,0.0,0.64671138,1.42694184,0.66328952,0.0,0.14161347,0.66940732,0.20614275,0.83460338,0.0,0.35137163,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.89526588,0.94196862,0.0,0.0,0.703786,0.0,0.77506793,1.06949616,0.11291177,0.0,1.97571247,0.69313058,1.49630061,0.0,1.16105148,0.77006965,0.20977751,0.70298919,0.0,1.87556006,0.0,0.0,0.0,0.0,1.18462498,0.95435404,0.0,0.0,0.0,0.0,1.44785879,0.0,0.91480506,1.6831153000000003,0.48024485,0.0,0.54943732,1.34989675,0.0,0.0,3.26853791,2.68036378,1.50336829,1.88988741,0.0,0.0,0.96879721,0.25225669,0.0,0.0,0.11256685,2.64156794,4.70863052,3.75022724,5.44365584,2.05204774,0.0,0.0,0.0,0.92606971,1.18274054,0.11403774,0.0,0.79507145,0.0,0.43309368,0.0,0.0,0.0,1.05144228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.60441588,0.28748581,0.0,0.70187459,0.0,0.0,0.0,1.78573077,0.0,0.89414882,0.17776624,0.42220947,0.69251246,0.0,1.45709946,0.0,0.97630226,0.0,0.0,0.0,0.0,0.72273128,0.0,2.64061191,0.0,0.0,0.0,0.24889811,0.0,0.0,0.0,0.97799863,0.0,0.63228556,0.0,0.64652137,0.0,0.82008887,0.41166782,0.0,0.44746697,0.0,0.75456718,2.12758951,0.44942802,0.48964671,1.51328951,1.59775683,2.03752347,0.21141489,0.0,0.65663091,0.74147951,3.64803268,0.68837477,3.32674504,2.38052672,3.20453276,0.31244023,1.68521031,0.77378203,0.10109951,1.11499459,0.0,1.14339574,0.28935043,0.0,0.0,0.66661926,2.24209328,2.14988317,3.0543826000000003,0.4373073,0.0,0.0,1.05205062,0.98512033,0.0,0.0,0.97467323,0.0,0.54224759,1.1560928,0.0,1.70720183,1.08637055,0.0,3.57480259,2.75784349,1.15274373,0.81749224,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.219251974,0.219033977,0.219383784,0.219111597,0.210374235,0.185164918,0.14204941699999998,0.0887419991,0.0388927804,0.00511027799,0.0,0.0,0.00697558957,0.0132069289,0.0110693661,0.0034391321200000005,0.0,0.0,0.0,0.00140482131,0.0,0.0,0.0,0.0,0.00962660605,0.042171547999999996,0.0619144809,0.045070688899999996,0.0,0.0,0.0,0.0,0.0259427023,0.333861329,0.7239793809999999,1.08571599,1.29465703,1.26285537,0.98029778,0.527131706,0.047886419900000005,0.0,0.0,0.0,0.0,0.19700254899999997,0.330943697,0.280276921,0.0813403774,0.0,0.0,0.0,0.0,0.13310838,0.304618263,0.310692255,0.141099984,0.0,0.0,0.0,0.0,0.187435608,0.48535569100000003,0.570015566,0.34981095100000004,0.0,0.0,0.0,0.0,0.11111053900000001,1.30619878,2.60528556,3.61820893,4.0258513,3.70092525,2.75560529,1.49669582,0.307662465,0.0,0.0,0.0,0.0,0.32503543100000004,0.528380444,0.43460577,0.12321878300000001,0.0,0.0,0.0,0.0,0.225824403,0.600900797,0.830702651,0.85802657,0.708173666,0.46468247700000004,0.22493724,0.0583689627,0.0,0.0,0.00256708042,0.0111720066,0.0,0.0,0.0,0.0,0.006618063520000001,0.0742602011,0.140757305,0.18874492399999998,0.212820333,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.18571479100000002,0.149499171,0.207371145,0.298368051,0.308208624,0.208456528,0.109773215,0.163253475,0.40152133100000004,0.681222221,0.7968800840000001,0.669010973,0.42983301399999996,0.318581808,0.47440052,0.8122927590000001,1.09426362,1.13162757,0.9385152290000001,0.705178291,0.623579032,0.7250025309999999,0.8687367,0.8802843109999999,0.7098370279999999,0.47675333799999997,0.37447753100000003,0.525622138,0.9011009179999999,1.34725105,1.6791808999999998,1.77049354,1.60120904,1.26390404,0.933651583,0.7967493790000001,0.94804021,1.31063993,1.6536836,1.73226345,1.46923784,1.03405063,0.730241438,0.757455296,1.03726386,1.26162709,1.14326827,0.665896348,0.11550503,0.0,0.00801839391,0.371723006,0.56551979,0.37026464299999995,0.0,0.0,0.0,0.30392131899999997,0.9708483109999999,1.32887657,1.19980642,0.730322639,0.238614238,0.0,0.0,0.00439287797,0.0449371004,0.024130765699999997,0.0,0.010907290900000002,0.046854239900000004,0.054238891799999994,0.0169833479,0.0,0.0,0.023080109100000003,0.0569244097,0.032990043399999995,0.0,0.0,0.0,0.039069675,0.0823804605,0.0423227142,0.0,0.0,0.0,0.0515272473,0.10061495,0.047788231699999996,0.0,0.0,0.0,0.0651808642,0.11961158599999999,0.0527087165,0.0,0.0,0.0,0.0828139967,0.14400063,0.0587666221,0.0,0.0,0.0,0.108833021,0.18076033100000002,0.0681509748,0.0,0.0,0.0,0.154232666,0.24785830399999997,0.086538775,0.0,0.0,0.0,0.262630812,0.424624555,0.142362748,0.0,0.0,0.0,1.01148182,2.60536338,3.80826629,4.15424077,3.69800796,2.88627731,2.17743321,1.74238403,1.46507491,1.17260166,0.836076009,0.557291376,0.398655783,0.275198504,0.04929726190000001,0.0,0.0,0.0,0.7451741820000001,1.74425526,2.32151442,2.08920294,1.16328128,0.0972047518,0.0,0.0,0.0,0.313532142,0.30645301199999997,0.0232342268,0.0,0.0,0.0,0.17616847300000002,0.17042212399999998,0.00666298826,0.0,0.0,0.07087878780000001,0.22319788899999998,0.25034632100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.209356008,1.13030405,0.0,0.10600198699999999,0.0,0.701224828,0.0,1.27625827,0.0,0.0,0.601828888,0.0,0.557966682,0.6407742160000001,0.0,0.0,1.01252034,0.913285742,0.0,1.64456999,1.36950132,1.8145058,0.41688584,1.41795048,1.85154209,1.50801738,1.00585874,1.26958553,1.17173952,1.25098118,0.8329519590000001,0.0,0.0,0.0,0.43121369200000004,0.0,0.6375050320000001,0.236344083,0.0,0.0,0.0,0.45729912799999994,0.0,0.0,0.0,0.0,0.0,0.233344594,0.0,0.43390464799999995,0.0,0.0,0.0,0.0,0.0,1.88970333,2.06374546,0.0716853357,0.651107153,0.0,0.5673183970000001,0.0,0.431769636,0.0,0.0,0.0,0.612082125,0.0,0.525448178,0.0,0.347407942,0.0,0.0,0.31123553,0.0,0.0,0.645873025,1.72311656,1.14974671,0.6164815370000001,0.0,0.0127838106,0.0,0.0,0.23357075300000002,0.23369161100000002,0.0,0.534799854,0.44432167100000003,0.0,0.0,0.0,0.0,0.359206959,0.0,0.0,0.661914063,1.98911609,0.40110679899999996,0.10282316400000001,0.0,0.0,0.602551473,0.0,0.37403187600000004,0.20083995100000002,0.0,0.0,0.828134328,0.0,2.0565983,2.43820296,0.6524920160000001,3.5336182000000003,3.69653257,2.9697855,4.08259454,3.96858535,2.90810458,4.17283269,4.518337,3.72345406,3.13940874,0.09682682849999999,1.07574026,0.965879712,0.0,0.344612784,0.265804857,0.0,0.0,0.514923237,0.0,1.91183687,1.11704166,2.90975699,0.3231073,0.334171617,1.07748344,0.0,1.17973635,0.0,0.471143989,0.0,0.15814695,0.6729629009999999,0.110694493,0.732510579,0.446979695,1.14378057,1.86418181,3.37218045,0.810024691,2.87255276,2.71506115,1.83068619,1.2231614,0.9582344140000001,2.44681228,0.615958597,0.945533217,1.4465333999999999,0.45679814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.038278877200000005,0.0,0.0,0.0,0.0314750202,0.0362137599,0.0,0.0,0.295599618,0.19636762800000002,0.0,0.137323501,0.0,0.34048389799999995,0.0509310378,0.15620092,0.030265564300000002,0.35225365,0.0,0.209238153,0.0,0.0,0.0,0.0736325179,0.0,0.169317277,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10097340699999999,0.0,0.0,0.0,0.017788391299999998,0.449272679,0.158081905,0.09255474279999999,0.660493275,0.318573105,0.487127799,0.841401385,1.04252826,0.870923555,1.03841709,0.7989590259999999,0.360742337,0.9074267579999999,0.63707887,0.09818994980000001,0.202752321,0.28409434100000003,0.13824077099999998,0.0,0.0,0.0,0.0035769555600000005,0.240237515,0.0,0.0,0.33915299,0.0,0.0,0.28744688,0.0703917293,0.18097011300000002,0.0,0.167697917,0.36726836700000004,0.0,0.387433749,0.39480464,0.541026416,0.993734618,1.33136755,1.32715002,1.63015619,1.97028185,1.32597292,1.34175786,1.59409638,1.27983027,0.698185004,0.35066982799999996,0.23400207,0.394255552,0.5590569479999999,0.42311727600000004,0.12285705599999999,0.406585598,0.790069267,0.7165476909999999,0.506721384,0.16910664399999997,0.09491449269999999,0.0,0.0,0.0,0.0,0.0,0.0,0.21735064199999998,0.0952178058,0.9854609790000001,1.49997605,2.59441263,2.75577231,3.1060594,4.10035556,3.81664392,4.26507078,3.35592513,3.29147675,2.86906049,1.69335765,1.58318288,0.37524535600000003,0.492025465,0.0,0.0,0.0,0.0,0.264442099,0.39916494,0.34105357299999994,0.632675178,0.91674356,0.469104927,0.7935309890000001,0.791882251,0.073764695,0.387385401,0.24078736,0.00646946468,0.0,0.0,0.0,0.0,0.0,0.0774156608,0.0960458691,0.507304305,0.19455489899999998,0.0888568524,0.0,0.157552436,0.182326022,0.0,0.0,0.0,0.0,0.0,0.0,0.237325781,0.312438493,0.0,0.180400098,0.178129359,0.647825205,0.616339273,0.225477383,0.204072576,0.0,0.261117427,0.0683143034,0.0,0.0,0.0,0.0,0.436241499,0.00797274594,0.433493429,0.318169708,0.264486595,0.0,0.0,0.405979921,0.0,0.244669742,0.0,0.326556783,0.229552032,0.273742223,0.0889837635,0.320378471,0.21361192899999998,0.0,0.307782953,0.0,0.0138135748,0.347512573,0.560022546,0.555539604,1.02069567,1.26807306,1.09592594,1.42605261,2.0132759,2.43095151,2.23239809,2.16822688,2.79052464,2.81966141,1.97012131,2.29263847,1.77845003,1.1571728000000001,1.07081468,0.853069416,0.64679472,0.62371388,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
0.0322610609,0.0515587319,0.21708233,0.46834036700000004,0.6953270020000001,0.7932731940000001,0.715602373,0.496155296,0.228914919,0.0174899347,0.0,0.0,0.0272946265,0.120510786,0.213238683,0.352838969,0.617541777,1.0614768,1.66317733,2.30942494,2.82808192,3.05680383,2.91416528,2.43722683,1.76643071,1.08569188,0.547922964,0.222083745,0.0846338544,0.0539615126,0.0446553046,0.0109434726,0.0,0.0,0.0,0.0,0.0598253729,0.0948226605,0.0714358671,0.0019462248899999998,0.0,0.0,0.0,0.00610222914,0.079333146,0.104381167,0.0652165027,0.0,0.0,0.0,0.0,0.0228064,0.0907154635,0.102823459,0.0518007984,0.0,0.0,0.0,0.0,0.0367868436,0.09075095220000001,0.0862841617,0.0303953594,0.0,0.0,0.0,0.101961251,0.201287909,0.233945113,0.170801433,0.0364068646,0.0,0.0,0.0,0.0,0.107115532,0.168457065,0.126774983,0.006697898000000001,0.0,0.0,0.0,0.006964325899999999,0.134244418,0.181364894,0.11695995199999999,0.0,0.0,0.0,0.0,0.0382370835,0.166264121,0.19253573,0.0997878877,0.0,0.0,0.0,0.0,0.046350101799999995,0.0792527681,0.0050495283,0.0,0.17573258600000002,0.983096251,2.54126133,4.74895325,7.19123059,9.23880232,10.2636776,9.88516611,8.13730859,5.47774121,2.62708198,0.304622506,0.0,0.0,0.0,0.0,0.521222463,0.668728678,0.417362766,0.0,0.0,0.0,0.0,0.0351981307,0.259765985,0.30298132,0.166787872,0.0,0.0,0.0,0.0,0.0508471601,0.164615394,0.16916895399999998,0.0751679542,0.0,0.0,0.0,0.0,0.0463540775,0.0995870292,0.0868268632,0.0267537559,0.0,0.0,0.0,0.0,0.0127072063,0.0043919664,0.0,0.0,0.06275942450000001,0.19532968,0.343239539,0.43698236700000004,0.42419187399999997,0.305586456,0.143117684,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
0.170088028,0.193932308,0.0,0.0,0.05894582,0.0,0.244917797,0.09056938519999999,0.0313388581,0.0,0.0602315572,0.307664006,0.0,0.24763632100000002,0.644628771,0.701248523,0.43436289299999997,0.30525194,0.12845317,0.727065553,0.343910062,0.314562968,0.505377163,0.6487636,1.04117341,1.80606448,2.32304629,3.01787673,3.11286925,4.15757259,4.22013413,3.97479032,3.52913398,2.99460204,2.5907985,2.06998694,1.38644478,0.530658938,0.0,0.0,0.0,0.0,0.210416424,0.768287797,0.863538696,0.534327935,0.8748359990000001,0.8407330829999999,1.20921715,1.00456484,1.22329765,0.609611072,0.898701009,0.670964976,0.193220757,0.0,0.322084943,0.5203648820000001,0.447746734,0.46118996,0.0,0.0,0.489312587,0.40776261399999997,0.291049123,0.0,0.0,0.0,0.0,0.0,0.0,0.10356762300000001,0.0,0.41668044600000004,0.0,0.0,0.0366890582,0.0719093457,0.0,0.0,0.209022472,0.0,0.0178801723,0.0,0.283455341,0.36390095899999997,0.0,0.440683758,0.0,0.0,0.0,0.0,0.18815495699999998,0.031046001400000002,0.24120911,0.0,0.433240732,0.0,0.18315021899999998,0.0,0.254214954,0.0567805114,0.0,0.266321509,0.151588853,0.0677958155,0.0,0.055842284000000006,0.147313649,0.0,0.0,0.0,0.0,0.112921743,0.219364235,0.146508356,0.0,0.0,0.0,0.0,0.0,0.302064516,0.315853079,0.153050612,0.118310351,0.0,0.195684933,0.38349890700000006,0.0,0.17192806800000002,0.21314360300000001,0.0,0.221963248,0.248199714,0.0,0.154104767,0.474189641,0.382880912,0.0,0.263352521,0.194843397,0.0,0.26188629999999996,0.00354677145,0.0,0.26582551600000004,0.349816705,0.291713307,0.495143634,0.131485661,0.42849522700000003,0.0770253187,0.269788298,0.328691079,0.0,0.31725970800000003,0.0,0.0,0.216234423,0.0,0.407685824,0.284346205,0.0,0.0645715076,0.214814845,0.0184695102,0.0164992593,0.0,0.0,0.40484205,0.0,0.0,0.27583652,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.397
0.685023989,0.0,0.0,2.11407258,1.48773056,0.30491595899999996,0.778096683,1.94890072,1.59110846,0.0,1.8214305,2.59017184,2.09432361,4.1381392,4.23498318,3.99313422,2.60197396,2.28585665,0.0,2.06582943,0.213895799,1.05567795,0.0,1.52975754,0.0,1.22381602,0.0,0.0,0.0,0.0,0.722497422,0.0,0.532168624,0.0782594462,0.0,0.280920723,0.0,0.347463546,1.30498969,0.0,0.0,0.05129587,0.0,0.890336772,0.0,0.0,0.0030290358500000003,0.0,0.638133776,0.12306639300000001,0.0,0.0,0.286444055,0.36704627,0.291379934,0.8009142140000001,0.0,0.5120772029999999,0.0,0.0,0.325073425,0.0,0.0,0.428751172,0.527540607,0.0,1.30358073,0.739670084,0.0,0.0,0.615244728,0.309941397,0.005104541660000001,0.0,0.0,0.20061559199999998,0.221472639,0.287448169,0.0,0.0,0.195808254,2.07775818,1.64590173,0.577561587,1.06616332,0.616221538,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.510650443,0.125437065,0.0,0.0,0.0,0.0,0.0,0.09247669160000001,0.0,0.0,0.0,0.007439891109999999,0.0,0.505159908,0.0,0.6953099690000001,0.0,0.484880814,0.572731222,0.616164995,0.0,0.071631643,0.571521281,0.0,0.404389325,0.300588738,0.508958988,0.0,0.613605569,0.0,0.0,0.36153830200000003,0.0,0.386425863,0.6715222470000001,0.0,0.0,0.403262377,0.0,0.470843969,0.0,0.179884002,0.459071322,0.0,0.6414910429999999,0.0,0.29415027899999996,0.00461939045,0.10895826900000001,0.0,0.41278534100000003,0.66182363,0.5009438,0.656588527,0.625462581,0.0,0.0,0.0,0.0,0.0,0.703670997,0.0,0.0,0.0,0.320655271,0.40362204799999996,0.588206945,0.0,0.076054056,0.0,0.0949240714,0.44114570200000003,0.0,0.0,0.0144356547,0.0,0.0,0.45191440299999996,0.213448748,0.5229828320000001,0.0,0.681764186,0.25528897100000003,0.0,0.0,0.009821501219999999,0.0,0.0,0.1276344,0.279702526,0.49773645899999996,0.0,0.0,0.141560298,0.0,0.0836061016,0.0,0.554615964,0.0,0.0,0.0,0.0610949744,0.0,0.0,0.346843114,0.715876851,0.5304917370000001,0.196475307,0.0,0.537937749,0.0,0.0,0.0,0.104676928,0.0,0.590843133,0.0,0.601015944,0.207402047,0.054734108600000005,0.42115439299999996,0.0,0.0,0.0,0.541025512,0.06919427339999999,0.0,0.508584881,0.14866732800000002,0.0,0.59400491,0.6797462790000001,0.224417902,0.191379753,0.5375877689999999,0.42575444799999995,0.654601632,0.436679796,0.503051379,0.40600112299999996,0.0,0.103924756,0.190591135,0.0,0.0,0.324250195,0.179327104,0.22670772600000003,0.698522669,0.253767266,0.34533273299999995,0.18336816600000003,0.0,0.0,0.128696833,0.607509807,0.109394639,0.0,0.0,0.324846953,0.18043614600000002,0.401495056,0.398265937,0.677404876,0.102728416,0.0977844666,0.0,7.57632964,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.517240086,0.4684946,0.551476354,0.324975485,0.0178793278,0.44043371299999995,0.0,0.0,0.0,0.0364339043,0.0221300793,0.796140317,1.02604148,0.538710884,0.670707457,0.594450199,0.0,0.44432506899999996,0.0,0.018045329199999998,0.192705305,0.0,0.393640506,0.0,0.374829523,0.0,0.0,0.44978708700000003,0.0,0.0,0.0,0.0,0.00851241355,0.0,0.36936178399999997,0.0027773020299999996,0.0,0.15327291099999998,0.0,0.0,0.123647403,0.114626713,0.0,0.0,0.245688879,0.0,0.0,0.032694599500000004,0.0,0.0,0.0,0.36014308899999997,0.221635516,0.0,0.0,0.0,0.0,0.198764978,0.465628472,0.495071982,0.0642207117,0.0,0.0,0.38571466200000004,1.02045129,1.05061279,0.572406254,0.129474494,0.332180821,0.29940753800000003,0.0,0.0,0.345904239,0.0,0.0211391502,0.0,0.0,0.387961574,0.64423445,0.568441967,1.59543993,3.35543264,4.06865963,4.2801358,3.73923025,2.09247418,1.19281315,0.89013849,0.52641935,0.116252842,0.0,0.17559280600000002,0.7669056209999999,1.3468507,2.07299948,1.49605458,1.03487697,0.44375769600000003,0.0,0.0,0.609041163,1.20826603,1.4476798999999998,1.63808581,1.65288179,1.45961591,1.38357721,0.774073337,0.799853215,0.306975343,0.172778236,0.19192257,0.115993266,0.0684015067,0.0,0.0,0.0,0.0,0.0,0.317843576,0.25376481,0.0,0.20935026,0.0393074727,0.005453270279999999,0.107320413,0.0007796189569999999,0.09847265359999999,0.0,0.0,0.0,0.0,0.119530754,0.164286618,0.0,0.0,0.012742999,0.0,0.0,0.0,0.0,0.0,0.0,0.011256548799999998,0.18237827,0.134340762,0.0401997655,0.0,0.0,0.0,0.19619334600000002,0.09784528960000001,0.0,0.36109789200000003,0.0,0.175403835,0.29260327199999997,0.15642768099999999,0.22262263,0.171491065,0.21958101600000002,0.249197605,0.35854949700000005,0.0,0.150814533,0.0,0.0,0.196025824,0.10468774900000001,0.0874284896,0.0,0.0,0.0,0.178247997,0.014370906299999998,0.0,0.481707437,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
2.12738405,0.0,0.69529976,3.61757363,6.03809554,5.45260517,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.94240153,1.54101544,0.0,0.0,1.49562869,0.0,0.0,2.73920559,3.30405854,0.17930217,0.0,1.01249885,0.0,0.0,0.08800306,0.0,0.0,0.87763681,0.0,0.19552275,2.59421957,0.0,1.31857151,0.0,0.0,1.09135487,1.46299424,0.0,2.23509059,0.0,1.68304312,0.0,0.13641708,2.60606161,0.0,3.89507479,0.06896734,2.43198596,0.0,2.07877522,1.44820098,2.67949567,4.22705353,5.26945417,2.23888387,0.0,0.0,0.62591945,0.55406124,0.0,1.54680471,0.0,0.93338304,0.27490734,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
4.28628699,4.1795672999999995,3.66449273,3.09742637,2.64734045,2.01334444,2.16947478,1.81166562,0.9147932540000001,0.639869338,0.289243423,0.0852091516,0.18181598699999998,0.0,0.081767433,0.358864134,0.0,0.0,0.0,0.0,0.151390956,0.36625791,0.577980892,0.68360634,0.485234984,0.0378317512,0.298519818,0.67462216,0.0,0.466291365,0.0,0.246758463,0.265399863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.34385147200000005,0.0,0.0,0.0,0.173121143,0.46508986399999996,0.0,0.0,0.458308879,0.32761655300000003,0.32201728399999996,0.179324168,0.0628921595,0.34540182,0.298600951,0.0,0.0,0.0,0.0,0.0,0.441797696,0.48282000799999997,0.23771339100000002,0.433957506,0.0,0.134096173,0.0337060444,0.0,0.307180691,0.5162729460000001,0.0,0.393990282,0.197533375,0.0,0.0,0.0,0.09511506730000001,0.0,0.0,0.0,0.411107877,0.0,0.0,0.347050277,0.37013149700000003,0.69693029,0.772946822,0.552712092,0.30550391600000004,0.469137774,0.553360932,0.675909852,0.323177017,0.46967883,0.144365648,0.650317876,0.22810508300000001,0.53859371,0.0559613558,0.0,0.060037670300000005,0.0,0.0,0.299623237,0.123532836,0.0,0.0,0.0397079892,0.180508091,0.35458954,0.0,0.417214305,0.16710756400000001,0.426807631,0.0,0.448264746,0.0,0.13673149099999998,0.22209485199999998,0.368426621,0.41621102,0.13655863599999998,0.32508067,0.0,0.0,0.367385504,0.0,0.0,0.0,0.0,0.0,0.155124767,0.0,0.0,0.154407034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18468085199999998,0.0,0.029702666800000003,0.0222237968,0.0,0.0,0.180779988,0.0,0.0,0.0,0.35511826799999996,0.0,0.055447053899999994,0.0526992133,0.5324565379999999,0.240503448,0.354438965,0.0,0.0703976555,0.0,0.130783061,0.0,0.0,0.0,0.0,0.144866595,0.0,0.008620205,0.0,0.39272821,0.333946445,0.296552916,0.330691665,0.964806597,1.04201245,0.690882853,0.54905792,0.999438725,0.6816299029999999,0.689155848,0.9677617890000001,0.50009963,0.40189594700000003,0.695012912,0.28685230100000003,0.0,0.0,0.0,0.0111091121,0.0,0.114865385,0.0,0.149707384,0.26122671199999997,0.0,0.0,0.0,0.40609818799999997,0.0,0.0,0.398815484,0.0,0.157769207,0.0410143387,0.0,0.026032395299999997,0.0,0.0,0.511054773,0.187731617,0.520422886,1.19461356,1.11735751,1.58632687,1.67966251,1.78108747,2.3022175,2.65412716,2.97283976,3.7768538,3.92728685,3.88722688,4.28827287,4.71414168,5.02450385,5.08647505,4.84693083,4.70842891,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.28999728199999997,0.0,0.178809633,0.027949205699999997,0.0,0.507013107,0.0,0.0,2.990944,2.32421271,0.0,0.0,0.54953932,1.23079558,2.22696813,3.59959924,5.93925335,4.02942951,0.0,0.0,0.559881964,0.0,0.11560140599999999,0.166411573,0.0,0.230753298,0.0,0.0,0.206203926,0.0,0.023072719300000002,0.10685107099999999,0.0,0.11223411400000001,0.0,0.0,0.119998859,0.0,0.0,0.057625686100000004,0.0,0.0808372629,0.00363758551,0.0582945755,0.0,0.316116436,1.82238815,1.07105698,0.0,0.42951955299999994,0.528019352,0.0,1.33561138,1.65081154,1.04296049,2.20076514,2.27436894,1.21002535,1.71198186,2.57704369,1.8446145,0.629409621,0.9010980890000001,1.28625321,0.907045558,1.46299516,1.42697117,0.48994066700000005,0.947868212,0.945350774,0.176493037,0.400279441,0.33256177600000003,0.270520009,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
4.23769552,2.56804855,4.40435528,6.41141406,4.41219822,2.89801145,3.55961829,2.19155763,1.67788843,2.54238439,0.0,0.0,0.0,0.0,1.3073267,1.13037517,0.0,0.7808201790000001,1.61910616,0.5720980210000001,0.28370159300000003,0.0,0.0,0.0,1.21879487,0.0,0.834092334,0.0,0.150009273,0.0,0.157658656,0.528259635,0.556335473,0.0,2.46420169,0.533947553,1.4944335,0.035241441899999996,0.0,0.0,0.785121776,1.53236245,0.960638305,0.0,0.540332287,0.0,0.0328982069,1.30048325,0.498731955,0.0,0.0,0.179822132,0.0011904898699999999,0.0,0.0,0.0,0.0,0.0,0.530498816,1.03473914,0.0,0.5932351610000001,0.00613207772,0.0,0.0,0.455608735,0.0,0.0,0.0,0.0,0.0567910668,0.0,0.8534708590000001,0.393104775,0.8582140429999999,0.6634314179999999,0.0,0.008074177929999999,0.0,0.525080333,0.5677696320000001,0.6144986170000001,0.366846809,0.0,0.69844347,0.0,0.26984527,0.153257395,0.0,0.593424821,0.0,0.0,0.0,0.0,1.60139802,0.0,1.24032781,0.71062486,0.22735746399999998,1.41550471,0.0,0.8853384740000001,2.66284709,2.79361992,0.900102928,1.90535305,1.62383649,0.4290987,1.28721752,0.0,2.32110748,1.3155205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39299999999999996
0.0715821816,0.116536664,0.1200872,0.46170546799999995,0.025647490800000002,0.42592391799999996,0.722209827,1.68848673,4.246791,3.11056382,0.942027257,0.890280745,0.203821408,0.0,0.127181636,0.012605717800000001,0.0126978597,0.0,0.022877394199999998,0.0,0.12816090900000002,0.132391013,0.143936641,0.0422033236,0.0,0.12962193,0.0,0.0654125271,0.00557643113,0.0,0.0,2.29812379,11.003767199999999,11.3643761,1.30643604,0.0,0.777116584,0.20116648899999998,1.40243807,0.115321546,0.0,0.29620010199999997,0.0,0.360539834,0.0,0.0,0.159319936,0.0,0.19181568899999998,0.0,0.0252560258,0.07057992639999999,0.0,0.16036952,0.0,0.0688412562,0.0139971881,0.0,0.136951875,0.0,0.103883429,0.0,0.0,0.119529767,0.0,0.187778945,0.100555434,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.299872958,1.12677676,0.63014596,0.0,0.0,1.16751682,4.89625632,5.73886136,3.90864071,0.559725378,0.0,0.0,0.177486452,0.551196724,0.0,0.0,0.590476322,0.0,0.447797008,0.0,0.299501855,0.0981971539,0.548128415,0.0,0.0,0.567550172,0.0,0.23924922,0.0541960671,0.0,0.0,0.0,0.0,0.8498719570000001,2.00023859,1.84397432,0.0,0.0,0.0,0.532674298,0.324530967,0.0,0.19115899600000003,0.49750409,0.345585735,0.0,0.0,0.0,0.276969118,1.4073561,1.34683084,0.45555148799999995,0.0,0.0,0.230807547,0.5695238029999999,0.7586253159999999,1.18707105,0.898934316,0.25876589899999997,0.0,0.248229229,0.983073098,1.78524136,2.58638469,1.23969077,0.51456159,0.18913470100000002,0.0,0.662785813,0.43486536299999995,0.390909293,0.406808743,0.0,0.24016511899999998,0.5358961529999999,0.280216253,0.18448571600000002,0.0,0.0,0.758507783,0.0335514823,0.0,0.0,0.0434774137,1.30740195,0.424232447,0.7821753920000001,0.211662142,0.42778037799999996,0.516450069,0.0,0.0,0.250745998,2.79944474,3.11466637,1.9251318,0.021735946699999998,0.0,0.0,0.39776904799999996,0.8511521809999999,0.0458057463,0.104236342,0.5842571670000001,0.0,0.0,0.0,0.0,0.513003992,0.0,0.0,0.276647716,0.19324387399999998,0.0,0.7598459759999999,0.0806220077,0.304509111,0.36892995799999995,0.0808572966,0.0,0.40637747799999996,0.0,0.0555402523,0.0,0.130856321,0.0,0.0,0.518761403,0.464458194,0.130234146,0.592841601,0.0,0.781550066,1.58351765,2.00741157,2.07005414,1.37010179,0.276039615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.275830602,0.7036026240000001,1.16907916,1.65844933,2.15666765,2.64800469,3.11663829,3.54726003,3.92567066,4.23933824,4.47789385,4.6335424000000005,4.70136979,4.67953202,4.56931751,4.37507937,4.10404056,3.76598082,3.37281941,2.93811291,2.47649097,2.00305569,1.53277183,1.07987544,0.657326941,0.276332757,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.102570508,0.22309864199999999,0.32020925899999997,0.390217349,0.43122745,0.443104586,0.427357045,0.386941153,0.326001889,0.249565987,0.163205994,0.0726945239,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0368335616,0.0910226749,0.136799723,0.171833037,0.19455718100000002,0.20422798,0.20092615,0.185511638,0.159533665,0.125103808,0.0847413727,0.0412015535,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0155436472,0.0445158695,0.0693144744,0.0886190875,0.101513622,0.107523643,0.106624495,0.09922100119999999,0.0861013091,0.06836893990000001,0.0473583237,0.0245398933,0.0014212092600000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00579750609,0.0202059002,0.0324559299,0.0419156674,0.048169930599999994,0.0510339264,0.050551013799999996,0.0469756289,0.0407433622,0.0324309323,0.022709334700000004,0.012293725,0.00189361007,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0013874894500000002,0.00644979188,0.010532498400000001,0.013444778400000001,0.0150948628,0.0154937175,0.0147547064,0.013090508,0.0108086537,0.008306974620000001,0.00606999471,0.0046669109399999995,0.00475129333,0.007062066059999999,0.0124247555,0.0217514713,0.0360376814,0.056353608,0.0838280442,0.11962261,0.164894927,0.220749885,0.288179101,0.367989699,0.46072471299999995,0.566578563,0.6853121059999999,0.816172681,0.957825167,1.1083003999999999,1.26496713,1.42453329,1.58308107,1.73613935,1.87879469,2.00584049,2.1119613999999998,2.19194757,2.24093155,2.25463791,2.22963455,2.16357296,2.05540443,1.90555897,1.71607464,1.49066652,1.23472654,0.9552485709999999,0.6606761870000001,0.360674459,0.06583088349999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
0.54247229,2.51184535,0.96836157,0.81871682,0.0,0.47946125,1.17043545,0.42706542,3.93201254,6.30852221,5.27524175,5.49261792,4.86698404,6.01249415,1.78434614,3.17033807,1.13835671,0.0,2.09565461,5.4826623,4.57394612,4.75071256,2.2285952,0.0,0.0,0.0,0.13021023,0.73869188,1.78812579,0.3821598,1.53112245,0.95671995,0.0,0.12305343,0.0,0.0,1.50727973,0.0,0.0,0.0,0.0,3.09549281,0.0,0.83417453,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.11556304,0.35682179999999997,0.0,0.0,1.33331562,0.0,2.07560693,0.0,0.42063271,0.26268442,1.0927959999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
0.651184595,0.0,0.49072264200000004,0.584283976,0.0,0.304920126,0.060000493200000005,0.35468335799999995,0.540388548,0.629761221,0.0290676605,0.18029953899999998,0.223205934,0.240694199,0.178350712,0.365474911,0.0,0.153997089,0.0,0.512005434,1.16802806,3.64973025,4.08198924,3.87599943,4.97484921,6.14048217,4.95729341,1.12141444,0.0,0.98168097,0.593750902,0.210000775,0.513395884,0.671892505,0.657878706,0.133395613,0.31539518899999996,0.664066287,0.27279249699999997,1.58018384,2.41530216,1.9951444,2.68518438,2.20307356,2.72458581,3.24529617,3.00837457,3.72597697,3.23466186,1.67374015,0.18725149,0.0,0.11327732900000001,0.584145748,0.103775289,0.40435271799999994,0.571590157,0.0,0.532004477,0.0,0.0,0.500953917,0.0,0.17772836,0.0,0.0965281232,0.0,0.6720953909999999,0.0,0.0,0.00160267945,0.206334236,0.0393483407,0.0,0.17247490699999998,1.70597624,0.738917652,0.0,0.0,0.37366271100000004,1.15077979,1.13244889,0.0,0.370423485,0.0,0.0203700639,0.716836433,2.16560475,1.77603817,0.585551292,1.18346894,0.544820631,0.0,0.275936765,0.3010693,0.6756789529999999,0.401890542,0.550559571,0.0,0.12459214099999999,0.131621042,0.54989291,0.0,0.535015958,0.547378763,0.0,1.9615348999999997,1.64325948,0.9618553120000001,0.184504547,0.41949385,0.135201989,0.34784943100000004,0.820068185,0.25166159,0.00793457772,0.180238105,0.0,0.147961896,0.601139723,0.0,0.189440738,0.110716025,0.0,0.503205805,0.0357412732,0.0,0.5358556870000001,0.527876273,0.175377006,0.42809057100000003,0.0,0.08753871769999999,0.0,0.633620624,0.5759480579999999,0.167350151,0.245846355,0.7747455870000001,0.33832938700000004,0.630682255,1.34602505,0.527867751,0.42929138,0.940382704,0.506465462,0.38454518299999996,0.49423250700000004,0.0,0.808373096,0.303977405,0.29281809,0.0,0.222881825,0.8576778340000001,0.00968951078,0.586578061,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.0675307271,0.0,0.5095326729999999,0.0,0.0,0.630308851,0.0,0.0,0.307199083,0.0,0.0,0.337129392,0.470675202,0.414339963,0.0,0.0,0.359061449,0.0,0.0,0.00542172927,0.8530554920000001,0.273835916,0.0,0.5410299279999999,0.0,1.42082415,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.361054424,0.0,0.0,0.443942579,0.0,0.365090288,1.19728136,0.0,0.448818011,0.0,0.0,0.19907561399999998,0.13694368,0.0,0.686069322,0.0,0.0,0.28067965100000003,0.036332228,0.0,0.0,0.0,0.0,0.640261226,0.11676367800000001,0.478811672,0.062199431799999996,0.254463421,0.0,0.0,0.0300260541,0.0,1.14747837,0.0,0.0,0.0,0.0,0.0,0.0,0.585493225,0.0,1.70855972,0.0742013913,0.0,0.145742228,0.0,0.0,0.0663849479,0.0,0.0,0.017420286200000003,0.6638322870000001,0.0,0.373051732,0.659270317,0.0962729432,0.8471639540000001,2.37913551,1.53292704,1.29370525,1.98364401,0.602966317,0.6048283560000001,2.693998,0.584577551,0.0,0.0,0.0,0.0,0.0,0.00929509745,0.21047608399999998,0.0,0.0,0.69540501,0.7369378870000001,0.0,0.0,0.0,0.0,1.22658296,0.6624231429999999,0.0,0.0,0.0,0.0,0.273509022,0.0,0.338149025,0.0,0.526285645,0.722147875,0.0174236875,0.838848618,0.225959855,0.0,0.0,1.21818474,0.0,0.0,0.0684888413,0.0,0.508374322,0.0,0.0,0.0,0.0280882748,0.0,0.696814597,0.0,0.43785593899999997,0.782940905,0.67573652,0.0,1.60335539,0.264742309,0.460553675,0.784814283,0.0,0.126858359,0.125032941,0.238127475,0.0,0.0,0.0,0.0,0.305767639,0.0,0.146346698,0.415669499,0.205319561,0.485371334,0.0711120004,0.267636961,0.787924847,0.0,0.0,0.143621684,0.0,0.0,0.281804106,0.0169174485,1.008643,0.672654964,0.0,0.7387166490000001,0.18954083800000002,0.0,0.445105999,0.29373331199999997,0.0,0.0,0.0,0.120671825,0.649785241,0.0,0.0,0.245708827,0.489548489,0.543547778,2.06037782,0.258918616,0.0,0.0,0.0,0.0,0.823833574,0.142432775,1.70558563,1.71295756,2.17242304,2.05788126,2.40600036,3.6560326,2.92375301,2.80691088,2.2450067000000002,1.37076138,2.20940056,1.17833332,0.903408625,1.05723846,0.0,0.214443496,0.0,0.197479614,0.08904396560000001,1.62934695,1.0433373,1.7029843999999998,2.08396545,1.59505187,1.47599621,0.8314185190000001,1.89974601,0.77499914,0.783825833,0.310867862,0.0,0.336648328,1.03279908,0.0,0.535329882,0.0,0.257733194,0.0,0.255364087,0.0,0.46804761,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.100269365,0.0,0.0,0.7865321259999999,0.0,0.512531386,0.250371962,0.0,0.0,0.0,0.0,0.0,0.0,0.123443085,1.16340839,0.0,0.0,0.0,0.13842612199999998,1.08221351,0.726124228,0.622649185,0.595602109,0.0,0.0,0.0,0.184476167,0.765760928,0.0,0.0,0.3489178,0.0,0.60149322,0.780432528,0.0,0.0,1.46093305,0.0,0.33707857799999996,0.733068774,0.0,0.862349257,0.0,0.00359482187,0.0,0.36454880799999995,0.6974209729999999,0.0,0.462463161,0.45193401200000005,0.0,0.258916585,0.0,0.437642462,0.0,1.29661001,0.0,0.0,0.0,1.22892789,0.0,0.0,0.0,0.220108341,0.758319402,0.0,0.6328137979999999,0.0,0.20045959300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.210410262,1.5877968999999998,1.56824834,2.56669878,2.53596358,3.0857228,3.53700526,3.30363649,3.32959664,1.9049651,2.36412604,1.54568126,1.13172919,0.738268492,0.50477201,0.238137501,0.0,0.0,0.0,0.0,0.0835534701,0.203941605,0.7072058940000001,0.0,0.0,0.0,0.891222269,0.807017393,1.20837506,0.35612975700000005,0.0,0.0,0.28275322199999997,0.0,0.25617962,0.0,0.0,0.0,0.171484165,0.0,0.6395721360000001,0.440369555,1.06066374,0.915207303,0.0,0.0,0.332294103,0.570886291,0.0,0.265394991,0.25167771899999997,0.795328438,0.0,0.9240186359999999,0.0,0.0,0.23231562600000003,0.5378921179999999,0.0,0.0404497125,0.0,0.0636901945,0.0,0.0,1.40416933,0.503188379,0.141143695,0.400241626,0.0,0.350090565,0.567434071,0.0,0.359066526,0.0,0.0,0.0,0.918996459,0.0,0.306741172,0.397176928,0.0,0.522883911,0.702730319,0.0,0.425151939,0.815858163,0.46684344899999997,0.0,0.0,0.0,0.148140331,0.0,0.248424936,0.224905632,0.0,0.175967,0.40682001700000003,0.0,0.0,0.102111133,0.0,0.38249677200000004,0.0,0.0,0.0,0.0,0.38559066399999997,0.11948054,1.03112933,0.200267427,0.698040918,0.374091502,0.323711498,0.513002714,0.588347567,0.12098803300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.647845185,0.09986242570000001,0.45626618799999996,0.563656909,0.0,0.626774944,0.0255151368,0.9062756609999999,0.127173278,0.24132647899999998,0.0,0.376430255,0.0,0.730764437,0.0,0.522323535,0.0,0.0,0.0,1.39725378,0.500054836,0.112247789,0.0,1.05834385,0.0,0.371047965,0.004614934639999999,0.0,0.8101413279999999,0.663199399,1.32682509,1.31600712,1.23254678,0.880903792,2.05835709,1.5794504999999999,1.56412172,0.507802775,0.0,0.0,0.0,0.18550267,0.776731345,0.104570396,0.0,0.889401731,0.0874700309,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39
0.83361055,0.0,0.90336619,1.03073567,1.22277215,7.947917100000001,0.4789669,2.6696351000000003,0.0,1.1380299999999999,0.0,0.09874045,2.6468368,2.96315618,0.0,0.52008683,1.33762676,0.0,0.0,1.11586233,0.0,8.1483077,8.40008744,0.15479602,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.29388058,0.454108396,0.0,0.39497747200000005,0.0,0.347087335,0.510193212,0.326368422,0.0,0.0,0.35534704899999997,0.0,0.0,0.270753557,0.196969885,0.272141688,0.0,0.0,0.20202318800000002,0.0,0.0,0.210938787,0.08579118779999999,0.0,0.170421441,0.399862265,0.32497358,0.318469467,0.077051744,0.468810906,0.059824042,0.139107483,0.42850926799999994,0.0,0.048135411100000004,0.15069258,0.415182034,0.346090964,0.0,0.0,0.39767918700000005,0.0,0.285990961,0.0533586312,0.0,0.0,0.174692682,0.0,0.0,0.30870213399999996,0.20744833399999998,0.22317987600000003,0.0,0.0,0.305090591,0.26137849999999996,0.010475081899999999,0.332050494,0.0,0.0,0.0232517511,0.0,0.21868376899999997,0.0,0.0,0.0,0.40398383,0.29456491,0.0379490209,0.47783006200000006,0.0,0.0,0.010656328400000002,0.30172446,0.568358976,0.0,0.43599955799999995,0.0,0.0,0.0,0.0,0.0,0.0135722941,0.48453222700000004,0.0815881047,0.0,0.0,0.0,0.0633506514,0.43199167,0.550977361,0.634212545,0.233601013,0.35339077700000004,0.618308336,0.809825369,0.209412732,0.234550361,0.233200272,0.33077202899999997,0.0,0.13883120599999998,0.0,0.0,0.0,0.0,0.0,0.3239675,0.0497176713,0.25566830100000004,0.693271825,0.823444958,0.792199986,0.397286174,0.0,0.0,0.0,0.0,0.0,0.0031466525399999994,0.133921263,0.9038516759999999,1.41647781,1.96757437,2.85565605,2.94508308,3.27752818,3.51609531,3.19466024,3.2589697,2.98887357,2.70231645,2.42204888,2.05396221,2.35435482,2.02481509,2.67567263,3.29991761,3.99199032,3.92976557,4.29651762,4.32831301,4.06413192,3.63766876,2.88503429,1.63320155,1.0635626,0.08548960679999999,0.0940223631,0.0,0.0,0.0,0.0,0.152065191,0.0818676318,0.532914091,0.137917441,0.47288668700000003,0.646051674,0.627189284,0.0,0.0,0.00190977755,0.0,0.0,0.0,0.0,0.0,0.0,0.0106434142,0.0,0.0,0.0,0.371125386,0.38517001,0.194030352,0.0,0.0,0.0,0.13516171400000002,0.0,0.313789357,0.391248595,0.00717759152,0.025635193100000002,0.0,0.042227594800000004,0.173696093,0.0,0.0,0.154323505,0.0033577426299999996,0.0,0.296903779,0.13260881,0.0,0.251097885,0.262807787,0.0,0.14367154099999999,0.162419177,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.4
0.151506385,0.173302745,0.183587873,0.18701212399999997,0.18692285100000003,0.18437720300000002,0.17819217,0.165849394,0.144868904,0.11417828199999999,0.0750436152,0.031276991000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0297186398,0.054503377900000004,0.0659314463,0.0615839025,0.0427529358,0.014110601200000001,0.0,0.0,0.0,0.0,0.0,0.0,0.00583705767,0.0334565182,0.0524283196,0.0584057089,0.050322242,0.0306051413,0.00450580361,0.0,0.0,0.0,0.0,0.0,0.0,0.008148992579999998,0.019737196000000002,0.0213699122,0.013794146699999999,0.00203937968,0.0,0.00182856902,0.0328940202,0.0935690482,0.18382434399999997,0.296836879,0.419452269,0.534200794,0.622554132,0.668789954,0.663634005,0.60682859,0.50795004,0.38513957299999996,0.26185621800000003,0.16221370599999999,0.105824277,0.10325420699999999,0.153146125,0.241777274,0.34534815799999996,0.434723663,0.481796606,0.46623193,0.38117496100000003,0.236620566,0.059534341,0.0,0.0,0.0,0.0,0.16469156699999998,0.586024702,1.11979193,1.71189098,2.2939487,2.79350813,3.14533577,3.30186453,3.24090931,2.96926864,2.52156717,1.954559,1.33793408,0.743290311,0.233235138,0.0,0.0,0.0,0.0,0.0,0.0,0.033332277599999995,0.155569738,0.220258473,0.223756084,0.17631798199999998,0.09769538130000001,0.011338275900000002,0.0,0.0,0.0,0.0,0.0,0.0,0.015282425300000001,0.0325142882,0.0312945856,0.0168295437,0.0,0.0,0.00306019346,0.0395964943,0.09898353929999999,0.171902503,0.24366126899999999,0.297717015,0.319987221,0.302904021,0.248181879,0.16752910099999999,0.0809849753,0.013107341100000001,0.0,0.0225158552,0.12416239800000001,0.285969812,0.487846244,0.6992618629999999,0.8845555279999999,1.00961189,1.04857904,0.989241547,0.835901577,0.6091069339999999,0.342201381,0.07532642269999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0516066957,0.185867547,0.268833581,0.285231881,0.23500343899999998,0.13267447699999999,0.00367264455,0.0,0.0,0.0,0.0,0.0,0.0,0.0733954809,0.175289685,0.23442099,0.237209452,0.18349813199999998,0.08669912130000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0649158016,0.19341822399999997,0.287082381,0.320672723,0.283850153,0.186122768,0.057905488899999996,0.0,0.0,0.0088202941,0.283760654,0.7588212259999999,1.42616833,2.24518481,3.14549563,4.03543804,4.81479351,5.38978215,5.68784382,5.66968852,5.33650611,4.7310136,3.93204819,3.04350285,2.17935536,1.44719164,0.9328591970000001,0.6886684829999999,0.726934408,1.01973448,1.50471914,2.09582893,2.69701948,3.21669243,3.58053269,3.74084269,3.68115526,3.41576202,2.98465581,2.44510175,1.86150599,1.29538183,0.797021001,0.400021895,0.11921156699999999,0.0,0.0,0.0,0.0,0.0,0.0603974512,0.114174699,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
1.51691732,2.30768502,0.0,0.0,0.0,1.42072027,0.0,0.149232205,0.0,1.1137435,0.032055335,0.0,0.0,0.0,0.189792154,0.6839648770000001,1.32102048,0.0,1.27026369,0.349236786,0.0,0.92488904,0.0,0.0,1.15006498,1.09992138,3.53807688,3.92174031,0.809214475,0.490399645,4.81650625,0.0,1.43503543,3.59853729,0.0,1.35061704,0.0,0.152097225,0.0,0.0,0.0,0.0,1.43645891,0.0,0.0,0.0,0.0,0.38483140200000004,1.75978443,0.14126412,0.0,1.5357445,0.0,0.0,0.982013778,0.0,0.0,0.81913956,0.6756410829999999,1.03046495,0.0,1.29396303,5.94542308,2.49800536,3.16185707,4.49406082,3.91505777,0.682147209,0.47323387899999997,0.0,0.7457701840000001,0.898856102,0.15900019599999998,0.336593905,1.60217834,1.86457803,0.0,0.0498106167,0.400949338,2.53921513,1.96564835,0.0,0.0,0.912756166,0.0,2.47258153,3.86133402,2.30901194,0.316894258,0.0,0.0,0.16949275600000002,1.2239294,1.91985087,0.0,0.44468085399999996,0.0,0.439452926,0.518112066,0.21409307600000002,0.0,2.06049764,0.6421620060000001,0.0,0.269066147,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.57327555,0.0,1.51040642,0.0,0.0,0.0,0.0,0.0,0.532864116,0.510315823,0.0,0.5478040679999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.594602382,0.491119015,0.0,0.348687256,0.1190294,0.0,0.0,0.6049160720000001,0.0,0.6154759329999999,1.50024817,0.0,0.381200551,0.0,0.0,0.0,0.0,1.39153504,0.625345884,2.91120783,0.0,0.0,0.0,1.32308799,0.0,0.0,0.06598301570000001,3.65005477,2.39236525,3.80410681,4.81569579,5.09189781,4.09850919,3.61502365,2.95285278,2.64248439,0.910947218,0.9277467359999999,2.42412687,0.622093068,0.0,0.394979353,1.68016636,1.78270639,0.0,0.266045577,0.116627522,0.0755572207,0.0,0.6761912729999999,1.45727262,0.0,0.37261617,1.96753356,1.20232148,2.47157257,1.99195013,2.21862739,2.18461097,1.97027733,1.60829504,1.23385322,1.96691434,0.09717999050000001,0.576233907,1.70680828,1.52031853,0.0,0.006430651850000001,0.0,0.0,0.0,1.8129455,1.176476,0.0,0.346224615,0.49197975200000005,0.322721297,0.0,0.0,0.0,0.0,0.5221216710000001,0.0,0.0,0.0,0.0,0.0,0.0,2.73874129,0.45975882,0.0,0.0,0.0,0.0,0.0,0.032982327799999996,0.0,0.586546776,0.0,0.0,1.70636028,0.294444666,0.0,1.05281049,1.08931055,0.0,0.692899286,0.0,0.629588002,0.0,0.0,0.0,0.0,0.166586278,1.45518897,0.918230289,0.55526245,0.0,0.0,0.0,0.0675571007,0.0,2.18309497,2.27218972,1.43648715,0.459936433,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.401
0.178132134,0.0,0.0,0.0,0.022158193700000002,0.206800453,0.441723772,0.577916526,0.701859314,0.179763963,0.717629017,0.406561034,1.04557156,1.01091336,0.8257358490000001,0.644452708,1.05098073,0.547011194,1.09970507,0.168271765,0.0459996254,0.200336586,0.0,0.0744012826,0.0,0.0528589236,0.0,0.0,0.0,0.0,0.0724641638,0.20912403699999998,0.0432154372,0.387598392,0.0,0.313447407,0.0657964046,0.0,0.0,0.0403930421,0.15238125,0.0,0.163399854,0.043329263099999994,0.326147103,0.184863112,0.0,0.0,0.45093529299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.37696637,0.154685941,0.0,0.0270822857,0.0,0.0810927871,0.0,0.0,0.0,0.248759545,0.0,0.0,0.270367709,0.0,0.0,0.540555337,1.08409745,1.21630819,1.10246945,1.54424557,0.8886562379999999,0.828739538,0.758005314,1.07833447,0.28046686600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.194679538,0.587410413,0.53148517,0.0,0.46491348299999996,0.0,0.280971154,0.0864899399,0.0,0.0,0.0,0.446203632,0.509936696,0.0,0.365212639,0.27166332,0.537744522,0.43522025,0.35986055,0.0,0.210423885,0.0,0.350770354,0.0,0.0977537369,0.588528527,0.41345800899999996,0.0,0.47815610700000005,0.0783791049,0.197732563,0.0,0.0,0.0,0.11585851900000001,0.0,0.368794205,0.419823678,0.197566648,0.178562384,0.44308407,0.0,0.41350402700000005,0.08698693880000001,0.778528309,0.764706033,1.3759393999999998,1.86398874,3.40129235,3.85967565,4.09449741,4.13399182,4.95035883,4.26576773,3.76152519,2.89767848,2.28177689,1.93862118,0.6631076779999999,0.037307634,0.39703067200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.588493386,0.416109691,0.0,0.16314648,0.0,0.042904483,0.18752089600000002,0.35442448200000004,0.0680615069,0.049371005700000005,0.08420998269999999,0.0,0.0,0.514701889,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
0.6922443770000001,1.33027317,1.79829448,1.03224518,0.0,0.0,0.0,0.0,0.77915356,1.16029217,0.7587188770000001,0.6121939270000001,0.946386556,1.39463191,1.14894431,0.717497396,0.549210455,1.1122239999999999,0.344668464,0.0,0.0,0.42288009600000004,0.0,0.0,0.9610303570000001,0.636742892,0.0,0.0,0.331032618,0.0,0.0,0.579945689,0.135150973,0.381535281,0.261491872,0.438971348,0.06178240559999999,0.0,0.0,0.0,0.0,0.415622985,0.45048752700000005,0.0803693738,0.0,0.0,1.26261686,0.811430377,0.920559903,0.0,0.359667767,0.677777458,2.59548601,2.62801854,2.95854505,0.664612113,0.7191503020000001,0.6827628290000001,0.46457145899999996,0.26097354,0.0,0.0,0.134849875,0.0866584838,0.150069313,0.0,0.537716241,1.94894885,1.30906778,0.0,0.0,0.0,0.0,0.21389816899999997,0.612240589,0.353220927,0.0849190401,0.909563061,3.46337866,3.94128857,1.6689679,0.108130644,1.27666957,4.11692987,5.75907751,3.1736831000000003,1.19135537,0.0,0.257902014,1.6118566,0.689543294,0.0,1.21829934,3.76474307,3.84354077,0.775450071,0.0,0.0,0.393744486,0.0,1.54158161,1.80044723,0.170797268,0.0,0.193842132,0.597703659,1.38368468,0.0,0.0,0.681704781,0.346980655,0.0,0.6796750890000001,2.50953061,3.28962026,2.40714504,0.71917994,0.6874590190000001,1.04711392,0.7847967920000001,0.567400941,2.01503129,2.5010133,1.50064423,0.0,0.464580682,2.12346379,0.885751552,0.0,0.0,0.38459931299999994,0.0,0.0,0.0,0.54171696,0.170007501,0.33717910799999995,0.0,0.0,0.115503687,0.07250007160000001,0.37263212,0.0,0.0,0.462336921,0.0,0.249921607,0.36074956,0.0,0.288390166,0.0,0.0,0.0,0.0,0.0,0.7493402709999999,1.03202976,0.960632387,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.395
0.268625753,1.06233605,1.18724319,2.51110669,2.9962281,1.70780793,3.41706226,3.77255059,3.98372016,2.40152058,2.72170675,2.5251402,1.91872034,0.911716933,0.315264579,0.0,0.0,0.589490277,0.6900244940000001,0.0,0.0,0.11021237199999999,0.0,0.0,0.0,0.0,0.660109918,0.39370909,0.293807375,0.0,0.722805633,0.059905910300000004,0.0,0.142752806,0.32829211199999997,0.0,0.0,0.202620374,1.2371871,0.0,0.349676231,0.9164729620000001,0.139193039,0.535732426,0.699360709,0.0,0.6220687970000001,0.0,0.0,0.0,0.0,0.0,0.0,0.00827845912,0.0,0.0,0.6837502540000001,0.0,0.33993413899999997,0.0,0.82475718,0.0,0.146786573,0.921222068,0.714441256,0.275376242,0.0,0.0,0.0,0.0,0.054515929299999995,1.13878875,0.8003601770000001,1.38221655,0.0,0.055774887999999995,1.02221186,1.06362039,0.0,0.0,0.0,0.0,0.9338938920000001,0.16511979300000001,0.77910519,0.0,0.0,1.48281632,0.495716665,0.986153264,0.79356199,0.0,0.6828263000000001,0.147913789,0.0,0.0,0.0,0.0,0.655198937,0.27953272,0.0,1.32322878,0.0,0.885864401,0.16856102899999997,0.0,0.683310335,0.0,1.15716878,1.16032843,0.0,0.33741647,0.0,0.0,0.0,0.23794559699999998,0.0,0.0,0.0,0.0,0.37625033799999996,0.0,0.36932725,0.0,0.0,0.532232194,0.193993821,0.0170375933,0.0,0.0013372460999999999,0.45610762,0.0,0.471640701,0.7145584770000001,0.0,0.0,0.20463488800000001,0.0,0.0,0.0,0.256561985,0.0,0.0,0.0725490253,0.0,0.0,1.20921902,0.71196791,0.0,0.250119543,0.127281064,0.392345924,0.0,0.0,1.10562029,0.163370879,0.44005257799999997,0.7583897140000001,1.05374159,0.0,1.03940258,0.0,0.0332743877,0.44068402,1.12096047,1.10696049,0.0,1.13276991,0.675203633,1.62472101,1.43108422,1.00525107,0.74808652,0.769607204,1.55673911,0.27395922699999997,2.28565777,1.17490118,1.08157028,1.29224104,3.46569446,1.68091478,1.3919643,0.8798541,2.54403476,2.29878094,0.6959118409999999,2.91625297,0.8919229190000001,0.439898326,1.70865408,1.49537592,0.304825784,0.484406249,0.0,0.0,0.0,0.0,0.0843649947,0.407706988,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.19174684,0.96465585,2.23166704,3.37080124,3.48689132,2.81438818,2.19402953,1.17491141,0.73530283,0.80478315,0.43018919,0.0,0.10872392,0.0,0.0,0.0,0.29924376,0.11781527,0.0,0.0,0.0,0.36316395,0.17741256,0.13178034,0.0,0.0,0.0,0.32926821,0.19994926,0.28201363,0.0,0.05994334,0.04601668,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.328640525,0.0,0.0570084285,0.42516008299999997,1.32665398,0.799264602,0.822654881,0.7555998709999999,0.0,0.049771790499999996,1.31970021,1.00404054,0.0,0.0,1.11280176,0.412124114,0.287347216,0.11050511699999999,1.25983909,0.0,3.75607841,1.10264228,0.334936991,3.3687983999999997,1.28646208,0.774658622,0.790508422,0.194437533,0.0,0.421268365,0.0,0.494030894,0.0,0.744226795,0.0,0.535791409,0.0,0.853566222,0.33931434899999996,0.91404341,0.554964855,0.0,0.0,0.7547531120000001,0.0,0.0,0.27727148100000004,0.644499695,0.237961053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.11469786,1.24108859,1.2948783000000001,1.81396455,1.6336017,1.54401784,2.28729164,2.79068546,2.29640323,2.61750277,3.2656967999999997,2.29391497,1.83231392,1.64278338,2.77963164,1.03281384,1.18340957,1.44653934,1.25905896,0.52671321,0.62098473,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32323188,0.74769573,1.15700373,0.32491578,0.13451817,0.24184118,0.27327212,0.0,0.23829629,1.05203932,0.13720128,0.57017114,0.36565654,0.0,0.14211188,0.0,0.17131131,0.01619956,0.0,0.0,0.0,0.08973253,0.0,0.62965414,0.55048707,0.0,0.0,0.70564406,0.75264782,0.28268990000000005,0.0,0.0,0.30816993,0.90772391,0.3151507,0.02951733,0.97081152,0.0,0.31340854,0.0,0.08320007,0.0,0.0,0.0,0.0,0.31871504,0.46591484,0.42434042,0.57467596,0.90193794,0.0,0.0,0.0,0.0,0.0,0.0,0.23177235,0.51840693,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.384
0.5183168220000001,0.0,0.0,0.07105060269999999,0.105870743,0.0188214796,0.0189529586,0.118561786,0.08529762960000001,0.0,0.0,0.0,0.460566185,0.654929648,8.91015127e-16,0.0,0.0,1.21739777,4.74215785,7.61913073,7.91376257,5.44512754,1.95023909,0.0,0.0,0.446294855,1.31779581,1.22598814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
0.007662537170000001,0.0956214813,0.26176382600000003,0.278352353,0.072840352,0.0,0.0,0.020710322,0.180465739,0.11153279,0.0,0.0,0.0,0.14789185,0.147506033,0.0,0.0,0.0,0.10814507400000001,0.172789815,0.0194762526,0.0,0.0,0.0586450922,0.184942297,0.0784995929,0.0,0.0,0.0,0.18206786,0.13672857300000002,0.0,0.0,0.0,0.162296695,0.19197898100000002,0.0,0.0,0.0,0.123237921,0.24260688600000002,0.05446439769999999,0.0,0.0,0.0605181084,0.289660762,0.15853983300000002,0.0,0.0,0.0,0.373956367,0.43153365899999996,0.0671826879,0.0,0.0,0.274813005,0.41520285,7.09107209e-17,0.0,0.0,0.578535603,1.53890045,1.65049655,0.9093128890000001,0.219290072,0.338753087,0.91750077,0.845083947,0.0,0.0,0.0592488889,4.6206819,10.8460971,15.4703019,15.9398576,12.2907005,6.90157404,2.51416797,0.374121139,0.0,0.0583855129,0.019630808,0.0,0.0,0.10598721900000001,0.149679619,6.240143440000001e-15,0.0,0.0,0.0666408737,0.15968788,0.06430744570000001,0.0,0.0,0.0149501372,0.156490808,0.18986683199999999,0.148573727,0.139607488,0.18605071199999998,0.20353574600000002,0.126552448,0.00464415783,0.0,0.0,0.0265147476,0.032870630299999995,0.0025289862899999997,0.0,0.00889116372,0.0188884345,0.0107773502,0.0330772041,0.109409439,0.16161229,0.0878222114,0.0,0.0,0.236426069,0.734843604,1.06892546,1.06720666,1.04915561,1.60317357,2.95203526,4.54789172,5.40152187,4.9145414,3.4183692999999997,1.87529665,1.03601301,0.885724485,0.8744917320000001,0.598036675,0.177719177,0.0,0.196629122,0.49639136,0.550685442,0.32487674899999996,0.08603620869999999,0.0536565043,0.160583013,0.19224435399999998,0.0878222114,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.489
0.362900345,0.7048755,1.07770865,1.47481472,1.88878481,2.31156232,2.73463991,3.14927199,3.54669665,3.9183608999999997,4.25614276,4.55256372,4.80098568,4.99578641,5.13250863,5.20797838,5.22038906,5.16934897,5.05589082,4.88244303,4.65276366,4.37183909,4.04575025,3.68151047,3.28687975,2.87016076,2.43998254,2.00507822,1.57406296,1.15521853,0.756290556,0.38430391399999997,0.0454013837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04248059269999999,0.18305233199999998,0.308062477,0.414271638,0.49925161700000004,0.561417584,0.6000327670000001,0.615186479,0.607747158,0.579292826,0.5320220370000001,0.468648901,0.392286201,0.306320847,0.214286029,0.119734421,0.026116556200000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00815968106,0.0629541641,0.112441039,0.155115071,0.189800551,0.215678399,0.232298762,0.23957926699999998,0.237789563,0.227523315,0.20965923,0.185313034,0.155782619,0.122488745,0.08691376140000001,0.0505408119,0.014795867800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013973356599999999,0.025374395299999998,0.0339207315,0.0394990407,0.0421619296,0.0421169308,0.039708330699999995,0.0353928429,0.0297104003,0.0232515366,0.0166229635,0.0104130112,0.00515858928,0.00131524173,0.0,0.0,0.00109358055,0.00505909314,0.0108207918,0.0180386458,0.0262551564,0.0349183323,0.043410054299999994,0.0510785387,0.0572734073,0.061381729100000004,0.062863331,0.0612836771,0.056342694699999994,0.0478980767,0.035981804,0.020808909599999998,0.00277782637,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.011360538600000001,0.0523413591,0.0940666944,0.134932227,0.17327129,0.20741855,0.23577678600000002,0.25688424,0.269479939,0.272564301,0.265452491,0.247818125,0.21972523,0.181646726,0.134468156,0.0794758915,0.0183295916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06398961780000001,0.18054131399999998,0.300551701,0.42026631,0.5357592760000001,0.643060692,0.7382909809999999,0.81779803,0.8782925659999999,0.916977171,0.931664422,0.920879838,0.883945705,0.821042362,0.733244155,0.622528041,0.491753635,0.34461439899999996,0.18556059,0.019695517,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.057393951,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41100000000000003
0.28361205,0.0,0.0,0.0,0.0,4.20662173,0.0,0.0,0.5941903000000001,0.0,10.77269955,14.85993425,0.0,0.78608954,2.35535675,0.0,1.20478342,0.0,0.0,0.73963204,0.0,4.25542858,1.55421659,0.0,0.23479665,0.0,0.0,0.69559524,0.58682182,0.4838245,0.0,1.11804485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
1.28089744,0.0,0.337312613,0.0,0.533670822,0.865127483,0.928753755,1.4635143,0.59344577,0.0,0.485221767,0.0,0.0,1.43095172,0.0,0.589857729,1.3909003,1.45051706,0.0,0.693852253,0.060548091799999995,0.0,0.0,0.61685843,0.0,0.0,0.0,1.47707697,0.387892986,3.23077275,0.0,0.0,0.0539203798,0.0,1.63567482,2.03495294,0.0,0.8902090429999999,0.551288469,0.35798805100000003,0.0,0.0,0.0,0.0,0.0347552048,1.66020619,0.0,0.0,0.0048065057,0.0,0.305085195,0.0,0.0,0.152233021,0.22801614,0.22590316300000002,0.0,0.0,0.0,0.15164751699999998,0.0,0.561220487,1.32517672,0.0,0.611821266,0.239041325,0.815829215,0.0,0.0,1.09182994,0.651960992,0.0,0.0,0.0622376101,0.00974176193,0.400974735,0.6171940770000001,0.0,0.130814132,0.0,0.028243994100000003,0.0,1.50495138,0.0,0.830705727,0.0,0.0,0.0,0.0,0.0,0.88652656,3.68923983,6.23534726,6.48100957,4.78930661,2.33386207,1.34502463,0.0,0.0,0.0,0.0,0.321202347,0.153779591,0.0,0.168444665,0.117178503,0.0,0.0,1.11024383,0.669381684,0.0,0.518027124,0.0,0.0,1.05113365,0.0,0.0,0.0,0.35866475200000003,0.0,0.0,0.0,0.0,1.57380297,0.240998148,0.0,0.0,0.508479804,0.21321808899999997,0.144702519,0.0,0.9660420890000001,0.0,0.0,0.0,0.0120402879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.12263018,0.0,1.17444748,0.0937940433,0.615903619,0.0,0.0,0.0,0.0,0.102539674,0.0,0.501318136,0.0,0.124612772,0.733580729,0.239852769,0.278924008,0.528863674,0.384980428,0.0,0.267259323,0.247355272,0.707334444,0.0,0.287431897,0.0,0.9839012079999999,0.235792185,0.0,0.832908962,0.0,0.0,0.0,0.984358187,0.0,0.0,1.06421021,0.0,0.0,0.0,0.5823418579999999,0.82345727,0.44478896799999995,0.0,0.0,0.0,0.0,0.0,0.202592225,2.41075395,3.38753567,1.71036138,2.75650516,3.20485953,0.0,1.00125448,0.0,0.0,0.291717573,0.183055747,0.0,0.12248894,0.70385335,0.686983694,0.0,0.0,0.566076105,1.57987975,1.32903281,0.011306057900000001,1.0126318,0.0,0.0,0.638837361,0.10399288699999999,0.524051399,1.1832643,1.82638448,0.0,0.114798377,0.0840730249,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18460543899999998,0.07615062480000001,0.414432831,0.0,0.21194735399999998,0.0,0.0,0.0,0.0,0.0,0.858501966,1.63891472,1.3502729,2.18092944,1.09484453,2.81883988,2.09400683,1.03856642,2.46040872,1.52227028,0.910516757,0.333851682,0.0,0.448354524,1.4436862,0.015166618799999998,0.130854145,0.0,0.0,0.0,0.0,1.24175787,0.0,0.211314948,0.670414811,0.0,0.574085108,0.0,0.526046145,0.0,0.12554353099999999,0.0,0.11349352300000001,0.0,0.0,0.0,0.0,0.0,0.475273546,0.0,0.707025548,0.0,0.0,0.0,0.37121803700000006,0.0,0.392275899,0.42973913799999996,0.61063499,0.036111968700000004,0.6384987839999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
1.76700486,1.23789966,0.9356687640000001,0.892807268,0.483303285,0.289815848,0.19657434399999998,0.0258496424,0.251236411,0.19658602600000002,0.703136623,0.11341168800000001,0.50292843,0.5111608360000001,0.7855008170000001,0.27635178899999996,0.8079652420000001,0.572279346,0.41161486700000005,0.18402681899999998,0.468043734,0.802689223,0.467467934,0.152248464,0.109030004,0.0,0.032583936699999996,0.0,0.0,0.26373728,0.0,0.0,0.0,0.200581292,0.031609973900000005,0.00643943603,0.41182165600000004,0.0,0.0,0.0,0.043937254,0.110073041,0.0834119908,0.371970371,0.305302197,0.0,0.0,0.0,0.10659390099999999,0.0,0.0,0.0,0.0,0.29707497899999996,0.124146535,0.0,0.266666298,0.0,0.0,0.0,0.125922871,0.215889639,0.0,0.15163758,0.0925821377,0.43263148799999995,0.0,0.0,0.0,0.271652281,0.0,0.0,0.18830664,0.0,0.0,0.12329693900000001,0.169101473,0.05614052,0.435417294,0.21062096100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.152046732,0.0,0.2872563,0.043555583700000004,0.0,0.0,0.0,0.0,0.42766052,0.0913640443,0.399543679,0.44243256,0.103484354,0.401841017,0.5609194279999999,0.6433050610000001,0.0691194783,0.223771495,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.249194865,0.212411283,1.37947489,1.15613886,1.64436864,2.73948602,3.30780798,3.17961347,3.91946591,3.89098619,4.49427098,4.08055315,4.47764152,4.51328687,4.11429434,3.20697499,3.36454418,2.64956253,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.402
4.0202909,3.67084286,2.16237804,0.720578933,0.436789529,1.27461145,2.24082732,2.42315672,1.78354535,0.984845455,0.5976550389999999,0.603780141,0.645914557,0.5902123770000001,0.67958877,1.12462203,1.68574808,1.81228864,1.2275341,0.29180445899999996,0.0,0.0,0.24112911,0.466096316,0.21585824899999997,0.0,0.0,0.016070681899999998,0.300811597,0.221966389,0.0,0.0,0.0,0.22704526,0.312614128,0.0171315313,0.0,0.0,0.107871124,0.368789101,0.185813738,0.0,0.0,0.0,0.387938675,0.398003357,0.0,0.0,0.0,0.355667954,0.7459413020000001,0.216970837,0.0,0.0,0.171422703,2.52847579,4.40877413,4.58545496,3.29853931,2.00581312,1.96987374,3.07382068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.391
0.18588807300000001,0.0,0.204059453,0.0661099803,0.00241311979,0.0,0.217523263,0.529379473,0.0,0.690428057,0.49293195799999995,0.564480665,0.8253879820000001,0.849520707,0.0,0.211290213,0.0299335596,0.320028667,0.0,0.0,0.42952917799999996,0.0,0.0,0.0,0.44488663,0.39824265799999997,0.650384712,0.3573312,0.0,0.120147995,0.0,0.312066356,1.01815616,1.15174069,0.677768073,1.62147404,1.04312613,0.0,0.6797835309999999,0.529653345,0.276781034,0.451910708,0.515029616,0.286432054,0.997252073,0.0,0.0,0.0,0.012127726,0.588216946,0.195574075,1.2043263000000002,0.299403307,0.0,0.0,0.179474302,0.0,0.198220753,0.98804475,0.867030471,0.0,0.0,0.0,0.614888454,0.644691694,0.735538235,0.0,0.0180271124,0.0014543434299999999,0.0,0.0,1.41584987,2.06035889,2.78491684,1.91633837,1.389109,0.827422325,0.0,0.0,0.0,0.0,0.557481394,0.0,0.342755711,1.73718179,3.51727908,5.00323188,7.34070436,7.8532766,6.63283953,5.23506934,2.93500753,0.0,0.0,0.0,0.0,1.14827527,0.34361618899999996,0.53255202,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.198658532,0.137265751,0.0,0.0,4.9676061799999996e-05,0.0447830884,0.850960845,3.25262833,1.55857265,2.01033887,2.48986951,0.35663198,0.216920205,0.022979739,0.257288591,0.0,0.0,0.281401287,0.987443174,0.43647433399999996,0.04164232,0.0,0.15099426900000001,0.0,1.12678928,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
0.543086128,0.88084455,0.48337585200000005,1.80165701,1.30453709,0.0,0.6432224,0.0,0.272492218,0.0,0.22411362699999998,0.0,0.222022918,0.0,0.22258310399999998,0.291212649,1.41169127,1.85591551,0.0158816748,0.0,0.24610850399999998,0.0,1.75911444,3.68440278,0.999906423,2.61732551,1.17896105,0.169595758,0.0561344688,0.0,0.167908725,0.0,0.7189408490000001,3.82594512,3.80585794,3.46706425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
3.35022707,3.06120903,2.06618496,2.01014303,2.26336291,1.23640969,1.58207037,1.51598019,0.531657081,0.481139094,0.0,0.305077841,0.0124586579,0.0,0.0,0.0,0.43890822700000004,0.0,0.0,0.420786499,0.0,0.0,0.0,0.0,0.175226235,0.0,0.0,0.367674338,0.0984733539,0.0,0.8995755809999999,0.726900587,0.840882279,2.15255902,1.83154065,2.63971879,4.00314333,4.42857451,4.50481626,5.027500099999999,5.66926999,6.65097356,7.01826399,6.78389138,6.46362289,6.27899843,5.42365943,4.80192266,4.65264467,3.62789272,3.62892345,3.22401714,2.46702644,1.35166084,0.569878249,0.44252111899999996,0.449106374,0.622082939,0.356969056,0.0,0.0,0.210381083,0.14357675,0.599415269,0.293925045,0.625644011,0.9598305309999999,0.0,0.23196345100000001,0.0,0.576439599,0.433403119,0.409704426,0.328382283,0.0,0.0396866911,0.0,0.0,0.0,0.0,0.0,0.059362884299999995,0.32009062,0.004679059,0.0,0.0,0.30314724,0.620348562,0.229087779,0.9007867479999999,0.0,0.0,0.0,0.459463516,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17717692699999998,0.0,0.507010996,0.411363685,0.0826359364,0.18565250600000002,0.409979229,0.350737797,0.0,0.8042057140000001,0.5235685929999999,0.0,0.0,0.0,0.265778009,0.0,0.0,0.0,0.0,0.0,0.0,0.485487684,0.0,0.0,0.0810486487,0.0,0.0,0.0,0.37744063899999997,0.046327351100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0390054758,0.0,0.0785298596,0.0,0.0,0.10389380599999999,0.0,0.10601039699999999,0.19868559,0.317312912,0.026124575,0.587871756,0.447419222,0.493732788,0.183645476,0.557627495,0.0,0.297017786,0.0,0.0,0.0635141609,0.0,0.0,0.0,0.0,0.343564685,0.38211507899999997,0.7558541609999999,0.452108209,0.0178457193,0.287376625,0.0,0.703430071,0.0439171088,0.508643429,0.0,0.08763128560000001,0.0,0.088504706,0.0,0.0,0.0,0.06952417179999999,0.0,0.0,0.392063217,0.0,0.45049299299999995,0.147118805,0.030775751299999998,0.237903043,0.7272888279999999,0.7483256429999999,0.629317382,0.27012929999999996,0.949018061,0.514366031,0.0,0.08877384449999999,0.0,0.285037815,0.0,0.0,0.0,0.0,0.0,0.0,0.466415774,0.04808725690000001,0.916543048,1.94025806,2.02329086,1.62441377,2.14406482,2.50775698,2.60045332,3.64576728,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
2.72475829,4.30824401,2.59515639,2.56684883,3.79663736,2.96858599,2.12814222,2.72070605,2.79832306,1.49643718,1.58307964,0.662843883,1.38931941,1.49856868,0.548582652,0.598298926,0.0,0.0,0.0,0.502842742,0.0,0.0,0.0,0.0,0.0,1.10769844,0.0,0.0,0.0,1.29874975,0.0,0.0,0.0,0.0,0.24171868600000002,0.0,0.0,0.0,0.0,0.0,0.46156380399999997,0.720420973,0.0,0.0,1.05648767,0.74844143,0.337040121,0.0,0.16576162,0.9841258359999999,0.0,0.037973719100000004,0.0,0.985117638,0.224727216,0.0,0.0,0.198732457,0.0,0.12096097300000001,0.0,0.253150379,0.0,0.0,0.0,0.0,0.0,0.0381647062,0.5054567010000001,0.9059585490000001,0.0,0.0730095838,0.0,1.53382301,0.0,0.0,1.98527258,0.89941494,0.554355143,0.34169695299999997,0.127771681,0.0,0.0663969255,0.0,0.0,0.09292102199999999,0.316430828,0.0,0.0,0.0,1.06268164,0.0,0.0,0.207919171,0.62975293,0.0,0.0,0.0,0.7156998840000001,0.0,0.0,0.0,0.326430061,0.0,0.0,0.0,0.187536087,0.45372213100000003,1.16276022,0.298857284,0.61792591,0.0,0.44205130299999995,0.0,0.46251511,0.0,0.143940981,0.0491290271,0.9208016840000001,0.0,0.0191287279,1.62412438,0.0,0.0,0.838743417,0.0,0.0,0.0,0.407624795,0.0,0.0,0.9453990240000001,0.0067246949,0.0,0.0,0.0,0.525084342,0.6976797290000001,0.0,0.0,0.273442494,0.380068543,0.0,0.0,0.158523603,0.0,0.0,0.0,0.0,0.141797136,0.172895545,0.21687231199999998,0.0,0.0,0.48604219,0.0,0.0,0.77692708,0.0,0.669678137,0.06350450740000001,0.0,1.1752966999999999,0.0,0.8372104090000001,0.0,0.0,0.40542902299999994,0.0,0.0,0.619923798,0.0,0.0,0.329659898,0.571039969,0.0,0.0,0.0,0.8917634870000001,0.861207299,0.0275408258,0.34150373,0.0,0.0,0.632479772,1.23381831,1.82879573,0.07879812950000001,0.552983114,0.58801002,0.0,0.521190927,0.433523174,0.254304421,0.0,0.0,0.0,0.34373214700000004,0.0,0.0,0.45969882700000003,0.0,0.0,0.0,0.0,0.0,0.30828220100000003,0.0,0.0,0.0,0.0,0.0,1.39212779,0.6772812579999999,1.40666384,1.74932946,1.47656545,1.07184626,0.803055428,1.95112114,2.3958971,3.11805319,1.11167443,2.59209058,2.99608572,3.11378566,2.71209948,2.83515016,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.183027372,0.0997812025,0.0970202268,0.135424901,0.12042857,0.025374626,0.0,0.0,0.152879218,0.329163531,0.371441487,0.263513559,0.114002391,0.032954553,0.0268915318,0.024428388,0.0,0.0,0.0,0.0487527351,0.0687720484,0.0,0.0,0.0,0.108026494,0.36932132700000003,0.5147570029999999,0.45025617799999995,0.246013187,0.0558141691,0.0,0.0,0.015004586299999999,0.015303503500000001,2.0841149e-16,0.0,0.0,0.00495631939,0.038541373,0.124349751,0.262664152,0.414309865,0.5337211789999999,0.600512528,0.605506862,0.5192213410000001,0.310790981,0.021798530299999997,0.0,0.0,0.109641653,0.48231188799999997,0.6741385040000001,0.563863536,0.276899891,0.0495688753,0.0,0.0126641124,0.0,0.0,0.0860660572,0.734194866,1.78417447,2.84196013,3.44706504,3.38537922,2.78691779,1.96550246,1.18967792,0.583876397,0.17799222399999998,0.0,0.0,0.0411741888,0.101548875,0.0715481637,0.0,0.0,0.0,0.031411074500000004,0.0471096954,0.00428006123,0.0,0.0,0.0146119397,0.0388026098,0.013447818,0.0,0.0,0.00299062446,0.029399523900000002,0.017138383899999998,0.0,0.0,0.0,0.009665426329999999,0.000303532953,0.0057078261100000005,0.0759491014,0.19932428800000002,0.291978366,0.279736633,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.34353833,0.0,0.0,0.0,1.84149908,5.40393822,8.5921958,10.06010877,9.14395057,6.21235284,2.4906801,0.0,0.0,0.0,0.05480079,1.52283561,2.11302462,1.64139123,0.56762403,0.0,0.0,0.0,0.50331499,1.00570575,0.97052639,0.48898506,0.0,0.0,0.07738465,0.70126739,1.25369959,1.41627304,1.13112222,0.611712,0.1767434,0.0323852,0.15328614,0.33504615,0.36817604,0.20185942,0.0,0.0,0.15767028,0.59709228,0.990567,1.08805831,0.81644583,0.33755040000000003,0.0,0.0,0.08066310000000002,0.39296339,0.50990119,0.29200145,0.0,0.0,0.0,0.0,0.38416946,0.68485991,0.53353608,0.02381214,0.0,0.0,0.09051649,0.98135517,1.59113061,1.39574418,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.227891562,0.125966555,0.0,0.0,0.0,0.0731862378,0.037912976800000005,0.0,0.0,1.19477311e-16,0.0811928167,0.271402321,0.6316905939999999,1.01386647,1.09229829,0.7100321940000001,0.161095404,0.0,0.42020688799999995,1.0358001000000001,1.14111451,0.498969826,0.0,0.0,0.254241843,1.46942186,2.25404654,2.27068169,1.99318027,2.14693112,2.89621646,3.6265727,3.54597599,2.48252793,1.06404919,0.11627576699999999,0.0,0.095518837,0.137583491,0.0,0.0245804708,0.380694999,0.737492815,0.634028079,0.141245468,0.0,0.7821769479999999,2.3485112,3.60912723,3.59705126,2.35123508,0.851155647,0.0736179741,0.181192866,0.621480061,0.866946687,0.8953759370000001,0.966901018,1.14298134,1.21471103,1.07285981,0.944552397,1.12415025,1.53511986,1.72319471,1.34686722,0.5885590279999999,0.0,0.0,0.084747281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.389
0.38359049,0.663655814,0.8072905309999999,0.677856225,0.17602726600000002,0.556288496,0.190346033,0.16346676400000001,0.565038947,0.0437397319,0.15786292,0.0372255667,0.0,0.19636017600000003,0.271091721,0.08219225849999999,0.0,0.209370985,0.0,0.0,0.0,0.0,0.0,0.0,0.170875534,0.277326672,0.211890732,0.248109583,0.282581374,0.0,0.0,0.235279658,0.0,0.316657565,0.198253928,0.0,0.0832250472,0.0,0.181842258,0.0,0.162776954,0.0,0.0,0.0,0.25712298699999997,0.17784107300000002,0.0,0.0,0.20926952199999999,0.0731183578,0.11732253,0.167753529,0.0,0.0014346381099999998,0.0,0.0,0.257124827,0.10940309699999999,0.254777758,0.0,0.194916198,0.414885037,0.807287443,1.13411561,1.20969121,0.714420363,0.322227605,0.121287416,0.0,0.012924032,0.0,0.375421815,0.494992703,0.9964243220000001,1.1012206,1.42199893,1.157233,0.414349431,0.00633467193,0.057640539000000005,0.721651288,2.0025566,1.75005228,1.89742192,0.843852508,0.0315810046,0.0,0.273954817,0.83096481,0.987974138,1.59852731,1.31081172,0.864478071,0.18930031100000003,0.0,0.0,0.0,0.266337193,0.134046078,0.0,0.0,0.0,0.0323593609,0.650973373,1.28200563,0.8228828990000001,0.763587012,0.48138264700000005,0.49206399100000003,1.00635597,1.02288364,0.404260809,0.380187465,1.09496369,1.02876626,0.779415092,0.498732151,0.0,0.876120487,2.09010333,3.23943954,3.28989374,2.45639116,2.112485,1.95055452,2.9450385,3.55611358,2.80799519,1.53854418,0.57767245,0.238264224,0.533993579,1.02609656,0.547376039,0.0897762377,0.0,0.11389694199999999,0.403459245,0.638188601,0.42752270700000006,0.0410900119,0.0,0.302350295,0.24812348399999998,0.576895365,0.388643597,0.0100974063,0.0745538779,0.285816537,0.386436602,0.37577800100000003,0.18046814600000002,0.0,0.19658213100000002,0.103302311,0.324514272,0.0,0.133956537,0.0,0.255269605,0.0,0.0,0.0,0.0,0.006858029770000001,0.499011185,0.21146585,0.018464334199999998,0.0,0.104852059,0.43869817200000005,0.555560157,1.19626013,1.80310655,1.320088,1.2597709,1.08005655,0.0,0.0,0.0,0.156177592,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
2.01531885,0.651391443,0.0,0.0,0.0,2.17274332,1.07284577,0.0,1.06797781,0.0,2.91609409,1.02810073,0.0,0.0,0.756047315,4.67551424,3.47033413,6.88138583,5.64208944,6.02650775,2.20930474,0.0,0.013862819699999999,3.01647137,9.00612287,3.82625674,0.342150144,0.0,0.0,0.834018413,0.084902796,0.0,0.0,0.580439448,0.6343089789999999,0.621875772,0.0,0.0,0.381416871,1.18553508,0.0,1.54220837,0.664719976,1.10523596,1.7850515,1.67053237,0.400524421,0.0,1.11738059,0.0,0.0,0.0,0.0,0.7980370440000001,1.88220381,0.0,0.0,0.0,0.69624882,1.69766945,0.0,2.09976744,1.03079923,0.0,0.0,0.0,0.729103992,0.9457922009999999,0.0,0.08402891119999999,0.0,0.463301955,1.56742904,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
6.25156516,5.25248234,4.84500837,2.79936211,1.57564248,0.0,0.0,0.0,0.0,0.0,0.0,0.589879798,1.31069512,0.051580818099999995,0.138306989,0.0934597422,0.0,0.0,0.0,0.143995084,0.185865179,0.62751211,0.41109930899999997,0.27746929600000003,0.918648318,1.12971848,0.276899695,0.939835525,1.37787591,2.08402305,1.58294469,2.00676547,2.68296459,2.49626211,1.89793681,1.47536769,1.73206887,1.2965205,1.36439428,1.16130451,0.442199356,0.7806656340000001,0.190525245,0.0,0.0,0.128861164,0.0,0.0,0.0,0.385453036,0.334623408,0.0,0.57745576,0.0,0.0,0.213454539,0.295793682,0.438599574,0.0,0.673246475,0.301252111,0.0,0.117159355,0.0,0.0,0.50051347,0.408609935,0.23582392800000002,0.331228332,0.107709228,0.38131074299999995,0.39496298700000004,0.211795517,0.10738442,0.38085977600000004,0.0,0.0,0.151651575,0.498591671,0.20154860800000002,0.0,0.13756949400000001,0.0,0.0434309104,0.256789735,0.316183677,0.0,0.274807922,0.0,0.0,0.0,0.316540237,0.0,0.0,0.33543481,0.0,0.0,0.64210001,0.0,0.493135245,0.0,0.298866226,0.276479687,0.681145718,1.05637253,1.13765352,1.38957303,1.45010739,1.91985184,1.7464821,1.67739768,1.29862074,0.312519091,0.551035085,0.0,0.0,0.0,0.0,0.0,0.33566744,0.335850369,0.0,0.0,0.0,0.27141393,0.7339757140000001,1.12262955,0.857888799,0.7589784540000001,1.03751589,1.8789066000000003,1.6462699,0.532613927,0.8807745459999999,0.461916506,0.388213675,0.0,0.35806625200000003,0.590630023,0.184597911,0.0,0.08517343390000001,0.0,0.375494179,0.0,0.0493048379,0.0,0.304990826,0.15146357,0.323174051,0.0,0.0,0.0,0.0,0.0,0.513315764,0.0,0.0,0.0,0.149061412,0.0,0.0,0.205508755,0.408819362,0.16729108,0.0,0.0383897108,0.0731320896,0.061096944900000005,0.17657093899999998,0.487456491,0.0,0.0,0.33662853600000003,0.0,0.50726432,0.32690515800000003,0.0,0.595099383,0.427254739,0.016263013700000002,0.0,0.0,0.201228555,0.136432324,0.813578019,0.0524694779,0.303132348,0.032801418799999996,0.0,0.0,0.0,0.0,0.554341552,0.7315238709999999,0.577597472,0.0,0.0,0.0,0.0,0.0,0.0,0.451939045,0.0,0.0,0.28035546100000003,0.596014889,0.0,0.04077352,0.0,0.0,0.0,0.0,0.680030637,1.30978559,1.95234106,1.06964492,0.7923581270000001,0.35176136700000005,0.32685799,0.0,0.0,0.07406704830000001,1.02697735,1.25172292,0.447732884,0.0,0.0622713462,0.0,0.0,0.0,0.697462487,2.04555048,3.61227765,5.10416154,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.77315252,0.0,0.0,2.54622328,2.05608569,0.0,0.0,0.60295753,0.0,0.0,1.85528591,0.43947507,0.68397835,2.74038864,3.24722323,2.41770297,0.57763359,1.100827,0.70978038,0.87061109,1.2902271,1.96001669,1.48133463,0.0,0.0,0.0,0.0,0.0,0.0,0.66316756,2.47108556,1.27859341,4.25532564,4.67951066,4.36284138,4.55864121,3.05375876,1.3691216,1.43998073,0.18874807,0.0,0.0,0.0,1.66013482,0.0,2.27948916,0.35631512,1.18305488,0.0,0.2129814,0.65655527,0.0,1.7778541,0.88611768,1.82877272,0.0,0.0,0.61728883,0.0,0.03922886,0.0,0.92978154,0.77397949,0.0,0.0,1.89282583,0.0,0.03994763,0.0,0.87113515,0.60935599,0.0,1.51840596,0.0,0.0,0.79313075,1.90980779,0.0,0.0,0.75259164,1.03326053,0.0,0.0,0.0,0.13830439,0.29189190000000004,0.0,0.0,0.26401535,1.60377113,0.0,1.00882914,0.0,0.28131131,0.0,0.0,0.19832983,0.0,0.0,0.2636967,1.73949868,0.0,0.0,0.43456721,0.0,0.46691922,0.0,0.91500285,0.50953506,0.0,0.0,0.98826865,0.0,0.0,1.03062181,0.31632733,0.93675521,0.62924823,0.0,1.98116808,0.0,0.0,0.0,0.0,0.0,0.24195416,0.0,0.0,0.0,0.0,0.0,0.37073083,0.0,0.65583084,0.85787047,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.47560097,0.50757411,0.47720804,0.87352898,1.15780926,0.0,0.32622462,0.76091881,0.0,1.05874804,0.0,0.0,0.26638166,0.0,1.19384269,0.57888664,0.0,0.0,0.0,0.0,0.12105554,0.0,1.10147359,1.97068789,2.72422041,2.09206974,1.74109564,2.51039956,3.03966557,0.0,0.08980397,0.0,0.0,0.0,0.93350754,0.0,0.0,0.66277453,3.99458021,0.0,0.0,0.91361496,0.55365906,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39899999999999997
0.531148496,0.976574362,0.296981636,0.0,0.8498436420000001,0.0,0.192729368,0.0,0.0,0.0,0.0,0.538507009,0.21517804100000001,0.0788446047,0.31476518800000003,0.673160303,0.0,0.21199539999999997,0.0,0.36368363299999995,0.235005336,0.44581173700000004,0.0,0.006077563120000001,0.45975579200000005,0.0,0.6178283920000001,0.302252594,0.0,0.0,0.0,0.0,0.353968259,0.49584744,0.3022681,0.0,0.604095002,0.0,0.0,0.0,0.0,0.0,0.483480574,0.418329458,0.773919191,0.033777768300000004,0.8645795470000001,0.39756492,0.0,0.26445567,0.610469015,0.786003459,0.656207557,0.28957897,1.06536364,0.0,0.761566898,0.49177481700000003,0.0,0.805753285,1.10794944,1.20439771,1.12054952,1.76704784,0.9618352929999999,0.44792215,0.876055265,0.7277808290000001,0.641535204,0.427078798,0.0,0.0,0.0,0.0,0.06413266200000001,0.5033149920000001,0.0,0.0,0.889477525,0.43742171799999996,0.0,0.0,0.0,0.0,0.0,0.8363876920000001,0.61411855,0.665877298,0.146515885,0.0,0.102040417,0.683160604,0.0,0.0,0.0,0.0,0.651573679,0.0,0.0,0.0,0.0,0.854650494,0.287583566,0.41602909,0.6942583990000001,0.41218020899999996,0.656954817,0.6722424640000001,0.0,0.503597496,0.0,0.0,0.09503785,0.0,0.0,0.0,0.0,0.22346012899999998,0.0,0.621912672,0.0,0.523284118,0.244471539,0.0,0.0,0.6855535209999999,0.0,0.0,0.0367914893,0.0,0.0527901017,0.366363314,0.0583583555,0.17782474899999998,0.0,0.0,0.31344477,1.33303349,1.84041859,1.09440043,0.0,0.0,0.0,0.0,0.157727844,2.74867678,5.72003083,8.03547221,9.65895085,8.59279346,6.54301548,4.47333149,2.82928021,1.6699281000000004,0.582983789,0.0,0.156690311,0.96207176,0.0,0.0,0.20634961899999998,0.0,0.854869911,0.0,0.0,0.277735538,0.6834599290000001,0.07350024570000001,0.0,0.0,0.0,0.0895849111,0.846961795,0.0,0.0,0.216473372,0.0162307002,0.0,0.0,0.909449829,0.0,0.41207780299999996,0.0,0.0,1.70976666,2.02791189,2.00865916,2.6318113999999997,2.86553479,2.51757519,2.2579011,1.26566215,0.7882870959999999,0.945505778,0.502354674,0.0,0.0,0.9212590690000001,0.695183617,0.319811935,0.0710090095,0.0,0.0,0.814820155,0.473547082,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.014399218600000001,0.0,0.0,0.0,0.0175429367,0.101722996,0.20746532399999998,0.320865575,0.42594108399999997,0.507184208,0.5522717429999999,0.554458778,0.514200204,0.43964301200000006,0.34580577100000004,0.252482232,0.181137135,0.151262708,0.176795344,0.263224967,0.405951856,0.590263741,0.793045744,0.986038825,1.14017982,1.23033925,1.23966452,1.16276128,1.00710777,0.792374081,0.547667049,0.307083785,0.104268351,0.0,0.0,0.0,0.0476371469,0.203475916,0.37744972,0.533854838,0.6400796910000001,0.672440941,0.620569889,0.48953353899999996,0.299253527,0.0812549162,0.0,0.0,0.0,0.0,0.0,0.0,0.16609842800000002,0.409361021,0.619543565,0.760104022,0.807074614,0.754201261,0.6151754389999999,0.42246794200000004,0.222850573,0.0702648996,0.0171667003,0.105757138,0.360555777,0.783566379,1.35286762,2.02489869,2.74010079,3.43102455,4.03161432,4.48620092,4.75680285,4.82763734,4.70622137,4.42101438,4.01611732,3.54400222,3.05752546,2.60253477,2.21221223,1.90394089,1.67901094,1.5249792,1.42005427,1.3385728000000001,1.25650933,1.15603447,1.02838137,0.8746439559999999,0.704539705,0.5335464679999999,0.379099203,0.256662414,0.17646141399999998,0.141475606,0.147012337,0.18185079199999998,0.23063767699999999,0.27698845899999996,0.306639731,0.31002454100000004,0.283791245,0.23102187300000002,0.16017740800000002,0.0830492138,0.012178993400000001,0.0,0.0,0.0,0.0,0.0,0.0146857178,0.0496343601,0.07242431070000001,0.07840854809999999,0.0670295337,0.041652892000000004,0.008577591340000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0033184316100000003,0.0269006353,0.041725017,0.0449952364,0.037180851200000004,0.022051211600000002,0.00598403332,0.0,0.0016413469,0.0264593644,0.0737019533,0.142182195,0.22702015600000003,0.32039023699999997,0.41281548100000004,0.494752245,0.558157899,0.597745923,0.611702829,0.6017537270000001,0.572594246,0.530828979,0.48364643799999996,0.437500765,0.397055085,0.364575589,0.339864667,0.320707437,0.30370275,0.285277671,0.262657181,0.23458210899999998,0.201631748,0.16609842800000002,0.131459537,0.10157737,0.0798114284,0.0682411257,0.06716773320000001,0.075000361,0.088546215,0.103638705,0.11596643400000001,0.121926085,0.119320339,0.10775776,0.08867658869999999,0.0649944703,0.040464130200000004,0.0188747693,0.00326831054,0.0,0.0,0.000983242091,0.010191041999999999,0.0193474658,0.025255318199999998,0.0255995571,0.019458266000000002,0.007516335250000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0279070957,0.0651435993,0.10539813699999999,0.146145499,0.185569722,0.222769843,0.257679688,0.290722441,0.322288478,0.352175048,0.37914664600000003,0.400759009,0.413538932,0.41353524399999997,0.397168444,0.36222596,0.30879492,0.239908801,0.161715424,0.0830492138,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
0.0865694769,0.355023701,0.6122080289999999,0.123928211,1.98443758,1.04011008,0.0,0.197934102,0.0,0.156531734,0.953029054,1.60959114,0.8350385459999999,0.375472058,0.0,0.683601702,0.143216021,0.517164163,0.0,3.21132262,1.07454393,0.0,0.280172233,0.334859527,0.339902414,0.510973026,0.0,0.079989776,0.0,0.09937750029999999,0.0,0.15155217099999999,0.0,0.38395367700000005,0.0,1.2732758999999998,4.97608645,0.0,0.297667002,0.0,0.139573885,0.0,0.065053981,0.0,0.0,0.354484953,1.66093005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38
2.21651095,4.08202341,3.69406199,4.56537725,3.22345774,2.96039947,1.70701317,3.64008724,0.20559117300000002,0.232991349,0.777976874,1.87114176,0.17570570600000002,0.489196801,1.75859904,0.693096597,0.0,0.68021655,0.0,0.0325650132,0.7883507890000001,0.37868728700000004,0.0,0.0,1.19574165,0.0,1.2503753,0.0,0.0,0.0,1.17096266,1.41997569,1.08790346,1.5278508999999998,0.996409225,0.0,0.0,0.0,0.0,1.12111881,0.77988592,0.33632419799999996,0.8505976190000001,0.251693956,1.02516799,0.450151125,0.0,0.277004216,1.46092236,1.17400958,0.10260807,1.6746241999999998,0.125392452,0.0,2.1111167999999996,0.998160099,0.518048421,0.133998198,0.0,0.0,0.870960209,1.25609015,1.28979522,0.0,0.542420201,1.52050957,0.0,0.0,2.48898074,0.299867985,0.0,1.35560639,0.0,0.536237773,1.54232558,0.7095082340000001,1.20715666,0.0,0.0,0.795381696,0.0,0.0,0.0,0.0,0.0,0.576631065,0.697093198,0.0,0.203085262,2.43947275,0.0,0.720133657,1.28499889,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.385
0.108675157,0.0907894351,0.0739067609,0.0587956325,0.045999943200000004,0.0358259583,0.0283474138,0.0234270561,0.0207518563,0.0198782978,0.020283606699999998,0.0214185859,0.0227578423,0.023843627599999997,0.0243202098,0.0239565931,0.0226564332,0.020455073600000002,0.0175046703,0.0140493022,0.0103927173,0.00686187898,0.0037697274700000004,0.00138054173,0.0,0.0,0.0,0.00105766227,0.0029202003,0.00507776414,0.00717763316,0.00885350204,0.00976241711,0.00962089832,0.008236978229999999,0.0055351738,0.0015719402499999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0025327303899999997,0.0143698505,0.026329207200000003,0.0375513294,0.047162377400000004,0.054338624,0.0583711774,0.0587261335,0.0550954563,0.0474343433,0.0359816229,0.0212607986,0.004060647539999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.008985569379999999,0.0362831245,0.06269972730000001,0.0864278617,0.105743354,0.11912541,0.12536889699999998,0.123680951,0.113754688,0.0958140358,0.07062532070000001,0.039473334900000004,0.00410183073,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.023116486699999998,0.0760272932,0.127720649,0.175244085,0.215927537,0.247608195,0.268838794,0.279065124,0.278759628,0.269499879,0.25398347,0.235974176,0.22017805,0.212052168,0.21755281899999998,0.24283379100000002,0.293908813,0.37629496700000004,0.49465578600000004,0.652463676,0.851701145,1.09261911,1.37356817,1.69091562,2.0390566999999997,2.41052409,2.79619442,3.18558571,3.56723433,3.9291358999999995,4.25923062,4.54591068,4.77852583,4.9478624,5.04657211,5.06952895,5.01409548,4.88028432,4.67080528,4.39099463,4.04862813,3.65362581,3.21766151,2.75369506,2.27544883,1.79685317,1.33148665,0.8920373909999999,0.489810478,0.13430403300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0303578818,0.157161947,0.263592991,0.34514557799999995,0.39905820399999997,0.424333794,0.421668755,0.393298274,0.342769726,0.274659425,0.19425039100000002,0.107190227,0.0191484992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0197376792,0.0756125858,0.124047666,0.162440386,0.18892309899999998,0.202439283,0.20276785600000002,0.190496555,0.16694834,0.13406742800000002,0.09427364949999999,0.050295343799999996,0.0049918407,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.016794791599999997,0.053652287300000004,0.0877819459,0.117660863,0.142110282,0.160341326,0.17197350399999997,0.177026481,0.175887315,0.169256829,0.158079951,0.143465641,0.12660237900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
3.64199934,3.63922501,3.62316351,3.59395748,3.55186219,3.49724261,3.43056929,3.352413,3.26343835,3.1643963,3.05611578,2.93949448,2.81548889,2.68510384,2.54938146,2.40938998,2.26621219,2.12093399,1.97463301,1.82836742,1.68316521,1.5400139,1.39985095,1.26355486,1.13193713,1.00573516,0.885606146,0.7721220809999999,0.665765824,0.566928369,0.47590725700000003,0.39290617299999997,0.31803569600000003,0.251315174,0.19267569399999998,0.141964065,0.0989477718,0.063320791,0.0347101956,0.0126834329,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.008440604709999999,0.0204946662,0.0333809078,0.0465678871,0.059561975999999996,0.0719129071,0.08321850780000001,0.0931285758,0.10134785800000001,0.10763810800000001,0.111819222,0.11376944300000001,0.113424666,0.11077687,0.10587171199999999,0.09880536179999999,0.0897206092,0.0788023552,0.0662725433,0.0523846375,0.0374177363,0.0216704252,0.005454471210000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.009033244659999998,0.0251208304,0.040737369100000004,0.0555982333,0.0694327952,0.08198923129999999,0.09303898449999999,0.10238081,0.109844333,0.115293067,0.11862683,0.11978352699999999,0.118740265,0.11551378400000001,0.110160195,0.102774025,0.093486592,0.0824637357,0.06990293339999999,0.0560298591,0.041094437000000004,0.0253664573,0.009130828070000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0056976614500000005,0.0226845138,0.039256279500000005,0.0550887012,0.0698688034,0.0833013168,0.09511497740000001,0.10506859800000001,0.11295680599999999,0.118615358,0.121925923,0.12282026300000001,0.121283719,0.117357943,0.111142807,0.10279744199999999,0.09254038460000001,0.080648781,0.0674566684,0.0533523154,0.03877465,0.024208804,0.0101808187,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00629502243,0.030476685099999998,0.061558189299999996,0.0999490449,0.145994352,0.19996783699999998,0.26206563,0.332400889,0.41099935200000004,0.497795893,0.592632151,0.695255273,0.805317817,0.922378825,1.04590607,1.1752795,1.30979576,1.4486739,1.59106204,1.73604508,1.88265323,2.02987141,2.17664924,2.32191165,2.46456992,2.60353305,2.73771921,2.8660673,2.98754839,3.10117682,3.20602104,3.30121375,3.38596156,3.45955372,3.52137004,3.57088782,3.60768765,3.63145814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.39399999999999996
0.01650863,1.06456804,0.68481225,0.28052929,1.09228158,1.14450733,0.8959756,2.18766638,0.89292328,0.0,0.0,0.72160987,0.81651031,0.07016046,0.0,0.05864658,0.0,0.0,0.22631104,0.0,0.4352616,0.0,0.0,1.771901,0.0,0.6162072,0.0,0.74651056,1.80700254,2.29343362,2.50370029,2.70423599,3.44014713,2.99860778,3.71091957,3.25122806,4.05212869,4.12963682,2.9532877999999996,2.56625715,3.27914157,2.72902389,3.84394095,2.98080652,1.70139005,3.52055618,3.03110831,1.48856803,2.14186599,0.47857523,0.22635805,0.0,0.32574818,0.0,0.0,0.0,0.61677319,0.0,0.0,0.0,0.43011622,0.0,1.6133276,0.0,1.1195821000000001,0.12208017,0.27301514,0.06406643,1.14616779,0.0,1.26277459,0.4887745,0.4791416,0.0,0.65191141,0.08145756,0.63293968,0.44114673,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.74573158,0.0,0.0,0.39368944,0.9249339,0.0,0.49839967,0.04483372,0.3077268,0.0,0.0,0.46845064,0.91833364,1.22414913,0.0,0.0,0.31100664,0.0,0.67210511,0.28865052,0.0,0.0,1.42022754,0.0,0.0,0.0,0.26651661,0.0,0.0,0.0,0.0,0.0,0.0,0.02719932,0.0,0.44200012,0.35046902,0.84079734,0.46187513,0.60256331,0.0,0.82307623,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.396
3.36329099,1.47508943,1.57480002,1.70431835,1.8902041,0.0,1.02861299,0.0,0.0,0.72445111,0.90597383,0.22854482,0.89551013,0.09222305,0.0,0.4003826,1.34052082,1.55490429,0.13090968,2.3425523,2.97519399,1.57375743,0.5054025,0.0,0.0,0.0,0.0,0.56232561,0.0,0.49738597,0.54105416,0.7939076999999999,0.0,0.88885465,0.91889911,0.40225705,3.69516022,4.96852607,3.10253332,3.0351049999999997,4.0274164,1.73616558,0.0,0.58515802,0.72565793,0.0,0.0,0.74506994,0.32082532,0.62727102,0.0654209,0.0,0.0,0.89334155,1.12498644,0.49196816,0.90914954,0.16094883,0.0,0.70894998,0.77091108,1.14861169,0.0,0.0,0.9984690999999999,0.58903215,0.0,1.55283872,1.55146953,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.500901076,0.190811015,1.03416252,0.0,1.21833751,0.0,5.02366086,4.57084345,0.0,0.606964087,0.0,0.32059944100000004,0.0762549258,3.0597687999999996,3.4251370000000003,0.515344267,0.100142976,0.0,0.0,0.182233649,0.0195303118,0.22879059300000001,0.435213522,0.0,0.020986845499999997,0.19212765,0.0,0.309537703,0.0,0.0,0.260002601,0.0,0.0,0.0,0.378195461,0.0,0.162015305,0.00419173785,0.336007585,0.21971223199999998,0.0,0.0,0.0,0.0,0.113217466,0.36701191200000005,0.29115798,0.41835284,1.09672587,0.23262318,0.0573227696,0.389560544,0.947137283,0.0,0.187973825,0.348596746,1.33613769,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
0.20532984699999998,0.139194999,0.548550121,0.83129096,0.594407742,1.08531732,1.07417577,1.67032791,1.33864985,1.93001895,1.82792239,1.96972455,1.72361775,1.62457887,1.7730708999999998,1.6771782,1.40070603,1.10059734,0.878305496,0.719467854,0.471375416,0.46506119799999995,0.132512946,0.18698428399999997,0.13766969,0.427999709,0.143546866,0.137483244,0.25099993,0.0,0.101345585,0.350826862,0.220319495,0.0,0.0,0.0,0.0,0.0,0.270827517,0.117789486,0.22042598100000002,0.0317446603,0.0,0.0283468831,0.0,0.307257602,0.0,0.0,0.130170227,0.0,0.0,0.240980227,0.0,0.0,0.0,0.27636457600000003,0.28304114199999997,0.0,0.0,0.451099154,0.0571000425,0.49441698799999995,0.401376598,0.368225598,0.0401507406,0.0,0.0324324586,0.0,0.0,0.07153965059999999,0.0,0.0,0.046785314800000005,0.0,0.0,0.0012926110000000002,0.42374818200000003,0.137724144,0.567708491,0.429833124,0.325249213,0.360818477,0.0,0.0,0.10184488400000001,0.0,0.0,0.0,0.0,0.0,0.459458876,0.280435129,0.519147791,0.654305029,0.388977853,0.24761876,0.736529331,0.226365283,0.0672626106,0.052139068399999995,0.09801880310000001,0.0,0.0,0.0,0.0,0.165123997,0.484928084,1.12896569,1.61996213,1.90346834,2.35591058,2.65905797,2.69548056,3.25282778,2.6984737,2.99661606,2.75686939,2.06603466,1.86877012,1.13249833,1.05470927,0.515188733,0.27138967399999997,0.059371249699999996,0.0,0.0,0.0,0.0181281288,0.0,0.0,0.0,0.495069008,0.113578421,0.30762941,0.46744708700000004,0.324352631,0.38888940899999996,0.11610886,0.0,0.0,0.00512048849,0.25279323,0.215551402,0.204606838,0.42754134899999996,0.485317373,0.774559565,0.957128821,1.15977744,1.23838981,0.949155717,0.953592126,1.04020131,1.01040897,0.990980871,0.91119742,0.619827882,0.49581023700000004,0.133431194,0.281779431,0.0,0.0,0.251364168,0.0983241552,0.261191541,0.162876247,0.290469531,0.020269242399999998,0.227920065,0.23271261,0.0,0.0,0.0,0.0,0.0,0.0,0.0309842435,0.0,0.14583961199999998,0.332833447,0.278078011,0.416701985,0.311126635,0.341169592,0.846051088,0.677350951,0.533244677,0.572255957,0.622996346,0.675994102,0.316004188,0.608871578,0.443091752,0.0670394176,0.27450964699999997,0.310352123,0.401356249,0.0,0.0,0.0,0.0,0.29722897800000003,0.0,0.0,0.0,0.0241883104,0.15450565300000002,0.0,0.0,0.0221806702,0.0,0.0,0.22885600899999997,0.30618469600000003,0.190278203,0.0,0.0673842016,0.0,0.0,0.210058422,0.202327607,0.129989777,0.0,0.0901527737,0.0489398933,0.0,0.0919899969,0.244438464,0.100811105,0.0,0.0,0.0,0.160941757,0.0,0.0165675702,0.0647392016,0.0,0.0115723952,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.386
0.322311756,0.577573295,0.86972681,1.18916306,0.33651328700000005,0.9931745359999999,0.704929603,0.306291457,0.374283507,0.8972806729999999,0.621557695,0.6615233429999999,0.0,0.0,0.0,0.0788515949,0.0,0.0,0.0,0.0,0.179469098,0.0,0.0,0.0,0.0,0.0,0.236839827,0.417508654,0.517530371,0.420815901,0.160824772,0.0,0.0,0.24137453600000003,0.297904296,0.0,0.0285098173,0.44471613299999996,0.48083538600000003,0.391761198,0.936371728,0.9928051370000001,0.257865197,0.0345212845,0.587284337,0.606735262,0.503988949,0.464448918,0.0,0.0,0.0,0.0,0.0,0.0,0.258301563,0.8422685120000001,0.7240784659999999,0.899406812,0.00877940725,0.784556294,0.0,0.0889560683,0.0,0.0,0.111530676,0.0,0.0,0.665743788,0.848164987,1.81079597,2.00039871,3.0645974,3.95418652,3.97721817,4.37197161,4.72289468,5.43449379,5.38496299,4.45748702,4.03031151,3.31652951,3.65210472,3.11580863,2.24475888,1.52217331,1.29102145,0.183461345,0.0,0.0,0.466847826,0.475947654,0.413914205,0.05439377,0.0,0.0,0.025239053199999997,0.0221428963,0.22954207199999999,0.599504928,0.594351277,0.0,0.0290292381,0.146918078,0.0,0.0,0.0,0.0,0.400255853,0.0805202716,0.35896102,0.0918407732,0.0,0.0,0.0,0.0,0.0,0.00458550386,0.292263233,0.31551971300000003,0.0,0.38342167200000005,0.0,0.316656347,0.183201549,0.0,0.392189138,0.357557698,0.504904889,0.0,0.525690432,0.55620242,0.34987479899999996,0.239856882,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
1.91122383,0.286779629,0.0,0.0,0.6273495960000001,0.351098051,0.0,0.0,0.376220589,0.69907431,0.387169505,0.639635773,1.91705653,2.95693731,2.58191689,1.39431926,0.7499301190000001,0.830344697,0.7907792220000001,0.33608777700000003,0.0108755502,0.0636635552,0.08537829599999999,0.0,0.0,0.101114784,0.188365395,0.0,0.0,0.0336354044,0.243669876,0.0143306949,0.0,0.0,0.25431717800000003,0.12278052,0.0,0.0,0.218190522,0.23284248899999999,0.0,0.0,0.134894031,0.328763645,0.0,0.0,0.00546959128,0.396658777,0.0765883404,0.0,0.0,0.42481263799999996,0.281602548,0.0,0.0,0.415432431,0.673865528,0.0,0.0,0.22905690199999998,0.943846802,0.0,0.0,0.0,3.50979529,5.97589141,4.50934458,0.986237453,0.0,0.0,0.34462752799999996,0.251776791,0.0,0.0,0.0,0.0,0.10776244800000001,1.61657475,2.72170563,2.00600454,0.318572867,0.0,0.39134664700000005,1.00998036,0.657523445,0.203322224,0.499928803,0.93597997,0.580874451,0.0,0.0,0.260439584,0.792994454,0.8597703940000001,0.94678481,1.37017828,1.69838699,1.51121458,1.06322232,0.790884461,0.647142157,0.363338304,0.025837070400000002,0.0,0.045801162400000005,0.0856058192,0.0,0.0,0.00810827742,0.09053550380000001,0.07567315299999999,0.100178266,0.33567935600000004,0.8715628670000001,1.8231388,3.25965044,4.85768348,5.85453081,5.64214879,4.42401412,3.12179872,2.54306365,2.65434963,2.70560639,2.0816118,0.97990435,0.148255823,0.0,0.122042692,0.061822648099999995,0.0,0.0,0.135131929,0.14167966699999998,0.0,0.0,0.101216721,0.240740423,0.0,0.0,0.0143723264,0.372487487,0.06554422809999999,0.0,0.0,0.58320876,0.41785034,0.0,0.0,1.43895712,4.49309789,4.91393495,2.27329041,0.0,0.0,0.553518862,0.8987045690000001,0.0544243416,0.0,0.0,0.478055677,0.272719113,0.0,0.0,0.060628256900000004,0.00666491506,0.0651165811,0.411831405,0.5087511029999999,0.10955818099999999,0.0470712227,0.9948527420000001,2.03549839,1.7048226999999998,0.21116800800000002,0.0,0.0,0.466896291,0.27686772600000004,0.0,0.0,0.23291337199999998,0.30578061300000003,0.0,0.0,0.07995287150000001,0.29978906899999996,0.0,0.0,0.0,0.268826568,0.09274974009999999,0.0,0.0,0.265755747,0.370854244,0.0806112586,0.0,0.0868128101,0.254178088,0.157992907,0.00185951228,0.0060310197,0.0864931191,0.14414194800000002,0.25516757,0.402275485,0.402966063,0.27178438899999996,0.264921519,0.39834836700000004,0.358101425,0.09637793509999999,0.00951127798,0.21943419600000003,0.265771,0.00434604737,0.179155576,1.2837575,2.33542112,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.014834937900000001,0.0,1.11204583,1.38179448,0.0020833213600000003,0.296313414,0.160699766,0.0,0.0,0.0,0.0,0.416575352,0.302609823,0.0,0.725338096,0.0,0.381704025,0.0,0.268252641,0.419195174,0.0,0.0,0.827564482,0.0,1.42184817,5.50685087,4.93223467,5.2022636,5.03732855,1.14331348,0.0,0.9347808320000001,0.108814895,0.0,0.150484918,0.0,0.0,0.0,0.0,0.333784413,0.0,0.0,2.02989898,5.51563363,6.54712048,3.13913247,1.67246012,3.18570089,0.80304607,0.0,0.355710255,0.0416283757,0.0,0.510829623,0.0,0.0,0.0,0.0,1.29878208,2.19898778,1.6548211,4.25815604,4.74660507,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40299999999999997
0.0222436285,0.0,0.00237873553,0.00263822227,0.0,0.00105504752,0.0,0.0,0.0103025556,0.0,0.0,0.013368913100000001,0.011134608700000001,0.0,0.0,0.0298933415,0.0,0.0,0.027064757999999998,0.0248834916,0.0,0.0,0.056045638700000004,0.0,0.0,0.0458658901,0.048850211500000004,0.0,0.0,0.104413769,0.0,0.0,0.08513444880000001,0.109105077,0.0,0.0,0.25748299,0.0,0.0,1.08477496,2.82527167,2.8054422000000003,1.81808743,2.2670472000000004,3.71196542,3.87437806,2.7227362,1.85146944,1.51981464,1.26582746,1.40313911,1.85691048,1.72969179,1.04460669,0.72924184,0.89461433,1.15809891,1.76335123,2.65333438,2.91441171,2.35644483,1.88329649,1.75902673,1.37426668,0.6890589859999999,0.22894164399999997,0.11467286,0.23184108,0.522629437,0.6320507,0.323028113,0.0671101503,0.19156099,0.23437750000000002,0.0,0.0,0.063368832,0.0486429057,0.0,0.0831179236,0.149101586,0.0,0.0,0.174488667,0.115653286,0.0,0.0,0.126563712,0.0,0.0,0.051847633399999996,0.055056430999999996,0.0,0.113933319,0.224932418,0.0,0.0,0.074810454,0.107935895,0.0,0.0,0.18754988600000003,0.17664274300000002,0.360968448,1.17266213,1.76100483,1.31103568,0.431842501,0.00582588476,0.0,0.0946786494,0.194721573,0.147478641,0.0,0.0,0.0734854854,0.0057477430000000005,0.0,0.17579536899999998,0.257286698,0.0267388576,0.0,0.156378952,0.0780643147,0.0,0.046333192800000006,0.214602185,0.0094126236,0.0,0.144241017,0.0370257428,0.0,0.0636561195,0.30565469,0.0,0.0,1.15728814,2.66624349,1.9307561999999998,0.08729795119999999,0.0,0.26000660600000003,0.541725248,0.205246089,0.0039384280600000005,0.0176644827,0.0236661485,0.110820053,0.204447123,0.0870122101,0.0,0.0,0.051300703200000006,0.0,0.0,0.015442430200000001,0.0313440386,0.0190810617,0.0504695686,0.06480565190000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
1.61546105,1.97962522,3.06863581,2.29836383,1.01052821,0.335952674,0.0,0.0,0.34117126,0.183844478,0.0,0.0,0.0,0.0,0.320623288,0.0,0.0,0.0,0.0,0.312388441,0.0,0.183778745,0.0,0.023784367799999998,0.464334024,0.149274308,0.0797680653,0.0,0.0,1.00853943,1.38615886,0.578263671,0.574267101,0.0,0.291687467,1.94712431,2.36803074,1.53059124,0.185729311,0.8434167920000001,1.58075421,2.5551729,2.98927871,2.78730321,1.56002867,0.0621121316,0.44750181899999997,0.908763923,1.75530875,1.87067878,1.03835298,0.501758155,0.0,0.0,0.0,0.31026020000000004,0.0,0.137014668,0.0170610018,0.0,0.811191758,0.494422042,0.0,0.0,0.261067603,0.599526059,0.750381669,0.7104863,0.599921071,0.0,0.134279666,0.145600245,0.55308575,1.22510419,1.27375282,1.65828565,0.553009933,0.436129676,0.751761989,1.55044283,2.05386449,1.65606474,0.0,0.0,0.0,1.20818636,3.23146488,3.87826844,3.43919734,1.08164448,0.19004516800000001,0.0,0.0,0.23665815399999998,0.636399419,0.0,0.0,0.0,0.51056849,0.16113902800000002,0.11279109400000001,0.0,0.0,0.0,1.2447578000000001,2.28244433,2.76558067,2.3940755,1.69181447,2.37135891,2.68603497,4.25051969,5.00550931,4.72413275,5.20404944,5.45608847,4.71910595,3.50150147,2.76643633,2.35375669,1.56520321,1.07947226,1.11469899,0.897005863,1.14278732,0.727981929,0.193923294,0.11012110900000001,0.0425891275,0.050937557300000005,0.301224673,0.9434925609999999,0.0707682893,0.0123031926,0.18332415600000002,0.0,0.0,0.265262746,0.10477186,0.0,0.17617646,0.210271545,0.52853695,0.12080420300000001,0.0946225105,0.23902065600000003,0.0,0.543208192,0.32276242899999996,0.134378795,0.0,0.0721964562,0.125267712,1.40760875,1.0514118000000001,0.716438638,0.12190534300000001,0.181665406,0.134074412,0.728009758,1.31596659,0.822575043,0.38216633899999997,0.0,0.0265413637,0.5544542370000001,0.156462681,0.0,0.0839299976,0.0,0.43110422200000004,0.0,0.38102978,0.0,0.049802052699999995,0.0,0.0,0.543180325,0.0,0.0,0.0,0.504891847,0.0,0.250376402,0.0,0.0166723848,0.179785645,0.0,0.0153495592,0.15845711099999998,0.063054898,0.0,0.0,0.39005179700000003,0.0,0.0710204692,0.0,0.112870532,0.0,0.350604572,0.546318094,0.8268526890000001,0.965961128,0.0521397787,0.381809212,0.0536391289,0.0,0.0,0.312462069,0.469585501,0.160017759,0.198307404,0.0,0.0,0.033342986899999996,0.0,0.0,0.0184374394,0.355722452,0.587088377,0.00492287874,1.09609756,0.80624092,0.217035841,0.0,0.0,0.214072034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.409
0.0947905024,0.474927011,0.0471187031,0.8296413220000001,1.07884065,1.30940155,2.28214564,2.58177626,2.90970091,3.30731765,2.74443999,1.82525503,2.74694427,2.28356645,2.48946436,1.10231522,0.685605785,0.0777047075,0.5571094879999999,0.0,0.536883106,0.0,0.0,0.0,0.0,0.45006837200000005,0.0,1.2716671999999998,1.0170561,0.0,0.159404007,1.49157994,1.80792084,0.0,0.0,1.86323402,0.0,0.0,0.70513349,0.0,1.4124918,0.317108508,0.226977811,0.242969303,1.98127419,1.71284001,2.13042008,1.88795244,2.56714699,1.55346483,0.978943083,0.0279988372,0.0,0.804934356,0.0,0.0,0.0,1.32209542,0.0703392416,0.0,0.0,0.0,0.359233115,0.0,0.6854555720000001,1.86241928,0.0,0.514622699,0.0,0.47658892399999997,0.0,1.05159922,0.0,1.19242287,0.350287969,0.595671183,0.0,0.0,0.433665197,1.54819355,0.0298833263,0.5370402360000001,0.0798825816,0.826989726,0.12996015800000002,0.374378025,0.378347035,0.58237951,0.815606323,0.0,0.258208258,1.01343602,0.303901908,0.40162443200000003,0.576013607,0.40341675899999996,0.0,0.420903387,0.5918035070000001,0.0,0.05805542650000001,0.0,0.224971472,0.0554107905,0.20059575899999998,0.382804639,1.08239555,0.9250282790000001,0.9028939690000001,0.74695246,1.33626335,0.581796234,0.0,1.5894428999999999,1.29422187,0.7137305740000001,0.116219269,0.873564585,1.99799373,0.719553922,0.854765588,0.622234915,0.877225386,1.00373163,1.10604173,0.260376242,0.0,0.0,0.7759143009999999,0.0,0.150820524,0.240723942,0.0,0.677486812,0.573714507,0.0,0.603080487,0.716755305,0.0901091752,0.222113225,0.34061261299999995,0.371725604,2.1375131,1.14326833,0.0,0.48380121,0.29805648,1.39793148,0.613146104,0.483279455,0.20678889600000003,0.549607883,0.991984765,1.90639601,0.42596087899999996,2.04508432,1.05226479,1.19591181,1.24154793,0.0,1.38922499,1.05735379,0.64329947,0.0961003742,0.0,0.917842774,1.2585722,0.258731471,0.7695399340000001,1.7516123,0.82000786,0.8780988940000001,0.497094126,0.0,1.02985644,0.11174135,1.70405893,0.9246518229999999,1.23146272,0.506981285,0.73154958,0.0,0.13092367,1.35791275,0.0,0.0,0.589490361,0.0,0.418821205,0.0,0.0,0.0,0.40118720799999996,1.69473882,0.598552526,0.192235622,0.179999435,0.0,0.0,0.542115909,0.0,0.0,0.651275744,1.07085668,0.800948678,0.0,0.0,0.7398133459999999,0.0,0.677199153,0.0,0.0,0.0,0.448689316,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.382
0.42047830700000005,0.0,0.0,0.0,0.0,0.331935731,0.137146328,0.142709854,0.0,0.112271193,0.0,0.292632613,0.0,0.316158427,0.233497882,0.0579154447,0.23599037,0.450529103,0.0,0.0,0.129907847,2.31324472,2.97851014,1.44707475,0.0,0.0,0.621020617,0.45963011200000004,0.0,0.0,0.442029115,0.207316522,0.0,0.173244587,0.5025009460000001,0.0,0.265363935,0.0,0.0,0.0313756313,0.0,0.0,0.0,0.0,0.25041274,0.0,0.0,0.0,0.0,0.252603207,0.00350356388,0.32450885,0.0280780175,0.35214654,1.27929905,1.75757925,1.18271932,0.541333243,0.195204297,0.17609151,0.0,0.175881614,0.0,0.411326276,0.0,0.0,0.08920006470000001,0.0,0.11285184300000001,0.0,0.260287098,0.0,0.0,0.246814972,0.238531401,0.0075662581599999995,0.04944448059999999,0.39956491299999997,0.0967994588,0.0,0.0152392432,0.282455862,0.0165393668,0.22879237600000002,0.210477969,0.250846836,0.12461512400000001,0.166582893,0.0,0.559945447,0.449031994,0.0,0.622405474,0.329826483,0.201787175,0.46280154700000004,0.33606739799999996,0.0784943397,0.822640314,1.54188817,1.31794336,1.61688693,2.1733232000000005,2.62070621,2.92885484,2.123108,1.40633885,0.849670439,0.6747227029999999,0.771540447,1.24572319,1.60888389,1.8475582999999998,1.64295315,1.57713564,1.66326997,1.60350643,2.4463992,4.05889887,3.33163302,2.47531322,2.0545496,2.55679785,2.83614684,1.44505199,0.0,0.0,0.210943297,0.214190209,0.0,0.00492312275,0.0567369936,0.0,0.0,0.289785482,0.0,0.0,0.0,0.205549482,0.22228194899999998,0.112527634,0.29951187,0.13973733900000002,0.0,0.18470728,0.304522289,0.0,0.0,0.296022781,0.33401652600000004,0.0643475604,0.154910727,0.0,0.0,0.307198701,0.100025481,0.0,0.12039596,0.30849535100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.051836094000000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.38799999999999996
0.0624075211,0.7014491490000001,0.531283903,0.93751802,0.808979392,0.310358254,2.46224155,2.93449691,2.3906791000000003,1.24640466,0.471449446,0.390647266,0.16918853,0.861020115,0.8789718990000001,0.0306393512,0.0,0.326560081,3.15109285,5.43655454,9.06969402,8.9893245,9.46607514,6.32481625,4.4547568,2.95759164,1.14497535,0.7947958409999999,0.237967108,0.41077846799999995,0.0,0.12457001300000001,0.82892645,0.0,0.357488545,0.0,0.380787531,0.47688156,0.0655534145,0.773677655,0.0146238231,0.0,0.0,0.0,0.0,1.06853762,0.9717584109999999,0.124758972,0.550671705,0.0,0.16544336,1.10104971,0.011223994,0.0,0.0,0.0,0.0,0.402166165,1.44240841,0.5712810970000001,1.239737,0.0,0.84609834,0.175283386,0.0,0.0018040831200000001,0.0,0.0,0.745034072,0.0,0.0,0.966701551,0.40687378799999996,0.103553471,0.0,0.297039183,0.592252686,0.0,0.805388295,0.0,0.0,0.0,0.26562852600000003,0.849473266,0.33998441100000004,0.120959043,0.0,1.06741186,0.7977322179999999,0.355706157,0.9429850259999999,0.0,0.375073992,0.531487403,0.0,0.295046093,0.282188175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.9975241309999999,0.43889035,0.0,0.0,0.562388821,1.14643277,0.0,0.654156586,0.43323584299999995,0.516466335,0.9170416809999999,2.69200858,1.14717121,2.93443592,1.70706379,4.21789844,2.10089639,2.43191605,3.4830457000000004,3.47522057,3.56664896,3.48211503,2.05964031,2.83262695,2.99401976,1.37349996,1.38320521,1.38725517,0.262326054,1.45959888,0.0,0.0,0.0,1.72761085,0.0,0.0812089572,0.0,1.71917001,0.0,0.518623834,0.624008766,0.0,0.27302482899999997,1.11766594,0.0,0.168481771,0.0,0.0,0.0,0.138328546,0.0,0.0,0.238701524,0.0,0.0,0.0,0.394474686,0.409042969,0.233069348,0.0,0.0,0.00649449835,0.11059993,0.226960091,0.0,0.0,0.0,0.0,0.0,0.573646665,0.9729148040000001,0.0,0.0,0.9720609729999999,0.46111748799999996,0.604051036,0.450610024,0.000792443443,0.0,0.393551718,0.0,0.5132797,0.0,0.0,0.0,0.738720328,0.860924606,0.440403431,0.8351531209999999,0.0103651435,0.480655199,1.28528947,1.08977889,0.0744437997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.392
0.8559749940000001,1.57113931,0.667103062,0.0,0.0,0.0,0.0,0.0,0.101542395,0.0,0.0,0.0,0.26577788,0.0,0.5519883179999999,0.8824162040000001,0.0,0.294433919,0.0,0.302003746,0.57436221,0.0,0.49667928,0.0,0.0,0.290661579,0.335353118,0.0,0.510821455,1.01208204,0.812690232,0.0,0.0,0.0,0.0,0.0,0.29526827899999997,0.0,0.0,0.0,0.17777505100000002,0.0,0.0,0.0,0.0,0.145742567,0.0,0.0188885833,0.918732525,0.165158697,0.746040635,0.0,0.0,0.20721442399999998,0.0,0.42333991,0.149611454,0.34993411799999996,0.5176329789999999,0.0,1.36480794,1.54693763,1.79683111,3.73166815,3.35418327,3.17818936,1.95568114,1.91233693,0.5710075179999999,2.20010792,0.061335386299999996,0.0,0.170274641,0.0,0.0,0.0,0.0,0.294520908,0.261472945,0.827894395,0.164745791,0.36625027299999996,0.156574691,0.0626356937,0.456733905,0.311246675,0.558820361,0.0,0.43424759,0.0,0.33644821399999997,0.508213734,1.56708861,0.0,1.5258475,0.0,0.00352301531,0.0,0.141447539,0.29810867,1.55352869,0.888095463,0.415155424,1.43765203,0.39942960200000005,0.0,0.0,0.0,0.0,0.0,0.167062917,0.0,0.0,0.0297073241,0.40430368,0.230104762,0.907857867,0.557932345,0.0,0.009413289370000001,0.0,0.0,0.113787355,0.657178087,0.0,0.0,0.640965119,0.0,0.480148258,0.0,0.0,0.0,1.4664103000000002,0.0,0.0,1.54946735,0.0,0.0,0.185996679,0.0,0.0,0.154502924,0.0,0.280976751,0.149184662,0.0,0.0,0.654910229,0.692562542,0.0,0.5092163160000001,0.0467341875,0.711330158,0.0,0.0584643242,0.18107147899999998,0.0,0.0,0.0,0.0,0.144535072,0.0,0.504402786,0.656217241,0.389875817,0.0189577419,0.579710299,0.730007211,0.31966240100000004,0.6922591659999999,0.43278355799999996,0.578375151,0.0,0.0,0.0,0.0721178319,0.09413505779999999,0.366725106,0.0,0.137245173,0.0,0.0,0.0,0.0,0.0,0.128639908,0.0,0.400536668,0.0,0.517491688,0.0,0.546146099,0.434005961,0.421593425,0.24877980800000002,0.523448262,0.8782074059999999,1.34860937,0.0,0.7940592740000001,1.37197263,0.0,0.217490795,1.30955387,0.0,0.0,0.882814054,0.233603001,0.0,0.260263177,0.0,0.516391224,0.515639393,0.587155917,1.77228391,2.25022309,3.28067799,3.40003974,2.24405173,2.71334928,2.81714651,3.38242094,2.46213422,3.30474455,1.3775991,2.68664615,0.291377237,1.28645505,0.9315608940000001,1.3048255,1.02106872,0.680458775,1.03464402,1.36002282,1.55099824,0.6365831679999999,0.0,0.0,0.0,0.8387470229999999,0.417440464,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.387
0.7407148459999999,1.78535682,0.0,1.32855775,1.23174063,1.03138675,5.06778541,2.31826412,1.40560915,0.716800027,0.0,0.0,0.0,0.0,0.41375395600000003,0.21731630899999999,0.0,0.9518705279999999,0.612749688,5.10108014,0.168401855,0.989014995,1.48453212,0.0,0.563746593,0.09912323869999999,0.620124398,0.224151746,0.0,0.353612772,0.591118216,0.0567754866,0.333993843,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.381
