# llmtelora


## Installation

1. Install [anaconda](https://www.anaconda.com) package manager with [python](https://www.python.org) (e.g., version `3.8` or `3.10`);

2. Create a virtual environment:
    ```bash
    conda create --name llmtelora python=3.10 -y
    ```

3. Activate the environment:
    ```bash
    conda activate llmtelora
    ```

4. Install dependencies:
    ```bash
    pip install transformers torch torchvision tensorboard teneva jupyter matplotlib tiktoken datasets opt_einsum tqdm numpy==1.26 rotary_embedding_torch
    ```

5. Optionally delete virtual environment at the end of the work:
    ```bash
    conda activate && conda remove --name llmtelora --all -y
    ```


## How to run computations

Scripts:
- llmtelora.py is for training model on the tiny stories dataset
- eval_llmtelora.py is for testing self-speculative decoding
- transformers/transformers_check.py is for tuning PyCodeGPT model
- transformers/eval_pycode.py is testing self-speculative decoding for PyCodeGPT model

All command line arguments are described inside script files or can be invoked with --help option.


