#!/usr/bin/env fish

# Loop through each directory inside plp/programs
for dir in plp/programs/*/
    # Check if the directory exists
    if test -d $dir
        # Loop through each item inside the directory
        for item in $dir*
            # Check if the item is a directory
            if test -d $item
                # Remove the directory and its contents
                rm -rf $item
            else
                # Check if the file does not have a .pasp extension
                if not string match -r '\.pasp$' -- $item >/dev/null
                    # Remove the file
                    rm $item
                end
            end
        end
    end
end
