import numpy as np


def custom_random():
    r = np.random.rand()

    gamma = 0.5
    if r < gamma:
        return [np.random.uniform(-1, -0.7), np.log(gamma/0.3)]
    else:
        return [np.random.uniform(-0.7, 1), np.log((1-gamma)/1.7)]


def biased_sample(action_dim, return_log_prob=False):

    action_list = []
    log_prob_list = []
    for _ in range(action_dim):
        sample = custom_random()
        action_list.append(sample[0])
        log_prob_list.append(sample[1])

    random_array = np.array(action_list, dtype=np.float32)

    action_log_prob_array = np.array(log_prob_list, dtype=np.float32)
    action_log_prob = action_log_prob_array.sum()

    if return_log_prob:
        return random_array, action_log_prob
    else:
        return random_array


if __name__ == "__main__":
    random_arr = biased_sample(action_dim=8)
    print(random_arr)
    import matplotlib.pyplot as plt

    random_numbers = [custom_random()[0] for _ in range(10000)]
    plt.hist(random_numbers, bins=50, density=True)
    plt.show()
