# Maximum Next-State Entropy for Efficient Reinforcement Learning

## Requirements
We assume you have access to a gpu that can run CUDA 11.6. Then, the simplest way to install all required dependencies is to create an anaconda environment by running:
```
cd mnse/rl-baselines3-zoo
pip install -e .
```

## Instructions 

To train MNSE on the `Ant-v3` task run:

```
CUDA_VISIBLE_DEVICES=6 python train.py \
    --algo sac_mnse \
    --env Ant-v3 \  
    --seed 0 \ 
    -f logs/sac_mnse/ \ 
    -tb logs/sac_mnse/tb/ \
```

Run ***mnsesac_test.py***  will excute multiple commands at the same time.
```
python mnsesac_test.py
```

This will produce 'log' folder, where all the outputs(including the performance, the inverse dynamic model and the action mapping layer) are going to be stored. 
One can attacha tensorboard to monitor training by running:
```
tensorboard --logdir log
```
and opening up tensorboad in your browser.

