import os

from rl_zoo3.utils import (
    ALGOS,
    create_test_env,
    get_latest_run_id,
    get_saved_hyperparams,
    get_trained_models,
    get_wrapper_class,
    linear_schedule,
)

# Read version from file
version_file = os.path.join(os.path.dirname(__file__), "version.txt")
with open(version_file) as file_handler:
    __version__ = file_handler.read().strip()

import gym

try:
    import metaworld
    env_list = ['pick-place-v2','door-open-v2','hammer-v2','assembly-v2','drawer-open-v2']

    class MetaworldPickPlaceV2(metaworld.ML1('pick-place-v2').train_classes['pick-place-v2']):
        def reset(self, **kwargs):
            default_task = metaworld.ML1('pick-place-v2').train_tasks[0]
            self.set_task(default_task)
            return super(MetaworldPickPlaceV2, self).reset(**kwargs)
            # self.freeze_rand_vec = False

        def set_task(self, task) -> None:
            """Sets the environment's task.

            Args:
                task: The task to set.
            """
            import pickle
            self._set_task_called = True
            data = pickle.loads(task.data)
            assert isinstance(self, data["env_cls"])
            del data["env_cls"]
            self._freeze_rand_vec = True
            self._last_rand_vec = data["rand_vec"]
            del data["rand_vec"]
            self._partially_observable = data["partially_observable"]
            del data["partially_observable"]
            self._set_task_inner(**data)


    gym.envs.registration.register(
        id='Metaworld-PickPlace-v2',
        entry_point=__name__ + ':' + 'MetaworldPickPlaceV2',
    )

    class MetaworldDoorOpenV2(metaworld.ML1('door-open-v2').train_classes['door-open-v2']):
        def reset(self, **kwargs):
            default_task = metaworld.ML1('door-open-v2').train_tasks[0]
            self.set_task(default_task)
            return super(MetaworldDoorOpenV2, self).reset(**kwargs)
            # self.freeze_rand_vec = False

        def set_task(self, task) -> None:
            """Sets the environment's task.

            Args:
                task: The task to set.
            """
            import pickle
            self._set_task_called = True
            data = pickle.loads(task.data)
            assert isinstance(self, data["env_cls"])
            del data["env_cls"]
            self._freeze_rand_vec = True
            self._last_rand_vec = data["rand_vec"]
            del data["rand_vec"]
            self._partially_observable = data["partially_observable"]
            del data["partially_observable"]
            self._set_task_inner(**data)


    gym.envs.registration.register(
        id='Metaworld-DoorOpen-v2',
        entry_point=__name__ + ':' + 'MetaworldDoorOpenV2',
    )

    class MetaworldHammerV2(metaworld.ML1('hammer-v2').train_classes['hammer-v2']):
        def reset(self, **kwargs):
            default_task = metaworld.ML1('hammer-v2').train_tasks[0]
            self.set_task(default_task)
            return super().reset(**kwargs)
            # self.freeze_rand_vec = False

        def set_task(self, task) -> None:
            """Sets the environment's task.

            Args:
                task: The task to set.
            """
            import pickle
            self._set_task_called = True
            data = pickle.loads(task.data)
            assert isinstance(self, data["env_cls"])
            del data["env_cls"]
            self._freeze_rand_vec = True
            self._last_rand_vec = data["rand_vec"]
            del data["rand_vec"]
            self._partially_observable = data["partially_observable"]
            del data["partially_observable"]
            self._set_task_inner(**data)


    gym.envs.registration.register(
        id='Metaworld-Hammer-v2',
        entry_point=__name__ + ':' + 'MetaworldHammerV2',
    )

    class MetaworldAssemblyV2(metaworld.ML1('assembly-v2').train_classes['assembly-v2']):
        def reset(self, **kwargs):
            default_task = metaworld.ML1('assembly-v2').train_tasks[0]
            self.set_task(default_task)
            return super().reset(**kwargs)
            # self.freeze_rand_vec = False

        def set_task(self, task) -> None:
            """Sets the environment's task.

            Args:
                task: The task to set.
            """
            import pickle
            self._set_task_called = True
            data = pickle.loads(task.data)
            assert isinstance(self, data["env_cls"])
            del data["env_cls"]
            self._freeze_rand_vec = True
            self._last_rand_vec = data["rand_vec"]
            del data["rand_vec"]
            self._partially_observable = data["partially_observable"]
            del data["partially_observable"]
            self._set_task_inner(**data)


    gym.envs.registration.register(
        id='Metaworld-Assembly-v2',
        entry_point=__name__ + ':' + 'MetaworldAssemblyV2',
    )

    class MetaworldDrawerOpenV2(metaworld.ML1('drawer-open-v2').train_classes['drawer-open-v2']):
        def reset(self, **kwargs):
            default_task = metaworld.ML1('drawer-open-v2').train_tasks[0]
            self.set_task(default_task)
            return super().reset(**kwargs)
            # self.freeze_rand_vec = False

        def set_task(self, task) -> None:
            """Sets the environment's task.

            Args:
                task: The task to set.
            """
            import pickle
            self._set_task_called = True
            data = pickle.loads(task.data)
            assert isinstance(self, data["env_cls"])
            del data["env_cls"]
            self._freeze_rand_vec = True
            self._last_rand_vec = data["rand_vec"]
            del data["rand_vec"]
            self._partially_observable = data["partially_observable"]
            del data["partially_observable"]
            self._set_task_inner(**data)


    gym.envs.registration.register(
        id='Metaworld-DrawerOpen-v2',
        entry_point=__name__ + ':' + 'MetaworldDrawerOpenV2',
    )



except Exception:
    print("[Warning] Could not import metaworld env (is it installed?)")





# # edit in 2023/07/12
# # register for new environment with more distractors
# from babyai.levels.iclr19_levels import Level_GoTo
# import gym
# # register for new environment with more distractors

# class Level_GoToS8R2D1(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=1, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
# class Level_GoToS8R2D2(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=2, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
# class Level_GoToS8R2D4(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=4, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
# class Level_GoToS8R2D8(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=8, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
# class Level_GoToS8R2D16(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=16, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
# class Level_GoToS8R2D32(Level_GoTo):
#     def __init__(self, seed=None):
#         super().__init__(num_dists=32, room_size=8, num_rows=2, num_cols=2, seed=seed)
#
#
#
# def register_levels(module_name, globals):
#     """
#     Register OpenAI gym environments for all levels in a file
#     """
#
#     # Iterate through global names
#     for global_name in sorted(list(globals.keys())):
#         if not global_name.startswith('Level_'):
#             continue
#
#         level_name = global_name.split('Level_')[-1]
#         level_class = globals[global_name]
#
#         # Register the levels with OpenAI Gym
#         gym_id = 'MyBabyAI-%s-v0' % (level_name)
#         entry_point = '%s:%s' % (module_name, global_name)
#         # print(entry_point)
#         gym.envs.registration.register(
#             id=gym_id,
#             entry_point=entry_point,
#         )
#
#         # Add the level to the dictionary
#         # level_dict[level_name] = level_class
#
#         # Store the name and gym id on the level class
#         level_class.level_name = level_name
#         level_class.gym_id = gym_id
#
# # Register the levels in this file
# register_levels(__name__, globals())
