import os
import time


mujoco_env_list = ["Ant-v3",
                   "HalfCheetah-v3",
                   "Walker2d-v3",
                   "Humanoid-v3",
                   "Hopper-v3",
            ]


env_list = ["Ant-v3"]
time_flag = time.strftime("%Y-%m-%d-%H-%M-%S", time.localtime())
algo = "sac"
algo_filename = algo + "_" + time_flag
seed_list = [0,10,20,30,40]

env_num = len(env_list)
gpu_list = [7]
assert len(gpu_list) == env_num, "gpu_setting is incorrect"

for seed in seed_list:
    for env_id in range(env_num):
        cmd_line = f"CUDA_VISIBLE_DEVICES={gpu_list[env_id]} " \
                   f"python train.py " \
                   f" --algo {algo} " \
                   f" --env {env_list[env_id]} " \
                   f" --seed {seed} " \
                   f" -f logs/{algo_filename}/ " \
                   f" -tb logs/{algo_filename}/tb/ &"
        print(cmd_line)
        os.system(cmd_line)
        time.sleep(5)
