# Agent-Based Collaboration Framework

This repository contains an agent-based collaboration framework for simulating and studying team dynamics and problem-solving in various domains.

## Main Modules

### Agent
- `agent/llm.py`: Implements the LLM (Language Model) class, which serves as the base class for language model-based agents.
- `agent/agent.py`: Defines the Agent class, which inherits from the LLM class and adds additional functionality specific to agents.
- `agent/software.py`: Contains the Engineer and ProjectManager classes, which are specialized agents based on the Agent class, designed for software development scenarios.

### Memory
- `agent/memory.py`: Implements the Memory class, which handles the storage and retrieval of messages for agents. It also defines the Message data type used for communication between agents.

### Team
- `agent/team.py`: Defines the Team class, which represents a group of agents working together on a common goal or task.
- `agent/belief_model.py`: Implements the BeliefModel class, which represents the rules and dynamics of a team, governing how agents interact and collaborate within the team.

## Getting Started: Case Study

- `main.py`: Simulates the collaboration between ToM ProjectManager and a team of Engineers (with ToM or not). The experiments explore the impact of the ProjectManager's Theory of Mind (ToM) level on the team's performance and dynamics.

To run the benchmark, follow the steps below:

1. Add configuration file to `config/`. Follow the instruction of `config/README.md`.
2. Run the command below. 

```bash
python main.py --pm_tom_k 1 --eng_tom_k 0 --num_engineers 5 
```

The arguments are defined in `main.py`:

    Arguments:
    - `--pm_tom_k`: Theory of Mind level for Project Manager (default: 0)
    - `--eng_tom_k`: Theory of Mind level for Engineers (default: 1) 
    - `--num_engineers`: Number of engineers in the team (default: 5)
    - `--matching`: Use matching algorithm to form coalitions (default: False)
    - `--min_coalition_size`: Minimum size of coalitions (default: 3)
    - `--max_rounds`: Maximum number of cooperation rounds (default: 5)
    - `--task`: Task identifier
    - `--output_path`: Output path (default: results)
    - `--overwrite`: Overwrite existing results (default: False)
