from typing import List, Optional, Any, Dict
import logging
from agent.llm import LLM
from agent.team import Team
class Agent(LLM):
    def __init__(self, name: str, default_prompts: list = [{"role": "system", "content": ""}], tom_k: int = 0):
        super().__init__(name=name, default_prompts=default_prompts)
        self.name = name
        self.tom_k = tom_k
        self.teammates: List['Agent'] = []
        self.logger = logging.getLogger(self.__class__.__name__)
        self.belief_models = {}

    def add_teammate(self, teammate: 'Agent') -> None:
        """Add a teammate to this agent's team"""
        self.team.add_agent(teammate)

    def get_teammates(self) -> List['Agent']:
        """Get list of teammates"""
        team: Team = self.team
        return team.get_teammates(self)

    def update_belief_model(self, belief):
        self.belief_models = belief
    
    def generate_belief_model(self):
        pass
    
    def update_default_prompts(self, prompts: List[Dict[str, str]] | List[str]):
        for prompt in prompts:
            if isinstance(prompt, dict):
                self.default_prompts.append(prompt)
            else:
                self.default_prompts.append({"role": "system", "content": prompt})
                
                