import json
from datasets import load_dataset


def prompt_fn_human_eval(task):
    prompt = task["prompt"]
    text = f"""I will provide a function signature and its docstring as follows:

{prompt}

Your task is to:

1. Write a full implementation of the function
2. Include any necessary package imports
3. Restate the function signature exactly as given

Please format your entire response as a Python code block, like this:

```python
# Any necessary imports

def function_name(required_parameters):
   
    # Implementation
    return required_output
    """
    task["idea"] = text
    task["project_name"] = task["entry_point"]
    
    return task 

def prompt_fn_mbpp(task):
    prompt = task["text"]
    text = f""" I will provide a function signature and its docstring as follows:

    {task["code"].split(":")[0]}:
    \"\"\"
    {prompt}
    \"\"\"

    Your task is to:

    1. Write a full implementation of the function
    2. Include any necessary package imports
    3. Restate the function signature exactly as given

    Please format your entire response as a Python code block, like this:

    ```python
    # Any necessary imports

    def function_name(required_parameters):
    
        # Implementation
        return required_output
        """
    
    task["idea"] = text
    task["project_name"] = str(task["task_id"])
    
    return task
    
def prepare_human_eval_dataset():
    dataset = load_dataset("openai_humaneval",split="test")
    dataset = [prompt_fn_human_eval(entry) for entry in dataset]

    with open("human_eval.jsonl","w") as f:
        for entry in dataset:
            f.write(json.dumps(entry)+"\n")
            
def prepare_mbpp_dataset():
    dataset = load_dataset("mbpp",split="test")
    dataset = [prompt_fn_mbpp(entry) for entry in dataset]


    with open("mbpp.jsonl","w") as f:
        for entry in dataset:
            f.write(json.dumps(entry)+"\n")
            
def load_jsonl(file_path):
    data = []
    with open(file_path, 'r') as file:
        for line in file:
            json_object = json.loads(line.strip())
            data.append(json_object)
    return data


def prepare_dataset(dataset_name):
    if dataset_name == "human_eval":
        prepare_human_eval_dataset()
    elif dataset_name == "mbpp":
        prepare_mbpp_dataset()
    else:
        raise ValueError(f"Invalid dataset name: {dataset_name}")
        