import json
from typing import List
# def generate_tom_response_template(tom_k: int) -> str:
#     json_template = {}
#     for i in range(0, tom_k + 1):
#         json_template[f"ToM_level{i}"] = {
#             "belief": f"{{y_{i} your inferred actions for engineers}}",
#             "explanation": f"{{concise explanation of inferring actions y_{i} and choosing x_{i} based on this belief y_{i}}}",
#             "action": f'{{x_{i} The instruction for engineers. Begin with "The Engineer should ..."}}',
#         }
#     return json.dumps(json_template, indent=4)


def generate_tom_response_template(tom_k: int, teammates_name: List[str]=[]) -> str:
    json_template = {}
    for i in range(0, tom_k + 1):
        if i == 0:
            json_template[f"ToM_level{i}"] = {
                "explanation": "{{Explain your initial thought process as a project manager for providing task outlines to the engineers}}",
                "action": {
                    engineer_name: f"{{Initial task outline for {engineer_name}}}"
                    for engineer_name in teammates_name
                },
                "belief": f"No belief to infer at this level",
            }
        else:
            json_template[f"ToM_level{i}"] = {
                "belief": {
                    engineer_name: f"{{Inferred action for {engineer_name} based on the task outline from ToM_level{i-1}}}"
                    for engineer_name in teammates_name
                },
                "explanation": f"{{Explain your thought process for inferring the actions of engineers based on the `belief` from ToM_level{i-1}}}",
                "action": {
                    engineer_name: f"{{Updated task outline for {engineer_name} considering their inferred action}}"
                    for engineer_name in teammates_name
                }
            }
    return json.dumps(json_template, indent=4)


def generate_score_template(agent_names: List[str]) -> str:
    score_template = {
        name: {
            "score": "{{float (-1 to 1). Belief alignment score for " + name + "}}",
            "explanation": "{{str - Brief explanation of " + name + "'s alignment score in 10 words or less}}",
            "justification": "{{str - Detailed justification of " + name + "'s alignment score, considering their implementation and your belief model, in 30-50 words}}"
        }
        for name in agent_names
    }
    return json.dumps(score_template, indent=2)
        
def generate_code_response_template() -> str:
    implementation = ""
    implementation += json.dumps(
            {
                "code": "{str - Your Python code implementation goes here}",
                "explanation": "{str - Briefly explain your code here}",
                "dependencies": "{List[str] - dependencies for your code}",
                "interfaces": "{Dict[str, str] - of interfaces for your code}",
            }
            , indent=2
        )
    return implementation

CODE_COMPLETE_TEMPLATE = """
{idea}

## Constraints:
Your task is to organize the final solution in one python code block in the following format:

1. Write a full implementation of the function, only one function is allowed in the code block
2. Include any necessary package imports
3. Restate the function signature exactly as given

## Final solution template:

```python
# Any necessary imports

def required_function_name(required_parameters):
   
    # Implementation
    return required_output
```
"""