from config.const import CONFIGS as configs
import os
import json

def load_task(task: str, start_idx: int = 0):
    if task == "mbpp":
        return load_mbpp(start_idx=start_idx)
    elif task == "humaneval":
        return load_humaneval(start_idx=start_idx)
    else:
       return {
           "idea": task,
       } 
def load_mbpp(start_idx: int = 0):
    dataset_path = os.path.join("dataset", "mbpp.jsonl")
    return load_jsonl(dataset_path, start_idx=start_idx)

def load_humaneval(start_idx: int = 0):
    dataset_path = os.path.join("dataset", "human_eval.jsonl")
    return load_jsonl(dataset_path, start_idx=start_idx)

def load_jsonl(dataset_path: str, start_idx: int = 0, num_samples: int = 100):
    with open(dataset_path, "r") as f:
        lines = f.readlines()
        lines = lines[start_idx:num_samples]
        return [json.loads(line) for line in lines]