from typing import List, Dict, Any, Optional
from .llm import LLM
from dataclasses import dataclass

@dataclass
class CollaborationContext:
    teammate_implementations: Dict[str, str]
    teammate_beliefs: Dict[str, Any]
    dependencies: List[str]
    interfaces: Dict[str, Any]

class Team:
    def __init__(self, name: str="Team"):
        self.name: str = name # team_name
        self.agents: List[LLM] = []
        self.collaboration_context: Optional[CollaborationContext] = None

    def add_agent(self, agent: LLM):
        self.agents.append(agent)
        agent.team = self
    def add_agents(self, agents: List[LLM]):
        self.agents += agents
        
    def remove_agent(self, agent: LLM):
        self.agents.remove(agent)
        agent.team = None
        
    def remove_agents(self, agents: List[LLM]):
        for agent in agents:
            self.remove_agent(agent)

    def get_agents(self) -> List[LLM]:
        return self.agents

    def get_teammates(self, agent: LLM|str) -> List[LLM]:
        if isinstance(agent, str):
            # by agent name
            agent_name = agent
            return [a for a in self.agents if a.name != agent_name]
        else:
            # by agent object
            return [a for a in self.agents if a != agent]
        
    def get_teammate_names(self, agent: LLM|str) -> List[str]:
        return [a.name for a in self.get_teammates(agent)]
    
    
        
# from .software import ProjectManager, Engineer
# # Create agents
# project_manager = ProjectManager(0, 1, "Develop a chatbot")
# engineer1 = Engineer(0, "Develop a chatbot")
# engineer2 = Engineer(1, "Develop a chatbot")

# # Create a team
# team = Team("Chatbot Team")

# # Add agents to the team
# team.add_agent(project_manager)
# team.add_agent(engineer1)
# team.add_agent(engineer2)

# # Get teammates of an agent
# teammates_of_engineer1 = engineer1.get_teammates()
# print(f"Teammates of Engineer 1: {[teammate.name for teammate in teammates_of_engineer1]}")