from pathlib import Path
import yaml


CONFIG_PATH = "config/config2.yaml"



def get_config():
    config_path = Path(CONFIG_PATH).expanduser()
    with open(config_path, "r") as stream:
        try:
            configs = yaml.safe_load(stream)
        except yaml.YAMLError as exc:
            print(exc)
    return configs

CONFIGS = get_config()