import logging


class Logger:
    def __init__(self, name):
        self.name = name
        self.logger = logging.getLogger(self.name)

        if not self.logger.hasHandlers():
            self.logger.setLevel(logging.INFO)
            handler = logging.StreamHandler()
            handler.setFormatter(
                logging.Formatter(
                    "%(asctime)s - %(name)s - %(levelname)s - %(message)s"
                )
            )
            self.logger.addHandler(handler)

    def info(self, message):
        self.logger.info(message)
        return message

    def debug(self, message):
        self.logger.debug(message)
        return message

    def warning(self, message):
        self.logger.warning(message)
        return message

    def error(self, message):
        self.logger.error(message)
        return message

