import json
import logging 
from typing import List
from agent.software import ProjectManager, Engineer


async def save_outline(
    project_manager: ProjectManager, round: int, project_manager_dir: str
):
    outline = await project_manager.run()
    try:
        with open(
            f"{project_manager_dir}/outline_round{round + 1}.json",
            "w",
            encoding="utf-8",
        ) as f:
            json.dump(outline, f, ensure_ascii=False, indent=4)

        logging.info(f"Project Manager {project_manager.id} saved outline.")
        return (outline, project_manager.id)
    except Exception as e:
        logging.error(f"Failed to save outline: {str(e)}")
        raise ValueError(f"Failed to save outline: {str(e)}")


async def save_implementation(
    engineer: Engineer,
    outline: str,
    round: int,
    proj_id: int,
    project_manager_dirs: List[str],
):
    engineer_id = engineer.id
    implementation = await engineer.run(outline, proj_id)
    try:
        with open(
            f"{project_manager_dirs[proj_id]}/engineer{engineer_id}_round{round + 1}.py",
            "w",
        ) as f:
            f.write(implementation.strip("```python \n```"))
        logging.info(f"Engineer {engineer_id} saved implementation.")
        return (engineer, implementation, proj_id)
    except Exception as e:
        logging.error(f"Failed to save implementation: {str(e)}")
        raise ValueError(f"Failed to save implementation: {str(e)}")
