def method_default_args(prob_type):
    if prob_type in ['simple', 'nonconvex']:
        defaults = {}
        defaults['saveAllStats'] = True
        defaults['resultsSaveFreq'] = 50

        defaults['epochs'] = 150
        defaults['descent_step'] = 6
        defaults['batchSize'] = 64
        defaults['lr'] = 0.01
        defaults['hiddenSize'] = 200
        defaults['softWeight'] = 10
        defaults['softWeightEqFrac'] = 0.5
        defaults['useCompl'] = True
        defaults['useTrainCorr'] = True
        defaults['useTestCorr'] = True
        defaults['corrMode'] = 'partial'
        defaults['corrTrainSteps'] = 5
        defaults['corrTestMaxSteps'] = 5
        defaults['corrEps'] = 1e-4
        defaults['corrLr'] = 1e-7
        defaults['corrMomentum'] = 0.3

        if prob_type == 'simple':
            defaults['simpleVar'] = 100
            defaults['simpleIneq'] = 50
            defaults['simpleEq'] = 50
            defaults['simpleEx'] = 10000
        elif prob_type == 'nonconvex':
            defaults['nonconvexVar'] = 100
            defaults['nonconvexIneq'] = 50
            defaults['nonconvexEq'] = 50
            defaults['nonconvexEx'] = 10000

        return defaults

    # acopf 使用 config 配置
    elif 'acopf' in prob_type:
        return config()

    else:
        raise NotImplementedError


def config():
    defaults = {}
    defaults['predType'] = ['NN', 'NN_Eq'][1]
    defaults['projType'] = ['WS', 'Proj', 'D_Proj', 'H_Bis'][3]
    defaults['probType'] = ['qp', 'socp', 'convex_qcqp', 'sdp', 'acopf'][4]
    defaults['probSize'] = [[100, 50, 50, 10000],
                            [200, 100, 100, 20000]][1]
    defaults['opfSize'] = [[30,  10000],
                           [118, 20000]][1]
    defaults['testSize'] = 1024
    defaults['saveAllStats'] = False
    defaults['resultsSaveFreq'] = 1000
    defaults['seed'] = 2023

    defaults['mapping_para'] = \
        {'training': True, 'testing': False,
        'n_samples': 1024,
        't_samples': 10000,
        'bound': [0, 1],
        'scale_ratio': 1,
        'shape': 'square',
        'total_iteration': 10000,
        'batch_size': 512,
        'num_layer': 3,
        'lr': 1e-4,
        'lr_decay': 0.9,
        'lr_decay_step': 1000,
        'penalty_coefficient': 10,
        'distortion_coefficient': 1,
        'transport_coefficient': 0,
        'testing_samples': 1024}


    defaults['nn_para'] = \
        {'training': False, 'testing': True,
         'approach': 'unsupervise',
        'total_iteration': 10000,
        'epochs': 300,
        'batch_size': 512,
        'lr': 1e-3,
        'lr_decay': 0.9,
        'lr_decay_step': 1000,
        'descent_step': 6,
        'num_layer': 3,
        'objWeight': 1,
        'softWeightInEqFrac': 5.0,
        'softWeightEqFrac': 5.0}


    defaults['proj_para'] = \
        {'useTestCorr': False,    # post-process for infeasible solutions
        'corrMode': 'partial',    # equality completion
        'corrTestMaxSteps': 15,  # steps for D-Proj
        'corrBis': 0.9,           # steps for bisection
        'corrEps': 1e-5,          # tolerance for constraint violation
        'corrLr': 1e-5,           # stepsize for gradient descent in D-Proj
        'corrMomentum': 0.1, }    # momentum parameter in D-Proj

    return defaults
