# MLGLP: Multi-Scale Line Graph Link Prediction

<img src="./MLGLP.jpg" alt="Sample Image" width="1500" height="500"/>


# Introduction
This repository provides the official PyTorch implementation of the research paper "Multi-Scale Line Graph Link Prediction." The code is designed to run on Linux and requires a GPU.


# Training and Evaluating
To run MLGLP on dataset "Power", with test ratio=0.2 and maximum train number=100000, just type

```sh
!python Main.py --data-name=Power --test-ratio=0.2 --max-train-num=100000

```

# Requirements

The latest tested setup includes: Python 3.8.1 + Pytorch 1.4.0
Required python libraries: torch, torchvision, torchaudio, torch_sparse, gensim, torch_geometric, networkx, scikit-learn, ogb, tqdm, scipy, numpy, torch_scatter, matplotlib

# Installation

You can install the required libraries using the following commands:

pip install torch torchvision torchaudio
pip install torch_sparse 
pip install gensim
pip install torch_geometric
pip install networkx==2.8.8
pip install scikit-learn
pip install ogb 
pip install tqdm 
pip install scipy 
pip install numpy
pip install torch_scatter
pip install matplotlib


# Verification of Installation

You can check your installation with this code snippet:


```sh
import torch
print(torch.__version__)
print(torch.version.cuda)
if torch.cuda.is_available():
    print(f"CUDA is available. Using GPU: {torch.cuda.get_device_name(0)}")
else:
    print("CUDA is not available. Running on CPU.")
```