# OGN: Online Graph Nets

<b>The code and evaluation protocol is based
in the code provided by TGN, whose code can be found </b>
[here](https://github.com/twitter-research/tgn).

## Running the experiments

### Requirements

Dependencies (with python >= 3.7):

```{bash}
pandas==1.2.4
numpy==1.20.3
torch==1.6.0
scikit_learn==0.24.2
```

### Dataset and Preprocessing

#### Download the public data
Download the sample datasets (eg. wikipedia and reddit) from
[here](http://snap.stanford.edu/jodie/) and store their csv files in a folder named
```data/```.

#### Preprocess the data
We use the dense `npy` format to save the features in binary format. If edge features or nodes 
features are absent, they will be replaced by a vector of zeros. 
```{bash}
python preprocess_data.py --data wikipedia --bipartite
python preprocess_data.py --data reddit --bipartite
```

### Model Training

Self-supervised learning using the link prediction task.

To run OGN on Reddit:

```{bash}
# OGN in reddit and wikipedia 
python train.py --data reddit --activation tanh --alpha 1e-8 --bs 200 --n_epoch 100 --patience 10 --n_runs 1 --batch_norm --set_uniform
```

To run OGN on Wikipedia:

```{bash}
python train.py --data wikipedia --activation relu --alpha 1.0 --bs 200 --n_epoch 100 --patience 10 --n_runs 1 --batch_norm --set_uniform
```


