
%BL-M06
addpath('./utils1/');
addpath('../tensor_toolbox');
addpath('../tensor_toolbox/met/');

dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(MMSE).mat';
%dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(ADAS).mat';
path = '../../data/';
load([path dataset]);


time_points = 7;
X = cell([1,time_points]);
Y = cell([1,time_points]);

%MMSE dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X{1,1} = double(tenmat(new_Maha_MMSE_sc_ZYsc_m06Y_m12_m24Z, 3));
X{1,2} = double(tenmat(new_Maha_MMSE_m06_ZYsc_m06Y_m12_m24Z, 3));
X{1,3} = double(tenmat(new_Maha_MMSE_m12_ZYsc_m06Y_m12_m24Z, 3));
X{1,4} = double(tenmat(new_Maha_MMSE_m24_ZYsc_m06Y_m12_m24Z, 3));
X{1,5} = double(tenmat(new_Maha_MMSE_m36_ZYsc_m06Y_m12_m24Z, 3));
X{1,6} = double(tenmat(new_Maha_MMSE_m48_ZYsc_m06Y_m12_m24Z, 3));
X{1,7} = double(tenmat(new_Maha_MMSE_m60_ZYsc_m06Y_m12_m24Z, 3));

[S, T, ~] = size(new_Maha_MMSE_m60_ZYsc_m06Y_m12_m24Z);

[Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_MMSE_sc_Ysc_m06_m12_m24Y);
[Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_MMSE_m06_Ysc_m06_m12_m24Y);
[Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_MMSE_m12_Ysc_m06_m12_m24Y);
[Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_MMSE_m24_Ysc_m06_m12_m24Y);
[Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_MMSE_m36_Ysc_m06_m12_m24Y);
[Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_MMSE_m48_Ysc_m06_m12_m24Y);
[Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_MMSE_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ADAS-Cog dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% X{1,1} = double(tenmat(new_Maha_ADAS_sc_ZYsc_m06Y_m12_m24Z, 3));
% X{1,2} = double(tenmat(new_Maha_ADAS_m06_ZYsc_m06Y_m12_m24Z, 3));
% X{1,3} = double(tenmat(new_Maha_ADAS_m12_ZYsc_m06Y_m12_m24Z, 3));
% X{1,4} = double(tenmat(new_Maha_ADAS_m24_ZYsc_m06Y_m12_m24Z, 3));
% X{1,5} = double(tenmat(new_Maha_ADAS_m36_ZYsc_m06Y_m12_m24Z, 3));
% X{1,6} = double(tenmat(new_Maha_ADAS_m48_ZYsc_m06Y_m12_m24Z, 3));
% X{1,7} = double(tenmat(new_Maha_ADAS_m60_ZYsc_m06Y_m12_m24Z, 3));
%
% [S, T, ~] = size(new_Maha_ADAS_m60_ZYsc_m06Y_m12_m24Z);
%
% [Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_ADAS_sc_Ysc_m06_m12_m24Y);
% [Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_ADAS_m06_Ysc_m06_m12_m24Y);
% [Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_ADAS_m12_Ysc_m06_m12_m24Y);
% [Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_ADAS_m24_Ysc_m06_m12_m24Y);
% [Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_ADAS_m36_Ysc_m06_m12_m24Y);
% [Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_ADAS_m48_Ysc_m06_m12_m24Y);
% [Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_ADAS_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Standardization
Y_mean = [Y_mean1, Y_mean2, Y_mean3, Y_mean4, Y_mean5, Y_mean6, Y_mean7];
Y_std = [Y_std1, Y_std2, Y_std3, Y_std4, Y_std5, Y_std6, Y_std7];


% split data into training and testing.
training_percent = 0.9;
[X_tr1, Y_tr, X_te1, Y_te] = mtSplitPerc(X, Y, training_percent);


%Tensor formation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X_tr = cell([1,time_points]);
X_te = cell([1,time_points]);
AA = [];
for t = 1:time_points
    a = 1;
    X_test = X_tr1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_tr{1,t} = DT;
end

for t = 1:time_points
    a = 1;
    X_test = X_te1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_te{1,t} = DT;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X_all = cell([1,time_points]);
for t = 1:time_points
    Z = cat(3, X_tr{t}, X_te{t});
    X_all{1,t} = Z;
end

tic;

% the function used for evaluation.
eval_func_str = 'eval_TMTL_rmse';
higher_better = false;  % rmse is lower the better.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% cross validation fold
cv_fold = 5;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% model parameter range
%λ, β, θ
param_range = [0.001 0.01 0.1 1 10 100 1000 10000];
%α
CCP_range_1 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_2 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_3 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_4 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_5 = [0.1 0.15 0.3 0.45 0.5];
%r
R_range = [1 2 3 4 5];


fprintf('Perform model selection via cross validation: \n')


% [ perform_mat,best_params] = progressModelCrossValidation1Param...
%     ( X_all, X_tr, Y_tr, 'TMTL', param_range, cv_fold,eval_func_str, higher_better, CCP_range_1, CCP_range_2, CCP_range_3, CCP_range_4, CCP_range_5, R_range);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%The optimal parameter
best_params(1,1) = 0.01;
best_params(2,1) = 0.001;
best_params(3,1) = 1000;
best_params(4,1) = 0.15;
best_params(5,1) = 0.15;
best_params(6,1) = 0.15;
best_params(7,1) = 0.15;
best_params(8,1) = 0.15;  %CCP
best_params(9,1) = 3;  %R

%Build model using the optimal parameter
[W, A, B, C, b] = TMTL(X_all, X_tr, Y_tr, best_params(1,1), best_params(2,1), best_params(3,1), best_params(4,1), best_params(5,1), best_params(6,1), best_params(7,1), best_params(8,1), best_params(9,1));

MAE_test=zeros(time_points,1);
rmse_test=zeros(time_points,1);
y_pred = cell([1,time_points]);

for i = 1: time_points
    
    W_task = reshape(W(:,i), [S, T]);
    b_task = b(1,i);
    A_task = reshape(A(:,i), [S, best_params(9,1)]);
    B_task = reshape(B(:,i), [T, best_params(9,1)]);
    [TestingSize, ~] = size(Y_te{i});
    
    [S1, T1, ~] = size(X_te{i});
    H1=zeros(S1, T1);
    for i1 = 1: S1
        for j1 = 1: T1
            if(j1 > i1)
                H1(i1, j1) = 1;
            end
        end
    end
    
    Y_hat = squeeze(sum(double(tenmat(X_te{i} .* repmat(reshape((A_task*B_task') .* (W_task.*H1), [S, T, 1]), [1, 1, TestingSize]), 3)), 2))+b_task;
    
    Y_hat = Y_hat.*repmat(Y_std(i),size(Y_hat,1),1)+repmat(Y_mean(i),size(Y_hat,1),1);
    Y_te{i} = Y_te{i}.*repmat(Y_std(i),size(Y_te{i},1),1)+repmat(Y_mean(i),size(Y_te{i},1),1);
    
    MAE_test(i,1) = mean(abs(Y_hat - Y_te{i}));
    rmse_test(i,1) = sqrt(mean((Y_hat - Y_te{i}).^2));
    y_pred{i} = Y_hat;
    
end

nmse = final_eval_TMTL_nmse_progress(Y_te, X_te, y_pred);
wR = final_eval_TMTL_wR(Y_te, X_te, y_pred);

toc;
operation_time=toc;

save(['MMSE  ' num2str(operation_time) '.mat'], ...
    'MAE_test', 'rmse_test', 'nmse', 'wR', ...
    'W', 'A', 'B', 'C', 'b', ...
    'y_pred', 'Y_te', 'best_params','operation_time');

%Update biomarker latent factor knowledge base
CL = zeros(S*T,time_points);
for i = 1: time_points
    A_task = reshape(A(:,i), [S, best_params(9,1)]);
    B_task = reshape(B(:,i), [T, best_params(9,1)]);
    CL_task = A_task*B_task';
    CL(:,i) = CL_task(:);
end

clearvars -except CL;







%M06-M12
addpath('./utils1/');
addpath('../tensor_toolbox');
addpath('../tensor_toolbox/met/');

dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(MMSE).mat';
%dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(ADAS).mat';
path = '../../data/';
load([path dataset]);


time_points = 7;
X = cell([1,time_points]);
Y = cell([1,time_points]);

%MMSE dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X{1,1} = double(tenmat(new_Maha_MMSE_sc_Zsc_Ym06_m12Y_m24Z, 3));
X{1,2} = double(tenmat(new_Maha_MMSE_m06_Zsc_Ym06_m12Y_m24Z, 3));
X{1,3} = double(tenmat(new_Maha_MMSE_m12_Zsc_Ym06_m12Y_m24Z, 3));
X{1,4} = double(tenmat(new_Maha_MMSE_m24_Zsc_Ym06_m12Y_m24Z, 3));
X{1,5} = double(tenmat(new_Maha_MMSE_m36_Zsc_Ym06_m12Y_m24Z, 3));
X{1,6} = double(tenmat(new_Maha_MMSE_m48_Zsc_Ym06_m12Y_m24Z, 3));
X{1,7} = double(tenmat(new_Maha_MMSE_m60_Zsc_Ym06_m12Y_m24Z, 3));

[S, T, ~] = size(new_Maha_MMSE_m60_Zsc_Ym06_m12Y_m24Z);

[Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_MMSE_sc_Ysc_m06_m12_m24Y);
[Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_MMSE_m06_Ysc_m06_m12_m24Y);
[Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_MMSE_m12_Ysc_m06_m12_m24Y);
[Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_MMSE_m24_Ysc_m06_m12_m24Y);
[Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_MMSE_m36_Ysc_m06_m12_m24Y);
[Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_MMSE_m48_Ysc_m06_m12_m24Y);
[Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_MMSE_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%ADAS-Cog dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% X{1,1} = double(tenmat(new_Maha_ADAS_sc_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,2} = double(tenmat(new_Maha_ADAS_m06_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,3} = double(tenmat(new_Maha_ADAS_m12_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,4} = double(tenmat(new_Maha_ADAS_m24_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,5} = double(tenmat(new_Maha_ADAS_m36_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,6} = double(tenmat(new_Maha_ADAS_m48_Zsc_Ym06_m12Y_m24Z, 3));
% X{1,7} = double(tenmat(new_Maha_ADAS_m60_Zsc_Ym06_m12Y_m24Z, 3));
%
% [S, T, ~] = size(new_Maha_ADAS_m60_Zsc_Ym06_m12Y_m24Z);
%
% [Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_ADAS_sc_Ysc_m06_m12_m24Y);
% [Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_ADAS_m06_Ysc_m06_m12_m24Y);
% [Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_ADAS_m12_Ysc_m06_m12_m24Y);
% [Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_ADAS_m24_Ysc_m06_m12_m24Y);
% [Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_ADAS_m36_Ysc_m06_m12_m24Y);
% [Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_ADAS_m48_Ysc_m06_m12_m24Y);
% [Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_ADAS_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Standardization
Y_mean = [Y_mean1, Y_mean2, Y_mean3, Y_mean4, Y_mean5, Y_mean6, Y_mean7];
Y_std = [Y_std1, Y_std2, Y_std3, Y_std4, Y_std5, Y_std6, Y_std7];

% split data into training and testing.
training_percent = 0.9;
[X_tr1, Y_tr, X_te1, Y_te] = mtSplitPerc(X, Y, training_percent);

%Tensor formation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X_tr = cell([1,time_points]);
X_te = cell([1,time_points]);
AA = [];
for t = 1:time_points
    a = 1;
    X_test = X_tr1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_tr{1,t} = DT;
end

for t = 1:time_points
    a = 1;
    X_test = X_te1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_te{1,t} = DT;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X_all = cell([1,time_points]);
for t = 1:time_points
    Z = cat(3, X_tr{t}, X_te{t});
    X_all{1,t} = Z;
end

tic;

% the function used for evaluation.
eval_func_str = 'eval_TMTL_rmse_2';
higher_better = false;  % rmse is lower the better.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% cross validation fold
cv_fold = 5;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% model parameter range
%λ, β, θ
param_range = [0.001 0.01 0.1 1 10 100 1000 10000];
%α
CCP_range_1 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_2 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_3 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_4 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_5 = [0.1 0.15 0.3 0.45 0.5];
%r
R_range = [1 2 3 4 5];
%η
delta_range = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];

fprintf('Perform model selection via cross validation: \n')


% [ perform_mat,best_params] = progressModelCrossValidation1Param_2...
%     ( X_all, X_tr, Y_tr, 'TMTL_2', param_range, cv_fold,eval_func_str, higher_better, CCP_range_1, CCP_range_2, CCP_range_3, CCP_range_4, CCP_range_5, R_range, delta_range, CL);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%The optimal parameter
best_params(1,1) = 0.01;
best_params(2,1) = 0.001;
best_params(3,1) = 1000;
best_params(4,1) = 0.15;
best_params(5,1) = 0.15;
best_params(6,1) = 0.15;
best_params(7,1) = 0.15;
best_params(8,1) = 0.15;  %CCP
best_params(9,1) = 3;  %R
best_params(10,1) = 0.2;  %delta

% build model using the optimal parameter
[W, A, B, C, b] = TMTL_2(X_all, X_tr, Y_tr, best_params(1,1), best_params(2,1), best_params(3,1), best_params(4,1), best_params(5,1), best_params(6,1), best_params(7,1), best_params(8,1), best_params(9,1), best_params(10,1), CL);

MAE_test=zeros(time_points,1);
rmse_test=zeros(time_points,1);
y_pred = cell([1,time_points]);

for i = 1: time_points
    
    W_task = reshape(W(:,i), [S, T]);
    b_task = b(1,i);
    A_task = reshape(A(:,i), [S, best_params(9,1)]);
    B_task = reshape(B(:,i), [T, best_params(9,1)]);
    CL_task = reshape(CL(:,i), [S, T]);
    [TestingSize, ~] = size(Y_te{i});
    
    [S1, T1, ~] = size(X_te{i});
    H1=zeros(S1, T1);
    for i1 = 1: S1
        for j1 = 1: T1
            if(j1 > i1)
                H1(i1, j1) = 1;
            end
        end
    end
    
    Y_hat = squeeze(sum(double(tenmat(X_te{i} .* repmat(reshape((best_params(10,1)*(CL_task)+(1-best_params(10,1))*(A_task*B_task')) .* (W_task.*H1), [S, T, 1]), [1, 1, TestingSize]), 3)), 2))+b_task;
    
    Y_hat = Y_hat.*repmat(Y_std(i),size(Y_hat,1),1)+repmat(Y_mean(i),size(Y_hat,1),1);
    Y_te{i} = Y_te{i}.*repmat(Y_std(i),size(Y_te{i},1),1)+repmat(Y_mean(i),size(Y_te{i},1),1);
    
    MAE_test(i,1) = mean(abs(Y_hat - Y_te{i}));
    rmse_test(i,1) = sqrt(mean((Y_hat - Y_te{i}).^2));
    y_pred{i} = Y_hat;
    
end

nmse = final_eval_TMTL_nmse_progress(Y_te, X_te, y_pred);
wR = final_eval_TMTL_wR(Y_te, X_te, y_pred);

toc;
operation_time=toc;

save(['MMSE  ' num2str(operation_time) '.mat'], ...
    'MAE_test', 'rmse_test', 'nmse', 'wR', ...
    'W', 'A', 'B', 'C', 'b', ...
    'y_pred', 'Y_te', 'best_params','operation_time');



%Update biomarker latent factor knowledge base
CL_new = zeros(S*T,time_points);
for i = 1: time_points
    A_task = reshape(A(:,i), [S, best_params(9,1)]);
    B_task = reshape(B(:,i), [T, best_params(9,1)]);
    CL_task = reshape(CL(:,i), [S, T]);
    CL_new_task = (best_params(10,1)*(CL_task))+((1-best_params(10,1))*(A_task*B_task'));
    CL_new(:,i) = CL_new_task(:);
end

CL = CL_new;
clearvars -except CL;






%M12-M24
addpath('./utils1/');
addpath('../tensor_toolbox');
addpath('../tensor_toolbox/met/');

dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(MMSE).mat';
%dataset = 'ADNI_MRI_BL_to_M06_to_M12_to_M24_(ADAS).mat';
path = '../../data/';
load([path dataset]);

time_points = 7;
X = cell([1,time_points]);
Y = cell([1,time_points]);

%MMSE dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X{1,1} = double(tenmat(new_Maha_MMSE_sc_Zsc_m06_Ym12_m24YZ, 3));
X{1,2} = double(tenmat(new_Maha_MMSE_m06_Zsc_m06_Ym12_m24YZ, 3));
X{1,3} = double(tenmat(new_Maha_MMSE_m12_Zsc_m06_Ym12_m24YZ, 3));
X{1,4} = double(tenmat(new_Maha_MMSE_m24_Zsc_m06_Ym12_m24YZ, 3));
X{1,5} = double(tenmat(new_Maha_MMSE_m36_Zsc_m06_Ym12_m24YZ, 3));
X{1,6} = double(tenmat(new_Maha_MMSE_m48_Zsc_m06_Ym12_m24YZ, 3));
X{1,7} = double(tenmat(new_Maha_MMSE_m60_Zsc_m06_Ym12_m24YZ, 3));

[S, T, ~] = size(new_Maha_MMSE_sc_Zsc_m06_Ym12_m24YZ);

[Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_MMSE_sc_Ysc_m06_m12_m24Y);
[Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_MMSE_m06_Ysc_m06_m12_m24Y);
[Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_MMSE_m12_Ysc_m06_m12_m24Y);
[Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_MMSE_m24_Ysc_m06_m12_m24Y);
[Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_MMSE_m36_Ysc_m06_m12_m24Y);
[Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_MMSE_m48_Ysc_m06_m12_m24Y);
[Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_MMSE_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%ADAS-Cog dataset input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% X{1,1} = double(tenmat(new_Maha_ADAS_sc_Zsc_m06_Ym12_m24YZ, 3));
% X{1,2} = double(tenmat(new_Maha_ADAS_m06_Zsc_m06_Ym12_m24YZ, 3));
% X{1,3} = double(tenmat(new_Maha_ADAS_m12_Zsc_m06_Ym12_m24YZ, 3));
% X{1,4} = double(tenmat(new_Maha_ADAS_m24_Zsc_m06_Ym12_m24YZ, 3));
% X{1,5} = double(tenmat(new_Maha_ADAS_m36_Zsc_m06_Ym12_m24YZ, 3));
% X{1,6} = double(tenmat(new_Maha_ADAS_m48_Zsc_m06_Ym12_m24YZ, 3));
% X{1,7} = double(tenmat(new_Maha_ADAS_m60_Zsc_m06_Ym12_m24YZ, 3));
%
% [S, T, ~] = size(new_Maha_ADAS_sc_Zsc_m06_Ym12_m24YZ);
%
% [Y{1,1}, Y_mean1, Y_std1] = zscore(ADNI_ADAS_sc_Ysc_m06_m12_m24Y);
% [Y{1,2}, Y_mean2, Y_std2] = zscore(ADNI_ADAS_m06_Ysc_m06_m12_m24Y);
% [Y{1,3}, Y_mean3, Y_std3] = zscore(ADNI_ADAS_m12_Ysc_m06_m12_m24Y);
% [Y{1,4}, Y_mean4, Y_std4] = zscore(ADNI_ADAS_m24_Ysc_m06_m12_m24Y);
% [Y{1,5}, Y_mean5, Y_std5] = zscore(ADNI_ADAS_m36_Ysc_m06_m12_m24Y);
% [Y{1,6}, Y_mean6, Y_std6] = zscore(ADNI_ADAS_m48_Ysc_m06_m12_m24Y);
% [Y{1,7}, Y_mean7, Y_std7] = zscore(ADNI_ADAS_m60_Ysc_m06_m12_m24Y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Standardization
Y_mean = [Y_mean1, Y_mean2, Y_mean3, Y_mean4, Y_mean5, Y_mean6, Y_mean7];
Y_std = [Y_std1, Y_std2, Y_std3, Y_std4, Y_std5, Y_std6, Y_std7];

% split data into training and testing.
training_percent = 0.9;
[X_tr1, Y_tr, X_te1, Y_te] = mtSplitPerc(X, Y, training_percent);

%Tensor formation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X_tr = cell([1,time_points]);
X_te = cell([1,time_points]);
AA = [];
for t = 1:time_points
    a = 1;
    X_test = X_tr1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_tr{1,t} = DT;
end

for t = 1:time_points
    a = 1;
    X_test = X_te1{1,t};
    [sample, ~] = size(X_test);
    TEN = tensor;
    for s = 1:sample
        for i = 1:S
            for j = 1:T
                AA(i,j) = X_test(s,a);
                a = a + 1;
                if (a > S*T)
                    a = 1;
                end
            end
        end
        TEN(:,:,s) = AA;
        AA = [];
    end
    DT = double(TEN);
    X_te{1,t} = DT;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X_all = cell([1,time_points]);
for t = 1:time_points
    Z = cat(3, X_tr{t}, X_te{t});
    X_all{1,t} = Z;
end

tic;

% the function used for evaluation.
eval_func_str = 'eval_TMTL_rmse_2';
higher_better = false;  % rmse is lower the better.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% cross validation fold
cv_fold = 5;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% model parameter range
%λ, β, θ
param_range = [0.001 0.01 0.1 1 10 100 1000 10000];
%α
CCP_range_1 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_2 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_3 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_4 = [0.1 0.15 0.3 0.45 0.5];
CCP_range_5 = [0.1 0.15 0.3 0.45 0.5];
%r
R_range = [1 2 3 4 5];
%η
delta_range = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];

fprintf('Perform model selection via cross validation: \n')


% [ perform_mat,best_params] = progressModelCrossValidation1Param_2...
%     ( X_all, X_tr, Y_tr, 'TMTL_2', param_range, cv_fold,eval_func_str, higher_better, CCP_range_1, CCP_range_2, CCP_range_3, CCP_range_4, CCP_range_5, R_range, delta_range, CL);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%The optimal parameter
best_params(1,1) = 0.01;
best_params(2,1) = 0.001;
best_params(3,1) = 1000;
best_params(4,1) = 0.15;
best_params(5,1) = 0.15;
best_params(6,1) = 0.15;
best_params(7,1) = 0.15;
best_params(8,1) = 0.15;  %CCP
best_params(9,1) = 3;  %R
best_params(10,1) = 0.2;  %delta


%Build model using the optimal parameter
[W, A, B, C, b] = TMTL_2(X_all, X_tr, Y_tr, best_params(1,1), best_params(2,1), best_params(3,1), best_params(4,1), best_params(5,1), best_params(6,1), best_params(7,1), best_params(8,1), best_params(9,1), best_params(10,1), CL);

MAE_test=zeros(time_points,1);
rmse_test=zeros(time_points,1);
y_pred = cell([1,time_points]);

for i = 1: time_points
    
    W_task = reshape(W(:,i), [S, T]);
    b_task = b(1,i);
    A_task = reshape(A(:,i), [S, best_params(9,1)]);
    B_task = reshape(B(:,i), [T, best_params(9,1)]);
    CL_task = reshape(CL(:,i), [S, T]);
    [TestingSize, ~] = size(Y_te{i});
    
    [S1, T1, ~] = size(X_te{i});
    H1=zeros(S1, T1);
    for i1 = 1: S1
        for j1 = 1: T1
            if(j1 > i1)
                H1(i1, j1) = 1;
            end
        end
    end
    
    Y_hat = squeeze(sum(double(tenmat(X_te{i} .* repmat(reshape((best_params(10,1)*(CL_task)+(1-best_params(10,1))*(A_task*B_task')) .* (W_task.*H1), [S, T, 1]), [1, 1, TestingSize]), 3)), 2))+b_task;
    
    Y_hat = Y_hat.*repmat(Y_std(i),size(Y_hat,1),1)+repmat(Y_mean(i),size(Y_hat,1),1);
    Y_te{i} = Y_te{i}.*repmat(Y_std(i),size(Y_te{i},1),1)+repmat(Y_mean(i),size(Y_te{i},1),1);
    
    MAE_test(i,1) = mean(abs(Y_hat - Y_te{i}));
    rmse_test(i,1) = sqrt(mean((Y_hat - Y_te{i}).^2));
    y_pred{i} = Y_hat;
    
end

nmse = final_eval_TMTL_nmse_progress(Y_te, X_te, y_pred);
wR = final_eval_TMTL_wR(Y_te, X_te, y_pred);

toc;
operation_time=toc;

save(['MMSE  ' num2str(operation_time) '.mat'], ...
    'MAE_test', 'rmse_test', 'nmse', 'wR', ...
    'W', 'A', 'B', 'C', 'b', ...
    'y_pred', 'Y_te', 'best_params','operation_time');

