%% FUNCTION mtSplitPerc
%   Multi-task data set splitting by percentage. 
%   
%% INPUT
%   X: {n * d} * t - input matrix
%   Y: {n * 1} * t - output matrix
%   percent: percentage of the splitting range (0, 1)
%
%% OUTPUT
%   X_sel: the split of X that has the specifid percent of samples 
%   Y_sel: the split of Y that has the specifid percent of samples 
%   X_res: the split of X that has the 1-percent of samples 
%   Y_res: the split of Y that has the 1-percent of samples 
%   selIdx: the selection index of for X_sel and Y_sel for each task
%
%

function [X_sel, Y_sel, X_res, Y_res, selIdx] = mtSplitPerc(X, Y, percent)

if percent > 1 || percent <0
    error('splitting percentage error')
end

time_points = length(X);

selIdx = cell(time_points, 0);
X_sel = cell(time_points, 0);
Y_sel = cell(time_points, 0);
X_res = cell(time_points, 0);
Y_res = cell(time_points, 0);

for t = 1: time_points
    task_sample_size = length(Y{t});
    tSelIdx = randperm(task_sample_size) <task_sample_size * percent;
    
    selIdx{t} = tSelIdx;
    
    X_sel{t} = X{t}(tSelIdx,:);
    Y_sel{t} = Y{t}(tSelIdx,:);
    X_res{t} = X{t}(~tSelIdx,:);
    Y_res{t} = Y{t}(~tSelIdx,:);
    
end