function [ perform_mat,best_params] = progressModelCrossValidation1Param_2...
    ( XTA, X, Y, obj_func_str, param_range, cv_fold, eval_func_str, higher_better, CCP_range_1, CCP_range_2, CCP_range_3, CCP_range_4, CCP_range_5, R_range, delta_range, CL)
%% Function CROSSVALIDATION1PARAM
%   Model selection (cross validation) for parameters
%


eval_func = str2func(eval_func_str);
obj_func  = str2func(obj_func_str);


% compute sample size for each task
time_points = length(X);

% performance vector
perform_mat = zeros(length(param_range),length(param_range),length(param_range));
best_params=zeros(10,1);
% begin cross validation
fprintf('[')
for cv_idx = 1: cv_fold
    fprintf('.')
    
    % buid cross validation data splittings for each task.
    cv_Xtr = cell(1, time_points);
    cv_Ytr = cell(1, time_points);
    cv_Xte = cell(1, time_points);
    cv_Yte = cell(1, time_points);
    
    for t = 1: time_points
        task_sample_size = length(Y{t});
        te_idx = cv_idx : cv_fold : task_sample_size;
        tr_idx = setdiff(1:task_sample_size, te_idx);
        
        cv_Xtr{t} = X{t}(:, :, tr_idx);
        cv_Ytr{t} = Y{t}(tr_idx, :);
        cv_Xte{t} = X{t}(:, :, te_idx);
        cv_Yte{t} = Y{t}(te_idx, :);
    end
    
    if (cv_fold == 1)
        cv_Xtr = cv_Xte;
        cv_Ytr = cv_Yte;
    end
    
    
    
    if(higher_better)
        max_eval=-inf;
        for p_id_10 = 1:length(delta_range)
            for p_id_9 = 1:length(R_range)
                for p_id_8 = 1:length(CCP_range_5)
                    for p_id_7 = 1:length(CCP_range_4)
                        for p_id_6 = 1:length(CCP_range_3)
                            for p_id_5 = 1:length(CCP_range_2)
                                for p_id_4 = 1:length(CCP_range_1)
                                    for p_id_1=1:length(param_range)
                                        for p_id_2=1:length(param_range)
                                            for p_id_3=1:length(param_range)
                                                [W, A, B, C, b] = obj_func(XTA, cv_Xtr, cv_Ytr, param_range(p_id_1),param_range(p_id_2), param_range(p_id_3), CCP_range_1(p_id_4), CCP_range_2(p_id_5), CCP_range_3(p_id_6), CCP_range_4(p_id_7), CCP_range_5(p_id_8), R_range(p_id_9), delta_range(p_id_10), CL);
                                                temp=eval_func(cv_Yte, cv_Xte, W, A, B, C, b, R_range(p_id_9), delta_range(p_id_10), CL);
                                                if(max_eval<temp)
                                                    best_params(1,1)=param_range(p_id_1);
                                                    best_params(2,1)=param_range(p_id_2);
                                                    best_params(3,1)=param_range(p_id_3);
                                                    best_params(4,1)=CCP_range_1(p_id_4);
                                                    best_params(5,1)=CCP_range_2(p_id_5);
                                                    best_params(6,1)=CCP_range_3(p_id_6);
                                                    best_params(7,1)=CCP_range_4(p_id_7);
                                                    best_params(8,1)=CCP_range_5(p_id_8);
                                                    best_params(9,1)=R_range(p_id_9);
                                                    best_params(10,1)=delta_range(p_id_10);
                                                    max_eval=temp;
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    else
        min_eval=inf;
        for p_id_10 = 1:length(delta_range)
            for p_id_9 = 1:length(R_range)
                for p_id_8 = 1:length(CCP_range_5)
                    for p_id_7 = 1:length(CCP_range_4)
                        for p_id_6 = 1:length(CCP_range_3)
                            for p_id_5 = 1:length(CCP_range_2)
                                for p_id_4 = 1:length(CCP_range_1)
                                    for p_id_1=1:length(param_range)
                                        for p_id_2=1:length(param_range)
                                            for p_id_3=1:length(param_range)
                                                [W, A, B, C, b] = obj_func(XTA, cv_Xtr, cv_Ytr, param_range(p_id_1),param_range(p_id_2), param_range(p_id_3), CCP_range_1(p_id_4), CCP_range_2(p_id_5), CCP_range_3(p_id_6), CCP_range_4(p_id_7), CCP_range_5(p_id_8), R_range(p_id_9), delta_range(p_id_10), CL);
                                                temp=eval_func(cv_Yte, cv_Xte, W, A, B, C, b, R_range(p_id_9), delta_range(p_id_10), CL);
                                                if(min_eval>temp)
                                                    best_params(1,1)=param_range(p_id_1);
                                                    best_params(2,1)=param_range(p_id_2);
                                                    best_params(3,1)=param_range(p_id_3);
                                                    best_params(4,1)=CCP_range_1(p_id_4);
                                                    best_params(5,1)=CCP_range_2(p_id_5);
                                                    best_params(6,1)=CCP_range_3(p_id_6);
                                                    best_params(7,1)=CCP_range_4(p_id_7);
                                                    best_params(8,1)=CCP_range_5(p_id_8);
                                                    best_params(9,1)=R_range(p_id_9);
                                                    best_params(10,1)=delta_range(p_id_10);
                                                    min_eval=temp;
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end

fprintf(']\n')


end

