"""Constant variables."""

from __future__ import annotations


__all__ = [
    'IGNORE_INDEX',
    'DEFAULT_BOS_TOKEN',
    'DEFAULT_EOS_TOKEN',
    'DEFAULT_PAD_TOKEN',
    'DEFAULT_UNK_TOKEN',
    'PROMPT_BEGIN',
    'PROMPT_USER',
    'PROMPT_ASSISTANT',
    'PROMPT_INPUT',
    'PROMPT_DICT',
    'PROMPT_DICTS',
    'ADAM_BETAS',
]


IGNORE_INDEX: int = -100
DEFAULT_BOS_TOKEN: str = '<s>'
DEFAULT_EOS_TOKEN: str = '</s>'
DEFAULT_PAD_TOKEN: str = '<pad>'
DEFAULT_UNK_TOKEN: str = '<unk>'

PROMPT_BEGIN: str = ''
PROMPT_USER: str = '[INST] {input} [/INST]'
PROMPT_ASSISTANT: str = ''

PROMPT_INPUT: str = PROMPT_BEGIN + PROMPT_USER + PROMPT_ASSISTANT

PROMPT_DICT: dict[str, str] = {
    'prompt_begin': PROMPT_BEGIN,
    'prompt_user': PROMPT_USER,
    'prompt_assistant': PROMPT_ASSISTANT,
    'prompt_input': PROMPT_INPUT,
}

PROMPT_DICTS: dict[str, dict[str, str]] = {
    'mistral-instruct': PROMPT_DICT,
    'metamath': {
        'prompt_begin': 'Below is an instruction that describes a task. Write a response that appropriately completes the request.\n\n',
        'prompt_user': '### Instruction:\n{input}\n\n',
        'prompt_assistant': '### Response:'
    },
    'llama3-instruct': {
        'prompt_begin': '<|start_header_id|>system<|end_header_id|>\n\nBelow is an instruction that describes a task. Write a response that appropriately completes the request.<|eot_id|>',
        'prompt_user': '<|start_header_id|>user<|end_header_id|>\n\n{input}<|eot_id|>',
        'prompt_assistant': '<|start_header_id|>assistant<|end_header_id|>\n\n'
    },
    'tulu': {
        'prompt_begin': 'Below is an instruction that describes a task. Write a response that appropriately completes the request.\n\n',
        'prompt_user': '<|user|>\n{input}\n',
        'prompt_assistant': '<|assistant|>\n'
    },
    'deepseek-coder': {
        'prompt_begin': 'You are an AI programming assistant, utilizing the Deepseek Coder model, developed by Deepseek Company, and you only answer questions related to computer science. For politically sensitive questions, security and privacy issues, and other non-computer science questions, you will refuse to answer\n',
        'prompt_user': '### Instruction:\n{input}\n',
        'prompt_assistant': '### Response:\n'
    }
}

ADAM_BETAS: tuple[float, float] = (0.9, 0.95)

