This code packages are for reviewers’ checking only. Please do not distribute to others. We will release the codes and results after the review.
We test our methods with the tasks developed by previous researchers, which are all open to use for common research. Our research is consistent with their intended use.

## Setup Environment

1. Create a conda environment and install dependency:
```bash
conda create -n llmfp python=3.9
conda activate llmfp
pip install -r requirements.txt
export OPENAI_API_KEY=YOUR_OPENAI_KEY
```

2. Get data:
* OptiGuide (from public repo https://github.com/microsoft/OptiGuide) contains Coffee, Workforce, and Facility queries
* LLMs-Planning (from public repo https://github.com/karthikv792/LLMs-Planning, and we processed into natural language) contains Blocksworld, Mystery Blocksworld queries
* Task Allocation and Warehouse queries are generated automatically when running test script in pipelines.
* Movie and Gripper queries (from public repo https://github.com/minecraft-saar/autoplanbench) are included in ```database```.

## Running
For every test script in pipelines, run test_xxx.py to run LLMFP on certain task. For example, the command to run coffee task is ```python pipelines/combinatorial/test_coffee.py```. You can also change the index to start and end. 

Note for Claude, the current code utlizes AWS to access Claude, you might want to switch to your own function to call Claude in openai_func.py. Since only prompts for single-step multi-constraint problems the prompts are diffrent for Claude and GPT, we only include testing scripts for these problems in ```pipelines/claude/```.

## Prompts
The prompts we used are included at top of the testing scripts.