import threestudio
from packaging.version import Version

if hasattr(threestudio, "__version__") and Version(threestudio.__version__) >= Version(
    "0.2.1"
):
    pass
else:
    if hasattr(threestudio, "__version__"):
        print(f"[INFO] threestudio version: {threestudio.__version__}")
    raise ValueError(
        "threestudio version must be >= 0.2.0, please update threestudio by pulling the latest version from github"
    )

from . import data
from .system import gsface, gsmeshface #, loss_utils
from .guidance import mp_guidance, facesr_guidance,supir_guidance,blip_guidance,vivid123_guidance,arcface_guidance
from .render import facemesh_render, facemesh_batch_render
from .geometry import facemesh
# import dino
