
# An End-to-End Model For Logits Based Large Language Models Watermarking     

 
## Description   
The source code of the paper "An End-to-End Model For Logits Based Large Language Models Watermarking"   

## How to run   
First, install dependencies: python 3.9, pytorch 2.1, and other packages by
```bash
pip install -r requirements.txt
 ```   

Run the ```test.py``` for testing our model.

```bash
python test.py
```

The ```test.py``` run the following function and the arguments are explained:

```python
def test(llm_name='opt-1.3b', assess_type='det', assess_name='no_attack', ds_len=-1):
    """
        Test the LLM with given assessment type and assessment name.

        Parameters:
            llm_name: The name of the LLM. 'opt-1.3b', 'Llama-2-7b-hf', 'Llama-2-7b-chat-hf'.
            assess_type: The type of assessment, 'det' for detection, 'qlt' for quality.
            assess_name: The name of the assessment.
                For detection, 'no_attack', 'delete', 'substitute', 'context_substitute', 'paraphrase_dipper'.
                For quality, 'PPL', 'Log Diversity', 'BLEU', 'pass@1'.
            ds_len: The length of the dataset. If -1, the whole dataset is used.
    """
```

The hyper-parameters of our model can be changed in the ```watermark/e2e/e2e.py``` file.

```python
class E2EConfig:
    def __init__(self, transformers_config: TransformersConfig, ckpt) -> None:
        # wm cfg
        self.delta = 1.25
        self.k = 20
        self.win_size = 10

```