import os
import argparse

# import subprocess

from pathlib import Path
from utils.io import load_yaml, save_yaml
import numpy as np


# generate dyanmical system data config files.
# config_path = f"data/process/analysis/lorenz-base.yaml"


def get_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "-c", "--config_path", help="analysis yaml config", type=str, default=None
    )
    parser.add_argument(
        "-n",
        "--noise",
        help="process_noise_std of the dynamics fn. this overrides config file.",
        type=str,
        default=None,
    )
    # parser.add_argument("-ss", "--speed_start", help="starting speed", type=float, default=None)
    # parser.add_argument("-se", "--speed_end", help="starting speed", type=float, default=None)
    return parser


def generate_configs(config):
    # script that generates file structure with config files

    # config_path = args.config_path
    if config["save_dir"] is None:
        config["save_dir"] = "data/analysis"

    save_dir = config["save_dir"]
    save_dir = (save_dir + ".")[:-1]

    sweep_values = config["sweep_values"].copy()
    sweep_key = config["sweep_key"].split("/").copy()

    config["save_dir"] = None
    config.pop("sweep_values", None)  # remove sweep values from config
    config.pop("sweep_key", None)  # remove sweep key from config

    speed = np.linspace(
        config["speed_start"], config["speed_end"], num=len(sweep_values)
    )

    config_paths = []
    for seed, (sv, sp) in enumerate(zip(sweep_values, speed)):
        d = config
        # sweep_key = config["sweep_key"].split("/")
        for key in sweep_key[:-1]:
            d = d[key]
        d[sweep_key[-1]] = sv

        # create subdir
        tag = "_".join(
            [
                f"{k}-{v}".replace("/", "-")
                for k, v in config["sde_args"]["dynamics_args"].items()
            ]
        )
        noise = config["sde_args"]["diffusion_args"]["sigma"]
        noise_str = f"noise-{noise}"

        config["sde_args"]["speed"] = sp.item()
        config["seed"] = seed  # new seed for each config

        save_dir_ = Path(save_dir) / config["sde_args"]["dynamics_fn"] / noise_str / tag
        # save_dir = Path(config["save_dir"]) / config["sde_args"]["dynamics_fn"] / "_".join([tag, f"noise-{noise}"])

        os.makedirs(save_dir_, exist_ok=True)

        save_config_path = save_dir_ / "config.yaml"
        save_yaml(config, save_config_path)

        config_paths.append(save_config_path)
        print(f"Config saved to: {save_config_path}")

    # generate script to generate data
    # save_script_path = save_dir_.parent / "generate_data.sh"
    save_script_path = "data/process/analysis/generate_data_commands.sh"
    with open(save_script_path, "a") as f:
        # f.write("#!/bin/bash\n")
        for config_path in config_paths:
            f.write(
                f"python data/process/analysis/generate_data.py --config_path {config_path}\n"
            )

    print(f"Script to generate data saved to: {save_script_path}")
    print("Configs generated successfully.")


# def  generate_configs(config):
#     # script that generates file structure with config files

#     # config_path = args.config_path
#     if config["save_dir"] is None:
#         config["save_dir"] = "data/analysis"

#     save_dir = config["save_dir"]
#     save_dir = (save_dir + '.')[:-1]

#     sweep_values = config["sweep_values"].copy()
#     sweep_key = config["sweep_key"].split("/").copy()

#     config["save_dir"] = None
#     config.pop("sweep_values", None)  # remove sweep values from config
#     config.pop("sweep_key", None)  # remove sweep key from config

#     config_paths = []
#     for sv in sweep_values:
#         d = config
#         # sweep_key = config["sweep_key"].split("/")
#         for key in sweep_key[:-1]:
#             d = d[key]
#         d[sweep_key[-1]] = sv

#         # create subdir
#         tag = "_".join([f"{k}-{v}".replace("/","-") for k, v in config["sde_args"]["dynamics_args"].items()])
#         noise = config["sde_args"]["diffusion_args"]["sigma"]
#         noise_str = f"noise-{noise}"

#         save_dir_ = Path( save_dir ) / config["sde_args"]["dynamics_fn"] / noise_str / tag
#         # save_dir = Path(config["save_dir"]) / config["sde_args"]["dynamics_fn"] / "_".join([tag, f"noise-{noise}"])

#         os.makedirs(save_dir_, exist_ok=True)

#         save_config_path = save_dir_ / "config.yaml"
#         save_yaml(config, save_config_path)

#         config_paths.append(save_config_path)
#         print(f"Config saved to: {save_config_path}")

#     # generate script to generate data
#     # save_script_path = save_dir_.parent / "generate_data.sh"
#     save_script_path = "data/process/analysis/generate_data_commands.sh"
#     with open(save_script_path, "a") as f:
#         # f.write("#!/bin/bash\n")
#         for config_path in config_paths:
#             f.write(f"python data/process/analysis/generate_data.py --config_path {config_path}\n")

#     print(f"Script to generate data saved to: {save_script_path}")
#     print("Configs generated successfully.")

# subprocess.call(['sh', save_script_path])


if __name__ == "__main__":

    parser = get_parser()
    args = parser.parse_args()

    config_path = args.config_path
    config = load_yaml(config_path)
    if args.noise is not None:
        config["sde_args"]["diffusion_args"]["sigma"] = float(args.noise)

    generate_configs(config)
