# create scripts/generated/commands.txt for mass pretraining

import os
from pathlib import Path

from utils.io import get_full_config, write_list_to_txtfile
from utils.io import find_all_directory_children_w_filter

# Example usage
top = "configs/semi-supervised"
config_paths = find_all_directory_children_w_filter(top, ".yaml")

commands = []
for c in config_paths:
    for s in [0, 1, 2, 3, 4]:
        config = get_full_config(c)

        subdir_name = config["model_type"]
        if config["model_name"] is not None:
            subdir_name = config["model_name"]

        if config["save_dir"] is None:
            data_name = [
                i for i in config["data_args"]["path"].split("/") if i != "data"
            ][0]
            sd = os.path.join(f"experiments", data_name, subdir_name, f"seed_{s}")

        if os.path.exists(Path(sd) / "scores.pkl"):  # skip if scores already exist
            continue

        commands.append(f"python scripts/run_pretrain.py -c {c} -s {s} -sd {sd}")

os.makedirs("scripts/generated", exist_ok=True)
write_list_to_txtfile(commands, "scripts/generated/commands_semi_supervised.sh")
