# generate transfer configs
import os
import argparse
from pathlib import Path
from utils.io import (
    find_all_directory_children_w_filter,
    write_list_to_txtfile,
    get_full_config,
)


def get_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "-td",
        "--top_backbone_dir",
        help="config path yaml file",
        type=str,
        default=None,
    )
    parser.add_argument(
        "-tc",
        "--transfer_config",
        help="set transfer config. this overrides the config file",
        type=str,
        default=None,
    )
    parser.add_argument(
        "-o",
        "--output_path",
        help="set data_path. this overrides the config file",
        type=str,
        default=None,
    )
    return parser


if __name__ == "__main__":
    parser = get_parser()
    args = parser.parse_args()

    top_parent_dir = args.top_backbone_dir
    transfer_config_path = args.transfer_config
    output_path = args.output_path

    paths = find_all_directory_children_w_filter(top_parent_dir, "seed")
    paths = [p for p in paths if "hp_" not in p]

    commands = []

    # seed = 1
    for path in paths:
        ckpt_path = Path(path) / "checkpoint_best"
        seed = str(Path(path).stem).split("_")[-1]

        # scores_path = Path(path) / "scores.pkl"
        # scores_path = Path(str(scores_path).replace("har", "gesture"))

        if ckpt_path.exists():
            # print(path, scores_path.exists())
            cmd = f"python scripts/run_transfer.py -c {transfer_config_path} -p {ckpt_path} -s {seed}"
            print(cmd)
            commands.append(cmd)

    write_list_to_txtfile(commands, output_path)
