import numpy as np
from sklearn.metrics import r2_score


def mse_loss(true, pred):
    return ((true - pred) ** 2).mean()


def mae_loss(true, pred):
    return np.abs(true - pred).mean()


def compute_scores(true, pred):
    scores = {
        "MSE": mse_loss(true, pred),
        "R2": r2_score(true, pred),
        "MAE": mae_loss(true, pred),
    }
    return scores


def compute_masked_loss(criterion, true, pred, mask):
    p = pred.flatten()[mask.flatten().bool()]
    t = true.flatten()[mask.flatten().bool()]
    loss = criterion(p, t)
    return loss
