#!/bin/bash
while IFS= read -r cmd; do
    sbatch <<EOF
#!/bin/bash
#SBATCH --job-name=pulse-generate_analysis
#SBATCH --output=slurm-logs/slurm-%j.out
#SBATCH --time=01:00:00
#SBATCH --partition=overcap
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1


export PYTHONPATH=~/flash/PULSE

source ~/flash/miniconda3/etc/profile.d/conda.sh
conda activate pulse

$cmd
EOF
done < data/process/analysis/generate_data_commands.sh


