import os
import zipfile
import requests
from tqdm import tqdm
import os


# from urllib.request import urlretrieve

# eeg datasets are from this repo: https://github.com/mims-harvard/TFC-pretraining

targetpaths = {
    "sleep_eeg": "data/sleep_eeg",
    "epilepsy": "data/epilepsy",
    "ptbxl": "data/ptbxl",
    "hhar": "data/hhar",
    "synthetic": "data/synthetic",
    "gesture": "data/gesture",
}

zippaths = {
    "sleep_eeg": "data/sleep_eeg.zip",
    "epilepsy": "data/epilepsy.zip",
    "ptbxl": "data/ptbxl.zip",
    "hhar": "data/hhar.zip",
    "gesture": "data/gesture.zip",
}

links = {
    "sleep_eeg": "https://physionet.org/static/published-projects/sleep-edfx/sleep-edf-database-expanded-1.0.0.zip",
    "epilepsy": "https://figshare.com/ndownloader/articles/19930199/versions/2",
    "gesture": "https://figshare.com/ndownloader/articles/19930247/versions/1",
    "ptbxl": "https://physionet.org/static/published-projects/ptb-xl/ptb-xl-a-large-publicly-available-electrocardiography-dataset-1.0.3.zip",
    "hhar": "https://archive.ics.uci.edu/static/public/344/heterogeneity+activity+recognition.zip",
}

processed_path = {
    "sleep_eeg": "data/sleep_eeg/processed",
    "epilepsy": "data/epilepsy/processed",
    "gesture": "data/gesture/processed",
    "ptbxl": "data/ptbxl/processed",
    "hhar": "data/hhar/processed",
    "synthetic": "data/synthetic/processed",
}


def download_file(url, filename):
    """
    Helper method handling downloading large files from `url` to `filename`. Returns a pointer to `filename`.
    """
    chunkSize = 1024
    r = requests.get(url, stream=True)
    with open(filename, "wb") as f:
        if "Content-Length" in r.headers:
            total_size = int(r.headers["Content-Length"])
            pbar = tqdm(unit="B", total=total_size, unit_scale=True)
        else:
            total_size = None
            pbar = tqdm(unit="B", unit_scale=True)

        for chunk in r.iter_content(chunk_size=chunkSize):
            if chunk:  # filter out keep-alive new chunks
                pbar.update(len(chunk))
                f.write(chunk)
    return filename


def unzip_file(zippath, targetpath, remove=True):
    with zipfile.ZipFile(zippath, "r") as zip_ref:
        zip_ref.extractall(targetpath)
    if remove:
        os.remove(zippath)


def downloadextract(key, redownload=False):
    targetpath = targetpaths[key]
    zippath = zippaths[key]
    link = links[key]
    if os.path.exists(targetpath) and redownload == False:
        print(f"{key} files already exist")
        return

    print(f"Downloading {key} files ...")
    download_file(link, zippath)

    print(f"Unzipping {key} files ...")
    unzip_file(zippath, targetpath, remove=True)

    print("Done extracting and downloading")
