# MSDNet-PyTorch

## Dependencies:

+ Python3
+ PyTorch >= 0.4.0

## Network Configurations

#### Train an MSDNet (block=7) on CIFAR-100 for *anytime prediction*: 

```
python3 damping-weight.py --data-root /PATH/TO/CIFAR100 --data cifar100 --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 64 --epochs 300 --nBlocks 7 \
                --stepmode even --step 2 --base 4 --nChannels 16 \
                -j 16
```
```
python3 damping-power-sqrt.py --data-root /PATH/TO/CIFAR100 --data cifar100 --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 64 --epochs 300 --nBlocks 7 \
                --stepmode even --step 2 --base 4 --nChannels 16 \
                -j 16
```
```
python3 damping-power-sqrt-dynamic-training-detach.py --data-root /PATH/TO/CIFAR100 --data cifar100 --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 64 --epochs 300 --nBlocks 7 \
                --stepmode even --step 2 --base 4 --nChannels 16 \
                -j 16
```

#### Train an MSDNet (block=7) on CIFAR-100 for *anytime prediction*: 

```
python3 damping-weight.py --data-root /PATH/TO/ImageNet --data ImageNet --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 256 --epochs 100 --nBlocks 5 \
                --stepmode even --step 4 --base 4 --nChannels 32 --growthRate 16 \
                --grFactor 1-2-4-4 --bnFactor 1-2-4-4 \
                
```
```
python3 damping-power-sqrt.py --data-root /PATH/TO/ImageNet --data ImageNet --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 256 --epochs 100 --nBlocks 5 \
                --stepmode even --step 4 --base 4 --nChannels 32 --growthRate 16 \
                --grFactor 1-2-4-4 --bnFactor 1-2-4-4 \
```
```
python3 damping-power-sqrt-dynamic-training-detach.py --data-root /PATH/TO/ImageNet --data ImageNet --save /PATH/TO/SAVE \
                --arch msdnet --batch-size 256 --epochs 100 --nBlocks 5 \
                --stepmode even --step 4 --base 4 --nChannels 32 --growthRate 16 \
                --grFactor 1-2-4-4 --bnFactor 1-2-4-4 \