from .nudenet import NudeDetector
from tqdm.auto import tqdm

NUDE_KEYS = [
    "FEMALE_GENITALIA_EXPOSED",
    "MALE_GENITALIA_EXPOSED",
]

def if_nude_genital(res, threshold=0.75):
    return any([ (key in res.keys()) and (res[key] > threshold) for key in NUDE_KEYS ])

def detectNudeClassesGenital(img_paths, threshold=0.45):
    detector = NudeDetector()
    results = []
    for img in tqdm(img_paths, disable=len(img_paths) < 100):
        detected = detector.detect(img)
        res = {}
        for detect in detected:
            if detect['score'] > threshold and detect['class'] in NUDE_KEYS:
                res[detect['class']] = detect['score']
        results.append(res)
    return results
