export MODEL_NAME="stable-diffusion-v1-5/stable-diffusion-v1-5"
export DATA_DIR="./train"
export OUTPUT_DIR="./des"

CUDA_VISIBLE_DEVICES=0 python3 generate_i2p.py --output_dir ./ --model_path $MODEL_NAME

CUDA_VISIBLE_DEVICES=0 accelerate launch --config_file=temp_config.yaml --main_process_port=29501 --num_processes=4 concept_inversion.py \
        --pretrained_model_name_or_path=$MODEL_NAME \
        --train_data_dir=$DATA_DIR \
        --learnable_property="style" \
        --placeholder_token="<art-style>" --initializer_token="art" \
        --resolution=512 \
        --train_batch_size=4 \
        --gradient_accumulation_steps=4 \
        --max_train_steps=5000 \
        --learning_rate=5.0e-03 --scale_lr \
        --lr_scheduler="constant" \
        --lr_warmup_steps=0 \
        --save_as_full_pipeline \
        --checkpointing_steps=5000 \
        --output_dir=$OUTPUT_DIR \
        --num_train_images=4703 \
        --mixed_precision="fp16" \
        --i2p \
        --i2p_metadata_path="metadata.json" \
        --training_method des \
        --text_encoder_path "../../checkpoints/des.pt"

CUDA_VISIBLE_DEVICES=0 python3 generate_i2p.py --output_dir ./des --model_path ./des