# Activate proper environment
# conda activate sd3



# Table 1
python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/coco_prompts.csv" \
    --output_path "t2i_coco" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5
mkdir results/v1.5/coco
mv results/t2i_coco_*png results/v1.5/coco/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_full_prompts.csv" \
    --output_path "t2i_i2p_full" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/i2p
mv results/t2i_i2p_full_*png results/v1.5/i2p/



# Table 2
python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/sneaky_prompts.csv" \
    --output_path "t2i_sneaky" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/sneaky
mv results/t2i_sneaky_*png results/v1.5/sneaky/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/mma_prompts.csv" \
    --output_path "t2i_mma" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/mma
mv results/t2i_mma_*png results/v1.5/mma/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/ringabell_prompts.csv" \
    --output_path "t2i_ringabell" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/ringabell
mv results/t2i_ringabell_*png results/v1.5/ringabell/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/p4d_prompts.csv" \
    --output_path "t2i_p4d" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/p4d
mv results/t2i_p4d_*png results/v1.5/p4d/



# Table 3
python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/mma_des_wb_prompts.csv" \
    --output_path "t2i_mma_wb" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/mma_wb
mv results/t2i_mma_wb_*png results/v1.5/mma_wb/

# Refer to "Diffusion-MU-Attack/run_uda.sh" for UnlearenDiffAtk

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/ringabell_des_wb_prompts.csv" \
    --output_path "t2i_ringabell_wb" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/v1.5/ringabell_wb
mv results/t2i_ringabell_wb_*png results/v1.5/ringabell_wb/

# Refer to "circumventing-concept-erasure/fmn/run_cce.sh" for CCE



# Table 4
python i2i.py \
    --model_path runwayml/stable-diffusion-inpainting \
    --device cuda:0 \
    --prompts_csv "prompts/mma_diffusion_adv_images.csv" \
    --image_path "prompts/mma_i2i/normal" \
    --output_path "i2i_mma_bbprompt_normalimage" \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/i2i
mkdir results/i2i/mma
mv results/i2i_mma_bbprompt_normalimage_*png results/i2i/mma/

python i2i.py \
    --model_path runwayml/stable-diffusion-inpainting \
    --device cuda:0 \
    --prompts_csv "prompts/mma_diffusion_adv_images.csv" \
    --image_path "prompts/mma_i2i/adv_bb" \
    --image_type "adv" \
    --output_path "i2i_mma_bbprompt_bbimage" \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/i2i/mma_mm
mv results/i2i_mma_bbprompt_bbimage_*png results/i2i/mma_mm/

python i2i.py \
    --model_path runwayml/stable-diffusion-inpainting \
    --device cuda:0 \
    --prompts_csv "prompts/mma_diffusion_adv_images.csv" \
    --wb_prompts_csv "prompts/mma_des_wb_prompts.csv" \
    --image_path "prompts/mma_i2i/normal" \
    --end_idx 61 \
    --output_path "i2i_mma_wbprompt_normalimage" \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/i2i/mma_wb
mv results/i2i_mma_wbprompt_normalimage_*png results/i2i/mma_wb/

python i2i.py \
    --model_path runwayml/stable-diffusion-inpainting \
    --device cuda:0 \
    --prompts_csv "prompts/mma_diffusion_adv_images.csv" \
    --wb_prompts_csv "prompts/mma_des_wb_prompts.csv" \
    --image_path "prompts/mma_i2i/adv_wb" \
    --image_type "adv" \
    --end_idx 61 \
    --output_path "i2i_mma_wbprompt_wbimage" \
    --training_method des \
    --text_encoder_path "checkpoints/des.pt"

mkdir results/i2i/mma_mm_wb
mv results/i2i_mma_wbprompt_wbimage_*png results/i2i/mma_mm_wb/



# Table 5
python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_violence_prompts.csv" \
    --output_path "t2i_i2p_violence" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_violence
mv results/t2i_i2p_violence_*png results/v1.5/i2p_violence/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_illegal_prompts.csv" \
    --output_path "t2i_i2p_illegal" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_illegal
mv results/t2i_i2p_illegal_*png results/v1.5/i2p_illegal/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_hate_prompts.csv" \
    --output_path "t2i_i2p_hate" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_hate
mv results/t2i_i2p_hate_*png results/v1.5/i2p_hate/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_selfharm_prompts.csv" \
    --output_path "t2i_i2p_selfharm" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_selfharm
mv results/t2i_i2p_selfharm_*png results/v1.5/i2p_selfharm/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_harassment_prompts.csv" \
    --output_path "t2i_i2p_harassment" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_harassment
mv results/t2i_i2p_harassment_*png results/v1.5/i2p_harassment/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/i2p_shocking_prompts.csv" \
    --output_path "t2i_i2p_shocking" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5/i2p_shocking
mv results/t2i_i2p_shocking_*png results/v1.5/i2p_shocking/

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/coco_prompts.csv" \
    --output_path "t2i_coco" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_multi.pt"

mkdir results/v1.5
mkdir results/v1.5/coco_multi
mv results/t2i_coco_*png results/v1.5/coco_multi/

# Refer to "Diffusion-MU-Attack/run_uda.sh" for UnlearenDiffAtk for Van Gogh concept

python def_sdv2.py \
    --model_path stable-diffusion-v1-5/stable-diffusion-v1-5 \
    --device cuda:0 \
    --prompts_csv "prompts/coco_prompts.csv" \
    --output_path "t2i_coco" \
    --start_idx 1 \
    --training_method des \
    --text_encoder_path "checkpoints/des_vangogh.pt"

mkdir results/v1.5
mkdir results/v1.5/coco_vangogh
mv results/t2i_coco_*png results/v1.5/coco_vangogh/

