from .linear_model import LinearModel

from .schnet import SchNetBase

from .dpp import DimeNetPlusPlusBase

from .painn import PaiNN

from .gemnet import GemNetT 

from .visnet import ViSNet 
from .e2gnn import E2GNN 

MODEL_REGISTRY = {
    'linear': LinearModel,

    'schnet': SchNetBase,
    'dimenetpp': DimeNetPlusPlusBase,
    'painn': PaiNN,
    'gemnet-t': GemNetT,

    'visnet': ViSNet,

    'e2gnn': E2GNN,
}