set -x

read -r -d '' training_commands <<EOF
openrlhf.main.train_nashmd \
   --save_path ./checkpoint/llama3-1b-nashmd \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --train_batch_size 256 \
   --micro_train_batch_size 16 \
   --pretrain FuseAI/FuseChat-Llama-3.2-1B-SFT \
   --reward_pretrain ./checkpoint/llama3-1b-rm \
   --bf16 \
   --max_epochs 1 \
   --max_len 8192 \
   --zero_stage 3 \
   --learning_rate 5e-7 \
   --beta 0.1 \
   --dataset JSON_Preference \
   --apply_chat_template \
   --flash_attn \
   --load_checkpoint \
   --gradient_checkpointing
EOF
    # --use_wandb [WANDB_TOKENS] or True (use wandb login command)
    # --ipo [for IPO]
    # --label_smoothing 0.1 [for cDPO]
    # --ref_offload
    # --packing_samples
    # --nll_loss_coef (Regularization with NLL loss)


if [[ ${1} != "slurm" ]]; then
    python -m $training_commands
fi
