set -x

read -r -d '' training_commands <<EOF
openrlhf.main.train_ppo \
   --pretrain FuseAI/FuseChat-Llama-3.2-1B-SFT \
   --reward_pretrain ./checkpoint/llama3-1b-rm \
   --save_path ./checkpoint/llama-3-1b-ppo \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --micro_train_batch_size 64 \
   --train_batch_size 64 \
   --micro_rollout_batch_size 16 \
   --rollout_batch_size 16 \
   --max_epochs 5 \
   --prompt_max_len 1024 \
   --generate_max_len 1024 \
   --bf16 \
   --actor_learning_rate 5e-7 \
   --critic_learning_rate 9e-6 \
   --init_kl_coef 0.01 \
   --prompt_data JSON_Preference \
   --apply_chat_template \
   --max_samples 100000 \
   --normalize_reward \
   --adam_offload \
   --flash_attn \
   --load_checkpoint \
   --gradient_checkpointing
EOF

    # --packing_samples
    # --use_wandb [WANDB_TOKENS] or True (use wandb login command)
    # --remote_rm_url http://localhost:5000/get_reward

if [[ ${1} != "slurm" ]]; then
    python -m $training_commands
fi
