import os
import logging
from datetime import datetime

def configure_logging(log_file_dir):
    # Create a logger instance
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)  # Set the logging level

    # Clear any existing handlers (important to avoid duplicate logs)
    if logger.hasHandlers():
        logger.handlers.clear()

    # Create a timestamped log file name
    timestamp = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
    log_file = os.path.join(log_file_dir, f"{timestamp}.log")

    # File handler for logging to a file
    file_handler = logging.FileHandler(log_file)
    file_handler.setFormatter(logging.Formatter('%(asctime)s - %(levelname)s - %(message)s'))

    # Stream handler for logging to the console
    stream_handler = logging.StreamHandler()
    stream_handler.setFormatter(logging.Formatter('%(asctime)s - %(levelname)s - %(message)s'))

    # Add handlers to the logger
    logger.addHandler(file_handler)
    logger.addHandler(stream_handler)

    return logger