import numpy as np

BIH = False
CHB = False
MNIST = False
CIFAR10 = True


if MNIST:
    list_dataset = [0]
    path_data = f'FANC/MNIST/mnist_test.csv'
    deltas = [0.001, 0.01]
    mean, std = 0, 1
    flag_clip = True
    num_not_classes = 9
    ex_mode = 1  # 1 for FNN or 2 for CNN

elif CIFAR10:
    list_dataset = [0]
    path_data = f'FANC/CIFAR/cifar10_test.csv'
    deltas = [0.001, 0.01]
    mean, std = [0.4914, 0.4822, 0.4465], [0.2023, 0.1994, 0.2010]
    flag_clip = True
    num_not_classes = 9
    ex_mode = 3  # 3 for FNN or 4 for CNN

elif CHB:
    nn = 17
    list_dataset = list(np.arange(nn, nn+1))
    path_data = f'CHB/testset/patient{nn:02d}_test.csv'
    path_net_1 = f'CHB/VNN/patient_{nn:02d}_modified.h5'
    path_net_2 = f'CHB/original/patient_{nn:02d}.h5'
    deltas = [0.0001,	0.0005,	0.001, 0.002]
    mean, std = 0, 1
    num_not_classes = 1
    ex_mode = 5

elif BIH:
    nn = 5
    list_all = [106, 119, 200, 203, 208, 209, 212, 213, 221, 222, 223, 228, 231, 233]
    list_dataset = list(np.arange(nn, nn+1))
    path_data = f'BIH/testset/patient{list_all[list_dataset[0]]:03d}_test.csv'
    path_net_1 = f'BIH/original/patient_{list_all[list_dataset[0]]:03d}.h5'
    path_net_2 = f'BIH/T5/BIH_distilled_patient{list_all[list_dataset[0]]:03d}_5.0.h5'
    deltas = [0.005,	0.01,	0.02,	0.04]
    mean, std = 0, 1
    num_not_classes = 1
    ex_mode = 5


if ex_mode == 1:  # MNIST FFNN
    path_net_1 = f'FANC/MNIST/FNN_original_h5/fcnn7_original.h5'
    path_net_2 = f'FANC/MNIST/FNN_prune_h5/fcnn7_prune_tune3.h5'
elif ex_mode == 2:  # MNIST CNN
    path_net_1 = f'FANC/MNIST/CNN_prune_h5/fconv4_prune_tune2.h5'
    path_net_2 = f'FANC/MNIST/CNN_original_h5/fconv4_original.h5'
elif ex_mode == 3:  # CIFAR10 FNN
    path_net_1 = 'FANC/CIFAR/FNN_quant_h5/fcnn7_cifar_float16.h5'
    path_net_2 = 'FANC/CIFAR/FNN_original_h5/fcnn7_cifar_original.h5'
elif ex_mode == 4:  # CIFAR10 CNN
    path_net_1 = 'FANC/CIFAR/CNN_original_h5/fconv4_cifar_original.h5'
    path_net_2 = 'FANC/CIFAR/CNN_prune_h5/fconv4_cifar_prune_tune1.h5'
elif ex_mode == 5:
    print('This is your own neural network and dataset.')
    flag_clip = False

