
# coding: utf-8

# In[25]:


import pandas as pd

import sys
sys.path.append("..")
sys.path.append("") 


# In[26]:


from conditional_bias_scan import ConditionalBiasScan
from cbs_preprocessor import CBSPreProcessor
from cbs_logger import CBSLogger
from yaml_funcs import YamlFunctions
from dataset_specific_funcs import DatasetSpecificFuncs


# In[27]:


tilde_p = "tilde_p"
p_bin_var = "p_bin_var"


# In[28]:


# reading in scan configs file, etc

yaml_configs_path = "../fsscan_yamls/fsscan_configs-COMPAS.yaml"
yaml_funcs = YamlFunctions(yaml_configs_path)
fsscan_configs = yaml_funcs.run()


# In[29]:


#1. dataset specific preprocessing configs file
data_specs_func = DatasetSpecificFuncs(fsscan_configs["data_set_specific_yaml"], tilde_p, p_bin_var)
data, dataset_yaml, tilde_probability_var, p_bin_var = data_specs_func.run()

# producing all scans in config file
scans = yaml_funcs.produce_scans(data)


print(scans)


# In[30]:


#defining logger

cbs_logger = CBSLogger(fsscan_configs["results_folder"])


# In[31]:


data


# In[34]:



# running all scans and writing their results to a csv file
i = 0
for scan in scans:
    cbs = ConditionalBiasScan(  scan["protected_class"], scan["protected_value"], scan["combo"], scan["event"] ,scan["conditional_variable"], fsscan_configs["fsscan_params"],scan["direction"], scan["feature_list"], scan["scan_type"], scan["scan_feature_list"], scan["threshold_probability"], scan["threshold_cutoff"] )
    results =  cbs.run(dataset_yaml, data,p_bin_var, tilde_probability_var)
    stats = cbs_logger.write_results(results["best_subset"], 
                             results["best_score"], 
                             results["best_param"], 
                             results["treatment"], 
                             results["treatment_events"], 
                             results["treatment_p_hat"], 
                             results["controls"],
                             results["control_events"],
                            results["control_conditional_var"],
                            results["treatment_conditional_var"],
                            results["dataset_yaml"],
                            scan["protected_class"],
                            scan["protected_value"], 
                            scan["combo"],
                            scan["event"],
                            scan["conditional_variable"],
                            fsscan_configs["fsscan_params"],
                            scan["direction"],
                            scan["feature_list"],
                            scan["scan_type"],
                            scan["scan_feature_list"],
                            "" , add_scores = True, include_conditional_var_base_rates = True)
    final_r = {**results , **stats}
    
    final_r["combo"] = scan["combo"]
    final_r["event"] = scan["event"]
    final_r["conditional_variable"] = scan["conditional_variable"]
    #run_info["fsscan_params"] = fsscan_configs["fsscan_params"]
    final_r["direction"] = scan["direction"]
    final_r["feature_list"] = scan["feature_list"]
    final_r["scan_type"] = scan["scan_type"] 
    final_r["scan_feature_list"] = scan["scan_feature_list"]
    final_r["threshold_probability"] = scan["threshold_probability"]
    final_r["threshold_cutoff"] = scan["threshold_cutoff"]
            
            
    final_r["best_subset"]  = results["best_subset"] 
    final_r["best_score"] = results["best_score"]
    final_r["best_param"] =  results["best_param"]

    final_r["cbs_param"] = results["best_param"]
    final_r["cbs_score"] = results["best_score"]
    final_r["protected_class"] = scan["protected_class"]
    final_r["protected_value"] = scan["protected_value"]
    final_r["p_hat_coefficient_mapping"] = results["p_hat_coefficient_mapping"]
    pd.DataFrame([final_r]).to_csv("results/_"+str(i)+".csv")
    i = i +1

