import yaml
import sys

class YamlFunctions:
    
    def __init__(self, fss_yaml_file_path):
        self.fss_yaml_file_path =  fss_yaml_file_path
    
    def produce_scans(self, data, key = None, key_value= None):
        
        # checking for proper inputs and configs
        #if self.fss_configs["cbs_params"]["cartesian_run"] == False and ((isinstance(key, type(None)) == True) or (isinstance(key_value, type(None)) == True)):
         #       message = "You need to pass in a key (protected class category) and key value (protected class value) for a non-cartesian run of CBS which evaluates all key-values as protected class"
          #      sys.exit(message)
        
            
        
        scan_types = self.fss_configs["cbs_params"]["scan_type_list"]
        scans = []
        for scan_type in scan_types:
            for combo_param in self.fss_configs["cbs_params"][scan_type]["combo_scan_list"]:
                if self.fss_configs["cbs_params"]["cartesian_run"] == True:
                    feature_list = self.fss_configs["cbs_params"][scan_type]["feature_list"]
                else:
                    if isinstance(key, type(None)):
                        feature_list = self.fss_configs["cbs_params"][scan_type]["protected_class_keys"]
                    else:
                        feature_list = [key]
                for feature in feature_list:
                    for direction in self.fss_configs["cbs_params"][scan_type]["direction"]:
                        if self.fss_configs["cbs_params"]["cartesian_run"] == True:
                            unique_feature_value_list = data[feature].unique()
                        else:
                            if isinstance(key_value, type(None)):
                                unique_feature_value_list = data[feature].unique()
                            else:
                                unique_feature_value_list = [key_value]
                        for unique_feature_value in unique_feature_value_list:
                            d = {}
                            d["scan_type"] = scan_type
                            d["combo"] = combo_param
                            d["protected_class"] = feature
                            d["protected_value"] = unique_feature_value
                            d["event"] = self.fss_configs["cbs_params"][scan_type]["event"]
                            # specifically here for the case of univariate binary sufficiency scans
                            if "conditional_variable" in self.fss_configs["cbs_params"][scan_type]:
                                d["conditional_variable"] = self.fss_configs["cbs_params"][scan_type]["conditional_variable"]
                            d["feature_list"] = self.fss_configs["cbs_params"][scan_type]["feature_list"]
                            d["scan_feature_list"] = self.fss_configs["cbs_params"][scan_type]["scan_feature_list"]
                            d["direction"] = direction
                            d["threshold_probability"] = self.fss_configs["cbs_params"][scan_type]["threshold_info"]["threshold_predictions"]
                            if d["threshold_probability"] == True:
                                d["threshold_cutoff"] = self.fss_configs["cbs_params"][scan_type]["threshold_info"]["threshold_value"]
                            else:
                                d["threshold_cutoff"] = None
                            scans.append(d)
        return scans
    
    def run(self):
        #1. read in yaml
        
        with open(self.fss_yaml_file_path , 'r') as file:
            self.fss_configs = yaml.safe_load(file)
        
        return self.fss_configs
        