hh_constants = [
  {
    "attribute_desc": "uses a direct questioning approach.",
    "attr_min": "uses an indirect or vague questioning approach",
    "attr_max": "uses a highly direct and clear questioning approach"
  },
  {
    "attribute_desc": "lacks technical details about fire ignition methods.",
    "attr_min": "provides comprehensive technical details about fire ignition methods",
    "attr_max": "completely lacks technical details about fire ignition methods"
  },
  {
    "attribute_desc": "implies a misunderstanding.",
    "attr_min": "clearly conveys understanding",
    "attr_max": "strongly implies a misunderstanding"
  },
  {
    "attribute_desc": "uses a direct and personal address.",
    "attr_min": "uses an indirect and impersonal address",
    "attr_max": "uses a highly direct and personal address"
  },
  {
    "attribute_desc": "employs direct speech with quotation marks.",
    "attr_min": "lacks direct speech and quotation marks",
    "attr_max": "effectively employs direct speech with clear quotation marks"
  },
  {
    "attribute_desc": "conveys a sense of continuity and ongoing activity.",
    "attr_min": "feels disjointed and static",
    "attr_max": "seamlessly flows with dynamic progression"
  },
  {
    "attribute_desc": "lacks specific details or context.",
    "attr_min": "provides comprehensive details and context",
    "attr_max": "completely lacks specific details or context"
  },
  {
    "attribute_desc": "lacks the phrase 'or severely impaired in some way.'",
    "attr_min": "includes the phrase 'or severely impaired in some way' appropriately",
    "attr_max": "completely lacks the phrase 'or severely impaired in some way'"
  },
  {
    "attribute_desc": "includes personal feelings and experiences.",
    "attr_min": "excludes personal feelings and experiences",
    "attr_max": "richly includes personal feelings and experiences"
  },
  {
    "attribute_desc": "uses direct messaging without elaboration.",
    "attr_min": "uses detailed and elaborative messaging",
    "attr_max": "uses extremely brief and direct messaging without any elaboration"
  },
  {
    "attribute_desc": "uses repetition for emphasis.",
    "attr_min": "avoids repetition, leading to a lack of emphasis",
    "attr_max": "excessively uses repetition, causing redundancy"
  },
  {
    "attribute_desc": "emphasizes user feedback and dialogue.",
    "attr_min": "ignores user feedback and lacks dialogue",
    "attr_max": "actively incorporates user feedback and maintains engaging dialogue"
  },
  {
    "attribute_desc": "includes both human and technological elements.",
    "attr_min": "lacks integration of human and technological elements",
    "attr_max": "seamlessly integrates both human and technological elements"
  },
  {
    "attribute_desc": "uses informal language with 'you\u2019re' contraction.",
    "attr_min": "uses formal language without contractions",
    "attr_max": "frequently uses informal language with 'you\u2019re' contraction"
  },
  {
    "attribute_desc": "uses a first-person perspective.",
    "attr_min": "uses a third-person perspective",
    "attr_max": "consistently uses a first-person perspective throughout"
  },
  {
    "attribute_desc": "lacks mention of additional communication systems.",
    "attr_min": "includes comprehensive details on additional communication systems",
    "attr_max": "completely omits any mention of additional communication systems"
  },
  {
    "attribute_desc": "includes a direct address to the reader.",
    "attr_min": "lacks any direct address to the reader",
    "attr_max": "frequently and effectively addresses the reader directly"
  },
  {
    "attribute_desc": "lacks detailed comparisons to other building collapses.",
    "attr_min": "provides comprehensive comparisons to other building collapses",
    "attr_max": "completely lacks detailed comparisons to other building collapses"
  },
  {
    "attribute_desc": "includes educational content.",
    "attr_min": "lacks educational content",
    "attr_max": "richly filled with educational content"
  },
  {
    "attribute_desc": "uses parallel structure for clarity.",
    "attr_min": "lacks parallel structure, causing confusion",
    "attr_max": "consistently uses parallel structure for maximum clarity"
  },
  {
    "attribute_desc": "includes direct references to external resources.",
    "attr_min": "lacks any references to external resources",
    "attr_max": "includes numerous and relevant direct references to external resources"
  },
  {
    "attribute_desc": "uses a colon to introduce content.",
    "attr_min": "does not use a colon to introduce content",
    "attr_max": "effectively uses a colon to introduce content"
  },
  {
    "attribute_desc": "provides detailed explanations and examples.",
    "attr_min": "provides vague explanations with no examples",
    "attr_max": "provides comprehensive explanations with numerous relevant examples"
  },
  {
    "attribute_desc": "uses fewer descriptive adjectives.",
    "attr_min": "uses many descriptive adjectives",
    "attr_max": "uses very few descriptive adjectives"
  },
  {
    "attribute_desc": "uses more direct dialogue and exclamations.",
    "attr_min": "uses indirect dialogue and lacks exclamations",
    "attr_max": "uses very direct dialogue and frequent exclamations"
  },
  {
    "attribute_desc": "conveys a polite acknowledgment.",
    "attr_min": "lacks acknowledgment or is impolite",
    "attr_max": "exhibits exceptionally polite acknowledgment"
  },
  {
    "attribute_desc": "includes a hypothetical scenario.",
    "attr_min": "lacks any hypothetical scenario",
    "attr_max": "includes a detailed and engaging hypothetical scenario"
  },
  {
    "attribute_desc": "ends abruptly, suggesting an incomplete thought.",
    "attr_min": "ends smoothly and with a complete thought",
    "attr_max": "ends very abruptly, leaving the thought incomplete"
  },
  {
    "attribute_desc": "lacks detailed descriptions of olive oil benefits.",
    "attr_min": "provides comprehensive and detailed descriptions of olive oil benefits",
    "attr_max": "completely lacks any descriptions of olive oil benefits"
  },
  {
    "attribute_desc": "is longer and more comprehensive.",
    "attr_min": "is brief and lacks detail",
    "attr_max": "is extremely lengthy and overly detailed"
  },
  {
    "attribute_desc": "uses a direct refusal.",
    "attr_min": "uses an indirect or polite refusal",
    "attr_max": "uses a very blunt or harsh refusal"
  },
  {
    "attribute_desc": "focuses on human behavior and nationality.",
    "attr_min": "ignores human behavior and nationality",
    "attr_max": "deeply analyzes human behavior and nationality"
  },
  {
    "attribute_desc": "implies a quantitative evaluation method.",
    "attr_min": "lacks any quantitative evaluation method",
    "attr_max": "utilizes a comprehensive and precise quantitative evaluation method"
  },
  {
    "attribute_desc": "uses future tense.",
    "attr_min": "uses past or present tense",
    "attr_max": "consistently uses future tense"
  },
  {
    "attribute_desc": "implies uncertainty with 'I think'.",
    "attr_min": "states information with certainty and confidence",
    "attr_max": "frequently uses 'I think' to express uncertainty"
  },
  {
    "attribute_desc": "suggests a specific product.",
    "attr_min": "does not suggest any specific product",
    "attr_max": "clearly and accurately suggests a specific product"
  },
  {
    "attribute_desc": "is longer and more detailed.",
    "attr_min": "is brief and lacks detail",
    "attr_max": "is extremely long and overly detailed"
  },
  {
    "attribute_desc": "introduces a meta-commentary about communication.",
    "attr_min": "lacks any meta-commentary about communication",
    "attr_max": "provides insightful and extensive meta-commentary about communication"
  },
  {
    "attribute_desc": "includes a request for clarification.",
    "attr_min": "provides clear and comprehensive information without needing clarification",
    "attr_max": "frequently requests clarification, indicating uncertainty or lack of understanding"
  },
  {
    "attribute_desc": "lacks specific subject matter references.",
    "attr_min": "contains detailed and specific subject matter references",
    "attr_max": "completely lacks any subject matter references"
  },
  {
    "attribute_desc": "uses conditional language to offer flexible guidance.",
    "attr_min": "uses rigid language with no flexibility",
    "attr_max": "uses highly adaptive and flexible language"
  },
  {
    "attribute_desc": "uses conditional language for hypothetical scenarios.",
    "attr_min": "does not use conditional language for hypothetical scenarios",
    "attr_max": "consistently uses precise conditional language for all hypothetical scenarios"
  },
  {
    "attribute_desc": "focuses on texture and material properties.",
    "attr_min": "ignores texture and material properties",
    "attr_max": "provides detailed and insightful analysis of texture and material properties"
  },
  {
    "attribute_desc": "includes a clear offer of additional services.",
    "attr_min": "lacks any mention of additional services",
    "attr_max": "provides a detailed and enticing offer of additional services"
  },
  {
    "attribute_desc": "uses a cause-and-effect structure.",
    "attr_min": "lacks clear cause-and-effect relationships",
    "attr_max": "demonstrates a clear and logical cause-and-effect structure"
  },
  {
    "attribute_desc": "includes a comparison of motivations.",
    "attr_min": "lacks any comparison of motivations",
    "attr_max": "provides a thorough and insightful comparison of motivations"
  },
  {
    "attribute_desc": "is structured with clear, distinct sections.",
    "attr_min": "is disorganized with no clear sections",
    "attr_max": "is highly organized with very clear and distinct sections"
  },
  {
    "attribute_desc": "includes a detailed description of components.",
    "attr_min": "lacks detail in the description of components",
    "attr_max": "provides an extremely detailed and comprehensive description of components"
  },
  {
    "attribute_desc": "includes a specific cultural reference.",
    "attr_min": "lacks any cultural reference",
    "attr_max": "richly incorporates a specific cultural reference"
  },
  {
    "attribute_desc": "uses a specific company reference.",
    "attr_min": "does not use any company reference",
    "attr_max": "uses a highly specific and relevant company reference"
  }
]


shp_constants = [
  {
    "attribute_desc": "implies indirect messaging through brevity.",
    "attr_min": "implies direct messaging with clarity",
    "attr_max": "implies very indirect messaging through extreme brevity"
  },
  {
    "attribute_desc": "implies a personal experience or context.",
    "attr_min": "lacks any personal experience or context",
    "attr_max": "strongly implies a personal experience or context"
  },
  {
    "attribute_desc": "provides minimal detail and context.",
    "attr_min": "provides comprehensive detail and context",
    "attr_max": "provides extremely minimal detail and context"
  },
  {
    "attribute_desc": "ends with a non-alphabetic character.",
    "attr_min": "ends with an alphabetic character",
    "attr_max": "ends with a highly non-alphabetic character"
  },
  {
    "attribute_desc": "lacks a question mark in the title.",
    "attr_min": "includes a question mark in the title when appropriate",
    "attr_max": "consistently lacks a question mark in the title when needed"
  },
  {
    "attribute_desc": "implies an external resource or reference.",
    "attr_min": "does not imply any external resource or reference",
    "attr_max": "strongly implies an external resource or reference"
  },
  {
    "attribute_desc": "includes a hypothetical scenario.",
    "attr_min": "lacks any hypothetical scenario",
    "attr_max": "includes a detailed and engaging hypothetical scenario"
  },
  {
    "attribute_desc": "employs a more direct messaging style.",
    "attr_min": "employs an indirect and vague messaging style",
    "attr_max": "employs an extremely direct and clear messaging style"
  },
  {
    "attribute_desc": "has a more inquisitive tone.",
    "attr_min": "has a flat or disinterested tone",
    "attr_max": "has an extremely inquisitive and engaging tone"
  },
  {
    "attribute_desc": "is longer and more detailed.",
    "attr_min": "is brief and lacks detail",
    "attr_max": "is extremely long and highly detailed"
  },
  {
    "attribute_desc": "employs a playful and whimsical tone.",
    "attr_min": "employs a serious and formal tone",
    "attr_max": "employs an extremely playful and whimsical tone"
  },
  {
    "attribute_desc": "includes a specific online community reference.",
    "attr_min": "lacks any reference to an online community",
    "attr_max": "includes a highly relevant and specific online community reference"
  },
  {
    "attribute_desc": "includes a direct request for information.",
    "attr_min": "lacks any request for information",
    "attr_max": "clearly and explicitly requests specific information"
  },
  {
    "attribute_desc": "includes specific examples and scenarios.",
    "attr_min": "lacks examples and scenarios",
    "attr_max": "richly includes specific examples and scenarios"
  },
  {
    "attribute_desc": "presents a conditional scenario for clarity.",
    "attr_min": "presents an unclear or confusing scenario",
    "attr_max": "presents a highly clear and well-defined conditional scenario"
  },
  {
    "attribute_desc": "contains direct personal advice and opinions.",
    "attr_min": "lacks personal advice and opinions",
    "attr_max": "rich in direct personal advice and opinions"
  },
  {
    "attribute_desc": "employs indirect messaging.",
    "attr_min": "employs direct and clear messaging",
    "attr_max": "employs highly indirect and ambiguous messaging"
  },
  {
    "attribute_desc": "contains a direct financial reference.",
    "attr_min": "lacks any financial reference",
    "attr_max": "contains explicit and detailed financial references"
  },
  {
    "attribute_desc": "uses ellipsis for dramatic pause.",
    "attr_min": "avoids using ellipsis, resulting in a flat delivery",
    "attr_max": "effectively uses ellipsis to create a strong dramatic pause"
  },
  {
    "attribute_desc": "uses a specific geographical reference.",
    "attr_min": "lacks any geographical reference",
    "attr_max": "uses highly specific and accurate geographical references"
  },
  {
    "attribute_desc": "includes an admission of incomplete knowledge.",
    "attr_min": "claims complete knowledge without admitting gaps",
    "attr_max": "openly acknowledges limitations and gaps in knowledge"
  },
  {
    "attribute_desc": "uses a definitive negative tone.",
    "attr_min": "uses a neutral or positive tone",
    "attr_max": "uses an extremely negative and harsh tone"
  },
  {
    "attribute_desc": "lacks descriptive imagery or sensory details.",
    "attr_min": "rich in descriptive imagery and sensory details",
    "attr_max": "completely lacks descriptive imagery or sensory details"
  },
  {
    "attribute_desc": "employs a conversational tone for relatability.",
    "attr_min": "uses a formal tone, making it less relatable",
    "attr_max": "employs an extremely conversational tone, enhancing relatability"
  },
  {
    "attribute_desc": "lacks descriptive imagery.",
    "attr_min": "rich in vivid and detailed imagery",
    "attr_max": "completely devoid of descriptive imagery"
  },
  {
    "attribute_desc": "includes punctuation marks.",
    "attr_min": "lacks punctuation marks entirely",
    "attr_max": "uses punctuation marks effectively and appropriately"
  },
  {
    "attribute_desc": "lacks phonetic guidance.",
    "attr_min": "provides clear phonetic guidance",
    "attr_max": "completely lacks phonetic guidance"
  },
  {
    "attribute_desc": "lacks descriptive adjectives and adverbs.",
    "attr_min": "rich in descriptive adjectives and adverbs",
    "attr_max": "completely lacks descriptive adjectives and adverbs"
  },
  {
    "attribute_desc": "uses a more dismissive tone.",
    "attr_min": "uses a respectful and engaging tone",
    "attr_max": "uses an extremely dismissive tone"
  },
  {
    "attribute_desc": "uses a positive, self-rewarding approach.",
    "attr_min": "uses a negative, self-punishing approach",
    "attr_max": "uses an extremely positive, self-rewarding approach"
  },
  {
    "attribute_desc": "contains spelling errors.",
    "attr_min": "contains no spelling errors",
    "attr_max": "contains numerous spelling errors"
  },
  {
    "attribute_desc": "offers a broader perspective on job treatment.",
    "attr_min": "offers a narrow perspective on job treatment",
    "attr_max": "offers an exceptionally broad and comprehensive perspective on job treatment"
  },
  {
    "attribute_desc": "conveys surprise or unexpectedness.",
    "attr_min": "predictable and expected",
    "attr_max": "highly surprising and unexpected"
  },
  {
    "attribute_desc": "includes a direct personal opinion on usage.",
    "attr_min": "lacks any personal opinion on usage",
    "attr_max": "strongly includes a direct personal opinion on usage"
  },
  {
    "attribute_desc": "hints at a nostalgic cultural reference.",
    "attr_min": "lacks any cultural reference or nostalgia",
    "attr_max": "evokes strong nostalgia with clear cultural references"
  },
  {
    "attribute_desc": "implies a deeper understanding of mechanical operations.",
    "attr_min": "lacks understanding of mechanical operations",
    "attr_max": "demonstrates profound understanding of mechanical operations"
  },
  {
    "attribute_desc": "focuses on personal convenience and flexibility.",
    "attr_min": "inconvenient and inflexible",
    "attr_max": "highly convenient and extremely flexible"
  },
  {
    "attribute_desc": "highlights community support and collegiality.",
    "attr_min": "lacks community support and collegiality",
    "attr_max": "strongly emphasizes community support and collegiality"
  },
  {
    "attribute_desc": "conveys excitement with exclamation.",
    "attr_min": "conveys excitement without any exclamation",
    "attr_max": "conveys extreme excitement with multiple exclamations"
  },
  {
    "attribute_desc": "incorporates personal dining rituals and preferences.",
    "attr_min": "ignores personal dining rituals and preferences",
    "attr_max": "fully incorporates personal dining rituals and preferences"
  },
  {
    "attribute_desc": "provides more vivid imagery of baking issues.",
    "attr_min": "provides vague or unclear imagery of baking issues",
    "attr_max": "provides extremely vivid and detailed imagery of baking issues"
  },
  {
    "attribute_desc": "includes broader universe context.",
    "attr_min": "lacks broader universe context",
    "attr_max": "fully integrates broader universe context"
  },
  {
    "attribute_desc": "highlights thinkers' willingness to embrace pessimism.",
    "attr_min": "ignores or dismisses pessimism",
    "attr_max": "fully embraces and explores pessimism"
  },
  {
    "attribute_desc": "focuses on positive aspects with minimal detail.",
    "attr_min": "focuses on negative aspects with excessive detail",
    "attr_max": "focuses exclusively on positive aspects with minimal detail"
  },
  {
    "attribute_desc": "includes specific age-related considerations.",
    "attr_min": "lacks any age-related considerations",
    "attr_max": "thoroughly includes specific age-related considerations"
  },
  {
    "attribute_desc": "discusses broader organizational dynamics and implications.",
    "attr_min": "ignores organizational dynamics and implications",
    "attr_max": "thoroughly analyzes and explains broader organizational dynamics and implications"
  },
  {
    "attribute_desc": "implies flexibility with 'likely' and 'probably'.",
    "attr_min": "implies certainty without using 'likely' or 'probably'",
    "attr_max": "heavily relies on 'likely' and 'probably' to imply flexibility"
  },
  {
    "attribute_desc": "uses repetitive phrases for emphasis.",
    "attr_min": "avoids repetition, lacks emphasis",
    "attr_max": "overuses repetitive phrases, overly emphatic"
  },
  {
    "attribute_desc": "conveys a more pessimistic emotional impact.",
    "attr_min": "conveys an optimistic or neutral emotional impact",
    "attr_max": "conveys an extremely pessimistic emotional impact"
  },
  {
    "attribute_desc": "focuses on scientific complexity and observational challenges.",
    "attr_min": "oversimplifies scientific concepts and ignores observational challenges",
    "attr_max": "deeply explores scientific complexity and thoroughly addresses observational challenges"
  }
]

cpm_constants = [
    {
        'attribute_desc': "is helpful for the original poster",
        'attr_min': "not helpful",
        'attr_max': "very helpful",
    },
    {
        'attribute_desc': "is specific enough",
        'attr_min': "too vague",
        'attr_max': "very specific",
    },
    {
        'attribute_desc': "understands the original poster's intent",
        'attr_min': "failure of understanding",
        'attr_max': "perfect understanding",
    },
    {
        'attribute_desc': "is factually correct",
        'attr_min': "egregiously incorrect",
        'attr_max': "fully correct",
    },
    {
        'attribute_desc': "is easy to understand",
        'attr_min': "very difficult to understand",
        'attr_max': "very easy to understand",
    },
    {
        'attribute_desc': "is relevant to the original poster's question",
        'attr_min': "off-topic",
        'attr_max': "very relevant",
    },
    {
        'attribute_desc': "is easy to read and not too technical for the original poster",
        'attr_min': "very difficult to read",
        'attr_max': "very easy to read",
    },
    {
        'attribute_desc': "provides enough detail to be helpful",
        'attr_min': "too little detail",
        'attr_max': "very detailed",
    },
    {
        'attribute_desc': "is biased or one-sided",
        'attr_min': "very biased",
        'attr_max': "not biased at all",
    },
    {
        'attribute_desc': "fails to consider the original poster's cultural or individual preferences",
        'attr_min': "takes into account the original poster's preferences",
        'attr_max': "fails to consider the original poster's preferences",
    },
    {
        'attribute_desc': "is repetitive",
        'attr_min': "very repetitive",
        'attr_max': "not repetitive",
    },
    {
        'attribute_desc': "fails to consider the original poster's context",
        'attr_min': "fails to consider the original poster's context",
        'attr_max': "takes into account the original poster's context",
    },
    {
        'attribute_desc': "is too long",
        'attr_min': "too long",
        'attr_max': "not too long",
    }
]

SHP_TEMPLATE = """You will be given a Reddit post and a reply. Your job is to evaluate how well the assistant's reply demonstrates specific attributes. For each attribute, score it on a scale from 1 to 10.

POST:
{history}

Reply:
{reply}

Please score each attribute on a scale from 1 to 10:
{attributes}

For each attribute above, provide a score from 1-10 on a new line, one by one, with no additional text.
Your response should contain exactly {num_attributes} numbers, one per line.

Answer:"""

HH_TEMPLATE = """You will be given a conversation between a human and an AI assistant. Your job is to evaluate how well the assistant's reply demonstrates specific attributes. For each attribute, score it on a scale from 1 to 10.

H:
{history}

A:
{reply}

Please score each attribute on a scale from 1 to 10:
{attributes}

For each attribute above, provide a score from 1-10 on a new line, one by one, with no additional text.
Your response should contain exactly {num_attributes} numbers, one per line.

Answer:"""