# Need the following packages
#install.packages("CVXR")
#install.packages("MASS")
#install.packages("huge")
#install.packages("matrixcalc")
#install.packages("ggplot2")
#install.packages("cowplot")

library(CVXR)
library(MASS)
library(huge)
library(matrixcalc)
library(ggplot2)
library(cowplot)

#########################################################################
###################### 4 classes #########################
#############################################################################
######### 0.2 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-4
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# Use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.2*(p^(0.5))*mumator
mumat02<-mumat


probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat02<-matrix(0,numsim,nlen)
numlabinterpmat02<-matrix(0,numsim,nlen)



time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat02[k,m]<-numnoninterp
    numlabinterpmat02[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#############################################################################
############## 0.3 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-4
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.3*(p^(0.5))*mumator
mumat03<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat03<-matrix(0,numsim,nlen)
numlabinterpmat03<-matrix(0,numsim,nlen)



time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat

    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat03[k,m]<-numnoninterp
    numlabinterpmat03[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01



#######################################################################
################ 0.4 ################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-4
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.4*(p^(0.5))*mumator
mumat04<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat04<-matrix(0,numsim,nlen)
numlabinterpmat04<-matrix(0,numsim,nlen)



time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat04[k,m]<-numnoninterp
    numlabinterpmat04[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#remove(probl)
#remove(constraint)
#remove(obj)
#rm(result)
#remove(dat00)
#remove(datmat00)



####################################################
###########################################################################################
###################### 3 classes ##########################

#############################################################################
######### 0.2 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-3
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.2*(p^(0.5))*mumator
mumat02b<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat02b<-matrix(0,numsim,nlen)
numlabinterpmat02b<-matrix(0,numsim,nlen)

time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat02b[k,m]<-numnoninterp
    numlabinterpmat02b[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#############################################################################
############## 0.3 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-3
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.3*(p^(0.5))*mumator
mumat03b<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat03b<-matrix(0,numsim,nlen)
numlabinterpmat03b<-matrix(0,numsim,nlen)

time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat03b[k,m]<-numnoninterp
    numlabinterpmat03b[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01



#######################################################################
################ 0.4 ################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-3
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.4*(p^(0.5))*mumator
mumat04b<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat04b<-matrix(0,numsim,nlen)
numlabinterpmat04b<-matrix(0,numsim,nlen)



time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat04b[k,m]<-numnoninterp
    numlabinterpmat04b[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#remove(probl)
#remove(constraint)
#remove(obj)
#rm(result)
#remove(dat00)
#remove(datmat00)






####################################################
###########################################################################################
###################### 6 classes ##########################
#############################################################################
######### 0.2 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.2*(p^(0.5))*mumator
mumat02d<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat02d<-matrix(0,numsim,nlen)
numlabinterpmat02d<-matrix(0,numsim,nlen)

time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmat[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmat[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmat[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat02d[k,m]<-numnoninterp
    numlabinterpmat02d[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#############################################################################
############## 0.3 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.3*(p^(0.5))*mumator
mumat03d<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat03d<-matrix(0,numsim,nlen)
numlabinterpmat03d<-matrix(0,numsim,nlen)


time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat03d[k,m]<-numnoninterp
    numlabinterpmat03d[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01



#######################################################################
################ 0.4 ################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.4*(p^(0.5))*mumator
mumat04d<-mumat
#mumat[,2]<-10*mumat[,1]

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat04d<-matrix(0,numsim,nlen)
numlabinterpmat04d<-matrix(0,numsim,nlen)


time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat04d[k,m]<-numnoninterp
    numlabinterpmat04d[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#remove(probl)
#remove(constraint)
#remove(obj)
#rm(result)
#remove(dat00)
#remove(datmat00)
#remove(eig00)









####################################################
###########################################################################################
###################### 7 classes ##########################
#############################################################################
######### 0.2 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-7
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.2*(p^(0.5))*mumator
mumat02e<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat02e<-matrix(0,numsim,nlen)
numlabinterpmat02e<-matrix(0,numsim,nlen)


time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmat[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmat[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmat[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat02e[k,m]<-numnoninterp
    numlabinterpmat02e[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#############################################################################
############## 0.3 ##################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-7
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.3*(p^(0.5))*mumator
mumat03e<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat03e<-matrix(0,numsim,nlen)
numlabinterpmat03e<-matrix(0,numsim,nlen)


time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat

    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat03e[k,m]<-numnoninterp
    numlabinterpmat03e[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01



#######################################################################
################ 0.4 ################
p<-1000
nvec<-c(10,20,30,40,55,70,85,100)
nlen<-length(nvec)
numcla<-7
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

# I use eigenvectors of a covariance matrix as the mean vectors
# huge.generator is to create a covariance matrix
set.seed(22222)
dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                        g = NULL, prob = NULL, vis = F, verbose = TRUE)
datmat00<-dat00$sigma
eig00<-eigen(datmat00)
mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
mumat<-0.4*(p^(0.5))*mumator
mumat04e<-mumat

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

# To create the covariance matrix (diagonal here)
lbdvec<-rep(1,p) # Diagonal elements
covmat<-diag(lbdvec)

numsim<-100  # number of simulations

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numnoninterpmat04e<-matrix(0,numsim,nlen)
numlabinterpmat04e<-matrix(0,numsim,nlen)



time01<-Sys.time()
for(m in 1:nlen){
  n<-nvec[m]
  onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmat04e[k,m]<-numnoninterp
    numlabinterpmat04e[k,m]<-numlabinterp
  }
}

time02<-Sys.time()
time02-time01


#remove(probl)
#remove(constraint)
#remove(obj)
#rm(result)
#remove(dat00)
#remove(datmat00)
#remove(eig00)








##################################################################################
####################### Figures ###################
################# 4 class ################
numcla<-4
numnoninterpsum<-matrix(0,3,nlen)
numlabinterpsum<-matrix(0,3,nlen)

for (j in 1:nlen) {
  numnoninterpsum[1,j]<-mean(numnoninterpmat02[,j])
}
for (j in 1:nlen) {
  numnoninterpsum[2,j]<-mean(numnoninterpmat03[,j])
}
for (j in 1:nlen) {
  numnoninterpsum[3,j]<-mean(numnoninterpmat04[,j])
}
numnoninterpsum


for (j in 1:nlen) {
  numlabinterpsum[1,j]<-mean(numlabinterpmat02[,j])
}
for (j in 1:nlen) {
  numlabinterpsum[2,j]<-mean(numlabinterpmat03[,j])
}
for (j in 1:nlen) {
  numlabinterpsum[3,j]<-mean(numlabinterpmat04[,j])
}
numlabinterpsum

numnoninterpprop<-matrix(0,3,nlen)
numlabinterpprop<-matrix(0,3,nlen)


for (j in 1:nlen) {
  numnoninterpprop[,j]<-numnoninterpsum[,j]/(nvec[j]*(numcla-1))
}

for (j in 1:nlen) {
  numlabinterpprop[,j]<-numlabinterpsum[,j]/(nvec[j]*(numcla-1))
}
numnoninterpprop
numlabinterpprop


mulen02<-sqrt(sum(mumat02[,1]^2))
mulen03<-sqrt(sum(mumat03[,1]^2))
mulen04<-sqrt(sum(mumat04[,1]^2))

rescnvec<-(numcla^1.5)*(nvec^1.5)/1000


propnonintermat02<-matrix(0,numsim,nlen)
propnonintermat03<-matrix(0,numsim,nlen)
propnonintermat04<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  propnonintermat02[,j]<-numnoninterpmat02[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat03[,j]<-numnoninterpmat03[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat04[,j]<-numnoninterpmat04[,j]/(nvec[j]*(numcla-1))
}


proplabintermat02<-matrix(0,numsim,nlen)
proplabintermat03<-matrix(0,numsim,nlen)
proplabintermat04<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  proplabintermat02[,j]<-numlabinterpmat02[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat03[,j]<-numlabinterpmat03[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat04[,j]<-numlabinterpmat04[,j]/(nvec[j]*(numcla-1))
}

sdnonintermat<-matrix(0,3,nlen)
sdnonintermat[1,]<-apply(propnonintermat02, 2, sd)
sdnonintermat[2,]<-apply(propnonintermat03, 2, sd)
sdnonintermat[3,]<-apply(propnonintermat04, 2, sd)

sdlabintermat<-matrix(0,3,nlen)
sdlabintermat[1,]<-apply(proplabintermat02, 2, sd)
sdlabintermat[2,]<-apply(proplabintermat03, 2, sd)
sdlabintermat[3,]<-apply(proplabintermat04, 2, sd)



################# 7 class ################
numcla<-7
numnoninterpsume<-matrix(0,3,nlen)
numlabinterpsume<-matrix(0,3,nlen)

for (j in 1:nlen) {
  numnoninterpsume[1,j]<-mean(numnoninterpmat02e[,j])
}
for (j in 1:nlen) {
  numnoninterpsume[2,j]<-mean(numnoninterpmat03e[,j])
}
for (j in 1:nlen) {
  numnoninterpsume[3,j]<-mean(numnoninterpmat04e[,j])
}
numnoninterpsume


for (j in 1:nlen) {
  numlabinterpsume[1,j]<-mean(numlabinterpmat02e[,j])
}
for (j in 1:nlen) {
  numlabinterpsume[2,j]<-mean(numlabinterpmat03e[,j])
}
for (j in 1:nlen) {
  numlabinterpsume[3,j]<-mean(numlabinterpmat04e[,j])
}
numlabinterpsume

numnoninterpprope<-matrix(0,3,nlen)
numlabinterpprope<-matrix(0,3,nlen)


for (j in 1:nlen) {
  numnoninterpprope[,j]<-numnoninterpsume[,j]/(nvec[j]*(numcla-1))
}

for (j in 1:nlen) {
  numlabinterpprope[,j]<-numlabinterpsume[,j]/(nvec[j]*(numcla-1))
}
numnoninterpprope
numlabinterpprope

mulen02e<-sqrt(sum(mumat02e[,1]^2))
mulen03e<-sqrt(sum(mumat03e[,1]^2))
mulen04e<-sqrt(sum(mumat04e[,1]^2))

rescnvece<-(numcla^1.5)*(nvec^1.5)/1000


#mulen02e

propnonintermat02e<-matrix(0,numsim,nlen)
propnonintermat03e<-matrix(0,numsim,nlen)
propnonintermat04e<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  propnonintermat02e[,j]<-numnoninterpmat02e[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat03e[,j]<-numnoninterpmat03e[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat04e[,j]<-numnoninterpmat04e[,j]/(nvec[j]*(numcla-1))
}


proplabintermat02e<-matrix(0,numsim,nlen)
proplabintermat03e<-matrix(0,numsim,nlen)
proplabintermat04e<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  proplabintermat02e[,j]<-numlabinterpmat02e[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat03e[,j]<-numlabinterpmat03e[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat04e[,j]<-numlabinterpmat04e[,j]/(nvec[j]*(numcla-1))
}

sdnonintermate<-matrix(0,3,nlen)
sdnonintermate[1,]<-apply(propnonintermat02e, 2, sd)
sdnonintermate[2,]<-apply(propnonintermat03e, 2, sd)
sdnonintermate[3,]<-apply(propnonintermat04e, 2, sd)

sdlabintermate<-matrix(0,3,nlen)
sdlabintermate[1,]<-apply(proplabintermat02e, 2, sd)
sdlabintermate[2,]<-apply(proplabintermat03e, 2, sd)
sdlabintermate[3,]<-apply(proplabintermat04e, 2, sd)






length(nvec)
lab00<-c(rep("(4) 0.2",8),rep("(4) 0.3",8),rep("(4) 0.4",8),
         rep("(7) 0.2",8),rep("(7) 0.3",8),rep("(7) 0.4",8))
labcla00<-c(rep(" 4",24),rep(" 7",24))
data_int01<-data.frame(c(numlabinterpprop[1,],numlabinterpprop[2,],numlabinterpprop[3,],
                         numlabinterpprope[1,],numlabinterpprope[2,],numlabinterpprope[3,]),
                       c(nvec,nvec,nvec,nvec,nvec,nvec),lab00,labcla00,
                       c(sdlabintermat[1,],sdlabintermat[2,],sdlabintermat[3,],
                         sdlabintermate[1,],sdlabintermate[2,],sdlabintermate[3,]))
names(data_int01)<-c("interp","n","ratio","k","sd")
title=expression(paste("(k)"~mu))
plot_int01<-ggplot(data_int01, aes(x=n, y=interp,group=ratio)) + ylab("Fraction of support vectors") +
  geom_errorbar(aes(ymin=interp-sd,ymax=interp+sd),width=3)+
  geom_line(aes(linetype=k,color = ratio),size=1.5)+coord_cartesian(xlim = c(10, 100),ylim = c(0.1,1)) +geom_point(aes(color = ratio),size=3)+
  theme_minimal() +labs(color=title,linetype="k")+
  theme(axis.text = element_text(size = 12),axis.title = element_text(size = 21),legend.text = element_text(size = 17),legend.title = element_text(size = 21) )


lab00<-c(rep("(4) 0.2",8),rep("(4) 0.3",8),rep("(4) 0.4",8),
         rep("(7) 0.2",8),rep("(7) 0.3",8),rep("(7) 0.4",8))
labcla00<-c(rep(" 4",24),rep(" 7",24))
data_int02<-data.frame(c(numlabinterpprop[1,],numlabinterpprop[2,],numlabinterpprop[3,],
                         numlabinterpprope[1,],numlabinterpprope[2,],numlabinterpprope[3,]),
                       c(rescnvec*mulen02,rescnvec*mulen03,rescnvec*mulen04,
                         rescnvece*mulen02e,rescnvece*mulen03e,rescnvece*mulen04e),lab00,labcla00,
                       c(sdlabintermat[1,],sdlabintermat[2,],sdlabintermat[3,],
                         sdlabintermate[1,],sdlabintermate[2,],sdlabintermate[3,]))
names(data_int02)<-c("interp","n","ratio","k","sd")
plot_int02<-ggplot(data_int02, aes(x=n, y=interp, group=ratio)) + ylab("Fraction of support vectors") + xlab(expression(paste("("~k^1.5~n^1.5~"||"~mu~"||"~")/("~"p"~")")))+
  geom_line(aes(color = ratio,linetype=k),size=1.5)+coord_cartesian(xlim = c(0.05,150),ylim = c(0.1,1))+geom_point(aes(color = ratio),size=3)+
  theme_minimal() + 
  theme(axis.text = element_text(size = 12),axis.title = element_text(size = 21),legend.text = element_text(size = 17),legend.title = element_text(size = 21) )

legend_01<-get_legend(plot_int01+
                        theme(legend.key = element_rect(color = "black", linetype = "solid", size = 0.5),
                              legend.key.size = unit(0.3, "cm"), legend.key.height=unit(1.5,"line")) +
                        guides(colour = guide_legend(override.aes = list(size= 1)))+labs(title = title))

legend_01<-get_legend(plot_int01)



p_grid<-plot_grid(
  plot_int01+theme(legend.position="none"),
  plot_int02+theme(legend.position="none"),
  nrow=1)


plotg<-plot_grid(p_grid,legend_01,rel_widths = c(3, .4))

plotg




##################################################################################
################# 3 class ################
numcla<-3
numnoninterpsumb<-matrix(0,3,nlen)
numlabinterpsumb<-matrix(0,3,nlen)

for (j in 1:nlen) {
  numnoninterpsumb[1,j]<-mean(numnoninterpmat02b[,j])
}
for (j in 1:nlen) {
  numnoninterpsumb[2,j]<-mean(numnoninterpmat03b[,j])
}
for (j in 1:nlen) {
  numnoninterpsumb[3,j]<-mean(numnoninterpmat04b[,j])
}
numnoninterpsumb


for (j in 1:nlen) {
  numlabinterpsumb[1,j]<-mean(numlabinterpmat02b[,j])
}
for (j in 1:nlen) {
  numlabinterpsumb[2,j]<-mean(numlabinterpmat03b[,j])
}
for (j in 1:nlen) {
  numlabinterpsumb[3,j]<-mean(numlabinterpmat04b[,j])
}
numlabinterpsumb

numnoninterppropb<-matrix(0,3,nlen)
numlabinterppropb<-matrix(0,3,nlen)


for (j in 1:nlen) {
  numnoninterppropb[,j]<-numnoninterpsumb[,j]/(nvec[j]*(numcla-1))
}

for (j in 1:nlen) {
  numlabinterppropb[,j]<-numlabinterpsumb[,j]/(nvec[j]*(numcla-1))
}
numnoninterppropb
numlabinterppropb


mulen02b<-sqrt(sum(mumat02b[,1]^2))
mulen03b<-sqrt(sum(mumat03b[,1]^2))
mulen04b<-sqrt(sum(mumat04b[,1]^2))

rescnvecb<-(numcla^1.5)*(nvec^1.5)/1000


propnonintermat02b<-matrix(0,numsim,nlen)
propnonintermat03b<-matrix(0,numsim,nlen)
propnonintermat04b<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  propnonintermat02b[,j]<-numnoninterpmat02b[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat03b[,j]<-numnoninterpmat03b[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat04b[,j]<-numnoninterpmat04b[,j]/(nvec[j]*(numcla-1))
}


proplabintermat02b<-matrix(0,numsim,nlen)
proplabintermat03b<-matrix(0,numsim,nlen)
proplabintermat04b<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  proplabintermat02b[,j]<-numlabinterpmat02b[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat03b[,j]<-numlabinterpmat03b[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat04b[,j]<-numlabinterpmat04b[,j]/(nvec[j]*(numcla-1))
}

sdnonintermatb<-matrix(0,3,nlen)
sdnonintermatb[1,]<-apply(propnonintermat02b, 2, sd)
sdnonintermatb[2,]<-apply(propnonintermat03b, 2, sd)
sdnonintermatb[3,]<-apply(propnonintermat04b, 2, sd)

sdlabintermatb<-matrix(0,3,nlen)
sdlabintermatb[1,]<-apply(proplabintermat02b, 2, sd)
sdlabintermatb[2,]<-apply(proplabintermat03b, 2, sd)
sdlabintermatb[3,]<-apply(proplabintermat04b, 2, sd)



################# 6 class ################
numcla<-6
numnoninterpsumd<-matrix(0,3,nlen)
numlabinterpsumd<-matrix(0,3,nlen)

for (j in 1:nlen) {
  numnoninterpsumd[1,j]<-mean(numnoninterpmat02d[,j])
}
for (j in 1:nlen) {
  numnoninterpsumd[2,j]<-mean(numnoninterpmat03d[,j])
}
for (j in 1:nlen) {
  numnoninterpsumd[3,j]<-mean(numnoninterpmat04d[,j])
}
numnoninterpsumd


for (j in 1:nlen) {
  numlabinterpsumd[1,j]<-mean(numlabinterpmat02d[,j])
}
for (j in 1:nlen) {
  numlabinterpsumd[2,j]<-mean(numlabinterpmat03d[,j])
}
for (j in 1:nlen) {
  numlabinterpsumd[3,j]<-mean(numlabinterpmat04d[,j])
}
numlabinterpsumd

numnoninterppropd<-matrix(0,3,nlen)
numlabinterppropd<-matrix(0,3,nlen)


for (j in 1:nlen) {
  numnoninterppropd[,j]<-numnoninterpsumd[,j]/(nvec[j]*(numcla-1))
}

for (j in 1:nlen) {
  numlabinterppropd[,j]<-numlabinterpsumd[,j]/(nvec[j]*(numcla-1))
}
numnoninterppropd
numlabinterppropd

mulen02d<-sqrt(sum(mumat02d[,1]^2))
mulen03d<-sqrt(sum(mumat03d[,1]^2))
mulen04d<-sqrt(sum(mumat04d[,1]^2))

rescnvecd<-(numcla^1.5)*(nvec^1.5)/1000


propnonintermat02d<-matrix(0,numsim,nlen)
propnonintermat03d<-matrix(0,numsim,nlen)
propnonintermat04d<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  propnonintermat02d[,j]<-numnoninterpmat02d[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat03d[,j]<-numnoninterpmat03d[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  propnonintermat04d[,j]<-numnoninterpmat04d[,j]/(nvec[j]*(numcla-1))
}


proplabintermat02d<-matrix(0,numsim,nlen)
proplabintermat03d<-matrix(0,numsim,nlen)
proplabintermat04d<-matrix(0,numsim,nlen)
for(j in 1:nlen){
  proplabintermat02d[,j]<-numlabinterpmat02d[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat03d[,j]<-numlabinterpmat03d[,j]/(nvec[j]*(numcla-1))
}
for(j in 1:nlen){
  proplabintermat04d[,j]<-numlabinterpmat04d[,j]/(nvec[j]*(numcla-1))
}

sdnonintermatd<-matrix(0,3,nlen)
sdnonintermatd[1,]<-apply(propnonintermat02d, 2, sd)
sdnonintermatd[2,]<-apply(propnonintermat03d, 2, sd)
sdnonintermatd[3,]<-apply(propnonintermat04d, 2, sd)

sdlabintermatd<-matrix(0,3,nlen)
sdlabintermatd[1,]<-apply(proplabintermat02d, 2, sd)
sdlabintermatd[2,]<-apply(proplabintermat03d, 2, sd)
sdlabintermatd[3,]<-apply(proplabintermat04d, 2, sd)




length(nvec)
lab00<-c(rep("(3) 0.2",8),rep("(3) 0.3",8),rep("(3) 0.4",8),
         rep("(6) 0.2",8),rep("(6) 0.3",8),rep("(6) 0.4",8))
labcla00<-c(rep(" 3",24),rep(" 6",24))
data_int03<-data.frame(c(numlabinterppropb[1,],numlabinterppropb[2,],numlabinterppropb[3,],
                         numlabinterppropd[1,],numlabinterppropd[2,],numlabinterppropd[3,]),
                       c(nvec,nvec,nvec,nvec,nvec,nvec),lab00,labcla00,
                       c(sdlabintermat[1,],sdlabintermat[2,],sdlabintermat[3,],
                         sdlabintermate[1,],sdlabintermate[2,],sdlabintermate[3,]))
names(data_int03)<-c("interp","n","ratio","k","sd")
title=expression(paste("(k)"~mu))
plot_int03<-ggplot(data_int03, aes(x=n, y=interp,group=ratio)) + 
  ylab("Fraction of support vectors") +
  geom_errorbar(aes(ymin=interp-sd,ymax=interp+sd),width=3)+
  geom_line(aes(color = ratio,linetype=k),size=1.5)+coord_cartesian(xlim = c(10, 100),ylim = c(0.1,1)) +geom_point(aes(color = ratio),size=3)+
  theme_minimal() +labs(color=title,linetype="k")+
  theme(axis.text = element_text(size = 12),axis.title = element_text(size = 21),legend.text = element_text(size = 17),legend.title = element_text(size = 21) )



lab00<-c(rep("(3) 0.2",8),rep("(3) 0.3",8),rep("(3) 0.4",8),
         rep("(6) 0.2",8),rep("(6) 0.3",8),rep("(6) 0.4",8))
labcla00<-c(rep(" 3",24),rep(" 6",24))
data_int04<-data.frame(c(numlabinterppropb[1,],numlabinterppropb[2,],numlabinterppropb[3,],
                         numlabinterppropd[1,],numlabinterppropd[2,],numlabinterppropd[3,]),
                       c(rescnvec*mulen02b,rescnvec*mulen03b,rescnvec*mulen04b,
                         rescnvece*mulen02d,rescnvece*mulen03d,rescnvece*mulen04d),lab00,labcla00,
                       c(sdlabintermat[1,],sdlabintermat[2,],sdlabintermat[3,],
                         sdlabintermate[1,],sdlabintermate[2,],sdlabintermate[3,]))
names(data_int04)<-c("interp","n","ratio","k","sd")
plot_int04<-ggplot(data_int04, aes(x=n, y=interp, group=ratio)) + ylab("Fraction of support vectors") + xlab(expression(paste("("~k^1.5~n^1.5~"||"~mu~"||"~")/("~"p"~")")))+
  geom_line(aes(color = ratio,linetype=k),size=1.5)+coord_cartesian(xlim = c(0.05,150),ylim = c(0.1,1))+geom_point(aes(color = ratio),size=3)+
  theme_minimal() + 
  theme(axis.text = element_text(size = 12),axis.title = element_text(size = 21),legend.text = element_text(size = 17),legend.title = element_text(size = 21) )


legend_03<-get_legend(plot_int03+
                        theme(legend.key = element_rect(color = "black", linetype = "solid", size = 0.5),
                              legend.key.size = unit(0.3, "cm"), legend.key.height=unit(1.5,"line")) +
                        guides(colour = guide_legend(override.aes = list(size= 1)))+labs(title = title))

legend_03<-get_legend(plot_int03)



p_grid<-plot_grid(
  plot_int03+theme(legend.position="none"),
  plot_int04+theme(legend.position="none"),
  nrow=1)


plotg<-plot_grid(p_grid,legend_03,rel_widths = c(3, .4))

plotg



