# Need the following packages
#install.packages("CVXR")
#install.packages("MASS")
#install.packages("huge")
#install.packages("matrixcalc")
#install.packages("ggplot2")
#install.packages("cowplot")

library(CVXR)
library(MASS)
library(huge)
library(matrixcalc)
library(ggplot2)
library(cowplot)



############## 4-0.2 means that 4 classes, mu = 0.2 ###########

############################ LS estimator #########################
################################################################################
###################  6-0.2 #################### 
n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

numsim<-100  # number of simulations
nt<-1000 


numwrongmat<-matrix(0,numsim,plen)


time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.2*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    
    ainvmat<-solve(t(xmat)%*%xmat)
    ymatresc<-(ymat-(1/numcla))
    muhat<-xmat%*%ainvmat%*%t(ymatresc)
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmat[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01




################################################################################
###################  6-0.3 #################### 
n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

numsim<-100  # number of simulations
nt<-1000

numwrongmat02<-matrix(0,numsim,plen)

time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.3*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    ainvmat<-solve(t(xmat)%*%xmat)
    ymatresc<-(ymat-(1/numcla))
    muhat<-xmat%*%ainvmat%*%t(ymatresc)
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmat02[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01






################################################################################
###################  6-0.4 #################### 
n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class


numsim<-100  # number of simulations
nt<-1000


numwrongmat03<-matrix(0,numsim,plen)

time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.4*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    ainvmat<-solve(t(xmat)%*%xmat)
    ymatresc<-(ymat-(1/numcla))
    muhat<-xmat%*%ainvmat%*%t(ymatresc)
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmat03[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01


numwrongmat03







#########################  multiclass SVM ##################
################################################################################################
################################################################################################
#############################  SVM  6-0.2  #############################

n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class


numsim<-100  # number of simulations
nt<-1000


numwrongmatsvm<-matrix(0,numsim,plen)
numnoninterpmatbn<-matrix(0,numsim,plen)
numlabinterpmatbn<-matrix(0,numsim,plen)

time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.2*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    muhat<-mumat_est
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmatbn[k,m]<-numnoninterp
    numlabinterpmatbn[k,m]<-numlabinterp
    
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmatsvm[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01



################################################################################################
#############################  SVM  6-0.3  #############################

n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class

numsim<-100  # number of simulations
nt<-1000

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numwrongmatsvm02<-matrix(0,numsim,plen)
numnoninterpmatbn02<-matrix(0,numsim,plen)
numlabinterpmatbn02<-matrix(0,numsim,plen)


time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.3*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  #onevec<-rep(1,n)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    muhat<-mumat_est
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmatbn02[k,m]<-numnoninterp
    numlabinterpmatbn02[k,m]<-numlabinterp
    
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmatsvm02[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01






################################################################################################
#############################  SVM  6-0.4  #############################
n<-30
pvec<-c(50,100,150,250,400,600,800,1000,1200)
plen<-length(pvec)
numcla<-6
labpos<-(numcla-1)/numcla
labneg<-(-1)/numcla

probvec<-rep(1/(numcla),numcla)  # To set the probabilities for each class


numsim<-100  # number of simulations
nt<-1000

# the matrix below shows the number of constraints that do not satisfy equality for each sample
# so the number of equality is n*(numcla-1) - the number below

numwrongmatsvm03<-matrix(0,numsim,plen)
numnoninterpmatbn03<-matrix(0,numsim,plen)
numlabinterpmatbn03<-matrix(0,numsim,plen)

time01<-Sys.time()
for(m in 1:plen){
  p<-pvec[m]
  set.seed(22222)
  dat00 <- huge.generator(n = 1000, d = p, graph = "random", v = NULL, u = NULL,
                          g = NULL, prob = NULL, vis = F, verbose = TRUE)
  datmat00<-dat00$sigma
  eig00<-eigen(datmat00)
  mumator<-eig00$vectors[,1:numcla]  # To create the mean vectors
  mumat<-0.4*(p^(0.5))*mumator
  
  lbdvec<-rep(1,p) # Diagonal elements
  covmat<-diag(lbdvec)
  for(k in 1:numsim){
    set.seed(9*k)
    
    # We first create Y, X and Q(noise) matrices
    ymat<-matrix(0,numcla,n) # Y matrix
    labclass<-sample(seq(1:numcla),size = n,replace = TRUE,prob = probvec) # To create the vector indicating labels
    for (i in 1:n) {
      lll<-labclass[i]
      ymat[lll,i]<-1
    }
    qmat<-t(mvrnorm(n,rep(0,p),covmat)) # the noise matrix
    xmat<-mumat%*%ymat+qmat
    xmatint<-xmat
    
    # Next we do optimization
    vmat<-Variable((p),numcla)
    obj<-Minimize(cvxr_norm(vmat,"fro")^2)
    constraint<-vector(mode = "list",length = (n*(numcla)))
    # Add constraints - need to use the list data structure
    for(i in 1:n){
      for (j in 1:(numcla)) {
        if(j!=labclass[i]){
          constraintone<-list(t(xmatint[,i])%*%(vmat[,(labclass[i])]-vmat[,j])>=1)
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
        else{
          constraintone<-list(abs(vmat[1,1]-vmat[1,1])<=0.001) # cannot put NULL as a constraint, so just add a 'trivial' constraint
          count01<-((i-1)*numcla)+j
          constraint[[count01]]<-constraintone[[1]]
        }
      }
    }
    probl <- Problem(obj, constraint)
    result <- solve(probl)
    mumat_est <- result$getValue(vmat) # get the solution
    muhat<-mumat_est
    
    # We finally compute the inner products (x^T%*%W) and count the number of inequalities
    numnoninterp<-0
    numlabinterp<-0
    for (i in 1:n) {
      inner01<-t(xmatint[,i])%*%mumat_est[,labclass[i]]
      mumat_estcut<-mumat_est[,-(labclass[i])]
      for (j in 1:(numcla-1)) {
        innerneg<-t(xmatint[,i])%*%mumat_estcut[,j]
        if(abs(inner01-(innerneg)-1)>=0.00001){
          numnoninterp<-numnoninterp+1
        }
        if((abs(inner01-labpos)<0.00001)&&(abs(innerneg-labneg)<0.00001)){
          numlabinterp<-numlabinterp+1
        }
      }
    }
    numnoninterpmatbn03[k,m]<-numnoninterp
    numlabinterpmatbn03[k,m]<-numlabinterp
    
    
    ### testing ###
    ymatt<-matrix(0,numcla,nt)
    set.seed(10*k)
    labclasst<-sample(seq(1:numcla),size = nt,replace = TRUE,prob = probvec)
    for (i in 1:nt) {
      lll<-labclasst[i]
      ymatt[lll,i]<-1
    }
    qmatt<-t(mvrnorm(nt,rep(0,p),covmat))
    xmatt<-mumat%*%ymatt+qmatt
    estymat<-t(muhat)%*%xmatt
    numwrong<-0
    for (i in 1:(nt)) {
      estyvec<-estymat[,i]
      maxestyvec<-max(estyvec)
      estlab<-which(estyvec==maxestyvec)
      if(estlab != labclasst[i]){
        numwrong<-numwrong+1
      }
    }
    numwrongmatsvm03[k,m]<-numwrong
  }
}

time02<-Sys.time()
time02-time01



#remove(probl)
#remove(constraint)
#remove(obj)
#rm(result)
#remove(dat00)
#remove(datmat00)
#remove(eig00)





##############################################################################
#########################  Figures ####################
lenpvec<-length(pvec)

errormatls<-matrix(0,3,lenpvec)
errormatls[1,]<-apply(numwrongmat,2,mean)/1000
errormatls[2,]<-apply(numwrongmat02,2,mean)/1000
errormatls[3,]<-apply(numwrongmat03,2,mean)/1000

errormatsvm<-matrix(0,3,lenpvec)
errormatsvm[1,]<-apply(numwrongmatsvm,2,mean)/1000
errormatsvm[2,]<-apply(numwrongmatsvm02,2,mean)/1000
errormatsvm[3,]<-apply(numwrongmatsvm03,2,mean)/1000

numcla<-6;n<-30
nointerpmat<-matrix(0,3,lenpvec)
nointerpmat[1,]<-apply(numlabinterpmatbn,2,mean)/((numcla-1)*n)
nointerpmat[2,]<-apply(numlabinterpmatbn02,2,mean)/((numcla-1)*n)
nointerpmat[3,]<-apply(numlabinterpmatbn03,2,mean)/((numcla-1)*n)




pvector02<-pvec
length(pvec)
lab_00<-c(rep("0.2",9),rep("0.3",9),rep("0.4",9))
data_error<-data.frame(c(errormatls[1,],errormatls[2,],errormatls[3,]),
                       c(errormatsvm[1,],errormatsvm[2,],errormatsvm[3,]),
                       c(pvector02,pvector02,pvector02),lab_00)
names(data_error)<-c("testerror","testerrorsvm","p","weight")
plot_error<-ggplot(data_error, aes(x=p, y=testerror, group=weight)) + ylab("classification error") +
  geom_line(aes(color = weight),size=1.5)+coord_cartesian(xlim = c(50, 1200),ylim = c(0,0.5))+
  geom_point(aes(color = weight),size=3)+ theme_minimal() + 
  theme(plot.title = element_text(size = 12),axis.text = element_text(size = 12),axis.title =element_text(size = 20) )+
  geom_line(aes(x=p, y=testerrorsvm, group=weight,color=weight),size=1,linetype="dashed")+
  geom_point(aes(x=p, y=testerrorsvm, color = weight),size=3)



lab_00<-c(rep("0.2",9),rep("0.3",9),rep("0.4",9))
data_intp<-data.frame(c(nointerpmat[1,],nointerpmat[2,],nointerpmat[3,]),
                      c(pvector02,pvector02,pvector02),lab_00)
names(data_intp)<-c("sv","p","weight")
title<-expression(mu)
plot_intp<-ggplot(data_intp, aes(x=p, y=sv, group=weight)) + ylab("Fraction of support vectors") + 
  geom_line(aes(color = weight),size=1.5)+geom_point(aes(color=weight),size=3)+
  coord_cartesian(xlim = c(50, 1200),ylim = c(0.1,1))+theme_minimal() +labs(color=title)+
  theme(axis.text = element_text(size = 12),axis.title = element_text(size = 20),legend.text = element_text(size = 17),legend.title = element_text(size = 20) )


legend_01<-get_legend(plot_intp)

p_grid<-plot_grid(plot_error+theme(legend.position="none"),
                  plot_intp+theme(legend.position="none"),
                  nrow=1)

plot_grid(p_grid,legend_01,rel_widths = c(3, .4))



















