#!/bin/bash

source ~/.bashrc
conda activate mace-update-v5

PREFIX=/data/cluster_name/scratch/$(whoami)/projects/MACE-Update
PREFIX_SCRATCH=/data/cluster_name/$(whoami)/projects/MACE-Update

ALGO_NAME=$2
CHANGE=$3
TASK=$4
CONFIG=$5
PORT_NUMBER=$6
PROMPTS_CSV=$7
METRIC=$8
RANDOM_SEED=$9

mkdir -p $PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/results/${PROMPTS_CSV}/
RESULTS_DIR=$PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/results/${PROMPTS_CSV}/

ROW_PREFIX="${ALGO_NAME},${CHANGE},${TASK},${CONFIG},none,none,none,${PROMPTS_CSV},${RANDOM_SEED},"

echo $METRIC
if [ "$METRIC" == "FID" ]; then
    conda deactivate

    conda activate mace-update-plot
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_fid.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/ --dir2 $PREFIX_SCRATCH/data/finetuning/mscoco/coco_5k --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    conda deactivate
elif [ "$METRIC" == "clip_score" ]; then
    
    if [ "$TASK" != "art" ]; then
        
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score.py --image_dir $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/ --prompts_path $PREFIX/tasks/${TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    else
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score_art.py --image_dir $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/0/ --prompts_path $PREFIX/tasks/${TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score_art.py --image_dir $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/1/ --prompts_path $PREFIX/tasks/${TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    fi

elif [ "$METRIC" == "clip_acc" ]; then
    
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder $PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/erased/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder $PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/others/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder $PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/synonyms/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

elif [ "$METRIC" == "GCD" ]; then

    conda deactivate

    conda activate GCD

    export APP_DATA_DIR=$PREFIX/celeb-detection-oss/examples/resources
    export APP_RECOGNITION_WEIGHTS_FILE=face_recognition/best_model_states.pkl

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/erased --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/others --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate

elif [ "$METRIC" == "lpips" ]; then

    conda deactivate

    conda activate LPIPS

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_lpips.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/0 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/0 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_lpips.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/1 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/1 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate
else
    echo "Metric not supported"
fi