#!/bin/bash

source ~/.bashrc
conda activate mace-update-v5

PREFIX=/data/cluster_name/scratch/$(whoami)/projects/MACE-Update

ALGO_NAME=$2
CHANGE=$3
TASK=$4
CONFIG=$5
PORT_NUMBER=$6
PROMPTS_CSV=$7
METRIC=$8
RANDOM_SEED=$9

mkdir -p $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/results/${PROMPTS_CSV}/
RESULTS_DIR=$PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/results/${PROMPTS_CSV}/

ROW_PREFIX="${ALGO_NAME},${CHANGE},${TASK},${CONFIG},none,none,none,${PROMPTS_CSV},${RANDOM_SEED},"

echo $METRIC
if [ "$METRIC" == "FID" ]; then

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_fid.py --dir1 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/ --dir2 '/data/cluster_name/scratch/$(whoami)/projects/MACE-Update/data/mscoco-30k'

elif [ "$METRIC" == "CLIP" ]; then
    
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score.py --image_dir /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/ --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/prompts.csv --results_file $RESULTS_FILE

elif [ "$METRIC" == "GCD" ]; then

    conda deactivate

    conda activate GCD

    export APP_DATA_DIR=$PREFIX/celeb-detection-oss/examples/resources
    export APP_RECOGNITION_WEIGHTS_FILE=face_recognition/best_model_states.pkl

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD_bulk.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/erased --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    # CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/others --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate
else
    echo "Metric not supported"
fi