#!/bin/bash

source ~/.bashrc
conda activate mace-update-v5

PREFIX=/data/cluster_name/scratch/$(whoami)/projects/MACE-Update

. /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/slurm/scripts/prelude-ft.sh

ALGO_NAME=$2
CHANGE=$3
ORIG_TASK=$4
ORIG_CONFIG=$5
FINETUNE_ALGO=$6
FINETUNE_TASK=$7
FINETUNE_CONFIG=$8
PORT_NUMBER=$9
PROMPTS_CSV=${10}
METRIC=${11}
RANDOM_SEED=${12}


mkdir -p $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/results/${PROMPTS_CSV}
RESULTS_DIR=$PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/results/${PROMPTS_CSV}/
ROW_PREFIX="${ALGO_NAME},${CHANGE},${ORIG_TASK},${ORIG_CONFIG},${FINETUNE_ALGO},${FINETUNE_TASK},${FINETUNE_CONFIG},${PROMPTS_CSV},${RANDOM_SEED},"

echo $METRIC
if [ "$METRIC" == "FID" ]; then

    conda deactivate

    conda activate mace-update-plot
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_fid.py --dir1 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/ --dir2 $PREFIX_SCRATCH/data/finetuning/mscoco/coco_5k  --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate
elif [ "$METRIC" == "clip_score" ]; then
    
    if [ "$PROMPTS_CSV" == "coco_5k" ]; then
        
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score.py --image_dir /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/ --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/tasks/${ORIG_TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    else
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score_art.py --image_dir /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/0/ --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/tasks/${ORIG_TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
        CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score_art.py --image_dir /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/1/ --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/tasks/${ORIG_TASK}/${PROMPTS_CSV}.csv --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    fi

elif [ "$METRIC" == "clip_acc" ]; then
    
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/erased/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/others/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_accuracy.py --base_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/synonyms/ --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

elif [ "$METRIC" == "GCD" ]; then

    conda deactivate

    conda activate GCD

    export APP_DATA_DIR=$PREFIX/celeb-detection-oss/examples/resources
    export APP_RECOGNITION_WEIGHTS_FILE=face_recognition/best_model_states.pkl

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/erased --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/others --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate

elif [ "$METRIC" == "lpips" ]; then

    conda deactivate

    conda activate LPIPS

    # CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_lpips.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/0 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/0 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_lpips.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/1 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/1 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate

elif [ "$METRIC" == "CSD" ]; then

    conda deactivate

    conda activate CSD

    CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_CSD.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/0 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/0 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX
    # CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_lpips.py --dir1 $PREFIX/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/1 --dir2 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/SD/baseline_art_none/0/inference/art_100_concepts/1 --results_dir $RESULTS_DIR --row_prefix $ROW_PREFIX

    conda deactivate
else
    echo "Metric not supported"
fi

# if [ "$METRIC" == "FID" ]; then

#     CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_fid.py --dir1 /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV} --dir2 '/data/cluster_name/scratch/$(whoami)/projects/MACE-Update/data/mscoco-30k'

# elif [ "$METRIC" == "CLIP" ]; then
    
#     CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_clip_score.py --image_dir /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV} --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/prompts.csv --results_file $RESULTS_FILE

# elif [ "$METRIC" == "GCD" ]; then

#     conda deactivate

#     conda activate GCD

#     export APP_DATA_DIR=$PREFIX/celeb-detection-oss/examples/resources
#     export APP_RECOGNITION_WEIGHTS_FILE=face_recognition/best_model_states.pkl

#     CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/erased --save_excel_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/results/${PROMPTS_CSV}/erased
#     # CUDA_VISIBLE_DEVICES=$1 python $PREFIX/evaluation/evaluate_by_GCD.py --image_folder /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}/inference/${PROMPTS_CSV}/others --save_excel_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}/${RANDOM_SEED}/finetune/${FINETUNE_ALGO}/${FINETUNE_TASK}_${FINETUNE_CONFIG}}/results/${PROMPTS_CSV}/others

#     conda deactivate
# else
#     echo "Metric not supported"
# fi